(***********************************************************************
CreatedBy='MathematicaCalcCenter 3.0'
                    Mathematica CalcCenter-Compatible Notebook

This notebook can be used on any computer system with Mathematica CalcCenter, \

Mathematica, MathReader, Publicon, or any compatible application. 
The data for the notebook  starts with the line containing stars above.

To get the notebook into a Mathematica CalcCenter-compatible application, do 
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica \
CalcCenter-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica CalcCenter-compatible applications may \
try 
to use invalid cache data.

For more information on notebooks and Mathematica CalcCenter-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)
  phone: +44(0)1993-883400 (Europe)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     92555,       2323]*)
(*NotebookOutlinePosition[     93919,       2369]*)
(*  CellTagsIndexPosition[     93846,       2363]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["\[CapitalSHacek]kolen\[IAcute] Mathematica CalcCenter \
20.12.2006",
  FontFamily->"Arial",
  FontSize->28,
  FontColor->RGBColor[0, 0, 0.501961]]], "Title"],

Cell["\<\
Pozn.: Rozbalen\[IAcute] p\:0159\[IAcute]slu\[SHacek]n\[EAcute] sekce je \
pomoc\[IAcute] dvojkliku vpravo na zob\[AAcute]\[CHacek]ek jednotliv\[EAcute] \
bu\:0148ky.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Kalkula\[CHacek]ka",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    \(1 + 1\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \(5 - 8*3\)], "Input",
  CellLabel->"In[27]:="],

Cell[BoxData[
    \(\((5 - 8)\)*3\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    \(7*4\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    \(2/9\)], "Input",
  CellLabel->"In[25]:="],

Cell[BoxData[
    \(\@1024\)], "Input",
  CellLabel->"In[29]:="],

Cell[BoxData[
    \(\@2\%3\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \(Sqrt[1024]\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \(2\^32\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(2^3\)], "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[{
    \(4 + 3\), "\n", 
    \(%*7\), "\n", 
    \(%*2\)}], "Input",
  CellLabel->"In[54]:="],

Cell[BoxData[
    \(2/5\)], "Input",
  CellLabel->"In[57]:="],

Cell[BoxData[
    \(\[Integral]\_\(-1\)\%1 x \[DifferentialD]x\)], "Input",
  CellLabel->"In[62]:="],

Cell[BoxData[
    \(\@\(1\/10\)\)], "Input",
  CellLabel->"In[272]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Konverze",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    \(Convert[\(130\ Kilo\ Meter\)\/Hour, Mile\/Hour]\)], "Input",
  CellLabel->"In[87]:=",
  GeneratedCell->False],

Cell[BoxData[
    \(Convert[5  Foot + 8  Inch, Centimeter]\)], "Input",
  CellLabel->"In[94]:="],

Cell[BoxData[
    \(SI[115\ Horsepower]\)], "Input",
  CellLabel->"In[96]:=",
  GeneratedCell->False],

Cell[BoxData[
    \(Convert[2  Pi\ Radian, Grade]\)], "Input",
  CellLabel->"In[97]:=",
  GeneratedCell->False],

Cell[BoxData[
    \(2*3 + 4.5\)], "Input",
  CellLabel->"In[100]:="],

Cell[BoxData[
    \(SpeedOfLight\)], "Input",
  CellLabel->"In[101]:="],

Cell[BoxData[
    \(1/\((\[Sqrt]\((VacuumPermeability*VacuumPermittivity)\))\)\)], "Input",
  CellLabel->"In[102]:="],

Cell[BoxData[
    \(211285\^2\)], "Input",
  CellLabel->"In[111]:="],

Cell[BoxData[
    \(AgeOfUniverse*SpeedOfLight\)], "Input",
  CellLabel->"In[112]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Funkce",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    RowBox[{"\[VeryThinSpace]", 
      StyleBox[
        TagBox[
          StyleBox[
            FormBox[GridBox[{
                  {
                    StyleBox[GridBox[{
                          {
                            StyleBox["Sin",
                              "ReverseSCComment",
                              TextAlignment->Left], 
                            StyleBox[
                              AdjustmentBox[\(calculate\ the\ sine\),
                                BoxMargins->{{0.5, 0.5}, {1.2, 1.2}}],
                              "SCComment",
                              Editable->False,
                              Selectable->False,
                              FontFamily->"Helvetica"]}
                          }],
                      Editable->False,
                      Selectable->False]},
                  {GridBox[{
                        {
                          RowBox[{
                            TagBox[
                              StyleBox[
                                TagBox[GridBox[{
                                      {
                                        StyleBox[
                                        TagBox[
                                        RowBox[{"The", " ", 
                                        StyleBox["number",
                                        "HelperLabelEmphasised"], " ", "or", 
                                        " ", 
                                        StyleBox["variable",
                                        "HelperLabelEmphasised"], " ", "to", 
                                        " ", "calculate", " ", "sin", " ", 
                                        "at"}],
                                        "a",
                                        Editable->False,
                                        Selectable->False],
                                        "SCHelperGridLabels"], 
                                        StyleBox[
                                        TagBox[\(\(\ \)\(\[Pi]\)\(\ \)\),
                                        {"Example", 
                                        RowBox[ {"2", " ", "\[Pi]"}]},
                                        Editable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False]}
                                      }],
                                  {
                                  Hold[ 
                                    Sin[ "a"]], "HelperBox"},
                                  Editable->False],
                                "SCHelperGrid"],
                              "Helper"], " ", "\[IndentingNewLine]", 
                            GridBox[{
                                {
                                  StyleBox[" ",
                                    "Text",
                                    FontSize->1]}
                                },
                              ColumnWidths->22,
                              RowMinHeight->{0, 1}]}], 
                          TagBox[GridBox[{
                                {
                                  ButtonBox[\(Show\ example\),
                                    ButtonStyle->"ExampleButton"]},
                                {
                                  ButtonBox[\(Convert\ to\ text\ input\),
                                    
                                    ButtonFunction:>
                                      CalculationCenter`Functions`private`\
StandardizeButtonCell[ ],
                                    ButtonEvaluator->Automatic,
                                    ButtonStyle->"ConvertCellButton",
                                    ButtonNote->"Reformat cell"]},
                                {
                                  ButtonBox["Calculate",
                                    ButtonStyle->"CalculateCellButton"]}
                                }],
                            "Ignore"]}
                        }]}
                  },
                ColumnAlignments->{Right},
                GridFrame->False,
                RowLines->False,
                ColumnLines->False],
              "TraditionalForm"],
            "HelperBackground"],
          "CommentBox",
          Editable->False],
        Placeholder->False], "\[VeryThinSpace]"}]], "Input",
  CellLabel->"In[114]:=",
  GeneratedCell->False],

Cell[BoxData[
    \(\(?Sin\)\)], "Input",
  CellLabel->"In[118]:="],

Cell[BoxData[
    \(Sin[\(3\ \[Pi]\)\/2]\)], "Input",
  CellLabel->"In[117]:="],

Cell[BoxData[
    \(\[Pi]/2\)], "Input",
  CellLabel->"In[119]:="],

Cell[BoxData[
    \(\[ExponentialE]\^\(\[ImaginaryI]*\[Pi]\)\)], "Input",
  CellLabel->"In[120]:="],

Cell[BoxData[
    \(\[Degree]\)], "Input",
  CellLabel->"In[128]:="],

Cell[BoxData[
    \(180  \[Degree]\)], "Input",
  CellLabel->"In[126]:="],

Cell[BoxData[
    \(\[Pi]/\[Degree]\)], "Input",
  CellLabel->"In[127]:="],

Cell[BoxData[{
    \(Sin[45  \[Degree]]\), "\n", 
    \(ArcSin[%]\), "\n", 
    \(%/\[Degree]\)}], "Input",
  CellLabel->"In[147]:="],

Cell[BoxData[
    \(TraditionalForm\`Log[10, 1000]\)], "Input",
  GeneratedCell->False],

Cell[BoxData[
    \(TraditionalForm\`Log[\(-1\)]\)], "Input",
  CellLabel->"In[350]:=",
  GeneratedCell->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Komplexn\[IAcute] \[CHacek]\[IAcute]sla",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    \(\(\(\[ImaginaryI]\^2\)\(\[IndentingNewLine]\)
    \)\)], "Input",
  CellLabel->"In[184]:="],

Cell[BoxData[{
    \(\((1 + \[ImaginaryI])\)*\((5 - \[ImaginaryI])\)\), "\n", 
    \(\((1 + \[ImaginaryI])\)/\((5 - \[ImaginaryI])\)\)}], "Input",
  CellLabel->"In[188]:="],

Cell[BoxData[
    \(z = \(1\/2\) \((1 - \@3*\[ImaginaryI])\)\)], "Input",
  CellLabel->"In[230]:="],

Cell[BoxData[{
    \(Re[z]\), "\n", 
    \(Im[z]\), "\n", 
    \(Abs[z]\), "\n", 
    \(Arg[z]\), "\n", 
    \(%/\[Degree]\)}], "Input",
  CellLabel->"In[231]:="],

Cell[BoxData[
    \(1.047197/\[Degree]\)], "Input",
  CellLabel->"In[229]:="],

Cell[BoxData[
    \(ArcTan[Im[z]\/Re[z]]\)], "Input",
  CellLabel->"In[212]:="],

Cell[BoxData[
    \(Conjugate[z]\)], "Input",
  CellLabel->"In[219]:="]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Random",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    \(Random[]\)], "Input",
  CellLabel->"In[244]:="],

Cell[BoxData[
    \(Random[Real, {5, 10}]\)], "Input",
  CellLabel->"In[246]:="],

Cell[BoxData[
    \(a = Random[Integer, {5, 10}]\)], "Input",
  CellLabel->"In[255]:="],

Cell[BoxData[
    \(a\)], "Input",
  CellLabel->"In[262]:="],

Cell[BoxData[
    \(nah := Random[Integer, {5, 10}]\)], "Input",
  CellLabel->"In[275]:="],

Cell[BoxData[
    \(nah\)], "Input",
  CellLabel->"In[281]:="],

Cell[BoxData[
    \(znah := nah + \[ImaginaryI]*nah\)], "Input",
  CellLabel->"In[288]:="],

Cell[CellGroupData[{

Cell[BoxData[{
    \(znah\), "\n", 
    \(znah\), "\n", 
    \(Conjugate[%%]*%\)}], "Input",
  CellLabel->"In[342]:="],

Cell[BoxData[
    \(TraditionalForm\`5 + 7\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[342]="],

Cell[BoxData[
    \(TraditionalForm\`7 + 8\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[343]="],

Cell[BoxData[
    \(TraditionalForm\`91 - 9\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[344]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[{"\<zadan\[IAcute] \[CHacek].\>", i, "\<z1=\>", 
        z1 = znah, "\<z2=\>", z2 = znah, \*"\"\<\!\(\(z1\^*\)\)*z2=\>\"", 
        res = Conjugate[z1*z2], "\<\[Phi]=\>", Arg[res]/\[Degree]}, {i, 
        20}]\)], "Input",
  CellLabel->"In[348]:="],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "1", "\<\"z1=\"\>", \(6 + 
                10\ \[ImaginaryI]\), "\<\"z2=\"\>", \(6 + 
                7\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-34\) - 
                102\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \
\(-108.43494882292201`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "2", "\<\"z1=\"\>", \(5 + 
                9\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                6\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-9\) - 111\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-94.63546342690265`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "3", "\<\"z1=\"\>", \(7 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                7\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-7\) - 79\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-95.06361685303008`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "4", "\<\"z1=\"\>", \(7 + 
                10\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                9\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-27\) - 
                153\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \
\(-100.00797980144134`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "5", "\<\"z1=\"\>", \(9 + 
                9\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                9\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-36\) - 
                126\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \
\(-105.94539590092285`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "6", "\<\"z1=\"\>", \(5 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                7\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(10 \
- 80\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-82.8749836510982`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "7", "\<\"z1=\"\>", \(7 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(10 + 
                10\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(20 - 120\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-80.53767779197439`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "8", "\<\"z1=\"\>", \(7 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                5\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(5 \
- 65\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-85.60129464500447`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "9", "\<\"z1=\"\>", \(6 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                6\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(18 \
- 90\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-78.69006752597979`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "10", "\<\"z1=\"\>", \(8 + 
                8\ \[ImaginaryI]\), "\<\"z2=\"\>", \(6 + 
                5\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(8 \
- 88\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-84.8055710922652`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "11", "\<\"z1=\"\>", \(6 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                10\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-30\) - 
                90\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \
\(-108.43494882292201`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "12", "\<\"z1=\"\>", \(9 + 
                10\ \[ImaginaryI]\), "\<\"z2=\"\>", \(8 + 
                5\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(22 \
- 125\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-80.01817071226684`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "13", "\<\"z1=\"\>", \(9 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                6\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(9 \
- 84\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-83.8844964337146`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "14", "\<\"z1=\"\>", \(5 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(7 + 
                7\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-7\) - 77\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-95.1944289077348`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "15", "\<\"z1=\"\>", \(5 + 
                9\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                10\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(\(-45\) - 
                131\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \
\(-108.95818340510618`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "16", "\<\"z1=\"\>", \(7 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(10 + 
                10\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \
\(20 - 120\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-80.53767779197439`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "17", "\<\"z1=\"\>", \(9 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(6 + 
                9\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(9 \
- 111\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-85.36453657309735`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "18", "\<\"z1=\"\>", \(7 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(5 + 
                6\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(5 \
- 67\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-85.73210669970919`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "19", "\<\"z1=\"\>", \(10 + 
                6\ \[ImaginaryI]\), "\<\"z2=\"\>", \(9 + 
                6\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(54 \
- 114\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-64.6538240580533`\)},
            {"\<\"zadan\[IAcute] \[CHacek].\"\>", 
              "20", "\<\"z1=\"\>", \(10 + 
                5\ \[ImaginaryI]\), "\<\"z2=\"\>", \(6 + 
                7\ \[ImaginaryI]\), "\<\"\\!\\(\\(z1\\^*\\)\\)*z2=\"\>", \(25 \
- 100\ \[ImaginaryI]\), "\<\"\[Phi]=\"\>", \(-75.96375653207353`\)}
            }], ")"}], TraditionalForm]], "Output",
  CellLabel->"Out[348]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Grafy",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell["\<\
Ozna\[CHacek]it a stisknout kombinace SmartPlot: CTRL+SHIFT+s\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`Cos[\[Degree]\ x]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(TraditionalForm\`Cos[x]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`Plot[
      Cos[x], {x, 0, 2\ \[Pi]}, {\(-2\), 
        5}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[359]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    \(TraditionalForm\`Sin[2*x]\)], "Input"],

Cell[BoxData[
    RowBox[{"\[VeryThinSpace]", 
      StyleBox[
        TagBox[GridBox[{
              {GridBox[{
                    {
                      StyleBox[
                        TagBox[\(\(\ \)\(Plot\)\(\ \)\),
                          "PlotTypeTag"],
                        "ReverseSCComment",
                        Editable->False,
                        Selectable->False], 
                      StyleBox[
                        
                        AdjustmentBox[\(\(\(\ \)\(Visualize\)\(\ \)\) \(Sin[
                              2\ x]\)\(\ \)\),
                          BoxMargins->{{0.5, 0.5}, {1.2, 1.2}}],
                        "SCComment",
                        Editable->False,
                        Selectable->False,
                        FontFamily->"Helvetica"]}
                    }]},
              {GridBox[{
                    {
                      StyleBox[GridBox[{
                            {
                              StyleBox[\(x \(\(\ \)\(variable\)\)\),
                                FontFamily->"Times",
                                FontWeight->"Plain",
                                FontSlant->"Plain"], 
                              TagBox[GridBox[{
                                    {
                                      StyleBox[\(\(From\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox[\(-\[Pi]\),
                                        "From: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]},
                                    {
                                      StyleBox[\(\(To\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox["\[Pi]",
                                        "To: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]}
                                    },
                                  ColumnAlignments->{Right, Left}],
                                CalculationCenter`QuickPlot`Private`QPVarInfo[
                                 "x", "var", "-\[Pi]", "\[Pi]", "-\[Pi]", {
                                  "-\[Pi]", "\[Pi]"}]], ""}
                            },
                          ColumnAlignments->{Right, Left},
                          GridFrame->True,
                          RowLines->True,
                          ColumnLines->False],
                        Background->GrayLevel[0.996109]], GridBox[{
                          {
                            ButtonBox[\(Guess\ values\),
                              
                              ButtonFunction:>(
                                CalculationCenter`QuickPlot`Private`\
QPGuessValues[ #2]&),
                              ButtonStyle->"ExampleButton"]},
                          {
                            ButtonBox[\(Convert\ to\ input\),
                              
                              ButtonFunction:>
                                CalculationCenter`Functions`private`\
StandardizeButtonCell[ ],
                              ButtonEvaluator->Automatic,
                              ButtonStyle->"ConvertCellButton",
                              ButtonNote->"Reformat cell"]},
                          {
                            ButtonBox["Calculate",
                              ButtonStyle->"CalculateCellButton"]}
                          },
                        RowSpacings->0.5,
                        ColumnSpacings->0.5]}
                    }]},
              {
                RowBox[{
                  StyleBox[\(\(PlotType\)\(:\)\(\ \)\),
                    "ReverseHelperBackground"], 
                  StyleBox[
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["Plot", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["Plot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "Plot"], #, #2]&),
                                        ButtonData:>"Plot",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->"Plot"]},
                                        {
                                        ButtonBox["LogPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "LogPlot"], #, #2]&),
                                        ButtonData:>"LogPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"LogPlot"]},
                                        {
                                        ButtonBox["LogLogPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "LogLogPlot"], #, #2]&),
                                        ButtonData:>"LogLogPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"LogLogPlot"]},
                                        {
                                        ButtonBox["LogLinearPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "LogLinearPlot"], #, #2]&),
                                        ButtonData:>"LogLinearPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"LogLinearPlot"]},
                                        {
                                        ButtonBox["PolarPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "PolarPlot"], #, #2]&),
                                        ButtonData:>"PolarPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"PolarPlot"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"Plot", "LogPlot", "LogLogPlot", 
                          "LogLinearPlot", "PolarPlot"}, {False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "Plot"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "LogPlot"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "LogLogPlot"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "LogLinearPlot"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "PolarPlot"]}, ""},
                          Editable->False],
                        {"PlotType", None},
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False],
                    "Text"]}]},
              {
                StyleBox[
                  RowBox[{
                    StyleBox[\(\(PlotStyle\)\(:\)\(\ \)\),
                      "ReverseHelperBackground"], 
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["Default", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["Default",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Default",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->"Default"]},
                                        {
                                        ButtonBox["Technical",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Technical",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Technical"]},
                                        {
                                        ButtonBox["Minimal",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Minimal",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Minimal"]},
                                        {
                                        ButtonBox["Business",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Business",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Business"]},
                                        {
                                        ButtonBox["Colorful",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Colorful",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Colorful"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"Default", "Technical", "Minimal", 
                          "Business", "Colorful"}, {False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{Null}, ""},
                          Editable->False],
                        "PlotStyle",
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False]}],
                  "Text"]},
              {
                StyleBox[
                  RowBox[{
                    StyleBox[\(\(Secondary\ PlotStyle\)\(:\)\(\ \)\),
                      "ReverseHelperBackground"], 
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["None", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["None",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"None",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->None]},
                                        {
                                        ButtonBox["Frame",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Frame",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Frame"]},
                                        {
                                        ButtonBox["NoFrame",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoFrame",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoFrame"]},
                                        {
                                        ButtonBox["Grid",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Grid",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Grid"]},
                                        {
                                        ButtonBox["NoGrid",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoGrid",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoGrid"]},
                                        {
                                        ButtonBox["SmallPoints",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"SmallPoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"SmallPoints"]},
                                        {
                                        ButtonBox["LargePoints",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"LargePoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"LargePoints"]},
                                        {
                                        ButtonBox["NoPoints",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoPoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoPoints"]},
                                        {
                                        ButtonBox["ViewLeft",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewLeft",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewLeft"]},
                                        {
                                        ButtonBox["ViewRight",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewRight",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewRight"]},
                                        {
                                        ButtonBox["ViewCenter",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewCenter",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewCenter"]},
                                        {
                                        ButtonBox["Tall",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Tall",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Tall"]},
                                        {
                                        ButtonBox["Wide",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Wide",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Wide"]},
                                        {
                                        ButtonBox["Detailed",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Detailed",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Detailed"]},
                                        {
                                        ButtonBox["VeryDetailed",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"VeryDetailed",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"VeryDetailed"]},
                                        {
                                        ButtonBox["RealTime",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"RealTime",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"RealTime"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"None", "Frame", "NoFrame", "Grid", 
                          "NoGrid", "SmallPoints", "LargePoints", "NoPoints", 
                          "ViewLeft", "ViewRight", "ViewCenter", "Tall", 
                          "Wide", "Detailed", "VeryDetailed", "RealTime"}, {
                          False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{Null}, ""},
                          Editable->False],
                        "SecondaryPlotStyle",
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False]}],
                  "Text"]}
              },
            ColumnAlignments->{Right},
            GridFrame->False,
            RowLines->False,
            ColumnLines->False],
          {"QuickPlotBox", 
          HoldComplete[ 
            Sin[ 
              Times[ 2.0, x]]]},
          Editable->False],
        "HelperBackground"], "\[VeryThinSpace]"}]], "Input",
  CellLabel->"In[273]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    \(TraditionalForm\`Log[x]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`p1 = 
      PolarPlot[Log[x], {x, 1, 6}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[364]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    \(TraditionalForm\`p2 = 
      PolarPlot[Cos[x], {x, 1, 6}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[366]:="],

Cell[BoxData[
    \(TraditionalForm\`Show[p1, p2]\)], "Input",
  CellLabel->"In[367]:="],

Cell[BoxData[
    \(TraditionalForm\`x^2\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`p1 = 
      Plot[x\^2, {x, \(-5\), 5}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[370]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    \(TraditionalForm\`p2 = 
      Plot[x\^3, {x, \(-5\), 5}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[373]:="],

Cell[BoxData[
    \(TraditionalForm\`pp = Show[p1, p2]\)], "Input",
  CellLabel->"In[389]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Export["\<c:/pokus.eps\>", pp]\)], "Input",
  CellLabel->"In[390]:="],

Cell[BoxData[
    \(TraditionalForm\`"c:/pokus.eps"\)], "Output",
  CellLabel->"Out[390]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["V\[YAcute]razy",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`$ShowFractions = True\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(TraditionalForm\`True\)], "Output",
  CellLabel->"Out[9]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`$ShowFractions = False\)], "Input",
  CellLabel->"In[406]:="],

Cell[BoxData[
    \(TraditionalForm\`False\)], "Output",
  CellLabel->"Out[406]="]
}, Closed]],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Integral]", 
        RowBox[{\(x\^4\), 
          RowBox[{"\[DifferentialD]", 
            StyleBox["x",
              Placeholder->True]}]}]}], TraditionalForm]], "Input",
  CellLabel->"In[402]:="],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(1\/x\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[392]:=",
  GeneratedCell->False],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Integral]", 
        RowBox[{\(Sin[2  x]\), "*", \(Cos[x]\), 
          RowBox[{"\[DifferentialD]", 
            StyleBox["x",
              Placeholder->True]}]}]}], TraditionalForm]], "Input",
  CellLabel->"In[403]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(Sin[
              x\^m]\/x\^k\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[407]:="],

Cell[BoxData[
    \(TraditionalForm\`\(-\(\(1\/m\) \((\((0.5`\ \[ImaginaryI])\)\ x\^\(1 - k\
\)\ \((\(-\((\(-\[ImaginaryI]\)\ x\^m)\)\^\(\(\(-1\) + k\)\/m\)\)\ Gamma[\(1 \
- k\)\/m, \(-\[ImaginaryI]\)\ x\^m] + \((\[ImaginaryI]\ x\^m)\)\^\(\(\(-1\) + \
k\)\/m\)\ Gamma[\(1 - k\)\/m, \[ImaginaryI]\ x\^m])\))\)\)\)\)], "Output",
  CellLabel->"Out[407]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`Clear[a, b]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\((a + b)\)\^3\)], "Input",
  CellLabel->"In[422]:="],

Cell[BoxData[
    \(TraditionalForm\`\((a + b)\)\^3\)], "Output",
  CellLabel->"Out[422]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`ExpandAll[%]\), "\[IndentingNewLine]", 
    \(TraditionalForm\`Simplify[%]\), "\[IndentingNewLine]", 
    \(TraditionalForm\`%/\((a + b)\)\)}], "Input",
  CellLabel->"In[437]:="],

Cell[BoxData[
    \(TraditionalForm\`a\^2 + 2\ a\ b + b\^2\)], "Output",
  CellLabel->"Out[437]="],

Cell[BoxData[
    \(TraditionalForm\`\((a + b)\)\^2\)], "Output",
  CellLabel->"Out[438]="],

Cell[BoxData[
    \(TraditionalForm\`a + b\)], "Output",
  CellLabel->"Out[439]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`\((a\^3 + 3\ a\^2\ b + 3\ a\ b\^2 + b\^3)\)/\((a + 
          b)\)\), "\[IndentingNewLine]", 
    \(TraditionalForm\`Simplify[%]\)}], "Input",
  CellLabel->"In[435]:="],

Cell[BoxData[
    \(TraditionalForm\`\(a\^3 + 3\ a\^2\ b + 3\ a\ b\^2 + b\^3\)\/\(a + \
b\)\)], "Output",
  CellLabel->"Out[435]="],

Cell[BoxData[
    \(TraditionalForm\`\((a + b)\)\^2\)], "Output",
  CellLabel->"Out[436]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`\((a\^3 + \ a\^2\ b + \ a\ b\^2 + b\^3)\)*\((a - 
          b)\)\), "\[IndentingNewLine]", 
    \(TraditionalForm\`Simplify[%]\)}], "Input",
  CellLabel->"In[433]:="],

Cell[BoxData[
    \(TraditionalForm\`\((a - b)\)\ \((a\^3 + a\^2\ b + a\ b\^2 + 
          b\^3)\)\)], "Output",
  CellLabel->"Out[433]="],

Cell[BoxData[
    \(TraditionalForm\`a\^4 - b\^4\)], "Output",
  CellLabel->"Out[434]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`ExpandAll[\((a + b)\)\^3\/\((c + d)\)\^2]\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \(TraditionalForm\`a\^3\/\(c\^2 + 2\ c\ d + d\^2\) + \(3\ a\^2\ \
b\)\/\(c\^2 + 2\ c\ d + d\^2\) + \(3\ a\ b\^2\)\/\(c\^2 + 2\ c\ d + d\^2\) + 
      b\^3\/\(c\^2 + 2\ c\ d + d\^2\)\)], "Output",
  CellLabel->"Out[1]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Simplify[%]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(TraditionalForm\`\((a + b)\)\^3\/\((c + d)\)\^2\)], "Output",
  CellLabel->"Out[2]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Together[%%]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    \(TraditionalForm\`\(a\^3 + 3\ a\^2\ b + 3\ a\ b\^2 + b\^3\)\/\(c\^2 + 2\ \
c\ d + d\^2\)\)], "Output",
  CellLabel->"Out[3]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`ExpandAll[\((5/36 + x)\) \((3/6 + x)\)]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(TraditionalForm\`5\/72 + 23\/36\ x + x\^2\)], "Output",
  CellLabel->"Out[10]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Factor[%]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \(TraditionalForm\`\((5\/36 + x)\)\ \((1\/2 + x)\)\)], "Output",
  CellLabel->"Out[11]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Apart[1\/\(x\^2 - x\)]\)], "Input",
  CellLabel->"In[12]:=",
  GeneratedCell->False],

Cell[BoxData[
    \(TraditionalForm\`1\/\(\(-1\) + x\) - 1\/x\)], "Output",
  CellLabel->"Out[12]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Definice funkce",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[BoxData[
    \(TraditionalForm\`f[x_] := x\^2 + 1\)], "Input",
  CellLabel->"In[19]:=",
  GeneratedCell->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`f[3]\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    \(TraditionalForm\`10\)], "Output",
  CellLabel->"Out[20]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`Plot[f[x], {x, \(-2\), 2\ }, {0, 4}]\)], "Input",
  CellLabel->"In[22]:="],

Cell[BoxData[
    \(TraditionalForm\`spotreba[km_, litru_] := 100*litru\/km\)], "Input",
  CellLabel->"In[23]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`spotreba[710, 51]\)], "Input",
  CellLabel->"In[26]:="],

Cell[BoxData[
    \(TraditionalForm\`7.183098591549296`\)], "Output",
  CellLabel->"Out[26]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`obsahkruhu[polomer_] := \[Pi]*polomer\^2\)], "Input",
  CellLabel->"In[27]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`obsahkruhu[3]\)], "Input",
  CellLabel->"In[28]:="],

Cell[BoxData[
    \(TraditionalForm\`28.274333882308138`\)], "Output",
  CellLabel->"Out[28]="]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Listy a ostatn\[IAcute]",
  FontFamily->"Arial",
  FontColor->RGBColor[0, 0.501961, 0.501961]]], "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`data = {2, \[Pi], auto, 
        Petr, {hruska, jablko}}\)], "Input",
  CellLabel->"In[46]:="],

Cell[BoxData[
    \(TraditionalForm\`{2, \[Pi], auto, Petr, {hruska, jablko}}\)], "Output",
  CellLabel->"Out[46]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`data[\([5]\)]\), "\[IndentingNewLine]", 
    \(TraditionalForm\`%[\([2]\)]\)}], "Input",
  CellLabel->"In[42]:="],

Cell[BoxData[
    \(TraditionalForm\`{hruska, jablko}\)], "Output",
  CellLabel->"Out[42]="],

Cell[BoxData[
    \(TraditionalForm\`jablko\)], "Output",
  CellLabel->"Out[43]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`data[\([5, 2]\)]\)], "Input",
  CellLabel->"In[44]:="],

Cell[BoxData[
    \(TraditionalForm\`jablko\)], "Output",
  CellLabel->"Out[44]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Length[data]\)], "Input",
  CellLabel->"In[47]:="],

Cell[BoxData[
    \(TraditionalForm\`5\)], "Output",
  CellLabel->"Out[47]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Length[data[\([5]\)]]\)], "Input",
  CellLabel->"In[48]:="],

Cell[BoxData[
    \(TraditionalForm\`2\)], "Output",
  CellLabel->"Out[48]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[prestavka\^it, {it, 4}]\)], "Input",
  CellLabel->"In[56]:="],

Cell[BoxData[
    \(TraditionalForm\`{prestavka, prestavka\^2, prestavka\^3, 
      prestavka\^4}\)], "Output",
  CellLabel->"Out[56]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`nah := Random[Integer, {\(-10\), 10}]\)], "Input",
  CellLabel->"In[80]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`nah\)], "Input",
  CellLabel->"In[92]:="],

Cell[BoxData[
    \(TraditionalForm\`10\)], "Output",
  CellLabel->"Out[92]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`ExpandAll[\((x - nah)\)*\((x - nah)\)]\)], "Input",
  CellLabel->"In[95]:="],

Cell[BoxData[
    \(TraditionalForm\`9 + 10\ x + x\^2\)], "Output",
  CellLabel->"Out[95]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(TraditionalForm\`pocetzadani = 3\), "\[IndentingNewLine]", 
    \(TraditionalForm\`listkorenu = 
      Table[{it, nah, nah}, {it, pocetzadani}]\)}], "Input",
  CellLabel->"In[124]:="],

Cell[BoxData[
    \(TraditionalForm\`3\)], "Output",
  CellLabel->"Out[124]="],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"1", "6", \(-8\)},
            {"2", \(-8\), "1"},
            {"3", \(-8\), \(-7\)}
            }], ")"}], TraditionalForm]], "Output",
  CellLabel->"Out[125]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`zadani = 
      Table[\[IndentingNewLine]{it, 
          ExpandAll[\[IndentingNewLine]\((x - 
                  listkorenu[\([it, 2]\)])\)*\((x - 
                  listkorenu[\([it, 3]\)])\)]}, {it, 
          Length[listkorenu]}]\)], "Input",
  CellLabel->"In[126]:="],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"1", \(\(-48\) + 2\ x + x\^2\)},
            {"2", \(\(-8\) + 7\ x + x\^2\)},
            {"3", \(56 + 15\ x + x\^2\)}
            }], ")"}], TraditionalForm]], "Output",
  CellLabel->"Out[126]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`Table[
      Plot[zadani[\([it, 2]\)], {x, \(-10\), 10}], {it, 
        pocetzadani}]\)], "Input",
  CellLabel->"In[128]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[prvek, {3}]\)], "Input",
  CellLabel->"In[130]:="],

Cell[BoxData[
    \(TraditionalForm\`{prvek, prvek, prvek}\)], "Output",
  CellLabel->"Out[130]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[x\^it, {it, 4}]\)], "Input",
  CellLabel->"In[135]:="],

Cell[BoxData[
    \(TraditionalForm\`{x, x\^2, x\^3, x\^4}\)], "Output",
  CellLabel->"Out[135]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[x\^it, {it, 0, 6, 2}]\)], "Input",
  CellLabel->"In[136]:="],

Cell[BoxData[
    \(TraditionalForm\`{1, x\^2, x\^4, x\^6}\)], "Output",
  CellLabel->"Out[136]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`Plot[{1, x\^2, x\^4, x\^6}, {x, \(-5\), 
        5}, "\<Default\>", "\<None\>"]\)], "Input",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Table[Random[], {5}]\)], "Input",
  CellLabel->"In[137]:="],

Cell[BoxData[
    \(TraditionalForm\`{0.36397307286940345`, 0.5374828219094779`, 
      0.509380812860048`, 0.39978943619996066`, 
      0.5203450231612028`}\)], "Output",
  CellLabel->"Out[137]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`Sin[%]\)], "Input",
  CellLabel->"In[138]:="],

Cell[BoxData[
    \(TraditionalForm\`{0.35598982939618445`, 0.5119753596026516`, 
      0.487636761160043`, 0.3892243915742757`, 
      0.4971795259799716`}\)], "Output",
  CellLabel->"Out[138]="]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`siny = Table[Sin[ite*x], {ite, 6}]\)], "Input",
  CellLabel->"In[140]:="],

Cell[BoxData[
    \(TraditionalForm\`{Sin[x], Sin[2\ x], Sin[3\ x], Sin[4\ x], Sin[5\ x], 
      Sin[6\ x]}\)], "Output",
  CellLabel->"Out[140]="]
}, Closed]],

Cell[BoxData[
    \(TraditionalForm\`Plot[siny, {x, 0, \[Pi]/2}]\)], "Input",
  CellLabel->"In[143]:="],

Cell[BoxData[
    \(TraditionalForm\`BPlot[barva_, fce_, rozsah_, opts___] := 
      Plot[Table[fce, {barva}], rozsah, opts]\)], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox[\(Plot[Log[it*x], {x, 1, 3}, {0, 3}]\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontColor->RGBColor[1, 0, 0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[",",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontColor->RGBColor[1, 0, 0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox["\[IndentingNewLine]",
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontColor->RGBColor[1, 0, 0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            StyleBox[\({it, 1, 4, 0.2}\),
              FontFamily->"Courier New"]}], 
          StyleBox["]",
            FontFamily->"Courier New"]}], 
        StyleBox[";",
          FontFamily->"Courier New"]}], TraditionalForm]], "Input",
  CellLabel->"In[162]:="],

Cell[BoxData[
    \(TraditionalForm\`{Sin[x], Cos[x], x}\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`{1 - t, 4 + t, t}\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`Sin[x*y]\)], "Input"],

Cell[BoxData[
    RowBox[{"\[VeryThinSpace]", 
      StyleBox[
        TagBox[GridBox[{
              {GridBox[{
                    {
                      StyleBox[
                        TagBox[\(\(\ \)\(Plot3D\)\(\ \)\),
                          "PlotTypeTag"],
                        "ReverseSCComment",
                        Editable->False,
                        Selectable->False], 
                      StyleBox[
                        
                        AdjustmentBox[\(\(\(\ \)\(Visualize\)\(\ \)\) \(Sin[
                              x\ y]\)\(\ \)\),
                          BoxMargins->{{0.5, 0.5}, {1.2, 1.2}}],
                        "SCComment",
                        Editable->False,
                        Selectable->False,
                        FontFamily->"Helvetica"]}
                    }]},
              {GridBox[{
                    {
                      StyleBox[GridBox[{
                            {
                              StyleBox[\(x \(\(\ \)\(variable\)\)\),
                                FontFamily->"Times",
                                FontWeight->"Plain",
                                FontSlant->"Plain"], 
                              TagBox[GridBox[{
                                    {
                                      StyleBox[\(\(From\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox[\(-2\),
                                        "From: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]},
                                    {
                                      StyleBox[\(\(To\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox["2",
                                        "To: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]}
                                    },
                                  ColumnAlignments->{Right, Left}],
                                CalculationCenter`QuickPlot`Private`QPVarInfo[
                                 "x", "var", 
                                  RowBox[ {"-", "2"}], "2", 
                                  RowBox[ {"-", "2"}], {
                                  RowBox[ {"-", "2"}], "2"}]], 
                              StyleBox[
                                ButtonBox[
                                  StyleBox[\(Make\ x\ fixed\),
                                    "Text",
                                    FontFamily->"Arial",
                                    FontWeight->"Plain"],
                                  
                                  ButtonFunction:>(
                                    CalculationCenter`QuickPlot`Private`\
switchVarConst[ #2]&),
                                  ButtonEvaluator->Automatic,
                                  
                                  ButtonData:>
                                    CalculationCenter`QuickPlot`Private`\
QPVarInfo[ "x", "var", 
                                      RowBox[ {"-", "2"}], "2", 
                                      RowBox[ {"-", "2"}], {
                                      RowBox[ {"-", "2"}], "2"}],
                                  Active->True,
                                  ButtonStyle->"MakeFixedButton"],
                                Selectable->True]},
                            {
                              StyleBox[\(y \(\(\ \)\(variable\)\)\),
                                FontFamily->"Times",
                                FontWeight->"Plain",
                                FontSlant->"Plain"], 
                              TagBox[GridBox[{
                                    {
                                      StyleBox[\(\(From\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox[\(-2\),
                                        "From: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]},
                                    {
                                      StyleBox[\(\(To\)\(:\)\(\ \)\),
                                        Editable->False,
                                        Selectable->False,
                                        FontFamily->"Times",
                                        FontWeight->"Plain",
                                        FontSlant->"Italic"], 
                                      TagBox[
                                        StyleBox[
                                        TagBox["2",
                                        "To: ",
                                        Editable->True,
                                        Selectable->True],
                                        "Input",
                                        Editable->False,
                                        Deletable->False,
                                        PrintPrecision->6],
                                        "IgnoreTagBox",
                                        Editable->False,
                                        Selectable->False]}
                                    },
                                  ColumnAlignments->{Right, Left}],
                                CalculationCenter`QuickPlot`Private`QPVarInfo[
                                 "y", "var", 
                                  RowBox[ {"-", "2"}], "2", 
                                  RowBox[ {"-", "2"}], {
                                  RowBox[ {"-", "2"}], "2"}]], 
                              StyleBox[
                                ButtonBox[
                                  StyleBox[\(Make\ y\ fixed\),
                                    "Text",
                                    FontFamily->"Arial",
                                    FontWeight->"Plain"],
                                  
                                  ButtonFunction:>(
                                    CalculationCenter`QuickPlot`Private`\
switchVarConst[ #2]&),
                                  ButtonEvaluator->Automatic,
                                  
                                  ButtonData:>
                                    CalculationCenter`QuickPlot`Private`\
QPVarInfo[ "y", "var", 
                                      RowBox[ {"-", "2"}], "2", 
                                      RowBox[ {"-", "2"}], {
                                      RowBox[ {"-", "2"}], "2"}],
                                  Active->True,
                                  ButtonStyle->"MakeFixedButton"],
                                Selectable->True]}
                            },
                          ColumnAlignments->{Right, Left},
                          GridFrame->True,
                          RowLines->True,
                          ColumnLines->False],
                        Background->GrayLevel[0.996109]], GridBox[{
                          {
                            ButtonBox[\(Guess\ values\),
                              
                              ButtonFunction:>(
                                CalculationCenter`QuickPlot`Private`\
QPGuessValues[ #2]&),
                              ButtonStyle->"ExampleButton"]},
                          {
                            ButtonBox[\(Convert\ to\ input\),
                              
                              ButtonFunction:>
                                CalculationCenter`Functions`private`\
StandardizeButtonCell[ ],
                              ButtonEvaluator->Automatic,
                              ButtonStyle->"ConvertCellButton",
                              ButtonNote->"Reformat cell"]},
                          {
                            ButtonBox["Calculate",
                              ButtonStyle->"CalculateCellButton"]}
                          },
                        RowSpacings->0.5,
                        ColumnSpacings->0.5]}
                    }]},
              {
                RowBox[{
                  StyleBox[\(\(PlotType\)\(:\)\(\ \)\),
                    "ReverseHelperBackground"], 
                  StyleBox[
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["Plot3D", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["Plot3D",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "Plot3D"], #, #2]&),
                                        ButtonData:>"Plot3D",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->"Plot3D"]},
                                        {
                                        ButtonBox["ContourPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "ContourPlot"], #, #2]&),
                                        ButtonData:>"ContourPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ContourPlot"]},
                                        {
                                        ButtonBox["DensityPlot",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ 
                                        
                                        CalculationCenter`QuickPlot`Private`\
ChangeHeading[ "DensityPlot"], #, #2]&),
                                        ButtonData:>"DensityPlot",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"DensityPlot"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"Plot3D", "ContourPlot", 
                          "DensityPlot"}, {False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "Plot3D"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "ContourPlot"], 
                          CalculationCenter`QuickPlot`Private`ChangeHeading[ 
                          "DensityPlot"]}, ""},
                          Editable->False],
                        {"PlotType", None},
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False],
                    "Text"]}]},
              {
                StyleBox[
                  RowBox[{
                    StyleBox[\(\(PlotStyle\)\(:\)\(\ \)\),
                      "ReverseHelperBackground"], 
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["Technical", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["Default",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Default",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Default"]},
                                        {
                                        ButtonBox["Technical",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Technical",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->"Technical"]},
                                        {
                                        ButtonBox["Minimal",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Minimal",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Minimal"]},
                                        {
                                        ButtonBox["Business",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Business",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Business"]},
                                        {
                                        ButtonBox["Colorful",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Colorful",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Colorful"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"Default", "Technical", "Minimal", 
                          "Business", "Colorful"}, {False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{Null}, ""},
                          Editable->False],
                        "PlotStyle",
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False]}],
                  "Text"]},
              {
                StyleBox[
                  RowBox[{
                    StyleBox[\(\(Secondary\ PlotStyle\)\(:\)\(\ \)\),
                      "ReverseHelperBackground"], 
                    FrameBox[
                      TagBox[
                        TagBox[GridBox[{
                              {
                                Experimental`PopupBox["None", 
                                  StyleBox[GridBox[{
                                        {
                                        ButtonBox["None",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"None",
                                        ButtonFrame->"Palette",
                                        Background->RGBColor[1, 0.749996, 
                                        0.500008],
                                        ButtonNote->None]},
                                        {
                                        ButtonBox["Frame",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Frame",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Frame"]},
                                        {
                                        ButtonBox["NoFrame",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoFrame",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoFrame"]},
                                        {
                                        ButtonBox["Grid",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Grid",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Grid"]},
                                        {
                                        ButtonBox["NoGrid",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoGrid",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoGrid"]},
                                        {
                                        ButtonBox["SmallPoints",
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"SmallPoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"SmallPoints"]},
                                        {
                                        ButtonBox["LargePoints",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"LargePoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"LargePoints"]},
                                        {
                                        ButtonBox["NoPoints",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"NoPoints",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"NoPoints"]},
                                        {
                                        ButtonBox["ViewLeft",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewLeft",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewLeft"]},
                                        {
                                        ButtonBox["ViewRight",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewRight",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewRight"]},
                                        {
                                        ButtonBox["ViewCenter",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"ViewCenter",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"ViewCenter"]},
                                        {
                                        ButtonBox["Tall",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Tall",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Tall"]},
                                        {
                                        ButtonBox["Wide",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Wide",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Wide"]},
                                        {
                                        ButtonBox["Detailed",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"Detailed",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"Detailed"]},
                                        {
                                        ButtonBox["VeryDetailed",
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"VeryDetailed",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"VeryDetailed"]},
                                        {
                                        ButtonBox["RealTime",
                                        
                                        ButtonFunction:>(
                                        CalculationCenter`PopupList`Private`\
PopupFkt[ Null, #, #2]&),
                                        ButtonData:>"RealTime",
                                        ButtonFrame->"Palette",
                                        ButtonNote->"RealTime"]}
                                        },
                                      RowSpacings->0,
                                      ColumnSpacings->0,
                                      ColumnAlignments->{Left},
                                      GridFrame->2,
                                      GridFrameMargins->False,
                                      RowLines->False,
                                      RowsEqual->True,
                                      ColumnsEqual->True],
                                    "Input",
                                    FontSize->12,
                                    FontColor->GrayLevel[0],
                                    ButtonBoxOptions->{
                                    ButtonEvaluator->Automatic,
                                    Active->True,
                                    ButtonExpandable->True,
                                    ButtonSource->ButtonData,
                                    ButtonMargins->3,
                                    ButtonNote->None}],
                                  Active->True]}
                              }],
                          {"PopupList", {"None", "Frame", "NoFrame", "Grid", 
                          "NoGrid", "SmallPoints", "LargePoints", "NoPoints", 
                          "ViewLeft", "ViewRight", "ViewCenter", "Tall", 
                          "Wide", "Detailed", "VeryDetailed", "RealTime"}, {
                          False}, 
                          CalculationCenter`PopupList`Private`BtnFunctions :> \
{Null}, ""},
                          Editable->False],
                        "SecondaryPlotStyle",
                        Editable->False,
                        Selectable->True],
                      BoxFrame->False]}],
                  "Text"]}
              },
            ColumnAlignments->{Right},
            GridFrame->False,
            RowLines->False,
            ColumnLines->False],
          {"QuickPlotBox", 
          HoldComplete[ 
            Sin[ 
              Times[ x, y]]]},
          Editable->False],
        "HelperBackground"], "\[VeryThinSpace]"}]], "Input",
  CellLabel->"In[182]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
            
            StyleBox[\(Plot3D[
                Sin[it + x*y], {x, \(-2\), 2}, {y, \(-2\), 
                  2}, "\<Detailed\>"]\),
              FontFamily->"Courier New",
              FontSize->12,
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontColor->RGBColor[1, 0, 0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], ",", 
            "\[IndentingNewLine]", \({it, 1, 4, 0.2}\)}], "]"}], ";"}], 
      TraditionalForm]], "Input",
  CellLabel->"In[185]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"],

Cell[BoxData[
    \(TraditionalForm\`bz = Import["\<c:/pokus.gif\>"]\)], "Input",
  CellLabel->"In[267]:="],

Cell[BoxData[
    \(TraditionalForm\`Show[bz]\)], "Input",
  CellLabel->"In[268]:="],

Cell[BoxData[
    \(TraditionalForm\`x\^2 + y\^2 < 25\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`InequalityPlot[{x\^2 + y\^2 < 25, 
        1/x + y > 1}, {x, \(-100\), 100}, {y, \(-100\), 
        100}, "\<Default\>", "\<None\>"]\)], "Input",
  CellLabel->"In[271]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Helper"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{890, 653},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
Magnification->1.25,
StyleDefinitions -> "CalculationCenterDefault.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica CalcCenter, you must remove the line containing CacheID at the \
top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica CalcCenter.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Helper"->{
    Cell[19112, 566, 236, 7, 54, "Input",
      CellTags->"Helper"],
    Cell[19412, 578, 26611, 513, 230, "Input",
      CellTags->"Helper"],
    Cell[46085, 1096, 217, 6, 54, "Input",
      CellTags->"Helper"],
    Cell[46598, 1116, 215, 6, 55, "Input",
      CellTags->"Helper"],
    Cell[58071, 1597, 203, 5, 30, "Input",
      CellTags->"Helper"],
    Cell[61011, 1696, 30218, 580, 247, "Input",
      CellTags->"Helper"],
    Cell[91232, 2278, 744, 21, 97, "Input",
      CellTags->"Helper"],
    Cell[92245, 2312, 282, 7, 77, "Input",
      CellTags->"Helper"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Helper", 93251, 2342}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1901, 55, 181, 4, 96, "Title"],
Cell[2085, 61, 190, 4, 31, "Text"],

Cell[CellGroupData[{
Cell[2300, 69, 126, 2, 79, "Section"],
Cell[2429, 73, 63, 2, 38, "Input"],
Cell[2495, 77, 65, 2, 38, "Input"],
Cell[2563, 81, 71, 2, 38, "Input"],
Cell[2637, 85, 61, 2, 38, "Input"],
Cell[2701, 89, 61, 2, 38, "Input"],
Cell[2765, 93, 64, 2, 42, "Input"],
Cell[2832, 97, 64, 2, 46, "Input"],
Cell[2899, 101, 68, 2, 38, "Input"],
Cell[2970, 105, 63, 2, 39, "Input"],
Cell[3036, 109, 61, 2, 38, "Input"],
Cell[3100, 113, 105, 4, 82, "Input"],
Cell[3208, 119, 61, 2, 38, "Input"],
Cell[3272, 123, 100, 2, 56, "Input"],
Cell[3375, 127, 70, 2, 82, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3482, 134, 116, 2, 45, "Section"],
Cell[3601, 138, 129, 3, 57, "Input"],
Cell[3733, 143, 96, 2, 38, "Input"],
Cell[3832, 147, 101, 3, 38, "Input"],
Cell[3936, 152, 111, 3, 38, "Input"],
Cell[4050, 157, 68, 2, 54, "Input"],
Cell[4121, 161, 71, 2, 54, "Input"],
Cell[4195, 165, 117, 2, 58, "Input"],
Cell[4315, 169, 68, 2, 55, "Input"],
Cell[4386, 173, 85, 2, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4508, 180, 114, 2, 45, "Section"],
Cell[4625, 184, 4483, 96, 158, "Input"],
Cell[9111, 282, 67, 2, 54, "Input"],
Cell[9181, 286, 79, 2, 73, "Input"],
Cell[9263, 290, 66, 2, 54, "Input"],
Cell[9332, 294, 99, 2, 55, "Input"],
Cell[9434, 298, 68, 2, 54, "Input"],
Cell[9505, 302, 73, 2, 54, "Input"],
Cell[9581, 306, 74, 2, 54, "Input"],
Cell[9658, 310, 133, 4, 97, "Input"],
Cell[9794, 316, 87, 2, 38, "Input"],
Cell[9884, 320, 111, 3, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[10032, 328, 147, 2, 45, "Section"],
Cell[10182, 332, 111, 3, 77, "Input"],
Cell[10296, 337, 172, 3, 76, "Input"],
Cell[10471, 342, 99, 2, 73, "Input"],
Cell[10573, 346, 162, 6, 141, "Input"],
Cell[10738, 354, 77, 2, 54, "Input"],
Cell[10818, 358, 79, 2, 75, "Input"],
Cell[10900, 362, 71, 2, 54, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11008, 369, 114, 2, 45, "Section"],
Cell[11125, 373, 67, 2, 54, "Input"],
Cell[11195, 377, 80, 2, 54, "Input"],
Cell[11278, 381, 87, 2, 54, "Input"],
Cell[11368, 385, 60, 2, 54, "Input"],
Cell[11431, 389, 90, 2, 54, "Input"],
Cell[11524, 393, 62, 2, 54, "Input"],
Cell[11589, 397, 90, 2, 54, "Input"],

Cell[CellGroupData[{
Cell[11704, 403, 118, 4, 97, "Input"],
Cell[11825, 409, 97, 2, 47, "Output"],
Cell[11925, 413, 97, 2, 47, "Output"],
Cell[12025, 417, 98, 2, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12160, 424, 291, 5, 76, "Input"],
Cell[12454, 431, 6252, 114, 910, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18755, 551, 113, 2, 45, "Section"],
Cell[18871, 555, 85, 2, 31, "Text"],
Cell[18959, 559, 91, 2, 38, "Input"],
Cell[19053, 563, 56, 1, 38, "Input"],
Cell[19112, 566, 236, 7, 54, "Input",
  CellTags->"Helper"],
Cell[19351, 575, 58, 1, 38, "Input"],
Cell[19412, 578, 26611, 513, 230, "Input",
  CellTags->"Helper"],
Cell[46026, 1093, 56, 1, 38, "Input"],
Cell[46085, 1096, 217, 6, 54, "Input",
  CellTags->"Helper"],
Cell[46305, 1104, 143, 3, 54, "Input"],
Cell[46451, 1109, 88, 2, 54, "Input"],
Cell[46542, 1113, 53, 1, 38, "Input"],
Cell[46598, 1116, 215, 6, 55, "Input",
  CellTags->"Helper"],
Cell[46816, 1124, 141, 3, 55, "Input"],
Cell[46960, 1129, 93, 2, 54, "Input"],

Cell[CellGroupData[{
Cell[47078, 1135, 106, 2, 54, "Input"],
Cell[47187, 1139, 91, 2, 47, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[47327, 1147, 122, 2, 45, "Section"],

Cell[CellGroupData[{
Cell[47474, 1153, 95, 2, 38, "Input"],
Cell[47572, 1157, 79, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[47688, 1164, 98, 2, 54, "Input"],
Cell[47789, 1168, 82, 2, 47, "Output"]
}, Closed]],
Cell[47886, 1173, 242, 7, 70, "Input"],
Cell[48131, 1182, 137, 3, 73, "Input"],
Cell[48271, 1187, 264, 7, 70, "Input"],

Cell[CellGroupData[{
Cell[48560, 1198, 139, 3, 74, "Input"],
Cell[48702, 1203, 352, 5, 63, "Output"]
}, Closed]],
Cell[49069, 1211, 61, 1, 38, "Input"],

Cell[CellGroupData[{
Cell[49155, 1216, 90, 2, 55, "Input"],
Cell[49248, 1220, 91, 2, 49, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[49376, 1227, 216, 4, 97, "Input"],
Cell[49595, 1233, 98, 2, 49, "Output"],
Cell[49696, 1237, 91, 2, 49, "Output"],
Cell[49790, 1241, 82, 2, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[49909, 1248, 206, 4, 77, "Input"],
Cell[50118, 1254, 131, 3, 65, "Output"],
Cell[50252, 1259, 91, 2, 49, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[50380, 1266, 204, 4, 77, "Input"],
Cell[50587, 1272, 138, 3, 49, "Output"],
Cell[50728, 1277, 88, 2, 49, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[50853, 1284, 115, 2, 63, "Input"],
Cell[50971, 1288, 237, 4, 50, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[51245, 1297, 85, 2, 38, "Input"],
Cell[51333, 1301, 105, 2, 51, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[51475, 1308, 86, 2, 38, "Input"],
Cell[51564, 1312, 145, 3, 50, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[51746, 1320, 114, 2, 38, "Input"],
Cell[51863, 1324, 100, 2, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[52000, 1331, 84, 2, 38, "Input"],
Cell[52087, 1335, 107, 2, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[52231, 1342, 121, 3, 57, "Input"],
Cell[52355, 1347, 100, 2, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52504, 1355, 123, 2, 45, "Section"],
Cell[52630, 1359, 116, 3, 39, "Input"],

Cell[CellGroupData[{
Cell[52771, 1366, 79, 2, 38, "Input"],
Cell[52853, 1370, 78, 2, 31, "Output"]
}, Closed]],
Cell[52946, 1375, 111, 2, 38, "Input"],
Cell[53060, 1379, 113, 2, 57, "Input"],

Cell[CellGroupData[{
Cell[53198, 1385, 92, 2, 38, "Input"],
Cell[53293, 1389, 94, 2, 31, "Output"]
}, Closed]],
Cell[53402, 1394, 115, 2, 39, "Input"],

Cell[CellGroupData[{
Cell[53542, 1400, 88, 2, 38, "Input"],
Cell[53633, 1404, 95, 2, 31, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[53777, 1412, 131, 2, 45, "Section"],

Cell[CellGroupData[{
Cell[53933, 1418, 131, 3, 38, "Input"],
Cell[54067, 1423, 116, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[54220, 1430, 151, 3, 51, "Input"],
Cell[54374, 1435, 92, 2, 31, "Output"],
Cell[54469, 1439, 82, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[54588, 1446, 91, 2, 29, "Input"],
Cell[54682, 1450, 82, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[54801, 1457, 87, 2, 29, "Input"],
Cell[54891, 1461, 77, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[55005, 1468, 96, 2, 29, "Input"],
Cell[55104, 1472, 77, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[55218, 1479, 104, 2, 30, "Input"],
Cell[55325, 1483, 136, 3, 33, "Output"]
}, Closed]],
Cell[55476, 1489, 112, 2, 29, "Input"],

Cell[CellGroupData[{
Cell[55613, 1495, 78, 2, 38, "Input"],
Cell[55694, 1499, 78, 2, 31, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[55809, 1506, 113, 2, 29, "Input"],
Cell[55925, 1510, 92, 2, 33, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[56054, 1517, 204, 4, 67, "Input"],
Cell[56261, 1523, 78, 2, 47, "Output"],
Cell[56342, 1527, 231, 7, 80, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[56610, 1539, 307, 7, 110, "Input"],
Cell[56920, 1548, 265, 7, 91, "Output"]
}, Closed]],
Cell[57200, 1558, 161, 4, 45, "Input"],

Cell[CellGroupData[{
Cell[57386, 1566, 93, 2, 54, "Input"],
Cell[57482, 1570, 98, 2, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57617, 1577, 97, 2, 46, "Input"],
Cell[57717, 1581, 98, 2, 49, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[57852, 1588, 103, 2, 46, "Input"],
Cell[57958, 1592, 98, 2, 49, "Output"]
}, Closed]],
Cell[58071, 1597, 203, 5, 30, "Input",
  CellTags->"Helper"],

Cell[CellGroupData[{
Cell[58299, 1606, 96, 2, 54, "Input"],
Cell[58398, 1610, 197, 4, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[58632, 1619, 82, 2, 45, "Input"],
Cell[58717, 1623, 196, 4, 47, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[58950, 1632, 110, 2, 45, "Input"],
Cell[59063, 1636, 147, 3, 47, "Output"]
}, Closed]],
Cell[59225, 1642, 103, 2, 45, "Input"],
Cell[59331, 1646, 137, 2, 38, "Input"],
Cell[59471, 1650, 1334, 35, 97, "Input"],
Cell[60808, 1687, 69, 1, 38, "Input"],
Cell[60880, 1690, 67, 1, 38, "Input"],
Cell[60950, 1693, 58, 1, 38, "Input"],
Cell[61011, 1696, 30218, 580, 247, "Input",
  CellTags->"Helper"],
Cell[91232, 2278, 744, 21, 97, "Input",
  CellTags->"Helper"],
Cell[91979, 2301, 107, 2, 54, "Input"],
Cell[92089, 2305, 84, 2, 54, "Input"],
Cell[92176, 2309, 66, 1, 39, "Input"],
Cell[92245, 2312, 282, 7, 77, "Input",
  CellTags->"Helper"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica CalcCenter Notebook file.
***********************************************************************)

