(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     54291,       1123]
NotebookOptionsPosition[     52773,       1090]
NotebookOutlinePosition[     53222,       1107]
CellTagsIndexPosition[     53179,       1104]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8726603655960217`*^9, 3.8726603718455667`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1900"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "920"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", 
   StyleBox["1",
    FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"k", "*", "0.45"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"div", "[", "v_", "]"}], ":=", 
   RowBox[{"Div", "[", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "s_", "]"}], ":=", 
   RowBox[{"Grad", "[", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<a= \>\"", ",", "a", ",", 
    "\"\< \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rce", "=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "\[Equal]", 
   RowBox[{"a", "*", 
    RowBox[{"div", "[", 
     RowBox[{"grad", "[", 
      RowBox[{"T", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "]"}], "]"}]}]}]}], "\n", 
 RowBox[{
  RowBox[{"Tokoli", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tStart", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"x", ",", "tStart"}], "]"}], "\[Equal]", "Tokoli"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]in", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]ext", "=", "16"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tin", "=", "26"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]ext", "*", 
      RowBox[{"(", 
       RowBox[{"Tokoli", "-", 
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}]}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
    RowBox[{"x", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tanh", "[", "t", "]"}], "*", "\[Alpha]in", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], "-", "Tin"}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
    RowBox[{"x", "\[Rule]", "d"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceCelkem", "=", 
   RowBox[{"{", 
    RowBox[{"rce", ",", "okr1", ",", "okr2", ",", "poc"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "=", "d"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"5", "*", "24", "*", "3600", "*", 
    SuperscriptBox[
     StyleBox["k",
      FontColor->RGBColor[1, 0, 0]], "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rceCelkem", ",", "T", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["xmax", "400"], ",", 
         FractionBox["tmax", "400"]}], "}"}]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"casy", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"tStart", ",", "tmax", ",", 
     FractionBox["tmax", "20"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"krivky", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "#"}], "]"}], "&"}], "/@", "casy"}], ")"}], "/.", 
    "sol"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "krivky", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "23"}], "}"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Alpha]in"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"xmax", ",", "t"}], "]"}], "-", "Tin"}], ")"}]}], "/.", 
     "sol"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "150"}], "}"}]}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tuprostred", "=", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"0.5", "xmax"}], ",", "t"}], "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"solT", "=", 
  RowBox[{"Quiet", "@", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"Tuprostred", "\[Equal]", "10"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"0.5", "tmax"}]}], "}"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Tuprostred", "/.", "solT"}]}], "Input",
 CellChangeTimes->{{3.872660411874035*^9, 3.8726604156549993`*^9}, {
   3.8726604809159946`*^9, 3.872660487405876*^9}, {3.872660528986147*^9, 
   3.8726605312828503`*^9}, {3.8726607359716597`*^9, 3.872660739080819*^9}, {
   3.8726607906397114`*^9, 3.872660805919901*^9}, {3.872661090701332*^9, 
   3.8726611554054413`*^9}, 3.8726612144325476`*^9, {3.8726615438470144`*^9, 
   3.872661602033931*^9}, {3.872661642508669*^9, 3.872661685700559*^9}, 
   3.8732650165546646`*^9, {3.873265217151928*^9, 3.8732652361044044`*^9}, 
   3.873265333144582*^9, {3.873265396218337*^9, 3.8732654031990447`*^9}, {
   3.8732654407901807`*^9, 3.8732654544941916`*^9}, {3.8732654964639673`*^9, 
   3.8732655083381476`*^9}, 3.873265577489601*^9},
 CellLabel->
  "In[431]:=",ExpressionUUID->"446694a0-1345-4e66-8365-1f503ea7420d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a= \"\>", "\[InvisibleSpace]", "4.576659038901602`*^-7", 
   "\[InvisibleSpace]", "\<\" \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a= ", 4.576659038901602*^-7, 
   " \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \(-1\)]\
\)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8732652374168177`*^9, 3.873265455103505*^9, {3.873265499963735*^9, 
   3.87326550921309*^9}, 3.873265580020695*^9},
 CellLabel->
  "During evaluation of \
In[431]:=",ExpressionUUID->"dad7c685-eaed-4dfa-9375-bb3868cec75c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["T", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
  RowBox[{"4.576659038901602`*^-7", " ", 
   RowBox[{
    SuperscriptBox["T", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "t"}], "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.8732652374168177`*^9, 3.8732654551169996`*^9, {3.873265499963735*^9, 
   3.87326550921309*^9}, 3.87326558002684*^9},
 CellLabel->
  "Out[440]=",ExpressionUUID->"6a5f7685-8aa8-43da-a36c-d42e4eb6d38e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/V09UPn4Dmc7BjAQcbjzU3jNH7Eiexh/eXt7wW+x
JjjfbG45y/6bk+D8fTP4FixjnAPnL3xk8/pk7SI432KB73ylmOVw/qN3/NV+
z1fD+QWbrpm/y9wA56+rvDVj25VNcH4Z5/beF6Jb4fwXOoz9p9u3w/lPJFRU
JC7shPPlBf/IP+PZA+ezzHXUSK3aB+fv/KH/SC3+AJx/9E3ptuKZB+H8j2li
doznDsH5Sa6L+w+/PQznr3ibln5P9Sicb/xLjFPP8xicP/nCX4NrLcfhfCFd
e579u07A+dfe5my8c/sknJ9fcfFOkOhpON83XenSX8szcL7XnbNVLyPOwvmy
0htW6k44B+eb7KtbtGzTeTh/gughgT1lF+B8Mf5Pmq6CFxHxZSWxImMhgh94
OjJzh+0lOJ+tb2L/ovMI/unJZfxr4y7D+dX/yi49/ong+87O/bWl6wqczzW3
PnWT+lU4/+WFdlOvXQj+DXfbeCava3D+RmW+M8+eIvhrDa/OTS2/jgjPJds3
CYjegPM7o9wV76xH8Bc6nf3i6HATzl/Sn8d95Q6Cf5KPrZ0h/xac/++CV4zv
PwRf7seqkmMzb8P5CYGMn25q3YHz/e5WRF2uRvCtMz8cOnMGwQcATEPmCg==

       "]]},
     Annotation[#, "Charting`Private`Tag$21402#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Hk41FsfAHBJurKl+zNj31UyQzcSt/Q9poYiaypkTbae3BalIpKbpiTL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       "]]},
     Annotation[#, "Charting`Private`Tag$21402#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVx3s0lHkYwHFkZ7cyLjXzzrhOcyMW8xa22uh52KTscqJNkaLOUk6FCBVb
Ue2kWpdsYkuukXaSrB1ymcY4qJBb7r9USGl3Sp3a6DK2/eN7PufL3xHhG6Kj
paXl9bn/fWflI2yp/m5VqMpU2ZDMQnkBh7uOI4AvNJ5i4SkWsgKTi/mcpaAl
t7x8/PM3LlepmRw3ONlv/9bjNAtNSrYZ6XJ8YcPLtIGOMyxcM2IrnKV2wMiM
Sf14KgvJzELZRyoKEnJzEoWZLCyRSiM/UEmwWRHHnylg4Tc5cbq3Bs+C/bYV
2slKFiqy9POKtS9CS4BYkDbCwvxR57/v/FwAkokwz2wNC5fneeUKAktgiLP2
XL6IjaMvDOK9n/4BZg2rLqZ/z8bIir5lL8LKIcqrYd+rg2wsOziUJb9fAU0q
k60iGRtj51b9+oz9F+i4yhLPPGTjM1vt1FZpFRQudVArzSgc54pE3M6bEBT7
e1TsFgp5Rh95E3p1kLuVOpp5iULdHNfFIYcUUHts2VaXFxTenJaMWgYpQb//
eXwkcLDpnxh5dHYDWCQcTk3M5eCrUGqV9j0VrElgyaUMLu5wL0xtVDfC5JaQ
imfhXLyiDt05Im4Ci2poVExy0eE9Ndd+XTNk7J3aPx1ijBmdn+i+4y1QOy4M
vPTOGBfYgd6tmtuwKZExGHrWBPvUe26Q4TvQfmUw5pGdKUYc6CK+7Fb4Kpy1
wGLMFL12Cro/rWgDtcPG/uYsM/Qk7YcmN7dD7v4qJWOTOZqblpfapd0D2cNH
U+kOFuioOFxQXNEB08yu95YGPExjqwzrYjthr4ub0o+xCCmD19buRl2Q7Sw/
MXFqESq+5V7Zld8FY/67E2eZfPRp9Q+rdukGUir2TiriIyMlPbWgoxtSQj3W
6q4QYGtGrMG1bT0w9PK6AXYLMF4T2z020wNRasOAlYlC9Lqw933lqfsQXPO4
t8lWhPNyjoRUWPVCit1pneGXIpzslDp51vSCxyN/p8tlYhzwcAnS8eyDGJ/p
ko59lnhDqN828aQPFPtC/zzvbYXXlvTmhMT1Q+0ePZGleDFmFFVVGLIHoLv8
vGiIssbkAA8+uT4Aw85dEn+mDea7tb9xxUGI8T+0J/iDDRalhs+/Twbh+e2L
b8wZtnhHnyHVihiCS66NMqMv7VDT6RnopRkC/TlHfCXz7NFi+ur+5uxhUKbP
llt8LcFgH+3XgzYEnqyRpY/xaFQy3eu32xHQRGvV/iigkXf35MlJCQGVxlDc
LKJxxM2QN+NIIKxUUltqTWOgI+8HLhBoyXigjnagcRPHpdhvA4GZsrpglgeN
3g8OBPTEE5jtPWJ8IpzGsuw68ZbDBKhOY9BE0sj003o1epSAk83VwrhoGtvu
SaWvTxDQexptvfsAjeuUmZVGaQTmqxZabkyicXVhpf76IgJv/eR9jpk0FgVN
D/YXE1i84MH4jSwa55g5Xw4qJSA5brBEcoFG1W+NKyPKCFgtDTxmk0cj/tK9
K6WagI3wDVN0lcY8N8qRqiVQJB6YVyijcVbjP5tTT6CmZL274DqNirjH566p
CATQjVH8ShrNHcXbnZoIuNnlhuTLaUyY2mVb30IgObPnHP8mjUQme7f6LoF/
A3zmFNTSuDJsStXWRsD/p7llAgWN/wFN4zKS
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX081HccAPBTrSZPJ/3uLg8dd+Sh8/DbkJV8PikripdUlMTUECmlcqJR
vZrrVK6NpnutW55yeiAk1BBnkqfC6eL6TpseaEWoPFTY9sf79TbbGeMXNovB
YHj/5//HLTfyGytXuw1e6xZcSKKwPIfN8WTz4GbK1cz8ZAoXBonzzdhfgUAa
yb91jMJ6F8WgDtsddJ20f+s8QaGhPFh/DtsPpsajeXoiCr/tFfBnWDuBCP5J
TJNQSCYNrn9mxUKsEhbKsyiUi0T7P7FOAFWhGFxTT6GzTDjnbs/PkBhr23qY
ycKaC7pZ+RoXwai5Jen4dhZm97m+bvohB8pSxpxdC1jokuV9iRckh7R9VoFR
MyzsG9JL9Om/BmlxFw2ebmbj/lLVsqHIYggIyHQPLWdj0RH1hfKuUsgNGvM4
bsTBOM2KswPULTBcpZ85P5mDAwINSYuoApwPfqo2GOHgc465Oaf9NjCi1xvJ
QxchV/8z96V2FUg3+NsYqRbhHNkqq7CEGoAru7IKtxvi7Qn7viUhtbB8nqDt
0FNDbHhzuPygtA40smXvkuKMcCSc5abxQAF/iGK/OGJgjDs9ciX1g/Uw73W8
fKrQGAsGwyN6LRpgRzKb2RFsgl9/ZGnaed4DVuIOj17txZjePuWgOtkIl/uP
6uYrF+MCW9C+e+c++B/N4MRnc1E1GF1CnjRBBn/USO5kijHxHcSPagE3cvLs
+QJT9I7gdU590woub7usnRaZoRdpS3i1tQ3eG+cybp8xQxOj4iu25x5AuDgn
4S89HjrWJOXklz4EzZSBKbWEh+coBbMqrh3evvn4oc6Ujyy9UWsP/Q7wF/Ym
h97iY81yTsHu7A7wc3q7rd7DHDe2bIusXNkJQ6u5STcGzHFu2k+SnIedEM5t
ZjamWGBLepxeYbASSg7N5EZZLsHE6bjOZ5NKuGf57iFFlqD3r3s/lqV2wTrm
ke5LqZY4X5YcVmr5CEretZEtPlb4ql3k5HXnEdhV1vVZa1lj99qVIbO8VNB0
wIWMNlljCV+39eULFQjl6a42l2ywkH4kCxM+BnFZ0o3JPUsxPa+ilEl1w/oN
vlZWvgIUB641Ize64XmDjmmwsy1mu7e9X4U9ENuVUXtygR3mSfZpdZEeyJzZ
dWZ8rj026c4VMWLUUNQp1Yoatsfpdq8g72k1TNhE39HY64CLJ64euid9AlsF
wvp1Qw743UaN0R4bAi+nAyKXRdJYq+NRHWpLoBQ4y0L30MhtPnXqlT2Bg+Iv
7U/vpbHXncmddCRQZ7FZ9vQAjUGO3A0cIKBOSI9NTaAxgL0y338TAeM9qeP9
p2n0+TM+UJlIQOkjtVYU0VgkrbLYnkTA08Vl6UgxjTr+jJG+YwTYDPUW05s0
tj4QiUZ/JGD3YsYiuYJGz9pfyvTPEZBI7xe71dK4JrdM1zePQKqkL6Khg8a8
kImex/kEAjfZfRhT0jjb2PVyyBUC6W19V61UNCoy6lfEFBEw0QyRnFHTiCmd
u9MqCehTGSv8n9GY5c5yZP1OYDZFaYlf0DgzvW1GVk1ApCqeVdVPY43w7/OF
CgKVQv0o3hsaTRwtQp0aCPjWKHq2DNF4dHi3oLqRgH9GxAHxMI3k+vXxNc0E
4i3HHKpHaVwROaxobSVA5X7PGXlP4783FTon
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#4"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjWs0lHkcgIecjhJSeWeExmXcyvXNLeL3I61NjaI9unBSNKWTQopK9y0j
m0GDbjs2lya5VXNEWqZBKLeGEM2flVY4LQdLUWLbD895zvPpMQyJ8OcpMxgM
7g/+9xczP+P6pxvcR6e9O1JOU1iazWRtYhrBE6/Hm/3OULgi6KrYkElDvc76
Pq1zFNY4V4+oMz3B3Udtv/AihSvv79FSYfrDcvX+rhsJFP7Ua2k8T4WAa7RS
ojiDQjKzvHCWOgaqPx/OVEgovM/nR36jLgFToGz34BOFjqJYlefd1yGtfIiu
C2Oi9KbGXbHS71Cv2Dbh28fErP71n16dzYZE4PKCd7LQ+S73D6Og+2BQMDBA
97Kwf1QzznewAHR60sqa9uhgpKTTafTQI4hSppzSR3Ww+NS7m6XtEghURHal
X1iJMYvKkoa0n4DopKnqEXVdHLJUSm7kl8EOxv6M1AJd/JvF4bDk5ZCZH5p6
x0sP2Vqz7I9LKoDdU1Q1+5ceqog8zHmnpdAfTz70CfSxfNqm3zRYBvpvGWMb
nFdh7T8nSqNvVYGpv+TR2OdVOH6AcldqqQZumdNxYTkbQzbmJNeM1AD+4j80
72KAeSMHDvaa1ILRFYV4xT0DXPuVWmS9qQ6iGyZretUMUSj/btt5uR4cJluX
nT1viMusYMnzZy9hnXW5btiUIXaOhD8mileglltaFHXQCCNOthJ/7UYIOBVe
JRw0Qu5Bo7bv65qg9UTC60uhxuhDmk8P72wGDl9ll957Y9TXffTAKqUFVrTo
Ji48ykF76blsseQ1UAGR5pNTHEzRrl5aESOHvJICHTOBCVKaExYbtVqBw5nR
TDI3RakLKy8sqxWiZWODqpWm6Ne469BTtzY4JnlhORVihgsFqcnZr9tgsXRu
PlrZHBuFMZpFe95AkMUCQ4Mcc4ybi2n7MPMGrM0C7mwOsEDunSNfSxLbYd2/
8sBppdW4WHSeJzHrAI0h8e5J2WoclvMdfJ51wNdwDWF77Brs8nYLVvbphOMG
PT3bbSzxsbFG08eBTphZY+ym/M0Si+w6RLzYt5BYu9hgf6UVCnPLJEu1uyA5
It5flGaNV3d7G5KHXdCf67AmKtwGszybJz2wG3bwXO0UeraYm3xUrZ10w96q
iBYXgS2+0ljIZ0S8A58PHyumZ2xxTu4TxJ17B7X2gTlbeXa4ajr/eN0tBfx6
2zFBpLDDvX5KE92rCcjbMsfzN9MoU99Yuc+KgNCpsTmbSyO7ISFh2IYAO3jf
y9tbaez1XMqesSeQNPaQ9dt2GoPs2VtYQOBaNsvkSCCNO5hu4oDtBFa+MBt0
PEyjb8/J3W/iCOzNONrXl0hj8a0Kk8BzPzo56wy5RqN6AGO8/wKBqQOhjl0C
Gpta+PyJKwRcv8Qqy6/TuEmWUaKVQqBxrdGs7DaNXjklGttyCaj5hkbk5dOY
Gzzd/VZM4HOUx/t7hTQu0Ft/L/gBAedh98icYhqr02pcI4oJlEnjBjIlNGJ8
W5jgKYGCtc6WN57ReNeTsqf+/PG32BKfXkHj/NyueVElgXEL7+9CKY3S2Pfp
RdUEULXTI7WaRn17k30OtQSaawI1U17QeGYszLKynsDFDYUzgjoaSWHhF68G
AunHZAzBSxpdD41VNzURGHBJ5SQ10PgfM8U+Kg==
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#5"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzXs0lHkcgPEh61RyqzXvpJgYGkKYVynR95tCZGx0kUts07p1NtQKkdou
u5OIRG1t1IRFK5J1vyVWyGDchtGvOqlsziSSCqHd/eM5nz8fPUGYR4Aig8Hg
/9f/fua6c5ortm4u2VW989NuCssyKZYzpQ/aZ+Ypd08Kv/WNz9GjeHAv0HMq
34vCxg0No6qUPUwrpigJ/CjUzvXTVKI8INB6Kb8ziELHZ6acr0wBVD19UFAY
QyGZXnZ3lnkUQnlgfFpEYa5QGP6FeQYS5HZD0W8pXJ8RpfRAdhkOFXQ0dl5m
Yd01NVGOQjpMahs4CiyW4+0hW3lrXCaENQds2tK+HDeI+Lf0fXMhLryfHRij
jUPv1GPd/smH7YsuFqqzV2B4sdT6XUgRBERPxazpW4GFxwevlfUWQ+nCseoP
CSsxclH5xTdapZCirvW7i40OvjFVSG4TloPI/0Z8+xcdfMUyMGBJKmHBjsG5
1yW6yNacZQ8vqYHcdtlYbSgblTK2GAXE1IHnle+8m3RXYeWU+dBq/3o4dOSz
U8vpVdj09ljZT9cfwswtN8XZsVX4PpC5WaGjAQZUqrfy/PVQ4JCV3DjaCPZG
5i9KW/UwbzQw6JlhE3wT+XBYgPpIzzAXrXV+BLx+bOYV62OqZM5Ceq4Z3OMu
nxu14OBSM1jyoKoFVMyXar0o4qB09Mf75EkrqJjl7Y8yMcCw6C7iodUG4bb5
KZN/GSA/SL97bqMY5PesYzvWG6ILaY8Z2dcOqc4nJvZUGaLOiqI7Zpc6oKYk
zq/EdTVa1Z3MzCnuBDXv7T4tA6vxklaDRk2kBDqG0yWhEVxkqk8YO2h2waBD
zyxH0wjrbFh5wbe7YIa7UCTOMUL3Nq+QCrtu4KR3jY24GqNyUkpyZmc3+ES1
HEuWG2NbaqR6gV8PyIT58sMX1mDsfGT3y+keCCxS3ZNoY4L8G4dnSi70Auv1
4rR9Qya4OONUQDG3D5SfD0oZ6aY4IhGuc6nqgwGlxGGZqxkOONn5K7pIIbGm
Oytizgzvc9TEw6+lIC2SnkmpX4sFln0ZAVH9IKfZN8ePm2NqdnmxhtYAuNsc
TeVyLDDe20mP3BuA36TNL3nxFnjbvn1yC8rg1MflWUMjFpidHKrSS2Tw6Mo7
PbfdltiqpixkhA2CQ2fNBValJc5LXHz584Owb+HBdVY6PNSd+jPi0fUnIJIw
49Yn8PB7d4UJ2RoCJzSC8nQ/8LBe1aH2gBmBkSJH5/eTPGQ/Pn9+xJzAVVt9
hb8/8fCZvQZ72orAq6SK0pAZHvpasV1ZQMBvY7dlmQKNnpRdzt5dBDa6Wh/Z
pUGj29No755YAifx7JubZjQWXq8x9DlJ4Esn8Yswp1F1L+P90M8ERiFR7mxJ
o7hDKJz4hQC3vt/poxWNzvVXSzQvEdBWTlLh29K4LatEbWc2gbelg1WMHTRm
+0/J+nMIlNtqp/W70rhgpe0f/ncImNM+ZwvdaGxIa9wUVkjAkyfO8vWgEX/t
Dk6qICC/0Sev9KJRZM+0YlYTUGlNiEjxofHrvNfXjNr//r2sZSH7aayLenGl
oIHAJ+PMFNYBGnWsDA+sayJg0pR6ZFxA44nxYNPaZgIHnzsGtfxAI7l79/O2
xwTSdMuOigJp3BQy3iAWE2jlktToYBr/BfDJPa0=
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#6"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxXk41HkcAGBkO0VDZn65r0FjnL+xnXw+iXqyyVHPdE2Jjdin0rMkUbH7
pKFrlNhUziyVo5qEDjPtaJIzBuPoSxsdPI6N7LrC7v7xPq9pYJhfkJqKiorX
f/5/3MrXvKp8oyvnaR9v3QIKS3NY1BaWGQR7W43qLKZwuSAxz5TlBE4+ospB
DQorV8uGlrLcgB20/HaGNoV6+fsZ6iw/iDsWx59nROGmbq75HDMQFFLPm408
CsmkTuE35s9gebJ7LjqQwnyh8Ng081eIzyvaqi2h8Pv0E+rSjqtw/C/Ti+Px
K1ByXTMrT/UWpEbtKDjipofZPesHqk/nwE3fepnBjB6uzvLKNBPkg77INUKt
Rh97hrVitn0ugICv8inxBQM8JlauGg59AE0pOmmJBwyx+GTn9dIWMdy4JW55
xDPCyEVll/p0H4N2Gje/eMYI+7iqolphGfB5ZgUOb43xA2VhQTU+AffQHw1e
8k3QmPHN+JPGc5gajbHKlJqgevoG66BoCeytOm4eTpvikwn7Hkv/F+ARdzXn
QrYpygePl4an/QFCpWesrb4ZjgQzXVUbZDAtDRDMXjPDQI/bosqhSmj7Zd+w
YqE53hkKPtTNloMrREnGEsyRnmIustvyCvYRC+txNQtMbpxxUJ6tgumukrbu
RAvUtgUN6dPXMP2upNuAwUbl0OGH5G016Lb//bj5ChvDopqIn24tJBX11fJM
LNHrkJliZk0d9Np+fNmab4mepD66f1c9HPzSotxrb4WG+g/u2iY1gMLu6J+b
5FbIk5zJyRO/gSe/ZRUObLfGJF3ZsueRjcAUOFLCEWtkao2u9GA0AedRzEUf
0UqUrKXuhGQ3gcC0oX81m4O+tbtDy10U4NebmfKqhoPzL18R5bxRQN8jeYZh
iA3WJkdqFe1vhvBEX5sJdS7GzEYqeiebgZqvEbFczEWvm0emSs63gHqtPNyL
b4uL02ODxFatEKua6Y1L7LC/Uejs+bQVOiOG7YZK7bB9s4u/mqcS7jcyoioC
7PGhuWbdp49K0JnpCunVdMAix9b0oBNtkCwdS/l8yAGTc8vEy3TbYc0R/13l
1Q6YuGezKbnfDtnKwCVMG0fMdqsf24Ad4LxGNMkQOmKu6OiSFtIB2oflOxcO
OmK15nyhSlgnPLNndwb/4ISzjZ4Cr9lOkGq4e32664RGE/ciXqW9he9upI7F
MWg84Ks62sEhoHdKf4IdTuOLpR4VAbYEPG5xFpAIGo1rEhL67Ql83TRhdTWS
xm63ZcaTPAK9u6UZsydpFPCMt1JAIM/k0oH2OBp3slzy+NsJLHa+5yi6TOO2
rqg9zTEE8HHX0KJ7NBanPWfvPUMg4+AcV1ZA41K+ykhPHIF/Vvmfji6isa5B
KByNJ2CtVe078IDGLS9SSxhJBCbKm1/Xl9HofrtE0yeXwE/xvMEUOY25/hMd
bXkEzjF8XLyraJxnsP53/7sE+GdDMhdW0yi7VrkurJhAV2lsakwdjXhOEXK5
nABnZ4t3YDONWW5MHvMZgc3sg9YGrTTOze6eS68goDv1hqFU0ig58T6lSEZg
ZK0Ny7OTRkMeO8BZTuBDsDatTmg89SWEW1FFYMcKub+ki0ZSWDjuXkMgwQHS
o97RuC70i6yujgDz/KkBp/c0/gtWkz0Y
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#7"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVzHk41HkcwHFKlxCVmV+hyTimMA0zP6XQ52NKItpISpQox2xtqt3VYaWn
1MiTa9GS1bpC26AmKzlbHpUjOcfRl8eRZMOiw1GNbf94P6//3ro+gS6+8xQU
FJy+9b9THGe9Z0Xbtp5cdSzRL4HCwnQmZc9kQ0hRdk1GIoUrPa9n6TL5MPjP
oHJfMoVVFpWjqkwhSNVDyzzSKVydfVhDiekCS4K8XjvnU7ijx0RvjuEDYxX5
QpsaCsnMCskXxhlQ2MaNMflKYbZYfOoz4zKYzhvu2+S7CjemnFWq6PwVHBUW
cDrsVmN5olpqluLvUO2hdGlAWwvT+q3e1YSkQ+iNnXt3/KuFFqlOf7A9s2Fq
sKbHp00b+8eWBe8eugdjojAelaeDp6SyTWOi+yA+KszdnrwG8853JRa2SsHy
io5yzjUWBi15FPlW8y94b5zFduWvxbcmitF14keQL2ly0pKsxdeUvj7V+BiU
qbkMPksXWRpfWG9USuHjvQgHUawuKqXYrPO9UA7igt65j2psfDzN6zf0egKp
4wH8gqtsrB75ufDHpL9BZM3euGWxHk74MbYqNlTCoX2O1dsi9NDHNiO6arQK
zP13au5aoI85o37+PQbV8PSuHbfghj4KZhlLNtg/hd4bwkG5igHGNX41lYU9
A9n+z1XsWwa4nAsqFcXPYfeH2qkhQ0OUjZ54QF7VwIyLdKeVxBADzzURF806
KHULU1YCDjr5s5u/bq6HWesLCdxaDjqQFxeGD7yAvgOt9rdd16GO1v273JgG
iI+1Eq0cXYd0+cX0LOlLeD28mHk5ZD3GaFaqlwY1wunC3i9+2kbIWDa53laj
CULGwnl1xUZYvoXKCUhrgmx58G+SPcboXOcuKrJuhssWGzwiPxrjwqjY6PSX
zaBmcqc8O9YE6+KCluUebgG/9kOFxSZcDJYHNQ/MtECMxUTVjnYuOiX/MFsQ
0QrHmKERYec2oHJKqK+U0wZW4acGEtfzcLhRbO5Q3AZ5cff3aDTxsMPO2mue
gwxc+O7KyZam+EBPrf7NoAxSjj+kam+aYq5ZW4rv2Xa4Gjrd2TdiinGZj6Tq
mh1wVGR023KXGV4/aKdL8jtg7oRS8FCOGaYJX3ywwU4Yjr05xFPkY2b0yaWt
pBMWvVN/2+3Nxxq1hWKFwC7wZw9x5aV8lDc6eDrJu+DITNRqbaYA10z/+dPT
pFfAOxG26PF5AR5xVpzsNCLgHf9wUahMgE9Ubcu8uQSa6gL613QIkFUbHj7M
I/CpYaK2vFOAPUJ11gxNYKj1TLWcCNCTZjlSQKBlcZdX6IAA9zOts9z2Enif
GMa5Mi7A3d3nDrYEEzCN/H4kXpnGvKRSA4+LBGxGooI3qtCo6qYw0X+JgMsn
NtWhSmN9g1g8efXb/2jkeS0NGu2f3CzQiCGQNLm8O51J4/aMArU9mQTyElbp
F+jTmOk13dmeRYAxWhLuZkjjfG2rO153CZSsTJ6d5tBYGV9lGZhHoHfp/IVb
jWnEa80BUUUEJHJWyXMzGlOFDJpRQkCK310/LqBxTu4+l1JGQPYw7ZiaOY3l
Z/sScisJcFwzhK4WNOrQBt7m1QR8VjjaTm2m8ZfxAJOyZwQ6OUv33bKkkUgk
U9trCTi6d5+2tqbRUjReWV9PYOpkRXLvVhr/A+6cOTc=
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#8"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVzXs4FXYYwHFKyuRWzq3iuFO5Hr+KON7XkdymoqIjJYqyldvKKaSJOugp
NlujzVOhg5Lhya25xYPhxOmUa7/YtImJlbao0Nof3+fz51c/JNI3dImCgoL3
p/531tTHsL3GxUnzuY68ahkHq/JYbA+WARweGDvoosJB7cA0iT6LB9Hz2+d6
VnKwxa55So0lgCNer3ZNrObgmsKDWkosX2j3GLm2zoCD24fNDT8yQ+Byyd/Z
F5w4SN+tLplnxkBEijQ+WMTBQrE46gPzPDiuqOwUTHBwc65IqXHwW5BGJCQs
/rYGG7LVb0gUfwKvIxU20R1r8eao42TH2TyACdsAcek6tLvhfd0gsBBiYp7q
XSzSwdFpjfgdL+6Al35pf1CWLkZV9G2ZDi+DSGe5f3UWF0vPDGVXPakA5hRH
o9xdD2NVqi+PMyrhwPYtJ/9t1MNxc8WMLnE1yKwYCWECffyDbWTEltVC4d5L
Mrd6feRqzXPHVtaB/2R7We9mA1TKdTYLjWsA/gsNiUKdAdbOWY2aBDXBGzdh
brK9Iba+PFX1Vc4DiGFNay00G+LrMKaTYnczKLv61ER7GWGIa35Gy1QLWPNd
zjKkRlg0FXZ02LgVJMuLb5kJjdH2PVPF0qMNEt3ZxXuGjTFLtmDdl9IOKSZL
H3hHmeAqC1jZeP9XMNrZpC5UNMW+qePl9GkHcM+v1nVMN8XI04+oL6MLhDPg
GKpnht5HDeQL9lI4t+qZr6DUDD3pw7iJfQ+hyUA78q+t61FnbVmxRWY37N7b
PevZux5JQ2KepKIHhswknapHN2Amo1mzLlYGDBd382HljcjUmFnvqvUIUto7
XApvbcSGreyiYzcfwbjlrgNRDubo0yUMr+HLIXPFYlrliDkqX/kmI69HDmN2
3WmtcRbYlRWrcffgY+gpSnYI0bbE+MVY+fN3jyE12cpyqM4SvX888f5e+hM4
EB1oXrHfCj/LPRdaYdoL0zyJoF/JGidk4k2e93vhzQ+ub8f8rHHAjR+0xLMP
auz03+oWWWO5obp07M8+CJxk1Ggo2uBdm97cUFE/LHwRLBrYY4NZBdUVmowB
OMPSMRGV2WBagJs+/XkA1nhVyreq8vCm4OE/zjgIbVq+3dcO8bAgI0L1CR0E
h5zKxJf1POxQVxYrRA6B9vGR/bUMW1yUeQZ6Lw6Bv+Y+tfDjtqg7d/tkW85T
yHfbvEO3yxYP+SjODG6gMJ59/wTDiGCTmmt9sAWFK0Lj6XxjgtzO1NQJKwpW
6cFneKYEhwWa3HeEAiNtW9nODQQDCfdzNlD4sCz6ero1QX8WX+K3m8LbUUHS
Ej7BHc9OBzyOp8CX3HF+v5dgaU6d8f5ECkW8dFa6P0E1P4XXo19TKJFPznKE
BKXdYvHMBQpJYZYD9oEEPZqu3tPKpJB+6ktmXAjBbfn31HcVUGBfzxbPRxAs
CJob7JdQ2J2QqHQ5iuDSdY63goo//fIaL+nEEGz+rsUhspTCznaPWqdTBPGi
/NiVGgonA7ZkJsUTvCFgEuYvFOYOlwetOkvw46LwY249BZvbMfb5iQQbRL9/
f7eZAhlpUm1NIqhDjIM3tVJwaHNX8ksmmPDqmHl9O4WIIbXlL1II0pKS2W2d
FKavqmmfvkjQIfxVs1RKQRTrulElleB/jzUoGA==
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#9"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVxXk0FHgcAHBa2ZIjtcZMh8kxOXL7VVL5ftmxQmMTFRKxj9jH0m45q7W9
asIuEwrVvHVF7thJU8bRWPdU4z76aYvVtZSODW3Y3T8+76MbFLk3eImCggLv
P/8/Y+ih3yb+0v63IyXKTH8W1uZrM1209aC4omXpeCALv/BLKtLVtoZ1SW3q
lcEsbLaVTqlpO8K78Sx7bgQL1xT7aypp7wXHPeaMoydY+NUjU/1FRhCkbXMt
k11mIZ1bXf6J8T1YlL0WpgyysJjPj/qHcRrMPkQYm3iswS3CGKXG4XQYNeme
T/RZiw3Z6rlFilch2y9kw1aPdZg3tuOvjpP5UF3vGbHEaT3a5vJ+1fMrhpem
LpICdx0ce6WR4P6sDFLdHqc1ObMxqmZg66uwGxDqFu2euWkDVsaNZNf21cBC
k9GnrOoNGL381i/PtW6CNMjriq+FLj43VUzr4t+C9MwFtRyxLv7JNDBgym9D
bUVrZNY2PWRrfmI/VZXA1z6lN5+J9VBJ6GAUHN8A4aYSHVWuPt6etRjbGNAE
cdup12irPrZMHq/9IecuxCoxx9r3GeCbEIa94n0pREysVuGOG2CQU0Fa81Qz
qN3ukruFcvD6VMiRR5wW6Fjb0Sub46DNR8Zyc5dWmK38MNl+eiNmyOctB860
QWrodDufaYirzEC18U47SC2KLJ+XG+LAVHg1fdgBD5JTEgS2RhgZ2033anXB
shBepG+3EfKO6PXMb5NBLIfL3hNojK70XvwL73tQH2vsW/XaGNevvVFiJrgP
jiusJpNSTJA0nMovqnkAraJ9x911NqFAS7pSEi2HCXadbV/DJmRovDV20uyG
iLSwGxOHTLHBjnk9NK8bZLav4i++M0WPLp8w8c4emC73++iTZYbKqRfS8h/0
gHdLilKGlTl2ZURrVPj3woyua5xSpzkmLET3jM/1gsqZrM39URbIuxLxUZTc
B8Migee4siWqCH8MrjHsB+2DwZ7X/SzxhZy/2fVOPzjPnKgPrrDEIeedAUtc
ByCFOSkxnLfEan112dOJAfg8aNDOy8sKK6z6hcExgxCfLpt3K7LCjMJbNSu1
hsD83AyrZdEKk3yddWnVENiXKpugtzXmOd5774DDkJ/8tOpAmTUWpn23oo8O
w7nwxzxlZRvsUFfmK0SOwLEYw5CtB21wQe7qx1sYAfdLuwRbqmxQZ7b0WGvO
Q6g8XOxPVQge9lB8O2xC4Umket3gYYJNak71gWYUkodEBd5BBNmd58+/sKAQ
VdKfOfwNwUeOK9lzhAK+PCV4GELQj7B3M4FCeZ7d1B/hBA9o7yza70lB61qZ
3ctYgu6jsb69CRRO/r2MufQCwcocCefgKQqXe51V+ekE1fYrvBlLpJBf2bxs
eSZB2X0+/+1ZClezv12jlkXQpemSSFNA4cKAfa6WkCC3QKS+p5BCwO+7iVEJ
wcKA2eHBIgo/vT9aVlpK8LN1O64FlFDIeSMyMSsnKM1s3h5ZSUGc8LODdRVB
PNcTmiqmEDfqKt9xk2CuI4Mw6ijwzhqeb6wluLjgsyisp6DJXbXLUUywIebJ
xQophUSOymPnOoLrCSdwcwuF6f2rxZ0SgiemQ03r2yiMSPSyeQ0EaXn5DLeT
Aj20JVHeSHB72LRUJqPggLujPO8S/BfvZzrg
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#10"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVx3k4FHgYwHFiVdZZmXHPupoOt5+NGO+bsj0pFPvUKFFa164au4liU6mo
dnPsREkKicqxORr3pLGUq8Y1jH711KB4RHh6Vii2/eP7fJ6vUSDPO2iJnJyc
x9f+d4a9y+RJ1WYXt53iWwm3dVCQy9TexjQGJdFUcXyBDq7yu5hvxLQFQUV/
Y1yhDjY6iMZVma7AUlBdGl2ug7oF/pqKTG8IiL87FtKogz+8MjdZZARCkm2k
7fZBHaSzK4s+M36D8vrrlGmiiwWJiRHzjHiIXGHX05qri99nRSs+kv4Fu9uu
G1pU6aHwmlp2vvwNcNSeO/O6Vh9zZM5jLSdzQf916ErHWgN0yPa4ZexXAOGb
H/YYdRqibEI91vNdITzstu/5tZeFEWWSDRNhD+CY7cg3e45/hyUnBq4Jespg
PLV1+ouCEUYtr7w8ovUQPEDwszTBCEfM5ZPbEishlXen+IiWMQ5pm5pqi6uh
JqISHTONkaX5mfVWpQ6WtxYGqrFMUDFr05qgGCEoz/fnyEpMsPqTlWx1QAPI
Tt9jv7Q3xab3xwRHMx6Dllf7kGqLKU4FM1zkn4mAH5medWKvGQa63U5uHG8E
HxL+47TMDO+OB4e8MmsCoe+G2rHo1Wg3x1huua0ZsjGbO6TARr74i7Xk3BOo
OOjAvXqDjSssQOVRzVMoqgjfz7dbg5Lx8FL6ogUOD6QFBj9eg7zjndRbqw00
XH1cXPzWokeIcdcXx3boi2v5LBlfi+60I2aU2wGj7YuiP0+uQwO9B/csUp7B
pMr56su665EI43Lzy55D3oGlE3ol6zFFS6RRFyUGZesZU3Mvc2SoT6910+yE
JYsN7MgJcxRu1L4bmtMJD8z0lNTOWeCuNt+wKk4XxFZtDPiFbYlKSanJuc+7
wKC6rnm2wRLb+FHqxf7dUD4nfzWOa4WxC1Fdg7PdwEs66ye/YIUemYfnKi71
QGazVln1DmtUzjoVVMbuhUv7Ms0u5FjjqDjR3r2mF+bv/BHhNGWN/Vs5AUvc
JfA6zTewD2yw1ESt/e2wBHSFHZHZaTZYbNObFRTdB6KfvKfXvbVBfl5lmYZW
P5wMXoz9yLHFi3u3GtG/+2GDomJG3hVbzHHt+LgJpXBr5UTI1LAt5iUf+baH
SuHDO65XkosdtqgpJcrxBoChIk4oT7XDBbG7n8fCAMh7cW+mD9qh4af7kc0Z
L0B9f9dCrzPBA7vkp6XrKHQ5LDsak0KwQdWt/qAFhUNpluWTqQRZrRcujFpR
kOrPzwbzCb5y1WDNEgpBgtOZPukE/QhrhzZQcN++ytLiBsE9TE7+bh8Khm9U
U94UEPR8eXxvdyyFmpv/OHs9IliSUWe2L46CwP+pZ3MDQdXdclOy0xSqDVxD
OCKC7c8SE6fPU+DHpxaubyK4rSG9QjOFwjDn2JllbQS33K5Q25lHQdV/7kCj
hGBewCdpXz6Fug/50o39BBX0ne8E3KPwVLmUWyYlKLrS6MQrofCvoC8shxLE
hK7QpCoKH55v7j8lI5jtyiCMWgrn0kvPzgwSXFzwXcyqp6B/JcKeN0xQGP0m
rVhEIUGJFvqPEDQgZgftmyhIDp2PkIwS/H0y1Lz+CQV2ywknzzGCtKhoZksr
BYP7lSrN7wk6hU2K2tu/fgxniDNB8D9Ag0a0
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#11"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVxX081HccAPAjLxXnKXN35PmxdJ5/pxJ9Ph4vXlhZK5pIS0drqIlETROn
VtzSvJx1VhK1UJk8FPJQcR6v89Tpm4URLYpXvTyFbX+8X2+jg9EB4fI0Gs3v
P/8/a7HLpLnKfXtu2vqRNQPaWJHPZHkzjcFz6m3spkFt/CL4fKER0x72T3XT
/Ye1sWlL46QK0w28xld9mfVWG3WKQjQUmAGQpLxbT39RG70G2SYrjIOQXB43
SunqIJnXLP7MOA5ReS2uvBAdLOLzYxYZP0HuVnWd18M66CiKV3gsuwzfjRrK
JcvrYl2O6rVCuauQvLeg66qaHl4fdv5HfDof1u38WqLI0sct1/x+Nw4ughN2
UrWszQY4PKWW6P/mDmSmfmzbY2yIMWV9m6ci70HKorefsNwQSxMGcip6yiBk
kj5b7GGEcWsrL41rPYBjD4Sn09uMcJwtl9nGr4SQap8D/iHG+DfL1JQlqYa4
qdZq8sYYDTQ+G4zRa6C2fEeOS7QJKohcN4SfqoOzlapOj+VNsXrOZtg8tB7a
ixTOLV00xafvTlT8IGyAmGW3Lr6JGU4fZmyX62wEbtKbPKUqMzzoeSOzabIJ
znWYuzi6m+OtycO8QbOnIMhY9h0fMEeHBcZaa+9nkPq5OWhLpAVmSZZs+841
g3WCrb6zwgZcZwX0xw9bwFzQwHMXbcC+yaP3yUsxZE+t0ROzN2L0yeckQKsN
tN9zPzmLN6Ifz1i6tLUdXGdWiF6wJfqQjlMTgR2Q8PNC/V/vLFFv/b3bVoJO
cAlctfDswiak6s7kF5Z1wROnS9Uz+mwUaDWq18RJ4CK3RxJVz0aG2sxGT43n
oGt/Z+h1qBXWObFuRVx/DmdTk19FfLLCXW1BkVUuUpjenHspNscaFTN+yczv
koIJD48k2dlgW1acWklINzRf+TDl1WKDictx0pH5bmi52Z8S5miLfr99v1B+
oQeCLJ16U1JsUUn0Y3iZRS+I2cIMQb8tTkj4HJ+HveAlK+48bm6HL7guofI+
fdDAL5FaxNrhfRPV9rHRPhCWavbIWuywxK5XFB7fD0f3Zws8WfaYVVBZpq71
AtabqAfVRNnj+X1cI3L3BVC6oe4KT+zxulvHR1eUgctiGmtC0wELMqOUe4gM
fIWfAseOOKBYVZFPix6AGXdeWkyNAy5LfIL9lgcg5+PrsTt0CvXn/oh9JnwJ
qQwvt7WHKDywS25GZklA/8jIaP8DCutVPGvDrAiszqgQe1ZSaNCanj5hQyBE
uaHszyoKB93UDeYpArrh8VcyH1EYTBn4soCAUseObG4DhXuZLoV7viLQlR5/
uaqdQv9XJ/d1JxKI0Gk6lDdCYamwxuybMwTuNm6dpI9SqLKHNj2cTKB7vuFU
4hiF7Z18/kwqAfSXvxk4QaF3fXa5hoBAPNPIUfM9hR43ylV3FhA43tzqfX6B
woLQOVl/IYHe8lbjuUUKV+k63wy9TaCJJqbxlihsvNK0LbqUwLGhR20eNA5i
mjQio4rArdlAEU2Rg9fcGBTjEYEAumVe9GoOriwHrYhqCUz2vL8xuIaDdfFD
v5Y0ElC9vbuuRpmDepRZGOcpgQLutHSTCgeTPkSwa5sJ+NaffperykFSXDzr
0UqASeaUlNQ5uC3yQ2N7O4Ghb8OsEzQ4+C82wD3F
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#12"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVznk41HkcwHEzSRsxY60xDZJznLnm10H6fNIo1CjaLtGkXRXPWp7KuEqy
2w61xWzYapsKY9SKMitUTEWSo3JffZN0sWUetD2GDdv+8X5e/77N90QHhdM1
NDQEX/rfCW6gZX3lmlWRsxuqWzQ5WJ5nxPYzsoBqiTBdfz4HvwlJl5sbuUG+
zDM4SJeDtctrRnSNvCG1IVS7w5CDnMJd+ppGQSA7dEXWbcPBtf2OlrOsPWAw
7ffghS8HyaTBtc+sA5AYsL7+468cLBSLY/5lpcKxNOezDobGuFQap3m39zdQ
Ku/TO1eaoPKs3mU57QI4JQ3UfRtoirmDK983HMmDg4kthWT3Ilx+WXDJIqQQ
Tn5/ImxSbIaDKkZSwLsiCKzP0pkWLMYYRdcyVcQNEPGZ9q9fLcaShL6z5R0K
UJksUMbEmaNofsWpIcObMOklHoimWeCQIy2jSVwB273Xio7+boGv2VZW7JZb
4K2wM6BbWaKZ/meztwuqIEpVsNShxBI1pattwxOVIJSEJmfwrfCW2nnQRngP
PnMa0kJbrbDuQ2z5wXP3gYrlydMirXFsL2sV7UkNGFfrGsfTbHCPT35G7Ugt
1HdtVt4/bYNXRvbu67euA0xo3Zhjy0X3Kdb8JX4PQevdc0lVJRfPtEy7dP1c
DzbMHF/JFlv82gkW3L39CMaG+ifcRm2xa+SHUvKsAb7ySZHoHrPD6PhWEmTY
BNqlWaIHi+xRsM+ibXpFM6StZ8rlCnv0J48Th7c/hgOxkr88+A5oanzjqlPm
E2hkxO/sGnRAnjI5T654CjoqSD4S54iZhjXMKlELOH+8OSVY6IQsxridj34r
ePSFNg9UOqHSg31lf24rlF2sOB4csAQDm3ZEVHq1gcyc/cZ6bAlqnZZk5D1t
g8yCneradGdsOiNiFO9qhyGBVHeG4YJJM6K2V5PtMK+OMdYR5oKCP6Kmyk50
wMYLiz+klLigtvRouILbCcKAwpOfaK443CKm/G93guoip9R9kyv2rPMS0v27
wHfu+Rh3qSuWWuo1v33TBWuKtCO0x1yx2LVTGh7XDZ4BWuxscMMzsgoF07AH
pC/WzqNnu2F68Dpzcr0HBliOvs7Dbpjr/fif1dgLKaze/Mll7ijL+FGng/RC
suGp6hun3LFBT0usEd0H6s394ern7jjT4h8imOmD7qmcwHeOPFyk/vPQw3PP
4P2KgqTGVB7uDqSN99oTqNh69yfbdh7e0/WpDnMisDttS09GBw/NGtPShp0J
fIqZ4zrRycN+b6bZJI+A+E6eqq6HhyE8sw1sIDB7pPP8d/083GbkJd+6mcD1
A17ll4Z5GPA8Prg9iUD5gwvjHA0KS85VWe9MJiB7KXyUSqNQd6vG2GAKgVo9
07y/6RQ2PxGLx48TSOg7FnZ7LoV+93LK9DMJMD/1MYJ1KOTnl+ltkhF4mau2
O8+iUCZU93bLCRRrf1hFZ1M4x2RlgfAqgajYxm2RCymsyar1jC758i/mZ3uY
UIi/tO0/XUmgl2MAz8wpvOzN4rHuEDDQ4x9cY0nh7MyOWWk1gZKo7UVFVhQq
415mF9cQiJZxuYe5FJryrMOoOgL7sgYiX9tSeHh0v2N1PYFwiwTFBnsKybVr
E/xGAoeCR6fLHCj0jBitaW4mEO/rIzB1ovA/NKw0xQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#13"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVxXk41HkcAOBRaMlZmbGjXGPc4xi/X87x+bAkSgc9XTwp5aoNz1bYbNqn
VUMXZSqU0hC1666dlCuEZJy5Rt/sk0qHI+yKSuzuH+/zGgRH+YUsYjAYvv/5
/xmTzZym8h9cj10p1d9rzEaJmKXtzTIExYWNtyrM2bgiMDnPgMWHg8tKeCus
2VjvUDemynKHiq4a7wZ7NrLzd2nKs/zAWBpWbOLNxjWDlpwFZjB095rZjR1g
I/m8vGCO+RMESCat4kvZmC8URn9lnoBXSxTO5Ljo4OqsWPka2UVQyb1w4er+
lVidrpadJ3cNxqcDnN4mrsKbQy4jzcfEoH+H1yKfqYsO2b43DAPzYTS9X1ez
SQ+HxtXjN7z9A+ZW8F8LovUxuqzXfjyiBHyOqvczlAyw6OeBdEl3GVxc6jK9
5oYBxijdP/dO6094GX23qNLCEN9ZyqW0CO/DJplX1e7Hhvha28hIu+MBeL+r
aaT8OainOac3rFIJI1lF7Wf/4qB8lptpyNFqqKnNLqTijPDBrPWQcdAjGGbl
o8ISLjaMHpEcyqiF43I63ijm4mQo01WurQ4OsdZLmM7GGOyZk1I/Vg+tpk3X
lZ4a4+2x0LBBbgOU6znMng4xQbsvTCUr70YwG/hiaDhjgmkd32x6E5vga+Sb
63svmeIyHqjUPHwCHhNiDy9bM+wd+7GUPG8GxX2NPrx6M4yK6yR+Wi2wPXQi
4+Uec/QNM+z65igFwYfg9HOfzNGHtB59v70VNrhWxDcmWeAqnZI7vNQ2WJ15
JuejiSVS1QnivLJ2UKjbmDhTaYmpWnUalTEd0LNtn5FyEA+Z6lNmnpqd0FyS
JJLM87DaSft2+M1OOLVuozJXZIWbW3ZElAu6wPix8mDVamtUPH8hRdzeBRU9
y198126NLWkx6oW7nkFAmI5SGN8G4+djul59fgYpo7GTo7/ZoO/Vg1/une6G
KVGfkkuHDSpnHQ8pM+mBi45hax05tvi+Q0j7POwBQfFX8adoW+z3EgQt8ukF
1VCJfniVLZZy1KTDb3rhqoMznabBx0LbnqyQ2D5YrJi/9uAuPqbl3i/T0OoH
I7F+ptJdPibv9DIgxf3gueVvlR2KdnjTvfUfN5SBwlZBrecWO8xNiVzaTWQQ
FD40PnfbDpvVFIWMqAFwMjl70mvWDuc7fAJ95wdgXbFIZLuGQt3Z3w83ZjyH
yNTihZFMCndvlpuSmRNwZcy3mX6g8JGqZ9UeHoFlqQvfTo9QqPc0Kem9NYGz
lL3N2CiFg+4aep8pAqEDntdLP1IYSOmt1wYC/gek2U7TFG5jCfK2+hPY/YS4
+jJo3PAibuezeALzTtOyw0waizIquQEJBA6r+EX2sWhU3cqYHPqVQHJRq4LT
9zRK24TCqZMEZg/pui7o0Oj96PI9zVQCGhGa3ckGNHrk3FPblEvApfaK6IYl
jblBs7K+PALXLJJ3LrKicfFKl1tBdwgcuHyOE2JNY52o3jmqiADniLTanE8j
nuoKP19OQEWoypbY05jtzqSYFQTquSdmtR1pXJjfsZBVRSCuc/FAvBON1bEv
LxXWERj2t8hzE9C4iuLuoRsIBBS0p+a60vjLRLhlVRMBT62EhCVIIykomPF4
SsC+nY7a70ajc8REnVRKIJ/9KbjVncZ/AXP/LqI=
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#14"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwVjms01HkYgM2k9ljl0jKmkWQwyH3MvyzG+6ZmiwwZe2zJmnIIW2i3zW26
7HYbal3K1lKJkaQYRW5Ro8aRcr9kyvit3bQpW2xpO0a5bPvhOc+n55zHIiJB
FEXX0tISfuJ/T9kEWbbWr/P2aHpn14gsrC0yYfqasIHmXruJI2ChUVh6iYUJ
F1wCdu055cvCZnfl+BITH+DJapTRIhayroQbapuIoJe28KRRJAu/GnawnGdE
AHO7uDxeykIy/UX5DOMHGFx3BK27WHhFKt3zkXEYZiRe7AvbTHF1fpJ20+Bp
KIMWK2nmclTk6hWW0C4Aq3LhGrHcDGUjXq8eHigCNff95eH7K9C9UFjADrsC
/6x8GpWjMceRCX1JwIsyMA2Uda44uRL3VKnWTMTegJm0bO2VHAusSFHn1j6q
AtEbaWq6wgITdeoyXhrXwE/OHO0Jfza+dKBltUvroF/n49e5L9j4F9PKitlz
CwKXlS3wTrZEc8MZ89HFt6FmfUSe/yIr1M5faxuVqgAj6TVoLLTCWxrnEY74
LsS39Waau1pjy+t9tXvz7oGA7t2v6bTGtzsZ3rQuJWQEbg4VxnAwQnApq3m8
GaRM/8kMDQdLx3dGD1u3gMD0YqP4jA26fWDoOPneh6EtttuYtraY0zProjra
CrrdF3WTW21xqSMsbmp4AMbLjgZsibRD1fjuSjL0EGLoPhyDKTtMSO4lIuN2
aDukt/Hk2VUojGb3zX7ZARMZz84N2NujH+lMHdvSCe5Tx7qzFPZoZnrjqmN2
Fzi2h2tswh2QpzhYVFLVDTkNfY2Sdw6Ybaw0uJ3YA/Pq8x7KM47I0J+0Exj2
QmqzmeIw5YQKD2ZpjKwX9omeh7xsc8Kg9q2x9fw+sCn9JXVrnDMuyjyVVdTd
B3EgkVXSXbA9J1FfHt4PRrwF7GihC0rmEvueTffDvaHw/fKLLig8H/eh+sQj
sHvfdP3m3y74ef6hqCqbAdgUkgLBfFcc65FSfg0DEBZZlFZ2whWfbOCL6X4q
KLp5IlKucsVKS72O0ecqkEw3nA2y46LcdSA/KukxHKnJN5IlcjGnuK7KwPgJ
LBybr8pr42J66AYLcv0JzNR1LvM0c0OZT+e/a3EQUlQP/kz5zg2Ls+J1H5FB
eLBbyY9RuOFDvUVSrQQ1qEvd1r5ezMO5Hr8w4ZwaXqQPFeiE8nCF5tqP9/OG
QMK8xx2S83B7EG1ycBWB17/tN6RmeHh3ieDODkcC6bLLq3NmeWjelpY25kyA
1AeHv53j4bCPgfk0j4Cwy6tGTqMwjGfuzwQCxxXcnzmfUfiNCb8kJJiAutrp
FHMphQG/J4f2SwgwNLEZczYUVuTdtt52kEBFC4v+rR2FS0K03o789KkXe6c0
rqKwo0sqnTxGIO7qUHyyI4W+d89WG2YTWL4rPGmSS+H6S9V6m4sJXJ+nz47y
KSwWawYflxC4ZX8+VwAULljudVl8lYDuHxdWFyOFyl+bPRMqCOhL1Sk71lGI
x/tiMusJvJI6mZGNFBb6MHiMRgKCc/QODz8K5+e2zuff+fST5nkgbxOFiqSn
Z+RKAv6ywdGQAArNeNY7qBYCwwX8gppACve/iXG400rge7Z2qFEQhaS8fGp9
G4He0w4me0UUesa+UXZ0ELgZWqvqDabwP/l4MzM=
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#15"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxXk0FHgcAHBKKmWGLUOT+0gY15gfVvh+02EJy/RoXSN6ri69WhSbdrsG
tbGkpy0SIkIR4whphI0hlLMfCVtUEq8tOtjdPz7voxUUwQ9eIiUl5fqf//+k
76HTUrXFviBran2oJxtF2coqTsraEN/Y3T/izca1fgl5WspcWLNiRbqPgI2N
1uIpeWUHqI0JV3MLZSM7X6Aoo8wHv2yylRxj4/Zhjs4iKwgSMwOWymSwkc6v
KfrKOgwTKb47c8bZmC8UHvrCOgn9LvUXJ4+sR8uMaJn7AykwJMdoFhWqYn06
IytP+ioU2lsnarar4fVR2zePjmfDuoNpPyi8VkfrLNdr2n750KTk4yNiauLo
O2as26tb0FS8Rc8ySxMPlfVavQu/A2Gcjrl5Wy0sOTaYLnpaBqKq+LcKfVoY
tbLy9wmlCoh79qJmPkQbJzjSSW3CStBnfqiwWaqD4yq6uiqd1ZDTRZtc03RQ
Q/GrxsvVteDLeXisXFcXZTI2bwyOqYcVTuLPwgZdrJ4zHd0Q0AAZKUYsA74e
Nr2NFB25/ADm2gv3OL7Xw5kQlr10hxhi7nTXtpzbgEHbcpIapxpButDOgKGm
jzenQkKH9ZqA+3zf9KsafbT4zFpp4tQMnvZhJafcNmJq5zez3tMt0KsvNdP4
biN+Zwyr79f8BXFd3L17zxtg79T+UvrsEZx5XTXWrGGIEUe7KF+pDRLSiezw
fUN0DdXu/va9BJ4vu5Wa62mEzrQ9ZvKndpiaV4CHE0aotv5OgXFyB5y4W37i
bjwHefVx2Xllj6G6LF3ioG6MyUpihdqoTsg8H/O1tMEYWcxZg22KXXAD9tuf
3G2C9TYqN8Oud0Hd2O2RkX9M0KPNO7zKrhs+GLYOcdNNUfbCH0nZj7uhMJ9b
K6Nihm2pUcxiwROYDp7uuxRkhrELUd1j809gbLKCf+uuGbpeOfC5PPEppCke
5x9dNEO5jBPBZfo90NMsEnR4mONkp5A41/SAle8y775Mc+x3tAtY4twL/kbr
rv722hxLdRiSl3/3QqX/vY/3bLlYbN6TERzdB/FVsxWZCVxMza0sU1DqB/be
nBHWEBcTfBy16O1+YF7cWWFqaoHXHdo/bMYBuIRhS17GWmBu0sFVT+kAvNkT
IrF8bIGPGLJCqYhBuFowvaCuxsOFTmc/14VBMDx9o+FKOA/V5wp/br78DAzC
pjNFtTzc7SE9O2BIIcJ7+z6BHMEG+W11gcYUGgSWwdWrCGq0xsdPmlJYc04z
cK08wWEHBY15HoWZlBeCViZBP56GiwpQyJldedhSieAuZbs8r50UuDuSPzI0
CboNHfV5Ekth3IYf+YAQLLlcq+cbR0FtvKBY1YqgvJfUzOivFGwCp15FWxOU
dAiFs2coiJdbBplsIujUcKlcMZmCp9eDA1eQ4NaccoZ7LgV9e5+RyB0EcwPm
BvryKFwrtbbqciG4VNX2RkABhYWyL0kcN4Lii42bIkoohJ8zdhxzJ4hnu8Mu
VFE4K7aQuHsRzHJg8Vj3KPj0GHCLdhFcXPBezKijoCqR+nO5N8H66BdpxWIK
ckk/RtT7ElTj6QWSJgqDEc10nT/BX96HcepaKIz4q7pECgjSoqJPW1sp2I+5
13UGENwU/l4skVCQTdxjxgkk+C8bWjrl
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#16"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX081HccAPBT8no1DldzbifP5ynk6X6tFn0+kerolHrtysO66OXhYjHl
VKRWOGqhtI2ZJYmUx8tCIfOYPHQec3xZUfKQkqxQse2P9+ut7xuyx28ZjUbj
/+f/P5i4GzaVO22+3jV75aofG+9mabJ4mgawymOoiXOYjV96J+Toa9qCwZnU
T3lH2Fi3oXaKrukIR2Tngkoj2MjOPcBQ1NwDV5w8hc0JbNw2ZGG4xPSFwRRO
5rsCNpL51fmfmGEw/WRNEu89G3MlktCPzLNwWrVf9DFOC9dnRCg+kF+GWU9G
eXfNGqxOVc3MUfgd3uDzUOVRbbw2bD/ZfCoLRJfT3xas0MUNmfyrBt650O4e
s2NWRw+HX6tFur28DTxTj5HaYj0MlfZ+/VpUDNN6op1jbvpYeKI/9W63FIKN
PjruntBH8cqyi2Maf8JpT9F9UaQBjlkoJLVIyiDf9fXjcZYhPmdxOCxZBcTF
fE7RyjdEXcYn3VGVSjASLuxMtuegYsYWU7+T1fBuVXBHpJyDFXNWw8bCGqD9
1vOjRrARNrwKv3s07S8YMlzot1U2xrf+zM0K7bVAF9wU/5FrjL7O15PqpuqA
UaIlkG40wZtT/gFDRg1g2XcHvfpM0G6BuXIdrxHMU1rW5wWbYorss3VvTBMo
O9YVpdHNcJUlqDy49xA6NoUXD9w2w96p4BIy0AzKIUr7K2AthhzvIHs0WoAW
RB9xeboW+QEGnZ83tsK5pVMTYWJzdCFtJ8f3t0GR6ajt8EoL1NYqzrNMbgem
U1Gzxi0L5FZHZ+VIH8OofkBbF1hiskateqVYBqFJsRO+w5bIVJsxc2Z0gPTO
jjg4uw6rv2HdDLzWAd8+MytJ1bRC9xYPUblDJ+ya07HvrLBCpcRLSVmPO4E7
WSaoMbXGlhSxWsGBLniZeyh//VFrjFwUd47Md4E874Qip94a+enfL5Se74bE
6Av69Wo2+EXGaT+pSQ/E0z2jn/rY4LhMQrnc64EDxgKH24U22LfdQbjMpRcC
OtXr1RdssMRQtXX0RS9UbT7ImHO1xQKbngy/iCfw6zsqKjbVFlOyy6TqGn1w
+aV8IHXSFhM8t+uToj5wbbwRt83BDq85ts1uQTnsCn9aeSnBDrOTjih3Ezm0
xs498yd22KyqJKGF9APPrV3WbcbFRZmLN3+xH1rf21/oCueiztytY41pA5Bp
G6YifMjFg+4KM/K1BHJ/iNWJ1KCwhu5c5WNJoPjhRHoXk0LdR/Hx41YE/HmD
bAsWhUOO6rrzXAJVhwK1B9kUenN1d7KAgJk9nQI9CvdpOuQI9hI45uJUuNyc
QrfB455dkQTEG181XEQKC9MqjbyiCTAtecdGt1BIF9DeDp8hMKpiygEnClvb
JZKZWAIxRofjp50p5NX8UspIJsBv/Md3ryuFW6+Xqu7OJpA90y/8SkBhtnBO
/iSHwIo35sZh+yhcvsb+hjCPwE8G81OP9lNYe6VuU0ghgaYHSmejvCjEuM7A
xHICr+qf3//7IIWZjkwu8z4BeTA9cYMvhUuLHksZVQQmg4p8Lh2isDri2c8F
tQQCFr+jO/lTqM018qEaCHDkohfpARRGTQdaVDURuJU2VT0bSCHJz/+w9RGB
qJGxNP5hCjeJpmtbWwms9vQS5wRR+C+ayT3G
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#17"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX081HccAHDKtFZEzbFDh3MeLsLd/dSKPp+u5KFOoiUPc6OXohWNOklF
Upd6FdPDS5sT4mRRuQyVo45qnKc7R+GbSuZhSw9ejUhs++P9eltGxPpHztHS
0hL85/8nbLcwH1evWxPI930dFEfHygJjE29jK+i8mWA+LKLj16HpUktjDryQ
6fmJkuhYv1IxqmfMh8nDx+9kpdGRXhxmqGPsDwJXmUR5iY4b+hyYs7QIYDyY
vu5+j45kcknpNC0Oqic8h6x0TLFYLN73iZYKdQMSg7GLpugqSdCp686CbZKw
Y05qM6zN1s+TaufAiTMDLdmT5pjf7/Z345ECoD2YuzXIlIEr8wRXrEKLIf50
1ry/2BbY/2ZRku/QdRDd3hpcJ7fAfbKuFW+ibwHwrVynQi3xRmJPdqVGBtZj
gtzdk5Yoml91dtjod1i26opN/BkrHHbQzlCKq6A1riR31J6JAybW1ibtd2Cp
UXmwVi0TGYbTjMGFNdBm4v7Ba7M16kjW2kUeqoX9DTJng1FrvPPRqd9GeB9K
0ze83ZPCwoevD1TGX34AAR3DUf4WNvh+J22NdqsCApuzc0VyG4zwuJpRP1oP
iULV7WV+tnhtdOeuPtZD2PHC1S7hrS1yp2jzl3s/gvjGkH/80uzwfPtn5660
xzDdo3NbybLHxY6wsO7uH7B4gVQubrDHrtE95aS3EcSbHBVN29kYe1BF/I2U
4B8xFFQzyUbBLiv152+bYTmleeacuQx9SMuhke0tMHohJreP6YDmprdKHDNb
oegiS+PZ4IC82qMFUlkbJC2OTGYHO2KmkcKgRtQORaVZJeppR6QtGrP3MFTB
zd4l49U5y7F2lcm1qHwVlPGud+lxnHCLMii62l0NPZWNHJ7GCXXP/ZxR0KYG
f/2VmS8pZ1SeFy0qC+uAgL2VdH6KMybNiNSvJjugxkcgN1A5o+DXvVMVpzWg
mujMP2vmgl9JkiNltp0wf9/43cMxLjjSLqZ87nbCSOFsIe2eCz71dBfO8emC
g2Pebht0OVjO1G8e/LML5k6FhL0O5GCZS6ckMuEJHEo8oHEt5OD5wiqZgdFT
aJoyM/80zsH0YE9LcvMppAr55Vu9uJjPb/mwFrtBP6fp+cYLXCzMiFmgId1w
xat6tm6Qi436umKt2B54U3RmpoXLw5l2n1DBTA+8GuzXRCfzcOnH3/Y/utwL
gV7KJ2kqHv6wRXusm01gRdm4B3cphff1POThjgTGWf1t6QwKGU2nTo04EWCv
+yLkhQWFfXwDxiSPwMmA9/vPMikM5TE2mQCBNFZQ1ZAdhYHG7tJtAQSSuGxR
DpdC32cHgzuSCMwrH+jW9abwxuUaVshRAsoUt9Pf+1Cot03rfX8KASazfnXF
RgqbW8XisRME1ilCCsJ9KfS+f6nCMJPApV9kR2oCKFx/tULfr5BAokH1nrgw
CguFH7ufSAkkp/Y6NQopnGvmViQsIVC8yf4DI5xCxYX61bE3CHAa+SktOyjE
k+qoc9UEYpMjpXbRFObxaTzaPQLftHXEJe+mcHYmaFYiJyCkdmPXjxTWJry8
WKYgYG+t//x4DIXmPFY49ZBAvanprZ5YCg+/i3KQPyZg++XmVJefKCSlpRPr
mwg05JV8dyqOwtXR7xTNzQQ+57DZz+Mp/BenxD1t
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#18"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjnk41HkcgGfKtmlzbRmzwuQ+cgzmJyV9PpR6spkylTbZNORqlaN2KCX2
WU3sriMlKls0i8oRSZQrkpyJZsbwTdJFRXiUm60/3uf9632eV9sriOezgEaj
uXzlm8cNXXXrSzes5/Bdc9xOqGNJphpzi5oOzMfOvfsQpY7LPWKztNWsQLu+
wSg6Rh1rbWsGFdQcIUlUkXczXh3Vs/epyKnxwOYzu46WoY6bekx15xleoPfT
F5ObdepIJpflzjBCoWrwmJSmtAKzhcLgacYfELbOqbcgYwXapIfJVcnOQuTS
KFHLCw2sTFW8mkW/DDdCw/jDi7Uwo2/dh4aTmVDlIbVxN2Wh7VWXKzoe2cDQ
cojaylmJfUNKEdx3N8E7bmTiU/1KDC6SrB4KuAUHNIWxcv7amH+sK7XkWRGc
Om8RuvE7HRTI3/2nX/UO6HL9Ehen6mC/KT2hSXgXuDVp0ZtX6+Jrpp4es60M
SvwjHi5p1kWWygzr7dJyCGnRuDL5qx7KpTsY+RyvhJ/HpBsOzehh2YRFn4Fn
Nbix+MreifpY9/H3kiNpD4CsLzv7hm2AI76M9fTWGlgjC8m82GqAXk7XEmoH
ayE695VNK98QcwZ9/Xr066BOezuVRjdC6ymGvPmWR1B/Z6S8N8UIk9tm2ZI/
6+FCnMdkva0x/mgGS6vuPQYVu38fvZIao2QwsJB0NwDzYsxOQaAJBoU/JTzV
JjA2cXC+rbAKXfx02mfXNIOtdH+7t2gVOpOW4wO/tMDU+78uONqaouaKW9fN
ElshkrejV9xpipzKyMysoifAvB/JFR82w0TVGuVyQRsk51SsTFIxR4bSqLGT
ylMYeXz/+1OF5li5lpnjn/EUluUfiWvbZIGuTXsCSu3bIX65muxdvwUuik9K
yHzSDqO/MRdZIBubkgVKefs6oNf4niAyjo0Rc4L2V5MdoBFzjkZ1s9Hl0qGp
4rhnUD2t4JhiYIlL0k/5FBmKwf5CuoQfbokDbULK+Z4Y5G2OBYkfWmLnZnvP
Bc4SkF8YWNylZIWFuorNb99I4PN0ym0XvhXmWYrTfcKkIL3TesU7zwqTRXeL
lFU7IYCylA3MW2Gs+2ZtUtAJ4xfHQuiu1pjh2DLmgDKIK5DeKrlsjaKEwz88
IzKIzi4r6BmyxgbFRUJaUBd0e874ZthxcK7N2cNlrgsC50+IPp3moNbEjaOP
0rrBfsEqr6JODu53pY/KTAgczLR7vESfwmoFpwq+GQEJb22jpwGFrMYzZwYs
CDz826yl2JDCHkdl1iSHwPsHw+J9JhR6cFhbmUAgif16tMiCwt1q9lluOwhw
p7jue9dSyH0e7t4RQSCYXfg8dxuF+Wnl+nsjCUSbS2bprhQquNFG+qIIeDf2
a+3mUdjcKhSOxhComBZ703dRuKU6pVglkUCZbuPELncKN14rVtwu+tp79XPn
D1Ao8pyQSbMIdAw1n9zpS+FCjXX/eV4nwD9/Ke+6H4U152rtgvIJLN/2RWnn
QQrxdLt/fCmBzxsuvcgJovCqI4PDuP/1P6RRdS6Ywvm5PfPpFQRg7OXWHaEU
Voa9PJ9XQ+CcakPF7FEKNTn6fKqOQIxj6jhPQOGJYX/TinoCmi+5VjlhFJLc
3PGNjQQCSz8emg2n0C5guKa5mYAgIeQG7ziF/wMJX0Pl
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#19"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0H881HccwPEjSY1Dy53HicvPpOP8uG8k5/2mJKKlGatZ6kxIpVpRLinJ
qUeFfli/NIcOLRYu1JDOkNzp/Hb55PFI+blYWSsU1v54PZ7/v0wFMVvC1Wk0
mv+X/vfj8gDzxsq17q+sS3s5ySwsz2Ea+jDNYIf/QF5jKguXhJyRmDIdIebN
5D7BeRbWucjGdJie0LX4z/lXM1nIyt+ur8HcAtyNn/jzClm4vo9jPscQQJIk
TqVSsJBMfX33M+MgKGIna0VMI8wXifZ/YiTBhr9PHxq8Y4SrsuI0Hqkuwqmj
L00SRpdizVV6tkTtJvhdTnGfXmKC4n63v5oScoA271RLyWo2umT7/2oWkg9l
33XmF65Zhv3jusJNQ7+BW7S8f/zZMtxf2uU8HnUPTmqGeRfvN8Xio8+vlneU
wgE2qmfQzTB2YcX5YYP7YNk6ETAsNsNhjlpas6gCtMvf733sYY6vDS0sDJUP
oKDhBU+32xzZ+p/Zg9pV8MFYI/lElAVqZHlYh8fXQOBGrwNCLUt8MMnttwqt
hclAZdDITUusf3O4/Odrj2E06Zz+EN8K3+1iuKu1yKD8VvJTHWKFAq/ctLqx
OhBH24nzYpZjwdiuiD7LepiL55S161qj0zRjoZ1PA6i8sgMP3LbGS8oZ+67k
RnBtNC4r8l6Bi21B+9HDJ+Dq+k3ekqEV2DW2p4T0NoHmBO/GgNAGY460ki0G
zbCn7yfpj8Yr0T/CrG1mtRx8/UMC+dKV6EsU8SPfK2Dcb3665wYOGhvdK7RN
b4EZt1TyYZiDvJrjOZLSZ3BLaU20E20x3UCmVxWrhBL+EKvH1A4ZuhMrvPRb
IeDk6qnmx3ZY42pYECluBWNncTcrmIsBzVujKvltwOaeDrKa4qLmhYy0nGdt
MK1lmLFugz02X4rVLdreDkm3UjJTLtqjcDa27dVUO7jcGXO2eWWP/jf2TkvP
doBeXFPTYTsHXJSVGF66vBNqBJJEyxMOOKIUUb4PO2FWcHKBUO6APd78UHXf
LphQaTFDmY5YYk6XDw50wVYP9ofCSEcscujMCo/rhoSIywWZUke8lFdRqmfQ
A1oh+dw3mk54Zpu3Kfm9B46ZUOrKYCcUeyree6AKgqsNkwNynTAvbd9XHUQF
g/qHG/j/OmETXVNEi3kO4baq6HoPHs4qfUP8Z5+DYup9fdc5HppM3jnUcK0X
muJXYWAfD3cEqE2obAgYlGVYRNlQWKvjVb3TlkCOhtY/VSspZD9NTR3hEuhz
dpfp2VLY56nHnuIRCPllRFDJpTCEx/YzBAJnkp2LFlAUBjP5kqBvCdzcfDZc
AhRuenFkW7uQQN1kb9jrQAqLr1VZ/nCcgFA87eMSRKFOEO1d/wkC96rb7c8F
UyhvEYkmThMYyJbSeNso9KnNlOqnE/Bbyyk8FUrhulwpfXMegUUR8qXmuynM
C51UdUsIDOUk0OOiKZy31O12aCGBHemDtOY9FMou162JKSZQ0dI3dDCGQkxp
i7xQSSBsJqxGdojCbE8Gj/EHgapRxX1GLIVzs1vnsqoJGFmNF+2Oo7Am7uWV
IhmBGx2bsxfHU2jMs9xJ1RNIGr94fZeQwmNvIznVjQQ+55698vAYheTu3Y/r
nn7588Q5g36cwjVRb2VyOYFRu+vnBYkU/geMuTu9
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#20"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX081HccAHCMtjwcVu50Qh6OzvO5+5UWfT4ei6VCK8lYinjNUBZyeZha
J5qHbvNiubqkQyGZROWIhJxnLupbNswy6YXqFQ1t++P9ehuFRPuGKikoKHj/
5//fm/uYtNW5bvORtWr7ZTCxtoih68kwBvV6V+58FhPXBp6TGDHswfHxsa9y
hUxscWie0WC4wH6v3y/2FDKRWRKkrczwhUbftZydN5no8cLK5CM9BG4suSW5
DzKRLK4pX6Ifh1g/S7GDgR6WCAQx/9DTwM+MZmlUrYebRPHKjSMXwNXshHB0
fj1K82liiWIh3CO1KZEGBnhlzHG6I6kI2lnTM2w3Q3QQe182DiyBxIeXxmKc
N+DYa03+rr9uwG9eTDVKvgFjquWbX0dUQaC5Ij8x3ggrTz7Nrx2shumzzQtE
xxjjVt/56aXObYirp7eXlBnjSyvF7E7BHVhxFpNFTxOc0DU11e2th8xyjb01
oyZoqL1kOKl+H/gWGQrnj5uissh5Y2iiFMKYy2vntFlYv2A7ZhbcBBLbnZsb
JCxsfXWiNrbgATzYoVGkt8MM58Lo2xS7m6Fv/1DGxUkzDHG/mt0y0wJ1ifZu
qYnmWDoTdvQFqxXa1djPl5kbkfuBvtrG8xF4jjvQRqs2orB32U5+pg00oqe3
BPmx8XNrUG+82w7+mipGCm/YKJ+JvEWedYCq/JKWUroFRif0EV+dTng1tie3
lG2J3keN+5e3yIDhasGqaLJEL9KVOOXfBXqmjOzevVaor1dVZp3TDRdaolsu
vbNCnjS5SFLdA6pv4xMeZVpjjk6z1v24Xqj04feJbGyQrjnPdtfugzhnCMrr
tkHpF7ql4Vf6IKfgHXv8sC36dB6IqHPqhw62bvW8kh2uysrNLurph4VVKvzC
XXbYKYzTrAgaAH3p7MJAvh3yV+L6xxcHwPSU5cPwKTv0vvjdh5qMQWBO9Ptc
5XFQVZQSWm0+BDbj29lOZzk41SugvO4OweiZH9bx+zk4vN0pWMlLDgspXKa7
vj3eMqHJJv+Uw2i7VlJMlD1WcIZEofFPIJnjIXe8a4/C4jvVWjrDMJsVbB6p
zsVzAduNyM1hSKu7fcD8ay5ecel664wj8KtLoUtqKReLs6PUBskIvKn3v+b0
gYsdtFUCheinYK2rMpfnwcOVXq9A75WnsDt1w5mEXB4aLFz//lHBM7hsoHKt
cYyH3/gozo9YEHAVT+RctqGwScO94ZA1Ads3qlHzthQaPk5Pn7IlkClv+9Kd
Q+ELFy3DRR6B/Dbl1dNcCgN5hjt1gUCPWJCxaQuF+xlOkn1+BGiZwrIuVwp3
PU8IGOAT6JsZ2rfkT2FlwX3WwWQCASnnPXYHUKixT2FuLJXAyaChTUUHKZR1
CwTzPxIo5euv2xFEoWdTXo12DoHr356eEB6m0O1qDW1PMQHOqCDPMorC4uCF
kScSAvEMv+zkaAo/We94LbiMwPHYyvS+GAqbf27ZGl1JwFtNJyk+lkI82x+e
VUdA9rcosiWBQrELnUe/R0Dn2GQEPZHCjysHPooaCGgoS49G8CmUxv/xS0Uz
AbOH60I1kynU57EOUa0EnG+IjoSkUHhqNtyqoY3Ap2uqjtxOpZCUl793e0wg
YnhP6GdpFG6NmG2WyQjsHk4JO3iawn8BUDwt/w==
       "]]},
     Annotation[#, "Charting`Private`Tag$21402#21"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.4499999908163265}, {0, 23}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8732652374168177`*^9, 3.8732654551169996`*^9, {3.873265499963735*^9, 
   3.87326550921309*^9}, 3.8732655821360917`*^9},
 CellLabel->
  "Out[456]=",ExpressionUUID->"c82fb120-622d-4403-9b53-f2a705f533f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d2", "=", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "90277.12045089614`"}], "}"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8732655865889053`*^9, 3.8732655902136555`*^9}},
 CellLabel->
  "In[461]:=",ExpressionUUID->"b8d50964-9e11-4bd4-8a10-aed6a3d019b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"t", "\[Rule]", "90277.12045089614`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8732652374168177`*^9, 3.8732654551169996`*^9, {3.873265499963735*^9, 
   3.87326550921309*^9}, {3.873265582386075*^9, 3.8732655907917423`*^9}},
 CellLabel->
  "Out[461]=",ExpressionUUID->"36694cc0-6361-4d69-bae6-e59a388ee758"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "313227.5325269686`"}], "}"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.873265543101369*^9, 
  3.873265549804031*^9}},ExpressionUUID->"cb12975b-11ca-44e7-a659-\
f741149e3ae0"],

Cell[BoxData["10.`"], "Output",
 CellChangeTimes->{
  3.8732652374168177`*^9, 3.8732654551169996`*^9, {3.873265499963735*^9, 
   3.87326551160355*^9}},
 CellLabel->
  "Out[430]=",ExpressionUUID->"b07ba2ee-ce28-4e30-8f15-0052e580a20e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"t", "/.", "d1"}], 
  RowBox[{"t", "/.", "d2"}]]], "Input",
 CellChangeTimes->{{3.873265125554089*^9, 3.8732651386469326`*^9}, {
  3.8732653148645873`*^9, 3.8732653174581575`*^9}},
 CellLabel->
  "In[462]:=",ExpressionUUID->"3c71999c-74a2-4301-988d-e0563f3318aa"],

Cell[BoxData["3.0094877145942065`"], "Output",
 CellChangeTimes->{{3.873265307224473*^9, 3.8732653177237473`*^9}, 
   3.873265459247793*^9, 3.8732655936665454`*^9},
 CellLabel->
  "Out[462]=",ExpressionUUID->"2bb8bd42-4dfa-458b-af42-c56e830f2d0c"]
}, Open  ]]
},
WindowSize->{1280, 754},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.4 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 478, 11, 163, "Input",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],
Cell[CellGroupData[{
Cell[1061, 35, 7131, 211, 1763, "Input",ExpressionUUID->"446694a0-1345-4e66-8365-1f503ea7420d"],
Cell[8195, 248, 647, 15, 54, "Print",ExpressionUUID->"dad7c685-eaed-4dfa-9375-bb3868cec75c"],
Cell[8845, 265, 711, 23, 108, "Output",ExpressionUUID->"6a5f7685-8aa8-43da-a36c-d42e4eb6d38e"],
Cell[9559, 290, 41348, 737, 629, "Output",ExpressionUUID->"c82fb120-622d-4403-9b53-f2a705f533f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50944, 1032, 314, 8, 146, InheritFromParent,ExpressionUUID->"b8d50964-9e11-4bd4-8a10-aed6a3d019b2"],
Cell[51261, 1042, 347, 7, 108, "Output",ExpressionUUID->"36694cc0-6361-4d69-bae6-e59a388ee758"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51645, 1054, 287, 8, 116, InheritFromParent,ExpressionUUID->"cb12975b-11ca-44e7-a659-f741149e3ae0"],
Cell[51935, 1064, 234, 5, 108, "Output",ExpressionUUID->"b07ba2ee-ce28-4e30-8f15-0052e580a20e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52206, 1074, 301, 7, 140, "Input",ExpressionUUID->"3c71999c-74a2-4301-988d-e0563f3318aa"],
Cell[52510, 1083, 247, 4, 108, "Output",ExpressionUUID->"2bb8bd42-4dfa-458b-af42-c56e830f2d0c"]
}, Open  ]]
}
]
*)

