(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15816,        412]
NotebookOptionsPosition[     14929,        392]
NotebookOutlinePosition[     15380,        409]
CellTagsIndexPosition[     15337,        406]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8726603655960217`*^9, 3.8726603718455667`*^9}},
 CellLabel->
  "In[1276]:=",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1900"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "920"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]iz", "=", "0.036"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cpiz", "=", "800"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]iz", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "0.45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diz", "=", 
   RowBox[{"15", "*", "cm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prechod", "[", 
    RowBox[{"odkud_", ",", "kam_", ",", "kde_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "rce", ",", 
       RowBox[{"strmost", "=", "100"}], ",", "sol"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"rce", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "-", "b"}], "\[Equal]", "odkud"}], ",", 
         RowBox[{
          RowBox[{"a", "+", "b"}], "\[Equal]", "kam"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{"rce", ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Tanh", "[", 
          RowBox[{"strmost", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "kde"}], ")"}]}], "]"}]}]}], "/.", "sol"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prechod", "[", 
   RowBox[{"1", ",", "2", ",", "diz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"diz", "+", "d"}]}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2.5"}], "}"}]}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rocepe", "=", 
   RowBox[{"prechod", "[", 
    RowBox[{
     RowBox[{"\[Rho]iz", "*", "cpiz"}], ",", 
     RowBox[{"\[Rho]", "*", "cp"}], ",", "diz"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"diz", "+", "d"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lambda", "=", 
   RowBox[{"prechod", "[", 
    RowBox[{"\[Lambda]iz", ",", "\[Lambda]", ",", "diz"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"diz", "+", "d"}]}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.872660411874035*^9, 3.8726604156549993`*^9}, {
   3.8726604809159946`*^9, 3.872660487405876*^9}, {3.872660528986147*^9, 
   3.8726605312828503`*^9}, {3.8726607359716597`*^9, 3.872660739080819*^9}, {
   3.8726607906397114`*^9, 3.872660805919901*^9}, {3.872661090701332*^9, 
   3.8726611554054413`*^9}, 3.8726612144325476`*^9, {3.8726615438470144`*^9, 
   3.872661602033931*^9}, {3.872661642508669*^9, 3.872661685700559*^9}, 
   3.8732650165546646`*^9, {3.873265217151928*^9, 3.8732652361044044`*^9}, 
   3.873265333144582*^9, {3.873265396218337*^9, 3.8732654031990447`*^9}, {
   3.8732654407901807`*^9, 3.8732654544941916`*^9}, {3.8732654964639673`*^9, 
   3.8732655083381476`*^9}, 3.873265577489601*^9, {3.873265826655661*^9, 
   3.873265876019165*^9}, {3.8732659849086857`*^9, 3.8732660184092236`*^9}, {
   3.873266204521944*^9, 3.873266206374241*^9}, {3.8732664667814703`*^9, 
   3.8732665269236207`*^9}, {3.8732665577694473`*^9, 3.873266777108144*^9}, {
   3.873266894159795*^9, 3.8732669062426634`*^9}, {3.8732671865385323`*^9, 
   3.873267280692215*^9}, {3.873269347230706*^9, 3.873269365130481*^9}},
 CellLabel->
  "In[1279]:=",ExpressionUUID->"446694a0-1345-4e66-8365-1f503ea7420d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"div", "[", "v_", "]"}], ":=", 
   RowBox[{"Div", "[", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "s_", "]"}], ":=", 
   RowBox[{"Grad", "[", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{
    RowBox[{"rocepe", "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "\[Equal]", 
    RowBox[{"div", "[", 
     RowBox[{"lambda", "*", 
      RowBox[{"grad", "[", 
       RowBox[{"T", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "]"}]}], "]"}]}]}], 
  ";"}], "\n"}], "Input",
 CellChangeTimes->{{3.872660411874035*^9, 3.8726604156549993`*^9}, {
   3.8726604809159946`*^9, 3.872660487405876*^9}, {3.872660528986147*^9, 
   3.8726605312828503`*^9}, {3.8726607359716597`*^9, 3.872660739080819*^9}, {
   3.8726607906397114`*^9, 3.872660805919901*^9}, {3.872661090701332*^9, 
   3.8726611554054413`*^9}, 3.8726612144325476`*^9, {3.8726615438470144`*^9, 
   3.872661602033931*^9}, {3.872661642508669*^9, 3.872661685700559*^9}, 
   3.8732650165546646`*^9, {3.873265217151928*^9, 3.8732652361044044`*^9}, 
   3.873265333144582*^9, {3.873265396218337*^9, 3.8732654031990447`*^9}, {
   3.8732654407901807`*^9, 3.8732654544941916`*^9}, {3.8732654964639673`*^9, 
   3.8732655083381476`*^9}, 3.873265577489601*^9, {3.873265826655661*^9, 
   3.8732658515079193`*^9}, {3.8732673393837614`*^9, 3.873267381208537*^9}, 
   3.873267505329939*^9},
 CellLabel->
  "In[1295]:=",ExpressionUUID->"44d0444e-a75f-49da-aeca-629b169c0d27"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"den", "=", 
   RowBox[{"24", "*", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tprum", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tokoli", "=", 
   RowBox[{"Tprum", "+", 
    RowBox[{"7", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"t", "*", "2", "Pi", "*", 
       FractionBox["1", "den"]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"25", "*", "den"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tStart", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"x", ",", "tStart"}], "]"}], "\[Equal]", "Tprum"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"Tokoli", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.872660411874035*^9, 3.8726604156549993`*^9}, {
   3.8726604809159946`*^9, 3.872660487405876*^9}, {3.872660528986147*^9, 
   3.8726605312828503`*^9}, {3.8726607359716597`*^9, 3.872660739080819*^9}, {
   3.8726607906397114`*^9, 3.872660805919901*^9}, {3.872661090701332*^9, 
   3.8726611554054413`*^9}, 3.8726612144325476`*^9, {3.8726615438470144`*^9, 
   3.872661602033931*^9}, {3.872661642508669*^9, 3.872661685700559*^9}, 
   3.8732650165546646`*^9, {3.873265217151928*^9, 3.8732652361044044`*^9}, 
   3.873265333144582*^9, {3.873265396218337*^9, 3.8732654031990447`*^9}, {
   3.8732654407901807`*^9, 3.8732654544941916`*^9}, {3.8732654964639673`*^9, 
   3.8732655083381476`*^9}, 3.873265577489601*^9, {3.873265826655661*^9, 
   3.8732658515079193`*^9}, {3.8732673393837614`*^9, 
   3.8732673545512238`*^9}, {3.873267515074619*^9, 3.8732676583219495`*^9}, 
   3.8732682096684713`*^9, 3.873268685060727*^9, {3.8732688122928677`*^9, 
   3.8732688124934683`*^9}, {3.873269073891346*^9, 3.8732690740919104`*^9}},
 CellLabel->
  "In[1298]:=",ExpressionUUID->"fe581d3f-62e7-45df-b962-9d364e5da66f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]in", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]ext", "=", "16"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tin", "=", "26"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "=", 
   RowBox[{"d", "+", "diz"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]ext", "*", 
      RowBox[{"(", 
       RowBox[{"Tokoli", "-", 
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}]}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "lambda"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
    RowBox[{"x", "\[Rule]", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Tanh", "[", "t", "]"}], "*", "\[Alpha]in", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], "-", "Tin"}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "lambda"}], "*", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"T", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "/.", 
    RowBox[{"x", "\[Rule]", "xmax"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rceCelkem", "=", 
    RowBox[{"{", 
     RowBox[{"rce", ",", "okr1", ",", "okr2", ",", "poc"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{"rceCelkem", ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", 
         SuperscriptBox["T", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tStart", ",", "tmax"}], "}"}], ",", 
       RowBox[{"MaxStepSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["xmax", "1600"], ",", 
          FractionBox["tmax", "1600"]}], "}"}]}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "/.", "sol"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "xmax"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"tmax", "-", 
      RowBox[{"3", "*", "den"}]}], ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.872660411874035*^9, 3.8726604156549993`*^9}, {
   3.8726604809159946`*^9, 3.872660487405876*^9}, {3.872660528986147*^9, 
   3.8726605312828503`*^9}, {3.8726607359716597`*^9, 3.872660739080819*^9}, {
   3.8726607906397114`*^9, 3.872660805919901*^9}, {3.872661090701332*^9, 
   3.8726611554054413`*^9}, 3.8726612144325476`*^9, {3.8726615438470144`*^9, 
   3.872661602033931*^9}, {3.872661642508669*^9, 3.872661685700559*^9}, 
   3.8732650165546646`*^9, {3.873265217151928*^9, 3.8732652361044044`*^9}, 
   3.873265333144582*^9, {3.873265396218337*^9, 3.8732654031990447`*^9}, {
   3.8732654407901807`*^9, 3.8732654544941916`*^9}, {3.8732654964639673`*^9, 
   3.8732655083381476`*^9}, 3.873265577489601*^9, {3.873265826655661*^9, 
   3.8732658515079193`*^9}, {3.8732673393837614`*^9, 
   3.8732673545512238`*^9}, {3.873267515074619*^9, 3.8732675240547028`*^9}, 
   3.873267599177705*^9, {3.873267749810335*^9, 3.873267786783126*^9}, 
   3.8732678209285746`*^9, {3.8732679916130548`*^9, 3.873267997474149*^9}, 
   3.8732682183631134`*^9, {3.8732682536054306`*^9, 3.873268297600246*^9}, 
   3.8732683566477613`*^9, 3.8732684937514954`*^9, {3.873268568056952*^9, 
   3.8732685700000453`*^9}, {3.8732686088932247`*^9, 
   3.8732686419723787`*^9}, {3.873268693902757*^9, 3.8732686965952053`*^9}, {
   3.873268853117241*^9, 3.873268857508241*^9}, {3.8732690999382343`*^9, 
   3.8732691023922424`*^9}},
 CellLabel->
  "In[1305]:=",ExpressionUUID->"85ee51e4-8b6b-4d92-ae9f-be1fff51aeba"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"qPrum", "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "\[Alpha]in"], "+", 
       FractionBox["1", "\[Alpha]ext"], "+", 
       FractionBox["d", "\[Lambda]"], "+", 
       FractionBox["diz", "\[Lambda]iz"]}], ")"}], 
     RowBox[{"-", "1"}]], "*", 
    RowBox[{"(", 
     RowBox[{"Tin", "-", "Tprum"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Alpha]in", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"T", "[", 
          RowBox[{"xmax", ",", "t"}], "]"}], "-", "Tin"}], ")"}]}], "/.", 
      "sol"}], ",", "qPrum", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"lambda", "*", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"T", "[", 
           RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "/.", 
       RowBox[{"x", "\[Rule]", "xmax"}]}], "/.", "sol"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"tmax", "-", 
      RowBox[{"3", "*", "den"}]}], ",", "tmax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.873269407092916*^9, 3.873269544786379*^9}, {
  3.8732695752389035`*^9, 3.873269585569623*^9}},
 CellLabel->
  "In[1317]:=",ExpressionUUID->"e8caf49b-76c6-4cff-817a-51df388730f5"]
},
WindowSize->{1152, 690},
WindowMargins->{{24, Automatic}, {Automatic, 50}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.4 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 484, 12, 193, "Input",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],
Cell[1045, 34, 4309, 110, 1086, "Input",ExpressionUUID->"446694a0-1345-4e66-8365-1f503ea7420d"],
Cell[5357, 146, 1805, 44, 287, "Input",ExpressionUUID->"44d0444e-a75f-49da-aeca-629b169c0d27"],
Cell[7165, 192, 2034, 45, 424, "Input",ExpressionUUID->"fe581d3f-62e7-45df-b962-9d364e5da66f"],
Cell[9202, 239, 4379, 109, 1054, "Input",ExpressionUUID->"85ee51e4-8b6b-4d92-ae9f-be1fff51aeba"],
Cell[13584, 350, 1341, 40, 282, "Input",ExpressionUUID->"e8caf49b-76c6-4cff-817a-51df388730f5"]
}
]
*)

