(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     33482,        853]
NotebookOptionsPosition[     32896,        831]
NotebookOutlinePosition[     33297,        848]
CellTagsIndexPosition[     33254,        845]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   StyleBox[
    RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.505321783390625*^9, 3.505321788078125*^9}, {
   3.60467097675*^9, 3.60467101234375*^9}, 3.60467289*^9, {
   3.622789417921875*^9, 3.622789421484375*^9}, {3.749189448700396*^9, 
   3.7491894526847706`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"roOlej", "=", "847"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"roVoda", "=", "997"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mm", "=", 
   RowBox[{"0.1", "cm"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.62409541509375*^9, 3.624095491703125*^9}, {
  3.624095800265625*^9, 3.624095808046875*^9}, {3.6241614845*^9, 
  3.624161484921875*^9}, {3.6254096563125*^9, 3.62540966321875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"datvisc", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "5.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"100.01", ",", 
        RowBox[{"5.4", "-", "0.01"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"65", ",", 
        RowBox[{
         FractionBox[
          RowBox[{"10.876", "*", 
           SuperscriptBox["10", 
            RowBox[{"-", "3"}]]}], "roOlej"], "*", 
         SuperscriptBox["10", "6"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "32"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40.01", ",", "31.99"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"32.94", ",", 
        RowBox[{
         FractionBox[
          RowBox[{"36.612", "*", 
           SuperscriptBox["10", 
            RowBox[{"-", "3"}]]}], "roOlej"], "*", 
         SuperscriptBox["10", "6"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "80"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "160"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    SuperscriptBox["mm", "2"], "/", "s"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"datvisc", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<T[\[Degree]C]\>\"", ",", 
        "\"\<\!\(\*SuperscriptBox[\(10\), \(6\)]\)\[Nu][\!\(\*SuperscriptBox[\
\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.622782371546875*^9, 3.62278238496875*^9}, {
   3.622782436*^9, 3.6227824473125*^9}, {3.622782478203125*^9, 
   3.622782507046875*^9}, {3.62278254334375*^9, 3.6227825469375*^9}, {
   3.622782623890625*^9, 3.622782634171875*^9}, {3.622782678046875*^9, 
   3.622782712953125*^9}, 3.622784628234375*^9, {3.624092803609375*^9, 
   3.6240928668125*^9}, {3.624093051984375*^9, 3.62409306609375*^9}, {
   3.6240935539375*^9, 3.624093558546875*^9}, {3.624093614890625*^9, 
   3.624093648296875*^9}, {3.624093686953125*^9, 3.62409370696875*^9}, {
   3.624093756140625*^9, 3.62409377446875*^9}, {3.624093849046875*^9, 
   3.624093858265625*^9}, {3.624095524671875*^9, 3.624095600328125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"nahr", ",", "T", ",", "\[Alpha]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", ":=", 
   RowBox[{
    SubscriptBox["\[Alpha]", "#"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"par", ":=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"Cases", "[", 
      RowBox[{"#", ",", 
       SubscriptBox["\[Alpha]", "_"], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{
    RowBox[{"v", "[", "1", "]"}], "+", 
    RowBox[{
     RowBox[{"v", "[", "2", "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"v", "[", "3", "]"}], "*", "T"}]}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"nahr", "[", "T_", "]"}], "=", 
   RowBox[{"model", "/.", 
    RowBox[{"FindFit", "[", 
     RowBox[{"datvisc", ",", "model", ",", 
      RowBox[{"par", "[", "model", "]"}], ",", "T", ",", 
      RowBox[{"Method", "\[Rule]", "NMinimize"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"nahr", "[", "T", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "10", ",", "110"}], "}"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<T[\[Degree]C]\>\"", ",", 
        "\"\<\!\(\*SuperscriptBox[\(10\), \(6\)]\)\[Nu][\!\(\*SuperscriptBox[\
\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0.63", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl2", ",", "pl1", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nyOlej", "[", "Tolej_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", "6"}]], "*", 
    RowBox[{"nahr", "[", "Tolej", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cpOlej", "=", "1988"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cpVoda", "=", "4178"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TinVoda", "=", "14.5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.622782827640625*^9, 3.62278283146875*^9}, {
   3.62409561434375*^9, 3.624095659734375*^9}, {3.624096126265625*^9, 
   3.62409621025*^9}, {3.6241111299375*^9, 3.624111133640625*^9}, {
   3.624111167875*^9, 3.6241111881875*^9}, {3.624115442625*^9, 
   3.624115460796875*^9}, 3.624160445578125*^9, {3.624161665296875*^9, 
   3.6241616656875*^9}, {3.6244566878099756`*^9, 3.6244567140180216`*^9}, {
   3.62541097434375*^9, 3.6254110010625*^9}, 3.627032962046875*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"mereni", " ", "cislo", " ", "5"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TinOlej", "=", "59"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ToutOlej", "=", "34.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"msteckouVoda", "=", "6.33"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"msteckouOlej", "=", "1.218"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"respars", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"cpOlej", "*", "msteckouOlej", "*", 
            RowBox[{"(", 
             RowBox[{"TinOlej", "-", "ToutOlej"}], ")"}]}], "\[Equal]", 
           RowBox[{"cpVoda", "*", "msteckouVoda", "*", 
            RowBox[{"(", 
             RowBox[{"ToutV", "-", "TinVoda"}], ")"}]}]}], ",", 
          RowBox[{"P", "==", 
           RowBox[{"cpVoda", "*", "msteckouVoda", "*", 
            RowBox[{"(", 
             RowBox[{"ToutVoda", "-", "TinVoda"}], ")"}]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"ToutV", ",", "P"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ToutVoda", ",", "vykon"}], "}"}], "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ToutV", ",", "P"}], "}"}], "/.", "respars"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datNyVoda", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.787"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1.519"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1.307"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1.004"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "0.801"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "0.658"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "0.553"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "0.475"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"70", ",", "0.413"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"80", ",", "0.365"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"90", ",", "0.326"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "0.29"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nyVoda", "=", 
     RowBox[{
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], "*", 
       RowBox[{
        RowBox[{"Interpolation", "[", "datNyVoda", "]"}], "[", "#", "]"}]}], 
      "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataPrVoda", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.01", ",", "13.67"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "9.47"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "7.01"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "5.43"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "4.34"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "3.56"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "2.99"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"70", ",", "2.56"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"80", ",", "2.23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"90", ",", "1.96"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PrVoda", "=", 
     RowBox[{"Interpolation", "[", "dataPrVoda", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataLambdaVoda", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0.561"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "0.5984"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "0.631"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "0.654"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"80", ",", "0.67"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "0.679"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambdaVoda", "=", 
     RowBox[{"Interpolation", "[", "dataLambdaVoda", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambdaOlej", "=", 
     RowBox[{"0.13141", "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrOlej", "[", "T_", "]"}], ":=", 
     FractionBox[
      RowBox[{"nyOlej", "[", "T", "]"}], 
      FractionBox[
       RowBox[{"lambdaOlej", "[", "T", "]"}], 
       RowBox[{"cpOlej", "*", "roOlej"}]]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"nu", "[", "gz_", "]"}], ":=", 
     RowBox[{"Which", "[", 
      RowBox[{
       RowBox[{"0", "\[LessEqual]", "gz", "<", "667"}], ",", 
       RowBox[{"4.364", "+", 
        RowBox[{"0.263", "*", 
         SuperscriptBox["gz", "0.506"], "*", 
         RowBox[{"Exp", "[", 
          FractionBox[
           RowBox[{"-", "41."}], "gz"], "]"}]}]}], ",", 
       RowBox[{"667", "\[LessEqual]", "gz", "<", 
        RowBox[{"2", "*", 
         SuperscriptBox["10", "4"]}]}], ",", 
       RowBox[{
        RowBox[{"1.302", "*", 
         SuperscriptBox["gz", "0.333"]}], "-", "0.5"}], ",", 
       RowBox[{"gz", "\[GreaterEqual]", 
        RowBox[{"2", "*", 
         SuperscriptBox["10", "4"]}]}], ",", 
       RowBox[{
        RowBox[{"1.302", "*", 
         SuperscriptBox["gz", "0.333"]}], "-", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"nu", "[", "gz", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"gz", ",", "666", ",", "680"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.62278560215625*^9, 3.622785653734375*^9}, {
   3.622785795984375*^9, 3.622785799765625*^9}, {3.6227858299375*^9, 
   3.6227858638125*^9}, {3.62278589853125*^9, 3.62278601515625*^9}, {
   3.622786053875*^9, 3.622786065234375*^9}, {3.62278611396875*^9, 
   3.622786157421875*^9}, {3.62278625221875*^9, 3.62278626465625*^9}, {
   3.62411550084375*^9, 3.624115507140625*^9}, {3.62416049825*^9, 
   3.624160535890625*^9}, {3.6241611096875*^9, 3.624161110765625*^9}, {
   3.624161143953125*^9, 3.624161144328125*^9}, {3.624161725984375*^9, 
   3.624161726953125*^9}, 3.624170622046875*^9, {3.6244565829153914`*^9, 
   3.6244565890150023`*^9}, 3.6244566478427057`*^9, {3.625410933765625*^9, 
   3.625410961484375*^9}, {3.62546552296875*^9, 3.625465551078125*^9}, 
   3.62546649853125*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "vydej", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]xVstup", "=", 
     RowBox[{"50", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dchar", "=", 
     RowBox[{
      StyleBox["0.32",
       FontColor->RGBColor[1, 0, 0]], "cm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydej", "[", 
      RowBox[{"S0_", ",", "TinVoda_", ",", "d0_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dchar", "=", "dchar"}], ",", "vyska", ",", "m0", ",", "nk", 
         ",", "prurez", ",", "rychlostOlej", ",", "rychlostVoda", ",", 
         "ReVoda", ",", "ReOlej", ",", "gz", ",", "alfaOlej", ",", "alfaVoda",
          ",", "nKanalu", ",", "\[Xi]", ",", "Tplech", ",", "kacko", ",", 
         "Tdeska", ",", "\[Alpha]Olej", ",", "\[Alpha]Voda", ",", "TdefOlej", 
         ",", "TdefVoda", ",", "k", ",", "rce", ",", "res", ",", "Tvd", ",", 
         "Tv0", ",", "Tvvystup", ",", "tv0", ",", "pom", ",", "Tvoda", ",", 
         "Tolej", ",", "ksi", ",", "plb", ",", "vykony", ",", "TstrV", ",", 
         "TstrO", ",", "ReV", ",", "ReO", ",", "PrV", ",", "PrO", ",", 
         "pomNu"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"m0", "=", 
         FractionBox["S0", "d0"]}], ";", "\[IndentingNewLine]", 
        RowBox[{"vyska", "=", "d0"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"prurez", "=", 
         RowBox[{"Dchar", "*", "m0"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"rychlostVoda", "=", 
         FractionBox["msteckouVoda", 
          RowBox[{"roVoda", "*", "prurez"}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{"rychlostOlej", "=", 
         FractionBox["msteckouOlej", 
          RowBox[{"roOlej", "*", "prurez"}]]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ReVoda", "[", "T_", "]"}], ":=", 
         FractionBox[
          RowBox[{"Dchar", "*", "rychlostVoda"}], 
          RowBox[{"nyVoda", "[", "T", "]"}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ReOlej", "[", "T_", "]"}], ":=", 
         FractionBox[
          RowBox[{"Dchar", "*", "rychlostOlej"}], 
          RowBox[{"nyOlej", "[", "T", "]"}]]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"gz", "[", 
          RowBox[{"re_", ",", "pr_", ",", "x_"}], "]"}], ":=", 
         FractionBox[
          RowBox[{"re", "*", "pr", "*", "Dchar"}], "x"]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"alfaOlej", "[", 
          RowBox[{"T_", ",", "x_"}], "]"}], ":=", 
         RowBox[{
          FractionBox[
           RowBox[{"lambdaOlej", "[", "T", "]"}], "Dchar"], "*", 
          RowBox[{"nu", "[", 
           RowBox[{"gz", "[", 
            RowBox[{
             RowBox[{"ReOlej", "[", "T", "]"}], ",", 
             RowBox[{"PrOlej", "[", "T", "]"}], ",", 
             RowBox[{
              RowBox[{"Abs", "[", "x", "]"}], "+", 
              "\[CapitalDelta]xVstup"}]}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"alfaVoda", "[", 
          RowBox[{"T_", ",", "x_"}], "]"}], ":=", 
         RowBox[{
          FractionBox[
           RowBox[{"lambdaVoda", "[", "T", "]"}], "Dchar"], "*", 
          RowBox[{"nu", "[", 
           RowBox[{"gz", "[", 
            RowBox[{
             RowBox[{"ReVoda", "[", "T", "]"}], ",", 
             RowBox[{"PrVoda", "[", "T", "]"}], ",", 
             RowBox[{
              RowBox[{"Abs", "[", 
               RowBox[{"d0", "-", "x"}], "]"}], "+", 
              "\[CapitalDelta]xVstup"}]}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"\[Xi]", "=", 
         FractionBox[
          RowBox[{"alfaOlej", "[", 
           RowBox[{
            RowBox[{"0.5", 
             RowBox[{"(", 
              RowBox[{"62", "+", "39"}], ")"}]}], ",", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{"d0", "+", "\[CapitalDelta]xVstup"}], ")"}]}]}], "]"}], 
          RowBox[{"alfaVoda", "[", 
           RowBox[{
            RowBox[{"TinVoda", "+", "2"}], ",", 
            RowBox[{"0.5", "*", 
             RowBox[{"(", 
              RowBox[{"d0", "+", "\[CapitalDelta]xVstup"}], ")"}]}]}], 
           "]"}]]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Tplech", "[", 
          RowBox[{"Tolej_", ",", "Tvoda_"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Tdeska", "/.", 
            RowBox[{"Simplify", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Solve", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Alpha]Olej", "*", 
                   RowBox[{"(", 
                    RowBox[{"Tolej", "-", "Tdeska"}], ")"}]}], "\[Equal]", 
                  RowBox[{"\[Alpha]Voda", "*", 
                   RowBox[{"(", 
                    RowBox[{"Tdeska", "-", "Tvoda"}], ")"}]}]}], ",", 
                 "Tdeska"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "/.", 
              RowBox[{"\[Alpha]Olej", "\[Rule]", 
               RowBox[{"ksi", "*", "\[Alpha]Voda"}]}]}], "]"}]}], ")"}], "/.", 
          RowBox[{"ksi", "\[Rule]", "\[Xi]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"kacko", "[", 
          RowBox[{"\[Alpha]1_", ",", "\[Alpha]2_"}], "]"}], ":=", 
         FractionBox[
          RowBox[{"\[Alpha]1", "*", "\[Alpha]2"}], 
          RowBox[{"\[Alpha]1", "+", "\[Alpha]2"}]]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"TdefOlej", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{"0.5", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"To", "[", "x", "]"}], "+", 
             RowBox[{"Tplech", "[", 
              RowBox[{
               RowBox[{"To", "[", "x", "]"}], ",", 
               RowBox[{"Tv", "[", "x", "]"}]}], "]"}]}], ")"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"TdefVoda", "=", 
         RowBox[{"Simplify", "[", 
          RowBox[{"0.5", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Tv", "[", "x", "]"}], "+", 
             RowBox[{"Tplech", "[", 
              RowBox[{
               RowBox[{"To", "[", "x", "]"}], ",", 
               RowBox[{"Tv", "[", "x", "]"}]}], "]"}]}], ")"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"k", "[", "x_", "]"}], "=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "}"}], ",", 
           RowBox[{
            RowBox[{"\[Alpha]1", "=", 
             RowBox[{
              RowBox[{"alfaOlej", "[", 
               RowBox[{"TdefOlej", ",", "x"}], "]"}], "*", 
              SuperscriptBox[
               RowBox[{"(", 
                FractionBox[
                 RowBox[{"nahr", "[", "TdefOlej", "]"}], 
                 RowBox[{"nahr", "[", 
                  RowBox[{"Tplech", "[", 
                   RowBox[{
                    RowBox[{"To", "[", "x", "]"}], ",", 
                    RowBox[{"Tv", "[", "x", "]"}]}], "]"}], "]"}]], ")"}], 
               "0.14"]}]}], ";", 
            RowBox[{"\[Alpha]2", "=", 
             RowBox[{"alfaVoda", "[", 
              RowBox[{"TdefVoda", ",", "x"}], "]"}]}], ";", 
            RowBox[{"kacko", "[", 
             RowBox[{"\[Alpha]1", ",", "\[Alpha]2"}], "]"}]}]}], "]"}]}], ";",
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"rce", "[", "ToutVoda_", "]"}], ":=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "cpVoda"}], "*", "msteckouVoda", "*", 
             RowBox[{
              RowBox[{"Tv", "'"}], "[", "x", "]"}]}], "\[Equal]", 
            RowBox[{
             RowBox[{"k", "[", "x", "]"}], "*", "m0", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"To", "[", "x", "]"}], "-", 
               RowBox[{"Tv", "[", "x", "]"}]}], ")"}]}]}], ",", 
           RowBox[{
            RowBox[{"cpOlej", "*", "msteckouOlej", "*", 
             RowBox[{
              RowBox[{"To", "'"}], "[", "x", "]"}]}], "\[Equal]", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"k", "[", "x", "]"}]}], "*", "m0", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"To", "[", "x", "]"}], "-", 
               RowBox[{"Tv", "[", "x", "]"}]}], ")"}]}]}], ",", 
           RowBox[{
            RowBox[{"To", "[", "0", "]"}], "==", "TinOlej"}], ",", 
           RowBox[{
            RowBox[{"Tv", "[", "0", "]"}], "==", "ToutVoda"}]}], "}"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "[", "ToutVoda_", "]"}], ":=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{
            RowBox[{"rce", "[", "ToutVoda", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Tv", ",", "To"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", "d0"}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", "\n", 
        RowBox[{
         RowBox[{"Tvd", "[", 
          RowBox[{"Tv0_", "?", "NumberQ"}], "]"}], ":=", 
         RowBox[{
          RowBox[{"Tv", "[", "d0", "]"}], "/.", 
          RowBox[{"res", "[", "Tv0", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Tv0", "[", "tvd_", "]"}], ":=", 
         RowBox[{"tv0", "/.", 
          RowBox[{"FindRoot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Tvd", "[", "tv0", "]"}], "\[Equal]", "tvd"}], ",", 
            RowBox[{"{", 
             RowBox[{"tv0", ",", "19"}], "}"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Tvvystup", "=", 
         RowBox[{"Tv0", "[", "TinVoda", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pom", "=", 
         RowBox[{"res", "[", "Tvvystup", "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"plb", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Tv", "[", "x", "]"}], ",", 
               RowBox[{"To", "[", "x", "]"}]}], "}"}], "/.", "pom"}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", "d0"}], "}"}], ",", 
           RowBox[{"AxesOrigin", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Thick", ",", "Blue"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Thick", ",", "Magenta"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<x [m]\>\"", ",", "\"\<\!\(\*
StyleBox[\"Tvoda\",
FontColor->RGBColor[0, 0, 1]]\)  \!\(\*
StyleBox[\"Tolej\",
FontColor->RGBColor[1, 0, 0]]\)  [\[Degree]C]\>\""}], "}"}]}], ",", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"vykony", "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"cpOlej", "*", "msteckouOlej", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"To", "[", "0", "]"}], "-", 
               RowBox[{"To", "[", "d0", "]"}]}], ")"}]}], ",", 
            RowBox[{"cpVoda", "*", "msteckouVoda", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Tv", "[", "0", "]"}], "-", 
               RowBox[{"Tv", "[", "d0", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "pom"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TstrV", ",", "TstrO"}], "}"}], "=", 
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Tv", "[", 
              RowBox[{"0.5", "d0"}], "]"}], ",", 
             RowBox[{"To", "[", 
              RowBox[{"0.5", "d0"}], "]"}]}], "}"}], "/.", "pom"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ReV", ",", "ReO", ",", "PrV", ",", "PrO"}], "}"}], "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ReVoda", "[", "TstrV", "]"}], ",", 
           RowBox[{"ReOlej", "[", "TstrO", "]"}], ",", 
           RowBox[{"PrVoda", "[", "TstrV", "]"}], ",", 
           RowBox[{"PrOlej", "[", "TstrO", "]"}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"plb", ",", "vykony", ",", "\[Xi]", ",", 
          RowBox[{"{", 
           RowBox[{"TstrV", ",", "TstrO"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ReV", ",", "ReO", ",", "PrV", ",", "PrO"}], "}"}], ",", 
          FractionBox[
           RowBox[{"ReV", "*", "PrV"}], 
           RowBox[{"ReO", "*", "PrO"}]], ",", 
          RowBox[{"pomNu", "=", 
           FractionBox[
            RowBox[{"nu", "@", 
             RowBox[{"gz", "[", 
              RowBox[{"ReV", ",", "PrV", ",", 
               RowBox[{"0.5", "*", 
                RowBox[{"(", 
                 RowBox[{"d0", "+", "\[CapitalDelta]xVstup"}], ")"}]}]}], 
              "]"}]}], 
            RowBox[{"nu", "@", 
             RowBox[{"gz", "[", 
              RowBox[{"ReO", ",", "PrO", ",", 
               RowBox[{"0.5", "*", 
                RowBox[{"(", 
                 RowBox[{"d0", "+", "\[CapitalDelta]xVstup"}], ")"}]}]}], 
              "]"}]}]]}], ",", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"pomNu", "*", 
             FractionBox[
              RowBox[{"lambdaVoda", "[", "TstrV", "]"}], 
              RowBox[{"lambdaOlej", "[", "TstrO", "]"}]]}], ")"}], 
           RowBox[{"-", "1"}]]}], "}"}]}]}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S0", "=", "17.68"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d0", "=", 
     RowBox[{"1360", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"pp", "=", 
    RowBox[{"vydej", "[", 
     RowBox[{"S0", ",", "14", ",", "d0"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.62408484246875*^9, 3.6240848465625*^9}, {
   3.624086053234375*^9, 3.624086126453125*^9}, {3.6240861785*^9, 
   3.624086268*^9}, {3.624086344796875*^9, 3.624086570703125*^9}, {
   3.62408662928125*^9, 3.624086692546875*^9}, {3.62408673684375*^9, 
   3.624087055453125*^9}, {3.624087115828125*^9, 3.624087213625*^9}, 
   3.62411551875*^9, {3.624115619015625*^9, 3.6241156325*^9}, {
   3.62411639371875*^9, 3.62411639384375*^9}, {3.624116442640625*^9, 
   3.624116500921875*^9}, {3.62411656575*^9, 3.624116571546875*^9}, 
   3.62411660334375*^9, {3.62411670596875*^9, 3.624116730453125*^9}, 
   3.624116804546875*^9, {3.62411698815625*^9, 3.624117015140625*^9}, {
   3.624117075203125*^9, 3.624117105765625*^9}, {3.624117235359375*^9, 
   3.624117256515625*^9}, {3.62411729371875*^9, 3.6241173013125*^9}, {
   3.6241173516875*^9, 3.6241173524375*^9}, {3.62411738575*^9, 
   3.624117399015625*^9}, 3.6241174566875*^9, {3.624117501140625*^9, 
   3.624117501359375*^9}, 3.62411759034375*^9, {3.624117647796875*^9, 
   3.624117657390625*^9}, {3.624118553125*^9, 3.624118583921875*^9}, {
   3.624119548140625*^9, 3.624119548609375*^9}, 3.624160599296875*^9, {
   3.624160691421875*^9, 3.62416069171875*^9}, {3.624161312625*^9, 
   3.624161328828125*^9}, {3.624161385859375*^9, 3.624161506484375*^9}, {
   3.624161569875*^9, 3.62416164871875*^9}, {3.624161689484375*^9, 
   3.62416176996875*^9}, {3.624161805578125*^9, 3.624161839578125*^9}, {
   3.62416189178125*^9, 3.624162114765625*^9}, 3.6241621630625*^9, {
   3.624170209671875*^9, 3.62417021084375*^9}, {3.624170251203125*^9, 
   3.624170254859375*^9}, {3.6241706383125*^9, 3.624170639375*^9}, 
   3.624170680859375*^9, {3.6241707238125*^9, 3.62417073375*^9}, {
   3.624170988953125*^9, 3.62417100175*^9}, {3.6244568483810577`*^9, 
   3.624456857694274*^9}, {3.6244569146811743`*^9, 3.6244569195483828`*^9}, 
   3.624595228703125*^9, {3.625409726125*^9, 3.625409748453125*^9}, {
   3.625410589515625*^9, 3.625410590546875*^9}, {3.625410626921875*^9, 
   3.62541073996875*^9}, {3.625410822953125*^9, 3.62541082321875*^9}, {
   3.62541225471875*^9, 3.62541230415625*^9}, {3.625412337203125*^9, 
   3.6254124084375*^9}, {3.6254127149375*^9, 3.6254127168125*^9}, {
   3.625412757390625*^9, 3.625412758046875*^9}, {3.62541298315625*^9, 
   3.625413106859375*^9}, {3.62541314325*^9, 3.625413275828125*^9}, {
   3.62541330584375*^9, 3.62541334740625*^9}, {3.62541341928125*^9, 
   3.62541343534375*^9}, {3.625413495359375*^9, 3.625413520375*^9}, 
   3.62541358428125*^9, {3.62541362740625*^9, 3.625413700296875*^9}, {
   3.6254137546875*^9, 3.625413880875*^9}, {3.62546096928125*^9, 
   3.62546098690625*^9}, 3.62546445553125*^9, {3.62546449915625*^9, 
   3.625464500671875*^9}, {3.625465481953125*^9, 3.62546549171875*^9}, {
   3.627031414515625*^9, 3.627031414796875*^9}, {3.627031467484375*^9, 
   3.627031469859375*^9}, {3.627031749953125*^9, 3.62703176384375*^9}, {
   3.627032357*^9, 3.6270323580625*^9}, {3.627032416484375*^9, 
   3.627032426859375*^9}, {3.627032498578125*^9, 3.62703252990625*^9}}],

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"\"\<odchylka vypocet - mereni= \>\"", ",", 
   RowBox[{"100", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"Mean", "[", 
        RowBox[{"pp", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], "-", "P"}], "/.", "respars"}], 
     RowBox[{"P", "/.", "respars"}]]}], ",", "\"\< %\>\""}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"vydej", "[", 
       RowBox[{"S0", ",", "14", ",", "d0"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], 
    RowBox[{"Mean", "[", 
     RowBox[{
      RowBox[{"vydej", "[", 
       RowBox[{
        RowBox[{
         FractionBox["5", "7"], "S0"}], ",", "14", ",", "d0"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]], ",", 
   FractionBox["7.", "5"]}], "}"}]], "Input",
 CellChangeTimes->{{3.625415667796875*^9, 3.625415729328125*^9}}]
},
WindowSize->{1121, 743},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
ShowSelection->True,
Magnification->1.4000000953674316`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 705, 19, 117, "Input"],
Cell[1265, 41, 515, 12, 117, "Input"],
Cell[1783, 55, 2482, 64, 195, "Input"],
Cell[4268, 121, 2960, 80, 332, "Input"],
Cell[7231, 203, 6937, 189, 765, "Input"],
Cell[14171, 394, 17772, 404, 1913, "Input"],
Cell[31946, 800, 372, 10, 70, "Input"],
Cell[32321, 812, 571, 17, 83, "Input"]
}
]
*)

(* End of internal cache information *)
