(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69453,       1839]
NotebookOptionsPosition[     68622,       1812]
NotebookOutlinePosition[     69024,       1829]
CellTagsIndexPosition[     68981,       1826]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   StyleBox[
    RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5942260055625*^9, 3.59422601065625*^9}, {
   3.5979047426875*^9, 3.597904763359375*^9}, {3.597904863109375*^9, 
   3.597904864859375*^9}, {3.5979051625625*^9, 3.59790516409375*^9}, {
   3.59790777721875*^9, 3.59790777865625*^9}, {3.598168166484375*^9, 
   3.598168168671875*^9}, {3.598173564453125*^9, 3.59817356540625*^9}, {
   3.59851018225*^9, 3.59851018328125*^9}, {3.60066951265625*^9, 
   3.600669535453125*^9}, {3.600669728359375*^9, 3.600669731640625*^9}, {
   3.60066978978125*^9, 3.600669801125*^9}, {3.60066988971875*^9, 
   3.600669913609375*^9}, 3.600670029921875*^9, 3.600670453546875*^9, {
   3.60069330071875*^9, 3.600693301703125*^9}, {3.6006934398125*^9, 
   3.60069345925*^9}, {3.65112889046875*^9, 3.6511288913125*^9}, {
   3.651997606485471*^9, 3.651997610532346*^9}, {3.749188348856646*^9, 
   3.749188352825396*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cm", "=", 
   RowBox[{"10.", "mm"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"imax", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jmax", "=", "12"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TavstupZadane", "=", "99.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TbvstupZAdane", "=", "10.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"msteckouA", "=", "5.23"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"msteckouB", "=", "3.869"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"delkaVymeniku", "=", "5.5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.651993729376096*^9, 3.651993733219846*^9}, 
   3.651993869063596*^9, {3.651998297751096*^9, 3.651998319219846*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{
     "yjm", ",", "x", ",", "rceKruh", ",", "yjmax", ",", "kmax", ",", "udaje",
       ",", "\[CapitalDelta]yj", ",", "km", ",", "\[CapitalDelta]yjm"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D1", "=", "0.5"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"vnitrni", " ", "prumer", " ", "trouby", " ", "B"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1", "=", 
     RowBox[{"1.5", "cm"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"vnitrni", " ", "prumer", " ", "trubicky", " ", "A"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"2", "mm"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"tloustka", " ", "streny", " ", "trubicky", " ", "A"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]y", "=", "1.2"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"\[CapitalDelta]ytrubicka", "+", "mezera"}], "=", 
     RowBox[{"\[Xi]y", "*", "\[CapitalDelta]ytrubicka"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]yukr", "=", "2"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "kolikrat", " ", "je", " ", "mezera", " ", "u", " ", "kraje", " ", 
      "mensi"}], ",", " ", 
     RowBox[{"nez", " ", "mezera", " ", "mezi", " ", "trubkami"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Xi]xj1", "=", "0.2"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
    "kolikrat", " ", "je", " ", "pocatecni", " ", "x", " ", "vuci", " ", 
     "prumeru"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]ytrubicka", "=", 
     RowBox[{"d1", "+", 
      RowBox[{"2", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]yjZadane", "=", 
     RowBox[{"\[Xi]y", "*", "\[CapitalDelta]ytrubicka"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]yukr", "=", 
     RowBox[{"\[Xi]yukr", "*", 
      RowBox[{"(", 
       RowBox[{"\[CapitalDelta]yjZadane", "-", "\[CapitalDelta]ytrubicka"}], 
       ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xj1", "=", 
     RowBox[{"\[Xi]xj1", "*", "D1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]x", "=", 
     FractionBox[
      RowBox[{"D1", "-", 
       RowBox[{"2", "xj1"}]}], 
      RowBox[{"jmax", "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "j_Integer", "]"}], ":=", 
     RowBox[{"xj1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceKruh", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", 
          RowBox[{"0.5", "D1"}]}], ")"}], "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"0.5", "D1"}], ")"}], "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"yjmax", "[", "j_Integer", "]"}], ":=", 
     RowBox[{"yjm", "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{"rceKruh", "[", 
         RowBox[{
          RowBox[{"x", "[", "j", "]"}], ",", "yjm"}], "]"}], "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kmax", "[", "j_Integer", "]"}], ":=", 
    RowBox[{"Floor", "[", 
     RowBox[{"km", "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "*", 
           RowBox[{"yjmax", "[", "j", "]"}]}], "\[Equal]", 
          RowBox[{
           RowBox[{"2", "*", "\[CapitalDelta]yukr"}], "+", 
           RowBox[{"km", "*", "\[CapitalDelta]ytrubicka"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"km", "-", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
             "\[CapitalDelta]yjZadane", "-", "\[CapitalDelta]ytrubicka"}], 
             ")"}]}]}]}], ",", "km"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"udaje", "[", 
      RowBox[{"j_Integer", ",", "k_Integer"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"km", ",", "yjm", ",", "prutocnaDelka"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"km", "=", 
         RowBox[{"kmax", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"yjm", "=", 
         RowBox[{"yjmax", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[CapitalDelta]yj", "=", 
         RowBox[{"\[CapitalDelta]yjm", "/.", 
          RowBox[{
           RowBox[{"Solve", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", "yjm"}], "\[Equal]", 
              RowBox[{
               RowBox[{"2", "*", "\[CapitalDelta]yukr"}], "+", 
               RowBox[{"km", "*", "\[CapitalDelta]ytrubicka"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"km", "-", "1"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                 "\[CapitalDelta]yjm", "-", "\[CapitalDelta]ytrubicka"}], 
                 ")"}]}]}]}], ",", "\[CapitalDelta]yjm"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"prutocnaDelka", "=", 
         RowBox[{
          RowBox[{"2", "*", "\[CapitalDelta]yukr"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"km", "-", "1"}], ")"}], "*", 
           RowBox[{"(", 
            RowBox[{"\[CapitalDelta]yj", "+", 
             RowBox[{"-", "\[CapitalDelta]ytrubicka"}]}], ")"}]}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"x", "[", "j", "]"}], ",", 
            RowBox[{
             RowBox[{"-", "yjm"}], "+", "\[CapitalDelta]yukr", "+", 
             RowBox[{"0.5", "*", "\[CapitalDelta]ytrubicka"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}], "*", "\[CapitalDelta]yj"}]}]}],
            "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"km", ",", "yjm", ",", "prutocnaDelka"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "k"}], "}"}]}], "}"}]}]}], "\[IndentingNewLine]",
       "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"kruh", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x_", ",", "y_"}], "}"}], ",", "r_"}], "}"}], ",", "tk_", 
       ",", "barva_"}], "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "tk", "]"}], ",", "barva", ",", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", "r"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stredy", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"udaje", "[", 
            RowBox[{"j", ",", "k"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "jmax"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"kmax", "[", "j", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kruhy1", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"kruh", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"0.5", "d1"}]}], "}"}], ",", "0.005", ",", "Black"}], 
        "]"}], "&"}], "/@", "stredy"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kruh2", "=", 
     RowBox[{"kruh", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"0.5", "D1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"0.5", "D1"}]}], "}"}], ",", "0.01", ",", "Black"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"grRez", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"kruhy1", ",", "kruh2"}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.651130249671875*^9, 3.65113029471875*^9}, {
   3.651130325765625*^9, 3.651130501171875*^9}, {3.651130543828125*^9, 
   3.651130587890625*^9}, {3.651130621171875*^9, 3.65113089284375*^9}, {
   3.65113104625*^9, 3.65113119609375*^9}, {3.651131854484375*^9, 
   3.651132099640625*^9}, {3.6511321380625*^9, 3.65113228725*^9}, {
   3.651132594515625*^9, 3.651132741671875*^9}, {3.65113282296875*^9, 
   3.651132897890625*^9}, {3.651133028015625*^9, 3.651133349984375*^9}, {
   3.651133396*^9, 3.65113342109375*^9}, {3.65113355246875*^9, 
   3.65113377378125*^9}, {3.651133829890625*^9, 3.651133834796875*^9}, {
   3.651133874046875*^9, 3.651133955453125*^9}, {3.651133991078125*^9, 
   3.65113403721875*^9}, {3.651134222171875*^9, 3.651134403046875*^9}, {
   3.65113444903125*^9, 3.651134463234375*^9}, {3.65121037640625*^9, 
   3.651210387390625*^9}, {3.651212620984375*^9, 3.651212665140625*^9}, {
   3.651212751671875*^9, 3.651212829453125*^9}, {3.65121286034375*^9, 
   3.651212871296875*^9}, 3.651212927234375*^9, 3.65121295746875*^9, 
   3.651213189953125*^9, {3.651213265734375*^9, 3.65121327128125*^9}, {
   3.65121362653125*^9, 3.65121363865625*^9}, 3.651213750796875*^9, 
   3.651213861375*^9, {3.651213898734375*^9, 3.651213931015625*^9}, {
   3.65121398825*^9, 3.65121399965625*^9}, 3.6512144479375*^9, {
   3.651214490828125*^9, 3.65121454984375*^9}, {3.651214625546875*^9, 
   3.651214651796875*^9}, {3.65121491615625*^9, 3.651214935671875*^9}, {
   3.651215071109375*^9, 3.651215083171875*^9}, 3.65121513709375*^9, {
   3.651215193171875*^9, 3.651215216609375*^9}, {3.651216222171875*^9, 
   3.651216254328125*^9}, {3.65121631353125*^9, 3.65121631825*^9}, {
   3.651216524890625*^9, 3.6512165281875*^9}, 3.6512166591875*^9, 
   3.651216721640625*^9, {3.65121707528125*^9, 3.65121708103125*^9}, 
   3.651217151796875*^9, 3.6512172435*^9, 3.65121873034375*^9, {
   3.65122134346875*^9, 3.651221365734375*^9}, {3.651241783453125*^9, 
   3.651241783953125*^9}, {3.65124220971875*^9, 3.65124223953125*^9}, 
   3.651242545578125*^9, {3.651243881328125*^9, 3.65124389096875*^9}, {
   3.651325017078125*^9, 3.65132502125*^9}, 3.651325086875*^9, {
   3.651325154453125*^9, 3.65132518334375*^9}, 3.651325220640625*^9, 
   3.65132526740625*^9, 3.651325591265625*^9, {3.651326327578125*^9, 
   3.651326337578125*^9}, {3.651326382859375*^9, 3.651326394140625*^9}, {
   3.651326489875*^9, 3.65132651859375*^9}, {3.651326552390625*^9, 
   3.65132655809375*^9}, {3.651993819204221*^9, 3.651993842094846*^9}, 
   3.651997349047971*^9, 3.651997626876096*^9, 3.65362651584375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "prutocnaDelka", ",", "SoutVrstva", ",", "SinVrstva", ",", "SkB", ",", 
    "nyA", ",", "Tolej", ",", "gzA", ",", "nuA", ",", "vmaxB", ",", 
    "\[Alpha]A", ",", "\[Alpha]B", ",", "nuB", ",", "kspom"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]Trubka", "=", "41.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nTrubekA", "=", 
   RowBox[{"Length", "[", "stredy", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SkA", "=", 
   RowBox[{"nTrubekA", "*", "Pi", "*", 
    FractionBox[
     SuperscriptBox["d1", "2"], "4"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]z", "=", 
   FractionBox["delkaVymeniku", "imax"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RthTrubka", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
     "2.", "*", "Pi", "*", "\[Lambda]Trubka", "*", "\[CapitalDelta]z"}]], "*", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"d1", "+", 
       RowBox[{"2", "t"}]}], "d1"], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SvitrniTrubka", "=", 
   RowBox[{"2.", "*", "Pi", "*", "\[CapitalDelta]z", "*", "d1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SvnejsiTrubka", "=", 
   RowBox[{"2.", "*", "Pi", "*", "\[CapitalDelta]z", "*", 
    RowBox[{"(", 
     RowBox[{"d1", "+", 
      RowBox[{"2", "t"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SinVrstva", "[", "j_", "]"}], ":=", 
   RowBox[{"SvitrniTrubka", "*", 
    RowBox[{"kmax", "[", "j", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SoutVrstva", "[", "j_", "]"}], ":=", 
   RowBox[{"SvnejsiTrubka", "*", 
    RowBox[{"kmax", "[", "j", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"prutocnaDelka", "[", "j_", "]"}], ":=", 
   RowBox[{
    RowBox[{"udaje", "[", 
     RowBox[{"j", ",", "1"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SkB", "[", "j_", "]"}], ":=", 
   RowBox[{
    RowBox[{"prutocnaDelka", "[", "j", "]"}], "*", "\[CapitalDelta]z"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nyA", "[", "Tolej_", "]"}], "=", 
   RowBox[{"N", "[", 
    RowBox[{"<<", "\"\<nyA\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nyB", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"<<", "\"\<milionnyB\>\""}], ")"}], "[", "#", "]"}]}], 
     "&"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"funkce", " ", "teploty", " ", "A"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cpA", "[", "T_", "]"}], ":=", 
   RowBox[{"1988", "+", 
    RowBox[{"0.01", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cpB", "[", "T_", "]"}], ":=", 
   RowBox[{"4178", "-", 
    RowBox[{"0.0478", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]A", "[", "T_", "]"}], ":=", 
   RowBox[{"0.13141", "+", 
    RowBox[{"0.0001", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Lambda]B", "=", 
    RowBox[{"<<", "\"\<lambdaB\>\""}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"funkce", " ", "teploty", " ", "B"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrA", "[", "Tolej_", "]"}], "=", 
   RowBox[{"<<", "\"\<prA\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrB", "=", 
    RowBox[{"<<", "\"\<prB\>\""}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"funkce", " ", "teploty", " ", "B"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"roA", "[", "T_", "]"}], ":=", 
   RowBox[{"847", "-", 
    RowBox[{"0.0000158", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"roB", "[", "T_", "]"}], ":=", 
   RowBox[{"1000", "-", 
    RowBox[{"0.00047", "T"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gzA", "[", 
    RowBox[{"reA_", ",", "prA_", ",", "z_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"reA", "*", "prA", "*", "d1"}], "z"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nuA", "[", 
    RowBox[{"gz_", ",", "PrA_", ",", "Prw_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.01", "*", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["PrA", "Prw"], ")"}], "0.25"]}]}], ")"}], "*", 
    RowBox[{"Which", "[", 
     RowBox[{
      RowBox[{"0", "\[LessEqual]", "gz", "<", "667"}], ",", 
      RowBox[{"4.364", "+", 
       RowBox[{"0.263", "*", 
        SuperscriptBox["gz", "0.506"], "*", 
        RowBox[{"Exp", "[", 
         FractionBox[
          RowBox[{"-", "41."}], "gz"], "]"}]}]}], ",", 
      RowBox[{"667", "\[LessEqual]", "gz", "<", 
       RowBox[{"2", "*", 
        SuperscriptBox["10", "4"]}]}], ",", 
      RowBox[{
       RowBox[{"1.302", "*", 
        SuperscriptBox["gz", "0.333"]}], "-", "0.5"}], ",", 
      RowBox[{"gz", "\[GreaterEqual]", 
       RowBox[{"2", "*", 
        SuperscriptBox["10", "4"]}]}], ",", 
      RowBox[{
       RowBox[{"1.302", "*", 
        SuperscriptBox["gz", "0.333"]}], "-", "1"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DcharB", "=", 
   RowBox[{"d1", "+", 
    RowBox[{"2", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vmaxB", "[", 
    RowBox[{"j_", ",", "T_"}], "]"}], ":=", 
   FractionBox["msteckouB", 
    RowBox[{
     RowBox[{"roB", "[", "T", "]"}], "*", 
     RowBox[{"SkB", "[", "j", "]"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vA", "[", "T_", "]"}], ":=", 
   FractionBox["msteckouA", 
    RowBox[{
     RowBox[{"roA", "[", "T", "]"}], "*", "SkA"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reA", "[", "T_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"vA", "[", "T", "]"}], "*", "d1"}], 
    RowBox[{"nyA", "[", "T", "]"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"reB", "[", 
    RowBox[{"T_", ",", "j_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"vmaxB", "[", 
      RowBox[{"j", ",", "T"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"d1", "+", 
       RowBox[{"2", "t"}]}], ")"}]}], 
    RowBox[{"nyB", "[", "T", "]"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]A", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]Aminule_", ",", "\[Alpha]Bminule_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"TAminule_", ",", "TBminule_"}], "}"}], ",", "z_"}], "}"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Tstena", ",", "Tdef", ",", "nu", ",", "re", ",", "pr", ",", "prw", 
        ",", "gz", ",", "\[Lambda]"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tstena", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"TAminule", " ", "\[Alpha]Aminule"}], "+", 
          RowBox[{"TBminule", " ", "\[Alpha]Bminule"}]}], 
         RowBox[{"\[Alpha]Aminule", "+", "\[Alpha]Bminule"}]]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Tdef", "=", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"Tstena", "+", "TAminule"}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"re", "=", 
        RowBox[{"reA", "[", "Tdef", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"pr", "=", 
        RowBox[{"PrA", "[", "Tdef", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"prw", "=", 
        RowBox[{"PrA", "[", "Tstena", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"gz", "=", 
        RowBox[{"gzA", "[", 
         RowBox[{"re", ",", "pr", ",", "z"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"nu", "=", 
        RowBox[{"nuA", "[", 
         RowBox[{"gz", ",", "pr", ",", "prw"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"\[Lambda]", "=", 
        RowBox[{"\[Lambda]A", "[", "Tdef", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       FractionBox[
        RowBox[{"nu", "*", "\[Lambda]"}], "d1"]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"nuB", "[", 
     RowBox[{"re_", ",", "PrB_", ",", "Prw_"}], "]"}], ":=", 
    RowBox[{
     SuperscriptBox["PrB", "0.36"], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["PrB", "Prw"], ")"}], "0.25"], "*", "0.52", 
     SuperscriptBox["re", "0.5"]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"0.25", " ", "kapaliny"}], ",", " ", "0", ",", " ", "plyny", ",", 
    " ", 
    RowBox[{"HeatTransfer", " ", 
     RowBox[{"str", ".", " ", "382"}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]B", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]Aminule_", ",", "\[Alpha]Bminule_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"TAminule_", ",", "TBminule_"}], "}"}], ",", "j_"}], "}"}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Tstena", ",", "Dchar", ",", "Tdef", ",", "prB", ",", "prw", ",", "nu",
         ",", "re", ",", "\[Lambda]"}], "}"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Tstena", "=", 
        FractionBox[
         RowBox[{
          RowBox[{"TAminule", " ", "\[Alpha]Aminule"}], "+", 
          RowBox[{"TBminule", " ", "\[Alpha]Bminule"}]}], 
         RowBox[{"\[Alpha]Aminule", "+", "\[Alpha]Bminule"}]]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Dchar", "=", 
        RowBox[{"d1", "+", 
         RowBox[{"2", "t"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Tdef", "=", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"Tstena", "+", "TBminule"}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"prB", "=", 
        RowBox[{"PrB", "[", "Tdef", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"prw", "=", 
        RowBox[{"PrB", "[", "Tstena", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"re", "=", 
        RowBox[{"reB", "[", 
         RowBox[{"Tdef", ",", "j"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"nu", "=", 
        RowBox[{"nuB", "[", 
         RowBox[{"re", ",", "prB", ",", "prw"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"\[Lambda]", "=", 
        RowBox[{"\[Lambda]B", "[", "Tdef", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       FractionBox[
        RowBox[{"nu", "*", "\[Lambda]"}], 
        RowBox[{"d1", "+", 
         RowBox[{"2", "t"}]}]]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"kspom", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]Aminule_", ",", "\[Alpha]Bminule_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"TAminule_", ",", "TBminule_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j_", ",", "z_"}], "}"}]}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Alpha]1", ",", "\[Alpha]2", ",", "S1", ",", "S2"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Alpha]1", "=", 
        RowBox[{"\[Alpha]A", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"TAminule", ",", "TBminule"}], "}"}], ",", "z"}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"S1", "=", 
        RowBox[{"SinVrstva", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"S2", "=", 
        RowBox[{"SoutVrstva", "[", "j", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"\[Alpha]2", "=", 
        RowBox[{"\[Alpha]B", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"TAminule", ",", "TBminule"}], "}"}], ",", "j"}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       FractionBox["1", 
        RowBox[{"RthTrubka", "+", 
         FractionBox["1", 
          RowBox[{"\[Alpha]1", "*", "S1"}]], "+", 
         FractionBox["1", 
          RowBox[{"\[Alpha]2", "*", "S2"}]]}]]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "doskSij", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"doskSij", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_Integer", ",", "j_Integer", ",", "res_"}], "}"}], ",", 
      "dosalfas_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]ANew", ",", "\[Alpha]BNew", ",", "TAminule", ",", "TBminule", 
       ",", "z", ",", "\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Alpha]a", "[", 
           RowBox[{"i", ",", "j"}], "]"}], ",", 
          RowBox[{"\[Alpha]b", "[", 
           RowBox[{"i", ",", "j"}], "]"}]}], "}"}], "/.", "dosalfas"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"z", "=", 
       RowBox[{"\[CapitalDelta]z", "*", 
        RowBox[{"(", 
         RowBox[{"0.5", "+", "i", "-", "1"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TAminule", "=", 
       RowBox[{
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tain", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "+", 
           RowBox[{"Taout", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "/.", "res"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"TBminule", "=", 
       RowBox[{
        RowBox[{"Tbin", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "/.", "res"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]ANew", "=", 
       RowBox[{"\[Alpha]A", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"TAminule", ",", "TBminule"}], "}"}], ",", "z"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Alpha]BNew", "=", 
       RowBox[{"\[Alpha]B", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[Alpha]Aminule", ",", "\[Alpha]Bminule"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"TAminule", ",", "TBminule"}], "}"}], ",", "j"}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"kS", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "->", 
           RowBox[{"kspom", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Alpha]ANew", ",", "\[Alpha]BNew"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"TAminule", ",", "TBminule"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"j", ",", "z"}], "}"}]}], "}"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"mca", "[", 
              RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", 
             RowBox[{
              FractionBox[
               RowBox[{"msteckouA", "*", 
                RowBox[{"kmax", "[", "j", "]"}]}], "nTrubekA"], "*", 
              RowBox[{"cpA", "[", "TAminule", "]"}]}]}], ",", 
            RowBox[{
             RowBox[{"mcb", "[", 
              RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", 
             RowBox[{"msteckouB", "*", 
              RowBox[{"cpB", "[", "TBminule", "]"}]}]}]}], "}"}]}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]a", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", "\[Alpha]ANew"}], ",", 
          RowBox[{
           RowBox[{"\[Alpha]b", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", "\[Alpha]BNew"}]}], 
         "}"}]}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.651214680953125*^9, 3.651214736140625*^9}, 
   3.651214944078125*^9, {3.65121505046875*^9, 3.651215054640625*^9}, {
   3.651215886203125*^9, 3.651215901109375*^9}, {3.65121597178125*^9, 
   3.65121601425*^9}, {3.6512167566875*^9, 3.651216921609375*^9}, {
   3.651216973*^9, 3.65121710575*^9}, {3.651242323015625*^9, 
   3.651242507984375*^9}, {3.65124380678125*^9, 3.6512439019375*^9}, {
   3.651244008109375*^9, 3.651244063484375*^9}, {3.651244186859375*^9, 
   3.651244202734375*^9}, {3.651244263359375*^9, 3.651244310609375*^9}, {
   3.651244377078125*^9, 3.651244408578125*^9}, {3.651244449484375*^9, 
   3.651244466734375*^9}, 3.651244499875*^9, {3.651244626953125*^9, 
   3.6512446289375*^9}, {3.651244671765625*^9, 3.651244674875*^9}, {
   3.651244717109375*^9, 3.651244760078125*^9}, {3.651245054828125*^9, 
   3.651245081484375*^9}, {3.651245171265625*^9, 3.6512452374375*^9}, {
   3.651245281046875*^9, 3.65124532909375*^9}, {3.65124536996875*^9, 
   3.651245431703125*^9}, {3.65124570540625*^9, 3.65124592271875*^9}, 
   3.65124655634375*^9, {3.651246873984375*^9, 3.651246947796875*^9}, 
   3.651247047578125*^9, {3.65124711175*^9, 3.651247127296875*^9}, {
   3.6512471814375*^9, 3.651247201890625*^9}, {3.65124723828125*^9, 
   3.6512473090625*^9}, {3.6512473566875*^9, 3.651247358046875*^9}, {
   3.651247433296875*^9, 3.65124752528125*^9}, 3.651247573046875*^9, {
   3.651247626140625*^9, 3.651247685390625*^9}, {3.65124774628125*^9, 
   3.65124780040625*^9}, {3.6512478320625*^9, 3.651247859203125*^9}, {
   3.651247914453125*^9, 3.651248087640625*^9}, {3.65124811865625*^9, 
   3.651248297453125*^9}, {3.65124852303125*^9, 3.65124858296875*^9}, {
   3.651248650234375*^9, 3.651248777921875*^9}, {3.651248840484375*^9, 
   3.65124909765625*^9}, {3.65124914065625*^9, 3.6512494035*^9}, {
   3.651249455328125*^9, 3.65124945721875*^9}, {3.6512496809375*^9, 
   3.651249693640625*^9}, {3.651249761890625*^9, 3.6512498515625*^9}, {
   3.651249892265625*^9, 3.651249968640625*^9}, {3.651249999140625*^9, 
   3.651250048125*^9}, {3.651250080921875*^9, 3.65125012103125*^9}, 
   3.6512999049375*^9, {3.651299955859375*^9, 3.651299974109375*^9}, {
   3.651324553625*^9, 3.65132465159375*^9}, {3.651324687953125*^9, 
   3.65132470609375*^9}, {3.651324816734375*^9, 3.651324902796875*^9}, {
   3.651324988171875*^9, 3.651324999328125*^9}, {3.651325038390625*^9, 
   3.65132506340625*^9}, {3.651325375734375*^9, 3.65132543484375*^9}, {
   3.651325731125*^9, 3.651325754109375*^9}, {3.65132657596875*^9, 
   3.651326589921875*^9}, 3.6513325640625*^9, {3.65133285528125*^9, 
   3.65133289221875*^9}, {3.651332940484375*^9, 3.65133294553125*^9}, {
   3.651332986703125*^9, 3.65133301890625*^9}, {3.65133306434375*^9, 
   3.651333074734375*^9}, {3.651485456265625*^9, 3.651485470515625*^9}, {
   3.65148551553125*^9, 3.6514856271875*^9}, {3.651485658390625*^9, 
   3.651485698140625*^9}, {3.651485775796875*^9, 3.651485801078125*^9}, {
   3.651485866203125*^9, 3.651485897453125*^9}, {3.651485929984375*^9, 
   3.6514860660625*^9}, {3.65148609615625*^9, 3.65148623621875*^9}, {
   3.651486283859375*^9, 3.651486352734375*^9}, {3.6514864139375*^9, 
   3.6514864165*^9}, {3.6514864846875*^9, 3.651486506546875*^9}, {
   3.651486551390625*^9, 3.65148659946875*^9}, {3.651487314890625*^9, 
   3.65148740440625*^9}, {3.651487459515625*^9, 3.651487709078125*^9}, {
   3.65148788925*^9, 3.65148793678125*^9}, {3.651487994953125*^9, 
   3.651488148296875*^9}, {3.651488614671875*^9, 3.65148863115625*^9}, 
   3.6514897544375*^9, 3.65173941271875*^9, {3.651995357719846*^9, 
   3.651995363313596*^9}, {3.651996004329221*^9, 3.651996021454221*^9}, {
   3.651996669110471*^9, 3.651996669626096*^9}, {3.651997825922971*^9, 
   3.651997827844846*^9}, {3.651998079969846*^9, 3.651998085954221*^9}, {
   3.651998292704221*^9, 3.651998309532346*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"rcebilanceLn", ",", "rcebilance"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rcebilanceLn", "[", 
      RowBox[{"i_Integer", ",", "j_Integer"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"mca", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tain", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "-", 
           RowBox[{"Taout", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"mcb", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tbout", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "-", 
           RowBox[{"Tbin", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"kS", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tain", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "-", 
           RowBox[{"Taout", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}], "*", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"Abs", "[", 
            RowBox[{"(", 
             FractionBox[
              RowBox[{
               RowBox[{"Tain", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "-", 
               RowBox[{"Tbin", "[", 
                RowBox[{"i", ",", "j"}], "]"}]}], 
              RowBox[{
               RowBox[{"Taout", "[", 
                RowBox[{"i", ",", "j"}], "]"}], "-", 
               RowBox[{"Tbin", "[", 
                RowBox[{"i", ",", "j"}], "]"}]}]], ")"}], "]"}], "]"}], 
          RowBox[{"-", "1"}]]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rcebilance", "[", 
      RowBox[{"i_Integer", ",", "j_Integer"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"mca", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tain", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "-", 
           RowBox[{"Taout", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"mcb", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Tbout", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "-", 
           RowBox[{"Tbin", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"kS", "[", 
          RowBox[{"i", ",", "j"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"0.5", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Tain", "[", 
               RowBox[{"i", ",", "j"}], "]"}], "+", 
              RowBox[{"Taout", "[", 
               RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "-", 
           RowBox[{"Tbin", "[", 
            RowBox[{"i", ",", "j"}], "]"}]}], ")"}]}], "\[Equal]", 
        RowBox[{"Q", "[", 
         RowBox[{"i", ",", "j"}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojA", "[", 
      RowBox[{"i_Integer", ",", "j_Integer"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Taout", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "\[Equal]", 
       RowBox[{"Tain", "[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "j"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojB", "[", 
      RowBox[{
       RowBox[{"i_", "?", "EvenQ"}], ",", "j_Integer"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tbout", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "\[Equal]", 
       RowBox[{"Tbin", "[", 
        RowBox[{"i", ",", 
         RowBox[{"j", "+", "1"}]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojB", "[", 
      RowBox[{
       RowBox[{"i_", "?", "OddQ"}], ",", "j_Integer"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tbin", "[", 
        RowBox[{"i", ",", "j"}], "]"}], "\[Equal]", 
       RowBox[{"Tbout", "[", 
        RowBox[{"i", ",", 
         RowBox[{"j", "+", "1"}]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojDole", "[", 
      RowBox[{"i_", "?", "OddQ"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tbin", "[", 
        RowBox[{"i", ",", "jmax"}], "]"}], "\[Equal]", 
       RowBox[{"Tbout", "[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "jmax"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojDole", "[", 
      RowBox[{"i_", "?", "EvenQ"}], "]"}], ":=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojNahore", "[", 
      RowBox[{"i_", "?", "EvenQ"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tbin", "[", 
        RowBox[{"i", ",", "1"}], "]"}], "\[Equal]", 
       RowBox[{"Tbout", "[", 
        RowBox[{
         RowBox[{"i", "+", "1"}], ",", "1"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceSpojNahore", "[", 
      RowBox[{"i_", "?", "OddQ"}], "]"}], ":=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceVystupA", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"mca", "[", 
           RowBox[{"imax", ",", "j"}], "]"}], "*", 
          RowBox[{"Taout", "[", 
           RowBox[{"imax", ",", "j"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "jmax"}], "}"}]}], "]"}], "\[Equal]", 
       RowBox[{"Tavystup", "*", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"mca", "[", 
           RowBox[{"imax", ",", "j"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "jmax"}], "}"}]}], "]"}]}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rceVstupA", "[", "j_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tain", "[", 
        RowBox[{"1", ",", "j"}], "]"}], "\[Equal]", "Tavstup"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceVstupB", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"OddQ", "[", "imax", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Tbin", "[", 
          RowBox[{"imax", ",", "jmax"}], "]"}], "\[Equal]", "Tbvstup"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Tbin", "[", 
          RowBox[{"imax", ",", "1"}], "]"}], "\[Equal]", "Tbvstup"}], "}"}]}],
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rceVystupB", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tbout", "[", 
        RowBox[{"1", ",", "1"}], "]"}], "\[Equal]", "Tbvystup"}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6507885672172165`*^9, 3.6507885812797165`*^9}, {
   3.6507886978890915`*^9, 3.6507888021547165`*^9}, {3.6507888572015915`*^9, 
   3.6507889874984665`*^9}, {3.6507892127015915`*^9, 
   3.6507892184828415`*^9}, {3.6507892701703415`*^9, 
   3.6507892825922165`*^9}, {3.6507894145297165`*^9, 
   3.6507894339828415`*^9}, {3.6507895429203415`*^9, 
   3.6507896221547165`*^9}, {3.6507896758578415`*^9, 
   3.6507897282328415`*^9}, {3.6507897782484665`*^9, 
   3.6507898721078415`*^9}, {3.6507899287015915`*^9, 
   3.6507899612328415`*^9}, {3.6507899950609665`*^9, 
   3.6507900049047165`*^9}, {3.6507900427640915`*^9, 
   3.6507901196859665`*^9}, {3.6507902391859665`*^9, 
   3.6507903044359665`*^9}, {3.6507903612172165`*^9, 
   3.6507904302484665`*^9}, {3.6507905041547165`*^9, 
   3.6507906059672165`*^9}, {3.6507906911078415`*^9, 
   3.6507907672797165`*^9}, {3.6507918327484665`*^9, 
   3.6507918835140915`*^9}, {3.650886407328125*^9, 3.6508864108125*^9}, {
   3.650886476875*^9, 3.650886479984375*^9}, {3.65088681346875*^9, 
   3.650886815609375*^9}, {3.650889429515625*^9, 3.65088945565625*^9}, {
   3.650889534046875*^9, 3.650889557953125*^9}, {3.6508898038125*^9, 
   3.650889806046875*^9}, {3.65088986646875*^9, 3.650889879859375*^9}, {
   3.650889912578125*^9, 3.650889914828125*^9}, 3.65088995221875*^9, {
   3.650890786359375*^9, 3.65089078890625*^9}, 3.650891277359375*^9, {
   3.650891939765625*^9, 3.650891942171875*^9}, 3.650892314828125*^9, 
   3.650892386453125*^9, {3.65089243096875*^9, 3.65089243184375*^9}, {
   3.650892699484375*^9, 3.650892747203125*^9}, {3.65089444228125*^9, 
   3.650894454640625*^9}, {3.650894509328125*^9, 3.6508945426875*^9}, {
   3.651128273453125*^9, 3.651128284140625*^9}, {3.6511283661875*^9, 
   3.6511284033125*^9}, 3.651130313984375*^9, {3.651213804625*^9, 
   3.651213807140625*^9}, 3.6512138744375*^9, 3.65121457821875*^9, 
   3.651216677046875*^9, 3.651241732*^9, 3.65132509596875*^9, {3.651325249*^9,
    3.651325249171875*^9}, 3.6513252969375*^9, 3.651325337484375*^9, {
   3.65173422496875*^9, 3.6517342254375*^9}, 3.65173573821875*^9, {
   3.65173615765625*^9, 3.651736169*^9}, {3.651736290828125*^9, 
   3.651736296625*^9}, {3.651737314359375*^9, 3.651737332640625*^9}, {
   3.651737403765625*^9, 3.651737411453125*^9}, 3.651993727282346*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rcebilance", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "imax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1Ln", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rcebilanceLn", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "imax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceSpojA", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"imax", "-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r3", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceSpojB", "[", 
       RowBox[{"i", ",", "j"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "imax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"jmax", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r4", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceSpojDole", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"imax", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r4", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceSpojNahore", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"imax", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r5", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceSpojDole", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"imax", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r6", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"rceVstupA", "[", "j", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r7", "=", "rceVystupA"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r8", "=", "rceVstupB"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r9", "=", "rceVystupB"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rdohr", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"DeleteCases", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Union", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<r\>\"", "<>", 
            RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
         RowBox[{"Range", "[", "9", "]"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", "}"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rdohrLn", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"r1Ln", ",", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"Union", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ToExpression", "[", 
            RowBox[{"\"\<r\>\"", "<>", 
             RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"2", ",", "9", ",", "1"}], "]"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", "}"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6507909444203415`*^9, 3.6507910193109665`*^9}, {
   3.6507910578734665`*^9, 3.6507912196078415`*^9}, 3.6507912651390915`*^9, {
   3.6507915709828415`*^9, 3.6507916492484665`*^9}, {3.6507916991859665`*^9, 
   3.6507917538578415`*^9}, {3.6507918984984665`*^9, 
   3.6507920393578415`*^9}, {3.65088958878125*^9, 3.65088960521875*^9}, {
   3.65173426134375*^9, 3.651734357703125*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mcbStart", "=", 
     RowBox[{"msteckouB", "*", 
      RowBox[{"cpB", "[", "TbvstupZAdane", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mcaStart", "=", 
     RowBox[{"msteckouA", "*", 
      FractionBox[
       RowBox[{"kmax", "[", 
        RowBox[{"Round", "[", 
         RowBox[{"0.5", "*", "jmax"}], "]"}], "]"}], "nTrubekA"], "*", 
      RowBox[{"cpA", "[", "TavstupZadane", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ksStart", "=", 
     RowBox[{"kspom", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"100", ",", "100"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"TavstupZadane", ",", "TbvstupZAdane"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Round", "[", 
           RowBox[{"0.5", "*", "jmax"}], "]"}], ",", 
          RowBox[{"0.5", "*", "delkaVymeniku"}]}], "}"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dosalfasStart", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]a", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", 
           RowBox[{"2", "*", "ksStart"}]}], ",", 
          RowBox[{
           RowBox[{"\[Alpha]b", "[", 
            RowBox[{"i", ",", "j"}], "]"}], "->", 
           RowBox[{"2", "*", "ksStart"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "imax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.651995180907346*^9, 3.651995296063596*^9}, 
   3.651995411079221*^9, {3.651995719735471*^9, 3.651995806626096*^9}, 
   3.651995906547971*^9, {3.651996211407346*^9, 3.651996225438596*^9}, {
   3.651996259376096*^9, 3.651996287844846*^9}, {3.651996374329221*^9, 
   3.651996418079221*^9}, {3.651996451891721*^9, 3.651996461719846*^9}, {
   3.651996606501096*^9, 3.651996615063596*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dosTry", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"mcb", "[", 
         RowBox[{"_", ",", "_"}], "]"}], "\[RuleDelayed]", "mcbStart"}], ",", 
       RowBox[{
        RowBox[{"mca", "[", 
         RowBox[{"_", ",", "_"}], "]"}], "\[RuleDelayed]", "mcaStart"}], ",", 
       RowBox[{
        RowBox[{"kS", "[", 
         RowBox[{"_", ",", "_"}], "]"}], "\[RuleDelayed]", "ksStart"}], ",", 
       RowBox[{"Tavstup", "\[Rule]", "TavstupZadane"}], ",", 
       RowBox[{"Tbvstup", "\[Rule]", "TbvstupZAdane"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rdos", "=", 
     RowBox[{"rdohr", "/.", "dosTry"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nezname", "=", 
     RowBox[{"Union", "[", 
      RowBox[{
       RowBox[{"Cases", "[", 
        RowBox[{"rdos", ",", 
         RowBox[{"_", "[", 
          RowBox[{"_Integer", ",", "_Integer"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Tavystup", ",", "Tbvystup"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"resStart", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"rdos", ",", "nezname"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6507920475609665`*^9, 3.6507921977797165`*^9}, 
   3.65088984525*^9, {3.650890576375*^9, 3.650890627046875*^9}, {
   3.650890664171875*^9, 3.65089074771875*^9}, {3.65089081215625*^9, 
   3.65089097053125*^9}, {3.650891017421875*^9, 3.650891072359375*^9}, {
   3.650891108390625*^9, 3.6508911101875*^9}, {3.650891151140625*^9, 
   3.65089117359375*^9}, {3.650891225078125*^9, 3.65089124796875*^9}, {
   3.650891421421875*^9, 3.650891528234375*^9}, 3.650891932953125*^9, {
   3.650892444515625*^9, 3.650892445078125*^9}, {3.650892550234375*^9, 
   3.6508925508125*^9}, {3.6508926740625*^9, 3.65089268240625*^9}, {
   3.650892826203125*^9, 3.650892858953125*^9}, 3.650893095921875*^9, {
   3.65089331853125*^9, 3.65089336346875*^9}, {3.650893470640625*^9, 
   3.650893515640625*^9}, 3.65089432684375*^9, {3.650894490953125*^9, 
   3.65089450028125*^9}, {3.65112858109375*^9, 3.651128604796875*^9}, {
   3.65112908078125*^9, 3.651129094390625*^9}, {3.651242052*^9, 
   3.65124205253125*^9}, {3.65173951*^9, 3.651739554515625*^9}, {
   3.65173962065625*^9, 3.6517396488125*^9}, 3.651993859594846*^9, 
   3.651994089938596*^9, {3.651994877032346*^9, 3.651994884688596*^9}, {
   3.651994952563596*^9, 3.651994978126096*^9}, 3.651995093469846*^9, 
   3.651995305282346*^9, 3.651995469751096*^9, 3.651995520016721*^9, 
   3.651995600938596*^9, {3.651995696157346*^9, 3.651995708766721*^9}, 
   3.651995740922971*^9, 3.651995814954221*^9, 3.651995908407346*^9, 
   3.651996474172971*^9, 3.651996720891721*^9, {3.651996802282346*^9, 
   3.651996802969846*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "dos", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dos", "[", 
    RowBox[{"{", 
     RowBox[{"res_", ",", "doslast_"}], "}"}], "]"}], ":=", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Tavstup", "\[Rule]", "TavstupZadane"}], ",", 
       RowBox[{"Tbvstup", "\[Rule]", "TbvstupZAdane"}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"doskSij", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", "j", ",", "res"}], "}"}], ",", "doslast"}], 
          "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "imax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "jmax"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosStart", "=", 
   RowBox[{"dos", "[", 
    RowBox[{"{", 
     RowBox[{"resStart", ",", "dosalfasStart"}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.651487789796875*^9, 3.651487800140625*^9}, {
   3.651488244140625*^9, 3.651488346375*^9}, {3.651488701953125*^9, 
   3.651488721734375*^9}, {3.65148939171875*^9, 3.65148945896875*^9}, {
   3.651489776421875*^9, 3.651489809984375*^9}, 3.65148985365625*^9, 
   3.651490044390625*^9, {3.651490220796875*^9, 3.651490227109375*^9}, {
   3.651490296046875*^9, 3.6514903023125*^9}, {3.65173957284375*^9, 
   3.65173957715625*^9}, 3.651739665765625*^9, {3.6518115980625*^9, 
   3.6518116543125*^9}, {3.6518117040625*^9, 3.651811765703125*^9}, 
   3.651811817671875*^9, {3.651811983*^9, 3.651811983578125*^9}, {
   3.65181238140625*^9, 3.65181238821875*^9}, {3.6518124321875*^9, 
   3.65181243296875*^9}, {3.651812852015625*^9, 3.651812859796875*^9}, 
   3.651996822188596*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"krokLin", ",", "krokLinLn", ",", "krokLn", ",", "krok"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"krokLin", "[", 
     RowBox[{"{", 
      RowBox[{"doslast_", ",", "res_", ",", "iter_Integer"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "resNew", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"resNew", "=", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"rdohr", "/.", "doslast"}], ",", "nezname"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dos", "[", 
          RowBox[{"{", 
           RowBox[{"resNew", ",", "doslast"}], "}"}], "]"}], ",", "resNew", 
         ",", 
         RowBox[{"iter", "+", "1"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"krokLinLn", "[", 
     RowBox[{"{", 
      RowBox[{"doslast_", ",", "res_", ",", "iter_Integer"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "resNew", ",", "dosNew", ",", "rdohrNew", ",", "obory", ",", "resLn"}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"resNew", "=", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"rdohr", "/.", "doslast"}], ",", "nezname"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"dosNew", "=", 
        RowBox[{"dos", "[", 
         RowBox[{"{", 
          RowBox[{"resNew", ",", "doslast"}], "}"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"rdohrNew", "=", 
        RowBox[{"rdohrLn", "/.", "dosNew"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"obory", "=", 
        RowBox[{"resNew", "/.", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_", "\[Rule]", "b_"}], ")"}], "\[RuleDelayed]", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"resLn", "=", 
        RowBox[{"FindRoot", "[", 
         RowBox[{"rdohrNew", ",", "obory"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dos", "[", 
          RowBox[{"{", 
           RowBox[{"resLn", ",", "dosNew"}], "}"}], "]"}], ",", "resLn", ",", 
         RowBox[{"iter", "+", "1"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\n", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"krokLn", "[", 
     RowBox[{"{", 
      RowBox[{"doslast_", ",", "res_", ",", "iter_Integer"}], "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "resNew", ",", "dosNew", ",", "rdohrNew", ",", "obory", ",", "resLn"}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rdohrNew", "=", 
        RowBox[{"rdohrLn", "/.", "doslast"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"obory", "=", 
        RowBox[{"res", "/.", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_", "\[Rule]", "b_"}], ")"}], "\[RuleDelayed]", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"resLn", "=", 
        RowBox[{"FindRoot", "[", 
         RowBox[{"rdohrNew", ",", "obory"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dos", "[", 
          RowBox[{"{", 
           RowBox[{"resLn", ",", "doslast"}], "}"}], "]"}], ",", "resLn", ",", 
         RowBox[{"iter", "+", "1"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\n", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", 
    RowBox[{"par", ":", 
     RowBox[{"{", 
      RowBox[{"doslast_", ",", "res_", ",", "iter_Integer"}], "}"}]}], "]"}], 
   ":=", 
   RowBox[{"Which", "[", 
    RowBox[{
     RowBox[{"iter", "<", "2"}], ",", 
     RowBox[{"krokLin", "[", "par", "]"}], ",", 
     RowBox[{"2", "\[LessEqual]", "iter", "<", "3"}], ",", 
     RowBox[{"krokLinLn", "[", "par", "]"}], ",", 
     RowBox[{"iter", "\[GreaterEqual]", "3"}], ",", 
     RowBox[{"krokLn", "[", "par", "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.651812998296875*^9, 3.651813005640625*^9}, {
   3.651813042359375*^9, 3.651813059359375*^9}, {3.651813204984375*^9, 
   3.65181321403125*^9}, 3.651996829297971*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "tav", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tav", "[", 
    RowBox[{"{", 
     RowBox[{"doslast_", ",", "res_", ",", "iter_Integer"}], "}"}], "]"}], ":=", 
   RowBox[{"Tavystup", "/.", "res"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", 
     RowBox[{"{", 
      RowBox[{"dosStart", ",", "resStart", ",", "1"}], "}"}], ",", "4"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dosVys", ",", "resVys", ",", "iterVys"}], "}"}], "=", 
   RowBox[{"dats", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dosvys", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"dosVys", ",", "resVys"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"tav", "/@", "dats"}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", 
  RowBox[{"Last", "[", "%", "]"}]}]}], "Input",
 CellChangeTimes->{
  3.65181311975*^9, 3.6518132311875*^9, {3.651827374078125*^9, 
   3.651827398875*^9}, 3.651993753141721*^9, 3.651996836985471*^9, 
   3.651996880329221*^9, {3.651996911501096*^9, 3.651996953110471*^9}, {
   3.651997042751096*^9, 3.651997055547971*^9}, 3.651997480047971*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pla", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"Taout", "[", 
            RowBox[{"#", ",", "2"}], "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Range", "[", "imax", "]"}]}], ")"}], "/.", "dosvys"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<i [-]\>\"", ",", "\"\<T [\[Degree]C]\>\""}], " ", 
       "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plb", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"#", ",", 
            RowBox[{"Tbout", "[", 
             RowBox[{"#", ",", "2"}], "]"}]}], "}"}], "&"}], "/@", 
         RowBox[{"Range", "[", "imax", "]"}]}], ")"}], "/.", "dosvys"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Blue"}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sipka", "[", 
    RowBox[{"barva_", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}]}], "]"}], ":=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"barva", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1", ",", "y1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2", ",", "y2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{
    RowBox[{"sipka", "[", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.4", "*", "imax"}], ",", 
          RowBox[{"Tavstup", "-", "10"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.6", "imax"}], ",", 
          RowBox[{"Tavstup", "-", "10"}]}], "}"}]}], "}"}]}], "]"}], "/.", 
    "dosvys"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{
    RowBox[{"sipka", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.6", "*", "imax"}], ",", "Tbvstup"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"0.4", "imax"}], ",", "Tbvstup"}], "}"}]}], "}"}]}], "]"}], 
    "/.", "dosvys"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pla", ",", "plb", ",", "s1", ",", "s2", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "100"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.650892906*^9, 3.65089299509375*^9}, {3.650893034625*^9, 
   3.650893046328125*^9}, {3.650893121765625*^9, 3.65089312253125*^9}, {
   3.650893255765625*^9, 3.650893304625*^9}, {3.650893386359375*^9, 
   3.6508934570625*^9}, {3.650893548515625*^9, 3.650893588109375*^9}, {
   3.650894029703125*^9, 3.650894047359375*^9}, {3.6511286208125*^9, 
   3.65112862815625*^9}, 3.65112868909375*^9, {3.651129026875*^9, 
   3.651129027765625*^9}, {3.651489703453125*^9, 3.6514897119375*^9}, 
   3.651993911344846*^9, {3.651997062985471*^9, 3.651997078563596*^9}, {
   3.651997162079221*^9, 3.651997165547971*^9}, 3.651998499001096*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vykon1", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"Cases", "[", 
        RowBox[{"resVys", ",", 
         RowBox[{"Q", "[", 
          RowBox[{"_Integer", ",", "_Integer"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], "/.", 
      "dosvys"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vykon2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Tavstup", "*", "msteckouA", "*", 
       RowBox[{"cpA", "[", "Tavstup", "]"}]}], "-", 
      RowBox[{"Tavystup", "*", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mca", "[", 
          RowBox[{"imax", ",", "j"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "jmax"}], "}"}]}], "]"}]}]}], ")"}], "/.",
     "dosvys"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vykon3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"mcb", "[", 
        RowBox[{"1", ",", "jmax"}], "]"}], "*", "Tbvystup"}], "-", 
      RowBox[{"msteckouB", "*", 
       RowBox[{"cpB", "[", "Tbvstup", "]"}], "*", "Tbvstup"}]}], ")"}], "/.", 
    "dosvys"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"vykon1", ",", "vykon2", ",", "vykon3"}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Tavstup", "-", "Tavystup"}], ",", 
      RowBox[{"Tbvystup", "-", "Tbvstup"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Tavystup", ",", "Tbvystup"}], "}"}]}], "}"}], "/.", 
  "dosvys"}]}], "Input",
 CellChangeTimes->{{3.651997110172971*^9, 3.651997129579221*^9}, {
  3.651997406172971*^9, 3.651997464360471*^9}, {3.651997657969846*^9, 
  3.651997679110471*^9}, {3.651997753501096*^9, 3.651997785188596*^9}, {
  3.651997977204221*^9, 3.651997992126096*^9}, {3.651998029235471*^9, 
  3.651998044219846*^9}, {3.651998530047971*^9, 3.651998548282346*^9}}]
},
WindowSize->{1147, 767},
WindowMargins->{{-6, Automatic}, {Automatic, 7}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1336, 27, 131, "Input"],
Cell[1884, 49, 853, 21, 271, "Input"],
Cell[2740, 72, 11230, 279, 1120, "Input"],
Cell[13973, 353, 20713, 538, 3038, "Input"],
Cell[34689, 893, 10225, 272, 724, "Input"],
Cell[44917, 1167, 4366, 131, 467, "Input"],
Cell[49286, 1300, 2169, 57, 329, "Input"],
Cell[51458, 1359, 3020, 64, 215, "Input"],
Cell[54481, 1425, 1862, 45, 131, "Input"],
Cell[56346, 1472, 4701, 124, 831, "Input"],
Cell[61050, 1598, 1321, 34, 215, "Input"],
Cell[62374, 1634, 4204, 117, 327, "Input"],
Cell[66581, 1753, 2037, 57, 187, "Input"]
}
]
*)

(* End of internal cache information *)
