(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10786,        301]
NotebookOptionsPosition[     10385,        284]
NotebookOutlinePosition[     10764,        300]
CellTagsIndexPosition[     10721,        297]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proms", "=", 
   RowBox[{"ToString", "/@", 
    RowBox[{"{", 
     RowBox[{"Qout", ",", "T2", ",", "Pmechout", ",", "Qin", ",", "T4"}], 
     "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.749185764231646*^9, 3.7491857933410206`*^9}, {
  3.7491863424660206`*^9, 3.749186342825396*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m1", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c2", "=", "c1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tout", "=", "35."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]out", "=", "10."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej1", "[", 
    RowBox[{"{", 
     RowBox[{"kS_", ",", "m2_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rceSpolecne", ",", "T2", ",", "T3", ",", "T4", ",", "Pmechout", ",", 
       "Qout", ",", "\[CapitalDelta]1", ",", "\[CapitalDelta]2", ",", 
       RowBox[{"\[Eta]TD", "=", "0.6"}], ",", "\[Eta]Carnot", ",", "Qin", ",",
        "rceLin", ",", "rceLog", ",", "dospoc", ",", "proms", ",", "sol"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]1", "=", 
       RowBox[{"T1", "-", "T4"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalDelta]2", "=", 
       RowBox[{"T2", "-", "T3"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"T3", "=", 
       RowBox[{"Tout", "+", "\[CapitalDelta]out"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Eta]Carnot", "=", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"Tout", "+", "273"}], 
         RowBox[{"T4", "+", "273."}]]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rceSpolecne", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Qin", "\[Equal]", 
          RowBox[{"m1", "*", "c1", "*", 
           RowBox[{"(", 
            RowBox[{"T1", "-", "T2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Qin", "\[Equal]", 
          RowBox[{"m2", "*", "c2", "*", 
           RowBox[{"(", 
            RowBox[{"T4", "-", "T3"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Qin", "\[Equal]", 
          RowBox[{"Pmechout", "+", "Qout"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Pmechout", "==", 
          RowBox[{"\[Eta]Carnot", "*", "\[Eta]TD", "*", "Qin"}]}]}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rceLin", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"rceSpolecne", ",", 
         RowBox[{"{", 
          RowBox[{"Qin", "\[Equal]", 
           RowBox[{"kS", "*", 
            FractionBox[
             RowBox[{"\[CapitalDelta]1", "+", "\[CapitalDelta]2"}], "2"]}]}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rceLog", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"rceSpolecne", ",", 
         RowBox[{"{", 
          RowBox[{"Qin", "\[Equal]", 
           RowBox[{"kS", "*", 
            FractionBox[
             RowBox[{"\[CapitalDelta]1", "-", "\[CapitalDelta]2"}], 
             RowBox[{"Log", "[", 
              FractionBox["\[CapitalDelta]1", "\[CapitalDelta]2"], "]"}]]}]}],
           "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dospoc", "=", 
       RowBox[{
        RowBox[{"Solve", "[", "rceLin", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"proms", "=", 
       RowBox[{"First", "/@", "dospoc"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"Quiet", "@", 
         RowBox[{"FindRoot", "[", 
          RowBox[{"rceLog", ",", 
           RowBox[{"Thread", "[", 
            RowBox[{"{", 
             RowBox[{"proms", ",", 
              RowBox[{"(", 
               RowBox[{"proms", "/.", "dospoc"}], ")"}]}], "}"}], "]"}]}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"{", 
        RowBox[{"Qout", ",", "T2", ",", "Pmechout", ",", "Qin", ",", "T4"}], 
        "}"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"proms", "/.", "sol"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7491799516535206`*^9, 3.749180524981646*^9}, {
   3.7491806226222706`*^9, 3.749180707669146*^9}, {3.749180746200396*^9, 
   3.7491807494035206`*^9}, {3.7491808221222706`*^9, 3.749180850106646*^9}, {
   3.7491817817785206`*^9, 3.7491818751222706`*^9}, {3.749182024200396*^9, 
   3.749182156887896*^9}, {3.7491821994972706`*^9, 3.7491822863097706`*^9}, {
   3.749182318950396*^9, 3.7491823887160206`*^9}, 3.749182423106646*^9, {
   3.7491824787160206`*^9, 3.7491824915910206`*^9}, {3.7491825621535206`*^9, 
   3.7491826796222706`*^9}, {3.749186334919146*^9, 3.7491863353722706`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej2", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej2", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kS_", ",", "m2_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Aa_", ",", "Ab_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cPmech_", ",", "cQout_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "Qout", ",", "T2", ",", "Pmechout", ",", "Qin", ",", "T4", ",", "CF"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Qout", ",", "T2", ",", "Pmechout", ",", "Qin", ",", "T4"}], 
        "}"}], "=", 
       RowBox[{"vydej1", "[", 
        RowBox[{"{", 
         RowBox[{"kS", ",", "m2"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CF", "=", 
       RowBox[{
        RowBox[{"Pmechout", "*", "cPmech"}], "+", 
        RowBox[{"Qout", "*", "cQout"}], "-", 
        RowBox[{"(", 
         RowBox[{"Aa", "+", 
          RowBox[{"Ab", "*", "kS"}]}], ")"}]}]}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7491825080285206`*^9, 3.749182517981646*^9}, {
  3.749182694637896*^9, 3.7491829972785206`*^9}, {3.749186306887896*^9, 
  3.749186307856646*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej3", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Aa", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ab", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cPmech", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cQout", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej3", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"kS_", "?", "NumberQ"}], ",", 
      RowBox[{"m2_", "?", "NumberQ"}]}], "}"}], "]"}], ":=", 
   RowBox[{"vydej2", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kS", ",", "m2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Aa", ",", "Ab"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cPmech", ",", "cQout"}], "}"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vys", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"FindMaximum", "[", 
     RowBox[{
      RowBox[{"vydej3", "[", 
       RowBox[{"{", 
        RowBox[{"kS", ",", "m2"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"kS", ",", "1300"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"m2", ",", "1"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"myR", ":=", 
   RowBox[{
    RowBox[{"0.01", 
     RowBox[{"Round", "[", 
      RowBox[{"100", "#"}], "]"}]}], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vysledek", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Qout", ",", "T2", ",", "Pmechout", ",", "Qin", ",", "T4"}], 
     "}"}], "=", 
    RowBox[{"vydej1", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"kS", ",", "m2"}], "}"}], "/.", 
      RowBox[{"vys", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ToString", "[", " ", "#", "]"}], "<>", "\"\<=\>\""}], 
         "&"}], "/@", "proms"}], ")"}], "[", 
      RowBox[{"[", "#", "]"}], "]"}], "<>", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ToString", "/@", 
        RowBox[{"(", 
         RowBox[{"myR", "/@", "vysledek"}], ")"}]}], ")"}], "[", 
      RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", 
   RowBox[{"Range", "[", 
    RowBox[{"Length", "[", "proms", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "*", 
  RowBox[{"{", 
   RowBox[{
   "\"\<W\>\"", ",", "\"\<\[Degree]C\>\"", ",", "\"\<W\>\"", ",", "\"\<W\>\"",
     ",", "\"\<\[Degree]C\>\""}], 
   "}"}]}], "\[IndentingNewLine]", "vys", "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.749183020762896*^9, 3.7491830230910206`*^9}, {
  3.7491830543722706`*^9, 3.7491832312785206`*^9}, {3.7491832699972706`*^9, 
  3.7491832800910206`*^9}, {3.7491833327785206`*^9, 3.7491833551222706`*^9}, {
  3.749183513481646*^9, 3.7491835208410206`*^9}, {3.749183815512896*^9, 
  3.7491838162160206`*^9}, {3.7491863151535206`*^9, 3.7491863315597706`*^9}}]
},
WindowSize->{985, 743},
WindowMargins->{{8, Automatic}, {Automatic, 3}},
Magnification->1.7000001668930054`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 657, 18, 136, "Input"],
Cell[1217, 40, 4753, 109, 1030, "Input"],
Cell[5973, 151, 1362, 39, 194, "Input"],
Cell[7338, 192, 3043, 90, 484, "Input"]
}
]
*)

(* End of internal cache information *)
