(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      3589,        114]
NotebookOptionsPosition[      3234,         98]
NotebookOutlinePosition[      3613,        114]
CellTagsIndexPosition[      3570,        111]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"plerror", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"100", "*", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"\[Xi]", "-", "1"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Xi]", "+", "1"}], ")"}], "*", 
         RowBox[{"Log", "[", "\[Xi]", "]"}]}]]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Xi]", ",", "0.5", ",", "2"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", " ", "Thick"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<\!\(\*FractionBox[\(\[CapitalDelta]1\), \
\(\[CapitalDelta]2\)]\)\>\"", ",", "\"\<\[Delta]P [%]\>\""}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<chyba pouziti \!\(\*FractionBox[\(\[CapitalDelta]1 + \
\[CapitalDelta]2\), \(2\)]\) misto \!\(\*FractionBox[\(\[CapitalDelta]1 - \
\[CapitalDelta]2\), \(ln \*FractionBox[\(\[CapitalDelta]1\), \
\(\[CapitalDelta]2\)]\)]\)\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.748594170078125*^9, 3.74859430925*^9}, {
  3.7485943399375*^9, 3.748594419984375*^9}, {3.748594485734375*^9, 
  3.748594487875*^9}}],

Cell[BoxData[
 RowBox[{"exp", "[", "plerror", "]"}]], "Input",
 CellChangeTimes->{{3.748594530640625*^9, 3.748594535515625*^9}}]
},
WindowSize->{878, 743},
WindowMargins->{{8, Automatic}, {Automatic, 3}},
Magnification->1.8000001907348633`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1163, 35, 277, "Input"],
Cell[1723, 57, 1376, 35, 291, "Input"],
Cell[3102, 94, 128, 2, 52, "Input"]
}
]
*)

(* End of internal cache information *)
