(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10457,        300]
NotebookOptionsPosition[      9893,        278]
NotebookOutlinePosition[     10358,        297]
CellTagsIndexPosition[     10315,        294]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "souproudy", " ", "a", " ", "protiproudy", " ", "vymenik", " ", "pro", " ",
     "rekuperaci", " ", "tepla", " ", "z", " ", "vetraciho", " ", "vzduchu"}],
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"exp", ",", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"exp", "[", "co_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "graf"}], "}"}], ",", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"ToString", "[", 
          RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
        RowBox[{"graf", ":=", 
         RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
        RowBox[{"Export", "[", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
          RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}],
     ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7491897877160206`*^9, 3.7491897881222706`*^9}, {
  3.7491898793097706`*^9, 3.749189903169146*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Tout", "=", 
   RowBox[{"-", "10"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tin", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T1", "=", "Tin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T2", "=", "Tout"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]1", "=", 
   RowBox[{"T1", "-", "T4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]2", "=", 
   RowBox[{"T3", "-", "T2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Volume", "=", 
   RowBox[{"10", "*", "5", "*", "2.5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"timeOfAirExchange", "=", 
   RowBox[{"3", "*", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"density", "=", 
   FractionBox["349", 
    RowBox[{"Tin", "+", "273"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"massFlow", "=", 
   FractionBox[
    RowBox[{"Volume", "*", "density"}], "timeOfAirExchange"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<massFlow= \>\"", ",", "massFlow", ",", 
   "\"\< kg.\!\(\*SuperscriptBox[\(s\), \(-1\)]\)\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Q", "\[Equal]", 
      RowBox[{"kS", "*", 
       FractionBox[
        RowBox[{"\[CapitalDelta]1", "+", "\[CapitalDelta]2"}], "2"]}]}], ",", 
     RowBox[{"Q", "\[Equal]", 
      RowBox[{"massFlow", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"T1", "-", "T3"}], ")"}]}]}], ",", 
     RowBox[{"Q", "\[Equal]", 
      RowBox[{"massFlow", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"T4", "-", "T2"}], ")"}]}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QwithoutExchanger", "=", 
   RowBox[{"massFlow", "*", "c", "*", 
    RowBox[{"(", 
     RowBox[{"Tin", "-", "Tout"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<needed heat for ventilation= \>\"", ",", "QwithoutExchanger", ",", 
   "\"\< W\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QwithHeatExchanger", "=", 
   RowBox[{
    RowBox[{"massFlow", "*", "c", "*", 
     RowBox[{"(", 
      RowBox[{"Tin", "-", "T4"}], ")"}]}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Quiet", "@", 
       RowBox[{"Solve", "[", "eqns", "]"}]}], ")"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pl1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{"QwithHeatExchanger", ",", 
    RowBox[{"{", 
     RowBox[{"kS", ",", "0", ",", "130"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1.1", "QwithoutExchanger"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Red"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<kS [W/K]\>\"", ",", "\"\<Q [W]\>\""}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.698131967454345*^9, 3.6981320963573713`*^9}, {
  3.698132179302717*^9, 3.6981322573028545`*^9}, {3.6981323035881357`*^9, 
  3.698132523626522*^9}, {3.6981325593973846`*^9, 3.6981326401275268`*^9}, {
  3.698132784770981*^9, 3.6981329440784607`*^9}, {3.6981333865576377`*^9, 
  3.69813343908293*^9}, {3.698134211830287*^9, 3.698134217321497*^9}, {
  3.749189973856646*^9, 3.7491899832160206`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]1", "=", 
     RowBox[{"T1", "-", "T2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]2", "=", 
     RowBox[{"T3", "-", "T4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eqnsLog", "[", "kS_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Q", "\[Equal]", 
        RowBox[{"kS", "*", 
         FractionBox[
          RowBox[{"\[CapitalDelta]1", "-", "\[CapitalDelta]2"}], 
          RowBox[{"Log", "[", 
           FractionBox["\[CapitalDelta]1", "\[CapitalDelta]2"], "]"}]]}]}], 
       ",", 
       RowBox[{"Q", "\[Equal]", 
        RowBox[{"massFlow", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"T1", "-", "T3"}], ")"}]}]}], ",", 
       RowBox[{"Q", "\[Equal]", 
        RowBox[{"massFlow", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"T4", "-", "T2"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol", "[", "kS_", "]"}], ":=", 
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{"eqnsLog", "[", "kS", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "300"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"T3", ",", "15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"T4", ",", "10"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "[", "20", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6981335680171566`*^9, 3.698133569311959*^9}, {
  3.698133682037757*^9, 3.6981336921933746`*^9}, {3.698133748759074*^9, 
  3.698133764468302*^9}, {3.698133863091675*^9, 3.6981340322115717`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "QwithHeatExchanger", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QwithoutExchanger", "=", 
   RowBox[{"massFlow", "*", "c", "*", 
    RowBox[{"(", 
     RowBox[{"Tin", "-", "Tout"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<needed heat for ventilation= \>\"", ",", "QwithoutExchanger", ",", 
   "\"\< W\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QwithHeatExchanger", "[", "kS_", "]"}], ":=", 
   RowBox[{
    RowBox[{"massFlow", "*", "c", "*", 
     RowBox[{"(", 
      RowBox[{"Tin", "-", "T4"}], ")"}]}], "/.", 
    RowBox[{"sol", "[", "kS", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6981335680171566`*^9, 3.698133569311959*^9}, {
  3.698133682037757*^9, 3.6981336921933746`*^9}, {3.698133748759074*^9, 
  3.698133762471498*^9}, {3.6981340973572865`*^9, 3.698134181675434*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"QwithHeatExchanger", "[", "kS", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"kS", ",", "0", ",", "130"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"1.1", "QwithoutExchanger"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<kS [W/K]\>\"", ",", "\"\<Q [W]\>\""}], "}"}]}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.6981335680171566`*^9, 3.698133569311959*^9}, {
  3.698133682037757*^9, 3.6981336921933746`*^9}, {3.698133748759074*^9, 
  3.698133762471498*^9}, {3.6981340973572865`*^9, 3.6981341035192966`*^9}, {
  3.6981341871198435`*^9, 3.6981342296455183`*^9}, {3.749189813419146*^9, 
  3.749189814981646*^9}}],

Cell[BoxData[{
 RowBox[{"plSouHaProti", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", "pl2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "[", "plSouHaProti", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6981342432019424`*^9, 3.698134248630752*^9}, {
  3.7491898290910206`*^9, 3.7491898474972706`*^9}, {3.749189929419146*^9, 
  3.749189931075396*^9}}]
},
WindowSize->{1105, 758},
WindowMargins->{{24, Automatic}, {Automatic, 30}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1597, 44, 215, "Input"],
Cell[2157, 66, 3636, 99, 652, "Input"],
Cell[5796, 167, 1694, 46, 238, "Input"],
Cell[7493, 215, 931, 23, 131, "Input"],
Cell[8427, 240, 1082, 26, 103, "Input"],
Cell[9512, 268, 377, 8, 75, "Input"]
}
]
*)

(* End of internal cache information *)
