(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9329,        271]
NotebookOptionsPosition[      8932,        254]
NotebookOutlinePosition[      9311,        270]
CellTagsIndexPosition[      9268,        267]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m1", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T3", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", "1000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c2", "=", "c1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej1", "[", 
    RowBox[{"{", 
     RowBox[{"kS_", ",", "m2_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "rceSpolecne", ",", "T2", ",", "T4", ",", "\[CapitalDelta]1", ",", 
       "\[CapitalDelta]2", ",", "Qin", ",", "rceLin", ",", "rceLog", ",", 
       "dospoc", ",", "proms", ",", "sol"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]1", "=", 
       RowBox[{"T1", "-", "T4"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalDelta]2", "=", 
       RowBox[{"T2", "-", "T3"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"rceSpolecne", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Qin", "\[Equal]", 
          RowBox[{"m1", "*", "c1", "*", 
           RowBox[{"(", 
            RowBox[{"T1", "-", "T2"}], ")"}]}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Qin", "\[Equal]", 
          RowBox[{"m2", "*", "c2", "*", 
           RowBox[{"(", 
            RowBox[{"T4", "-", "T3"}], ")"}]}]}]}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rceLin", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"rceSpolecne", ",", 
         RowBox[{"{", 
          RowBox[{"Qin", "\[Equal]", 
           RowBox[{"kS", "*", 
            FractionBox[
             RowBox[{"\[CapitalDelta]1", "+", "\[CapitalDelta]2"}], "2"]}]}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rceLog", "=", 
       RowBox[{"Union", "[", 
        RowBox[{"rceSpolecne", ",", 
         RowBox[{"{", 
          RowBox[{"Qin", "\[Equal]", 
           RowBox[{"kS", "*", 
            FractionBox[
             RowBox[{"\[CapitalDelta]1", "-", "\[CapitalDelta]2"}], 
             RowBox[{"Log", "[", 
              FractionBox["\[CapitalDelta]1", "\[CapitalDelta]2"], "]"}]]}]}],
           "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"dospoc", "=", 
       RowBox[{
        RowBox[{"Solve", "[", "rceLin", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"proms", "=", 
       RowBox[{"First", "/@", "dospoc"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{"Quiet", "@", 
         RowBox[{"FindRoot", "[", 
          RowBox[{"rceLog", ",", 
           RowBox[{"Thread", "[", 
            RowBox[{"{", 
             RowBox[{"proms", ",", 
              RowBox[{"(", 
               RowBox[{"proms", "/.", "dospoc"}], ")"}]}], "}"}], "]"}]}], 
          "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Qin", ",", "T2", ",", "T4"}], "}"}], "/.", "sol"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7491799516535206`*^9, 3.749180524981646*^9}, {
   3.7491806226222706`*^9, 3.749180707669146*^9}, {3.749180746200396*^9, 
   3.7491807494035206`*^9}, {3.7491808221222706`*^9, 3.749180850106646*^9}, {
   3.7491817817785206`*^9, 3.7491818751222706`*^9}, {3.749182024200396*^9, 
   3.749182156887896*^9}, {3.7491821994972706`*^9, 3.7491822863097706`*^9}, {
   3.749182318950396*^9, 3.7491823887160206`*^9}, 3.749182423106646*^9, {
   3.7491824787160206`*^9, 3.7491824915910206`*^9}, {3.7491825621535206`*^9, 
   3.7491826796222706`*^9}, {3.749186334919146*^9, 3.7491863353722706`*^9}, {
   3.749186627075396*^9, 3.749186627887896*^9}, {3.7491869612160206`*^9, 
   3.7491870861847706`*^9}, {3.749187147325396*^9, 3.749187237856646*^9}, {
   3.749187829325396*^9, 3.7491878296847706`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mmin", "=", 
   RowBox[{"0.05", "m1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mmax", "=", 
   RowBox[{"100", "m1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nEmek", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RadicalBox[
    FractionBox["mmax", "mmin"], "nEmek"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"emka", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"mmin", "*", 
      SuperscriptBox["q", 
       RowBox[{"#", "-", "1"}]]}], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"rn", "=", 
      RowBox[{"Range", "[", 
       RowBox[{"nEmek", "+", "1"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"vydej1", "[", 
        RowBox[{"{", 
         RowBox[{"1500", ",", "#"}], "}"}], "]"}]}], "}"}], "&"}], "/@", 
    "emka"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListLogLinearPlot", "[", 
    RowBox[{
     RowBox[{"data", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m2_", ",", 
         RowBox[{"{", 
          RowBox[{"Qin_", ",", "T2_", ",", "T4_"}], "}"}]}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"m2", ",", "T4"}], "}"}]}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<m2 [kg/s]\>\"", ",", "\"\<\!\(\*
StyleBox[\"T4\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"\[Degree]C\",
FontColor->RGBColor[1, 0, 0]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[1, 0, 0]]\), \!\(\*
StyleBox[\"Q\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\" \",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"[\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"kW\",
FontColor->RGBColor[0, 0, 1]]\)\!\(\*
StyleBox[\"]\",
FontColor->RGBColor[0, 0, 1]]\)\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ListLogLinearPlot", "[", 
    RowBox[{
     RowBox[{"data", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m2_", ",", 
         RowBox[{"{", 
          RowBox[{"Qin_", ",", "T2_", ",", "T4_"}], "}"}]}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"m2", ",", 
         FractionBox["Qin", "1000"]}], "}"}]}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.749187253262896*^9, 3.749187671950396*^9}, {
  3.749187732544146*^9, 3.7491878456847706`*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"data", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m2_", ",", 
       RowBox[{"{", 
        RowBox[{"Qin_", ",", "T2_", ",", "T4_"}], "}"}]}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"T4", ",", 
       FractionBox["Qin", "1000"]}], "}"}]}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<T4 [\[Degree]C]\>\"", ",", "\"\<Q [kW]\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7491878865285206`*^9, 3.7491879524035206`*^9}}]
},
WindowSize->{985, 743},
WindowMargins->{{8, Automatic}, {Automatic, 3}},
Magnification->1.7000001668930054`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 330, 9, 107, "Input"],
Cell[890, 31, 4101, 95, 853, "Input"],
Cell[4994, 128, 3153, 100, 461, "Input"],
Cell[8150, 230, 778, 22, 149, "Input"]
}
]
*)

(* End of internal cache information *)
