(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15187,        384]
NotebookOptionsPosition[     14223,        360]
NotebookOutlinePosition[     14851,        382]
CellTagsIndexPosition[     14808,        379]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"koeficienty", "=", 
   RowBox[{"N", "[", 
    RowBox[{"<<", "\"\<koeficienty\>\""}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.725635030921875*^9, 
  3.72563503215625*^9}},ExpressionUUID->"040535f3-6424-4597-97c6-\
02e5da008f83"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "znatelny", " ", "vliv", " ", "vnitrniho", " ", "odporu", " ", "zdroje", 
   " ", "a", " ", 
   RowBox[{
    RowBox[{"kapacity", "!!"}], "!"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.714292269294443*^9, 3.7142922817788177`*^9}, {
  3.725535301859375*^9, 
  3.725535310765625*^9}},ExpressionUUID->"1d956e27-ba7b-4cd8-8baa-\
ecfa16514db6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Uz0", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ri", "=", "15.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]F", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cz", "=", 
   RowBox[{"100", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1.8", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2.", "*", 
    FractionBox["Pi", "T"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ns", "=", "480"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"i", ",", "t", ",", "ipom"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"np", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ipom", "[", "t_", "]"}], ":=", 
    RowBox[{"0.5", "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"ns", "*", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"0.5", "\[Omega]", "*", "t"}], "+", 
            RowBox[{"0.5", "Pi", "*", 
             RowBox[{"Random", "[", "]"}]}]}], "]"}], "132"]}], "]"}], 
       RowBox[{"Cosh", "[", 
        RowBox[{"1.00", "*", "ns"}], "]"}]], ")"}], "*", 
     RowBox[{"Tanh", "[", 
      FractionBox["t", 
       RowBox[{"0.1", "T"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"i", "[", "t_", "]"}], "=", 
    RowBox[{
     FractionBox["2.", "np"], 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ipom", "[", "t", "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "np", "]"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"i", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.71419371778125*^9, 3.714193959359375*^9}, {
   3.714194227921875*^9, 3.71419424175*^9}, {3.714195117390625*^9, 
   3.714195119125*^9}, {3.7141953094375*^9, 3.71419530975*^9}, 
   3.71419556215625*^9, {3.714195902703125*^9, 3.7141959211875*^9}, {
   3.714202467109375*^9, 3.714202500234375*^9}, {3.7142028041875*^9, 
   3.714202804515625*^9}, {3.714204518578125*^9, 3.714204518734375*^9}, {
   3.714208001390625*^9, 3.7142080286875*^9}, 3.71420809446875*^9, {
   3.71421047840625*^9, 3.714210493296875*^9}, 3.714210540234375*^9, {
   3.7142917179975677`*^9, 3.714291718263193*^9}, 3.714292075825693*^9, {
   3.714292112731943*^9, 3.714292200825693*^9}, 3.714292258106943*^9, {
   3.71437291753125*^9, 3.7143729894375*^9}, 3.7143732435625*^9, {
   3.714373284265625*^9, 3.7143733266875*^9}, {3.714373367296875*^9, 
   3.714373367765625*^9}, 3.71437343965625*^9, {3.714373469890625*^9, 
   3.714373531859375*^9}, {3.71437356265625*^9, 3.714373563015625*^9}, 
   3.71437360778125*^9, 3.714373665828125*^9, {3.714373711890625*^9, 
   3.71437375653125*^9}, 3.714373800515625*^9, {3.714374033390625*^9, 
   3.714374033609375*^9}, {3.714374223234375*^9, 3.714374237359375*^9}, 
   3.7143793808125*^9, 3.714379507078125*^9, {3.71437961603125*^9, 
   3.714379616859375*^9}, 3.714379700625*^9, {3.714721128234375*^9, 
   3.714721151421875*^9}, 3.71472321021875*^9, 3.71472324396875*^9, {
   3.714724874109375*^9, 3.714724892265625*^9}, 3.714725077*^9, 
   3.714725226578125*^9, {3.714725329171875*^9, 3.714725451234375*^9}, 
   3.714725575171875*^9, 3.725535235578125*^9, {3.7255352659375*^9, 
   3.725535291140625*^9}, {3.72560655346875*^9, 3.72560658190625*^9}, 
   3.72560664890625*^9, {3.725633758796875*^9, 3.7256338076875*^9}, {
   3.72563387903125*^9, 3.725634065875*^9}, {3.725634105140625*^9, 
   3.72563410575*^9}, {3.7256341635*^9, 3.725634163859375*^9}, {
   3.725634194328125*^9, 3.72563419471875*^9}, {3.7256342834375*^9, 
   3.7256342843125*^9}, {3.725634316*^9, 3.725634362453125*^9}, {
   3.725635884234375*^9, 3.725635884734375*^9}, {3.7256359231875*^9, 
   3.7256359240625*^9}, {3.72563600959375*^9, 3.725636009984375*^9}, {
   3.725636819703125*^9, 3.725636820921875*^9}, {3.72568799821875*^9, 
   3.725688022296875*^9}},ExpressionUUID->"c49de2ae-af5e-4636-b6dd-\
551ea4ffc0b4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", "3000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"5.2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"u", ",", "e", ",", "uz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Uz0", "-", 
        RowBox[{"uz", "[", "t", "]"}]}], "Ri"], "\[Equal]", 
      RowBox[{
       RowBox[{"cz", "*", 
        RowBox[{
         RowBox[{"uz", "'"}], "[", "t", "]"}]}], "+", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"uz", "[", "0", "]"}], "==", "Uz0"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"k", "*", 
         RowBox[{"i", "[", "t", "]"}]}], "-", 
        RowBox[{"u", "[", "t", "]"}]}], "R1"], "\[Equal]", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"u", "'"}], "[", "t", "]"}]}], "+", 
       FractionBox[
        RowBox[{"u", "[", "t", "]"}], "R2"]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "*", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "e", ",", 
        RowBox[{"u", "'"}], ",", "uz"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]], "T"}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"e", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"uz", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<u [V]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<E [J]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<uz [V]\>\""}], "}"}]}]}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"pli", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"i", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}]}]}], "}"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etrue", "=", 
   RowBox[{
    RowBox[{"e", "[", "tmax", "]"}], "-", 
    RowBox[{"e", "[", "0", "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.714193973140625*^9, 3.714194434171875*^9}, {
   3.714194477015625*^9, 3.714194488546875*^9}, {3.714194560890625*^9, 
   3.714194862015625*^9}, {3.714194893765625*^9, 3.71419489890625*^9}, {
   3.71419494371875*^9, 3.71419509759375*^9}, {3.714195129390625*^9, 
   3.714195178625*^9}, 3.714195211671875*^9, 3.7141952571875*^9, 
   3.714195517265625*^9, {3.71419669915625*^9, 3.714196700015625*^9}, 
   3.71419709803125*^9, 3.714202535109375*^9, {3.71420262665625*^9, 
   3.714202643171875*^9}, {3.714204559234375*^9, 3.714204559484375*^9}, {
   3.71420509434375*^9, 3.7142050945*^9}, 3.714206417359375*^9, 
   3.714207988*^9, {3.714210401453125*^9, 3.714210455359375*^9}, {
   3.7142105194375*^9, 3.714210519890625*^9}, {3.71421060253125*^9, 
   3.714210613484375*^9}, {3.71421066359375*^9, 3.7142106650625*^9}, {
   3.714210711078125*^9, 3.7142107330625*^9}, {3.71421252984375*^9, 
   3.71421254378125*^9}, {3.7142913657475677`*^9, 3.7142913676225677`*^9}, 
   3.7142915904975677`*^9, {3.714291633919443*^9, 3.714291634075693*^9}, {
   3.714291702513193*^9, 3.714291702825693*^9}, 3.714291736481943*^9, {
   3.714291768325693*^9, 3.714291768544443*^9}, {3.7142920923100677`*^9, 
   3.714292092450693*^9}, {3.714292242856943*^9, 3.714292243075693*^9}, {
   3.7142923021850677`*^9, 3.714292302325693*^9}, {3.714372936625*^9, 
   3.71437293859375*^9}, {3.714372974859375*^9, 3.714373115453125*^9}, {
   3.71437315396875*^9, 3.714373164765625*^9}, 3.714373258078125*^9, {
   3.714373337171875*^9, 3.714373383234375*^9}, {3.71437341990625*^9, 
   3.71437342203125*^9}, 3.714373454921875*^9, 3.714373540984375*^9, 
   3.714373578390625*^9, 3.7143736266875*^9, {3.714373678109375*^9, 
   3.7143736879375*^9}, {3.714373776734375*^9, 3.714373782703125*^9}, {
   3.71437390203125*^9, 3.71437391184375*^9}, {3.71437405009375*^9, 
   3.714374103359375*^9}, {3.71437425453125*^9, 3.714374255265625*^9}, {
   3.714374316796875*^9, 3.714374318765625*^9}, {3.714379623109375*^9, 
   3.7143796499375*^9}, {3.714379685078125*^9, 3.714379691765625*^9}, 
   3.7147233005625*^9, 3.7147239073125*^9, 3.71472408765625*^9, 
   3.714724964515625*^9, 3.714725020125*^9, {3.725550917625*^9, 
   3.725550919015625*^9}},ExpressionUUID->"2720b700-fb10-4abd-bb91-\
f7efc67d5413"],

Cell[BoxData[{
 RowBox[{"pli", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pli.png\>\"", ",", "pli", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.725551014828125*^9, 3.72555107284375*^9}, {
   3.7255511350625*^9, 3.725551143109375*^9}, 3.725605280015625*^9, {
   3.725634227796875*^9, 
   3.725634231546875*^9}},ExpressionUUID->"575fe589-0a94-4790-93c0-\
14756c7da315"]
},
WindowSize->{1041, 796},
WindowMargins->{{1, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 578, 16, 136, "Input",ExpressionUUID->"040535f3-6424-4597-97c6-02e5da008f83"],
Cell[1138, 38, 388, 10, 45, "Input",ExpressionUUID->"1d956e27-ba7b-4cd8-8baa-ecfa16514db6"],
Cell[1529, 50, 4832, 110, 810, "Input",ExpressionUUID->"c49de2ae-af5e-4636-b6dd-551ea4ffc0b4"],
Cell[6364, 162, 6811, 169, 791, "Input",ExpressionUUID->"2720b700-fb10-4abd-bb91-f7efc67d5413"],
Cell[13178, 333, 1041, 25, 136, "Input",ExpressionUUID->"575fe589-0a94-4790-93c0-14756c7da315"]
}
]
*)

