(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    227237,       4582]
NotebookOptionsPosition[    222670,       4498]
NotebookOutlinePosition[    223130,       4515]
CellTagsIndexPosition[    223087,       4512]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"d2e69146-abcb-44b5-a67e-b27e1e90746d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"derivace", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", 
      RowBox[{"{", 
       RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "x1"}], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"Pi", "*", "t"}], "]"}], "40"], "+", 
      RowBox[{"0.1", "x2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], "x2"}], "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"E", "*", "t"}], "]"}], "41"], "+", 
      RowBox[{"0.1", "x1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"derivace", "[", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x1", "[", "t", "]"}], ",", 
          RowBox[{"x2", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "==", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"x2", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"derVect", ",", "matrix"}], "}"}], "=", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{
      RowBox[{"eqns", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "\[RuleDelayed]", "0"}], ",", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], "\[RuleDelayed]", "0"}]}], "}"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x1", "[", "t", "]"}], ",", 
        RowBox[{"x2", "[", "t", "]"}]}], "}"}]}], "]"}], "//", "Normal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x1", "[", "t", "]"}], ",", 
       RowBox[{"x2", "[", "t", "]"}]}], "}"}], ".", "matrix"}], "\[Equal]", 
    RowBox[{"-", "derVect"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigVal", "=", 
   RowBox[{"Eigenvalues", "[", "matrix", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Union", "[", 
   RowBox[{"Negative", "/@", 
    RowBox[{"(", 
     RowBox[{"Re", "/@", "eigVal"}], ")"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "%", "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"Print", "[", "\"\<sytem is stable\>\"", "]"}], ",", 
   RowBox[{"Print", "[", "\"\<sytem is'nt stable\>\"", "]"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6893162414375*^9, 3.68931625128125*^9}, {
   3.689316281890625*^9, 3.6893163511875*^9}, {3.689316645671875*^9, 
   3.689316698609375*^9}, {3.68931676365625*^9, 3.689316767703125*^9}, {
   3.68931709484375*^9, 3.68931729590625*^9}, {3.689407260802955*^9, 
   3.6894072791310797`*^9}, 3.689407329927955*^9, {3.689407435615455*^9, 
   3.6894074649435797`*^9}},ExpressionUUID->"a8c765eb-1c48-47b7-be34-\
7ea5c0e86c0f"],

Cell[BoxData["\<\"sytem is stable\"\>"], "Print",
 CellChangeTimes->{3.8473334679192557`*^9, 3.8780904248105855`*^9, 
  3.878714270954266*^9},ExpressionUUID->"101e49f3-f78b-424b-b38d-\
09044b5830e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Runge", " ", "Kutta", " ", "fixed", " ", "Step"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tmax", "=", "5."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nSteps", "=", "60"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]tFixed", "=", 
     FractionBox["tmax", "nSteps"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startPoint", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaFixedStep", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "k1", ",", "k2", ",", "k3", ",", "k4", ",", "\[CapitalDelta]t"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\[CapitalDelta]t", "=", "\[CapitalDelta]tFixed"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"NestList", "[", 
      RowBox[{"RungeKuttaFixedStep", ",", "startPoint", ",", "nSteps"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1Sol", "=", 
     RowBox[{"sol", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "x1"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"x1Sol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Opacity", "[", "0.5", "]"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"sol", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "x2"}], "}"}]}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"solNDSolve", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqns", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"t0", ",", 
              RowBox[{"{", 
               RowBox[{"x10", ",", "x20"}], "}"}]}], "}"}], "=", 
            "startPoint"}], ";", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"x1", "[", "t0", "]"}], "\[Equal]", "x10"}], ",", 
             RowBox[{
              RowBox[{"x2", "[", "0", "]"}], "\[Equal]", "x20"}]}], "}"}]}]}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "x2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x1", "[", "t", "]"}], "/.", "solNDSolve"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", "Red"}]}], "]"}], ",", "pl1"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x1", "'"}], "[", "t", "]"}], "/.", "solNDSolve"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.68931622440625*^9, 3.689316234125*^9}, {
   3.68931656225*^9, 3.6893165855625*^9}, 3.689316648640625*^9, {
   3.689402601771705*^9, 3.689402809490455*^9}, {3.689405509709205*^9, 
   3.689405560396705*^9}, {3.6894066292248297`*^9, 3.689406668959205*^9}, {
   3.6894071995998297`*^9, 3.6894072124123297`*^9}, 3.6894072685373297`*^9, 
   3.689407306052955*^9, {3.6894073372873297`*^9, 3.689407410677955*^9}, {
   3.689407478709205*^9, 3.689407504865455*^9}, {3.689407567271705*^9, 
   3.689407686052955*^9}, {3.6894087479435797`*^9, 3.6894087567560797`*^9}, {
   3.6894087915373297`*^9, 3.6894087997873297`*^9}, {3.689409015865455*^9, 
   3.6894090270060797`*^9}, {3.6894095950998297`*^9, 3.6894096065060797`*^9}, 
   3.6894103571310797`*^9, 
   3.8787142604167233`*^9},ExpressionUUID->"f29a97f3-2619-466b-9518-\
ace3faf9c648"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       LineBox[CompressedData["
1:eJwVl3k8FF4XxjFDZUaZUaLFVihEWijh3FISUokoS6VkyZ6tkDVFimQNkYgK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        "]]},
      Annotation[#, "Charting`Private`Tag$1474#1"]& ]}, {}, {}}, {{}, {{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.011000000000000001`], AbsoluteThickness[1.6], Opacity[0.5], 
      PointBox[CompressedData["
1:eJw10glIVEEYAOBV1/vaA0VCCw/QRKQSUvP4f1PxwMJ71zwCJTQLuywzWSJU
MDK1rMygDI82zSOLMoxKKH2r7uoebumGRkKmkkeZSurupuP4w+PxmO/N/Mc4
Z56JP2HIYrGCNp+t9048qN2KMUgi8Qr2rjpV8jij9LsXehpcQPT4M2xrOVTb
+8Vlh6vpuhoWxZ3+XjoVtJDQQFm5sDXUXQV6Et8gpC+tq6dKTdcn4dBYzpGs
iS/0/x9gYSbWNszs7D8Ns8kbvqonanhG/Cw4FTQVHMwfgWTi5yDypW3S+zgV
9YvgmWYquBuspPv9BtzXfCfdX0HP+wMTV3InmwLlNJ8l4ImV4ZKyIUgkfhnG
ZfpbTu1SaCZ+BfZ8ZJYmmwdBR/wqdM9xMuoq5JBA/D+I7RL72Huo4Cnxa/Dh
dBZjVqQELfHrkC0aHNYVKSCeeC1UfJ8KOn9dDmLidTAdGvPTImIYNrYTArv5
+yc9qmX0fBa+UOdPsVcGaX4GyNbv1l/NG6D5G6Ckq3jeXyuh9Rmi+FzqeEob
Q+s3QuZC7YgykKH9YePR0ZsRiSCj/WTjjCb59vRmftv9NMaSvMyodSsFGBBv
gsKyteaOCDm0Em+CG9GuOcV2wyAg3hRLvG2vubXJYPsOmWEr1zHsbJIU2og3
w7ihooBH1oMgJN4cHT95XF4Y6Qcj4i1Q+PbSgfYWCbQTb4FvQnNDuisZSCHe
Epmvzs7TAQywibfCxiWXGs9wGXQQb4VBD0WCe4UKOEa8NS6X6qskRgowJt4G
7V0N3jn4yeE58TbokxF2qm52CFKJt0WIjhLfKJDRfDgoXIhp4NtLab4cVPYb
1R/vHaD1cLCzKzCqvqSf1stFTY9lsEOChPaDi+ZTh6FxP0P7xUX3ee7rUk0f
7ScPNfyarMAFKe03D1WFdaW/0hV0Hjy0iy9v8WYp6Lz42B4pqPGNl9N58jHb
z/eiSDhM581Hr1W3ccGuIXof+Ph3UWccOyOF/2ZDu10=
       "]]}, {}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.17703157001788092`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5.}, {0.17703157001788092`, 0.39999996938776144`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8787142717409096`*^9},ExpressionUUID->"ec237a35-3927-4543-8cb8-\
0a45ce06cd57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Runge", " ", "Kutta", " ", "Adaptive", " ", "Step"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RungeKuttaAdaptiveStep", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "k1", ",", "k2", ",", "k3", ",", "k4", ",", "\[CapitalDelta]t", ",", 
         RowBox[{"kDer", "=", "0.5"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"k1", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"\[CapitalDelta]t", "=", 
         RowBox[{"\[CapitalDelta]tFixed", "*", 
          RowBox[{"Min", "[", 
           RowBox[{
            FractionBox["kDer", 
             RowBox[{"Max", "[", 
              RowBox[{"Abs", "/@", "k1"}], "]"}]], ",", "1"}], "]"}]}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"k2", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k3", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", 
             FractionBox["\[CapitalDelta]t", "2"]}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"k4", "=", 
         RowBox[{"derivace", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "6"], "*", 
            RowBox[{"(", 
             RowBox[{"k1", "+", 
              RowBox[{"2", "k2"}], "+", 
              RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"solAdaptive", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"RungeKuttaAdaptiveStep", ",", "startPoint", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "tmax"}], "&"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1SolAdaptive", "=", 
     RowBox[{"solAdaptive", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t_", ",", 
         RowBox[{"{", 
          RowBox[{"x1_", ",", "x2_"}], "}"}]}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "x1"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl3", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"x1SolAdaptive", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.008", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", "pl3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.689408915240455*^9, 3.689408917927955*^9}, {
   3.689408983490455*^9, 3.689409072584205*^9}, {3.689409114584205*^9, 
   3.6894091736310797`*^9}, {3.689409205896705*^9, 3.689409238584205*^9}, {
   3.689409401115455*^9, 3.689409474177955*^9}, 3.689409518396705*^9, {
   3.6894095727560797`*^9, 3.689409586552955*^9}, {3.689410062834205*^9, 
   3.689410101802955*^9}, {3.6894101865685797`*^9, 3.689410192521705*^9}, {
   3.689410249084205*^9, 3.6894102995373297`*^9}, {3.6894103620060797`*^9, 
   3.6894103773185797`*^9}, {3.689415607209205*^9, 3.689415610459205*^9}, 
   3.6894208198498297`*^9},ExpressionUUID->"8032df97-fd0e-4f0e-8a4d-\
d7219bc57479"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      0.011000000000000001`], AbsoluteThickness[1.6], Opacity[0.5], 
      PointBox[CompressedData["
1:eJw10glIVEEYAOBV1/vaA0VCCw/QRKQSUvP4f1PxwMJ71zwCJTQLuywzWSJU
MDK1rMygDI82zSOLMoxKKH2r7uoebumGRkKmkkeZSurupuP4w+PxmO/N/Mc4
Z56JP2HIYrGCNp+t9048qN2KMUgi8Qr2rjpV8jij9LsXehpcQPT4M2xrOVTb
+8Vlh6vpuhoWxZ3+XjoVtJDQQFm5sDXUXQV6Et8gpC+tq6dKTdcn4dBYzpGs
iS/0/x9gYSbWNszs7D8Ns8kbvqonanhG/Cw4FTQVHMwfgWTi5yDypW3S+zgV
9YvgmWYquBuspPv9BtzXfCfdX0HP+wMTV3InmwLlNJ8l4ImV4ZKyIUgkfhnG
ZfpbTu1SaCZ+BfZ8ZJYmmwdBR/wqdM9xMuoq5JBA/D+I7RL72Huo4Cnxa/Dh
dBZjVqQELfHrkC0aHNYVKSCeeC1UfJ8KOn9dDmLidTAdGvPTImIYNrYTArv5
+yc9qmX0fBa+UOdPsVcGaX4GyNbv1l/NG6D5G6Ckq3jeXyuh9Rmi+FzqeEob
Q+s3QuZC7YgykKH9YePR0ZsRiSCj/WTjjCb59vRmftv9NMaSvMyodSsFGBBv
gsKyteaOCDm0Em+CG9GuOcV2wyAg3hRLvG2vubXJYPsOmWEr1zHsbJIU2og3
w7ihooBH1oMgJN4cHT95XF4Y6Qcj4i1Q+PbSgfYWCbQTb4FvQnNDuisZSCHe
Epmvzs7TAQywibfCxiWXGs9wGXQQb4VBD0WCe4UKOEa8NS6X6qskRgowJt4G
7V0N3jn4yeE58TbokxF2qm52CFKJt0WIjhLfKJDRfDgoXIhp4NtLab4cVPYb
1R/vHaD1cLCzKzCqvqSf1stFTY9lsEOChPaDi+ZTh6FxP0P7xUX3ee7rUk0f
7ScPNfyarMAFKe03D1WFdaW/0hV0Hjy0iy9v8WYp6Lz42B4pqPGNl9N58jHb
z/eiSDhM581Hr1W3ccGuIXof+Ph3UWccOyOF/2ZDu10=
       "]]}, {}}, {}, {}, {}, {}}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.008], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJw1z30w23ccB/CIx5CWJH2wVjtjRbvtsPU6XO39NdOhiKWo46r1rFbtKWUN
xtTumIeqUfPQ3tVoWVjviFPFNg9tIpJIIqWxtR6qNaZk6qmObfq72/vuc+/7
3L3+eb8TcYEXTafRaB5b96b/T2XFm2hQrDqvVyusAkPgcvvsLg2O/Sk5LtM2
gum8cORc/mNc1llRxRrfQ6NjHN15fASMiX7vNOdeTL9kHM+cHoYwP3n5wJQM
bbr1i1dyH8G+ytQ/7nM1bBZLbXVd1cjRRtV1VWuQPl0SyXccgsbj/jp78SkK
nMavBPWpccPc4eJ80AS0IwsvtD4j8OwdtajQmYJfi4MmMGsErxK+Fbk3vgD6
Y+a/I8O4SfkZcFsKCuX6j+BF+TkMJ23/ovr3ISxRfh7MQJ8/LLtV4DLNnVMF
WuReCi1MaVWiNjyhSEpbxNc8RV5zqwJuGV3SnPde4dniUUGUcBDXVWyr0awl
nDBNehgqkeEv27hU++FlzPLTLST6UhDKr8IrMfgblEtRRvk1qF30hkY5Knxa
F5dgVvwaqrCCxG12Qyhf7+qJfr6OnSbNKmt/Fea4HPMOlw3Q6eF+Izwl3Ci/
iY3JkvSUCAWuU/4fKGP3Gny4KcfKHUbBqX00ssHfzXLyleEWT3jESEwj4rRD
v/a3DMBnM2yi+aIOCaqOCVbbS7BKeTpp3rWmu9kjRlxadsTBDDrZqZkR5uiJ
8YOrqsFdRCeODh6ehhkitLtJ1A2WuuSrquprIWwRouaSMwMGdImFlc1YMl8C
zw/q7fYd1SMTNIf9JlYK0PbEnJpr1SMGV21YTZlKCPrMjMrP6JPPSmzLwzYV
CLrQ0exmYkCc2n+bz3JSQIfyBmT56m1h5pocjZQ3JI61s4/jr8lwkvJGRJWs
rf7bRQo65Y2IJWfY1WdJgibKM0gTn53a2dmPYMobk6KGQpfC78XQpbwx+dja
IjKWL8LPlDchxbfOxVsHbf3amJNNkyYkoELaXnR3AFxDfwcnTyZxP/NvvjBa
gThhqv2anEnOt5U1m2zt4Zy2Gq25vI1UdnP3lg0r8AtDluP77nYiHnz/cBJT
gbOU305etknGksvl2EF5U9LX+tybayfDWE5Mjw3bjKjXMxPLJAM4PNqxOz3W
jAi8V6cSMyTIs2clKDvNSOgDZLxF+vGU8izSEWIrHmCJ8RHlWeTGzS9b+asP
kUt5FslYjYl8EiLCE8qzSYlXqajymRxvx0esvD7GJn3hhQ/GnZXQ5zFnT2ez
yaUavx/r/JXQHJjbwxOwSaW65z50lAjq/2RzYZJN2kftFb1FCgj2l/I8nDhE
W3MwwFc6CFryzJ3KQg6ZuZsij8iTI5DyHFKf3X1PckKGnyi/gyh71PmLh6T4
DxohCeg=
       "]]}, {}}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 4.999999999999999}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8473334682316823`*^9, 3.8780904253587112`*^9, 
  3.8787142720417786`*^9},ExpressionUUID->"222d25db-725e-42f0-bca6-\
9314f0fb6e26"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "desired", " ", "angular", " ", 
    "frequency"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"\[Omega]desired", ",", "step"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"steepness", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tsol", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"step", "=", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"steepness", "#"}], "]"}]}], ")"}]}], "&"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Omega]1", "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "0"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Omega]2", "-", "\[Omega]1"}], ")"}], "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", 
      RowBox[{"2.5", "*", 
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart"}], ")"}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"yDesired", "[", "t_", "]"}], ":=", 
     RowBox[{"\[Omega]desired", "[", "t", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6894176868498297`*^9, 3.6894177216935797`*^9}, 
   3.6894183103498297`*^9, 
   3.689435420890625*^9},ExpressionUUID->"2e86c788-5558-4b42-961c-\
1f71d77bccb9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Linear", " ", "system", " ", "control"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"transferFunction", "=", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"\[Tau]", "*", "p"}], "+", "1"}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"laplaceEqn", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Denominator", "[", "transferFunction", "]"}], "*", 
        RowBox[{"y", "[", "p", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{"Numerator", "[", "transferFunction", "]"}], "*", 
        RowBox[{"u", "[", "p", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"systemEqn", "=", 
     RowBox[{"laplaceEqn", "//.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", "*", 
          RowBox[{"f_", "[", "p", "]"}]}], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"f", "[", "t", "]"}], ",", "t"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"f_", "[", "p", "]"}], "\[RuleDelayed]", 
         RowBox[{"f", "[", "t", "]"}]}], ",", 
        RowBox[{
         TagBox[
          StyleBox[
           RowBox[{"Times", "[", 
            RowBox[{
             RowBox[{"Power", "[", 
              RowBox[{"p", ",", "pow_"}], "]"}], ",", 
             RowBox[{"f_", "[", "t", "]"}]}], "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm], "\[RuleDelayed]", 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"f", "[", "t", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "pow"}], "}"}]}], "]"}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"controllerEqn", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"kp", "*", 
          RowBox[{"e", "[", "t", "]"}]}], "+", 
         RowBox[{"kI", "*", 
          RowBox[{"Integrate", "[", 
           RowBox[{
            RowBox[{"e", "[", "t", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}]}]}], ",", 
       "t"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"connectionEqn", "=", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"yDesired", "[", "t", "]"}], "-", 
       RowBox[{"y", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"sole", "=", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"connectionEqn", ",", 
         RowBox[{"D", "[", 
          RowBox[{"connectionEqn", ",", "t"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"e", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"e", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6894157571623297`*^9, 3.6894159569435797`*^9}, {
   3.689416054271705*^9, 3.6894161164748297`*^9}, {3.689416149927955*^9, 
   3.689416169115455*^9}, {3.689416226865455*^9, 3.689416277334205*^9}, 
   3.6894163211310797`*^9, 3.6894163621310797`*^9, {3.6894165096623297`*^9, 
   3.689416533959205*^9}, {3.689416570552955*^9, 3.6894166050685797`*^9}, {
   3.6894166536935797`*^9, 3.689416824146705*^9}, {3.6894169933498297`*^9, 
   3.6894170009435797`*^9}, {3.689417102490455*^9, 3.689417151834205*^9}, 
   3.689417462052955*^9, {3.689439417671875*^9, 
   3.689439419015625*^9}},ExpressionUUID->"0406145b-d2cf-4d84-9373-\
fb6f2d86b2dd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"1.`", " ", 
      RowBox[{"(", 
       RowBox[{"1.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"5.`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}]}], ")"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"(", 
       RowBox[{"1.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"5.`", " ", "t"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"y", "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"5.`", " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        RowBox[{"5.`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}], "2"]}], "+", 
     RowBox[{"5.`", " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        RowBox[{"5.`", " ", "t"}], "]"}], "2"]}], "-", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.847333468403549*^9, 3.87809042567523*^9, 
  3.8787142723582287`*^9},ExpressionUUID->"320b7f8b-c7e1-47a9-a691-\
0c617d765d1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"solDers", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"systemEqn", ",", "controllerEqn"}], "}"}], "/.", "sole"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"dery", ",", "deru"}], "}"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"u", "'"}], "[", "t", "]"}]}], "}"}], "/.", "solDers"}], 
    ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u_", "[", "t", "]"}], "\[RuleDelayed]", "u"}], 
    "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.6894168621623297`*^9, 3.6894168968810797`*^9}, {
  3.6894171591935797`*^9, 
  3.689417380209205*^9}},ExpressionUUID->"b0d06a8f-d7ab-430a-b8f3-\
b69e9a5f2ca8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"0.2`", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"0.2`", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["u", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2.`", " ", "kI"}], "+", 
     RowBox[{"5.`", " ", "kp", " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        RowBox[{"5.`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}], "2"]}], "+", 
     RowBox[{"5.`", " ", "kp", " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        RowBox[{"5.`", " ", "t"}], "]"}], "2"]}], "+", 
     RowBox[{"1.`", " ", "kI", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"5.`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}]}], "+", 
     RowBox[{"1.`", " ", "kI", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"5.`", " ", "t"}], "]"}]}], "-", 
     RowBox[{"0.2`", " ", "kp", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"kI", " ", 
      RowBox[{"y", "[", "t", "]"}]}], "+", 
     RowBox[{"0.2`", " ", "kp", " ", 
      RowBox[{"y", "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473334686534567`*^9, 3.878090426045127*^9, 
  3.8787142747113886`*^9},ExpressionUUID->"62a08632-2976-44e3-b44e-\
bf2b5dfbd439"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"0.2`", " ", "u"}], "-", 
    RowBox[{"0.2`", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"2.`", " ", "kI"}], "-", 
    RowBox[{"0.2`", " ", "kp", " ", "u"}], "-", 
    RowBox[{"kI", " ", "y"}], "+", 
    RowBox[{"0.2`", " ", "kp", " ", "y"}], "+", 
    RowBox[{"5.`", " ", "kp", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", 
       RowBox[{"5.`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}], "2"]}], "+", 
    RowBox[{"5.`", " ", "kp", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", 
       RowBox[{"5.`", " ", "t"}], "]"}], "2"]}], "+", 
    RowBox[{"1.`", " ", "kI", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"5.`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}]}], "+", 
    RowBox[{"1.`", " ", "kI", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"5.`", " ", "t"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473334686534567`*^9, 3.878090426045127*^9, 
  3.878714274780383*^9},ExpressionUUID->"b9a1ebfe-4c1c-485f-b697-\
a0a7ed3684d8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"solNDS", ",", "giveGraf"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"solNDS", "[", 
     RowBox[{"kpp_", ",", "kII_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "eqns", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eqns", "=", 
        RowBox[{
         RowBox[{"Union", "[", 
          RowBox[{
           RowBox[{"solDers", "/.", 
            RowBox[{"Rule", "\[Rule]", "Equal"}]}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"u", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
             RowBox[{
              RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "0"}]}], "}"}]}],
           "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"kp", "\[Rule]", "kpp"}], ",", 
           RowBox[{"kI", "\[Rule]", "kII"}]}], "}"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NDSolve", "[", 
         RowBox[{"eqns", ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "y"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "tStart", ",", 
            RowBox[{"2", "tsol"}]}], "}"}], ",", 
          RowBox[{"MaxSteps", "\[Rule]", 
           SuperscriptBox["10", "6"]}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"giveGraf", "[", 
    RowBox[{"kp_", ",", "kI_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sol", ",", "pl1", ",", "pl2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"solNDS", "[", 
        RowBox[{"kp", ",", "kI"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
          RowBox[{"yDesired", "[", "t", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<t [s]\>\"", ",", 
           "\"\<yDesired  \!\(\*StyleBox[\"yReal\",FontColor->RGBColor[1, 0, \
0]]\)\>\""}], "}"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"giveGraf", "[", 
  RowBox[{"6", ",", "10"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894179060373297`*^9, 3.689418095959205*^9}, {
   3.6894181264123297`*^9, 3.689418140365455*^9}, {3.689418182209205*^9, 
   3.6894183036310797`*^9}, {3.689418345802955*^9, 3.6894185395373297`*^9}, {
   3.6894185859435797`*^9, 3.6894186144748297`*^9}, {3.6894191843185797`*^9, 
   3.689419192802955*^9}, 3.6894208503810797`*^9, {3.6894396130625*^9, 
   3.689439622046875*^9}},ExpressionUUID->"09dd9d21-e42e-46d0-90fc-\
9dae8c382f5e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJws2Xk4Vc8bAPBr37nXvpb9ChVKie6ZtyypkBYllawpaaFClhIqSZZQKUUb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       "]]},
     Annotation[#, "Charting`Private`Tag$2171#1"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJxF2nk0VV0UAPBHEsIzNxjiTUQJpST3nkNIhUpRhkoSEUKaDIWUIQnRaCoq
mSIlFR4yRpmHJJE58zx7372Pvvxj/dY+59xz9z77PGs9UhbnDc6wEgiEmRUE
Av47Mz//J4MhmEtY/slRzuygTv9zQXxy3/7hf64IejjzoPWfu0wchBXy/ll4
bJ2eufc/O5OdsnLZ/lnOZ8MTL06B/71uxnLOo4r4v0WaJtMf5v2z0Cc/u/S0
f+b1SPrZE/LPrCzj9MMG//yH44bPxhre/5219ilPXS3PsmPUPswoFQ0V/HNG
U8E1rnf/nBrRMwTC/zpV7bmkQnWC4T8/Y8kPKNT655jfh3e3Kv91ptrjuMtv
hUX+OUiGft+znnvZuWreSexX++7/dYHaJQV9U6Ojf12u5jjqVH57x19Xq9m+
DUfy1vx1rZrlpQ8pk1Orl92odlLl54ZNjX/drCbp4bCd5cNft6r9zmPo1j/6
63a1OPaQ04muf92lZrWf5Opp+te9asUDtiv79v91n5pMcHqwodpfD6r5K82L
5m7662G1P7WaL2XF/3pEbf/lO0rhPMv2HFVLWlefzVjgWo6PqzmcsK6tbVm2
55RaBSH1JKj4G59RU4id/vOK/tdzaiFa6peEUv+OX1Ab7fZnuR7z1wy1wwHV
gb3Bf8ezIG83ia494vU3zopcckqS32jx1yuRBsGJD/cM/o5fhahkIFqLGn/N
iTw6dqvy7Na/Xo3Mzn4zrSH/NQ9iGrmmGxFaNiQiWcDcOZ5t2a18iIfPiJ9H
J+eSYwSRFpqqUE/dsqEwgpZ6RxsULbtVBIk+VyabnbHs3LUIgVcoQ/rlX69H
TqWaqYc++GsxJN/gefm877IlNyDkiYGj1lf+xiURnwfb26vOLpuPhHTuvO6g
ZrxsTzKi3Vw882Lv3zgVeXmN7ya/6t/5NIRDypjPXfbveBnE5vPTJ13r/1oW
+XLmD+3Q6mUHb0ICE9wQWj/H8vsqIAO6BSXBzcseVkT0h7iPzJUv23wr8jrE
8NeZ7GX3bEP4tkXZViYv22874lTfNaEateyDKkj1lS1ez4OWDVWRsOzcB67n
lx2MIhMnOcmdJ5ftDhEjVoOUAweXXa6OvI97vPMjXPa23cjaPe0FFMVlZ2oi
V3vlDt6VWraZNtJ02+XHDP+yJXWQJ5UrR7+NrlryWl3kLeWKSXfbsn30kfIr
f/IZlcsOPYh0lJvJrc1d9uIhZF6y4p7C62UHHEaELqrP60QtW8UQ2Vyabnnq
zrK5jyInnB4qh55btoIpcqmQKyrBZNm3jiN313mwf967bA5zJN5+yOGHyrJt
TiG5eacaxqSX3WuBNArXAu41y/a3RIZttOMp7MvWt0KkBOSuGnawL/mALaJq
FdlmX7PsUDvE4CNx3638ZXOcR2x5vd9EpS3Z87sj4m0xvv59zLJ1nZHHGVY3
Ku4uj2+9gKRzfe/rvrYcD7+IdLzJzlp7fNkXryLz7ApURd3l8S/cEGHTZ3f2
7lr2qmuI/GuhyVOyS4b6noj2Ct8TruuW57/zQk4cnSkK5Vj2rhvIpcRzWxKn
Vi6Nb/dBXh4+SGiuWzIh1g/JfZl/drxgybl5AUjj3LYq7rfLceIdZPjAy53U
2OX5d+8iHHHrniGhS5YkhyCS07e5jLyWHBMRiuzUXXR2cFz29jDEdvz37mj9
JXs2PEC8dQyT3iPL8Y5HyJOIYqHKTcvP2xCBvB3e6dEjumTzgCikXDOpk7B6
ycHhMUjHQwn9dbNsTLeyPkPm+4MzFHuXHHM3FtkcftHXonjJjgIvEe3e7iHX
jCWn8r5CTiAmx+49Xx6/PRG5FFKemxi2ZL6gZCSoE91YcGPJftypyIudaSHN
zstxhzSEfoc8O35qyYTBN8iwMkcZFS658nAGwhHguhXdsrw+yESkWvqfGEks
OdfwI6KqdJLtPM+SGx9lIQa3qux851csmUhHbJt210X3LZmjJRfxls9AMpuW
HHYoH0mvf8zbm7nkI08KEXaXAE3SqyVrGhUjx/hdXU0fLTlpWymSkGKTGua/
ZMudZcj8fuOur1eX7G79FdHv1RFbZbtknfwK5OktFQNosjyfVoVo563JeaO6
ZHbWWuThiVXjfbJLVoioQ/rmJjdSRZesdLQBQR91nTyxesmpyt+R4O314Q/m
WJeep/oD+V1TWFbZt+Sksz8RZad3LFzNSw76/AtpSgyzd89aMpvvb2TTXp/Y
d0lLrmXtQK53Xfg+GLFkYmQnUn3jNFHmzpLJx7oRitRhrVMeS07f3otcytFw
e2y/5PBdfUiJqVJazfEl/7AZQOzv84tro0vmkRlBcreyHL4uz7Rnvu8oIlA1
7JcpsRR/tmIcsXRozRnhXfJA5ASSsbpyXJbBwrSg8RTC8Youazm05IwdM4ip
9mvzyF9LTlabQwheQeXEXKY9xYoYiIHENda9qUzDbBkW9PknexXvmKXxXn6s
6PSx4w6fgpfsyMaG7pvUjRv3XJpfFrUSjbin1rTZackrTFahQwqb+KxPLa33
QYUTDTu32v27+tJ8FTsetItjLk1AaSl+upiI7nzxp3s/ielW+438aODuJvGb
AkznAn8BtKW19HAO61IcWSmEKlz74D81SmD6VbQw6i36iq7QznTMmMkaVNrI
Ty72M9OSP1FR1HXs8qnmdKZzrezF0fJg6wfCcUzDhJINqIT80a/6YUw7SshK
oY5l2iv8fJg2X/Qnoflnt+/Mc2G6cjU7BRVmp52ftWT6oF8MFf0IV/6w01py
rupGlLtlnO+F8tJ6E0AOPenWof2LuuRwh83om7W17mtFlp4/UroFZcv4/OYQ
O9OECllFNPmFVZXwAIOOkS87QAk1aNNC/L4ynfudfRsaYcQmbB/EtEyt2Q40
dXz7rl12TGfePbMTLQi1OcW5j2nCsye70EaFCN8GaaY9F1hRtO/bt+TnK5k+
O3kAoot2LLUX2hdxc9/5pI4KrN42q57HdEGZ9m5Udc8j7RZ3puHNYm1Uv7PM
LsmE6Vb4WQe1uLEY6qrCtJ1i3z70kpTiBx0RptUUduuh/vTTv0TGF3A72lUc
QCOO31/ZWcX0tp37DqGpcyVy6a+ZHn1UZoA27pC/cuAc00HDykZof515lPhe
pvUZlGMoweVeQR+N6UsywAQVEij684GN6fxNfmaodOo0n9/vedz3JdlOoqr6
cjuMcpmO+fDDHNXvP36cEsX0RbfDFuglmc+vco2ZBosvz6ABRRMVQTuYlkwL
sEYjLWUmzYSZHrV9YIOmspqKyY3NMefXVp1DC2LuaMxUMj3VjTigjWju2eIU
pnfOn3dE+5tHg8IDcXtGm7U4oYLrjv1Q1GF6zQPxiyjtfQALgcYcL4yMX0JV
DbOlv61gxu1+jl1B9ceG9CLaZnG7ckq6oRYhJBdbOtOkZ+4e6KUtho9VInHn
mg2xe6L+X31z2d1wwz2ydl5oKucAd+x2Ztwh7r4PWvByw1YnIeb82wGnbqGN
WgbGYHQGf/6GM0f80P52n+s8lbg9M1OcA1CG1/vnP5KZdtqSG4gKSP4pe3Ub
d27yCvW7KC1HbPSyDdOZVfPBqP6sFypExR0jyycYhlo8fGv5m5VpN6/qcPTS
9u6A1NZpfH+93ZkP0IDadWnXcnB7Fr8sfYRGOus26EYwzebEEYGm8l1fWO+K
uzVb62oUWpCSRu49ivvgWxgcg/b/EXG8Kcj0h4LQWJTgv/f+4ZEpfD9OXHue
o0LS7llSFbgJurpSL1GZwpTfQ0m4zQcbKa/QXafbOHICcMMMHcNEVJ9FaEvg
Wdx8ZJ+MZNQiWtvQRBu3ytkztFQ04Efi00kW3DqcycLpqNX8fnvL1knMkjyz
GW9RdfF+leoc3MPxfW4ZqBgayAYjcXuq3LHORKdPbKpMdsOdG7/J4yNac738
iagJ7mPS5rlZaEqMnbW/Cu4r+tzKdPTM76RFy4kJzHbDHBb5KFyh96W6BrdP
z8LYZ1SMMhAO3+CG43viC9EpzTunUoJxxxTVeRWj1Wc2bxY7j5tNsf5GKZpy
6+u0vx5uzcjstDLU/6V9wZQcbl3GfuI3FPYmm9b0jGNWVWa8rULFuPSl1Ytx
W1zapFKDTskOjqY8xx388FxzLVq9PyhHzAf38Ju7cfVoip18QIAFbrXoV/ca
0YA73wynIW4FyJPchJ5JcZCy2oB7266j482o2HBKpnrzGOaqnYd429BpvgM+
rz/iFnqnfuM3WqM4dED8Ee7sTO61HWiKwV3R25dxB+TbVnSiARe2dE8b4h4o
P5DUjZ4Jq3hjtQ3369PDab0ofHf+Wq0A7ijp4vY+dGrytXBqxSid4PlzT779
MFq95mCbeApumcS52hE0RWU46XYgZsLTp+0mY6i/cfCVGVs8rrNqHesEaumq
oGm9F/f3FS5fJ1H4pJJYJ42Ptxriyp1GRbMcf2iw4/G+pzt+zqLVC6nOEp9H
MO89IP+CgaZIHEIDn2KGMQPrNrMAfzDCOXsdM+GrWkIcK7A0D6mzPoE7eZe+
GhuAXopP69Tw8Wrg8+RKIPqsym63KOZcGS/WhlVgMt9JJW1mGBu/qKbdygmS
2d5UBGbgTmyVdecFflSDJ7NhmGOGq81u8wFL7VGrsxcwm6+REp3gB8A6VKn+
EGZJvsQcD0Gw3k9pcbcC7scdf6SFwWR8dWkaLz6fNug+KQKe3euUBU1D2H6k
vIL71wK+NVbGk4cxx+x9xXZcHBQfezFcxYfZ87wwx68N4NrjLt/kr4N0At+W
/qH9UkC5mbbBPwAz3KQhXkQC/eLWGZZ7MDuev3bfnAJiT77Ug2yYzZMfikvQ
gMnT7g7RvAE6oXV9WSqLDCimnBWsUcXMNzEOdTYBq9uRrYrz/XRC5b0pe195
wDZanRycjVnB0Z7qqgBij3G4DV3DzNeupFaqCDToiI4+xBzMf3tYaStoo14Q
TmbBfNbG/eSHbcAzMP736s992P5Xzlee2A5yjAU9SrUw9yRWF/GpguO5Ovtk
VmEuaf1QRVID87Rra3xL/mD77709fgIFT+6kd3T6Y9Y5aLDbEgLV8Z40zf2Y
XVoehaSpg+8mEtdjuTHnntM7um43uJJ3WJf1Wy+dcPC7aEqkJsgIyumiH8Rs
JrJDf6UOMJwYS5cQwOzT9CZ5YC8YN93o5VHTQyfE122rnt8P7uWf0G8Ow2xu
MPxNWR8obQwT3WWEucX83azeQVB1t7Tn0RrMmaNK9o8OAcfJxXfTjd10QqPi
/c0MA5Dy2eZghilmiwnDdSQjoCcbLS4sjrnERXa0/SjoD679c6Gli07Ip310
LTUGt6c4M6ujMc8KhN6qMwWyJ8BNxVOYNbeaklafAKUFLgbBJMxt3LLl283B
WbmEDUPtnVh+r4eoep4CL6aFPiZZYY4hvfc8bQm0Tu7zXS2D2Uv3WiyLFego
vH7EtreDTjjQznI/1xrc2PROqjQB8w6vnKFnNoB078+gtB1mlp2a7onnQN7M
hqxbmzG/HUDBT3tgbm7o3znYTvfMolhliTuCqM255Findjphe6n+10JngIRN
DLNsxRyX6JOi4QKaZ2VzzMd/0z0nttETfl4EbqfMb9PfYb7qU7Dh0WWwviT8
mMTl33TCzJmzjy9fBR/ky6geKpj5DMSa3NzAsXDC2I+ZNjrBOyS3Nt4D3Lc4
d+eRexsd/iAmLGh6AeXSGJNpBIvb3ngb98wb1G6plz7KaKVD9nilSlEfcOH+
6ol3ua303E+6X+Pe3AQCCzBfyBuzU92Uo40vSDt96e6F3dj4Nt+p1xr+4OCX
RLNqNixue0mMR/02ENuyeXAD8Rcdzjny1GbeBSbzD/x+hrTQIb/hHgOxEPCw
lJX8RKiFLtmXrrXtYiiov2+ffezBT7r5yWcPZnruASHLxqMi63/SYdFd+uur
4cBAcfdoTUQzHbqW3gnY+AAELyYHhmxoprdeJ0d3zT4E3I9u5HFTf9Ald9nk
OHJHAvbxXVo7I5voMar7Rg7ejAYM/fGSM8JNdE8V9/GQdU/B9Ksk3dA73+kK
thSFNXeegVG2M5U5K7/Tg2VPD3tviAP9J8WP9Hk00lMf52buq3kOOj/WNayZ
bMDywyfNn/gSNDpq/3LsqqdLZlnPClYnguqyRYvIE/X0ypebFm5Lp4Ay2vuu
0vo6ejDf5Fq6USoo8DpvO6lfR5dM4lIpSU8DOc3Sg6TiWvpD9YW1VZvSQeaO
VqcDoJYuOas/0fX5LUgLfTjh9r6GntqAzGxzywBxOpwLtS+r6fGBTxuyDn8E
UbF5niyS1fSSgQ087VezwIPFq2zyD6voOoYTOWu/5IBgYyU/E74qOkdgl82d
2FwQ8PbPal+/SnpY9uXMXzN5wIcYezedUEl34Y57ftXmM5itzaDljnyjd9RL
iP4YKwC/4ENl5+pyOse78hyRkyWgepIDKcsvo9eevtzJtfsLKEi6qklJ/0L3
UZDJH9tTDt5b/NnvEVtKH7cQ5Dp6/htIWGt6uP5eCR193Jx19HgliPxWZrLF
p5i+NqogMz28CgT7qFn4uRTRrzEeX7dpqwaXhsWdVA0L6I/9tKfQd3XA5kXQ
lXtan+mzTRbOZmgDMDNjXO9XzqdnXCjLK25uBBolrUFRIrl0pYeu0aYmzcB2
/tmmIZ4ceipaR3ywswUcOOuz6+ngJ/r7EvGTG9a0gvVwj/HK1Pf0aN9Ewhq5
34CQJHP2ffA7esT+CWMRzXbQtYbrso1TOl0h44yql1UHOP3r0cYnZ1LofJRz
e9HCLkDx2Kd+tP4xXUQ3+GVEbR/4tKnSfYNxKD1sVZI0B2UAPM9MdKx4f4Ne
/XHLu5GLg2Ce301jg6s7+P3xwtDhoGHAv0LTKd0/DsjM96cnyY4BbTmvwwdK
4kGBWzf1dPkYcD2co9zHngx6d+irjdmOg5FDYh78+W+AbF6+XX/EBDB5dl99
L/gELPQlqH++TAElIvcND9VsAJM+cd1Snwar3b0K0pTpYNNQ4muP9GnQIptB
5rmfBzJWCXMc8p8B+9ocNV/eyweXxswCZQZmwPsHcmfUQz4DV/GOLQa6syCY
7emLi4GFQIUjob1pfhbMfzQtJgYUAaHUjO1W+nPgrJNIzyvfYhCX4F/x+Mkc
qJWu4tC8WQIGNOyvPeyYA+ottze2eJcC69+c37w2zoOUMO19Vzy/gK5Q9/Nu
tvNg/X6WcwLXysAXuc60xJfzYPT9pSTtq19Bx7kvQfprFsAJB8WvrZe+AQlR
oWz+fQugjNI/4OpSARoSt80kXl0AEfaHfbl2VoLv2/uMtF4sgOqS1AcN7ytB
5YmWIysrFwAHhTc+bnsVmObUfSEwtQDQ6+cynd5VgTCGEvs90UWQoEz7vjq9
GjRR3yldO74IWoNv9DYq1gBuI+Au77YIRPpbZ56n1oA2ffVXzfcXge4elOvC
lloQU3VpdXzqIvB+9mQ9TKkFjy3P+aaULILMhWlZns11YEfHqnvcvxbB4DGj
XU2JdUBg55UdP8cWgSmR38zlVT04OIQ67FrHAKG2DnbqMg3gIqeLzPRGBigp
LHPnfdkArLJMW27uZIBFyY13flAbwaq5Q93Texhgm/utyPi4RiAfaWdpacgA
tg3tyRfJ30ELv55e0ykGiFFSz9F49h2wWut5nLNnAO7euZbm6CawrbLit7g3
A2hoGg+9kvgBOFrzPpjeZoAr0RmMS5E/wIQfu/LgPQZImRXk0xRrBn527jZt
Txig09BJkv9JM9AwG4uEsQwglvZNoWXdT5DltPmoSAIDGHBvUk98+BNwZjqc
tktlgJz8rlNa91vAQnnayexPDDAuruksIPwLRNlvzC7JZQC5q0+9f937BQ7E
6ZldLGQARdvre404W8HNmx5rvpQyQPmalKosnVYwPlak9/UrA1gXNhuT/VpB
khxvn08VA7BeWP3bv7gV0B1yzk/WMoDKt7OjRtptoMosWUP0BwPUuD1wzb7Z
BuwEzr1v+MkADhuLWCmFbWC/zZideSsDcDaMBwSw/QZW64PkP/xmgDgfsuDI
7t8Azhl7dXYwAFAyeHL0xm+wP2XHq54uBmj65UnOyf8NfDJOJRf2MADfrpat
t9XbgdnKD4fW9mP5aFd0enO9HTQm3vxye4ABZG7fTPme3Q4Ei4yQjkGsXlu/
9xHm24FFj2U0eRhb/8emjTKqHeBVSFve/hEG2HfD0+rAlQ6QUXrjyIlRBjCS
q429lNEB+lb1dJuNYft3c5MoVOoEf94SCskTDOBKrjDtd+wEumZBLwcx3ywj
PRJ83QlEGzRyEyYZIPjCpXrVgU7g+OoSyXiKASJEvwhayHUBmYchX2cxx38W
P+Rv0wU8Na6mBE8zwNtzTkGpL7uASkNnjOgMA5R9WsvJIHcDbv2YJsFZBqg/
badNs+gGG8s2B3lj/r0694ZeTDfIPPRtcy/mwXTBPJeWblBXr3JQZ44BZk2t
F5+I9YC0GnmvGMzsbJ92fTbpAYeM92iMYuZP4r3652EP0ApNXI3OY/mafzem
ItwLXl9ttyvEvC2OU9H8cC+4F1VexrLAAFD3uINvSC/Q79DP34lZdzw1MaWi
FxxMpz+zx3w0gq23jucPaHJz+RCJ2ULzGG1h/x+w+4SS3hfMDv2JpykBf4As
PTx6DPMttcMtzux9QPvspvPIItZ/HS9EH2v2AcaO1cYnMEcFzh7L8+4DK7tv
/nDHnLBN/35Pbh+QvBBAfoT5XfPTGiKjD+xLpJukY871meDbgfSDjiP5L8sw
l2/aq3/CrR8c+3Vc/jfmDvfhkqSpfoDopdhyMRhgmKLJXqs8APhyX5mKYZ4r
f7B77sIAeGFAWtiEmf1inyfpzQDYx/bIWg2zgDjI2Ts8AIabCtL2YZYoDJ1z
lB8Efrpvh49ilrXvUnloNwgkd/bvsMSsnn0nvatnELAe3E1zxax7pm2YR3oI
mFx+O3AD8zEeZXnlM0Ng4wv1xUDMlu/8zpnFDgHZSe0z4ZgdjzfH32gbAmYf
aFsiMeewrr1QRxwGMhmm1nGYC+rz+HvlhwE7MWBtIuaKa8IH+OyHwReeu9zv
Mdca0AfIgcMgZTPbqSzMTTSbwB2JwyAwpPRQHubWWQG5/V+GQUOodFch5q5v
WaUneodBsGkL5Qvm/mdWZ505RoB14xahb5hHL/GtuiU9AlhHej5UYV6UsNRM
PjMCPpBeI42Yw+9+lDnjOwI0AhZO/cC8icDPI/5qBJS4Zmu3YP7saD1S+2UE
XIoYH27FbNKWXRfYPwLYWHefacc8ckjooybvKIBb+l52YvbLt42a3zIK9D2+
Z3VjzohdY213YRRomKSf68OsJ+SwnxI+CsrPrOAewNzhU7ClOQMbH2t/exCz
28R6obDGUSARcrt/CK+fldP0/tlRELImX3EE86v64uYVYmPgTarW8VHMcI9E
3idkDLTuknAaw+wgU+Yv5zUG4q+RjScwr3wk5dD+bAys3hutMIk5gvOKwZOC
MaDQKziFe6vrt+2Hu8ZAd/335CnMX/5QRFdzjIM3h+SNpjGfMnVj5G8cB+a+
yiO4p8uq2l33jwP5u/PXZzDTkq8l/QkaB1Hfwt1nMWeL1wU/Sx0HL65K9OM+
EiR30aR6HMTU1xvMYe5b9DIWGB8H2LWXhtv7fCPyRXgCdOWGcMxjXtcqT/Le
MQFQesUx3KkHb7KrGk8A0sWMZ7h/KipVvML+bplYdKEuYHZ55pd+KmcCqBRs
OYmbS/DXg3WtEyAi2SQM99Mbyu5VLJMgjs2gELfK+G1zf/Ik6Cm2HcVdYflb
U11rEgSjY6KLmK3qVDbOWE0C6LlVA3dYRufI2YRJYPvx103cctJq9ZLlk2Bx
Y14s7vwHoR8bByZBkoQ2HbcxR29UMHEKzJlFNeIevgJu6ChOAfH2iSHcvr3h
1oTDU0BX+eJKBt6PJv37M12mgFic+jrcurseCclkToF9D3TUcLcnDk3/+j4F
TvTQ9+N2FdP++WBuCnAYLxrj5r8TkXdAfBpkPROzxh2/MPp8FZgGuQGKF3AD
h70BdPNpkMFpcA13fUu0w2XvabB4PsQPN1uu7o7uwmlglvbmMe4nCrGi0d3T
IJXt7TPcSk9nGEacM8DRSjABdyn/wQ5euRmQ8exnKm5z7xclRbozINNb4j3u
qdH5pGsOMwBta83CHXT6cMj24Bngmi2fjztLk2DyomYGvOIIKcP9i2QWKzY2
A3yvOFXgZmXJ7A8VmAUMX44a3NRfgts5lWZBd6xpPW6d7PPXrx+aBdbV57/j
PvekrGTCcRYEfdzbzHzeVWkBu+BZYJY40IK7RvlX3LGKWaB0KLYd96TgrsFv
g7OAQsnqxL129P4OLd45YKCd3I17V+Wo56fNc2D+xdVe3CdS9L8o6s2BmgVy
H+44W/bjEoFz4PJ5sUHcf2g5Q1xlcyDifvwwboX2i95TnPNA4FfDKO5L0ZuF
O3TmwTXv9+PM9zftfFnpOw9ONhpM4mZZG6maXTQPsh6nT+EODOY2v6+5AEJD
O2eY++N0v3k+fwHMt3nP4dbu2yla+wE7V8WvF3F/7HI7FtFIgJox2G2LeTZk
xV6tWVa4jjbDtCpye+eg6ErYdJPBNOOTak3E1lVQYGrJBap/7Pbv54TGjCXr
hA4btaKr4eiyy3on4UUlHri4bHOu4pv6B4mQsPQD3cL3dwq+5/vfNIFfr8fS
+f93ZZCza02qwP/ecei0bUOt0P8md7utaBsU+d9fDfv6KzvW/u/EkVXEvvF1
kHXZ/ncoiitXikLKsovC7dwEVojBNyxLZot6W7iBRRzuEVp2cHDHlllxWN+1
bG+7FXBMAk7t5mJaZyBwo7HrBthqRWNaO6le+gNBEvLG32V6TfEJp+skSVj2
XRh/Auxp6/qopSkJva3W4VuCB4cSfskYSkLZU31Mf5h3YOO2koTO1kQ23A4r
qu57OEjC2fxSpklcWzcOXZKEG/yer8Rdzxf+yfy6JHR9G8+OO2DNlF61ryR8
cqxpFe77JSXt+bclYRHVjQP306uPr6bflYQRFTKcuJNk7Yhx9ySh5/EOpjN/
IM/DHkjClr4U/AVhQSBx180nkrA32X81sx5IW+XFaEloMXSRG3d3tM+80UtJ
ePmFHy/u0YNGoXsSJeEwfEPEvcgiI6PyWhIeeTXGh5srfSZbJl0SChXrC+AW
sSw7vO49tt/4QkHm+wlH9nJ+koSOt0yEcW8ucrg+myMJ7xcR1+DWlBFI/FEk
CQ0YneuZ+fveDsu/YPsv5RbHbRrwrj7rmyRke3ZyA26rXb52ydWScI73txRu
5/5jrFH1kjCx5QF+BOC1SNmHQU2ScN/mm9LM/OnPb77eIgmVz6XIMvOVGm1s
3iUJN2qWKDLzdcpp6OAfScgX91mZmS+B3TfVByXhsTt8qsx8fRYSVRqVhA9v
vkOZ+XLpSiVNSsKJBx92426mZmoLzkrCrycpe5n5q/dvXrEoCXcLLeoz86Wy
maNzpRTccIlkxszXn8XIOk4p+JXf6zRu4SeVW4t4pGBr2KVzuCV1n5Vm8EtB
Y36iC+5NCxdOvhSWghbBRz1wq6RoTTxYJwX5aCd8mfk7uea2n7gUzGdXCmXm
K+9jhg1VCmrF+yQw8+UcqGuyUQqK6spkMvNFPvF732YpOK7SXsTMV+2WK7sU
pWBUYVk9M183WXg3KUvBowKz3czztr0mVmynFDy52W+Wmb/uuJ08iBT0UA3l
ZcHztVfnzKCmFNy18f4u3AWz6+ZadKTg1QO1R3BXJPYFV+hKwbBjaxxxN5ll
03IPSsHwCL87uLt47malHpGCYvlHknGP5pgbPD0mBflZkypwL55X6gkxk4JF
jvnjuIWr6wQvWEpBdkMBHVY8Xzdevjp9VgpuJX+5hHvTtqvgiJ0UJISgr3Cr
dO6r03SUgimkrF+4Ne+LnVN2kYIabuHrV+Dnbc8ggXZFCjZ+J5vgNp2m3xdx
l4IzMcVRuJ1NTudP3ZCC38SmVbCGhXzRf1rV/KRgxvH5+7hT2p0YXoFSUHdw
8wJuXZkZ8eJgLF8tGnYr8S/57DzVuMOl4D5Blk7ct9JWmR56JAUvx4OzWIND
ymTQ1fuRUjDUoWcSt/n1yAzJF1IwU91XlQN//8+UujMJ2PlpyB7BHcGRNJaQ
IgXF09ozOfH/QNPbKjD8RgraPjANwRocNoR8VFB+LwU9N710xxocutSrH3D9
hNUjwsYda3AoIFpqT6dLwVRf21Ae/F+Y4hoS9pZg6/0mcmINDft7TpQGlUvB
3MI1Dvz4edjc1V1TKQXNWjaNYg0OZZzt2dfVYet5sj7ErlRYmDFOOfFdCtI2
+FmIYLaYc9sd+1MKStwaPLIWMwGusOhpk4K7/ZKdsQaHaqX80c5/sPNrGQk2
4OeB51H2+0EpKGxkOoU1NLxiINk8PyoFr+k96aPg98mDl7PqU1i9jsZIyWBO
/yG/zndOChrEkKLl8PpJZuwoZ2D1izW23YJ50BIx4mcjwcZdqwK2YpYd3H/v
CTcJtkR96VDDXKJUk9bKR4ICPv4KGnh/XDappAqTYH+9/Oge/PMgq23Qdh0J
Rs3ObtXHzzvBhidVnASVnQVYDDGjWsNyE1LY+mkhZ8zw/ve/vE+VRoKk+GcO
lpjXCt7yLZAnQQ/dsfhL+JeqR3lecG4lQfLWl7OemI9EhBXo7yBB6UFepUD8
vLeKtt/bRYKtSqTTDzHfpcayfAckqPstLPY5fp5tZSUlNEmwa/MC11vMX1LS
0NM6JGiCLr75jJldJddt4CAJ7r7xajvWsDDOfc9jJUMS9HO/eWgOs0bet8zL
xiS4mPlVjp+FAFtXGjVkHSfB8MFT/TKYPfb9nGCxIEEXd69sDczr71oK7bEi
QW1Fka8nMGfW9CkF2pJgoPdKPQ/M42az50UukODPzkC3fMyhT72CTC9j+bm3
/nkvZoUujuQYNxJ8u7pYWYiVAL/JBpd1XifBtVXyVzUw251f80fWhwTXF7rm
uWDmehvF4eiHxROHrRMxx09Tpd8FkqAG4+7XLsztXtssQTgJem2d8LFfgZ0/
Ed4gx0ck+OSup0EmZruE7vdPI0kwdqriGicbAaaheW3VT0nwxA7XsFOYJ6sf
r2Z7QYJvdlRuzMO8y9pFWTmBBMUzGttkVhKg55zeSasUEixKNrd/hJmLwpJe
koHtL4qV9yE7AR7IbGqe+UiCSTftaqVXEWCY7lt2OToJFm74XPMZc2PrHQWz
zyTYdGdCyJ6DAMUvWpvcKSZBkTTF9xROrB841X1yykjQrfzDSB/mF5HrU4Yq
SFDh+C/hAi4sX0VfWQwaSfAkb/BQEjcBXjR5KXejmQR7zURbcnkI8OOgp+Hb
VhL0PH9ucz8vdh94m1zv7MDyK55Qq8BHgLvXbHsl0kuCebeixoP5CdAvkadm
zwAJ6vQuNvEKEmA56J6/MkKCR94S2JOFCNDo7OODP2aw9bxsNxmuJcAn8xdc
uRdJcLLjsuqZ9dj5CNaLQ1jJUPOxx6enYtj9RJX+5sBOhpdfiZzk3UCANh8I
09FcZLggFiH5Wgq7//SapKp4yVBWsETXj4Kd57b0/ayCZPhn4LVvlDQBunNZ
R1uKkuG24fXh9+UJMC8KloZvIMPq+B3RN5Sw87t1/VgRmYzVNU65YDsB7ise
E5uWJsM2X5Y1J3dh/WD6VXvjJjIsNTbxMcVuk9qhF44mCmR4acB6b54W1m8+
no9vbyNDnXnhwof7CfBZ0tbBATUyjFhv4Jh3DPs8hjxrN6iTYZ+ZfyDNHOun
ui71g1pkaNpsto96lgCdbHLPee0lwzgNXbtSR6xfFx6Fv9Ejw+0RYu4bXAlw
LuQCvf0QGVq+f1K9zYcAIU2vV8iIDC9mJUStuUuApfoE5PIJMky4GRbn/ZIA
edu/W8VbkGHS4LvHcu8I0OByevB3KzKkaN250f6ZAB+svvOR6xwZ8mv5zGTV
YPdHtFXHrvNkKNZUermsgwCltkFe+wtk2Ji18zB5CrufStapRF0mQ/pJh9ff
uVjg8HD5bYInGZ4t2ir1cTsLVL754p2iDxmeT/jZzn+ABbqu8/xl4UeGqnDz
HrINC8xJNuYMCyTDfJo9hf0mC1yhsXVrYTAZ2ttkn69+xgJ16rmPT4Zh+XSy
ZonJZ4GBtl23pB9h9iw3utXBAkXuPWryf4rtpyuxYEqeFXLXCVY5PyfDTInt
I81HWCHrmqBi01dkSIrItvjpzgqHHnu/3ZxGhrMSRQlnalhhV/N8gsg7MlxP
IxmuYF0BmyUuP2VkkqHCeQedbqUVsOTZuaCqXOy8XfzZGfxkBczp6PT5WECG
i5eTqgxrVsC3NHO32BIyzKCojZzgYYNPE46cvVhJhteIwioCfmzQ9Q2isa6V
DCOzrw83hK+EjuPvVVg7yLB+6ufljJ8rodV2pS193WT42KP7AlGaHR7+SBPL
HsJcpiLols0ON+UTJ80ZZFj0XGX3vbFV8FdV26t4CQp07qSt9zjMBesFzWJC
SBToSVNuV3/MBcsN6++70ihQSVDg0L5fXDDz+5cbuvIUWBldNhV3ejVMEdVy
VVaiwOrKk+15z1bD58fpjhLbKfDtRFrb+1+rYWhb+vFhhALD1AkxEwbc0I8s
f+S7OgUa90dIyflzw2tn4vfla1FgDl25SCibG57rjdgRpkeBNgrBrRwSPNBC
bo28xyEK9I7RNRLfzwOP2YdQrAwp8Kv45X0zF3mg5shNfpXjFNiU9ottRyEP
VN1K4JA6RYGzL5153vXyQIWLroucZygwykLjuhI3L6S9Hx8fPUuBI3G59NxN
vFB8xqHvhx0FOh29yuG8nxcK7eptK3DEnt/oIGd8lhdyeZxuTHahQHm9Lcf9
b/DCScKxwuvuFOhgmhQs8I4X9mtUfzrrSYEFqrUGoWW88LeP7ptDPhQoeSz9
ZHwrL2wsKopX9aNAM6HKC9bjvLCCQz2aHEiBJr+kf7axE2HRvk/h3MEUyBFU
dXbjWiLMClQOnLhHwf7eNztyQIYI4/lkrxY/weqzd0TpihYR+7wxnmaLoUCd
jHuNiYeJ8MMn/8sacRSYuoo6UWdOhBohHyavx1Og+6nLuznsifCLVe/F7CQK
9B99F3T4ChEaqK2bmE2lwC+fFd4VexPhD/69LirvKDDyxWTShUAi7M+Kd07P
xvLV8NEnIZIIXUIbR4bzKBBR1l1x4DkRLlhzOMkXUeDZLWMxJ5KI8BaiMnzu
CwUaSaXt6HhDhLyCZ8+/+kaB1iucenszifB+z4PBrmoK3DNkvfFqDhFK5BTb
UxooMHi/U+Hjz0S4xUbaLvoXBVpezdB6V06EmejRvuZ2Cqzllf6ZVUmEUMjX
dn0PBY69t9VxqSXCkt6M3qP9FJjPVx7T1kCEB+ldZ8OHsfozhu5w/SDCxjCR
nupxClzkO6w3/pMIT9lqW/PNYPXosP4Q20qEzsIvztxmocIsbhPVM51EOPun
rqNkJRXK3yw+cL2bCG/krrRk56JCf8dUifO9RMh9X7l9Ny8Vat/eOryjjwjD
zp2x8BKgwpwrF7829xOhmHp4W44IFVYv7vExHyTC5yKF5vPrqbCf80Zi4RAR
ZuRRTl4mU2GQSH4iMkqE6IMjLW+lqdCm/2P+kTEiLLbzOT4qR4VVnlXlhuPY
+2i8bd6iQIVGQ4E3NSaw91nTYWq/jQqDpeZuik0SofmA4I8EFSosFz64pxNz
T/5ukx41Kpw1OkKNmiLCGfvYY6e1qPCL+jfJzmki9N5d0xCzlwq3BSpeujhD
hFzrVhxt0aPCgtQG01nMoYNK9aIGVAinBT+4zBLh+gILQ2MjKhQw4z7difnZ
o9Da+yZUqA/IEnpzRCh3Pv9w7QkqVI7Vik7CrLaeZHDAmgqP+ah6Gc4TYcHQ
oarAc1Q4/o2FMwazXqHXwS/nqTBGOfNFB+b6x2kVq1yoMDzBqJq8QIQnHNv0
ta5QIc8R09njmLu0+L95u2NxdT+fe5jPi6rr5XpSYabevW8FmD2LYvbv8qfC
b2FR46KLRMgRUfnlyh0qROs1bDQwhzgR9mWEUOGWTSKVZzCv36NQOhZOhQQV
svUtzM/EzHUUH2P14gmwjsMsO3q32CEKOw8v21fmYn5TTNdOekaFFL9I5++Y
Pztv0JJOpEKtTFYrdgYRzk8MBYu9pkK9C2mTazFvv5rbzJ9OhbUOo1RZzI7z
wTKr3lNh4MHVvKqYE66fcpn/iNVHTr9YB3MHq1LuSA4VcgajZ40wS9xi5e7O
p0KJhvSVpzGHBsbGVn2hwrhPvV5XMZcTXYaKvmH7tea9cQMz+z3NXVnVVGgS
+LYwEDMUEfZNq6dCizD2Y+GYXR91Vr9ookJ3U6k9kZjfimVIRLRQ4YatMtFx
mAejb9mG/KZCFruj5xIxW7yQZnX/Q4VNo6z+7zFHbJzWcxqkQm4ezoEszPVJ
JY+sRqkw1MX6Tx5mPoVHnaaTVFjxJdevCPO+dBvFQ7NU+PooreILZp/tqh7a
i1R4voFU8A1zzgeu0l2sNDjjWmBfjVkxN9GcxkWDkcLT442YbXe7J4ny0rB9
+Db/wBxXpDvNJ0CDYXVFgS2YW/aKa7KL0OD6mWrONsxrvw7cnVtHg5943Y62
YzY4mPNjWJwGr9/VutqJObAmSLpLigaVay86d2MmNG2hV26kQUFC++QfzKrH
CauLNtPgKn5v337MLq2VRp8UaZDv0uHZAcwpp58+S1WmQfP8oENDmHu6nAaf
76TBuYPqd4cxk2w1VJ8gNBh69tC7EcxmAwK3gtVpMIbsVTiKuXIsXdxtLw3a
scYmjGPmuuxj46hHg2mZbt4TmDVnj7w7c4gGf7/U2jeJ+ZoHlcXUkAYXo5VW
TGHOJEzqHjSmQUra8RTcozeKHmodp8Hy5nLdacybVj3oUD1FgwUvnH/hjuZR
cafa0GDXnpqOGcyNwRwl6+1p8Pt2CeNZzAJC3wX5nGiQ/Vh+AW7dB69OrryI
re9oKTOH+dZ618TZKzQ4xRLpgzs3ct/UkDsN5u+Y+Y57VlJ0d6cnDRp9mpOZ
x+wgndVU4UeDvM7f3uGOTwikFQbSoIHypXHcvzcfd/4YjNUv1UV+AbNY2uac
12E0OPGKZInbaNsi5/OHNNipWx2OO/j9N8PHETT452XFZ9xfVKOf3o2hwdVS
pwZxo+pwp2s8DX7dCVUXMW8QOh1smkSDZLkTprgJ3Te71VKx+hnzu+Ju+xCP
SrzF6tF/6z7u/MCycMZ7GhT73JOKO/bkYH/rJxp8kHi8FLePEr9mPh17Xgxn
K27tRqNRn2Ia/BXnz8HALJ14da9VGQ326Txaj5vjWkTMngoa7Ll8VA5370H6
lEwNDY5WN6vi/kL+rc/VQIOz8nAv7sRJthd9TVj+Mu4b4Q4slV4ob8Hmrxq3
wK133j7xbhcNsl7muopbXiOY1ekPDZ4V6PDGzSucbmwwSIO3Y1cG4h7qrkvd
Ooq97yP3MNyVH6dXCU/SYKyVYQTutDuiJydnaHDvgyexuEPN0YyGBRo0bTFO
wH2E3cfy8UppuC7uTAZu5e8vPrlxSkPRHwWfcIsklQoc55HG+pqei3vqWr8N
yi8N568fL8TdeIiYt0FYGiasfl6K+wNFaS3LOmnY/zTiK+7HU0fO/xaThplr
91XhNot8LP6cIg2Du3404EYcs11uyUjDyO7SJtwSu1vLrDdJQxs5r5+4GcIr
yHsVsPmpK1txt/ZQXWW3ScMXcqa/ced90qlarSINJVff7MD9LOiczMAuadjj
casLt+W2tPrXu6Wha7roH9xaq2o3h+yRhjc/ve3DTWua9HHeLw039G4ZwL0q
eV3z4QPSUMD27iDunutqW5UPS0On3XVDuEsNTgaIHJWGoUdWjOBOoHq3TZlI
w0pj0VHcdmXFdz9aSEMQShxn1s+JB/WwlYbHHLMncA+LHO4HztKQ9l1+Cveb
rIePWV2x9fXspnG7WLToFHpJw2ZRjxnc08k2z/eFSEPSCsU53G4z4yyVMdLQ
r995HndLMcvCbWkZqHMvh4Fb/T7v9J4UGRizb47p2vWKvgtyG6HfQwbTVtGH
RdJfbYQSU0tG7stkzSjKwlOMJQvdWTgFP8rCiWWLqvY88dwpBxnLJnVX1+Vm
yi1/H8EHufxXuXorb/rfo7JqEppv/nn/Ya6w3tzN/3tFzwol72z5/615ymJB
rWLL/6ZYJOgv2Cv87/q9H94Y9v3z11jXzeCC4v8eSz+kRhr959lM53e3HJT+
t7aCtpb7xD/nH99ic+7C1v+tsupg6rsP/5yS6ohl5p//A2CtwT0=
       "]]},
     Annotation[#, "Charting`Private`Tag$2171#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\"yDesired  \\!\\(\\*StyleBox[\\\"yReal\\\",FontColor->RGBColor[1, 0, \
0]]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 20}, {0., 4.507911242254655}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.847333468778429*^9, 3.878090426214356*^9, 
  3.8787142749652395`*^9},ExpressionUUID->"aa58c6f1-931e-410d-a976-\
13f4b3882cf0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"previous", " ", "plus", " ", "control", " ", "criteria"}], "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"solNDS", ",", "giveGraf"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"solNDS", "[", 
      RowBox[{"kpp_", ",", "kII_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "eqns", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"eqns", "=", 
         RowBox[{
          RowBox[{"Union", "[", 
           RowBox[{
            RowBox[{"solDers", "/.", 
             RowBox[{"Rule", "\[Rule]", "Equal"}]}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"y", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"area", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"uSqr", "[", "tStart", "]"}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"area", "'"}], "[", "t", "]"}], "\[Equal]", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"y", "[", "t", "]"}], "-", 
                 RowBox[{"yDesired", "[", "t", "]"}]}], "]"}]}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"uSqr", "'"}], "[", "t", "]"}], "\[Equal]", 
               SuperscriptBox[
                RowBox[{"u", "[", "t", "]"}], "2"]}]}], "}"}]}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "\[Rule]", "kpp"}], ",", 
            RowBox[{"kI", "\[Rule]", "kII"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"NDSolve", "[", 
          RowBox[{"eqns", ",", 
           RowBox[{"{", 
            RowBox[{"u", ",", "y", ",", "area", ",", "uSqr"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "tStart", ",", 
             RowBox[{"2", "tsol"}]}], "}"}], ",", 
           RowBox[{"MaxSteps", "\[Rule]", 
            SuperscriptBox["10", "6"]}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"giveGraf", "[", 
      RowBox[{"kp_", ",", "kI_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "sol", ",", "pl1", ",", "pl2", ",", "controlArea", ",", "intUsqare"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{"solNDS", "[", 
          RowBox[{"kp", ",", "kI"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"controlArea", ",", "intUsqare"}], "}"}], "=", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"area", "[", 
             RowBox[{"2", "tsol"}], "]"}], ",", 
            RowBox[{"uSqr", "[", 
             RowBox[{"2", "tsol"}], "]"}]}], "}"}], "/.", "sol"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"y", "[", "t", "]"}], "/.", "sol"}], ",", 
            RowBox[{"yDesired", "[", "t", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "tStart", ",", 
            RowBox[{"2", "tsol"}]}], "}"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Black", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<t [s]\>\"", ",", 
             "\"\<yDesired  \!\(\*StyleBox[\"yReal\",FontColor->RGBColor[1, \
0, 0]]\)\>\""}], "}"}]}], ",", 
          RowBox[{"PlotLabel", "\[Rule]", 
           RowBox[{"Column", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"\"\<controlArea= \>\"", "<>", 
               RowBox[{"ToString", "[", "controlArea", "]"}]}], ",", 
              RowBox[{
              "\"\<\!\(\*SubsuperscriptBox[\(\[Integral]\), \(t1\), \
\(t2\)]\)u(t\!\(\*SuperscriptBox[\()\), \(2\)]\)\[DifferentialD]t= \>\"", "<>", 
               RowBox[{"ToString", "[", "intUsqare", "]"}]}]}], "}"}], 
            "]"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.689418628896705*^9, 3.689418631802955*^9}, {
   3.6894189071935797`*^9, 3.689419132427955*^9}, {3.6894191647560797`*^9, 
   3.689419464052955*^9}, 3.68943950025*^9, {3.6894396755*^9, 
   3.68943968146875*^9}},ExpressionUUID->"b0c0a66d-7c9f-40e8-9a77-\
c1743cdd2b65"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"weightOfArea", "=", "60"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"weightOfUSquareIntegral", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"forMinimum", "[", 
     RowBox[{
      RowBox[{"kp_", "?", "NumericQ"}], ",", 
      RowBox[{"kI_", "?", "NumericQ"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"weightOfArea", "*", 
        RowBox[{"area", "[", 
         RowBox[{"2", "tsol"}], "]"}]}], "+", 
       RowBox[{"weightOfUSquareIntegral", "*", 
        RowBox[{"uSqr", "[", 
         RowBox[{"2", "tsol"}], "]"}]}]}], ")"}], "/.", 
     RowBox[{"solNDS", "[", 
      RowBox[{"kp", ",", "kI"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"solMin", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"forMinimum", "[", 
      RowBox[{"kp", ",", "kI"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"kp", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"kI", ",", "1"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"giveGraf", "[", 
  RowBox[{
   RowBox[{"kp", "/.", "solMin"}], ",", 
   RowBox[{"kI", "/.", "solMin"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.689419630927955*^9, 3.689419904302955*^9}, 
   3.68943946671875*^9, {3.68943950796875*^9, 3.68943959015625*^9}, 
   3.6894396576875*^9, {3.689439751453125*^9, 3.6894397916875*^9}, 
   3.689473882328125*^9},ExpressionUUID->"1917570c-c62e-432f-bdba-\
435930b41d22"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"kp", "\[Rule]", "11.103063783914573`"}], ",", 
   RowBox[{"kI", "\[Rule]", "2.2228406430940777`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473334696688795`*^9, 3.8780904269943013`*^9, 
  3.8787142757673345`*^9},ExpressionUUID->"792bad0e-3481-459a-976a-\
7d5b990e693c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJws13c8ld8fAPBrk3HtEbK3JFEa9zkfhYbS5ItKhYikjLJSiSIJkUoUEmVG
MkKea2aU7CTJ3tl73d9ze/384/V+3fOcc57POedzPo+M1dUTFxlJJBIXC4lE
/59fWvqbRhOgkv7/V6yT36ewSDfs9Szo2VP+Ln3UaJLuyJFj+iKUGvGEaech
wiA6X+WhSfke8nzpWRfhOJ11D0OgNDOEkIrbCHfVJX1hNaK0u/mx9dUT5nXc
9Q47Reka9ODZUE1vr/yRw+QMZcDCSUizhHCYsbR+rxVl7Ju1hOknwvV9E48P
XqJMg7nczSzC7D8OOJ11oixmG6u+TiYcEx7pGOpCWVfU31oVTzjTzmjY8AaF
+cVO3fEowuUjBptNvCgbuLcgwXDCzeL3dAtuUYRmxI6cv0t4vuzSCX1/ykZb
8qn7XoS9LkwwLt2nSP9kPp3mQnjVRFTk5wOKOj5xadGKMC1eOYc7jKKl1X91
02nCxa8ym4sfU3QT22/on6S3r+RIuhdB0X9Y4R+2j95/1BbLU88oh9YLHubu
JvxBf1X/TBTlmHNmeMc2wn83vvjtGU05/V90nLI84d6DB+XnYykucs5FVGbC
PW0FfktvKB5PbcsGVvmpJErHRexUEuUWx5karjnCZteXGj69pTyYMGwz6+en
3vl6qd0vMYUSVygxO1lB/G6eovfgdiYlSYN/RbiYMIvfzkNmWZS0eDZGSi7h
x0mJ7ts/UPICpskPkojnD9S1izB9pNSdrFKTCSCsE5d/5Xcepbnys9b+20T7
ru8nwrvzKe07s3decSd+dzh0QW70E6Vf6tX+T3b8VJCS/hXEU0RZHXW1Pn6A
nyrNpBS/w4hKUfOXivblIJ4fMJ8wNKmgcNUnh62T+KldeYM5rnyVlHFx7fve
i3xE/IUd6usrKR+yDzhfH+SjStebRouZV1F0e53321fwUe+UWMmMhtZS9PeW
zxzz5aMe+9101sCogaIYYjz8zYOP2nVQVuNXaQOFrb2t89A1Pmq9ht4c+55G
So3z32r9c0R/Fybt1Lc1UY7FC8fpUvioYZcE/4Rrt1DOkOwPSy/xUsMYXQU7
/X5SsMMzei8nealV01XHZwTbKVLPfXZsHOKlmp2euBf3tp3SsyVcVvAHL5UU
md5Y2vCLculc4SJbDi9VN3ViTXFnJ8WtmDtx4hov9fDWim/bU7opYks2Kz4N
ZGr+evCSp+UgRbh9Pvt5CZl67Z6m7/qnQYpgYaBjdhaZWp8T3qUtPETh8Un7
PfSYaC8QoZhXP0RhZJjFT54gU6vK/L7zGY9QRtj9/FWaeKizs/KRUg5/KUWi
8dwtzdzUr0ey3esEpimflrQqJ8q5qZppV3dkHJ6m5LaX39qQw011PMfZO3Bv
mpIZMzSBIrmpDuVda1ZL05REac3GFBNuanAg0977fTOUEGX86Z1WLqrZkjKz
Z+0c5Zzubyn1Nk6qtM/MVXLHEoXarpD6tIqTOP81NrmblinSPk7bGT5xUvM7
tzR8uLBM6SmhHW6N4qQGvX/Lmza0TLE1kvW6c5qTOv7qoGrc8grFydKuublz
AzXlo2lViMY6xcd/KtCnn4NK6qz5sfcyA9apuEtwqIWDemVVrvbvYwYMq74b
e6KSg1oZqO9Vls+AkXgEc5XeclBVRn9xTrAyYv7Ptvc2XOKgfmu1XjVMZMSC
U7wpimPs1McH2/iXh5mw6HqW6bppNir7y5NCVyJYsY/yHhaD3WzUjpBDVupl
rNhXj5FSWj0bdbu94KLkDCu2Kv09QvM9G9Xth/T6s5NsmKXzc53wy2xU4RcS
boPC7JgMv5qnSR8rlSU/lm02iQN7e/IYqaOFhRpo2vy1bIwLo74tvTRbzkL9
aqas/VWWG2tb0W7g+shCfbbvaB+rOTfG/kbsNSWchZrXKCQlUMmNOcz27Is1
ZqFK/Li3fv81D7Y58nqA1Rdm6oEiDy0nLV7McHhwwiuXmRrAUJDGfJQXs6RY
mEUkMlPZC22MPl7mxUL6MZVyP2ZqQ9D8nGUiLzapw16rAMxUt5ecpB4xPow9
yGsbtoWZWur//KXeDj5MpnMs2nQTM/VYV8i5glN82In7DY4Bq0zUbbN5xxZC
+bDs1hc8w/lMVCzBzV+exoexugXpyyYzUQelzm/xFubHzPi8vE5HMVHVe3pK
mtX5sVUj84FvnkzU+zsyXoaZ8mPGwwck2ByYqNE18wPT9vxY/H3dE2DBRD2Y
0CpidpMfMywRKf6wi4nqrnBGU+0VP/bckm12VJWJulDHIBqVzo+NrsyrKIgz
UXmLsUGOIn4Mixo4Z8nJRK2Y5n/lU82PhW1vjXy2wkgVvHJrz2wLP9bTVFFb
P8pIpan7ll7p5sd0nHMYNnQwUv20xDVHRvmxQJ7EHfu+MlJf+xy+Zz/Hj7Wn
Prlys4iReoZHqHR0jR9TP+ifkJPGSM3qcxu4xiKA3R5w/Tkew0iNJzlOL3IK
YI1+1mTlR4xUNavlfj8+AUxe5qTBBR9G6jEO6RI+YQHsRvFe7xdXGKnk+Q6/
12ICWNVprayms4xUB+WtGtslBLCNSzKDXMaM1HNxEtSvkgLYlad8koYYI3X8
bOxO200CGHUbw8nbGoxUsQufXjAS5m+YDMzfxEjtTHbojSeet3HqKp7iYaRS
dLMF9DcKYLmc9bOqNAaqLleE2jAxPnsyrmozwUD9prBB7TG/AHba8P35l38Y
qPwjc6oZPAJYRu+rp63fGag/T62cVBAUwEi+IV/JVAZqtY1zmbe8AHZi0y3G
g5kM1EExM88sJIAlFl7RvRvHQFV3e3+98qIAtmh21qkwjIEa4+qeX/BUADs0
f/jN7B0G6i7RTL2QRgEsJmJP+2ZnBiqTlTmfnpggNqGpzmt3gYE6fcxVqclB
ENtbJ24Yd5yBytW/5qf/RRB7cpnz5k89Bup/m5YUIzWEsAH2lSx+LWL+qza8
FXFC2M6kkUEjWQaq3R09aJYUxoL3tUve42egqiWH5JYmCmOdXdUnixkZqLLu
h13DdEUwzVufHixMk6iGI143KK0i2F3xZFyzl0SNZNxIrb4liimZBqollJGo
72RTFO9MimFeM+4XOrJJVEfV6H0pnzZiX8Psngm9IVEv/VhNyn4kjl2rNWQK
9CdRe6T59WxMJbHSS9t3lriRqOc/V7hzGm3ChFgVry7bkKjL68Ozjw9JYQXA
8svRgET9o7v3wqYcaYyrc5Y3SYdEdTvu80DTQAY7591n+EeBRH1aNHnqQ7sM
xpxb9uE4K4n6JuhOC7OwHJaeZNsg9JeGP/wbE9RSKIed6DagBH6j4WwJUz1C
dvLYgrhC8nI6DU/cYry7UkQBizFlFroSQsPNfvuP9TQrYJmz23fvdqThg6zK
JcZ5ilh5uP0FjkM0XG0I2fNlKmFtmjEBP5RouLzv1z5VXBkbratLT2Sh4b8a
vm2L7lPB1h0Zml171/GD7ftMraTVMH5O7WW9knXc6oXG4Tsu6phisq00b+w6
rnAuIt/412Zs1/4ow86b63jU2llxqYtbMOP+Wsc0i3W8fyIp/WyQJmbltx7u
pbuOd9zdWsR3fSt2Q2brpwPC63hWnvGnVBct7AFu/Ud4dg13Cll/o+a3DYs5
+5Slv2EN52DTu/04SRvLXKlSy36/hnvLCB/43aGDlUetHPd9tIbHMeVoqyvv
wNp2aHgcvbyGt/qscuRH6mJjLedfSR5cw5W7Ln7/qrQLI7lFlI8qruFPVaf8
HTp3Y4L8lSOfmNdwmbOvVB9/omBKmYu8gT2r+A/3K1T4hLBdxmo7TKmruCll
S0LROGDGY2fPyr9axSs/6FpKCuzFrILC/Ka9V3FhuW/xUYf3YTeUy5Kp5qv4
24r5XVIJ+lhQ5dz3kB2ruFqAvmmQmCH20kZ5/ozQKu7lH/fe88N+LJPxtITa
zAr+X/ssY/C1g1h53KO9S/Ur+J1ENa7zpkZYG0a99CVjBa9j3BLwxPYINtYx
HRIZvIKTycNbqhKOYgJiZr+2HljBfzQJrjX9dwJTzAtiICmu4C3bS6urSk5i
u0w+K9UxreAdqlKJXvtNMOOZiSMx3cs4q1GD5vtRU8zqsaybA76My0tyX0jL
NcNubDF5oftyGb8ot8ounGaBPfgWQGX1XsZDHLWl+uvOYJkcf7kSti/jwr6O
+UbN57Hyt1LbnAWXcebc/MO5WlZYm8EJczS9hFcmm9yrSLfGxnr9b3PXL+F5
1iG/5wwvYjTfvMRf6Us4Gk2vL6PZYvzSI7XJD5fwdDtjh30dlzDFYolpd/sl
vPXZjbmWXgfMeNkXE1RYwtdkfm+u872KWT3/aNPDuIS/cttz35HsjN3YPhiU
2bWIn1+7MbXZywULahbLulW8iD+9P/emmdENe+ly+MfhmEU8ecejXKHU61gm
7+21jV6LOFkoUsTFwx0rz8iSG/5vEe+Wfb8ocM0TGxsRvnZPYBGvF2g6Xzzi
g5EeHHx6cmoBd/p6Zo191x1MUOlmkcz3BVyqWuel9AtfTLkio2cibQF3f5fa
rCvih+227mYvDlrA7UvLHCDbHzNmENwSfGkBN7zwiG+H633MKtbQxMJwARd9
FMqfaBGIBf1KjZ9nWMCD29ZrclKDMdtVoys2XfP4lNmk9xVyKKYnOabbWDyP
2/RbahxpCsMksGBmeDmPGz93+TG4OxxbtFSvT/eexy+Poqz8sgis6fbXaHGL
eTwiyY150jESy4hztHugO497Py4WK975DLvYk7ZuMzeHNz/Sfth2MBoDpiM1
jU1z+NG6e4frIl9iEvJ/I+HDHK557/vRYY44bEH/0YWMsDlcWXgpNc06Hmu8
uHmzxNU5fDA0RKKi/TWWcf/b4oMjc7h2qPAhM5c32IO3V8oX1OZwl4DH5W3q
SRgMp59uGprFa5LZM+sEUzCJDcZKel9mcb0k+7CIg2nYgur4dEbiLH4NaTSk
ZWRgjUYhxRL+s/ihgT9cdQmZWIajRlCQ1Syuv3OjRijXByzoUZ3JIszi2cfY
c62eZGMXM5xkbKVm8XH9kENxlBxMYjIjX69jBneQ9PFxpuVji7xH/d8XzOCq
f+v0VKQKsaatE0clo2bwOCH/GvYrn7GME6HiD91n8Ca7eEPqGI4FuW4ZXDSZ
wZ+/U15+e7wEu/jk+wdb7Rl888yQx92aUgxyrt5q5p/Bdylivk7W5djC/Huh
zO/T+IBNa+UOhiqsUeRYt2TGNP6A83EFH1cNlqE7mfYweBpvVmqSLt/3FXtg
Huax5DCNtxfpC2en1mE2Xpr6dgen8Z6gIxf439RjEF1PblGaxt9HJmn+4mnE
xIuu/drLOo2rXm7XC3jehDWuZbpsKpvCvUS5ozMEfmAZm45jwfFT+MzYfWkZ
zp/YAzTFsXx7Cp8XMO0J2vwLszn/uMXOcgqnVmplB9/6jYHv1viWPVO4Wcve
bmWGLkz8dYPjPvEpvG7syGcby25svtRZN2tpEn/tzZJk87MHS2f+8D04dxIf
8FRfPbhtAAtUOBG9/GQS58k+5/xXZAizMZy2veQ6iYuW9O9bVBjBkF24Vuvx
Sfx4pOXpnvNj2MZArfV9mpN41MTX3Liv49j8u8bqLJ5J3LH79c3Y3EnsdUS/
KmqfwO+e0H35Rm4a4xWxNZ8/OYHfe5l0ve/sHPbFLGmygXcC7yqgnn2nuYDd
ejEQkP5tHFfOdjt4VG0J0+lQlHoQNI6X3xE8KHV8BRuTtMu12T+Ot2ble00n
rmEJ594eAeZx/GqYXXufMAlZxA/2iZf8xRt5i4rsbjCgL/KXBJp2/cXfpaSX
KoYzI9uHL7u2ro7h1SriuqDNipinG9PDPo/hqTHqf6IW2FCCGbv3xK0xPNsu
RflXJwfai1MOGMMYftvcyKlgjBN1K7gKpTOM4UfmTDys5XnQneB3PZxlozi+
9KgoRp8XFZsL+FQbjOL/4cXMh2f50VnqgUPKbKO434u3f9OvC6JVxVsiAVUj
OCReZUkUEkbRj7L7+h+M4B9tN72JahVBu2aHsvSNRnCN9GdnDxaKoZ8Wm24n
cI3g3d8WkUelOPIoOXmYsW4Yf3Op8YnkiiTKDSkewI8N48/1yE3m7jLIZG4m
exP/MF6mudTr2C6LZk+r+Po0DeE3r3H4FZjLo4hSS+OOJ0O4g7iPov+CAtJS
eSK+23QIH9u2lCqWq4QaQquHokSG8DsKHBXKz1XQtfn1nMW2QbzImfW6X5wa
yiizP5Z7ehBP6b6xpiWqiY6oxkoKSQ7iXj/WrC+c24rGwppHXDsHcGHnSP8A
qhZ6uMCR3xg7gG/N/kT+TNFGqpbo3tYLA7hJ3fwt1Z86qLrc7USY7AC+v8Lm
qmHkDnRJLUVqorcfN+45pB/vthMlLQoWpNn246874ypd31GQwblDAZzK/fhP
Pt8bTxkA9VXcPuUw3If/6k4r6zDUQ37qOTLVKX34weOSVrOJe5FsxMi4kmMf
fo687+lvaX1UsiRVdH9zH26d8T7xxycDdP68yYP+8V78THPFuZ2u+9GrzVS5
BOdefKaFUlJ83AhRnsxNMmzrxS8caNj2+uYR1LGsWnx+tgfnKnmW7d50FHlf
OP8Qz+nBeUH7yh/142hjVaTZJvcePD2viyXqwQn0SaNWwUe3B3+3h7ppnOEU
Moskzfxa6sY/RiSZcD83QU+tLj+KutmN65sdfaWrZI50quMsFinduGM1W4W/
wmnUvKVV6T9aF96sfK5T7fBZ5PqUcy6H2oU/2sEreuTVOcS/BqWCd7twkZgd
npnkCyjL+kao674u/LyZq4GfvRU6VpN6ppG5Cyftrzd93WmNJLZsHpci/8E9
Oqa2XZazQxarzwJ/P+7E7cusfToWLqHn1Yxy0YKduDHsz1SfckCtT698Nnv2
G39nf2bPDv4rSNCm7T/hjb/xHcWbygUtr6ITW/dNN8V04Fu2pxpzjV1DYevp
wY+lOvBzvBdvDeu5IK4ovxIuhV/4EtxTI8N1xDq722Dny3a88T913f387ohm
PFt1Uagd1z6RGSXI5YkWk9MOhz/6ib+sfz1XqumNppkv1hez/MSjs637e/18
0Ng5yVOjPm24zkCNTyLzHdRf0PJDZP4HzjQdMBZi5Yvarhn+uTbQip/mzOff
5OmPGmvXrV5atuIzD6ylS7bfR7WKeQPVrS34BvW8vGixQFTue9Vh3rgFfyxW
3ZUqH4SKO5TGZb804zG3EtyUTgej/B1dzkdRMy5S8Ef2NjUEZYU/n/POa8J3
632K25oWht4c4FhrftuIx1quyU08i0CvEkruMEg34vdmbrAJ74lEz9Y9mTWe
N+BCBg4MFMZnKMxcK9CCtwH/LDhhPjn2HAV9HOEMCKzHT8sqd/Wtv0D+5ITQ
bFI9nnFKR2tx10u03JyrSJ2qw7nvTjZvfROL/sBzHZfGr3hbXXn6vXuvUeM8
O6W2tBbfuksh9gvbG1Se5qkvn12Dt33/xnDnbSLKsxox8kmoxnXmNASjbd+i
FNHTJ1sjqnDJL6maovuT0cu6Wost/l/wPLUXYexGqSjMf49VoFslLszLZvvI
LR3dmJR03mVSjrtpbqh7JJ2F7JNCPCIMynDsnu/XY24f0JkztNtjOqX41HS1
yX9/stFR/msBBool+LCPiVKFVQ7aW9UV8kqYilf6sYwV0nKRw+pr9QnuYvy6
cMRns7x8dPSS/+748ULc3+Pz1aygArQR9puzZObhmiekKXmBxYiUpnwpLywH
T63Eqt5aUNGAyAZ3e+dsfHjGx6bgTgmy/hOlEn0xAz+7/fmd5LUypJF3Zj9N
MQWfF2U8LmVSgZZDpC5aDyXi5Xz+D4I+VyJ5n0N6/7W+wF0a1u0LS6pRoXr9
TSnzcFwja+hw6NlalJifeu17nh++P2p2n8uGb2iVz3uvlNdN9MOfwe64UT3i
Y9J3zn7wBgljT3Wu7GhGhmq+J49WvUO/KtqNl/RbkNfJYp1R1nTUPG4ceci8
FU0dl/DhK/2AVv33HCh60oYsXj/VO4gK0ZKzXTbF6DfSInP5+ez6jNJLrm/P
dOpEnDd9y7N0cESlMviJRv5Bnaq5ctxPS9BCtPXwu9kuFMYcn3Q9uAJdP8Uj
mnOiF03n3Ugz9PyG6n5kpjvyDyFLp63fum7UIR2jp8/F3g2hWvmxv15u39GN
jYOPB/YMo8aqzGc/8upRgdWC4X3rEZSio/iTM7sRKUcerSl5PYZOk/nOuCW3
olndEZVop0kU7uDkqKf8A31d1I4szJhEVRW1N3ne/kAybtrFG8YnkfbN+y/f
vWlDyHKoZIvDFOIaXunsiG1H9+647LtrNo326ptPJG/6hdSUnzQxhk8jj9hc
2o2Xv9CcRqjz+5pp1G/iLM0X3YEcHfX5w3bOoOLSgQsGTzuRlOkutTDuWTQr
qe/CL/QH7b9DvhsGs0jNM/7un4g/qP188tMvLrPoq0hGQ9GBLjTziPVWd/Ms
0q27NG1q2I0ObLe/vhY6h3h3d257qNeLpDyvcFf2ziOJ3q3OH273om4xfMlx
wwJSfngv4+fnXuTczRjhprmA0C91FeVdfSjK4nR2htcCcvL23lSh1Y86xjuD
udgXkZfc99Nj1/qRlJt52bzKIrpXKxsl8L4f+dzs2XrSaBHFiNcIWKkNoPWG
m3qXgxdRbaEoB01uEDUfavA8wb6EWq0dDRWtBlGZPwc7h+IS6uGk+h2JG0SV
rfcO7t23hJZP261HSwyhqvimav2bS0h5NWdGV2gYCS/wceFDS+j+npOdLqyj
KOhQ/yHp9GUU3pck/kJ/FA0KJZp1lS2jV8HLZiV3R9EP6++vUPsyyumIbyLT
RhFfZ/KWHpYV1HdzsiptYQwR1fd8t9kKmpTXZ23W+Yv4BYrLKx1X0MrXZ/tW
XP+iPNLRMtM7K4hfEhUfnPyLzu/UnPBJWkF6nx9lDwyNI8Ok3yU8Eyvo8MXu
SW6lCTTCwCXqSlpFZtw6GjoXJ9CjLu/tj/hW0bWzHe/8uieQmmRU/KDWKvp+
S+go75VJNMYVHGbqsorWN9nop1+cQrvIe52E+1dRZGiB8sWAKSQVORJxa2YV
qZP4uCWTp5B685+5BIY1ZNH9uSV4bArJjPceVpNcQ7kJInaOrtPIs6/tweHj
a+iIoJORfOQ0EhXdQcHPrqE+//ItHbnTqJPLdfei/Rrit3VeNFqeRnyNpw+W
+K4hJ+XaB2q+M6jL/nNhbcYaYomScep9PYMu+y4wPfq0hmI4PE5El88g5o+C
HhLla6hmRF6ck30WXdtdYZ/ctoYU02+ljYTMIrSL/XYEbQ393qr1PTlmDkW8
8TtgabCO3F4HZl8onkO9Kr4eF4+sow0Cf56Jdc2h1tIkx/0m60h39uH5B3Lz
qOx8qtUrm3X0JLd/6lLKPCrfZOuU4ruO1JT2tEp/nUdHHbaxvQhcR6XPwgva
/s6jBbEfXvah62jSA/kd2LqA/C63aaXErKPDu6MElfMXUIjbm/DSnHXUmzqx
+OfnAio4bhlDLVxHXhKGv5+tLKCkiSM/X5eso3dr04lsaBGdWjWYEvq2jpip
h3cMViyiRwk9+8t71lGRPskiqWkJcSY+dEzioKE/smcSJGaWUIieukMTNw0x
MuSPhfMvIxmZRyfG+WjowOert28fX0bGG/rUJsRoqEnnzxuz78tItsZAXEGF
huYFdo/XjS+jgPsFxdXqNCQ6/XSHAc8KEkvf/txSk4YsM4xrth5ZQaUx11gt
dtDQiGLxxIbaFdTWdkwrVp+GuFk27vQdWUFoWqPr634a0uy9fneBYxU9xpYq
xw7R0I3YzUJ9B1bRQ2qjBvNxGmIQfbnrc+UqkhgK7H92hhiP4+a9q6VrKERz
83tfZxraPfijrr97DbH+OkQbcyXGr9gmeoZhHZ18tbv1yA0aeuM7mnIA1tGJ
56crJ71oaMuyRb1MMbEuHktXqX40dKItV+z573W0o5Mzr+MeDbnl8lvzrK2j
9zvYOicCaKjApWZueTcNFb18cX7lIQ0Zju4Ub/5EQ1PJR/RTI2joUnWkzaGf
NLTx5ZfndyNp6OHbqXTqIg0Z//KeO/6MhoayTsW1ipPAbprP5OcLGtJw4tpW
ZkECYUGKckg80f+At1lMGwlE/jY6pKbTkKA8KS55mAToYNrqlvc05HTBfzB3
mQRHfF5cSc+kIdmO4BsNEgzg1+t9PSKbhoIaXj5hvcAAVS6uOJmYVx+PbIeA
CwMcTr7QY1lAQ9jhJDkZPwZwCHbofFtIQ9OVGR92JzKARHlwk1IxDVkU4fXX
hhngFYtJXU8pDX1c2id6a5kBTApym5nKaYhnR9W5h5yMADuYH0tV0FBpVv14
4mZGOKf9LmD/FxpSfdvN9cuZERwHVqZP19LQ8mOmgwbLjOA0GfYipZGGTn0P
CDvByQRW0dGhvk00lMHF1XZOggl0tX8+PtVMQ1YBgnZeGBPYt1eyT7TQUM1N
hXvv7zLBdAWteqGNhuQLkr8WRTCBSF2CehYR51sLmwVr3jDB/bUFZbt2GtJy
2Z7QV8kEPK8vqVX/oqEXdvtLxDiZ4USmM8muk4Zm39SyK0kww6n4lz9Z/xDr
0nP0mPZmZvirNlSRQJjxrNkf46PMUPd4lqeli4YcTtiv+UUwww3Z+iLhXhra
RXm4c1ycBWLrXu+TGST26yezjFR1FqjYZrIWSVhRR1HOnsICzCHkGPYhGuLf
XMLVZ8kCbKb2GYOERyUW/vyMZ4Hw+CNbQkZoqOd5+alnH1jA2KRFbIZwm2B4
9akyFihKFtE2HaWhcq7N2d/7WMCWOVBYZIyGYlat7lcosYLg9SJ7/780FO6h
uXJXlxWUOIfe/SIcOLt2FQ6yAs+0ksnWcRq6PvbcvNCBFUSDQwTaCBt31Kln
pbMCh1HyhMAkDdEKdzXFbGMDEcOVxEPTxHnewX7AQp8NtjEY/H5IeCy7pUjE
hA3Yrn8brCXclnotKfwGG2zQaws6MENDmdFJnoGf2OCL772n2rM0lCTiNm5Q
wwYLYtfnHAnHROhZM/1iA/Rn07E3hB887Dh8a5UNarSfcPHOEevtzS/thtjh
k5WVeAdhs4U/T7YeY4fG6qutXPPEfF3TOSbOs4P//b73ewjvunxgxv4uOzBU
B9VFERY4favyXAU75Mie3nxogYjXrhFHIyMO2JlNirxPnLs7V3YJDllwAHey
wqN3hPfEBRX6O3BAvA3rTDXhjyxqG4ofcMARPmM+ziUaSqy//FazigP26/i2
3idsxVRk/O0HB8xaLXq/IbxpO9e8/SAHCD9Viy8h/DQ6TT+BdQNIfclxXSZ8
3/Zvt5DBBgiMNblhu0xDe6MoDz6c2gBuviMmdwiv1z7SPGqzAS6E3q+IInxj
q8btQL8NkE6WPlNL2G7VSWKlZANwV4xGqawQ+Td80rQL44Srq5c6mwgzV8D6
TWNO+PxHN2yQMHUhLFHMkhOep8aMLRPWPbt19oQPJxRzCaVKr9KQirLL44pC
Tri808buEuEBi1Jdq1pOEPgwFelJ+PUj/q71dk5wyxjzDCK8ceaDhu4yJxhY
stulEt5QPFObossFl771LAwTrpzc57r/ABeIPxuaWSR8V+7Jxr7/uCA3mPye
bY0474Ha9pLuXOByusNWnvDIyeusYTlc4N26Z9GCcO3wPFzX4oY7SdO3PxOu
d5DktNnHDdsOOP6sJtw8uq/lxCluGE0NX2wh3Pk3zF7zBje0L00//Et4cko1
fPQTN0y4WMptXKehOZfjZ9pruGFu8EWlPOHlGXfF6l/cMBT7ascWwkzz5QVJ
a9yQ9XDq/j7CwsuWvRf0eODiUfZpe8Ibve+lHzvBA3x2zBKuhKVWU92RNQ+Y
enpsvElYeX2RU/IeD3RZzzx7RHg3Y4R2WxUPmKufT80gfH7Dl3vGx8hQptnd
Okz44sO/RykXyDASoBY/SdiBS3CjugsZXGI5jRYIu/JcyOB4QobeCFZgphH7
hX+ltfwHGYwedOAShIMiZOKzh8ig7HL/mSzhUMEDl18vkUHoI3ZSmfDhhzU0
nJsXKt5Ue2wjbPpI5MnLLbywr7/5wQHCbd9UlwR1eeHoXp/QI4QteDDLYOCF
skJ+nxOEz4XaKHsf5wU19nG+M4QvPc4qMnPlhcTegs1OhL0jjfoF8nghIsbr
bgjh81vjepeLeUHZJmDxMWHDb7Pd3ZW8cPzCsmUkYV6WV53vW3nBV5hjPZpw
ktvkD6N5Xrgnfe/hO8IPeQ1atdZ5wWv21sNUwtfSoprFWPkgwqnWJ4Pw7r69
DYNCfOAVcWLXR8L1JyNr/HT4wP3TdzGccO7EcJUDhQ/EbRmzSwhHP8S+HDfg
A70Dp6CcsG3ZYJmUCR8U6AnrVhNe0dr1udCND0Q2/hffSFiR/8/7mWw+2BNT
5N9LmDNjW0Z7IR+AvtaNfsKTBwPTSsr4gEks1nKQcKHv1uTQJj6gtc4KjhI+
NuX3Wm2GDy4GZohPE97+qC2Of4UPFjxXqmYIi6tsjl1i5IfCj45Oc4QHzrdG
f+Hnh6ydJ14v0uNZrxxprcUP/c7FWev0eDr6RBzaxQ+nUsb5SCQSGLI3Pt66
lx8w39AvdPOCdwjtOD9w7aEqMxJOev8tINqZH3THPMuZCdeHuHg1ZfKDgix2
hYNw+3GtIOtP/GB415hhA+FewemomRJ+eDF2Ipzu+RfOnwSa+GHxi3MqJ2HJ
t9cWT87xQ95iaCE3YUUHTfa+NX5Q76rW5SGsuXlSxI1VAH6Z2GTTrZ99dccT
EQGYtvobRybsgDvdaN4pAGmiGZbEC4DbXY37NnsFYHV0XxXdPgbjkbOHBKDl
yrMt/ITDaq/kCJ4RgNI78Qt05/1wnD11SwBGV+2cBAlTX6gz998XgNSLfF/o
rjk7JnA9VAA4tb9JChHu7L28LTJOAC5+flVBN/Okg0tLqQA4Cj+gCRPmyVa9
e7FWAOrLUw+KEBa5MfJ4rkkATN/JhNOtumqfJdQvAOY0xU2ihI+z20+asAnC
SJCPnBhhi1pl0gBZEAb1xC/QbRMyRL4hKgifQw++pNtD8NKWpyqCcEjchW8j
4VfSdk6tRoKwWSZlmO53vYq3bE8JAlbsJyFOOCtp4NH8GUHQMpU1prtc3TZd
2EkQXG5UpdM9ontxzDRMECa/Gp2TIDy7Ir868FwQrrwYDaR7rbiP0z1eEAoK
vbPo5jWwUXv2gZjvW18a3TuOWzv8aBYEM+ecUEnCIdlfwtBvQchr/ZpJ94CQ
et7bfkFIE2RuoPtp+yyTx7wgLEd282yij2d9/6WoqBCEkSvu0H24cqTsjrQQ
bIjeH033G+WjI0PKQmA5z55D98m/Ijs+7RSC2AizAbo/3EiuNz8tBMuyYSBF
eMNP7oUSayFoFrxqQrfVbhdJVUchYLz31p5uPtJuh+WbQvD8lWYY3ZesYsOs
7gmBtFLAa7qp5Ux5NY+EYNfY3o90X3vwlSn6lRBYj8y10F01qqnK9FYIIhhn
+umWMo48dvk9YaELc3TX8Vu+3E0VAoORaH5pwptjJrZ3dAvBgke7Id3+6yfP
6o8Iwc+c1BN0d5zP90ubFoLFQQZLuoMVfOtvMgmDlJKhK919Af3zfZzCUJql
60P37pGDkkcEhaFF/dN9ukcy+B0kFYTh7oTjc7r38rmH3dssDLkf38TR/cL1
V+5fHWEIuej6ju6Dum+Yig2FwepeZy7dcS/YVRWPCsOC8+3PdC+uOh4L+U8Y
LhpQy+h+V6Lz0vKSMDDEqH6nmyT/oqzymjBUx5g10212f31Yw1MYChI1ftKd
OWTF+8xXGOw103/TzWb0ZTvtgTBIfmjpptsyXe2sXbgwXEpI7qc7lxzm9/2F
MHTcVB2mm8dlNnlHgjBw5ZmP0W3bbFYfmyoMD2t0J+gu3v55nu2jMIxtqZ6i
WyhKRvJaERGfc1yzdDuu3NvXVi4MsY1M83SXnx2xh2/CIMKQtUC3BNU47F2L
MBRaCy3R7SabncvbKQybXLWW6f7qL/LbY4CI71uOFbrlBr2ZuseF4ZpXzD8/
t/pyN2xdGDRSVv+Zp5OfEXhE4K+7zz9XReeXiAiLQA7333/9+Zlb+k5IioDp
H6V/xkSY9b4oiIBklsa/8Rebk0mxm0Wgx5xxke7s8KPUGzoicCsz4d/8nY7N
3TamiEDVQ4E5upV5opGigQg8Lz0xQ3dvLdDWDotApZrVv3i8ejBQ3HJKBNRe
7f0XL7P9wbfSz4jAq8nZf/GsK/2xdsZRBHgfNw7SHXjH57O2mwjgwbQ+uvdh
cj5cN0Wgo4yhh+78T06rhQ9FoBQ9+EW3q7tgUUSECOzW4m2jW0OnwPtytAjc
Lbz6bz8kZLKsbEwVgc6/hV//rbdTasH0BxF4rZ9SRbeo+nGvmgIRiHJyK6c7
5G3MkmeNCJyCV4V0e7zattg2LAJhO83/7VetMz/zMqdEIOn69gS6/4rddg9c
EoEfJrMv6baKrJnfwSEK+G3BCLqPBF+Ye6osCqSBBW+6Zb1Cp0/ZiUIub8sB
un/v0PmgflUU9lxi2ftvPefanZndRaHQUGo33dzOilPZ90VBSpdv87/1sfs8
wZ8kCn8PLJHp/mYyOlbfJwrDLDqN9POetmv18/G/onAdv1NNd5AUd2jjnCho
FXyi0n1gWGNrM6sYVKTMZdBdftPl+g9lMdB1iQuiuyhhae23oxi8a+ZGdKdO
sZFHZ8XA0yn5FT2/PXgkv5WFRRyWlOb20/Mn86uPFVIMknCIKp9Lz/fMdx2Z
YGYTuJudOky/T/ID6yKzVjZBsgxlL92OoZrKcsxSwBqhokt3S8zsYVYhKbgq
zC1Pd1Lezadft0tBavb6Cv1+OvA3WMXcSwo23Q5Jo9swrVXpE0kaLkm48NId
955taopZGjLz6lnpXv6gW6DKIQ0zD7et0e+/jE8vDsfwSQOZkXWEbpEvls63
ZaVBXuRPGd1D3QMFBvrSUO1h70F3kMjCkcYAaWggS/TT79OnVVW9pQ+l4dux
9A664z1feGaHSoOS+b5muvN/URKfPJOG31M+ZXQPxvqvmr6Vhl8ntr2mW1+Z
P/VXpTTc/cB5ge5jP3vhaw0xX05+c7pPB+W0FtVJw/1aueN0u4yZMb5qlYZ0
r8t6/8bLjDU/PyANZ7fGytK9rruZvZ9FBlSLg4fo9cCGkfWXLRwyoL6a3023
UHT9tkpuGRAsYf5Ft/qa67m3QjIg38xUR7duhsHcMzEZeBJT+K+e0D8n8jBQ
Uga8uqJL6D5dUpBrryADSa2dOXTbugQftlCRgTSVA5l0u8hZ9hzaLANulKEU
um81b/HYvVUGzgyVJdIddI+BR11HBipJXXF0P93elCCxUwZ4z+rF0B0/+GYn
N0UGYprGntGd9vzG9zWQgS+7BiPozj944OK4vgzMXtIJo7t8WWyl84AM3NHu
CKb7e+po2PfDMvDNtesB3e1nPitSj8lACvuhALoHuEOLMk/JgHma/D26p4vP
n4g3k4FDll5+dK9f1Rp6fEYGKiRM7v6LnwzzrbvnZYBvoNj3X/waWwRcbWTg
Rn7JP0v7vU22viQDu8Pt/rVX1/ZEpxxlwP5uwb/+dPsPtehfI+LJVfNvPP2n
Epd13GTgtGdyIN3H9o+TFD1kgLHb4d/8Ty/iT4VvykDdaenH/+Kb/Fid7Y4M
sDB2PP0XXwvr0gU/GRgfff+Sbt7Yka49gTIw3WiXRHdGrzPNN1gGbhU8/bce
h5WXJL+EyQDrJpsiuocd7+zhipQBbcularrvZ7GdPh4lA5mfbv2kW34+xPPp
S2I/XJUYpbt0l/DzX/EysPB5eZ3u87df5konyUBwxCGhf/utTL7lYooMPPYx
0qA7hj1tJiVDBg6b7zlE964j2/gnP8gAifmMPd0/Hhdo6uQR87UYfki3W6ve
Ua9CYj06FD/QzS9efQXHZeAdcv53njLPHQtmLpeBnHoVTvr5M37zI+VglQys
LWdidI8NWVaHfJWBH+Z27v/O5+aBwaZ6Ir5VeA7dyi5XWMVaiPUc1l+muyJ3
Vt7ypwx8d/A1oOcDqxXvfQm/ZWDrIu0Z3SRgshrqlgH+66em6X7lH3Rn84AM
iI5RTOj5Z081X6zLCDHeJd8Sutu5oz7njctAaUjvjn/17gnpjtVpGWi5hT7R
Lfzs7bLeggwwl0Ub0vNf9i8NsYAVGWhgYOym+5h07o6vNBmYm7j1gF7fjttQ
TPmYZSHF0USPXq+qjhtFRHPJQvtKVh89n1ZpNWV18cqCYdbGJnq+tXW3qFcQ
koVt0aut9HzMXNQ97iAmC4rb9Kbp+T+eZM+dKSkL09QGRVn6fW4wqTYnIwsW
Hs035Ah3PHA/tEtRFno2N/TJ0+87gfsB5RqyUJciq6BMOPc/7iSObbLw6pvL
mgrhUzFPyo13yBL1322aGv38dIn3RuyWhU7Ofg0NwqEKCQw/kSw4CRaGatLP
g4Oq9CZ9WbB2UVDcRrgmIwuzPiALJ13r5nUIs+pSvf8ek4Vque7Tewi/ubn/
hZaJLNx7ELOCCO8tqct3N5cFmmnJ2D7CXSymP4rOykIeD2X7AcI+h37PMVjJ
Au/3iT+HCW8MtRHcbysLBy1I08fp+aJpVCvYQRYCa5Kv/0d49szyVWFXWah4
0blkTTg83jfktLsssJ8b471MWHOAPT3OWxY8UrBKF8J1qmG1/bdl4bn5tJI3
/X66KjKi6i9L1LV5+v70/PDxFfu1QFlYNhpUDyH8blFBKSdYFpQ15KefE+71
1bZBkbKwcYO1VRZ9PwrzhFyLkoWQoedzxfT+Ugbz4l/KwsCpoKxvhLOwku7G
eFlI3ZPz/jfh+cYXnMxJsnDnvj7nBOHddm46OimyQLqM9TAwkODOypFzthlE
/J88OyVMeIM8Q3ZVriwUvRGI1id8NL+9Y6lAFu6mGRRbEn5y+COrGi4Lrrkl
4t6E27oeaZ4pk4X8vVJ9UYQlr9tZPPoiC+5DM0aFhK049PyLa2VhNoEz+A/h
pJcbMya+y0JMtl8PKyMRr8pvDCfaZKFY7lnvOcLXLd6q+XUQ8XozrhBOuGD8
jsnHLlmYl5HPqCK8ftfidn8f4SMXfjIxEfWbiHay8LAsbCq6wKlPODCVu2n/
X6I/g/qsB4S/osFVjylZ+GbjqNdC2PTSi2O/lmSB4z9F5TvMJIhedfXiWpeF
WI/w2C7CXWFH3lAY5aAbO7T3IAuRzxSU6pxY5cAvwK6kgLD9J9Ji7AY5EDbf
+FOHlciXR9plGnjkQLbG9XQh4enubCNGATkY7SySOcxGgpsb7GJtxOUg5dPa
2Qh2EpS8gupIKTnwaeWfMOIg9u+2jTOVcnJgiZ5sENxAgkNfZiQWleTAS6xr
aoxw6OlvhirqctCk2MjbxkmC5omkaxaacsDAuNLVykWcN/87Lx5qy8HGI68Z
R7lJ8Dpt2/jfPXJwc+KouQUvUS8At6iUnhwU/2z3/MRHnKeWAb1jBnJw8T6l
SEeABM721Mu+B+UgULvIt0GQOK9rUZEfjsgBo/bRo6HCJFh57Ir3HpcDi53X
mp1FSQCKR4YFTeVAelWE/eZGElQbkyjulnIQkKNIFpQivg96f9q+s5KDpyZK
De9kSHDCPTvsp60cRMiXSbrKk+AZ56OCDZeJeJ3RI7krEfkj1rZv91U5eGk9
8ztflQQy2sBzxVUOpmaEjCkaRH6qEtN95S4HnUmJBzi0SDA5+fUh6Y4csDlt
WQreRQKde0k5W/3l4PfPCzzHEImI250/VoFysJdm5uSsT3w/pZtzPAmWg6uB
YQELB4nsvHfbtoowOWAP+LN5+ChR/7VynZ1/IgeSZFGnI6bE96jDwH2lKDnY
fyC8WO0skX8jotofxMvBDZs/1tcdScDVItDgkigHc633N1i4kYBRJOTL6WQ5
yEAVluU3ifrZjL1YP10OwtnmjxXeI8HEi7sfN2fJwfsRwzGDUKJ+6FhNEc6R
gw6PGKPLUcT7b3KPp+XLwTNr7jCtN0R+fn05pIEqBxcS9qqWFRLz7+v3LyiX
A8NbJu4vqkjwUfG8d0KVHGzZ5+u6pZXIzymnLl2vl4Oaizc002aI+n6sztKy
mYiX5/aJWCYGCNE4aLK/TQ50XI6q2wsygNcHyl6xLjlAV67xheoywLXZPF3G
Pjlo2HDh9YwRA9hu19oyOigH/xnvRpTzDHCyQFHi84Qc5Ly5VhXwkAEOrcbx
J83IgfVrS6+g1wwAmDhH6IIchA0pV10vYAD1UvL8eRqxv409pEl/GUCWOWjs
IJM87GpmTo1iYwQxQ+ZeLTZ5UKrWGuCVYwTWmsXvzGR5cDgA1/3OMMKfhu7k
d5vk4QumoZHXxgitAmfiHsvKQ07qcJjfEiN8NWl96qUoD8oftIonNjJB/s8a
v8Ma8tCe17nH5xwThHdnn52kyEPIlj207eNMoD91j0/3rDxs0I7wtBRlgXe8
qp5fouXBsZ9c53COjcjX5ovMcfJwWGdY0dafDT4VPnDf+0YeBGbKGmbfsUGN
7fD1z2ny8IM//2nJJBuMFb1zyf4sD7Wto/K9XuzgFt42NVkiDyemBlWI4gXW
7NidNSrlofuYwXe5z+zAI3DpanId8X5k9RSfNXbYYq/kGPuHeP/ilz3eHhyQ
j/032tErD2wzhZ1cTzkABAMcNg7JQ8rVl4sK2RxwDB+4FDkpDzLMXL9mRjnA
RSjp4kMGBSgcyD0gZrYBckvkz7nLKcA77+0ekeKcgD071flRSQF6hn68VtPi
hC+O/men1RTAvUH41NkDnNAm0nf6irYCyL605oty5YSlKwlm1gYKcFf8e/CL
Ck64u6/pR9xBBbALMbmq85MTNogx/dd5RAGG3/VedB/jhI3lVibmpgpgbyqt
Pc/HBXs2yp44aqcAzRohnqzmXFA+cbwh+LICSD19IszgwAVHKnyP1VxVgAb+
iO/pXlxgea3b2MBDATI8d9TIRnPBnco4o90PFKBa4GzDqzYuKHORMlBKJfr/
WhEzYcgNq3MTYRLvFUDjZhOl5gQ3bPekdvBlK8AhSYVAZ0tuSLl9wW21QAF6
s9ddVK5zQ3hwQkJDjQKUOHSXmsRxw1ey20RlnQLo2rbiaSncxHeh/u6iRgW4
lafZ0fqRG7yi+huT2hWgXkXC7m0VN1glKTHeHFEAve44OeNxbohRWTziPK4A
+TrbHU4scENrWlWU7bQCZHfJ39xC4oFD2fZbjy8rQKIY84cbfDywlZp6XnGD
IsT+TeA20uIBUvsWvF5FEXaGCVU8vsIDu86SOCs3K4LtitMFRzcecOuqNy3c
qgjWT/vkVbx5YGjAeTxxpyJ42T7bYhTIA/Uz2ZLeBxWhKD1yGIvngQ3u/vbX
jijCX6HHfrpveUB/+VTOxeOKUME0slE0nQfySfOHj5krQkCS/FJQPg/Ecuve
VLBXBObkbTZGdTzQFsZetfGKIjSxz9bcaeIBfsGfArzOimDBGn47to0H7m/0
Sl32UIS9RtcuvOjhASelovbvgYqwtv+aS9gcD2B6sNPrnSKI6K/k1IqQQUrQ
Oux0miKg20uy6eJkIA3eG9yTqQhGNxKWfaTIUBpcG0nLU4TXR0pIE4pkMGwz
nfb/ogh92ApNSIcMSqmeB21rFYHH7reRly4Z2G/FxO3/rggqyaGi9bvJUCPX
Y7zhhyIcvaagcnwvGY5cvZIaOqBI1HHWde+NyaCxN4zReUQRtL+ZFSQdJwOP
ULb5iXFFiOrZshx2igz1BYtsQvOKsJ3j3GGwIMMpVn+bFyxKUPjoGA/vRTKc
eflCMlFeCRjf78995UEGyrXPbveVlSC/+bBHjxcZNu3rqrVTV4JPJ2MeSviQ
oWtIwUtVWwk8XFKM3HzJYKOd1fp+nxIM9nYk5T4ggwFb8+bH+5WAWVT5XNZD
Mii2z/u7GClBf9qfuIRHZBi6vWebzkklCGEcOn71MRkca7+EFlgpAXJ9cfTt
c+L9Xo0MRNsqwddXUlutXhDv58yN+TgowdD1iTShGDJMCp8cQy5KkLyPNm0b
SwY3q84DFb5KMCfmKJWbSAbvpVmG+jgl2O9eUymVRYbxc9+6WRKV4Gom46uQ
D2Swqkws2Z2sRHyXmNbPZ5PhQISp79ssJTB631OWnUsGwc35pNulSnA+/ptO
byEZAiLCuj5WKsGBSJ0t0p/JsLx0iTpSowS1S7ft/ysm4lEpdse0SQkeVp/h
zKGSIe28N21znxJ4aRePbakg9seXk3+sh5SgZPH0d71KMoRvVsejxpTAc3Ck
yPgLGTyWO26xzBHjiZzhtagm4vcEW+9gUQZSwIY13W9k6PzCsPZQSRl8rrKf
VW0mw3GN9o4SNWXoXeP+Pk+4/MmHooUtyuC2NTAYbyFDygXrm9a6yhAW+G6r
4Q8yuK+Ur+w6qAznH18lqbaTYeTCy1/XjiiDl5btu3bCllXXC5OOK4OwpolE
4C8y6EcqevNbKIPILHvCzw4y8G4JXB52UIb9WutfzP6QwS/yfLvUVWXICE+2
nyI8v6JbYOKqDPVcew4EdJGho2rYs8RbGdZar42ldJPhnZXR0vNgZRi8HSHX
1EsGvac8i/szlGFr4n+PswbJYJsS8EbngzLsLP0+Jj5EhqBi0nG5XGXIfq3n
7U+4eWA6ef2zMnxYOHz82DDRfseP0znflIFPgrm4aYRob3SMPaGBmB/b+yDN
UTK8P1f9MaxFGV7yalc8JLwYUMjt+FsZ1pOxV5Qxon1bLC77Vxn6N1+PCv1L
howxUUfeKWV4skwO6SLcRAoXXZ9VhhK9DQqa42SQUPF3/rmqDGKWrMdqCb/3
vCQXxqUC4SysWtMTxPw2bg1YU1OBzJuffrNOE+NppGwb3aICBsOcN/UJS+6T
62rbpgL9j4TJvoRtLwvt/LhbBWr5xBUW6O0Ll0YcjFTgKcvRRz9miPHqXZ6Z
HVWBI6H4Ee5ZIl59o/sMT6rAAa0ahb2Eg7g6Y2ROq4ALt7ZaMmHJs6XGbQ4q
cO0d/5TjHBn2Ou9eqXBSgZoz7M3RhG3vfXyb7aIC1wvejlYTzkxPIoV6Ef3d
v/xFbp5ovx70wSBIBWyyckLrCNvGnhTOTlYB9aMBTEyLRP/77xrNpavAOxo1
WYVw83jmnR0fVEDhfdaLo4T1MJ7RwgIVuHJRxD6KsMTvKry8VgXgbSiPwhIR
T/+FWdZ6Faj/InHBkHCQuqLqwWYVmI+WErEjvODt9+Rbhwo0Psr/lES4cSNm
3/pXBeIcveSklsnwoNTxleg00d5ooXM3YXCIbrKYV4F0axkBM8LpnxYpf9aJ
eD96MRFCONAsm3+IrAr7P84WzxOmPFUuWtqqCn6iD2MzV8gwS/lvavd2VTjK
obpcQTil/57irV2qECviP9lOWFSnN4xxnypIVmrlMa2SYbrp5UXOU6rgW1P7
6xjhZO+vL46YqcKN0jf7rAmfl1v5HnpGFfh5qKeuE/7mYrZL8KIqfIq/5fmc
8Ds+AbLkDVW4CEUL7YTPfdLTP+elCjeZBVtGCAtfuOYZf0sVSvVv2y0T9sv8
1qsQQMxvSDhLdI04n0cD8zWeq4Jz9Z+144QFH61dgAJVUP5hF5pP+GbPV+td
xarQspgVVka4b0fMRe1Sov1/jhfqCOf07LJXrlGFdYk6t17Cproe13jbVUHq
XoAn5zoZih/td9nQqQqmD+W5hQgr9gq7MfeowuYSixubCC88ynFfHFYFg8eO
XzUJP++dvtW1pAq5URujTxIm7Sy9076mCs9mrk+cJnwp5PHdZgY1mJMXl7Ih
vHOn5v0qDjUwTYjjdyPcHnLlUaaYGoidPG4RTlh811D0nZ1qkN8lPlJF2D80
76UXRQ06Zye2fyc81nc/1k1PDR5x/LBrIVwUqpBw6aAazC8kuHcTPtNvlXLM
XA1WIf70IuHyXVpph86qwY2s6y1rhNXDGDL0L6jBf8lD25loZFjbFZela68G
JdNXP3ATfhX2O1/aUw0427qeyRBmHUgr2OijBrMGthaKhJ123ywS9FWD3eg9
mxphNLCRyv5ADQ7lTMlpE+7abfZl8rkanP3JcMWAsOxgYws1X+1/HdZ7PFXZ
FwBwLqEbYvSQQQ+SOPeco4sotKY8fsrIqymTKZeSSioSkTK3vCWvUZNHD0oj
r4iI0kiGhhCNhCIVKSXPUvjtdf/8fs7n7L3XWnvvtcE7K+LMLmK9mNFX1yp0
Ia2Vo+RJDHoLhmLu60JW47eI/cQ7g5y5zrUkXt4RKx/i1LndZp/byPwh1fNP
Et+4JW7T1qELMrmBWkLiO84azndfknzpl68MJW7P8PCN7NOFfttcmWjiBUaD
WUsndCE26gc6mXh5l3yx9Ddd0L737Nl5Yn0hWzU4rQu8WQ3+KcSO9b6dZVIU
PMxQTLxEHOc6qeCwgIJlFlXm2cTcSOlAoQEFtwVJFeXEi+iV4Z7GFKiWXrp/
l1i7ZWOSrSkFrd03yiuJrdRi81QsyHdl93MPiE/fnNdb6ESBuGTRu0fEib8Y
Dp3fRkHIbInseuIr37ZOnXChIJ4X4PaY+G+LlIWbdlHwdMS+opl4un2pTa8v
BR17zRc+I5Y7ucG5zp+Cbiez1HZiVc3dHvlBFNhl/KbSQbzW+3pI0CkKumJi
OC+IAzhMsVIiBY5XXoT2Eg/rmKibF1JgSB/wHiROcle6daKEAkHMvBsfiQ1S
B6zL7lAwaJXa8wn/l/vTj35AAXuk1mQY98+nsXrlVgq25+/JG8f9o93g5viM
AmZS/u4E1leQ+eVMJwWvsvfUfCEWPnHQlHhDgZFvXN0ksUxxftDgGAVN844m
TRNnD4Ypak9S8Nx3R9AM8SatHVlu0xQUDHTSYmIKEHtOtqVNigc1B6O54sRK
gXt1qhbyQDppw3UOsfo6jfZkYx6YyAlCZxHf95/0bjblwWrZgWdoQUGzpOx6
HvhHVOpIEWcuDWF/38iDrYt86tArJbvC92/nQaJHw4g08SOTW2rXdvJg8NK5
NTLEXn7RRd3uPFDOGTiJzntr/HKLFw+WHLGSmk2sX5dsCME8KLH8g8Ml/k/c
uz7wdx7Yf3UzQ/uvsXArDuXBpeyPAeg7N0bO6MSS9YZsGUBDrN2beRd5sEFq
4t4c4k2O3KR398n/8Wv05YjTjYXjHdU8KFK9vB09tHhy2+NaHuQPGgrRyR/e
qRU18eDohql69KvQuqzj3TxwGbF1lic28PqJe/A1DzK6IwPREQ5lXoJ+HkS1
y6Wg6cV/6VkO8QCap9rRx0ojyueK0bDrVNfmucT16WLqHEkadjtV7EerhwaE
jErTsPPW9zB0tb2nRftcGr6fzClHK7y3aryymAaxLgV1BWL35kq9PzRoGK0w
N0CX3F6dFL6Chl/ffdyEdjm9wtmLocGooMAfnaUm3WuwjobjFbw69KTESQvt
DTRYJ27tRNsMjGepWNHAzZr9CT1c8tZrxpYGjUh5JUViM7ua8dodNFTZt2xB
xxuaOZe70WCu478b/Vq1pDzXg4YvVkVH0FHvroYkeNNwvvF7PPqpMJTrcoKG
jAROLVp775SXrZCGb5YXWtGBm/0aIYyG23+0daOXqO5OWh5Lxte3/oL25XSN
L0wg60sLkfiBuKbfyZmbTIP6E3d5tFexufqnNBoWtfA10JUpFSE9l2lobtTg
oX8Q6ve2XKXBNrfGEF1qq3m9NJcG3590rNES/RKrhHdpcMgM34fuF+ip1f1N
w4+mTT7oxx07ZBRqaNDj1gWizzeWvUh7TINbZ1MkOti6r+71Exqk81/Fod0e
zCvWbaNByT77HJq6fTC67CUNfumumWhFvbSjYq9p+GWhQzZ6PPuRwKqfhuLJ
6Xz0/fTlRk+HaJiVGncHfVXZUUN1jAYDu4BKdFRCiLz7Vxq8B5ZWo53COl4P
iTPwwrSyHm0sNrtptRQD20ZvNaHVAw3LT3AZEN481CqKd9T92kN5BqZ8R9pE
8R6Ij5dVYsBrjVkHuqHv3nHHhQz4SDi8QBcKPuy58CMDBQ1MD/r4FiszbU0G
XF1/fosWNB5ZeVCbgflaZ/vRltZX5pVQDJzpSx9A6z5onPnOMuCZEfwBrWA6
NbDBgAHrbdRH9FiJzn9Rxgy0SOZ8Qj9nt/3dbMrA9aypIVE9s0NzlNczsG/d
smF0pmbRuZ2WDBQ2qoygI9O7hdc2MjC7ql9kb2V570FbBiqlzoyiHRPWOus7
MrBls8wY2kh2r3nQVgY2/rxdZI5YtcpsVwacmGiR60fUPyd7MvDSaJnINw/Y
dHZ5MWCgXSIaL7nv2D+ahxl4P7Zc5CBBVuF+PwZOOfqI5nftaE0rPMZA0HCK
aL0WWziRX4PJ+KczPqN1GpkjIGTg7J1IUXxzrX/bGR7GwA3LzaL4R6uiNj6O
YkD7+eggut2k1GD+WQYitIJE+btX8maJSyLJX9crUX4jsmHiXQoDGULnPvQB
Te9X7CUGujT2vUE7pKc0+GcycEhuZy9aNWE8Y1YuAzMXJ0T1FZfVPGtzk4GV
Jqmd6Leh9oGJxQxwpVc8Rxccy7Fbeo/ka+5n0f4xF7hNmTQy4Gi4qw7dpPNq
5GALA742v9SgXUYFA1faGAhYwX+APhIuaJPpZsD7S16FqH65rjdbhxgYF6vI
E+U/OH+V4WwWMitizqJrBZ9yN89h4bTnjmh0rCWzcq8cC7LcpeFoFYX8xamK
LMQeDjyBXpWRJ8tRYaEgO8wL7V6X+7ZBh4XW95stRfnOGxT0USzMidj6E3oo
gdclxrBw9ImTiWg/u+S28PksaK7VW4VO+pRz/8+1LNzoPKqGrp6fc2G3DQvp
HoJhvI803bJtpw6wMFiudg79IG1NwfBBFmTYy6L7zq39kWL/YRZsri2JQV+0
e9/6xI+FbZLzfkerrKO2Xw9mIc+3cR9aQTVvj+MZFuwCbpqip57eDPkrh4Wf
Z+p68D7+z7qscMt7Fr7t79VCN2QE8tb56kHUXOPz2F9GiuxNlg3rgdmcf02w
X02W+hSHea+Ch+H7JWXxPLKWFsfHVsG3rJom7I9VvzF79/vyIYBZ1oD9Vt7d
szzNjw8xe1pq0b96XpZr8ueDWGhYNfqzj1Kh/nE+yB4aLkcviZiYnDrNhyKp
nmx0cGFlTFwyH9YYLopEG0nbFRSX8SF0xwdL9GnZSE5/OR+uvX62Ht2kWOWk
co8P0kb/mKH3qOp/PVHFhwjLvwzRyXrK6//3LzHnlBZ6ZHt3y/NOPjl/0aL3
gZlgkZbcSz68HU3koKM8HALW9fBhOih9Gt8Tyw5Xq2a+4cOustJxtF3Y9d0H
PvJB6rN4Hzo1uuf2xSE+fI5T7kX3x6lwnwzzYf179iX6ZEpMnuEEH35s9GhD
P7r0UGzvVz5kbDvdgl5wbdoh5Rsf4lMzGtFuN1ZfbZjiQ9+F6n9F75mCQxMz
M3zIdOz7B/1/9Z/hmQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$8534#1"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJxF2nk0VV0UAPBHEsIzNxjiTUQJpST3nkNIhUpRhkoSEUKaDIWUIQnRaCoq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       "]]},
     Annotation[#, "Charting`Private`Tag$8534#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\"yDesired  \\!\\(\\*StyleBox[\\\"yReal\\\",FontColor->RGBColor[1, 0, \
0]]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
    TagBox[
     GridBox[{{"\"controlArea= 1.80067\""}, {
       "\"\\!\\(\\*SubsuperscriptBox[\\(\[Integral]\\), \\(t1\\), \
\\(t2\\)]\\)u(t\\!\\(\\*SuperscriptBox[\\()\\), \\(2\\)]\\)\[DifferentialD]t= \
421.299\""}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
      "Column", 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"], 
    TraditionalForm],
  PlotRange->{{-5, 20}, {0., 4.0000723234369}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8473334696688795`*^9, 3.8780904269943013`*^9, 
  3.87871427588316*^9},ExpressionUUID->"f7c9ed03-6b1a-4eca-a08a-3df9f2501810"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"dery", ",", "deru"}], "}"}]], "Input",ExpressionUUID->"aff27fc0-\
ce8e-4e0c-b02b-a589b65d6f06"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"0.2`", " ", "u"}], "-", 
    RowBox[{"0.2`", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"2.`", " ", "kI"}], "-", 
    RowBox[{"0.2`", " ", "kp", " ", "u"}], "-", 
    RowBox[{"kI", " ", "y"}], "+", 
    RowBox[{"0.2`", " ", "kp", " ", "y"}], "+", 
    RowBox[{"5.`", " ", "kp", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", 
       RowBox[{"5.`", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}], "2"]}], "+", 
    RowBox[{"5.`", " ", "kp", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", 
       RowBox[{"5.`", " ", "t"}], "]"}], "2"]}], "+", 
    RowBox[{"1.`", " ", "kI", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"5.`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "10.`"}], "+", "t"}], ")"}]}], "]"}]}], "+", 
    RowBox[{"1.`", " ", "kI", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"5.`", " ", "t"}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473334698094354`*^9, 3.8780904272169423`*^9, 
  3.878714275999021*^9},ExpressionUUID->"ec2f384b-d573-42c9-bc21-\
7501355709d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[", "derivative", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"derivative", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tt_", ",", "state_"}], "}"}], ",", "params_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dery", ",", "deru", ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"y", "-", 
       RowBox[{"yDesired", "[", "t", "]"}]}], "]"}], ",", 
     SuperscriptBox["u", "2"]}], "}"}], "/.", 
   RowBox[{"Union", "[", 
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", "u", ",", "area", ",", "uSqr"}], "}"}], "\[Rule]", 
       "state"}], "]"}], ",", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kp", ",", "kI"}], "}"}], "\[Rule]", "params"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", "\[Rule]", "tt"}], "}"}]}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"derivative", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tsol", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.689420126677955*^9, 3.6894201381310797`*^9}, {
  3.689420203740455*^9, 3.6894204096935797`*^9}, {3.6894204448498297`*^9, 
  3.689420468802955*^9}, {3.6894205541935797`*^9, 3.689420571896705*^9}, {
  3.689420603677955*^9, 3.6894207452248297`*^9}, {3.68943545296875*^9, 
  3.689435576609375*^9}, {3.689435610765625*^9, 3.689435651515625*^9}, {
  3.68943572640625*^9, 3.68943580015625*^9}, {3.689435831984375*^9, 
  3.689435843609375*^9}},ExpressionUUID->"0535f73e-551b-4bf2-8a1d-\
609a1831c587"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "8.`", ",", "3.`", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.8473334698562994`*^9, 3.8780904272794313`*^9, 
  3.878714276068016*^9},ExpressionUUID->"f6291491-6c97-4144-a8c4-\
4df47d6b8a8c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "solRungeKutta", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solRungeKutta", "[", 
    RowBox[{"params", ":", 
     RowBox[{"{", 
      RowBox[{"kpp_", ",", "kII_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"derivace", ",", 
       RowBox[{"\[CapitalDelta]t", "=", 
        RowBox[{"0.05", "\[Tau]"}]}], ",", "RungeKuttaFixedStep", ",", "sol", 
       ",", "plot", ",", "y", ",", "u", ",", "area", ",", "uSqr", ",", 
       "endState"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"time_", ",", "state_"}], "}"}], "]"}], ":=", 
       RowBox[{"derivative", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"time", ",", "state"}], "}"}], ",", "params"}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RungeKuttaFixedStep", "[", 
        RowBox[{"{", 
         RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
       RowBox[{"Module", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"k1", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"k2", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", 
               FractionBox["\[CapitalDelta]t", "2"]}], ",", 
              RowBox[{"y", "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"k3", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", 
               FractionBox["\[CapitalDelta]t", "2"]}], ",", 
              RowBox[{"y", "+", 
               RowBox[{
                FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"k4", "=", 
           RowBox[{"derivace", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
              RowBox[{"y", "+", 
               RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
            RowBox[{"y", "+", 
             RowBox[{
              FractionBox["\[CapitalDelta]t", "6"], "*", 
              RowBox[{"(", 
               RowBox[{"k1", "+", 
                RowBox[{"2", "k2"}], "+", 
                RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sol", "=", 
       RowBox[{"NestWhileList", "[", 
        RowBox[{"RungeKuttaFixedStep", ",", 
         RowBox[{"{", 
          RowBox[{"tStart", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
           RowBox[{"2", "tsol"}]}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"endState", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"y", ",", "u", ",", "area", ",", "uSqr"}], "}"}], "=", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"sol", ",", "endState"}], "}"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{
    RowBox[{"solRungeKutta", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"kp", "/.", "solMin"}], ",", 
       RowBox[{"kI", "/.", "solMin"}]}], "}"}], "]"}], "//", "Timing"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<trvalo to \>\"", ",", 
    RowBox[{"pom", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\< s\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ypsilon", "=", 
   RowBox[{
    RowBox[{"pom", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "1"}], "]"}], "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", 
       RowBox[{"{", 
        RowBox[{"y_", ",", "u_", ",", "area_", ",", "uSqr_"}], "}"}]}], "}"}],
      "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "y"}], "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", "ypsilon", "]"}]}], "Input",
 CellChangeTimes->{{3.689420126677955*^9, 3.6894201381310797`*^9}, {
   3.689420203740455*^9, 3.6894204096935797`*^9}, {3.6894204448498297`*^9, 
   3.689420468802955*^9}, {3.6894205541935797`*^9, 3.689420571896705*^9}, {
   3.689420603677955*^9, 3.6894207452248297`*^9}, {3.68943545296875*^9, 
   3.689435576609375*^9}, {3.689435610765625*^9, 3.689435651515625*^9}, {
   3.68943572640625*^9, 3.68943580015625*^9}, {3.689435831984375*^9, 
   3.689435843609375*^9}, {3.689435879359375*^9, 3.6894358948125*^9}, {
   3.689435967609375*^9, 3.68943599940625*^9}, {3.689436029765625*^9, 
   3.68943639159375*^9}, {3.68943647171875*^9, 3.689436753375*^9}, 
   3.689437044203125*^9, {3.689439145375*^9, 3.68943921825*^9}, {
   3.689439267453125*^9, 3.68943932828125*^9}, 
   3.68943971696875*^9},ExpressionUUID->"c9fd4d05-355b-4f8e-80a9-\
5d7faa23a63e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"trvalo to \"\>", "\[InvisibleSpace]", "0.03125`", 
   "\[InvisibleSpace]", "\<\" s\"\>"}],
  SequenceForm["trvalo to ", 0.03125, " s"],
  Editable->False]], "Print",
 CellChangeTimes->{3.84733346996565*^9, 3.878090427379668*^9, 
  3.878714276183875*^9},ExpressionUUID->"515bba65-0ef9-48b8-963b-\
e7e28b51fc65"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdzwlMm2Ucx/FXYB00jJWj29gBlJX7aAtsBrutfwXGoki0KjhQKhiYzAmm
6SYIsjcyjri4SWDYOVkmDgUZ65DNzWXQF6wLQ7eh4WiVaSE67qOs9ODSmT7/
JvIkb5588s0vT15eVr4024GiqJzH33+37Xgx1P+O5xp7rLH7GnPW2I357c2M
Wu2wfI/NrszRmB2neqQqYjZTsdJdcP2PUWJn5oWyCJ0+1H+vzSxGqymPTfwm
ndiJ6XtJU3CUc4bYgbEI6kQ6l15iijnRNMvJP+K8z8ZldX3g1J0vlc8QW9Q1
5lTVqReLiY1qbvLMet3pa8RzavGYtP3Hw3PEY+pm+oOW1tVgic16dYVCw6tf
yiLuVbv09a/3YX8uwT+W+pVfmnr6PnbJaklteEb+OO4l8vO9srSPjMRjksuO
GSvmVCvxnGQ1U3+skLdMbJTwq2pycm+tEFskXZXKmnVNq8TLEllf8sA7on/w
fVCeFAiARjvAxbLBOksL2gk88lgzX3ejWZBd921XlhbtDO+pui/cHUaz4cDU
YFH1KNoV0m+EDO2ZRLvB/qJbiuZpNAf6C37xy5xFu4NVF9/cOIf2gK3vx4pb
DGhPKN/U210xj/YC3nnr4P5HaC48dJKMz9u9CbR9WlaVEb0ZGs/OiPkL6C2Q
1iM+ctlub9A1resVmtBboV2bLb5k9za4eVuayDOjt0PkuYTcT+zeASNXRqhF
u33gp6S/ZBkWtC9sLLx5r91uP3j9+8zTW6zEtB+klJXp89AUDx7kGTid9s4D
URqVyVnE7g+JB29cy0XT/pDOmhw5tIR9JyT9PXpM6ECBre+Ew0/GdDTsIqb4
EBTyfOs9wxOk84GJC0m7eJBFegA8Vbq5hBvHJj0Acph0xWqTK+mBQKmuumvd
3EgPhInx3W2HhoipIFAYfJN+lm4kPQhcrlf1cz8lpoKh8i0nWXUH9mAo0g8Y
P+zHHgIT3BSX6RHsIfCd433r7xPYQyGBbfKsn8UeCs7p8UM189jD4I2P2V8U
GLGHQb1SkdCxgD0cbi+kMF+ZsIeD9KT+eKoZewQ0iEy+D9F0BPjUV/NlFuyR
8Flb7OAdNB0Jr3mnHg+1YhdAvEbbWIqmBTBpvvvngL0LYdvYvu0Bi8QghK66
MCofTQthg+OupatoRgjJV/gyM5oSQWXiD2/vXsK9CKxTqlfkaFoERedefbYZ
zYjgROtz8mE0FQWJobXzXsu4j4KX685MJ6DpKOiMKyxVoJkoKOHU/HoBTUVD
8bvV5h77PhomTA0bHtn30aCXKyO9V3AfDRAxLd+LpmKgrXDWIENDDBQ/0HTS
j/0veGXbMg==
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5., 20.25}, {0, 3.998780740566586}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.847333470028144*^9, 3.878090427464282*^9, 
  3.8787142762684927`*^9},ExpressionUUID->"faed0cbe-19c3-4a77-8400-\
abcd342c48bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"weightOfArea", "=", "10"}], ";", "\[IndentingNewLine]", 
    RowBox[{"weightOfUSquareIntegral", "=", "1"}], ";"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", "forMinimumRunge", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"forMinimumRunge", "[", 
      RowBox[{"params", ":", 
       RowBox[{"{", 
        RowBox[{"kpp_", ",", "kII_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"solRungeKutta", "[", "params", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "0", ",", "weightOfArea", ",", "weightOfUSquareIntegral"}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"forMinimumRunge", "[", 
       RowBox[{"{", 
        RowBox[{"kp", ",", "kI"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"kp", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"kI", ",", "1"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"forMinimumRunge", "[", 
     RowBox[{"{", 
      RowBox[{"11", ",", "2.22"}], "}"}], "]"}], "//", "Timing"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.689436838421875*^9, 3.689436877703125*^9}, {
   3.689436912640625*^9, 3.689437010703125*^9}, {3.6894387485*^9, 
   3.689438780296875*^9}, {3.68943912746875*^9, 3.68943912959375*^9}, 
   3.68943944375*^9, {3.689473819375*^9, 3.68947381953125*^9}, {
   3.689473851265625*^9, 
   3.689473855328125*^9}},ExpressionUUID->"42d59a35-7931-4992-bd27-\
1f9b58ce9e6b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.03125`", ",", "536.7153362981406`"}], "}"}]], "Output",
 CellChangeTimes->{3.847333470106242*^9, 3.8780904275489264`*^9, 
  3.878714276368743*^9},ExpressionUUID->"92ae394c-06bd-4ce8-8a57-\
b19bdf1c691c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "grad", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", 
    RowBox[{"{", 
     RowBox[{"kp_", ",", "kI_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[CapitalDelta]kp", "=", "0.01"}], ",", 
       RowBox[{"\[CapitalDelta]kI", "=", "0.01"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "+", "\[CapitalDelta]kp"}], ",", "kI"}], "}"}], 
          "]"}], "-", 
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"kp", "-", "\[CapitalDelta]kp"}], ",", "kI"}], "}"}], 
          "]"}]}], 
        RowBox[{"2", "\[CapitalDelta]kp"}]], ",", 
       FractionBox[
        RowBox[{
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{"kp", ",", 
            RowBox[{"kI", "+", "\[CapitalDelta]kI"}]}], "}"}], "]"}], "-", 
         RowBox[{"forMinimumRunge", "[", 
          RowBox[{"{", 
           RowBox[{"kp", ",", 
            RowBox[{"kI", "-", "\[CapitalDelta]kI"}]}], "}"}], "]"}]}], 
        RowBox[{"2", "\[CapitalDelta]kI"}]]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"grad", "[", 
   RowBox[{"tryPoint", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kp", ",", "kI"}], "}"}], "/.", "solMin"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.689473924578125*^9, 3.689474135125*^9}, {
  3.6894741810625*^9, 3.689474257078125*^9}, {3.689474540453125*^9, 
  3.6894745443125*^9}, {3.68947457775*^9, 3.68947458840625*^9}, {
  3.68947468078125*^9, 
  3.6894746834375*^9}},ExpressionUUID->"3ad564fd-36c6-4ada-acf4-5f5ed7a5f752"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.125`", ",", 
   RowBox[{"{", 
    RowBox[{"6.912997074437044`", ",", 
     RowBox[{"-", "33.48788306944357`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473334702781086`*^9, 3.8780904278184376`*^9, 
  3.878714276569215*^9},ExpressionUUID->"a4506b42-9d8d-4e1d-8600-\
524ae7b34d9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"stepGrad", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"point", ":", 
       RowBox[{"{", 
        RowBox[{"kp_", ",", "kI_"}], "}"}]}], ",", "absgr_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"normgrad", ",", "gr", ",", "absgrad", ",", 
       RowBox[{"\[CapitalDelta]", "=", "0.05"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"gr", "=", 
       RowBox[{"grad", "[", 
        RowBox[{"{", 
         RowBox[{"kp", ",", "kI"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"normgrad", "=", 
       FractionBox["gr", 
        RowBox[{"absgrad", "=", 
         SqrtBox[
          RowBox[{"gr", ".", "gr"}]]}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"point", "-", 
         RowBox[{"\[CapitalDelta]", "*", "normgrad", "*", 
          RowBox[{"Tanh", "[", "absgrad", "]"}]}]}], ",", "absgrad"}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"stepGrad", "[", 
  RowBox[{"{", 
   RowBox[{"tryPoint", ",", "10"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.68947427340625*^9, 3.6894742968125*^9}, 
   3.689474369390625*^9, {3.6894744223125*^9, 3.689474535125*^9}, 
   3.689474726640625*^9, {3.6894747669375*^9, 3.68947496025*^9}, 
   3.689475024859375*^9, 3.689475092359375*^9, 
   3.689475294671875*^9},ExpressionUUID->"867e563c-b388-40f0-8a4b-\
024dc2f4274d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11.092955281866281`", ",", "2.271808164844108`"}], "}"}], ",", 
   "34.19397375304457`"}], "}"}]], "Output",
 CellChangeTimes->{3.8473334704499435`*^9, 3.8780904280124707`*^9, 
  3.8787142767697015`*^9},ExpressionUUID->"c397458a-1ab9-4d1a-8699-\
f4f5afc67338"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aux", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"stepGrad", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6.12", ",", "1.287"}], "}"}], ",", "15.79"}], "}"}], ",", 
    "20"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.68947497678125*^9, 3.68947500275*^9}, {
   3.68947505971875*^9, 3.6894750671875*^9}, {3.68947510696875*^9, 
   3.689475118046875*^9}, 3.6894752120625*^9, 3.689475276796875*^9, {
   3.689475343421875*^9, 
   3.68947537278125*^9}},ExpressionUUID->"54901a3a-9072-4111-a9d5-\
7a85b1d360d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.12`", ",", "1.287`"}], "}"}], ",", "15.79`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.169135703515686`", ",", "1.2962564917770296`"}], "}"}], ",", 
     "15.445458431163486`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.218230092516288`", ",", "1.3057296627697241`"}], "}"}], ",", 
     "15.09605992262083`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.267377930884119`", ",", "1.3149215060978123`"}], "}"}], ",", 
     "14.763201819488389`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.316417588397392`", ",", "1.3246740437664384`"}], "}"}], ",", 
     "14.421846382813268`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.365624859589441`", ",", "1.3335422150450376`"}], "}"}], ",", 
     "14.113252300414961`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.414513069226411`", ",", "1.3440275838263804`"}], "}"}], ",", 
     "13.7696795756429`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.463943587701128`", ",", "1.3515524654401916`"}], "}"}], ",", 
     "13.501174628441786`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.512127375992832`", ",", "1.3649062119490503`"}], "}"}], ",", 
     "13.15566877631112`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.562115271983842`", ",", "1.3660063275482992`"}], "}"}], ",", 
     "12.917759725711814`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.603307009662257`", ",", "1.3943478297494964`"}], "}"}], ",", 
     "13.71668489014448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.64759905271397`", ",", "1.3711483702233591`"}], "}"}], ",", 
     "15.48029944304879`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.662499993475496`", ",", "1.4188763700182538`"}], "}"}], ",", 
     "26.07563823121216`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.699517548669959`", ",", "1.3852653508812975`"}], "}"}], ",", 
     "19.567226423116043`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.721716927334864`", ",", "1.4300669980261536`"}], "}"}], ",", 
     "19.53446594281989`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.75845438146246`", ",", "1.3961500485138119`"}], "}"}], ",", 
     "19.204076683325926`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.778078837837647`", ",", "1.4421378807303709`"}], "}"}], ",", 
     "20.661822271717952`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.814044742456268`", ",", "1.4074038382797103`"}], "}"}], ",", 
     "19.372789676591328`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.833421992495384`", ",", "1.4534963775992311`"}], "}"}], ",", 
     "20.291178134020385`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.868753254639908`", ",", "1.4181169780102765`"}], "}"}], ",", 
     "19.487251969900623`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6.886989489978429`", ",", "1.4646727480144133`"}], "}"}], ",", 
     "20.600258376545465`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847333473214884*^9, 3.878090430541312*^9, 
  3.8787142794313164`*^9},ExpressionUUID->"a3b59b35-4009-40e1-9fb0-\
eefacf5ef59e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"kpg", ",", "kpI"}], "}"}], "=", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"aux", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "<", 
       RowBox[{"#2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.689475411703125*^9, 
  3.68947547071875*^9}},ExpressionUUID->"3aac318f-868e-4053-8558-\
de20fe8455c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.562115271983842`", ",", "1.3660063275482992`"}], "}"}]], "Output",
 CellChangeTimes->{3.8473334732774024`*^9, 3.878090430704113*^9, 
  3.8787142795315185`*^9},ExpressionUUID->"95ffd27f-9f70-4ba1-a446-\
eea659cef683"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"giveGraf", "[", 
  RowBox[{"kpg", ",", "kpI"}], "]"}]], "Input",
 CellChangeTimes->{{3.689475495578125*^9, 
  3.689475500265625*^9}},ExpressionUUID->"0daa2122-6712-4872-8751-\
3e8c178c2f40"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJws13c8Ve8fAPBrb9cme2+uGdE951Oh0jchLUpISCiSzMrIiCRUJGlKQkZk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       "]]},
     Annotation[#, "Charting`Private`Tag$17877#1"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Large], Opacity[1.], LineBox[CompressedData["
1:eJxF2nk0VV0UAPBHEsIzNxjiTUQJpST3nkNIhUpRhkoSEUKaDIWUIQnRaCoq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       "]]},
     Annotation[#, "Charting`Private`Tag$17877#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\"yDesired  \\!\\(\\*StyleBox[\\\"yReal\\\",FontColor->RGBColor[1, 0, \
0]]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
    TagBox[
     GridBox[{{"\"controlArea= 3.01488\""}, {
       "\"\\!\\(\\*SubsuperscriptBox[\\(\[Integral]\\), \\(t1\\), \
\\(t2\\)]\\)u(t\\!\\(\\*SuperscriptBox[\\()\\), \\(2\\)]\\)\[DifferentialD]t= \
369.01\""}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
      "Column", 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"], 
    TraditionalForm],
  PlotRange->{{-5, 20}, {0., 4.004845123604062}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8473334733710976`*^9, 3.878090430857725*^9, 
  3.8787142796473765`*^9},ExpressionUUID->"d4d4dc57-40bd-4842-a48b-\
33d3695c43ba"]
}, Open  ]]
},
WindowSize->{1146, 630},
WindowMargins->{{4, Automatic}, {Automatic, 3}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.4000000953674316`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 387, 10, 97, "Input",ExpressionUUID->"d2e69146-abcb-44b5-a67e-b27e1e90746d"],
Cell[CellGroupData[{
Cell[970, 34, 3182, 97, 212, "Input",ExpressionUUID->"a8c765eb-1c48-47b7-be34-7ea5c0e86c0f"],
Cell[4155, 133, 199, 3, 32, "Print",ExpressionUUID->"101e49f3-f78b-424b-b38d-09044b5830e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4391, 141, 6324, 168, 796, "Input",ExpressionUUID->"f29a97f3-2619-466b-9518-ace3faf9c648"],
Cell[10718, 311, 19537, 340, 328, "Output",ExpressionUUID->"ec237a35-3927-4543-8cb8-0a45ce06cd57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30292, 656, 4303, 109, 545, "Input",ExpressionUUID->"8032df97-fd0e-4f0e-8a4d-d7219bc57479"],
Cell[34598, 767, 3901, 81, 341, "Output",ExpressionUUID->"222d25db-725e-42f0-bca6-9314f0fb6e26"]
}, Open  ]],
Cell[38514, 851, 2273, 67, 349, "Input",ExpressionUUID->"2e86c788-5558-4b42-961c-1f71d77bccb9"],
Cell[CellGroupData[{
Cell[40812, 922, 3778, 103, 325, "Input",ExpressionUUID->"0406145b-d2cf-4d84-9373-fb6f2d86b2dd"],
Cell[44593, 1027, 1383, 41, 82, "Output",ExpressionUUID->"320b7f8b-c7e1-47a9-a691-0c617d765d1b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46013, 1073, 1122, 37, 69, "Input",ExpressionUUID->"b0d06a8f-d7ab-430a-b8f3-b69e9a5f2ca8"],
Cell[47138, 1112, 1592, 46, 82, "Output",ExpressionUUID->"62a08632-2976-44e3-b44e-bf2b5dfbd439"],
Cell[48733, 1160, 1152, 33, 82, "Output",ExpressionUUID->"b9a1ebfe-4c1c-485f-b697-a0a7ed3684d8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49922, 1198, 3350, 88, 387, "Input",ExpressionUUID->"09dd9d21-e42e-46d0-90fc-9dae8c382f5e"],
Cell[53275, 1288, 48933, 824, 344, "Output",ExpressionUUID->"aa58c6f1-931e-410d-a976-13f4b3882cf0"]
}, Open  ]],
Cell[102223, 2115, 5011, 126, 598, "Input",ExpressionUUID->"b0c0a66d-7c9f-40e8-9a77-c1743cdd2b65"],
Cell[CellGroupData[{
Cell[107259, 2245, 1638, 44, 209, "Input",ExpressionUUID->"1917570c-c62e-432f-bdba-435930b41d22"],
Cell[108900, 2291, 323, 7, 46, "Output",ExpressionUUID->"792bad0e-3481-459a-976a-7d5b990e693c"],
Cell[109226, 2300, 46381, 784, 395, "Output",ExpressionUUID->"f7c9ed03-6b1a-4eca-a08a-3df9f2501810"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155644, 3089, 135, 3, 40, "Input",ExpressionUUID->"aff27fc0-ce8e-4e0c-b02b-a589b65d6f06"],
Cell[155782, 3094, 1154, 33, 82, "Output",ExpressionUUID->"ec2f384b-d573-42c9-bc21-7501355709d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[156973, 3132, 1704, 43, 184, "Input",ExpressionUUID->"0535f73e-551b-4bf2-8a1d-609a1831c587"],
Cell[158680, 3177, 249, 5, 46, "Output",ExpressionUUID->"f6291491-6c97-4144-a8c4-4df47d6b8a8c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158966, 3187, 5792, 149, 699, "Input",ExpressionUUID->"c9fd4d05-355b-4f8e-80a9-5d7faa23a63e"],
Cell[164761, 3338, 359, 8, 32, "Print",ExpressionUUID->"515bba65-0ef9-48b8-963b-e7e28b51fc65"],
Cell[165123, 3348, 2648, 59, 350, "Output",ExpressionUUID->"faed0cbe-19c3-4a77-8400-abcd342c48bc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167808, 3412, 1776, 48, 237, "Input",ExpressionUUID->"42d59a35-7931-4992-bd27-1f9b58ce9e6b"],
Cell[169587, 3462, 245, 5, 46, "Output",ExpressionUUID->"92ae394c-06bd-4ce8-8a57-b19bdf1c691c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169869, 3472, 1904, 53, 228, "Input",ExpressionUUID->"3ad564fd-36c6-4ada-acf4-5f5ed7a5f752"],
Cell[171776, 3527, 332, 8, 46, "Output",ExpressionUUID->"a4506b42-9d8d-4e1d-8600-524ae7b34d9f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172145, 3540, 1514, 41, 238, "Input",ExpressionUUID->"867e563c-b388-40f0-8a4b-024dc2f4274d"],
Cell[173662, 3583, 330, 8, 46, "Output",ExpressionUUID->"c397458a-1ab9-4d1a-8699-f4f5afc67338"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174029, 3596, 559, 14, 40, "Input",ExpressionUUID->"54901a3a-9072-4111-a9d5-7a85b1d360d0"],
Cell[174591, 3612, 3737, 109, 215, "Output",ExpressionUUID->"a3b59b35-4009-40e1-9fb0-eefacf5ef59e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178365, 3726, 535, 17, 40, "Input",ExpressionUUID->"3aac318f-868e-4053-8558-de20fe8455c8"],
Cell[178903, 3745, 258, 5, 46, "Output",ExpressionUUID->"95ffd27f-9f70-4ba1-a446-eea659cef683"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179198, 3755, 214, 5, 40, "Input",ExpressionUUID->"0daa2122-6712-4872-8751-3e8c178c2f40"],
Cell[179415, 3762, 43239, 733, 395, "Output",ExpressionUUID->"d4d4dc57-40bd-4842-a48b-33d3695c43ba"]
}, Open  ]]
}
]
*)

