(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    203123,       4774]
NotebookOptionsPosition[    199758,       4713]
NotebookOutlinePosition[    200240,       4731]
CellTagsIndexPosition[    200197,       4728]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"3c543de1-32e7-4f15-b223-40e0b1159f85"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", "*", "3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 3.689476074453125*^9}, {
   3.690042085125*^9, 3.69004208646875*^9}, {3.6900439293125*^9, 
   3.690043938546875*^9}, 3.69008213334375*^9, 
   3.690082312671875*^9},ExpressionUUID->"94102320-72ac-4766-85ce-\
942075ccdc51"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a = \"\>", "\[InvisibleSpace]", "1.2648809523809523`*^-6", 
   "\[InvisibleSpace]", "\<\"  \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a = ", 1.2648809523809523`*^-6, 
   "  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.847938769589344*^9, 
  3.8787146378049974`*^9},ExpressionUUID->"cac4b8f4-4b20-40d0-bf38-\
98b5bd85c7eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]x = \"\>", "\[InvisibleSpace]", "0.05`", 
   "\[InvisibleSpace]", "\<\"  m\"\>"}],
  SequenceForm["\[CapitalDelta]x = ", 0.05, "  m"],
  Editable->False]], "Print",
 CellChangeTimes->{3.847938769589344*^9, 
  3.8787146378115025`*^9},ExpressionUUID->"8578a546-1ddc-419a-ae89-\
a648385e93c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]tmax = \"\>", "\[InvisibleSpace]", 
   "988.2352941176473`", "\[InvisibleSpace]", "\<\"  s\"\>"}],
  SequenceForm["\[CapitalDelta]tmax = ", 988.2352941176473, "  s"],
  Editable->False]], "Print",
 CellChangeTimes->{3.847938769589344*^9, 
  3.878714637827129*^9},ExpressionUUID->"82825033-946e-41f4-a43b-\
112cf50c7c6d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]el", "[", "T_", "]"}], ":=", 
   RowBox[{"1.5", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "150"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Skolma", "=", 
   RowBox[{"Pi", "*", 
    SuperscriptBox["R", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obvod", "=", 
   RowBox[{"2", "*", "Pi", "*", "R"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "5.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV1", "[", "T_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["proud", "Skolma"], ")"}], "2"], "*", 
    RowBox[{"\[Rho]el", "[", "T", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV2", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox["obvod", "Skolma"], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}], "+", 
      RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", "+", "273."}], ")"}], "4"], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"To", "+", "273."}], ")"}], "4"]}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qv", "[", "T_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"QV1", "[", "T", "]"}], "-", 
     RowBox[{"QV2", "[", "T", "]"}]}], 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"qv", "[", "Tustalene", "]"}], "\[Equal]", "0"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690041981890625*^9, 3.69004201409375*^9}, {
   3.690042057671875*^9, 3.690042449171875*^9}, {3.6900425315625*^9, 
   3.69004260603125*^9}, {3.6900436025625*^9, 3.690043624921875*^9}, {
   3.690082154875*^9, 3.690082166859375*^9}, {3.6900822255625*^9, 
   3.69008225271875*^9}, 3.690082706984375*^9, 
   3.69008293615625*^9},ExpressionUUID->"a6995c93-cf85-433e-8af6-\
40006e960d00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"Tustalene", "\[Rule]", "330.87181344808187`"}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8479387696986933`*^9, 
  3.8787146378739924`*^9},ExpressionUUID->"f01966d9-51f0-448e-b2cf-\
a9fc8b764afb"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "\[Alpha]1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], ":=", "To1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], ":=", "Ton"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042772671875*^9}, {3.690043833125*^9, 
   3.690043840921875*^9}, {3.690082173234375*^9, 3.690082209984375*^9}, 
   3.690082289390625*^9, 3.69008241721875*^9, 3.69008247815625*^9, 
   3.690082961578125*^9},ExpressionUUID->"57823c0d-70b6-4bcd-9fff-\
4a355a24bcd3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "krok", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Tpom", ",", "odQV"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"odQV", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]t", "*", 
          RowBox[{"qv", "[", "#", "]"}]}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"list", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Tpom", "=", 
       RowBox[{
        RowBox[{"1", "*", "odQV"}], "+", 
        RowBox[{"ListConvolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Fo", ",", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}],
          "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{"Tpom", ",", 
          RowBox[{"fTn", "[", 
           RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"krok", "[", "Tpolepoc", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.690042942125*^9}, {3.690043200828125*^9, 3.690043297484375*^9}, {
   3.690043448078125*^9, 3.690043451015625*^9}, {3.69004370228125*^9, 
   3.690043703796875*^9}, {3.690043903703125*^9, 3.690043904125*^9}, {
   3.690082271046875*^9, 3.690082276484375*^9}, {3.69008274721875*^9, 
   3.69008287409375*^9}, {3.690082914625*^9, 
   3.6900829280625*^9}},ExpressionUUID->"c502a010-7279-4a65-96d9-\
aedda76f1a67"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"10", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxT", "=", 
   RowBox[{
    RowBox[{"Last", "[", "teppole", "]"}], "//", "Max"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.690043497046875*^9}, {3.690043647546875*^9, 3.690043650421875*^9}, {
   3.690043768484375*^9, 3.69004379325*^9}, 3.69004389503125*^9, {
   3.6900823911875*^9, 3.690082391453125*^9}, 3.69008250709375*^9, 
   3.690082973640625*^9},ExpressionUUID->"2172b13a-cc6f-4da0-8dec-\
5926a7f6577f"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plotik", "[", 
     RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"nel", "=", 
         RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i", 
        ",", "tpopis"}], "}"}], ",", 
      RowBox[{
       RowBox[{"listpom", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
            RowBox[{"list", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"listpom", ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
         ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"maxT", "+", "10"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{"tpopis", "=", 
           RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
          RowBox[{"PlotLabel", "->", 
           RowBox[{"\"\<t=\>\"", "<>", 
            RowBox[{"ToString", "[", "tpopis", "]"}], "<>", 
            "\"\< s\>\""}]}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.6900434928125*^9}, {3.69004366353125*^9, 3.6900436775*^9}, {
   3.690043744765625*^9, 3.6900437659375*^9}, {3.690043801109375*^9, 
   3.690043802625*^9}},ExpressionUUID->"7ec2568d-bc6c-43b9-874d-454e873b6d3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"plots", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"plotik", "[", 
      RowBox[{
       RowBox[{"teppole", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"i", "-", "1"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 3.689476362265625*^9}, {
   3.690043683015625*^9, 3.69004369415625*^9}, 3.690043805375*^9, 
   3.690044085796875*^9, {3.690047003421875*^9, 3.690047010078125*^9}, 
   3.69008234125*^9, 3.690082997296875*^9, 
   3.847938796379936*^9},ExpressionUUID->"2d5dea7a-b719-48e6-a6ae-\
e1e5bb33cfbb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9qj8nXC+iTEIHEaTPwnnQ+gLaOov
w/npaSBwDU3/TTj/7BkQuINm3gM09Q/RzH+Mpv8Jmn3P0Mx7gWbeSzTzXqOZ
9wbNvHdo5n1AU/8BzfyPaPo/odn3Gc28L2jmfUEz7yuaed/QzPsO5wMA1TB3
9w==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=0 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9kH3U3wSYhyg/J1wvokxCBxGkz8J
50PMuYCm/jKcn54GAtfQ9N+E88+eAYE7aOY9QFP/EM38x2j6n6DZ9wzNvBdo
5r1EM+81mnlv0Mx7h2beBzT1H9DM/4im/xOafZ/RzPuCZt4XNPO+opn3Dc28
7/aw+AQAAibCcw==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9jWrGdbq3HKB8nfalxz6lyVb5uZg
YgwCh+F8iPxJOB9izgU09Zfh/PQ0ELiGpv8mnH/2DAjcQTPvAZr6h2jmP0bT
/wTNvmdo5r1AM+8lmnmv0cx7g2beOzTzPqCp/4Bm/kc0/Z/Q7PuMZt4XNPO+
oJn3Fc28b/D4gpj33R4WnwAHv9KZ
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=1000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9qeSbpU65XlA+Tvtj+xpyd793NvB
xBgEDtt/3cVU/tHfByp/Es6HmHMBzoeovwznp6eBwDU0/Tfh/LNnQOAOmnkP
0NQ/RDP/MZr+J2j2PUMz7wWaeS/RzHuNZt4bNPPeoZn3AU39BzTzP6Lp/4Rm
32c0876gmfcFzbyv8PiAmPcNHl8Q877bw+ITAJdS2sU=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=1500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9u9Obl30Mtcbyt9pz5DUEvQhIcDB
xBgEDttrhk7u4HsZAJU/aV+yTPivzbcAB4g5F+B8iPrLcH56Gghcg/Mh+m/C
+WfPgMAdNPMeoKl/iGb+YzT9T9Dse4Zm3gs0816imfcazbw3aOa9QzPvA5r6
D2jmf0TT/wnNvs9o5n1BM+8LWnh/hccHxLxv8PiCmPfdHhafAKth190=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=2000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9rJxr8X+MvtB+Tvtj0bxHrjSG+Rg
YgwCh+1firJPiasOhsqftL9ac/nxscXBDhBzLtjL/P/WLbM8GKr+MpyfngYC
1+B8iP6bcP7ZMyBwB86HmPcATf1DNPMfo+l/gmbfMzTzXqCZ9xLNvNdo5r1B
M+8dmnkf0NR/QDP/I5r+T2j2fUYz7ws8PCHmfUEL76/w+ICY981eDhpfEPO+
28PiEwD5x9gS
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=2500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9jkeG6IfqARA+TvtVxtOrC1pCXEw
MQaBw/YHDtdy/7wfCpU/ae84PXGLuX6YA8ScC/bn1J4lfrYKg6q/bP/sQFjY
aeswh/Q0ELgG50P034Tzz54BgTtwPsS8B2jqH8L5EPMfo+l/gmbfMzTzXqCZ
9xLNvNdo5r1BM+8dmnkf0NR/QDP/I5r+T2j2fYaHF8S8L/DwhJj3BS28v8Lj
A2LeN3h8Qcz7bg+LTwB2NNZT
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=3000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9rcSOCZeVQ+E8nfavzzOG3DEJ8zB
xBgEDttPur6lrEkyAip/0r5DWHGhz4wIB4g5F+zfpCtEPNgYAVV/2f7+0RN8
VlsjHNLTQOCa/aG0vA0FW2H6b8L5Z8+AwB04H2LeAzT1D+F8iPmP0fQ/gfMh
9j1DM+8Fmnkv0cx7jWbeGzTz3qGZ9wFN/Qc08z+i6f8EDw+IfZ/h4QUx74t9
JzQ8IeZ9sZ+IEt5f4fEBMe8bPL4g5n23h8UnAMlC1sU=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=3500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9g/zon3mCARB+Tvt5whVxcu/DXcw
MQaBw/ZzV37eK68dBZU/aX9+tlTErPtRDhBzLtgvj7+UJssTDVV/2f7jJWkv
DZFoh/Q0ELhm3/yxmU1KNBqq/6b9Q5HeG+pA/tkzIHAHzoeY9wDOh6h/COdD
zH+Mpv8JnA+x7xmaeS/QzHuJZt5rNPPeoJn3Ds28D2jqP6CZ/xHuX4j+T/Yf
oOEBse8zPLwg5n2BhyfEvC9o4f0VHh8Q877ZP4LGF8S87/aw+AQAM4HF0w==

        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=4000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9tllHmFZj4Og/J32oZXTG5dlRTqY
GIPAYfsN7P9v/BOPgcqftN+vubXRji3WAWLOBXsW+9RnUl6xUPWX7U2ivVfZ
R8Y6pKeBwDX7t/+Ne3ZGx0L137Q/abji2x8g/+wZELhjL6iwqZQhBmbeAzgf
ov4hnA8x/zGcD9H/BM6H2PcMzbwXaOa9RDPvNZp5b9DMe4dm3gc09R/sT0H9
AzH/I9y/EP2f7I2h4QGx77M9KzS8IOZ9gYcnxLwv9utRwvurfRg0PiDmfbPP
gcYXxLzv9rD4BABn3b/L
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=4500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9p2mmdoli4Oh/J32V0w2aHSfjHIw
MQaBw/Z1eT1/VR7HQuVP2meJ8j1ZwhvvADHngv2cRSlv6nLioeov23v7Ptir
1hrvkJ4GAtfs12S/PqDdFQ/Vf9N+30vm7tdA/tkzIHDHvuVQn96/Lph5D+xd
dX8L/IerfwjnQ8x/DOdD9D+B8yH2PYPzIea9QDPvJZp5r9HMe4Nm3js08z7A
3QtR/8F+P9Q/EPM/wv0L0f/J3gsaHhD7PsPDC2LeF3h4Qsz7Yl+PEt5f4fEB
Me+bfRc0viDmfbeHxScAaAXTPw==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=5000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9s8FFivZBodA+TvtD2UnPHfjjXEw
MQaBw/acaUKyMf3xUPmT9pz/N/xcX53gADHngn1k77NC3l0JUPWX7ZOi5qS4
nklwSE8DgWv2If/8NeZfSIDqv2n/zbW3Mf9igsPZMyBwx95w8UTJnosw8x7Y
l3tmrui7CFP/0L5OgvcoiA8x/zGcD9H/BM6H2PcMzoeY9wLOh5j3Es2812jm
vUEz7x3cPRDzPsDdC1H/Ae4fiPkf4f6F6P8EDw+IfZ/h4QUx7ws8PCHmfUEL
76/2h6HxATHvGzy+IOZ9t4fFJwCdw80G
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=5500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ny8h06e/BIC5e+0PzrLx+CIRayD
iTEIHLavOtntOb0/ASp/0v6VU93F9qREB4g5F+z3pH5a9X5DIlT9ZfurjMtX
CJ5KdEhPA4Fr9gLc3S9uXUiE6r9pf0/I3S/qUqLD2TMgcMd+mvT9uXMuwcx7
YM9+YyHn0ksw9Q/tb71w2QPiQ8x/bH9gXfPhpXD9T+B8iH3P4HyIeS/gfIh5
L+F8iHmv0cx7Y38bah/EvHdw90DM+wB3L0T9B7h/IOZ/hPsXov8TPDwg9n2G
hxfEvC/w8ISY9wUtvL/C4wNi3jd7fmh8Qcz7bg+LTwDtqt+r
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=6000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9vyzMtgOdoZC+TvtT9mfL6rxi3Mw
MQaBw/aX/ktOKPFKhMqftE960/VMwybJAWLOBfusr9eKM2YnQdVftl+wZjpn
5J4kh/Q0ELhmf7p71l2NY0lQ/Tftp33cdnPeiSSHs2dA4I79nEPrWBROwsx7
YO+6Sv6kyUmY+of2C9472pqfhJn/2N7CYXcuiA/R/8T+dtmEfBAfYt8zOB9i
3gs4H2LeSzgfYt5re0sU897YL4TaBzHvHdw9EPM+wN0LUf8B7h+I+R/h/oXo
/wQPD4h9n+HhBTHvCzw8IeZ9QQvvr/anofEBMe+bvQA0viDmfbeHxScAfULW
dw==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=6500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9n/eSmxvEg6D8nfadx3dvLAvIN7B
xBgEDttXCjHs8/+ZCJU/af8roz8nhjPZAWLOBXth67At/yuToeov2+9Rsp3T
sDjZIT0NBK7ZT4mflvp8QzJU/037LU8Pfl+wJdnh7BkQuGOfqqMr37AVZt4D
++gA+yurtsLUP7Tf/VnAbuNWmPmP7Q8dSf0M4kP0P7FPXFLLsGkrzL5n9p3h
X8B8iHkv4HyIeS/h6iHmvbY/jGLeG/s9UPsg5r2Duwdi3ge4eyHqP8D9AzH/
I9y/EP2f4OEBse8zPLwg5n2BhyfEvC/2VSjh/dW+GxofEPO+2f+FxhfEvO/2
sPgEAMOc1tY=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=7000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ofWsy43nxwG5e+0f2R2VyVDIcHB
xBgEDtsvK3W4JzE3CSp/0l7jw0/Dx6eSHSDmXLCv6H9aae+bAlV/2T5g19u8
D/UpDulpIHDNvlkmUaxkYgpU/0175ehDHQempTicPQMCd+yPiDWsV5yRAjXv
gX2z5BGZ/Bkw9Q/tKz6lMNTOgJn/2H7OErOvdTNg+p/Yr7qppFk/A2bfM/u+
KSt06uHmvYDzIea9tF8JVQ8x7zWaeW/g9kHMewd3D8S8D/aHoe6FqP9grwT1
D8T8j3D/QvR/gocHxL7P9uXQ8IKY98VeExqeEPO+2C9HCe+v9o+h8QEx7xs8
viDmfbeHxScAbF/RCA==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=7500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9m9LjaTvcoZD+TvtfyUVROdOSHAw
MQaBw/brJl56sMIsGSp/0n4rV6tVSWOKA8ScC/aX+v5mbxRNhaq/bH+LsdpR
KCjVIT0NBK7Zc359+lo7IxWq/6a97fpSjaj8VIezZ0Dgjr3o7LRXKYWpUPMe
2L8uVL/1pBCm/qH9Jntfq/+FMPMf22uo3FnLXATT/8RewOunC0sRzL5n9pn1
W4JBfIh5L+wzoHyIeS/h6iHmvUYz7439Zqh9EPPewd0DMe+DvQjUvRD1H+xt
oP6BmP8R7l+I/k/w8IDY9xkeXhDzvsDDE2LeF/v1KOH91f43ND4g5n2zfweN
L4h53+1h8QkAtozL7A==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=8000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9vsW70n0rQiH8nfaLxHRm8X1M8HB
xBgEDtuvn2yrcuRYMlT+pP32mufqe3RTHSDmXLBfODPt+53LqVD1l+3Ng5LC
A6TSHNLTQOCa/bO0ALNs0zSo/pv2AeF7Vx63S3M4ewYE7tincux5t9QxDWre
A/vlph6Xspxg6h/aB1l2O88A8iHmP7avDXORWugE0//EvqN9f9MiJ5h9z+yn
HF+2HsSHmPfCfjKUDzHvpX07VD3EvNf2dSjmvbEPgdoHMe8d3D0Q8z7Yp0Dd
C1H/wd4f6h+I+R/h/oXo/2RvAQ0PiH2f4eEFMe8LPDwh5n2x34AS3l/tl0Lj
A2LeN/sD0PiCmPfdHhafAGEYzcE=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=8500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9tPcpnm53Q+H8nfaX1b3nXQvKtHB
xBgEDtszGE06KOOXApU/aX9wCbty7IVUB4g5F+wzE83Y3TrSoOov25ub/iwW
uZnmkJ4GAtfs7a0/pfT+TIPqv2lv0ZWXkcCa7nD2DAjcsV/7PUDXljMdat4D
+6p7vEuiudKh6h/aF9lucFsC5EPMf2x/65Cs0hYumP4n9jl3rXm3A/kQ+57Z
b5E8VgPiQ8x7AedDzHtpnw1VDzHvtf0dFPPe2JdA7YOY9w7uHoh5H+zXQN0L
Uf/B3hzqH4j5H+H+hej/BA8PiH2f4eEFMe8LPDwh5n1BC++v9leg8QEx75v9
dGh8Qcz7bg+LTwCDn8Qs
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=9000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ooTU5Xy7COg/J327zbG2pRtS3Qw
MQaBw/bVOzWmh5xNgcqftNfIWS38PjPNAWLOBfvCDGXNHON0qPrL9pNPd7Ac
70t3SE8DgWv2xoraB99sSYfqv2nvfcKquvJwusPZMyBwx/7ExN799SfSoeY9
sF926A0/3ymY+of2NW/qS6pPwcx/bP/D9t2Bqadg+p/YH9k832j2KZh9z+yt
JbWV5pyCmffC3gbKh5j3Eq4eYt5r+58o5r2xr4PaBzHvnf1yqHsg5n2wPw51
L0T9B7h/IOZ/tDeC+hei/xM8PCD2fbYvgoYXxLwv8PCEmPcFLby/wuMDYt43
eyVofEHM+24Pi08A7grStg==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=9500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9t1f/04LnxkB5e+0X8x/q8SfJ8nB
xBgEDtsXNvwW+e+SCpU/af/UO56N4XeaA8ScC/adyl8ZT11Nh6q/bP/xZ0jZ
OesMh/Q0ELhmP3HVXNVH6RlQ/Tftv/LuPZdameFw9gwI3LFv7l+9dn99BtS8
B/bp3musrzbC1D+03878zbyoKQNq/mP7PdeW689ugul/Yi+w8lXXkiaYfc/s
2Xk5IpY1wcx7Yc8B5UPMewlXDzHvtf1eFPPe2O+A2gcx7x3cPRDzPsDdC1H/
Ae4fiPkf7SdA/QvR/wkeHhD7Ptt3QcMLYt4XeHhCzPtiX4AS3l/tl0DjA2Le
N3h8Qcz7bg+LTwAX79T+
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=10000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9m8DtM62vI2A8nfaP905Q/Z2TJKD
iTEIHLaf8FbjwqKtqVD5k/azOU+tFmlJd4CYc8GevZLv75X8DKj6y/azVe9v
7nuQ4ZCeBgLX7H82cu88IpQJ1X/T3mqmqGGZeqbD2TMgcMe+bHarmo9+JtS8
B/aHH3B+YDCCqX9ov0OuOfMmkA8x/7H9tYJ4PjFjmP4n9tKVzbKqQD7Evmf2
H0vSfDSMYea9gPMh5r2Eq4eY99r+Oop5b+x3Qu2DmPfO/gjUPRDzPthXQN0L
Uf8B7h+I+R/h/oXo/wQPD4h9n+HhBTHvi/0caHhCzPuCFt5f7Z9B4wNi3jf7
d9D4gpj33R4WnwAENssr
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=10500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ndmtNzKtImE8nfay354e69uRZKD
iTEIHLYXjvvzeJd8GlT+pP3cN+JPVrBmOEDMuWCv3y6t/pcxE6r+sn28yoXD
GbWZDulpIHDN/jD/vQ0vt2ZC9d+0d7c9G/zzbKbD2TMgcMf+05GM1YXXM6Hm
PbCfGrL7/N1bMPUP7Y/GZTb8uw0z/7H9jdlrekPuwPQ/sX8kLtWWfQdm3zN7
MZPZxwruwMx7AedDzHsJVw8x77X9TRTz3tgfh9oHMe+d/TSoeyDmfbD/DHUv
RP0Hew+ofyDmf4T7F6L/k30cNDwg9n22N4CGF8S8L/DwhJj3xV4EJby/2stB
4wNi3jf7u9D4gpj33R4WnwDzDt2M
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=11000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9jrnXxzPa4uE8nfa35m5as6090kO
JsYgcNhe/eJJtR3NaVD5k/YeHax+Bg0ZDhBzLtjbvrmrvrYnE6r+sv2VyX+a
dwllOaSngcA1+2Rdc9klgVlQ/TfthSssT1jnZjmcPQMCd+xTDUOMqiqyoOY9
sFdteNe+tQam/qH90rSag9p1WVDzH9srpltNX1gH0//E3mH9WYnDdTD7ntmX
PlrseboOZt4L+zIoH2LeS3tHqHqIea/tlVDMe2O/DGofxLx39mpQ90DM+2Cf
BnUvRP0HuH8g5n+E+xei/xM8PCD2fYaHF8S8L/DwhJj3xV4DJby/2t+FxgfE
vG/2utD4gpj33R4WnwDAktBe
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=11500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9hIvPcw/no6E8nfat0aHrCs1SnYw
MQaBw/aTOHItmB6lQeVP2r8xcbwi9iXDAWLOBfvyHskgL4EsqPrL9pFHcqvv
LchySE8DgWv27M3c+12eZUH137Tfm53ws5012+HsGRC4Y28kedNhrVA21LwH
9g07D/w6J54NVf/Q/mbAjawVktlQ8x/b561U/OoiBdP/xN62rIm1BMiH2PfM
Xm5xv2mDFMy8F3A+xLyXcPUQ817bF6CY98b+FtQ+iHnv7Jug7oGY98HeGOpe
iPoPcP9AzP8I9y9E/yd4eEDs+wwPL4h5X+DhCTHvi/1klPD+Co8PiHnf7CWh
8QUx77s9LD4B2pvI5Q==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=12000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9rULTxxw5Y2C8nfar+LLeJZemOxg
YgwCh+0LFWbn/7BKh8qftBfN+2B6MDHTAWLOBfs69feHTHqzoOov2y849Huf
tka2Q3oaCFyz52D79VyyJBuq/6a9TkC6qtr0bIezZ0Dgjr3t1SrGgGXZUPMe
2B+qjEjJWwNT/9BeJjb5zo512VDzH9trhO8tb14P0//EXvqcT9Xh9TD7ntnL
bGR7cWU9zLwXcD7EvJf2MlD1EPNe22uimPfGXhZqH8S8d/ZHoO6BmPfB3g7q
Xoj6D3D/QMz/aM8J9S9E/yf7+dDwgNj32b4WGl4Q877Yi0HDE2LeF/silPD+
ar8aGh8Q877Z10HjC2Led3tYfAIAmkrOFg==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=12500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9osrFMR2ekVB+Tvt1/VfLdy0JtnB
xBgEDts/E+1b9akvHSp/0r6aoaWj92SmA8ScC/Y8SWu6jzNnQ9VftpfmWf/k
64psh/Q0ELhm//i2YnL+72yo/pv23lr3wmOUchzOngGBO/Ym68RDlxrnQM17
YC88Mab6qlUOVP1D++8esnvn2eZAzX9sL8B0WHK+HUz/E/uN8deOfAbyIfY9
s39U/v02tz3MvBdwPsS8l/aboOoh5r22F0Qx7439D6h9EPPe2YtA3QMx74O9
KdS9EPUf7H2g/oGY/xHuX4j+T/ZS0PCA2PcZHl4Q877AwxNi3hf75yjh/dV+
PTQ+IOZ9s18CjS+Ied/tYfEJAHd40A8=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=13000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9peZdn6f0BIF5e+09xV7OW3Kk2QH
E2MQOGy/f/1nNqd76VD5k/bfXr3ceFk7ywFizgX7qRdSHkWUZEPVX7bXbT3A
1Kuc45CeBgLX7PVWMaT11eRA9d+010rdmpq3PMfh7BkQuGPPVjnx4dtdOVDz
HtjzPG3sdT4MU//Qvjs3XnbmsRyo+Y/t8983KF0/DtP/xL7i65IilxMw+57Z
71FOP5FyAmbeCzgfYt5L+0qoeoh5r9HMe2PfA7UPYt47e16oeyDmfbBnh7oX
ov6DvTbUPxDzP8L9C9H/yV4HGh4Q+z7Dwwti3hf779DwhJj3BS28v9r7Q+MD
Yt43+6vQ+IKY990eFp8AcTrYrg==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=13500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9h/uBrHw7o6C8nfaW88MjfSQTHEw
MQaBw/ZvZapbDDUzoPIn7Z/L77/1tCPLAWLOBfu5MgvCrO5nQ9Vftr95as52
2xk5DulpIHDNvux+QMfe7zlQ/Tftjaq8Xs9Vy3U4ewYE7tg/aFgql2GTCzXv
gb2e7O0ZX11zoeof2pfNcpn2xDMXav5je84VZm4Z3jD9T+xtL+oXfALyIfY9
s9/NH7dPxgdm3gs4H2LeS3s7qHqIea/RzHsDtw9i3jt7fah7IOZ9gLsXov4D
3D8Q8z/C/QvR/wkeHhD7PtvPg4YXxLwv9i+g4Qkx7wtaeH+1t4HGB8S8b/af
oPEFMe+7PSw+AQBdzm4=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=14000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9p++ymalv4uC8nfa9997w87sneJg
YgwCh+0Xqj2YwlaQAZU/ad/3r+GGwMMsB4g5F+xX+ilz7HTJgaq/bF9+4JRF
IHuuQ3oaCFyzN+d8fNAhNxeq/6a9xMVtPloLch3OngGBO/bn7ZYnBuzIhZr3
wP51SlOS2mGY+of2/xWr0nYfz4Wa/9j+EWPPkZ6TMP1P7P+yb1OzOAWz75n9
ustPXfNOwcx7AedDzHtp/weqHmLea/vHKOa9gdsHMe+d/RuoeyDmfYC7F6L+
A9w/EPM/2ltA/QvR/8m+AhoeEPs+w8MLYt4X+35oeELM+4IW3l/h8QEx75v9
Z2h8Qcz7bg+LTwAN+tPY
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=14500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9uI8a+quykVD+Tvtg86t3f61MsXB
xBgEDtsrdDyfzbg5Ayp/0j4u6kf/HJNsB4g5F+z7PdLuyS7Ngaq/bG956k8a
b2GuQ3oaCFyzX+xQmxt5Nxeq/6b93zPxOwJE8hzOngGBO/Zf5y548UAvD2re
A/vnOgrdfNZ5UPUP7SUd9veEOuRBzX9s/3qWaWuNE0z/E/tcs3MzfJ3zoPY9
s2/y56ua6Awz7wWcDzHvJVw9xLzX9m9QzHtjLwW1D2LeO/sXUPdAzPsAdy9E
/Qf7f1D/QMz/aL8E6l+I/k/2VtDwgNj3GR5eEPO+2CdAwxNi3he08P5qHwiN
D4h53+wloPEFMe+7PSw+ATbjzqU=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=15000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9l88eJ06fKKh/J32bXvk1/suS3Ew
MQaBw/Zc0SmJcZ8yoPIn7T2NrQLONGc7QMy5YL82fN3+tQy5UPWX7d+5vXq6
5WquQ3oaCFyzP/D9ob+bRx5U/017tpWrtH2a8xzOngGBO/ZVT42fBi7Ig5r3
wP74+T0Ln6yFqX9o7yEV/uDF5jyo+Y/t10rdNcrdBtP/xF5PZ21txvY8qH3P
7DMcPijv2Q4z74V9OpQPMe8lXD3EvNf261DMe2PvCbUPYt47uHsg5n2Auxei
/oM9O9Q/EPM/2h+E+hei/5P9e2h4QOz7bL8OGl4Q877Ye0HDE2LeF7Tw/gqP
D4h53+DxBTHvuz0sPgElIdUf
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=15500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9l+zui6sKY+G8nfai7WlHjG5kOJg
YgwCh+2b1wmUh+hlQuVP2ns8WaN2/1y2A8ScC/ahviLHV4bnQtVftk85edWs
3TTPIT0NBK7Z/1GxWOS8Lg+q/6a93emllaFv8xzOngGBO/YHk2rbb/LkQ817
YP+q1Nz0rnQ+VP1De4Yda9VXKuVDzX9s/4gpI2SSaj5U/xP7st2q0XvU8qH2
PbO/K7HsiqI6zLwX9negfIh5L+HqIea9tn+CYt4beyaofRDz3tm/hroHYt4H
uHsh6j/Y20P9AzH/o/1fqH8h+j/Zp0HDA2LfZ/swaHhBzPsCD0+IeV/Qwvur
vSg0PiDmfbP/Bo0viHnf7WHxCQDbKs5E
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=16000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9j+4jx3NWRAN5e+0b5zIsuHi9xQH
E2MQOGzfkX9wsnh6JlT+pH3Gqw4dAbEcB4g5F+w9Qr9V+K/Khaq/bF896d6V
AxPyHNLTQOCa/aFF6vLd/PlQ/TftT2oXBC8Oync4ewYE7thflpThXFOSDzXv
gX2mxuonWq0w9Q/tLxzI0j3Rkw81/7H9ffZdKbITYPqf2AfOTJ9XNTEfat8z
+8RWs3+fJ8LMewHnQ8x7CVcPMe+1/QMU897YX4TaBzHvHdw9EPM+wN0LUf/B
/hTUPxDzP9ofgfoXov+TfS00PCD2fbb3goYXxLwv9pnQ8ISY98W+HSW8v8Lj
A2LeN3h8Qcz7bg+LTwA0TtHm
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=16500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9lYRnZPfHYuG8nfaR8Yxh3nIpjqY
GIPAYfuqf65Pr8/JhMqftD+l4HduWmSOA8ScC/bpuxu+3viRC1V/2T7xT1bQ
7Od5DulpIHDNfputiFBITj5U/0178ZvKQVmb8x3OngGBO/ZXd5Tv+H09H2re
A/u973/n/XsJU//QPjBX7Urpp3yo+Y/t+QoFXtp+g+l/Yl+u0bb50vd8qH3P
7C0f5HEn/YCZ9wLOh5j3Eq4eYt5rNPPe2AdB7YOY9w7uHoh5H+Duhaj/YC8B
9Q/E/I/2O6D+hej/ZJ8MDQ+IfZ/tM6DhBTHvi/1paHhCzPtiX4kS3l/tI6Dx
ATHvGzy+IOZ9t4fFJwDwD9pb
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=17000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9i0t4udCX0dD+TvtT/rsYdvlkOpg
YgwCh+1NZ4pEHTqfCZU/aZ94YzHv8pk5DhBzLtibr5LQrHXOg6q/bF93WL7c
1yrfIT0NBK7Z96/6nn75SD5U/03722Esje/YCxzOngGBO/ZGZ9WaaqQLoOY9
sF/bcyfBWbUAqv6hPatzucgHzQKo+Y/tJTZwHhbQgel/Yr9P+iXvTyAfYt8z
+3zv8N0+ujDzXsD5EPNewtVDzHuNZt4bezaofRDz3sHdAzHvg70h1L0Q9R/s
70D9AzH/o/1EqH8h+j/ZN0DDA2LfZ3tLaHhBzPtinwQNT4h5X+xNUML7q/0J
aHxAzPsGjy+Ied/tYfEJAGhHyGk=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=17500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9vtO9ecf5o2B8nfab7/XvsM1KdXB
xBgEDttnHd/zmIEhCyp/0j7WSHRf4bUcB4g5F+z50rt/5XflQdVftv//61ss
d2e+Q3oaCFyzFxTe/mAuTwFU/01797Ds76ImBQ5nz4DAHfuYJ4ecX3oUQM17
YB86ZXdzRTBM/UN7vfLEXTMjCqDmP7Z3sLnD+SsKpv+J/YYFnY5MMQVQ+57Z
qzVefp8UAzPvBZwPMe8lXD3EvNf2jijmvYHbBzHvHdw9EPM+wN0LUf/B3gPq
H4j5H+2FoP6F6P9kz/gbEh4Q+z7bC0DDC2LeF/s4aHhCzPtin4kS3l/tt0Hj
A2LeN3h8Qcz7bg+LTwCl88+i
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=18000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9lfPLxIO04uB8nfab2Y2tuZoSnUw
MQaBw/bZAt837dLNgsqftN+7WWSvikCuA8ScC/ZeB76WPTqbB1V/2T4+Wmky
25V8h/Q0ELhmL5J89tA9kwKo/pv2j+dn3nCKK3A4ewYE7tjH5C3tiiopgJr3
wF5l5d2oLfUw9Q/tFy+fqubbWgA1/7H9ZUeOG+/bYfqf2G+4fe2lZGcB1L5n
9q1ruCZ0dMLMe2HfAuVDzHsJVw8x77X9FRTz3sDtg5j3Du4eiHkf4O6FqP9g
/wTqH4j5H+3FoP6F6P9knwgND4h9n+29oeEFMe+L/T5oeELM+4IW3l/tN0Hj
A2LeN/sr0PiCmPfdHhafAHmE0io=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=18500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9h/TVulo+cZA+TvtE8/zp8ksSHUw
MQaBw/bhJTx5IpFZUPmT9hmPV6m+dst1gJhzwZ7tWvJvJr58qPrL9l+89khs
5y1wSE8DgWv2306ernKOLoDqv2mfOsGntrutwOHsGRC4Y+9weu2jp3MLoOY9
sH+/1fUs9yqY+of2m/gZL8ltKICa/9je/mx3BttmmP4n9vr6j1RCtsDse2bv
LLR//cUtMPNe2DtB+RDzXsLVQ8x7be+AYt4buH0Q897B3QMx74O9I9S9EPUf
7NOg/oGY/xHuX4j+T/ZfoeEBse+zPQc0vCDmfYGHJ8S8L2jh/RUeHxDzvtl/
gMYXxLzv9rD4BAClis4J
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=19000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9pyP2YyjsmKg/J32/BP8HWfvSXUw
MQaBw/bT5ponGTRlQeVP2kel6DS8rcp1gJhzwX6mp1HMX698qPrL9lvXzavf
rl/gkJ4GAtfsUz0lFR7VF0D137RXObY+mHVtgcPZMyBwx/5WgCvDgqMFUPMe
2LPduf5l0iWY+of2Zh5u2Uo3C6DmP7aPnHZOK/AOTP8T+/flG52O3IXZ98y+
qfHnpMB7MPNewPkQ817C1UPMe20fhWLeG3tzqH0Q897Zs0PdAzHvg/1tqHsh
6j/A/QMx/6N9GtS/EP2f7LdBwwNi32d4eEHM+wIPT4h5X9DC+ys8PiDmfbPn
gsYXxLzv9rD4BADcCc9y
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=19500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9u55jef/tcZA+TvthZ2stedcT3Uw
MQaBw/Y/L/Vs0FuZBZU/aS+0yedd4JpcB4g5F+w7xB24frfkQ9VftrcNFDgq
GVDgkJ4GAtfsu5genTq/qACq/6a9qsrZJ0cuFjicPQMCd+zbb60/Nud1AdS8
B/bzr1xXif0JU//QvjL7590shkKo+Y/tm/pXn3rEXAjV/8TemO3B2RrWQqh9
z+z7Hb5tk2IrhJr3As6HmPcSrh5i3ms0897YV0Htg5j3zn4B1D0Q8z7A3QtR
/8FeDeofiPkf7buh/oXo/2RvBw0PiH2f7Tuh4QUx7ws8PCHmfUEL76/2QtD4
gJj3zd4DGl8Q877bw+ITAJcX1Z0=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=20000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ve7Qhn1F8RA+TvtDx4/+dPkY6qD
iTEIHLafdPZxme65LKj8SfvmebeDbW7nOkDMuWA/cyqLmfKefKj6y/Ymt3UV
P+UVOKSngcA1+0nPfs5VOFIA1X/TPiDuxZ27Xwoczp4BgTv2ERlpfu/5C6Hm
PbBftMX9Q41cIVT9Q/ubyVMiudQKoeY/tv8zXcLirGYhVP8Te3OpS5P7tQuh
9j2z73ZceMtOB2beCzgfYt5LuHqIea/t/6KY98b+FtQ+iHnv7BdD3QMx74N9
JNS9EPUf7AOh/oGY/xHuX4j+T/DwgNj32X4WNLwg5n2BhyfEvC/2k1HC+ys8
PiDmfbO/B40viHnf7WHxCQDf/NS9
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=20500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9mWrsx0YdsZA+TvtmbwYJas40xxM
jEHgsH2Cjf5Xj49ZUPmT9rO4S2vOsec5QMy5YP/iyPwPsz7kQ9VftneYmHsq
uKfAIT0NBK7Zz/m49MLzxwVQ/TftQzKOCyWLFTqcPQMCd+w/upS+XmlUCDXv
gf3KPRoGLE6FUPUP7bveaEYIeRVCzX9s3/G9eJ2iH0z/E/uiusY1vAGFUPue
2ZvxLmc7HwAz7wWcDzHvJVw9xLzX9p0o5r2x74baBzHvnf0qqHsg5n2w/wR1
L0T9B/tQqH8g5n+E+xei/5O9IzQ8IPZ9tn8JDS+IeV/g4Qkx74t9PEp4f4XH
B8S8b/D4gpj33R4WnwB/osu5
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=21000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9gd2W81puxAD5e+0n8jZtKxOIc3B
xBgEDtvv71uwfrZQNlT+pL2FaoqdhlGeA8ScC/Y9CXVLnQQLoOov20uYmjIF
rihwSE8DgWv2OyPsdpgzFUL137R/qqfdn2ZW6HD2DAjcsdcrvm58L7gQat4D
+66v8zhZUmDqH9rfn3JnyeScQqj5j+15cut2fyiA6X9iv7nnZSN7cSHUvmf2
XE/lp94uhpn3As6HmPcSrh5i3mt7XhTz3tg/gNoHMe8d3D0Q8z7Y60PdC1H/
wf4Z1D8Q8z/C/QvR/wkeHhD7Ptv3QsMLYt4XeHhCzPuCFt5f4fEBMe8bPL4g
5n23h8UnAKZEybg=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=21500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9pKbt16/8iwGyt9pz2bQ0xViluZg
YgwCh+2P27/utTPKhsqftC9f+HVWelSeA8ScC/b/cvt3MmoWQNVfttf981bh
96ECh/Q0ELhmn/l13kVF+UKo/pv2TQ9tp/wMKXQ4ewYE7tj/6z/JOre4EGre
A/viLd8/97TA1D+0PykmlzSvtxBq/mP7V5fZ3bwmwfQ/sTeaKnG9Z0oh1L5n
9s+m37IomQoz7wWcDzHvpb0xVD3EvNdo5r2xPwW1D2LeO7h7IOZ9gLsXov6D
fTPUPxDzP9pnQf0L0f8JHh4Q+z7Dwwti3hd4eELM+4IW3l/h8QEx75u9FDS+
IOZ9t4fFJwA9+the
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=22000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ntc5jT9+R0D5e+0V8k93sfjneZg
YgwCh+07OT9+9wjIhsqftE9zyb+zoiHPAWLOBfslAjfTZ9kXQNVftq/cMnVh
0p0Ch/Q0ELhmP2Vx7KltVoVQ/TftDxx8u0SnqNDh7BkQuGN/4Qpf37eJhVDz
Hthf3jBp37rFMPUP7Rsad/E7rS2Emv/Yvmhz8BTbTTD9T+w/OL85t2ZLIdS+
Z/b2WT4sK7bCzHth7wDlQ8x7CVcPMe81mnlv4PZBzHsHdw/EvA9w90LUf4D7
B2L+R7h/Ifo/wcMDYt9neHhBzPsCD0+IeV/sO1DC+ys8PiDmfbPfDY0viHnf
7WHxCQBV1Nqq
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=22500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9o1fKgX4BGKh/J32Plxcxdvi0hxM
jEHgsP36J+IfLuRkQ+VP2mfx3dvItjTPAWLOBfvEu797pEMLoOov26tsO6sz
/UuBQ3oaCFyzP+h9oJMttBCq/6Y961udHv6+QoezZ0Dgjn1oobLfr3WFUPMe
2Jvyr51WcRCm/qH9XcFNE3pPF0LNf2zfWGAVdPMCTP8T+3qXuk+llwuh9j2z
X+qpXdB6BWbeC/tlUD7EvJdw9RDzXqOZ9wZuH8S8d3D3QMz7AHcvRP0HuH8g
5n+0PwD1L0T/J3h4QOz7bJ8EDS+IeV/g4Qkx74v9OpTw/gqPD4h53+wboPEF
Me+7PSw+ATZqz8w=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=23000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9h73p7yVUI6F8nfau4WGMiQWpjmY
GIPAYfsDIc3ar9uzofIn7V2EX3jMOp7nADHngv1yXmHryZkFUPWX7cVzMhcv
5y50SE8DgWv2OYx5lgp5hVD9N+3zX/KnbFxR6HD2DAjcsddmjFDafqoQat4D
+4lzeHl/3oWpf2gvwvvEoP9FIdT8x/YBgdzTtd/B9D+xf8bhZv7tA8y+Z/ZH
/LYnSn2CmffC/iiUDzHvJVw9xLzXaOa9gdsHMe8d3D0Q8z7A3QtR/wHuH4j5
H+2zof6F6P8EDw+IfZ/h4QUx74u9KzQ8IeZ9QQvvr/au0PiAmPfN3h0aXxDz
vtvD4hMAeZDHgg==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=23500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9o2CrJO0TWOh/J32TLPNpKSa0xxM
jEHgsH2KUIrG6oXZUPmT9m1fTqVWv8hzgJhzwd6fXesoX20BVP1l+3j5eo1F
ioUO6WkgcM3+IuMNX6G2Qqj+m/YmL4/OUThU6HD2DAjcsQ/Pu+Ru/bQQat4D
+yepE6XtfsLUP7Qv6uxZFcJSBDX/sf0fHuPXjlxFUP1P7F/bfWGx5i2C2vfM
/mrIDoMSviKoeS/gfIh5L+HqIea9RjPvDdw+iHnv4O6BmPcB7l6I+g/2xlD/
QMz/aH8B6l+I/k/w8IDY9xkeXhDzvti3Q8MTYt4X+1SU8P5qzwiND4h53+wb
oPEFMe+7PSw+AQrYxL8=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=24000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9prCapOD3WKh/J32Oibbzr2bnOZg
YgwCh+3b2rudlHdlQ+VP2peErqk8wJ7vADHngv28fKZTs/oLoOov2xdG/NOa
YlbokJ4GAtfsD7dG9L2aUwjVf9P+4p405uxbhQ5nz4DAHfs0icKkKf8KoeY9
sN9xc7pWqHARVP1D+8X7p2m/liuCmv/YfqHlKl9N1SKo/if2vZo81oEaRVD7
ntn76Zisna9ZBDXvBZwPMe8lXD3EvNdo5r2B2wcx7x3cPRDzPsDdC1H/wf4C
1D8Q8z/C/QvR/8m+ABoeEPs+w8MLYt4X+1JoeELM+4IW3l/h8QEx75u9BjS+
IOZ9t4fFJwBfuMlz
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=24500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9uaafZvnhsVC+Tvtn1r+THm9OM3B
xBgEDtvfXZ59LOViNlT+pL1WQNz2OtV8B4g5F+wvJpjaOS8sgKq/bL9h4fm8
Lq9Ch/Q0ELhmf9uLTXbbpkKo/pv2xv6TT8z9WOhw9gwI3LF/Mb236bxYEdS8
B/ab1vuKeesUQdU/tM90OBoVb1EENf+x/ZtJepbv7Iqg+p/YGx22M3N1KoLa
98yee/VDlZXOMPNe2HNB+RDzXsLVQ8x7jWbeG/sMqH0Q897B3QMx7wPcvRD1
H+D+gZj/Ee5fiP5P9uuh4QGx7zM8vCDmfbHXhoYnxLwvaOH91f4JND4g5n2D
xxfEvO/2sPgEAMgpz0I=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=25000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9uGtGz+KpsVC+TvtT1lsy5LenOZg
YgwCh+35kpYzNTzPhsqftP/4ZZvaKcd8B4g5F+yXXNpZKrypAKr+sn3/yUbR
ibGFDulpIHDNvqDWpq7xeCFU/017F+9nbUfZixzOngGBO/a33szR+qlbBDXv
gb3Py6vGOi5FUPUP7Vdbb4zZG1AENf+x/ZJjnivnhMP0P7Gf49B9VSm6CGrf
M/sT02My5sTAzHsB50PMewlXDzHvtf1iFPPewO2DmPcO7h6IeR/g7oWo/2Dv
DPUPxPyPcP9C9H+ChwfEvs/2i6HhBTHvCzw8IeZ9sedHCe+v8PiAmPcNHl8Q
877bw+ITAP7v08M=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=25500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9qpCwVOPl8RC+Tvtt3XOPNB5MM3B
xBgEDttPlwmJaPmTDZU/ac+sNn3b1ph8B4g5F+wP77mpI3aoAKr+sv3j7x3L
NucXOqSngcA1e0Hf6/MjbhdC9d+0NzI29nwnU+Rw9gwI3LE/Frw6RNalCGre
A/uG6IAwlugiqPqH9k8eLbwhkFEENf+xfZORhrxDPkz/E/syV436r0VFUPue
2dtpy11oKYGZ9wLOh5j3Eq4eYt5r+0YU897YP4baBzHvnX091D0Q8z7A3QtR
/8HeEOofiPkf4f6F6P8EDw+IfZ/tD0HDC2LeF3smaHhCzPuCFt5f4fEBMe8b
PL4g5n23h8UnAOUazDM=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=26000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9orzHljvbYqF8nfaKx/ZtNThfJqD
iTEIHLZfHcPp1SCQA5U/ad+7ZpdvcFm+A8ScC/a7Ps6bEHqxAKr+sv09dhHx
vw2FDulpIHDNfs9X1Qdu7wqh+m/alx+aNEHZsMjh7BkQuGNvlrip3D2yCGre
A/vXAXsv3ysogqp/aD/rus3flLoiqPmP7dWPOS573ArT/8Te+KaF6onOIqh9
z+yL59s65nbDzHsB50PMewlXDzHvtb0ainlv4PZBzHtn/wrqHoh5H+xNoe6F
qP8A9w/E/I9w/0L0f4KHB8S+z/Y7oeEFMe+LfQ80PCHmfUEL76/w+ICY9w0e
XxDzvtvD4hMAg8TUYA==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=26500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9lqHrjxmmBAL5e+0V/vCeMjzTpqD
iTEIHLa/dfhGZ6NyDlT+pP0qzcxbm/vyHSDmXLA/pXXA7fb9Aqj6y/YfFtdc
LJ9Y6JCeBgLX7BfnTRYJZyiC6r9p//uddVSBS5HD2TMgcMe+JuZET1NuEdS8
B/a2X/d2HmuFqX9o/6NFoPXI5CKo+Y/tGbiv35g4G6b/ib3iO3+vpfOLoPY9
s9/A9scwYSHMvBf266F8iHkv4eoh5r1GM++N/XeofRDz3tnbQN0DMe+DfTXU
vRD1H+x/Qf0DMf+j/RKofyH6P8HDA2LfZ/uT0PCCmPfFfiU0PCHmfbG/iRLe
X+HxATHvGzy+IOZ9t4fFJwBHOths
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=27000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9kJvTb/PnhML5e+033rWwmDdizQH
E2MQOGwf/d2VbappDlT+pH1oo2zi86X5DhBzLtgnWouVbnhbAFV/2f7Y3LA9
ugsLHdLTQOCa/S979gmTBYug+m/aC7hpqt4PK3I4ewYE7tjHKWuI3Gwogpr3
wP5RtOGjozNh6h/al5v/3GW5oghq/mN7Fi2XJyEbYPqf2FeLHGWdvqUIat8z
+550uXXp22DmvbDvhvIh5r2Eq4eY9xrNvDf2ZVD7IOa9s38IdQ/EvA/2sVD3
QtR/gPsHYv5H+99Q/0L0f4KHB8S+z/YJ0PCCmPfFPgQanhDzvthHoYT3V3h8
QMz7Zi8MjS+Ied/tYfEJAK4dzRo=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=27500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9nuy3UOnr4iF8nfau3452Fb2Jc3B
xBgEDtvbbQ3+dswtByp/0l6t05zr7+58B4g5F+w/P11w4u6vAqj6y/b675Uc
NTYUOqSngcA1e197Bk02pSKo/pv2Qbu6vldmFDmcPQMCd+wN1QWlQicXQc17
YB8usu76szUw9Q/tf+xNrDu3uwhq/mP7t4u0e82OwPQ/sfc7cId9+YkiqH3P
7H88kojuPQUz7wWcDzHvJVw9xLzXaOa9sf8OtQ9i3jv7MKh7IOZ9sDeAuhei
/gPcPxDzP8L9C9H/CR4eEPs+23+ChhfEvC/2KtDwhJj3xd4WJby/wuMDYt43
eHxBzPtuD4tPACF+1io=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=28000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9l1s9dG/N8dC+TvtrXrlHqz6n+Zg
YgwCh+2n+u98ohSeA5U/aX9K+pQe88V8B4g5F+wXhSjVZLMXQtVftq/etSqo
YF+hQ3oaCFyzN1TMtt9hWATVf9N+vwNLildlkcPZMyBwx/5FUL01w9IiqHkP
7I1jb/w02g9T/9DeLDrBvedcEdT8x/a+nlXGDtdh+p/YO0Udm3vvdhHUvmf2
RSW8Nbfuwsx7AedDzHsJVw8x7zWaeW/sTaH2Qcx7Z28EdQ/EvA/2z6Huhaj/
APcPxPyPcP9C9H+yr4KGB8S+z/YLoeEFMe+L/QloeELM+4IW3l/traHxATHv
Gzy+IOZ9t4fFJwCq0c0V
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=28500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9oFXz789vy8Wyt9pf2LNikdBXOkO
JsYgcNie43Pgrs1pOVD5k/ZbDaalsD/Nd4CYc8H+zrHwuEThQqj6y/abW9iK
+c4UOqSngcA1e92PZoc2ORRB9d+0f3FjZ19kZ5HD2TMgcMde6sGuVY+3FkHN
e2C/Q3lq4eYLMPUP7QPPbNCqeVAENf+x/UEGt2tVL2H6n9gzahZtdXtXBLXv
mb3j6gVfwz/AzHsB50PMewlXDzHvtf0BFPPe2AdA7YOY985+O9Q9EPM+wN0L
Uf8B7h+I+R/h/oXo/2S/CRoeEPs+29+GhhfEvC/2m6HhCTHviz07Snh/tT8J
jQ+Ied/sg6DxBTHvuz0sPgFsWNrJ
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=29000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9hsNIutkTsZC+TvtI7YfP14qku5g
YgwCh+11664eby7NgcqftG+1dOoU+5HvADHngv3BmVevH5MrhKq/bK9zOHQn
181Ch/Q0ELhm/2DGSpN/fkVQ/TftGc5pGm2YUeRw9gwI3LH/E3DAmONYEdS8
B/YvxaVYCx/C1D+0n6LRc3fZxyKo+Y/tP8zsEH//C6b/iX3yL4eHz/8XQe17
Zl/UtyyQj6kYat4LOB9i3ku4eoh5r+3fo5j3xn4y1D6Iee/sX0DdAzHvA9y9
EPUf4P6BmP8R7l+I/k/22tDwgNj32f4ANLwg5n2xb4aGJ8S8L/Y6KOH91T4S
Gh8Q877Zb4LGF8S87/aw+AQArULWuw==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=29500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9muV2kVeXIqF8nfau7YvSpKSS3cw
MQaBw/bXrV+em9OcA5U/aa//JDdNjrXAAWLOBftP2T0fFmkWQtVftpfdpHU9
52mhQ3oaCFyzr15XtnlRTBFU/037FerXFoctL3I4ewYE7thfetvgUHa1CGre
A3t509vSJR9h6h/aS8XH7xRhKoaa/9h+guwO+6XcxVD9T+x3B/RHnxIohtr3
zN5l88pDrMLFUPNewPkQ817C1UPMe23fj2LeG3tJqH0Q897Zy0HdAzHvA9y9
EPUf4P6BmP8R7l+I/k/2MtDwgNj32f4jNLwg5n2x14OGJ8S8L/bXUML7q70b
ND4g5n2zXweNL4h53+1h8QkAZF3O1g==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=30000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9pMTNgRb3omF8nfan2KMUnNXT3cw
MQaBw/aHWqdycUzMgcqftF9lcOPuId4CB4g5F+zd9/0J+WNcCFV/2X6j8zpZ
m4+FDulpIHDN/uqpWT+XZxZB9d+0/5+470bI1iKHs2dA4I59h/ufO6ZPiqDm
PbA3NQk7dIShGKr+of1b8cT9ZwWLoeY/ti89YOu4VLoYqv+J/acdslzfFIqh
9j2zr033U3dTLoaa9wLOh5j3Eq4eYt5r+xIU897Yv4HaBzHvnb0J1D0Q8z7A
3QtR/wHuH4j5H+2vQP0L0f/JfgM0PCD2fbZ3g4YXxLwv9iuh4Qkx74v9QZTw
/gqPD4h53+ynQOMLYt53e1h8AgDCOdFY
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=30500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9i0rbBrFnsZC+Tvt9x68qs1kkO5g
YgwCh+2ztXXMz83NgcqftN+z4ojyP9ECB4g5F+yrJOWib9oWQtVftv9wvr6p
/k+hQ3oaCFyz37vyb4poWRFU/017mXmrMjcdKnI4ewYE7ti3xBnv9vtUBDXv
gb1a/p61WfzFUPUP7Zv2s8+5qVAMNf+x/bfVZ3Z/0yqG6n9iv+hieGORQTHU
vmf2Ausm8143Koaa98KeH8qHmPcSrh5i3mv7ryjmvbFvhNoHMe+dvSrUPRDz
Ptg3Q90LUf8B7h+I+R/t90D9C9H/yf49NDwg9n22r4SGF8S8L/a7oeEJMe+L
fRZKeH+FxwfEvG/w+IKY990eFp8APbnS9w==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=31000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9hP9Y7ta38ZC+Tvtv0/TNg+0SHcw
MQaBw/aBuatmfl+ZA5U/aa+9WyvjqmyBA8ScC/aWuf/YHNwLoeov2/9nDVli
y17kkJ4GAtfs74Tc/fWxsQiq/6b9+37P6WXnixzOngGBO/ahqt/MTvwvgpr3
wN7xXLV9rmwxVP1D+5MtCavs9Yuh5j+237R95v8FlsVQ/U/s6wqr2d3ti6H2
PbPPWfN5637HYqh5L+B8iHkv7Wuh6iHmvbbfiGLeG7h9EPPe2TtA3QMx74N9
CNS9EPUf7N9B/QMx/6P9bah/Ifo/2f+DhgfEvs/2FtDwgpj3xV4LGp4Q877Y
+6OE91d4fEDM+waPL4h53+1h8QkAbl3TKg==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=31500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9gz3Ejh7vsZC+Tvt206t3GPpkO5g
YgwCh+0jcxaw9WzNgcqftP/UpDrNV7XAAWLOBfvlfHL8ZgGFUPWX7aPKw87X
CBY5pKeBwDV7tcksOS69RVD9N+0ZapX8Vtwucjh7BgTu2Ctr90Su5CmGmvfA
/nfK8o7LWsVQ9Q/tZYU9vrPZFkPNf2zvrFoqsNq9GKr/if0L54XTq3yLofY9
sz/LmSrGHgAz7wWcDzHvpf1zqHqIea/RzHtjLwO1D2LeO7h7IOZ9sFeCuhei
/oP9/xqIfyDmf4T7F6L/k30kNDwg9n22XwYNL4h5X+w/QsMTYt4X+wiU8P4K
jw+Ied/g8QUx77s9LD4BWWrCTA==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=32000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9mGHVnrp/42F8nfai8V3Pz3gnu5g
YgwCh+2bRJa/mHQgByp/0n6b/9HwbJ0CB4g5F+xZinseHIgohKq/bB/9LoDR
WbrIIT0NBK7Zvz97TkJ4RhFU/037pStjtPyeFzmcPQMCd+zVvSzv/pAohpr3
wF6swMF3iXkxVP1De/NLrS5mXsVQ8x/bMyYfXyEdWgzV/8R+ieyKJ8LRxVD7
ntk7Lre7uzkWZt4LOB9i3kv7xVD1EPNe2zOgmPcGbh/EvHf2olD3QMz7YK8G
dS9E/Qf7JVD/QMz/aP8O6l+I/k/w8IDY99meGRpeEPO+2G+BhifEvC/2DSjh
/RUeHxDzvtmHQ+MLYt53e1h8AgA7Xst1
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=32500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ntS/QNLWOKg/J32Ufdjprz2S3cw
MQaBw/bLjuW4CZ/OgcqftN8pvUzS2LjAAWLOBfufdScXPU0ohKq/bL9o1uy3
U1WKHNLTQOCa/aUJv0VSFhVB9d+0PzEjtjrvU5HD2TMgcMe+xHm+wV6VYqh5
D+x7ChLYnzkXQ9U/tL9ddor7Slgx1PzH9hsvFNr8TCyG6n9ir2TBEiOZUQy1
75m91f9/xWeyYOa9gPMh5r20V4Sqh5j32n4Dinlv4PZBzHtn3w11D8S8D/bF
UPdC1H+A+wdi/ke4fyH6P8HDA2LfZ/sf0PCCmPfFfgc0PCHmfbFfghLeX+0j
ofEBMe8bPL4g5n23h8UnABXj0sQ=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=33000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9klOBbfjueOg/J32P7aLZ+4LTXcw
MQaBw/b9IQknhK/mQOVP2qs/9eNbaVngADHngj0Tc771yoxCqPrL9sI/bjBU
6xY5pKeBwDX7JXuCtW3XFEH137RvarV35/9b5HD2DAjcsVew/lv5R78Yat4D
+1w111fz/Iuh6h/a31g3qfFZUjHU/Mf2m8un/PbMK4bqf2J/rqBYY2JJMdS+
Z/aTUn8whpfDzHthPxHKh5j30v4sVD3EvNf2m1DMewO3D2LeO7h7IOZ9sJeH
uhei/gPcPxDzP8L9C9H/yV4IGh4Q+z7Dwwti3hd7NWh4Qsz7Yt+HEt5f7b9B
4wNi3jd4fEHM+24Pi08AXg/MqA==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=33500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9rtYrNO+CcZB+Tvtf0/5ecQ2Jt3B
xBgEDtu/dGLcN+teDlT+pL3GlFjDi/YFDhBzLtgzHloaKFBQCFV/2X6eQUPK
d9Mih/Q0ELhm71em9HDx1iKo/pv2rXWKfmbsxQ5nz4DAHfsIfr9Ze6yKoeY9
sH9qYv/0SlQxVP1D+8Ob3k0vziuGmv/Yvm6+5VXhKpj+J/Z3Z043aWwohtr3
zF7e93FeZDPMvBdwPsS8l/a3oeoh5r22r0Ux7w3cPoh57+DugZj3wT4c6l6I
+g9w/0DM/wj3L0T/J/u50PCA2PcZHl4Q877AwxNi3hf7Fyjh/dX+FzQ+IOZ9
s98JjS+Ied/tYfEJABwvzok=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=34000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9ivMtxjaSMRB+Tvtjx6SOZeblO5g
YgwCh+0/bL6ttO55DlT+pH33xSav9a4FDhBzLtgHqGcGypcXQtVftm+basEk
YFfkkJ4GAtfsNU83V87dVwTVf9O+vTOI96VAscPZMyBwx/54p5sBs2sx1LwH
9nq2Lct6U4uh6h/aX2vTZ2ysLIaa/9g+Uf5FZUwrTP8T++O3y3XfdxdD7Xtm
z78sPPVmH8y8F/Z8UD7EvJf2x6DqIea9tk9AMe+N/VWofRDz3sHdAzHvA9y9
EPUf4P6BmP8R7l+I/k/2rdDwgNj3GR5eEPO+wMMTYt4XtPD+an8EGh8Q877Z
L4fGF8S87/aw+AQAxyXK7A==
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=34500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9q2Nti6mcnFQ/k57bbVrRUEZ6Q4m
xiBw2L7/luni4A85UPmT9qs+Bnxw8y5wgJhzwV583py8W7WFUPWX7Xeu4mg/
6VrkkJ4GAtfsiz53/dA7XgTVf9N+gWHkIR2pYoezZ0Dgjv2hXJPZV/2KoeY9
sNdxfDr3XH4xVP1De4/NVUYiLcVQ8x/bP3aTjdOcANP/xH6x5KuWB9OKofY9
s78Qrhd6ZybMvBdwPsS8l/aLoOoh5r1GM+8N3D6Iee/g7oGY9wHuXoj6D3D/
QMz/CPcvRP8neHhA7PsMDy+IeV/g4Qkx7wtaeH+114LGB8S8b/Yt0PiCmPfd
HhafALt20Ew=
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=35000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9u6cj3OfKsdB+TvtD/y9k/M+N93B
xBgEDttbxJUsmPAjByp/0n7tnQddswMKHCDmXLCX8f663LWlEKr+sr24XHSa
hm+RQ3oaCFyz383lpBZ7vgiq/6a99b0buWzKxQ5nz4DAHfuHafv/WkQUQ817
YF+hkPV/TmUxVP1D+3lWrmlGfcVQ8x/b++mv31M/C6b/iX2n3dPiqIXFUPue
2W88dbo0fQnMvBdwPsS8l3D1EPNe2/uimPcGbh/EvHdw90DM+wB3L0T9B7h/
IOZ/hPsXov8TPDwg9n22l4WGF8S8L/DwhJj3BS28v8LjA2LeN3h8Qcz7bg+L
TwC3ONJ3
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=35500 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {{}, {}, 
      {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], Thickness[Large], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQjQpMHGbNBIGV9vfNi70DNOOg/J32u1wdXDyK0x1M
jEHgsH3TaivTLIZcqPxJe9Pl/mEbQgscIOZcsJ+yd9fJlK5CqPrL9tpPb98x
CClySE8DgWv2Z1haJ+pcL4Lqv2nv5xV2rUq72OHsGRC4Y995u8fBKLEYat4D
e0nmy0f/NhVD1T+0r5i0bd6D6cVQ8x/bSzhJzExZAtP/xN7Pf++fxNXFUPue
2c9LDzlRvw5m3gs4H2LeS7h6iHmv7cVRzHtjXw61D2LeO3spqHsg5n2Auxei
/gPcPxDzP8L9C9H/CR4eEPs+w8MLYt4XezNoeELM+2LfjBLeX+HxATHvGzy+
IOZ9t4fFJwAPx86I
        "]]}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox["\"x[m]\"", TraditionalForm], 
      FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotLabel->FormBox["\"t=36000 s\"", TraditionalForm],
    PlotRange->{{0, 1.4500000000000002`}, {0, 324.9061969086705}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {0, 0}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{3.8479387987387533`*^9, 
  3.8787146393878984`*^9},ExpressionUUID->"45481f07-effa-47bc-a3cb-\
6371186cdb60"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"plots", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{
  3.690043991421875*^9},ExpressionUUID->"e0f624ed-a30e-491d-9fdf-\
5c77e5ba12e7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceUstStav", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"qv", "[", 
        RowBox[{"T", "[", "x", "]"}], "]"}]}], "\[Equal]", "0"}], "}"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "d", "]"}], "\[Equal]", "Ton"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"resNDS", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rceUstStav", ",", "okr1", ",", "okr2"}], "]"}], ",", "T", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", "x", "]"}], "/.", "resNDS"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.690044568703125*^9, 3.6900446249375*^9}, {
  3.690044659953125*^9, 3.6900446638125*^9}, {3.690044766109375*^9, 
  3.690044841265625*^9}, {3.690044872828125*^9, 3.690044930453125*^9}, {
  3.6900449689375*^9, 3.690044969515625*^9}, {3.690045002765625*^9, 
  3.690045050828125*^9}, {3.690083035390625*^9, 
  3.690083116796875*^9}},ExpressionUUID->"19d1e58f-392f-4495-a670-\
3be4e58f50bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"T", "\[Rule]", 
    InterpretationBox[
     RowBox[{
      TagBox["InterpolatingFunction",
       "SummaryHead"], "[", 
      DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
       "Ready"}, 
       TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquarePlusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}]], 
               GraphicsBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz77NZ0qBAA0QKm+gdgd
Cpk/ITGcLI/gUkAvlAOEtBeqP7ICdlMLI19Aj/RD6Atisz/qlwB9fDlkQMyH
F2FrmLk/5D31GeX4Z0Cj2m5OyyrAPwTCHjI9SmtAZlmCWdBPwz873nE0BNBt
QEYlD0Y7uMY/NqbS1OMEcECJpeQbvRDKP6JmrsIS53BA0o3qXq4vzT8Dr5FK
NZNxQJzhtMECSdA/jeL3DWMrckBSsIwKZt3RP9f7iMgBn3JAOdkIyNRp0z9f
zwhJGfxyQK+oQXb2F9U/PcanTo1Oc0AorBLbT6nWP32I9Qc9jXNAMFagMFxc
2D8ThkBEjcRzQGpa0vpzB9o/P6trl3Hwc0Cmkpx7w5XbP2lT+L7OEXRAcXEj
7cVF3T/caSfaQS90QD+EQhUA2d4/sM6gao9FdEDOHg+X9kbgP+59uPwdWXRA
lijP3XId4T8uoO1JgGh0QF9M2/+K5eE/DtamtQ10dEBww0WafL7iP5puwbIO
fnRAglT8DwqJ4z8Rtyq7a4V0QK0SBUCdT+Q/6+BrnhOLdEAfJGzoCSflP+0n
Sb62j3RAk08fbBLw5T83Tcom0JJ0QE7OMGj0yeY/wCuqGfqUdEAiepQe3J/n
P3azRRr8lXRA9z9EsF9n6D8Gfq/Y95V0QBRZUrq8P+k/Tu8c1+eUdEAyjKyf
tQnqP1DQszvkknRAaexYP7TP6j+40zil4Y90QOefY1eMpus/sKOUGVKLdEBn
bbpKAG/sP/vmeveshXRALo5vtk1I7T+QLoyLx310QPfIcP02E+4/rXX/Xm10
dEDYMMT+JdruP+qkqHMJaXRAAex1eO6x7z/G48Lcrll0QJbguWapPfA/+wuO
j/FHdEDO9GdNyKrwP2hoiRAtMHRAkx8/EeoV8T8wGYhsNRN0QFhXvMLZefE/
DZEj/ATyc0DBuGgwNubxP0glX2THxXNAKye7i2BL8j+lzXA2/5JzQCGsNsSN
rvI/Q13t1VlWc0C7WuG4JxrzP69aV6+tBXNAVhYym49+8z9RMMqeValyQJT7
sTlk6/M/508p0FkuckBf91q1O1b0P0ghVuUfmXFAKgCqHuG59D97IeeTsO5w
QJkyKETzJfU/VdMbA/ILcEAJckxX04r1PwMzIfpMEG5AHdufJiD49T8jTVXT
DVxrQL1aHNNvY/Y/1vfLa1wTaEBe5z5tjcf2P2TZgoATUmRAop2Qwxc09z/V
3Gd6GqVeQOdgiAdwmfc/kHQlYIstU0AI5Sz5///3P+xI2rkDADRA3WjN2Q==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$5925#1"]& ]}}, {}, {}}, {
                DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                 AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                 GridLines -> {None, None}, DisplayFunction -> Identity, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None, 
                   "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                 PlotRange -> {{0., 1.5}, {0., 329.37404849268876`}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}], True -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquareMinusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}]], 
               GraphicsBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz77NZ0qBAA0QKm+gdgd
Cpk/ITGcLI/gUkAvlAOEtBeqP7ICdlMLI19Aj/RD6Atisz/qlwB9fDlkQMyH
F2FrmLk/5D31GeX4Z0Cj2m5OyyrAPwTCHjI9SmtAZlmCWdBPwz873nE0BNBt
QEYlD0Y7uMY/NqbS1OMEcECJpeQbvRDKP6JmrsIS53BA0o3qXq4vzT8Dr5FK
NZNxQJzhtMECSdA/jeL3DWMrckBSsIwKZt3RP9f7iMgBn3JAOdkIyNRp0z9f
zwhJGfxyQK+oQXb2F9U/PcanTo1Oc0AorBLbT6nWP32I9Qc9jXNAMFagMFxc
2D8ThkBEjcRzQGpa0vpzB9o/P6trl3Hwc0Cmkpx7w5XbP2lT+L7OEXRAcXEj
7cVF3T/caSfaQS90QD+EQhUA2d4/sM6gao9FdEDOHg+X9kbgP+59uPwdWXRA
lijP3XId4T8uoO1JgGh0QF9M2/+K5eE/DtamtQ10dEBww0WafL7iP5puwbIO
fnRAglT8DwqJ4z8Rtyq7a4V0QK0SBUCdT+Q/6+BrnhOLdEAfJGzoCSflP+0n
Sb62j3RAk08fbBLw5T83Tcom0JJ0QE7OMGj0yeY/wCuqGfqUdEAiepQe3J/n
P3azRRr8lXRA9z9EsF9n6D8Gfq/Y95V0QBRZUrq8P+k/Tu8c1+eUdEAyjKyf
tQnqP1DQszvkknRAaexYP7TP6j+40zil4Y90QOefY1eMpus/sKOUGVKLdEBn
bbpKAG/sP/vmeveshXRALo5vtk1I7T+QLoyLx310QPfIcP02E+4/rXX/Xm10
dEDYMMT+JdruP+qkqHMJaXRAAex1eO6x7z/G48Lcrll0QJbguWapPfA/+wuO
j/FHdEDO9GdNyKrwP2hoiRAtMHRAkx8/EeoV8T8wGYhsNRN0QFhXvMLZefE/
DZEj/ATyc0DBuGgwNubxP0glX2THxXNAKye7i2BL8j+lzXA2/5JzQCGsNsSN
rvI/Q13t1VlWc0C7WuG4JxrzP69aV6+tBXNAVhYym49+8z9RMMqeValyQJT7
sTlk6/M/508p0FkuckBf91q1O1b0P0ghVuUfmXFAKgCqHuG59D97IeeTsO5w
QJkyKETzJfU/VdMbA/ILcEAJckxX04r1PwMzIfpMEG5AHdufJiD49T8jTVXT
DVxrQL1aHNNvY/Y/1vfLa1wTaEBe5z5tjcf2P2TZgoATUmRAop2Qwxc09z/V
3Gd6GqVeQOdgiAdwmfc/kHQlYIstU0AI5Sz5///3P+xI2rkDADRA3WjN2Q==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$5925#1"]& ]}}, {}, {}}, {
                DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                 AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                 GridLines -> {None, None}, DisplayFunction -> Identity, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None, 
                   "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                 PlotRange -> {{0., 1.5}, {0., 329.37404849268876`}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}]}, 
          Dynamic[Typeset`open$$], ImageSize -> Automatic]},
        "SummaryPanel",
        DisplayFunction->(
         ButtonBox[#, Active -> False, Alignment -> Left, 
          Appearance -> {
           "Default" -> 
            FrontEnd`FileName[{"Typeset", "SummaryBox"}, "Panel.9.png"]}, 
          FrameMargins -> 7, BaseStyle -> {}, 
          DefaultBaseStyle -> {"Panel", Background -> None}, BaselinePosition -> 
          Baseline]& )],
       DynamicModuleValues:>{}], "]"}],
     InterpolatingFunction[{{0., 1.5}}, {
      5, 7, 2, {129}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
       False}, CompressedData["
1:eJxFk2kwnAcAhpFURVRNxSY01BGMoo7IOFJe4mswjjiycUZFpK66JxoiccSx
rjZEpCoqRKiJSukm6QoVSpasCOuKMyvWtWtj11qrVTQz+dF35pnn/zPzagTH
eF6QkpCQkHxHusT/W13pP8ALpdq8d5cNVYfObtr9HBOUCtk3o1YwbI8sEpEI
pBO3JSO1CIz09sWxjAjondqeJX9J4OqwoSfDkQDTN7DTlkwgOaS9Wj+agGaM
+jVSDgFGUvp5yTsEAtnOul+UfQWBG4nrV3wSmTRWY06+A0hH7sdTMx3BqXWS
s1L3QO8T69fKO2T8MmDS/PekH7LntbPGaV/DdFuuYco5GM+aw+Yr3C8iOeFC
S21bGq4XkjJ2mNmoraM7nVkqwExQq8zY1SJweCUrGbklIAXSE+r/+Bkaiynb
iwk1MP+MZHc5vx6u3g8y5e82otnhCNt9ugmtc/wslXAqelLbdNnrj6Cw79sy
IrEFfsUq+++J2zBYGPJnRutTJDKPi02vdELloKLxnHUX2v05YTd2unH+TkeV
fTsdMvM/TghTexEv6S8rPcjApKqq1SHNfmhWrJrdtByA9/0BF7XgQRTQmkLq
8pjooBenGP8+hI2RhBLa5DD02acbTuwdRdDasS6GwRhuShycOk1+hefym8Lp
K+PYOTy+P7R2Akf1W7T4/ZMIsyw/niSeQoVDipeU+gyY5LOR+Y6vsce00i7P
ggU12g8v+vtYsLBN81U8Nwsveuy8t2gWUW7n4m7nvgFlxGObpTqH6oATudrN
c+86mCpFnGRjLEKrqnGCDYFA0VAYPQ+5pL008z0L0JEQESm3FmCXMz/wVH8R
6iGW3X2Ni9i1LaS9MlnCjOrsr2zqElr/Mavmmy+jfIxS+m/LMpKpU3kyNhz4
FhmnHujgwCI6M0Gd4MJzizLc68JFJKXwWAKZi0yl4tLDgVxUVJeKu7/h4rFR
uU9MDBcDrZW0Q5e4WHaqUelM42JGtncsboiLIQavRENnBT0Fn3gOXlpBm6v5
x+mMFTTLB/QZq/FQ9zItlxXLg8W0isv6KA/POVR5Geu3CNh0G/z07lvwPli+
YbRvFamK187Yx6xCQUNV2XtkFR63JqMeqvKhXtu/ou3Dxyq1I7K0mI/2v6gc
6Rd8fM+sC//uQwHOzv60tGgngAG/MNQnRYCtnbSFnkcCmA38RhNtCRBVxSrQ
tFtDbbxC0KnsNbDsbY+mMNagrBQrXa8ghOdC5fgIWYj8xy8bpMqF6KLsphqx
hIgwfVZ/2WQdClMFQ/SMdTzM8tpWHF6Hv5GKbpC2CJLjLPeGRBHqMuqSN+ki
uBpE1xDKGxCOmPVfj9hAWeqWeOrJBqDXqaH3kRhsJsX5YqAY8eFd96weiPH+
/Zv4D88IDKk=
      "], {Developer`PackedArrayForm, CompressedData["
1:eJwl0QtHHQAAhuFTKaUspSll2VFKKZtSymYpTVlKN6WU5kwppaOUpildxogY
Y0REjIiIiIiIiIiIiIiIERERsZ7s4/kD3xsMhZuHIwKBwFzg/6KIIY4EEknm
JWlkkEmQbHLJp5C3FFNKOe+poIqP1FJHA0200k4n3XzmC30MMESYUcb5yjem
meU7P1hgkZ/84jdLLLPCKn9YY50NNtlimx122WOfAw454pgTTjnjnAsuueKa
v9xwyx33PPDIPyIdHE0s8bwgiRRSSecVr8kihzwKeEMRJZTxjg9UUk0Nn6in
kRba6KCLHkL00s8gz8FHGGOCSaaYYZ4nN4k4pQ==
       "], CompressedData["
1:eJwd1mk81Vv3AHAZSiSiUobHUJxLKZ0cdFHL1GB4hMzzkJkO52cImckcQpIp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       "]}, {Automatic}],
     Editable->False,
     SelectWithContents->True,
     Selectable->False]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.847938770995262*^9, 
  3.878714639954069*^9},ExpressionUUID->"2f54ed91-825a-48f4-a48f-\
0aba7f903e87"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"DSolve", "[", 
   RowBox[{"rceUstStav", ",", 
    RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690044707359375*^9, 3.690044721046875*^9}, 
   3.690044754328125*^9},ExpressionUUID->"f89c2ed4-b2d7-4fd4-9381-\
a4835a191be8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"resStrelba", "[", 
   RowBox[{"derT0_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rce", ",", "res"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rce", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"rceUstStav", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"res", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{"rce", ",", 
         RowBox[{"{", 
          RowBox[{"T", ",", 
           RowBox[{"T", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", "[", "d", "]"}], ",", "T"}], "}"}], "/.", "res"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resStrelba", "[", "20.1", "]"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.69004510465625*^9, 3.690045276484375*^9}, {
  3.690045309859375*^9, 3.690045316484375*^9}, {3.690045353015625*^9, 
  3.690045382484375*^9}, {3.690045430640625*^9, 3.690045444328125*^9}, {
  3.6900455263125*^9, 3.690045628140625*^9}, {3.69008314978125*^9, 
  3.690083208375*^9}},ExpressionUUID->"8305935b-890f-480c-8f7a-ccad93c715b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.6806256174966473`*^7"}], ",", 
     InterpretationBox[
      RowBox[{
       TagBox["InterpolatingFunction",
        "SummaryHead"], "[", 
       DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
        "Ready"}, 
        TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquarePlusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAA88dx3mtMWz7JvJIIAAA0QKm+gdgd
Cpk/1lMmw0fsLEAvlAOEtBeqP3W8lHsLvhXAj/RD6Atisz8Zf+reFexCwMyH
F2FrmLk/2CURKwX2VMCj2m5OyyrAPwckcz6j92LAZlmCWdBPwz9CWj3E41Nt
wEYlD0Y7uMY/iAHK2VLZdcCJpeQbvRDKP5GoP+gyzn7A0o3qXq4vzT9+uB50
3pqEwJzhtMECSdA/YD/Mm12ai8BSsIwKZt3RPzrPaJ1215HAOdkIyNRp0z89
shzLPa+WwK+oQXb2F9U/cEJ9Wq4kncAorBLbT6nWP55QcIEuRqLAMFagMFxc
2D9Owg+d6DWnwGpa0vpzB9o/8Ojmk000rcCmkpx7w5XbPx+wSjOsBrLAcXEj
7cVF3T+EJGx8FpW2wD+EQhUA2d4/4HJn2ZXNu8DOHg+X9kbgPzj/a3soYcHA
lijP3XId4T/B0I1taJrFwF9M2/+K5eE/V//K+pxuysBww0WafL7iP1c8vjYB
btDAglT8DwqJ4z82S7OQmh3UwK0SBUCdT+Q/snI+gfyD2MAfJGzoCSflP26C
KiHOXd7Ak08fbBLw5T+2xTDCI4jiwE7OMGj0yeY/aqv6P7f95sAiepQe3J/n
P+D6Ez8DZ+zA9z9EsF9n6D9M+PZxwUrxwBRZUrq8P+k/rSz7dX9n9cAyjKyf
tQnqP4xZE539HfrAaexYP7TP6j/lMFItQr3/wOefY1eMpus/s6V0sTqbA8Fn
bbpKAG/sP2Qdi31a4QfBLo5vtk1I7T/tC1Ax4JENwffIcP02E+4/kvVEyZUM
EsHYMMT+JdruP2Dk8y948hXBAex1eO6x7z/gNWtorSEbwZbguWapPfA/xLnv
9MeIIMHO9GdNyKrwP8U5mlcAfSTBkx8/EeoV8T/q4fE5ykkpwVhXvMLZefE/
0JrdACnGLsHBuGgwNubxPz6TwG+FCTPBKye7i2BL8j+rMQzi7zg3wSGsNsSN
rvI/e5aEso83PMG7WuG4JxrzPwosYOjJbUHBVhYym49+8z+cQe52dDpFwZT7
sTlk6/M/g4oSE5FJSsFf91q1O1b0P0Zh7VBmNlDBKgCqHuG59D90RsEZlrdT
wZkyKETzJfU/WnOg/B1hWMEJckxX04r1P+Xvi66PuF3BHdufJiD49T93YoKC
LGtiwSwjE67hEPY/VJ7RMV5qY8GaisyM
                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$6065#1"]& ]}}, {}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 1.5}, {-1.0179313556838192`*^7, 
                   20.00000051100213}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}], True -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquareMinusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAA88dx3mtMWz7JvJIIAAA0QKm+gdgd
Cpk/1lMmw0fsLEAvlAOEtBeqP3W8lHsLvhXAj/RD6Atisz8Zf+reFexCwMyH
F2FrmLk/2CURKwX2VMCj2m5OyyrAPwckcz6j92LAZlmCWdBPwz9CWj3E41Nt
wEYlD0Y7uMY/iAHK2VLZdcCJpeQbvRDKP5GoP+gyzn7A0o3qXq4vzT9+uB50
3pqEwJzhtMECSdA/YD/Mm12ai8BSsIwKZt3RPzrPaJ1215HAOdkIyNRp0z89
shzLPa+WwK+oQXb2F9U/cEJ9Wq4kncAorBLbT6nWP55QcIEuRqLAMFagMFxc
2D9Owg+d6DWnwGpa0vpzB9o/8Ojmk000rcCmkpx7w5XbPx+wSjOsBrLAcXEj
7cVF3T+EJGx8FpW2wD+EQhUA2d4/4HJn2ZXNu8DOHg+X9kbgPzj/a3soYcHA
lijP3XId4T/B0I1taJrFwF9M2/+K5eE/V//K+pxuysBww0WafL7iP1c8vjYB
btDAglT8DwqJ4z82S7OQmh3UwK0SBUCdT+Q/snI+gfyD2MAfJGzoCSflP26C
KiHOXd7Ak08fbBLw5T+2xTDCI4jiwE7OMGj0yeY/aqv6P7f95sAiepQe3J/n
P+D6Ez8DZ+zA9z9EsF9n6D9M+PZxwUrxwBRZUrq8P+k/rSz7dX9n9cAyjKyf
tQnqP4xZE539HfrAaexYP7TP6j/lMFItQr3/wOefY1eMpus/s6V0sTqbA8Fn
bbpKAG/sP2Qdi31a4QfBLo5vtk1I7T/tC1Ax4JENwffIcP02E+4/kvVEyZUM
EsHYMMT+JdruP2Dk8y948hXBAex1eO6x7z/gNWtorSEbwZbguWapPfA/xLnv
9MeIIMHO9GdNyKrwP8U5mlcAfSTBkx8/EeoV8T/q4fE5ykkpwVhXvMLZefE/
0JrdACnGLsHBuGgwNubxPz6TwG+FCTPBKye7i2BL8j+rMQzi7zg3wSGsNsSN
rvI/e5aEso83PMG7WuG4JxrzPwosYOjJbUHBVhYym49+8z+cQe52dDpFwZT7
sTlk6/M/g4oSE5FJSsFf91q1O1b0P0Zh7VBmNlDBKgCqHuG59D90RsEZlrdT
wZkyKETzJfU/WnOg/B1hWMEJckxX04r1P+Xvi66PuF3BHdufJiD49T93YoKC
LGtiwSwjE67hEPY/VJ7RMV5qY8GaisyM
                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$6065#1"]& ]}}, {}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 1.5}, {-1.0179313556838192`*^7, 
                   20.00000051100213}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}]}, 
           Dynamic[Typeset`open$$], ImageSize -> Automatic]},
         "SummaryPanel",
         DisplayFunction->(
          ButtonBox[#, Active -> False, Alignment -> Left, 
           Appearance -> {
            "Default" -> 
             FrontEnd`FileName[{"Typeset", "SummaryBox"}, "Panel.9.png"]}, 
           FrameMargins -> 7, BaseStyle -> {}, 
           DefaultBaseStyle -> {"Panel", Background -> None}, 
           BaselinePosition -> Baseline]& )],
        DynamicModuleValues:>{}], "]"}],
      InterpolatingFunction[{{0., 1.5}}, {
       5, 7, 2, {123}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
        False}, CompressedData["
1:eJxFk/szFAgAx5c8khM6a9GdcrcmhZplqTPluyfyqj2cLhdWp8S1RclF52Ly
mvVq0nHGeXSIJCZW64g88l6yXufVej9iubXsspG4ZvrhPjOf+fwFHz3vABcf
WQKBIPPRUML/2LixTmtcj7L81GTL+u50B2adDlISf6GZlh+CflrnNS0FKmxK
N1v1iFT4tB0iG5KpiJlwC6eaUpG/HjN8woqKFnWOma0zFYpW6os/BlBhF3gt
52oiFbE5bW7hT6lQi74YYjFohlTfD6mrckeh65D6dwnlGPKMKANMxjeQyv4Z
O3LPCukB6Qei/e0AfkaTEZ2OG2QeRaDpgoZhHqFG4Sw2f2MqR5j8DMeYo/E9
opvQoleqXbILxUrcl+0b393FkP9oYsP7KNS6PHRKeMzC3jDa2jPHFPS7UBrT
Tmah7XP1tvrMXBwIUyop1y5A1JxM6tOUItw4+MGyi1WCvxi32dxmNrSUHhi0
aD1HUllhVsMVDpQYDRp11eW4u5MfV727AhtsCaHyQiUCPVWCOewXYPhl+hYw
XiKvUrPojHwd9tYyyLbu9UhqzM+glb6CIleoYaHYiDs880RTzyaI+8Lkjcua
oWSXrPh7RCv2VT1RWnfmwuxwrbKXXgccs/tUmkSvcUFDoGpYx0NVwzartaUL
p+7sigt91o1uc2L84dQekLjW0X7NvWB4BoXnrPbhkSj3Np/cD0Fk701N1wFQ
SDv8nSIHEVxo4hfHHkLNCW/vxolhyHUneWyp8eFwqf6HY7QRJElFToEBoxiI
2+9YlDUGVdWCr8SXx8EerN13f2scZ3MGvjD+YwLvmEvaXONJpJspknybJoFt
XQ05zylMtpqrZ0umEP2AvtsyYRoGHpeV33w9g3b9sJ0hVTMIWEqRJ34/iz2V
xbJswSw4EU3b9Ii3cDs9srmgPYf3xNV1VukcHo59JtW3n4fVE7Lk1fg8ZgKP
L3uFCMA67ircVF2AocLVhbTHC+jkRc6ZYxGBaekzvf2LIF4sm7zu/y8qjNrH
VBSEcF+b5BdmCrFVuzFka7aEnNg9A9MdH3uQKKCZiBC0O9tPNUyEU2KjtyNt
IpAGK3yKiMuYr7ae/vWnZbzI7vK2L15GQozHBGl9GQzmnNes9QqOOAWNPr+/
AhkzgmckfwU92glvnA3EeLRFOr8/SIxbU7mDwloxbFuPnHupLIF2cdU/8eck
ECTZup7PlaD6Vm+PwZIEie5ezlKLVXjRFnhNMaug6AfTk3tWIbtrx2tv3TX0
Ce85Uq6sIa9Xh7vNWUNwRb5dp4wU9pkmLRlnpNCJqLFhpkmh8u1YDqdDik83
v8N/ldLe6g==
       "], {Developer`PackedArrayForm, CompressedData["
1:eJwl0Q1HnQEAhuG3TWlKKc3SlI5SmlJKKUsppZTSl1JKOVNK6ShGlDEiIiIi
IiIiIiIiIiIiIiIiIsaIGBF1ZQ/XH3juUDjSMRkVBMFc8H8fieET8SSSzGdS
+UoGIbLJ5RsFFFFCGRVUUk0t9TTSTCvtdNFDHwMM8YMRxpggwjQ/mWGWX/xm
ngUWWWKZFVZZY50NNtlimx122WOfAw454pgTTjnjnAsuueKaG265454H/vCX
R574xzMvvPLBwdHEEkcCSaTwhTTSySSLHPLIp5BiSinnO1XUUEcDTbTQRifd
9NLPIGGGGWWc9+BTvAH6BTW0
        "], CompressedData["
1:eJwdzmk41AsbBnA72bekVPbEKDHWnPQXKRGRNQ0xJFuiHHtJJxHKmqUUHVJH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        "]}, {Automatic}],
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.847938771135855*^9, 
  3.8787146401389227`*^9},ExpressionUUID->"467ff42d-9f4e-460a-9dab-\
a8f616a39217"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"resStrelba", "[", "T0", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T0", ",", "20", ",", "20.1"}], "}"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690045639328125*^9, 3.69004566425*^9}, 
   3.6900456968125*^9},ExpressionUUID->"9b8f1f18-3827-4ec5-bd1f-f386dfe2ddb7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"resStrelba", "[", 
    StyleBox["2500.65",
     FontColor->RGBColor[1, 0, 0]], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "d"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690045702796875*^9, 3.69004576675*^9}, {
  3.690083247828125*^9, 
  3.69008349196875*^9}},ExpressionUUID->"9aa450f4-3a55-4453-b8d6-\
6c71d55ac94e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd2Xc8ld8fAHCRSFkRoiShQdNKw+ckDUlRmZVZkuz7oJSikL2pzKisfBUZ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       "]]},
     Annotation[#, "Charting`Private`Tag$6129#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 20.000076550498495`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.847938771213962*^9, 
  3.878714640286022*^9},ExpressionUUID->"23c33c27-dcd0-44fd-9394-\
e8269707cc36"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"{", 
     RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Tvlevo", "+", "Tvpravo", "-", 
     RowBox[{"2", "Tzde"}]}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rceUvnitr", "[", 
    RowBox[{"trojice", ":", 
     RowBox[{"{", 
      RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"der2", "[", "trojice", "]"}]}], "+", 
     RowBox[{"qv", "[", "Tzde", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcesIn", "=", 
   RowBox[{
    RowBox[{"rceUvnitr", "/@", 
     RowBox[{"Partition", "[", 
      RowBox[{"teploty", ",", "3", ",", "1"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "rcesIn", "]"}], "+", "2"}], "\[Equal]", 
  "n"}]}], "Input",
 CellChangeTimes->{{3.69004616290625*^9, 3.69004622325*^9}, {
  3.69004628921875*^9, 3.69004639315625*^9}, {3.69004642625*^9, 
  3.690046508078125*^9}, {3.69004694071875*^9, 
  3.690046940953125*^9}},ExpressionUUID->"4a7ee25d-e0ac-4e93-b1b0-\
28d37e8f1601"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.8479387712920685`*^9, 
  3.878714640408387*^9},ExpressionUUID->"b425fcbb-f725-4442-8c2f-\
9ae113930c37"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceT1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], "-", "To1"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceTn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "n"], "-", "Ton"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690046633703125*^9, 3.6900467539375*^9}, {
  3.69008353121875*^9, 
  3.690083547*^9}},ExpressionUUID->"62f4da5a-7950-4f21-b274-b64fe14c1832"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rceSite", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rcesIn", ",", "rceT1", ",", "rceTn"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6900467973125*^9, 
  3.6900468335*^9}},ExpressionUUID->"6bd168ab-9917-4fcc-857c-2fe6903a053c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocTeploty", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"To", "+", "150"}]}], "}"}], "&"}], "/@", "teploty"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"rceSite", ",", "pocTeploty"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6900468523125*^9, 
  3.69004693203125*^9}},ExpressionUUID->"574939da-ac2b-4801-8c3d-\
e58227f30235"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], "\[Rule]", "20.`"}], ",", 
   RowBox[{
    SubscriptBox["T", "2"], "\[Rule]", "122.38935375114957`"}], ",", 
   RowBox[{
    SubscriptBox["T", "3"], "\[Rule]", "191.05360372779538`"}], ",", 
   RowBox[{
    SubscriptBox["T", "4"], "\[Rule]", "237.10020213204186`"}], ",", 
   RowBox[{
    SubscriptBox["T", "5"], "\[Rule]", "267.9778634116347`"}], ",", 
   RowBox[{
    SubscriptBox["T", "6"], "\[Rule]", "288.68150336180224`"}], ",", 
   RowBox[{
    SubscriptBox["T", "7"], "\[Rule]", "302.5602402097774`"}], ",", 
   RowBox[{
    SubscriptBox["T", "8"], "\[Rule]", "311.8591637397916`"}], ",", 
   RowBox[{
    SubscriptBox["T", "9"], "\[Rule]", "318.0825115817`"}], ",", 
   RowBox[{
    SubscriptBox["T", "10"], "\[Rule]", "322.2370017687524`"}], ",", 
   RowBox[{
    SubscriptBox["T", "11"], "\[Rule]", "324.99468418414864`"}], ",", 
   RowBox[{
    SubscriptBox["T", "12"], "\[Rule]", "326.80165451273206`"}], ",", 
   RowBox[{
    SubscriptBox["T", "13"], "\[Rule]", "327.95021677824417`"}], ",", 
   RowBox[{
    SubscriptBox["T", "14"], "\[Rule]", "328.626167817753`"}], ",", 
   RowBox[{
    SubscriptBox["T", "15"], "\[Rule]", "328.9388526523558`"}], ",", 
   RowBox[{
    SubscriptBox["T", "16"], "\[Rule]", "328.9388526523558`"}], ",", 
   RowBox[{
    SubscriptBox["T", "17"], "\[Rule]", "328.62616781775307`"}], ",", 
   RowBox[{
    SubscriptBox["T", "18"], "\[Rule]", "327.95021677824417`"}], ",", 
   RowBox[{
    SubscriptBox["T", "19"], "\[Rule]", "326.8016545127321`"}], ",", 
   RowBox[{
    SubscriptBox["T", "20"], "\[Rule]", "324.9946841841487`"}], ",", 
   RowBox[{
    SubscriptBox["T", "21"], "\[Rule]", "322.23700176875246`"}], ",", 
   RowBox[{
    SubscriptBox["T", "22"], "\[Rule]", "318.08251158170003`"}], ",", 
   RowBox[{
    SubscriptBox["T", "23"], "\[Rule]", "311.85916373979165`"}], ",", 
   RowBox[{
    SubscriptBox["T", "24"], "\[Rule]", "302.5602402097775`"}], ",", 
   RowBox[{
    SubscriptBox["T", "25"], "\[Rule]", "288.68150336180224`"}], ",", 
   RowBox[{
    SubscriptBox["T", "26"], "\[Rule]", "267.9778634116347`"}], ",", 
   RowBox[{
    SubscriptBox["T", "27"], "\[Rule]", "237.10020213204183`"}], ",", 
   RowBox[{
    SubscriptBox["T", "28"], "\[Rule]", "191.05360372779535`"}], ",", 
   RowBox[{
    SubscriptBox["T", "29"], "\[Rule]", "122.38935375114956`"}], ",", 
   RowBox[{
    SubscriptBox["T", "30"], "\[Rule]", "20.`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8479387713389316`*^9, 
  3.878714640508624*^9},ExpressionUUID->"3cd47de4-c102-4056-9d9e-\
85ed68392677"]
}, Open  ]]
},
WindowSize->{1003, 740},
WindowMargins->{{18, Automatic}, {Automatic, 6}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 387, 10, 98, "Input",ExpressionUUID->"3c543de1-32e7-4f15-b223-40e0b1159f85"],
Cell[CellGroupData[{
Cell[957, 34, 2108, 56, 532, "Input",ExpressionUUID->"94102320-72ac-4766-85ce-942075ccdc51"],
Cell[CellGroupData[{
Cell[3090, 94, 534, 12, 32, "Print",ExpressionUUID->"cac4b8f4-4b20-40d0-bf38-98b5bd85c7eb"],
Cell[3627, 108, 354, 8, 32, "Print",ExpressionUUID->"8578a546-1ddc-419a-ae89-a648385e93c9"],
Cell[3984, 118, 384, 8, 32, "Print",ExpressionUUID->"82825033-946e-41f4-a43b-112cf50c7c6d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4417, 132, 2736, 81, 531, "Input",ExpressionUUID->"a6995c93-cf85-433e-8af6-40006e960d00"],
Cell[7156, 215, 260, 7, 46, "Output",ExpressionUUID->"f01966d9-51f0-448e-b2cf-a9fc8b764afb"]
}, Open  ]],
Cell[7431, 225, 1283, 32, 266, "Input",ExpressionUUID->"57823c0d-70b6-4bcd-9fff-4a355a24bcd3"],
Cell[8717, 259, 2120, 54, 182, "Input",ExpressionUUID->"c502a010-7279-4a65-96d9-aedda76f1a67"],
Cell[10840, 315, 1216, 29, 192, "Input",ExpressionUUID->"2172b13a-cc6f-4da0-8dec-5926a7f6577f"],
Cell[12059, 346, 2313, 57, 238, "Input",ExpressionUUID->"7ec2568d-bc6c-43b9-874d-454e873b6d3a"],
Cell[CellGroupData[{
Cell[14397, 407, 774, 20, 70, "Input",ExpressionUUID->"2d5dea7a-b719-48e6-a6ae-e1e5bb33cfbb"],
Cell[15174, 429, 120911, 2972, 5782, "Output",ExpressionUUID->"45481f07-effa-47bc-a3cb-6371186cdb60"]
}, Open  ]],
Cell[136100, 3404, 389, 12, 41, "Input",ExpressionUUID->"e0f624ed-a30e-491d-9fdf-5c77e5ba12e7"],
Cell[CellGroupData[{
Cell[136514, 3420, 1586, 46, 154, "Input",ExpressionUUID->"19d1e58f-392f-4495-a670-3be4e58f50bf"],
Cell[138103, 3468, 19282, 364, 94, "Output",ExpressionUUID->"2f54ed91-825a-48f4-a48f-0aba7f903e87"]
}, Open  ]],
Cell[157400, 3835, 306, 7, 41, "Input",ExpressionUUID->"f89c2ed4-b2d7-4fd4-9381-a4835a191be8"],
Cell[CellGroupData[{
Cell[157731, 3846, 1628, 42, 182, "Input",ExpressionUUID->"8305935b-890f-480c-8f7a-ccad93c715b4"],
Cell[159362, 3890, 19089, 360, 94, "Output",ExpressionUUID->"467ff42d-9f4e-460a-9dab-a8f616a39217"]
}, Open  ]],
Cell[178466, 4253, 410, 10, 41, "Input",ExpressionUUID->"9b8f1f18-3827-4ec5-bd1f-f386dfe2ddb7"],
Cell[CellGroupData[{
Cell[178901, 4267, 602, 17, 70, "Input",ExpressionUUID->"9aa450f4-3a55-4453-b8d6-6c71d55ac94e"],
Cell[179506, 4286, 14638, 259, 342, "Output",ExpressionUUID->"23c33c27-dcd0-44fd-9394-e8269707cc36"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194181, 4550, 1473, 43, 193, "Input",ExpressionUUID->"4a7ee25d-e0ac-4e93-b1b0-28d37e8f1601"],
Cell[195657, 4595, 157, 3, 46, "Output",ExpressionUUID->"b425fcbb-f725-4442-8c2f-9ae113930c37"]
}, Open  ]],
Cell[195829, 4601, 558, 17, 98, "Input",ExpressionUUID->"62f4da5a-7950-4f21-b274-b64fe14c1832"],
Cell[196390, 4620, 271, 6, 41, "Input",ExpressionUUID->"6bd168ab-9917-4fcc-857c-2fe6903a053c"],
Cell[CellGroupData[{
Cell[196686, 4630, 439, 13, 70, "Input",ExpressionUUID->"574939da-ac2b-4801-8c3d-e58227f30235"],
Cell[197128, 4645, 2614, 65, 159, "Output",ExpressionUUID->"3cd47de4-c102-4056-9d9e-85ed68392677"]
}, Open  ]]
}
]
*)

