(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    139013,       2770]
NotebookOptionsPosition[    135403,       2708]
NotebookOutlinePosition[    135885,       2726]
CellTagsIndexPosition[    135842,       2723]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"2e2c8cd7-2a2d-43ad-ab75-fb52dbdd9b27"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"2", "*", "3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "1.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 3.689476074453125*^9}, {
   3.690042085125*^9, 3.69004208646875*^9}, {3.6900439293125*^9, 
   3.690043938546875*^9}, 3.69008213334375*^9, 
   3.690082312671875*^9},ExpressionUUID->"fd1896dc-8a6d-450f-a0e2-\
788e2bc12383"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a = \"\>", "\[InvisibleSpace]", "1.2648809523809523`*^-6", 
   "\[InvisibleSpace]", "\<\"  \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a = ", 1.2648809523809523`*^-6, 
   "  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.847938730153336*^9},ExpressionUUID->"a7e2f2a5-acd3-4ef0-a014-\
a9638573f7ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]x = \"\>", "\[InvisibleSpace]", "0.05`", 
   "\[InvisibleSpace]", "\<\"  m\"\>"}],
  SequenceForm["\[CapitalDelta]x = ", 0.05, "  m"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8479387302002*^9},ExpressionUUID->"dad18e9b-f673-4f66-a4ec-f27aaca4aecc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]tmax = \"\>", "\[InvisibleSpace]", 
   "988.2352941176473`", "\[InvisibleSpace]", "\<\"  s\"\>"}],
  SequenceForm["\[CapitalDelta]tmax = ", 988.2352941176473, "  s"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8479387302158213`*^9},ExpressionUUID->"769c9786-ca39-479d-997d-\
294f2463bc3d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]el", "[", "T_", "]"}], ":=", 
   RowBox[{"1.5", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.0005", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"proud", "=", "150"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Skolma", "=", 
   RowBox[{"Pi", "*", 
    SuperscriptBox["R", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obvod", "=", 
   RowBox[{"2", "*", "Pi", "*", "R"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "5.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Sigma]", "=", 
   RowBox[{"5.67", "*", 
    SuperscriptBox["10", 
     RowBox[{"-", "8"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV1", "[", "T_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["proud", "Skolma"], ")"}], "2"], "*", 
    RowBox[{"\[Rho]el", "[", "T", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QV2", "[", "T_", "]"}], ":=", 
   RowBox[{
    FractionBox["obvod", "Skolma"], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "*", 
       RowBox[{"(", 
        RowBox[{"T", "-", "To"}], ")"}]}], "+", 
      RowBox[{"\[Epsilon]", "*", "\[Sigma]", "*", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"T", "+", "273."}], ")"}], "4"], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"To", "+", "273."}], ")"}], "4"]}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"qv", "[", "T_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"QV1", "[", "T", "]"}], "-", 
     RowBox[{"QV2", "[", "T", "]"}]}], 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"qv", "[", "Tustalene", "]"}], "\[Equal]", "0"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Tust", "=", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Tustalene", "/.", "%"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}], "//",
    "Max"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690041981890625*^9, 3.69004201409375*^9}, {
   3.690042057671875*^9, 3.690042449171875*^9}, {3.6900425315625*^9, 
   3.69004260603125*^9}, {3.6900436025625*^9, 3.690043624921875*^9}, {
   3.690082154875*^9, 3.690082166859375*^9}, {3.6900822255625*^9, 
   3.69008225271875*^9}, 3.690082706984375*^9, 3.69008293615625*^9, {
   3.69008363284375*^9, 3.690083640453125*^9}, {3.69008383903125*^9, 
   3.690083876640625*^9}},ExpressionUUID->"b83d99d8-a1c4-47e3-bfab-\
a9dfeeaae529"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{"-", "846.9985434850007`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "190.55558261763312`"}], "-", 
      RowBox[{"505.19265909508243`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "190.55558261763312`"}], "+", 
      RowBox[{"505.19265909508243`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tustalene", "\[Rule]", "136.10970872026718`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.847938730293928*^9},ExpressionUUID->"a01e396d-1880-41be-b9a6-\
176a0e717134"],

Cell[BoxData["136.10970872026718`"], "Output",
 CellChangeTimes->{
  3.847938730293928*^9},ExpressionUUID->"b079c747-0232-4238-8346-\
52f2d69bea11"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", "To"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "\[Alpha]1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], ":=", "To1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], ":=", "Ton"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042772671875*^9}, {3.690043833125*^9, 
   3.690043840921875*^9}, {3.690082173234375*^9, 3.690082209984375*^9}, 
   3.690082289390625*^9, 3.69008241721875*^9, 3.69008247815625*^9, 
   3.690082961578125*^9},ExpressionUUID->"d6615cff-7d26-4760-b8c0-\
e4ce859e9e9a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "krok", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Tpom", ",", "odQV"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"odQV", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalDelta]t", "*", 
          RowBox[{"qv", "[", "#", "]"}]}], "&"}], "/@", 
        RowBox[{"(", 
         RowBox[{"list", "[", 
          RowBox[{"[", 
           RowBox[{"2", ";;", 
            RowBox[{"-", "2"}]}], "]"}], "]"}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Tpom", "=", 
       RowBox[{
        RowBox[{"1", "*", "odQV"}], "+", 
        RowBox[{"ListConvolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Fo", ",", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}],
          "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Append", "[", 
         RowBox[{"Tpom", ",", 
          RowBox[{"fTn", "[", 
           RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"krok", "[", "Tpolepoc", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.690042942125*^9}, {3.690043200828125*^9, 3.690043297484375*^9}, {
   3.690043448078125*^9, 3.690043451015625*^9}, {3.69004370228125*^9, 
   3.690043703796875*^9}, {3.690043903703125*^9, 3.690043904125*^9}, {
   3.690082271046875*^9, 3.690082276484375*^9}, {3.69008274721875*^9, 
   3.69008287409375*^9}, {3.690082914625*^9, 
   3.6900829280625*^9}},ExpressionUUID->"b26bcbf2-76f3-4985-be6b-\
aa604c71d7ca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"10", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"maxT", "=", 
   RowBox[{
    RowBox[{"Last", "[", "teppole", "]"}], "//", "Max"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.690043497046875*^9}, {3.690043647546875*^9, 3.690043650421875*^9}, {
   3.690043768484375*^9, 3.69004379325*^9}, 3.69004389503125*^9, {
   3.6900823911875*^9, 3.690082391453125*^9}, 3.69008250709375*^9, 
   3.690082973640625*^9},ExpressionUUID->"1762d504-b32d-4c94-80bd-\
10a7bea66b2d"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plotik", "[", 
     RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"nel", "=", 
         RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i", 
        ",", "tpopis"}], "}"}], ",", 
      RowBox[{
       RowBox[{"listpom", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
            RowBox[{"list", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"listpom", ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
         ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"maxT", "+", "10"}]}], "}"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{"tpopis", "=", 
           RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
          RowBox[{"PlotLabel", "->", 
           RowBox[{"\"\<t=\>\"", "<>", 
            RowBox[{"ToString", "[", "tpopis", "]"}], "<>", 
            "\"\< s\>\""}]}]}], ",", 
         RowBox[{"Joined", "\[Rule]", "True"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 3.68947628559375*^9}, {
   3.690042696609375*^9, 3.690042731078125*^9}, {3.690042921203125*^9, 
   3.69004292515625*^9}, 3.6900433693125*^9, {3.690043489984375*^9, 
   3.6900434928125*^9}, {3.69004366353125*^9, 3.6900436775*^9}, {
   3.690043744765625*^9, 3.6900437659375*^9}, {3.690043801109375*^9, 
   3.690043802625*^9}},ExpressionUUID->"14e04897-d01a-4a5e-a2be-9977a6216f53"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 3.689476362265625*^9}, {
   3.690043683015625*^9, 3.69004369415625*^9}, 3.690043805375*^9, 
   3.690044085796875*^9, {3.690047003421875*^9, 3.690047010078125*^9}, 
   3.69008234125*^9, 3.690082997296875*^9, {3.690083660390625*^9, 
   3.690083668109375*^9}},ExpressionUUID->"d7607734-1377-4710-a851-\
e0c70c5081aa"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"plots", "[", 
     RowBox[{"[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{
  3.690043991421875*^9},ExpressionUUID->"ab6d9f6f-e52f-4736-b940-\
166366216d94"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceUstStav", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{
         RowBox[{"T", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"qv", "[", 
        RowBox[{"T", "[", "x", "]"}], "]"}]}], "\[Equal]", "0"}], "}"}], "//",
     "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"okr2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"T", "[", "d", "]"}], "\[Equal]", "Ton"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"resNDS", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rceUstStav", ",", "okr1", ",", "okr2"}], "]"}], ",", "T", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "x", "]"}], "/.", "resNDS"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690044568703125*^9, 3.6900446249375*^9}, {
   3.690044659953125*^9, 3.6900446638125*^9}, {3.690044766109375*^9, 
   3.690044841265625*^9}, {3.690044872828125*^9, 3.690044930453125*^9}, {
   3.6900449689375*^9, 3.690044969515625*^9}, {3.690045002765625*^9, 
   3.690045050828125*^9}, {3.690083035390625*^9, 3.690083116796875*^9}, 
   3.69008368015625*^9},ExpressionUUID->"8ded1dd5-05a9-4f92-b464-\
5e7a6550396a"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot","sszero",
   "\"The step size in the search has become less than the tolerance \
prescribed by the PrecisionGoal option, but the function value is still \
greater than the tolerance prescribed by the AccuracyGoal option.\"",2,54,1,
   28822904883602776557,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.847938732808961*^9},ExpressionUUID->"2235fd92-03b4-4031-a025-\
b063e9a095db"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve","berr",
   "\"The scaled boundary value residual error of \
\\!\\(\\*RowBox[{\\\"1.2774911248668091`*^7\\\"}]\\) indicates that the \
boundary values are not satisfied to specified tolerances. Returning the best \
solution found.\"",2,54,2,28822904883602776557,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.847938732887068*^9},ExpressionUUID->"870e6e68-f249-4cdc-aa49-\
36165d2cb3b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"T", "\[Rule]", 
    InterpretationBox[
     RowBox[{
      TagBox["InterpolatingFunction",
       "SummaryHead"], "[", 
      DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
       "Ready"}, 
       TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquarePlusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}]], 
               GraphicsBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz5prTWMC05XwKm+gdgd
Cpk/4J2rrnpxYMAvlAOEtBeqPzoxatvtcGjAj/RD6Atisz+ClPbsumlxwMyH
F2FrmLk/yFDu9SQLeMCj2m5OyyrAP4I9ZQCDmYDAZlmCWdBPwz943M+vat6F
wEYlD0Y7uMY/FByNuZ5ajMCJpeQbvRDKP/Gak/aL65DA0o3qXq4vzT/oAa3r
h6WRwJzhtMECSdA/BV9wWQ2mj8BSsIwKZt3RPxggvU8HyInAOdkIyNRp0z88
JlkQIw2EwK+oQXb2F9U/xgNUqh+UfcAorBLbT6nWP7bc+rD/t3XAMFagMFxc
2D/xAzU7yTVuwGpa0vpzB9o/ibL6jvabZMCmkpx7w5XbPw9yoG9fs1zAcXEj
7cVF3T9bZKuXn3dUwD+EQhUA2d4/rC/RKcJ2UcDOHg+X9kbgPw+JYXwuJ1PA
lijP3XId4T9Fh08Q7uZZwF9M2/+K5eE/DoCvONODYsBww0WafL7iPx6oL+xp
bmvAglT8DwqJ4z9hbbiq0mJzwK0SBUCdT+Q/egUGf4qLesAfJGzoCSflP4WY
1+/0K4LAk08fbBLw5T/bxhhTEbiHwE7OMGj0yeY/fQgnflw0jsAiepQe3J/n
P+HZnuMOaJHA9z9EsF9n6D8gUkbZt1yRwBRZUrq8P+k/OVRoy0rujcAyjKyf
tQnqPxSRHd2G54fAaexYP7TP6j+lYSuOmmiCwOefY1eMpus/0HOrsV/yesBn
bbpKAG/sP71f0LiMpHPALo5vtk1I7T8Aby1NIhtrwPfIcP02E+4/hJrQc6vD
YsDYMMT+JdruP04Zn4h1RlrAAex1eO6x7z+0+A8Us0tTwJbguWapPfA/mjbs
9PllUcDO9GdNyKrwPyVxBDgQRlTAkx8/EeoV8T++4zphoTtcwFhXvMLZefE/
o5S3mlBJZMDBuGgwNubxP/egCmvk7G3AKye7i2BL8j9DzBqclgJ1wCGsNsSN
rvI/TvXNdB+WfMC7WuG4JxrzPyjJvHK4cIPAVhYym49+8z/S3t32+CuJwJT7
sTlk6/M/Ocjx02aGj8Bf91q1O1b0P3cqeyMDoJHAKgCqHuG59D9NwxD8av6Q
wJkyKETzJfU/eBg7ewKJjMAJckxX04r1Pw8yMB4Ig4bAHdufJiD49T+nD8dR
priAwL1aHNNvY/Y/xZRZ8C9GeMBe5z5tjcf2P4Fi7OMVjXHAop2Qwxc09z/f
Mf3zawVowOdgiAdwmfc/12Lwg+CWYMAI5Sz5///3P9eS7LeHTlfAmyfw3A==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$5969#1"]& ]}}, {}, {}}, {
                DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                 AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                 GridLines -> {None, None}, DisplayFunction -> Identity, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None, 
                   "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                 PlotRange -> {{0., 1.5}, {-1129.3827349693693`, 0.}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}], True -> GridBox[{{
               PaneBox[
                ButtonBox[
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEBitmaps", "SquareMinusIconMedium"]], 
                 ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                 None, Evaluator -> Automatic, Method -> "Preemptive"], 
                Alignment -> {Center, Center}, ImageSize -> 
                Dynamic[{
                  Automatic, 3.5 CurrentValue["FontCapHeight"]/
                   AbsoluteCurrentValue[Magnification]}]], 
               GraphicsBox[{{{{}, {}, 
                   TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz5prTWMC05XwKm+gdgd
Cpk/4J2rrnpxYMAvlAOEtBeqPzoxatvtcGjAj/RD6Atisz+ClPbsumlxwMyH
F2FrmLk/yFDu9SQLeMCj2m5OyyrAP4I9ZQCDmYDAZlmCWdBPwz943M+vat6F
wEYlD0Y7uMY/FByNuZ5ajMCJpeQbvRDKP/Gak/aL65DA0o3qXq4vzT/oAa3r
h6WRwJzhtMECSdA/BV9wWQ2mj8BSsIwKZt3RPxggvU8HyInAOdkIyNRp0z88
JlkQIw2EwK+oQXb2F9U/xgNUqh+UfcAorBLbT6nWP7bc+rD/t3XAMFagMFxc
2D/xAzU7yTVuwGpa0vpzB9o/ibL6jvabZMCmkpx7w5XbPw9yoG9fs1zAcXEj
7cVF3T9bZKuXn3dUwD+EQhUA2d4/rC/RKcJ2UcDOHg+X9kbgPw+JYXwuJ1PA
lijP3XId4T9Fh08Q7uZZwF9M2/+K5eE/DoCvONODYsBww0WafL7iPx6oL+xp
bmvAglT8DwqJ4z9hbbiq0mJzwK0SBUCdT+Q/egUGf4qLesAfJGzoCSflP4WY
1+/0K4LAk08fbBLw5T/bxhhTEbiHwE7OMGj0yeY/fQgnflw0jsAiepQe3J/n
P+HZnuMOaJHA9z9EsF9n6D8gUkbZt1yRwBRZUrq8P+k/OVRoy0rujcAyjKyf
tQnqPxSRHd2G54fAaexYP7TP6j+lYSuOmmiCwOefY1eMpus/0HOrsV/yesBn
bbpKAG/sP71f0LiMpHPALo5vtk1I7T8Aby1NIhtrwPfIcP02E+4/hJrQc6vD
YsDYMMT+JdruP04Zn4h1RlrAAex1eO6x7z+0+A8Us0tTwJbguWapPfA/mjbs
9PllUcDO9GdNyKrwPyVxBDgQRlTAkx8/EeoV8T++4zphoTtcwFhXvMLZefE/
o5S3mlBJZMDBuGgwNubxP/egCmvk7G3AKye7i2BL8j9DzBqclgJ1wCGsNsSN
rvI/TvXNdB+WfMC7WuG4JxrzPyjJvHK4cIPAVhYym49+8z/S3t32+CuJwJT7
sTlk6/M/Ocjx02aGj8Bf91q1O1b0P3cqeyMDoJHAKgCqHuG59D9NwxD8av6Q
wJkyKETzJfU/eBg7ewKJjMAJckxX04r1Pw8yMB4Ig4bAHdufJiD49T+nD8dR
priAwL1aHNNvY/Y/xZRZ8C9GeMBe5z5tjcf2P4Fi7OMVjXHAop2Qwxc09z/f
Mf3zawVowOdgiAdwmfc/12Lwg+CWYMAI5Sz5///3P9eS7LeHTlfAmyfw3A==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$5969#1"]& ]}}, {}, {}}, {
                DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
                 AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                 GridLines -> {None, None}, DisplayFunction -> Identity, 
                 PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                 All, DisplayFunction -> Identity, AspectRatio -> 1, 
                 Axes -> {False, False}, AxesLabel -> {None, None}, 
                 AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                 Frame -> {{True, True}, {True, True}}, 
                 FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                 Directive[
                   Opacity[0.5], 
                   Thickness[Tiny], 
                   RGBColor[0.368417, 0.506779, 0.709798]], 
                 FrameTicks -> {{None, None}, {None, None}}, 
                 GridLines -> {None, None}, GridLinesStyle -> Directive[
                   GrayLevel[0.5, 0.4]], ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                 Method -> {
                  "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                   AbsolutePointSize[6], "ScalingFunctions" -> None, 
                   "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                 PlotRange -> {{0., 1.5}, {-1129.3827349693693`, 0.}}, 
                 PlotRangeClipping -> True, PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
               GridBox[{{
                  RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                  RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                False, GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                GridBoxSpacings -> {
                 "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                BaseStyle -> {
                 ShowStringCharacters -> False, NumberMarks -> False, 
                  PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
             GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             BaselinePosition -> {1, 1}]}, 
          Dynamic[Typeset`open$$], ImageSize -> Automatic]},
        "SummaryPanel",
        DisplayFunction->(
         ButtonBox[#, Active -> False, Alignment -> Left, 
          Appearance -> {
           "Default" -> 
            FrontEnd`FileName[{"Typeset", "SummaryBox"}, "Panel.9.png"]}, 
          FrameMargins -> 7, BaseStyle -> {}, 
          DefaultBaseStyle -> {"Panel", Background -> None}, BaselinePosition -> 
          Baseline]& )],
       DynamicModuleValues:>{}], "]"}],
     InterpolatingFunction[{{0., 1.5}}, {
      5, 7, 2, {465}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
       False}, CompressedData["
1:eJwt13k01HsfB3AVlySVSCgiKalui8r+jiwtXFsLFVkqhEhIZF9uhRYhZG+7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      "], {Developer`PackedArrayForm, CompressedData["
1:eJwl04W3DwYYBuDfvbq78+ru7u68urk6r2Zquru7xrQxbYwxbYwxxhhjjDE1
xtSee3znPN8f8L7nDQkLD+0VFAgELkY8F4moxCA28UhIEpKTirSEkIms5CA3
+ShIEYpTirJUoDLVqEkd6tOQJjSnFW1pTye60oNw+jKAwQxlBKMYywQmM42Z
zGE+i1jKClazlvVsYivb2cke9nOQwxzlOKc4y/mIbLjMVa5zk9vc5T4PecxT
XvCKN7zjI8GyjUJ0YhGXBCQmGSlJQ3oykoXs5CIvBShMMUpShvJUoio1qE09
GtCYZrSkDWF0pAvdiSi8D/0ZxBCGM5IxjGcSU5nBbOaxkCUsZxVrWMdGtrCN
HexmHwc4xBGOcZIznOMCl7jCNW5wizvc4wGPeMJzXvKat3wgKDgQiEw0YhKH
+CQiKSlITToykJls5CQP+SlEUUpQmnJUpArVqUVdQmlEU1rQmnZ0oDPd6Elv
+jGQzxjG54xmHBOZwnRmMZcFLGYZK/mCL9nAZr7ia3axl2/4lu/4nhOc5gd+
5Cd+5hd+5Td+5w/+5C/+5hn/8C//8T740/gjEZUYxCYeCUlCclKRlhAykZUc
5CYfBSlCcUpRlgpUpho1qUN9GtKE5rSiLe3pRFd6EE5fBjCYoYxgFGOZwGSm
MZM5zGcRS1nBataynk1sZTs72cN+DnKYoxznFGc5z0Uuc5Xr3OQ2d7nPQx7z
lBe84g3v+EhwZPsnOrGISwISk4yUpCE9GclCdnKRlwIUphglKUN5KlGVGtSm
Hg1oTDNa0oYwOtKF7vSiD/0ZxBCGM5IxjGcSU5nBbOaxkCUsZxVrWMdGtrCN
HexmHwc4xBGOcZIznOMCl7jCNW5wizvc4wGPeMJzXvKat3wgKIr9E42YxCE+
iUhKClKTjgxkJhs5yUN+ClGUEpSmHBWpQnVqUZdQGtGUFrSmHR3oTDd60pt+
/A8VPeRK
       "], CompressedData["
1:eJwV2Xc8Vf8fwHF7ZdwiRBORjMho0ufQ4BtZ2WWvRIRQyt7zXiOr7Jm99/VO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       "]}, {Automatic}],
     Editable->False,
     SelectWithContents->True,
     Selectable->False]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.847938732949552*^9},ExpressionUUID->"ba9da1e5-6f32-4c8b-a163-\
faab8d5b5756"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVWnk8lN8btZRUSkWFJAlJtJFIPNGqBWMnW7Lv2dfsknVe4auI7EnWSCE9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       "]]},
     Annotation[#, "Charting`Private`Tag$6049#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.5}, {-1132.7048625639313`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8479387330432806`*^9},ExpressionUUID->"9ae0b22a-0532-4647-ab1b-\
7ce190b05e22"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"DSolve", "[", 
   RowBox[{"rceUstStav", ",", 
    RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690044707359375*^9, 3.690044721046875*^9}, 
   3.690044754328125*^9},ExpressionUUID->"ce361a12-23aa-487f-b57d-\
8bc8daf9518e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"resStrelba", "[", 
   RowBox[{"derT0_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"rce", ",", "res"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rce", "=", 
      RowBox[{"Union", "[", 
       RowBox[{"rceUstStav", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"T", "'"}], "[", "0", "]"}], "\[Equal]", "derT0"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"T", "[", "0", "]"}], "\[Equal]", "To1"}], "}"}]}], "]"}]}],
      ";", "\[IndentingNewLine]", 
     RowBox[{"res", "=", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{"rce", ",", 
         RowBox[{"{", 
          RowBox[{"T", ",", 
           RowBox[{"T", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "d"}], "}"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"T", "[", "d", "]"}], ",", "T"}], "}"}], "/.", "res"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resStrelba", "[", "20.1", "]"}], "//", "Timing"}]}], "Input",
 CellChangeTimes->{{3.69004510465625*^9, 3.690045276484375*^9}, {
  3.690045309859375*^9, 3.690045316484375*^9}, {3.690045353015625*^9, 
  3.690045382484375*^9}, {3.690045430640625*^9, 3.690045444328125*^9}, {
  3.6900455263125*^9, 3.690045628140625*^9}, {3.69008314978125*^9, 
  3.690083208375*^9}},ExpressionUUID->"b334e129-80d3-4545-acc6-7f8d63f7def5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1124.253676261307`"}], ",", 
     InterpretationBox[
      RowBox[{
       TagBox["InterpolatingFunction",
        "SummaryHead"], "[", 
       DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = 
        "Ready"}, 
        TemplateBox[{PaneSelectorBox[{False -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquarePlusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz7JvJIIAAA0QKm+gdgd
Cpk/8BED1QflLEAvlAOEtBeqP38twObA4BbAj/RD6Atisz/j6teJlpdDwMyH
F2FrmLk/5kj2kdzoVcCj2m5OyyrAP93fc26JC2TAZlmCWdBPwz96B/fY/T1v
wEYlD0Y7uMY/4If9jORkd8CJpeQbvRDKP/pGk89xg4DA0o3qXq4vzT8ANQ29
cPyFwJzhtMECSdA/rjhqBXipjMBSsIwKZt3RPwZe4NTBAJHAOdkIyNRp0z/l
rIm/mMWRwK+oQXb2F9U/osmK52fSj8AorBLbT6nWPwcv6H++zInAMFagMFxc
2D927x2+ilODwGpa0vpzB9o/AVmT91T2e8Cmkpx7w5XbP0GE2Rmh5HPAcXEj
7cVF3T83iATc+OhpwD+EQhUA2d4/1h7FtzjSX8DOHg+X9kbgP6LMI+Tyek/A
lijP3XId4T+NOap3ZmozwF9M2/+K5eE/3n6QEqcOGEBww0WafL7iP5kdiyK8
4jJAglT8DwqJ4z84b/Neef0xQK0SBUCdT+Q/QkaqDKfZE0AfJGzoCSflP0KV
pPb00DfAk08fbBLw5T8UTGo+KotQwE7OMGj0yeY/LM2bcaJyYMAiepQe3J/n
Px0z26+QUWvA9z9EsF9n6D/tXL9GkjB0wBRZUrq8P+k/KgkhX+IdfcAyjKyf
tQnqP/zaPWBttYPAaexYP7TP6j87O+n+uJ6JwOefY1eMpus/KKxSQq4FkMBn
bbpKAG/sPwfqop4zwZHALo5vtk1I7T+uoqcrrt+QwPfIcP02E+4/PNXZ8S0+
jMDYMMT+JdruP4dh2lUtG4bAAex1eO6x7z+efDfdBTeAwJbguWapPfA/vtJ+
n3Fsd8DO9GdNyKrwPzTlQLeZR2/Akx8/EeoV8T/Hj11ws3FjwFhXvMLZefE/
gSiHNqcmVsDBuGgwNubxPzyYcDqAIkLAKye7i2BL8j98+Bi293wPwCGsNsSN
rvI/U6+8OXVXLEC7WuG4JxrzP8Z3LH+m9TNAVhYym49+8z90nW2gKYQpQJT7
sTlk6/M/XWNFuYDLIsBf91q1O1b0P4Rkp/ZhpEfAKgCqHuG59D+29xIy/chY
wJkyKETzJfU/zw3JVKwFZsAJckxX04r1P4K19MKc53DAHdufJiD49T9eQwnY
hA15wL1aHNNvY/Y/tJxsJ/COgcBe5z5tjcf2Pxe7Q929OofAop2Qwxc09z+3
HeXN8O2NwOdgiAdwmfc/3bnuPnlekcAI5Sz5///3P5+HstcDkZHAj3LzEQ==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$6106#1"]& ]}}, {}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 1.5}, {-1137.3991681587006`, 
                   20.00000051100213}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}], True -> GridBox[{{
                PaneBox[
                 ButtonBox[
                  DynamicBox[
                   FEPrivate`FrontEndResource[
                   "FEBitmaps", "SquareMinusIconMedium"]], 
                  ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], 
                 Alignment -> {Center, Center}, ImageSize -> 
                 Dynamic[{
                   Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                GraphicsBox[{{{{}, {}, 
                    TagBox[{
                    Directive[
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1]], 
                    LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAA88dx3mtMWz7JvJIIAAA0QKm+gdgd
Cpk/8BED1QflLEAvlAOEtBeqP38twObA4BbAj/RD6Atisz/j6teJlpdDwMyH
F2FrmLk/5kj2kdzoVcCj2m5OyyrAP93fc26JC2TAZlmCWdBPwz96B/fY/T1v
wEYlD0Y7uMY/4If9jORkd8CJpeQbvRDKP/pGk89xg4DA0o3qXq4vzT8ANQ29
cPyFwJzhtMECSdA/rjhqBXipjMBSsIwKZt3RPwZe4NTBAJHAOdkIyNRp0z/l
rIm/mMWRwK+oQXb2F9U/osmK52fSj8AorBLbT6nWPwcv6H++zInAMFagMFxc
2D927x2+ilODwGpa0vpzB9o/AVmT91T2e8Cmkpx7w5XbP0GE2Rmh5HPAcXEj
7cVF3T83iATc+OhpwD+EQhUA2d4/1h7FtzjSX8DOHg+X9kbgP6LMI+Tyek/A
lijP3XId4T+NOap3ZmozwF9M2/+K5eE/3n6QEqcOGEBww0WafL7iP5kdiyK8
4jJAglT8DwqJ4z84b/Neef0xQK0SBUCdT+Q/QkaqDKfZE0AfJGzoCSflP0KV
pPb00DfAk08fbBLw5T8UTGo+KotQwE7OMGj0yeY/LM2bcaJyYMAiepQe3J/n
Px0z26+QUWvA9z9EsF9n6D/tXL9GkjB0wBRZUrq8P+k/KgkhX+IdfcAyjKyf
tQnqP/zaPWBttYPAaexYP7TP6j87O+n+uJ6JwOefY1eMpus/KKxSQq4FkMBn
bbpKAG/sPwfqop4zwZHALo5vtk1I7T+uoqcrrt+QwPfIcP02E+4/PNXZ8S0+
jMDYMMT+JdruP4dh2lUtG4bAAex1eO6x7z+efDfdBTeAwJbguWapPfA/vtJ+
n3Fsd8DO9GdNyKrwPzTlQLeZR2/Akx8/EeoV8T/Hj11ws3FjwFhXvMLZefE/
gSiHNqcmVsDBuGgwNubxPzyYcDqAIkLAKye7i2BL8j98+Bi293wPwCGsNsSN
rvI/U6+8OXVXLEC7WuG4JxrzP8Z3LH+m9TNAVhYym49+8z90nW2gKYQpQJT7
sTlk6/M/XWNFuYDLIsBf91q1O1b0P4Rkp/ZhpEfAKgCqHuG59D+29xIy/chY
wJkyKETzJfU/zw3JVKwFZsAJckxX04r1P4K19MKc53DAHdufJiD49T9eQwnY
hA15wL1aHNNvY/Y/tJxsJ/COgcBe5z5tjcf2Pxe7Q929OofAop2Qwxc09z+3
HeXN8O2NwOdgiAdwmfc/3bnuPnlekcAI5Sz5///3P5+HstcDkZHAj3LzEQ==

                    "]]}, 
                    Annotation[#, 
                    "Charting`Private`Tag$6106#1"]& ]}}, {}, {}}, {
                 DisplayFunction -> Identity, Ticks -> {Automatic, Automatic},
                   AxesOrigin -> {0, 0}, FrameTicks -> {{{}, {}}, {{}, {}}}, 
                  GridLines -> {None, None}, DisplayFunction -> Identity, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, PlotRangeClipping -> True, ImagePadding -> 
                  All, DisplayFunction -> Identity, AspectRatio -> 1, 
                  Axes -> {False, False}, AxesLabel -> {None, None}, 
                  AxesOrigin -> {0, 0}, DisplayFunction :> Identity, 
                  Frame -> {{True, True}, {True, True}}, 
                  FrameLabel -> {{None, None}, {None, None}}, FrameStyle -> 
                  Directive[
                    Opacity[0.5], 
                    Thickness[Tiny], 
                    RGBColor[0.368417, 0.506779, 0.709798]], 
                  FrameTicks -> {{None, None}, {None, None}}, 
                  GridLines -> {None, None}, GridLinesStyle -> Directive[
                    GrayLevel[0.5, 0.4]], ImageSize -> 
                  Dynamic[{
                    Automatic, 3.5 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}], 
                  Method -> {
                   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
                    AbsolutePointSize[6], "ScalingFunctions" -> None, 
                    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Identity[#]& )[
                    Part[#, 1]], 
                    (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
                  PlotRange -> {{0., 1.5}, {-1137.3991681587006`, 
                   20.00000051100213}}, PlotRangeClipping -> True, 
                  PlotRangePadding -> {{
                    Scaled[0.1], 
                    Scaled[0.1]}, {
                    Scaled[0.1], 
                    Scaled[0.1]}}, Ticks -> {Automatic, Automatic}}], 
                GridBox[{{
                   RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.5`"}], "}"}], "}"}], 
                    "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Output: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"scalar\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Order: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["3", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"Hermite\"", "SummaryItem"]}]}, {
                   RowBox[{
                    TagBox["\"Periodic: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["False", "SummaryItem"]}]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {
                  "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                 BaseStyle -> {
                  ShowStringCharacters -> False, NumberMarks -> False, 
                   PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
              GridBoxAlignment -> {"Rows" -> {{Top}}}, AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              BaselinePosition -> {1, 1}]}, 
           Dynamic[Typeset`open$$], ImageSize -> Automatic]},
         "SummaryPanel",
         DisplayFunction->(
          ButtonBox[#, Active -> False, Alignment -> Left, 
           Appearance -> {
            "Default" -> 
             FrontEnd`FileName[{"Typeset", "SummaryBox"}, "Panel.9.png"]}, 
           FrameMargins -> 7, BaseStyle -> {}, 
           DefaultBaseStyle -> {"Panel", Background -> None}, 
           BaselinePosition -> Baseline]& )],
        DynamicModuleValues:>{}], "]"}],
      InterpolatingFunction[{{0., 1.5}}, {
       5, 7, 2, {532}, {4}, 0, 0, 0, 0, Automatic, {}, {}, 
        False}, CompressedData["
1:eJwt2Hk01G0bB3BLRI+iLGmRiupJKrQivq2WSJvKUkikRQihUnksSSVUKNIi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       "], {Developer`PackedArrayForm, CompressedData["
1:eJwl1WP4EAYQB+Bs2/XPtm1rLdu2bXvLbbnVsm3btm279rbued5P9+3ufs8F
NGxXqW3gQIECRQ8S6P8KSghCE46IRPnZJxZxSUAASUlBatKRkSxkJxd5KUBh
ilGSMpTnNypTjZrUoT6NaEoLWtOOjnShO73oywAGM4yRjGE8E5jMNP5mFnP5
h39ZwnJWsZYNbGYbO9nDfg5xlBOc5hwXucJ1bnGXBzzmGS95w3s+8ZUfBDHg
4IQiLBGITDRiEof4JCIJyUlFWjKQmWzkJA/5KURRSlCaclTkd6pSg9rUoyFN
aE4rfi68A53pRk/60J9BDGUEoxnHn0xiKn8xkznMZyGLWcZK1rCeTWxlB7vZ
x0GOcJxTnOUCl7nGTe5wn0c85QWvecdHvvCdwO41GCEJQ3giEZUYxCYeCUlM
MlKShvRkIis5yE0+ClKE4pSiLBWoRBWqU4u6NKAxzWhJG9rTia70oDf9GMgQ
hjOKsfzBRKYwnRnMZh4LWMRSVrCadWxkC9vZxV4OcJhjnOQM57nEVW5wm3s8
5AnPecVbPvCZb0F+hT8oIQhNOCIShejEIi4JCCApKUhNOjKShezkIi8FKEwx
SlKG8vxGZapRkzrUpxFNaUFr2tGRLnSnF30ZwGCGMZIxjGcCk5nG38xiLv/w
L0tYzirWsoHNbGMne9jPIY5ygtOc4yJXuM4t7vKAxzzjJW94zye+8oMgweSf
UIQlApGJRkziEJ9EJCE5qUhLBjKTjZzkIT+FKEoJSlOOivxOVWpQm3o0pAnN
aUVbOtCZbvSkD/0ZxFBGMJpx/MkkpvIXM5nDfBaymGWsZA3r2cRWdrCbfRzk
CMc5xVkucJlr3OQO93nEU17wmnd85AvfCRxc/glJGMITiajEIDbxSEhikpGS
NKQnE1nJQW7yUZAiFKcUZalAJapQnVrUpQGNaUZL2tCeTnSlB73px0CGMJxR
jOUPJjKF6cxgNvNYwCKWsoLVrGMjW9jOLvZygMMc4yRnOM8lrnKD29zjIU94
zive8oHPfAv+6/EHJQShCUdEohCdWMQlAQEkJQWpSUdGspCdXOTlP651CMw=

        "], CompressedData["
1:eJwt2Hc8V98fB3CrjKxPg0SRETKyvy11LonKKDOikBEiM3vv7WNFUvbee3/e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        "]}, {Automatic}],
      Editable->False,
      SelectWithContents->True,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847938733168253*^9},ExpressionUUID->"aba7eb6d-e292-42af-bb3a-\
fe7cf6543edf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"resStrelba", "[", "T0", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T0", ",", "20", ",", "20.1"}], "}"}]}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.690045639328125*^9, 3.69004566425*^9}, 
   3.6900456968125*^9},ExpressionUUID->"8087a880-9f45-4140-8fc2-4ec32320626e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"resStrelba", "[", 
    StyleBox["1610.68",
     FontColor->RGBColor[1, 0, 0]], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "d"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.690045702796875*^9, 3.69004576675*^9}, {
  3.690083247828125*^9, 3.69008349196875*^9}, {3.6900837148125*^9, 
  3.690083806453125*^9}},ExpressionUUID->"c0e1ae59-eb5b-4349-b7b9-\
d1c5d5e122f8"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13c81d8bAHClovJNGWWTEKJlhMpzkhUNlb3ubdgjKTIzQtmulS0UiaKy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       "]]},
     Annotation[#, "Charting`Private`Tag$6170#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.847938733246359*^9},ExpressionUUID->"23344955-b2ed-40ad-8014-\
65c41512d530"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"{", 
     RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Tvlevo", "+", "Tvpravo", "-", 
     RowBox[{"2", "Tzde"}]}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rceUvnitr", "[", 
    RowBox[{"trojice", ":", 
     RowBox[{"{", 
      RowBox[{"Tvlevo_", ",", "Tzde_", ",", "Tvpravo_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", 
      RowBox[{"der2", "[", "trojice", "]"}]}], "+", 
     RowBox[{"qv", "[", "Tzde", "]"}]}], "\[Equal]", "0"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teploty", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["T", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rcesIn", "=", 
   RowBox[{
    RowBox[{"rceUvnitr", "/@", 
     RowBox[{"Partition", "[", 
      RowBox[{"teploty", ",", "3", ",", "1"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Length", "[", "rcesIn", "]"}], "+", "2"}], "\[Equal]", 
  "n"}]}], "Input",
 CellChangeTimes->{{3.69004616290625*^9, 3.69004622325*^9}, {
  3.69004628921875*^9, 3.69004639315625*^9}, {3.69004642625*^9, 
  3.690046508078125*^9}, {3.69004694071875*^9, 
  3.690046940953125*^9}},ExpressionUUID->"31a00bfc-d192-4102-8a87-\
7590d6bdcaf3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.8479387333713284`*^9},ExpressionUUID->"0d062baa-0a32-4315-a2fd-\
40358af58861"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rceT1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "1"], "-", "To1"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceTn", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["T", "n"], "-", "Ton"}], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.690046633703125*^9, 3.6900467539375*^9}, {
  3.69008353121875*^9, 
  3.690083547*^9}},ExpressionUUID->"661ac678-21c7-488e-9d02-a01389140904"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rceSite", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rcesIn", ",", "rceT1", ",", "rceTn"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6900467973125*^9, 
  3.6900468335*^9}},ExpressionUUID->"8f99145e-22a5-40d5-8e6f-67f756caec75"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocTeploty", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", "Tust"}], "}"}], "&"}], "/@", "teploty"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FindRoot", "[", 
  RowBox[{"rceSite", ",", "pocTeploty"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6900468523125*^9, 3.69004693203125*^9}, {
  3.690083929015625*^9, 
  3.690083931984375*^9}},ExpressionUUID->"aba93a7c-2c72-4aa4-b881-\
0031ee9a2fd2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], "\[Rule]", "20.`"}], ",", 
   RowBox[{
    SubscriptBox["T", "2"], "\[Rule]", "78.7267074334222`"}], ",", 
   RowBox[{
    SubscriptBox["T", "3"], "\[Rule]", "108.42060159570578`"}], ",", 
   RowBox[{
    SubscriptBox["T", "4"], "\[Rule]", "122.911458894384`"}], ",", 
   RowBox[{
    SubscriptBox["T", "5"], "\[Rule]", "129.85629090414545`"}], ",", 
   RowBox[{
    SubscriptBox["T", "6"], "\[Rule]", "133.15532020818952`"}], ",", 
   RowBox[{
    SubscriptBox["T", "7"], "\[Rule]", "134.71583386560084`"}], ",", 
   RowBox[{
    SubscriptBox["T", "8"], "\[Rule]", "135.45250219620604`"}], ",", 
   RowBox[{
    SubscriptBox["T", "9"], "\[Rule]", "135.7999226046531`"}], ",", 
   RowBox[{
    SubscriptBox["T", "10"], "\[Rule]", "135.96368404743413`"}], ",", 
   RowBox[{
    SubscriptBox["T", "11"], "\[Rule]", "136.04083367678749`"}], ",", 
   RowBox[{
    SubscriptBox["T", "12"], "\[Rule]", "136.0771224619627`"}], ",", 
   RowBox[{
    SubscriptBox["T", "13"], "\[Rule]", "136.09407712653677`"}], ",", 
   RowBox[{
    SubscriptBox["T", "14"], "\[Rule]", "136.10175679004973`"}], ",", 
   RowBox[{
    SubscriptBox["T", "15"], "\[Rule]", "136.10471807608536`"}], ",", 
   RowBox[{
    SubscriptBox["T", "16"], "\[Rule]", "136.10471807608536`"}], ",", 
   RowBox[{
    SubscriptBox["T", "17"], "\[Rule]", "136.1017567900497`"}], ",", 
   RowBox[{
    SubscriptBox["T", "18"], "\[Rule]", "136.09407712653677`"}], ",", 
   RowBox[{
    SubscriptBox["T", "19"], "\[Rule]", "136.0771224619627`"}], ",", 
   RowBox[{
    SubscriptBox["T", "20"], "\[Rule]", "136.04083367678746`"}], ",", 
   RowBox[{
    SubscriptBox["T", "21"], "\[Rule]", "135.9636840474341`"}], ",", 
   RowBox[{
    SubscriptBox["T", "22"], "\[Rule]", "135.79992260465306`"}], ",", 
   RowBox[{
    SubscriptBox["T", "23"], "\[Rule]", "135.452502196206`"}], ",", 
   RowBox[{
    SubscriptBox["T", "24"], "\[Rule]", "134.71583386560084`"}], ",", 
   RowBox[{
    SubscriptBox["T", "25"], "\[Rule]", "133.15532020818952`"}], ",", 
   RowBox[{
    SubscriptBox["T", "26"], "\[Rule]", "129.85629090414545`"}], ",", 
   RowBox[{
    SubscriptBox["T", "27"], "\[Rule]", "122.91145889438398`"}], ",", 
   RowBox[{
    SubscriptBox["T", "28"], "\[Rule]", "108.42060159570576`"}], ",", 
   RowBox[{
    SubscriptBox["T", "29"], "\[Rule]", "78.72670743342219`"}], ",", 
   RowBox[{
    SubscriptBox["T", "30"], "\[Rule]", "20.`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.847938733433814*^9},ExpressionUUID->"078932d5-93de-437f-a3b7-\
c63b3a196303"]
}, Open  ]]
},
WindowSize->{1003, 740},
WindowMargins->{{18, Automatic}, {Automatic, 6}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 387, 10, 98, "Input",ExpressionUUID->"2e2c8cd7-2a2d-43ad-ab75-fb52dbdd9b27"],
Cell[CellGroupData[{
Cell[957, 34, 2108, 56, 532, "Input",ExpressionUUID->"fd1896dc-8a6d-450f-a0e2-788e2bc12383"],
Cell[CellGroupData[{
Cell[3090, 94, 510, 12, 32, "Print",ExpressionUUID->"a7e2f2a5-acd3-4ef0-a014-a9638573f7ba"],
Cell[3603, 108, 326, 7, 32, "Print",ExpressionUUID->"dad18e9b-f673-4f66-a4ec-f27aaca4aecc"],
Cell[3932, 117, 364, 8, 32, "Print",ExpressionUUID->"769c9786-ca39-479d-997d-294f2463bc3d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4345, 131, 3101, 91, 559, "Input",ExpressionUUID->"b83d99d8-a1c4-47e3-bfab-a9dfeeaae529"],
Cell[7449, 224, 752, 21, 75, "Output",ExpressionUUID->"a01e396d-1880-41be-b9a6-176a0e717134"],
Cell[8204, 247, 148, 3, 46, "Output",ExpressionUUID->"b079c747-0232-4238-8346-52f2d69bea11"]
}, Open  ]],
Cell[8367, 253, 1283, 32, 266, "Input",ExpressionUUID->"d6615cff-7d26-4760-b8c0-e4ce859e9e9a"],
Cell[9653, 287, 2120, 54, 182, "Input",ExpressionUUID->"b26bcbf2-76f3-4985-be6b-aa604c71d7ca"],
Cell[11776, 343, 1216, 29, 192, "Input",ExpressionUUID->"1762d504-b32d-4c94-80bd-10a7bea66b2d"],
Cell[12995, 374, 2313, 57, 238, "Input",ExpressionUUID->"14e04897-d01a-4a5e-a2be-9977a6216f53"],
Cell[15311, 433, 827, 21, 70, "Input",ExpressionUUID->"d7607734-1377-4710-a851-e0c70c5081aa"],
Cell[16141, 456, 389, 12, 41, "Input",ExpressionUUID->"ab6d9f6f-e52f-4736-b940-166366216d94"],
Cell[CellGroupData[{
Cell[16555, 472, 1589, 45, 154, "Input",ExpressionUUID->"8ded1dd5-05a9-4f92-b464-5e7a6550396a"],
Cell[18147, 519, 450, 10, 61, "Message",ExpressionUUID->"2235fd92-03b4-4031-a025-b063e9a095db"],
Cell[18600, 531, 454, 10, 61, "Message",ExpressionUUID->"870e6e68-f249-4cdc-aa49-36165d2cb3b7"],
Cell[19057, 543, 33659, 601, 94, "Output",ExpressionUUID->"ba9da1e5-6f32-4c8b-a163-faab8d5b5756"],
Cell[52719, 1146, 19955, 346, 325, "Output",ExpressionUUID->"9ae0b22a-0532-4647-ab1b-7ce190b05e22"]
}, Open  ]],
Cell[72689, 1495, 306, 7, 41, "Input",ExpressionUUID->"ce361a12-23aa-487f-b57d-8bc8daf9518e"],
Cell[CellGroupData[{
Cell[73020, 1506, 1628, 42, 182, "Input",ExpressionUUID->"b334e129-80d3-4545-acc6-7f8d63f7def5"],
Cell[74651, 1550, 36705, 650, 94, "Output",ExpressionUUID->"aba7eb6d-e292-42af-bb3a-fe7cf6543edf"]
}, Open  ]],
Cell[111371, 2203, 410, 10, 41, "Input",ExpressionUUID->"8087a880-9f45-4140-8fc2-4ec32320626e"],
Cell[CellGroupData[{
Cell[111806, 2217, 646, 17, 70, "Input",ExpressionUUID->"c0e1ae59-eb5b-4349-b7b9-d1c5d5e122f8"],
Cell[112455, 2236, 17355, 304, 336, "Output",ExpressionUUID->"23344955-b2ed-40ad-8014-65c41512d530"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129847, 2545, 1473, 43, 193, "Input",ExpressionUUID->"31a00bfc-d192-4102-8a87-7590d6bdcaf3"],
Cell[131323, 2590, 135, 3, 46, "Output",ExpressionUUID->"0d062baa-0a32-4315-a2fd-40358af58861"]
}, Open  ]],
Cell[131473, 2596, 558, 17, 98, "Input",ExpressionUUID->"661ac678-21c7-488e-9d02-a01389140904"],
Cell[132034, 2615, 271, 6, 41, "Input",ExpressionUUID->"8f99145e-22a5-40d5-8e6f-67f756caec75"],
Cell[CellGroupData[{
Cell[132330, 2625, 460, 13, 70, "Input",ExpressionUUID->"aba93a7c-2c72-4aa4-b881-0031ee9a2fd2"],
Cell[132793, 2640, 2594, 65, 159, "Output",ExpressionUUID->"078932d5-93de-437f-a3b7-c63b3a196303"]
}, Open  ]]
}
]
*)

