(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    235447,       4252]
NotebookOptionsPosition[    233765,       4215]
NotebookOutlinePosition[    234247,       4233]
CellTagsIndexPosition[    234204,       4230]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"www", ".", "profitableinsulation", ".", "com"}], "/", 
        "media"}], "/", "20499"}], "/", "prorox"}], "%20", "sl", "%20920", 
     RowBox[{"cz", ".", "pdf"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Lambda]", "=", "0.04"}], ",", " ", 
    RowBox[{"ro", "=", "100"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"www", ".", "profitableinsulation", ".", "com"}], "/", 
        "media"}], "/", "20526"}], "/", "prorox"}], "%20", "wm", 
     RowBox[{"%20960", ".", "pdf"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"\[Lambda]", "=", "0.044"}], ",", 
    RowBox[{"ro", "=", "40"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Lambda]Izolace", "=", "0.048"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roIzol", "=", "40"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cpIzol", "=", "2100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roCpIzol", "=", 
     RowBox[{"roIzol", "*", "cpIzol"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm", "=", "0.001"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cm", "=", 
     RowBox[{"10", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "2.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dIzol", "=", 
     RowBox[{"10", "cm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Sdeska", "=", 
     RowBox[{"2", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "b"}], "+", 
        RowBox[{"a", "*", "c"}], "+", 
        RowBox[{"b", "*", "c"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vvzduch", "=", 
     RowBox[{"a", "*", "b", "*", "c"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cpVzduch", "=", "1000."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tloustkaDeska", "=", 
     RowBox[{"3", "mm"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vdeska", "=", 
     RowBox[{"Sdeska", "*", "tloustkaDeska"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rocpAl", "=", 
     RowBox[{"2700", "*", "896."}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"roVzduch", "=", 
     FractionBox["349.", 
      RowBox[{"273", "+", "20"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pmax", "=", 
     RowBox[{"12.5", "*", "230."}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Pmax", "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"0.5", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"Tanh", "[", 
            FractionBox[
             RowBox[{
              RowBox[{
               SubscriptBox["T", "1"], "[", "t", "]"}], "-", "90"}], "0.1"], 
            "]"}]}], ")"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"To", "=", "20"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.682665067669345*^9, 3.68266522709122*^9}, {
   3.68266549174747*^9, 3.682665493231845*^9}, {3.6827440004375*^9, 
   3.682744013234375*^9}, {3.68274432103125*^9, 3.682744328734375*^9}, {
   3.682744484296875*^9, 3.68274449575*^9}, 3.683437876109375*^9, {
   3.683437966703125*^9, 3.68343799803125*^9}, {3.68343803590625*^9, 
   3.683438055140625*^9}, {3.68343866859375*^9, 3.683438788359375*^9}, {
   3.683438857640625*^9, 3.683438953921875*^9}, {3.68343914203125*^9, 
   3.683439142578125*^9}, 3.683439261359375*^9, 3.683439473125*^9, {
   3.6834398455*^9, 3.6834398665625*^9}, {3.683439998046875*^9, 
   3.6834400018125*^9}, {3.68344008884375*^9, 3.683440091828125*^9}, {
   3.6834405913125*^9, 3.683440591546875*^9}, 3.68344063709375*^9, 
   3.68344091584375*^9, {3.6834411123125*^9, 3.683441124890625*^9}, {
   3.683441172625*^9, 3.683441179234375*^9}, {3.683441212171875*^9, 
   3.683441226421875*^9}, {3.683441333375*^9, 3.683441442984375*^9}, 
   3.6834427244375*^9, {3.694324619296875*^9, 3.694324644109375*^9}, 
   3.69432492484375*^9},ExpressionUUID->"ed9a9890-1d67-44a5-9cbe-\
218ea578d53c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nDeleni", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dVrstva", "=", 
   FractionBox["dIzol", "nDeleni"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mcpVrstva", "=", 
   RowBox[{"dVrstva", "*", "Sdeska", "*", "roCpIzol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rocp", "=", 
   RowBox[{"rocppom", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Vdeska", "*", "rocppom"}], "\[Equal]", 
       RowBox[{
        RowBox[{"Vdeska", "*", "rocpAl"}], "+", 
        RowBox[{"Vvzduch", "*", "roVzduch", "*", "cpVzduch"}], "+", 
        "mcpVrstva"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Rthvrstva", "=", 
   FractionBox["dVrstva", 
    RowBox[{"\[Lambda]Izolace", "*", "Sdeska"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rcei", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"mcpVrstva", "*", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "i"], "'"}], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["T", 
         RowBox[{"i", "-", "1"}]], "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["T", "i"], "[", "t", "]"}]}], "Rthvrstva"], "-", 
     FractionBox[
      RowBox[{
       RowBox[{
        SubscriptBox["T", "i"], "[", "t", "]"}], "-", 
       RowBox[{
        SubscriptBox["T", 
         RowBox[{"i", "+", "1"}]], "[", "t", "]"}]}], "Rthvrstva"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceUvnitr", "=", 
   RowBox[{
    RowBox[{"rcei", "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"2", ",", 
       RowBox[{"nDeleni", "-", "1"}], ",", "1"}], "]"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceDeska", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rocp", "*", "Vdeska", "*", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "1"], "'"}], "[", "t", "]"}]}], "\[Equal]", 
     RowBox[{"P", "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         SubscriptBox["T", "1"], "[", "t", "]"}], "-", 
        RowBox[{
         SubscriptBox["T", "2"], "[", "t", "]"}]}], "Rthvrstva"]}]}], "}"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceKonec", "=", 
   RowBox[{"{", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          SubscriptBox["T", 
           RowBox[{"nDeleni", "-", "1"}]], "[", "t", "]"}], "-", 
         RowBox[{
          SubscriptBox["T", "nDeleni"], "[", "t", "]"}]}], "Rthvrstva"], 
       "\[Equal]", 
       RowBox[{"\[Alpha]", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["T", "nDeleni"], "[", "t", "]"}], "-", "To"}], 
         ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"rceUvnitr", ",", "rceDeska", ",", "rceKonec"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "\[Equal]", "To"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rce", ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["T", "a_"], "[", "t", "]"}], "\[RuleDelayed]", 
       SubscriptBox["T", "a"]}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"5", "*", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"rce", ",", "pocs"}], "]"}], ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{"nezname", "[", "t", "]"}], "]"}], "/.", "res"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68343906875*^9, 3.68343921065625*^9}, {
   3.683439243140625*^9, 3.68343939628125*^9}, 3.683439427515625*^9, {
   3.683439487734375*^9, 3.68343951625*^9}, {3.683439618796875*^9, 
   3.683439618984375*^9}, 3.683439691921875*^9, {3.683439738546875*^9, 
   3.683439792484375*^9}, {3.683439884734375*^9, 3.68344044759375*^9}, {
   3.6834405636875*^9, 3.683440573*^9}, {3.6834406895*^9, 
   3.683440699453125*^9}, 3.683441473796875*^9, 3.694324850921875*^9, {
   3.6943260795625*^9, 
   3.694326104171875*^9}},ExpressionUUID->"cd6aa55a-71db-4a75-a4a7-\
b5b4be35dc56"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV03k01PsbB3A/uRFCSmVJckmLSllKkXeSEEnMl4piGFHKkshtQZIoKiSh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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk0lGscB/BylRYxCUmyRYUITSrr15IMFdW8L0KyhUqLQlc3QnJpUWhC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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0wk0lG0bB3BJSLa8acGbJZSipDEJ6Y9krzD3IMoytqKSNJRKtrxpUbYk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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#3"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0nk0lVsfB3CZkikRSaYjlKSSQ6b4RpEo4nlCKBkaXclbJ65bElIUQpLr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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#4"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0nk01OsfB3CpKHtjzZ6LUrpUYy/elrIWme83SiKDVEiuBulWTCUSZUto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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#5"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwdz3k4lAsbBnChEi2S7SBLkRTR6TXWuJEihzTvO4dCxp7qSJOmxYnQ5JCS
JWU5rVKkRDNjmVIOSpvMiJTlSNk+FSIlnPO93/dc13M91+96/rlvvcC9zBBp
KSmpInr/d13S8lQXLbG0l/r/ENB9O1C5R0UVWbGFs2fR7i9+mmGrsgIWZcoF
GrT9uZ4h71LN4ONWdfkk7c1ZomP6Kgy4tMxSPT2LgLlwRV5Yjg12FLsOOsgQ
UBxq8GlJBWStU16WziYwJzpmkMt0ggKvam2HHIFpeeKguspG3OaFbKycT+BL
zqBs1WsXaKTq5totJjCw6mK6T44bnu0w7merEuiqonRnfD2QvxqyKloEdhnM
9nqZ6ok/J7V8PZcRCPn091Ld0a3ot36oM8+IAFtQ9SGSSWLJH8bODDMCLOdI
jpLKr9hXPXDzhT0BzwVuVkFcL7zye3DVyIXu02IgxX/tjWvlnO2dngQQ0n6K
leODy6wKOUYQgSzHq9TzVDaS7tjPNz5JILNAsSIKAWDZUn41ZwmkycdoLh0N
wNt5rNaUSwRSJN49vzGDwFnsuEMkJBAXuDBykUooEk/ZahK9BGIeRTeX14fC
djTpCmOUwO+rBhlsbhh8hCer/GYIcL/Uztx5vRPaY5arlqiaY0/84ZPMnN0w
2GyaO+5iDuOtnOanqZGYTt/tdPauOdT2dX5eoMLFzAbS/EMWAxG5SfpNUVxY
NL43byxgoK7efHv6Ky6Opg2N1QsZ4GicrlfNPIhK2QMTHa0MNNba5eksOYwz
vty1F9QscEL1kuvaxb/jmXtztl6uBX74rWUWzYmDVJe1rPcNS+yUGS9+IZ0I
yzdbOSsk1qgaMBubpZ6GunNutRvH7FAguT6Vkp6Fee5JCSbxDlB25Dp9T8hD
dmvdBam7Tjh1OK/g09zLGDIwNY2tcIYk08hty7x8fGmL9vn4bhOSS7N6b0wX
wLhcwEyedMXC4Rm23f1CyMhG9m3rcwM5rDjtVFmMvDNkyMmv7ghW1D7Eiy+B
RGXPoGX7FkRlzz7wt3YpVMK9DWvbPKE2X7KeyCnDXE0n14ZXW6GbqvltxfRd
7JobkKZ3n4my+bhiIM2HctFBM4UaJpySg9315fgIsbh9YbyOiVDerat6ynz8
kMsbePSciVvR9p5axnxIjbPXhXcwYb0zqHCxLx8ajudv5k8xQTnc9JkW8WH8
2XnHNysSfdUv50zV8KEw+Grk7XoSB23HSycf89HqeYSsdiCRY7Fe7lszH8Ec
naTjriTembzkjw7xUWi85vbCbSQ4N8f8R0b5qInRuTPiS0LWSF1h+BsfHsW8
bRI2iZX6AQEfZQQQ9a/4JX0niQiNsQX9mgJImyWH3DhIQuq8WmWvngAe2ofY
VtEk0lVsgz8YCjDT/sLqdgwJgSKv6t06Abiz2McdeCSm56iFdbgJcFfmL/7K
NBKnj9sotW8VgEq65TOQQUJHmn3/jZcATsy4kowsEo4zN5a8DhLgs4tcWlku
iaQx64fiaAEiXDHX7BoJ7bVuPvw4AX706P8aeJ1EWYTPRFaiAOdKokR/FJLo
GIw29s0QIEHvhAX/Fok13ffO9xUJsPdUNzdTQELy3G7f1BsB1Bsf+UhqSYTK
b5nf9bcARmKqNrqexNQm/+sPe+m+zoo2Oo9J6NfGdvJGBcgr0TdgPSXBrXzo
qjhPiB4nv09xTSQ0ChyXGVgKMXvvl6NSHSRuv2fen2snxIblMmY7Okk46QV5
/8dJiM3svURFF4k9eQmnS7YI0e0qlxbwjkR1et0PqzAhbJJ6v5/sIxEUu7HZ
I0sIeY7C+JYREsXem48fGhciKFiNPzmLQnyy1rmvk0L0JlcfH5Gm4H3vcyHn
XyHibb8W98pQkNXNeLlHvhwDxFKdZ7Mp+PW3awToluM+P5ORMI/CQu5vpa6/
lGPNP9SyW4oUIjPOdGnkl2N4sMp3njaFjfWBo+cKy5GtSbm10Nb6RsiqlJRj
ZYe94SUdCg3b3xgtqipHw4jR3Z/1KOgtW3ZApqkcT3e5c9z0KUju3FX4OFUO
Tra2qscqCuaNrZb3yQp8H76QX2hO4YzXwOrSbRVYmVtpFcag8LF7UvuafwUK
eJ0Dyy0o5I9pzT61uwKidsOLOZYUlH4KEvsmVCD+mkrRURsKI0HD4dNlFfgn
Nk5dy4FC0eTcXBulSqxqdRU+dqOgbWA1U9lUiRgd91AzfwqiK/N3urRW4mqY
dXEFbW/dbklreyXyVi+PBZtChmbijbG+SrTdUXnpEUBBTqmFNJmpRE1Kgklo
EIUv/0QWXTKqwnB+aOKxMAqP2m54JcZXIbBLhbNzL4XfUtTLKEIE1+vZQwYx
dL+A1TPbrEXYn1rUfZF2GcPOxR8iTC83OfJTLIXv3UFd4b+IkFF4JU/hGIUE
8xL52GAR0pIX3h6Ko5Dd5RxUmCmC+lKPqFwehXqz/cr/jIvQ1SOR3EuhsLTl
Bfe64B5uPmx7vTSHQqL2fsaEaTXCVg34xZdS+PXQ2b6eMw/wp6nhkpQ6CrVv
NjbXJj6ExLdhf3UrhdOxcatDrGvwPjCJ39RLQWhAxB0frMGxnrFFC8bo/z1x
V+z1v7D83lTQwL90nvZbxFPvWrjzqvML5VmghqLSR9TrIM5pO6etwsKeqbuf
MlvqoFA/sdRDm4XyjLUOf/DqoWzn1Cq9goUyrZw8rw2PYLJGVHTChIVuE4eR
AxOPEL6aJ3y1joXd9mwHpWuPYV5fURpuxcJ1h105yYEN+F7Gqeq0Y0H1ednQ
1iVPcOVMSsY+JxbMN/Vt+Cp5gkZu1Xj/JhYSN3tn9fOewiJDN67AjQWGh2Ov
l/kz3Lys/G3Cg4Wzjmq2+WPPEPHE1G4dkwXDB6tO2l97DtOJnyL+Q7EQbmzU
Iwx5AcaT2rOpXizI5VxkFC9rhIz/TYP321h4m0oljEgasSnmov5rHxZ8ueOv
FdNf4u1IUXO1HwtJnHAlLGvCkaE+JW9/FpSKMsuFh5sgUvMM/YvNwtg2ATu3
rQmnuftc9ANZ+Oz+lWe4VoyxcXXKPYjuG1LfX/azGKnHau2YtNlHz7raEWJI
uZkZetFuLjZfwLIQQ/8SNcqmXaHAzYxfL8aDkA+7omjHPZm40ukqRrrZrPEc
2srO3x9kBIqxjmcR0kf7hW+Dnk6wGNXGWvJDtE9EnU8oChHDV+N98TDtyauW
m2p2ilFyTPPjd9pd0ocbP0eI0ZbouVUhmM73cLLDNVqMHaO55aa02W1P7Fp+
FyMwX9mGoK0xkn2JHSPG1LGYe5a0U3Ssgw/GifFir1GlA+3ImCND+YliKP08
kU3SNsra7G6WJEaPvdICb9o9tzRKRMliyA2uiPGlzeqs4khOiWHxaP32ENoL
vya/8ksV406rQ3047Yb5PozBM2KwbRzXRNCO0199PipdjNge+7Mc2ta2U5P/
ZojhXGXzg0v7v5nM1vA=
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#6"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd0nk4lIsXB3BlSZIQEmG4JLTpviZbfNFiqWjeGZSlsZV2SVNyrxpLokTI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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#7"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1Hs01PkbB3CprKQSjUKEUumiy35dQrwJJQnf71cURZgkJUlUkh9WIuUy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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#8"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwd1nk0lWsbBnAJTUjYmTKe5DP0xfFSSbokSTLsd78ilC2EUkm1I5WDSjlC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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#9"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd0Hk0VYsXB3AZKiIlM5leKqWiDhlKX1OmwjmOKESGqCRTtzxNSB6JohR5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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#10"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwl1Hk01PsbB3DZKyJbhYRLolV9x5b0RmUL850ZcaPsUUlIU5YrKkSKECWt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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#11"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwl1Hk41QkXB3BZIiKjKEtEFCGZfq4l8UVZw91ESLJFYeyKmRokkbImyVsG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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#12"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt1Ws0lAsXB3C5VXKLUI1rLxVS6DFyafqjFMJchKJyzTWNTFPoqCGJlEIq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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#13"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt0ns41GkbB3CktLZFSgqhNrUVlfY3Q1J9kUSY38w4LSrnnLITmojIcSKn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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#14"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwl1Xk01P0XB3BZe1SSUjGKPKhGKr++xlq9EdnGjJkJRSVb9mxJP1JD1sju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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#15"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hk01P0XB3BEPKKQLUso0l7qO1OW8kYUMcaMikxPdhJCmhLpQRIJ2crQ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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#16"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt03k0ldsfBnAZUjKUokyHXArNeQ/FrZ6ozNObUCjzHEJHImXqRGZRya1E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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#17"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1nk01VsbB3BCKCEiU1GhpJLb7yBFX5nHwzFHZYwyZOq4XsVFEsp0UEmT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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#18"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt0nk4lHsbB3BrSimmLCG0M9WR0zMTsnwpxJgyT0KhEJXI3iBSI85EdpKk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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#19"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwl0nk0lWsbBnBjIxUiU6YoKZV67aJwIclQ2RuZNiHKPGzOFqIUicxTkaSS
DkcytBEJmdIgL2k2JEckEtEg9b3Od6/1rHv91v3P89zXI+/sy3Dl4eLiKqLO
fN+bnC22XGSHDtd/RcA4o+akoigN8rz/968lRJC46B5oCGT/58msEb7qF3tx
st+NZ97DKpdT7LJMEHS3ZuG8e6st5OaY+yE3LiM6bw8lfquniWY4SS/YOm/X
sb7Vcl/oKNFy9p63I6d60I9hDgWd8Jfztg1L/6eh3AIOE/kJ3JQtDfxYwqIH
ISZ7uIyHspmgicZhthXSrtF9+ebv263EdfuFNUSztH8soGxwiauVT8MWfJvP
xS2hDNc38ZZZdkheJueznPJO1QqL/Fkm5DOHR0Qp06aTpL4xHbBZPJohQ1mt
1nPA8N4hKNi/+KNMOUPvmsXjREfINvgcoFFOy19RFQgndGv4XtlDOXlJuNTq
L074eEDX1pZygs9oePMVZ7SUMHv9Kcd1Wg94Mw4jHbfT4ynH0FoMxHhd8Kpz
6v1NymeythXcK3dBX4bGli7Kkb9zBY66uGLvmqz+OcoRzsv8losegQ9fge0m
bgLhLaFdlc1HoKJR/9uF8nGVEZoj+yg842qUr1IOTjiYtWidG+7nvNMaosye
bJwreeGGWZcPqWo8BAIPqjnZnHUHMyEnLJKyf3VOE7eGB35ua7Xuo+x1Kvgc
I8sTR+C4pJiXym9oaPynsRfOTBiEKvAROGpswbg264VkVht/LmWX4gaOSZE3
okSfj67lJ+AsvFniK9MHwu8X+FRSdmRnH88W9EWKq10LfQEB+9eL+3ff80Wb
s7LqDOWNdFbXw0Q/tMb+891+EYENvOv5ZYf9sFd8rFZ+MQEVTh8tAP4oTVOz
nKC8TmJfltQXf3A8bqcVLyWw9hHvY18jFu6dzIrMESCgGFY913iFBWbdk+eZ
ggQU3q1z8mIEIOHIRrHy5QTkUntT6gsDYMgS3EGuICBrkN60kjcQ/H7fFGeF
CEgX8CjXlgeCVDcvZa0ksMq/Z1xQlI2rvNI2kxIEfC7GKHYEsqFxxsYpWYpA
U7O6bcozNvgdbj/UXk2AJZnQLJYWhPGakP4mOQLtjdrZsiLB4FboOxOuTEBp
/CP5jhUMqae8kskqVH7i5xfmdQZD0CVUtmwj9V7vzyzllBB4n5/0kVWj/odY
rpGa0HH4mlrb52sS6IHpiSm/4zjyO6RtgxYBwvP7bU7HccD62dE6HQIDdWZy
mklhkBNNWiBkQEDLnfub3vIT0GmP3cM0I/DTXo1RuCACu5cJrI5yp/YXsND7
HC0CnS2mOUNeBOhne6K9jkRgMnfDfks/An+XxdRuaqHmFswxmyACBxcOKJdH
nUKP5quFv6MIlJak/Knhi4R1vbhu7nUCb5vdJC8RkTgdq+X7qIDAojfa6uEu
kVDnV4znKSbgwD/qgaZIbP+gZphWQUDAVv950+koVF/tD9N/QMCN92vRE55o
OGfPserGCORWv4o6tTkarwdbZfdNEnjpX+ewnRmNbHaE3OAMAaP+2BVXONGw
EhfsU+VSh0qtfGCg21nM3ll3dZOIOkbZB3ZKtcdAyE5i9oWmOnw+Fra5ZcbB
dM2FTJckdVQPb5niFk/GZXLw6Vk6Dc5NDNlPqsn4vXraoNeKhiW5gSbP9ZNx
IbYmR8OBBhurqmuFvslwXXqoi9uThu/NOhbmrclYXHHL4EUkDerX9nPy2CkI
KDHwSrhDQ4m9V5BhdyqqggRYk2u3I7/zxmxcSgaiR/PdRpbvwEo9tv7309lQ
nR7ULNLSRHxwdv7YwitQ0POUvMvehc609SYHFufhRE+xQRW/DmJLM/79+1c+
Esj+hr5OYNnnOUft2gKkXpp7sE1MD+afV/zSv1OES5rMyyph+nBZIXMs6tQt
6AvOzrp27kZgJv9ffTKl+MPV89hWaQ9WCXRqEVll4OMWKvlwwRByiVLf1v4q
x/3Jk0PqM3sRM6VZT4Zy8ORviZFWljFk1Ezsbkdw0DslYJJzzBhlPnYzGdEc
rOd0fQwIN8bbkdCNzFQOvkkdZUrHGmNT/90LQ4Uc3F0lIu1wxRidj7X9Z19x
wArdbRL11BiS+XoKSjsq4KHHHk9Yb4Iia+PIY18r8MdCTfMgaYJTsdLnp39U
IKC08MtMtwms744XsP5UQDoxaTj1tQn45FKfei2pxM0tnjn335vA/sMbSSe5
SujJ1YZOTZtgGdu71Mi0Eooh9o3XJUzhl5rUK5lXiez6S7WuDqZQb3++o9a8
Ct5ev7C51xRJVsMbSm2qwPIPCd4/YIpP/T9krh+qQmZNsZPHkCnypqT54z2r
UNb60PzCuCmEJQ6TzNNVKJ3l0nvy2xQThz+7/yqrQrdQ6LbLMvtQ+GPhxZ3C
d1Dgox/JzdwHGSWNuTsdd+DudyYws30fvOPEyyyIGoS8VR2TjtuP1d1P2Dc4
d9Ge1zMronUA0TIBtJnN98D16W2m5bMDOHgsfWggqQ7VN4rjzymbofHVnq7G
6HocmktUvuVihoQTERtcNRtQez9FpiXDDBVKRETkSAPuyZ18MHKfmt8le0/c
uI924R7FgTEzZL65STy0boRQk3RLvxAdFqOBKRPiTfiHy+zQB4IOr9nysbTu
JoRuq7h9y5yOylQ13bNRzUgUZWyK9KajTDor22p3CxacKvDjnKGjX1V34q+Z
Fthtfc54eZEOTx1HXeHrrShptipMKKbjhq5HVqzzA6QVxRg9r6dD7HHZKF2k
DTuWB8tv6qBD3XBo93RnGzrilw4q9NERbWyd8SHqIf4K/6V7a5QO2n69f63U
H+F4wTj74Qwd6XqrduVNPcJew52dV7gZWFenck7n+mN49HUK1CxhwH3j+oEK
1yfIDnhTfl6EgUVZl2lFCu0ImR186yzFwOtEi9MTne24X/+0eUyeASb764sV
KU+hu/i0zQFlBmJY7sJQ6EAYZ0qmUJUB4cK0yorgDlyseF90dCsDUzYcx4sv
O3Buhmd40XYGxvdNR61TIzH+mqgZ1WTghmvzh7KtJMzXsLf+ouwYlm6kTZDI
KVO/KrCTga4idUHL7SQa12h5qlKuWspOO6VFgmh4dM2HckTbzNUeIxKWfm9K
P1NeafC9LtWZhLy3g82nXQw8YT6Ql3Uh0YXPQ7OUzwReOF3oSiJezd17qRYD
P67tMGxwI+EtoOSqQrmXJ7h93IfEYnFRLjfKN+p/vDUKJSG7KGvoHWXHl23a
3cdJ1JRu5/tCWXIiM9cxnEQu9xdJLm0G4mQ1XYIiSKTSGrfJUPYLDxnNiyZh
5KotYkt5fYbxvi0xJA6WCv10ozxwU/JWTSwJk2GJ10GULXuqWZ3xJLTudEel
U142HfvMPpGEU14iPY/yAwE72kgSiVrpc2LllCMUN1wITCExaPzoWQNlzV2z
P/6kkvC0Mo/roPw/hqi9qg==
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#20"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt0nk0ldsfBnBj0hUyXUmoW4kk9J4Tih6K4pjOoUgqGUrm8SBDEVemjLm3
kwZThkqGDKlIxgbDq4GryNXNkFISl5Df667fXmuvvT7r+8d+1rP3OgcvljMP
FxdXMbWXzv0pmVIi4pq7uf5bBIwz7p/dIElHwP89v4IIlJY0hJW70n/+xhnl
q+nej17Ru/95RPla6mEOAyumfXmW3F9jpbBgZwbLKVWBJbtu5LfuSLLA4wIb
sSU7f363VmGCibqKAaUl21fU/OPNssS74NXWS7YNu3izvtwKmcJl+Us+YODt
KyZ5EEl5LFVuyhYrGVqObGtck83m5VnK+2oj191uG1hZbzDkpWxwhauFT8sW
JE+bDD9lOL9JPMA5DHML09sClHdurbS6MWeHlmvW236hTJ9KXvOv3VG0bins
EaGs/tBtcF/tMWwJVh+SpJyhn2P1PMkedXPenLWU02+IVvvjOAx2Je9UpJyy
InzN2onj2Bc9K7Gd8gXPsfCmLAdIyvj46lFO6LIZ9GA5QsN0MpdFOZbebCDF
6wTNulXzJyj/ztleWFvuBL2wlqfhlKN+Xhc66eSM+OogJw7lCAdhbxHJE2hJ
SZetoRzeHPKiqukEQh+PGPZTDlUepduzT0IlUlBbgJtA8IWDnOWKLui0mNan
UWZ/a1go6XYBt9JsqQtl/4Pqxw+dPwUfrxIyi7JPzdVGbi1XcFUuTA5Q9pQT
2lw06gqJtnUnN/EQcI8Mjmdx3BCb+sDHl7Lr0ND4D2N3qJq9t26ifNLYipUz
5w7as1o7eV4CTsX1FYxbHviRQzacpewgtm31dztPBKQMt45Stmdnhmau9EJa
3okiWz4CR3oFB/bWekEt8FH2C8oqTN8XT5O8EVo3UtrPT2ALrxK//Ig3BDoe
q/osI6Bc8Y7uBx+Im5HJQgIEFFebctZM+KCXsVh2dDmBTc94n3sZ+eJpmEWz
pCCBDWE1Cw1ZvvDNynR8TXn934rH3Vl+KLZqa/H/hYBCWn/qoyI/rEkx6mQJ
EZA3uNgoweuPQxnz/2ivJCBbyLP5Ybk/zndIXVMSIfCrT9/4Skk2DMoP9p8T
p/q6HLuh05+Ny3Jp/B0SBBqbaLapL9mwfTjZsEmKgK/MhSap9EBU9a4znpcm
8GSv9lzPZCDy51ZtOy1D3e81pHbZMgh3RzI/8MkSaG/QzZQXD4ZQ0vIvkCew
cfwj+bdvMLKds5jfFKj3lv5DILcrGJVyA3kl66k+PL74bk49jZzdLtutNlH/
Seq6kfqqUBzu3ie4Q5VAH0zOTHqHwtI7RcVCjQDhNnO3ojMUJVqyemwNAoN1
FgrayWH4vkxUbZROQOcU97/6ImfQ660YcgoEfhxRZxUti8A+11ah5weofv0E
POLpEWh/ff5+iQ0B5vm+GPcTEdAOmm/OOkygoCz2oWozNZ9vqy04TuCgwODm
8uhI8Lk65+/3JFBakrp4ny8KXXeVGA2xBN42uchcIaKgw9g9eSKRwPI3urRw
pyiU7UlbJpVC4Cj/mCsao7Bc8efWjD8JCNnued14LhrCAV/KZAsIuPB+v9XG
EwONu/tliCcErtf8FR25LQas4jEJnTYCPT51R3fYxcD4TbecOUnAaCBONKsi
BqZBYcoX/qL6e7jO39/lPNblhhazPxIYY5vvXNMeC/GLE+8+rKTB82PRE5dL
CWhurXJ8b0vDjazk7LXNCXigf1B96hgN/TbskK5vCVAZ5Tkt7EyDeYve1l0m
ifitRdPM2osGtdyeZJHFRPDWmtchioaJI8tsKp2SUOOs/NPlDg01I2qT3NIp
SHXRtGhcQYdDI0v+09YUfMrmSkoVpWPFdX/G6z0pQH9PzQkpOg5ZV+cUeaXg
cnx3pcJ6OmaadltZtqTg44ZBRq8WHbQcs4pcdirGHQqC7FzpKDniHrjvVRqm
iZJQpw46bnTlzyWkZqCJKdb6KX8HJPTZe2bOZWLMTOnF3XItJAZn3vgskIWd
hjoaBzp2oitdiWEumIurIuHDb6GLuNKMDwXzN9A7/3HHekdA+MuCve7DQqzr
Hz8ww9GD5RfR+T33bqHkXnDYsWl9OInKBUVH3oGmsBuZpLcX/pf4A97JlYJ+
7Zk5I94Avwp16RCcMkj6Dcf5TRlCIWnNv5vmy2HdF+R71ng/Yie1H5EhFSg2
KvlxvdYIt2yMo4K+V6JOvs5DRYaByDjZP6ZmK9FVXxbcJceAzYPxQt/FSqQ5
PZcO+I0BPoW0DvcVVWhki0uUqDBwZPiNzHGFKsRcyNu4oMuAMNuj1MikCoK5
izpTDgx4pyX3y+RWYb/lslaPAgZo7a81H1pWY7HxUc0mZRMkW49sKT1UDUuv
1702qib4NDArl3esGgpsl+YYDRPkTsryJ7pVoz2ER/SttgnEVjuSdueqQRrW
vTvKMMFXxy+n5suqIeqn977TzQRFswKXd4rdQ6f+dc2IIhPIbdRauNd5D8Ux
5Zo98qbwSJAusyLuw/3DD7nsQVOsfdXGzq94gMOCC4VKl8wQI+dHn95Wi9tO
I2qxNHMcDLo4NJhchxZm5eaySnM0/GX4oiHmEZTu1/cUrbbAhTMRW5y166Gw
XfImx9QClRuJiKjReghqxFs5hlDzB2T/mfzHWJTdaDGTb4FLb24TT20acLyo
QILVZgGrMf/Ur9KNqCuNd7w5YQH3ufLP6a8aYTFa8PHKKiaq0tT1zkc34Zjc
nT53FSbKZDmZ1nub0TdRlpJqyMTAVr2vAdPNyP3tw5VIOybcdtvrieW1YG1k
fNa4FxP5eq6cOIdWCLO464YjmZB6XjbGFH8Crm/paS9TmaDtG9o71fUEniVK
KbbZTMQY22QMRz/FVXPjVvs7TNDN9D9Y055BOW31q+EaJi7q/7ord/IZdrZd
8d/czIRinXL87rzncBPsXsbpYOKUitJgpXMb9nomVD/vYWI55xr91vp2dAep
JrwfYKI3yerc1652yG8Znb09zIQd+3u3aGoHKoLyz5qOMxHre0oM6zvx1tRB
7+0kE2JF6VWVwZ2AtsjLlhkmJg9V2F/u6QQpXsyVscDEuOlUtKI6CTuztoSr
3CzkOzcNl2mQUDL7J+cOZfuwi0a6BImz5Wrljyi/uEVbeWAHicd3AmsGKVf/
wk6P1CGhGaDgvomHhYgn09l9RiRkTn0+eouyhMFMXZoDiTSR75wyXhba7FrX
yTuRePMyrO4x5d/9/zxX5Ezi6+DNt12UZ3M099W7kMib5uaepNzPE9w+7kmC
1ToxocFH5Xs0+9YohIRaQG1gKWX7nie6r0JJtKlLba6nLPP10nX7cBLkTUOy
k3KCvLZTYAQJrSld4a+UvcNPj+XGkLhQOKKhys+CUoaxqVosiaC1DkU6lAdv
y9y5H0dCOrZdxpTygb4a365EElecEofcKAtPxb08kkRCynFIL4Ryq9Bh+mgy
CTf27ow4yhEbtvzpn0pi6MPl95coa++am11Mo/LM/FQqpPw/BNvInw==
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#21"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hk0ldsfBnCEzCRKlKEUJYXec0qFR8hQ4hUlQ6FDSMhwylUOIkTmlEO3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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#22"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwt1Xkw1d8bB3BEhEpEshYJaVOfey0V71BC4dolsn6T7K6LEskuhWupkIhk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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#23"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hk01G0bB3AGkUQbiUfaZKss/WZE4ps12WbsZEsmS2SJkbJkIksiS0Qq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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#24"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJw103c01m0DB3AzI1tJCBUZLfK7b6NHvlZCcpsRepCVZLuljIhkZOcpo4go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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#25"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJw11nk01c0fB/AQIiJLRCIlUpKn771F0TtrUblda1mSrpLIdrsSkT37fsvS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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#26"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJw11Hk01VsbB3BDUi4qUzJXZqnU7xwh+hLJfDqIUCFKMsVxSkTElVkcMhUy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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#27"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt1nk01VsbB3BjZMqQKKHJUFTU7yAZvqbMOSFkKjokmZ0OIiISKfOQoYhS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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#28"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt1Hk01N8bB3BLSrIUKqW0UYlCPjOylLc9hAkxRIkhlS0mSylZx5Z1yFYp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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#29"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt1Hk01d8aBnBjJEoipBKZS1Lfc0LoQRLSMVMUiZJkPI6EikiGEEKGEBGh
UhRC5hRyKGkg9bvpF5eUkqK6W+vutfba6/Pfu9bzvFvGxdvSjYuDg+MBufPv
zgtZy5cs09jG8fdQmBOgAiXEdoD7/7Yx9PETEbPFq/LFf20uZKp5kGWHfwzl
/trkmTzHnef2+HbZ8q8NsznaeTT3Qjb4xl/D7dV5mwwHXK/ZzznvrapV1oWz
jqh/ks41b/q3RKnvjvsx4FjBM2/1uqPvjOqdQGnI8887VT/fujPBGR4SmULz
TikUvsfEARSGTovN+4LASalVnw8grNdddt7xXmMnW/NcIFfrQc07rtf+3THL
g3A2HjGbdzS9zXA5tyucxyR95302Y3Nx/W1XdNR05s474neu4GFXN/z+uXN4
3mEui32WiB2C5ya3zZzEJ9uC++62HkLygszL8w5R+Uh3Zh2G48gmRS7ioHjb
DH5FdzQp3OudN+tL86+bz91x/kdsETcx01b9wJ5zR8ArHFbKQ+xbc7mFU9MD
t+SmPvISe60WVCr56IH1H4Td+Yg9w4NiLTOOYvUioY0LiT1GRiZ+mniiZ7LL
dBHxYRNry/xZTzzjH2wVInYtb6w0LT2G9qjAYmFiFxE1ya+OXpCZ5OQWJXZm
ZYVkCXljgVnekDjxvpcLh7fXe+N3t6XxSmLVnNo81hYfHNj/yFyGeL2FX9+j
BB8c69fjViRex63MK/2vDxgLMrxViVUq39D94QvNotsFFLHS4VT39nRftApf
qdAmVpQ0y5D67IusO/LFhsQKj7k7vY39cH2v6CUGsVxoza/mPD+87pVJ3ku8
Vs1XTeKnH4zNoq8dIpZ9q3jA09IfT89XjPoTr0keSnpQ4o/STsmj4cTShhdb
RLmZMH9fujWJePV302l3Byboqi5e+cQri7mU6m4zoR50WqyKWMqhes9SwQA8
6YLBI+IVQj6xbq4ByIjcKDBMLO47OCEkxkLCMtUyYU6SR2a0XA+TBT218IUb
iFtaaXuTnrLgMHcix4xYavJtgjUVCLwOOetN7LcivnV5SiD+HFran0zcsV1r
dmAqEK1WqVdriNd4j2zMtDoOvfRlgv8h7m7WzZJeFoTl1So/dbkoyE+Mst/6
BcEmV/CGD3GIRBpfQW8Q7m9otrlKrHLsk59S0gkMvfHvEecm/UzLvDb6+QT6
gkV7bIgHGo2GSi2CMZzEkEgjPrs811h9aQisfvE+W8tDYRC7Tk35hMAv562f
NzF1dOZOZU8Idm3XvF5P/K7BfI1WYijEI5s13HkpaI7O2cx9CkWKS8LtJuJE
0eLYesZJNGg1icosoKBzhPO7/pJTCHLg6/1InJJctp7X+xQq/MUsrPkojNbt
cWnvPoWj/z0610S8a+GLEXmj09ijOyNZxk/h5z51y5IFYXhRFKBQJUD64c93
LJYehlTnG40GiyhYnBuM8jwUhpKT17j6ia9VRNdtaAvDsJ/ddX4hCrZ875Ru
R4YjpW/lbNESCuEr7xmkVIajsj5J2VGYQpl6/P6A9+Hw37DVSWwpBR5HrZQt
hmdwsDBZIE2Ewq2bSX9qeSJwPskiYECMwutW9xXZVATkx1hfK5dT4H+lSzvp
GgEXCcu2dHEK+3nHPNASAQue9HAvSQqCew36W85EImTxdRWHVRTcub+WdnFF
4eNYZ4OuAoXcmheR4WpRSEhf/NpJkeTj27B/i2MUtBZ3fIpUomA8HCOcVxmF
nM2uC9+qkHzrZJhM93NYtmGnVZ8ahTEWY6tUdzSm+gN1SrTIvmygifb8jAYr
1P2rlDYFx/crxiMUYzD4tKo5SYdCp9XI5YnTMVA4PFyeAAqlG0O5mjbHQvL5
uo62HaTPoyUd7pfiICteZK1iTaEwL/HKqrY4BM+qto7bUBiyZwX3folD40iG
eZUdBUa7nqr2rvMY+sZbZetAYWPBQOKSP+ch4plS9NSFwud9C+yrXBMQ1v5K
t8WPQs2/G6c4JS5gg4aconsq+X9aLKX/q3oBaWrOcQ/SKQjkMk37DS5As7T0
+qpMCnvs7uWXeBNrzi4ZyaEw07rN2qr9AmSnOKgbxRRo+bsrC1hJuHfk0NSa
ego393kGGj1LBvPRgXTfUQr2mvH56mPJwM7WNsdxChxiN59IcabgT/l+l12T
ZP7OKcXJ9Skon73TrzFNYUIreCA9IgVOoqEeO7hoWCcRozm6+SLSr42MqUvR
UNhbNBuXlArv/U2xW8xpcBVsv2ZZkoqvBznMpq1okN0xYiPRlIqB1uyhajsa
sqvlbuZ/ToWDhrEbw4mGlNw81xrzNNDbNuXc9qIh3Cuz68PidBi1xXTsi6dh
n0BCjn7sJURK+JnIsGkQ1WcZzJzJwo5hJ76yg3QM7Mp+opiRhT6dyPub3OnI
smtxsLuZhVrfifFaTzrkjokwq15nQeNObe1AAB209PICJi0bvHacD7aeo8N2
YoT380g2Psk1Wl8toyMtw+7hR+McdB2f057+Scf5oKzCcb48sFXrfZfmbEFv
irIpY2EBtpa+H+1V1kTMrdT31+YKwSouFFZ+qYXFn34569YV44pcW+tYvDas
PgnPGVSXYi+vpO3KKF24Cq8+Hhl+A2Z5yUaTWgDzEm/Am9W3ULWxZnSYrgdx
wV4dKqMCSgV6pzgs9LEmQeq7wtxtXKQZfONzMkD0lNYDdnAl+urXa9dEb0ep
vUnE8a9V2N6wd6jhliFo3f0adVb30OOeK0Ov3oHV8pq/qnuqEcC7dolynRGO
xUlUWFO1+CLXv+9t6k6setbFKqq8jwb267XLPIwRtdqfPq1WjzEn/Uy1tSaw
PX5x5F1iA0K+lGvq1Jug+cWOvuaoBxgPFFi3xcYU8afC1rlpNWLN0C3dtj5T
VMlTYREfGyHq8Iu/zmAX4u+zh04VNUGh4ZYG761duPSqjHpk34z337Q07wqa
wXqMmTQp0QJh/RNhCw+ZwXP29njKsxaM9/g6pt0xw91kdb1zka0Q1WHmnJs2
Q8XKjCy77W2wfFpuN0jfjWFVvcmA6TZ8Gpm+MuC5G0e3OeuJXG3HhhNlygVZ
u1Gk55ER4/IQPDGG4TaPd2N5Z8WYxbIOCNfbDpz9shs0o5Ht33o7MJhoTauV
YCDKxD71Q+QjHImUFurQYIC+W/+9He0xfh5xfKNow8BFfXHtgqnHODvTYvPC
hwHFBpXYbVc7wa1wRkH8HANH1iu/q3LrgqfII9WaywzwZ+TQS2W70SQgEH+l
goGXCdZnJnu7IT3u+Mq+mQFH1tfnwklP0MIjFXe1j4FovyMikO1B1zvjMcu3
DIiUpNytCurBsQWBN73GGZjaU+mcOdCD2ItD4vo/GJgw+xapqM7GjPhMYhqn
OYrcWj9UbGJjKt45vZTYOfSisS7FRkDuptRG4r5SmpDNFjamu+UCxojvLWKl
hOuw4fyr+oEulznCOqavDBqzQdV6Jv1DLGo405DswoaxpaSuAo85uhwfyki7
svFeepGUFvFZZvqZEjc2WmcnJsyIf+RrGDW6s3GIKzs4gHiIK6h7wouNf4y4
lVuIix78eG0czIb1pdPPnXjJfAMdus9C2JA8GyjvT7xi8lKu80k2opbmeZwl
jpPWcg0MY4OplPWylNjn5Imxgig2TK3yLX4QK6eamG2MZoN3U+4ewQXmeFe2
4kZtDBuZ3z/ZSxPbDNb49Z5nw8chXceQePG3mKf7Eti4v+iHrD3xQ0EH+sdE
Nn633f/jQRwmty6dmcSGVuqHvlBiLe3ZH3+S2QgMD81JJP4fg+ogpQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#30"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Hk41NsfB3BLIqFIUkqphKK4fWds0ZvIbq4ldKMrDSHCNKYskS0Zyq4M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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#31"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11gk0ldvfB3CzMkSkDGW6ZGqgnnNMxdeUyHAzpaLkIpWMx5EyZB5DpoS6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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#32"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Qk0Vd8eB/DMKVKiDFHJkChD55qKvkjmWylDg/4SkWTqEhnKPGQmRRQN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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#33"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Xk0ldv/B3BjNKGBDokiSVHUc05IehsiwzlFxqRbIkNk6CSKQmTIFDIc
FJHiahShDBWJODmadEVRqShzbkX13ef+1u9Z61nPev3x7LU/e3+GZS6+1m5C
AgICr8jL/249kyMjuUB7s8B/D4XpWdQRmrQJ/t+2W/wC5kvbQUXj/wy3rgRb
jhOC54r/53TDApvWpD342zP8P6cVSVWysReWyh//85lZxxcvGd2LHXsTBflO
PDh4vDHfBdzKDCG+4zsc+nys90G+WkuE71jGwy0ywq7gZmbM4PsUZ31xbZkr
blbIzuI78nfeHHdXN2SkK0ryHe4i4ScpvR+3alfL8H384bGntxv3Q+/+a0W+
Q1Z9ZuwJdEePs4gG38GJdhxxVQ+4X4rT5ztw7MGv6y89cDIo1pZvtp3WXscY
T4SK6B/i27/6XIOgjhduRS7P4vugwpyVJZ+9MKtRp5lv74jg09acAyhf6yEq
SOzV3z/009wbH8c6tvHtbm5jXTDlDUXWtxK+Xa/eK7co9cGY/jVZIWKX+Wtl
J3YdRGEI7TzfewJzQnLm+iLoe66+MLHzPzPfGtf6YpA9PMW3xvk7+YEb/FBE
k+gSIVa3CnjakuSHZz6mb0WJVwuriSp+8sNY5A4pMeJV5W8Yh+CPY31TvuLE
K93TPZoy/TH1q0pkFrGqLJOzeNQfIs7yz2YTr3gs3OprFoD+exvezyVeHlr9
60F+ADa26GyUIlZe67+W9jMA6x/dfTOfWKlXda+39SE07crolCZemtqTUl9y
CD3XR9RliRW3nG1YKMzGOwX99/LECv9aTHo4sZHwZ/WMZcTyxUIra8rYWCXy
gKNCvNipynHenMOYeVezZBWx3Fy/026uh/GkTWCTJjGtbkVN1d3D2G/c5cQg
XuTfPTRXOhBL2PWSm/j3kx27vJ0diNbEgRlbiBsa6TtTngXibPnnB0z++iO9
STbUETgve2VtTxwgl9gok3YELhI69XuJm411pzrHj0D8Ug7Nhx+Pb79m9o4g
hAx3ewQTcx/o5yguCMa5zGUqZ4lVhgZ4vQHB6KVn/F3IzzdahlhhRzCifTp3
lxM/NTTatH/dUYya+ls28e/DZzhgZcpRvPH+Hf4PP38zsi8PjB6FNtNk7jBx
5z3TnlKrYwg6KTUtIkjyXybPTGteCJqdijfSibtheWLcLwSn1Ddf3kZMHfh+
q7w9BDEtvdcOEPfVbV+qmxyKK5bfmi4T6wxM204Ph+Lqz2UTzcTJC4tP1247
jszIF2NfiDd5Cv5rKHkCS363nNMWIvWbekVd1PcERFVc3fcSD9Q4ujRxT2Dp
JiWdeGLLma/6VUzDsO55t8Yn4iCFa4JiR8JAU2IfkBWmULA+Sv5TURhiR9kf
LYl/OmtZl8wIR69rJreaeMUhMZ/TjHBoNoft+EZsFdMd7b0/HOcPy5uvE6Fw
+WZszZqH4eh32lRbRvys6a9OyclwBF0Ls/lO/Oc1fXxEJQKl5vEJm0Up2In1
rSyLioDvgf2LXhBHyFcapZVHQCXoxgmVGRSuaCXuPvwhAlurHKqOEIvs0k3b
sOUkIlbntS0Xo3DjesqfOyKRaGw/XHJBnMLrRg+5XCoSSgqMJzNnUhDv0qcf
d41EyMZ9cmzi3aKDXmiIxLeRLAvrWRTm7DR60XAyClV/pJQYcyho+8qOXiyL
glmtTNRt4n2Rw7Oj30WBy3By0JtLofpqtoGZ0Sm4ewX5b5eg4CE8UdomFA2J
iWdWBVIU8qpfRUWsjUYCpmMY80g++Nft3rArGm27LSdbic3exknll0cjSVsi
TngByaeaZWy2Rwz0jA+uzZQm/YQtxlQ7G4OXxfI3t8hQ4Kz+qtJzLwbuqUVn
J4lncSpfmi6OxdjOGykuNAqDgds2LubGwj9jrH/fYlLva+gL23/GQrjqxpi6
PIVdH+S+RqrGIdOTfvIHceuO/nNDYXH4de0vw1wFCqWaoUL315+G2mh2nqQS
qb+BkmaPrHi4+Xm+vKBGoSg/+cKSh/GQrVR/fnEVhR6HwGMdY/E4fKf0dOlq
CtuaDDT0LBPAvSmi0ahBQbOwM1nyTwKqzewilddRGHWe4VDhmoSBBlnL9I0k
XukvmgfOJCGtRu2f53ok3lbezKW1SVgZ4AVZfQqeudzuhtnJ2CE1xfkbFF7N
5iStcUuGlePny7+3kPP/pDkuSDuDUWV7qb+syP8N1opfNM7g9sobCs+tyfnk
sS1eGJ3B+ujArywbCo72lQUlvmfQbPS1jWlP4XvjZpsdTWfQLbWqKMiZAr2A
VV4YmIKqrmdfIrxI/hz3602MT8Gi3m4VujeZVztT5gZfSMHDlx5Kgz4kn+e9
cGNyU+BJ+8vNxZ/0nzBnmUmVVCgLm0gcD6Jw3dn7iOnzVFTw8q56RlNw0Eks
0BpMxUX6KSGHWAoC0tefLBZMw4TT44Xmp8n5tY6rjqinIbVoUYBOEoUh3WOd
mZFpOCqo/sc4g8wDWpzOwPqziB6b5EpcJvfRcWkqPiUdzjlLU9xbyTya03TZ
uiQd2vt7HAWekH5u0m9Lu58Ox4lbnrk8CrlVy68XjKajTsp21/sXpD/k5btW
b8+At85l14u9pN4OZrd9lMhEvZL0rbF/ybyalXTe8HQWkvsWGFxTpUPO+Kql
eEEWGjXeLeSuoqMztO1HW3UW6OF1v0Y06LAZnW3jOJCFjtBEMSOKDvPOGHE/
Mw7s7KRaFhnQoV0U4Z8rlg3ferkjEU50LDQMNPp+MgfPfsrEbUsl61nmPlHl
5GB2imjStXQ6cuwbnOyv50DvVtvQfA4dy33msyte5yB/tLLyXR4d9MyrhWx6
LpQHx82uXKXDbqhfdLQ/F/tMVgu/aaEjg2P/6LPZeawJvt9yQ5SBhOCcoq9i
+XgjrPLnTiQDP6+s0RhfkI805a2Vm2MZ8OirL/uumI/gNPPBhwkMGFp8qBfW
zkfB25GKN+kMTMqv6ZL1yMejvK5S3WIGdtfXSZo8yofy+lrbNC4DmmLvgs7F
XMDgGvemR4s3oCNNzWLbzEIYDh8yb67bgLgb6R8uTxfBSrAitVdZBxLDv/bo
1xQj+4z6j/eputgxLDVtVFWKbKuAZDNjPbhKKQRFRVzDMvu/PyaMbQI7S/Tw
G4UbOLAzjH3wymYsmtOxieLcRFX8svH37cDSpMX/rpgug/2swTzZ+waIHdet
5x0rR1ZU6EAU1xClDuaRQRMV+GY6s0G+ywh07gvtmh2VUGG3lSXxjKGgovOr
qr0KcStT/Rtbt8AnnnbThrqDpeFrz6kVmmDJ87bAS+V3sWjBBwH7IFNEKxxi
TK6tRbihxZUN1FbYBZ3t70uuwwa7o++TO7biwSuTpw+i6xHr6iq7y8cMiSfC
V7vp3sPX/M+PA4bNUKFChUd+vgcpr6akChdzJN7l9Zy4dB8WLCuezVNzZHVd
oVocHiA0r237Oy0L2AyyU0ZoDWj78/O9eKIFvKfKvqY9b0CCotdB2hsL3E7V
MoiJakSTqICaqrIlbspzcuyNH6JupPJpgpsl3moYjByefAgLO6VKk1xLHNi8
x2D+xSa4Fffp53ItccnAixPn8ggXfkw8aP9tCZnWm4NWC5qxUDpyn4kqE3TT
fuNvHc0QbmKOVLCYiDZ3SP8Y1QKRCRsa15cJBsvwgz39MWxNdtctSmDirOEi
vcLxx+CI2PpeLWZCtW7V6c0XW3Gotetc6T0mPNXV+irc2hB2SV9w9ismxDnn
GaVKXDB9UpUzvzLxT5LNyZEOLmr2Hazt/M3ErsCJl1IpT5ArVbO9VJKF2ADP
+VBqx97ozNctS1iYX5J2uyK4HQv9pnjmq1gYdyzfk93ZjhWmSfPCGCwMMb9F
qWrxYP/xrm4dWLjk1vjx5joe+twiLg4Q7wk9a6ZP8RDiFjItbcDC01L6XNsN
PNBCtXy9iStnB6ZFbOLhklKWB82QhfDmyQvdZjw8/bKizNuIhYVbvteluvBA
Hz36YYYJC227Hi1TdOUhqHTGp7XEp9iZJ0vceIgufPvSgfhHgbbpPQ8ews/l
nSgh7hEK5g4d5GGlkO6IpSnZX/2P12bHeHBskXdO3Er219ms/zyEh51ybO0K
YrmRrLw9x3kQ+XZOsIc4XlHX9Ug4D625yc4aZiz4HT86WBjNg49om95jYrV0
c6ZmLA/TY8XRY8R9V+Su3YnjQXl+br2sOQu23dUBHQk8XNf+OO1OLPEt7plz
Eg+8zyyBJOJHc5wYn5N5EFo6NFpOHL58dSY7hYelmm2818S6elM//qTyMNN3
4rywBQv/Awzz1b8=
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#34"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Xk0VW0bBnBDZY6UWahIg4z7EEVXJBlOSTJUek9FFDIdpFCmzPN8kLFJ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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#35"]& ], 
    TagBox[
     {RGBColor[0.772079, 0.431554, 0.102387], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Xk0Vev/B/CQKDKFTNFAlBTZ5ySl3oYSzrnGRFIy65Kh45iSiGsMHUOc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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#36"]& ], 
    TagBox[
     {RGBColor[0.363898, 0.618501, 0.782349], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Xk0lPsfB/BsKdmyR2ghS4vkGSHpjRDG7YZC0UVjqQjT2EqJyL6NLRNF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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#37"]& ], 
    TagBox[
     {RGBColor[1, 0.75, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJw11Xk0VXv/B3BjUkSFRFEiRRlqH6HBO/NwukUy3NKVSwkZj4PMIvN0TDlI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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#38"]& ], 
    TagBox[
     {RGBColor[0.647624, 0.37816, 0.614037], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Xk4VesXB/DMc4MppFAkpVD7HEPR1xznlDJkSknGUoZOhpDomIVMmSNS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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#39"]& ], 
    TagBox[
     {RGBColor[0.571589, 0.586483, 0.], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwt1glUTfsXB/AGzXOakQwNlBL3Nr3wbSB1Q6WUBpJGmodbKdGtpEGlkeZZ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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#40"]& ], 
    TagBox[
     {RGBColor[0.915, 0.3325, 0.2125], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1Qk0lVsbB3BjKCJFQqYIKUPOMVX8zXEakRJKhqLB7KCQeZ6nMmU6Ra4h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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#41"]& ], 
    TagBox[
     {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJwt1gk0VH8bB3CpSMgSEZJKIXvNjKXoa29GG1EU/aVNUZYYRLbIVpaxhGQJ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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#42"]& ], 
    TagBox[
     {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJw11nk0VP0fB3CRrWzZt1ARolAzSMUbiZlQQlooeZBKWWKQyJo1y2SPbCM9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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#43"]& ], 
    TagBox[
     {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJw11nk0VW8XB3BDMkSmDEWiDKWU6lxTqq8prhQhpZCKXFGGUETGmzEzGTNG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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#44"]& ], 
    TagBox[
     {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
      AbsoluteThickness[1.6], Opacity[1.], LineBox[CompressedData["
1:eJw11gk0Vev7B3Bj5qFESJJCklL2Uan4mp3SQDTccBGuigzpiEznmIoyHEOc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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#45"]& ], 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw113k0VV8bB/BMSWaZkigZMpSGc4XCF4mrpEJRKvkh3mR2RRnuNVOGaxZF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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#46"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11gk0lVsbB3BjZEqkpAwNSCS656hcw998lDmKouuKIskYIdMxO2SWMdNB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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#47"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11gk0lO37B3BbFELZJVREkaWeQdq+iCGpVESpvF5EKjvZ931fs2YbkZdK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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#48"]& ], 
    TagBox[
     {RGBColor[0.922526, 0.385626, 0.209179], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11nlYjF8bB3AlQqtUkmRpsyeeSUK+rWNISCktJJWitO/7VEp706JV2vEK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       "]]},
     Annotation[#, "Charting`Private`Tag$2456#49"]& ], 
    TagBox[
     {RGBColor[0.528488, 0.470624, 0.701351], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11wk0lO37B3AkRHZKiEqSFultRpLla50UFdmX8gohlX3JkjVrdrJmibRQ
JIWSJRIhg6SS0uItlSXRQvW7n/7nP+fMmfM5c55n7rm+931dM6vtTxg7srGw
sHwmT+p1V0reMn5hZQ2Wvw8aTHXdPYVEzfD/DrPnc+cXdYIR7//ZLTwg3jjn
KA7+y/7Xm4w8+zuT3CHgeuSvN9S8VPKCB0LS7/+13ArDHIlpD+ypcGOlvO7h
oq4T+p4wZo799drg+l/3ijwxwhbJRllmi8cWsZ+eKHI2WER5zajcv27GXvgx
rM9OeVXaSGrTZS9cM4lZTFlaN6NVZJE37EZFOClLfdsz52ztDVUWliWUJS+x
rW+o9gYHw5qHsoR1naXgUh8cylfloyzO6x7v6OCDDP3bgpTFGtc11N3xgV/T
jCjl5R4vJnhFffFbgV2C8vHc2LW93r4Y7ypYTbm1jW6VOuCLkfl0+b/3nxpN
MqH5walYahtlT/HEtmXpfhguClSn3KGjMj8044dN36f3/P0+J8YUcw/4gzdh
wJqyX3aqk221P5IC/I9T7rmnnictHIC3WzQjKctOjDNHPQPgMJCTTzlI7Cxn
SV8AYl58r6fcr6Wt5vTPScQOjwz/zePYpOf61JMIiH+8iJXK82zuxfHpk9hf
4KdIeaiZMVJuFIjmfKfDlLd8mhE+URUIbhHTfMqnlxXqbxUMwqMG1peUX8Dg
1Ix7EB6/osuzEdOOfr9R0xuEwTfMIMrxGSXjforBGHCuf0b5deP+VSrJwWjY
9UF7EfGO8QXThclgUifXOsrJIpfi7+4LAYe4kSo78Zi6aXPotRDoSnR2U1Zz
Yf2mxX8Kkq18JxYTp6dVbFp84hRW8Tuu5iAeb7C0b+85Be7SLWOUV31l69JZ
HorPioN3OYkNljwdk2WEIqllqJyL2F/qGiunXyjUD3RVLSE+vy1K8v2FUJha
Gjzipuq9y3p7x2AoZMxEOJcS/7TdanyZIwyP+MeteKn968V5LF4pDD+887v4
iI1iXkS7OYXhY738QQEqj/zqYsPMMOhcSxEUIr54PbZB4X4Ygj2H3gsTD7Qf
GuKfC8PtTskxUeI/w/SZKdlwaBRc4BEjNuN8vb46Khyle28NSRKHS9Zqp9eE
w+3VXKQ0ccXWxIM+78IRe4D/8BoqPz2HADPRCOy8keIjS8xuo5K+XTcCliGC
jeupPD0Eron5REBtfpfWJmKr02MdP0oicHCUh02RuKoy9c9t9kiE98ZqKRMP
tzmL59Mi8SZsTYcqMddzdXqIQyR+t/BkaRIfXPzRFa2RUGlaL2FAHCfeHLX6
ayQEA5sfGxHXbDlbyLY2CvnGnu/MiZdaaQ+2RkShdfUhQUdi5RMrpkuroyA/
GkBzIz4cOckT/SYKbmEu9V7E9VdzNfW1TyO3ZPGvCGo/3POw2eB1GiwVz5sS
iAWfMvx4zp/G1XKOuQxi50Vfy7vZotHPXnjvEnFh/dOo8C3RSG86daWaqo9H
48HtNtHwcmUsukus/ypOoKgmGrfqT/EPUPU96/7B9HU0jmWGdL6kPn+vWQs3
fwwyj3ixfaLOT8Nqb2/nGND3Os0tZqXB3pvTUD4jBmcer6wTJs7Z+Fl2pDkG
Txh0jjXE3Dm1TxgSsSRPeUMQf/Tdt1OiJxa8325MRBCvVaCL9P6MxXueGYdM
Ypt34p8j5eLgzmUbdom468DYuYnQODyr+1rPJGbn6fI7XxGH2cN7X44Rq7ZU
7bd4FofKxzK1C8TlisFsLdviwXU9L2MDGw1v/7N/7msXj74rJ4u0iCULdt3Y
eCYepXp67tbEZ3hFnDLG4nEyeaNjEvHx8csdztkJSJ2fEmRdRMOFouTilfcT
cDyZI1eaeMTCN7DvSwIcg9axaxDva9fcrGpwBselhaNCiRVLhpL5/5xBzLaq
Mj52kof1XZfWjYmYnWQ7SyMuFCrRCrBIhPGeoxHWxAJhJ76+rkrEy6TZf8uJ
p205LG46JOG6Y2WO1WJSb9FPikdTkjC29vCTGGL7LuaSVXeTYKzftbmW2CW/
50UrTzKKHv6hi3PQ8JQnJ0nBMRlKk4dEPxHXv1ecYRVLQXNzl3AnF7m+1Vj6
0+YURPcXa3AvIfkUeu8Z1E4B27nmq3uILc1rz18+kYKDfr/t+4i/t2mYHGhP
QWVDoP8kN1l/0b+hai9S4CNaIKzCQwMjOKJcbiYF7BNbuE8TZ9La2RekUmE+
tkx0zVIa6Of31pT4pqKkweGLKy85TyHuo4kJqUi771DXRBxplcobUJwK/eqK
L8v5SD8QHHQ07EnFe4239zuJPUNtl83JpmFFrqumlgANlbZufozHaSjbKdpz
UpgGix2J57d+TIONveu398QsopWPJFjTwV4dc8dChOTTNSM3tSkdUpUeMmqi
NEyoBA5lRaZDLHlD6YrlNGwUi9sxvi0D9F0cPjISNPTNXHEc0M/Adhsvt3Li
k4+6U+4eyoCb0X6Z7ZI0dJ4WHE+Nz0B4heQTo5Uk39msnJ1vMqAdwHYmT5rs
l76y+YTUTDzZbDYcs5YGh6XtF40vZ6LGxqNPVZbMb70xU7GWTFg+Hf7xhTi/
bm3l+elM+JRbvHOUI/28sMihfv9ZaH8QdHHaQM7j8dzu//iy0Dxi9ahfkQZc
rD9ZsS4LO+faH1zZSsPv0adyXupZ+NndKHj6HxoCTMXCfx/Lwq/5l1maNBrc
VTOURLuzANWgSwPbabDlTirQis+G96MDkm4aZN7rXDXgOp8Nl426bS4g/SG4
+0d3fTYODXcMuGjSYDLNY2I5ng1JnS2bPLRp2D0Uw+WunwNf66HhPAbpXxfC
PfI5c/Ht3ADdZT8NIlq+2t8j8nBk09PPzw+T+xnkP5LLyQP37qMcQo405Jm3
WptX5qHte6Xhbidy/o8Jed8czoPwJjHXZmeyX7KulnjT81EhLfW24xjp/xNj
i6fH8vFDr19ax5+GsznmDz7oF+DaJwX5l4mkX5SGmKywK0DzrfFM62Qy7ypL
X+3yLUDNSp0dz1LIvGmb+V5WXIBk6TSJkXQaaqeS5J3mC9Ax+NOEJZf8fpNx
0PUwK4RqSWvs1TLSDwLyLnzmLELPw5xnlS1k3lUobJ4RLkLxdKpXdivJ+3VT
9XfpIgQkj+dF3qdBa8+7pkXKReA1X1pg30nDnKTC8xXORfj6zthUrY/Mh6ZG
fr0HRVi156LUsdekP3C+8T8XU4xdPqwG19np6EuX37NvSQkW1yk6VuynQ1c/
rUpStASudgcj5A/QUftrYfn4qhLMFctOlZnScc6p922kcgnp0wLXr1jR4aLs
F1J/pATBLHqNPQ50sAy3VsneL4HNDVX18AA6FGTsxBbCS6H2pywxq4SOuKrM
dxcXLsCu315kL6sS+CZ/2ak3XEL/l0EboVYlHJgUWNCuK4flzl1PpW5sh4OA
lH9U+DU4SAiLdV1Rhnf2Yp+XUlV42xYYVFy1A8uX9qnRcq7D8m6czPRLFaxK
kvi2bqEaoVwJ96K4VBE7o9LEDKxB5VRPjoa5Gsotdkf6f72JfW97xn9cVge9
Z1C54UAtbCznVn2c0ICU7I5fdb11+FVF/9J+ATiWIHbdhHYbWwcd1ed1NLHy
cbdvWc0dtNTQ3A6OaSJayktpbstdHHqT0pDvrwUz/4yx18mNOIHQ/pxZLdx7
qtd/L7oJ+lfezQ+7ayPxVNhGR5VmCLf/I8j1VBs3ZWlhkR+aYaW75FoJXQeJ
d5gjp8paMBeYWmiSrIPs5xW0Tot7UGgOVswY1oHJR+/UKbFWzC9v95tdpwu3
+erP6Y9boZSwYsTNWRe30rZqxkS1oUnOuNe5QBfXJXPyzHXuo+Ig1zbBx7p4
tVlzymfuPuqrs0TE2fRwVMNOU6i0HYdY3MZ/yuuhTNM1J87+AV6vlOaf3q+H
ZV3XPxoJd8D2jFFQqYce6Iwxndm+DnAaPueITtFD9G6LzP+iOuF94/5dvXI9
KO3VemdOfwjt7V4JM/f0kKG1XLVk5iH2vB+t5H+uB7nGDfEapV34MprV6T2h
B5dN8q9vOnZDqUbjhgUrA1w5BUrla3qgkGKXNivIwLMkk4ipvh7wB+Y1/yfN
gI3v1ycCqY+gtVa0M2wzA7GeLkJY0wvdyeW5H5UZELqcfutmQC9kDBN2cWgz
MGNZY5c71Isdnr+T3howMGE4GyW3lYkWw28/NpkyUObY9t/1f5j4IxcmtJ/Y
LjhDX53GhHAZt4QXcX85ndd0OxOB5jsWaolreXzTw9WYcH3e80fbjIGwjrni
F/pMtEFWyNycARHd741p9kzw5fVmeFgy0G3zYLW0AxM2o8p3UolPe2dFXHZk
Ynt8ZH818Y/zyoxmZyZ2/no1MEs8whbQM3GcCcFJV5kAK7K+JvJPK5CJ0qtl
s0HWZH1DHeqPg5g44n58cz6x+FR2oV0IEyaWkWYNxAnSKg5+YUxYpdQG/SJ2
Dzn5sSSaXK/wZ0WwDQPymbsNFWPJ+3fnh/OIX1eIX7sdx0SsWXDKHWLTF/We
fWeYYEvZ8GiemG82bsA2iYlzVw5bSNgy8GCptdKHZCZsG1X7VYjD1m7M8k5l
wiXmjoYVsYrq/I8/aUx8avmQH0D8P8/GUUw=
       "]]},
     Annotation[#, "Charting`Private`Tag$2456#50"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
  AxesOrigin->{0, 19.999999999999986`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8479384200532284`*^9},ExpressionUUID->"1c3ae423-781d-48c4-ae8c-\
922a38badc4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Thlinik", "=", 
   RowBox[{"First", "[", 
    RowBox[{"nezname", "/.", "res"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"nezname", "/.", "res"}], "]"}], "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"To", ",", "0"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68344070834375*^9, 3.6834407454375*^9}, {
  3.683440788984375*^9, 3.683440823859375*^9}, {3.683441494578125*^9, 
  3.68344150990625*^9}},ExpressionUUID->"3c43f5f0-564a-4233-ba29-\
48a550d43d3f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV03k01PsbB3A/uRFCSmVJckmLSllKkXeSEEnMl4piGFHKkshtQZIoKiSh
3Eq2VMzMd8aQLVuyDiktys2luqUIRajfZ/54zue8znPe5zzPc85nEdN/J0tc
TEwsm5TotbqcMVd+9jqznoaRYDExA2i8/CDwU5qLG93Zk7dUDPC+4EmSidJi
GB4XPBYzNIBNSmmElpIRIozMq/V8DTApbRA6X8kS6md/Dki0GYCxJSBIUYnC
VzcHF+Y1Q0Qy5QLklbyRuoFXwtJYi3mB3V9mKoXgprW0UEp+PXymjRQ0i8fg
Tq1P8PPpQMkHveH/zb+Mbnl92Yq75shuz5m4kJiCpOlXSmt1tmCOecjmsagM
GKYH1vEqtyI+LCN7QPImispnSIcp26A9eek2+xlZ6O2o3/rusi3iilL6ciez
wZHKvLH4y3bIfZ1y31iWB+PD/k1WcTvg+FVhcrOgAF29euH69x3gpaB+LPr0
A0zmXb+2RLATwdf+OPpWvQiaSyML5pY4Yp5su6lBGhvmb2NDvjQ6QWsNX+ph
Jhvf47KceludoOeS0bH5Dhs1E08Hn3c4wSrL29exkI02j2rPyldOOGYykRxU
xwbF+WSY8MkJL/20Phd+Y6NxxtyMBTIMZDSHpK3YxgEvQmpYxoaB3OE9LHoH
B1kS24vH7BjgKm/SM6WIW3+a9jkw0MSSqbP14KDbpT2ubBcDU1OZQwdDOVCR
DtI96MvA3pUNVvm3OVAOWZFZco4BjYuqPxZPcqD6T0/psnoG2LK4pS3ORVB4
NdOzkYHNcV52WlJcrF11oiq9lQHv6Hu3F83hQqKiLlumi4F7x812qOlyEeW/
YPaHDwys9/HMm+XKxRYxyegkaQpNfTFOCkwuTkYacurlKLh5FvyW8+FikopN
m1CkELF3lCEbzMW+58PJTFUK9U4x4pIXuChSnr9hhS4Fp01390yWcsHNs3Kj
7Sj0l7dOn6ji4l7gSe0+BwqhJiNF4/Vc2FxdkjOHopC21lTqRwcX92teC4P2
UtClPTijL7hIMD7rcZNJoXzN2b0jb7noe6Jv0+pN4Z8VrdyhT1wcmf1DT8uf
QtDd4X2DQ1xUqU/t2HiEgsTS+TJff3Dx1FTOd1kohZRsE97AFBdZqsNL0v6i
sETLw+PzNBoX9h9dpHuSQsnNaNlPM2jMmrLY1XaKwraF+fyP8jTQlJjYEE7h
dUYL84MSjXzXtaquERQOqwzPfK9KY/VTDUkusVjqPEHfIhofJjKj/yNOVDLx
+leHRqNPnWBmJAWtJHf53hU0JjuZt7SJaYXokn/0aXz2TxcaEVsm5LF6jGmE
lMj1bSbukmlReGtGw8pZzG878YHYb6XdW2hkBPftcCaenD5v/+ttNHhVt9X2
ESec2aD4yoGG/3slbW/iheLuZS+cafzIGbjpR2w+lTv7uScNH/5U8DHip381
l3f60phX4DB4kth7bMj3qT+NZQ76a6KIY4fXVwqP02DpztGJJ1ZfvW0PN5LG
FZZ/y2Vi9uE931NiSL7U3DGF+PXH47quSTRW2j4RyyRe2fMwtT+fRvMhCZ0H
xI8WNOs3FNJwLYwbZxM77+luucujIXsovphHHPFsSiLwEY3cLZZi5cTtTRsD
J17QaHF92NIomk/aXvbNWxrZ9t7qrcQTW/flVPbROFc35N4uum91eHf0EI0F
6nWVXcQhgkprhRk8uA/kjv1LrJJtrqm9jodYSanrE8T3e3eWSW7kQYLpavuL
ePMiT5f/NvOwTtpsROw0Bb+MqIQH9jwEcqJWTicuT6z5abyfh+zA0J0KxJ7h
lh3bU3j4erbrxJ/EBS42Z46N8EAZ+BtZEp+OU7s6Os7DVtc6NStil4df8oJ+
88Cb+vXbmlhCI6nVT5qP1ca2ZXbEbu9fqXho8HFPp2gOg1gu5FCRtS0fgo/n
4UkckHTpjUoWH1ryj1tOElvWMoeu5vHB6bjJCidW+2EgofSAD2Z/9M8I4se7
XyyVL+EjaCxK/QzxIk3No9Pa+PjW/Ms+jri9kCPzeYKPXOs6txRiw5Zn68oc
i3H44nLLe8SXnD8sL9pVDCpdp+4+8eeecfU7+4phPxZtUUicNaz2R/xB0scJ
Ew6xorKn0DWqGFtGHykLiAc9v/pOsouhrKsXX0OcPy6ZvkFRgJl1qwJeEqtr
G08J2gToWfu8RjyKQuktWR+rZwKopaW/m0bsotHT/uyVAN1Pkn5LECepxuQO
9wuQvEN7rSSxlGKn44opAXIDRjJkiL/9Csj/e2kJbi/2tphDXNeV6xxzugT6
Dsoy2sSHLsxnOxmUQrVNim1BvKCzOSSHfggziYMbThPHqB8x+r6qHFJuBzz5
xNSxK/3vLlWAvWPNUC9x9QvLjuqYSjju7iiTP0P+W3jkctb6KiRaqYgbEvO0
DSLPfKyC2nTD85So/1D4JjznEfr3neoPJb726p7BE5dqGNb6BiQTO30KThyc
X4MwnbD6QmK/Cc5AcmcNdrfErXpCzE9avelcdC2y7+f3viVmq6VlOFvU4Xq1
8YFR4p4VmwaPfq/DnSOtjySjKRw0c9+keKces/TlN8wnztl0IC2O+Rh//mo/
t4R4bhP7k8PsBuSPnfY0Ijbc2m8x2t6AY6eWyFoQx9i4pLyPfgK3ssa/7YmN
tpv3ORs2IpXVP7aL+Ir5PJOs4UZEThgt8SLWqVh23uxOEwod39b6EfvqLn3H
YzXjvv9j46PEUmmZRgWaLdhm0UafIH550SlqsL0FD542S0YRu4aMPFdIbMXL
Wx7rY4ljg3wVodmGbRU2wQnEivnJfF5YG14OliknEQ/vot3Tu9pgnGCde5X4
i91otM5qIVp1g0+li/Zl1b5nrxGi07ckQWT3k1esNxoIIX5l/IbIHQWGMxlr
hfCrYVaIXCwTknzaVAh6oOe3yJEN3291WwvRlX4xPIN4zpaxiiQmyUu2hl0n
bnZ9vGihlxD9acaxIp8NTo3KZwlx+eT1VJHHb6/bWuUjhL6dA1/kN+JhLV8O
C8F67zsick7l+Gvr40K4XmEduiGar6thY+cJkk/1OSGyyuC1v91PCbGfyTov
8oWF671CI4X4b79tnsgBp/76lBUjhLSs8F+Rl6bY2OnFCvFL6fawyO/uqTwo
jRMiQtNfPJOY0V0S1B4vhIbH6EKR5UbjnrpdFML41oOVIj+W3WP08ZIQz6Z5
mYocqbU8NThRiOB4RVuR15tMjP9OEuKSZelukf8P2lLlGw==
       "]]},
     Annotation[#, "Charting`Private`Tag$2625#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"T[\[Degree]C]\"", TraditionalForm]},
  AxesOrigin->{20., 0.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.847938420193849*^9},ExpressionUUID->"a7dde72d-a0a6-44f5-9628-\
3f832c7d5a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"int", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thlinik", "[", "#", "]"}], ",", "#"}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "5256", ",", "10"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{"Quiet", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"Round", "@", 
         RowBox[{"int", "[", "#", "]"}]}]}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", 
      RowBox[{"25", ",", "90", ",", "5"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"obr", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"d1", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<T[\[Degree]C]\>\"", ",", "\"\<t[s]\>\""}], "}"}]}], "]"}],
     ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.683441569484375*^9, 3.683441603421875*^9}, {
  3.683441644109375*^9, 3.6834417315*^9}, {3.683441763484375*^9, 
  3.683441770109375*^9}, {3.683441980859375*^9, 3.6834420988125*^9}, {
  3.683444242328125*^9, 3.683444243765625*^9}, {3.694326029859375*^9, 
  3.694326032359375*^9}},ExpressionUUID->"26b4d4bc-a361-4ad6-946d-\
d71d01fb7a1a"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"T[\[Degree]C]\"\>", "\<\"t[s]\"\>"},
    {"25", "289"},
    {"30", "602"},
    {"35", "934"},
    {"40", "1280"},
    {"45", "1640"},
    {"50", "2012"},
    {"55", "2397"},
    {"60", "2792"},
    {"65", "3199"},
    {"70", "3616"},
    {"75", "4042"},
    {"80", "4479"},
    {"85", "4925"},
    {"90", "5380"}
   },
   AutoDelete->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.847938420318838*^9},ExpressionUUID->"701e2c16-00d3-4729-b94a-\
0080ecc824e1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<tab.png\>\"", ",", "obr"}], "]"}], "*)"}]], "Input",
 CellChangeTimes->{{3.683444247359375*^9, 
  3.683444284265625*^9}},ExpressionUUID->"76f340cc-de90-4010-9476-\
048be1e98402"],

Cell[CellGroupData[{

Cell[BoxData["Pmax"], "Input",
 CellChangeTimes->{{3.694326363375*^9, 
  3.69432636390625*^9}},ExpressionUUID->"61aad9d3-2ea2-4be2-993a-\
f3ebb210fcdd"],

Cell[BoxData["2875.`"], "Output",
 CellChangeTimes->{
  3.847938420381276*^9},ExpressionUUID->"7dd47b67-4a9c-4c4d-8494-\
7b060240a7b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"P", "/.", "res"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<P[W]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Magenta", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.694326490546875*^9, 
  3.694326547921875*^9}},ExpressionUUID->"6b408539-d104-40cb-842a-\
2dda45c50fee"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF1Xk01fkfx3FZStkaKkuijKZUppQ9y0uLFs2oST9KizW0KGtcWW6W61rv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       "]]},
     Annotation[#, "Charting`Private`Tag$2673#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"P[W]\"", TraditionalForm]},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.847938420459384*^9},ExpressionUUID->"4d00a76d-ce55-410b-954d-\
6df9e49b339c"]
}, Open  ]]
},
WindowSize->{1042, 694},
WindowMargins->{{18, Automatic}, {Automatic, 11}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
ShowSelection->True,
Magnification->1.3999992609024048`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 4986, 128, 800, "Input",ExpressionUUID->"ed9a9890-1d67-44a5-9cbe-218ea578d53c"],
Cell[CellGroupData[{
Cell[5568, 152, 5453, 163, 591, "Input",ExpressionUUID->"cd6aa55a-71db-4a75-a4a7-b5b4be35dc56"],
Cell[11024, 317, 208745, 3549, 340, "Output",ExpressionUUID->"1c3ae423-781d-48c4-ae8c-922a38badc4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[219806, 3871, 1042, 26, 92, "Input",ExpressionUUID->"3c43f5f0-564a-4233-ba29-48a550d43d3f"],
Cell[220851, 3899, 4817, 99, 340, "Output",ExpressionUUID->"a7dde72d-a0a6-44f5-9628-3f832c7d5a00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[225705, 4003, 1340, 38, 92, "Input",ExpressionUUID->"26b4d4bc-a361-4ad6-946d-d71d01fb7a1a"],
Cell[227048, 4043, 644, 24, 370, "Output",ExpressionUUID->"701e2c16-00d3-4729-b94a-0080ecc824e1"]
}, Open  ]],
Cell[227707, 4070, 250, 6, 41, "Input",ExpressionUUID->"76f340cc-de90-4010-9476-048be1e98402"],
Cell[CellGroupData[{
Cell[227982, 4080, 152, 3, 41, "Input",ExpressionUUID->"61aad9d3-2ea2-4be2-993a-f3ebb210fcdd"],
Cell[228137, 4085, 135, 3, 41, "Output",ExpressionUUID->"7dd47b67-4a9c-4c4d-8494-7b060240a7b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228309, 4093, 731, 19, 67, "Input",ExpressionUUID->"6b408539-d104-40cb-842a-2dda45c50fee"],
Cell[229043, 4114, 4706, 98, 331, "Output",ExpressionUUID->"4d00a76d-ce55-410b-954d-6df9e49b339c"]
}, Open  ]]
}
]
*)

