(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    183895,       3240]
NotebookOptionsPosition[    183103,       3211]
NotebookOutlinePosition[    183588,       3230]
CellTagsIndexPosition[    183545,       3227]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 ExpressionUUID -> "70192984-aa3e-40c9-8ac7-5d319549f3c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "2"}], "}"}]}], "]"}], "*", "2"}]], "Input",
 CellChangeTimes->{{3.8455242815*^9, 3.84552432146875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"taylor1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x0", ",", "2"}], "}"}]}], "]"}], ")"}], "//", 
    "Normal"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"taylor1", "/.", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"x0", "+", "\[CapitalDelta]x"}]}]}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"taylor1", "/.", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"x0", "-", "\[CapitalDelta]x"}]}]}], "//", 
  "Simplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%%", "-", "%"}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.687064274578125*^9, 3.687064363203125*^9}, {
   3.687064427140625*^9, 3.687064462375*^9}, 3.8455243584375*^9},
 ExpressionUUID -> "58afee5f-50ea-4a97-aa1f-d54ea4fae330"],

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6870645825*^9, 3.687064590328125*^9}},
 ExpressionUUID -> "21e1b861-e9c5-4e98-8c37-52acb001d726"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", "Sin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der1", "[", 
    RowBox[{"x_", ",", "\[CapitalDelta]x_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"fce", "[", 
      RowBox[{"x", "+", "\[CapitalDelta]x"}], "]"}], "-", 
     RowBox[{"fce", "[", "x", "]"}]}], "\[CapitalDelta]x"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"der2", "[", 
    RowBox[{"x_", ",", "\[CapitalDelta]x_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"fce", "[", 
      RowBox[{"x", "+", "\[CapitalDelta]x"}], "]"}], "-", 
     RowBox[{"fce", "[", 
      RowBox[{"x", "-", "\[CapitalDelta]x"}], "]"}]}], 
    RowBox[{"2", "*", "\[CapitalDelta]x"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deltaIks", "=", "0.1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"der1", "[", 
        RowBox[{"x", ",", "deltaIks"}], "]"}], "-", 
       RowBox[{
        RowBox[{"fce", "'"}], "[", "x", "]"}]}], "1"], ",", 
     FractionBox[
      RowBox[{
       RowBox[{"der2", "[", 
        RowBox[{"x", ",", "deltaIks"}], "]"}], "-", 
       RowBox[{
        RowBox[{"fce", "'"}], "[", "x", "]"}]}], "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Red"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Blue"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.687064645234375*^9, 3.687064785703125*^9}, {
  3.68706485534375*^9, 3.6870648805*^9}, {3.6870649235625*^9, 
  3.687065001203125*^9}, {3.845524546734375*^9, 3.845524665984375*^9}},
 ExpressionUUID -> "8cbf49b5-5432-481b-ae36-12240191c341"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"vyr", "[", "t_", "]"}], ":=", 
     RowBox[{"2", "+", 
      RowBox[{"3", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"1.38", "t"}], "+", "0.789"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rn", ":=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{
          RowBox[{"vyr", "[", "t", "]"}], "+", 
          RowBox[{"0.1", "*", "rn"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0.", ",", 
         RowBox[{"2", "Pi"}], ",", 
         FractionBox["Pi", "1000"]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"data", ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<u[V]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "model", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"model", "[", "t_", "]"}], ":=", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"c", "*", "t"}], "+", "d"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fit", "=", 
     RowBox[{"FindFit", "[", 
      RowBox[{"data", ",", 
       RowBox[{"model", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "t"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vysledek", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"model", "[", "t", "]"}], "/.", "fit"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"vyr", "[", "t", "]"}], "-", 
        RowBox[{"vysledek", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"vyr", "'"}], "[", "t", "]"}], "-", 
        RowBox[{
         RowBox[{"vysledek", "'"}], "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"int", "=", 
     RowBox[{"Interpolation", "[", "data", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"vyr", "'"}], "[", "t", "]"}], "-", 
        RowBox[{
         RowBox[{"int", "'"}], "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.84552495859375*^9, 3.84552500290625*^9}, {
   3.845525050390625*^9, 3.8455250671875*^9}, {3.845525108546875*^9, 
   3.845525302984375*^9}, {3.845525376203125*^9, 3.84552540428125*^9}, 
   3.845525478828125*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8l98XlwZJZWXla+/I3uNce2/ZIrSkaCFKyCqjSEJEMiqRUSjhEpKQ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->
   NCache[{{0, 2 Pi}, {-152.46395433634183`, 145.51443645844475`}}, {{
     0, 6.283185307179586}, {-152.46395433634183`, 145.51443645844475`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.84552538909375*^9, 3.84552540625*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"vyr", "[", "t", "]"}], "+", 
        RowBox[{
         StyleBox["0.000001",
          FontColor->RGBColor[1, 0, 0]], "*", "rn"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", 
       RowBox[{"2", "Pi"}], ",", 
       FractionBox["Pi", "1000"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t[s]\>\"", ",", "\"\<u[V]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.006", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "model", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", "t_", "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"c", "*", "t"}], "+", "d"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fit", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", 
     RowBox[{"model", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "t"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vysledek", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"model", "[", "t", "]"}], "/.", "fit"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vyr", "[", "t", "]"}], "-", 
      RowBox[{"vysledek", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"vyr", "'"}], "[", "t", "]"}], "-", 
      RowBox[{
       RowBox[{"vysledek", "'"}], "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int", "=", 
   RowBox[{"Interpolation", "[", "data", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"vyr", "''"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"int", "''"}], "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"vyr", "'"}], "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"int", "'"}], "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"int", "[", "t", "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.845525503109375*^9, 3.845525543859375*^9}, {
  3.84552558396875*^9, 3.845525604953125*^9}, {3.84552565609375*^9, 
  3.845525691375*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdmHk4Vd/3x433GlLuveecaJA0U1HRhPZKiijNShGRBh+ZilIkiTRJUolE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       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81d8bv7Zk3YmSIhUyI6PiuakoSkYhIyOpJKMyQiK+VpJkl6iQkq2Q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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmHk8lN0bxu3LmJnnUBhLEYqKJESlzp1XVKQSSVFSIomWNyKUkjVLklSk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       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmXk8VV8Xxs3zveeYLxqpyJAGZcxe+SGViAplSJJKIpTMIiGVoUQkMoQS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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwdmXk8VO8Xx20z9pi5M6KSaBdRSSl6TlJCqZAUspQWSfiGREmWUAktlELJ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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.845525506796875*^9, 3.845525544328125*^9}, {
  3.84552558434375*^9, 3.8455256053125*^9}, {3.845525663921875*^9, 
  3.845525691796875*^9}}]
}, Open  ]]
},
WindowSize->{1116, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
ShowSelection->True,
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->2.1000001430511475`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 389, 10, 162, "Input"],
Cell[937, 32, 258, 7, 87, "Input"],
Cell[1198, 41, 897, 25, 199, "Input"],
Cell[2098, 68, 292, 7, 87, "Input"],
Cell[2393, 77, 1994, 58, 493, "Input"],
Cell[CellGroupData[{
Cell[4412, 139, 3704, 112, 611, "Input"],
Cell[8119, 253, 65564, 1081, 510, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73720, 1339, 3656, 116, 563, "Input"],
Cell[77379, 1457, 105708, 1751, 568, "Output"]
}, Open  ]]
}
]
*)

