(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    245825,       6949]*)
(*NotebookOutlinePosition[    246468,       6971]*)
(*  CellTagsIndexPosition[    246424,       6967]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
autor: Ladislav Musil

Lit:
[1]Young W. Kwon, Hyochoong Bang: The Finite Element Method using Matlab, \
1997\
\>", "Text"],

Cell[CellGroupData[{

Cell["\<\
Metody zalo\:017een\[EAcute] na metod\:011b v\[AAcute]hov\[YAcute]ch residu\
\[IAcute] (Methods of Weighted Residual)
\
\>", "Section",
  FontSize->16],

Cell["\<\
Z\[AAcute]kladn\[IAcute] my\[SHacek]lenky budou uk\[AAcute]z\[AAcute]ny na n\
\[AAcute]sleduj\[IAcute]c\[IAcute] \[UAcute]loze\
\>", "Text"],

Cell["Zad\[AAcute]n\[IAcute] \[UAcute]lohy", "Text"],

Cell[BoxData[
    \(\(rov = \[PartialD]\_\(x, x\)T[x] \[Equal] 
          3*0.2*\((\ T[x] - 20)\);\)\)], "Input"],

Cell[BoxData[
    \(okr1 = T[0] \[Equal] 0; okr1 = T[1] \[Equal] 0;\)], "Input"],

Cell["\<\
Te\:010f si navrhneme tvar \:0159e\[SHacek]en\[IAcute], tedy omez\[IAcute]me \
mno\:017einu v\[SHacek]ech funkc\[IAcute], mezi kter\[YAcute]mi \
hled\[AAcute]me \:0159e\[SHacek]en\[IAcute] na mno\:017einu popsatelnou jedn\
\[IAcute]m tvarem s n\:011bkolika parametry a spl\:0148uj\[IAcute]c\[IAcute] \
okrajov\[EAcute] podm\[IAcute]nky. \
\>", "Text"],

Cell["\<\
Tvar jenom s jedn\[IAcute]m parametrem:\
\>", "Text"],

Cell[BoxData[
    \(\(Tapr = a\ x\ \((1 - x)\);\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Table[Tapr, {a, 0, 10}]], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.235442 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -6 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.5)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(1)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(1.5)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(2)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(2.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29725 m
.02756 .29725 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57978 m
.02756 .57978 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.02954 .01472 L
.03053 .01472 L
.03163 .01472 L
.03279 .01472 L
.03395 .01472 L
.0352 .01472 L
.03638 .01472 L
.03746 .01472 L
.03873 .01472 L
.03944 .01472 L
.04011 .01472 L
.04132 .01472 L
.04262 .01472 L
.04327 .01472 L
.04396 .01472 L
.04519 .01472 L
.04588 .01472 L
.04652 .01472 L
.04722 .01472 L
.04797 .01472 L
.04862 .01472 L
.04933 .01472 L
.05061 .01472 L
.05186 .01472 L
.05302 .01472 L
.05414 .01472 L
.05519 .01472 L
.05634 .01472 L
.05759 .01472 L
.05882 .01472 L
.06012 .01472 L
.06123 .01472 L
.06244 .01472 L
.06315 .01472 L
.06381 .01472 L
.06453 .01472 L
.06529 .01472 L
.06657 .01472 L
.06729 .01472 L
.06797 .01472 L
.06924 .01472 L
.0704 .01472 L
.07103 .01472 L
.07173 .01472 L
.073 .01472 L
Mistroke
.07376 .01472 L
.07448 .01472 L
.07513 .01472 L
.07583 .01472 L
.0766 .01472 L
.0774 .01472 L
.07809 .01472 L
.07885 .01472 L
.07956 .01472 L
.0802 .01472 L
.08095 .01472 L
.08166 .01472 L
.08291 .01472 L
.08362 .01472 L
.08427 .01472 L
.08544 .01472 L
.08669 .01472 L
.08787 .01472 L
.08896 .01472 L
.09016 .01472 L
.09148 .01472 L
.09214 .01472 L
.09285 .01472 L
.09413 .01472 L
.09483 .01472 L
.09548 .01472 L
.09619 .01472 L
.09695 .01472 L
.09821 .01472 L
.09893 .01472 L
.09961 .01472 L
.10086 .01472 L
.10201 .01472 L
.10333 .01472 L
.10458 .01472 L
.10572 .01472 L
.10694 .01472 L
.1081 .01472 L
.10916 .01472 L
.11033 .01472 L
.11162 .01472 L
.11227 .01472 L
.11297 .01472 L
.11422 .01472 L
.11491 .01472 L
.11554 .01472 L
.11624 .01472 L
.11698 .01472 L
.11822 .01472 L
.11892 .01472 L
Mistroke
.11958 .01472 L
.12081 .01472 L
.12194 .01472 L
.12323 .01472 L
.12446 .01472 L
.12562 .01472 L
.12668 .01472 L
.12789 .01472 L
.12903 .01472 L
.13009 .01472 L
.13107 .01472 L
.13214 .01472 L
.13327 .01472 L
.13441 .01472 L
.13564 .01472 L
.1368 .01472 L
.13785 .01472 L
.13909 .01472 L
.13979 .01472 L
.14043 .01472 L
.14162 .01472 L
.14288 .01472 L
.14402 .01472 L
.14526 .01472 L
.14656 .01472 L
.14777 .01472 L
.14891 .01472 L
.14994 .01472 L
.15113 .01472 L
.15226 .01472 L
.15348 .01472 L
.15478 .01472 L
.15589 .01472 L
.15711 .01472 L
.15842 .01472 L
.15915 .01472 L
.15982 .01472 L
.16113 .01472 L
.16236 .01472 L
.16352 .01472 L
.16456 .01472 L
.16577 .01472 L
.1669 .01472 L
.16796 .01472 L
.16893 .01472 L
.16999 .01472 L
.17111 .01472 L
.17225 .01472 L
.17347 .01472 L
.17462 .01472 L
Mistroke
.17566 .01472 L
.17689 .01472 L
.17758 .01472 L
.17823 .01472 L
.1794 .01472 L
.18065 .01472 L
.18185 .01472 L
.18316 .01472 L
.18441 .01472 L
.18556 .01472 L
.1867 .01472 L
.18773 .01472 L
.18893 .01472 L
.19005 .01472 L
.19128 .01472 L
.19258 .01472 L
.19369 .01472 L
.19491 .01472 L
.19623 .01472 L
.19696 .01472 L
.19763 .01472 L
.19894 .01472 L
.20017 .01472 L
.20122 .01472 L
.20238 .01472 L
.20359 .01472 L
.20472 .01472 L
.20578 .01472 L
.20675 .01472 L
.20781 .01472 L
.20894 .01472 L
.21008 .01472 L
.21129 .01472 L
.21244 .01472 L
.21349 .01472 L
.21472 .01472 L
.21541 .01472 L
.21605 .01472 L
.21723 .01472 L
.21847 .01472 L
.21968 .01472 L
.221 .01472 L
.22224 .01472 L
.2234 .01472 L
.22454 .01472 L
.22558 .01472 L
.22677 .01472 L
.2279 .01472 L
.22914 .01472 L
.23044 .01472 L
Mistroke
.23155 .01472 L
.23277 .01472 L
.23409 .01472 L
.23482 .01472 L
.2355 .01472 L
.2368 .01472 L
.23804 .01472 L
.23909 .01472 L
.24025 .01472 L
.24146 .01472 L
.2426 .01472 L
.24365 .01472 L
.24462 .01472 L
.24569 .01472 L
.24681 .01472 L
.24795 .01472 L
.24917 .01472 L
.25032 .01472 L
.25137 .01472 L
.2526 .01472 L
.25329 .01472 L
.25393 .01472 L
.2551 .01472 L
.25635 .01472 L
.25756 .01472 L
.25888 .01472 L
.26013 .01472 L
.26129 .01472 L
.26233 .01472 L
.26348 .01472 L
.26467 .01472 L
.2658 .01472 L
.26704 .01472 L
.26835 .01472 L
.26946 .01472 L
.27068 .01472 L
.272 .01472 L
.27274 .01472 L
.27341 .01472 L
.27472 .01472 L
.27595 .01472 L
.27701 .01472 L
.27817 .01472 L
.27938 .01472 L
.28052 .01472 L
.28158 .01472 L
.28255 .01472 L
.28367 .01472 L
.28474 .01472 L
.28588 .01472 L
Mistroke
.2871 .01472 L
.28825 .01472 L
.2893 .01472 L
.29053 .01472 L
.29122 .01472 L
.29186 .01472 L
.29303 .01472 L
.29427 .01472 L
.29549 .01472 L
.29618 .01472 L
.29682 .01472 L
.29799 .01472 L
.29923 .01472 L
.30034 .01472 L
.30138 .01472 L
.30252 .01472 L
.30375 .01472 L
.30499 .01472 L
.30569 .01472 L
.30634 .01472 L
.30765 .01472 L
.30839 .01472 L
.30906 .01472 L
.31026 .01472 L
.31156 .01472 L
.31278 .01472 L
.31392 .01472 L
.31497 .01472 L
.31611 .01472 L
.31718 .01472 L
.31816 .01472 L
.3193 .01472 L
.32055 .01472 L
.32173 .01472 L
.32282 .01472 L
.32406 .01472 L
.32522 .01472 L
.32626 .01472 L
.32739 .01472 L
.32862 .01472 L
.32992 .01472 L
.33103 .01472 L
.33225 .01472 L
.33356 .01472 L
.33477 .01472 L
.33541 .01472 L
.3361 .01472 L
.33683 .01472 L
.33751 .01472 L
.33876 .01472 L
Mistroke
.33991 .01472 L
.34123 .01472 L
.34249 .01472 L
.3436 .01472 L
.3448 .01472 L
.34592 .01472 L
.34694 .01472 L
.34814 .01472 L
.34945 .01472 L
.35067 .01472 L
.35181 .01472 L
.35302 .01472 L
.35431 .01472 L
.35554 .01472 L
.35665 .01472 L
.35796 .01472 L
.3587 .01472 L
.35939 .01472 L
.36064 .01472 L
.36128 .01472 L
.36198 .01472 L
.36266 .01472 L
.36337 .01472 L
.36465 .01472 L
.36536 .01472 L
.36602 .01472 L
.36675 .01472 L
.36753 .01472 L
.3682 .01472 L
.36893 .01472 L
.36962 .01472 L
.37026 .01472 L
.37146 .01472 L
.37274 .01472 L
.37394 .01472 L
.37526 .01472 L
.37651 .01472 L
.37766 .01472 L
.3788 .01472 L
.37984 .01472 L
.38103 .01472 L
.38216 .01472 L
.38339 .01472 L
.3847 .01472 L
.38581 .01472 L
.38703 .01472 L
.38834 .01472 L
.38908 .01472 L
.38975 .01472 L
.39106 .01472 L
Mistroke
.39229 .01472 L
.39334 .01472 L
.3945 .01472 L
.39571 .01472 L
.39685 .01472 L
.39791 .01472 L
.39888 .01472 L
.39994 .01472 L
.40106 .01472 L
.40221 .01472 L
.40342 .01472 L
.40457 .01472 L
.40562 .01472 L
.40685 .01472 L
.40754 .01472 L
.40818 .01472 L
.40936 .01472 L
.4106 .01472 L
.41181 .01472 L
.41313 .01472 L
.41438 .01472 L
.41554 .01472 L
.41669 .01472 L
.41772 .01472 L
.41892 .01472 L
.42005 .01472 L
.42129 .01472 L
.42259 .01472 L
.42371 .01472 L
.42493 .01472 L
.42624 .01472 L
.42698 .01472 L
.42765 .01472 L
.42896 .01472 L
.43019 .01472 L
.43125 .01472 L
.43241 .01472 L
.43362 .01472 L
.43476 .01472 L
.43582 .01472 L
.43679 .01472 L
.43791 .01472 L
.43898 .01472 L
.44012 .01472 L
.44134 .01472 L
.44249 .01472 L
.44354 .01472 L
.44477 .01472 L
.44546 .01472 L
.4461 .01472 L
Mistroke
.44727 .01472 L
.44851 .01472 L
.44973 .01472 L
.45042 .01472 L
.45106 .01472 L
.45223 .01472 L
.45347 .01472 L
.45458 .01472 L
.45562 .01472 L
.45676 .01472 L
.45799 .01472 L
.45922 .01472 L
.45992 .01472 L
.46057 .01472 L
.46188 .01472 L
.46262 .01472 L
.46329 .01472 L
.46449 .01472 L
.46579 .01472 L
.46702 .01472 L
.46815 .01472 L
.4692 .01472 L
.47034 .01472 L
.47141 .01472 L
.47239 .01472 L
.47353 .01472 L
.47478 .01472 L
.47596 .01472 L
.47705 .01472 L
.47829 .01472 L
.47945 .01472 L
.48049 .01472 L
.48162 .01472 L
.48285 .01472 L
.48415 .01472 L
.48526 .01472 L
.48648 .01472 L
.48779 .01472 L
.489 .01472 L
.48963 .01472 L
.49033 .01472 L
.49105 .01472 L
.49174 .01472 L
.49299 .01472 L
.49413 .01472 L
.49539 .01472 L
.49671 .01472 L
.49783 .01472 L
.49902 .01472 L
.50014 .01472 L
Mistroke
.50116 .01472 L
.50236 .01472 L
.50366 .01472 L
.50489 .01472 L
.50603 .01472 L
.50723 .01472 L
.50853 .01472 L
.50975 .01472 L
.51087 .01472 L
.51218 .01472 L
.51292 .01472 L
.51361 .01472 L
.51486 .01472 L
.5155 .01472 L
.5162 .01472 L
.51687 .01472 L
.51759 .01472 L
.51886 .01472 L
.51958 .01472 L
.52024 .01472 L
.52096 .01472 L
.52174 .01472 L
.52241 .01472 L
.52314 .01472 L
.52383 .01472 L
.52447 .01472 L
.52568 .01472 L
.52695 .01472 L
.52816 .01472 L
.52947 .01472 L
.53072 .01472 L
.53187 .01472 L
.53301 .01472 L
.53405 .01472 L
.53525 .01472 L
.53637 .01472 L
.5376 .01472 L
.53891 .01472 L
.54002 .01472 L
.54124 .01472 L
.54255 .01472 L
.54329 .01472 L
.54396 .01472 L
.54526 .01472 L
.5465 .01472 L
.54755 .01472 L
.54871 .01472 L
.54992 .01472 L
.55105 .01472 L
.55211 .01472 L
Mistroke
.55308 .01472 L
.55415 .01472 L
.55527 .01472 L
.55641 .01472 L
.55763 .01472 L
.55878 .01472 L
.55982 .01472 L
.56105 .01472 L
.56175 .01472 L
.56238 .01472 L
.56356 .01472 L
.5648 .01472 L
.56601 .01472 L
.56734 .01472 L
.56858 .01472 L
.56974 .01472 L
.57088 .01472 L
.57192 .01472 L
.57312 .01472 L
.57425 .01472 L
.57548 .01472 L
.57679 .01472 L
.5779 .01472 L
.57912 .01472 L
.58044 .01472 L
.58118 .01472 L
.58185 .01472 L
.58315 .01472 L
.58439 .01472 L
.58544 .01472 L
.5866 .01472 L
.58782 .01472 L
.58895 .01472 L
.59001 .01472 L
.59098 .01472 L
.5921 .01472 L
.59317 .01472 L
.59431 .01472 L
.59553 .01472 L
.59668 .01472 L
.59773 .01472 L
.59896 .01472 L
.59965 .01472 L
.60029 .01472 L
.60146 .01472 L
.60271 .01472 L
.60392 .01472 L
.60461 .01472 L
.60525 .01472 L
.60642 .01472 L
Mistroke
.60766 .01472 L
.60876 .01472 L
.6098 .01472 L
.61094 .01472 L
.61217 .01472 L
.61341 .01472 L
.6141 .01472 L
.61475 .01472 L
.61607 .01472 L
.6168 .01472 L
.61747 .01472 L
.61867 .01472 L
.61997 .01472 L
.6212 .01472 L
.62233 .01472 L
.62339 .01472 L
.62452 .01472 L
.62559 .01472 L
.62657 .01472 L
.62771 .01472 L
.62896 .01472 L
.63014 .01472 L
.63123 .01472 L
.63247 .01472 L
.63363 .01472 L
.63467 .01472 L
.6358 .01472 L
.63703 .01472 L
.63833 .01472 L
.63944 .01472 L
.64066 .01472 L
.64197 .01472 L
.64318 .01472 L
.64381 .01472 L
.6445 .01472 L
.64523 .01472 L
.64591 .01472 L
.64716 .01472 L
.64831 .01472 L
.64956 .01472 L
.65088 .01472 L
.652 .01472 L
.65319 .01472 L
.65431 .01472 L
.65533 .01472 L
.65653 .01472 L
.65784 .01472 L
.65906 .01472 L
.6602 .01472 L
.6614 .01472 L
Mistroke
.6627 .01472 L
.66392 .01472 L
.66504 .01472 L
.66635 .01472 L
.66709 .01472 L
.66777 .01472 L
.66903 .01472 L
.66966 .01472 L
.67036 .01472 L
.67104 .01472 L
.67175 .01472 L
.67303 .01472 L
.67374 .01472 L
.6744 .01472 L
.67513 .01472 L
.67591 .01472 L
.67658 .01472 L
.67731 .01472 L
.678 .01472 L
.67864 .01472 L
.67984 .01472 L
.68112 .01472 L
.68232 .01472 L
.68364 .01472 L
.68488 .01472 L
.68603 .01472 L
.68718 .01472 L
.68821 .01472 L
.68941 .01472 L
.69053 .01472 L
.69176 .01472 L
.69307 .01472 L
.69418 .01472 L
.6954 .01472 L
.69671 .01472 L
.69745 .01472 L
.69812 .01472 L
.69942 .01472 L
.70066 .01472 L
.70171 .01472 L
.70286 .01472 L
.70407 .01472 L
.70521 .01472 L
.70627 .01472 L
.70724 .01472 L
.7083 .01472 L
.70942 .01472 L
.71056 .01472 L
.71178 .01472 L
.71293 .01472 L
Mistroke
.71398 .01472 L
.71521 .01472 L
.7159 .01472 L
.71654 .01472 L
.71771 .01472 L
.71896 .01472 L
.72017 .01472 L
.72149 .01472 L
.72273 .01472 L
.72389 .01472 L
.72503 .01472 L
.72607 .01472 L
.72727 .01472 L
.7284 .01472 L
.72963 .01472 L
.73094 .01472 L
.73205 .01472 L
.73327 .01472 L
.73458 .01472 L
.73532 .01472 L
.73599 .01472 L
.7373 .01472 L
.73853 .01472 L
.73959 .01472 L
.74075 .01472 L
.74196 .01472 L
.7431 .01472 L
.74416 .01472 L
.74513 .01472 L
.74619 .01472 L
.74731 .01472 L
.74846 .01472 L
.74967 .01472 L
.75083 .01472 L
.75187 .01472 L
.7531 .01472 L
.75379 .01472 L
.75443 .01472 L
.75561 .01472 L
.75685 .01472 L
.75806 .01472 L
.75875 .01472 L
.75939 .01472 L
.76056 .01472 L
.7618 .01472 L
.7629 .01472 L
.76394 .01472 L
.76508 .01472 L
.76631 .01472 L
.76754 .01472 L
Mistroke
.76824 .01472 L
.76889 .01472 L
.7702 .01472 L
.77094 .01472 L
.77161 .01472 L
.7728 .01472 L
.7741 .01472 L
.77533 .01472 L
.77646 .01472 L
.77752 .01472 L
.77865 .01472 L
.77972 .01472 L
.7807 .01472 L
.78184 .01472 L
.78309 .01472 L
.78427 .01472 L
.78536 .01472 L
.7866 .01472 L
.78776 .01472 L
.7888 .01472 L
.78993 .01472 L
.79116 .01472 L
.79246 .01472 L
.79357 .01472 L
.79479 .01472 L
.7961 .01472 L
.7973 .01472 L
.79793 .01472 L
.79863 .01472 L
.79936 .01472 L
.80004 .01472 L
.80129 .01472 L
.80243 .01472 L
.80369 .01472 L
.80501 .01472 L
.80612 .01472 L
.80731 .01472 L
.80843 .01472 L
.80945 .01472 L
.81066 .01472 L
.81196 .01472 L
.81318 .01472 L
.81432 .01472 L
.81552 .01472 L
.81682 .01472 L
.81804 .01472 L
.81916 .01472 L
.82047 .01472 L
.8212 .01472 L
.82189 .01472 L
Mistroke
.82315 .01472 L
.82385 .01472 L
.82448 .01472 L
.82516 .01472 L
.82587 .01472 L
.82715 .01472 L
.82786 .01472 L
.82852 .01472 L
.82925 .01472 L
.83002 .01472 L
.8307 .01472 L
.83143 .01472 L
.83212 .01472 L
.83275 .01472 L
.83396 .01472 L
.83524 .01472 L
.83644 .01472 L
.83775 .01472 L
.839 .01472 L
.84015 .01472 L
.84129 .01472 L
.84232 .01472 L
.84352 .01472 L
.84464 .01472 L
.84587 .01472 L
.84718 .01472 L
.84829 .01472 L
.8495 .01472 L
.85082 .01472 L
.85155 .01472 L
.85222 .01472 L
.85353 .01472 L
.85476 .01472 L
.85581 .01472 L
.85697 .01472 L
.85818 .01472 L
.85932 .01472 L
.86037 .01472 L
.86134 .01472 L
.86241 .01472 L
.86353 .01472 L
.86467 .01472 L
.86589 .01472 L
.86704 .01472 L
.86808 .01472 L
.86931 .01472 L
.87 .01472 L
.87064 .01472 L
.87182 .01472 L
.87306 .01472 L
Mistroke
.87427 .01472 L
.87559 .01472 L
.87684 .01472 L
.87799 .01472 L
.87914 .01472 L
.88017 .01472 L
.88137 .01472 L
.88249 .01472 L
.88373 .01472 L
.88503 .01472 L
.88615 .01472 L
.88737 .01472 L
.88868 .01472 L
.88942 .01472 L
.89009 .01472 L
.89139 .01472 L
.89263 .01472 L
.89368 .01472 L
.89484 .01472 L
.89605 .01472 L
.89719 .01472 L
.89825 .01472 L
.89922 .01472 L
.90029 .01472 L
.90141 .01472 L
.90255 .01472 L
.90377 .01472 L
.90492 .01472 L
.90596 .01472 L
.90719 .01472 L
.90789 .01472 L
.90852 .01472 L
.9097 .01472 L
.91094 .01472 L
.91216 .01472 L
.91284 .01472 L
.91348 .01472 L
.91464 .01472 L
.91589 .01472 L
.91699 .01472 L
.91803 .01472 L
.91917 .01472 L
.9204 .01472 L
.92163 .01472 L
.92233 .01472 L
.92297 .01472 L
.92429 .01472 L
.92502 .01472 L
.92569 .01472 L
.92689 .01472 L
Mistroke
.92819 .01472 L
.92941 .01472 L
.93055 .01472 L
.9316 .01472 L
.93273 .01472 L
.9338 .01472 L
.93478 .01472 L
.93592 .01472 L
.93717 .01472 L
.93835 .01472 L
.93944 .01472 L
.94068 .01472 L
.94184 .01472 L
.94288 .01472 L
.94401 .01472 L
.94524 .01472 L
.94654 .01472 L
.94765 .01472 L
.94887 .01472 L
.94975 .01472 L
.95057 .01472 L
.95146 .01472 L
.95241 .01472 L
.95324 .01472 L
.95401 .01472 L
.95486 .01472 L
.95577 .01472 L
.95653 .01472 L
.95737 .01472 L
.95824 .01472 L
.95905 .01472 L
.95981 .01472 L
.9605 .01472 L
.9613 .01472 L
.96206 .01472 L
.96287 .01472 L
.96377 .01472 L
.96471 .01472 L
.96559 .01472 L
.96641 .01472 L
.96716 .01472 L
.96802 .01472 L
.96884 .01472 L
.96972 .01472 L
.97067 .01472 L
.97155 .01472 L
.97236 .01472 L
.97331 .01472 L
.97433 .01472 L
.9753 .01472 L
Mistroke
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .02388 L
.10458 .03299 L
.14415 .04071 L
.18221 .04736 L
.22272 .05362 L
.26171 .05884 L
.30316 .06352 L
.34309 .06718 L
.3815 .06993 L
.40095 .07103 L
.42237 .07201 L
.44268 .07272 L
.45178 .07297 L
.46172 .0732 L
.4671 .07329 L
.4721 .07337 L
.47727 .07344 L
.48196 .07349 L
.48658 .07353 L
.4887 .07354 L
.49093 .07355 L
.49332 .07356 L
.49438 .07357 L
.49552 .07357 L
.49675 .07357 L
.49789 .07357 L
.49859 .07358 L
.49925 .07358 L
.50049 .07358 L
.50163 .07357 L
.50286 .07357 L
.50401 .07357 L
.50508 .07357 L
.50754 .07356 L
.51014 .07355 L
.51268 .07353 L
.51504 .07352 L
.5204 .07347 L
.5293 .07335 L
.53882 .07318 L
.54906 .07295 L
.56016 .07264 L
.58032 .0719 L
.60019 .07097 L
.62123 .06976 L
.65912 .067 L
.69946 .06325 L
.73829 .05884 L
.77956 .05329 L
Mistroke
.81932 .04711 L
.85757 .04039 L
.89827 .0324 L
.93745 .0239 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .03304 L
.10458 .05126 L
.14415 .0667 L
.18221 .08001 L
.22272 .09252 L
.26171 .10296 L
.30316 .11232 L
.34309 .11965 L
.3815 .12515 L
.40095 .12734 L
.42237 .12931 L
.44268 .13073 L
.45178 .13123 L
.46172 .13168 L
.4671 .13187 L
.4721 .13203 L
.47727 .13217 L
.48196 .13227 L
.48658 .13234 L
.4887 .13237 L
.49093 .13239 L
.49332 .13241 L
.49438 .13242 L
.49552 .13243 L
.49675 .13243 L
.49789 .13243 L
.49859 .13243 L
.49925 .13244 L
.50049 .13244 L
.50163 .13243 L
.50286 .13243 L
.50401 .13243 L
.50508 .13242 L
.50754 .13241 L
.51014 .13238 L
.51268 .13235 L
.51504 .13232 L
.5204 .13222 L
.5293 .13199 L
.53882 .13165 L
.54906 .13119 L
.56016 .13056 L
.58032 .12909 L
.60019 .12722 L
.62123 .12481 L
.65912 .11929 L
.69946 .11178 L
.73829 .10296 L
.77956 .09186 L
Mistroke
.81932 .0795 L
.85757 .06606 L
.89827 .05009 L
.93745 .03309 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .04221 L
.10458 .06954 L
.14415 .09269 L
.18221 .11265 L
.22272 .13142 L
.26171 .14708 L
.30316 .16112 L
.34309 .17212 L
.3815 .18036 L
.40095 .18366 L
.42237 .1866 L
.44268 .18874 L
.45178 .18949 L
.46172 .19016 L
.4671 .19045 L
.4721 .19069 L
.47727 .19089 L
.48196 .19104 L
.48658 .19116 L
.4887 .1912 L
.49093 .19123 L
.49332 .19126 L
.49438 .19127 L
.49552 .19128 L
.49675 .19129 L
.49789 .19129 L
.49859 .19129 L
.49925 .1913 L
.50049 .1913 L
.50163 .19129 L
.50286 .19129 L
.50401 .19128 L
.50508 .19128 L
.50754 .19125 L
.51014 .19122 L
.51268 .19117 L
.51504 .19112 L
.5204 .19097 L
.5293 .19063 L
.53882 .19012 L
.54906 .18942 L
.56016 .18848 L
.58032 .18627 L
.60019 .18348 L
.62123 .17985 L
.65912 .17158 L
.69946 .16031 L
.73829 .14708 L
.77956 .13044 L
Mistroke
.81932 .11189 L
.85757 .09173 L
.89827 .06778 L
.93745 .04228 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .05137 L
.10458 .08781 L
.14415 .11868 L
.18221 .1453 L
.22272 .17033 L
.26171 .1912 L
.30316 .20993 L
.34309 .22459 L
.3815 .23558 L
.40095 .23997 L
.42237 .2439 L
.44268 .24675 L
.45178 .24774 L
.46172 .24864 L
.4671 .24903 L
.4721 .24935 L
.47727 .24962 L
.48196 .24982 L
.48658 .24997 L
.4887 .25002 L
.49093 .25007 L
.49332 .25011 L
.49438 .25012 L
.49552 .25014 L
.49675 .25015 L
.49789 .25015 L
.49859 .25015 L
.49925 .25016 L
.50049 .25016 L
.50163 .25015 L
.50286 .25015 L
.50401 .25014 L
.50508 .25013 L
.50754 .2501 L
.51014 .25005 L
.51268 .24999 L
.51504 .24992 L
.5204 .24972 L
.5293 .24927 L
.53882 .24859 L
.54906 .24766 L
.56016 .2464 L
.58032 .24346 L
.60019 .23973 L
.62123 .2349 L
.65912 .22387 L
.69946 .20885 L
.73829 .1912 L
.77956 .16901 L
Mistroke
.81932 .14428 L
.85757 .11741 L
.89827 .08547 L
.93745 .05147 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .06053 L
.10458 .10609 L
.14415 .14467 L
.18221 .17794 L
.22272 .20923 L
.26171 .23532 L
.30316 .25873 L
.34309 .27706 L
.3815 .29079 L
.40095 .29628 L
.42237 .30119 L
.44268 .30475 L
.45178 .306 L
.46172 .30712 L
.4671 .30761 L
.4721 .30801 L
.47727 .30835 L
.48196 .3086 L
.48658 .30878 L
.4887 .30885 L
.49093 .30891 L
.49332 .30896 L
.49438 .30898 L
.49552 .30899 L
.49675 .309 L
.49789 .30901 L
.49859 .30901 L
.49925 .30902 L
.50049 .30902 L
.50163 .30901 L
.50286 .30901 L
.50401 .309 L
.50508 .30898 L
.50754 .30894 L
.51014 .30888 L
.51268 .30881 L
.51504 .30872 L
.5204 .30848 L
.5293 .3079 L
.53882 .30706 L
.54906 .30589 L
.56016 .30432 L
.58032 .30065 L
.60019 .29599 L
.62123 .28994 L
.65912 .27616 L
.69946 .25738 L
.73829 .23532 L
.77956 .20758 L
Mistroke
.81932 .17668 L
.85757 .14308 L
.89827 .10315 L
.93745 .06066 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .0697 L
.10458 .12436 L
.14415 .17066 L
.18221 .21059 L
.22272 .24813 L
.26171 .27944 L
.30316 .30753 L
.34309 .32953 L
.3815 .34601 L
.40095 .3526 L
.42237 .35849 L
.44268 .36276 L
.45178 .36426 L
.46172 .3656 L
.4671 .36619 L
.4721 .36667 L
.47727 .36707 L
.48196 .36737 L
.48658 .3676 L
.4887 .36768 L
.49093 .36775 L
.49332 .36781 L
.49438 .36783 L
.49552 .36785 L
.49675 .36786 L
.49789 .36787 L
.49859 .36787 L
.49925 .36788 L
.50049 .36788 L
.50163 .36787 L
.50286 .36787 L
.50401 .36785 L
.50508 .36784 L
.50754 .36779 L
.51014 .36772 L
.51268 .36763 L
.51504 .36753 L
.5204 .36723 L
.5293 .36654 L
.53882 .36553 L
.54906 .36413 L
.56016 .36224 L
.58032 .35783 L
.60019 .35224 L
.62123 .34499 L
.65912 .32844 L
.69946 .30591 L
.73829 .27945 L
.77956 .24616 L
Mistroke
.81932 .20907 L
.85757 .16875 L
.89827 .12084 L
.93745 .06984 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .07886 L
.10458 .14263 L
.14415 .19665 L
.18221 .24323 L
.22272 .28703 L
.26171 .32356 L
.30316 .35633 L
.34309 .382 L
.3815 .40122 L
.40095 .40891 L
.42237 .41579 L
.44268 .42077 L
.45178 .42251 L
.46172 .42408 L
.4671 .42477 L
.4721 .42532 L
.47727 .4258 L
.48196 .42615 L
.48658 .42641 L
.4887 .42651 L
.49093 .42659 L
.49332 .42666 L
.49438 .42668 L
.49552 .4267 L
.49675 .42672 L
.49789 .42673 L
.49859 .42673 L
.49925 .42674 L
.50049 .42674 L
.50163 .42673 L
.50286 .42672 L
.50401 .42671 L
.50508 .42669 L
.50754 .42663 L
.51014 .42655 L
.51268 .42645 L
.51504 .42633 L
.5204 .42598 L
.5293 .42518 L
.53882 .424 L
.54906 .42236 L
.56016 .42016 L
.58032 .41502 L
.60019 .4085 L
.62123 .40003 L
.65912 .38073 L
.69946 .35445 L
.73829 .32357 L
.77956 .28473 L
Mistroke
.81932 .24146 L
.85757 .19442 L
.89827 .13853 L
.93745 .07903 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .08802 L
.10458 .16091 L
.14415 .22264 L
.18221 .27588 L
.22272 .32594 L
.26171 .36768 L
.30316 .40514 L
.34309 .43447 L
.3815 .45644 L
.40095 .46522 L
.42237 .47308 L
.44268 .47878 L
.45178 .48077 L
.46172 .48256 L
.4671 .48335 L
.4721 .48398 L
.47727 .48453 L
.48196 .48492 L
.48658 .48522 L
.4887 .48533 L
.49093 .48543 L
.49332 .48551 L
.49438 .48553 L
.49552 .48556 L
.49675 .48558 L
.49789 .48559 L
.49859 .48559 L
.49925 .4856 L
.50049 .4856 L
.50163 .48559 L
.50286 .48558 L
.50401 .48557 L
.50508 .48555 L
.50754 .48548 L
.51014 .48539 L
.51268 .48526 L
.51504 .48513 L
.5204 .48473 L
.5293 .48382 L
.53882 .48247 L
.54906 .4806 L
.56016 .47808 L
.58032 .4722 L
.60019 .46475 L
.62123 .45508 L
.65912 .43302 L
.69946 .40298 L
.73829 .36769 L
.77956 .3233 L
Mistroke
.81932 .27385 L
.85757 .2201 L
.89827 .15622 L
.93745 .08822 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .09719 L
.10458 .17918 L
.14415 .24863 L
.18221 .30853 L
.22272 .36484 L
.26171 .41181 L
.30316 .45394 L
.34309 .48694 L
.3815 .51165 L
.40095 .52154 L
.42237 .53038 L
.44268 .53678 L
.45178 .53903 L
.46172 .54104 L
.4671 .54193 L
.4721 .54264 L
.47727 .54325 L
.48196 .5437 L
.48658 .54404 L
.4887 .54416 L
.49093 .54427 L
.49332 .54435 L
.49438 .54439 L
.49552 .54441 L
.49675 .54443 L
.49789 .54445 L
.49859 .54445 L
.49925 .54446 L
.50049 .54446 L
.50163 .54445 L
.50286 .54444 L
.50401 .54442 L
.50508 .5444 L
.50754 .54433 L
.51014 .54422 L
.51268 .54408 L
.51504 .54393 L
.5204 .54349 L
.5293 .54245 L
.53882 .54094 L
.54906 .53884 L
.56016 .536 L
.58032 .52939 L
.60019 .52101 L
.62123 .51012 L
.65912 .48531 L
.69946 .45151 L
.73829 .41181 L
.77956 .36188 L
Mistroke
.81932 .30625 L
.85757 .24577 L
.89827 .17391 L
.93745 .09741 L
.97619 .01472 L
Mfstroke
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00@P3oool2000000@0oooo0P0000030?ooo`@000009@3oool2000000@0oooo0P0000050?oo
o`<000008`3oool2000000@0oooo0P0000030?ooo`<000009P3oool2000000@0oooo0P0000040?oo
o`800000:`3oool5000000D0oooo00110?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0240oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?ooo`00@@3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool00000203oool5
00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?oo
o`00@@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02<0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo
0`00000U0?ooo`040000003oool0oooo000000T0oooo0P00000]0?ooo`030000003oool0oooo00D0
oooo00110?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000903oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002<0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;03oool00`000000oooo0?ooo`050?ooo`00@P3oool2000000X0oooo0P00000V0?ooo`800000
2`3oool2000002@0oooo0P00000:0?ooo`<000009@3oool2000000X0oooo0P00000/0?ooo`800000
1`3oool00?l0oooo8@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`003`3ooooo0000014000000@3oool001D0oooo20000005
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0080oooo2@0000070?ooo`005@3oool5000000<0oooo1000000X0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo02D0oooo100000030?ooo`H000001`3oool001D0oooo1`0000050?ooo`@0
0000i03oool3000000D0oooo1`0000080?ooo`005@3oool00`000000oooo00000006000000L0oooo
1000003L0?ooo`@000001P3oool4000000040?ooo`0000000000000000T0oooo000E0?ooo`030000
003oool0000000<0000000<0oooo0000003oool00`0000080?ooo`D00000d`3oool4000000P0oooo
0P0000000`3oool000000?ooo`05000000T0oooo000E0?ooo`L0000000<0oooo0000000000000P3o
ool2000000/0oooo1P0000370?ooo`H000002P3oool2000000040?ooo`00000000000?ooo`800000
00<0oooo0000000000002P3oool001D0oooo00<000000?ooo`3oool01@0000020?ooo`040000003o
ool0oooo0?ooo`8000003`3oool500000;d0oooo1@00000>0?ooo`8000000P3oool01@000000oooo
0?ooo`000000oooo00@000002P3oool001D0oooo00<000000?ooo`3oool00`0000000`3oool00000
000000020?ooo`8000000`3oool300000140oooo1@00002b0?ooo`H000004@3oool200000080oooo
0P0000020?ooo`030000003oool0000000<000002`3oool001D0oooo00@000000?ooo`3oool0oooo
100000000`3oool000000?ooo`020?ooo`030000003oool0oooo00<0oooo0P00000D0?ooo`D00000
Y@3oool8000001D0oooo0P0000030?ooo`060000003oool0oooo0?ooo`000000oooo1@00000;0?oo
o`005@3oool010000000oooo0?ooo`3oool5000000030?ooo`000000oooo0080oooo0P0000050?oo
o`<000005P3oool6000009L0oooo2000000J0?ooo`<00000103oool020000000oooo0?ooo`3oool0
00000?ooo`000000oooo1000000;0?ooo`005@3oool010000000oooo0?ooo`3oool4000000040?oo
o`000000oooo000000@0oooo00<000000?ooo`3oool01@3oool3000001T0oooo200000290?ooo`H0
00007`3oool3000000D0oooo0P0000030?ooo`040000003oool000000?ooo`@00000303oool001D0
oooo00<000000?ooo`3oool00P3oool4000000040?ooo`000000oooo000000@0oooo0P0000080?oo
o`8000007`3oool;000007L0oooo1`00000S0?ooo`8000001`3oool00`000000oooo0?ooo`020?oo
o`040000003oool000000?ooo`D00000303oool001D0oooo0P0000030?ooo`80000000H0oooo0000
00000000oooo0000003oool2000000@0oooo00<000000?ooo`3oool01`3oool3000002L0oooo2`00
001Q0?ooo`/000009`3oool3000000L0oooo0P0000040?ooo`060000003oool000000?ooo`000000
oooo0`00000=0?ooo`005@3oool00`000000oooo0?ooo`030?ooo`@000000P3oool010000000oooo
0?ooo`0000040?ooo`8000002P3oool3000002l0oooo2P00001<0?ooo`/00000;`3oool3000000T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020?ooo`D000003@3oool001D0oooo
00<000000?ooo`3oool00`3oool2000000030?ooo`00000000000080oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`0:0?ooo`800000=`3oool>00000340oooo3@00000g0?ooo`<0
00002P3oool2000000@0oooo0P000000103oool000000?ooo`3oool2000000030?ooo`0000000000
00h0oooo000E0?ooo`030000003oool0oooo00<0oooo100000001@3oool000000?ooo`3oool00000
0080oooo00<000000?ooo`3oool00`3oool2000000`0oooo0`0000120?oooc400000@P3oool20000
00`0oooo00<000000?ooo`3oool00`3oool020000000oooo0?ooo`3oool000000?ooo`000000oooo
1000000>0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`80000000@0oooo0000003oool00000
0P3oool010000000oooo0?ooo`0000060?ooo`8000003@3oool200000;00oooo0`00000<0?ooo`80
00001@3oool01@000000oooo0?ooo`3oool000000080oooo0P000000103oool000000?ooo`00000>
0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`<0000000<0oooo0000000000000`3oool00`00
0000oooo0?ooo`02000000H0oooo0P00000=0?ooo`<00000ZP3oool3000000d0oooo0P0000060?oo
o`050000003oool0oooo0?ooo`0000000P3oool2000000040?ooo`0000000000000000l0oooo000E
0?ooo`8000001P3oool2000000040?ooo`000000oooo00000080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`050?ooo`8000003P3oool400000:80oooo1000000?0?ooo`030000003o
ool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool000000?ooo`00
0000oooo0000000?0?ooo`005@3oool00`000000oooo0?ooo`050?ooo`<0000000@0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo0P00000@0?oo
o`@00000VP3oool400000140oooo0P0000070?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0000003oool300000100oooo000E0?ooo`030000003oool0oooo00D0oooo00P00000
0?ooo`00000000000?ooo`000000oooo00000080oooo00<000000?ooo`3oool00P3oool2000000P0
oooo00<000000?ooo`3oool04@3oool3000009@0oooo0`00000C0?ooo`8000001`3oool2000000<0
oooo00H000000?ooo`3oool0oooo0000003oool3000000030?ooo`000000oooo00l0oooo000E0?oo
o`030000003oool0oooo00H0oooo0`0000001@3oool000000?ooo`3oool000000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`800000503oool4000008`0oooo1000000D
0?ooo`800000203oool00`000000oooo0?ooo`030?ooo`070000003oool0oooo0000003oool00000
0?ooo`0300000140oooo000E0?ooo`030000003oool0oooo00H0oooo00P000000?ooo`0000000000
0?ooo`000000oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?oo
o`8000005P3oool4000008@0oooo1000000F0?ooo`8000002@3oool00`000000oooo0?ooo`030?oo
o`090000003oool0oooo0000003oool000000?ooo`000000oooo008000004@3oool001D0oooo00<0
00000?ooo`3oool01`3oool300000080oooo00<000000?ooo`0000000`3oool00`000000oooo0?oo
o`030?ooo`8000002@3oool00`000000oooo0?ooo`0G0?ooo`@00000O03oool4000001P0oooo0P00
000:0?ooo`030000003oool0oooo00<0oooo00P000000?ooo`3oool0oooo0000003oool000000?oo
o`<000004P3oool001D0oooo00<000000?ooo`3oool01`3oool01P000000oooo000000000000oooo
00000080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00L0oooo0P00
000K0?ooo`H00000L@3oool5000001X0oooo0P00000;0?ooo`030000003oool0oooo00<0oooo00X0
00000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo0P00000B0?ooo`005@3oool20000
00P0oooo00L000000?ooo`000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo
000000060?ooo`030000003oool0oooo00P0oooo0P00000O0?ooo`D00000I`3oool5000001`0oooo
0`00000;0?ooo`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`00
000000000?ooo`00000B0?ooo`005@3oool00`000000oooo0?ooo`080?ooo`040000003oool00000
00000080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`8000002P3o
ool200000280oooo1P00001K0?ooo`H000007`3oool2000000d0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`000000oooo0P00000C0?ooo`00
5@3oool00`000000oooo0?ooo`080?ooo`070000003oool000000?ooo`000000oooo000000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?oo
o`8000009P3oool500000540oooo1@00000S0?ooo`8000003P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool000000?ooo`02000000030?ooo`000000
oooo0180oooo000E0?ooo`030000003oool0oooo00T0oooo00@000000?ooo`00000000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo00D0oooo0P00000;0?ooo`800000:@3o
ool5000004H0oooo1P00000V0?ooo`8000003P3oool2000000H0oooo00<000000?ooo`3oool00P3o
ool01`000000oooo0?ooo`000000oooo0000003oool00P00000D0?ooo`000P3oool2000000@0oooo
0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`090?ooo`050000003oool000000?ooo`00
00000P3oool010000000oooo0?ooo`0000040?ooo`8000001`3oool00`000000oooo0?ooo`0:0?oo
o`800000;03oool5000003`0oooo1@00000Z0?ooo`8000003`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0080oooo00X000000?ooo`3oool000000?ooo`000000oooo0000003oool0
0000503oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo00X0oooo00L000000?ooo`000000oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo0P00
000_0?ooo`/000008P3oool?000002`0oooo0`00000?0?ooo`8000001`3oool00`000000oooo0?oo
o`020?ooo`080000003oool0oooo0?ooo`000000oooo0000003oool2000001D0oooo00001@3oool0
00000?ooo`3oool0000000/0oooo00<000000?ooo`3oool00P3oool3000000X0oooo00D000000?oo
o`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?oo
o`050?ooo`8000003@3oool3000003L0oooo8P00000i0?ooo`800000403oool2000000P0oooo00<0
00000?ooo`3oool00P3oool02`000000oooo0?ooo`3oool000000?ooo`000000oooo0000003oool0
000001D0oooo00001@3oool000000?ooo`3oool0000000T0oooo0P0000050?ooo`030000003oool0
oooo00/0oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00d0oooo0`00002=0?ooo`800000
4@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00/000000?ooo`3oool0
oooo0000003oool000000?ooo`000000oooo0000000E0?ooo`0000D0oooo0000003oool0oooo0000
00090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool01@000000oooo0000
003oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00H0oooo0P00000@0?ooo`800000R@3oool200000140oooo0P0000090?ooo`030000
003oool0oooo00<0oooo00/000000?ooo`3oool0oooo0000003oool000000?ooo`000000oooo0000
000F0?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo00`0oooo00D00000
0?ooo`000000oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00l0oooo0`0000240?ooo`8000004P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool000000?ooo`0000005P3oool001D0oooo00<000000?ooo`3oool0
303oool00`000000oooo000000020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`070?ooo`8000004P3oool3000007h0oooo0`00000B0?ooo`80
00002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00L000000?ooo`00
0000oooo0000003oool0000001L0oooo000E0?ooo`030000003oool0oooo00d0oooo00D000000?oo
o`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0180oooo0`00001i0?ooo`800000503oool00`000000oooo0?oo
o`080?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`080000003oool0oooo0000003oool0
00000?ooo`00000G0?ooo`005@3oool2000000h0oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool20000
01D0oooo0P00001d0?ooo`<00000503oool2000000X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`020?ooo`080000003oool0oooo0000003oool000000?ooo`00000H0?ooo`005@3o
ool00`000000oooo0?ooo`0>0?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool2000001D0oooo
0`00001_0?ooo`8000005@3oool2000000/0oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`00000H0?ooo`005@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool000000080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00@0oooo0P00000;0?ooo`030000003oool0oooo01D0oooo0`00001Y
0?ooo`<000005P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00P3oool020000000oooo0?ooo`000000oooo0000003oool000006@3oool001D0oooo
00<000000?ooo`3oool03`3oool00`000000oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0P00000H0?ooo`@0
0000H@3oool4000001L0oooo0P00000<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0000001T0oooo000E0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
01T0oooo1000001I0?ooo`@000006P3oool00`000000oooo0?ooo`0:0?ooo`8000001`3oool00`00
0000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`030000003o
ool0oooo01L0oooo000E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0:0?ooo`8000007@3oool400000540oooo1000000L0?ooo`800000303oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0000001X0oooo000E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`0;0?ooo`8000007`3oool5000004H0oooo1P00000N0?ooo`8000003@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000J0?ooo`005@3oool200000180oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0<0?ooo`8000008P3oool5000003`0oooo1@00000R0?ooo`8000003@3oool2000000P0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`0000006`3oool001D0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?oo
o`8000003P3oool2000002D0oooo1P00000a0?ooo`D000009@3oool2000000h0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`00000K0?ooo`005@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool03@3oool2000002T0oooo3000000H0?ooo`d00000:03oool2000000l0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0000000L0?ooo`005@3oool00`000000oooo0?ooo`0B0?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool03P3oool2000003<0oooo6000000d0?ooo`030000
003oool0oooo00d0oooo0P0000090?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo000001`0oooo000E0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`800000N`3oool2000000l0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0000000M0?ooo`005@3oool00`000000oooo0?ooo`0C0?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0403oool2000007L0oooo0P00000@0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool06`3oool001D0oooo0P00000E0?oo
o`030000003oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00L0oooo0P00000B0?ooo`800000L`3oool200000100oooo0P00000:0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000007P3oool001D0oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0140oooo0P00001_0?ooo`8000004@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool0703oool001D0oooo00<000000?ooo`3oool05@3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0180oooo0`00001Y0?ooo`<00000
4@3oool2000000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool07@3oool001D0oooo00<000000?ooo`3oool0
5@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`080?ooo`8000005@3oool3000006<0oooo0`00000C0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0M0?ooo`005@3oool00`000000
oooo0?ooo`0F0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool20000
05l0oooo0P00000E0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool07P3oool0
01D0oooo00<000000?ooo`3oool05P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`8000005`3oool3
000005T0oooo0`00000E0?ooo`800000303oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01h0oooo000E
0?ooo`030000003oool0oooo01L0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool2000001P0oooo0`00
001C0?ooo`<000005`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
7`3oool001D0oooo0P00000H0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00D0oooo0P00000<0?ooo`030000003oool0oooo01P0oooo
0`00001<0?ooo`@000006@3oool00`000000oooo0?ooo`0:0?ooo`8000001`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000008@3oool001D0oooo
00<000000?ooo`3oool0603oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?ooo`8000006`3oool4000004@0
oooo1000000K0?ooo`800000303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0200oooo000E0?ooo`03
0000003oool0oooo01P0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
01`0oooo1000000l0?ooo`@000007P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
00000280oooo000E0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool2
00000200oooo1P00000a0?ooo`D00000803oool2000000d0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000008`3o
ool000d0oooo1@0000030?ooo`030000003oool0oooo01T0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0<0?ooo`800000903oool5000002H0oooo1P00000S0?ooo`8000003P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?oo
o`00000S0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01X0oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool03@3oool2000002L0oooo1`00000H0?ooo`L00000:03oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`040000003oool0oooo000002@0oooo000?0?ooo`030000003oool0oooo00<0oooo
0`00000J0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool03P3oool2000002`0oooo6000000]0?ooo`80
00003`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000002@0oooo000?0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool06`3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`070?ooo`800000403oool2000006d0oooo0P00000?0?oo
o`8000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000009@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0K0?oo
o`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool03`3oool2000006T0oooo0P00000@0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000009@3oool000h0oooo0P0000050?ooo`030000003oool0oooo01`0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0@0?ooo`800000I@3oool200000140oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo
0000000V0?ooo`005@3oool00`000000oooo0?ooo`0L0?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
4@3oool200000640oooo0P00000B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000009P3oool001D0oooo
00<000000?ooo`3oool07@3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0180oooo0P00001M0?ooo`80
00004`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool0000002L0oooo000E0?ooo`8000007P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`090?ooo`800000503oool2000005T0oooo0P00000C0?ooo`8000002P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0U0?ooo`005@3oool00`000000oooo0?ooo`0N0?ooo`050000003oool0oooo0?ooo`00
00001@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool04`3oool3000005<0oooo0`00000D0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool09P3oool001D0oooo00<000000?ooo`3oool07`3oool01@000000oooo0?ooo`3oool0000000D0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0
oooo0P00001>0?ooo`<000005P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0
oooo000E0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool2000001L0oooo
0`0000190?ooo`8000005`3oool2000000/0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09`3oool001D0oooo00<0
00000?ooo`3oool0803oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01L0oooo0P0000140?ooo`<00000
603oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02L0oooo000E0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0H0?ooo`<00000?@3o
ool4000001X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0X0?ooo`005@3oool0
0`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00/0oooo0P00000K0?ooo`<00000=P3oool4000001`0oooo0P00
000<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo02T0oooo000E0?ooo`8000008P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo01/0oooo1000000_0?ooo`<000007`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02T0oooo000E0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0N0?ooo`D000009P3oool400000200oooo0P00000=0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo02X0oooo000E0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo0P00000=0?ooo`80
00008`3oool9000001<0oooo2P00000S0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0:`3oool001D0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo02T0oooo4`00000[0?ooo`8000003P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0[0?ooo`005@3o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00`0oooo0P00001U0?ooo`8000003`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0/0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00d0oooo0P00001Q0?ooo`800000403oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0/0?ooo`005@3oool20000
02H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool03P3oool2000005d0oooo0P00000A0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
02d0oooo000E0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool03`3oool2000005T0
oooo0P00000B0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02h0oooo000E0?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool0403oool2000005D0oooo0P00000C0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02h0oooo
000E0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00T0oooo0P00000B0?ooo`800000D@3oool2000001<0oooo0P00
000:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0_0?ooo`005@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0140oooo0P00001=
0?ooo`800000503oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0_0?ooo`005@3oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0180oooo0`0000180?ooo`8000005@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0`0?oo
o`005@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01@0oooo0P0000140?ooo`80
00005P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0a0?ooo`005@3oool2000002X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
5@3oool3000003h0oooo0`00000F0?ooo`8000002`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0<@3oool001D0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3o
ool2000001P0oooo0`00000i0?ooo`800000603oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0b0?ooo`005@3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01P0oooo1000000a0?ooo`@000006@3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0c0?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
01/0oooo1000000W0?ooo`H000006`3oool2000000d0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo03<0oooo00000`3oool000000000000300000080
oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`8000007`3oool300000200
oooo1000000P0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo03@0oooo00030?ooo`030000003oool0oooo00L0oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo01l0
oooo1`00000C0?ooo`H000008P3oool2000000h0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo03D0oooo00030?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool00P3oool3000002d0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00`0oooo0P00000V0?oooa<000009P3oool2000000l0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03D0oooo
00030?ooo`030000003oool0oooo00P0oooo0P0000050?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo0P00
001L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo03H0oooo00030?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo05L0oooo0P00000@
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0f
0?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00h0oooo0P00001F0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo03L0oooo000E0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0D@3oool200000140oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo03P0oooo000E0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`080?ooo`800000403oool2000004l0oooo0P00000B0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0h0?ooo`005@3o
ool200000340oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00l0oooo0P00001;0?ooo`8000004`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0>@3oool001D0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0403oool2
000004L0oooo0P00000D0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0j0?ooo`005@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0A0?ooo`800000@`3oool20000
01D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
03X0oooo000E0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0180oooo0`00000n0?ooo`8000005P3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0>`3oool001D0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0503oool3000003T0oooo0P00000G0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0l0?ooo`005@3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool2000001L0oooo0`00
000c0?ooo`<000005`3oool2000000/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0l0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0G0?ooo`800000;P3oool3000001T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo03d0oooo000E0?oo
o`800000=P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0603oool4000002H0oooo1000000K0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0n0?ooo`005@3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool2000001`0oooo1000000N0?ooo`@0
00007@3oool2000000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0o0?ooo`00
5@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0M0?ooo`L000004@3oool600000200oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo03l0oooo000E0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo02<0oooo4@00000U0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`100?ooo`005@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0
oooo00P0oooo00<000000?ooo`3oool0303oool2000005L0oooo0P00000=0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0@@3oool001D0oooo00<000000?ooo`3oool0>@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0D`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0@P3oool001D0
oooo0P00000k0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool03@3oool200000540
oooo0P00000?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0@P3oool001D0oooo
00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00h0oooo
0P00001=0?ooo`800000403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04<0oooo
000E0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo04P0oooo0P00000A0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0A03oool001D0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00l0oooo0P0000160?ooo`8000004P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo04D0oooo000E0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`0@0?ooo`800000@P3oool2000001<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`150?ooo`005@3oool00`000000oooo0?ooo`0n0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool04@3oool2000003h0oooo0P00000D0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0AP3oool001D0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`090?ooo`8000004`3oool3000003T0oooo0P00000D0?ooo`800000
2P3oool00`000000oooo0?ooo`170?ooo`005@3oool200000440oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0C0?ooo`800000=03oool3000001D0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`180?ooo`005@3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0503oool2000002l0oooo0`00000G0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0B@3oool001D0oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo01D0oooo0P00000Z0?ooo`<000006@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo04T0oooo000E0?ooo`030000003oool0oooo0480
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0F0?ooo`<000009@3oool2000001/0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1:0?ooo`003@3oool4000000@0oooo
00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0;0?ooo`8000006@3oool4000001h0oooo
0`00000K0?ooo`800000303oool00`000000oooo0?ooo`1;0?ooo`003@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`0J0?ooo`L000004@3oool6000001d0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`1<0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`<00000A@3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0200oooo4@00000R0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0C@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo00`0oooo0P00001A0?ooo`8000003@3oool00`000000oooo0?ooo`1>0?oo
o`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04H0oooo00<000000?oo
o`3oool03P3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0CP3oool000h0oooo0P0000050?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`1:0?ooo`8000003`3oool00`000000oooo0?ooo`1?0?ooo`00
5@3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo00h0oooo0P0000180?ooo`800000
403oool00`000000oooo0?ooo`1@0?ooo`005@3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo0540oooo000E0?ooo`800000B`3oool00`000000oooo0?ooo`0?0?ooo`800000@P3oool2
00000140oooo00<000000?ooo`3oool0DP3oool001D0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`1C0?ooo`005@3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo0100
oooo0P00000l0?ooo`8000004P3oool00`000000oooo0?ooo`1D0?ooo`005@3oool00`000000oooo
0?ooo`1=0?ooo`030000003oool0oooo0140oooo0P00000h0?ooo`8000004P3oool2000005L0oooo
000E0?ooo`030000003oool0oooo04h0oooo0P00000C0?ooo`<00000<`3oool2000001<0oooo00<0
00000?ooo`3oool0E`3oool001D0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0C
0?ooo`800000;P3oool3000001@0oooo00<000000?ooo`3oool0F03oool001D0oooo00<000000?oo
o`3oool0D@3oool00`000000oooo0?ooo`0D0?ooo`<00000:03oool3000001H0oooo00<000000?oo
o`3oool0F@3oool001D0oooo0P00001C0?ooo`030000003oool0oooo01H0oooo0`00000S0?ooo`80
0000603oool00`000000oooo0?ooo`1J0?ooo`005@3oool00`000000oooo0?ooo`1C0?ooo`030000
003oool0oooo01P0oooo0P00000K0?ooo`H000006@3oool00`000000oooo0?ooo`1K0?ooo`005@3o
ool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo01T0oooo2000000>0?ooo`D000007@3o
ool2000005h0oooo000E0?ooo`030000003oool0oooo05D0oooo0P00000Q0?ooo`h000008@3oool0
0`000000oooo0?ooo`1N0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo
04`0oooo00<000000?ooo`3oool0G`3oool001D0oooo00<000000?ooo`3oool0F03oool00`000000
oooo0?ooo`190?ooo`800000HP3oool001D0oooo0P00001J0?ooo`800000B03oool00`000000oooo
0?ooo`1R0?ooo`005@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0H`3oool001D0oooo00<000000?ooo`3oool0G03oool200000480oooo0P00001V
0?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo03h0oooo00<000000?oo
o`3oool0IP3oool001D0oooo00<000000?ooo`3oool0G`3oool2000003`0oooo0P00001Y0?ooo`00
5@3oool00`000000oooo0?ooo`1Q0?ooo`800000>03oool2000006/0oooo000E0?ooo`030000003o
ool0oooo06<0oooo0P00000d0?ooo`800000K@3oool001D0oooo0P00001V0?ooo`800000;`3oool3
000006l0oooo000E0?ooo`030000003oool0oooo06L0oooo0P00000Z0?ooo`<00000LP3oool001D0
oooo00<000000?ooo`3oool0J@3oool2000002H0oooo0P00001e0?ooo`005@3oool00`000000oooo
0?ooo`1[0?ooo`<00000803oool3000007L0oooo00000`3oool0000000000002000000<0oooo0P00
00040?ooo`8000001@3oool00`000000oooo0?ooo`1^0?ooo`D00000603oool3000007X0oooo0000
0`3oool000000?ooo`0:0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0L`3o
ool5000000h0oooo1@00001m0?ooo`000P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0080oooo0`00001h0?ooo`h00000PP3oool000<0oooo00<000000?ooo`3oool0203oool20000
00D0oooo00<000000?ooo`3oool0o`3oool90?ooo`0000D0oooo0000003oool0oooo000000090?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oool90?ooo`000P3oool2000000X0
oooo0`0000040?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0
o`3oool90?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0829852, -0.193675, \
0.00386179, 0.0156212}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["Dosad\[IAcute]me tento tvar do rovnice", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rovApr = 
      rov /. {T[x] \[Rule] 
            Tapr, \(T''\)[x] -> \[PartialD]\_\(x, x\)Tapr}\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ a \[Equal] 
      0.6000000000000001`\ \((\(-20\) + a\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell["\<\
A p\:0159evedeme v\[SHacek]e na jednu stranu.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Residuum = 
      rovApr /. Equal[Left_, Right_] \[Rule] \(-Left\) + Right\)], "Input"],

Cell[BoxData[
    \(2\ a + 
      0.6000000000000001`\ \((\(-20\) + a\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell["\<\
Dostaneme tedy n\:011bco co chceme vynulovat, tak zvan\[EAcute] residuum\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Table[Residuum, {a, 0, 10}]], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.343238 0.0273769 [
[.21429 .33074 -9 -9 ]
[.21429 .33074 9 0 ]
[.40476 .33074 -9 -9 ]
[.40476 .33074 9 0 ]
[.59524 .33074 -9 -9 ]
[.59524 .33074 9 0 ]
[.78571 .33074 -9 -9 ]
[.78571 .33074 9 0 ]
[.97619 .33074 -3 -9 ]
[.97619 .33074 3 0 ]
[.01131 .06947 -18 -4.5 ]
[.01131 .06947 0 4.5 ]
[.01131 .20635 -12 -4.5 ]
[.01131 .20635 0 4.5 ]
[.01131 .48012 -6 -4.5 ]
[.01131 .48012 0 4.5 ]
[.01131 .61701 -12 -4.5 ]
[.01131 .61701 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .34324 m
.21429 .34949 L
s
[(0.2)] .21429 .33074 0 1 Mshowa
.40476 .34324 m
.40476 .34949 L
s
[(0.4)] .40476 .33074 0 1 Mshowa
.59524 .34324 m
.59524 .34949 L
s
[(0.6)] .59524 .33074 0 1 Mshowa
.78571 .34324 m
.78571 .34949 L
s
[(0.8)] .78571 .33074 0 1 Mshowa
.97619 .34324 m
.97619 .34949 L
s
[(1)] .97619 .33074 0 1 Mshowa
.125 Mabswid
.07143 .34324 m
.07143 .34699 L
s
.11905 .34324 m
.11905 .34699 L
s
.16667 .34324 m
.16667 .34699 L
s
.2619 .34324 m
.2619 .34699 L
s
.30952 .34324 m
.30952 .34699 L
s
.35714 .34324 m
.35714 .34699 L
s
.45238 .34324 m
.45238 .34699 L
s
.5 .34324 m
.5 .34699 L
s
.54762 .34324 m
.54762 .34699 L
s
.64286 .34324 m
.64286 .34699 L
s
.69048 .34324 m
.69048 .34699 L
s
.7381 .34324 m
.7381 .34699 L
s
.83333 .34324 m
.83333 .34699 L
s
.88095 .34324 m
.88095 .34699 L
s
.92857 .34324 m
.92857 .34699 L
s
.25 Mabswid
0 .34324 m
1 .34324 L
s
.02381 .06947 m
.03006 .06947 L
s
[(-10)] .01131 .06947 1 0 Mshowa
.02381 .20635 m
.03006 .20635 L
s
[(-5)] .01131 .20635 1 0 Mshowa
.02381 .48012 m
.03006 .48012 L
s
[(5)] .01131 .48012 1 0 Mshowa
.02381 .61701 m
.03006 .61701 L
s
[(10)] .01131 .61701 1 0 Mshowa
.125 Mabswid
.02381 .09685 m
.02756 .09685 L
s
.02381 .12422 m
.02756 .12422 L
s
.02381 .1516 m
.02756 .1516 L
s
.02381 .17898 m
.02756 .17898 L
s
.02381 .23373 m
.02756 .23373 L
s
.02381 .26111 m
.02756 .26111 L
s
.02381 .28848 m
.02756 .28848 L
s
.02381 .31586 m
.02756 .31586 L
s
.02381 .37062 m
.02756 .37062 L
s
.02381 .39799 m
.02756 .39799 L
s
.02381 .42537 m
.02756 .42537 L
s
.02381 .45275 m
.02756 .45275 L
s
.02381 .5075 m
.02756 .5075 L
s
.02381 .53488 m
.02756 .53488 L
s
.02381 .56225 m
.02756 .56225 L
s
.02381 .58963 m
.02756 .58963 L
s
.02381 .04209 m
.02756 .04209 L
s
.02381 .01472 m
.02756 .01472 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .01472 L
.10458 .01472 L
.14415 .01472 L
.18221 .01472 L
.22272 .01472 L
.26171 .01472 L
.30316 .01472 L
.34309 .01472 L
.3815 .01472 L
.42237 .01472 L
.46172 .01472 L
.49955 .01472 L
.53984 .01472 L
.57861 .01472 L
.61984 .01472 L
.65954 .01472 L
.69774 .01472 L
.73838 .01472 L
.77751 .01472 L
.81909 .01472 L
.85916 .01472 L
.89771 .01472 L
.93871 .01472 L
.97619 .01472 L
s
.02381 .06947 m
.06244 .07011 L
.10458 .07074 L
.14415 .07128 L
.18221 .07175 L
.22272 .07218 L
.26171 .07255 L
.30316 .07287 L
.34309 .07313 L
.3815 .07332 L
.40095 .0734 L
.42237 .07347 L
.44268 .07352 L
.45178 .07353 L
.46172 .07355 L
.4671 .07356 L
.4721 .07356 L
.47727 .07357 L
.48196 .07357 L
.48658 .07357 L
.4887 .07357 L
.49093 .07357 L
.49332 .07357 L
.49438 .07357 L
.49552 .07358 L
.49675 .07358 L
.49789 .07358 L
.49859 .07358 L
.49925 .07358 L
.50049 .07358 L
.50163 .07358 L
.50286 .07358 L
.50401 .07358 L
.50508 .07358 L
.50754 .07357 L
.51014 .07357 L
.51268 .07357 L
.51504 .07357 L
.5204 .07357 L
.5293 .07356 L
.53882 .07355 L
.54906 .07353 L
.56016 .07351 L
.58032 .07346 L
.60019 .07339 L
.62123 .07331 L
.65912 .07312 L
.69946 .07285 L
.73829 .07255 L
.77956 .07216 L
Mistroke
.81932 .07173 L
.85757 .07126 L
.89827 .0707 L
.93745 .07011 L
.97619 .06947 L
Mfstroke
.02381 .12422 m
.06244 .1255 L
.10458 .12677 L
.14415 .12785 L
.18221 .12878 L
.22272 .12965 L
.26171 .13038 L
.30316 .13103 L
.34309 .13154 L
.3815 .13193 L
.40095 .13208 L
.42237 .13222 L
.44268 .13232 L
.45178 .13235 L
.46172 .13238 L
.4671 .1324 L
.4721 .13241 L
.47727 .13242 L
.48196 .13242 L
.48658 .13243 L
.4887 .13243 L
.49093 .13243 L
.49332 .13243 L
.49438 .13243 L
.49552 .13244 L
.49675 .13244 L
.49789 .13244 L
.49859 .13244 L
.49925 .13244 L
.50049 .13244 L
.50163 .13244 L
.50286 .13244 L
.50401 .13244 L
.50508 .13243 L
.50754 .13243 L
.51014 .13243 L
.51268 .13243 L
.51504 .13243 L
.5204 .13242 L
.5293 .1324 L
.53882 .13238 L
.54906 .13235 L
.56016 .1323 L
.58032 .1322 L
.60019 .13207 L
.62123 .1319 L
.65912 .13152 L
.69946 .13099 L
.73829 .13038 L
.77956 .12961 L
Mistroke
.81932 .12874 L
.85757 .1278 L
.89827 .12669 L
.93745 .1255 L
.97619 .12422 L
Mfstroke
.02381 .17898 m
.06244 .18089 L
.10458 .1828 L
.14415 .18442 L
.18221 .18581 L
.22272 .18712 L
.26171 .18821 L
.30316 .18919 L
.34309 .18996 L
.3815 .19053 L
.40095 .19076 L
.42237 .19097 L
.44268 .19112 L
.45178 .19117 L
.46172 .19122 L
.4671 .19124 L
.4721 .19125 L
.47727 .19127 L
.48196 .19128 L
.48658 .19129 L
.4887 .19129 L
.49093 .19129 L
.49332 .19129 L
.49438 .19129 L
.49552 .1913 L
.49675 .1913 L
.49789 .1913 L
.49859 .1913 L
.49925 .1913 L
.50049 .1913 L
.50163 .1913 L
.50286 .1913 L
.50401 .1913 L
.50508 .19129 L
.50754 .19129 L
.51014 .19129 L
.51268 .19129 L
.51504 .19128 L
.5204 .19127 L
.5293 .19125 L
.53882 .19121 L
.54906 .19117 L
.56016 .1911 L
.58032 .19095 L
.60019 .19075 L
.62123 .1905 L
.65912 .18992 L
.69946 .18913 L
.73829 .18821 L
.77956 .18705 L
Mistroke
.81932 .18576 L
.85757 .18435 L
.89827 .18268 L
.93745 .1809 L
.97619 .17898 L
Mfstroke
.02381 .23373 m
.06244 .23629 L
.10458 .23883 L
.14415 .24098 L
.18221 .24284 L
.22272 .24459 L
.26171 .24604 L
.30316 .24735 L
.34309 .24837 L
.3815 .24914 L
.40095 .24945 L
.42237 .24972 L
.44268 .24992 L
.45178 .24999 L
.46172 .25005 L
.4671 .25008 L
.4721 .2501 L
.47727 .25012 L
.48196 .25013 L
.48658 .25014 L
.4887 .25015 L
.49093 .25015 L
.49332 .25015 L
.49438 .25015 L
.49552 .25016 L
.49675 .25016 L
.49789 .25016 L
.49859 .25016 L
.49925 .25016 L
.50049 .25016 L
.50163 .25016 L
.50286 .25016 L
.50401 .25016 L
.50508 .25015 L
.50754 .25015 L
.51014 .25015 L
.51268 .25014 L
.51504 .25014 L
.5204 .25013 L
.5293 .25009 L
.53882 .25005 L
.54906 .24998 L
.56016 .24989 L
.58032 .24969 L
.60019 .24943 L
.62123 .24909 L
.65912 .24832 L
.69946 .24727 L
.73829 .24604 L
.77956 .2445 L
Mistroke
.81932 .24277 L
.85757 .24089 L
.89827 .23867 L
.93745 .23629 L
.97619 .23373 L
Mfstroke
.02381 .28848 m
.06244 .29168 L
.10458 .29486 L
.14415 .29755 L
.18221 .29987 L
.22272 .30206 L
.26171 .30388 L
.30316 .30551 L
.34309 .30679 L
.3815 .30775 L
.40095 .30813 L
.42237 .30847 L
.44268 .30872 L
.45178 .30881 L
.46172 .30888 L
.4671 .30892 L
.4721 .30895 L
.47727 .30897 L
.48196 .30899 L
.48658 .309 L
.4887 .30901 L
.49093 .30901 L
.49332 .30901 L
.49438 .30901 L
.49552 .30902 L
.49675 .30902 L
.49789 .30902 L
.49859 .30902 L
.49925 .30902 L
.50049 .30902 L
.50163 .30902 L
.50286 .30902 L
.50401 .30902 L
.50508 .30901 L
.50754 .30901 L
.51014 .30901 L
.51268 .309 L
.51504 .309 L
.5204 .30898 L
.5293 .30894 L
.53882 .30888 L
.54906 .3088 L
.56016 .30869 L
.58032 .30843 L
.60019 .30811 L
.62123 .30769 L
.65912 .30672 L
.69946 .30541 L
.73829 .30388 L
.77956 .30194 L
Mistroke
.81932 .29978 L
.85757 .29744 L
.89827 .29465 L
.93745 .29169 L
.97619 .28848 L
Mfstroke
.02381 .34324 m
.06244 .34707 L
.10458 .35089 L
.14415 .35412 L
.18221 .3569 L
.22272 .35952 L
.26171 .36171 L
.30316 .36367 L
.34309 .3652 L
.3815 .36635 L
.40095 .36681 L
.42237 .36722 L
.44268 .36752 L
.45178 .36762 L
.46172 .36772 L
.4671 .36776 L
.4721 .36779 L
.47727 .36782 L
.48196 .36784 L
.48658 .36786 L
.4887 .36786 L
.49093 .36787 L
.49332 .36787 L
.49438 .36787 L
.49552 .36788 L
.49675 .36788 L
.49789 .36788 L
.49859 .36788 L
.49925 .36788 L
.50049 .36788 L
.50163 .36788 L
.50286 .36788 L
.50401 .36788 L
.50508 .36787 L
.50754 .36787 L
.51014 .36787 L
.51268 .36786 L
.51504 .36785 L
.5204 .36783 L
.5293 .36778 L
.53882 .36771 L
.54906 .36762 L
.56016 .36748 L
.58032 .36718 L
.60019 .36679 L
.62123 .36628 L
.65912 .36513 L
.69946 .36355 L
.73829 .36171 L
.77956 .35939 L
Mistroke
.81932 .3568 L
.85757 .35398 L
.89827 .35064 L
.93745 .34708 L
.97619 .34324 L
Mfstroke
.02381 .39799 m
.06244 .40247 L
.10458 .40692 L
.14415 .41069 L
.18221 .41394 L
.22272 .41699 L
.26171 .41954 L
.30316 .42183 L
.34309 .42362 L
.3815 .42496 L
.40095 .42549 L
.42237 .42597 L
.44268 .42632 L
.45178 .42644 L
.46172 .42655 L
.4671 .4266 L
.4721 .42664 L
.47727 .42667 L
.48196 .4267 L
.48658 .42671 L
.4887 .42672 L
.49093 .42673 L
.49332 .42673 L
.49438 .42673 L
.49552 .42674 L
.49675 .42674 L
.49789 .42674 L
.49859 .42674 L
.49925 .42674 L
.50049 .42674 L
.50163 .42674 L
.50286 .42674 L
.50401 .42674 L
.50508 .42673 L
.50754 .42673 L
.51014 .42672 L
.51268 .42672 L
.51504 .42671 L
.5204 .42669 L
.5293 .42663 L
.53882 .42655 L
.54906 .42643 L
.56016 .42628 L
.58032 .42592 L
.60019 .42547 L
.62123 .42487 L
.65912 .42353 L
.69946 .42169 L
.73829 .41954 L
.77956 .41683 L
Mistroke
.81932 .41381 L
.85757 .41053 L
.89827 .40663 L
.93745 .40248 L
.97619 .39799 L
Mfstroke
.02381 .45275 m
.06244 .45786 L
.10458 .46295 L
.14415 .46725 L
.18221 .47097 L
.22272 .47446 L
.26171 .47737 L
.30316 .47998 L
.34309 .48203 L
.3815 .48356 L
.40095 .48418 L
.42237 .48472 L
.44268 .48512 L
.45178 .48526 L
.46172 .48539 L
.4671 .48544 L
.4721 .48549 L
.47727 .48552 L
.48196 .48555 L
.48658 .48557 L
.4887 .48558 L
.49093 .48559 L
.49332 .48559 L
.49438 .48559 L
.49552 .4856 L
.49675 .4856 L
.49789 .4856 L
.49859 .4856 L
.49925 .4856 L
.50049 .4856 L
.50163 .4856 L
.50286 .4856 L
.50401 .4856 L
.50508 .48559 L
.50754 .48559 L
.51014 .48558 L
.51268 .48557 L
.51504 .48557 L
.5204 .48554 L
.5293 .48547 L
.53882 .48538 L
.54906 .48525 L
.56016 .48507 L
.58032 .48466 L
.60019 .48414 L
.62123 .48347 L
.65912 .48193 L
.69946 .47983 L
.73829 .47737 L
.77956 .47428 L
Mistroke
.81932 .47083 L
.85757 .46707 L
.89827 .46262 L
.93745 .45787 L
.97619 .45275 L
Mfstroke
.02381 .5075 m
.06244 .51325 L
.10458 .51897 L
.14415 .52382 L
.18221 .528 L
.22272 .53193 L
.26171 .5352 L
.30316 .53814 L
.34309 .54045 L
.3815 .54217 L
.40095 .54286 L
.42237 .54348 L
.44268 .54392 L
.45178 .54408 L
.46172 .54422 L
.4671 .54428 L
.4721 .54433 L
.47727 .54437 L
.48196 .54441 L
.48658 .54443 L
.4887 .54444 L
.49093 .54445 L
.49332 .54445 L
.49438 .54445 L
.49552 .54446 L
.49675 .54446 L
.49789 .54446 L
.49859 .54446 L
.49925 .54446 L
.50049 .54446 L
.50163 .54446 L
.50286 .54446 L
.50401 .54446 L
.50508 .54445 L
.50754 .54445 L
.51014 .54444 L
.51268 .54443 L
.51504 .54442 L
.5204 .54439 L
.5293 .54432 L
.53882 .54421 L
.54906 .54407 L
.56016 .54387 L
.58032 .54341 L
.60019 .54282 L
.62123 .54206 L
.65912 .54033 L
.69946 .53797 L
.73829 .5352 L
.77956 .53172 L
Mistroke
.81932 .52784 L
.85757 .52362 L
.89827 .51861 L
.93745 .51327 L
.97619 .5075 L
Mfstroke
.02381 .56225 m
.06244 .56865 L
.10458 .575 L
.14415 .58039 L
.18221 .58503 L
.22272 .5894 L
.26171 .59304 L
.30316 .5963 L
.34309 .59886 L
.3815 .60078 L
.40095 .60154 L
.42237 .60223 L
.44268 .60272 L
.45178 .6029 L
.46172 .60305 L
.4671 .60312 L
.4721 .60318 L
.47727 .60323 L
.48196 .60326 L
.48658 .60329 L
.4887 .6033 L
.49093 .6033 L
.49332 .60331 L
.49438 .60331 L
.49552 .60332 L
.49675 .60332 L
.49789 .60332 L
.49859 .60332 L
.49925 .60332 L
.50049 .60332 L
.50163 .60332 L
.50286 .60332 L
.50401 .60332 L
.50508 .60331 L
.50754 .60331 L
.51014 .6033 L
.51268 .60329 L
.51504 .60328 L
.5204 .60324 L
.5293 .60316 L
.53882 .60305 L
.54906 .60288 L
.56016 .60266 L
.58032 .60215 L
.60019 .6015 L
.62123 .60066 L
.65912 .59873 L
.69946 .59611 L
.73829 .59304 L
.77956 .58917 L
Mistroke
.81932 .58485 L
.85757 .58016 L
.89827 .57459 L
.93745 .56866 L
.97619 .56225 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000
003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooool000001@0000070?ooo`005@3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?oo
o`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
5@3oool200000?l0oooo2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0
oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo
00070?ooo`D000000P3oool2000000D0oooo00<000000?ooo`3oool0o`3oool90?ooo`002@3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`3o0?ooo`T0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?oooc`00000S@3ooolk000000L0oooo00000`3oool0000000000002000000@0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0>@3o
oon=00000480oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0?l0oooo2@3oool000P0oooo0P0000040?ooo`8000001@3oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0
oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo
000E0?ooo`800000o`3oool:0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?oo
o`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
5@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3o
ool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?oo
o`T0oooo000E0?oooa`00000c@3ooolK000000L0oooo000E0?ooo`030000003oool0oooo01T0oooo
=P00001Q0?ooocH000008P3oool001D0oooo00<000000?ooo`3oool0C`3ooomQ000005P0oooo000E
0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?oo
o`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo
2@3oool001D0oooo0P00003o0?ooo`X0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo
0?l0oooo2@3oool001D0oooo4000003T0?oooa0000001`3oool001D0oooo00<000000?ooo`3oool0
3@3ooolQ00000:<0oooo8000000G0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooob400000H@3o
oolQ000003L0oooo000E0?ooo`030000003oool0oooo04l0ooooH@00001H0?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000=0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
403oool00`000000oooo0?ooo`020?ooo`<00000o`3oool90?ooo`001`3oool4000000<0oooo0P00
00050?ooo`030000003oool0oooo0?l0oooo2@3oool000h0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000>0?ooo`<00000103oool00`000000oooo0?ooo`3o0?oo
o`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0
o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`D00000n@3oool6
000000L0oooo000E0?ooo`030000003oool0oooo0080oooo2`00003T0?ooo`X000003@3oool001D0
oooo00<000000?ooo`3oool03@3ooolF00000;P0oooo5P00000G0?ooo`005@3oool00`000000oooo
0?ooo`0S0?oooaH00000S@3ooolE000002d0oooo000E0?ooo`030000003oool0oooo03T0oooo8000
001<0?ooob400000@P3oool001D0oooo00<000000?ooo`3oool0F@3ooom<000006<0oooo000E0?oo
o`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
5@3oool200000?l0oooo2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool0
0`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0
oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo
000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo1@00003i0?ooo`H000001`3oool0
01D0oooo00<000000?ooo`3oool00P3oool;00000>@0oooo2P00000=0?ooo`005@3oool00`000000
oooo0?ooo`0=0?ooo``00000c@3oool;000001L0oooo000E0?ooo`030000003oool0oooo01T0oooo
5@00002S0?oooaD000008P3oool001D0oooo00<000000?ooo`3oool0:P3oool200000080oooo2`00
000U0?ooo`800000103oool2000000D0oooo0`00000S0?ooo`800000103oool2000000<0oooo0`00
000V0?ooo`h00000:`3oool5000000D0oooo000E0?ooo`030000003oool0oooo02T0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`3ooolP000000@0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000001@3ooolQ000000030?ooo`000000oooo00L0oooo00@000000?ooo`3oool00000;03o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`0Y0?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`3oool0803ooom<000001l0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo02T0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0S0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000008`3oool010000000oooo0?ooo`00
00080?ooo`<000009@3oool010000000oooo0?ooo`0000090?ooo`800000;@3oool00`000000oooo
0?ooo`050?ooo`005@3oool2000002X0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`00000T0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`0000008`3oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo02X0oooo0P00000:0?ooo`8000009P3oool2000000/0oooo0P00000T0?ooo`8000002P3o
ool3000002D0oooo0P00000:0?ooo`800000;03oool2000000L0oooo000E0?ooo`030000003oool0
oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<0
00000?ooo`3oool0o`3oool90?ooo`003P3ooooo000001<00000000E0?ooo`030000003oool0oooo
0080oooo2`00000:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0203oool:0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool03@3oool<000001P0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool05`3oool;000000l0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool06@3oool:00000;P0oooo2`00000R0?ooo`005@3oool00`000000oooo0?oo
o`0S0?ooo`/00000X`3oool:000002d0oooo000E0?ooo`030000003oool0oooo02h0oooo5P00001g
0?oooaH00000=`3oool001D0oooo00<000000?ooo`3oool0A03ooolE000004@0oooo7P00001=0?oo
o`005@3oool00`000000oooo0?ooo`1I0?oood@00000J`3oool001D0oooo0P00003o0?ooo`X0oooo
000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool9
0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0
oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?oo
o`3o0?ooo`T0oooo000E0?ooo`D00000n@3oool6000000L0oooo000E0?ooo`030000003oool0oooo
0080oooo2000003W0?ooo`X000003@3oool001D0oooo00<000000?ooo`3oool02P3oool600000=T0
oooo2000000G0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`T00000bP3oool6000001l0oooo
000E0?ooo`030000003oool0oooo01T0oooo5@00002S0?oooa8000009@3oool001D0oooo00<00000
0?ooo`3oool0;P3oool;000008d0oooo2`00000g0?ooo`005@3oool00`000000oooo0?ooo`0i0?oo
o`/00000M`3oool;00000480oooo000E0?ooo`030000003oool0oooo04@0oooo7@00000l0?oooah0
0000C@3oool001D0oooo0P00001R0?oooc`00000J`3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo
0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo1@00003i
0?ooo`H000001`3oool001D0oooo00<000000?ooo`3oool00P3oool800000>T0oooo2000000=0?oo
o`005@3oool00`000000oooo0?ooo`0:0?ooo`H00000gP3oool5000001D0oooo000E0?ooo`030000
003oool0oooo0100oooo2@00003=0?ooo`P000006P3oool001D0oooo00<000000?ooo`3oool06@3o
ool:00000;P0oooo2`00000R0?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool08`3oool;
00000:<0oooo2P00000]0?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo02h0oooo2`00002=0?ooo`/00000=`3oool00100oooo00<000000?ooo`3oool00P3oool30000
03T0oooo5P00001Q0?oooaH00000@P3oool000h0oooo0P0000050?ooo`030000003oool0oooo04l0
oooo4P00000l0?oooa<00000F03oool000h0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`1Q0?oooc`00000J`3oool000h0oooo0`0000040?ooo`030000003oool0oooo0?l0oooo2@3o
ool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?oo
o`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0
o`3oool90?ooo`005@3oool500000?T0oooo1P0000070?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`P00000j@3oool8000000d0oooo000E0?ooo`030000003oool0oooo00X0oooo1P00003N0?oo
o`D000005@3oool001D0oooo00<000000?ooo`3oool0403oool900000<d0oooo2000000J0?ooo`00
5@3oool00`000000oooo0?ooo`0I0?ooo`X00000^03oool;00000280oooo000E0?ooo`030000003o
ool0oooo02<0oooo2000002X0?ooo`P00000;@3oool001D0oooo00<000000?ooo`3oool0:`3oool6
000009d0oooo1@00000e0?ooo`005@3oool200000380oooo4`00001g0?oooa<00000>P3oool001D0
oooo00<000000?ooo`3oool0A03oool;00000640oooo2`00001=0?ooo`005@3oool00`000000oooo
0?ooo`1?0?oooa800000?03ooolC000005P0oooo000E0?ooo`030000003oool0oooo0640oooo?000
001[0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo
0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`<00000oP3oool3000000L0oooo000E0?ooo`030000003oool0
oooo00D00000l`3oool6000000X0oooo000E0?ooo`030000003oool0oooo00D0oooo2000003T0?oo
o`L00000403oool001D0oooo00<000000?ooo`3oool03@3oool900000=<0oooo2000000G0?ooo`00
5@3oool00`000000oooo0?ooo`0F0?ooo`H00000a`3oool6000001l0oooo000E0?ooo`030000003o
ool0oooo01`0oooo1`00002h0?ooo`P000009@3oool001D0oooo00<000000?ooo`3oool08`3oool;
00000:<0oooo2P00000]0?ooo`005@3oool2000002l0oooo2`00002=0?ooo`/00000=`3oool001D0
oooo00<000000?ooo`3oool0>@3oool;000007L0oooo2`0000120?ooo`005@3oool00`000000oooo
0?ooo`140?ooo`/00000H@3oool;000004d0oooo000E0?ooo`030000003oool0oooo04l0oooo4P00
000g0?oooaP00000F03oool001D0oooo00<000000?ooo`3oool0H@3ooolg00000700oooo000E0?oo
o`030000003oool0oooo0?l0oooo2@3oool000L0oooo1@0000020?ooo`8000001@3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo2@3oool000T0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo0`00003o0?ooo`T0oooo00090?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooo`h0oooo00090?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooo`h0oooo00080?ooo`800000
103oool200000?l0oooo4@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -12.8439, \
0.00385924, 0.134254}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Zobrazen\[EAcute] je residuum pro r\:016fzn\[EAcute] hodnoty \
hledan\[EAcute]ho koeficientu (koeficient v na\[SHacek]em tvaru \:0159e\
\[SHacek]en\[IAcute])\
\>", "Text"],

Cell["\<\
Cht\:011bli bychom tedy, aby toto residuum bylo nulov\[EAcute] pro jak\
\[EAcute]koli x mezi (0,1), co\:017e (jak u\:017e je vid\:011bt z \
p\:0159edchoz\[IAcute]ho grafu) pro n\[AAcute]mi zvolen\[YAcute] tvar \:0159e\
\[SHacek]en\[IAcute] nelze.\
\>", "Text"],

Cell["\<\
Metoda v\[AAcute]hov\[YAcute]ch residu\[IAcute] spo\[CHacek]\[IAcute]v\
\[AAcute] v tom, \:017ee :
a) Residuum vyn\[AAcute]sob\[IAcute]me t\[EAcute]m\:011b\:0159 libovolnou \
funkc\[IAcute] w[x] (m\:016f\:017ee z\[AAcute]viset i na koeficientu a, pak \
tedy w[x,a])
b) Tento sou\[CHacek]in zintegrujeme p\:0159es celou oblast (tedy mezi \
(0,1)).
c) Tento integr\[AAcute]l pak polo\:017e\[IAcute]me nule a dostaneme t\
\[IAcute]m jednu rovnici, v kter\[EAcute] nezn\[AAcute]me pouze koeficient a \
(sou\:0159adnice x jsme se zbavili integrov\[AAcute]n\[IAcute]m)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(w*Residuum\)], "Input"],

Cell[BoxData[
    \(w\ \((2\ a + 
          0.6000000000000001`\ \((\(-20\) + 
                a\ \((1 - x)\)\ x)\))\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(MVR = 
        0 == \[Integral]\_0\%1 w*Residuum \[DifferentialD]x;\)\)], "Input"],

Cell["\<\
Pozn.1: Kdy\:017e bude navrhovan\[YAcute] tvar \:0159e\[SHacek]en\[IAcute] m\
\[IAcute]t n koeficient\:016f, vyn\[AAcute]sob\[IAcute]me postupn\:011b \
residuum n r\:016fzn\[YAcute]mi (nav\[IAcute]c vz\[AAcute]jem\:011b line\
\[AAcute]rn\:011b nez\[AAcute]visl\[YAcute]mi) funkcemi a dostaneme tak \
soustavu n rovnic, v kter\[EAcute] bude t\:011bch n nezn\[AAcute]m\[YAcute]ch \
koeficient\:016f\
\>", "Text"],

Cell["\<\
Pozn.2: Funkci w se \:0159\[IAcute]k\[AAcute] v\[AAcute]hov\[AAcute] (pop\
\:0159. testovac\[IAcute]) funkce, proto\:017ee j\[IAcute] vlastn\:011b v\
\[AAcute]hujeme, v kter\[EAcute] oblasti m\[AAcute] b\[YAcute]t spln\:011bna \
rovnice l\[EAcute]pe a v kter\[EAcute] m\[EAcute]n\:011b. (Hodn\:011b \
zjednodu\[SHacek]en\:011b \:0159e\[CHacek]eno)\
\>", "Text"],

Cell["\<\
Pozn.3: Mimochodem lze dok\[AAcute]zat, \:017ee je-li integral z jakekoli \
funkce f  vyn\[AAcute]soben\[EAcute] v\[AAcute]hovou funkc\[IAcute] nulov\
\[YAcute] pro v\[SHacek]echny mo\:017en\[EAcute] v\[AAcute]hov\[EAcute] \
funkce (v\[AAcute]hov\[EAcute] funkce z dosti obecn\[EAcute] mno\:017einy \
funkc\[IAcute]) je tato funkce f na cel\[EAcute] oblasti (p\:0159es kterou \
integruji) nulov\[AAcute]. Tak\:017ee na\[SHacek]\[IAcute]m postupem z\
\[IAcute]sk\[AAcute]me residuum, kter\[EAcute]ho v\[AAcute]hovan\[YAcute] \
integr\[AAcute]l nen\[IAcute] nulov\[YAcute] pro v\[SHacek]ech \
nekone\[CHacek]n\:011b mnoho pot\:0159ebn\[YAcute]ch testovac\[IAcute]ch \
funkc\[IAcute], ale jen pro  kone\[CHacek]n\[YAcute] po\[CHacek]et \
n\[AAcute]mi (poku\:010f mo\:017eno vhodn\:011b) vybran\[YAcute]ch \
v\[AAcute]hov\[YAcute]ch funkc\[IAcute].
\
\>", "Text"],

Cell["\<\
Podle toho jak vol\[IAcute]me v\[AAcute]hov\[EAcute] funkce se pak dostanou r\
\:016fzn\[EAcute] metody \:0159e\[SHacek]en\[IAcute]. (N\[AAcute]sleduj\
\[IAcute]c\[IAcute] metody, tedy lze tedy zjednodu\[SHacek]en\:011b ozna\
\[CHacek]it za metody volby v\[AAcute]hov\[YAcute]ch funkc\[IAcute] )\
\>", "Text"],

Cell[CellGroupData[{

Cell["Collocation method", "Subsection"],

Cell["MVR/.{w\[Rule]DiracDelta[x-xi]};", "Text"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci dirakuv impuls v nejak\
\[EAcute]m bod\:011b (pop\:0159. v n\:011bjak\[YAcute]ch bodech, v p\:0159\
\[IAcute]pad\:011b v\[IAcute]ce koeficient\:016f), v kter\[EAcute]m chceme m\
\[IAcute]t rovnici spln\:011bnu\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CM = 
      0 == \[Integral]\_0\%1 DiracDelta[x - 0.5]*
            Residuum \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    \(0 \[Equal] \(-12.000000000000002`\) + 
        2.1500000000000004`\ a\)], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\:0159e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(resCM = \(Solve[CM, 
          a]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \({a \[Rule] 5.5813953488372094`}\)], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\:0159edpokl\
\[AAcute]dan\[EAcute]ho tvaru \:0159e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tapr /. resCM\)], "Input"],

Cell[BoxData[
    \(5.5813953488372094`\ \((1 - x)\)\ x\)], "Output"]
}, Open  ]],

Cell["\<\
\:0158e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu (samoz\:0159ejm\
\:011b z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Tapr /. resCM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.421833 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09908 -18 -4.5 ]
[.01131 .09908 0 4.5 ]
[.01131 .18345 -18 -4.5 ]
[.01131 .18345 0 4.5 ]
[.01131 .26781 -18 -4.5 ]
[.01131 .26781 0 4.5 ]
[.01131 .35218 -18 -4.5 ]
[.01131 .35218 0 4.5 ]
[.01131 .43655 -6 -4.5 ]
[.01131 .43655 0 4.5 ]
[.01131 .52091 -18 -4.5 ]
[.01131 .52091 0 4.5 ]
[.01131 .60528 -18 -4.5 ]
[.01131 .60528 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09908 m
.03006 .09908 L
s
[(0.2)] .01131 .09908 1 0 Mshowa
.02381 .18345 m
.03006 .18345 L
s
[(0.4)] .01131 .18345 1 0 Mshowa
.02381 .26781 m
.03006 .26781 L
s
[(0.6)] .01131 .26781 1 0 Mshowa
.02381 .35218 m
.03006 .35218 L
s
[(0.8)] .01131 .35218 1 0 Mshowa
.02381 .43655 m
.03006 .43655 L
s
[(1)] .01131 .43655 1 0 Mshowa
.02381 .52091 m
.03006 .52091 L
s
[(1.2)] .01131 .52091 1 0 Mshowa
.02381 .60528 m
.03006 .60528 L
s
[(1.4)] .01131 .60528 1 0 Mshowa
.125 Mabswid
.02381 .03581 m
.02756 .03581 L
s
.02381 .0569 m
.02756 .0569 L
s
.02381 .07799 m
.02756 .07799 L
s
.02381 .12017 m
.02756 .12017 L
s
.02381 .14127 m
.02756 .14127 L
s
.02381 .16236 m
.02756 .16236 L
s
.02381 .20454 m
.02756 .20454 L
s
.02381 .22563 m
.02756 .22563 L
s
.02381 .24672 m
.02756 .24672 L
s
.02381 .28891 m
.02756 .28891 L
s
.02381 .31 m
.02756 .31 L
s
.02381 .33109 m
.02756 .33109 L
s
.02381 .37327 m
.02756 .37327 L
s
.02381 .39436 m
.02756 .39436 L
s
.02381 .41546 m
.02756 .41546 L
s
.02381 .45764 m
.02756 .45764 L
s
.02381 .47873 m
.02756 .47873 L
s
.02381 .49982 m
.02756 .49982 L
s
.02381 .54201 m
.02756 .54201 L
s
.02381 .5631 m
.02756 .5631 L
s
.02381 .58419 m
.02756 .58419 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00@P3oool2000000@0oooo0P0000030?ooo`@000009@3oool2000000@0oooo0P0000050?oo
o`<000008`3oool2000000@0oooo0P0000030?ooo`<000009P3oool2000000@0oooo0P0000040?oo
o`800000:`3oool5000000D0oooo00110?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0240oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?ooo`00@@3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool00000203oool5
00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?oo
o`00@@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02<0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo
0`00000U0?ooo`040000003oool0oooo000000T0oooo0P00000]0?ooo`030000003oool0oooo00D0
oooo00110?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000903oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002<0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;03oool00`000000oooo0?ooo`050?ooo`00@P3oool2000000X0oooo0P00000V0?ooo`800000
2`3oool2000002@0oooo0P00000:0?ooo`<000009@3oool2000000X0oooo0P00000/0?ooo`800000
1`3oool00?l0oooo8@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`003`3ooooo0000014000000@3oool001D0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo000E0?oo
o`800000<P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0`0?ooo`8000001`3oool001D0oooo0P00003o0?ooo`40
oooo00<000000?ooo`3oool01P3oool001D0oooo00<000000?ooo`000000oP3oool00`000000oooo
0?ooo`070?ooo`005@3oool00`000000oooo0000003n0?ooo`030000003oool0oooo00L0oooo000E
0?ooo`80000000<0oooo0000003oool0n`3oool00`000000oooo0?ooo`080?ooo`005@3oool01000
0000oooo0?ooo`00003l0?ooo`030000003oool0oooo00P0oooo000E0?ooo`050000003oool0oooo
0?ooo`000000nP3oool00`000000oooo0?ooo`090?ooo`005@3oool01@000000oooo0?ooo`3oool0
00000?X0oooo00<000000?ooo`3oool02@3oool001D0oooo00D000000?ooo`3oool0oooo0000003j
0?ooo`030000003oool0oooo00T0oooo000E0?ooo`8000000`3oool00`000000oooo0?ooo`3f0?oo
o`030000003oool0oooo00X0oooo000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0mP3oool00`000000oooo0?ooo`0:0?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0?@0oooo00<000000?ooo`3oool02`3oool001D0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`3d0?ooo`030000003oool0oooo00/0oooo000E0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0lP3oool00`000000oooo0?ooo`0<0?ooo`005@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0?80oooo00<000000?ooo`3oool0303oool001D0
oooo0P0000050?ooo`030000003oool0oooo0?80oooo00<000000?ooo`3oool0303oool001D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00d0oooo
000E0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0l03oool00`000000oooo0?oo
o`0=0?ooo`005@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0>h0oooo00<00000
0?ooo`3oool03P3oool00080oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`3^0?ooo`030000003oool0oooo00h0oooo00001@3oool0
00000?ooo`3oool0000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo0>`0oooo00<000000?ooo`3oool03`3oool000050?ooo`000000oooo0?oo
o`0000002@3oool00`000000oooo0?ooo`040?ooo`<000001`3oool00`000000oooo0?ooo`3/0?oo
o`030000003oool0oooo00l0oooo00001@3oool000000?ooo`3oool0000000X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>X0oooo00<000000?oo
o`3oool0403oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0jP3oool00`000000oooo0?ooo`0@
0?ooo`000P3oool2000000X0oooo0P0000050?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0jP3oool00`000000oooo0?ooo`0@0?ooo`005@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo0>P0oooo00<000000?ooo`3oool04@3oool001D0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0oooo0140oooo000E0?ooo`8000002`3o
ool00`000000oooo0?ooo`3V0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool0iP3oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo0>@0oooo00<000000?ooo`3oool04`3oool001D0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3T0?ooo`030000003oool0oooo01<0
oooo000E0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0hP3oool00`000000oooo
0?ooo`0D0?ooo`005@3oool2000000d0oooo00<000000?ooo`3oool0hP3oool00`000000oooo0?oo
o`0D0?ooo`005@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0>00oooo00<00000
0?ooo`3oool05@3oool001D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3P0?oo
o`030000003oool0oooo01D0oooo000E0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0g`3oool00`000000oooo0?ooo`0F0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo0=h0oooo00<000000?ooo`3oool05P3oool001D0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`3M0?ooo`030000003oool0oooo01L0oooo000E0?ooo`800000403oool0
0`000000oooo0?ooo`3L0?ooo`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`0H0?ooo`005@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3oool0603oool001D0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo01T0oooo
00020?ooo`800000103oool2000000D0oooo0`0000030?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0f03oool00`000000oooo0?ooo`0I0?ooo`0000D0oooo0000003oool0oooo0000
000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`3G0?ooo`030000003oool0oooo01X0oooo00001@3oool000000?ooo`3oool0000000P0oooo1@00
00030?ooo`<000004P3oool00`000000oooo0?ooo`3F0?ooo`030000003oool0oooo01X0oooo0000
1@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool06`3oool000050?ooo`00
0000oooo0?ooo`0000002@3oool00`000000oooo000000040?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`0K0?ooo`000P3oool2000000/0oooo0P00
00040?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0d`3oool00`000000oooo0?oo
o`0L0?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0=80oooo00<00000
0?ooo`3oool0703oool001D0oooo0P00000E0?ooo`030000003oool0oooo0=40oooo00<000000?oo
o`3oool07@3oool001D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3@0?ooo`03
0000003oool0oooo01d0oooo000E0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
c`3oool00`000000oooo0?ooo`0N0?ooo`005@3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo0<h0oooo00<000000?ooo`3oool07P3oool001D0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`3=0?ooo`030000003oool0oooo01l0oooo000E0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`0O0?ooo`005@3oool2000001P0
oooo00<000000?ooo`3oool0b`3oool00`000000oooo0?ooo`0P0?ooo`005@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool0803oool001D0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`390?ooo`030000003oool0oooo0240oooo000E
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0Q
0?ooo`005@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0<L0oooo00<000000?oo
o`3oool08P3oool001D0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`360?ooo`03
0000003oool0oooo0280oooo000E0?ooo`8000006`3oool00`000000oooo0?ooo`350?ooo`030000
003oool0oooo02<0oooo000E0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0a03o
ool00`000000oooo0?ooo`0S0?ooo`005@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo0<<0oooo00<000000?ooo`3oool0903oool001D0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`320?ooo`030000003oool0oooo02@0oooo00020?ooo`800000103oool2000000<0
oooo0`0000050?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0`@3oool00`000000
oooo0?ooo`0U0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo
02D0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103oool3
000001d0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`0V0?ooo`0000D0oooo0000
003oool0oooo000000080?ooo`<000001@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo0;h0oooo00<000000?ooo`3oool09P3oool000050?ooo`000000oooo0?ooo`0000002@3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0_03oool0
0`000000oooo0?ooo`0W0?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0_03oool00`000000oooo0?ooo`0W0?ooo`005@3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3oool0:03oool001D0oooo
0P00000Q0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3oool0:03oool001D0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02T0oooo000E
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0Y
0?ooo`005@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0;H0oooo00<000000?oo
o`3oool0:P3oool001D0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`2f0?ooo`03
0000003oool0oooo02X0oooo000E0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
]03oool00`000000oooo0?ooo`0[0?ooo`005@3oool2000002D0oooo00<000000?ooo`3oool0/P3o
ool00`000000oooo0?ooo`0/0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo0;80oooo00<000000?ooo`3oool0;03oool001D0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`2`0?ooo`030000003oool0oooo02d0oooo000E0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`0]0?ooo`005@3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool0;P3oool001D0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo02h0oooo000E
0?ooo`800000:03oool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo02l0oooo000E0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool0[03oool00`000000oooo0?ooo`0_0?oo
o`005@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`3o
ool0<03oool00080oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo0340oooo00001@3oool000000?oo
o`3oool0000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo0:P0oooo00<000000?ooo`3oool0<@3oool000050?ooo`000000oooo0?ooo`00
0000203oool010000000oooo0?ooo`0000040?ooo`<00000:P3oool00`000000oooo0?ooo`2V0?oo
o`030000003oool0oooo0380oooo00001@3oool000000?ooo`3oool0000000T0oooo0P0000050?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`0c0?oo
o`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo03<0oooo00020?oo
o`8000002P3oool2000000D0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`2R0?oo
o`030000003oool0oooo03@0oooo000E0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0X03oool00`000000oooo0?ooo`0e0?ooo`005@3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo09l0oooo00<000000?ooo`3oool0=P3oool001D0oooo0P00000_0?ooo`030000003o
ool0oooo09h0oooo00<000000?ooo`3oool0=P3oool001D0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`2M0?ooo`030000003oool0oooo03L0oooo000E0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`0h0?ooo`005@3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool0>03oool001D0oooo
00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo03T0oooo
000E0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?oo
o`0j0?ooo`005@3oool2000003<0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`0j
0?ooo`005@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo09D0oooo00<000000?oo
o`3oool0>`3oool001D0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2C0?ooo`03
0000003oool0oooo03`0oooo000E0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0
TP3oool00`000000oooo0?ooo`0l0?ooo`005@3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo0940oooo00<000000?ooo`3oool0?@3oool001D0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`2?0?ooo`030000003oool0oooo03h0oooo000E0?ooo`800000=`3oool00`00
0000oooo0?ooo`2>0?ooo`030000003oool0oooo03h0oooo000E0?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0o0?ooo`005@3oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool0@03oool000d0oooo1@00
00030?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?oo
o`110?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo03T0oooo00<00000
0?ooo`3oool0R03oool00`000000oooo0?ooo`110?ooo`003`3oool00`000000oooo0?ooo`030?oo
o`<00000>P3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo0480oooo000?0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`250?ooo`03
0000003oool0oooo04<0oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
>`3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo04<0oooo000>0?ooo`8000001@3o
ool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool0A03o
ool001D0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`200?ooo`030000003oool0
oooo04D0oooo000E0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0P03oool00`00
0000oooo0?ooo`150?ooo`005@3oool2000003l0oooo00<000000?ooo`3oool0OP3oool00`000000
oooo0?ooo`160?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo07`0oooo
00<000000?ooo`3oool0A`3oool001D0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`1j0?ooo`030000003oool0oooo04P0oooo000E0?ooo`030000003oool0oooo0440oooo00<00000
0?ooo`3oool0N03oool00`000000oooo0?ooo`190?ooo`005@3oool00`000000oooo0?ooo`120?oo
o`030000003oool0oooo07H0oooo00<000000?ooo`3oool0BP3oool001D0oooo00<000000?ooo`3o
ool0@`3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo04/0oooo000E0?ooo`800000
A03oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo04/0oooo000E0?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`1<0?ooo`005@3oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0C@3oool0
01D0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo
04h0oooo000E0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0K03oool00`000000
oooo0?ooo`1?0?ooo`005@3oool2000004T0oooo00<000000?ooo`3oool0JP3oool00`000000oooo
0?ooo`1@0?ooo`005@3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo06P0oooo00<0
00000?ooo`3oool0D@3oool001D0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`1V
0?ooo`030000003oool0oooo0580oooo000E0?ooo`030000003oool0oooo04/0oooo00<000000?oo
o`3oool0I03oool00`000000oooo0?ooo`1C0?ooo`0000<0oooo0000000000000`0000020?ooo`80
00000`3oool4000000@0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1R0?ooo`03
0000003oool0oooo05@0oooo00030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0
E@3oool000<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`<00000CP3o
ool2000005l0oooo00<000000?ooo`3oool0EP3oool000<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0F`3oool0
0`000000oooo0?ooo`1G0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0
oooo05P0oooo00020?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0DP3oool00`00
0000oooo0?ooo`1G0?ooo`030000003oool0oooo05T0oooo000E0?ooo`030000003oool0oooo05<0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1J0?ooo`005@3oool00`000000oooo
0?ooo`1D0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0F`3oool001D0oooo0P00
001F0?ooo`030000003oool0oooo0500oooo0P00001N0?ooo`005@3oool00`000000oooo0?ooo`1F
0?ooo`800000C`3oool00`000000oooo0?ooo`1N0?ooo`005@3oool00`000000oooo0?ooo`1H0?oo
o`030000003oool0oooo04X0oooo0P00001Q0?ooo`005@3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo04L0oooo0P00001S0?ooo`005@3oool00`000000oooo0?ooo`1J0?ooo`030000
003oool0oooo04D0oooo00<000000?ooo`3oool0H`3oool001D0oooo00<000000?ooo`3oool0F`3o
ool2000004<0oooo0P00001V0?ooo`005@3oool2000005h0oooo00<000000?ooo`3oool0?`3oool0
0`000000oooo0?ooo`1V0?ooo`005@3oool00`000000oooo0?ooo`1N0?ooo`030000003oool0oooo
03`0oooo0P00001Y0?ooo`005@3oool00`000000oooo0?ooo`1O0?ooo`800000>P3oool2000006/0
oooo000E0?ooo`030000003oool0oooo0640oooo0P00000g0?ooo`030000003oool0oooo06/0oooo
000E0?ooo`030000003oool0oooo06<0oooo0`00000b0?ooo`800000KP3oool001D0oooo0P00001W
0?ooo`800000;P3oool200000700oooo000E0?ooo`030000003oool0oooo06P0oooo0`00000X0?oo
o`<00000LP3oool001D0oooo00<000000?ooo`3oool0J`3oool3000002<0oooo0P00001e0?ooo`00
5@3oool00`000000oooo0?ooo`1^0?ooo`8000007P3oool3000007L0oooo00000`3oool000000000
000300000080oooo0P0000050?ooo`<000000`3oool00`000000oooo0?ooo`1`0?ooo`D000004`3o
ool6000007X0oooo00030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`1e0?oooa<00000P03oool000<0oooo00<000000?ooo`3oool01`3oool50000
00<0oooo0`00003o0?ooo`T0oooo00030?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`3o0?ooo`T0oooo00030?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`3o0?ooo`T0oooo00020?ooo`800000
2`3oool2000000@0oooo00<000000?ooo`3oool0o`3oool90?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0849055, -0.108354, \
0.00387438, 0.00874727}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\:017e do rovnice dosad\[IAcute]me \:0159e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rovApr /. resCM\)], "Input"],

Cell[BoxData[
    \(\(-11.162790697674419`\) \[Equal] 
      0.6000000000000001`\ \((\(-20\) + 
            5.5813953488372094`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell["\<\
Spln\:011bn\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me na \
residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Residuum /. resCM\)], "Input"],

Cell[BoxData[
    \(\(\(11.162790697674419`\)\(\[InvisibleSpace]\)\) + 
      0.6000000000000001`\ \((\(-20\) + 
            5.5813953488372094`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Residuum /. resCM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.603319 0.703055 [
[.21429 .59082 -9 -9 ]
[.21429 .59082 9 0 ]
[.40476 .59082 -9 -9 ]
[.40476 .59082 9 0 ]
[.59524 .59082 -9 -9 ]
[.59524 .59082 9 0 ]
[.78571 .59082 -9 -9 ]
[.78571 .59082 9 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.01131 .04088 -24 -4.5 ]
[.01131 .04088 0 4.5 ]
[.01131 .18149 -24 -4.5 ]
[.01131 .18149 0 4.5 ]
[.01131 .3221 -24 -4.5 ]
[.01131 .3221 0 4.5 ]
[.01131 .46271 -24 -4.5 ]
[.01131 .46271 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .60332 m
.21429 .60957 L
s
[(0.2)] .21429 .59082 0 1 Mshowa
.40476 .60332 m
.40476 .60957 L
s
[(0.4)] .40476 .59082 0 1 Mshowa
.59524 .60332 m
.59524 .60957 L
s
[(0.6)] .59524 .59082 0 1 Mshowa
.78571 .60332 m
.78571 .60957 L
s
[(0.8)] .78571 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(1)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.2619 .60332 m
.2619 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.5 .60332 m
.5 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.7381 .60332 m
.7381 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.02381 .04088 m
.03006 .04088 L
s
[(-0.8)] .01131 .04088 1 0 Mshowa
.02381 .18149 m
.03006 .18149 L
s
[(-0.6)] .01131 .18149 1 0 Mshowa
.02381 .3221 m
.03006 .3221 L
s
[(-0.4)] .01131 .3221 1 0 Mshowa
.02381 .46271 m
.03006 .46271 L
s
[(-0.2)] .01131 .46271 1 0 Mshowa
.125 Mabswid
.02381 .07603 m
.02756 .07603 L
s
.02381 .11118 m
.02756 .11118 L
s
.02381 .14633 m
.02756 .14633 L
s
.02381 .21664 m
.02756 .21664 L
s
.02381 .25179 m
.02756 .25179 L
s
.02381 .28694 m
.02756 .28694 L
s
.02381 .35725 m
.02756 .35725 L
s
.02381 .3924 m
.02756 .3924 L
s
.02381 .42756 m
.02756 .42756 L
s
.02381 .49786 m
.02756 .49786 L
s
.02381 .53301 m
.02756 .53301 L
s
.02381 .56817 m
.02756 .56817 L
s
.02381 .00572 m
.02756 .00572 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59951 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60247 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58657 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`00
6`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3o
ool001/0oooo00<000000?ooo`3oool0nP3oool00`000000oooo0?ooo`050?ooo`006`3oool00`00
0000oooo0?ooo`3j0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000nP3oool00`000000
oooo0?ooo`060?ooo`006`3oool200000?X0oooo00<000000?ooo`3oool01P3oool001/0oooo00<0
00000?ooo`000000n03oool00`000000oooo0?ooo`070?ooo`00203oool2000000@0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0000003h0?ooo`030000003oool0oooo00L0oooo00070?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0000
003g0?ooo`030000003oool0oooo00P0oooo00070?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool00000103oool2000000030?ooo`000000oooo0?D0oooo00<000000?ooo`3oool0
203oool000030?ooo`0000000000008000000P3oool010000000oooo0?ooo`0000090?ooo`800000
1@3oool010000000oooo0?ooo`00003f0?ooo`030000003oool0oooo00P0oooo00070?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0
00000?@0oooo00<000000?ooo`3oool02@3oool000P0oooo0P00000:0?ooo`8000001@3oool01@00
0000oooo0?ooo`3oool000000?@0oooo00<000000?ooo`3oool02@3oool001/0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00X0oooo000K0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0l03oool00`000000oooo0?ooo`0:0?ooo`00
6`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool0
2P3oool001/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`030000003o
ool0oooo00/0oooo000K0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0kP3oool0
0`000000oooo0?ooo`0;0?ooo`006`3oool2000000D0oooo00<000000?ooo`3oool0k03oool00`00
0000oooo0?ooo`0<0?ooo`006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>`0
oooo00<000000?ooo`3oool0303oool001/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`3[0?ooo`030000003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0jP3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0>X0oooo00<000000?ooo`3oool03@3oool001/0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0oooo00h0oooo000K0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0j03oool00`000000oooo0?ooo`0>0?ooo`00
6`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool0
3`3oool001/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3V0?ooo`030000003o
ool0oooo00l0oooo000K0?ooo`800000203oool00`000000oooo0?ooo`3V0?ooo`030000003oool0
oooo00l0oooo000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0i03oool00`00
0000oooo0?ooo`0@0?ooo`006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>@0
oooo00<000000?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`3R0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0hP3oool00`000000oooo0?ooo`0A0?ooo`006`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0>00oooo00<000000?ooo`3oool04P3oool001/0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`3P0?ooo`030000003oool0oooo0180oooo000K0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0gP3oool00`000000oooo0?ooo`0C0?ooo`00
6`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0=h0oooo00<000000?ooo`3oool0
4`3oool001/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`3L0?ooo`030000003o
ool0oooo01@0oooo000K0?ooo`8000003@3oool00`000000oooo0?ooo`3L0?ooo`030000003oool0
oooo01@0oooo000K0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0f`3oool00`00
0000oooo0?ooo`0E0?ooo`006`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0=X0
oooo00<000000?ooo`3oool05@3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`3I0?ooo`030000003oool0oooo01H0oooo000K0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0f03oool00`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0=L0oooo00<000000?ooo`3oool05`3oool001/0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`3F0?ooo`030000003oool0oooo01L0oooo00080?ooo`80
0000103oool2000000<0oooo0`0000050?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0e@3oool00`000000oooo0?ooo`0H0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`3D0?oo
o`030000003oool0oooo01P0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool00000103oool200000140oooo00<000000?ooo`3oool0d`3oool00`000000oooo0?ooo`0I
0?ooo`0000<0oooo0000000000000P0000020?ooo`040000003oool0oooo000000P0oooo0`000005
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0dP3oool00`000000oooo0?ooo`0I
0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`3A0?ooo`030000003oool0oooo01X0oooo00080?oo
o`8000002P3oool3000000@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3@0?oo
o`030000003oool0oooo01X0oooo000K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool0d03oool00`000000oooo0?ooo`0J0?ooo`006`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0<h0oooo00<000000?ooo`3oool06`3oool001/0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3>0?ooo`030000003oool0oooo01/0oooo000K0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`0L0?ooo`006`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0703oool001/0
oooo0P00000F0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool07@3oool001/0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo01d0oooo
000K0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?oo
o`0N0?ooo`006`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0<P0oooo00<00000
0?ooo`3oool07P3oool001/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`360?oo
o`030000003oool0oooo01l0oooo000K0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0aP3oool00`000000oooo0?ooo`0O0?ooo`006`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo0<@0oooo00<000000?ooo`3oool0803oool001/0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`340?ooo`030000003oool0oooo0200oooo000K0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0Q0?ooo`006`3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool08@3oool001/0
oooo0P00000K0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool08P3oool001/0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo0280oooo
000K0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?oo
o`0S0?ooo`006`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0;h0oooo00<00000
0?ooo`3oool08`3oool001/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2l0?oo
o`030000003oool0oooo02@0oooo000K0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0_03oool00`000000oooo0?ooo`0T0?ooo`006`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo0;X0oooo00<000000?ooo`3oool09@3oool001/0oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo02D0oooo000K0?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0V0?ooo`006`3oool20000
0200oooo00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`0V0?ooo`006`3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool09`3oool001/0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo02P0oooo
000K0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0]03oool00`000000oooo0?oo
o`0X0?ooo`006`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;80oooo00<00000
0?ooo`3oool0:@3oool001/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2a0?oo
o`030000003oool0oooo02X0oooo000K0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool0/03oool00`000000oooo0?ooo`0Z0?ooo`006`3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo0:h0oooo00<000000?ooo`3oool0:`3oool000P0oooo0P0000040?ooo`8000001@3o
ool3000000<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2^0?ooo`030000003o
ool0oooo02/0oooo00070?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0:`0oooo00<000000?ooo`3oool0;03o
ool000L0oooo00@000000?ooo`3oool00000203oool5000000<0oooo0P00000U0?ooo`030000003o
ool0oooo0:/0oooo00<000000?ooo`3oool0;@3oool000030?ooo`0000000000008000000P3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo02d0oooo00070?ooo`040000003o
ool0oooo000000T0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo0:T0oooo00<000000?ooo`3oool0;P3oool000P0oooo0P00000;0?ooo`800000103o
ool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0;P3o
ool001/0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2W0?ooo`030000003oool0
oooo02l0oooo000K0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0Y@3oool00`00
0000oooo0?ooo`0`0?ooo`006`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0:@0
oooo00<000000?ooo`3oool0<03oool001/0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`2S0?ooo`030000003oool0oooo0340oooo000K0?ooo`030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0X@3oool00`000000oooo0?ooo`0b0?ooo`006`3oool2000002/0oooo00<00000
0?ooo`3oool0X03oool00`000000oooo0?ooo`0b0?ooo`006`3oool00`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo09l0oooo00<000000?ooo`3oool0<`3oool001/0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo03<0oooo000K0?ooo`030000
003oool0oooo02`0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0d0?ooo`006`3o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo09/0oooo00<000000?ooo`3oool0=@3o
ool001/0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0
oooo03D0oooo000K0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0V03oool00`00
0000oooo0?ooo`0f0?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo09H0
oooo00<000000?ooo`3oool0=`3oool001/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo
0?ooo`2F0?ooo`030000003oool0oooo03L0oooo000K0?ooo`800000<@3oool00`000000oooo0?oo
o`2D0?ooo`030000003oool0oooo03P0oooo000K0?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`3oool0T`3oool00`000000oooo0?ooo`0h0?ooo`006`3oool00`000000oooo0?ooo`0a0?oo
o`030000003oool0oooo0980oooo00<000000?ooo`3oool0>@3oool001/0oooo00<000000?ooo`3o
ool0<P3oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo03X0oooo000K0?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0j0?ooo`006`3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0>`3o
ool001/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2<0?ooo`030000003oool0
oooo03`0oooo000K0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0RP3oool00`00
0000oooo0?ooo`0m0?ooo`006`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo08T0
oooo00<000000?ooo`3oool0?@3oool001/0oooo00<000000?ooo`3oool0=P3oool00`000000oooo
0?ooo`280?ooo`030000003oool0oooo03h0oooo000K0?ooo`800000>03oool00`000000oooo0?oo
o`260?ooo`030000003oool0oooo03l0oooo000K0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool0Q03oool00`000000oooo0?ooo`100?ooo`006`3oool00`000000oooo0?ooo`0h0?oo
o`030000003oool0oooo08@0oooo00<000000?ooo`3oool0@03oool001/0oooo00<000000?ooo`3o
ool0>@3oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo0440oooo000K0?ooo`030000
003oool0oooo03X0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`120?ooo`006`3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool0@`3o
ool001/0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0
oooo04<0oooo00080?ooo`800000103oool2000000<0oooo100000040?ooo`030000003oool0oooo
03`0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`140?ooo`001`3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`1j0?ooo`030000003oool0oooo04D0oooo00070?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`3oool0103oool2000003l0oooo00<000000?ooo`3oool0N03oool00`00
0000oooo0?ooo`160?ooo`0000<0oooo0000000000000P0000020?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
07H0oooo00<000000?ooo`3oool0A`3oool000L0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0MP3oool0
0`000000oooo0?ooo`170?ooo`00203oool2000000X0oooo0P0000050?ooo`030000003oool0oooo
0400oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`180?ooo`006`3oool00`000000
oooo0?ooo`110?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0B@3oool001/0oooo
00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo04X0oooo
000K0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?oo
o`1;0?ooo`006`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo00<00000
0?ooo`3oool0C03oool001/0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?oo
o`030000003oool0oooo04`0oooo000K0?ooo`800000AP3oool00`000000oooo0?ooo`1Z0?ooo`03
0000003oool0oooo04d0oooo000K0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0
J03oool00`000000oooo0?ooo`1>0?ooo`006`3oool00`000000oooo0?ooo`170?ooo`030000003o
ool0oooo06H0oooo00<000000?ooo`3oool0C`3oool001/0oooo00<000000?ooo`3oool0B03oool0
0`000000oooo0?ooo`1T0?ooo`030000003oool0oooo0500oooo000K0?ooo`030000003oool0oooo
04T0oooo0P00001S0?ooo`030000003oool0oooo0540oooo000K0?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`1B0?ooo`006`3oool00`000000oooo
0?ooo`1<0?ooo`030000003oool0oooo05`0oooo0P00001E0?ooo`006`3oool00`000000oooo0?oo
o`1=0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0E@3oool001/0oooo00<00000
0?ooo`3oool0CP3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05H0oooo000K0?oo
o`030000003oool0oooo04l0oooo0P00001G0?ooo`030000003oool0oooo05L0oooo000K0?ooo`80
0000DP3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05P0oooo000K0?ooo`030000
003oool0oooo0580oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1I0?ooo`006`3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo04h0oooo0P00001L0?ooo`006`3oool0
0`000000oooo0?ooo`1D0?ooo`800000C@3oool00`000000oooo0?ooo`1L0?ooo`006`3oool00`00
0000oooo0?ooo`1F0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0G@3oool001/0
oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`160?ooo`800000H03oool001/0oooo
00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0600oooo
000K0?ooo`030000003oool0oooo02P0oooo0P0000040?ooo`8000000`3oool400000280oooo1000
00040?ooo`8000001@3oool3000002<0oooo0P0000040?ooo`8000000`3oool3000000030?ooo`00
000000000240oooo0P0000040?ooo`800000103oool2000002X0oooo1@0000050?ooo`006`3oool0
0`000000oooo0?ooo`0W0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool0903o
ool2000000030?ooo`000000oooo00X0oooo00<000000?ooo`3oool08@3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo00000280oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`00000[0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000:03oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0oooo02<0oooo00@000000?ooo`0000000000203o
ool500000280oooo00@000000?ooo`3oool00000203oool400000280oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000[0?ooo`030000003oool0oooo00D0oooo000K0?ooo`03
0000003oool0oooo02L0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo008000001`3oool010000000oooo0?ooo`00000S0?ooo`040000003oool0
oooo000000L0oooo1000000S0?ooo`040000003oool0oooo000000T0oooo0P00000/0?ooo`030000
003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo02L0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`00000S0?ooo`050000003oool0oooo0000003oool00P0000060?oo
o`030000003oool0000002<0oooo00@000000?ooo`3oool000001@3oool200000080oooo00<00000
0?ooo`3oool08P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000002/0oooo
00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool0:03oool2000000X0oooo0P00
000U0?ooo`800000103oool2000000D0oooo0P00000T0?ooo`800000103oool2000000@0oooo0`00
000S0?ooo`8000002P3oool2000002/0oooo0P0000070?ooo`006`3oool00`000000oooo0?ooo`1S
0?ooo`<00000;03oool2000006h0oooo000K0?ooo`030000003oool0oooo06H0oooo0`00000W0?oo
o`800000L03oool001/0oooo00<000000?ooo`3oool0J@3oool2000002<0oooo0P00001b0?ooo`00
6`3oool00`000000oooo0?ooo`1[0?ooo`<000007@3oool3000007@0oooo000K0?ooo`030000003o
ool0oooo06h0oooo1000000C0?ooo`H00000M`3oool001@0ooooo`00000=000000006`3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool001/0
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00D0
oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.89166, \
0.00394728, 0.00534711}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Pozn.1: Aplikujeme-li tuto metodu na  speci\[AAcute]ln\[IAcute] volbu tvaru \
\:0159e\[SHacek]en\[IAcute], dostaneme metodu kone\[CHacek]\[YAcute]ch \
diferenc\[IAcute]\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Least Squares Method", "Subsection"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci derivace residua podle \
jednotliv\[YAcute]ch koeficient\:016f. (derivac\[IAcute] residua podle n \
koeficient\:016f je n, tak\:017ee po\[CHacek]et rovnic bude spr\[AAcute]vn\
\[YAcute])\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LSM = 
      0 == \[Integral]\_0\%1\[PartialD]\_a\ Residuum*
            Residuum \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    \(0 \[Equal] \(-25.20000000000001`\) + 4.412000000000002`\ a\)], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\:0159e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(resLSM = \(Solve[LSM, 
          a]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    \({a \[Rule] 5.7116953762466`}\)], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\:0159edpokl\
\[AAcute]dan\[EAcute]ho tvaru \:0159e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tapr /. resLSM\)], "Input"],

Cell[BoxData[
    \(5.7116953762466`\ \((1 - x)\)\ x\)], "Output"]
}, Open  ]],

Cell["\<\
\:0158e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu (samoz\:0159ejm\
\:011b z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Tapr /. resLSM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.41221 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .09716 -18 -4.5 ]
[.01131 .09716 0 4.5 ]
[.01131 .1796 -18 -4.5 ]
[.01131 .1796 0 4.5 ]
[.01131 .26204 -18 -4.5 ]
[.01131 .26204 0 4.5 ]
[.01131 .34448 -18 -4.5 ]
[.01131 .34448 0 4.5 ]
[.01131 .42693 -6 -4.5 ]
[.01131 .42693 0 4.5 ]
[.01131 .50937 -18 -4.5 ]
[.01131 .50937 0 4.5 ]
[.01131 .59181 -18 -4.5 ]
[.01131 .59181 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09716 m
.03006 .09716 L
s
[(0.2)] .01131 .09716 1 0 Mshowa
.02381 .1796 m
.03006 .1796 L
s
[(0.4)] .01131 .1796 1 0 Mshowa
.02381 .26204 m
.03006 .26204 L
s
[(0.6)] .01131 .26204 1 0 Mshowa
.02381 .34448 m
.03006 .34448 L
s
[(0.8)] .01131 .34448 1 0 Mshowa
.02381 .42693 m
.03006 .42693 L
s
[(1)] .01131 .42693 1 0 Mshowa
.02381 .50937 m
.03006 .50937 L
s
[(1.2)] .01131 .50937 1 0 Mshowa
.02381 .59181 m
.03006 .59181 L
s
[(1.4)] .01131 .59181 1 0 Mshowa
.125 Mabswid
.02381 .03533 m
.02756 .03533 L
s
.02381 .05594 m
.02756 .05594 L
s
.02381 .07655 m
.02756 .07655 L
s
.02381 .11777 m
.02756 .11777 L
s
.02381 .13838 m
.02756 .13838 L
s
.02381 .15899 m
.02756 .15899 L
s
.02381 .20021 m
.02756 .20021 L
s
.02381 .22082 m
.02756 .22082 L
s
.02381 .24143 m
.02756 .24143 L
s
.02381 .28265 m
.02756 .28265 L
s
.02381 .30326 m
.02756 .30326 L
s
.02381 .32387 m
.02756 .32387 L
s
.02381 .36509 m
.02756 .36509 L
s
.02381 .3857 m
.02756 .3857 L
s
.02381 .40631 m
.02756 .40631 L
s
.02381 .44754 m
.02756 .44754 L
s
.02381 .46815 m
.02756 .46815 L
s
.02381 .48876 m
.02756 .48876 L
s
.02381 .52998 m
.02756 .52998 L
s
.02381 .55059 m
.02756 .55059 L
s
.02381 .5712 m
.02756 .5712 L
s
.02381 .61242 m
.02756 .61242 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00@P3oool2000000@0oooo0P0000030?ooo`@000009@3oool2000000@0oooo0P0000050?oo
o`<000008`3oool2000000@0oooo0P0000030?ooo`<000009P3oool2000000@0oooo0P0000040?oo
o`800000:`3oool5000000D0oooo00110?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0240oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?ooo`00@@3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool00000203oool5
00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?oo
o`00@@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02<0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo
0`00000U0?ooo`040000003oool0oooo000000T0oooo0P00000]0?ooo`030000003oool0oooo00D0
oooo00110?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000903oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002<0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;03oool00`000000oooo0?ooo`050?ooo`00@P3oool2000000X0oooo0P00000V0?ooo`800000
2`3oool2000002@0oooo0P00000:0?ooo`<000009@3oool2000000X0oooo0P00000/0?ooo`800000
1`3oool00?l0oooo8@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`003P3ooooo000001<00000000E0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`005@3oool20000
0380oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0<03oool2000000L0oooo000E0?ooo`800000o`3oool10?ooo`03
0000003oool0oooo00H0oooo000E0?ooo`030000003oool000000?h0oooo00<000000?ooo`3oool0
1`3oool001D0oooo00<000000?ooo`000000oP3oool00`000000oooo0?ooo`070?ooo`005@3oool3
00000?d0oooo00<000000?ooo`3oool0203oool001D0oooo00@000000?ooo`3oool00000o03oool0
0`000000oooo0?ooo`080?ooo`005@3oool010000000oooo0?ooo`00003k0?ooo`030000003oool0
oooo00T0oooo000E0?ooo`050000003oool0oooo0?ooo`000000nP3oool00`000000oooo0?ooo`09
0?ooo`005@3oool01@000000oooo0?ooo`3oool000000?X0oooo00<000000?ooo`3oool02@3oool0
01D0oooo0P0000020?ooo`030000003oool0oooo0?L0oooo00<000000?ooo`3oool02P3oool001D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo00X0
oooo000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0m@3oool00`000000oooo
0?ooo`0;0?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?@0oooo00<0
00000?ooo`3oool02`3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3c
0?ooo`030000003oool0oooo00`0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`0<0?ooo`005@3oool2000000D0oooo00<000000?ooo`3o
ool0lP3oool00`000000oooo0?ooo`0<0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0?40oooo00<000000?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00d0oooo000E0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0k`3oool00`000000oooo0?ooo`0>0?ooo`000P3oool20000
00@0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0>l0oooo00<000000?ooo`3oool03P3oool000050?ooo`000000oooo0?ooo`000000203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0k@3oool00`00
0000oooo0?ooo`0?0?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003oool0oooo
00@0oooo0`0000060?ooo`030000003oool0oooo0>d0oooo00<000000?ooo`3oool03`3oool00005
0?ooo`000000oooo0?ooo`0000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?ooo`0@0?ooo`0000D0oooo0000003o
ool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`3[0?ooo`030000003oool0oooo0100oooo00020?ooo`8000002P3oool20000
00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3[0?ooo`030000003oool0oooo
0100oooo000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0j@3oool00`000000
oooo0?ooo`0A0?ooo`005@3oool2000000T0oooo00<000000?ooo`3oool0j@3oool00`000000oooo
0?ooo`0A0?ooo`005@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0>L0oooo00<0
00000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3W
0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0i@3oool00`000000oooo0?ooo`0C0?ooo`005@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo0>D0oooo00<000000?ooo`3oool04`3oool001D0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`3T0?ooo`030000003oool0oooo01<0oooo000E0?ooo`800000303o
ool00`000000oooo0?ooo`3S0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0hP3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool05@3oool001D0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3P0?ooo`030000003oool0oooo01D0
oooo000E0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0g`3oool00`000000oooo
0?ooo`0F0?ooo`005@3oool2000000l0oooo00<000000?ooo`3oool0gP3oool00`000000oooo0?oo
o`0F0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0=d0oooo00<00000
0?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3L0?oo
o`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0g03oool00`000000oooo0?ooo`0G0?ooo`000P3oool2000000@0oooo0P0000050?ooo`<00000
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3oool0
603oool000050?ooo`000000oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`0H0?ooo`0000D0
oooo0000003oool0oooo000000080?ooo`D000000`3oool300000140oooo00<000000?ooo`3oool0
f03oool00`000000oooo0?ooo`0I0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3H0?ooo`03
0000003oool0oooo01T0oooo00001@3oool000000?ooo`3oool0000000T0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0=H0oooo00<000000?ooo`3o
ool06P3oool00080oooo0P00000;0?ooo`800000103oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0=H0oooo00<000000?ooo`3oool06P3oool001D0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3D0?ooo`030000003oool0oooo01/0oooo000E0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`0K0?ooo`005@3oool20000
01D0oooo00<000000?ooo`3oool0dP3oool00`000000oooo0?ooo`0L0?ooo`005@3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0=80oooo00<000000?ooo`3oool0703oool001D0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo01d0oooo
000E0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0d03oool00`000000oooo0?oo
o`0M0?ooo`005@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0<h0oooo00<00000
0?ooo`3oool07P3oool001D0oooo0P00000G0?ooo`030000003oool0oooo0<h0oooo00<000000?oo
o`3oool07P3oool001D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`3<0?ooo`03
0000003oool0oooo01l0oooo000E0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
c03oool00`000000oooo0?ooo`0O0?ooo`005@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo0<X0oooo00<000000?ooo`3oool0803oool001D0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`3:0?ooo`030000003oool0oooo0200oooo000E0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0Q0?ooo`005@3oool2000001X0
oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0Q0?ooo`005@3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool08P3oool001D0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo0280oooo0002
0?ooo`800000103oool2000000<0oooo0`0000050?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool0a03oool00`000000oooo0?ooo`0S0?ooo`0000D0oooo0000003oool0oooo00000008
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`340?ooo`030000003oool0oooo02<0oooo00001@3oool000000?ooo`3oool0000000P0oooo00@0
00000?ooo`3oool00000103oool3000001`0oooo00<000000?ooo`3oool0`P3oool00`000000oooo
0?ooo`0T0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`<000001@3oool00`000000oooo
0?ooo`0L0?ooo`030000003oool0oooo0<80oooo00<000000?ooo`3oool0903oool000050?ooo`00
0000oooo0?ooo`0000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`0U0?ooo`000P3oool2000000X0oooo0`00
00040?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0`03oool00`000000oooo0?oo
o`0U0?ooo`005@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0;h0oooo00<00000
0?ooo`3oool09P3oool001D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`2m0?oo
o`030000003oool0oooo02H0oooo000E0?ooo`800000803oool00`000000oooo0?ooo`2l0?ooo`03
0000003oool0oooo02L0oooo000E0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
^`3oool00`000000oooo0?ooo`0W0?ooo`005@3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo0;X0oooo00<000000?ooo`3oool0:03oool001D0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02T0oooo000E0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0Y0?ooo`005@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0:P3oool001D0oooo
0P00000S0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0:`3oool001D0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo02/0oooo000E
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0/
0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0;80oooo00<000000?oo
o`3oool0;03oool001D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`2`0?ooo`03
0000003oool0oooo02d0oooo000E0?ooo`8000009P3oool00`000000oooo0?ooo`2_0?ooo`030000
003oool0oooo02h0oooo000E0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0[P3o
ool00`000000oooo0?ooo`0^0?ooo`005@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo0:d0oooo00<000000?ooo`3oool0;`3oool001D0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`2/0?ooo`030000003oool0oooo02l0oooo00020?ooo`800000103oool2000000@0
oooo0P0000050?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0Z`3oool00`000000
oooo0?ooo`0`0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo
0340oooo00001@3oool000000?ooo`3oool0000000P0oooo00@000000?ooo`3oool00000103oool3
000002T0oooo00<000000?ooo`3oool0Z03oool00`000000oooo0?ooo`0a0?ooo`0000D0oooo0000
003oool0oooo000000090?ooo`8000001@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo0:L0oooo00<000000?ooo`3oool0<P3oool000050?ooo`000000oooo0?ooo`000000203oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0YP3o
ool00`000000oooo0?ooo`0b0?ooo`000P3oool2000000X0oooo0P0000050?ooo`030000003oool0
oooo02/0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`0c0?ooo`005@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0=03oool001D0
oooo0P00000]0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0=03oool001D0oooo
00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo03D0oooo
000E0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0X03oool00`000000oooo0?oo
o`0e0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo09h0oooo00<00000
0?ooo`3oool0=P3oool001D0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`2N0?oo
o`030000003oool0oooo03H0oooo000E0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool0W03oool00`000000oooo0?ooo`0g0?ooo`005@3oool200000340oooo00<000000?ooo`3oool0
VP3oool00`000000oooo0?ooo`0h0?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`030000003o
ool0oooo09X0oooo00<000000?ooo`3oool0>03oool001D0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`2H0?ooo`030000003oool0oooo03T0oooo000E0?ooo`030000003oool0oooo
0380oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0i0?ooo`005@3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0>P3oool001D0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo03/0oooo
000E0?ooo`800000=@3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo03`0oooo000E
0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`0l
0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0900oooo00<000000?oo
o`3oool0?@3oool000d0oooo1@0000030?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`0n0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo03L0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0o0?ooo`003`3o
ool00`000000oooo0?ooo`030?ooo`<00000>03oool00`000000oooo0?ooo`2:0?ooo`030000003o
ool0oooo0400oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0>03oool0
0`000000oooo0?ooo`2:0?ooo`030000003oool0oooo0400oooo000?0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo
0440oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo08H0
oooo00<000000?ooo`3oool0@P3oool001D0oooo00<000000?ooo`3oool0>`3oool00`000000oooo
0?ooo`240?ooo`030000003oool0oooo04<0oooo000E0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool0PP3oool00`000000oooo0?ooo`140?ooo`005@3oool2000003d0oooo00<00000
0?ooo`3oool0PP3oool00`000000oooo0?ooo`140?ooo`005@3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo0800oooo00<000000?ooo`3oool0A@3oool001D0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo04H0oooo000E0?ooo`030000
003oool0oooo03l0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`170?ooo`005@3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0B03o
ool001D0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0
oooo04T0oooo000E0?ooo`800000@P3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0oooo
04T0oooo000E0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0MP3oool00`000000
oooo0?ooo`1:0?ooo`005@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo07@0oooo
00<000000?ooo`3oool0B`3oool001D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1b0?ooo`030000003oool0oooo04`0oooo000E0?ooo`030000003oool0oooo04D0oooo00<00000
0?ooo`3oool0L03oool00`000000oooo0?ooo`1=0?ooo`005@3oool2000004L0oooo00<000000?oo
o`3oool0KP3oool00`000000oooo0?ooo`1>0?ooo`005@3oool00`000000oooo0?ooo`160?ooo`03
0000003oool0oooo06h0oooo00<000000?ooo`3oool0CP3oool001D0oooo00<000000?ooo`3oool0
A`3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo04l0oooo000E0?ooo`030000003o
ool0oooo04P0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`1@0?ooo`0000<0oooo
0000000000000`0000020?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool0B@3oool0
0`000000oooo0?ooo`1X0?ooo`030000003oool0oooo0540oooo00030?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo
06H0oooo00<000000?ooo`3oool0DP3oool000<0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`<00000B`3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo05<0
oooo00030?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1<0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0E03oool000<0oooo00<0
00000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04d0oooo
00<000000?ooo`3oool0G`3oool2000005L0oooo00020?ooo`8000002P3oool2000000D0oooo00<0
00000?ooo`3oool0CP3oool2000005h0oooo00<000000?ooo`3oool0E`3oool001D0oooo00<00000
0?ooo`3oool0D03oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05P0oooo000E0?oo
o`800000DP3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05T0oooo000E0?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1J0?ooo`00
5@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0
F`3oool001D0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`1A0?ooo`800000GP3o
ool001D0oooo00<000000?ooo`3oool0E@3oool200000500oooo00<000000?ooo`3oool0GP3oool0
01D0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo
05l0oooo000E0?ooo`800000F@3oool00`000000oooo0?ooo`190?ooo`800000HP3oool001D0oooo
00<000000?ooo`3oool0F@3oool2000004P0oooo00<000000?ooo`3oool0HP3oool001D0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06<0oooo000E
0?ooo`030000003oool0oooo05`0oooo0P0000120?ooo`800000IP3oool001D0oooo00<000000?oo
o`3oool0GP3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06H0oooo000E0?ooo`03
0000003oool0oooo05l0oooo0P00000l0?ooo`800000J@3oool001D0oooo0P00001R0?ooo`800000
>03oool2000006/0oooo000E0?ooo`030000003oool0oooo06<0oooo0P00000e0?ooo`030000003o
ool0oooo06/0oooo000E0?ooo`030000003oool0oooo06D0oooo0P00000a0?ooo`800000KP3oool0
00030?ooo`000000000000<000000P3oool2000000D0oooo0`0000030?ooo`030000003oool0oooo
06L0oooo0P00000]0?ooo`800000L03oool000<0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo06T0oooo0P00000X0?ooo`<00000LP3oool000<0oooo
00<000000?ooo`3oool01`3oool5000000<0oooo0`00001[0?ooo`<000008`3oool2000007D0oooo
00030?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000103oool00`000000oooo
0?ooo`1^0?ooo`8000007P3oool3000007L0oooo00030?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`000000103oool00`000000oooo0?ooo`1`0?ooo`D000004`3oool6000007X0oooo0002
0?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool0M@3ooolC00000800oooo000E0?oo
o`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
5@3oool200000?l0oooo2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -0.112305, \
0.00385924, 0.00891649}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\:017e do rovnice dosad\[IAcute]me \:0159e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rovApr /. resLSM\)], "Input"],

Cell[BoxData[
    \(\(-11.4233907524932`\) \[Equal] 
      0.6000000000000001`\ \((\(-20\) + 
            5.7116953762466`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell["\<\
Spln\:011bn\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me na \
residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Residuum /. resLSM\)], "Input"],

Cell[BoxData[
    \(\(\(11.4233907524932`\)\(\[InvisibleSpace]\)\) + 
      0.6000000000000001`\ \((\(-20\) + 
            5.7116953762466`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Residuum /. resLSM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.410855 0.687017 [
[.21429 .39836 -9 -9 ]
[.21429 .39836 9 0 ]
[.40476 .39836 -9 -9 ]
[.40476 .39836 9 0 ]
[.59524 .39836 -9 -9 ]
[.59524 .39836 9 0 ]
[.78571 .39836 -9 -9 ]
[.78571 .39836 9 0 ]
[.97619 .39836 -3 -9 ]
[.97619 .39836 3 0 ]
[.01131 .13605 -24 -4.5 ]
[.01131 .13605 0 4.5 ]
[.01131 .27345 -24 -4.5 ]
[.01131 .27345 0 4.5 ]
[.01131 .54826 -18 -4.5 ]
[.01131 .54826 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .41086 m
.21429 .41711 L
s
[(0.2)] .21429 .39836 0 1 Mshowa
.40476 .41086 m
.40476 .41711 L
s
[(0.4)] .40476 .39836 0 1 Mshowa
.59524 .41086 m
.59524 .41711 L
s
[(0.6)] .59524 .39836 0 1 Mshowa
.78571 .41086 m
.78571 .41711 L
s
[(0.8)] .78571 .39836 0 1 Mshowa
.97619 .41086 m
.97619 .41711 L
s
[(1)] .97619 .39836 0 1 Mshowa
.125 Mabswid
.07143 .41086 m
.07143 .41461 L
s
.11905 .41086 m
.11905 .41461 L
s
.16667 .41086 m
.16667 .41461 L
s
.2619 .41086 m
.2619 .41461 L
s
.30952 .41086 m
.30952 .41461 L
s
.35714 .41086 m
.35714 .41461 L
s
.45238 .41086 m
.45238 .41461 L
s
.5 .41086 m
.5 .41461 L
s
.54762 .41086 m
.54762 .41461 L
s
.64286 .41086 m
.64286 .41461 L
s
.69048 .41086 m
.69048 .41461 L
s
.7381 .41086 m
.7381 .41461 L
s
.83333 .41086 m
.83333 .41461 L
s
.88095 .41086 m
.88095 .41461 L
s
.92857 .41086 m
.92857 .41461 L
s
.25 Mabswid
0 .41086 m
1 .41086 L
s
.02381 .13605 m
.03006 .13605 L
s
[(-0.4)] .01131 .13605 1 0 Mshowa
.02381 .27345 m
.03006 .27345 L
s
[(-0.2)] .01131 .27345 1 0 Mshowa
.02381 .54826 m
.03006 .54826 L
s
[(0.2)] .01131 .54826 1 0 Mshowa
.125 Mabswid
.02381 .033 m
.02756 .033 L
s
.02381 .06735 m
.02756 .06735 L
s
.02381 .1017 m
.02756 .1017 L
s
.02381 .1704 m
.02756 .1704 L
s
.02381 .20475 m
.02756 .20475 L
s
.02381 .2391 m
.02756 .2391 L
s
.02381 .3078 m
.02756 .3078 L
s
.02381 .34215 m
.02756 .34215 L
s
.02381 .3765 m
.02756 .3765 L
s
.02381 .44521 m
.02756 .44521 L
s
.02381 .47956 m
.02756 .47956 L
s
.02381 .51391 m
.02756 .51391 L
s
.02381 .58261 m
.02756 .58261 L
s
.02381 .61696 m
.02756 .61696 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?oo
o`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?X0oooo00<000000?ooo`3oool01@3oool0
01/0oooo00<000000?ooo`3oool0nP3oool00`000000oooo0?ooo`050?ooo`006`3oool200000?X0
oooo00<000000?ooo`3oool01P3oool001/0oooo0P00003j0?ooo`030000003oool0oooo00H0oooo
000K0?ooo`030000003oool000000?P0oooo00<000000?ooo`3oool01`3oool001/0oooo0`00003h
0?ooo`030000003oool0oooo00L0oooo000K0?ooo`030000003oool000000?L0oooo00<000000?oo
o`3oool0203oool001/0oooo00@000000?ooo`3oool00000mP3oool00`000000oooo0?ooo`080?oo
o`006`3oool010000000oooo0?ooo`00003f0?ooo`030000003oool0oooo00P0oooo000K0?ooo`05
0000003oool0oooo0?ooo`000000m03oool00`000000oooo0?ooo`090?ooo`006`3oool01@000000
oooo0?ooo`3oool000000?@0oooo00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00X0oooo000K0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0l03oool00`000000oooo0?ooo`0:0?ooo`006`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3oool02P3o
ool001/0oooo0P0000040?ooo`030000003oool0oooo0>h0oooo00<000000?ooo`3oool02`3oool0
01/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`030000003oool0oooo
00/0oooo000K0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0k03oool00`000000
oooo0?ooo`0<0?ooo`006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>`0oooo
00<000000?ooo`3oool0303oool001/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`3[0?ooo`030000003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0jP3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0>X0oooo00<000000?ooo`3oool03@3oool001/0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0j03oool00`000000oooo0?ooo`0>0?ooo`006`3o
ool2000000P0oooo00<000000?ooo`3oool0iP3oool00`000000oooo0?ooo`0?0?ooo`006`3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool03`3oool0
01/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3V0?ooo`030000003oool0oooo
00l0oooo000K0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0i03oool00`000000
oooo0?ooo`0@0?ooo`006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>@0oooo
00<000000?ooo`3oool0403oool001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`3R0?ooo`030000003oool0oooo0140oooo000K0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0hP3oool00`000000oooo0?ooo`0A0?ooo`00203oool2000000@0oooo0P0000050?oo
o`<000000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0>00oooo00<000000?oo
o`3oool04P3oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0h03oool00`000000oooo0?ooo`0B0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`D000000`3oool2000000`0oooo00<000000?oo
o`3oool0gP3oool00`000000oooo0?ooo`0C0?ooo`0000<0oooo0000000000000P0000020?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo0=h0oooo00<000000?ooo`3oool04`3oool000L0oooo00@000000?oo
o`3oool000002@3oool00`000000oooo000000040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0g03oool00`000000oooo0?ooo`0D0?ooo`00203oool2000000/0oooo0P0000040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`0D0?oo
o`006`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0=/0oooo00<000000?ooo`3o
ool05@3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3J0?ooo`030000
003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0f@3o
ool00`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0=P0oooo00<000000?ooo`3oool05P3oool001/0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`3G0?ooo`030000003oool0oooo01L0oooo000K0?ooo`800000403oool00`000000
oooo0?ooo`3F0?ooo`030000003oool0oooo01L0oooo000K0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0e@3oool00`000000oooo0?ooo`0H0?ooo`006`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0=@0oooo00<000000?ooo`3oool0603oool001/0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`3C0?ooo`030000003oool0oooo01T0oooo000K0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0dP3oool00`000000oooo0?ooo`0I0?oo
o`006`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0=40oooo00<000000?ooo`3o
ool06P3oool001/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3@0?ooo`030000
003oool0oooo01X0oooo000K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0d03o
ool00`000000oooo0?ooo`0J0?ooo`006`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0<h0oooo00<000000?ooo`3oool06`3oool001/0oooo0P00000D0?ooo`030000003oool0oooo
0<h0oooo00<000000?ooo`3oool06`3oool001/0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`3<0?ooo`030000003oool0oooo01`0oooo000K0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`0L0?ooo`006`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool07@3oool001/0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo01d0oooo000K0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0N0?oo
o`006`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3o
ool07P3oool001/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`360?ooo`030000
003oool0oooo01l0oooo000K0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0aP3o
ool00`000000oooo0?ooo`0O0?ooo`006`3oool2000001T0oooo00<000000?ooo`3oool0a03oool0
0`000000oooo0?ooo`0P0?ooo`006`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
0<@0oooo00<000000?ooo`3oool0803oool001/0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`320?ooo`030000003oool0oooo0240oooo000K0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`0Q0?ooo`006`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool08P3oool001/0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo0280oooo000K0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?ooo`0S0?oo
o`006`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3o
ool08`3oool000P0oooo0P0000040?ooo`8000000`3oool4000000@0oooo00<000000?ooo`3oool0
703oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo02@0oooo00070?ooo`040000003o
ool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo0;`0oooo00<000000?ooo`3oool0903oool000L0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0?ooo`040?ooo`8000007P3oool00`000000oooo0?ooo`2j0?ooo`030000
003oool0oooo02D0oooo00000`3oool000000000000200000080oooo00@000000?ooo`3oool00000
2P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
^@3oool00`000000oooo0?ooo`0U0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2h0?ooo`03
0000003oool0oooo02H0oooo00080?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`2g0?ooo`030000003oool0oooo02H0oooo000K0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`0W0?ooo`006`3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3oool0:03oool0
01/0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo
02P0oooo000K0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0/P3oool00`000000
oooo0?ooo`0Y0?ooo`006`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;40oooo
00<000000?ooo`3oool0:P3oool001/0oooo0P00000S0?ooo`030000003oool0oooo0;00oooo00<0
00000?ooo`3oool0:P3oool001/0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2^
0?ooo`030000003oool0oooo02/0oooo000K0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0[P3oool00`000000oooo0?ooo`0[0?ooo`006`3oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo0:`0oooo00<000000?ooo`3oool0;03oool001/0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02d0oooo000K0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`0]0?ooo`006`3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3oool0;P3oool0
01/0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo
02h0oooo000K0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0Y`3oool00`000000
oooo0?ooo`0_0?ooo`006`3oool2000002P0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo
0?ooo`0`0?ooo`006`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0:@0oooo00<0
00000?ooo`3oool0<03oool001/0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2S
0?ooo`030000003oool0oooo0340oooo000K0?ooo`030000003oool0oooo02T0oooo00<000000?oo
o`3oool0X@3oool00`000000oooo0?ooo`0b0?ooo`006`3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo0:00oooo00<000000?ooo`3oool0<P3oool001/0oooo00<000000?ooo`3oool0
:P3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo03<0oooo000K0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`0c0?ooo`006`3oool0
0`000000oooo0?ooo`0X0?ooo`8000000P3oool010000000oooo0000000000030?ooo`@00000903o
ool2000000@0oooo0P0000050?ooo`<000008`3oool2000000@0oooo0P0000030?ooo`<00000903o
ool2000000@0oooo0P0000030?ooo`<00000:P3oool5000000D0oooo000K0?ooo`030000003oool0
oooo02L0oooo00H000000?ooo`3oool000000?ooo`0000060?ooo`030000003oool0oooo02@0oooo
00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000008P3oool010000000oooo0?ooo`0000070?ooo`8000000P3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000:03oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3o
ool010000000oooo0?ooo`0000080?ooo`D000008P3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo00000280oooo00@000000?ooo`3oool000001`3oool200000080oooo00<00000
0?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0W0?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0R
0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000008`3oool010000000oooo
0?ooo`0000080?ooo`<000008`3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo
00800000;03oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`04
0000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo0240oooo00@000000?ooo`3oool000002@3oool00`000000oooo0000000S0?ooo`040000003o
ool0oooo000000T0oooo00<000000?ooo`3oool08P3oool010000000oooo0?ooo`0000050?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?oo
o`006`3oool00`000000oooo0?ooo`0X0?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`80
00009@3oool2000000/0oooo0P00000T0?ooo`8000002P3oool3000002<0oooo0P0000060?ooo`04
0000003oool0oooo0?ooo`800000:`3oool2000000L0oooo000K0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`0h0?ooo`006`3oool00`000000oooo
0?ooo`0a0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0>03oool001/0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo03T0oooo000K
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`0j
0?ooo`006`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo08l0oooo00<000000?oo
o`3oool0>P3oool001@0ooooo`00000=000000006`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0
oooo000K0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool01@3oool001/0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo03d0oooo000K
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`0n
0?ooo`006`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo08H0oooo00<000000?oo
o`3oool0?`3oool001/0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`240?ooo`03
0000003oool0oooo0400oooo000K0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
Q03oool00`000000oooo0?ooo`100?ooo`006`3oool00`000000oooo0?ooo`0i0?ooo`030000003o
ool0oooo0880oooo00<000000?ooo`3oool0@@3oool001/0oooo0P00000k0?ooo`030000003oool0
oooo0800oooo00<000000?ooo`3oool0@P3oool001/0oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`1n0?ooo`030000003oool0oooo04<0oooo000K0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`130?ooo`006`3oool00`000000oooo
0?ooo`0l0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0A03oool001/0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo04D0oooo000K
0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`16
0?ooo`006`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo07H0oooo00<000000?oo
o`3oool0A`3oool001/0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`1f0?ooo`03
0000003oool0oooo04L0oooo000K0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
M03oool00`000000oooo0?ooo`180?ooo`006`3oool200000480oooo00<000000?ooo`3oool0LP3o
ool00`000000oooo0?ooo`190?ooo`006`3oool00`000000oooo0?ooo`120?ooo`030000003oool0
oooo0700oooo00<000000?ooo`3oool0BP3oool001/0oooo00<000000?ooo`3oool0@`3oool00`00
0000oooo0?ooo`1^0?ooo`030000003oool0oooo04/0oooo000K0?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`1<0?ooo`006`3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0C03oool001/0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo04d0oooo000K
0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`1>
0?ooo`006`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo06H0oooo00<000000?oo
o`3oool0C`3oool001/0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`1T0?ooo`03
0000003oool0oooo0500oooo000K0?ooo`030000003oool0oooo04T0oooo0P00001S0?ooo`030000
003oool0oooo0540oooo000K0?ooo`800000C03oool00`000000oooo0?ooo`1O0?ooo`030000003o
ool0oooo0580oooo000K0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0G03oool2
000005D0oooo000K0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0FP3oool00`00
0000oooo0?ooo`1E0?ooo`006`3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo05P0
oooo00<000000?ooo`3oool0EP3oool001/0oooo00<000000?ooo`3oool0C`3oool2000005L0oooo
00<000000?ooo`3oool0E`3oool001/0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo05P0oooo000K0?ooo`030000003oool0oooo0580oooo00<00000
0?ooo`3oool0D@3oool00`000000oooo0?ooo`1I0?ooo`00203oool2000000@0oooo0P0000030?oo
o`@00000103oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo04h0oooo0P00001L0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0E03oool2000004d0oooo00<000000?ooo`3oool0G03oool000L0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo0?ooo`040?ooo`800000E`3oool00`000000oooo0?ooo`190?oo
o`030000003oool0oooo05d0oooo00070?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo04H0oooo0P00001P0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool0F03oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0600oooo00080?oo
o`8000002P3oool2000000D0oooo00<000000?ooo`3oool0F@3oool200000480oooo0P00001S0?oo
o`006`3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3o
ool0H`3oool001/0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0k0?ooo`800000
IP3oool001/0oooo00<000000?ooo`3oool0G@3oool2000003T0oooo0P00001X0?ooo`006`3oool0
0`000000oooo0?ooo`1O0?ooo`800000=@3oool2000006X0oooo000K0?ooo`030000003oool0oooo
0640oooo0P00000a0?ooo`800000K03oool001/0oooo0P00001T0?ooo`<00000;03oool2000006h0
oooo000K0?ooo`030000003oool0oooo06H0oooo0`00000W0?ooo`800000L03oool001/0oooo00<0
00000?ooo`3oool0J@3oool2000002<0oooo0P00001b0?ooo`006`3oool00`000000oooo0?ooo`1[
0?ooo`<000007@3oool3000007@0oooo000K0?ooo`030000003oool0oooo06h0oooo1000000C0?oo
o`H00000M`3oool001/0oooo00<000000?ooo`3oool0LP3ooolC000007d0oooo000K0?ooo`030000
003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool0
0`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.632331, \
0.00394728, 0.00547194}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Galerkin's Method", "Subsection"],

Cell["\<\
Tato metoda dosad\[IAcute] za testovac\[IAcute] funkci derivace navrhovan\
\[EAcute]ho \:0159e\[SHacek]en\[IAcute] podle jednotliv\[YAcute]ch koeficient\
\:016f. (derivac\[IAcute] podle n koeficient\:016f je op\:011bt n, tak\:017ee \
to op\:011bt vyhovuje)\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GM = 
      0 == \[Integral]\_0\%1\[PartialD]\_a\ Tapr*
            Residuum \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    \(0 \[Equal] \(-2.000000000000001`\) + 0.3533333333333334`\ a\)], "Output"]
}, Open  ]],

Cell["\<\
A dostaneme rovnici (soustavu rovnic) pro n\[AAcute]\[SHacek] koeficient \
(koeficienty)\
\>", "Text"],

Cell["Rovnici vy\:0159e\[SHacek]\[IAcute]me", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(resGM = \(Solve[GM, 
          a]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(resGM\\)\\\" is similar to existing symbol \
\\\"\\!\\(resCM\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \({a \[Rule] 5.6603773584905674`}\)], "Output"]
}, Open  ]],

Cell["\<\
A dosad\[IAcute]me vypo\[CHacek]ten\[YAcute] koeficient do p\:0159edpokl\
\[AAcute]dan\[EAcute]ho tvaru \:0159e\[SHacek]en\[IAcute] \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tapr /. resGM\)], "Input"],

Cell[BoxData[
    \(5.6603773584905674`\ \((1 - x)\)\ x\)], "Output"]
}, Open  ]],

Cell["\<\
\:0158e\[SHacek]en\[IAcute]m pak je v\[YAcute]raz pro teplotu (samoz\:0159ejm\
\:011b z\[AAcute]visl\[YAcute] na x):\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Tapr /. resGM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.415947 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .0979 -18 -4.5 ]
[.01131 .0979 0 4.5 ]
[.01131 .18109 -18 -4.5 ]
[.01131 .18109 0 4.5 ]
[.01131 .26428 -18 -4.5 ]
[.01131 .26428 0 4.5 ]
[.01131 .34747 -18 -4.5 ]
[.01131 .34747 0 4.5 ]
[.01131 .43066 -6 -4.5 ]
[.01131 .43066 0 4.5 ]
[.01131 .51385 -18 -4.5 ]
[.01131 .51385 0 4.5 ]
[.01131 .59704 -18 -4.5 ]
[.01131 .59704 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .0979 m
.03006 .0979 L
s
[(0.2)] .01131 .0979 1 0 Mshowa
.02381 .18109 m
.03006 .18109 L
s
[(0.4)] .01131 .18109 1 0 Mshowa
.02381 .26428 m
.03006 .26428 L
s
[(0.6)] .01131 .26428 1 0 Mshowa
.02381 .34747 m
.03006 .34747 L
s
[(0.8)] .01131 .34747 1 0 Mshowa
.02381 .43066 m
.03006 .43066 L
s
[(1)] .01131 .43066 1 0 Mshowa
.02381 .51385 m
.03006 .51385 L
s
[(1.2)] .01131 .51385 1 0 Mshowa
.02381 .59704 m
.03006 .59704 L
s
[(1.4)] .01131 .59704 1 0 Mshowa
.125 Mabswid
.02381 .03551 m
.02756 .03551 L
s
.02381 .05631 m
.02756 .05631 L
s
.02381 .07711 m
.02756 .07711 L
s
.02381 .1187 m
.02756 .1187 L
s
.02381 .1395 m
.02756 .1395 L
s
.02381 .1603 m
.02756 .1603 L
s
.02381 .20189 m
.02756 .20189 L
s
.02381 .22269 m
.02756 .22269 L
s
.02381 .24349 m
.02756 .24349 L
s
.02381 .28508 m
.02756 .28508 L
s
.02381 .30588 m
.02756 .30588 L
s
.02381 .32668 m
.02756 .32668 L
s
.02381 .36827 m
.02756 .36827 L
s
.02381 .38907 m
.02756 .38907 L
s
.02381 .40986 m
.02756 .40986 L
s
.02381 .45146 m
.02756 .45146 L
s
.02381 .47226 m
.02756 .47226 L
s
.02381 .49305 m
.02756 .49305 L
s
.02381 .53465 m
.02756 .53465 L
s
.02381 .55545 m
.02756 .55545 L
s
.02381 .57624 m
.02756 .57624 L
s
.02381 .61784 m
.02756 .61784 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00@P3oool2000000@0oooo0P0000030?ooo`@000009@3oool2000000@0oooo0P0000050?oo
o`<000008`3oool2000000@0oooo0P0000030?ooo`<000009P3oool2000000@0oooo0P0000040?oo
o`800000:`3oool5000000D0oooo00110?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0240oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?ooo`00@@3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02@0oooo00@000000?ooo`3oool00000203oool5
00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`050?oo
o`00@@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02<0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000S0?ooo`040000003oool0oooo000000P0oooo
0`00000U0?ooo`040000003oool0oooo000000T0oooo0P00000]0?ooo`030000003oool0oooo00D0
oooo00110?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000903oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002<0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;03oool00`000000oooo0?ooo`050?ooo`00@P3oool2000000X0oooo0P00000V0?ooo`800000
2`3oool2000002@0oooo0P00000:0?ooo`<000009@3oool2000000X0oooo0P00000/0?ooo`800000
1`3oool00?l0oooo8@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`003P3ooooo000001<00000000E0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`005@3oool20000
0380oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool0<03oool2000000L0oooo000E0?ooo`800000o`3oool10?ooo`03
0000003oool0oooo00H0oooo000E0?ooo`030000003oool000000?h0oooo00<000000?ooo`3oool0
1`3oool001D0oooo00<000000?ooo`000000oP3oool00`000000oooo0?ooo`070?ooo`005@3oool3
00000?d0oooo00<000000?ooo`3oool0203oool001D0oooo00@000000?ooo`3oool00000o03oool0
0`000000oooo0?ooo`080?ooo`005@3oool010000000oooo0?ooo`00003k0?ooo`030000003oool0
oooo00T0oooo000E0?ooo`050000003oool0oooo0?ooo`000000nP3oool00`000000oooo0?ooo`09
0?ooo`005@3oool01@000000oooo0?ooo`3oool000000?X0oooo00<000000?ooo`3oool02@3oool0
01D0oooo0P0000020?ooo`030000003oool0oooo0?L0oooo00<000000?ooo`3oool02P3oool001D0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo00X0
oooo000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0m@3oool00`000000oooo
0?ooo`0;0?ooo`005@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?@0oooo00<0
00000?ooo`3oool02`3oool001D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3c
0?ooo`030000003oool0oooo00`0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0l`3oool00`000000oooo0?ooo`0<0?ooo`005@3oool2000000D0oooo00<000000?ooo`3o
ool0lP3oool00`000000oooo0?ooo`0<0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0?40oooo00<000000?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00d0oooo000E0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0k`3oool00`000000oooo0?ooo`0>0?ooo`000P3oool20000
00@0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0>l0oooo00<000000?ooo`3oool03P3oool000050?ooo`000000oooo0?ooo`000000203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0k@3oool00`00
0000oooo0?ooo`0?0?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003oool0oooo
00@0oooo0`0000060?ooo`030000003oool0oooo0>d0oooo00<000000?ooo`3oool03`3oool00005
0?ooo`000000oooo0?ooo`0000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?ooo`0@0?ooo`0000D0oooo0000003o
ool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`3[0?ooo`030000003oool0oooo0100oooo00020?ooo`8000002P3oool20000
00D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3[0?ooo`030000003oool0oooo
0100oooo000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0j@3oool00`000000
oooo0?ooo`0A0?ooo`005@3oool2000000T0oooo00<000000?ooo`3oool0j@3oool00`000000oooo
0?ooo`0A0?ooo`005@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0>L0oooo00<0
00000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3W
0?ooo`030000003oool0oooo0180oooo000E0?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0i@3oool00`000000oooo0?ooo`0C0?ooo`005@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo0>D0oooo00<000000?ooo`3oool04`3oool001D0oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`3T0?ooo`030000003oool0oooo01<0oooo000E0?ooo`800000303o
ool00`000000oooo0?ooo`3S0?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0hP3oool00`000000oooo0?ooo`0D0?ooo`005@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0>40oooo00<000000?ooo`3oool05@3oool001D0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3P0?ooo`030000003oool0oooo01D0
oooo000E0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0g`3oool00`000000oooo
0?ooo`0F0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0=h0oooo00<0
00000?ooo`3oool05P3oool001D0oooo0P00000?0?ooo`030000003oool0oooo0=d0oooo00<00000
0?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3L0?oo
o`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0g03oool00`000000oooo0?ooo`0G0?ooo`000P3oool2000000@0oooo0P0000050?ooo`<00000
0`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3oool0
603oool000050?ooo`000000oooo0?ooo`0000002`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`0H0?ooo`0000D0
oooo0000003oool0oooo000000080?ooo`D000000`3oool300000140oooo00<000000?ooo`3oool0
f03oool00`000000oooo0?ooo`0I0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`3H0?ooo`03
0000003oool0oooo01T0oooo00001@3oool000000?ooo`3oool0000000T0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0=H0oooo00<000000?ooo`3o
ool06P3oool00080oooo0P00000;0?ooo`800000103oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0=H0oooo00<000000?ooo`3oool06P3oool001D0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3D0?ooo`030000003oool0oooo01/0oooo000E0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`0K0?ooo`005@3oool20000
01D0oooo00<000000?ooo`3oool0dP3oool00`000000oooo0?ooo`0L0?ooo`005@3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0=80oooo00<000000?ooo`3oool0703oool001D0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3@0?ooo`030000003oool0oooo01d0oooo
000E0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0d03oool00`000000oooo0?oo
o`0M0?ooo`005@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0<h0oooo00<00000
0?ooo`3oool07P3oool001D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`3>0?oo
o`030000003oool0oooo01h0oooo000E0?ooo`800000603oool00`000000oooo0?ooo`3<0?ooo`03
0000003oool0oooo01l0oooo000E0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
c03oool00`000000oooo0?ooo`0O0?ooo`005@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo0<X0oooo00<000000?ooo`3oool0803oool001D0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`3:0?ooo`030000003oool0oooo0200oooo000E0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0Q0?ooo`005@3oool2000001X0
oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0Q0?ooo`005@3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool08P3oool001D0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo0280oooo000E
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`0S
0?ooo`000P3oool2000000@0oooo0P0000030?ooo`<000001@3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo0<@0oooo00<000000?ooo`3oool08`3oool000050?ooo`000000oooo0?oo
o`000000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0`P3oool00`000000oooo0?ooo`0T0?ooo`0000D0oooo0000003oool0oooo00000008
0?ooo`040000003oool0oooo000000@0oooo0`00000L0?ooo`030000003oool0oooo0<80oooo00<0
00000?ooo`3oool0903oool000050?ooo`000000oooo0?ooo`000000203oool3000000D0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo02D0oooo0000
1@3oool000000?ooo`3oool0000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0M0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool09@3oool00080oooo0P00000:
0?ooo`<00000103oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0;h0oooo00<00000
0?ooo`3oool09P3oool001D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`2m0?oo
o`030000003oool0oooo02H0oooo000E0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0_03oool00`000000oooo0?ooo`0W0?ooo`005@3oool200000240oooo00<000000?ooo`3oool0
^`3oool00`000000oooo0?ooo`0W0?ooo`005@3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo0;X0oooo00<000000?ooo`3oool0:03oool001D0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`2h0?ooo`030000003oool0oooo02T0oooo000E0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0^03oool00`000000oooo0?ooo`0Y0?ooo`005@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3oool0:P3oool001D0oooo
0P00000S0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0:`3oool001D0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo02/0oooo000E
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0/
0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0;80oooo00<000000?oo
o`3oool0;03oool001D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`2`0?ooo`03
0000003oool0oooo02d0oooo000E0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
[`3oool00`000000oooo0?ooo`0^0?ooo`005@3oool2000002L0oooo00<000000?ooo`3oool0[P3o
ool00`000000oooo0?ooo`0^0?ooo`005@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0
oooo0:d0oooo00<000000?ooo`3oool0;`3oool001D0oooo00<000000?ooo`3oool09`3oool00`00
0000oooo0?ooo`2/0?ooo`030000003oool0oooo02l0oooo000E0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool0Z`3oool00`000000oooo0?ooo`0`0?ooo`000P3oool2000000@0oooo
0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0:T0oooo
00<000000?ooo`3oool0<@3oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0Z03oool00`000000
oooo0?ooo`0a0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo0000
00@0oooo0`00000Y0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0<P3oool00005
0?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo00<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`2V0?ooo`030000003oool0oooo0380oooo00001@3oool000000?ooo`3oool00000
00P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo0:@0oooo00<000000?ooo`3oool0<`3oool00080oooo0P00000:0?ooo`8000001@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0=03oool001D0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`2R0?ooo`030000003oool0oooo03@0
oooo000E0?ooo`800000;P3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo03D0oooo
000E0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0X03oool00`000000oooo0?oo
o`0e0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo09h0oooo00<00000
0?ooo`3oool0=P3oool001D0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`2N0?oo
o`030000003oool0oooo03H0oooo000E0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3o
ool0W03oool00`000000oooo0?ooo`0g0?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`030000
003oool0oooo09X0oooo00<000000?ooo`3oool0>03oool001D0oooo0P00000a0?ooo`030000003o
ool0oooo09X0oooo00<000000?ooo`3oool0>03oool001D0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`2H0?ooo`030000003oool0oooo03T0oooo000E0?ooo`030000003oool0oooo
0380oooo00<000000?ooo`3oool0U`3oool00`000000oooo0?ooo`0i0?ooo`005@3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0>P3oool001D0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo03/0oooo
000E0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?oo
o`0l0?ooo`005@3oool2000003H0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`0l
0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0900oooo00<000000?oo
o`3oool0?@3oool001D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`2>0?ooo`03
0000003oool0oooo03h0oooo000=0?ooo`D000000`3oool00`000000oooo0?ooo`0g0?ooo`030000
003oool0oooo08`0oooo00<000000?ooo`3oool0?`3oool000l0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0@03o
ool000l0oooo00<000000?ooo`3oool00`3oool3000003P0oooo00<000000?ooo`3oool0RP3oool0
0`000000oooo0?ooo`100?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
03T0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`110?ooo`003`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0QP3oool00`000000
oooo0?ooo`120?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool0>`3oool00`000000oooo
0?ooo`240?ooo`030000003oool0oooo04<0oooo000E0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool0PP3oool00`000000oooo0?ooo`140?ooo`005@3oool00`000000oooo0?ooo`0l
0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool0A03oool001D0oooo0P00000n0?oo
o`030000003oool0oooo0800oooo00<000000?ooo`3oool0A@3oool001D0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo04H0oooo000E0?ooo`030000
003oool0oooo03l0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`170?ooo`005@3o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0B03o
ool001D0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1h0?ooo`030000003oool0
oooo04T0oooo000E0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0N03oool00`00
0000oooo0?ooo`190?ooo`005@3oool2000004<0oooo00<000000?ooo`3oool0MP3oool00`000000
oooo0?ooo`1:0?ooo`005@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo07@0oooo
00<000000?ooo`3oool0B`3oool001D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1b0?ooo`030000003oool0oooo04`0oooo000E0?ooo`030000003oool0oooo04D0oooo00<00000
0?ooo`3oool0L03oool00`000000oooo0?ooo`1=0?ooo`005@3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo06h0oooo00<000000?ooo`3oool0CP3oool001D0oooo0P0000170?ooo`03
0000003oool0oooo06h0oooo00<000000?ooo`3oool0CP3oool001D0oooo00<000000?ooo`3oool0
A`3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo04l0oooo000E0?ooo`030000003o
ool0oooo04P0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`1@0?ooo`005@3oool0
0`000000oooo0?ooo`190?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0D@3oool0
00030?ooo`000000000000<000000P3oool2000000<0oooo100000040?ooo`030000003oool0oooo
04X0oooo00<000000?ooo`3oool0IP3oool00`000000oooo0?ooo`1B0?ooo`000`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B`3oool00`000000
oooo0?ooo`1T0?ooo`030000003oool0oooo05<0oooo00030?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0103oool3000004`0oooo00<000000?ooo`3oool0HP3oool00`000000oooo
0?ooo`1D0?ooo`000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0C@3oool00`000000oooo0?ooo`1O0?ooo`800000E`3oool000<0oooo00<00000
0?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo04h0oooo0P00
001N0?ooo`030000003oool0oooo05L0oooo00020?ooo`8000002P3oool2000000D0oooo00<00000
0?ooo`3oool0D03oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05P0oooo000E0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1I0?oo
o`005@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3o
ool0FP3oool001D0oooo0P00001D0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0
F`3oool001D0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`1A0?ooo`800000GP3o
ool001D0oooo00<000000?ooo`3oool0E@3oool200000500oooo00<000000?ooo`3oool0GP3oool0
01D0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo
05l0oooo000E0?ooo`030000003oool0oooo05P0oooo00<000000?ooo`3oool0B@3oool200000680
oooo000E0?ooo`800000FP3oool2000004P0oooo00<000000?ooo`3oool0HP3oool001D0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06<0oooo000E
0?ooo`030000003oool0oooo05`0oooo0P0000120?ooo`800000IP3oool001D0oooo00<000000?oo
o`3oool0GP3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06H0oooo000E0?ooo`03
0000003oool0oooo05l0oooo0P00000l0?ooo`800000J@3oool001D0oooo00<000000?ooo`3oool0
H@3oool2000003P0oooo0P00001[0?ooo`005@3oool2000006@0oooo0P00000e0?ooo`030000003o
ool0oooo06/0oooo000E0?ooo`030000003oool0oooo06D0oooo0P00000a0?ooo`800000KP3oool0
01D0oooo00<000000?ooo`3oool0I`3oool2000002d0oooo0P00001`0?ooo`005@3oool00`000000
oooo0?ooo`1Y0?ooo`800000:03oool300000780oooo00000`3oool000000000000300000080oooo
0P0000050?ooo`<000000`3oool00`000000oooo0?ooo`1[0?ooo`<000008`3oool2000007D0oooo
00030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`1^0?ooo`8000007P3oool3000007L0oooo00030?ooo`030000003oool0oooo00L0oooo1@000003
0?ooo`<00000L03oool5000001<0oooo1P00001j0?ooo`000`3oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0M@3ooolC00000800oooo00030?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`3o0?oo
o`T0oooo00020?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool0o`3oool90?ooo`00
5@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`800000o`3oool:0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0825959, -0.111296, \
0.00385924, 0.00883638}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Kdy\:017e do rovnice dosad\[IAcute]me \:0159e\[SHacek]en\[IAcute] \
dostaneme:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rovApr /. resGM\)], "Input"],

Cell[BoxData[
    \(\(-11.320754716981135`\) \[Equal] 
      0.6000000000000001`\ \((\(-20\) + 
            5.6603773584905674`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell["\<\
Spln\:011bn\[IAcute] t\[EAcute]to rovnice nejl\[EAcute]pe uvid\[IAcute]me na \
residuu:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Residuum /. resGM\)], "Input"],

Cell[BoxData[
    \(\(\(11.320754716981135`\)\(\[InvisibleSpace]\)\) + 
      0.6000000000000001`\ \((\(-20\) + 
            5.6603773584905674`\ \((1 - x)\)\ x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[Residuum /. resGM], {x, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.485599 0.693245 [
[.21429 .4731 -9 -9 ]
[.21429 .4731 9 0 ]
[.40476 .4731 -9 -9 ]
[.40476 .4731 9 0 ]
[.59524 .4731 -9 -9 ]
[.59524 .4731 9 0 ]
[.78571 .4731 -9 -9 ]
[.78571 .4731 9 0 ]
[.97619 .4731 -3 -9 ]
[.97619 .4731 3 0 ]
[.01131 .06965 -24 -4.5 ]
[.01131 .06965 0 4.5 ]
[.01131 .2083 -24 -4.5 ]
[.01131 .2083 0 4.5 ]
[.01131 .34695 -24 -4.5 ]
[.01131 .34695 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .4856 m
.21429 .49185 L
s
[(0.2)] .21429 .4731 0 1 Mshowa
.40476 .4856 m
.40476 .49185 L
s
[(0.4)] .40476 .4731 0 1 Mshowa
.59524 .4856 m
.59524 .49185 L
s
[(0.6)] .59524 .4731 0 1 Mshowa
.78571 .4856 m
.78571 .49185 L
s
[(0.8)] .78571 .4731 0 1 Mshowa
.97619 .4856 m
.97619 .49185 L
s
[(1)] .97619 .4731 0 1 Mshowa
.125 Mabswid
.07143 .4856 m
.07143 .48935 L
s
.11905 .4856 m
.11905 .48935 L
s
.16667 .4856 m
.16667 .48935 L
s
.2619 .4856 m
.2619 .48935 L
s
.30952 .4856 m
.30952 .48935 L
s
.35714 .4856 m
.35714 .48935 L
s
.45238 .4856 m
.45238 .48935 L
s
.5 .4856 m
.5 .48935 L
s
.54762 .4856 m
.54762 .48935 L
s
.64286 .4856 m
.64286 .48935 L
s
.69048 .4856 m
.69048 .48935 L
s
.7381 .4856 m
.7381 .48935 L
s
.83333 .4856 m
.83333 .48935 L
s
.88095 .4856 m
.88095 .48935 L
s
.92857 .4856 m
.92857 .48935 L
s
.25 Mabswid
0 .4856 m
1 .4856 L
s
.02381 .06965 m
.03006 .06965 L
s
[(-0.6)] .01131 .06965 1 0 Mshowa
.02381 .2083 m
.03006 .2083 L
s
[(-0.4)] .01131 .2083 1 0 Mshowa
.02381 .34695 m
.03006 .34695 L
s
[(-0.2)] .01131 .34695 1 0 Mshowa
.125 Mabswid
.02381 .10431 m
.02756 .10431 L
s
.02381 .13898 m
.02756 .13898 L
s
.02381 .17364 m
.02756 .17364 L
s
.02381 .24296 m
.02756 .24296 L
s
.02381 .27763 m
.02756 .27763 L
s
.02381 .31229 m
.02756 .31229 L
s
.02381 .38161 m
.02756 .38161 L
s
.02381 .41627 m
.02756 .41627 L
s
.02381 .45094 m
.02756 .45094 L
s
.02381 .52026 m
.02756 .52026 L
s
.02381 .55492 m
.02756 .55492 L
s
.02381 .58959 m
.02756 .58959 L
s
.02381 .03499 m
.02756 .03499 L
s
.02381 .00033 m
.02756 .00033 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool200000?l0oooo103oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`00
6`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3o
ool001/0oooo00<000000?ooo`3oool0nP3oool00`000000oooo0?ooo`050?ooo`006`3oool00`00
0000oooo0?ooo`3j0?ooo`030000003oool0oooo00D0oooo000K0?ooo`800000nP3oool00`000000
oooo0?ooo`060?ooo`006`3oool200000?X0oooo00<000000?ooo`3oool01P3oool001/0oooo00<0
00000?ooo`000000n03oool00`000000oooo0?ooo`070?ooo`006`3oool300000?P0oooo00<00000
0?ooo`3oool01`3oool001/0oooo00<000000?ooo`000000m`3oool00`000000oooo0?ooo`080?oo
o`006`3oool010000000oooo0?ooo`00003f0?ooo`030000003oool0oooo00P0oooo000K0?ooo`04
0000003oool0oooo00000?H0oooo00<000000?ooo`3oool0203oool001/0oooo00D000000?ooo`3o
ool0oooo0000003d0?ooo`030000003oool0oooo00T0oooo000K0?ooo`050000003oool0oooo0?oo
o`000000m03oool00`000000oooo0?ooo`090?ooo`006`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0?00oooo00<000000?ooo`3oool02P3oool000P0oooo0P0000040?ooo`800000
0`3oool3000000D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3`0?ooo`030000
003oool0oooo00X0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?00oooo00<000000?ooo`3o
ool02P3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?oo
o`800000103oool00`000000oooo0?ooo`3^0?ooo`030000003oool0oooo00/0oooo00000`3oool0
00000000000200000080oooo00@000000?ooo`3oool00000203oool3000000D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3^0?ooo`030000003oool0oooo00/0oooo00070?ooo`04
0000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0>`0oooo00<000000?ooo`3oool0303oool000P0oooo0P00000:0?ooo`<0
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0>`0oooo00<000000?ooo`3o
ool0303oool001/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3[0?ooo`030000
003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0jP3o
ool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0>X0oooo00<000000?ooo`3oool03@3oool001/0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`3X0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0j03oool00`000000oooo0?ooo`0>0?ooo`006`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool03`3oool001/0oooo0P00
00080?ooo`030000003oool0oooo0>H0oooo00<000000?ooo`3oool03`3oool001/0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`3V0?ooo`030000003oool0oooo00l0oooo000K0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0i03oool00`000000oooo0?ooo`0@0?oo
o`006`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0>@0oooo00<000000?ooo`3o
ool0403oool001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3R0?ooo`030000
003oool0oooo0140oooo000K0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0hP3o
ool00`000000oooo0?ooo`0A0?ooo`006`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0>00oooo00<000000?ooo`3oool04P3oool001/0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`3P0?ooo`030000003oool0oooo0180oooo000K0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0gP3oool00`000000oooo0?ooo`0C0?ooo`006`3oool2000000`0oooo
00<000000?ooo`3oool0gP3oool00`000000oooo0?ooo`0C0?ooo`006`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3oool0503oool001/0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`3L0?ooo`030000003oool0oooo01@0oooo000K0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`0E0?oo
o`006`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0=X0oooo00<000000?ooo`3o
ool05@3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3I0?ooo`030000
003oool0oooo01H0oooo000K0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0f03o
ool00`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo0=L0oooo00<000000?ooo`3oool05`3oool001/0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`3F0?ooo`030000003oool0oooo01L0oooo000K0?ooo`800000403oool00`000000
oooo0?ooo`3E0?ooo`030000003oool0oooo01P0oooo000K0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`0H0?ooo`006`3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0=<0oooo00<000000?ooo`3oool06@3oool001/0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`3B0?ooo`030000003oool0oooo01T0oooo000K0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0d@3oool00`000000oooo0?ooo`0J0?oo
o`006`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3o
ool06P3oool001/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3@0?ooo`030000
003oool0oooo01X0oooo00080?ooo`800000103oool2000000D0oooo0`0000030?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0cP3oool00`000000oooo0?ooo`0K0?ooo`001`3oool0
10000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`3>0?ooo`030000003oool0oooo01/0oooo00070?ooo`040000003oool0
oooo000000P0oooo1@0000030?ooo`8000005@3oool00`000000oooo0?ooo`3<0?ooo`030000003o
ool0oooo01`0oooo00000`3oool000000000000200000080oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
c03oool00`000000oooo0?ooo`0L0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0000000@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3:0?ooo`030000
003oool0oooo01d0oooo00080?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo01d0oooo000K0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`0N0?ooo`006`3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool07P3oool001/0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo01l0
oooo000K0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0aP3oool00`000000oooo
0?ooo`0O0?ooo`006`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0<@0oooo00<0
00000?ooo`3oool0803oool001/0oooo0P00000I0?ooo`030000003oool0oooo0<@0oooo00<00000
0?ooo`3oool0803oool001/0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`320?oo
o`030000003oool0oooo0240oooo000K0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0`P3oool00`000000oooo0?ooo`0Q0?ooo`006`3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo0<00oooo00<000000?ooo`3oool08P3oool001/0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`300?ooo`030000003oool0oooo0280oooo000K0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?ooo`0S0?ooo`006`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool08`3oool001/0
oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo02@0
oooo000K0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0_03oool00`000000oooo
0?ooo`0T0?ooo`006`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0;X0oooo00<0
00000?ooo`3oool09@3oool001/0oooo0P00000O0?ooo`030000003oool0oooo0;T0oooo00<00000
0?ooo`3oool09@3oool001/0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2h0?oo
o`030000003oool0oooo02H0oooo000K0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0]`3oool00`000000oooo0?ooo`0V0?ooo`006`3oool00`000000oooo0?ooo`0O0?ooo`030000
003oool0oooo0;H0oooo00<000000?ooo`3oool09`3oool001/0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo02P0oooo000K0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0]03oool00`000000oooo0?ooo`0X0?ooo`006`3oool00`00
0000oooo0?ooo`0Q0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool0:@3oool001/0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo02X0
oooo000K0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0/03oool00`000000oooo
0?ooo`0Z0?ooo`006`3oool2000002@0oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?oo
o`0[0?ooo`006`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0:h0oooo00<00000
0?ooo`3oool0:`3oool001/0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`2/0?oo
o`030000003oool0oooo02`0oooo000K0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0Z`3oool00`000000oooo0?ooo`0]0?ooo`006`3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo0:X0oooo00<000000?ooo`3oool0;@3oool001/0oooo00<000000?ooo`3oool09@3o
ool00`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo02h0oooo000K0?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool0Z03oool00`000000oooo0?ooo`0^0?ooo`00203oool20000
00@0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
0:L0oooo00<000000?ooo`3oool0;`3oool000L0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0Y@3oool00`00
0000oooo0?ooo`0`0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo
00@0oooo0P00000Y0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0<03oool00003
0?ooo`0000000000008000000P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`2S0?ooo`030000003oool0oooo
0340oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0<P3oool0
00P0oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
0:00oooo00<000000?ooo`3oool0<P3oool001/0oooo00<000000?ooo`3oool0:P3oool00`000000
oooo0?ooo`2O0?ooo`030000003oool0oooo03<0oooo000K0?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`0c0?ooo`006`3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo09`0oooo00<000000?ooo`3oool0=03oool001/0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo03D0oooo000K0?oo
o`030000003oool0oooo02d0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`0e0?oo
o`006`3oool2000002l0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`0f0?ooo`00
6`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0
=`3oool001/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`2F0?ooo`030000003o
ool0oooo03L0oooo000K0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0U03oool0
0`000000oooo0?ooo`0h0?ooo`006`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
09<0oooo00<000000?ooo`3oool0>03oool001/0oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`2B0?ooo`030000003oool0oooo03T0oooo000K0?ooo`030000003oool0oooo0380oooo
00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?oo
o`0c0?ooo`030000003oool0oooo08l0oooo00<000000?ooo`3oool0>P3oool001/0oooo00<00000
0?ooo`3oool0<`3oool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo03/0oooo000K0?oo
o`030000003oool0oooo03@0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0l0?oo
o`006`3oool2000003H0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`0m0?ooo`00
6`3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool0
?@3oool001/0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`280?ooo`030000003o
ool0oooo03h0oooo000K0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0QP3oool0
0`000000oooo0?ooo`0o0?ooo`006`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo
08@0oooo00<000000?ooo`3oool0@03oool001/0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`240?ooo`030000003oool0oooo0400oooo000K0?ooo`030000003oool0oooo03T0oooo
00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`110?ooo`006`3oool00`000000oooo0?oo
o`0X0?ooo`800000103oool2000000<0oooo100000030?ooo`030000003oool0oooo01h0oooo0P00
00040?ooo`8000001@3oool3000002<0oooo0P0000040?ooo`8000000`3oool300000240oooo00<0
00000?ooo`3oool00P0000040?ooo`800000103oool2000002X0oooo1@0000050?ooo`006`3oool0
0`000000oooo0?ooo`0W0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0L0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0
8@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000001l0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000002/0oooo00<0
00000?ooo`3oool01@3oool001/0oooo0P00000X0?ooo`040000003oool0oooo000000T0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0L0?ooo`040000003oool0oooo000000P0oooo
1@00000R0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000007`3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool00000:`3o
ool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`040000003oool0
oooo000000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000008`3oool010000000oooo0?ooo`0000080?oo
o`<000007`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01`3oool2
000002`0oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool09`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool06P3o
ool010000000oooo0?ooo`0000090?ooo`030000003oool0000002<0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`00000[0?ooo`030000003oool0oooo00D0oooo000K0?oo
o`030000003oool0oooo02P0oooo0P00000:0?ooo`800000203oool00`000000oooo0?ooo`0J0?oo
o`8000002`3oool2000002@0oooo0P00000:0?ooo`<00000703oool00`000000oooo0?ooo`040?oo
o`8000002P3oool2000002/0oooo0P0000070?ooo`006`3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo07H0oooo00<000000?ooo`3oool0A`3oool001/0oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo04L0oooo000K0?ooo`030000003o
ool0oooo0400oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`180?ooo`006`3oool0
0`000000oooo0?ooo`110?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0B@3oool0
01/0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo
04X0oooo000D0?ooool000003@00000001/0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00D0oooo000K
0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`1=
0?ooo`006`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo06P0oooo00<000000?oo
o`3oool0CP3oool001/0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`1V0?ooo`03
0000003oool0oooo04l0oooo000K0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`1@0?ooo`006`3oool00`000000oooo0?ooo`190?ooo`800000H`3o
ool00`000000oooo0?ooo`1A0?ooo`006`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0
oooo05l0oooo00<000000?ooo`3oool0DP3oool001/0oooo0P00001=0?ooo`030000003oool0oooo
05`0oooo0P00001E0?ooo`006`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo05X0
oooo00<000000?ooo`3oool0E@3oool001/0oooo00<000000?ooo`3oool0CP3oool00`000000oooo
0?ooo`1H0?ooo`030000003oool0oooo05H0oooo000K0?ooo`030000003oool0oooo04l0oooo0P00
001G0?ooo`030000003oool0oooo05L0oooo000K0?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool0D`3oool00`000000oooo0?ooo`1H0?ooo`006`3oool00`000000oooo0?ooo`1B0?oo
o`030000003oool0oooo0540oooo00<000000?ooo`3oool0F@3oool001/0oooo00<000000?ooo`3o
ool0D`3oool00`000000oooo0?ooo`1>0?ooo`800000G03oool001/0oooo00<000000?ooo`3oool0
E03oool2000004d0oooo00<000000?ooo`3oool0G03oool001/0oooo00<000000?ooo`3oool0EP3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo05d0oooo000K0?ooo`800000F03oool0
0`000000oooo0?ooo`160?ooo`800000H03oool001/0oooo00<000000?ooo`3oool0F03oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo0600oooo000K0?ooo`030000003oool0oooo05T0
oooo0P0000120?ooo`800000H`3oool001/0oooo00<000000?ooo`3oool0F`3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo06<0oooo000K0?ooo`030000003oool0oooo05`0oooo00<0
00000?ooo`3oool0>`3oool2000006H0oooo000K0?ooo`030000003oool0oooo05d0oooo0P00000i
0?ooo`800000J03oool001/0oooo00<000000?ooo`3oool0G`3oool2000003D0oooo0P00001Z0?oo
o`006`3oool00`000000oooo0?ooo`1Q0?ooo`800000<@3oool2000006`0oooo000K0?ooo`030000
003oool0oooo06<0oooo0`00000/0?ooo`800000KP3oool001/0oooo00<000000?ooo`3oool0IP3o
ool3000002L0oooo0P00001`0?ooo`006`3oool2000006X0oooo0P00000S0?ooo`800000LP3oool0
01/0oooo00<000000?ooo`3oool0J`3oool3000001d0oooo0`00001d0?ooo`006`3oool00`000000
oooo0?ooo`1^0?ooo`@000004`3oool6000007L0oooo000K0?ooo`030000003oool0oooo0780oooo
4`00001m0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0
oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000
oooo0?ooo`3o0?ooo`<0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.734468, \
0.00394728, 0.00542278}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
Pozn.1: Aplikac\[IAcute] t\[EAcute]to metody na  speci\[AAcute]ln\[IAcute] \
volbu tvaru \:0159e\[SHacek]en\[IAcute], dostaneme metodu kone\[CHacek]\
\[YAcute]ch element\:016f (op\:011bt velmi zhruba \:0159e\[CHacek]eno, metoda \
kone\[CHacek]n\[YAcute]ch element\:016f je sp\[IAcute]\[SHacek]e naopak: \
metodou volby tvaru \:0159e\[SHacek]en\[IAcute] pro galerkina (nebo pro \
Reil-Ritzovu metodu, co\:017e je metoda zalo\:017een\[AAcute] ne na metod\
\:011b v\[AAcute]hov\[YAcute]ch residu\[IAcute], ale na minimalizaci ur\
\[CHacek]it\[EAcute]ho speci\[AAcute]ln\[IAcute]ho funkcion\[AAcute]lu)\
\>", "Text"],

Cell["\<\
Pozn.2: Tato metoda dosad\[IAcute] za v\[AAcute]hov\[EAcute] funkci derivace \
navrhovan\[EAcute]ho \:0159e\[SHacek]en\[IAcute] podle jednotliv\[YAcute]ch \
koeficient\:016f. Ka\:017ed\[AAcute] rovnice se tedy bude sna\:017eit dostat \
\:0159e\[SHacek]en\[IAcute], kter\[EAcute] je nejp\:0159esn\:011bj\[SHacek]\
\[IAcute] v m\[IAcute]stech, kde je citlivost \:0159e\[SHacek]en\[IAcute] na \
dan\[YAcute] koeficient nejvy\[SHacek]\[SHacek]\[IAcute]. (op\:011bt velmi \
zjednodu\[SHacek]eno)\
\>", "Text"],

Cell["\<\
Pozn.3: Galerkinova metoda d\[AAcute]v\[AAcute] obvykle l\[EAcute]pe podm\
\[IAcute]n\:011bn\[EAcute] soustavy rovnic, ne\:017e metoda nejmen\[SHacek]\
\[IAcute]ch \[CHacek]tverc\:016f. (pravd\:011bpodobn\:011b souvis\[IAcute] s \
pozn.2:)\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Slab\[AAcute] formulace (weak formulation) ", "Section"],

Cell["\<\
Laicky \:0159e\[CHacek]eno: Je to metoda zbaven\[IAcute] se druh\[YAcute]ch \
derivac\[IAcute] v rovnici (tedy v residuu).  Pou\:017eije semetoda per \
partes (ve 2D a 3D jej\[IAcute] analogii: Green-Gaussovu v\:011btu)\
\>", "Text"],

Cell["\<\
Aplikuje se je\[SHacek]t\:011b p\:0159ed pou\:017eit\[IAcute]m n\:011bkter\
\[EAcute] z t\:0159\[IAcute] v\[YAcute]\[SHacek]e uveden\[YAcute]ch metod\
\>", "Text"],

Cell["\<\
Nejd\:0159\[IAcute]ve si nap\[IAcute]\[SHacek]eme a dosad\[IAcute]me do \
metody v\[AAcute]hov\[YAcute]ch residu\[IAcute] na\[SHacek]\[IAcute] konkr\
\[EAcute]tn\[IAcute] rovnici, (je\[SHacek]t\:011b p\:0159ed t\[IAcute]m, ne\
\:017e dosad\[IAcute]me n\[AAcute]mi navrhovan\[YAcute] tvar  \
\:0159e\[SHacek]en\[IAcute]). \
\>", "Text"],

Cell["\<\
Residuum tedy v na\[SHacek]em p\:0159\[IAcute]pad\:011b bude:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResiduumGen = 
      rov /. Equal[Left_, Right_] \[Rule] \(-Left\) + Right\)], "Input"],

Cell[BoxData[
    RowBox[{\(0.6000000000000001`\ \((\(-20\) + T[x])\)\), "-", 
      RowBox[{
        SuperscriptBox["T", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Dostaneme rovnici, kde na prav\[EAcute] stran\:011b bude integr\[AAcute]l\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MVR = 
      0 == \[Integral]\_0\%1 w[x]*ResiduumGen \[DifferentialD]x\)], "Input"],

Cell[BoxData[
    RowBox[{"0", "\[Equal]", 
      RowBox[{\(\[Integral]\_0\%1\), 
        RowBox[{
          RowBox[{\(w[x]\), " ", 
            RowBox[{"(", 
              RowBox[{\(0.6000000000000001`\ \((\(-20\) + T[x])\)\), "-", 
                RowBox[{
                  SuperscriptBox["T", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], 
              ")"}]}], \(\[DifferentialD]x\)}]}]}]], "Output"]
}, Open  ]],

Cell["Jen si to trochu rozn\[AAcute]sob\[IAcute]me:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MVR2 = 
      MVR /. \[Integral]\_b_\%a_ c_\ \[DifferentialD]x \[RuleDelayed] 
          Distribute[\[Integral]\_b\%a Expand[
                  c]\ \[DifferentialD]x]\)], "Input"],

Cell[BoxData[
    RowBox[{"0", "\[Equal]", 
      RowBox[{\(\[Integral]\_0\%1\(\(-12.000000000000002`\)\ w[
                x]\) \[DifferentialD]x\), 
        "+", \(\[Integral]\_0\%1\( 
              0.6000000000000001`\ T[x]\ w[x]\) \[DifferentialD]x\), "+", 
        RowBox[{\(\[Integral]\_0\%1\), 
          RowBox[{
            RowBox[{\(-w[x]\), " ", 
              RowBox[{
                SuperscriptBox["T", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", 
                "]"}]}], \(\[DifferentialD]x\)}]}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
A na \[CHacek]leny kde se vyskytuje druh\[AAcute] derivace T pou\:017eijeme \
per partes:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WF = 
      MVR2 /. \[Integral]\_b_\%a_ Times[c___?NumericQ, 
                w[x], \(\(Derivative[2]\)[T_]\)[
                  x]]\ \[DifferentialD]x \[RuleDelayed] \[Integral]\_b\%a 
                  Times[\(-c\), \(\(Derivative[1]\)[w]\)[
                    x], \(\(Derivative[1]\)[T]\)[x]]\ \[DifferentialD]x + 
            c*w[a]*\(\(Derivative[1]\)[T]\)[a] - 
            c*w[b]*\(\(Derivative[1]\)[T]\)[b]\)], "Input"],

Cell[BoxData[
    RowBox[{"0", "\[Equal]", 
      RowBox[{\(\[Integral]\_0\%1\(\(-12.000000000000002`\)\ w[
                x]\) \[DifferentialD]x\), 
        "+", \(\[Integral]\_0\%1\( 
              0.6000000000000001`\ T[x]\ w[x]\) \[DifferentialD]x\), "+", 
        RowBox[{\(\[Integral]\_0\%1\), 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["T", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], " ", 
              RowBox[{
                SuperscriptBox["w", "\[Prime]",
                  MultilineFunction->None], "[", "x", 
                "]"}]}], \(\[DifferentialD]x\)}]}], "+", 
        RowBox[{\(w[0]\), " ", 
          RowBox[{
            SuperscriptBox["T", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}]}], "-", 
        RowBox[{\(w[1]\), " ", 
          RowBox[{
            SuperscriptBox["T", "\[Prime]",
              MultilineFunction->None], "[", "1", "]"}]}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Nyn\[IAcute] jen \[UAcute]lohu p\:0159eformulujeme takto: hled\[AAcute]me \
\:0159e\[SHacek]en\[IAcute], kter\[EAcute] pro \"v\[SHacek]echny mo\:017en\
\[EAcute]\" testovac\[IAcute] funkce spl\:0148uje v\[YAcute]\[SHacek]e \
uvedenou rovnici plus nav\[IAcute]c okrajov\[EAcute] podm\[IAcute]nky. T\
\[IAcute]m jsme dostali to, \[CHacek]emu se \:0159\[IAcute]k\[AAcute] slab\
\[AAcute] formulace \[UAcute]lohy.\
\>", "Text"],

Cell["\<\
Pozn.1: P\:016fvodn\[IAcute] formulaci pomoc\[IAcute] p\:016fvodn\[IAcute] \
diferenci\[AAcute]ln\[IAcute] rovnice se logicky \:0159\[IAcute]k\[AAcute] \
siln\[AAcute] formulace\
\>", "Text"],

Cell["\<\
Pozn.2: Lze dok\[AAcute]zat, \:017ee je-li \:0159e\[SHacek]en\[IAcute] \
\:0159e\[SHacek]en\[IAcute]m siln\[EAcute] formulace, je \:0159e\[SHacek]en\
\[IAcute]m i slab\[EAcute] formulace. S opa\[CHacek]n\[YAcute]m sm\:011brem \
je to trochu slo\:017eit\:011bj\[SHacek]\[IAcute]. Existuje na to docela slo\
\:017eit\[AAcute] matematick\[AAcute] teorie, kter\[AAcute] ukazuje, \:017ee \
slab\[EAcute] \:0159e\[SHacek]en\[IAcute] je v jak\[EAcute]msi smyslu limitou \
siln\[YAcute]ch \:0159e\[SHacek]en\[IAcute].\
\>", "Text"],

Cell["\<\
Pozn.3: Sice se m\:016f\:017ee zd\[AAcute]t, \:017ee jsme p\:0159eformulov\
\[AAcute]n\[IAcute]m nic v\[YAcute]znamn\[EAcute]ho neud\:011blali. Je to ale \
dosti v\[YAcute]znamn\[YAcute] krok. Mimo jin\[EAcute] n\[AAcute]m umo\:017en\
\[IAcute] pou\:017e\[IAcute]t v metod\:011b kon. prvk\:016f line\[AAcute]rn\
\[IAcute] elementy, kter\[EAcute] maj\[IAcute] nulovou druhou derivaci a p\
\:0159i zp\:011btn\[EAcute]m dosazen\[IAcute] \:0159e\[SHacek]en\[IAcute] do \
p\:016fvodn\[IAcute] dif. rovnice by n\[AAcute]m \[CHacek]len stouto derivac\
\[IAcute] \[UAcute]pln\:011b vypadl. Slab\[EAcute] \
\:0159e\[SHacek]en\[IAcute] pomoc\[IAcute] lin element\:016f je ale jak\
\[YAcute]msi limitn\[IAcute]m p\:0159ibl\[IAcute]\:017een\[IAcute]m \:0159e\
\[SHacek]en\[IAcute] na\[SHacek]eho tvaru k \:0159e\[SHacek]en\[IAcute] obecn\
\[EAcute]mu i p\:0159i uva\:017eov\[AAcute]n\[IAcute] vlivu druh\[YAcute]ch \
derivac\[IAcute]. Nav\[IAcute]c n\[AAcute]m slab\[AAcute] formulace \
nap\:0159. umo\:017e\:0148uje zahrnout do modelu bodov\[EAcute] zdroje.\
\>", "Text"],

Cell["\<\
Pozn.4: Metodu v\[AAcute]hov\[YAcute]ch residu\[IAcute] dostaneme ze slab\
\[EAcute] formulace pouye t\[IAcute]m, \:017ee hled\[AAcute]me \:0159e\
\[SHacek]en\[IAcute] v n\[AAcute]mi zvolen\[EAcute]m tvaru (samoz\:0159ejm\
\:011b kone\[CHacek]n\:011b parametrizovateln\[EAcute]m) a spln\:011bn\
\[IAcute] uveden\[EAcute] integr\[AAcute]ln\[IAcute] rovnice \:017e\[AAcute]d\
\[AAcute]me pouze pro kone\[CHacek]n\[YAcute] po\[CHacek]et v\[AAcute]hov\
\[YAcute]ch funkc\[IAcute] w[x].\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Metoda kone\[CHacek]n\[YAcute]ch prvk\:016f MKP (Finite elements method \
FEM)\
\>", "Section"],

Cell[CellGroupData[{

Cell["Tvorba hledan\[EAcute]ho tvaru \:0159e\[SHacek]en\[IAcute]", \
"Subsection"],

Cell["\<\
Jedn\[IAcute]m z hlavn\[IAcute]ch prvk\[UAcute] metody \
kone\[CHacek]n\[YAcute]ch element\:016f je zp\:016fsob, jak\[YAcute]m se pro \
r\:016fzn\[EAcute] geometrie generuje tvar hledan\[EAcute]ho \
\:0159e\[SHacek]en\[IAcute]:\
\>", "Text"],

Cell["\<\
Nejd\:0159\[IAcute]ve se po\[CHacek]\[IAcute]tan\[AAcute] oblast rozd\:011bl\
\[IAcute] na men\[SHacek]\[IAcute] podoblasti ur\[CHacek]en\[EAcute]ho tvaru \
- tzv. elementy  (v 1D jsou to \[UAcute]se\[CHacek]ky, ve 2D obvykle troj\
\[UAcute]heln\[IAcute]ky, nebo m\[EAcute]n\:011b obvykle obd\[EAcute]ln\
\[IAcute]ky, ve 3D tetrahedrony nebo kv\[AAcute]dry). Pro ka\:017ed\[YAcute] \
element se podle jeho typu (nap\:0159. Lagrangeuv line\[AAcute]rn\[IAcute], \
kvadratick\[YAcute] atd., kde to linearn\[IAcute] je ve skute\[CHacek]nosti \
typ funkce, kterou aproximujeme \:0159e\[SHacek]en\[IAcute] a Lagrange\:016fv \
je zp\:016fsob jak\[YAcute]m to na dan\[EAcute]m elementu d\:011bl\[AAcute]me \
(tedy ehm. zase zjednodu\[SHacek]en\:011b \:0159e\[CHacek]eno, \:017ee?) ), \
tak\:017ee znovu: pro ka\:017ed\[YAcute] element se podle jeho typu ur\
\[CHacek]\[IAcute] ur\[CHacek]it\[YAcute] po\[CHacek]et bod\:016f - tzv. n\
\[OAcute]d\:016f, nebo t\[EAcute]\:017e Gausov\[YAcute]ch bod\:016f. \
V\:017edy to jsou vrcholy dan\[EAcute]ho elementu (v 2D nap\:0159. vrcholy \
troj\[UAcute]heln\[IAcute]ka, v 1D samoz\:0159ejm\:011b krajn\[IAcute] body) \
plus u elementu vy\[SHacek]\[SHacek]\[IAcute]ch \:0159\[AAcute]d\:016f (ne \
line\[AAcute]rn\[IAcute]ch) nav\[IAcute]c nap\:0159 st\:0159edy hran nebo st\
\:0159ed elementu atd. 
Takto rozd\:011blen\[EAcute] celkov\[EAcute] oblasti na elementy s \
n\[OAcute]dy se \:0159\[IAcute]k\[AAcute] s\[IAcute]\:0165 (mesh).\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Galerkinova formulace", "Subsection"],

Cell["\<\
Postup: 
-nejd\:0159\[IAcute]ve p\:0159evedeme formulaci \[UAcute]lohy na slabou \
formulaci
-dosad\[IAcute]me hledan\[YAcute] tvar \:0159e\[SHacek]en\[IAcute] (metoda v\
\[AAcute]hov\[YAcute]ch residu\[IAcute]) dan\[YAcute] metodou kone\[CHacek]n\
\[YAcute]ch prvk\:016f
-dosad\[IAcute]me tvary v\[AAcute]hov\[YAcute]ch funkc\[IAcute] podle \
Galerkinovy metody (t\[IAcute]m dostaneme pot\:0159ebn\[YAcute] po\[CHacek]et \
rovnic)
-vy\:0159e\[SHacek]\[IAcute]me vzniklou soustavu rovnic (\:0159e\[SHacek]en\
\[IAcute]m jsou koeficienty na\[SHacek]eho tvaru \:0159e\[SHacek]en\[IAcute])\
\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 693}},
WindowSize->{784, 565},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 132, 6, 90, "Text"],

Cell[CellGroupData[{
Cell[1911, 61, 161, 5, 89, "Section"],
Cell[2075, 68, 150, 3, 33, "Text"],
Cell[2228, 73, 52, 0, 33, "Text"],
Cell[2283, 75, 113, 2, 30, "Input"],
Cell[2399, 79, 80, 1, 30, "Input"],
Cell[2482, 82, 361, 6, 52, "Text"],
Cell[2846, 90, 63, 2, 33, "Text"],
Cell[2912, 94, 62, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2999, 99, 83, 1, 30, "Input"],
Cell[3085, 102, 66187, 2201, 186, 26397, 1705, "GraphicsData", "PostScript", \
"Graphics"],
Cell[69275, 2305, 130, 3, 29, "Output"]
}, Open  ]],
Cell[69420, 2311, 54, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[69499, 2315, 129, 3, 30, "Input"],
Cell[69631, 2320, 114, 2, 29, "Output"]
}, Open  ]],
Cell[69760, 2325, 69, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[69854, 2331, 107, 2, 30, "Input"],
Cell[69964, 2335, 102, 2, 29, "Output"]
}, Open  ]],
Cell[70081, 2340, 96, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[70202, 2346, 87, 1, 30, "Input"],
Cell[70292, 2349, 23380, 943, 186, 12120, 799, "GraphicsData", "PostScript", \
"Graphics"],
Cell[93675, 3294, 130, 3, 29, "Output"]
}, Open  ]],
Cell[93820, 3300, 181, 4, 33, "Text"],
Cell[94004, 3306, 270, 5, 52, "Text"],
Cell[94277, 3313, 586, 11, 109, "Text"],

Cell[CellGroupData[{
Cell[94888, 3328, 43, 1, 30, "Input"],
Cell[94934, 3331, 132, 3, 29, "Output"]
}, Open  ]],
Cell[95081, 3337, 104, 2, 42, "Input"],
Cell[95188, 3341, 420, 7, 52, "Text"],
Cell[95611, 3350, 371, 6, 52, "Text"],
Cell[95985, 3358, 869, 14, 109, "Text"],
Cell[96857, 3374, 319, 5, 52, "Text"],

Cell[CellGroupData[{
Cell[97201, 3383, 40, 0, 38, "Subsection"],
Cell[97244, 3385, 48, 0, 33, "Text"],
Cell[97295, 3387, 288, 5, 52, "Text"],

Cell[CellGroupData[{
Cell[97608, 3396, 127, 3, 42, "Input"],
Cell[97738, 3401, 103, 2, 29, "Output"]
}, Open  ]],
Cell[97856, 3406, 112, 3, 33, "Text"],
Cell[97971, 3411, 53, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[98049, 3415, 110, 2, 30, "Input"],
Cell[98162, 3419, 65, 1, 29, "Output"]
}, Open  ]],
Cell[98242, 3423, 156, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[98423, 3430, 46, 1, 30, "Input"],
Cell[98472, 3433, 69, 1, 29, "Output"]
}, Open  ]],
Cell[98556, 3437, 140, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[98721, 3444, 73, 1, 30, "Input"],
Cell[98797, 3447, 22250, 514, 186, 4192, 287, "GraphicsData", "PostScript", \
"Graphics"],
Cell[121050, 3963, 130, 3, 29, "Output"]
}, Open  ]],
Cell[121195, 3969, 102, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[121322, 3976, 48, 1, 30, "Input"],
Cell[121373, 3979, 160, 3, 29, "Output"]
}, Open  ]],
Cell[121548, 3985, 111, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[121684, 3992, 50, 1, 30, "Input"],
Cell[121737, 3995, 177, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121951, 4003, 77, 1, 30, "Input"],
Cell[122031, 4006, 20864, 463, 186, 3581, 245, "GraphicsData", "PostScript", \
"Graphics"],
Cell[142898, 4471, 130, 3, 29, "Output"]
}, Open  ]],
Cell[143043, 4477, 192, 4, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[143272, 4486, 42, 0, 30, "Subsection"],
Cell[143317, 4488, 265, 5, 52, "Text"],

Cell[CellGroupData[{
Cell[143607, 4497, 132, 3, 42, "Input"],
Cell[143742, 4502, 92, 1, 29, "Output"]
}, Open  ]],
Cell[143849, 4506, 112, 3, 33, "Text"],
Cell[143964, 4511, 53, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[144042, 4515, 112, 2, 30, "Input"],
Cell[144157, 4519, 62, 1, 29, "Output"]
}, Open  ]],
Cell[144234, 4523, 156, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[144415, 4530, 47, 1, 30, "Input"],
Cell[144465, 4533, 66, 1, 29, "Output"]
}, Open  ]],
Cell[144546, 4537, 140, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[144711, 4544, 74, 1, 30, "Input"],
Cell[144788, 4547, 22284, 517, 186, 4226, 290, "GraphicsData", "PostScript", \
"Graphics"],
Cell[167075, 5066, 130, 3, 29, "Output"]
}, Open  ]],
Cell[167220, 5072, 102, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[167347, 5079, 49, 1, 30, "Input"],
Cell[167399, 5082, 155, 3, 29, "Output"]
}, Open  ]],
Cell[167569, 5088, 111, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[167705, 5095, 51, 1, 30, "Input"],
Cell[167759, 5098, 172, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[167968, 5106, 78, 1, 30, "Input"],
Cell[168049, 5109, 20422, 456, 186, 3490, 242, "GraphicsData", "PostScript", \
"Graphics"],
Cell[188474, 5567, 130, 3, 29, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[188653, 5576, 39, 0, 30, "Subsection"],
Cell[188695, 5578, 280, 5, 52, "Text"],

Cell[CellGroupData[{
Cell[189000, 5587, 127, 3, 42, "Input"],
Cell[189130, 5592, 93, 1, 29, "Output"]
}, Open  ]],
Cell[189238, 5596, 112, 3, 33, "Text"],
Cell[189353, 5601, 53, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[189431, 5605, 110, 2, 30, "Input"],
Cell[189544, 5609, 358, 5, 37, "Message"],
Cell[189905, 5616, 65, 1, 29, "Output"]
}, Open  ]],
Cell[189985, 5620, 156, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[190166, 5627, 46, 1, 30, "Input"],
Cell[190215, 5630, 69, 1, 29, "Output"]
}, Open  ]],
Cell[190299, 5634, 140, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[190464, 5641, 73, 1, 30, "Input"],
Cell[190540, 5644, 22283, 517, 186, 4225, 290, "GraphicsData", "PostScript", \
"Graphics"],
Cell[212826, 6163, 130, 3, 29, "Output"]
}, Open  ]],
Cell[212971, 6169, 102, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[213098, 6176, 48, 1, 30, "Input"],
Cell[213149, 6179, 160, 3, 29, "Output"]
}, Open  ]],
Cell[213324, 6185, 111, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[213460, 6192, 50, 1, 30, "Input"],
Cell[213513, 6195, 177, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[213727, 6203, 77, 1, 30, "Input"],
Cell[213807, 6206, 20520, 457, 186, 3463, 242, "GraphicsData", "PostScript", \
"Graphics"],
Cell[234330, 6665, 130, 3, 29, "Output"]
}, Open  ]],
Cell[234475, 6671, 622, 9, 71, "Text"],
Cell[235100, 6682, 514, 8, 52, "Text"],
Cell[235617, 6692, 263, 5, 52, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[235929, 6703, 62, 0, 73, "Section"],
Cell[235994, 6705, 243, 4, 52, "Text"],
Cell[236240, 6711, 173, 3, 33, "Text"],
Cell[236416, 6716, 345, 6, 52, "Text"],
Cell[236764, 6724, 85, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[236874, 6730, 107, 2, 30, "Input"],
Cell[236984, 6734, 207, 4, 29, "Output"]
}, Open  ]],
Cell[237206, 6741, 97, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[237328, 6747, 103, 2, 42, "Input"],
Cell[237434, 6751, 445, 10, 42, "Output"]
}, Open  ]],
Cell[237894, 6764, 61, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[237980, 6768, 199, 4, 44, "Input"],
Cell[238182, 6774, 558, 12, 42, "Output"]
}, Open  ]],
Cell[238755, 6789, 113, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[238893, 6796, 448, 8, 99, "Input"],
Cell[239344, 6806, 992, 23, 42, "Output"]
}, Open  ]],
Cell[240351, 6832, 433, 7, 52, "Text"],
Cell[240787, 6841, 201, 4, 33, "Text"],
Cell[240991, 6847, 533, 8, 52, "Text"],
Cell[241527, 6857, 1070, 15, 90, "Text"],
Cell[242600, 6874, 505, 8, 52, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[243142, 6887, 105, 3, 73, "Section"],

Cell[CellGroupData[{
Cell[243272, 6894, 82, 1, 38, "Subsection"],
Cell[243357, 6897, 251, 5, 33, "Text"],
Cell[243611, 6904, 1491, 21, 147, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[245139, 6930, 43, 0, 38, "Subsection"],
Cell[245185, 6932, 612, 13, 109, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

