(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9716,        268]
NotebookOptionsPosition[      8725,        247]
NotebookOutlinePosition[      9185,        264]
CellTagsIndexPosition[      9142,        261]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"15", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<dataChladnuti.csv\>\"", " ", "jsou", " ", 
    "dvojice", " ", 
    RowBox[{"{", 
     RowBox[{"cas", ",", "teplota"}], "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "predpokladate", " ", "platnost", " ", "rovnic", " ", 
    "\"\<{m*cFe*T'[t]\[Equal]-S*(\[Alpha]*(T[t]-Ta)+\[Epsilon]*\[Sigma]*((T[t]\
+273\!\(\*SuperscriptBox[\()\), \(4\)]\)-(Ta+273\!\(\*SuperscriptBox[\()\), \
\(4\)]\))),T[0]\[Equal]Tpoc}\>\""}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"vite", " ", "ze", " ", "\[Sigma]"}], "=", 
     RowBox[{"5.67", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "8"}]]}]}], ",", " ", 
    RowBox[{
    "najdete", " ", "hodnoty", " ", "\[Epsilon]", " ", "a", " ", "\[Alpha]"}],
     ",", " ", 
    RowBox[{
    "rovnice", " ", "vyreste", " ", "a", " ", "resni", " ", "zobrazte", " ", 
     "v", " ", "jednom", " ", "grafu", " ", "se", " ", "zadanymi", " ", 
     "daty"}]}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8794731763194237`*^9, 3.8794732336699133`*^9}, {
   3.879473263678887*^9, 3.879473402568264*^9}, {3.8794735737901907`*^9, 
   3.8794735797556815`*^9}, 
   3.8794736691337337`*^9},ExpressionUUID->"fc8c899d-a739-410d-b859-\
107170662377"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"\"\<m,S,cp,Tokoli\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "4.110250388446646`", ",", "0.031415926535897934`", ",", "460", ",", 
      "20"}], "}"}]}], "}"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8794732383845367`*^9, 
  3.8794732384001465`*^9}},ExpressionUUID->"85ac800d-ca27-48f9-bda6-\
104bcc6052d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<dataSignal.csv\>\"", " ", "jsou", " ", 
    "dvojice", " ", 
    RowBox[{"{", 
     RowBox[{"cas", ",", " ", "napeti"}], "}"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "urcete", " ", "frekvenci", " ", "a", " ", "zastoupeni", " ", 
      "harmonickych", " ", "vite"}], "-", "li"}], ",", " ", 
    RowBox[{
    "ze", " ", "nad", " ", "10.", " ", "uz", " ", "nic", " ", "neni"}]}], 
   "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8794062085833654`*^9, 3.879406279678856*^9}, {
   3.87947342592603*^9, 3.8794734437670097`*^9}, {3.8794735848247375`*^9, 
   3.879473593567995*^9}, 
   3.87947367799833*^9},ExpressionUUID->"a945b9ec-07f9-4f63-bd46-\
fe9cc81c16c2"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"urcete", " ", "numericky", " ", "hodnotu", " ", "integralu", " ", 
    RowBox[{"(", 
     RowBox[{
     "samotny", " ", "prikaz", " ", "solveru", " ", "se", " ", "nepocita"}], 
     ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], "]"}], 
      SqrtBox["x"]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.879406306613126*^9, 3.879406326060956*^9}, {
  3.879406407521157*^9, 3.879406573459076*^9}, {3.8794735976965933`*^9, 
  3.879473602226232*^9}, {3.8794736940474806`*^9, 
  3.8794737004288*^9}},ExpressionUUID->"c7bf1625-9ee9-4d3f-94ee-0690640bb2eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"vyreste", " ", "metodou", " ", "Runge"}], "-", 
     RowBox[{
     "Kutta", " ", "a", " ", "porovnejte", " ", "s", " ", "vnitrnim", " ", 
      "solverem"}]}], ",", " ", 
    RowBox[{"tmax", "=", "10"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{"t", "/;", 
      RowBox[{"t", "\[LessEqual]", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      FractionBox["1", "t"], "/;", 
      RowBox[{"t", ">", "1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"f", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8794066061768456`*^9, 3.8794068040109406`*^9}, {
  3.8794072784505606`*^9, 3.8794072838203025`*^9}, {3.8794736086303096`*^9, 
  3.8794736139997153`*^9}, {3.8794737105445642`*^9, 
  3.879473718670186*^9}},ExpressionUUID->"642a9f26-393a-405b-81ba-\
d383f754c583"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"20", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"vyreste", " ", "metodou", " ", "Runge"}], "-", 
     RowBox[{
     "Kutta", " ", "a", " ", "porovnejte", " ", "s", " ", "vnitrnim", " ", 
      "solverem"}]}], ",", " ", 
    RowBox[{"zobrazte", " ", "reseni", " ", "v", " ", "grafu"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], " ", "je", " ", "interpolace", " ", "dat", 
     " ", "ze", " ", "souboru", " ", "\"\<dataSignal.csv\>\""}], ",", " ", 
    RowBox[{"derivovat", " ", "f", " ", "je", " ", "zakazano"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"f", "[", "t", "]"}], "+", 
         RowBox[{"0.5", "*", 
          RowBox[{
           RowBox[{"f", "'"}], "[", "t", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
        RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8794073069228616`*^9, 3.879407381415332*^9}, {
  3.8794736182127094`*^9, 3.879473625713418*^9}, {3.879473727064945*^9, 
  3.8794737760950346`*^9}},ExpressionUUID->"f31f39b3-9980-4cf7-8189-\
8760a0e6dbd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "v", " ", "souboru", " ", "\"\<body.csv\>\"", " ", "jsou", " ", "trojice",
      " ", "souradnic", " ", "bodu", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ".", " ", "Najdete"}], " ", 
     "souradnice", " ", "stredu", " ", "a", " ", "polomer", " ", "nejmensi", 
     " ", "koule"}], ",", " ", 
    RowBox[{
    "ktera", " ", "tyto", " ", "body", " ", "obsahuje", " ", "a", " ", 
     "zobrazte", " ", "vysledek", " ", "jako", " ", "na", " ", "obrazku", 
     " ", "\"\<koule.png\>\""}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.879473469309016*^9, 3.8794735589063635`*^9}, {
  3.879473629362706*^9, 
  3.879473633591852*^9}},ExpressionUUID->"3219db9f-a4b5-41d4-977e-\
e8a9c4c2fe75"]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5000001192092896`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1430, 34, 218, "Input",ExpressionUUID->"fc8c899d-a739-410d-b859-107170662377"],
Cell[1991, 56, 383, 10, 73, InheritFromParent,ExpressionUUID->"85ac800d-ca27-48f9-bda6-104bcc6052d0"],
Cell[2377, 68, 904, 24, 131, "Input",ExpressionUUID->"a945b9ec-07f9-4f63-bd46-fe9cc81c16c2"],
Cell[3284, 94, 983, 24, 196, "Input",ExpressionUUID->"c7bf1625-9ee9-4d3f-94ee-0690640bb2eb"],
Cell[4270, 120, 1835, 52, 287, "Input",ExpressionUUID->"642a9f26-393a-405b-81ba-d383f754c583"],
Cell[6108, 174, 1729, 48, 189, "Input",ExpressionUUID->"f31f39b3-9980-4cf7-8189-8760a0e6dbd4"],
Cell[7840, 224, 881, 21, 131, "Input",ExpressionUUID->"3219db9f-a4b5-41d4-977e-e8a9c4c2fe75"]
}
]
*)

