(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9242,        308]
NotebookOptionsPosition[      8251,        270]
NotebookOutlinePosition[      8714,        288]
CellTagsIndexPosition[      8671,        285]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "t_", "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", 
     RowBox[{"Exp", "[", 
      FractionBox[
       RowBox[{"-", "t"}], "\[Tau]"], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0.0", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"vyr", "[", "t", "]"}], "+", 
        RowBox[{"0.1", "*", "rn"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"5", "*", "\[Tau]"}], ",", 
       FractionBox["\[Tau]", "10"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<t[s]\>\"", ",", "\"\<u[V]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm", "[", "x_", "]"}], ":=", 
   SuperscriptBox["x", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", "t_", "]"}], ":=", 
   RowBox[{"c", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", "1"}], ")"}], "*", 
     RowBox[{"Exp", "[", 
      FractionBox[
       RowBox[{"-", "t"}], "e"], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"norm", "[", 
    RowBox[{"y", "-", 
     RowBox[{"model", "[", "t", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"celkErr", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"err", "/@", "data"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"min", "=", 
   RowBox[{
    RowBox[{"FindMinimum", "[", 
     RowBox[{"celkErr", ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "0.5"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<PrincipalAxis\>\""}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vysledek", "=", 
   RowBox[{
    RowBox[{"model", "[", "t", "]"}], "/.", "min"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"vysledek", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"5", "\[Tau]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", "pl2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"model", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", "t", ",", 
    RowBox[{"Method", "\[Rule]", "NMinimize"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.845521910515625*^9, 3.84552195465625*^9}, {
  3.84552198559375*^9, 3.845522410203125*^9}, {3.845522474375*^9, 
  3.845522477828125*^9}, {3.845522549609375*^9, 3.8455225890625*^9}, {
  3.8455226389375*^9, 3.845522703546875*^9}, {3.845522760234375*^9, 
  3.845522760671875*^9}, {3.84552283990625*^9, 3.845522874734375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", "t_", "]"}], ":=", 
   RowBox[{"c", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", "1"}], ")"}], "*", 
     RowBox[{"Exp", "[", 
      FractionBox[
       RowBox[{"-", "t"}], "e"], "]"}]}], "+", 
    RowBox[{"f", "*", "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"params", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"model", "[", "0.1", "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"E", "\[Rule]", 
         RowBox[{"1.", "E"}]}], ",", 
        RowBox[{"Pi", "\[Rule]", "1"}]}], "}"}]}], ",", "_Symbol", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", 
    RowBox[{"model", "[", "t", "]"}], ",", "params", ",", "t", ",", 
    RowBox[{"Method", "\[Rule]", "NMinimize"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8455229295*^9, 3.845522937828125*^9}, {
  3.8455230764375*^9, 3.845523101046875*^9}, {3.845523235265625*^9, 
  3.845523249421875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "d", ",", "e", ",", "f"}], "}"}]], "Output",
 CellChangeTimes->{{3.84552308321875*^9, 3.84552310171875*^9}, 
   3.845523249875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "E", "]"}]], "Input",
 CellChangeTimes->{{3.845523263421875*^9, 3.8455232675625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.84552326825*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "E", "]"}]], "Input",
 CellChangeTimes->{{3.8455232830625*^9, 3.845523286109375*^9}}],

Cell[BoxData[
 RowBox[{"{", "\<\"E\"\>", "}"}]], "Output",
 CellChangeTimes->{3.84552328684375*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "=", "3"}], ";"}]], "Input",
 CellChangeTimes->{{3.845523290046875*^9, 3.84552329246875*^9}}],

Cell[CellGroupData[{

Cell[BoxData["E"], "Input",
 CellChangeTimes->{3.84552330125*^9}],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.845523302265625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "List", "]"}]], "Input",
 CellChangeTimes->{{3.845523381421875*^9, 3.8455233850625*^9}, {
  3.84552343746875*^9, 3.84552343796875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Locked", ",", "Protected"}], "}"}]], "Output",
 CellChangeTimes->{3.8455233855*^9, 3.845523438640625*^9}]
}, Open  ]]
},
WindowSize->{1068, 641},
WindowMargins->{{6, Automatic}, {Automatic, -4}},
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->2.000000238418579,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1186, 35, 296, "Input"],
Cell[1746, 57, 3883, 116, 797, "Input"],
Cell[CellGroupData[{
Cell[5654, 177, 1143, 33, 219, "Input"],
Cell[6800, 212, 180, 4, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7017, 221, 127, 2, 83, "Input"],
Cell[7147, 225, 151, 4, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7335, 234, 126, 2, 83, "Input"],
Cell[7464, 238, 99, 2, 83, "Output"]
}, Open  ]],
Cell[7578, 243, 132, 3, 83, "Input"],
Cell[CellGroupData[{
Cell[7735, 250, 65, 1, 83, "Input"],
Cell[7803, 253, 70, 1, 83, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7910, 259, 177, 3, 83, "Input"],
Cell[8090, 264, 145, 3, 83, "Output"]
}, Open  ]]
}
]
*)

