(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    426428,       7515]
NotebookOptionsPosition[    424909,       7464]
NotebookOutlinePosition[    425457,       7485]
CellTagsIndexPosition[    425414,       7482]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"koeficienty", "=", 
   RowBox[{"N", "[", 
    RowBox[{"<<", "\"\<koeficienty\>\""}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.725635030921875*^9, 3.72563503215625*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "znatelny", " ", "vliv", " ", "vnitrniho", " ", "odporu", " ", "zdroje", 
   " ", "a", " ", 
   RowBox[{
    RowBox[{"kapacity", "!!"}], "!"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.714292269294443*^9, 3.7142922817788177`*^9}, {
  3.725535301859375*^9, 3.725535310765625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Uz0", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ri", "=", "15.6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]F", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cz", "=", 
   RowBox[{"100", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"1.8", "T"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", "=", 
   RowBox[{"2.", "*", 
    FractionBox["Pi", "T"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ns", "=", "480"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"i", ",", "t", ",", "ipom"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"np", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ipom", "[", "t_", "]"}], ":=", 
    RowBox[{"0.5", "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"ns", "*", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"0.5", "\[Omega]", "*", "t"}], "+", 
            RowBox[{"0.5", "Pi", "*", 
             RowBox[{"Random", "[", "]"}]}]}], "]"}], "132"]}], "]"}], 
       RowBox[{"Cosh", "[", 
        RowBox[{"1.00", "*", "ns"}], "]"}]], ")"}], "*", 
     RowBox[{"Tanh", "[", 
      FractionBox["t", 
       RowBox[{"0.1", "T"}]], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"i", "[", "t_", "]"}], "=", 
    RowBox[{
     FractionBox["2.", "np"], 
     RowBox[{"Plus", "@@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ipom", "[", "t", "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", "np", "]"}]}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"i", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "300"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.71419371778125*^9, 3.714193959359375*^9}, {
   3.714194227921875*^9, 3.71419424175*^9}, {3.714195117390625*^9, 
   3.714195119125*^9}, {3.7141953094375*^9, 3.71419530975*^9}, 
   3.71419556215625*^9, {3.714195902703125*^9, 3.7141959211875*^9}, {
   3.714202467109375*^9, 3.714202500234375*^9}, {3.7142028041875*^9, 
   3.714202804515625*^9}, {3.714204518578125*^9, 3.714204518734375*^9}, {
   3.714208001390625*^9, 3.7142080286875*^9}, 3.71420809446875*^9, {
   3.71421047840625*^9, 3.714210493296875*^9}, 3.714210540234375*^9, {
   3.7142917179975677`*^9, 3.714291718263193*^9}, 3.714292075825693*^9, {
   3.714292112731943*^9, 3.714292200825693*^9}, 3.714292258106943*^9, {
   3.71437291753125*^9, 3.7143729894375*^9}, 3.7143732435625*^9, {
   3.714373284265625*^9, 3.7143733266875*^9}, {3.714373367296875*^9, 
   3.714373367765625*^9}, 3.71437343965625*^9, {3.714373469890625*^9, 
   3.714373531859375*^9}, {3.71437356265625*^9, 3.714373563015625*^9}, 
   3.71437360778125*^9, 3.714373665828125*^9, {3.714373711890625*^9, 
   3.71437375653125*^9}, 3.714373800515625*^9, {3.714374033390625*^9, 
   3.714374033609375*^9}, {3.714374223234375*^9, 3.714374237359375*^9}, 
   3.7143793808125*^9, 3.714379507078125*^9, {3.71437961603125*^9, 
   3.714379616859375*^9}, 3.714379700625*^9, {3.714721128234375*^9, 
   3.714721151421875*^9}, 3.71472321021875*^9, 3.71472324396875*^9, {
   3.714724874109375*^9, 3.714724892265625*^9}, 3.714725077*^9, 
   3.714725226578125*^9, {3.714725329171875*^9, 3.714725451234375*^9}, 
   3.714725575171875*^9, 3.725535235578125*^9, {3.7255352659375*^9, 
   3.725535291140625*^9}, {3.72560655346875*^9, 3.72560658190625*^9}, 
   3.72560664890625*^9, {3.725633758796875*^9, 3.7256338076875*^9}, {
   3.72563387903125*^9, 3.725634065875*^9}, {3.725634105140625*^9, 
   3.72563410575*^9}, {3.7256341635*^9, 3.725634163859375*^9}, {
   3.725634194328125*^9, 3.72563419471875*^9}, {3.7256342834375*^9, 
   3.7256342843125*^9}, {3.725634316*^9, 3.725634362453125*^9}, {
   3.725635884234375*^9, 3.725635884734375*^9}, {3.7256359231875*^9, 
   3.7256359240625*^9}, {3.72563600959375*^9, 3.725636009984375*^9}, {
   3.725636819703125*^9, 3.725636820921875*^9}, {3.72568799821875*^9, 
   3.725688022296875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81e8Xt0W2a3OV7r1GioSM+3mOldIUEqIkSgghO3tnJYQkFCHZCSEy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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"i [A]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.725687719140625*^9, 3.725687841296875*^9, {3.725687999515625*^9, 
   3.72568802453125*^9}, 3.7256928246875*^9, 3.725697351328125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", "3000."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "=", "2500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"5.2", "\[Mu]F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"u", ",", "e", ",", "uz"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Uz0", "-", 
        RowBox[{"uz", "[", "t", "]"}]}], "Ri"], "\[Equal]", 
      RowBox[{
       RowBox[{"cz", "*", 
        RowBox[{
         RowBox[{"uz", "'"}], "[", "t", "]"}]}], "+", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"uz", "[", "0", "]"}], "==", "Uz0"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"k", "*", 
         RowBox[{"i", "[", "t", "]"}]}], "-", 
        RowBox[{"u", "[", "t", "]"}]}], "R1"], "\[Equal]", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"u", "'"}], "[", "t", "]"}]}], "+", 
       FractionBox[
        RowBox[{"u", "[", "t", "]"}], "R2"]}]}], ",", 
     RowBox[{
      RowBox[{"u", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"uz", "[", "t", "]"}], "*", 
       RowBox[{"i", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "e", ",", 
        RowBox[{"u", "'"}], ",", "uz"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"MaxStepSize", "\[Rule]", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]], "T"}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", 
       SuperscriptBox["10", "6"]}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"e", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uz", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"uz", "[", "t", "]"}], "/.", "sol"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<u [V]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"e", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<E [J]\>\""}], "}"}]}]}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<t[s]\>\"", ",", "\"\<uz [V]\>\""}], "}"}]}]}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"pli", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"i", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "300"}]}], "]"}]}]}], "}"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etrue", "=", 
   RowBox[{
    RowBox[{"e", "[", "tmax", "]"}], "-", 
    RowBox[{"e", "[", "0", "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.714193973140625*^9, 3.714194434171875*^9}, {
   3.714194477015625*^9, 3.714194488546875*^9}, {3.714194560890625*^9, 
   3.714194862015625*^9}, {3.714194893765625*^9, 3.71419489890625*^9}, {
   3.71419494371875*^9, 3.71419509759375*^9}, {3.714195129390625*^9, 
   3.714195178625*^9}, 3.714195211671875*^9, 3.7141952571875*^9, 
   3.714195517265625*^9, {3.71419669915625*^9, 3.714196700015625*^9}, 
   3.71419709803125*^9, 3.714202535109375*^9, {3.71420262665625*^9, 
   3.714202643171875*^9}, {3.714204559234375*^9, 3.714204559484375*^9}, {
   3.71420509434375*^9, 3.7142050945*^9}, 3.714206417359375*^9, 
   3.714207988*^9, {3.714210401453125*^9, 3.714210455359375*^9}, {
   3.7142105194375*^9, 3.714210519890625*^9}, {3.71421060253125*^9, 
   3.714210613484375*^9}, {3.71421066359375*^9, 3.7142106650625*^9}, {
   3.714210711078125*^9, 3.7142107330625*^9}, {3.71421252984375*^9, 
   3.71421254378125*^9}, {3.7142913657475677`*^9, 3.7142913676225677`*^9}, 
   3.7142915904975677`*^9, {3.714291633919443*^9, 3.714291634075693*^9}, {
   3.714291702513193*^9, 3.714291702825693*^9}, 3.714291736481943*^9, {
   3.714291768325693*^9, 3.714291768544443*^9}, {3.7142920923100677`*^9, 
   3.714292092450693*^9}, {3.714292242856943*^9, 3.714292243075693*^9}, {
   3.7142923021850677`*^9, 3.714292302325693*^9}, {3.714372936625*^9, 
   3.71437293859375*^9}, {3.714372974859375*^9, 3.714373115453125*^9}, {
   3.71437315396875*^9, 3.714373164765625*^9}, 3.714373258078125*^9, {
   3.714373337171875*^9, 3.714373383234375*^9}, {3.71437341990625*^9, 
   3.71437342203125*^9}, 3.714373454921875*^9, 3.714373540984375*^9, 
   3.714373578390625*^9, 3.7143736266875*^9, {3.714373678109375*^9, 
   3.7143736879375*^9}, {3.714373776734375*^9, 3.714373782703125*^9}, {
   3.71437390203125*^9, 3.71437391184375*^9}, {3.71437405009375*^9, 
   3.714374103359375*^9}, {3.71437425453125*^9, 3.714374255265625*^9}, {
   3.714374316796875*^9, 3.714374318765625*^9}, {3.714379623109375*^9, 
   3.7143796499375*^9}, {3.714379685078125*^9, 3.714379691765625*^9}, 
   3.7147233005625*^9, 3.7147239073125*^9, 3.71472408765625*^9, 
   3.714724964515625*^9, 3.714725020125*^9, {3.725550917625*^9, 
   3.725550919015625*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BbITHKvs5gTEhZZkiM+7FEohiGhrJUkjUJbUKLIiVZQkm0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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"u [V]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF13lYzF8XAPD2PUSbahLtE0mb1Mw9LUqkTA2mPUurFqEkREkhCpGIRIl2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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"E [J]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw82nc81e/7B3A7ycjOrHCMQ5Idh0tIkXEOIiUrVEpJFFFJKpWVioaUlbJC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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"uz [V]\"", TraditionalForm]},
    AxesOrigin->{0, 4.962},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c81e8Xt0W2a3OV7r1GioSM+3mOldIUEqIkSgghO3tnJYQkFCHZCSEy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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesLabel->{
      FormBox["\"t[s]\"", TraditionalForm], 
      FormBox["\"i [A]\"", TraditionalForm]},
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.725687722671875*^9, 3.7256878446875*^9, {3.72568800659375*^9, 
   3.7256880276875*^9}, 3.725692827890625*^9, 3.7256973545625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pli", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "500"}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<pli.png\>\"", ",", "pli", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.725551014828125*^9, 3.72555107284375*^9}, {
   3.7255511350625*^9, 3.725551143109375*^9}, 3.725605280015625*^9, {
   3.725634227796875*^9, 3.725634231546875*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[0.006], LineBox[CompressedData["
1:eJwUV3k81F8Xtoylkl9lzIwZg5AIWUKW+d4j2UooIXukIhVCRFmSQtnXhEIo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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"i [A]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  GridLines->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.725687723234375*^9, 3.725687845265625*^9, {3.725688009765625*^9, 
   3.725688028109375*^9}, 3.725692828390625*^9, 3.725697355*^9}],

Cell[BoxData["\<\"pli.png\"\>"], "Output",
 CellChangeTimes->{
  3.725687723234375*^9, 3.725687845265625*^9, {3.725688009765625*^9, 
   3.725688028109375*^9}, 3.725692828390625*^9, 3.72569735553125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plii", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"i", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0.0001", ",", "0.0003"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<t[s]\>\"", ",", "\"\<i [A]\>\""}], "}"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "300"}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<plii.png\>\"", ",", "plii", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7256053023125*^9, 3.72560535134375*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[0.006], LineBox[CompressedData["
1:eJwU13c8ld8fAHA7KSKj3GmFlswy7nM+iiIhSWSEkJAoSZKVUEJD2dkjOyKr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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"t[s]\"", TraditionalForm], 
    FormBox["\"i [A]\"", TraditionalForm]},
  AxesOrigin->{0.0001, 0},
  GridLines->Automatic,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.72568772459375*^9, 3.72568784603125*^9, 
  3.725688028875*^9, 3.725692829625*^9, 3.725697355765625*^9}],

Cell[BoxData["\<\"plii.png\"\>"], "Output",
 CellChangeTimes->{3.72568772459375*^9, 3.72568784603125*^9, 
  3.725688028875*^9, 3.725692829625*^9, 3.72569735628125*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      FractionBox["1", "k"], "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["R1", "R2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     FractionBox[
      RowBox[{"R1", "*", "c"}], "k"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"uz", "[", "t", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"srTry", "=", "23.5"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.714193973140625*^9, 3.714194434171875*^9}, {
   3.714194477015625*^9, 3.714194488546875*^9}, {3.714194560890625*^9, 
   3.714194862015625*^9}, {3.714194893765625*^9, 3.71419489890625*^9}, {
   3.71419494371875*^9, 3.71419509759375*^9}, {3.714195129390625*^9, 
   3.714195178625*^9}, 3.714195211671875*^9, 3.7141952571875*^9, 
   3.714195517265625*^9, {3.71419669915625*^9, 3.714196700015625*^9}, 
   3.71419709803125*^9, 3.714202535109375*^9, {3.71420262665625*^9, 
   3.714202643171875*^9}, {3.714204559234375*^9, 3.714204559484375*^9}, {
   3.71420509434375*^9, 3.7142050945*^9}, 3.714206417359375*^9, 
   3.714207988*^9, {3.714210401453125*^9, 3.714210455359375*^9}, {
   3.7142105194375*^9, 3.714210519890625*^9}, {3.71421060253125*^9, 
   3.714210613484375*^9}, {3.71421066359375*^9, 3.7142106650625*^9}, {
   3.714210711078125*^9, 3.7142107330625*^9}, {3.71421252984375*^9, 
   3.71421254378125*^9}, {3.7142913657475677`*^9, 3.7142913676225677`*^9}, 
   3.7142915904975677`*^9, {3.714291633919443*^9, 3.714291634075693*^9}, {
   3.714291702513193*^9, 3.714291702825693*^9}, 3.714291736481943*^9, {
   3.714291768325693*^9, 3.714291768544443*^9}, {3.7142920923100677`*^9, 
   3.714292092450693*^9}, {3.714292242856943*^9, 3.714292243075693*^9}, {
   3.7142923021850677`*^9, 3.714292302325693*^9}, {3.714372936625*^9, 
   3.71437293859375*^9}, {3.714372974859375*^9, 3.7143729808125*^9}, {
   3.7143743256875*^9, 3.714374326859375*^9}, {3.7143794205*^9, 
   3.714379488640625*^9}, {3.71472095834375*^9, 3.714720963296875*^9}, {
   3.71472100109375*^9, 3.714721099109375*^9}, {3.714721412546875*^9, 
   3.714721412890625*^9}, {3.71472317921875*^9, 3.714723179453125*^9}, 
   3.714723365734375*^9, 3.71472343325*^9, 3.714723471265625*^9, 
   3.71472383990625*^9, 3.714723876265625*^9, {3.714723942765625*^9, 
   3.714723943109375*^9}, {3.714724001796875*^9, 3.714724001953125*^9}, {
   3.714724759890625*^9, 3.714724760875*^9}, 3.71472514896875*^9, 
   3.714725518484375*^9, 3.72563462621875*^9, {3.725634902828125*^9, 
   3.7256349451875*^9}, 3.725634977859375*^9, {3.72563546475*^9, 
   3.725635465296875*^9}, {3.7256356031875*^9, 3.725635621328125*^9}, 
   3.725635679234375*^9, {3.7256359445*^9, 3.72563594546875*^9}, {
   3.72563618575*^9, 3.7256361980625*^9}, {3.725636704953125*^9, 
   3.725636709421875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydej", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej", "[", 
    RowBox[{"n_Integer", ",", "sr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "casy", ",", "vahy", ",", "g", ",", "i1", ",", "i2", ",", "ftKsi", ",", 
       "h", ",", "Ecelk", ",", "p", ",", "Eraw", ",", "\[CapitalDelta]t"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       RowBox[{"N", "@", 
        FractionBox["T", "sr"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"casy", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}], ",", 
         "n", ",", 
         RowBox[{"n", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vahy", "=", 
       RowBox[{"koeficienty", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"uz", "[", "#", "]"}], "*", 
         RowBox[{"i", "[", "#", "]"}]}], "&"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eraw", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"h", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f1", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"g", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", 
         RowBox[{"list_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"EvenQ", "[", 
             RowBox[{"Length", "[", "#", "]"}], "]"}], "&"}], ")"}]}]}], 
        "]"}], ":=", 
       RowBox[{"0.5", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"list", "[", 
            RowBox[{"[", 
             FractionBox[
              RowBox[{"Length", "[", "list", "]"}], "2"], "]"}], "]"}], "]"}],
           "+", 
          RowBox[{"f", "[", 
           RowBox[{"list", "[", 
            RowBox[{"[", 
             RowBox[{
              FractionBox[
               RowBox[{"Length", "[", "list", "]"}], "2"], "+", "1"}], "]"}], 
            "]"}], "]"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", 
         RowBox[{"list_", "?", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"OddQ", "[", 
             RowBox[{"Length", "[", "#", "]"}], "]"}], "&"}], ")"}]}]}], 
        "]"}], ":=", 
       RowBox[{"f", "[", 
        RowBox[{"list", "[", 
         RowBox[{"[", 
          FractionBox[
           RowBox[{
            RowBox[{"Length", "[", "list", "]"}], "+", "1"}], "2"], "]"}], 
         "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
        RowBox[{"f1", "[", 
         RowBox[{"First", "[", "list", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"ftKsi", "[", 
          RowBox[{"u", ",", "list"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"uz", "[", 
            RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
           RowBox[{"uz", "[", 
            RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"h", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelk", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Eraw"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelk"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydej", "[", 
    RowBox[{"2", ",", "srTry"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.714721233890625*^9, 3.71472126696875*^9}, {
   3.71472136746875*^9, 3.714721435203125*^9}, {3.714721487265625*^9, 
   3.714721516296875*^9}, {3.7147215596875*^9, 3.714721665796875*^9}, {
   3.714721703125*^9, 3.714721732171875*^9}, {3.7147221045625*^9, 
   3.714722144671875*^9}, {3.7147224009375*^9, 3.714722410703125*^9}, {
   3.714722457125*^9, 3.714722497625*^9}, {3.714722533859375*^9, 
   3.71472272728125*^9}, {3.7147227644375*^9, 3.714722812875*^9}, {
   3.714722865078125*^9, 3.714723053125*^9}, {3.71472359590625*^9, 
   3.71472371175*^9}, {3.71472451265625*^9, 3.714724527515625*^9}, 
   3.7147250401875*^9, 3.72563478740625*^9, {3.72563538634375*^9, 
   3.7256354331875*^9}, {3.72563547578125*^9, 3.725635497609375*^9}, {
   3.7256361678125*^9, 3.7256362071875*^9}, {3.725636586828125*^9, 
   3.725636638640625*^9}, 3.725636796453125*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.714723103140625*^9, 3.714723121296875*^9}, 
   3.714724524984375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejb", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejb", "[", 
    RowBox[{"n_Integer", ",", "sr_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "casy", ",", "vahy", ",", "g", ",", "i1", ",", "i2", ",", "ftKsi", ",", 
       "h", ",", "Ecelk", ",", "p", ",", "Eraw", ",", "\[CapitalDelta]t"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]t", "=", 
       RowBox[{"N", "@", 
        FractionBox["T", "sr"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"casy", "=", 
       RowBox[{"Partition", "[", 
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{"0", ",", "tmax", ",", "\[CapitalDelta]t"}], "]"}], ",", 
         "n", ",", 
         RowBox[{"n", "-", "1"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vahy", "=", 
       RowBox[{"koeficienty", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p", ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"uz", "[", "#", "]"}], "*", 
         RowBox[{"i", "[", "#", "]"}]}], "&"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Eraw", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"h", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f1", "/@", "list"}], ")"}], ".", "vahy"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i1", "=", 
       RowBox[{"\[CapitalDelta]t", "*", 
        RowBox[{"(", 
         RowBox[{"Plus", "@@", 
          RowBox[{"(", 
           RowBox[{"g", "/@", "casy"}], ")"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ftKsi", "[", 
        RowBox[{"f_", ",", "list_"}], "]"}], ":=", 
       RowBox[{"Mean", "[", 
        RowBox[{"f", "/@", "list"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", "list_List", "]"}], ":=", 
       RowBox[{
        RowBox[{"f1", "[", 
         RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
        RowBox[{"f1", "[", 
         RowBox[{"First", "[", "list", "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"ftKsi", "[", 
          RowBox[{"u", ",", "list"}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"uz", "[", 
            RowBox[{"Last", "[", "list", "]"}], "]"}], "-", 
           RowBox[{"uz", "[", 
            RowBox[{"First", "[", "list", "]"}], "]"}]}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i2", "=", 
       RowBox[{"Plus", "@@", 
        RowBox[{"(", 
         RowBox[{"h", "/@", "casy"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ecelk", "=", 
       RowBox[{
        RowBox[{"a", "*", "i1"}], "+", 
        RowBox[{"b", "*", "i2"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Eraw"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}], ",", 
        RowBox[{"100", 
         RowBox[{"Abs", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["Etrue", "Ecelk"], ")"}], 
            RowBox[{"-", "1"}]]}], "]"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejb", "[", 
    RowBox[{"2", ",", "srTry"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.714721233890625*^9, 3.71472126696875*^9}, {
   3.71472136746875*^9, 3.714721435203125*^9}, {3.714721487265625*^9, 
   3.714721516296875*^9}, {3.7147215596875*^9, 3.714721665796875*^9}, {
   3.714721703125*^9, 3.714721732171875*^9}, {3.7147221045625*^9, 
   3.714722144671875*^9}, {3.7147224009375*^9, 3.714722410703125*^9}, {
   3.714722457125*^9, 3.714722497625*^9}, {3.714722533859375*^9, 
   3.71472272728125*^9}, {3.7147227644375*^9, 3.714722812875*^9}, {
   3.714722865078125*^9, 3.714723053125*^9}, {3.71472359590625*^9, 
   3.71472371175*^9}, {3.71472451265625*^9, 3.714724549234375*^9}, {
   3.7147246680625*^9, 3.714724688984375*^9}, {3.714724728984375*^9, 
   3.7147247386875*^9}, {3.714725047140625*^9, 3.714725047515625*^9}, {
   3.72563551971875*^9, 3.725635571125*^9}, {3.725635987734375*^9, 
   3.725635988734375*^9}, 3.72563615796875*^9, 3.725636213640625*^9, {
   3.725636516796875*^9, 3.725636551796875*^9}, 3.72563679859375*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"srTry", "=", "80.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"vydejb", "[", 
       RowBox[{"#", ",", "srTry"}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "7", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"vydej", "[", 
       RowBox[{"#", ",", "srTry"}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "7", ",", "1"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.725635558828125*^9, 3.7256355674375*^9}, 
   3.72563606371875*^9, {3.72563611828125*^9, 3.7256361475625*^9}, 
   3.72563686640625*^9, {3.72563844090625*^9, 3.72563845365625*^9}, {
   3.725696691453125*^9, 3.725696695171875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "vydejGraf", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vydejGraf", "[", 
    RowBox[{"{", 
     RowBox[{"n_Integer", ",", 
      RowBox[{"{", 
       RowBox[{"srmin_", ",", "srmax_"}], "}"}]}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"srList", ",", 
       RowBox[{"nq", "=", "50"}], ",", "q", ",", "da", ",", "db", ",", 
       "errRaws", ",", "erra", ",", "errb", ",", "datsRaw", ",", "datsa", ",",
        "datsb", ",", "mypl"}], "}"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{"Exp", "[", 
        RowBox[{
         FractionBox["1.", 
          RowBox[{"nq", "-", "1"}]], "*", 
         RowBox[{"Log", "[", 
          FractionBox["srmax", "srmin"], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"srList", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"srmin", "*", 
          SuperscriptBox["q", 
           RowBox[{"(", 
            RowBox[{"#", "-", "1"}], ")"}]]}], "&"}], "/@", 
        RowBox[{"Range", "[", "nq", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"da", ",", "db"}], "}"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"vydej", "[", 
              RowBox[{"n", ",", "#"}], "]"}], ",", 
             RowBox[{"vydejb", "[", 
              RowBox[{"n", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", 
          "srList"}], ")"}], "\[Transpose]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"errRaws", "=", 
       RowBox[{"First", "/@", "da"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"erra", "=", 
       RowBox[{"Last", "/@", "da"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"errb", "=", 
       RowBox[{"Last", "/@", "db"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"datsRaw", "=", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"srList", ",", "errRaws"}], "}"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"sr_", ",", "err_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "T"], "*", "sr"}], ",", "err"}], "}"}]}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"datsa", "=", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"srList", ",", "erra"}], "}"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"sr_", ",", "err_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "T"], "*", "sr"}], ",", "err"}], "}"}]}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"datsb", "=", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"{", 
          RowBox[{"srList", ",", "errb"}], "}"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"sr_", ",", "err_"}], "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            FractionBox["1", "T"], "*", "sr"}], ",", "err"}], "}"}]}]}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"mypl", "[", 
        RowBox[{"co_List", ",", "hue_Real"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"pointPlot", ",", "linePlot"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"pointPlot", "=", 
           RowBox[{"ListLogLogPlot", "[", 
            RowBox[{"co", ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Hue", "[", "hue", "]"}], ",", 
                RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
             RowBox[{"AxesLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<sr [-]\>\"", ",", "\"\<err [%]\>\""}], "}"}]}], 
             ",", 
             RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"linePlot", "=", 
           RowBox[{"ListLogLogPlot", "[", 
            RowBox[{"co", ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Hue", "[", "hue", "]"}], "}"}]}], ",", 
             RowBox[{"Joined", "\[Rule]", "True"}], ",", 
             RowBox[{"AxesLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<sr [-]\>\"", ",", "\"\<err [%]\>\""}], "}"}]}], 
             ",", 
             RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Show", "[", 
           RowBox[{"pointPlot", ",", "linePlot"}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"mypl", "[", 
         RowBox[{"datsRaw", ",", "0.0"}], "]"}], ",", 
        RowBox[{"mypl", "[", 
         RowBox[{"datsa", ",", "0.33"}], "]"}], ",", 
        RowBox[{"mypl", "[", 
         RowBox[{"datsb", ",", "0.66"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"grafik", "=", 
  RowBox[{"Quiet", "@", 
   RowBox[{"vydejGraf", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3000"}], "}"}]}], "}"}], 
    "]"}]}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.725637072375*^9, 3.72563710309375*^9}, {
   3.725637170828125*^9, 3.725637204125*^9}, {3.72563730934375*^9, 
   3.7256373666875*^9}, {3.72563747934375*^9, 3.725637608328125*^9}, 
   3.725638541171875*^9, {3.725638639484375*^9, 3.7256387933125*^9}, {
   3.72563883034375*^9, 3.7256391758125*^9}, {3.72563920665625*^9, 
   3.725639769828125*^9}, {3.725639880703125*^9, 3.725639912453125*^9}, 
   3.72563994659375*^9, {3.72564006165625*^9, 3.72564009721875*^9}, {
   3.72568779796875*^9, 3.7256878370625*^9}, 3.72569729321875*^9, {
   3.7256973384375*^9, 3.72569734746875*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, 
     {Hue[0.], PointSize[0.01], PointBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQfc8t/2dQupyDWOjW3RuzhRx8s6+cU2eQd3Ce3dO0
Acjf3W+55M8MeYeLrTcyFLYJOohGnd/zQkIBrt7nTaN6cKqCw7fjlmB+c53J
pL0bEfK7BJ7/Uf+n4LD48akdj4OFHD4tmpk+yUvRYWoIRF7T1OfSn2mKcPUJ
x//ZpD9WdMjnlDD6dpjFYXrkxuUX9ZUcvhQWFDG/FnQ4/zpZyKZGySH9zeH/
e0OFHNjqxGqXnVByiCyRuiuqLelgK3DyuYCosoO7yvsSZ9cv9iWLqoOqE5Ud
tIv41jimCTmsNtHb+3StssO3TeW/7P5yOzw+9kA94Jeyg4f6mW6Qf6UiJ0/a
5abiIB9ikvZkJ6dD4GvXvyqTVRxsz+96bWkt6NBR+yO9/76KQ/eSw942DsIO
B/hXX/qpreqws3VntJI9v8P3hbG2KRWqDpfU19q51Ao66JkIrDh3RNXBk+vZ
vO3/WB1Sjx0SshRUc9i79sHHmj08DnMiSmsXx6o5qF1Wmsh7j8fhyiv1F7yr
1BwSyhu+nN302p679lZQxTc1Bx7Ppe9U9rE7OPH37n3kpO7As097v9cRBofK
hfYavv3qDhZTavyXn2Bz2Gj8adL22+oOXGnfWaby/LV/cXTJX0UNDYeLanzy
YtyCDvIR4Rk9JRoOPvNWawj8+m4f9orz8rcDGg7HzX7wHI1ndeit2WObyKvp
8Dx566ILe1/ZH+XLX3E6UtNheonhkcOMn+3/LFAUNlum6eDwIDd6efYHe2Pj
K7ULPmk6bPQ5eP9w+/n9WUfbXnDZazk8Kqxcarbpg/2icMvg0m4thyWb8k9/
1v+w/+bL13vvX9dyOPxvtWy2Bd8BgZp5Gl4q2g7RTqsl1/fxHnDnC5y8pUDb
4UvYz4XvFaQO1C9g/ie3V9vh9bVJP+wLFA9sM9qW0cmp47Cdf8aMT3UqB94e
ybj8OVTHod6Hr/sAn+4BlXBpu7hFOg7r/y5coNSrcyD65dkVJ97pODy6q35J
sVrnwOTqBmFja10HJW4hR28g/xSvcd3cdl2HNuYTyn5APuOCpy/Yr+g6zJHh
dAwB8gFpEWWc
       "]]}, {}}, {{}, {}, 
     {Hue[0.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQfc8t/2dQupyDWOjW3RuzhRx8s6+cU2eQd3Ce3dO0
Acjf3W+55M8MeYeLrTcyFLYJOohGnd/zQkIBrt7nTaN6cKqCw7fjlmB+c53J
pL0bEfK7BJ7/Uf+n4LD48akdj4OFHD4tmpk+yUvRYWoIRF7T1OfSn2mKcPUJ
x//ZpD9WdMjnlDD6dpjFYXrkxuUX9ZUcvhQWFDG/FnQ4/zpZyKZGySH9zeH/
e0OFHNjqxGqXnVByiCyRuiuqLelgK3DyuYCosoO7yvsSZ9cv9iWLqoOqE5Ud
tIv41jimCTmsNtHb+3StssO3TeW/7P5yOzw+9kA94Jeyg4f6mW6Qf6UiJ0/a
5abiIB9ikvZkJ6dD4GvXvyqTVRxsz+96bWkt6NBR+yO9/76KQ/eSw942DsIO
B/hXX/qpreqws3VntJI9v8P3hbG2KRWqDpfU19q51Ao66JkIrDh3RNXBk+vZ
vO3/WB1Sjx0SshRUc9i79sHHmj08DnMiSmsXx6o5qF1Wmsh7j8fhyiv1F7yr
1BwSyhu+nN302p679lZQxTc1Bx7Ppe9U9rE7OPH37n3kpO7As097v9cRBofK
hfYavv3qDhZTavyXn2Bz2Gj8adL22+oOXGnfWaby/LV/cXTJX0UNDYeLanzy
YtyCDvIR4Rk9JRoOPvNWawj8+m4f9orz8rcDGg7HzX7wHI1ndeit2WObyKvp
8Dx566ILe1/ZH+XLX3E6UtNheonhkcOMn+3/LFAUNlum6eDwIDd6efYHe2Pj
K7ULPmk6bPQ5eP9w+/n9WUfbXnDZazk8Kqxcarbpg/2icMvg0m4thyWb8k9/
1v+w/+bL13vvX9dyOPxvtWy2Bd8BgZp5Gl4q2g7RTqsl1/fxHnDnC5y8pUDb
4UvYz4XvFaQO1C9g/ie3V9vh9bVJP+wLFA9sM9qW0cmp47Cdf8aMT3UqB94e
ybj8OVTHod6Hr/sAn+4BlXBpu7hFOg7r/y5coNSrcyD65dkVJ97pODy6q35J
sVrnwOTqBmFja10HJW4hR28g/xSvcd3cdl2HNuYTyn5APuOCpy/Yr+g6zJHh
dAwB8gFpEWWc
       "]]}}}, {{{}, 
     {Hue[0.33], PointSize[0.01], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA3kZv+VJnHkARFzJ6+BQQQE1r1M4n
AB9ATbKocSoL87+7jzmk/JgfQAXb3uHrK/C/FVrPvOgYIEBLyKhWBSoCQEzs
gSdTZSBAIzDW1ClcAsCDfjSSvbEgQGu+MGGmSQFAuhDn/Cf+IECzWYEOaln8
v/KimWeSSiFAV2dxzrNh8L8pNUzS/JYhQMS2HnjYWQPAYMf+PGfjIUBOKwwy
Ig8QwJdZsafRLyJAO2aQ35q++r/P62MSPHwiQDFxbFdVExHABn4WfabIIkAo
aGos0KL8vz0QyecQFSNA0QVKAiNvBcB0ontSe2EjQKCxfOdNVAXAqzQuveWt
I0CyqiQQiRoOwOPG4CdQ+iNAjjP2sptrCMAaWZOSukYkQFBxWIRQ2wTAUetF
/SSTJECNjll8vjsIwIh9+GeP3yRAjxp0YXboBcDAD6vS+SslQHbh97VthQnA
96FdPWR4JUCZbIzW2z0HwC40EKjOxCVA8tLEkQfvF8BlxsISOREmQOPEiQqI
WRXAnFh1faNdJkAFVphjyhARwNTqJ+gNqiZAnq1U4+LQD8ALfdpSePYmQIYE
9+VJRhLAQg+NveJCJ0DL5ul5s7kUwHmhPyhNjydApCSOXyMuFMCxM/KSt9sn
QDmek1n4NgvA6MWk/SEoKECBCrYNJvoMwB9YV2iMdChAaCHP6Eh/E8BW6gnT
9sAoQGCYAUtARxLAjXy8PWENKUA3cRErYtwUwMUOb6jLWSlALOGK70YgFcD8
oCETNqYpQFcvjzoANhnAMzPUfaDyKUCReHuwx90awGrFhugKPypAD9189TFT
F8CiVzlTdYsqQD5igO6foyDA2enrvd/XKkB0tHV9ZwMcwBB8nihKJCtACrwj
3DXPIMBHDlGTtHArQEwPbOpTTiXAf6AD/h69K0DKRsEvc+wjwLYytmiJCSxA
Y2Fv1EhhKcDtxGjT81UsQCFmQUoujirAJFcbPl6iLEDtho5znXQswFvpzajI
7ixAT+rskf7iLMCTe4ATMzstQGrTSEZBbS3Ayg0zfp2HLUAxukMT3fItwAGg
5egH1C1AfFq0gBdzLsB3aGiw
       "]]}, {}}, {{}, {}, 
     {Hue[0.33], LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA3kZv+VJnHkARFzJ6+BQQQE1r1M4n
AB9ATbKocSoL87+7jzmk/JgfQAXb3uHrK/C/FVrPvOgYIEBLyKhWBSoCQEzs
gSdTZSBAIzDW1ClcAsCDfjSSvbEgQGu+MGGmSQFAuhDn/Cf+IECzWYEOaln8
v/KimWeSSiFAV2dxzrNh8L8pNUzS/JYhQMS2HnjYWQPAYMf+PGfjIUBOKwwy
Ig8QwJdZsafRLyJAO2aQ35q++r/P62MSPHwiQDFxbFdVExHABn4WfabIIkAo
aGos0KL8vz0QyecQFSNA0QVKAiNvBcB0ontSe2EjQKCxfOdNVAXAqzQuveWt
I0CyqiQQiRoOwOPG4CdQ+iNAjjP2sptrCMAaWZOSukYkQFBxWIRQ2wTAUetF
/SSTJECNjll8vjsIwIh9+GeP3yRAjxp0YXboBcDAD6vS+SslQHbh97VthQnA
96FdPWR4JUCZbIzW2z0HwC40EKjOxCVA8tLEkQfvF8BlxsISOREmQOPEiQqI
WRXAnFh1faNdJkAFVphjyhARwNTqJ+gNqiZAnq1U4+LQD8ALfdpSePYmQIYE
9+VJRhLAQg+NveJCJ0DL5ul5s7kUwHmhPyhNjydApCSOXyMuFMCxM/KSt9sn
QDmek1n4NgvA6MWk/SEoKECBCrYNJvoMwB9YV2iMdChAaCHP6Eh/E8BW6gnT
9sAoQGCYAUtARxLAjXy8PWENKUA3cRErYtwUwMUOb6jLWSlALOGK70YgFcD8
oCETNqYpQFcvjzoANhnAMzPUfaDyKUCReHuwx90awGrFhugKPypAD9189TFT
F8CiVzlTdYsqQD5igO6foyDA2enrvd/XKkB0tHV9ZwMcwBB8nihKJCtACrwj
3DXPIMBHDlGTtHArQEwPbOpTTiXAf6AD/h69K0DKRsEvc+wjwLYytmiJCSxA
Y2Fv1EhhKcDtxGjT81UsQCFmQUoujirAJFcbPl6iLEDtho5znXQswFvpzajI
7ixAT+rskf7iLMCTe4ATMzstQGrTSEZBbS3Ayg0zfp2HLUAxukMT3fItwAGg
5egH1C1AfFq0gBdzLsB3aGiw
       "]]}}}, {{{}, 
     {Hue[0.66], PointSize[0.01], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA3kZv+VJnHkDVkjiTyxUQQE1r1M4n
AB9AzM5m1sss97+7jzmk/JgfQJ3837NbtvG/FVrPvOgYIEASSfEAkiUCQEzs
gSdTZSBAePCBcop7BsCDfjSSvbEgQPWmoyhEWgFAuhDn/Cf+IEAt6TGba6v+
v/KimWeSSiFAeNRV+rPr8r8pNUzS/JYhQGFIpCMp+wfAYMf+PGfjIUAiJNOP
/cAKwJdZsafRLyJARuT8gcYf+b/P62MSPHwiQBURR+imxxHABn4WfabIIkDl
D54gYSX/vz0QyecQFSNAnOk7xFCmBMB0ontSe2EjQMQSnyWN+wfAqzQuveWt
I0DzZLtxLYwOwOPG4CdQ+iNAIKA31onICMAaWZOSukYkQM8VMksB+gPAUetF
/SSTJECG5tfLe4gJwIh9+GeP3yRAIh71gBR2BcDAD6vS+SslQBriH/Y09wnA
96FdPWR4JUBBkoAJKWgJwC40EKjOxCVAYe3/r8Z6FsBlxsISOREmQDRIaDoO
sBHAnFh1faNdJkBRFNoX1cATwNTqJ+gNqiZAjMXhk9YME8ALfdpSePYmQNB/
G2OAmBHAQg+NveJCJ0C0VYKgRaQYwHmhPyhNjydAcOj/35mhFcCxM/KSt9sn
QOLzoIlCeBDA6MWk/SEoKEAPDHeu7/UQwB9YV2iMdChAKE3ScuTUFsBW6gnT
9sAoQHvivtzLXRXAjXy8PWENKUAhgG+2dE4YwMUOb6jLWSlAZ5jwuAU3GMD8
oCETNqYpQAP0A4lYCR3AMzPUfaDyKUAQGSZks+4ewGrFhugKPypAxtGnStIa
G8CiVzlTdYsqQPHbXrcmeiLA2enrvd/XKkDNB9t7ZyYgwBB8nihKJCtAtwZs
i2TIIsBHDlGTtHArQAT0aMCobibAf6AD/h69K0DeOfgZH6UlwLYytmiJCSxA
hMys9d/HKMDtxGjT81UsQAHoducNfCnAJFcbPl6iLEAucfiotUEqwFvpzajI
7ixAnGhfvIHQKsCTe4ATMzstQLb0N91BYivAyg0zfp2HLUC9oP5ZxvIrwAGg
5egH1C1AJ3X9FnaBLMCkknpK
       "]]}, {}}, {{}, {}, 
     {Hue[0.66], LineBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA3kZv+VJnHkDVkjiTyxUQQE1r1M4n
AB9AzM5m1sss97+7jzmk/JgfQJ3837NbtvG/FVrPvOgYIEASSfEAkiUCQEzs
gSdTZSBAePCBcop7BsCDfjSSvbEgQPWmoyhEWgFAuhDn/Cf+IEAt6TGba6v+
v/KimWeSSiFAeNRV+rPr8r8pNUzS/JYhQGFIpCMp+wfAYMf+PGfjIUAiJNOP
/cAKwJdZsafRLyJARuT8gcYf+b/P62MSPHwiQBURR+imxxHABn4WfabIIkDl
D54gYSX/vz0QyecQFSNAnOk7xFCmBMB0ontSe2EjQMQSnyWN+wfAqzQuveWt
I0DzZLtxLYwOwOPG4CdQ+iNAIKA31onICMAaWZOSukYkQM8VMksB+gPAUetF
/SSTJECG5tfLe4gJwIh9+GeP3yRAIh71gBR2BcDAD6vS+SslQBriH/Y09wnA
96FdPWR4JUBBkoAJKWgJwC40EKjOxCVAYe3/r8Z6FsBlxsISOREmQDRIaDoO
sBHAnFh1faNdJkBRFNoX1cATwNTqJ+gNqiZAjMXhk9YME8ALfdpSePYmQNB/
G2OAmBHAQg+NveJCJ0C0VYKgRaQYwHmhPyhNjydAcOj/35mhFcCxM/KSt9sn
QOLzoIlCeBDA6MWk/SEoKEAPDHeu7/UQwB9YV2iMdChAKE3ScuTUFsBW6gnT
9sAoQHvivtzLXRXAjXy8PWENKUAhgG+2dE4YwMUOb6jLWSlAZ5jwuAU3GMD8
oCETNqYpQAP0A4lYCR3AMzPUfaDyKUAQGSZks+4ewGrFhugKPypAxtGnStIa
G8CiVzlTdYsqQPHbXrcmeiLA2enrvd/XKkDNB9t7ZyYgwBB8nihKJCtAtwZs
i2TIIsBHDlGTtHArQAT0aMCobibAf6AD/h69K0DeOfgZH6UlwLYytmiJCSxA
hMys9d/HKMDtxGjT81UsQAHoducNfCnAJFcbPl6iLEAucfiotUEqwFvpzajI
7ixAnGhfvIHQKsCTe4ATMzstQLb0N91BYivAyg0zfp2HLUC9oP5ZxvIrwAGg
5egH1C1AJ3X9FnaBLMCkknpK
       "]]}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"sr [-]\"", TraditionalForm], 
    FormBox["\"err [%]\"", TraditionalForm]},
  AxesOrigin->{7.600902459542082, -14.528812737937413`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.4849066497880004`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\"\"", TraditionalForm]}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.4849066497880004`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {8.517193191416238, 
       FormBox["5000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"1", 
          
          TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {10.819778284410283`, 
       FormBox[
        TemplateBox[{"5", 
          
          TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"1", 
          
          TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {13.122363377404328`, 
       FormBox[
        TemplateBox[{"5", 
          
          TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TemplateBox[{"1", 
          
          TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {15.424948470398375`, 
       FormBox[
        TemplateBox[{"5", 
          
          TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
           SuperscriptBox]}, "Row", 
         DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
         InterpretationFunction -> (RowBox[{"Row", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )],
         TraditionalForm]}, {7.600902459542082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {8.517193191416238, 
       FormBox["\"\"", TraditionalForm]}, {9.210340371976184, 
       FormBox["\"\"", TraditionalForm]}, {10.819778284410283`, 
       FormBox["\"\"", TraditionalForm]}, {11.512925464970229`, 
       FormBox["\"\"", TraditionalForm]}, {13.122363377404328`, 
       FormBox["\"\"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {15.424948470398375`, 
       FormBox["\"\"", TraditionalForm]}, {7.600902459542082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{{6.907755278982137, 8.517193191416238, 9.210340371976184, 
    10.819778284410283`, 11.512925464970229`, 13.122363377404328`, 
    13.815510557964274`, 15.424948470398375`, 7.600902459542082, 
    8.006367567650246, 8.294049640102028, 8.699514748210191, 8.85366542803745,
     8.987196820661973, 9.104979856318357, 9.903487552536127, 
    10.308952660644293`, 10.596634733096073`, 11.002099841204238`, 
    11.156250521031495`, 11.289781913656018`, 11.407564949312402`, 
    12.206072645530174`, 12.611537753638338`, 12.89921982609012, 
    13.304684934198283`, 13.458835614025542`, 13.592367006650065`, 
    13.710150042306449`, 14.508657738524219`, 14.914122846632385`, 
    15.201804919084164`}, {-13.815510557964274`, -9.210340371976182, \
-4.605170185988091, 0., 
    4.605170185988092, -11.330603908176274`, -10.680016342035124`, \
-10.289150033348113`, -10.008848068193954`, -9.790158867229126, \
-9.610817938573309, -9.458801731274683, -9.326874188232134, \
-6.725433722188183, -6.074846156047033, -5.683979847360021, \
-5.403677882205863, -5.184988681241033, -5.005647752585217, \
-4.853631545286591, -4.721704002244043, -2.120263536200091, \
-1.4696759700589417`, -1.07880966137193, -0.7985076962177716, \
-0.579818495252942, -0.40047756659712525`, -0.2484613592984996, \
-0.11653381625595151`, 2.4849066497880004`, 3.1354942159291497`, 
    3.5263605246161616`, 3.8066624897703196`, 4.02535169073515, 
    4.204692619390966, 4.356708826689592, 4.48863636973214}},
  Method->{},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{{{6.907755278982137, 
      FormBox["1000", TraditionalForm]}, {8.517193191416238, 
      FormBox["5000", TraditionalForm]}, {9.210340371976184, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {10.819778284410283`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {11.512925464970229`, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {13.122363377404328`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {13.815510557964274`, 
      FormBox[
       TemplateBox[{"1", 
         TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {15.424948470398375`, 
      FormBox[
       TemplateBox[{"5", 
         TemplateBox[{"10", "6"}, "Superscript", SyntaxForm -> 
          SuperscriptBox]}, "Row", 
        DisplayFunction -> (RowBox[{#, "\[Times]", #2}]& ), 
        InterpretationFunction -> (RowBox[{"Row", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{#, ",", #2}], "}"}], ",", "\"\[Times]\""}], "]"}]& )], 
       TraditionalForm]}, {7.600902459542082, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.006367567650246, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.294049640102028, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.699514748210191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.85366542803745, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.987196820661973, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {9.104979856318357, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {9.903487552536127, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {10.308952660644293`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {10.596634733096073`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {11.002099841204238`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {11.156250521031495`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {11.289781913656018`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {11.407564949312402`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {12.206072645530174`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {12.611537753638338`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {12.89921982609012, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.304684934198283`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.458835614025542`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.592367006650065`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.710150042306449`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {14.508657738524219`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {14.914122846632385`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {15.201804919084164`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-13.815510557964274`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {4.605170185988092, 
      FormBox["100", TraditionalForm]}, {-11.330603908176274`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.680016342035124`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.289150033348113`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.008848068193954`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.790158867229126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.610817938573309, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.458801731274683, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.326874188232134, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.725433722188183, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.074846156047033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.683979847360021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.403677882205863, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.184988681241033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.005647752585217, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.853631545286591, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.721704002244043, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.120263536200091, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.4696759700589417`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.07880966137193, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.7985076962177716, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.579818495252942, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.40047756659712525`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2484613592984996, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.11653381625595151`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.4849066497880004`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.1354942159291497`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.5263605246161616`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.8066624897703196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.02535169073515, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.204692619390966, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.356708826689592, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.48863636973214, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{3.725687731234375*^9, 3.725687851875*^9, 
  3.725688034796875*^9, 3.725692836140625*^9, 3.72569730403125*^9, 
  3.72569736896875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<grafik.png\>\"", ",", "grafik", ",", 
   RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.725687881546875*^9, 3.725687884484375*^9}, {
  3.72568793053125*^9, 3.72568795084375*^9}}],

Cell[BoxData["\<\"grafik.png\"\>"], "Output",
 CellChangeTimes->{3.725687953609375*^9, 3.72568803565625*^9, 
  3.72569283703125*^9, 3.725697369796875*^9}]
}, Open  ]]
},
WindowSize->{1041, 796},
WindowMargins->{{1, Automatic}, {Automatic, 2}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
Magnification->1.6000001430511475`,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 518, 14, 131, "Input"],
Cell[1078, 36, 328, 8, 46, "Input"],
Cell[CellGroupData[{
Cell[1431, 48, 4775, 109, 669, "Input"],
Cell[6209, 159, 65160, 1074, 389, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71406, 1238, 6754, 168, 676, "Input"],
Cell[78163, 1408, 115667, 1920, 431, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193867, 3333, 980, 23, 103, "Input"],
Cell[194850, 3358, 100211, 1649, 389, "Output"],
Cell[295064, 5009, 202, 3, 45, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295303, 5017, 868, 21, 131, "Input"],
Cell[296174, 5040, 71622, 1180, 389, "Output"],
Cell[367799, 6222, 167, 2, 45, "Output"]
}, Open  ]],
Cell[367981, 6227, 2995, 55, 219, "Input"],
Cell[370979, 6284, 6051, 160, 835, "Input"],
Cell[377033, 6446, 118, 2, 46, "Input"],
Cell[377154, 6450, 5014, 126, 747, "Input"],
Cell[382171, 6578, 878, 24, 103, "Input"],
Cell[CellGroupData[{
Cell[383074, 6606, 6352, 161, 927, "Input"],
Cell[389429, 6769, 34997, 678, 373, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[424463, 7452, 273, 5, 46, "Input"],
Cell[424739, 7459, 154, 2, 45, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
