(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      5710,        190]
NotebookOptionsPosition[      5236,        170]
NotebookOutlinePosition[      5698,        188]
CellTagsIndexPosition[      5655,        185]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 ExpressionUUID -> "c1754577-7b23-450e-91b5-9be5e68cd5db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "100."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"20", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"314.", "t"}], "+", "0123"}], "]"}]}], "+", 
    RowBox[{"10", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3", "*", "314", "t"}], "+", "0.569"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"R", "*", 
        RowBox[{"i", "[", "t", "]"}]}], "+", 
       RowBox[{"L", "*", 
        RowBox[{
         RowBox[{"i", "'"}], "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"i", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "0.08"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "'"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"u", "[", "t", "]"}], ",", 
        RowBox[{"i", "[", "t", "]"}]}], "}"}], "/.", "sol"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "tmax", ",", 
       FractionBox["tmax", "100"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<data1.csv\>\"", ",", "data"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<data1.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intU", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "u"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intI", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "i"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"intI", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.844916684265625*^9, 3.8449167313125*^9}, {
  3.8449167655625*^9, 3.84491681884375*^9}, {3.844916850265625*^9, 
  3.844916943640625*^9}, {3.84491701015625*^9, 3.84491709896875*^9}, {
  3.844917129171875*^9, 3.844917234640625*^9}, {3.8449174796875*^9, 
  3.84491773346875*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.08`"}], "}"}]], "Output",
 CellChangeTimes->{{3.844917676453125*^9, 3.84491773121875*^9}}]
}, Open  ]]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification->2.000000238418579,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1245, 36, 296, "Input"],
Cell[CellGroupData[{
Cell[1827, 60, 3246, 102, 501, "Input"],
Cell[5076, 164, 144, 3, 83, "Output"]
}, Open  ]]
}
]
*)

