(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13260,        392]
NotebookOptionsPosition[     12090,        364]
NotebookOutlinePosition[     12539,        381]
CellTagsIndexPosition[     12496,        378]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"053d72f5-cf9f-484b-975e-088b45b70d77"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "200."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "5"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"20", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"314.", "t"}], "+", "0123"}], "]"}]}], "+", 
    RowBox[{"10", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3", "*", "314", "t"}], "+", "0.569"}], "]"}]}], "+", 
    RowBox[{"5", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"5", "*", "314", "t"}], "+", "1.569"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"i", "[", "t_", "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"u", "[", "t", "]"}], "R"], "+", 
    RowBox[{"c", "*", 
     RowBox[{
      RowBox[{"u", "'"}], "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tmax", "=", "0.08"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"u", "[", "t", "]"}], ",", 
       RowBox[{"i", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "tmax", ",", 
       FractionBox["tmax", "2500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<dataUI.csv\>\"", ",", "data"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<dataUI.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intU", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "u"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intI", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "i"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"intI", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataProFit", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"intU", "[", "t", "]"}], ",", 
       RowBox[{
        RowBox[{"intU", "'"}], "[", "t", "]"}], ",", 
       RowBox[{"intI", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "tmax", ",", 
       FractionBox["tmax", "500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Fit", "[", 
  RowBox[{"dataProFit", ",", 
   RowBox[{"{", 
    RowBox[{"uu", ",", "deru"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"uu", ",", "deru"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.844916684265625*^9, 3.8449167313125*^9}, {
  3.8449167655625*^9, 3.84491681884375*^9}, {3.844916850265625*^9, 
  3.844916943640625*^9}, {3.84491701015625*^9, 3.84491709896875*^9}, {
  3.844917129171875*^9, 3.844917234640625*^9}, {3.8449174796875*^9, 
  3.84491773346875*^9}, {3.8456051280135536`*^9, 3.845605388999177*^9}, {
  3.845605439409227*^9, 3.8456054926935973`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"da8ec300-268e-48ad-9605-6d170e285630"],

Cell[BoxData[
 RowBox[{
  RowBox[{"9.999999264366433`*^-6", " ", "deru"}], "+", 
  RowBox[{"0.0050000014681183`", " ", "uu"}]}]], "Output",
 CellChangeTimes->{
  3.845605390061395*^9, {3.845605440393366*^9, 3.84560549420883*^9}, 
   3.845608112578936*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"f1373d17-cb99-44ca-80ba-513a8ecd157d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matRozsirena", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matice", "=", 
   RowBox[{
    RowBox[{"Drop", "[", 
     RowBox[{
      RowBox[{"matRozsirena", "\[Transpose]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "\[Transpose]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"praveStrany", "=", 
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"matRozsirena", "\[Transpose]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{"matice", ",", "praveStrany"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<matRozsirena.csv\>\"", ",", "matRozsirena"}], "]"}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Max", "[", "sol", "]"}], ",", 
   RowBox[{"Min", "[", "sol", "]"}], ",", 
   RowBox[{"Mean", "[", "sol", "]"}], ",", 
   RowBox[{"Variance", "[", "sol", "]"}]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8456055060967045`*^9, 3.845605738807718*^9}, {
  3.8456081351711416`*^9, 3.8456081776525817`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"30b1cd49-4da5-489b-9fb5-489e46fb5c89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0365792684125281`", ",", 
   RowBox[{"-", "1.0650382824938842`"}], ",", "0.010965308834503867`", ",", 
   "0.16291552146588287`"}], "}"}]], "Output",
 CellChangeTimes->{{3.8456055574283686`*^9, 3.845605740401145*^9}, 
   3.845608113360135*^9, {3.8456081451860847`*^9, 3.845608178199404*^9}},
 CellLabel->"Out[60]=",ExpressionUUID->"7205de1a-8d10-4aa8-bedc-7a876a1e17b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "=", "1"}], ";", 
  RowBox[{"X1", "=", "3"}], ";", 
  RowBox[{"R2", "=", "2"}], ";", 
  RowBox[{"X2", "=", "2"}], ";", 
  RowBox[{"U", "=", "230"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i1", "=", 
   FractionBox["230", 
    RowBox[{"R1", "+", 
     RowBox[{"I", "*", "X1"}], "+", "Rz1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i2", "=", 
   FractionBox["230", 
    RowBox[{"R2", "+", 
     RowBox[{"I", "*", "X2"}], "+", "Rz2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pchceme", "=", "2000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{
    RowBox[{"Rz1", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], "+", 
    RowBox[{"Rz2", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{
    RowBox[{"X1", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], "+", 
    RowBox[{"X2", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "vys"}], "}"}], "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Q", ",", 
      RowBox[{"P", "\[Equal]", "Pchceme"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Rz1", ",", "Rz2"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<DifferentialEvolution\>\""}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"P", ",", 
    RowBox[{"Rz1", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], ",", 
    RowBox[{"R1", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i1", "]"}], "2"]}], ",", 
    RowBox[{"Rz2", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}], ",", 
    RowBox[{"R2", "*", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "i2", "]"}], "2"]}], ",", "i1", ",", "i2", ",", 
    RowBox[{"Abs", "[", "i1", "]"}], ",", 
    RowBox[{"Abs", "[", "i2", "]"}]}], "}"}], "/.", 
  "vys"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.845608238757736*^9, 3.845608442181184*^9}, {
  3.8456085348622813`*^9, 3.845608593045762*^9}, {3.8456086271684055`*^9, 
  3.8456086688374014`*^9}, {3.8456114314189396`*^9, 3.845611477197027*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"c5c19204-afb1-4eef-b7cc-f30f2e50bafc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11043.907586072477`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rz1", "\[Rule]", "2.1485293348684467`*^7"}], ",", 
     RowBox[{"Rz2", "\[Rule]", "0.36219019803700575`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.845608443196723*^9, {3.845608536721511*^9, 3.8456085942019157`*^9}, {
   3.8456086307306423`*^9, 3.845608669727948*^9}, 3.8456114357311153`*^9, 
   3.8456114779000773`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"a8022949-f593-451f-b5a9-9472118ec0ba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1999.9999999999998`", ",", "0.002462149071794719`", ",", 
   "1.1459694926369135`*^-10", ",", "1999.997537850928`", ",", 
   "11043.907586072133`", ",", 
   RowBox[{"0.000010704996462572472`", "\[VeryThinSpace]", "-", 
    RowBox[{"1.4947428164829307`*^-12", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"56.71263097357853`", "\[VeryThinSpace]", "-", 
    RowBox[{"48.016989504661446`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.000010704996462572576`", ",", "74.30984990589113`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.845608443196723*^9, {3.845608536721511*^9, 3.8456085942019157`*^9}, {
   3.8456086307306423`*^9, 3.845608669727948*^9}, 3.8456114357311153`*^9, 
   3.8456114779000773`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"2c87559b-57c2-4760-9580-4e32d49aad57"]
}, Open  ]]
},
WindowSize->{1068, 738},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>1.8 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1264, 36, 289, "Input",ExpressionUUID->"053d72f5-cf9f-484b-975e-088b45b70d77"],
Cell[CellGroupData[{
Cell[1847, 60, 3738, 114, 712, "Input",ExpressionUUID->"da8ec300-268e-48ad-9605-6d170e285630"],
Cell[5588, 176, 334, 7, 58, "Output",ExpressionUUID->"f1373d17-cb99-44ca-80ba-513a8ecd157d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5959, 188, 1876, 56, 357, "Input",ExpressionUUID->"30b1cd49-4da5-489b-9fb5-489e46fb5c89"],
Cell[7838, 246, 412, 7, 58, "Output",ExpressionUUID->"7205de1a-8d10-4aa8-bedc-7a876a1e17b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8287, 258, 2441, 72, 468, "Input",ExpressionUUID->"c5c19204-afb1-4eef-b7cc-f30f2e50bafc"],
Cell[10731, 332, 527, 12, 63, "Output",ExpressionUUID->"a8022949-f593-451f-b5a9-9472118ec0ba"],
Cell[11261, 346, 813, 15, 170, "Output",ExpressionUUID->"2c87559b-57c2-4760-9580-4e32d49aad57"]
}, Open  ]]
}
]
*)

