(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35800,       1042]
NotebookOptionsPosition[     32352,        978]
NotebookOutlinePosition[     32833,        996]
CellTagsIndexPosition[     32790,        993]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 
  3.676092822828125*^9}},ExpressionUUID->"a0728aa4-f8eb-4a24-a91f-\
a96dae15df4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", "*", "x"}], "+", 
        RowBox[{"b", "*", "y"}]}], "\[Equal]", "p1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "*", "x"}], "+", 
        RowBox[{"d", "*", "y"}]}], "\[Equal]", "p2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.676097044546875*^9, 
  3.67609706796875*^9}},ExpressionUUID->"2ead09d2-f75f-414c-96e2-\
579cb9c1cbe1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"d", " ", "p1"}], "-", 
        RowBox[{"b", " ", "p2"}]}], 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}]]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", "p1"}], "+", 
        RowBox[{"a", " ", "p2"}]}], 
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.809752104059058*^9},ExpressionUUID->"33cc121f-f6cd-451b-88cc-\
1bf8af8b8696"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat1", "=", 
   RowBox[{"(", GridBox[{
      {"5", "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMat1", "=", 
   RowBox[{"Det", "[", "mat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<determinant= \>\"", ",", "detMat1"}], "]"}]}], "Input",
 CellChangeTimes->{{3.676092443*^9, 3.676092455296875*^9}, {
  3.676092486734375*^9, 3.676092564375*^9}, {3.6760926228125*^9, 
  3.676092638515625*^9}, {3.6760962355*^9, 
  3.676096249375*^9}},ExpressionUUID->"51749cab-e6c2-4102-b5e7-a2fdf867b14d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"determinant= \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["determinant= ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8097521040968113`*^9},ExpressionUUID->"4af5c2e8-c757-4b1e-b2e4-\
5b1ade613383"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "mat1", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"odhadMaxDet", "=", 
     RowBox[{
      SqrtBox[
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         RowBox[{"i", "=", "1"}], "n"], 
        RowBox[{"(", 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"j", "=", "1"}], "n"], 
          SuperscriptBox[
           RowBox[{"Abs", "[", 
            RowBox[{"mat1", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}], "2"]}], ")"}]}]], 
      "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<maximalni hodnota determinantu: \>\"", ",", "odhadMaxDet"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.676095958703125*^9, {3.67609601296875*^9, 3.676096018296875*^9}, {
   3.67609606778125*^9, 
   3.676096231953125*^9}},ExpressionUUID->"8d3bb934-de36-47d5-a303-\
da8193352bd3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"maximalni hodnota determinantu: \"\>", "\[InvisibleSpace]", 
   "50343.1956673392`"}],
  SequenceForm["maximalni hodnota determinantu: ", 50343.1956673392],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8097521041436777`*^9},ExpressionUUID->"e80849b2-7471-465b-8166-\
b67b5a0c39a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"detMat2", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.67609263334375*^9, 3.6760926529375*^9}, {
  3.676092730828125*^9, 
  3.67609274709375*^9}},ExpressionUUID->"449f7501-fbf7-486c-a6cc-\
208ecfe1a139"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"68", " ", "\[Epsilon]"}]}]], "Output",
 CellChangeTimes->{
  3.8097521041592994`*^9},ExpressionUUID->"e9bca537-a9f4-4c43-9e2b-\
95661653a2f1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"invEps", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"Inverse", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"invEps", "[", "\[Epsilon]", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.676092752921875*^9, 
  3.676092835140625*^9}},ExpressionUUID->"022fc151-8e60-418b-8083-\
a6003a0d0989"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["68", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"25", "+", 
        RowBox[{"19", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"5", "+", 
        RowBox[{"51", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"36", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8097521041970606`*^9},ExpressionUUID->"77ad2ae0-c50c-4831-b867-\
c5591f755b49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"LinearSolve", "::", "\"\<luc\>\""}], ",", 
   RowBox[{"RowReduce", "::", "\"\<luc\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"mat2", "[", 
     FractionBox[
      RowBox[{"-", "1"}], 
      RowBox[{"68", "-", 
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]]}]], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xPresne", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solSol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"A", ".", 
        RowBox[{"(", 
         RowBox[{"xvect", "=", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", "#"], "&"}], "/@", 
           RowBox[{"Range", "[", "n", "]"}]}]}], ")"}]}], "\[Equal]", "b"}], 
      "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"errVect1", "=", 
  RowBox[{
   RowBox[{"A", ".", "xPresne"}], "-", "b"}]}], "\[IndentingNewLine]", 
 RowBox[{"errVect2", "=", 
  RowBox[{
   RowBox[{"A", ".", 
    RowBox[{"(", 
     RowBox[{"xvect", "/.", "solSol"}], ")"}]}], "-", 
   "b"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6760977475*^9, 
  3.676098134625*^9}},ExpressionUUID->"9a09cb9f-78c5-47ff-aeac-8f4f87b69842"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.009765625`", ",", 
   RowBox[{"-", "0.015625`"}], ",", "0.01171875`", ",", "0.01171875`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.809752104243929*^9},ExpressionUUID->"ccdcf302-9d90-43fe-8909-\
bb76952eb5df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.001953125`", ",", "0.0234375`", ",", "0.0234375`", ",", "0.01171875`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8097521042595496`*^9},ExpressionUUID->"36bc319a-141f-4192-af85-\
955b832e8182"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"prosta", " ", "iterace"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "=", ".025"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{
      RowBox[{"k", "*", 
       RowBox[{"(", GridBox[{
          {"20", "3", "4"},
          {"3", "44", "5"},
          {"1", "2", "50"}
         }], ")"}]}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"k", "*", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Norm", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], 
         ")"}]}], ")"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.67609936765625*^9, 3.67609937503125*^9}, {
   3.6761003179375*^9, 3.676100349453125*^9}, {3.676101115875*^9, 
   3.676101202046875*^9}, {3.676269990734375*^9, 3.676270011984375*^9}, {
   3.67627087578125*^9, 3.676270967140625*^9}, {3.676271000078125*^9, 
   3.676271025171875*^9}, 3.676271086921875*^9, {3.676273503703125*^9, 
   3.67627350975*^9}},ExpressionUUID->"a57915d9-9159-4ddf-a0f5-1a3f82920772"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Jacobi", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", 
          RowBox[{"3", "+", "I"}], "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LinearSolve", "[", 
     RowBox[{"Aorig", ",", "borig"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Norm", "/@", "%"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.676105032961247*^9, 3.676105075961247*^9}, {
   3.676105114054997*^9, 3.676105206804997*^9}, {3.676105245633122*^9, 
   3.676105245883122*^9}, {3.676105350539372*^9, 3.676105397804997*^9}, {
   3.676105497039372*^9, 3.676105542664372*^9}, 3.676269892203125*^9, {
   3.676270187109375*^9, 3.676270188421875*^9}, {3.676270266546875*^9, 
   3.676270275953125*^9}, {3.67627043290625*^9, 3.6762704591875*^9}, {
   3.67627069090625*^9, 3.67627069184375*^9}, {3.67627073290625*^9, 
   3.676270769328125*^9}, {3.676270799515625*^9, 3.67627080465625*^9}, {
   3.676270842046875*^9, 3.6762708435*^9}, {3.676271017640625*^9, 
   3.676271084125*^9}, 3.67627133303125*^9, {3.6762713951875*^9, 
   3.676271416734375*^9}},ExpressionUUID->"5b03e942-b6b3-43ba-a710-\
02b2f09233ea"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.676270323859375*^9, 3.676270328109375*^9}, 
   3.6762704955*^9},ExpressionUUID->"1d339204-719f-4a1f-99a1-47054b02bf9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Seidel", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", "3", "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "x_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xn", ",", "xp"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"xn", "=", "x"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"xp", "=", 
            RowBox[{
             RowBox[{"Cmat", ".", "xn"}], "+", "b"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", 
            RowBox[{"xp", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "xn"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Norm", "/@", "%"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.676271376046875*^9, 3.6762713814375*^9}, 
   3.676271424046875*^9, {3.676273062046875*^9, 3.6762730915*^9}, {
   3.676273151359375*^9, 3.67627315178125*^9}, {3.676273268609375*^9, 
   3.676273317328125*^9}, {3.67627336390625*^9, 3.676273495640625*^9}, 
   3.67739442165625*^9},ExpressionUUID->"cceaa29c-949f-481c-8650-\
d62ed28079e5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 0.07599974697132941}, {2., 0.017916460000937523`}, {3., 
      0.0007091897729583686}, {4., 0.000018589452804575432`}, {5., 
      1.0586571109905757`*^-7}, {6., 
      4.566372830582151*^-9}}]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.921875, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1., 6.}, {0, 0.07599974697132941}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8097521045290337`*^9},ExpressionUUID->"931529e5-5ca4-47f4-b879-\
b417b43be676"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "podivejme", " ", "se", " ", "pomoci", " ", "experimentalni", " ", 
    "matematiky", " ", "na", " ", "vlastni", " ", "cisla", " ", "matic"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "aijMax"}], ",", "aijMax"}], "}"}], "]"}], "&"}], 
        "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "rnm"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{
      RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Abs", "/@", "lambdas"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"vectors", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "dejSouradniceVBaziEigenvectors", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eqns", ",", "lambdas", ",", "\[Lambda]"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lambdas", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "rnm", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"lambdas", "/.", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"lambdas", ".", "vectors"}], "\[Equal]", "vect"}], 
             "]"}], ",", "lambdas"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"dejSouradniceVBaziEigenvectors", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.684507384390625*^9, 3.68450773*^9}, {
   3.68450779615625*^9, 3.684507854296875*^9}, {3.68450790325*^9, 
   3.6845079044375*^9}, {3.684508081984375*^9, 3.684508368984375*^9}, 
   3.684508414421875*^9, {3.6845084795625*^9, 3.68450851825*^9}, {
   3.68450857453125*^9, 3.684508605921875*^9}, {3.684508672890625*^9, 
   3.6845087789375*^9}, {3.68450897421875*^9, 3.684509153671875*^9}, {
   3.684509196234375*^9, 3.684509237*^9}, {3.684509268375*^9, 
   3.68450931365625*^9}, {3.68450934990625*^9, 3.68450942665625*^9}, {
   3.68450971296875*^9, 
   3.684509714515625*^9}},ExpressionUUID->"9b0960a1-890d-4137-950b-\
db5f1305a829"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.036979223999276`"}], "+", 
    RowBox[{"0.8082438377411559`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.036979223999276`"}], "-", 
    RowBox[{"0.8082438377411556`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"2.3071796616215448`", "\[VeryThinSpace]", "+", 
    RowBox[{"1.9915431685917802`*^-17", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8097521052309694`*^9},ExpressionUUID->"f53bb4ce-248d-4dfd-b521-\
9fd5287595d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vect", "=", 
   RowBox[{"{", 
    RowBox[{"0.256", ",", 
     RowBox[{"2", "-", "I"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect", "]"}], "[", 
     RowBox[{"[", "#", "]"}], "]"}], "*", 
    RowBox[{"vectors", "[", 
     RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", 
  RowBox[{"Range", "[", "rnm", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Chop", "/@", 
  RowBox[{"Plus", "@@", "%"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", "vect"}]}], "Input",
 CellChangeTimes->{{3.68450947375*^9, 3.684509501859375*^9}, {
  3.684509542625*^9, 
  3.684509641359375*^9}},ExpressionUUID->"b35751b4-21c4-41cc-8e7b-\
5ce54e5c3e0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.24676601695390593`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7428570279407504`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9668617116740595`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7540840749362827`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.4658824366845648`"}], "+", 
      RowBox[{"2.2795458511932924`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.3283872172922857`"}], "-", 
      RowBox[{"1.450598569152314`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.8317576417504466`", "\[VeryThinSpace]", "-", 
      RowBox[{"2.176230104376008`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2.996984210226755`"}], "-", 
      RowBox[{"3.249834309773856`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.3376212003383801`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7077415412115641`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.201380646575494`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.4221460294397259`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.4628666469113203`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.970288458580564`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8097521052465916`*^9},ExpressionUUID->"03fc3baf-6606-4e7d-9716-\
d82bf80b90b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25600000000000034`", ",", 
   RowBox[{"2.`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.9999999999999996`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "2.999999999999999`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8097521052622128`*^9},ExpressionUUID->"aab6929a-8e4f-4cc9-aca9-\
c68a47e6e29c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.3306690738754696`*^-16", ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"4.440892098500626`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   "8.881784197001252`*^-16"}], "}"}]], "Output",
 CellChangeTimes->{
  3.809752105277834*^9},ExpressionUUID->"013b2356-7e91-4b0d-bc60-\
5e6754b7f8de"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.6845118365*^9},ExpressionUUID->"72f5096d-b337-4ac5-8749-d164d23bf50e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]AbsMax", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "/@", "lambdas"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ratio", "[", 
     RowBox[{"exp_Integer", ",", "vect_List"}], "]"}], ":=", 
    FractionBox[
     RowBox[{"Norm", "@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"MatrixPower", "[", 
          RowBox[{"A", ",", "exp"}], "]"}], ".", "vect"}], "//", "N"}], 
       ")"}]}], 
     RowBox[{
      SuperscriptBox["\[Lambda]AbsMax", "exp"], "*", 
      RowBox[{"Norm", "[", "vect", "]"}]}]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"upravit", ",", " ", "opravit"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ratio", "[", 
  RowBox[{"17", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.684511345484375*^9, 3.684511406640625*^9}, {
  3.68451144090625*^9, 3.68451158309375*^9}, {3.684511613421875*^9, 
  3.684511637609375*^9}, {3.68451176071875*^9, 3.684511765421875*^9}, {
  3.684511799625*^9, 3.684511828953125*^9}, {3.68451190390625*^9, 
  3.68451192446875*^9}, {3.684570222828125*^9, 
  3.684570300265625*^9}},ExpressionUUID->"69c264ba-13fb-435d-a130-\
95c4a7c93a92"],

Cell[BoxData["0.4148325433112122`"], "Output",
 CellChangeTimes->{
  3.809752105315587*^9},ExpressionUUID->"ceb98d2c-a8ed-45ac-a816-\
9bef924fde3c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"en", ".", "wikipedia", ".", "org"}], "/", "wiki"}], "/", 
     "Square_root"}], "_of", "_a", "_matrix"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.68457101390625*^9, 
  3.684571016109375*^9}},ExpressionUUID->"9e1225d0-b165-4331-ba8e-\
9ec9a4e1da09"]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 582, 16, 136, "Input",ExpressionUUID->"a0728aa4-f8eb-4a24-a91f-a96dae15df4c"],
Cell[CellGroupData[{
Cell[1152, 40, 587, 18, 76, "Input",ExpressionUUID->"2ead09d2-f75f-414c-96e2-579cb9c1cbe1"],
Cell[1742, 60, 726, 25, 80, "Output",ExpressionUUID->"33cc121f-f6cd-451b-88cc-1bf8af8b8696"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2505, 90, 689, 17, 189, "Input",ExpressionUUID->"51749cab-e6c2-4102-b5e7-a2fdf867b14d"],
Cell[3197, 109, 266, 7, 34, "Print",ExpressionUUID->"4af5c2e8-c757-4b1e-b2e4-5b1ade613383"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3500, 121, 1048, 30, 216, "Input",ExpressionUUID->"8d3bb934-de36-47d5-a303-da8193352bd3"],
Cell[4551, 153, 339, 8, 34, "Print",ExpressionUUID->"e80849b2-7471-465b-8166-b67b5a0c39a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4927, 166, 599, 17, 159, "Input",ExpressionUUID->"449f7501-fbf7-486c-a6cc-208ecfe1a139"],
Cell[5529, 185, 187, 5, 51, "Output",ExpressionUUID->"e9bca537-a9f4-4c43-9e2b-95661653a2f1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5753, 195, 418, 11, 76, "Input",ExpressionUUID->"022fc151-8e60-418b-8083-a6003a0d0989"],
Cell[6174, 208, 3042, 96, 209, "Output",ExpressionUUID->"77ad2ae0-c50c-4831-b867-c5591f755b49"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9253, 309, 1545, 47, 299, "Input",ExpressionUUID->"9a09cb9f-78c5-47ff-aeac-8f4f87b69842"],
Cell[10801, 358, 256, 7, 51, "Output",ExpressionUUID->"ccdcf302-9d90-43fe-8909-bb76952eb5df"],
Cell[11060, 367, 242, 7, 51, "Output",ExpressionUUID->"36bc319a-141f-4192-af85-955b832e8182"]
}, Open  ]],
Cell[11317, 377, 2542, 70, 472, "Input",ExpressionUUID->"a57915d9-9159-4ddf-a0f5-1a3f82920772"],
Cell[13862, 449, 3829, 108, 627, "Input",ExpressionUUID->"5b03e942-b6b3-43ba-a710-02b2f09233ea"],
Cell[17694, 559, 168, 2, 45, "Input",ExpressionUUID->"1d339204-719f-4a1f-99a1-47054b02bf9e"],
Cell[CellGroupData[{
Cell[17887, 565, 4012, 118, 837, "Input",ExpressionUUID->"cceaa29c-949f-481c-8650-d62ed28079e5"],
Cell[21902, 685, 1432, 39, 387, "Output",ExpressionUUID->"931529e5-5ca4-47f4-b879-b417b43be676"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23371, 729, 3443, 88, 616, "Input",ExpressionUUID->"9b0960a1-890d-4137-950b-db5f1305a829"],
Cell[26817, 819, 544, 14, 57, "Output",ExpressionUUID->"f53bb4ce-248d-4dfd-b521-9fd5287595d6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27398, 838, 792, 22, 166, "Input",ExpressionUUID->"b35751b4-21c4-41cc-8e7b-5ce54e5c3e0b"],
Cell[28193, 862, 1457, 33, 112, "Output",ExpressionUUID->"03fc3baf-6606-4e7d-9716-d82bf80b90b7"],
Cell[29653, 897, 343, 8, 51, "Output",ExpressionUUID->"aab6929a-8e4f-4cc9-aca9-c68a47e6e29c"],
Cell[29999, 907, 339, 8, 57, "Output",ExpressionUUID->"013b2356-7e91-4b0d-bc60-5e6754b7f8de"]
}, Open  ]],
Cell[30353, 918, 140, 2, 76, "Input",ExpressionUUID->"72f5096d-b337-4ac5-8749-d164d23bf50e"],
Cell[CellGroupData[{
Cell[30518, 924, 1285, 33, 184, "Input",ExpressionUUID->"69c264ba-13fb-435d-a130-95c4a7c93a92"],
Cell[31806, 959, 148, 3, 51, "Output",ExpressionUUID->"ceb98d2c-a8ed-45ac-a816-9bef924fde3c"]
}, Open  ]],
Cell[31969, 965, 379, 11, 45, "Input",ExpressionUUID->"9e1225d0-b165-4331-ba8e-9ec9a4e1da09"]
}
]
*)

