(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40908,        817]
NotebookOptionsPosition[     38940,        778]
NotebookOutlinePosition[     39387,        795]
CellTagsIndexPosition[     39344,        792]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Prost\[AAcute] iterace = Cobweb Diagram", "Subtitle",ExpressionUUID->"0bc2d523-d9ad-4e99-856a-4f72543c151a"],

Cell["The iteration process:", "MainSection",ExpressionUUID->"f77198fc-74ae-48c3-b47e-7227b681bddd"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["x", "0"], ";", " ", 
   RowBox[{
    SubscriptBox["x", "1"], "=", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "0"], ")"}]}], ";", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["x", "2"], "=", 
      RowBox[{"f", "(", 
       SubscriptBox["x", "1"], ")"}]}], ";"}], " ", "..."}], " ", ";", " ", 
   RowBox[{
    SubscriptBox["x", 
     RowBox[{"n", "+", "1"}]], "=", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "n"], ")"}], " "}]}], 
  TraditionalForm]],ExpressionUUID->"8e30fc77-790b-4a43-a37a-3913d91566e8"]], \
"TextBox",
 CellMargins->{{70, 207}, {Inherited, Inherited}},
 TextAlignment->Center,
 TextJustification->0,ExpressionUUID->"af2b640c-3a69-409d-9d72-c2704bfeb8a7"],

Cell[TextData[{
 "Definition and the plot of  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]],ExpressionUUID->
  "3e0235b2-5b8d-4a16-8079-b5b9a8ce0f4c"]
}], "MainSection",ExpressionUUID->"263c7695-2b0e-4db5-b7de-0a984f3c7301"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"2.8", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}]}]}]], "Input",ExpressionUUID->"959f238d-\
5344-4187-a473-066ef69c42fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p0", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.8"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Thickness", "[", "0.006", "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.482723326640625*^9, 
  3.482723373265625*^9}},ExpressionUUID->"0d5ebc06-46f0-40b2-891b-\
e1b648d1d367"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.006], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd2Hk8VN8bB3BKUvraWoTKFm2KpLT6yJISZd+yhYqSIoUiKYoS1VcihFIq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       "]]},
     Annotation[#, "Charting`Private`Tag$2192#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.006], Opacity[1.], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGDQB2IQ7ZX64uKBl6F2MJrFWargvqSJPYw2nj9jzmZJFzjt
ffb6prmSIXA6POX73kmSKXD6rn67c69kCZxeIOrf1iXZAqcbOTard0pOgdMR
kQvXf/i4BE5z/2+McZdbD6dVA9+9ONy9BU6Xn7O0n/FlJ5wW3yJ4j5FxP5ze
9sj5zHmbQ3D6UNZc6cg3R+D0VzVb/rW5x+E008/VAtKqp+C02f+EbcHrzsDp
My0m545pnYfT8hNe/1z57gKcfv39/r2rBpfg9JJXu0/x9V2G03yyy98/eXIF
Tvdkbk1boHINTn9zWP0ko/46nC4xOrJF7PANOH1/3ZHui4q34PTvrCuzNatu
w2ltR/Z/abvvwGn3RYrpG8Xvwely2XilhzH34bTOm1Du674P4LQw/weOI78Q
NMv+2euV5zyE09kmu29yej+C06s9kxbs+4agv76WEng27TGc3hrszjzF5Qmc
rvdonb/lGYJWvOt1Y3HrUzhtZd4yRdLoGZyOkTv/k/Eygv56qvdRQeNzOD2D
Ja4kSOUFnBa+t3UR0xEEzVrbGGJZ+BJOz5oJAggaABvVegw=
       "]]},
     Annotation[#, "Charting`Private`Tag$2192#2"]& ]}, {}, {}},
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.9999999795918367}, {0, 0.8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8109628291187267`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"0f63cf9a-6692-4ff6-925b-c03ad8ca9df1"]
}, Open  ]],

Cell["The iteration", "MainSection",ExpressionUUID->"98fe19a1-179f-4cac-9509-1428ee12d51e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x0", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"data", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"f", ",", "x0", ",", "NN"}], "]"}]}]}], "Input",ExpressionUUID->\
"5ea23d61-8a8d-4e83-b6cc-34adee9d2c84"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2`", ",", "0.44799999999999995`", ",", "0.6924288`", ",", 
   "0.596319239405568`", ",", "0.674023291536932`", ",", 
   "0.6152045032074255`", ",", "0.6628381828340448`", ",", 
   "0.6257544333916573`", ",", "0.655720302950561`", ",", 
   "0.6321033242971593`", ",", "0.6511363927869906`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.810962829187721*^9},ExpressionUUID->"403d242b-2ecb-4325-9f8b-\
da4084984a56"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dd", "=", 
  RowBox[{"Drop", "[", 
   RowBox[{
    RowBox[{"Thread", "[", 
     RowBox[{"{", 
      RowBox[{"data", ",", 
       RowBox[{"RotateLeft", "[", "data", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",ExpressionUUID->"b795adcf-11e0-\
4455-9269-9a9b49ee3491"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "0.44799999999999995`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.44799999999999995`", ",", "0.6924288`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6924288`", ",", "0.596319239405568`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.596319239405568`", ",", "0.674023291536932`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.674023291536932`", ",", "0.6152045032074255`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6152045032074255`", ",", "0.6628381828340448`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6628381828340448`", ",", "0.6257544333916573`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6257544333916573`", ",", "0.655720302950561`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.655720302950561`", ",", "0.6321033242971593`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6321033242971593`", ",", "0.6511363927869906`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.810962829218964*^9},ExpressionUUID->"7b7b2741-cc4f-4a36-ae81-\
e660a397843b"]
}, Open  ]],

Cell["The Cobweb diagram ", "MainSection",ExpressionUUID->"46f45d30-5f5f-4008-99eb-003fab2e26b5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cary", "=", 
   RowBox[{"dd", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u_", ",", "v_"}], "}"}], "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "u", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"u", ",", "u"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"u", ",", "v"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"v", ",", "v"}], "}"}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"p0", ",", "cary", ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.48272331953125*^9, {3.482723388359375*^9, 
   3.482723389703125*^9}},ExpressionUUID->"7a5ccfb0-411a-4ff6-8131-\
b7605076ba62"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.006], Opacity[1.], 
       LineBox[CompressedData["
1:eJwd2Hk8VN8bB3BKUvraWoTKFm2KpLT6yJISZd+yhYqSIoUiKYoS1VcihFIq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        "]]},
      Annotation[#, "Charting`Private`Tag$2192#1"]& ], 
     TagBox[
      {RGBColor[0.880722, 0.611041, 0.142051], Thickness[0.006], Opacity[1.], 
       LineBox[CompressedData["
1:eJxTTMoPSmViYGDQB2IQ7ZX64uKBl6F2MJrFWargvqSJPYw2nj9jzmZJFzjt
ffb6prmSIXA6POX73kmSKXD6rn67c69kCZxeIOrf1iXZAqcbOTard0pOgdMR
kQvXf/i4BE5z/2+McZdbD6dVA9+9ONy9BU6Xn7O0n/FlJ5wW3yJ4j5FxP5ze
9sj5zHmbQ3D6UNZc6cg3R+D0VzVb/rW5x+E008/VAtKqp+C02f+EbcHrzsDp
My0m545pnYfT8hNe/1z57gKcfv39/r2rBpfg9JJXu0/x9V2G03yyy98/eXIF
Tvdkbk1boHINTn9zWP0ko/46nC4xOrJF7PANOH1/3ZHui4q34PTvrCuzNatu
w2ltR/Z/abvvwGn3RYrpG8Xvwely2XilhzH34bTOm1Du674P4LQw/weOI78Q
NMv+2euV5zyE09kmu29yej+C06s9kxbs+4agv76WEng27TGc3hrszjzF5Qmc
rvdonb/lGYJWvOt1Y3HrUzhtZd4yRdLoGZyOkTv/k/Eygv56qvdRQeNzOD2D
Ja4kSOUFnBa+t3UR0xEEzVrbGGJZ+BJOz5oJAggaABvVegw=
        "]]},
      Annotation[#, "Charting`Private`Tag$2192#2"]& ]}, {}, {}}, 
   {Hue[0.2], Thickness[0.006], 
    LineBox[{{0.2, 0.2}, {0.2, 0.44799999999999995`}, {0.44799999999999995`, 
     0.44799999999999995`}}]}, 
   {Hue[0.44799999999999995`], Thickness[0.006], 
    LineBox[{{0.44799999999999995`, 0.44799999999999995`}, {
     0.44799999999999995`, 0.6924288}, {0.6924288, 0.6924288}}]}, 
   {Hue[0.6924288], Thickness[0.006], 
    LineBox[{{0.6924288, 0.6924288}, {0.6924288, 0.596319239405568}, {
     0.596319239405568, 0.596319239405568}}]}, 
   {Hue[0.596319239405568], Thickness[0.006], 
    LineBox[{{0.596319239405568, 0.596319239405568}, {0.596319239405568, 
     0.674023291536932}, {0.674023291536932, 0.674023291536932}}]}, 
   {Hue[0.674023291536932], Thickness[0.006], 
    LineBox[{{0.674023291536932, 0.674023291536932}, {0.674023291536932, 
     0.6152045032074255}, {0.6152045032074255, 0.6152045032074255}}]}, 
   {Hue[0.6152045032074255], Thickness[0.006], 
    LineBox[{{0.6152045032074255, 0.6152045032074255}, {0.6152045032074255, 
     0.6628381828340448}, {0.6628381828340448, 0.6628381828340448}}]}, 
   {Hue[0.6628381828340448], Thickness[0.006], 
    LineBox[{{0.6628381828340448, 0.6628381828340448}, {0.6628381828340448, 
     0.6257544333916573}, {0.6257544333916573, 0.6257544333916573}}]}, 
   {Hue[0.6257544333916573], Thickness[0.006], 
    LineBox[{{0.6257544333916573, 0.6257544333916573}, {0.6257544333916573, 
     0.655720302950561}, {0.655720302950561, 0.655720302950561}}]}, 
   {Hue[0.655720302950561], Thickness[0.006], 
    LineBox[{{0.655720302950561, 0.655720302950561}, {0.655720302950561, 
     0.6321033242971593}, {0.6321033242971593, 0.6321033242971593}}]}, 
   {Hue[0.6321033242971593], Thickness[0.006], 
    LineBox[{{0.6321033242971593, 0.6321033242971593}, {0.6321033242971593, 
     0.6511363927869906}, {0.6511363927869906, 0.6511363927869906}}]}},
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 0.9999999795918367}, {0, 0.8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.810962829272337*^9},ExpressionUUID->"cd6e99ee-c68d-4cfe-acc7-\
065026ad826e"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1014, 694},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->2,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"modeling-sty.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 114, 0, 104, "Subtitle",ExpressionUUID->"0bc2d523-d9ad-4e99-856a-4f72543c151a"],
Cell[684, 24, 100, 0, 43, "MainSection",ExpressionUUID->"f77198fc-74ae-48c3-b47e-7227b681bddd"],
Cell[787, 26, 766, 23, 78, "TextBox",ExpressionUUID->"af2b640c-3a69-409d-9d72-c2704bfeb8a7"],
Cell[1556, 51, 258, 6, 43, "MainSection",ExpressionUUID->"263c7695-2b0e-4db5-b7de-0a984f3c7301"],
Cell[1817, 59, 220, 6, 57, "Input",ExpressionUUID->"959f238d-5344-4187-a473-066ef69c42fb"],
Cell[CellGroupData[{
Cell[2062, 69, 865, 23, 175, "Input",ExpressionUUID->"0d5ebc06-46f0-40b2-891b-e1b648d1d367"],
Cell[2930, 94, 22882, 395, 616, 7677, 145, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"0f63cf9a-6692-4ff6-925b-c03ad8ca9df1"]
}, Open  ]],
Cell[25827, 492, 91, 0, 43, "MainSection",ExpressionUUID->"98fe19a1-179f-4cac-9509-1428ee12d51e"],
Cell[CellGroupData[{
Cell[25943, 496, 323, 8, 136, "Input",ExpressionUUID->"5ea23d61-8a8d-4e83-b6cc-34adee9d2c84"],
Cell[26269, 506, 456, 10, 105, "Output",ExpressionUUID->"403d242b-2ecb-4325-9f8b-da4084984a56"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26762, 521, 318, 9, 57, "Input",ExpressionUUID->"b795adcf-11e0-4455-9269-9a9b49ee3491"],
Cell[27083, 532, 1071, 26, 222, "Output",ExpressionUUID->"7b7b2741-cc4f-4a36-ae81-e660a397843b"]
}, Open  ]],
Cell[28169, 561, 97, 0, 43, "MainSection",ExpressionUUID->"46f45d30-5f5f-4008-99eb-003fab2e26b5"],
Cell[CellGroupData[{
Cell[28291, 565, 987, 29, 253, "Input",ExpressionUUID->"7a5ccfb0-411a-4ff6-8131-b7605076ba62"],
Cell[29281, 596, 9631, 178, 616, "Output",ExpressionUUID->"cd6e99ee-c68d-4cfe-acc7-065026ad826e"]
}, Open  ]]
}, Open  ]]
}
]
*)

