(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71814,       1624]
NotebookOptionsPosition[     68422,       1561]
NotebookOutlinePosition[     68903,       1579]
CellTagsIndexPosition[     68860,       1576]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMat2", "=", 
   RowBox[{"Det", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<determinant= \>\"", ",", "detMat2"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"invEps", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"Inverse", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"invEps", "[", "\[Epsilon]", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 3.676092822828125*^9}, {3.6851971430625*^9, 
  3.685197182328125*^9}},ExpressionUUID->"6c890249-8e10-44fc-bdd1-\
ba70c9ddb085"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"determinant= \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "+", 
    RowBox[{"68", " ", "\[Epsilon]"}]}]}],
  SequenceForm["determinant= ", 1 + 68 $CellContext`\[Epsilon]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.809752055789996*^9},ExpressionUUID->"8885c888-3f70-4b70-8872-\
ae077b1c0135"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["68", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"25", "+", 
        RowBox[{"19", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"5", "+", 
        RowBox[{"51", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"36", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8097520558277383`*^9},ExpressionUUID->"95cf7b68-17ac-40a2-852b-\
918e32bacbbb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "We", " ", "see", " ", "the", " ", "dependance", " ", "of", " ", "the", 
    " ", "inverse", " ", "matrix", " ", "as", " ", "an", " ", "expression", 
    " ", "containing", " ", 
    RowBox[{"\[Epsilon]", ".", " ", "Generally"}]}], ",", " ", 
   RowBox[{
   "all", " ", "the", " ", "terms", " ", "of", " ", "the", " ", "matrix", " ",
     "is", " ", "known", " ", "only", " ", "approximately"}], ",", " ", "so", 
   ",", " ", 
   RowBox[{
   "the", " ", "determinant", " ", "and", " ", "the", " ", "inverse", " ", 
    "matrix", " ", "can", " ", "be", " ", "assumed", " ", "as", " ", "a", " ",
     "function", " ", "of", " ", 
    SuperscriptBox["n", "2"], " ", "terms", " ", 
    SubscriptBox["\[Epsilon]", 
     RowBox[{"i", ",", "j"}]]}], ",", " ", "i", ",", "j", ",", " ", "1", ",", 
   "2", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "..."}], "n"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MatrixRank", "[", "mat2", "]"}], ".", "\[IndentingNewLine]", 
       SuperscriptBox["n", "2"]}], " ", "variables"}], " ", "=", 
     RowBox[{">", " ", "possible"}]}]}], ",", " ", 
   RowBox[{
   "but", " ", "not", " ", "easy", " ", "way", " ", "how", " ", "to", " ", 
    "study", " ", "the", " ", "changes", " ", "of", " ", "the", " ", 
    "inverse", " ", "matris", " ", "and", " ", "solution", " ", "of", " ", 
    "the", " ", "seto", " ", "of", " ", "equations"}]}], " ", 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.685197212703125*^9, 3.68519741396875*^9}, {
  3.685197474984375*^9, 3.685197519828125*^9}, {3.6851975590625*^9, 
  3.6851976230625*^9}},ExpressionUUID->"92d4c79e-ce7f-4a5e-bce7-ad0db0fefe2d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"norm1", "[", "vect_", "]"}], ":=", 
   SqrtBox[
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         SuperscriptBox["#", "2"], "]"}], "&"}], "/@", "vect"}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm2", "[", "vect_", "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "vect", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm3", "[", "vect_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"Abs", "/@", "vect"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm2D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}], "]"}], 
         "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm2D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.685197385390625*^9, 3.685197390046875*^9}, {
   3.6851976698125*^9, 3.685197746046875*^9}, {3.6851977818125*^9, 
   3.68519782909375*^9}, {3.685197876890625*^9, 3.685197915140625*^9}, {
   3.6851979521875*^9, 3.68519802796875*^9}, {3.6851980934375*^9, 
   3.685198098390625*^9}, {3.685198132078125*^9, 3.685198283140625*^9}, {
   3.685198362140625*^9, 3.68519836546875*^9}, {3.685198423984375*^9, 
   3.68519843240625*^9}, 
   3.685199038140625*^9},ExpressionUUID->"9aba7590-a6e6-4507-9463-\
41ca35cfc659"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlwtMlmUUx9GlzOkyTY1MBFnqDB0aRJmXI5WznJJpkbkcm5vlPZ2TLDdT
N1uxuZSVWaZRM2vLlFBqmnLAqa2ipQ0oU4pLJjf5QFMIb+F3zu91fN8+9m68
3/u8z7n8zv//DJn3ysz5XaOiouo7/m5d85e+vXnkwgp9MudqwYrFjVr+zdIz
HV/N7dI6uEtto57p/t6sZ/JPq2ZLe1L6BU34offa+TPKteCrQdmZ1y5on8yW
/pktZXptypTy6b2bNCfj7sfvSivTI9WJhdWJTTrqi/PvrP/klI5KPlcRd7RJ
p0WvmhG96qROuz5cExqbVFNvXgldKtH923YvWDQipN1f23lo7us/6rgRz7+c
kB7SXuH1j2vbUyeXrX8zpC2zV0Y/El+s926aWnGsIKQLf60bOyxFNTlq8eGC
4pB2Df++QCdWpT5bUhXSxv3vDl08b4/eGLVxeY+LIV2fOHHO6NodmhYbM/jn
9pBGhT8Hxtu1WYeMDN8X7icfCD8v1/35B2x9Ge/rb7f3yxje/0J4fxLj+4u3
/Qv772fxyViP76zFL3kef4blR8hPiuVPRnr+Nlt+hfzGleadXvp9mciOnvH1
A5r0PquHtHs9kq1e8rXXq9rqKYVez0qrt+z0eh+0fpAp3g/L1p2YM3VJpeiE
QadWZjXorPD+KqVrSf/WrSsa9OF1N9KyXq2UwqTWkqHLG7Tv7tKJiWsq5Y/w
ug16ucveA0cSquWDjbUvps2t12GrPnu/25Zqqc29s77jq6nJtz418ljG7AHl
2+r0ZnSvqPxva6Qo863jPVLqtOXKpYyG5/6W1ux9bdn7avXMsAr9K/WcHJq5
/dOel89rTDjec7J24EI5O/m8/jLujZd25v4jP9lVN9j/pZ/9TgvtOfnN1tGr
tq402nv0mL1X2m0fOtn2JWNsn9po+5Y4i0M/srik2eLURaeqDg/OqZdJsaVp
saVV+qflQQb/ntqasaZSiy1PMsbypt0sj5JuedUiy7MssbzrVKuD7HFOP7Y6
CZwWWR2lzDn1Osto59S5FDhNsz6RvtY3Wmx9JKud2yTrMxnu3E63PhS4zbc+
lVLndrz1sbStNm69zwVunVOpcW4fNE5kk3PrnArcOqeS59w6h3KHcem8Ngvc
cn+Xc8vzV+x5OBW4dU5FnVv296/tD04Fbh/1+HwuyT6Pv8W5dU4Fbn3OSZJz
S36znNtJnv8Y5/Y/rw/c7vX6pTm3PnflrHO7w+sPtz63Zb9z+533T5Zz65wK
3BZ5/z3k3NKfvZzb7d7Pl5zbe1pKn96ztU7g9Kjzcd05jeBHDjtfp51T51Lg
tMT55BrBb/Ac67Au7+G97CNifki8zxc4JQ7iesK4lAXOaZxxGeSBvJAn8hab
u+b+LStu55U8k3fqQF2oE3WjjtSVOlN3+oC+oE/oG/qIvqLPIvQi6Ev6lL6l
j+nrL6dXJB/q6PP0ATl9ZMNxyW+7leDbHMCFdtY3idC/gDO429VZPyVCXwOO
uZ/XWZ8lQr+DOcHcqOms/zLB9q/sn7lDfMwl5hRziznGXGPOMfeYg8xF8s/c
ZI5G+J9g7jKHmcvMaeY2c5y5zpxn7qMD6EK89x+6gY70NG4DnUGH0CV0a6Bz
jK6hc+gefKGL6CS6iY6iq+gsugvH6DI6jW6j4+g6Ou/zJfAB+AR8Az4CX4HP
wHc4l4EvwafgW/Ax+Bp8Dpzig/BF+CR8Ez4KTvFZ+C58GL4Mn4Zvw8fBKT4P
34cPxBd63wa+ca/1tR50TvGV+Ex8Jz4UXwqn+FZ8LL4Wn4vvjdDTwCfjm/HR
+Go4xXfjw/Hl+HT2/7lzSnxwis/H93MO4FxA/uCUcwTnCvLPucPnpvocDc4l
cMq5hXMM5xrOOZx74JRzEeekE95f85xT51ID/+b9meKcRvSvfuj9fdE5xQcP
dT/pflPh1nVOrzm38NTs3LpOqusmnCrcus4G1wieg+dYh3V5D+9lHxHzJIiD
uIiTuMkDeSFP7nuDPJLXyPPo/+DTvcQ=
       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], 
           LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
             18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
            34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
            50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
            66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
            82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
            98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 
            111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
            124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
            137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
            163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
            176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
            189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
            202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
            215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 
            228, 229, 230, 231, 232, 233, 234}]},
          RowBox[{
            SqrtBox[
             RowBox[{
               SuperscriptBox[
                RowBox[{"Abs", "[", 
                  TagBox["x", HoldForm], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"Abs", "[", 
                  TagBox["y", HoldForm], "]"}], "2"]}]], "\[Equal]", "1"}]],
         Annotation[#, (Abs[
               HoldForm[$CellContext`x]]^2 + Abs[
               HoldForm[$CellContext`y]]^2)^Rational[1, 2] == 1, 
          "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[SqrtBox[RowBox[{SuperscriptBox[TemplateBox[List[\
\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"]}]], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztl29olmUUxt8MHLVwRA0SWaVYo0ZISPmHwgwJBxIjqUUiQ2GFkCS5fZAZ
QvuktsI3SkRk2gddgg4iBYN5kTaoTFjuNdFszZWlyz9NIoUg6j7nfa+bc8H7
2S97GDz8tj3Pcz/nPuf8zjNz9VsvtU8pFAqf3lEopPPeOSNv1713HQU7/lx0
8NaW/ltbMt/Z2VLT2ZJ51UR920R95sNrf/z/5xq5dnz3tPHdmde8no7MA2NN
R8eaMq9Llx++Sv6qdeNg68bM00uLG0qLM39nxxXypsF0QebGo+kBf5DP2QIz
9/SnFxwnP9XXvbCvO/OltPxpmXfuSMdl8pLi7Obi7Mw3U7j6L5H3p9stzLw8
vc7g7+SpFs/MRyx+v+X4Wrwy39+WAn4xxytdXpPZwtPwK/nJuen4hfx+Wm7z
GPlG2r62C+QX0+06R8kv2/7+TG6wB/xE/sE3nPyBxecs+VV73zPke239p8nf
2npL5A9tfafIy2w9Q+S77PknZT++Id9j9x8kv2P3O0Z+0K4fIE+x/z9EPjGc
/n6APMv+fxfZz58/U+Fj/vdFFZ5hfID8uN+f/II/n7zN10d+2NdP7vf3I3v8
T5Jf8fiQd3n8yJ4Ppbw+jz95te8PeYfvH3nU95fc6PtPbvP8IC/3/CH/7flF
Lnr+kZ/2/CSf9fwld3p+kx/w/Ce3e32QB7x+yHd7fZFbvf7IB70+yf94/ZKX
en2Te73+yVe8P5AXeP/I++v9hTzi/Yfc5P2J3O39izzk/U32/yq5w/sl+Uvv
p+S13m/Jdd6PyV94v87x9H5OrvF+T/7MfUCe774gV86THpn0yKRHJj1SYfVI
l9XXefJj4pXjVs8j5JXimal2zp5R73i5Zb4pHlpir3NB4pe9dNkbc1VPWTn2
ZT4n3mpMtytm7hCPnbB+dPu8ts/ik7lZPPeXxau69zwdqntwu8WzuhcvWnyr
e9LCPTd7Ub252eJf3aNnbIHZm+rVR+yFq3u2y/Yre1W9+7X7hLxePGzhm7j9
Xp4XPQzxMGqih7EyehjiYdRFD6M9ehjiYbwZPYyG6F2Id9EVvYum6F2Id7E5
ehcLonch3sX26F0sjd6FeBd7o3fRGr0L8S4ORe+W45NZvIvj3gfI66OHMcv7
CPn76GW8632ILJ7GqAeQvC16G895HyRfjx5Hr/dRsni9nC/0Ouqj1yFeL8ef
XkdL9DrE6zgVvY6t0esQr2N69Dq2Rq9DvI6e6HX8Oxy8DvE6akvB6/hkOHi9
fKbX8Xz0OlZEr0O8jkej17Eneh3idfRGr+OJ6HWI1/FR9DrOR69DvI7Xotex
J3od4nU8FD2ON6K3IZ7GjehlfBw9DPEuTkfPYkP0KsSjWBM9iiPRoxCPYkX0
KPZHj0I8imXRm9gZPQnxIp6NHkRP9B7Ec5gTvYZN0WMQb2Fm9BTWRS9BPFSO
T+b7oocgHsKq6CHURg9BPIS++H3IOtknv9fr9L76XF2XrlvfS99b46Jx07hq
3HVfdN90X3XfNS80bzSvNO80LzVvNa8177UutG60rrTutC61brWute61L2jf
0L6ifUf7kvYt7Wva97Qvat/Uvqp9V/uy9m3t69r31Qt+zt5Qr6h31EvqLfWa
ek+9qN5Ur6p31cvqbfW6el/nAp0bdK7QueOazClFmWt0DhqSualD5iydy3Ru
07lO5z6dC3Vu1LlS506dS3Vu1blW516di3Vu1rla526dy3Vu17le5379LtDv
Bv2u0O8O/S6pfLf8B/6hWEQ=
       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], 
           LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
             18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
            34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
            50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
            66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
            82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
            98, 99, 100}], 
           LineBox[{101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
            112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
            125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
            138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
            164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 
            177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
            190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
            203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 
            216, 217, 218, 219, 220, 221}], LineBox[CompressedData["
1:eJwNzkVCAgEAAMDFbgG7UBAxsLsF6wE+wZsX/LHd3a04h7lPfHt3KxcKgmCH
PfY54JAjjjnhlDPOueCSK6654ZY77nngkSeeeeGVN9754JMvvvnhlz/yBEIh
CiikiGJKKKWMciqopIpqaqglTIQoddTTQCNNNNNCK22000GMTrqIk6CbJD2k
6KWPfgZIM8gQw4wwyhjjTDDJFNPMMMsc8yywyBLLrJAhyyprrLPBJv/z+CvG

            "]], LineBox[CompressedData["
1:eJwVztc6ggEAgOHfpbga2ZW9UyirZG8hWSF7Z5bcpdfB+zzf4Vcfz0TTdUEQ
JGgQIRppopkWWmmjnTARonTQSRfd9NBLH/0MMMgQw4wQY5Q4CcYYZ4IkKSaZ
YpoZZvmfzDBHlnkWWGSJZVZYZY11Nthki212yLHLHvvkOaDAIUccc8IpRc44
54ISl1xxzQ233HHPA4888cwLr5R5450PPvnimwpVfqjxyx/wPDDi
            "]]},
          RowBox[{
            RowBox[{"Max", "[", 
              RowBox[{
                RowBox[{"Abs", "[", 
                  TagBox["x", HoldForm], "]"}], ",", 
                RowBox[{"Abs", "[", 
                  TagBox["y", HoldForm], "]"}]}], "]"}], "\[Equal]", "1"}]],
         Annotation[#, Max[
            Abs[
             HoldForm[$CellContext`x]], 
            Abs[
             HoldForm[$CellContext`y]]] == 1, "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{\\\"max\\\", \\\"(\\\", \
RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"]}], \\\")\\\"}], \
TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmHlsVGUUxUdUMAZJ2IxISMDUaGgCUSPBBr1iCAZBRVCKJVIgbBrqRkpQ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       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], LineBox[CompressedData["
1:eJwl1FV0EAQYBeCNUaMZo3PUgu5mdIOklEhJiXRJd4eSSiPdUgoqIB0qDQJS
SoNSEkrz7fDw3f/9nnP/sDbd6ncNDAgIqClibiyCiE0c4hKP+ASTgIQkIjFJ
SEoykhNCCkJJSSpSk4a0pCM9GchIJjKThTCyko3s5CAn4UQQSRS5yE0e8pKP
/BSgIIUoTBGKUozilKAkpShNGcoSTTnKU4GKVKIyVahKNapTI6YralGbOnxA
XepRnwY0pBEf0pgmNKUZzfmIFnxMS1rRmja05RPa0Z4OdKQTn9KZz+hCV7rR
nR70pBe96UNf+vE5/RnAQAYxmCEMZRjDGcFIRjGaMYxlHOOZwEQmMZkpfMGX
TGUa05nBTGbxFV8zmznMZR7zWcBCFvENi1nCUpaxnBWsZBWrWcNa1rGeb9nA
RjaxmS18x/dsZRs/8CM/sZ0d7ORndrGbPexlH/s5wEEOcZhf+JXfOMJRjnGc
E5zkFKc5w++c5Rzn+YMLXOQSl7nCn/zFVa5xnRvc5Ba3ucNd/uYf7nGfBzzk
Ef/ymCc85Rn/8T/PecFLXvGaN7wlZvyBxCKI2MQhLvGITzAJSEgiEpOEpCQj
OSGkIJSUpCI1aUhLOtKTgYxkIjNZCCMr2chODnISTgSRRJGL3OQhL/nITwEK
UojCFKEoxShOCUpSitKUoSzRlKM8FahIJSpThapUozo1At//ync1g4zu
            "]]},
          RowBox[{
            RowBox[{
              RowBox[{"Abs", "[", 
                TagBox["x", HoldForm], "]"}], "+", 
              RowBox[{"Abs", "[", 
                TagBox["y", HoldForm], "]"}]}], "\[Equal]", "1"}]],
         Annotation[#, Abs[
             HoldForm[$CellContext`x]] + Abs[
             HoldForm[$CellContext`y]] == 1, "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\
\"], \\\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\
\"Abs\\\"]}], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.809752057479028*^9},ExpressionUUID->"75dc8791-a2a8-4e22-9ada-\
3cf34d22dfa2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm3D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "\[Equal]", "1"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], 
          "]"}], "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm3D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68519851934375*^9, 3.685198525078125*^9}, {
  3.685198564015625*^9, 3.685198610578125*^9}, {3.6851986656875*^9, 
  3.685198666375*^9}, {3.685198705796875*^9, 3.685198710421875*^9}, {
  3.685198750140625*^9, 3.68519875815625*^9}, {3.68519880321875*^9, 
  3.6851988208125*^9}, {3.685198851578125*^9, 
  3.685198877265625*^9}},ExpressionUUID->"6f363416-a85a-4dae-87f1-\
bbbf51468d09"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVmG9o1WUUx29/vb0oHUrJ3aqN3UnN6EVDEMJ+LZJmkca2mwQmMc3+it00
xPnC1OiFKEqBbGVCIqug7I+KOsXbCibaH4jtYpu70thGuljWXoR/Snsu/D4/
Hr5y+N376sdz7nnOOc/3PM8533Nr2lY1v3hjIpFI3pBI3OS+e9v3LywUJnKL
Nn413PNyPnffOy/131HRk7t8983p17dfiNZ80WfNPuSL79p37Vu3vvhR99PT
K3qCs1O++O81zw5ytdNysnnc2Yn00VO/yPGz9+/MaV9f7bN+a+kzyaJ95PhT
++ixr2qyvrc1M5ab3tL25Jvtv0fxsuZ35KlwzXf28Dfff+fiRO/2WSdnFvdh
nzW/I1c71fWZH52doDJcHzjVd/rTutFcuu/x9R2dA7nnv3zgnx1rxqM1X/RZ
s29FS2F8W3IikhP/uo6OnqK8LpQrDgfyG9LF/dNe+PPQB50DwcZXhlb6fpFX
id++ncuG3L5AcUkZ+LJf8UWP+JHj53zN1FW+nHjA4dyurueOO787Dm8YzWTG
gto3ljdnPb/IK8Vv/8j7S5zfQPOncWpewRM5uDatODXflxNnw2M/VGc9+xoP
8sFDl+uL8ej9YE1esAs+xImcfIIbcs5NnMjx/1P11rHtnn3Fed5wU5vDOYpf
/S74eOr9xfuAfn94P4iTvLCfeNBHTj7nhLgh1/w8EfrTONF/NIw3iifMt/od
CnHHvvX+eGf6/vRd6jvWe8190XuEvuaZfCremv8+wfugxHtQ4rLOoec+v3ny
80/cPnBlze/I1c6e3u4rzk6g9Qg8akWeXb3tLycPtE6BU1rkmw43nSjqa/3S
OqV1bcvm3Ze6PH2NH3nv26+u9uPPh/iCm+JC3HWCC3r4Ra55rFm06Wund108
rPndwpcvOGodBS+9b5xT64TyBeUFFo9Q3qH9P+rz0s/VjvZz7c/ab1JS360+
b/VJq15q3aI+ab3RuqL1xqoHtUbeFG/F1crDJcnb1hO79x91+2Y2JleeLUwE
rPkdudr57J5b6pydQPmf+lVeOHLnrl+6PX21jzyf3HfV6Ufy1jDfap98KA+4
97bGY+4c19mvCPUnGnNringqP1AeoLwhvaTzwhFPX/PLetatO5dnvfySb7VP
Xsnze5IPxR05eqMhnsj1vXBOvbfogxNy4tZzkW+NhzxZfLzk+SCG11s8vVR+
bfFci+80GPyC/A0KL4jr21pfy61/IzF5tvKwx8D1t8lnf/X118q8pDxV+euW
xY8MdnvvS/UXvNv+lH9ecLT47vyBfx/KenieCfFVHgyO2u+JY1TqC3FoftHn
HMiJQ/Ou9cjCscWoUzqPoq88PiU8rtw5zJqHrPnD4vX4hbfPE75s8ZRS+Wkc
34F3tBpzu9Yzzl0hcuqf1jnyv1bqitqPqxPcL71H2FdcfzbwnjE39YeTBzpH
VQpuzDWKJ/rgWvjw4YtHPDuKc8PCB692eXxS7fC7xXet/jpN+ivycuuF4sK6
X3i28uBy5/45MfM3c6KFe17mKn0f9AVrTtJ5IG7+gOcr37f4SKn8NI7XKC+I
65PUUZ3Dq8RvXF0BD72PGmep973cOUrtgVO57ycuXuWLVl+0eOSQ0S/j5kCd
c6z+qu8/eo/G/yY6r8Bvlb9ac4byYO3rWl+IR+1Qpyx8zwiPI35rHtb6ZfFv
6p1V1zSvxKPzNn7L5fHl8h6ts3ytecDiSXFzgjXnKZ9VXsX3f8FZEYc=
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           TagBox[{Polygon3DBox[CompressedData["
1:eJw11Hloz3Ecx/HPxgwbm6uMKUMxytyMYnP9M9d+rLZhRijX5kiGWMMOamrO
FhLGKLei3FcyN5s55hw7UBYLEfF8933549Hn8/v8Pn0+7+/7/f5+I2ak+9L8
nXOpaAA/+GveBwPRF9fwFpfwAbdxC+9xE1dxBx9xF4PQDwPwCQ/xANEYjCGI
Qld0wyh0RDvEIRI9EIvhGIFhGIoYdEdv7emPnuiF9trfBnUox2O8whWcR0Me
spaxGgHMvzB+xV8E8vsnYz0aMf/GWIk/eGm5Ya2K8Q0e4TNKUWM54793ykmV
zn+CMu25r3gsDy9QoTMtttc6s1J5tnMuas85tFLeQpSHtmipvI3EaExQTqxe
UzEFKZim+k5HInyYhCQkY7Jy6FO90rEECzERYzFOdRmPMZile2NUo1TV1NZn
YjbmYC7mYQHmI01xJiAe65CJLCzT+fG6d7niDEQQGiMYTdBUOWmtWrdAqHLS
DM2VqwCrt9XSef1mz/K/T8LRAZ2d129dFMNKZGApFmExfqtGz7EKa7EaYaqF
9W2E83q4E9Yo/hXO64HveGrPQI/44RfzzTiNLcjHUWxECQ7hoPN65jiOIRcH
kIfDuIcjOIVNKMAJnWPrl7EXO53Xq7bf3s0bKMIe7EcOslGsu+zefbiO3Vrf
gPU63/r5pOK099q+A9txBlud17cXnPetsD7/gWfYpfUdOItCbFOc9m7aN+Qf
M0SPJQ==
              "]], Polygon3DBox[CompressedData["
1:eJwt1LdPVlEYx/FzfRvYoossloB1gMWY4KAzyuigEVtAgw1fFJUYK4JiFwQs
iB1k0NHubBl0NVH+AZVoxIqiUb+/nN/w4XLPPeU5z3nOW1xTvyQ/KoRQhTRG
oxAZZNGAbdiCPCaiCJMw3u36XolFKMBMTEUK0zDL82q+TajHVmzGYr+rvcLr
av0cFFcfnuEJenEHD/AQd9Hi9qvYj0u4gWbsxiHP0eu+zf5+DU0edwV7Pb7J
367jIMaiDKUY4xxlHFviZ877Tvn/Qo9T/wnOmXI1Dmcdv/ZxBsWY7RwpV3P8
rvYS51H5nI7JWIdTOI1abEQH2rAe7ehEHTbgpPtr3Fqv2eFxyv9R99G31ViJ
I27Xew1O4DBW4Ljf1b4Gx9ym/6vR6vGaZ7ljanO/asfd7thqPW+r+2r+R3iM
+7iH+ViGpSh3DpSLGZgSYh0W+Vx0Hgl/CpDDP489gH2e4wVe4jZueR2tdw5d
IdaZ6u05nnofq0K8H4pRNV7pcyrxvJpfddbiuFTTFY7vB/5gAK9xMcQaVW02
um3A+9Z+Vddv8CrE+lZdqj4vYw+243yIdaQ79AEfMYj3jvsd3jr+Lu9N9zjv
PoPOgXJxE/0+s1bnpd/tys9Xz691PnvuNLlNJXENPdNJTP5fHr+9X+37W4ht
+pb4PEbcR9++e6/D+OQ9VznfC7EAQ/iJX/jip842k8R3PbNJjFPxZX3+I54/
5/esxwx7viGvqXvS6TzlnVPlVvdE90O/A30+X/0ezMW8EOuy3DEqVt1z3e8y
f1e/Up+Zzq4Hu3DB56dz3IGd6HZdNPqsut3e4DE9Hqf+/wH9VaiD
              "]], Polygon3DBox[CompressedData["
1:eJwt1GVsFUEUhuGhLYTg7lZci7sXp2jRQLDiBGgI7pKQYKUEfgDFSQoUp7g7
FHd3d3fnPZnvx3NnZ3d275wzZyY4IjJ8YIBzriES4wiO4jAWYwnKoQRCUB4V
UAPd0QM9UQt/8B3fcBt30AB1EIrsyKnvFEQhlEQpbMEVXMU5bEATDMFgRKIR
BmEohqEZGutbIZpjCiTDZ7zFG3zCF/Xt/ldcwyXEYyu2YQ5m4QkCEvGDIDzl
Mhzt0Q6VlINAnv1V3A/xCBXRFm3QAmWRB/VQX3nOi9IoiuIoo3FFEKa4Ldb8
yl8/9EVv5dLabuiK2rpXV+vQC330XwuwF/uwG/P0rD8GaC42bg8O4gAWIgad
0FlrbGtdHfOxCzv1TozW2+K3PPzDD6TReHuvJtJZKpVPy+svLn86X19WZ/s1
z0WIQEd0QDVUVpxd9Mz6VRXPDmzHXMX2Aa/xCu/x0fn6sDpp6nytFXa+vp9p
vR5oDhmQCzmcr9OMeOl8/VjdXMQZjbGxmXw4LhBByIysyI0kWvNg9e1+NszG
Zudr3eo7Gvfw2/mcWG7u067HJudr0+pxJpZrfQ4hAUtRRfmwPKVEaj177HzN
PsdxZNEcbI5ptR6pFIPFkl7vRmteG7ESU3ECJ3EKqxHn/B59pxxbrs/jgq4t
/y/0zk3Fd9f5erG6sX0xBqMxHC2d3y9jMU7PbMxp5fss1mINVqi1/gxMQXN9
Z4TzZ4XtHauNW86fQTecrxOLZ5XmPx3T1MYprlhMVl4TlLdjWIbLzp8X150/
K+I1h3VaqyjNJ7nz+9n2dQEkdX5P51Pf7hfDSEzCBOfPlNZqrT8R450/Z+yM
G6XxrZyv4//b+7Rl
              "]], 
             Polygon3DBox[{{193, 222, 224, 229, 228, 194}, {77, 83, 84, 82, 
              53, 48}, {206, 210, 211, 212, 177, 173}, {66, 65, 59, 58, 19, 
              21}, {24, 63, 64, 68, 69, 26}, {49, 80, 81, 79, 75, 43}, {176, 
              207, 208, 209, 201, 168}, {225, 226, 221, 219, 190, 191}}]},
            Annotation[#, "Charting`Private`Tag$2566#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJyNmHtU1VUWx/HVVRBRw/KR8vSRCpqlpQUHsBLxgQ6p+ahcCg2MghjRMiMK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        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[SqrtBox[RowBox[{SuperscriptBox[TemplateBox[List[\
\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"]}]], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVmT9rFFEUxUdtrCTBRnAaQUHyJR6CrRbi9v5BrMReCy38AJZGsDLfwEKx
WdL4BbRJsTaaMhKsLBXJGchv98d9k2Z5Z+/OzHlz373n3Fx58PTOo7PDMLw8
Mwzn/n2+f/bh9mp1tBz+/x0vbW2f9rvLv3e+3F0crn0fnPFXv958/mb3YC0+
OOOvv3r87cL2/lp8cMb/eff51sXt/cb44Izfuvfr49vdg7X44Ix//enFz8Xi
cC0++N7J+trDnR/3t46Xl26cf/J9ddSyzvfBs947fZ/p+txH7m/iGM/vs+b+
B+c+B+d+Bue+Bc8+hO94gpPvePr5puswD5gf5BucfIPzd1mTb3DyDU6+wck3
OPniOabrMI+Z3+QbnHyDk29wXi9r8g1OvsHJNzj54n7TdXgOeT7JNzj5Biff
4OQbnPfJmnyDk29w8sV1p+uwjrC+kG9w8g1OvsHJNzj5Buf9sybf4OSL30/X
ye/Jl3WT8eQbnHyDk29w8g1OvsHJN2vyxfM31nfWcdZ9xqf+EQ9f4uFLPHyJ
hy9x8g1OHlmHL/uT9a3wIh5exMOLeHgRDy/i7L/Bw8P0SKVfGGd9xuqx1S07
33YOLF9sv+15E8/+a/pg3Iw30w3jZryZnhg34810xrgZb9QfjOf5pS4xvcJ4
5j9x29/sH/HsE/HsB/HwJs48Yf6bvq70OPPf9JTpDuvP1ses3ltdtLpS6UJ7
P538pnjTkcz/Sl8y/yvdyfynHmU885861fQr45n/xK1e2D5KnjTJkyZ50kQv
NPbPuf6S+d/5vlV3mz41HUe9Y7rA+qr1JatDnee4GT/Bp3jzG8z/yocw/+lP
GM/8p28xP8N45j9x639WF2y/JE+a5EkTXdyoE+fOS5j/nfVL/aX5MPMr1PWm
f00/mv6yftvZr+z92PluxlvwaW2+lPlPv8p45j99rPlbxjP/iZuesz5n59/2
RfKkif9r9ENz53/M/85+rHMUe6/my+lfzeeZTzKfYbqyU5dZHbI+Zu/Nzn2z
/RB8WjP/BZ/imf/EGc/8J27+xHSb9TM758Zf5hyNvn/uPJv536kvre9aPbL3
pHMa8rJ5QOWnGV/5D8ZXeo3xVX8r3qfNsxr3yfaP8cx/4oxn/puvNr9hOsz6
k51b40Pc5lu9/5+xuYD5JdOR1l+t7tj7qOZ25F3NjRhf+WzGV76E8ZWOY3zV
9xhf1QnLC9tXxjP/bU5k/tl8hekt60N2Pnuf2+a5Nucy/2++yPSi9VGrL7a/
Nne2eZzNKcy/ma61fl/NF5kHNq/qnEupn5w5T9K6XOWrzRs65wrqe2fOA7R/
VOfK/GKnL1R/PtPPaZ+rzr/p/U5dr3OEmXpc+3FVp0yvdeoynXfM1FOqG6p6
WvVb4lX/JF71Q+JVf/sLD/dRaw==
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           
           TagBox[{Polygon3DBox[{{1, 2, 3}, {297, 328, 298}, {321, 290, 
              289}, {79, 89, 80}, {17, 16, 18}, {96, 87, 88}, {313, 377, 
              311}, {384, 320, 312}}], Polygon3DBox[CompressedData["
1:eJxNmHd8l9UVxu/LRpaGvSTIEBmJYRg0EAIkjBAhEFYYBgJhGQgJQySEoFSk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              "]]},
            Annotation[#, "Charting`Private`Tag$2581#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJztlcENhDAMBM1RCZVcD1cCEm9aoDNauhL45eEoBgRCazT5ZXeI4mgkhnH+
TR8zWzqz3vz6r/G+tfa+2zsHPuYL9z3JrzGvllcc88Y88166D/Pem1cc88b8
S+Zt7bPlpT/4f86Sl771Hq3z4E/xaj7jv+vF/cnOq/mM/64X9yc7r+Yz/rte
3J/svJrP+O96cX+y82o+47/rxf3Jzqv5jP+uF/cnO6/m89Fc5R7k5OTk5E/l
GzfvKM4=
        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{\\\"max\\\", \\\"(\\\", \
RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\"]}], \\\")\\\"}], \
TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVlk9IVFEUxgd1XTO1KiMrCobAXYsWyXMRQVAQ4oCtikAkN+5mhBYqBG1a
uLHmyRi1aNUmaWEE8tCFf4agRW5EZhwhmY20SA0XLno297vFTw7vOTBcznfv
Pf/u+c55l5+M9A22ZTKZyfjfHv87f11f6i9sR/V8/tHHC9Uo/3xo7VRuIbrb
uZHvKTe9rFXnJTfcPeG/L84ffojlg5kv98/mFoJvA73ZW//pEU49w592zrwJ
V/15naNd4bvOTvvslYfF0r/z1C95Ojz6rXp8+Wa2GPt9TL/O6d7V77eflcP1
aPza+96nXXXvr2TtC5esVfmR/PLtyOmh+J70S9Y+7WqtOn8tvRPwj/eFT8Dv
1614o+zjn3PT4XqwUfv78+eFU8/y8IvzjVotYDy0yzj3H9x4F9vwOPUL32r5
4fEVxC8/dZ9xC1ed7Dm7wulvxb07/ZEcun3hxe5z9+I8HrO76fxm/ZJPdfDG
4lkDvCQ/xDfWO/WIX1YdsJ6sumad8R1UT8wf9ah+rD7CuK08Ma+yP/l57Eeh
sO390b5w6tnp+To1WmoGB+hftCt8tHT0a0ZLY3cuTcX6hVM/zgfsd9L/Cjxk
/snPRWdXOPNcdvVKf6AnIJ/ZF6x8Mb/Kg3DWoezRT52Xv3wP2lUerX6/m3L+
JM0Naw6k7d/7Cf1my+gTqivvl8HvpHxbebLi7mjhXlY/pF3Fs4c+7vwJ6A/O
e3wT/Z38WQGvdJ/51Pmqs2/xzYpT3wHkOb8XdJ5ziH1Osuowaa4yj9SjuaP3
oD32dflLnrFPq99QX1JfEY/JV71DBbyhP3hPC/f1xHdWPtLOacah+Nwa5BzO
Ne2+4k3bZ6sn5Im+MzgPLP5wrmqf/qWdk0nzTXXAOBUPv4foj+eV0c+UL+aF
+bXmSgV1etI+kjSHrDnPfsy+o/UPsm0fMQ==
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           
           TagBox[{Polygon3DBox[{{1, 2, 3}, {60, 29, 31}, {25, 29, 26}, {127, 
              107, 106}, {33, 27, 28}, {36, 32, 34}, {43, 44, 45}, {30, 35, 
              31}, {41, 40, 42}, {108, 132, 109}, {125, 101, 100}, {138, 143, 
              134}, {130, 142, 131}, {102, 126, 103}, {141, 129, 128}, {118, 
              93, 90}, {123, 96, 94}, {95, 121, 92}, {37, 38, 39}, {23, 22, 
              24}, {5, 4, 6}, {47, 22, 18}, {19, 44, 15}, {53, 52, 54}, {63, 
              57, 58}, {33, 62, 34}, {55, 59, 56}, {47, 46, 48}, {60, 65, 
              61}, {69, 62, 64}, {66, 71, 67}, {7, 11, 8}, {12, 9, 10}, {13, 
              14, 15}, {17, 16, 18}, {19, 20, 21}, {139, 124, 120}, {72, 68, 
              70}, {49, 50, 51}, {116, 133, 112}, {144, 140, 135}, {118, 119, 
              120}, {83, 110, 84}, {79, 104, 80}, {99, 78, 77}, {114, 89, 
              86}, {87, 111, 85}, {91, 115, 88}, {75, 98, 76}, {105, 82, 
              81}, {97, 74, 73}, {108, 104, 103}, {122, 137, 117}, {116, 115, 
              117}, {99, 107, 100}, {136, 119, 113}}], 
             Polygon3DBox[{{140, 144, 143, 138}, {66, 68, 72, 71}, {73, 74, 
              37, 39}, {16, 17, 14, 13}, {7, 9, 12, 11}, {38, 41, 16, 13}, {
              92, 91, 65, 67}, {10, 9, 5, 6}, {137, 139, 140, 138}, {2, 7, 8, 
              3}, {4, 5, 2, 1}, {110, 114, 86, 84}, {14, 17, 4, 1}, {105, 111,
               112, 106}, {5, 9, 7, 2}, {43, 78, 73, 39}, {74, 75, 40, 37}, {
              85, 111, 105, 81}, {50, 55, 56, 51}, {26, 55, 50, 21}, {53, 57, 
              28, 24}, {58, 57, 53, 54}, {36, 68, 66, 35}, {113, 114, 110, 
              109}, {77, 78, 43, 45}, {46, 79, 80, 48}, {40, 75, 76, 42}, {20,
               25, 26, 21}, {80, 83, 52, 48}, {49, 82, 77, 45}, {81, 82, 49, 
              51}, {76, 79, 46, 42}, {8, 25, 20, 3}, {56, 85, 81, 51}, {65, 
              91, 88, 61}, {130, 126, 125, 129}, {84, 86, 58, 54}, {72, 96, 
              95, 71}, {52, 83, 84, 54}, {134, 143, 141, 128}, {30, 32, 36, 
              35}, {59, 87, 85, 56}, {112, 133, 127, 106}, {97, 98, 75, 74}, {
              96, 123, 121, 95}, {71, 95, 92, 67}, {127, 133, 134, 128}, {132,
               136, 113, 109}, {94, 96, 72, 70}, {125, 126, 102, 101}, {121, 
              123, 124, 122}, {142, 144, 135, 131}, {143, 144, 142, 141}, {
              141, 142, 130, 129}, {124, 139, 137, 122}, {88, 87, 59, 61}, {
              63, 89, 90, 64}, {86, 89, 63, 58}, {40, 41, 38, 37}, {12, 32, 
              30, 11}, {23, 27, 10, 6}, {69, 93, 94, 70}, {135, 136, 132, 
              131}, {102, 98, 97, 101}, {90, 93, 69, 64}, {28, 27, 23, 24}}], 
             Polygon3DBox[{{82, 105, 106, 107, 99, 77}, {22, 47, 48, 52, 53, 
              24}, {104, 108, 109, 110, 83, 80}, {29, 60, 61, 59, 55, 26}, {
              121, 122, 117, 115, 91, 92}, {50, 49, 45, 44, 19, 21}, {57, 63, 
              64, 62, 33, 28}, {119, 136, 135, 140, 139, 120}, {62, 69, 70, 
              68, 36, 34}, {93, 118, 120, 124, 123, 94}, {89, 114, 113, 119, 
              118, 90}, {4, 17, 18, 22, 23, 6}, {98, 102, 103, 104, 79, 76}, {
              44, 43, 39, 38, 13, 15}, {78, 99, 100, 101, 97, 73}, {35, 66, 
              67, 65, 60, 31}, {20, 19, 15, 14, 1, 3}, {27, 33, 34, 32, 12, 
              10}, {126, 130, 131, 132, 108, 103}, {11, 30, 31, 29, 25, 8}, {
              107, 127, 128, 129, 125, 100}, {16, 41, 42, 46, 47, 18}, {115, 
              116, 112, 111, 87, 88}, {137, 138, 134, 133, 116, 117}}]},
            Annotation[#, "Charting`Private`Tag$2600#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJxTTMoPSmViYGCYAMTMQCxrPMF1eeWj/TSi7SkUJ6juOj+bC4je7xLqBhKH
0TjUk2o+LvnBEj6DzT3k6qdWfJFs72j6GXXPcErPI8w9hPIZhjgsf6PnexLd
RW46orv56OUazN8EwpHS+COVHijzSQ1/asUX2fFIZLqluXtIDN/Bln6oZS+p
+YtSewdt+hxs6YFK5R6l4U9QHgAZ2zGk
        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\
\"], \\\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\
\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\
\"]}], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8097520578488092`*^9},ExpressionUUID->"e891523e-8798-46be-ba2d-\
0085b1fc8a83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm1", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"N", "@", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mat", "/.", 
          RowBox[{
           RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
           SuperscriptBox[
            RowBox[{"Abs", "[", "term", "]"}], "2"]}]}], ")"}], "/.", 
        RowBox[{"List", "\[Rule]", "Plus"}]}]]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Plus", "@@", "#"}], "&"}], ")"}], "/@", 
       RowBox[{"(", 
        RowBox[{"mat", "/.", 
         RowBox[{
          RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
          RowBox[{"Abs", "[", "term", "]"}]}]}], ")"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2a", "[", "mat_", "]"}], ":=", 
   RowBox[{"matNorm2", "[", 
    RowBox[{"Transpose", "@", "mat"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = \>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"matNorm2", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}], ",", 
     RowBox[{"matNorm2a", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6851991203125*^9, 3.6851993145625*^9}, {
   3.68519934696875*^9, 3.685199381390625*^9}, {3.685199412125*^9, 
   3.685199441796875*^9}, {3.685199512*^9, 3.685199656984375*^9}, {
   3.68519972671875*^9, 3.68519975721875*^9}, {3.68520000603125*^9, 
   3.685200017375*^9}, 
   3.6852002675625*^9},ExpressionUUID->"8351983c-836e-49fb-8bfe-98a4c466b13a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"33", ",", "33"}], "}"}]}],
  SequenceForm["{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = ", {33, 33}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8097520579269147`*^9},ExpressionUUID->"01bc1136-a8cb-4e74-bee7-\
24df99e14ba9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm3", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"N", "[", "#", "]"}], "]"}], "&"}], "@", 
       RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm2a", ",", "matNorm3"}], 
    "}"}], "[", 
   RowBox[{"mat2", "[", "0", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.685199839890625*^9, {3.68519987946875*^9, 3.685199990328125*^9}, {
   3.685200040390625*^9, 
   3.685200087734375*^9}},ExpressionUUID->"889821e4-f14e-4074-ae99-\
b77d51ce531e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30.54504869860253`", ",", "33", ",", "33", ",", "30.288685345802126`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.809752057964669*^9},ExpressionUUID->"a74ee674-55ea-4c72-a3d6-\
ee52495755ac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{"mat_", ",", "matNorm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"matNorm", "[", 
     RowBox[{"Inverse", "@", 
      RowBox[{"N", "@", "mat"}]}], "]"}], "*", 
    RowBox[{"matNorm", "[", 
     RowBox[{"N", "@", "mat"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{
     RowBox[{"mat2", "[", "0", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm3"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.68520046784375*^9, 3.685200492265625*^9}, {
   3.68520052959375*^9, 3.685200676875*^9}, 
   3.685202460703125*^9},ExpressionUUID->"a7004d81-2249-4653-819c-\
c19ad6ccd89a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3009.5787080587934`", ",", "4488.000000000207`", ",", 
   "2984.0927016756295`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.809752058011533*^9},ExpressionUUID->"2c6f71b2-0e46-4bca-b6c8-\
b54a2c758b84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exactMatrix", "=", 
   RowBox[{"mat2", "[", "0", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixRank", "=", 
   RowBox[{"MatrixRank", "[", "exactMatrix", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "=", 
   RowBox[{
    StyleBox["0.2",
     FontColor->RGBColor[1, 0, 0]], "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"matrixRank", ",", "matrixRank"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"knownMatrix", "=", 
   RowBox[{"exactMatrix", "+", "matrixOfErrors"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"knownMatrix", "//", "mf"}], ",", 
    RowBox[{"exactMatrix", "//", "mf"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"variablesToSolve", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["x", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"rhsVector", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.68520071415625*^9, 3.68520077615625*^9}, {
  3.68520082040625*^9, 3.685200990734375*^9}, {3.68520118575*^9, 
  3.685201205921875*^9}, {3.68520130540625*^9, 3.685201306640625*^9}, {
  3.68520136265625*^9, 3.685201404375*^9}, {3.685204244234375*^9, 
  3.685204283921875*^9}},ExpressionUUID->"54cb1497-74cf-4519-9ac7-\
7b87af7bdcde"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"5.126955796068429`", "6.844567844452494`", "6.115810397853541`", 
          "4.875121258682411`"},
         {"6.89654438698306`", "9.826295503803513`", "8.01689864820385`", 
          "6.892461802694411`"},
         {"5.958402432619435`", "8.080189512776897`", "9.884730391621652`", 
          "9.09946275259318`"},
         {"4.96914025973598`", "6.898997912345603`", "9.19086870469631`", 
          "10.130065175795405`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]},
    {
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"5", "7", "6", "5"},
         {"7", "10", "8", "7"},
         {"6", "8", "10", "9"},
         {"5", "7", "9", "10"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{
  3.809752058049317*^9},ExpressionUUID->"352eff03-2f51-44e3-9496-\
6f099d1a689f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.809752058080593*^9},ExpressionUUID->"78f7bf85-2fda-4915-8a11-\
9ae1f47eebcc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "4", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8097520580961914`*^9},ExpressionUUID->"9aa7d1d6-6171-47f3-9bb0-\
031c567db106"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "how", " ", "to", " ", "get", " ", "list", " ", "of", " ", "equations", 
    " ", "from", " ", "vectors", " ", "and", " ", "matrices"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"equations", "[", "mat_", "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"mat", ".", "variablesToSolve"}], "==", "rhsVector"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"mf", "/@", 
      RowBox[{"(", 
       RowBox[{"equations", "/@", 
        RowBox[{"{", 
         RowBox[{"exactMatrix", ",", "knownMatrix"}], "}"}]}], ")"}]}], "]"}],
     ";"}]}]}]], "Input",
 CellChangeTimes->{{3.685201310125*^9, 3.685201356921875*^9}, {
  3.685201429109375*^9, 3.685201523296875*^9}, {3.68520186425*^9, 
  3.685201890625*^9}, {3.685202028171875*^9, 
  3.685202073734375*^9}},ExpressionUUID->"932f1012-9de2-4bd4-8de3-\
2ab2ef91c741"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"how", " ", "to", " ", "get", " ", "rhsVector", " ", 
    RowBox[{"(", "b", ")"}], " ", "and", " ", "the", " ", "matrix", " ", 
    RowBox[{"(", "mat", ")"}], " ", "from", " ", "a", " ", "list", " ", "of", 
    " ", "equations", " ", "and", " ", "known", " ", "variablesToSolve"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "m"}], "}"}], "=", 
     RowBox[{
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"equations", "[", "exactMatrix", "]"}], ",", 
        "variablesToSolve"}], "]"}], "//", "Normal"}]}], ";"}], 
   "\[IndentingNewLine]", "b", "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "m"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68520172828125*^9, 3.6852017331875*^9}, {
  3.685201774875*^9, 3.6852018498125*^9}, {3.685201894171875*^9, 
  3.685201895046875*^9}, {3.68520195796875*^9, 
  3.685202045859375*^9}},ExpressionUUID->"0e38ca87-f9df-4c00-8294-\
9b45a24ccf6a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}], ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{
  3.809752058149555*^9},ExpressionUUID->"2518b2ad-ae28-4942-ab57-\
fec6e5127bfa"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5", "7", "6", "5"},
     {"7", "10", "8", "7"},
     {"6", "8", "10", "9"},
     {"5", "7", "9", "10"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.809752058165176*^9},ExpressionUUID->"1fcde0d8-be6c-4047-9188-\
86ebb2f99a95"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrors", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["exactMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrors", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685202113484375*^9, 3.68520217209375*^9}, {
  3.685202205671875*^9, 3.685202264234375*^9}, {3.68520229925*^9, 
  3.68520231340625*^9}, {3.685202375609375*^9, 3.6852024411875*^9}, {
  3.6852025109375*^9, 3.685202512359375*^9}, {3.685202563421875*^9, 
  3.685202816453125*^9}, {3.6852028650625*^9, 3.6852028746875*^9}, {
  3.68520302125*^9, 3.685203044*^9}, {3.685203136203125*^9, 
  3.685203221390625*^9}},ExpressionUUID->"76517880-1611-4a17-a0c8-\
25db7609ca6e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.389776339387272`", ",", "45.43477298256853`", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8097520582120404`*^9},ExpressionUUID->"384f25b3-92c3-48d4-a298-\
f4206661abd5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrorsKnown", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["knownMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrorsKnown", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.685203252265625*^9, 
  3.68520326675*^9}},ExpressionUUID->"5db0f898-251d-4c11-8382-4a1efb242a82"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.389776339387272`", ",", "3.484286557254947`", ",", "False"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.809752058249791*^9},ExpressionUUID->"026ff4a5-7940-4055-968b-\
9827704e98a4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"So", ",", " ", 
   RowBox[{"it", " ", "looks", " ", "like", " ", "a", " ", 
    RowBox[{
     StyleBox["joke",
      FontColor->RGBColor[1, 0, 0]], ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
          "for", " ", "the", " ", "comparison", " ", "of", " ", "errors", " ",
            "we", " ", "have", " ", "to", " ", "know", " ", "the", " ", "the",
            " ", "condition", " ", "number", " ", "of", " ", "the", " ", 
           StyleBox["exactMatrix",
            FontColor->RGBColor[1, 0, 0]]}], " ", "..."}], " ", "but", " ", 
         "knowing", " ", "it", " ", "we", " ", 
         RowBox[{"don", "'"}], "t", " ", "need", " ", "anything", " ", 
         "related", " ", "to", " ", "condition", " ", "numbers", " ", "etc"}],
         "..."}], "\[IndentingNewLine]", "..."}], " ", "but", " ", "we", " ", 
      "can", " ", "believe", " ", "that", " ", "for", " ", "small", " ", 
      "matrixNorm", " ", "of", " ", "matrixOfErrors", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "try", " ", "to", " ", "decrease", " ", "the", " ", "value", " ", 
         StyleBox["0.2",
          FontColor->RGBColor[1, 0, 0]], " ", "in", " ", "the", " ", 
         "definition", " ", "of", " ", "matrixOfErrors", " ", "the", " ", 
         "difference", " ", "of", " ", 
         RowBox[{"cond", "[", "exactMatrix", "]"}], " ", "and", " ", 
         RowBox[{"cond", "[", "knownMatrix", "]"}], " ", "is", " ", "small", 
         " ", "and", " ", "reasonable"}], "..."}], " ", ")"}]}]}]}]}], " ", 
  "\[IndentingNewLine]", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.68520388903125*^9, 3.68520408*^9}, {3.6852043109375*^9, 
  3.68520442140625*^9}, {3.68520445565625*^9, 
  3.68520450884375*^9}},ExpressionUUID->"8d9a7b9a-3065-4ae4-bb9a-\
fc10f0881a44"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.68520451846875*^9},ExpressionUUID->"960f7003-d8e9-4c08-8346-24edea99f75d"]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1441, 41, 377, "Input",ExpressionUUID->"6c890249-8e10-44fc-bdd1-ba70c9ddb085"],
Cell[2011, 65, 352, 9, 34, "Print",ExpressionUUID->"8885c888-3f70-4b70-8872-ae077b1c0135"],
Cell[2366, 76, 3042, 96, 209, "Output",ExpressionUUID->"95cf7b68-17ac-40a2-852b-918e32bacbbb"]
}, Open  ]],
Cell[5423, 175, 1715, 37, 290, "Input",ExpressionUUID->"92d4c79e-ce7f-4a5e-bce7-ad0db0fefe2d"],
Cell[CellGroupData[{
Cell[7163, 216, 2310, 62, 247, "Input",ExpressionUUID->"9aba7590-a6e6-4507-9463-41ca35cfc659"],
Cell[9476, 280, 15473, 299, 225, "Output",ExpressionUUID->"75dc8791-a2a8-4e22-9ada-3cf34d22dfa2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24986, 584, 1717, 42, 166, "Input",ExpressionUUID->"6f363416-a85a-4dae-87f1-bbbf51468d09"],
Cell[26706, 628, 22816, 393, 225, "Output",ExpressionUUID->"e891523e-8798-46be-ba2d-0085b1fc8a83"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49559, 1026, 2026, 53, 341, "Input",ExpressionUUID->"8351983c-836e-49fb-8bfe-98a4c466b13a"],
Cell[51588, 1081, 384, 10, 34, "Print",ExpressionUUID->"01bc1136-a8cb-4e74-bee7-24df99e14ba9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52009, 1096, 864, 24, 136, "Input",ExpressionUUID->"889821e4-f14e-4074-ae99-b77d51ce531e"],
Cell[52876, 1122, 238, 7, 51, "Output",ExpressionUUID->"a74ee674-55ea-4c72-a3d6-ee52495755ac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53151, 1134, 754, 21, 76, "Input",ExpressionUUID->"a7004d81-2249-4653-819c-c19ad6ccd89a"],
Cell[53908, 1157, 245, 7, 51, "Output",ExpressionUUID->"2c6f71b2-0e46-4bca-b6c8-b54a2c758b84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54190, 1169, 1881, 53, 286, "Input",ExpressionUUID->"54cb1497-74cf-4519-9ac7-7b87af7bdcde"],
Cell[56074, 1224, 2066, 53, 229, "Output",ExpressionUUID->"352eff03-2f51-44e3-9496-6f099d1a689f"],
Cell[58143, 1279, 287, 9, 51, "Output",ExpressionUUID->"78f7bf85-2fda-4915-8a11-9ae1f47eebcc"],
Cell[58433, 1290, 216, 6, 51, "Output",ExpressionUUID->"9aa7d1d6-6171-47f3-9bb0-031c567db106"]
}, Open  ]],
Cell[58664, 1299, 980, 27, 106, "Input",ExpressionUUID->"932f1012-9de2-4bd4-8de3-2ab2ef91c741"],
Cell[CellGroupData[{
Cell[59669, 1330, 1048, 24, 226, "Input",ExpressionUUID->"0e38ca87-f9df-4c00-8294-9b45a24ccf6a"],
Cell[60720, 1356, 233, 7, 51, "Output",ExpressionUUID->"2518b2ad-ae28-4942-ab57-fec6e5127bfa"],
Cell[60956, 1365, 764, 22, 145, "Output",ExpressionUUID->"1fcde0d8-be6c-4047-9188-86ebb2f99a95"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61757, 1392, 2253, 53, 555, "Input",ExpressionUUID->"76517880-1611-4a17-a0c8-25db7609ca6e"],
Cell[64013, 1447, 228, 6, 51, "Output",ExpressionUUID->"384f25b3-92c3-48d4-a298-f4206661abd5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64278, 1458, 1875, 47, 525, "Input",ExpressionUUID->"5db0f898-251d-4c11-8382-4a1efb242a82"],
Cell[66156, 1507, 227, 6, 51, "Output",ExpressionUUID->"026ff4a5-7940-4055-968b-9827704e98a4"]
}, Open  ]],
Cell[66398, 1516, 1873, 39, 376, "Input",ExpressionUUID->"8d9a7b9a-3065-4ae4-bb9a-fc10f0881a44"],
Cell[68274, 1557, 144, 2, 120, "Input",ExpressionUUID->"960f7003-d8e9-4c08-8346-24edea99f75d"]
}
]
*)

