(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16745,        409]
NotebookOptionsPosition[     15381,        384]
NotebookOutlinePosition[     15835,        401]
CellTagsIndexPosition[     15792,        398]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"b82f3785-76bc-4b79-9722-3160ea3e5eef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"v", " ", "souboru", " ", 
     RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", 
     " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"cas", ",", 
       RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
       RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
    RowBox[{
     RowBox[{"predpokladame", " ", "out"}], "=", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"in", "[", "t", "]"}]}], "+", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
      RowBox[{"i", "*", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", "t"], 
        RowBox[{
         RowBox[{"in", "[", "\[Tau]", "]"}], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
         "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
    RowBox[{"d", " ", "a", " ", "napiste", " ", 
     RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali",
      " ", "svoji", " ", 
     RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
     "naprogramujete"}], ",", " ", 
    RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.724320734265625*^9, 3.72432103215625*^9}, {
   3.724321083875*^9, 3.7243213455625*^9}, {3.724321385390625*^9, 
   3.724321564390625*^9}, {3.724321663765625*^9, 3.724321840953125*^9}, {
   3.72432187428125*^9, 3.72432190003125*^9}, {3.724321931390625*^9, 
   3.72432199065625*^9}, {3.7243220345625*^9, 3.72432210821875*^9}, {
   3.724322387859375*^9, 3.724322530484375*^9}, {3.7243225699375*^9, 
   3.7243226161875*^9}, {3.72432265234375*^9, 3.724322662265625*^9}, 
   3.724325867546875*^9, {3.7244821895733504`*^9, 3.724482191838975*^9}, {
   3.75542058921875*^9, 3.755420593828125*^9}, 3.8800794499175634`*^9, {
   3.8800796619771967`*^9, 
   3.8800796664449177`*^9}},ExpressionUUID->"739847bf-804d-43eb-8cf3-\
1978d5641fd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "V", " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", 
      "data", " ", "ve", " ", "tvaru", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
      "motor"}], "-", 
     RowBox[{
      RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
      "je"}], " ", "-", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "*", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
      "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
    RowBox[{"konstantu", " ", "treni"}], ",", " ", 
    RowBox[{
    "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
     "soustroji", " ", "rozebehne", " ", "pri", " ", "hnacim", " ", "momentu",
      " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
     "dobu", " ", "dosahne", " ", "uhlova", " ", "rychlost", " ", "poloviny", 
     " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
     RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.724322683546875*^9, {3.724322714953125*^9, 3.724323322953125*^9}, {
   3.724324213453125*^9, 3.724324228296875*^9}, {3.72432429309375*^9, 
   3.72432430578125*^9}, {3.724324360203125*^9, 3.724324361046875*^9}, {
   3.7243243940625*^9, 3.7243244180625*^9}, {3.724324932359375*^9, 
   3.72432563309375*^9}, 3.724325827984375*^9, {3.75542119128125*^9, 
   3.7554212354375*^9}, {3.8800793454751425`*^9, 3.8800793516924357`*^9}, 
   3.8800794591966434`*^9, {3.8800796704596033`*^9, 
   3.88007967430245*^9}},ExpressionUUID->"70fd11ae-9442-49f9-bcc8-\
9031e4a82c7b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataRCL.csv\>\"", " ", "jsou", " ", "data",
      " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"frekvence", ",", " ", 
       RowBox[{"Re", "[", "z", "]"}], ",", 
       RowBox[{"Im", "[", "z", "]"}]}], "}"}], " ", "paralelni", " ", 
     "kombinace", " ", "rezistoru"}], ",", " ", 
    RowBox[{"civky", " ", "a", " ", "kondenzatoru"}], ",", " ", 
    RowBox[{"najdete", " ", "jejich", " ", "kapacitu", " ", "a", " ", 
     RowBox[{"odpor", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.72432601265625*^9, {3.7243260908125*^9, 3.72432638728125*^9}, {
   3.7243264326875*^9, 3.724326615640625*^9}, {3.72432664828125*^9, 
   3.724326822625*^9}, {3.755421619421875*^9, 3.75542162496875*^9}, {
   3.8800784266092234`*^9, 3.880078463584963*^9}, 3.880078518587686*^9, {
   3.8800787074027824`*^9, 3.880078769341382*^9}, 3.8800788422025423`*^9, 
   3.8800793005325565`*^9, {3.880079472896558*^9, 3.8800794827536135`*^9}, {
   3.8800796772392545`*^9, 
   3.880079680722787*^9}},ExpressionUUID->"09022108-1cd2-4cb1-960b-\
d811f79342da"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Mate", " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", 
    " ", 
    RowBox[{
     RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
      RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
    RowBox[{"IRR", " ", "takove"}], ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       RowBox[{
        FractionBox["rocniUspora", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
        "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
        "dobou", " ", "navratnosti", " ", "definovanou", " ", "ta"}]}]}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "Treal"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7243269765625*^9, 3.724327253921875*^9}, {
   3.72432778575*^9, 3.72432797796875*^9}, {3.724328076125*^9, 
   3.724328231671875*^9}, {3.75542215925*^9, 3.75542216521875*^9}, 
   3.755422200484375*^9, 3.880079497343915*^9, {3.8800796836127605`*^9, 
   3.880079687643071*^9}},ExpressionUUID->"0ef86156-7c96-4954-a323-\
35139bfbcb67"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"V", " ", "souboru", " ", 
     RowBox[{"dataFrekvence", ".", "csv"}], " ", "jsou", " ", "dvojice", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cas", ",", "napeti"}], "}"}], ".", " ", "Najdete"}], " ", 
     "frekvenci", " ", "signalu", " ", "a", " ", "amplitudy", " ", 
     "harmonickych"}], ",", " ", 
    RowBox[{"vite", "-", 
     RowBox[{
     "li", " ", "ze", " ", "vyssi", " ", "nez", " ", "sesta", " ", "se", " ", 
      "v", " ", "signalu", " ", "nevyskytuje"}]}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7243282599375*^9, 3.724328347421875*^9}, {
   3.724482286307725*^9, 3.7244829149171004`*^9}, {3.7244829575108504`*^9, 
   3.724482990620225*^9}, {3.7244830217296004`*^9, 3.7244830238233504`*^9}, 
   3.724483063276475*^9, {3.724483118526475*^9, 3.7244831984171004`*^9}, {
   3.755422718203125*^9, 3.755422722140625*^9}, 3.8800795105595984`*^9, {
   3.8800796931105328`*^9, 
   3.880079697015873*^9}},ExpressionUUID->"9aa0ac62-e09c-41de-a671-\
679385e25660"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
    RowBox[{
     RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
     RowBox[{
      RowBox[{
      "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
       " ", "o", " ", "U"}], "=", 
      RowBox[{
      "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
       RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
       " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
       "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7244875491983504`*^9, 3.7244879638546004`*^9}, {
   3.724488021870225*^9, 3.724488034838975*^9}, 3.8800795336947947`*^9, {
   3.880079701342985*^9, 
   3.8800797048265424`*^9}},ExpressionUUID->"052e901c-6541-4fe6-b6e3-\
49c0d638899f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Tepelna", " ", "vodivost", " ", "cihlove", " ", "zdi", " ", "s", " ", 
      "izolaci", " ", "je", " ", 
      RowBox[{"\[Lambda]", "[", "x", "]"}]}], "=", 
     RowBox[{"0.4", "*", 
      RowBox[{"(", 
       RowBox[{"1.1", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"500", 
          RowBox[{"(", 
           RowBox[{"x", "-", "0.1"}], ")"}]}], "]"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"prislusna", " ", "rovnice", " ", "je", " ", "0"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "x", "]"}], "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"T", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
         "]"}], ".", " ", "Okrajove"}], " ", "podminky", " ", "jsou", " ", 
       RowBox[{"T", "[", "0", "]"}]}]}], "=", 
     RowBox[{"-", "15"}]}], ",", " ", 
    RowBox[{
     RowBox[{"T", "[", "0.455", "]"}], "=", 
     RowBox[{"18.", " ", "Vyreste", " ", 
      RowBox[{"dif", ".", " ", "rovnici"}], " ", "a", " ", "zobrazte", " ", 
      "graf", " ", "reseni"}]}]}], "*)"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.724488251932725*^9, {3.724488301463975*^9, 3.7244883028546004`*^9}, {
   3.724488366088975*^9, 3.7244886432608504`*^9}, {3.7244886757608504`*^9, 
   3.7244888733233504`*^9}, {3.724489061463975*^9, 3.7244891644171004`*^9}, 
   3.7542738933125*^9, 3.755423705*^9, {3.755423906625*^9, 
   3.755423926578125*^9}, 3.8800795538775673`*^9, {3.8800797090911665`*^9, 
   3.8800797125278263`*^9}},ExpressionUUID->"0316b8d2-8ea1-4b4a-be5e-\
eae720c414ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataVaristor.csv\>\"", " ", "jsou", " ", 
     "data", " ", "ve", " ", "tvaru", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cas", ",", " ", 
        RowBox[{
        "napeti", " ", "na", " ", "varistoru", " ", "s", " ", 
         "kondenzatorem"}], ",", 
        RowBox[{"proud", " ", "varistorem"}]}], "}"}], ".", " ", "Kapacita"}],
      " ", "kondenzatoru", " ", "je", " ", "4.7", 
     RowBox[{"\[Mu]F", ".", " ", "Naleznete"}], " ", "charakteristiku", " ", 
     "varistoru", " ", "a", " ", "teplo"}], ",", " ", 
    RowBox[{
    "ktere", " ", "se", " ", "za", " ", "jednu", " ", "periodu", " ", "na", 
     " ", "varistoru", " ", "vygeneruje"}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.75427390540625*^9, 3.75427421646875*^9}, {
   3.754274254671875*^9, 3.754274258578125*^9}, {3.754274297*^9, 
   3.7542745573125*^9}, {3.754274590828125*^9, 3.754274602515625*^9}, {
   3.754274637921875*^9, 3.754274834984375*^9}, {3.754274882140625*^9, 
   3.754275072*^9}, {3.755424047734375*^9, 3.75542408440625*^9}, 
   3.8800795976328926`*^9, {3.880079726446474*^9, 
   3.880079741786587*^9}},ExpressionUUID->"3d45424a-7aab-47a6-8049-\
43c8fbf83323"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.75542420465625*^9, 3.755424210046875*^9}, {
   3.755424246*^9, 3.75542434525*^9}, 
   3.880079734257134*^9},ExpressionUUID->"3e4936ce-8f3e-4924-88db-\
0a25c05b6ac2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"10", "b"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "V", " ", "souboru", " ", "\"\<dataUcinik.csv\>\"", " ", "jsou", " ", 
     "dvojice", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"napeti", ",", " ", "proud"}], "}"}], ".", " ", "Najdete"}], 
     " ", "P"}], ",", " ", 
    RowBox[{"Q", " ", "a", " ", 
     RowBox[{"cos", "[", "fi", "]"}]}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.754275117671875*^9, 3.754275438875*^9}, {
   3.754275497078125*^9, 3.75427564396875*^9}, {3.754275676671875*^9, 
   3.754276136796875*^9}, {3.755424413671875*^9, 3.755424429453125*^9}, 
   3.8800796445906363`*^9, {3.8800797439579573`*^9, 
   3.880079749113031*^9}},ExpressionUUID->"a25a171d-2cdb-4f8c-ba5c-\
d64cb78346d8"]
},
WindowSize->{1113, 646},
WindowMargins->{{6, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>1.8 Inherited,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 387, 10, 119, "Input",ExpressionUUID->"b82f3785-76bc-4b79-9722-3160ea3e5eef"],
Cell[948, 32, 2112, 47, 264, "Input",ExpressionUUID->"739847bf-804d-43eb-8cf3-1978d5641fd4"],
Cell[3063, 81, 2228, 48, 357, "Input",ExpressionUUID->"70fd11ae-9442-49f9-bcc8-9031e4a82c7b"],
Cell[5294, 131, 1576, 33, 255, "Input",ExpressionUUID->"09022108-1cd2-4cb1-960b-d811f79342da"],
Cell[6873, 166, 2079, 56, 352, "Input",ExpressionUUID->"0ef86156-7c96-4954-a323-35139bfbcb67"],
Cell[8955, 224, 1151, 25, 187, "Input",ExpressionUUID->"9aa0ac62-e09c-41de-a671-679385e25660"],
Cell[10109, 251, 1031, 23, 221, "Input",ExpressionUUID->"052e901c-6541-4fe6-b6e3-49c0d638899f"],
Cell[11143, 276, 1810, 45, 255, "Input",ExpressionUUID->"0316b8d2-8ea1-4b4a-be5e-eae720c414ca"],
Cell[12956, 323, 1361, 30, 221, "Input",ExpressionUUID->"3d45424a-7aab-47a6-8049-43c8fbf83323"],
Cell[14320, 355, 214, 4, 50, "Input",ExpressionUUID->"3e4936ce-8f3e-4924-88db-0a25c05b6ac2"],
Cell[14537, 361, 840, 21, 153, "Input",ExpressionUUID->"a25a171d-2cdb-4f8c-ba5c-d64cb78346d8"]
}
]
*)

