(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    192278,       3405]
NotebookOptionsPosition[    190484,       3376]
NotebookOutlinePosition[    190943,       3393]
CellTagsIndexPosition[    190900,       3390]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Vypracujte reseni v jakekoli programu.
Odeslete je jako jeden komprimovany soubor, ktery bude obsahovat i vsechny \
soubory s daty, ktera pouzijete.
V souboru bude info o slozeni tymu a jeho mluvcim.
Nazev souboru nesmi obsahovat \[OpenCurlyDoubleQuote]specialni znaky\
\[CloseCurlyDoubleQuote].


Dekuji vam, ze dnes nestavkujete za klima a ze \[OpenCurlyDoubleQuote]uhli \
patri pod zem\[CloseCurlyDoubleQuote], ostatne v clanku
https://neviditelnypes.lidovky.cz/klima/klima-co-skodi-planete.A231115_164605_\
p_klima_nef
se dozvite, ze z hlediska emisi sklenikovych plynu je LNG o 24% horsi, nez \
pouziti uhli z mistnich zdroju.
\
\>", "Text",
 CellChangeTimes->{{3.9091090046394234`*^9, 3.909109200701133*^9}, {
  3.909109329927229*^9, 
  3.909109340160571*^9}},ExpressionUUID->"f15ba45f-2733-4ecb-b7fe-\
3f275e07c373"],

Cell[TextData[{
 "Predstava AI o vasem dnesnim testu:-)\n",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJy0vQV4Xde1rn2e/9z//uec3rYhM7MtyxYzMzMza4uZwWLZAluWLVtgyZJl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     "], {{0, 206}, {206, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->Automatic,
   ImageSizeRaw->{206, 206},
   PlotRange->{{0, 206}, {0, 206}}]], "Input",ExpressionUUID->
  "7b70437b-92e0-46c3-9a48-82a5a1f4ec31"]
}], "Text",
 CellChangeTimes->{{3.9091108665997005`*^9, 
  3.9091108939061303`*^9}},ExpressionUUID->"e83a5136-12d1-4627-815d-\
33144d758e1e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"e8d2086a-1ae0-42c9-83a8-db53ff58e176"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"v", " ", "souboru", " ", 
     RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", 
     " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"cas", ",", 
       RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
       RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
    RowBox[{
     RowBox[{"predpokladame", " ", "out"}], "=", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"in", "[", "t", "]"}]}], "+", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
      RowBox[{"i", "*", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", "t"], 
        RowBox[{
         RowBox[{"in", "[", "\[Tau]", "]"}], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
         "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
    RowBox[{"d", " ", "a", " ", "napiste", " ", 
     RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali",
      " ", "svoji", " ", 
     RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
     "naprogramujete"}], ",", " ", 
    RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.724320734265625*^9, 3.72432103215625*^9}, {
   3.724321083875*^9, 3.7243213455625*^9}, {3.724321385390625*^9, 
   3.724321564390625*^9}, {3.724321663765625*^9, 3.724321840953125*^9}, {
   3.72432187428125*^9, 3.72432190003125*^9}, {3.724321931390625*^9, 
   3.72432199065625*^9}, {3.7243220345625*^9, 3.72432210821875*^9}, {
   3.724322387859375*^9, 3.724322530484375*^9}, {3.7243225699375*^9, 
   3.7243226161875*^9}, {3.72432265234375*^9, 3.724322662265625*^9}, 
   3.724325867546875*^9, {3.7244821895733504`*^9, 3.724482191838975*^9}, {
   3.75542058921875*^9, 3.755420593828125*^9}, 3.9090588432359495`*^9, {
   3.9091089211072803`*^9, 
   3.9091089280900497`*^9}},ExpressionUUID->"bc46d219-9522-4cdc-b90b-\
200478d78e96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "V", " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", 
      "data", " ", "ve", " ", "tvaru", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
      "motor"}], "-", 
     RowBox[{
      RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
      "je"}], " ", "-", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "*", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
      "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
    RowBox[{"konstantu", " ", "treni"}], ",", " ", 
    RowBox[{
    "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
     "soustroji", " ", "rozebehne", " ", "pri", " ", "hnacim", " ", "momentu",
      " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
     "dobu", " ", "dosahne", " ", "uhlova", " ", "rychlost", " ", "poloviny", 
     " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
     RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"fyzikalni", " ", "model", " ", "je", " ", "tedy", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"J", "*", 
        RowBox[{
         RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "B"}], "*", 
         RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
        RowBox[{"kv", "*", 
         SuperscriptBox[
          RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}], ",", 
      RowBox[{
       RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "\[Omega]0"}]}], 
     "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "15", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.724322683546875*^9, {3.724322714953125*^9, 3.724323322953125*^9}, {
   3.724324213453125*^9, 3.724324228296875*^9}, {3.72432429309375*^9, 
   3.72432430578125*^9}, {3.724324360203125*^9, 3.724324361046875*^9}, {
   3.7243243940625*^9, 3.7243244180625*^9}, {3.724324932359375*^9, 
   3.72432563309375*^9}, 3.724325827984375*^9, {3.75542119128125*^9, 
   3.7554212354375*^9}, {3.8800793454751425`*^9, 3.8800793516924357`*^9}, {
   3.9090566043875027`*^9, 3.909056619196436*^9}, {3.90905758013688*^9, 
   3.909057587131912*^9}, {3.909057664275864*^9, 3.909057666194765*^9}, {
   3.909057726276097*^9, 3.909057732427556*^9}, 
   3.909058859250802*^9},ExpressionUUID->"4a31d770-4912-4d25-906e-\
4369c4d52f17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Mate", " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", 
    " ", 
    RowBox[{
     RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
      RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
    RowBox[{"IRR", " ", "takove"}], ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       RowBox[{
        FractionBox["rocniUspora", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
        "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
        "dobou", " ", "navratnosti", " ", "definovanou", " ", "tak"}]}]}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "Treal"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
    RowBox[{
    "procemz", " ", "Treal", " ", "neni", " ", "cele", " ", "cislo"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"INV", "=", 
     RowBox[{"50.5", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diskont", "=", "3.4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rocniUspora", "=", 
     RowBox[{"4.1", "*", 
      SuperscriptBox["10", "6"]}]}], ";", 
    RowBox[{"zivotnost", "=", "20"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7243269765625*^9, 3.724327253921875*^9}, {
   3.72432778575*^9, 3.72432797796875*^9}, {3.724328076125*^9, 
   3.724328231671875*^9}, {3.75542215925*^9, 3.75542216521875*^9}, 
   3.755422200484375*^9, {3.908854468591878*^9, 3.9088544706453066`*^9}, {
   3.909057756043004*^9, 3.909057809531373*^9}, 3.909058881371114*^9, {
   3.909109229141529*^9, 
   3.909109245174321*^9}},ExpressionUUID->"c646897c-67f3-451d-a2ba-\
c616490e7c90"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
    RowBox[{
     RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
     RowBox[{
      RowBox[{
      "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
       " ", "o", " ", "U"}], "=", 
      RowBox[{
      "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
       RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
       " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
       "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7244875491983504`*^9, 3.7244879638546004`*^9}, {
   3.724488021870225*^9, 3.724488034838975*^9}, {3.909057842122707*^9, 
   3.9090578701468678`*^9}, 
   3.9090588896024*^9},ExpressionUUID->"483eadca-57af-4265-b317-f33cbbe3ed91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"je", " ", "dana", " ", "DR", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
           MultilineFunction->None], 
          RowBox[{"(", "t", ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], 
          RowBox[{"(", "t", ")"}]}], "+", 
         RowBox[{"y", 
          RowBox[{"(", "t", ")"}]}]}], "\[LongEqual]", 
        FractionBox[
         RowBox[{"sin", "(", "t", ")"}], 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["t", 
             RowBox[{"3", "/", "2"}]], "+", "1"}]], "+", "1"}]]}], ",", 
       RowBox[{
        RowBox[{"y", 
         RowBox[{"(", "0", ")"}]}], "\[LongEqual]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], 
         RowBox[{"(", "0", ")"}]}], "\[LongEqual]", "a"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{
     RowBox[{"sestrojte", " ", "graf", " ", "zavislosti", " ", "hodnoty", " ", 
      RowBox[{"y", "[", 
       RowBox[{"t", "=", "1"}], "]"}], " ", "na", " ", "hodnote", " ", "a", 
      " ", "pro", " ", "a"}], " ", "\[Element]", 
     RowBox[{"<", "0"}]}], ",", 
    RowBox[{"20", ">"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "najdete", " ", "hodnotu", " ", "a", " ", "pro", " ", "kterou", " ", 
     "plati", " ", 
     RowBox[{"y", "[", 
      RowBox[{"t", "=", "1"}], "]"}]}], "=", "2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9088546563802543`*^9, 3.908854657706787*^9}, {
   3.9088571150066404`*^9, 3.9088574382612906`*^9}, {3.908857867057598*^9, 
   3.9088580410945115`*^9}, {3.909057923002595*^9, 3.9090579293624516`*^9}, 
   3.9090588956179547`*^9},ExpressionUUID->"81c11f87-c44e-49c4-8d1d-\
7cb370dd61b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"soubor", " ", 
     RowBox[{"matSoustavy", ".", "csv"}], " ", "obsahuje", " ", "rozsirenou", 
     " ", "matici", " ", "soustavy"}], ",", " ", 
    RowBox[{
    "posledni", " ", "sloupec", " ", "je", " ", "vektor", " ", "pravych", " ",
      "stran"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "soucet", " ", "prvku", " ", "vektoru", " ", "reseni", " ", 
    "a", " ", "cislo", " ", "podminenosti", " ", "soustavy", " ", "s", " ", 
    "vyuzitim", " ", "spektralni", " ", "normy", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"te", " ", "co", " ", "vyuziva", " ", "vlastni", " ", "cisla"}],
       ",", " ", 
      RowBox[{
      "v", " ", "prednaskach", " ", "se", " ", "jmenuje", " ", "matNorm3"}]}],
      ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9089464450392885`*^9, 3.9089465881776447`*^9}, {
   3.908946619420231*^9, 3.908946852261881*^9}, {3.908946944676132*^9, 
   3.9089469766023593`*^9}, {3.9089470068489785`*^9, 3.908947015893444*^9}, {
   3.9089470675129375`*^9, 3.9089473746255035`*^9}, {3.909058010242605*^9, 
   3.9090580185072002`*^9}, 
   3.9090589017704496`*^9},ExpressionUUID->"de45368c-3660-4671-a13b-\
c96c93ed6298"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "V", " ", "souboru", " ", "\"\<infoVykony.csv\>\"", " ", "jsou", " ", 
       "data", " ", "ve", " ", "tvaru", " ", 
       RowBox[{"{", 
        RowBox[{"T1", ",", "T2", ",", "P"}], "}"}], " ", "tak"}], ",", " ", 
      RowBox[{
       RowBox[{
       "ze", " ", "plati", " ", "ze", " ", "pro", " ", "T\[Epsilon]"}], "<", 
       "T1"}], ",", "T2"}], ")"}], " ", "odebirame", " ", "vykon", " ", "P", 
    " ", "v", " ", "kW"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<teplotyPulhodinove.csv\>\"", " ", "jsou", 
    " ", "prumerne", " ", "pulhodinove", " ", "teploty"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "odebranou", " ", "energii", " ", "za", " ", "dane", " ", 
    "obdobi"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.908947564480008*^9, 3.9089475966398764`*^9}, {
   3.9089479755509815`*^9, 3.908948032666154*^9}, 3.9089480814738755`*^9, {
   3.9089481660404124`*^9, 3.9089481724082704`*^9}, {3.9089482662031035`*^9, 
   3.908948374670975*^9}, {3.908948497971346*^9, 3.908948498171571*^9}, {
   3.9089488000731297`*^9, 3.9089488277314663`*^9}, {3.9089488783261323`*^9, 
   3.908948992028455*^9}, {3.908949520462782*^9, 3.9089495253467894`*^9}, {
   3.9089497272795324`*^9, 3.9089497352897186`*^9}, {3.9090581127144294`*^9, 
   3.9090581211466093`*^9}, 
   3.9090589077140455`*^9},ExpressionUUID->"87c90be0-8f25-4bcf-93d0-\
4d5a97ab5d29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<teplotyPulhodinove.csv\>\"", " ", "jsou", 
    " ", "prumerne", " ", "pulhodinove", " ", "teploty"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Urcete", " ", "poradi", " ", "dni", " ", "v", " ", "tydnu", 
    RowBox[{"(*", 
     RowBox[{
     "prvni", " ", "den", " ", "znamena", " ", "prvnich", " ", "48", " ", 
      "hodnot", " ", "pulhodinovych", " ", "teplot"}], "*)"}], " ", "podle", 
    " ", "vzajemne", " ", "korelovanosti", " ", "prumernych", " ", "dennich", 
    " ", "teplot"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"tedy", " ", "ve", " ", "Wolframu", " ", 
    RowBox[{"Correlation", "[", 
     RowBox[{
     "listPondelnichTeplot", ",", "listPondelnichTeplotOTydenPozdeji"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "15", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.9090325763565145`*^9, 3.909033040715658*^9, 3.9090330851515837`*^9, {
   3.909033154608675*^9, 3.9090332197608433`*^9}, {3.9090332576753626`*^9, 
   3.909033281147024*^9}, {3.9090333755646515`*^9, 3.9090334309071836`*^9}, {
   3.909035086612809*^9, 3.909035232313428*^9}, {3.909035285135892*^9, 
   3.909035286919369*^9}, {3.909035404438876*^9, 3.9090354073475547`*^9}, {
   3.909035441806687*^9, 3.90903552455954*^9}, {3.90905827167447*^9, 
   3.9090582937386904`*^9}, 3.9090589120345526`*^9, 
   3.9091092664579988`*^9},ExpressionUUID->"703320fb-5fce-4c07-a28d-\
702c9e44c7ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "seriova", " ", "kombinace", " ", "civky", " ", "a", " ", "rezistoru", 
     " ", "se", " ", "v", " ", "case", " ", "t0"}], " ", "\[Element]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"0", ",", 
       RowBox[{"0.5", "T"}]}], ")"}], " ", "pripoji", " ", "ke", " ", 
     "zdroji", " ", "napeti"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "pro", " ", "jaky", " ", "cas", " ", "pripnuti", " ", "vznikne", " ", 
     "nemensi", " ", "prechodny", " ", "dej"}], ",", " ", 
    RowBox[{
    "tedy", " ", "nejmensi", " ", "integral", " ", "z", " ", "kvadratu", " ", 
     "rozdilu", " ", "prubehu", " ", "a", " ", "ustaleneho", " ", 
     RowBox[{"probehu", "?", "\"\<\>"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"rada", ":", " ", 
    RowBox[{
    "zkusmo", " ", "zadavat", " ", "casy", " ", "sepnuti", " ", "pripadne", 
     " ", "Manipulate", " ", "je", " ", "take", " ", "reseni"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"uz", "[", "t_", "]"}], ":=", 
     RowBox[{"230.", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.9090345307087774`*^9, {3.9090366500438833`*^9, 3.9090366615109835`*^9}, {
   3.909036717199144*^9, 3.909037414212799*^9}, 3.909037826815764*^9, {
   3.90905838615576*^9, 3.9090583922675285`*^9}, {3.909058925489846*^9, 
   3.90905895724168*^9}, {3.909109273194664*^9, 3.909109300881362*^9}, {
   3.909109385841197*^9, 
   3.9091094105493793`*^9}},ExpressionUUID->"7b7b6dbc-f917-4bf9-89e2-\
3c8a1d910996"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "seriova", " ", "kombinace", " ", "kondenzatoru", " ", "a", " ", 
    "rezistoru", " ", "se", " ", "v", " ", "case", " ", "t0", " ", "pripoji", 
    " ", "ke", " ", "zdroji", " ", "napeti"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "pro", " ", "jaky", " ", "cas", " ", "pripnuti", " ", "vznikne", " ", 
     "nemensi", " ", "prechodny", " ", "dej"}], ",", " ", 
    RowBox[{
    "tedy", " ", "nejmensi", " ", "integral", " ", "z", " ", "kvadratu", " ", 
     "rozdilu", " ", "prubehu", " ", "a", " ", "ustaleneho", " ", 
     RowBox[{"probehu", "?", "\"\<\>"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"rada", ":", " ", 
    RowBox[{
    "zkusmo", " ", "zadavat", " ", "casy", " ", "sepnuti", " ", "pripadne", 
     " ", "Manipulate", " ", "je", " ", "take", " ", "reseni"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"40", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.909037659561037*^9, 3.9090376777405305`*^9}, {
  3.909037736807881*^9, 3.909037786316409*^9}, {3.909037858114396*^9, 
  3.9090380128195114`*^9}, {3.9090380430047474`*^9, 3.9090380506597753`*^9}, {
  3.909058433692068*^9, 3.909058570196192*^9}, {3.9090589502516813`*^9, 
  3.909058981433804*^9}, {3.9091093109126406`*^9, 
  3.909109311383131*^9}},ExpressionUUID->"53308f8b-4a74-4708-a710-\
ed44e752dd8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"V", " ", "souboru", " ", "\"\<dataHarm.csv\>\""}], ",", " ", 
    RowBox[{"jsou", " ", "dvojice", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "ui"}], "}"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vite", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "f"}], "=", 
     RowBox[{
     "50", "Hz", " ", "a", " ", "ze", " ", "signal", " ", "ma", " ", 
      "nulovou", " ", "stredni", " ", "hodnotu", " ", "a", " ", "amlitudy", 
      " ", "harmonickych", " ", "vyssich"}]}], ",", " ", 
    RowBox[{"nez", " ", "40"}], ",", " ", 
    RowBox[{"jsou", " ", "nulove"}], ",", " ", 
    RowBox[{"signal", " ", "je", " ", "cisty"}], ",", " ", 
    RowBox[{"bez", " ", "sumu"}], ",", " ", 
    RowBox[{"netreba", " ", "filtrovat"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"najdete", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "1"}], "40"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["b", "n"], "*", 
         RowBox[{"sin", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "+", 
        RowBox[{
         SubscriptBox["a", "n"], "*", 
         RowBox[{"cos", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}]}], ")"}]}]}], ",",
     " ", 
    RowBox[{"jde", " ", "to", " ", "vice", " ", "zpusoby"}], ",", " ", 
    RowBox[{
    "doporucuji", " ", "fitovani", " ", "obsahuhjici", " ", "vyrazy", " ", 
     RowBox[{"sin", "[", 
      RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}], " ", "a", " ", 
     RowBox[{"cos", "[", 
      RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "stredni", " ", "elektrolytickou", " ", "hodnotu", " ", "a",
     " ", "efektivni", " ", "hodnotu", " ", 
    RowBox[{"u", "[", "t", "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"spoctete", " ", "hodnotu", " ", "ueff1"}], "=", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "*", 
     SqrtBox[
      RowBox[{
       RowBox[{
        FractionBox["1", "T"], "*", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"n", "=", "1"}], "40"], 
         SuperscriptBox[
          SubscriptBox["a", "n"], "2"]}]}], "+", 
       SuperscriptBox[
        SubscriptBox["b", "n"], "2"]}]]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"celkem", " ", "max", " ", "10", " ", "bodu"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9090590021259713`*^9, 
   3.909059005915784*^9}},ExpressionUUID->"91970e13-1993-44a1-90f7-\
f3931eee4302"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<dataPrechodak.csv\>\"", " ", "jsou", " ", 
    "data", " ", "ve", " ", "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"ti", ",", "proudi"}], "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "najdete", " ", "proklad", " ", "proudu", " ", "ve", " ", "tvaru", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", 
       RowBox[{"Exp", "[", 
        FractionBox[
         RowBox[{"-", "t"}], "tau"], "]"}]}]}], ")"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Omega]", "*", 
      RowBox[{"(", 
       RowBox[{"t", "+", "faze"}], ")"}]}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vite", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "f"}], "=", 
     RowBox[{"50", "Hz"}]}], ",", " ", 
    RowBox[{
     RowBox[{"proud", " ", "prochazi", " ", "rezistorem", " ", "R"}], "=", 
     RowBox[{"1", "\[CapitalOmega]"}]}], ",", " ", 
    RowBox[{
    "urcete", " ", "celkove", " ", "teplo", " ", "na", " ", "rezistoru", " ", 
     "vznikle"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"najdete", " ", "teplo"}], ",", " ", 
    RowBox[{
    "ktere", " ", "by", " ", "vzniklo", " ", "bez", " ", "exponencialni", " ",
      "slozky"}], ",", " ", 
    RowBox[{
    "tedy", " ", "kdyby", " ", "byl", " ", "proud", " ", "a", " ", "a", " ", 
     "vy", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Omega]", "*", 
       RowBox[{"(", 
        RowBox[{"t", "+", "faze"}], ")"}]}], "]"}], " ", "a", " ", 
     "vypoctete", " ", "o", " ", "kolik", " ", "je", " ", "teplo", " ", "s", 
     " ", "prechodakem", " ", "vetsi"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"doporucuji", " ", "err", " ", "a", " ", "NMinimize"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"celkem", " ", "10", " ", "bodu"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9090541226357822`*^9, 3.909054131516713*^9}, {
   3.9090542290128546`*^9, 3.9090543641334524`*^9}, {3.9090543975492954`*^9, 
   3.9090547460767217`*^9}, {3.909054854956362*^9, 3.9090548649090605`*^9}, {
   3.9090549638938675`*^9, 3.90905512042113*^9}, {3.9090551652609153`*^9, 
   3.909055273245077*^9}, {3.9090553278699694`*^9, 3.9090553694281683`*^9}, {
   3.9090553995009623`*^9, 3.9090554474025865`*^9}, {3.9090555060040226`*^9, 
   3.9090555750605497`*^9}, {3.9090556135804873`*^9, 
   3.9090560981487417`*^9}, {3.9090562657181053`*^9, 3.909056319060609*^9}, 
   3.909059015043168*^9},ExpressionUUID->"a8f393cd-656c-4a90-b0a2-\
9999bf6559a1"]
},
WindowSize->{1445, 822},
WindowMargins->{{-1719, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>1.8 Inherited,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 833, 20, 416, "Text",ExpressionUUID->"f15ba45f-2733-4ecb-b7fe-3f275e07c373"],
Cell[1394, 42, 163295, 2684, 432, "Text",ExpressionUUID->"e83a5136-12d1-4627-815d-33144d758e1e"],
Cell[164692, 2728, 387, 10, 119, "Input",ExpressionUUID->"e8d2086a-1ae0-42c9-83a8-db53ff58e176"],
Cell[165082, 2740, 2135, 48, 230, "Input",ExpressionUUID->"bc46d219-9522-4cdc-b90b-200478d78e96"],
Cell[167220, 2790, 3013, 69, 329, "Input",ExpressionUUID->"4a31d770-4912-4d25-906e-4369c4d52f17"],
Cell[170236, 2861, 2808, 76, 419, "Input",ExpressionUUID->"c646897c-67f3-451d-a2ba-c616490e7c90"],
Cell[173047, 2939, 1047, 23, 126, "Input",ExpressionUUID->"483eadca-57af-4265-b317-f33cbbe3ed91"],
Cell[174097, 2964, 2069, 57, 126, "Input",ExpressionUUID->"81c11f87-c44e-49c4-8d1d-7cb370dd61b2"],
Cell[176169, 3023, 1379, 31, 126, "Input",ExpressionUUID->"de45368c-3660-4671-a13b-c96c93ed6298"],
Cell[177551, 3056, 1665, 37, 126, "Input",ExpressionUUID->"87c90be0-8f25-4bcf-93d0-4d5a97ab5d29"],
Cell[179219, 3095, 1579, 33, 126, "Input",ExpressionUUID->"703320fb-5fce-4c07-a28d-702c9e44c7ad"],
Cell[180801, 3130, 2188, 55, 126, "Input",ExpressionUUID->"7b7b6dbc-f917-4bf9-89e2-3c8a1d910996"],
Cell[182992, 3187, 1878, 44, 126, "Input",ExpressionUUID->"53308f8b-4a74-4708-a710-ed44e752dd8e"],
Cell[184873, 3233, 2957, 76, 126, "Input",ExpressionUUID->"91970e13-1993-44a1-90f7-f3931eee4302"],
Cell[187833, 3311, 2647, 63, 126, "Input",ExpressionUUID->"a8f393cd-656c-4a90-b0a2-9999bf6559a1"]
}
]
*)

(* End of internal cache information *)

