

ClearAll[Tok, xmax, fourierBitPrecision, fourierRangeLow, fourierRangeHigh, VektorPromennych, chteny,
\[Rho], cp, \[Lambda], korper, zdrojovafce, Fitness, InitialCondition, RightBoundaryCondition];

(* okoli *)
Tok=20+273.15;(* K *)

(* ostatni *)
xmax=.05;(* m *)

fourierBitPrecision=8;
fourierRangeLow=-8.0;
fourierRangeHigh=8.0;

VektorPromennych={
      {tmaxlocal,60,60*60,12},
      {a0,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a1,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b1,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a2,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b2,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a3,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b3,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a4,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b4,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a5,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b5,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {a6,fourierRangeLow,fourierRangeHigh,fourierBitPrecision},
      {b6,fourierRangeLow,fourierRangeHigh,fourierBitPrecision}};

chteny=Tok+10*Sin[Pi*x/xmax];

(* ocel *)
\[Rho]= 7400; (* kg.m^-3 *) cp=2000; (*
  J.kg^-1.K^-1 *) \[Lambda]=51; (* W.m^-1.K^-1 *)

FourierEquation=\[Rho]*cp*D[T[x,t],t] == D[\[Lambda]*D[T[x,t],x],x];
InitialCondition=T[x,0] == Tok;
RightBoundaryCondition=-1*(D[T[x,t],x]/.x\[Rule]xmax) == +5*(T[xmax,t] - Tok);

korper[tmaxlocal_]:=2*Pi/(60*60);

zdrojovafce[tmaxlocal_,a0_,a1_,b1_,a2_,b2_,a3_,b3_, a4_,b4_,a5_,b5_,a6_,b6_]:=
    a0+(a1*Cos[t*korper[tmaxlocal]]+
        b1*Sin[t*korper[tmaxlocal]])+(a2*Cos[2*t*korper[tmaxlocal]]+
        b2*Sin[2*t*korper[tmaxlocal]])+(a3*Cos[3*t*korper[tmaxlocal]]+
        b3*Sin[3*t*korper[tmaxlocal]])+(a4*Cos[4*t*korper[tmaxlocal]]+
        b4*Sin[4*t*korper[tmaxlocal]])+(a5*Cos[5*t*korper[tmaxlocal]]+
        b5*Sin[5*t*korper[tmaxlocal]])+(a6*Cos[6*t*korper[tmaxlocal]]+
        b6*Sin[6*t*korper[tmaxlocal]])

Fitness[{tmaxlocal_, a0_, a1_, b1_, a2_, b2_, a3_, b3_, a4_, b4_, a5_, b5_, a6_, b6_}] :=
    Module[{},
      zdroj = Power[zdrojovafce[tmaxlocal, a0, a1, b1, a2, b2, a3, b3, a4, b4, a5, b5, a6, b6], 2]*t/(t + 1);
      pleft = (-1)*(D[T[x, t], x] /. x \[Rule] 0) == zdroj - 5*(T[0, t] - Tok);
      res = (NDSolve[{FourierEquation, pleft, RightBoundaryCondition, InitialCondition},
            T[x, t], {x, 0, xmax}, {t, 0, tmaxlocal}, MaxSteps \[Rule] 10^5])[[1]];
      tmax = tmaxlocal;
      prubeh[x_] = (T[x, t] /. res) /. t \[Rule] tmax;
      NIntegrate[(chteny - prubeh[x])^2, {x, 0, xmax}]*((60*tmaxlocal)/(60*30) + 1)
    ];

