(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      7889,        253]
NotebookOptionsPosition[      7153,        227]
NotebookOutlinePosition[      7533,        243]
CellTagsIndexPosition[      7490,        240]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costCoefficients", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "0.1", ",", "0.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "0.15", ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "0.08", ",", "0.006"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minMaxPowers", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "1000"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482721896609375*^9, 3.482722028265625*^9}, {
  3.4827221586875*^9, 3.48272216184375*^9}, {3.688282390202379*^9, 
  3.688282403805603*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fCost", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", "power"}], "+", 
    RowBox[{"c", "*", 
     SuperscriptBox["power", "2"]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6882824195772305`*^9, 3.688282420778433*^9}, {
  3.6882824978581686`*^9, 3.6882825041449795`*^9}, {3.688282570959897*^9, 
  3.6882825924255342`*^9}}],

Cell[BoxData[
 RowBox[{"fCost", "[", 
  RowBox[{"P", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6882825204158077`*^9, 3.6882825290270233`*^9}, 
   3.688282596060341*^9}],

Cell[BoxData[{
 RowBox[{"powers", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["P", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "n", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"cost", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"MapThread", "[", 
    RowBox[{"fCost", ",", 
     RowBox[{"{", 
      RowBox[{"powers", ",", "costCoefficients"}], "}"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.688282620068783*^9, 3.688282641799621*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fPowerConstrains", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "\[LessEqual]", "power", "\[LessEqual]", "b"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"powerConstrains", "=", 
  RowBox[{"MapThread", "[", 
   RowBox[{"fPowerConstrains", ",", 
    RowBox[{"{", 
     RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.688282714136948*^9, 3.688282748129408*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"desiredPower", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"conditionOfDesiredPower", "=", 
  RowBox[{"{", 
   RowBox[{"desiredPower", "\[Equal]", 
    RowBox[{"Total", "[", "powers", "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.6882827763654575`*^9, 3.6882828010447006`*^9}, {
  3.844309941484375*^9, 3.844309945625*^9}}],

Cell[BoxData[
 RowBox[{"condionsTogether", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"powerConstrains", ",", "conditionOfDesiredPower"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.68828286884242*^9, 3.6882828998240747`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cost", "}"}], ",", "condionsTogether"}], "]"}], ",", 
    "powers"}], "]"}], "//", "Timing"}]], "Input",
 CellChangeTimes->{{3.8443099710625*^9, 3.844309993640625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"strmost", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "fPenale", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fPenale", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Tanh", "[", 
           RowBox[{"strmost", "*", 
            RowBox[{"(", 
             RowBox[{"x", "-", "a"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"strmost", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "b"}], ")"}]}], "]"}]}], ")"}]}], ")"}], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], "2"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fPenale", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<penale\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.844310042296875*^9, 3.844310042546875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaleCelkovyVykon", "=", 
   RowBox[{"100", "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"desiredPower", "-", 
       RowBox[{"Total", "[", "powers", "]"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"penaleVykonovaOmezeni", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"MapThread", "[", 
     RowBox[{"fPenale", ",", 
      RowBox[{"{", 
       RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.844310083015625*^9, 3.844310114890625*^9}}],

Cell[BoxData[
 RowBox[{"FminNeomezena", "=", 
  RowBox[{
  "cost", "+", "penaleCelkovyVykon", "+", 
   "penaleVykonovaOmezeni"}]}]], "Input",
 CellChangeTimes->{{3.84431012025*^9, 3.844310120796875*^9}}],

Cell[BoxData[{
 RowBox[{"startHledani", "=", 
  RowBox[{"minMaxPowers", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{"a", "+", "b"}], "2."]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"zacatek", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{"powers", ",", "startHledani"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"FminNeomezena", ",", "zacatek"}], "]"}]}], "//", 
  "Timing"}]}], "Input",
 CellChangeTimes->{{3.844310162046875*^9, 3.844310178796875*^9}}]
},
WindowSize->{1264, 698},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.9000002145767212`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 94, 2, 55, "Input"],
Cell[654, 24, 897, 26, 124, "Input"],
Cell[1554, 52, 488, 13, 55, "Input"],
Cell[2045, 67, 236, 6, 55, "Input"],
Cell[2284, 75, 446, 13, 90, "Input"],
Cell[2733, 90, 534, 14, 90, "Input"],
Cell[3270, 106, 374, 8, 90, "Input"],
Cell[3647, 116, 227, 5, 55, "Input"],
Cell[3877, 123, 293, 8, 55, "Input"],
Cell[4173, 133, 1562, 46, 294, "Input"],
Cell[5738, 181, 573, 17, 90, "Input"],
Cell[6314, 200, 203, 5, 55, "Input"],
Cell[6520, 207, 629, 18, 153, "Input"]
}
]
*)

(* End of internal cache information *)
