(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30421,        751]
NotebookOptionsPosition[     26881,        681]
NotebookOutlinePosition[     28073,        713]
CellTagsIndexPosition[     27993,        708]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"podm", "=", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", "3"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fce", "=", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"3", 
       SuperscriptBox["y", "2"]}], "-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"podm0", "=", 
     RowBox[{"podm", "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"lhs_", ",", "rhs_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"lhs", "-", "rhs"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"podm0", "=", 
    RowBox[{"podm", "/.", 
     RowBox[{
      RowBox[{"lhs_", "\[Equal]", "rhs_"}], "\[RuleDelayed]", 
      RowBox[{"lhs", "-", "rhs"}]}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Lagrange", "=", 
     RowBox[{"fce", "+", 
      RowBox[{"\[Lambda]", "*", "podm0"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"0", "\[Equal]", 
      RowBox[{"D", "[", 
       RowBox[{"Lagrange", ",", "#"}], "]"}]}], "&"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "podleCeho_", "]"}], ":=", 
     RowBox[{"0", "==", 
      RowBox[{"D", "[", 
       RowBox[{"Lagrange", ",", "podleCeho"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"f", "/@", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "\[Lambda]"}], "}"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{"Solve", "[", "%", "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.84370328171875*^9, 3.843703281953125*^9}, {
   3.843703622265625*^9, 3.843703873734375*^9}, {3.843703907765625*^9, 
   3.843703949171875*^9}, {3.843704013234375*^9, 3.843704028703125*^9}, 
   3.8437201427084904`*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"90766807-cff9-4459-9cd7-49e34a3a601d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", "x", "+", 
  RowBox[{"2", " ", "y"}]}]], "Output",
 CellChangeTimes->{3.843720086509074*^9, 3.843720143341544*^9, 
  3.843720213519726*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"1080d7fc-d135-4f12-8343-cae845a00902"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", "\[Lambda]"}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"6", " ", "y"}], "+", 
     RowBox[{"2", " ", "\[Lambda]"}]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "x", "+", 
     RowBox[{"2", " ", "y"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.843720086509074*^9, 3.843720143341544*^9, 
  3.843720213519726*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"43841e4c-87c8-4482-951d-8b794b49de28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["9", "7"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["6", "7"]}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["18", "7"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.843720086509074*^9, 3.843720143341544*^9, 
  3.843720213519726*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"ec300de9-63bc-4c30-9081-a949d833bc53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "/@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8437201812076387`*^9, 3.8437201873103523`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"be06c843-f5d0-41fa-aa0e-7e0e2dd3b2f8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ff", "[", "x", "]"}], ",", 
   RowBox[{"ff", "[", "y", "]"}], ",", 
   RowBox[{"ff", "[", "z", "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.843720086509074*^9, 3.8437201433596363`*^9, 
  3.843720188313368*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"2f521a10-7e6a-40c4-b95d-9961e205d15d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"penaleMezi", "[", 
    RowBox[{"xMin_", ",", "xMax_", ",", "strmost_", ",", "promenna_"}], "]"}],
    ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"promenna", "-", "xMin"}], ")"}], "*", "strmost"}], "]"}], 
        "-", 
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"promenna", "-", "xMax"}], ")"}], "*", "strmost"}], 
         "]"}]}], ")"}]}], ")"}], "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"promenna", "-", 
       FractionBox[
        RowBox[{"xMin", "+", "xMax"}], "2"]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tryPenale", "=", 
  RowBox[{"penaleMezi", "[", 
   RowBox[{"2", ",", "4", ",", "100", ",", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{"tryPenale", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.843704095953125*^9, {3.843704505671875*^9, 3.843704622046875*^9}, {
   3.843704672171875*^9, 3.843704775484375*^9}, {3.843704883265625*^9, 
   3.843704942359375*^9}, {3.84370509475*^9, 3.843705102765625*^9}, 
   3.8437204189761276`*^9, 3.84372045944993*^9, 3.8437204896088247`*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"b170861c-0827-4b24-9661-4ebe3a336802"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"100", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "x"}], ")"}]}], "]"}], "-", 
    RowBox[{"Tanh", "[", 
     RowBox[{"100", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "x"}], ")"}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.8437203819398923`*^9, 3.8437204197157297`*^9, {3.8437204677370777`*^9, 
   3.843720490157237*^9}},
 CellLabel->"Out[42]=",ExpressionUUID->"210e405f-dac5-4974-89d1-339f81f8f266"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxF13k0lc//APDn2qnucy11kWTPUnFTstznmbe18rElLUqWUqmEkC0fJKKS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       "]]},
     Annotation[#, "Charting`Private`Tag$5747#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1, 6}, {0., 31.99999771428575}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8437203819398923`*^9, 3.8437204197157297`*^9, {3.8437204677370777`*^9, 
   3.8437204902106085`*^9}},
 CellLabel->"Out[43]=",ExpressionUUID->"79e06017-166d-4e1c-b182-fc3965cc761b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"penaleVetsiNez", "[", 
    RowBox[{"mez_", ",", "promenna_", ",", "strmost_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"strmost", "*", 
         RowBox[{"(", 
          RowBox[{"promenna", "-", "mez"}], ")"}]}], "]"}], "-", "1"}], 
      ")"}]}], "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"promenna", "-", "mez", "-", "1"}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tryPenale", "=", 
   RowBox[{"penaleVetsiNez", "[", 
    RowBox[{"3", ",", "x", ",", "100"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"tryPenale", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.843705043625*^9, 3.8437050658125*^9}, {
  3.843705113953125*^9, 3.843705312953125*^9}, {3.843705348140625*^9, 
  3.84370538609375*^9}},ExpressionUUID->"3f4c6719-becd-4dea-862a-\
737b964c4ec1"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJxN0gk0VcEfB/D3Hu/de+0kWZKQEtFCaXn33R9FEsqWPSUqIrIVoVQSCWVJ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-1, 6}, {0., 49.99999714285718}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.843705255703125*^9, 3.843705313140625*^9}, {
  3.843705368875*^9, 
  3.843705386296875*^9}},ExpressionUUID->"21145e5a-2676-4ecf-bffc-\
7d3bd757ee59"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMin", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"LinearProgramming",
 CellLabel->"In[1]:=",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f"],

Cell[BoxData[
 TemplateBox[{
  "ConstrainedMin","deprec",
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"ConstrainedMin\\\\\\\"\\\"}]\\) is \
deprecated and will not be supported in future versions of the Wolfram \
Language. Use \\!\\(\\*RowBox[{\\\"\\\\\\\"NMinimize or \
Minimize\\\\\\\"\\\"}]\\) instead.\"",2,1,1,31722434842732268524,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.843705796203125*^9, 3.8437196557536464`*^9},
 CellTags->"LinearProgramming",
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fed6de57-9e6e-4dec-804b-584ab1d71636"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.843705796203125*^9, 3.843719655822686*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[1]=",ExpressionUUID->"adedbbfa-9610-4f1b-9a55-2f4ae783355e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"3", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.843706164296875*^9, 3.84370617775*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"4fe1b322-2744-4f4e-ba3d-6fb4afc9e77c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6.`"}], ",", 
     RowBox[{"y", "\[Rule]", "4.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.84370617859375*^9, 3.843719662620743*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"af2e4df0-e2f6-4ef5-b791-54a9f949bab8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "1"}]},
      {"1", "0"}
     }], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"LinearProgramming",
 CellLabel->"In[3]:=",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.843705799296875*^9, 3.843719664463894*^9},
 CellTags->"LinearProgramming",
 CellLabel->"Out[3]=",ExpressionUUID->"9064ac19-68d7-4618-80e3-1930a7a587da"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "*", 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{
    RowBox[{".02", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"0.05", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    SuperscriptBox["y", "2"], "-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{"podminka", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "45"}], "}"}]}], "]"}]}], "Input",ExpressionUUID\
->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"fce", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{"podminka", "\[Equal]", "0"}]}], "}"}], "]"}], "//", "N"}]}], 
  ";"}]}], "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "res"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Element]", "Reals"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{"podminka", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "20"}], ",", "45"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", ".03", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"]
},
WindowSize->{1140, 806},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification:>1.95 Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearProgramming"->{
  Cell[21349, 502, 525, 16, 55, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
   CellTags->"LinearProgramming"],
  Cell[21877, 520, 578, 12, 85, "Message",ExpressionUUID->"fed6de57-9e6e-4dec-804b-584ab1d71636",
   CellTags->"LinearProgramming"],
  Cell[22458, 534, 360, 9, 62, "Output",ExpressionUUID->"adedbbfa-9610-4f1b-9a55-2f4ae783355e",
   CellTags->"LinearProgramming"],
  Cell[23784, 579, 524, 18, 114, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
   CellTags->"LinearProgramming"],
  Cell[24311, 599, 247, 5, 62, "Output",ExpressionUUID->"9064ac19-68d7-4618-80e3-1930a7a587da",
   CellTags->"LinearProgramming"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearProgramming", 27311, 694}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2072, 58, 463, "Input",ExpressionUUID->"90766807-cff9-4459-9cd7-49e34a3a601d"],
Cell[2655, 82, 269, 6, 87, "Output",ExpressionUUID->"1080d7fc-d135-4f12-8343-cae845a00902"],
Cell[2927, 90, 570, 16, 87, "Output",ExpressionUUID->"43841e4c-87c8-4482-951d-8b794b49de28"],
Cell[3500, 108, 471, 13, 109, "Output",ExpressionUUID->"ec300de9-63bc-4c30-9081-a949d833bc53"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4008, 126, 257, 5, 55, "Input",ExpressionUUID->"be06c843-f5d0-41fa-aa0e-7e0e2dd3b2f8"],
Cell[4268, 133, 343, 8, 87, "Output",ExpressionUUID->"2f521a10-7e6a-40c4-b95d-9961e205d15d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4648, 146, 1638, 45, 385, "Input",ExpressionUUID->"b170861c-0827-4b24-9661-4ebe3a336802"],
Cell[6289, 193, 683, 21, 87, "Output",ExpressionUUID->"210e405f-dac5-4974-89d1-339f81f8f266"],
Cell[6975, 216, 8553, 159, 532, "Output",ExpressionUUID->"79e06017-166d-4e1c-b182-fc3965cc761b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15565, 380, 1105, 32, 167, "Input",ExpressionUUID->"3f4c6719-becd-4dea-862a-737b964c4ec1"],
Cell[16673, 414, 4639, 83, 489, "Output",ExpressionUUID->"21145e5a-2676-4ecf-bffc-7d3bd757ee59"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21349, 502, 525, 16, 55, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
 CellTags->"LinearProgramming"],
Cell[21877, 520, 578, 12, 85, "Message",ExpressionUUID->"fed6de57-9e6e-4dec-804b-584ab1d71636",
 CellTags->"LinearProgramming"],
Cell[22458, 534, 360, 9, 62, "Output",ExpressionUUID->"adedbbfa-9610-4f1b-9a55-2f4ae783355e",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22855, 548, 556, 16, 55, "Input",ExpressionUUID->"4fe1b322-2744-4f4e-ba3d-6fb4afc9e77c"],
Cell[23414, 566, 333, 8, 62, "Output",ExpressionUUID->"af2e4df0-e2f6-4ef5-b791-54a9f949bab8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23784, 579, 524, 18, 114, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
 CellTags->"LinearProgramming"],
Cell[24311, 599, 247, 5, 62, "Output",ExpressionUUID->"9064ac19-68d7-4618-80e3-1930a7a587da",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[24573, 607, 700, 21, 130, "Input",ExpressionUUID->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],
Cell[25276, 630, 646, 18, 130, "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],
Cell[25925, 650, 368, 11, 55, "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],
Cell[26296, 663, 581, 16, 93, "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"]
}
]
*)

(* End of internal cache information *)

