(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     12805,        388]
NotebookOptionsPosition[      9563,        319]
NotebookOutlinePosition[     10739,        351]
CellTagsIndexPosition[     10660,        346]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "Graphics`ImplicitPlot`"}]], "Input",ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \\!\\(\\*RowBox[{\\\"\\\\\\\"Graphics`ImplicitPlot`\\\\\\\"\
\\\"}]\\).\"",2,1,1,28795123728089993528,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8436996636210365`*^9},ExpressionUUID->"ecb944fa-3be5-4d46-b9da-\
9ae99f6e5a5a"],

Cell[BoxData["$Failed"], "Output",
 CellChangeTimes->{
  3.843699663636657*^9},ExpressionUUID->"8d7e9dfc-3892-406b-b0b1-\
b83ef3292e53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "Graphics`Graphics`"}]], "Input",ExpressionUUID->"d5574ba4-00f1-47f3-893d-fa79927fb4ff"],

Cell[BoxData[
 TemplateBox[{
  "Get","noopen",
   "\"Cannot open \
\\!\\(\\*RowBox[{\\\"\\\\\\\"Graphics`Graphics`\\\\\\\"\\\"}]\\).\"",2,2,2,
   28795123728089993528,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8436996637993813`*^9},ExpressionUUID->"17fad41b-9ed8-43cd-bf80-\
897e258b69f3"],

Cell[BoxData["$Failed"], "Output",
 CellChangeTimes->{
  3.8436996638058877`*^9},ExpressionUUID->"f1c731c7-b198-4e67-a9aa-\
df4914bd595b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMin", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"3", " ", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
     RowBox[{"x", ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->
  "LinearProgramming",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f"],

Cell[BoxData[
 TemplateBox[{
  "ConstrainedMin","deprec",
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"ConstrainedMin\\\\\\\"\\\"}]\\) is \
deprecated and will not be supported in future versions of the Wolfram \
Language. Use \\!\\(\\*RowBox[{\\\"\\\\\\\"NMinimize or \
Minimize\\\\\\\"\\\"}]\\) instead.\"",2,3,3,28795123728089993528,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8436996638527555`*^9},
 CellTags->
  "LinearProgramming",ExpressionUUID->"d4afc3cd-2924-4cbc-a39d-48b9552170db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.843699663883998*^9},
 CellTags->
  "LinearProgramming",ExpressionUUID->"2492fe36-87c6-4fe8-92c6-ad5041383b85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "1"}]},
      {"1", "0"}
     }], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->
  "LinearProgramming",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.843699663906126*^9},
 CellTags->
  "LinearProgramming",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "*", 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{
    RowBox[{".02", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"0.05", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    SuperscriptBox["y", "2"], "-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{"podminka", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "45"}], "}"}]}], "]"}]}], "Input",ExpressionUUID\
->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],

Cell[BoxData[
 RowBox[{"ImplicitPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{"0.02`", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"0.05`", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "45"}], "}"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.8436996639529943`*^9},ExpressionUUID->"bad380df-5f1f-4f82-8d37-\
427ebc24ec48"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"fce", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"lagrange", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{"podminka", "\[Equal]", "0"}]}], "}"}], "]"}], "//", "N"}]}], 
  ";"}]}], "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],

Cell[BoxData[
 TemplateBox[{
  "Solve","ratnz",
   "\"Solve was unable to solve the system with inexact coefficients. The \
answer was obtained by solving a corresponding exact system and numericizing \
the result.\"",2,9,4,28795123728089993528,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8436996641000986`*^9},ExpressionUUID->"18bdc53f-3c2d-4a3d-a4cc-\
90a847de7072"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "res"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Element]", "Reals"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7.288691475657752`", ",", 
     RowBox[{"-", "1.4684090963635708`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.02312036492725`", ",", 
     RowBox[{"-", "23.092495748456827`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8436996641222625`*^9},ExpressionUUID->"81efd811-368e-429d-b6d2-\
c34855317e43"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{"podminka", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "20"}], ",", "45"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", "0", "]"}], ",", 
        RowBox[{"PointSize", "[", ".03", "]"}]}], "}"}]}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"ImplicitPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "+", 
       RowBox[{"0.02`", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"0.05`", " ", 
        SuperscriptBox["x", "2"], " ", "y"}], "+", 
       SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "20"}], ",", "45"}], "}"}]}], "]"}], ",", 
   GraphicsBox[{{}, {{}, 
      {Hue[0, 1, 1], PointSize[0.03], AbsoluteThickness[1.6], 
       PointBox[{{7.288691475657752, -1.4684090963635708`}, {
        32.02312036492725, -23.092495748456827`}}]}, {}}, {}, {}, {}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{6.902216024262916, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{7.288691475657752, 
      32.02312036492725}, {-23.092495748456827`, 0}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.8436996643384323`*^9},ExpressionUUID->"993617da-9b25-4ee5-b6bb-\
0f5a7196a829"]
}, Open  ]]
},
WindowSize->{859, 646},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearProgramming"->{
  Cell[1820, 65, 505, 16, 35, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
   CellTags->"LinearProgramming"],
  Cell[2328, 83, 510, 10, 54, "Message",ExpressionUUID->"d4afc3cd-2924-4cbc-a39d-48b9552170db",
   CellTags->"LinearProgramming"],
  Cell[2841, 95, 318, 9, 40, "Output",ExpressionUUID->"2492fe36-87c6-4fe8-92c6-ad5041383b85",
   CellTags->"LinearProgramming"],
  Cell[3196, 109, 504, 18, 71, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
   CellTags->"LinearProgramming"],
  Cell[3703, 129, 205, 5, 40, "Output",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807",
   CellTags->"LinearProgramming"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearProgramming", 9987, 332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 121, 1, 35, "Input",ExpressionUUID->"75082594-4e81-4b2b-a3a9-aa704ac7b99f"],
Cell[704, 25, 321, 8, 29, "Message",ExpressionUUID->"ecb944fa-3be5-4d46-b9da-9ae99f6e5a5a"],
Cell[1028, 35, 136, 3, 40, "Output",ExpressionUUID->"8d7e9dfc-3892-406b-b0b1-b83ef3292e53"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1201, 43, 117, 1, 35, "Input",ExpressionUUID->"d5574ba4-00f1-47f3-893d-fa79927fb4ff"],
Cell[1321, 46, 321, 9, 29, "Message",ExpressionUUID->"17fad41b-9ed8-43cd-bf80-897e258b69f3"],
Cell[1645, 57, 138, 3, 40, "Output",ExpressionUUID->"f1c731c7-b198-4e67-a9aa-df4914bd595b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1820, 65, 505, 16, 35, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
 CellTags->"LinearProgramming"],
Cell[2328, 83, 510, 10, 54, "Message",ExpressionUUID->"d4afc3cd-2924-4cbc-a39d-48b9552170db",
 CellTags->"LinearProgramming"],
Cell[2841, 95, 318, 9, 40, "Output",ExpressionUUID->"2492fe36-87c6-4fe8-92c6-ad5041383b85",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3196, 109, 504, 18, 71, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
 CellTags->"LinearProgramming"],
Cell[3703, 129, 205, 5, 40, "Output",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3945, 139, 700, 21, 84, "Input",ExpressionUUID->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],
Cell[4648, 162, 524, 16, 43, "Output",ExpressionUUID->"bad380df-5f1f-4f82-8d37-427ebc24ec48"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5209, 183, 646, 18, 60, "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],
Cell[5858, 203, 399, 9, 54, "Message",ExpressionUUID->"18bdc53f-3c2d-4a3d-a4cc-90a847de7072"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6294, 217, 368, 11, 35, "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],
Cell[6665, 230, 387, 11, 40, "Output",ExpressionUUID->"81efd811-368e-429d-b6d2-c34855317e43"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7089, 246, 581, 16, 60, "Input",ExpressionUUID->"f9e0e8c8-b5d3-46de-b5ad-2bd4c025c3ce"],
Cell[7673, 264, 1874, 52, 121, "Output",ExpressionUUID->"993617da-9b25-4ee5-b6bb-0f5a7196a829"]
}, Open  ]]
}
]
*)

