(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    185614,       3219]
NotebookOptionsPosition[    184201,       3189]
NotebookOutlinePosition[    184724,       3207]
CellTagsIndexPosition[    184681,       3204]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fce", "[", "x_", "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hledej", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "min_", ",", "i_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"normgrad", ",", "newx"}], "}"}], ",", 
    RowBox[{
     RowBox[{"normgrad", "=", 
      RowBox[{"Tanh", "[", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"fce", "'"}], "[", "x", "]"}]}], "]"}]}], ";", 
     RowBox[{"newx", "=", 
      RowBox[{"x", "+", 
       RowBox[{"dx", "*", "normgrad"}]}]}], ";", 
     RowBox[{"{", 
      RowBox[{"newx", ",", 
       RowBox[{"fce", "[", "newx", "]"}], ",", 
       RowBox[{"i", "+", "1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Nest", "[", 
  RowBox[{"hledej", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", "150"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "&"}], ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"body", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "b"}], "}"}]}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<i\>\"", ",", "\"\<f [xi]\>\""}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.451631313859375*^9, 3.451631604796875*^9}, {
   3.45163168234375*^9, 3.451631712953125*^9}, {3.512915605703125*^9, 
   3.512915633140625*^9}, {3.512915734671875*^9, 3.51291580815625*^9}, {
   3.512915893703125*^9, 3.512915939390625*^9}, 3.5129160510625*^9, 
   3.512916767609375*^9, {3.512958601390625*^9, 
   3.512958604921875*^9}},ExpressionUUID->"8f04cb27-a021-4694-b5c3-\
e9688b91d77a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0000000000050788`", ",", "2.579447606194715`*^-23", ",", "151"}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.8436997010057507`*^9},ExpressionUUID->"9db900bc-63f6-4752-8e8e-\
b5c82eefbcd8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"x", "+", "3"}], "2"], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"y", "-", "1"}], "4"], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmin", "=", 
   RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymin", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymax", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pl1", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x \>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.5129161295625*^9, {3.5129164641875*^9, 3.512916488578125*^9}, {
   3.512916597015625*^9, 3.51291660678125*^9}, {3.512916981734375*^9, 
   3.512917000453125*^9}, {3.5129177440625*^9, 3.5129177548125*^9}, {
   3.512917793421875*^9, 3.512917801390625*^9}, {3.51291783534375*^9, 
   3.512917979265625*^9}, {3.51291801275*^9, 3.512918017828125*^9}, {
   3.512918058421875*^9, 3.51291807334375*^9}, {3.5129183208125*^9, 
   3.512918321796875*^9}},ExpressionUUID->"32815cde-7c38-4a4f-b650-\
94876d581471"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHlcTdsb/xtOcxpUyBQ6hgzJLUOG9jEXSuRSZhluhmPIkCmRS+41dgwZ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   "], {{
     {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[
        TagBox[{Polygon3DBox[CompressedData["
1:eJwtmgnYTVUbhs/53r2ojCGVKYRCKIUMKUIhkoaflFApFSUlU8qQEJEMURIV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           "]], Polygon3DBox[CompressedData["
1:eJwtmnfgV1Mfx+8Zl5QSxYOMUrQUySyjKCOhJZWiskVWg0JUGsoKDbMUQpTs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           "]], Polygon3DBox[CompressedData["
1:eJwt13fcl+MaAPD3fb0/TlRokUraWqS9pUXztKlIpaWp9ZKG0RBN7SntQaWl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           "]], 
          Polygon3DBox[{{1098, 718, 384, 385, 719, 1099}, {1196, 632, 430, 
           429, 728, 1103}, {1117, 748, 474, 475, 749, 1118}, {1094, 714, 369,
            370, 715, 1095}, {1200, 645, 445, 444, 734, 1106}, {1047, 619, 
           725, 1239, 896, 897}, {1137, 517, 304, 303, 710, 1090}, {1206, 658,
            460, 459, 741, 1110}, {1113, 744, 459, 460, 745, 1114}, {1124, 
           753, 489, 490, 754, 1125}}]},
         Annotation[#, "Charting`Private`Tag$2517#1"]& ]],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k0vXFEABuAzzCjjq4tGmmhHR1BpykJEGhkrsarVxEpXWLFAwoJf0DZp
0127aCzbxhp/AH/Ad30TC3uqvsVzWLz3ec/N3HPuOXey/SP54UQI4bPUKLFX
uxwxXRjCUz5nDV+zmW3sYBe72cMPHOAQxzguk/o3fuIUf3CavznHOS5yMT6b
DOGWWWuv8CWfyYmsGp9yjf+4zjNu8D//8pyb8X5BeNjEhWzFykvZ1q+4w2vu
8oZ7vOU+73jAC3MU6rVyaJxhVfyNd102XuIC5znLGf7iH37nT37kV36RCX2U
g+xjL/N8z07m2Mom1jMTz9Z5HPOVdSv5gk8kJxXG7SznO5bFb8LSOA/TbGFJ
3Ku9FOnFcf96Sm+Ocxm/ZRHfMMVGWjY00GuEOsbjvHRJJh7/H/dZf0Du
       "]]}, 
     {GrayLevel[0.2], 
      Line3DBox[{778, 1089, 1241, 992, 777, 1242, 993, 779, 1243, 994, 780, 
       1244, 995, 781, 1245, 996, 782, 1246, 997, 783, 1434, 1090, 1137, 1433,
        784, 1091, 1247, 998, 785, 1248, 999, 786, 1249, 1000, 787, 1250, 
       1001, 788, 1251, 1002, 789, 1252, 1003, 790, 1435, 1092, 1004, 1093}], 
      Line3DBox[{792, 1138, 1339, 791, 1253, 1005, 793, 1254, 1006, 794, 1255,
        1007, 795, 1256, 1008, 796, 1257, 1009, 797, 1258, 1139, 1340, 798, 
       1140, 1341, 799, 1259, 1010, 800, 1260, 1011, 801, 1261, 1012, 802, 
       1262, 1013, 803, 1263, 1014, 804, 1264, 1015, 805}], 
      Line3DBox[{807, 1141, 1342, 806, 1142, 1343, 808, 1265, 1016, 809, 1266,
        1017, 810, 1267, 1018, 811, 1268, 1019, 812, 1269, 1143, 1344, 813, 
       1144, 1345, 814, 1145, 1346, 815, 1270, 1020, 816, 1271, 1021, 817, 
       1272, 1022, 818, 1273, 1023, 819, 1274, 1024, 820}], 
      Line3DBox[{822, 1146, 1347, 821, 1147, 1348, 823, 1148, 1349, 824, 1275,
        1025, 825, 1276, 1026, 826, 1277, 1027, 827, 1278, 1149, 1350, 828, 
       1150, 1351, 829, 1151, 1352, 830, 1152, 1353, 831, 1279, 1028, 832, 
       1280, 1029, 833, 1281, 1030, 834, 1282, 1031, 835}], 
      Line3DBox[{837, 1153, 1354, 836, 1154, 1355, 838, 1155, 1356, 839, 1156,
        1357, 840, 1283, 1032, 841, 1284, 1033, 842, 1285, 1157, 1358, 843, 
       1158, 1359, 844, 1159, 1360, 845, 1160, 1361, 846, 1161, 1362, 847, 
       1286, 1034, 848, 1287, 1035, 849, 1288, 1036, 850}], 
      Line3DBox[{852, 1162, 1363, 851, 1163, 1364, 853, 1164, 1365, 854, 1165,
        1366, 855, 1166, 1367, 856, 1289, 1037, 857, 1436, 1094, 1095, 1458, 
       858, 1096, 1097, 1437, 859, 1167, 1368, 860, 1168, 1369, 861, 1169, 
       1370, 862, 1170, 1371, 863, 1290, 1038, 864, 1291, 1039, 865}], 
      Line3DBox[{867, 1171, 1372, 866, 1172, 1373, 868, 1173, 1374, 869, 1174,
        1375, 870, 1175, 1376, 871, 1176, 1377, 872, 1438, 1098, 1099, 1459, 
       873, 1100, 1378, 1236, 874, 1177, 1379, 875, 1178, 1380, 876, 1179, 
       1381, 877, 1180, 1382, 878, 1181, 1383, 879, 1292, 1040, 880}], 
      Line3DBox[{884, 1293, 1041, 882, 1294, 1042, 886, 1295, 1043, 888, 1296,
        1044, 890, 1297, 1045, 892, 1298, 1046, 894, 724, 1188, 1439, 1129, 
       1102, 1299, 1047, 897, 1300, 1048, 899, 1301, 1049, 901, 1302, 1050, 
       903, 1303, 1051, 905, 1304, 1052, 907, 1305, 1053, 909}], 
      Line3DBox[{908, 1398, 1194, 906, 1397, 1193, 904, 1396, 1192, 902, 1395,
        1191, 900, 1394, 1190, 898, 1393, 1189, 896, 1239, 1392, 1101, 895, 
       1238, 1391, 1390, 1237, 893, 1389, 1187, 891, 1388, 1186, 889, 1387, 
       1185, 887, 1386, 1184, 885, 1385, 1183, 881, 1384, 1182, 883}], 
      Line3DBox[{911, 1195, 1399, 910, 1306, 1054, 912, 1307, 1055, 913, 1308,
        1056, 914, 1309, 1057, 915, 1310, 1058, 916, 1441, 1103, 1196, 1440, 
       1130, 1104, 1197, 1442, 917, 1311, 1059, 918, 1312, 1060, 919, 1313, 
       1061, 920, 1314, 1062, 921, 1315, 1063, 922, 1316, 1064, 923}], 
      Line3DBox[{925, 1198, 1400, 924, 1199, 1401, 926, 1317, 1065, 927, 1318,
        1066, 928, 1319, 1067, 929, 1443, 1105, 1068, 1131, 1460, 1106, 1200, 
       1444, 1132, 1107, 1201, 1445, 1133, 1108, 1202, 1446, 930, 1320, 1069, 
       931, 1321, 1070, 932, 1322, 1071, 933, 1323, 1072, 934, 1324, 1073, 
       935}], Line3DBox[{937, 1203, 1402, 936, 1204, 1403, 938, 1205, 1404, 
       939, 1325, 1074, 940, 1326, 1075, 941, 1447, 1109, 1076, 1134, 1461, 
       1110, 1206, 1448, 1135, 1111, 1207, 1449, 1136, 1112, 1208, 1450, 942, 
       1209, 1405, 943, 1327, 1077, 944, 1328, 1078, 945, 1329, 1079, 946, 
       1330, 1080, 947}], 
      Line3DBox[{949, 1210, 1406, 948, 1211, 1407, 950, 1212, 1408, 951, 1213,
        1409, 952, 1331, 1081, 953, 1332, 1082, 954, 1451, 1113, 1114, 1462, 
       955, 1115, 1116, 1452, 956, 1214, 1410, 957, 1215, 1411, 958, 1216, 
       1412, 959, 1333, 1083, 960, 1334, 1084, 961, 1335, 1085, 962}], 
      Line3DBox[{964, 1217, 1413, 963, 1218, 1414, 965, 1219, 1415, 966, 1220,
        1416, 967, 1221, 1417, 968, 1336, 1086, 969, 1453, 1117, 1118, 1463, 
       970, 1119, 1120, 1454, 971, 1222, 1418, 972, 1223, 1419, 973, 1224, 
       1420, 974, 1225, 1421, 975, 1337, 1087, 976, 1338, 1088, 977}], 
      Line3DBox[{991, 1128, 1127, 1457, 990, 1432, 1235, 989, 1431, 1234, 988,
        1430, 1233, 987, 1429, 1232, 986, 1428, 1231, 985, 1240, 1427, 1126, 
       984, 1464, 1125, 1124, 1456, 983, 1426, 1230, 982, 1425, 1229, 981, 
       1424, 1228, 980, 1423, 1227, 979, 1422, 1226, 978, 1455, 1122, 1121, 
       1123}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{292, 512, 1242, 293, 525, 1253, 319, 1343, 540, 334, 1348, 
       555, 349, 1355, 570, 364, 1364, 585, 379, 1373, 599, 394, 1385, 613, 
       1294, 409, 627, 1306, 424, 1401, 641, 439, 1403, 654, 454, 1407, 667, 
       469, 1414, 681, 484, 1422, 695, 499}], 
      Line3DBox[{294, 513, 1243, 295, 526, 1254, 320, 541, 1265, 335, 1349, 
       556, 350, 1356, 571, 365, 1365, 586, 380, 1374, 600, 395, 1386, 614, 
       1295, 410, 628, 1307, 425, 642, 1317, 440, 1404, 655, 455, 1408, 668, 
       470, 1415, 682, 485, 1423, 696, 500}], 
      Line3DBox[{296, 514, 1244, 297, 527, 1255, 321, 542, 1266, 336, 557, 
       1275, 351, 1357, 572, 366, 1366, 587, 381, 1375, 601, 396, 1387, 615, 
       1296, 411, 629, 1308, 426, 643, 1318, 441, 656, 1325, 456, 1409, 669, 
       471, 1416, 683, 486, 1424, 697, 501}], 
      Line3DBox[{298, 515, 1245, 299, 528, 1256, 322, 543, 1267, 337, 558, 
       1276, 352, 573, 1283, 367, 1367, 588, 382, 1376, 602, 397, 1388, 616, 
       1297, 412, 630, 1309, 427, 644, 1319, 442, 657, 1326, 457, 670, 1331, 
       472, 1417, 684, 487, 1425, 698, 502}], 
      Line3DBox[{300, 516, 1246, 301, 529, 1257, 323, 544, 1268, 338, 559, 
       1277, 353, 574, 1284, 368, 589, 1289, 383, 1377, 603, 398, 1389, 617, 
       1298, 413, 631, 1310, 428, 730, 1443, 731, 443, 737, 1447, 738, 458, 
       671, 1332, 473, 685, 1336, 488, 1426, 699, 503}], 
      Line3DBox[{302, 708, 1434, 710, 303, 530, 1258, 324, 545, 1269, 339, 
       560, 1278, 354, 575, 1285, 369, 714, 1436, 716, 384, 718, 1438, 720, 
       399, 1390, 722, 724, 414, 726, 1441, 728, 429, 732, 768, 1460, 734, 
       444, 739, 771, 1461, 741, 459, 744, 1451, 746, 474, 748, 1453, 750, 
       489, 753, 1456, 755, 757}], 
      Line3DBox[{306, 519, 1248, 307, 533, 1259, 327, 1346, 548, 342, 1352, 
       563, 357, 1360, 578, 372, 1368, 592, 387, 1379, 606, 402, 1393, 620, 
       1300, 417, 634, 1311, 432, 736, 1446, 647, 447, 743, 1450, 660, 462, 
       1410, 674, 477, 1418, 688, 492, 1428, 702, 506}], 
      Line3DBox[{308, 520, 1249, 309, 534, 1260, 328, 549, 1270, 343, 1353, 
       564, 358, 1361, 579, 373, 1369, 593, 388, 1380, 607, 403, 1394, 621, 
       1301, 418, 635, 1312, 433, 648, 1320, 448, 1405, 661, 463, 1411, 675, 
       478, 1419, 689, 493, 1429, 703, 507}], 
      Line3DBox[{310, 521, 1250, 311, 535, 1261, 329, 550, 1271, 344, 565, 
       1279, 359, 1362, 580, 374, 1370, 594, 389, 1381, 608, 404, 1395, 622, 
       1302, 419, 636, 1313, 434, 649, 1321, 449, 662, 1327, 464, 1412, 676, 
       479, 1420, 690, 494, 1430, 704, 508}], 
      Line3DBox[{312, 522, 1251, 313, 536, 1262, 330, 551, 1272, 345, 566, 
       1280, 360, 581, 1286, 375, 1371, 595, 390, 1382, 609, 405, 1396, 623, 
       1303, 420, 637, 1314, 435, 650, 1322, 450, 663, 1328, 465, 677, 1333, 
       480, 1421, 691, 495, 1431, 705, 509}], 
      Line3DBox[{314, 523, 1252, 315, 537, 1263, 331, 552, 1273, 346, 567, 
       1281, 361, 582, 1287, 376, 596, 1290, 391, 1383, 610, 406, 1397, 624, 
       1304, 421, 638, 1315, 436, 651, 1323, 451, 664, 1329, 466, 678, 1334, 
       481, 692, 1337, 496, 1432, 706, 510}], 
      Line3DBox[{316, 712, 1435, 713, 317, 538, 1264, 332, 553, 1274, 347, 
       568, 1282, 362, 583, 1288, 377, 597, 1291, 392, 611, 1292, 407, 1398, 
       625, 1305, 422, 639, 1316, 437, 652, 1324, 452, 665, 1330, 467, 679, 
       1335, 482, 693, 1338, 497, 758, 1457, 759, 760}], 
      Line3DBox[{498, 694, 1455, 752, 483, 680, 1413, 468, 666, 1406, 453, 
       653, 1402, 438, 640, 1400, 423, 626, 1399, 408, 1293, 612, 1384, 393, 
       598, 1372, 378, 584, 1363, 363, 569, 1354, 348, 554, 1347, 333, 539, 
       1342, 318, 524, 1339, 291, 1241, 511, 707, 761}], 
      Line3DBox[{504, 700, 776, 1464, 754, 490, 686, 775, 1463, 749, 475, 672,
        774, 1462, 745, 460, 658, 1448, 772, 740, 445, 645, 1444, 769, 733, 
       430, 632, 1440, 767, 727, 415, 618, 1439, 766, 723, 1391, 400, 604, 
       765, 1459, 719, 385, 590, 764, 1458, 715, 370, 576, 1358, 355, 561, 
       1350, 340, 546, 1344, 325, 531, 1340, 304, 517, 1433, 709, 762}], 
      Line3DBox[{505, 701, 756, 1427, 491, 687, 1454, 751, 476, 673, 1452, 
       747, 461, 659, 1449, 773, 742, 446, 646, 1445, 770, 735, 431, 633, 
       1442, 729, 416, 1299, 619, 725, 1392, 401, 605, 721, 1378, 386, 591, 
       1437, 717, 371, 577, 1359, 356, 562, 1351, 341, 547, 1345, 326, 532, 
       1341, 305, 1247, 518, 711, 763}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxsvHk0ld///i+RkkqpkEQqKRVJaaCnIZmSJg0kQxJlSEIRGVJIIioZI1NJ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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["\"x \"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->{{-7, 1}, {-6, 4}, {0., 7.062498232142971}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8436997013598523`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"f9da54cf-f545-4c0a-8729-a8de89717ab3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3.`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8436997014132214`*^9},ExpressionUUID->"f7b85641-1729-485a-9d9b-\
2277f0aa6a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", 
    RowBox[{"xx_", ",", "yy_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[RuleDelayed]", "xx"}], ",", 
      RowBox[{"y", "\[RuleDelayed]", "yy"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "0.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k0", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hledej", "[", 
    RowBox[{"{", 
     RowBox[{"i_", ",", 
      RowBox[{"b", ":", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}]}], ",", "hodn_", ",", "k_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gr", ",", "newbod"}], "}"}], ",", 
     RowBox[{
      RowBox[{"gr", "=", 
       RowBox[{"grad", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ";", 
      RowBox[{"newbod", "=", 
       RowBox[{"b", "-", 
        RowBox[{"dx", "*", "k", "*", 
         FractionBox["gr", 
          RowBox[{"Norm", "[", "gr", "]"}]]}]}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "newbod", ",", 
        RowBox[{"vyr", "[", 
         RowBox[{"Sequence", "@@", "newbod"}], "]"}], ",", 
        RowBox[{"k", "*", "q"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"vyr", "[", 
      RowBox[{"4", ",", "5"}], "]"}], ",", "k0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", "poc", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], ">", "0.01"}], "&"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"dat", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", "b", "}"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Bold"}], "]"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "1"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"dat", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"min", "[", 
  RowBox[{"[", "2", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.51291652671875*^9, 3.512916536375*^9}, {
   3.512916577625*^9, 3.512916578171875*^9}, {3.5129166568125*^9, 
   3.512916739546875*^9}, {3.51291678884375*^9, 3.5129168789375*^9}, {
   3.512916913953125*^9, 3.512916964390625*^9}, {3.512917078265625*^9, 
   3.512917130875*^9}, {3.512917164609375*^9, 3.512917242546875*^9}, {
   3.5129172891875*^9, 3.51291739909375*^9}, {3.51291744190625*^9, 
   3.51291748215625*^9}, {3.51291751515625*^9, 3.5129175488125*^9}, {
   3.512917723765625*^9, 3.51291773278125*^9}, {3.51291810890625*^9, 
   3.512918160453125*^9}, {3.5129182040625*^9, 3.5129182528125*^9}, {
   3.512918288109375*^9, 3.512918419578125*^9}, {3.51291846996875*^9, 
   3.51291855353125*^9}, 3.512918588453125*^9, {3.512958628359375*^9, 
   3.512958675359375*^9}},ExpressionUUID->"7da12926-cff1-41fb-a6b7-\
1fd4fcd7ea91"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[{{1., 5.}, {1., 5.}}]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{0.6119429999418673, 4.902985749985467}, {0.6119429999418673, 
      4.902985749985467}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{0.24509328952911474`, 4.803883328369849}, {
      0.24509328952911474`, 4.803883328369849}}]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.10133772040230743`, 
      4.7023621219256055`}, {-0.10133772040230743`, 4.7023621219256055`}}]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.42803634235565, 4.598041879816095}, {-0.42803634235565, 
      4.598041879816095}}]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.7355729797367725, 4.490484984757889}, {-0.7355729797367725,
       4.490484984757889}}]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-1.0243828100632106`, 
      4.379189018142047}, {-1.0243828100632106`, 4.379189018142047}}]}, 
    {RGBColor[1, 0.75, 0], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.294739078511094, 4.263581483193161}, {-1.294739078511094, 
      4.263581483193161}}]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.546717351054574, 4.143020515942196}, {-1.546717351054574, 
      4.143020515942196}}]}, 
    {RGBColor[0.571589, 0.586483, 0.], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.7801502268649738`, 
      4.016808949613396}, {-1.7801502268649738`, 4.016808949613396}}]}, 
    {RGBColor[0.915, 0.3325, 0.2125], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.994576009945535, 3.8842349155659894`}, {-1.994576009945535,
       3.8842349155659894`}}]}, 
    {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.18919518288633, 3.744660114440544}, {-2.18919518288633, 
      3.744660114440544}}]}, 
    {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
     PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.3628703578252854`, 
      3.5976829025819814`}, {-2.3628703578252854`, 3.5976829025819814`}}]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.5142402327851276`, 
      3.4433929001552355`}, {-2.5142402327851276`, 3.4433929001552355`}}]}, 
    {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.6420443301759198`, 
      3.2826778485743597`}, {-2.6420443301759198`, 3.2826778485743597`}}]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.745699132781138, 3.117426574637587}, {-2.745699132781138, 
      3.117426574637587}}]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.8259451073366177`, 
      2.950385304891122}, {-2.8259451073366177`, 2.950385304891122}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.8851312214580256`, 
      2.784581681865062}, {-2.8851312214580256`, 2.784581681865062}}]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.926832472115632, 2.62261580876397}, {-2.926832472115632, 
      2.62261580876397}}]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.9550354889755233`, 
      2.4662532038799476`}, {-2.9550354889755233`, 2.4662532038799476`}}]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.973412986305614, 2.316434692983255}, {-2.973412986305614, 
      2.316434692983255}}]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.984959471055754, 2.173505956403338}, {-2.984959471055754, 
      2.173505956403338}}]}, 
    {RGBColor[1, 0.75, 0], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.9919341388190253`, 
      2.037459973671054}, {-2.9919341388190253`, 2.037459973671054}}]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.995956756766151, 1.9081090892497552`}, {-2.995956756766151,
       1.9081090892497552`}}]}, 
    {RGBColor[0.571589, 0.586483, 0.], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.9981459590205652`, 
      1.785185834917927}, {-2.9981459590205652`, 1.785185834917927}}]}, 
    {RGBColor[0.915, 0.3325, 0.2125], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.99924905680324, 1.668395434504318}, {-2.99924905680324, 
      1.668395434504318}}]}, 
    {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.9997476878796503`, 
      1.557440725675338}, {-2.9997476878796503`, 1.557440725675338}}]}, 
    {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
     PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.9999385292064606`, 
      1.4520328606483612`}, {-2.9999385292064606`, 1.4520328606483612`}}]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.999992999043209, 1.351895239565806}, {-2.999992999043209, 
      1.351895239565806}}]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{-3., 1.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[
    RGBColor[0, 0, 1], Bold],
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3., 1.}, {1., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.84369970156033*^9},ExpressionUUID->"35c5796e-85ad-4074-a1db-69c9dd75cea6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"29", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.999992999043209`"}], ",", "1.351895239565806`"}], "}"}], 
   ",", "0.007739391239070596`", ",", "0.9513075410213284`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.843699701644944*^9},ExpressionUUID->"425217e2-057a-4f3d-837a-\
3d50033a7bf8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "3.`"}]}], ",", 
   RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8436997017295732`*^9},ExpressionUUID->"dfbe2212-68df-4c0d-b4d0-\
3c98dfbe5000"]
}, Open  ]]
},
WindowSize->{1006, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 2506, 73, 316, "Input",ExpressionUUID->"8f04cb27-a021-4694-b5c3-e9688b91d77a"],
Cell[3076, 97, 232, 6, 54, "Output",ExpressionUUID->"9db900bc-63f6-4752-8e8e-b5c82eefbcd8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3345, 108, 1946, 55, 286, "Input",ExpressionUUID->"32815cde-7c38-4a4f-b650-94876d581471"],
Cell[5294, 165, 166456, 2722, 443, 87494, 1427, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"f9da54cf-f545-4c0a-8729-a8de89717ab3"],
Cell[171753, 2889, 318, 10, 49, "Output",ExpressionUUID->"f7b85641-1729-485a-9d9b-2277f0aa6a00"]
}, Open  ]],
Cell[CellGroupData[{
Cell[172108, 2904, 3844, 108, 464, "Input",ExpressionUUID->"7da12926-cff1-41fb-a6b7-1fd4fcd7ea91"],
Cell[175955, 3014, 7618, 150, 390, "Output",ExpressionUUID->"35c5796e-85ad-4074-a1db-69c9dd75cea6"],
Cell[183576, 3166, 345, 10, 49, "Output",ExpressionUUID->"425217e2-057a-4f3d-837a-3d50033a7bf8"],
Cell[183924, 3178, 261, 8, 49, "Output",ExpressionUUID->"dfbe2212-68df-4c0d-b4d0-3c98dfbe5000"]
}, Open  ]]
}
]
*)

