(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     36302,        867]
NotebookOptionsPosition[     34764,        811]
NotebookOutlinePosition[     35141,        827]
CellTagsIndexPosition[     35098,        824]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costCoefficients", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "0.1", ",", "0.01"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "0.15", ",", "0.015"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"150", ",", "0.08", ",", "0.006"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"minMaxPowers", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "200"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "1000"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.482721896609375*^9, 3.482722028265625*^9}, {
  3.4827221586875*^9, 3.48272216184375*^9}, {3.688282390202379*^9, 
  3.688282403805603*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fCost", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "+", 
    RowBox[{"b", "*", "power"}], "+", 
    RowBox[{"c", "*", 
     SuperscriptBox["power", "2"]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6882824195772305`*^9, 3.688282420778433*^9}, {
  3.6882824978581686`*^9, 3.6882825041449795`*^9}, {3.688282570959897*^9, 
  3.6882825924255342`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fCost", "[", 
  RowBox[{"P", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6882825204158077`*^9, 3.6882825290270233`*^9}, 
   3.688282596060341*^9}],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "P"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["P", "2"]}]}]], "Output",
 CellChangeTimes->{{3.6882825294014235`*^9, 3.6882825966219416`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"powers", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["P", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "n", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"cost", "=", 
  RowBox[{"Plus", "@@", 
   RowBox[{"MapThread", "[", 
    RowBox[{"fCost", ",", 
     RowBox[{"{", 
      RowBox[{"powers", ",", "costCoefficients"}], "}"}]}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.688282620068783*^9, 3.688282641799621*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["P", "1"], ",", 
   SubscriptBox["P", "2"], ",", 
   SubscriptBox["P", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823171318507`*^9, 3.6882826430944233`*^9}],

Cell[BoxData[
 RowBox[{"300", "+", 
  RowBox[{"0.1`", " ", 
   SubscriptBox["P", "1"]}], "+", 
  RowBox[{"0.01`", " ", 
   SubsuperscriptBox["P", "1", "2"]}], "+", 
  RowBox[{"0.15`", " ", 
   SubscriptBox["P", "2"]}], "+", 
  RowBox[{"0.015`", " ", 
   SubsuperscriptBox["P", "2", "2"]}], "+", 
  RowBox[{"0.08`", " ", 
   SubscriptBox["P", "3"]}], "+", 
  RowBox[{"0.006`", " ", 
   SubsuperscriptBox["P", "3", "2"]}]}]], "Output",
 CellChangeTimes->{3.6882823171318507`*^9, 3.6882826430944233`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fPowerConstrains", "[", 
    RowBox[{"power_", ",", 
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"a", "\[LessEqual]", "power", "\[LessEqual]", "b"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"powerConstrains", "=", 
  RowBox[{"MapThread", "[", 
   RowBox[{"fPowerConstrains", ",", 
    RowBox[{"{", 
     RowBox[{"powers", ",", "minMaxPowers"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.688282714136948*^9, 3.688282748129408*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"100", "\[LessEqual]", 
    SubscriptBox["P", "1"], "\[LessEqual]", "400"}], ",", 
   RowBox[{"50", "\[LessEqual]", 
    SubscriptBox["P", "2"], "\[LessEqual]", "200"}], ",", 
   RowBox[{"200", "\[LessEqual]", 
    SubscriptBox["P", "3"], "\[LessEqual]", "1000"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823171630507`*^9, 3.688282748644209*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"desiredPower", "=", "500"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"conditionOfDesiredPower", "=", 
  RowBox[{"{", 
   RowBox[{"desiredPower", "\[Equal]", 
    RowBox[{"Plus", "@@", "powers"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.6882827763654575`*^9, 3.6882828010447006`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"500", "\[Equal]", 
   RowBox[{
    SubscriptBox["P", "1"], "+", 
    SubscriptBox["P", "2"], "+", 
    SubscriptBox["P", "3"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.688282317178651*^9, 3.688282802479903*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"condionsTogether", "=", 
  RowBox[{"Union", "[", 
   RowBox[{"powerConstrains", ",", "conditionOfDesiredPower"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.68828286884242*^9, 3.6882828998240747`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"500", "\[Equal]", 
    RowBox[{
     SubscriptBox["P", "1"], "+", 
     SubscriptBox["P", "2"], "+", 
     SubscriptBox["P", "3"]}]}], ",", 
   RowBox[{"50", "\[LessEqual]", 
    SubscriptBox["P", "2"], "\[LessEqual]", "200"}], ",", 
   RowBox[{"100", "\[LessEqual]", 
    SubscriptBox["P", "1"], "\[LessEqual]", "400"}], ",", 
   RowBox[{"200", "\[LessEqual]", 
    SubscriptBox["P", "3"], "\[LessEqual]", "1000"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823172098513`*^9, 3.6882829004792757`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "naklady", "}"}], ",", "podminkyCelkem"}], "]"}], ",", 
    "vykony"}], "]"}], "//", "Timing"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07800050000000000038902214782865485176`4.912697299900168", ",", 
   RowBox[{"{", 
    RowBox[{"1099.9416666666666`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["P", "1"], "\[Rule]", "149.9999999943138`"}], ",", 
       RowBox[{
        SubscriptBox["P", "2"], "\[Rule]", "98.33333333030201`"}], ",", 
       RowBox[{
        SubscriptBox["P", "3"], "\[Rule]", "251.66666667538416`"}]}], "}"}]}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823172878513`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"strmost", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClearAll", "[", "fPenale", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fPenale", "[", 
     RowBox[{"x_", ",", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Tanh", "[", 
           RowBox[{"strmost", "*", 
            RowBox[{"(", 
             RowBox[{"x", "-", "a"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"strmost", "*", 
           RowBox[{"(", 
            RowBox[{"x", "-", "b"}], ")"}]}], "]"}]}], ")"}]}], ")"}], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"0.5", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], "2"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fPenale", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<penale\>\""}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJxFe3k0Ve//PUJI5iSZkznjHXHOed17kUSGTKmEzFMIIakUkUwZEkKFihJS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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"penale\"", TraditionalForm]},
  AxesOrigin->{10., 0},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6882823173190513`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaleCelkovyVykon", "=", 
   RowBox[{"100", "*", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"vykonCelkemZadany", "-", 
       RowBox[{"Plus", "@@", "vykony"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"penaleVykonovaOmezeni", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"MapThread", "[", 
     RowBox[{"fPenale", ",", 
      RowBox[{"{", 
       RowBox[{"vykony", ",", "minMaxVykony"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FminNeomezena", "=", 
  RowBox[{
  "naklady", "+", "penaleCelkovyVykon", "+", 
   "penaleVykonovaOmezeni"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"300", "+", 
  RowBox[{"0.1`", " ", 
   SubscriptBox["P", "1"]}], "+", 
  RowBox[{"0.01`", " ", 
   SubsuperscriptBox["P", "1", "2"]}], "+", 
  RowBox[{"0.15`", " ", 
   SubscriptBox["P", "2"]}], "+", 
  RowBox[{"0.015`", " ", 
   SubsuperscriptBox["P", "2", "2"]}], "+", 
  RowBox[{"100", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"500", "-", 
      SubscriptBox["P", "1"], "-", 
      SubscriptBox["P", "2"], "-", 
      SubscriptBox["P", "3"]}], ")"}], "2"]}], "+", 
  RowBox[{"0.08`", " ", 
   SubscriptBox["P", "3"]}], "+", 
  RowBox[{"0.006`", " ", 
   SubsuperscriptBox["P", "3", "2"]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "250.`"}], "+", 
      SubscriptBox["P", "1"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "400"}], "+", 
         SubscriptBox["P", "1"]}], ")"}]}], "]"}], "-", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "100"}], "+", 
         SubscriptBox["P", "1"]}], ")"}]}], "]"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "125.`"}], "+", 
      SubscriptBox["P", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "200"}], "+", 
         SubscriptBox["P", "2"]}], ")"}]}], "]"}], "-", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "50"}], "+", 
         SubscriptBox["P", "2"]}], ")"}]}], "]"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "600.`"}], "+", 
      SubscriptBox["P", "3"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1000"}], "+", 
         SubscriptBox["P", "3"]}], ")"}]}], "]"}], "-", 
     RowBox[{"Tanh", "[", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "200"}], "+", 
         SubscriptBox["P", "3"]}], ")"}]}], "]"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.688282317350251*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"startHledani", "=", 
  RowBox[{"minMaxVykony", "/.", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}], "\[RuleDelayed]", 
    FractionBox[
     RowBox[{"a", "+", "b"}], "2."]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"zacatek", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{"{", 
    RowBox[{"vykony", ",", "startHledani"}], "}"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{"FminNeomezena", ",", "zacatek"}], "]"}]}], "//", 
  "Timing"}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"250.`", ",", "125.`", ",", "600.`"}], "}"}]], "Output",
 CellChangeTimes->{3.6882823173658514`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "1"], ",", "250.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "2"], ",", "125.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["P", "3"], ",", "600.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823173658514`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{"1099.917642387395`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["P", "1"], "\[Rule]", "149.99535017812119`"}], ",", 
       RowBox[{
        SubscriptBox["P", "2"], "\[Rule]", "98.33023339565581`"}], ",", 
       RowBox[{
        SubscriptBox["P", "3"], "\[Rule]", "251.65891689115665`"}]}], "}"}]}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6882823173658514`*^9}]
}, Open  ]]
},
WindowSize->{1264, 889},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->2.499999761581421,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 94, 2, 103, "Input"],
Cell[654, 24, 897, 26, 284, "Input"],
Cell[1554, 52, 488, 13, 106, "Input"],
Cell[CellGroupData[{
Cell[2067, 69, 236, 6, 103, "Input"],
Cell[2306, 77, 201, 5, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2544, 87, 446, 13, 194, "Input"],
Cell[2993, 102, 220, 6, 103, "Output"],
Cell[3216, 110, 501, 14, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3754, 129, 534, 14, 194, "Input"],
Cell[4291, 145, 401, 9, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4729, 159, 323, 7, 194, "Input"],
Cell[5055, 168, 252, 7, 103, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5344, 180, 227, 5, 149, "Input"],
Cell[5574, 187, 556, 14, 181, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6167, 206, 230, 7, 149, "Input"],
Cell[6400, 215, 547, 14, 149, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6984, 234, 1495, 45, 468, "Input"],
Cell[8482, 281, 21581, 360, 651, "Output"]
}, Open  ]],
Cell[30078, 644, 507, 16, 205, "Input"],
Cell[CellGroupData[{
Cell[30610, 664, 144, 4, 155, "Input"],
Cell[30757, 670, 2390, 81, 299, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33184, 756, 563, 17, 247, "Input"],
Cell[33750, 775, 139, 3, 105, "Output"],
Cell[33892, 780, 361, 12, 105, "Output"],
Cell[34256, 794, 492, 14, 142, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
