(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33436,        903]
NotebookOptionsPosition[     31151,        863]
NotebookOutlinePosition[     31801,        886]
CellTagsIndexPosition[     31758,        883]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"exp", ",", 
    RowBox[{"{", 
     RowBox[{"HoldAll", ",", "Listable"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"exp", "[", "co_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "graf"}], "}"}], ",", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "co", "]"}], "]"}]}], ";", 
      RowBox[{"graf", ":=", 
       RowBox[{"Evaluate", "[", "co", "]"}]}], ";", 
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"Evaluate", "[", 
         RowBox[{"a", "<>", "\"\<.png\>\""}], "]"}], ",", "graf", ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.638609350415511*^9, 3.6386093508061357`*^9}, {
   3.638612154478011*^9, 3.6386121598061357`*^9}, 3.638771498875*^9, 
   3.6387722884375*^9},ExpressionUUID->"4f6b1b00-235a-4655-b0a0-2c5a52ad774f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"kCVypZap", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindMinimum", "::", "\"\<fmmp\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataPminPmax", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", ",", "625"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"80", ",", "500"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"75", ",", "400"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "300"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataAcka", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"500", ",", "8", ",", "0.004"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"400", ",", "6.4", ",", "0.0048"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"600", ",", "7.9", ",", "0.005"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"400", ",", "7.5", ",", "0.0055"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dataCinCout", "=", 
   RowBox[{"kCVypZap", "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3000", ",", "1500"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3000", ",", "1500"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2000", ",", "1000"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "800"}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "dataAcka", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vykony", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["P", "#"], "&"}], "/@", 
    RowBox[{"(", 
     RowBox[{"rn", "=", 
      RowBox[{"Range", "[", "n", "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   SuperscriptBox["x", "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pen", "[", 
    RowBox[{
    "x_", ",", "a_", ",", "b_", ",", "\[Delta]a_", ",", "\[Delta]b_"}], "]"}],
    ":=", 
   RowBox[{
    SuperscriptBox["10", "3"], 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"res", ",", "vyr", ",", "xx", ",", "k", ",", "ka", ",", "kb"}],
        "}"}], ",", 
      RowBox[{
       RowBox[{"k", "=", 
        RowBox[{
         SuperscriptBox["10", "4"], 
         RowBox[{"Min", "[", 
          RowBox[{"Abs", "[", 
           RowBox[{"{", 
            RowBox[{
             FractionBox["1", "a"], ",", 
             FractionBox["1", "b"]}], "}"}], "]"}], "]"}]}]}], ";", 
       RowBox[{
        RowBox[{"vyr", "[", "xx_", "]"}], ":=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ka", "*", 
            RowBox[{"f", "[", 
             RowBox[{"(", 
              RowBox[{"xx", "-", "a"}], ")"}], "]"}]}], "+", 
           RowBox[{"kb", "*", 
            RowBox[{"f", "[", 
             RowBox[{"(", 
              RowBox[{"xx", "-", "b"}], ")"}], "]"}]}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Tanh", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"xx", "-", "b"}], ")"}], "*", "k"}], "]"}], "-", 
           RowBox[{"Tanh", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"xx", "-", "a"}], ")"}], "*", "k"}], "]"}]}], ")"}]}]}],
        ";", 
       RowBox[{"res", "=", 
        RowBox[{
         RowBox[{"Solve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"vyr", "[", 
               RowBox[{"a", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "-", 
                  RowBox[{"0.01", "\[Delta]a"}]}], ")"}]}], "]"}], "\[Equal]",
               "100"}], ",", 
             RowBox[{
              RowBox[{"vyr", "[", 
               RowBox[{"b", "*", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"0.01", "\[Delta]b"}]}], ")"}]}], "]"}], "\[Equal]",
               "100"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"ka", ",", "kb"}], "}"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"vyr", "[", "x", "]"}], "/.", "res"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ukpen", "[", "x_", "]"}], "=", 
   RowBox[{"pen", "[", 
    RowBox[{"x", ",", "20", ",", "30", ",", "5", ",", "5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plPenale", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"ukpen", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<P [MW]\>\"", ",", "\"\<penale\>\""}], "}"}]}], ",", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "[", "plPenale", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.56473827603125*^9, 3.56473827778125*^9}, {
   3.564738580984375*^9, 3.5647385834375*^9}, {3.564738883953125*^9, 
   3.56473888428125*^9}, {3.564739039375*^9, 3.564739043*^9}, {
   3.638609134853011*^9, 3.638609166540511*^9}, 3.6386091967748857`*^9, {
   3.6386092415873857`*^9, 3.638609282165511*^9}, {3.6386093574936357`*^9, 
   3.638609424478011*^9}, {3.638609457884261*^9, 3.638609481728011*^9}, {
   3.6386098099311357`*^9, 3.6386098476186357`*^9}, {3.6386124054623857`*^9, 
   3.6386124062748857`*^9}, 3.6386127153998857`*^9, 3.638613690196761*^9, {
   3.6387731205625*^9, 3.638773120921875*^9}, {3.638775841625*^9, 
   3.63877584421875*^9}, {3.638775978296875*^9, 3.63877602328125*^9}, 
   3.638776681625*^9, 3.638776718890625*^9, {3.638776767*^9, 
   3.63877676784375*^9}, 
   3.791265980535287*^9},ExpressionUUID->"66e3784e-0505-4c5e-bb1f-\
3b04113bc6c7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJxFzns0lPkfB/BRswlp3O+p3MkM5hEW88zny+KptkTKSheRDFYYt5JKqOhG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       "]]},
     Annotation[#, "Charting`Private`Tag$7464#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"P [MW]\"", TraditionalForm], 
    FormBox["\"penale\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.791265981082031*^9},ExpressionUUID->"7d9b79b4-6215-4b80-a767-\
0e40a223370c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"penale", "[", "i_", "]"}], ":=", 
     RowBox[{"pen", "[", 
      RowBox[{
       RowBox[{"vykony", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "5", ",", "5"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"penale", "[", "1", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["P", "1"], ",", "0", ",", "750"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<P [MW]\>\"", ",", "\"\<penale\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6386095181186357`*^9, 3.6386097899311357`*^9}, 
   3.6386098593373857`*^9, 
   3.638612868009261*^9},ExpressionUUID->"e87862c6-8635-406c-9ec9-\
89287a5c9baa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cena", "[", "i_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Pi", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Pi", "=", 
       RowBox[{"vykony", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "Pi", ",", 
         SuperscriptBox["Pi", "2"]}], "}"}], ".", 
       RowBox[{"dataAcka", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",ExpressionUUID->"532d8135-bbcb-4a8a-8d26-9f46ec2592f4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"penaleVykony", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"penale", "/@", "rn"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cenaVari", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"cena", "/@", "rn"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"penaleDodavka", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"200", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Plus", "@@", "vykony"}], ")"}], "-", "Pdodavka"}], ")"}], 
     "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"proFindMinimum", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"penaleVykony", "+", 
    RowBox[{"penaleDodavka", "[", "Pdodavka", "]"}], "+", "cenaVari"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6386098647123857`*^9, 3.638609938509261*^9}, 
   3.6386101308998857`*^9, 3.6386103283686357`*^9, {3.638612301884261*^9, 
   3.638612313415511*^9}, {3.638613120665511*^9, 3.6386132972748857`*^9}, 
   3.6386133479623857`*^9},ExpressionUUID->"24899835-cf30-475c-aff9-\
6b63f937ac12"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"obor", "[", "i_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"vykony", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"Mean", "[", 
       RowBox[{"dataPminPmax", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "]"}], "//", "N"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"obory", "=", 
   RowBox[{"obor", "/@", "rn"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.638613386853011*^9, 3.6386133888998857`*^9}, {
  3.638613419665511*^9, 3.6386134229311357`*^9}, {3.638613461290511*^9, 
  3.6386135291186357`*^9}},ExpressionUUID->"6e752049-aaa3-46c7-9504-\
2ad55242e4e7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"min", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{"proFindMinimum", "[", "Pdodavka", "]"}], ",", "obory"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cenaHodina", "[", "Pdodavka_", "]"}], ":=", 
   RowBox[{"cenaVari", "/.", 
    RowBox[{
     RowBox[{"min", "[", "Pdodavka", "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datazatizeni", "=", 
   RowBox[{"{", 
    RowBox[{
    "600", ",", "800", ",", "1100", ",", "1400", ",", "1000", ",", "1200", 
     ",", "1000", ",", "1400", ",", "1600", ",", "1600", ",", "1400", ",", 
     "800", ",", "400", ",", "200", ",", "1400", ",", "1200", ",", "450", ",",
      "300", ",", "400"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom1", "=", 
   RowBox[{
    RowBox[{"min", "/@", "datazatizeni"}], "//", "Quiet"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nakladyDen", "=", 
   RowBox[{"cenaVari", "/.", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "pom1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<celkem naklady= \>\"", ",", 
   RowBox[{"Plus", "@@", "nakladyDen"}], ",", "\"\< -\>\""}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6386134275561357`*^9, 3.638613433290511*^9}, {
  3.638613533446761*^9, 3.6386135815248857`*^9}, {3.6386136177436357`*^9, 
  3.6386136622436357`*^9}, {3.638770457734375*^9, 3.638770639671875*^9}, {
  3.638770699796875*^9, 3.638770722421875*^9}, {3.63877569565625*^9, 
  3.63877573796875*^9}},ExpressionUUID->"de4854fe-5500-4c49-a229-\
9d35afc0f2c2"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "optimalizace", " ", "denniho", " ", "provozu", " ", "pres", " ", "cely", 
   " ", "den"}], "*)"}]], "Input",
 CellChangeTimes->{{3.63877075921875*^9, 
  3.638770777078125*^9}},ExpressionUUID->"940edc50-0a48-4db6-ad65-\
3a8db883c62f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nk", "=", 
   RowBox[{
    SuperscriptBox["2", "n"], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"komb", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"#", ",", 
          RowBox[{"-", "4"}]}], "]"}], "&"}], ")"}], "/@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"IntegerDigits", "[", 
         RowBox[{
          RowBox[{"Range", "[", "nk", "]"}], ",", "2"}], "]"}], "/.", 
        RowBox[{
         RowBox[{"{", "q__Integer", "}"}], "\[RuleDelayed]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", "q"}], "}"}]}]}], ")"}]}], 
     ")"}], "//", "Union"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.638770831546875*^9, 3.63877085625*^9}, 
   3.638771351734375*^9, 
   3.638772405796875*^9},ExpressionUUID->"e6117fcd-3329-451d-a702-\
d7d3f2c2defd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"nakladyHodina", "[", 
     RowBox[{"Pzadany_", ",", "kombinace_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"penMinMax", ",", "penDodavka", ",", 
        RowBox[{"kpd", "=", "100"}], ",", 
        RowBox[{"kpmn", "=", "10"}], ",", "obors", ",", "cen", ",", "promin", 
        ",", "min", ",", "m", ",", "ps"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"penMinMax", "=", 
        RowBox[{"kpmn", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"penale", "/@", "rn"}], ")"}], ".", "kombinace"}]}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"penDodavka", "=", 
        RowBox[{"kpd", "*", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"vykony", ".", "kombinace"}], ")"}], "-", "Pzadany"}], 
           ")"}], "2"]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"obors", "=", 
        RowBox[{"Cases", "[", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"obory", ",", 
            RowBox[{"kombinace", "*", "rn"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"_", ",", "_"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"cen", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"cena", "/@", "rn"}], ")"}], ".", "kombinace"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"promin", "=", 
        RowBox[{"cen", "+", "penDodavka", "+", "penMinMax"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"min", "=", 
        RowBox[{
         RowBox[{"FindMinimum", "[", 
          RowBox[{"promin", ",", "obors"}], "]"}], "//", "Quiet"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cen", "/.", 
          RowBox[{"(", 
           RowBox[{"m", "=", 
            RowBox[{"min", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ",", "kombinace", ",",
          "m", ",", 
         RowBox[{"ps", "=", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"penMinMax", ",", "penDodavka"}], "}"}], "/.", "m"}]}], 
         ",", 
         RowBox[{"Plus", "@@", "ps"}]}], "}"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.638771367875*^9, 3.638771412546875*^9}, {
   3.638771548171875*^9, 3.6387715684375*^9}, {3.6387716386875*^9, 
   3.638771683140625*^9}, {3.638771728765625*^9, 3.638771807328125*^9}, {
   3.638771950734375*^9, 3.63877197425*^9}, 3.6387720411875*^9, {
   3.63877219471875*^9, 3.63877222509375*^9}, {3.638772272375*^9, 
   3.63877263778125*^9}, {3.638772770609375*^9, 3.6387727914375*^9}, {
   3.6387728909375*^9, 3.63877289384375*^9}, {3.63877604803125*^9, 
   3.6387760489375*^9}},ExpressionUUID->"92b0f2aa-97e3-4a92-8b99-\
0f436f28dc18"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"vydejHodina", "[", "Pzadany_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "dats", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dats", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"nakladyHodina", "[", 
           RowBox[{"Pzadany", ",", "#"}], "]"}], "&"}], "/@", "komb"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Take", "[", 
          RowBox[{"#", ",", "3"}], "]"}], "&"}], "/@", 
        RowBox[{"Sort", "@", 
         RowBox[{"Select", "[", 
          RowBox[{"dats", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "<", "1"}], "&"}]}], 
          "]"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.63877281059375*^9, 3.638772870875*^9}, {
   3.638772912203125*^9, 3.638772936015625*^9}, {3.638772991375*^9, 
   3.63877299996875*^9}, {3.6387735595625*^9, 3.63877356075*^9}, {
   3.638774884671875*^9, 3.638774902875*^9}, {3.638774970796875*^9, 
   3.638775002921875*^9}, 3.63877579321875*^9, 
   3.638776051921875*^9},ExpressionUUID->"70780b35-c3ed-49a1-8f21-\
e8161b8cd2f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"cenaprepnuti", "[", 
    RowBox[{"v1_", ",", "v2_"}], "]"}], ":=", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sign", "[", 
          RowBox[{"(", 
           RowBox[{"v1", "-", "v2"}], ")"}], "]"}], "[", 
         RowBox[{"[", "i", "]"}], "]"}], "<", "0"}], ",", 
       RowBox[{"dataCinCout", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Sign", "[", 
            RowBox[{"(", 
             RowBox[{"v1", "-", "v2"}], ")"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}], ">", "0"}], ",", 
         RowBox[{"dataCinCout", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6387731759375*^9, 3.638773233609375*^9}, {
   3.638773263953125*^9, 3.63877326496875*^9}, 3.63877538196875*^9, 
   3.6387757956875*^9, {3.638776056671875*^9, 
   3.63877605703125*^9}},ExpressionUUID->"9daa1d5d-545e-40ae-987e-\
1f5c2f201a8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"start", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vydejHodina", "[", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "1"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.638773675203125*^9, 3.63877367775*^9}, {
   3.638774753515625*^9, 3.638774775828125*^9}, {3.63877481053125*^9, 
   3.638774813828125*^9}, {3.63877513228125*^9, 3.638775140625*^9}, 
   3.638776060703125*^9},ExpressionUUID->"f0e9e1b0-ba3b-402a-a89a-\
d18ea202a4fd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c_", ",", "komb_", ",", "dosP_"}], "}"}], ",", "n_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"zatizeni", ",", "mozne", ",", "sprepnutim"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"zatizeni", "=", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", 
         RowBox[{"n", "+", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mozne", "=", 
       RowBox[{"vydejHodina", "[", "zatizeni", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sprepnutim", "=", 
       RowBox[{
        RowBox[{"Sort", "[", 
         RowBox[{"mozne", "/.", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ci_Real", ",", "kombi_List", ",", "dosPi_"}], "}"}], 
           "\[RuleDelayed]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ci", "+", 
              RowBox[{"1", "*", 
               RowBox[{"cenaprepnuti", "[", 
                RowBox[{"komb", ",", "kombi"}], "]"}]}]}], ",", "kombi", ",", 
             "dosPi"}], "}"}]}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"sprepnutim", ",", 
        RowBox[{"n", "+", "1"}]}], "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.638775076*^9, 3.638775112546875*^9}, {
  3.638775143859375*^9, 3.638775185*^9}, {3.638775218484375*^9, 
  3.63877547321875*^9}, {3.638775511921875*^9, 3.6387755666875*^9}, {
  3.638775672078125*^9, 3.638775674890625*^9}, {3.63877606640625*^9, 
  3.63877606678125*^9}},ExpressionUUID->"bf232160-72d1-4c81-976c-\
55205bc42f64"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dats", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "start", ",", 
     RowBox[{
      RowBox[{"Length", "[", "datazatizeni", "]"}], "-", "1"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"cenaDenSVypZap", "=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "&"}], "/@", "dats"}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<celkem denni naklady= \>\"", ",", "cenaDenSVypZap", ",", 
   "\"\< -\>\""}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.63877558603125*^9, 3.638775619375*^9}, {
   3.638775883375*^9, 3.6387758883125*^9}, 
   3.638776080875*^9},ExpressionUUID->"025afab1-95ec-4db0-8317-17ca48a75d19"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"dats", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ci_Real", ",", "kombi_List", ",", "dosPi_"}], "}"}], ",", 
       "nh_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"nh", ",", "ci", ",", "kombi", ",", "dosPi", ",", 
       RowBox[{"datazatizeni", "[", 
        RowBox[{"[", "nh", "]"}], "]"}], ",", 
       FractionBox["ci", 
        RowBox[{"datazatizeni", "[", 
         RowBox[{"[", "nh", "]"}], "]"}]]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"p1", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<hodina\>\"", ",", "\"\<c [Kc]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p2", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "5", "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<hodina\>\"", ",", "\"\<P [MW]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"p3", "=", 
  RowBox[{"BarChart", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}], "&"}], "/@", "pom"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<hodina\>\"", ",", 
       "\"\<ch [\!\(\*FractionBox[\(Kc\), \(MWh\)]\)]\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exp", "[", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.638776294578125*^9, 3.638776381875*^9}, {
  3.6387764495625*^9, 3.638776650171875*^9}, {3.63877724953125*^9, 
  3.638777269859375*^9}},ExpressionUUID->"46e82fd3-5b23-4468-8580-\
2e26c39f735d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"proexp", "=", 
   RowBox[{
    RowBox[{"pom", "/.", 
     RowBox[{
      SubscriptBox["P", "a_"], "\[RuleDelayed]", 
      RowBox[{"\"\<P\>\"", "<>", 
       RowBox[{"ToString", "[", "a", "]"}]}]}]}], "/.", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "\[Rule]", "b_"}], ")"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"ToString", "[", "a", "]"}], "<>", "\"\<=\>\"", "<>", 
      RowBox[{"ToString", "[", "b", "]"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<vysledky.xls\>\"", ",", "proexp"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.638776874921875*^9, 3.638776875234375*^9}, {
  3.6387769324375*^9, 3.638777101609375*^9}, {3.63877722046875*^9, 
  3.638777228296875*^9}, {3.638777292484375*^9, 
  3.63877734153125*^9}},ExpressionUUID->"0448cc42-676b-4b24-9076-\
1de46fa8691c"]
},
WindowSize->{1146, 811},
WindowMargins->{{7, Automatic}, {Automatic, 17}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{583.1999999999999, 829.68}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1355, 37, 210, "Input",ExpressionUUID->"4f6b1b00-235a-4655-b0a0-2c5a52ad774f"],
Cell[CellGroupData[{
Cell[1925, 61, 6038, 172, 517, "Input",ExpressionUUID->"66e3784e-0505-4c5e-bb1f-3b04113bc6c7"],
Cell[7966, 235, 4675, 97, 316, "Output",ExpressionUUID->"7d9b79b4-6215-4b80-a767-0e40a223370c"]
}, Open  ]],
Cell[12656, 335, 1309, 36, 126, "Input",ExpressionUUID->"e87862c6-8635-406c-9ec9-89287a5c9baa"],
Cell[13968, 373, 631, 17, 139, "Input",ExpressionUUID->"532d8135-bbcb-4a8a-8d26-9f46ec2592f4"],
Cell[14602, 392, 1171, 31, 154, "Input",ExpressionUUID->"24899835-cf30-475c-aff9-6b63f937ac12"],
Cell[15776, 425, 681, 19, 70, "Input",ExpressionUUID->"6e752049-aaa3-46c7-9504-2ad55242e4e7"],
Cell[16460, 446, 1779, 46, 210, "Input",ExpressionUUID->"de4854fe-5500-4c49-a229-9d35afc0f2c2"],
Cell[18242, 494, 277, 7, 41, "Input",ExpressionUUID->"940edc50-0a48-4db6-ad65-3a8db883c62f"],
Cell[18522, 503, 927, 28, 70, "Input",ExpressionUUID->"e6117fcd-3329-451d-a702-d7d3f2c2defd"],
Cell[19452, 533, 2912, 73, 636, "Input",ExpressionUUID->"92b0f2aa-97e3-4a92-8b99-0f436f28dc18"],
Cell[22367, 608, 1311, 35, 297, "Input",ExpressionUUID->"70780b35-c3ed-49a1-8f21-e8161b8cd2f5"],
Cell[23681, 645, 1270, 36, 192, "Input",ExpressionUUID->"9daa1d5d-545e-40ae-987e-1f5c2f201a8c"],
Cell[24954, 683, 579, 14, 85, "Input",ExpressionUUID->"f0e9e1b0-ba3b-402a-a89a-d18ea202a4fd"],
Cell[25536, 699, 1793, 47, 455, "Input",ExpressionUUID->"bf232160-72d1-4c81-976c-55205bc42f64"],
Cell[27332, 748, 852, 24, 245, "Input",ExpressionUUID->"025afab1-95ec-4db0-8317-17ca48a75d19"],
Cell[28187, 774, 2063, 62, 633, "Input",ExpressionUUID->"46e82fd3-5b23-4468-8580-2e26c39f735d"],
Cell[30253, 838, 894, 23, 198, "Input",ExpressionUUID->"0448cc42-676b-4b24-9076-1de46fa8691c"]
}
]
*)

