(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     89010,       1835]
NotebookOptionsPosition[     87435,       1801]
NotebookOutlinePosition[     87950,       1819]
CellTagsIndexPosition[     87907,       1816]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103185676102505`*^9, 3.910318568760665*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"par", ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Total", "[", 
      FractionBox["1", "#"], "]"}], 
     RowBox[{"-", "1"}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ser", "=", "Total"}], ";"}]}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"p", "*", "L1"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"za", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"p", "*", "c"}]], ",", "R2"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zb", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R3", ",", 
      RowBox[{"p", "*", "L2"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{"par", "[", 
    RowBox[{"{", 
     RowBox[{"za", ",", "zb"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prenos", "=", 
   RowBox[{
    FractionBox["z2", 
     RowBox[{"z1", "+", "z2"}]], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L1", "\[Rule]", "1"}], ",", 
      RowBox[{"L2", "\[Rule]", "1"}], ",", 
      RowBox[{"R1", "\[Rule]", "1"}], ",", 
      RowBox[{"R2", "\[Rule]", "2"}], ",", 
      RowBox[{"R3", "\[Rule]", "3"}], ",", 
      RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"prenos", "//", "Simplify"}], ",", 
   FractionBox[
    RowBox[{"Expand", "[", 
     RowBox[{"Numerator", "[", 
      RowBox[{"prenos", "//", "Simplify"}], "]"}], "]"}], 
    RowBox[{"Denominator", "[", 
     RowBox[{"prenos", "//", "Simplify"}], "]"}]]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}, {3.91032129999327*^9, 
   3.9103213268570223`*^9}, {3.9103216143103514`*^9, 
   3.9103216824171247`*^9}, {3.910322177432126*^9, 3.9103221884641523`*^9}, {
   3.9103222231440277`*^9, 3.9103222308871*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "p"}]}], ")"}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]], ",", 
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"7", " ", "p"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["p", "2"]}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.9103187216013775`*^9, 3.91031881473453*^9}, {
   3.910318863437398*^9, 3.910318941095933*^9}, 3.9103189852341127`*^9, 
   3.91031911496647*^9, {3.910319201428973*^9, 3.9103192132912235`*^9}, {
   3.910321292362014*^9, 3.9103213274636955`*^9}, {3.910321657468945*^9, 
   3.910321682935179*^9}, {3.910322180081609*^9, 3.9103221895424256`*^9}, 
   3.9103222326427927`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"e532444c-1d82-46a1-859d-d386cf4d5ee4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn0", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"vCem", ",", 
      SuperscriptBox["p", "i"]}], "]"}], "/;", 
    RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"vCem", "/.", 
      RowBox[{"p", "\[Rule]", "0"}]}], ")"}], "/;", 
    RowBox[{"i", "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numP", "=", 
   RowBox[{"Numerator", "[", "prenos", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"denomP", "=", 
   RowBox[{"Denominator", "[", "prenos", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"denomP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"numP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "0", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "0", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "i", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "i", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"i", "-", "1"}], "]"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vstupTry", "=", 
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"0.123", "t"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vstup", "[", "t_", "]"}], "=", "vstupTry"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceStavYU", "=", 
   RowBox[{"stavRcei", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dosVstup", "=", 
   RowBox[{"{", 
    RowBox[{"u", "\[Rule]", "vstup"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceStav", "=", 
   RowBox[{"rceStavYU", "/.", "dosVstup"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystupniRce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", "n", "]"}], "*", 
       RowBox[{"y", "[", "t", "]"}]}], "-", 
      RowBox[{
       RowBox[{"b", "[", "n", "]"}], "*", 
       RowBox[{"u", "[", "t", "]"}]}], "+", 
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}]}], "\[Equal]", "0"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solVystRov", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"vystupniRce", ",", 
      RowBox[{"y", "[", "t", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rceStavObecne", "=", 
  RowBox[{"rceStavYU", "/.", "solVystRov"}]}], "\[IndentingNewLine]", 
 RowBox[{"rceStavU", "=", 
  RowBox[{"rceStavObecne", "/.", "dosVstup"}]}]}], "Input",
 CellChangeTimes->{{3.9103190743512273`*^9, 3.910319177581434*^9}, 
   3.9103192389050026`*^9},ExpressionUUID->"610bb0be-b3fd-408f-8a42-\
be39a453f29d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"7", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"13", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"8", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 
   3.910319239453104*^9}},ExpressionUUID->"a0a0ca4e-9cb9-4e59-9719-\
f15af55ece65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"0.123`", " ", "t"}], "]"}], "+", 
        RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"7", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"0.123`", " ", "t"}], "]"}], "+", 
        RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"13", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"0.123`", " ", "t"}], "]"}], "+", 
        RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"8", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 
   3.910319239484318*^9}},ExpressionUUID->"ee26c6f5-f9c4-465f-8475-\
31da71bd1b15"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"outLpl", "=", 
   RowBox[{"prenos", "*", 
    RowBox[{"(", 
     RowBox[{"lplVstup", "=", 
      RowBox[{"LaplaceTransform", "[", 
       RowBox[{"vstupTry", ",", "t", ",", "p"}], "]"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outCas", "=", 
   RowBox[{"InverseLaplaceTransform", "[", 
    RowBox[{"outLpl", ",", "p", ",", "t"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"outCas", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xvect", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "#", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"laplasiRceStav", "=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rceStavObecne", ",", "vystupniRce"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "i_", "]"}], "'"}], "[", "t", "]"}], 
       "\[RuleDelayed]", 
       RowBox[{"p", "*", 
        RowBox[{"x", "[", "i", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i_", "]"}], "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{"x", "[", "i", "]"}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "\[RuleDelayed]", "y"}], ",", 
      RowBox[{
       RowBox[{"u", "[", "t", "]"}], "\[RuleDelayed]", 
       RowBox[{"LaplaceTransform", "[", 
        RowBox[{"vstupTry", ",", "t", ",", "p"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solLaplace", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"laplasiRceStav", ",", 
      RowBox[{"Union", "[", 
       RowBox[{"xvect", ",", 
        RowBox[{"{", "y", "}"}]}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solStav", "=", 
   RowBox[{"solLaplace", "/.", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"lhs_", ",", "rhs_"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"Rule", "[", 
      RowBox[{"lhs", ",", 
       RowBox[{"InverseLaplaceTransform", "[", 
        RowBox[{"rhs", ",", "p", ",", "t"}], "]"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"y", "/.", "solStav"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{"pl1", ",", "pl2"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103192638035693`*^9, 
  3.9103192690505667`*^9}},ExpressionUUID->"9af101ac-d87f-4f62-b0c8-\
47ee1b66fce1"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3c81f8Xx83Kyh6Z17rENS7lW1KfU7LaSylSqFRKNkVLokQZJZFRoTRE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        "]]},
      Annotation[#, "Charting`Private`Tag$59570#1"]& ]}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVl3c81f8Xx62UvUfmtS5xjUupND6nlJF2KUUDFS2RGVoSEhElmQ180xDZ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        "]]},
      Annotation[#, "Charting`Private`Tag$59692#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9103192643897095`*^9},ExpressionUUID->"ec6bcbc8-ae29-40a8-a5c8-\
a2fc5385835f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "derivace", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stavRce", "=", "rceStavU"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"derivace", "[", 
    RowBox[{"{", 
     RowBox[{"tt_", ",", "vect_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "stavRce"}], ")"}], "/.", 
      RowBox[{"MapThread", "[", 
       RowBox[{"Rule", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Through", "[", 
           RowBox[{"xvect", "[", "t", "]"}], "]"}], ",", "vect"}], "}"}]}], 
       "]"}]}], ")"}], "/.", 
    RowBox[{"t", "\[Rule]", "tt"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nBodu", "=", "100"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nUseku", "=", 
   RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"N", "@", 
    FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krokEuler", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "stav_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "der", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"der", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "stav"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"stav", "+", 
         RowBox[{"\[CapitalDelta]t", "*", "der"}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocStav", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"0.", "&"}], "/@", "xvect"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solEuler", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krokEuler", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vystupZeStavu", "[", 
    RowBox[{"{", 
     RowBox[{"tt_", ",", "vect_"}], "}"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"solVystRov", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Rule]", 
         RowBox[{"vstup", "[", "t", "]"}]}], "}"}]}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "\[Rule]", "tt"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}], "\[RuleDelayed]", 
        RowBox[{"Last", "[", "vect", "]"}]}]}], "}"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystupZeStavu", "[", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodyEuler", "=", 
   RowBox[{"solEuler", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"vystupZeStavu", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{"bodyEuler", ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", "pl1", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "RungeKuttaStep", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nBodu", "=", "300"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nUseku", "=", 
   RowBox[{"nBodu", "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{"N", "@", 
    FractionBox["tmax", "nUseku"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RungeKuttaStep", "[", 
    RowBox[{"{", 
     RowBox[{"t_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k1", ",", "k2", ",", "k3", ",", "k4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k1", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k2", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k1"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k3", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", 
           FractionBox["\[CapitalDelta]t", "2"]}], ",", 
          RowBox[{"y", "+", 
           RowBox[{
            FractionBox["\[CapitalDelta]t", "2"], "*", "k2"}]}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"k4", "=", 
       RowBox[{"derivace", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
          RowBox[{"y", "+", 
           RowBox[{"\[CapitalDelta]t", "*", "k3"}]}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "+", "\[CapitalDelta]t"}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          FractionBox["\[CapitalDelta]t", "6"], "*", 
          RowBox[{"(", 
           RowBox[{"k1", "+", 
            RowBox[{"2", "k2"}], "+", 
            RowBox[{"2", "k3"}], "+", "k4"}], ")"}]}]}]}], "}"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solRungeKutta", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"RungeKuttaStep", ",", "pocStav", ",", "nUseku"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bodyRungeKutta", "=", 
   RowBox[{"solRungeKutta", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "vect_"}], "}"}], "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"vystupZeStavu", "[", 
        RowBox[{"{", 
         RowBox[{"t", ",", "vect"}], "}"}], "]"}]}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"bodyRungeKutta", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", "pl1"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.9103192956849623`*^9},ExpressionUUID->"b2757a10-191d-49dc-a67e-\
bc59a1714663"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJxdmHk8VO37x0kqIpSyRRjb2GbGREk6V6tSKqQFPaLoSaF6pKeytCGkBe3p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       "]]}, {}}, {}, {}, {}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVl3c81f8Xx83Kyh6Z17rENS7lW1KfU7LaSylSqFRKNkVLokQZJZFRoTRE
tuQY1zVDKLtkXDPjuskofvf31308H5/P+4zXOef9uUfZ8dKB01wcHBy3uTk4
/v8ba/+4Jbz4LcHxe0DuYu55XHDZ1T3t/J7gUEz7qvjmEiZzdt/9Y5ZFwAhn
7fSSB27/HKk+2/aBKD2/ScvkvA8Ox1qUsc7lEDf0dV2KJK9g2Kl/djOLuQQc
uhtZuXwVWxbPPpxSKiRKbxGNUdtvoU+Vov5kVhFx44ymYm7UbZSNbq37ZVpM
nOSs0Rb6F4KOWsA95oxEckA8NUw1HP3eChQy28oJUqldWNSBh7gjirGCmVxB
lJqfuCL18xHK+5Udmj5HI3o3CK9R9X+Mpaa+U5OLlUSy76O/+U1xuLKrT+OX
Ug1hd+PVuOG/ZGwv/eQ9PlxDhK2o/NU98Qxfp8VWjGXVErH6j4W3Dz7HPR57
Toya1hNqNe15HT9SMIavKGbIuZHQN9qSROZLR7Gn1VzTbc0Eed+LSxYCWbi4
Oi/dzaSF4N+UpcqdkoUDN1/sm0puIeYU+ByOb/mAec7XEifPtRJ5qWNldN9s
PGa4znhi8SsxobNq8dzfXHxWm+Q+ptRBsCreLfqZfURWbK7Wj7AOIlT05/48
rmI0d67rb57vIIxPiX3YXFaM49x/rItaOolHSaHEym0luGHzHuO7Id3ELu1v
03WvSrHp/V8ujckfhO7kba2fTRV4vZayg3qin6hucePLOl+LGe/vdl3QHSW2
HL8sOiDWiqNio2E7HEaJQ8zHdUfNW1HDZ8cWzYejhJfcx9iqy62YbCLwrH9+
lPB4YLL+Tm8rRtWEnTlWOUa8v7XdKuTdV/TpfzBtYfeLIAmu427a3oZJAnW3
RM2miMb1qrVnnTpxy2Z/uxv2U8QKh0C6y8NO7HbVXj/pO0UE2bU/3VvZiTLN
9xj1r6eIxXORW/LJXRgZu8vqjsg0wRsf78Qa6sJb6g2rl7umifV2l/ninHrQ
mfjyZNxjhli5d+5gtkIvcjyfLeq6N0NsX+kgvNmwF2N55LtrU2aIXd8f0jMs
e7G65oxi+rcZQq3WUdvKsxc1D/19ftqYRWRcjf57oKoXh89qvP3O+Zv4o9ib
fPv8TzwfdbWkKWKWyGnSM/oa34dcv5//wPRZgtqSYjz+rg/jjlRzvC+fJTyt
grUGsA9r5cVNw1mzxB1T/lU+/X2o/fJVlZXNH6LzjKGn/Np+HP/Y0lSuNEec
7XYx35nRj66Da/tzMuaJ3osGQlxJA9hr37GqrGaeMNUi9fBnDODB9ju6nwfm
icqJtq7h4gHcUDd0eVB2gXge1Jqt2jmA3FmpIlIhC4RH2xqJCLFB9NGyNlJ5
vkBceyz9dDNpEIdf8NjpflogZqXOLZfoDGJDjNNL85kFItZDucjEchBjA5S3
+J5YJILbH3xR8h9E/tkmp1tXFokjPL6cZ0MG8eqlG3cfPFok3h9W/hkYPYiO
jj9aX9YtEtKfvqnrvxlEimWCS/t/f4l9qp4qp9sHsUx8zZONIv+I2kMcAwpa
DFwXXl1ipv2PuMnKNgg0ZGDaCr+B/eb/CMtZvQP5JgwMm/+mdz7gH0F2yn4W
vYeBh388pMcN/yNaH5yZF3VjYLXN9vE07iXCo8sXFnwZuKl5RjRbcYk4uYIn
9cN1BpIqDxyvO7REvAlv9Iu+z8DR1yKsxdIlwsZWdo/4awbaqZWuWdW9RAit
Cb5+JZOBjQmXCIk/S8S0qbFpVh4DcyIaQik6y8TQVrpFeDkDNfivZW6wXCZG
jA5eNKhmYNwtnW/bndjP86Mm0j4z8LpPmPLxJ8tEYKV76782BjInN1mcy1km
HDNoKr3dDDx1buyCd+MyEfNOPznyJwPVddW76VwcIDXzkMtxlIHfR/9O7BLh
gIjxTd9uTDAw9mUrZ4sCB6zVPprnymQgv3KQxo8NHDB6a+2N/Hl2/iaRetfM
OODuvHt0518GBtsk/qdwgAPqBT5NNC8zcLvXG6LYngO2rN90P5lrCLkiCixs
XThAReyRqynvEJa+qdy74MsBweZjYR9XDuG1quYjT4I44IrTN8Yq/iE06f9x
YkMkB1yvO3NFW3AIF5bGndsSOIASo2auunoIC2QXLvm85oBxD2GrKeEh9DFa
6SeZzwGs0MTAKNEhXHdA4kZOBQdcdCxl8okPIfOi8p2DTRyQX9D55LDEEGbe
1Y1gdrPPO9f6+UkOoWvqptjIEQ64bNofcUlqCClllsn6sxww9nuyf5P0EI51
W79q5OKEwR6qVw+bX885ZroKc8KW0ZPbD8kM4VkJtwIheU7Y5v3mSDKbyfpX
S99qcoKSUl5WGZsHdoZW71zPCb4v4w8XsPm58+Om0a2csIY+viOIzSdvpbTf
3cMJPVyZ0epsVkzK6tW05YRXYQ5GT9n+uotKhqucOeGJ8MyGYXZ8cd/qps54
ccKO0LpnfGy2YbbP8d7khH0qVb4c7HykVjM4UsM5ofyPUXk9O//WtTOrtsdx
wtyf3juuYkMYZcYh2p/GCafeL7cMigzhPgehNYHZnHBXdttbA7aeq6/KKiuX
cgLZp07WWmgI62M11pbWc4L7asO1uwWGMDRnHfVEByf4CAX9lOUbQsumrRuX
BtnxWm7eU7JiCGkr7axMljlB45eaezDnEAaqntvfJcAFb0Mit7xZYiAQPkev
yHABWvdNpC4ysNgn4lwBlQs0HOK1FX4z8EpUgvuRLVyQ3/Gt+ck0AzdkvL48
u4MLjEKfRo3/Ys/HIO3uulNcIFe1P0aCwcB3h+bTM2O4YNh9/qRbKwMvuK34
sPcFF5zxXfJPamSgVph40cR7LqhdUtBPrWXPe4VOLaWGC+bEd75dV8rARAPH
0VeLXBCkwc93Jp09n3suMS1WccPf29eXdr5goOz5gAWGBDeUeESu5UtgYMyz
GH51XW7IP7zgwxfBwPsidVrPTnKDzTDdSc2LgYX/KeTuceWGTM+4MvIFBg7Y
XyL++nPDlk3logtO7PvinfihI4+5QbzqySqJgwwctrK7KtTADU94jv+S0WOg
hHvGyo9d3CDWk++Tps5AIpYj6uwINzzItOVYIc/2z0hJq+DhgYZFk7RNqxho
eutX4+VNPGAz23fk9vdBdH1NHNOw4gFa9urFtJZBjPsSOdB6mAd2rvJpiq8e
xCklo3k9Dx7I0DuTu5w1iInF11QYr3hAYoS8lBM4iHO/hb0PSPGC+ouOpUW5
QVRVcFxeVuUFtUctq06vHsQ923PuvqPywmn/aJEUjkFMjbJJXLWbF45YXPue
MjCAB/SeVZXc4gX+FYyZvNcD+O6sgaz2NC8kTl5J2aE3gI5dh5C7fgU8K35C
5Mn1I3/8z4vuHStg4ziTP5GvHz8cc5X/wVgB3qOjmqf+9CF3Z8jlIs6V8PzY
sb1hzX2Y0l5k6P7fSpCOWbd0IKQPGV9Jr74/XwmbGRI/pkbZ38em8YjCy6vA
8M8ry41Pe9G9MsjxkgY/RFSHXPl4oQuz3AQPylgJgenbf9WnORqxPk788rvD
QiDkN7F29+MGZNBkk7adEgKRgSM/tuo2oOyatWMXrguBHodnlo3dZwwqM7tV
lisEha5jDQ6FdXhY7Hr2eZXVYHhhNUnErxoXsqfFPy2uhuyFB8+3iJajxPe5
jQf4hEFqp9rv82/LUHcVx8khKWHga9tm02hRhk52q9+KGgjDCCn0jtn1Uqzn
0d5+5qwwHAnsmZTu+4SJ1qe8hL8KwwDj+rJpeT4+83cZ1T8iAqSsxHum0y9R
v5RvLuS4CEgtCCcoPE3DUp5XvD+cRCDMbQNhYZmKveEDpHA3EbBrLfocm/Ic
FZOPHxm5KwKbVyCHaVccxtH20p4Vi4Bf/KNlPvUrGCW0LlFMRRSoHVGm+zCJ
UDnQ/OacpiionU/VjOJ+RmTFuBWW6orCQRHmUJ76c6JJ6V2r6yZRkNE5N/r8
VAqx2oAsUHdIFDJqVnmn1b8iQg/L+N0KEYU6f91Nm55lEoFJf/ezxkXB7XZ6
VfCRAmKffoG79owoWDnHdVRVFRCKZZ6RjvNs+08+iS8bFRJFfaNNTbxi0KCe
VLJDrIhgqnfsfacoBhrPGjIMij8Sjm9zd5/ZJwbK1MVz2t0lhP5m94sJh8Xg
VJJMlNEmJJY+U8Jb7cTAPxh51Z4gETf5on7bOTHgEr4R16RZSjQbRO1UChSD
mu5rdwI7S4mtha5W7dlseytX2BIq5cTqHVrnhIvE4Fyfkvgjy3Kiu3Pwjnmp
GFBs6LYHXcsJv7921Tn1YhAd8u71yoJyIpPYaRE5KAaMz1v6t26vIK41rXCu
HhODSR/ZoobTFcQuh/Lg5Wkx6DLmOlEaXEEMB26kX1wSg6Bl591N9AqCRNcw
2yEtDtFLO1/FEDRi4nD/qZsK4rCvj+/LZjsaUTyUGFSgKg5fs9c5mfvRCBs+
KRpZXxwOnfymcyWDRkTs4jHlthKHTbNfYxzEKwn7HnQ03isO3EarN/FpVxIU
V/9Ad2txUB/j2y68rZKofsAs++EgDh67exTXu1YSHC29UHxFHIYihkO+l1QS
QSMlz67cFIcFz8uH/jZXEnwcCVwb74gD3Y8PbRiVhJjOUVruI3Z8tgODdfx0
4rHpf+peT8VB4ZhX/085OiF/TDLY4IU4rGQ84FxPoRPqIV8s3meKQ1/Y542R
O+jE64T3ry7mi4Oaf1TaExs6oZsTzkcpEYc/D7U6ek7Tiexal/OjNHEwDba7
cdyDTmz4aVX3qk4cGJFKu2Wu0YniPxoU52ZxqPJ9yhS6Sye2rl4Rrt4hDu2H
dMlboukEXW3gV/8Pcbge4JT06imd2LGpfM9zhjis2rUkvTuVTjTsT35/8pc4
3P3ze6f2Ozpx8Ow1ESWWOPTs853flkMn2q/ZufcsiENnyGBvdBGdsHtk3BzP
KQH3BzppCqV0oveNjOGxVRIg6L/2fC+NTpwun42WEZYARnvX465qOjHa3sr6
JikBR9+ulxaupxOukx+sH8lLgP7pnOwrDXSCyRuZd1BVAuQahTcpNtEJX/lL
0mJaEjCQanx1ns1/DXb7NelLgLGq0y7BL3TihpV2x/3/JEAseCbgMPs570k+
491bJCAqOmqwjW0v1GcoTsBMAjjF1E5EsP2tDq9crNkpAWhSQ7teQyeiX7yw
u3NAAnYa/JxJraQTMkU3P5kflYBmW756rjI68bTphCLvSQkwaFDQi/lIJ5SH
Nl+vOCMBeSkbOU/m0om0f3K9Ny9KgKt1vubJDDqhJbEA4CUBK5b178ek0Yn3
Wu3Plq5IwJ7MG/LciXRi3dY8rk83JeBQemlp6kM6UXDkoZP/HQngiNl5/loo
nTBx9aBtfCAB+8qL+cOv04myoH3qc48kACynHn3xpBO1WYJDXi8kID3noMXf
o3RiT/WoheFrCTgmffNk30460fK9+tV0pgR8X3DZsWRCJ7oFbp93LZGA6iOm
D9rk6cRJFac6SqUEfCn+b/KhAJ0Y3LCVMlYnAdu959fema8kJk7/++XcIQHT
ihUHRFoqCc+Arj3kXgkYUuo5ksru/7mowvcDDAm4azt82i29kuAs9XZ3YEnA
/Ghp/6uASiL428FmpUUJoE+lBUidriT4f1ENv3NKwo+1792KdlUSErITrGPC
kkA7uuZr6ppKgux1xu+QliScCemcF3pNI3SMfxxM0peEqICE8P/u04h1HDZ6
o0aSIFlyIuCDO43YFmbFuG4qCTIviMWnRjTCPoVy6I2dJLSs+dFoWVBBnD6f
qjfrKAmOllo3OR9XEBf0FQW2npME2VSDTkHvCuJKsXD5N29J2NM6YSWvV0HE
tDL1uB5IgjjrzJhqfDmREOcisPuRJKxeoxjn61VOpJwcYDyOlwQOR+V0pd3l
xIfxrwk6ryThoozSwMW/ZUQDT6HA0TJJcOFNF+Y/WEbwrr8+9H5GEgoj2j04
y5AQXPxTvjAvCSfOHa3zsUdCrMwt0YxDCv4tfNqeuFBCkHY7WncJSoEj/99T
K/RKCJPTZhUryFLA7z0bv/dOMeH1SCDpuI0UBK/19PT4V0AM/H58WOCTFNx7
f/o0z1wm8XyroWdPhRQsNVSaP3PIJE6ENzx4XysFeZ/r4jOi3xOdarw1B9ul
ICx5VY4m5R3x5aDHpqczUrCnuHgXa9MroiRrF0lHSxqGPuSlLX2IJx5f5Bzd
81gaGgSY7k+LIvFQ4dMVyonSAMY5pekfH6IY7wbVmRRp2OeYx3mr7DHef+pq
9/iDNExNDd/270rAoLquhh+fpaGq7NXxdtVUdFubl+3GIwMTQbpCsUuZuGPw
/NUodxl4PWOWP/2iBM2vqr7d7icDckUdApGBiNskuztnr8mAEc3DQZBaisZm
uzfYhsnA6OuyM+OiZaiVqjej+lIGVkSduDrZXo4Cp1lnc7tloGB7wjlBfzrW
D1w91G6xBix7neQLVzbgnoEIbUVFWTDscFurzdGGoxWON6rfycGHi2k7KdCP
SpHt5+/nyMHlozdnvB368ZD9HutDH+WANr+3OzewH0vmNmr1VsuB9aWTstKV
/RilI9r6p18OVj9Mmba2GsBNj1FDQ1Ye9rqtKbmydxDDzss33g6Wh+Hr7/9I
7hvCsv+iCneGy4Nso9mFoEtDOMuzKkX0oTxE3e3P+X6fve8kzfglPJOHLf/a
b1h/Zu9rrbUqucXyUHCi2dzUahh7Nl/2GWDKg/+uZJdOkxHUFf2mYHpCAf58
HM/sEhlDRjgj8NFpBXiptxy9U3sME/j/DA25KEC29vqYZ2ZjKMgj8yHMTwGg
6ajw8uUxHJ09av4tUgGkREtvX/45hqndPa7naAogYyTKMH4zjvKvBvHBWkVQ
PqjT7KY5ga1qs2p9eorwtEhhaAMxgfeerQhdZ6QIL39MHu21nsCFOI1DHdsU
IbQn62F94AS2h58bVrFThPV52SKSXRMY7flLJO++IijsbygzuT2J/MRvh+4Z
Raji1ig7fGIK/bZqrspbUITNAUFpFuemkGFqm/GAUwl43UfVVTynsNyybGGb
sBLYx1ZHRgdP4ZUD4dHpWkogVt8bdPrtFI6dVq/0cVCCoPezI1kzU3jsrI3L
vrNKMFp4/gn17xRWn78nqnVJCXx/NQQ84ZnGlEvTx3sClODCG6UHypLTaHf5
06xprBIYmK5GkfXTWB9mrSnaqASeCZOytm7TaPzgTsPoVyWw/mdLtfadxleR
H71o3Uow5mJ9zOjaNAbFKJf5jirBcbd9qe/uTaNi0yxlkosEeW8H/VxTp9F6
vwiH3QoSBBVs9U96M41hzWtbqvlIcLZ/l2x+1jQutNpdfi5CgvSWX3NPPk3j
t47ySmtFEqjkML5QWqdRyLY7tlyZBAm2FvsjO6Zxe/dvFz11EvS5N/N1f5/G
D981xfgoJPh7THNBdWQa7/ffty/eSIJkf48PAX+nsfLUK+razSRYP1TcIsrJ
xL+DZTwxQAK97D09YbxMPD/Men3JggTq/10IXreaiRa/jv1RsSbBJS2p3VaK
TEyUuNVy3YYE/a3OAYvKTGRtevO+25YEtb3HrB6qMzE5dNE5xpEEOQUyKZcp
TJzNUt0+c5oEh3zuk+l6TNzdsZO07xwJqLGLevMGTFzQeNrO50YC5jNFmthG
Ju7bS8s548nmsHyz+U1MTPMZj6jwYeu3KGRC38LEg5UmVlevkiDJsdpXfDsT
X4+fUu+8QYI0bqu8aHMmckiEc/4XRAKd8FLbBUsmvnXsKZwKJcHIse9NV3Yz
kSuUN2b3fbbeCt3xD/cy0SZLx+N1JAnefrlOe7ifiRnt1ntWPiJBdqOGlf9B
JvJyXNM6FUuCa8OXNS2tmWinkbaiLJ6t/zknh8XDTPywp6FPIYkE/5TWzDy0
YaJ9gmJ8WyoJtg0rK/nbMjGHZu67Lp0EPxW3F1bZMZF/3PVg5FsSWLY2vVk4
zsST4o/1Jt6T4OJJxz/iJ5iYb4wCO7NJ0BrX+VT8JBNXOw4NvcwjQXWbY8I8
m0/dFabxFJHg24DLQqUDE4sy/0t2+ESCOzwZuX6OTBRpPxFQUkqCLSOaX0Sd
mHhmOcRGjkaC/e9V90ayuZicuc6vigRO3ygGf9gstqdd5GstCcY3yl41PcXE
c94cv6gNJJhexWfow+bSp5o197+QgOPT8SMP2CxF25c61kqC4yK0X/fZfGHM
76ZlOwnsZ3QXvNhcLvbseGoXCfhutt/YymYZ45qNXD9IMMDcGsxi+3N1mJY8
0UeC5WhD4ftspt1Zw/w4SALt7GLSajbLZW5tkBkhge9Dw1Ivdj4ebedee4+T
oMth/UwZO9/qpcjg5kkSkOTS8DdbD0VykaPeDAlmgjK1RdjstbtvS9gsW19p
+mZRtp61XvxyI/Mk+D6a+HeOrTfpqcEfs38k4E3beOn/9fCpONbynEMZnp/t
ehrArtfn0cD3y9zKYJcvHC5zjIlqYm/u2a1UBtkzryzi2fW9srHFuZBfGZJv
fmrlOcJE8h1VkqeoMghVyN0JY/dLwPudfxsllIFv5wy+ZvdT8zfPdoqMMnz9
4vTrPbvfrqvTIhiKypBwhbL30k4mfts1fsFURRlKGPB4rRUTKV4SVsnqyoDv
zvytZfdze/kpzmMUZYDFo5YVW5k4tbVT9qqeMrydLiq2JJi4smzvumQDZWiT
6n1XYMJEIzR2ZmxQZt+vhyg2/zHx4UeRzx5myuAtvTcjRps9D8bBjEeWytDo
0yDnrsnEisLF5YKd7PhdRY4YseeXmc8wWN6vDNISek432fO+N6c49p49Ox7+
neJyIux+MjT4kOHAPp83qrtbkInXPrys+3JKmb0Pk3zOr2Lbz4xaknZRhmtR
/wrPcLD7/d3ZUym+ytAnrnfbeXIa6akS+p8ilIHi6G8cUzON39VCrXqjlSFz
StD5Jm0af79YduR+rAz5Wy8m2+A0qj0ffWSVwI4/94lfXc40BiaWLn5NV4ZR
W/lAWuI0bnl8oWqiXBnUGvdliV2axsNSfb2idGV4VbL5Ev3sNF58dGRhXY0y
iDxx2ensOI1Po7fp+Dcqw6+HkO5mzb5vH8hEr+xWhiWdHOEU42nMvUOzJ/1m
n5e/XJbIyb7fd9TJhMwpg5K6s2nY/BTGCTY3/1pUBt66E4Knp6fwRsQP849c
KpCeVd/b3juFu2IXdA+LqMC9ysaE+pIp7Hupv3xPWwXSftd4//OZwtVVT5P+
OKjAaLHay8wPk8h598VR+9Mq8EGO9aIxYRJZO16LV55Vge3FOd/q70xiR0N+
SNQlFQipH/vlaD+JKd+aL+lcVYHmrwNneFdNojFjFTjFqsDPH0b1J9nf3zO8
3r0NDSrwXDXC4WLnOMoq1bQtflGBh/bDJtcrxrFhg0Kj5lcV4L7GjPF/O45G
Fyo/BXapQBvtUeW6a+O4okUy3mhYBTKLYoUySeOYmpxnncipCgu1L39xOY7h
wKa52ovrVGG1xYnDw20j6OThnysYpwqG3y00E5MYqOes3bDLQQ1ufZn83L+x
F7+fU7r07pQaTPRxHlut1IthF8RFVp9VgzNPPC5b8PTiiPvi/kZXNRiezvb8
nPADXwTUfd0foAaps/9Z02q+o3SUS8/hx2ow17XzN1mzB5eL34yf/KwGDC7c
IcHdiRmYFF7WpAZnJd9WmzZ3oF15tK5Kqxqsmy2UTHnWgYVV/m79nWoQ7SDs
Pg8d6Nm8k3V6WA32nNp4ZGVgOw4NjS2e51aHugMloLe6DRvFKALeG9VBw95D
6e6BVtxy8eJIvIk6GCgbn3in3YoZVRlV5YQ6hL/P3SbA24r3A6hBIubq4Nn6
Ndq7oAV3MYz+vTmgDlT7q4+FVVqwtnDrZJ+LOnBGzM5mcjSjscStz3yX1CFK
ab4rsecLvnalvdH3UAeZvanx9UVf8K6qxdlrfuqwfkxRdcT7C1qG7/q55rY6
JKx77qs/2YSVJ4+07EtUB2KS8L7f3YjrPsZm+T5TB1fbuwIfExsxRbLzQWKK
OpR7WNzwcGjEoFq7XeOv1eGt6I7koOEG3LbOsTIkXx2Csp+9tvj3GUtXXswv
aVIHr+Dompat9ajvmPFosIUdL0dv2LxgPSYXT3oKtqlDb53xn+z2Orzu7qF/
rEcdtGTTOUbc63BLl2/67xF16AHKPqc3tfgxIzCewk2GFHtxU+FNNbhil7Xs
4xVkeF+ulKYuWIP7RzSecPKTYRV1xJvVU41Dqp9jvomQwfPb3Y+fblWj+BPp
qBuKZBi6xc0r3F6F9kajImPKZJjpmeaaz6jC9JbiB9bqZHBtXWAlBVchsdox
XItChns6kY3kDVXocuvtndaNZBj7GxVHTqFjHun6SmIzGTLJbkErbtKRs2R/
cDqQwd5x4/GX9nR8PDd765oFGep0nmToyNOx4uLW65rWZFBWeit9NLkSVwtI
LEXZkEF7d1bjrluVePQVI+CfLRlCFZZ/8jhX4mTfvSvNjmTY3Pg3qUK/EuVs
vnkHuJHhYfFS7e3PNDzz+xWL4cmOj1KQkZZHw6wof8/9vmRwqlSm30+mocVn
kjv5Ghl8Vo835frQMOr8zGTETTL8EGfZ/3akYc9KuutiEBkCNeat/+2loec2
lwtN98gQ0ZYT50yhYcmPzWPGD8jQo+flVitHQ76rIudTo8hw9zrgrAAND8n2
DwvHkMHKxLxy/G8FJuXnOl95QgYd/WMlbycqcPTQHcbAU7ZeNXP9Rj8rcD3z
2Om9yWx/XmYX77VWYB2Fw0ntJRkSv+T6P/xUgVK1zT/vvyZDReFxJ6vsCnRw
Tj05/47t/2+RZ016Bb7l8fvhlEWGDVza7RLPKvDPsx32DTlkwJqMQu0nFbiN
UOjZUECGbs/RLaujKjC8e9L2xUcyJDeqhRXfq8D2y+WdQsjujynzCqPgClSV
fnTUr5wMV6q7uK/erEDXHOf2vkoyvGsUdnlwtQIL9xsf2V1DhvT0THHXKxXI
Myn4Lb+eDCPtFKk1fhW4N+zHIZUmMoj4RN+J8KnAuLUfWsJayPB9Ivpaq3cF
DtKDDvz5RgZ63VW+QTbrnzryxaGTDPEBsKGc/b4/p9a++h4y7Ke4SF9g22Ns
F2gn/yRDEretzVe2v313xk/cHCCDcbTWDPe1Ciyq+zzUNcTW+5rgrz/seNWE
318yGiPD79//LLPY+dw/EPEnYoIMIZn0lfphFTj3yP362DQZzBlzGl5sPRw7
Dqw0/02Gz4emU6+y9aqXX/cgeY4M/pZt/rvYehqdlJReXCTDxrdPn/Wy9U5+
MZtovUyGE0pLgsbsevAPtZEzuTQgRvRWlg27Xt5ahRn8KzQgavDqDZPqCuy9
GGd0mk8DDNcInhtsqcAdWf4lKKgB4V5SNgd7K1Bxw5YGL3ENmPMzYV5drMA7
/kqHG6U0QJCkdsGYn4bMEo7va2U1oNmTFPpxDQ2rzCp+fSdpQL5l/n8Cm2ho
cDfFe6OaBpzzDAzq2EXDp/W3/0VraMBeG9qkywkauh20FLLS1YCX5MFb3cE0
7IxZ++gFVQOCBU7bFMXTcHsnv8LSOg3YHp743DaLhmscPlOyN2kA+rq0DX2n
YbnrgV0KVhpwUOI4l7JpJVI+GLb67tKATWmTLRL2lRjzW8Kuea8GGKv3nqy9
XIkuAW0uIYc14FeWbdrl7EqUCLW7N+2kASxfuY0/9eh47fNm8V3OGlA4p7+n
ax8dh0WU4tPOa0BixNWOhx50/PT452tbdw0Q2m250qyAjmdSz9RWXtOA67b1
/0XsqsKmYYsDpEAN+NFafzvAswqNKWs7r9zWgGHvdH/1+CoUzh4b0QvTgJUb
fRvfjFdhQakbX9wTDSCt5s29FluN/N1XLF1z2P4sFe92idWikW+60IN8DXAq
VPSZ2VqLDmLtze+LNGDkyYxVunstFliuPz5dqgGV9VJ/xptr8UzupLvXZw2I
hGOW1U/rsOz+qfgrDA0I+dDScnb3ZxxfG30yfkQD7KqEbq8N/owylWXqxeMa
0H7xv6wb+BldFxUz/zE1wOSOpsuUYQPKn+2g3Vhm61Ppmk5XbWTv43smgmU0
IfTTjo5zD5owpTsg+6WcJqjX8qUdz2zCRt83ftWKmvDO3m5L7JcmJGes4uZX
1wSbxxFPeyW+YItshXQ4VRNMPKO8chO/oC7rv63ROzRha6/+bU1sxsE05YdJ
AZrg3v+R2qH/FceDfs5z39CENBdq743jX5Hp+OzE2VuaYGh+e8o19CtyKClr
U0M1QeP+Y1P5wa8o+5hUXv5YE9q9tHrfJXzDfSFKU4MfNKGYdYe+Sa4di50V
dlFGNKHNWDN+//YufKi5hqfQei0Y5m26Zi39EyPizlQ5kLTg30UWzV51GH19
Aj0DVLXgZr1R20ViGO0PJCo9JmtBQ9M1+yu2w0jh/+ZbT9ECww1VpaHRw1hz
2Uzzv41a8Epn4fZN7hHkOqp2V/CAFqyxUysM6xtBb+m+Hfm3tOA684WpVfwY
Hnt4vEFwSAuavl9SlxyZQPlsfjmXUS0Qq0zMTeGZxB9f8p1rfmlBSYrtf4qk
STwlLMYZzNIC0g9yx+fDk+gaSjdc5tSGqnp+DemKSQy8ofdkWl4bHOS8X4Ts
nML0C5ynvh3QhoosmUMWktN44V5G5rrD2rB+lfWt08rTqPva9l/UUW3QX9Uh
7qUzjR+GcmP2ntSGDJXZRgezaSx2PF9TfVEbLrrROAK8prHJpkX34x1tMIlu
33i/cRrntqfOJ5Vow91AV9udfux952PSLVqZNhjeiLINv8nevw3ihEZo2rDp
DPNoSSh7P1F6oGxQpw26V2Rnx5+y98d5Pytamzbk715ldKWUiYbvdj0ZntKG
UzxbMrbyzGCeqoWqEEsbdqVzGZ0TnEHjuK3vqH+0oSyN6XBNYga3hRiVXfmn
DbeKPlq7q83gPgfSiCA/Bdrs7gT6ms6gqyRrA1WVAtN2mw1YV2eQeW+i3JpM
AdUY/eHxoBn05hrZdWUtBbTlr0g035vBgMmekxV6FGjwnwp1eDKD92qq7lib
UGCDKlMyOnsGX12Nb79sTYGHNbI+BgMzSGE9cky0ocAFp9HO0ZEZzDwfMV5u
SwGV2yfy70/OYP6R2xyCjmz7xVsSYxdmkE69pJnoSoGF851J2cIs7B/c5lce
QoFsz9k/C+tZuC2p4bnWPQo8GzoRVm7MwmSbY5+j7lNAafS6kDvBQvs6dxWn
R2z/zU8TAi1Z2JmZXM/9ggLfZ3n8fY6ycON5yh+XNAqcihib8zzOwljVAuXW
dArsfGy2cMSBhYdjGn1SMimQWCdk03KWhc3+SySzEjYrTWyP8WEhdX3ozndl
FLjb5vWMfpmFEROSPpKVFHi8ZodWTwAL9zjo1A3WUeC88Ke44kAWvpMt/L27
kQLuBKfb7dssFGzdTsprZvvX+Llr3R0W1prbeQd3UEBm469F03AWruUYTpro
poAhp3BJygMW3in0rD3cS4GQ8XznsUgWmlPuKWkMUSDmRdEhrRgWpg5K7Xgw
yn5/jV2oSiwLeZKee/35RYEMHYkwjjgWlosW1VSx2OfN7nVdTGChcp0ZS2+O
AiIBDIV/iSy8EfRFMXaRAn3tEZIeySz8sfm4FccyBSLPRn+qf8bCLX+GPc9y
6QBJdpuo0AsWJmR6JTbx6kBE/SZBwxQW/j3HUbOBTwfSbM+/3pLKQlvVsJlk
QR2gveEa1ktjYVG3tCKfiA7M5QSVrXjJwjUxLyzdxXVAI/yjYQWb/fbqeXZI
6YCT+6dNp1+xsG3Vx4Stsjrg0jD2bZzNRuXm1ekKOmBhOcN1LJ2Fj/ybmaLK
OiBQVvfpLZtZ6+wVrqjpQJN9Ae8gmw9OjFj0aehAYYRFB9drFn546e2xQ1sH
1osf/G8Fm0UdOBM+6OqAzcyy4iT7fTfZ8CpZAx04Flny4BObG1tkmIHrdcDq
+Y677mzWDU+RH9ugA/X6bwQE2Bxurm9x0EQH1BIMpEPZ8Y0vf3T/SLDtP732
doKdz85Ci6eqpjrQsN6vfgObX3u00O+Z64Bo+UG/s2w9+CgnpmesdGBiMCLr
Kluvs4Ojcna7deDn/YXLfmw9qxJ9zGn7dKD4V1qLDVtvsg2XO+WQDrx2+1Oq
+JyFt0Xvxz88ogPbimO317LrNVC7hv73mA58fxHoYJvEwuebqXKfHXSgyirE
S/cpu/57+G8tntIBuSCov8/uh74T/aNrz+rAVoWr2u3sflENfFQU7KoDS3Ji
wuRHLNwe7aqS664DPSVb47WiWXgqxSK030sH9mm82CLD7r8U+vxR8NeBPne5
nowwFtLamstcr+kA07Hp55FQdjzDb9Ym3NQBitKMyGgIC9UE7OfnQ3RgsESH
p5Y9D6l7y2OzH+rApNzdPj9fFtJPxnP0PdYBmVr9HhcvFjLcvc6KxLP9+x4z
tHRn5/+QvOHiMx1YyTG++tN5Fqa1h7aRM3Sggv+gTawd+/yIE2GdpQMf1Ou5
2mzY5xdMXt7K0YFqYFgsH2KhhsKkT2+RDhSMvq8U3M3CVw4HpeKqdCDS5fEj
eRMWVntQrlXX6sDhnZFr0v9j4fAtXsbsZx0wk9O9rWTIQs20/NyDrTrwsoCx
uXYtC9NH5ayFfuqAc98JFxkpdn09B6JvLOjA0cUSmeejM1gb9Gkx458OKNGm
gprZ99/ooxinHg5diGSmxf/6PoPaBZaGxit1IVElnWOgeQbf/n3bPCOuC7FB
5SYthTP47ra3qLOOLhzMMaVX35rBcZPjgbf1dWHqnlhZQ8D/79PtMy8MdSG9
TV+zzHsGXztKfO3dqAsux60CXJzZ9y+RHXvMXBfK2u8ItlvNYMr8lNKeE7pQ
Q5weVhKYwbiLF3TXR+rCSGls1Ph1JnaqHUo6+FAXEuau9D73YeKa7k0iHo91
4ZTNiT8WF5kYu0OAmZGgCw3dc9/sjzHxkcbrXM3XupAc1lhZZsjEiJ9DJvIV
ulC1GKLh1j+NIdZOO7l/60Lu210rJf+bxud7u+1Oz+mClewp/24t9vfSytq1
alEX5pzEN0QrTiNzs0XkPS49eJhfJ9rIO412ZO02cRE9uPo2eelWyxQa/GE6
qmnrwZOzqcKcF6bwe2zgFTMHPRDbKO8brDaJ67ufpYd81gNax59oL78xjF0b
/+7zTn1wJct8c1QZQNaMeeqt3frwSHu5zo1rAPeWMJ9u3KsPNzvcEoP6+nHF
wR1hqQf04c2ioQk+70fvgPnzV4/qw5oTZKFQ1X480HhEU8dZH9bd2LK1gtyH
gt4SL8IC9eHsHmEHDaNePEuUxm0L0ofvC0W9cdK9WMF3IWrutj7spTQZbWH+
wCuJFTdP3dUHXRdz9Ty/HzhS5XHSJEIfzK7XnT4U8h3psl8UxhP04d5H89Su
N914vTQ8dmehPqy/qzgTJNWBoz2lD+eL9CH5mN6Nrh/teHhxJuJlsT6c2bcv
63R6O1KMjt3lLtUH56HIzdKb27H9DfnKR7o+3FEWCl8604YGj9FWu1UfltJn
vG0qvyLj4rSiwKQ+1FlMWI++b8b999TkCqf04Vl+zWa80YzFr45IOzP1QblK
yK99fzNG938SrvitD+84I2o6WF8QjoZy+P/Vh4iNvX/VtnzBuO2qfaN8VIj3
l2wKKW7E3XLWqbVqVIhON3pz6H0txg7oltqSqWD5evBB+9laHHi3qmtcgwrp
6x7/HVWpxQAoFhHWpkImN+3Lp9gafHtaNeAglQrNjvnftO+x/+9nTh/o3kyF
QONvcy/v0fHw5bqLFwkq6JPm5Y/uoePzbal3loAKLSknPjwTpePGrzYlpO1U
6L1ptmHxSSWeXcC1p3dQ4XeoYEQPez+q2n6fY+IwFbZ5ZFypWSpHsdVn5a7b
UOFCbbS7dl052rdtNRI5RgVhSq8FJbYcZ8/9djE4TgWF2ogNguvKkfzArs3H
iQogIWu3z7MMPWyMmCtPU+Hyuo7QnO1lWKIsIvTkDBWcPokWF0mVoXVOxbaP
56gwUH/3SUZxKQZ1aGUsX6ICXY8uskWkFJue89REuFMh4i3puN9nRPkL3/uV
PalgtJa6psQfMXspcs12H3Y8r1OjNbtLsE91PuhOABVUPws4hb79hFtdq2xF
71LB7MbTXf/ufcSF9hFzWigVJi/MC7yy/Ig5poIGvmFUmPqRYd674iOS1+xf
1fOACm6zegcWQ4pQkNaZ8yqGCpvbiz6NPC1Euu6/JNtYtv7qM56rzxTi9SdK
91bHUaFU9LYPTb8Qma6nHLwSqOD+dHR6sLYA29dMCEEKFUbuN+avEivAqCCR
eWYqFZoSFYfKhvJx56TBQOpLKry3VBQSxnwsofkWCbyhwrqDF43PeOSjn15c
aslbKntfKM9x25OP1LjiCPcMKuh0tQiIUPIx5RKnc1sWW793JO7V43lo36l6
IDSb3S+cxtMXGvJQ2sx88+ZcKiTL1xxx+JCHTe/Pak7lUaHcRf7A2OM8DJW9
J/6igAr9xl2z/NfzcPvtd0vWRVQg+fDalDrn4b/JxpFVxVQ44zsTKHAgD/OO
MVs/fqLCpn7rG+Ob89CtUqLUFalgGLn+kJN2Hmrp//dGuYwKY4Ez/y7J5mF/
3NGY1nIqOAxb+okJ5OFT3oCbITQqyFMtCnf8y8XDbokXjOlU8NK2+SAznYsi
XaVHflVRYVF/y74ARi7WmPVvS65h63lSwt+7JxcDM3l1D9ZR4fXAHimeb7lo
Iqe5ZsVnKvDu+Mih2ZSLs7d38BQ2UIGv94bEz7pcfD91YdKlia2/prKGXk0u
nrV90KnYTAWbI358YtW5qELPqvzSQoV/bZ9C7rK5W781M+grFWpHgs49qs3F
R/Gz8f+1UUHd9JP7+oZc3LNiTchoOxUSadn251pycZX7Jo+ETiq0bxAf1e/M
xfKu48f3dVOBpjxYfa8vF/3Nb1hyf6dCSnTUm8vjubgu67lh3g8qbFQY3Lzw
Jxcn5CoVz/2kQlfxSg0h3jx8FTzEJ99PhYT+EL4P4nnoMM33u2GAPU+3D98a
Vs1DWTtK700GFe6ur9HJXJ+HrfQ9deuGqXDkYHzCKqs8vE91zxsaoYILTDpO
H89Di6fRz+LGqHA9bS/fea88LHJv9+WYpEL9qLsIX1oeenYvOGZPUUHkvb27
blkeUiwU9pxhsuc1KTP7Z08eJsk7qtX/ZutZG/t6Ui4fjQ21dR3/UGHv+phV
KzblY6sV67+5OSo4/hHZ7G2bj6t8g3eq/WWf31NOtkvOx+fhe62L/rHn2ZCj
uZmWjyYpMif2LbPtZdUTyaP56PbltUcAlwGscnNYu9m4APmHPQPEeAyAnkO7
LnCqAFOWTIJf8RqA99XJ3boP2POk3fikdZUByNP3/3QdKUAInimlCBvAySJC
ovZdIXY+La4tFzEADo0CN62+QvTKvt1qI2YAuuZ2gp3SRfiqV3o4SNIAznt2
qqmx51t0k4lwj5wBzEjfX7PX+yP2TQYdD9c0ACG9LI29Dz5hwIo9zqpaBnDU
OrHSvP0TSilIuxdqG0CUb1DWDZUS3LEjPWhQ1wB2nnlEyy8qwQ8pn99sXm8A
nROxx2UWEG8dlVr4tdUAVF1N7vcdLUNFtx/cQaYGULF6l5nRnTIsCH4lJGtm
AP2ZpNWq+WU4nm2sbG5pAArJm59USpXjodUnLBP3GMDoJ94ExZ5yVKt4GbPH
1gAmlPelx9+mYQNlLqXbzgC+ek4KKBfT0C/GMvu8vQGMUbfv05+hYd25kcZg
BwMwM+PjH3WsRA8RbT50NoCbwXL1BZZ0xOMZ/npeBlDY/DLWUKcaj83lnBQJ
N4Cn3AUvug/VI48j76XE+2x/zw4PWcfXY0ad9VVKhAHYKPnxmvbVI2fS7BPL
aANo3Rpf6u3+GV+ZbWi58cQAjC3brms8asDfUR/NplMNYIfDvhu3/ZowQqdc
q7mE/Xyk5MDdhWZ8tcGWL7DUAGzvOp+p1mhBNGUNUcsN4FaU1goT6xacOEpO
jaw0APsHgS9KMltwZ3Co0v56A8Akfgvl86244scBiaYOA5g6q9DbMfgV/SP6
/31mGcA5ypzY6N92PDPD86VGyxCiC/ZwJwX/QMcsJunuA0PQWnHrVB4XAy8E
Hvy7I9IQDl3Y2VipwEDvgzltgtGGEB916yZ9AwPv/Pa+HxFjCFxvksziXBmY
sXF+8XGCIeSLz0jf7GDgfNnyt7Q3hrCa/LB34c0QRjQLhtOqDGFX5csdKltH
MO7FxbPBNYawJPiXL/3oCL7wajC1rDMEqT+bKyU9RjBPKmKhrsEQpipT25Ke
j2D3MfGzLV8NwVxrq9RFrlHU6F9j2tdvCNqvPhx/XjyK+jlXFFMGDSH0HH2j
Q8soGt/umj89ZAh+39e3c4yO4i6NhMyRUXY+oX/W/JQaQw8XkuL0tCHM5mXP
yl8awwCTm/MfZgyhX6JKsyNoDG8L9bV6/TaEYOcPzz3j2P8P37+4NzdnCB7/
1m3YVjmGz2/wOBctGILTwI9C784xfLP/9LaAv4aQ0n9vb/DkGOao0BW2LBmC
yCPLd54841gyQ55fXmbHO/0gZPOacfwfG7ctsw==
        "]]},
      Annotation[#, "Charting`Private`Tag$59570#1"]& ]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20.000000000000146`}, {-1.2915094737748423`, 
    0.17803450496520914`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9103192893501654`*^9, 
  3.9103192961016097`*^9}},ExpressionUUID->"62002853-5ff0-499c-ba7f-\
4cce752aee9c"]
}, Open  ]]
},
WindowSize->{1315.5, 499.5},
WindowMargins->{{0, Automatic}, {Automatic, 89.25}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.4 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0dcb5c1a-aa17-41a8-97fe-faa77ef461c9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 476, 11, 160, "Input",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],
Cell[1037, 33, 693, 15, 153, "Input",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],
Cell[CellGroupData[{
Cell[1755, 52, 2151, 60, 491, "Input",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],
Cell[3909, 114, 1168, 31, 119, "Output",ExpressionUUID->"e532444c-1d82-46a1-859d-d386cf4d5ee4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5114, 150, 4049, 125, 944, "Input",ExpressionUUID->"610bb0be-b3fd-408f-8a42-be39a453f29d"],
Cell[9166, 277, 1380, 43, 169, "Output",ExpressionUUID->"a0a0ca4e-9cb9-4e59-9719-f15af55ece65"],
Cell[10549, 322, 1770, 55, 169, "Output",ExpressionUUID->"ee26c6f5-f9c4-465f-8475-31da71bd1b15"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12356, 382, 3073, 93, 662, "Input",ExpressionUUID->"9af101ac-d87f-4f62-b0c8-47ee1b66fce1"],
Cell[15432, 477, 39105, 662, 552, "Output",ExpressionUUID->"ec6bcbc8-ae29-40a8-a5c8-a2fc5385835f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54574, 1144, 7010, 211, 2067, "Input",ExpressionUUID->"b2757a10-191d-49dc-a67e-bc59a1714663"],
Cell[61587, 1357, 25832, 441, 552, "Output",ExpressionUUID->"62002853-5ff0-499c-ba7f-4cce752aee9c"]
}, Open  ]]
}
]
*)

