(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    182067,       3392]
NotebookOptionsPosition[    179681,       3348]
NotebookOutlinePosition[    180197,       3366]
CellTagsIndexPosition[    180154,       3363]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103185676102505`*^9, 3.910318568760665*^9}},
 CellLabel->
  "In[700]:=",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"par", ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Total", "[", 
      FractionBox["1", "#"], "]"}], 
     RowBox[{"-", "1"}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ser", "=", "Total"}], ";"}]}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}},
 CellLabel->
  "In[703]:=",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"p", "*", "L1"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"za", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"p", "*", "c"}]], ",", "R2"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zb", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R3", ",", 
      RowBox[{"p", "*", "L2"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{"par", "[", 
    RowBox[{"{", 
     RowBox[{"za", ",", "zb"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prenos", "=", 
   RowBox[{
    FractionBox["z2", 
     RowBox[{"z1", "+", "z2"}]], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L1", "\[Rule]", "1"}], ",", 
      RowBox[{"L2", "\[Rule]", "1"}], ",", 
      RowBox[{"R1", "\[Rule]", "1"}], ",", 
      RowBox[{"R2", "\[Rule]", "2"}], ",", 
      RowBox[{"R3", "\[Rule]", "3"}], ",", 
      RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"prenos", "//", "Simplify"}], ",", 
   RowBox[{"prenos", "=", 
    FractionBox[
     RowBox[{"Expand", "[", 
      RowBox[{"Numerator", "[", 
       RowBox[{"prenos", "//", "Simplify"}], "]"}], "]"}], 
     RowBox[{"Denominator", "[", 
      RowBox[{"prenos", "//", "Simplify"}], "]"}]]}]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}, {3.91032129999327*^9, 
   3.9103213268570223`*^9}, {3.9103216143103514`*^9, 
   3.9103216824171247`*^9}, {3.910322177432126*^9, 3.9103221884641523`*^9}, {
   3.9103222231440277`*^9, 3.9103222308871*^9}, {3.910323229022059*^9, 
   3.910323231024375*^9}},
 CellLabel->
  "In[705]:=",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "p"}]}], ")"}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]], ",", 
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"7", " ", "p"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["p", "2"]}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.9103187216013775`*^9, 3.91031881473453*^9}, {
   3.910318863437398*^9, 3.910318941095933*^9}, 3.9103189852341127`*^9, 
   3.91031911496647*^9, {3.910319201428973*^9, 3.9103192132912235`*^9}, {
   3.910321292362014*^9, 3.9103213274636955`*^9}, {3.910321657468945*^9, 
   3.910321682935179*^9}, {3.910322180081609*^9, 3.9103221895424256`*^9}, 
   3.9103222326427927`*^9, {3.9103231596946964`*^9, 3.9103231657775264`*^9}, 
   3.9103232324484653`*^9, 3.910325838613558*^9},
 CellLabel->
  "Out[710]=",ExpressionUUID->"0c0c18a9-6562-43ef-afe4-bbacfecc0f57"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn0", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"vCem", ",", 
      SuperscriptBox["p", "i"]}], "]"}], "/;", 
    RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"vCem", "/.", 
      RowBox[{"p", "\[Rule]", "0"}]}], ")"}], "/;", 
    RowBox[{"i", "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numP", "=", 
   RowBox[{"Numerator", "[", "prenos", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"denomP", "=", 
   RowBox[{"Denominator", "[", "prenos", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103190743512273`*^9, 3.910319177581434*^9}, 
   3.9103192389050026`*^9, {3.9103231808821287`*^9, 3.910323239575629*^9}},
 CellLabel->
  "In[711]:=",ExpressionUUID->"610bb0be-b3fd-408f-8a42-be39a453f29d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"denomP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"numP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "0", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "0", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "i", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "i", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"i", "-", "1"}], "]"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceStavYU", "=", 
   RowBox[{"stavRcei", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"vystupniRce", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "n", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}]}], "\[Equal]", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solVystRov", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"vystupniRce", ",", 
      RowBox[{"y", "[", "t", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rceStavObecne", "=", 
  RowBox[{"rceStavYU", "/.", "solVystRov"}]}]}], "Input",
 CellChangeTimes->{{3.9103190743512273`*^9, 3.910319177581434*^9}, 
   3.9103192389050026`*^9, {3.9103231808821287`*^9, 3.9103232027633247`*^9}, {
   3.9103232621832104`*^9, 3.910323262641935*^9}, 3.910323298003126*^9, 
   3.910323655561279*^9, {3.9103237032383833`*^9, 3.91032375592161*^9}, {
   3.910323900694393*^9, 3.910323901712363*^9}, {3.9103251399580545`*^9, 
   3.9103251481619053`*^9}},
 CellLabel->
  "In[717]:=",ExpressionUUID->"67e9168b-db60-44ba-a9fa-427b0361b9a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "+", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}], "\[Equal]", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 3.910319239453104*^9}, {
   3.910323149040643*^9, 3.9103231851460104`*^9}, {3.910323242079173*^9, 
   3.91032329850871*^9}, 3.9103236560938244`*^9, {3.9103237037876053`*^9, 
   3.910323773767955*^9}, {3.910323886917143*^9, 3.910323929871626*^9}, {
   3.910325140772576*^9, 3.910325148806188*^9}, 3.9103258386453285`*^9},
 CellLabel->
  "Out[722]=",ExpressionUUID->"1ccb2269-4244-481a-b2e4-19d38c0b0364"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"13", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"8", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 3.910319239453104*^9}, {
   3.910323149040643*^9, 3.9103231851460104`*^9}, {3.910323242079173*^9, 
   3.91032329850871*^9}, 3.9103236560938244`*^9, {3.9103237037876053`*^9, 
   3.910323773767955*^9}, {3.910323886917143*^9, 3.910323929871626*^9}, {
   3.910325140772576*^9, 3.910325148806188*^9}, 3.9103258386453285`*^9},
 CellLabel->
  "Out[724]=",ExpressionUUID->"6e06fbc8-f41d-4f5e-84e6-2c87e042a93c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{"0.01", "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"0.123", "t"}], "]"}], "+", "rn"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "tmax", ",", 
       FractionBox["tmax", "500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intu", "=", 
   RowBox[{"Interpolation", "[", "data", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"intu", "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"intu", "'"}], "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"intu", "''"}], "[", "t", "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.910324022667981*^9, 3.910324246979061*^9}, 
   3.9103243631230135`*^9},
 CellLabel->
  "In[725]:=",ExpressionUUID->"34d5834a-ceef-490d-a6db-e030bb1d74d1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rhs", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Numerator", "[", "prenos", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Numerator", "[", "prenos", "]"}], "/.", 
          RowBox[{"p", "->", "0"}]}], ")"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], ":>", 
         TagBox[
          StyleBox[
           RowBox[{
            RowBox[{
             RowBox[{"Derivative", "[", "i", "]"}], "[", "u", "]"}], "[", "t",
             "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm]}], ",", 
        RowBox[{"p", ":>", 
         StyleBox[
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "1", "]"}], "[", "u", "]"}], "[", "t", 
           "]"}],
          ShowSpecialCharacters->False,
          ShowStringCharacters->True,
          NumberMarks->True]}]}], "}"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Numerator", "[", "prenos", "]"}], "/.", 
       RowBox[{"p", "->", "0"}]}], ")"}], "*", 
     RowBox[{"u", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lhs", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Denominator", "[", "prenos", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Denominator", "[", "prenos", "]"}], "/.", 
          RowBox[{"p", "->", "0"}]}], ")"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], ":>", 
         TagBox[
          StyleBox[
           RowBox[{
            RowBox[{
             RowBox[{"Derivative", "[", "i", "]"}], "[", "y", "]"}], "[", "t",
             "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm]}], ",", 
        RowBox[{"p", ":>", 
         StyleBox[
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "1", "]"}], "[", "y", "]"}], "[", "t", 
           "]"}],
          ShowSpecialCharacters->False,
          ShowStringCharacters->True,
          NumberMarks->True]}]}], "}"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Denominator", "[", "prenos", "]"}], "/.", 
       RowBox[{"p", "->", "0"}]}], ")"}], "*", 
     RowBox[{"y", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{"lhs", "==", "rhs"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"rce", ",", 
     TagBox[
      StyleBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "i_", "]"}], "[", "y", "]"}], "[", "t", 
         "]"}], ":>", 
        RowBox[{"0", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"i", "-", "1"}], "]"}], "[", "y", "]"}], "[", "0", 
          "]"}]}]}],
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], ",", "All"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceAll", "=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rce", ",", "pocs"}], "]"}], "/.", 
    RowBox[{"u", "->", "intu"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"rceAll", ",", "y", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plPrimo", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "sol1"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103243812289367`*^9, 3.9103243826652117`*^9}, {
  3.910324414835314*^9, 3.9103245150364323`*^9}, {3.9103245997099104`*^9, 
  3.910325094858467*^9}, {3.9103256972283707`*^9, 3.9103256995308657`*^9}},
 CellLabel->
  "In[731]:=",ExpressionUUID->"58dbc308-1146-4515-b1f9-896efc88e70d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocsStav", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rceStavObecne", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "'"}], "[", "t", "]"}], ":>", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "==", "0"}]}], ",", "All"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rceStavObecne", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i_", "]"}], "[", "t", "]"}], ":>", 
       RowBox[{"x", "[", "i", "]"}]}], ",", "All"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"rceStavObecne", ",", "pocsStav"}], "]"}], "/.", 
       RowBox[{"u", "->", "intu"}]}], ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystup", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "solVystRov"}], ")"}], "/.", 
    "sol2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plStav", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"vystup", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plPrimo", ",", "plStav"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910325160630723*^9, 3.9103253332064395`*^9}, 
   3.9103254136267843`*^9, {3.9103255845152264`*^9, 3.910325600041668*^9}, {
   3.9103256472702885`*^9, 3.9103257346019554`*^9}},
 CellLabel->
  "In[738]:=",ExpressionUUID->"2a7cb200-a0e5-4628-b6ca-6dbd311847cf"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVV3c81e8XNwul7JZxrWtd49JXkjqnQZI0lUqKslJCRKiEjIykjBTKCpVE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        "]]},
      Annotation[#, "Charting`Private`Tag$190318#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVV3c81e8XNys07GRe6xLXuBQqdY6VQiqlJPWVhlVWpKSFUlZUJBEZhVQq
ZOUa1xXKTlbIuGa411VG8ru/vz6v9+s5z5nvc57PkXfytDnLxcHB0czNwfH/
b9J1p1XkM093lcecTLhmpLeL2kqwOkq4AhZd+i5Lv0RhhVYWTCDcg8NS1X/i
rFRg/YOCXP6OB7CG1//mvptbIKk8Uo6X8ASW7tyKTb2AQJo+E7XinAzb59zv
m9TtgR/rn/37+z0V1rh/a47oPAhKL/j0FpcyQKb6PZd8vh2c3+l34Y9cFhy7
czBA964jfGjrT2eZ5AB32DcOrcCzsOhu1cNwfgt+lAFbLgN3SOHsuffH7B3w
FjKGt/V4genXGOXf399Dc+if3+UBvjAab17Bcs0DceU7T0nelyHizLLD7FI+
+B41Q5usQGhdcnk0I1cET7iOkZprguBSjaz29LtimBFTSqnbdBskH7bV/zIp
hZvdgREGAaHgpIbcE84UEC7Rv3XaOQK4lgIaWYHl4PCmjdK4HAVt/bYyLLMK
iPnW98HiezRczhEoYn6vhN263Ubnch+CxQP6KmZKFdh/4fDiIseC9OWKwwxX
KoR1TBTElsVBuYn/zPRSNbQe356DC09gdfeAyi+5Wjj0fppw9XwKdJR/8psc
rYXVCrBL//BzyH4RXzXxrg7U9v+qzjZOBWsf6//GTb6AVtvqdNyaDnF8xXEj
zo1wj/ehuJ9bJggnfuZifG+BzqOJcYEFubC0viDLy7AVavfMSN3Z9w6GbqUd
mElphZDnpLNZ9HdQ4Hz92bRrGyT3ybdckPsA9rpbtk8tfYMPtr5TYTn58Lwu
2XtCrhN+N6q/619dAqz4fLW+iE7YvqmOrl5ZArud6wdbFjpBmvDv0ZtrpTDJ
/ce2uLULXvFnd/38+wkMdlpvvxfaAyKz/iLLkeXQ9PYvl8p0H6yWPp3cU1QF
N+pIFuT/BkH9mjyR16sO3ry9131ecxw2hqgpPhVqg3Hh8QiLU+PwkbzF9bJp
G6hcstil+mgcHrlnB3L4t0GKocDzwYVxGMk6WK3T3QYPaiPO2VdPQPXEv0rL
tG9wafA+w9zhF2SuFxq13PEdkgXqg4XMZqDgD2ztd+qCXTuvOtw8OQPvGjzt
tB91QY+H+tZp/xm4kWObw1vdBRIt4fQv2TMgwtN7wkm5G2LirfbeFWRAtYOk
Hc9wNwQrN6xf6WZAxulBceLpH+AMzU8mfWZh66ccx7JN/cCR+ru4O3wWei+q
Mila/RDPI91Tlz4LdtceRFaY9cPn2nOyWe2z0MazJSbZux9UD/9NPbudBR8s
+d2saP0w6qKS08s5ByEiEv3fT/8EtwfXypqif0OW/FA4X+wAcM2l9lGyfsPB
Ve1Cl14MQMLRzxxvK3+DljC/Fv3jANRJi5hEsn7Djp+HL/d2DYD6y8yavXZ/
oJm5Iy2BMAiTJa1NlXLz0JacnnHjxSCEyC4w3hnMQ5DGHamUgkGQviUr8vzg
POx6WUN8ThsEq92utjeC5yE5IPvBafogvG7617ljZB7eOTREkpWHwGN482De
mwUw3L+tQOjZEPSf7FxTUbsAb/+zqg58PQSHOu5qfh1agOaayS33SofAoH7k
yrDkImzZVLgY0jkE3O8yBMVDF8FaOHplfMMwXFKz1VNIXQQWLWVaRGYYRtN4
HDQ/LQLH3U1x0mrD0BB3+uXu2UWI0ndZ3WkyDPGB8rv8/1uC7q3zC7KXhoH/
d9Pp4IAlIGXJTTgGDcM1z5v37scuQUh8YZV31DA4OfW1vaxfgrNJ98LTMoaB
tCfJvUP/L4xu6R7Y3zQMFSKbnmwTXIZr6YLFR+XpsCXyc5mZ+jIc06KsWKrT
4cWqy0MHdy+DiM1ylMJWOkQstGu5BS5Du3il+r49dPjnc8f20uNlGBb+SPY8
SAfvya1Xg96zzw9fWUOyp8ORvke0hNFl2M1vzOftRofPdqaTL7j/wb0dm7s5
fOiwo2VW6IPsP2AkhSbsvEIHQrXNifrD/6DNPWCzbSgdxrMFWUvl/8D6kETJ
QCodHJTKN63p+QeTPAbLUVl0aEzyBNE//2D+vL/42lw65EU3hJE0VoDT9udT
z1I63LgUIX/iyQpI9G7vWG6hA3N6h7lr3gqUlsm/MOugwxnXifN+jStgd8NS
+cIPOihrKvfQuDgwYKQCT4zQoXf875SVIAfeufssV2OSDvEv2zhbZThwx/Ha
+yMzdOCXD1HpM+DA7d0HPnIusuMzjNG6bsaBBiP9yPePDnfsnunL2HDgDdGK
xX7OETD1fQWlJzlQ48WKjivvCHBFF5ofd+fAJ2FJ4bfXjED5q+r9i/7s+ztN
iskCI3C9puXokxAO3CaeEHJh3QgYDvb9ZxDDgd3XEjMNN4zA4r9J5+9JHNjz
wevlC8ERKJRc9LyUzYF2zRb3PgmNwCW91ZfFPnKg2Wop4gfhEWBekL97qIkD
MfHvkKfoCOTe04xm9nCgD8eXtUZiI+CRsSM+ZowDEwza6vjFR4BUsSdF+zcH
anW1Ha5j44ke28xGLk7snSgpc9s4AtnzTrkeGzixrpFV1cHGLqJeheukOZGH
Ojm/QWIEiNrXynNUOXHlbRp5HRsPWYZ9ttzKia/+dDg3sOVTnR83jRtx4lLn
VIENGzsGp3fcs+bEJ7veZyaw7ckmv+tXPc6JlieF1bPY/vUUl43WOHOiySWi
/U22/wnt9TPnfDlxy8rWHgWREbBjdszz3uJEq5USrkfs+MXX0zkyIjkx8dqx
xu/sfLVtnl1jmsCJn56oM5jsfD4w4xAafMGJYSJx47PsfB84tW5T0AdOfGh/
6iadbwS+xKtsLv/CiVlnuywy2fUKy9tC/q+TEwXbGPL+3COwp8lo279hTtx4
4PqCHru+qyatjZKYnBhMUpX4ya4/dbXDXsMVdnzb/3t75i8dghRdD3YLcKGF
bOhgyQIdEC4dC5DgwhzrH90Dv+lQeinatZDMhSkvRsIesfkV8CDJ++guLoxd
Xbpa6hcdDN5kX/ltwYVnbN1FncfYfB+m3ttyhgs3PdHKs/xJBx/OlphWLy48
Of9ow0gPHbRl+p74XOPCuI2iC5Zsvr8+vJCVG8eFhbH+w7cb6HDea9X7/Wlc
2BwQJepbSwe1CJHiqbdc2EgqEbamsvu/SqOOVMuFm91VFb4W0eGZjtN45hIX
+ojv1q9LY/ejtSfTfA03rl0jSppNooOkW+AiXZQbn9jHFzEf0yHueRy/siY3
7jO1WvYMp0OUYL3ac0duLD46a2riRYcifZl8aw9urLK84+PqQoehk57w9yo3
miQc8/3PkT0fXoscPvqYG32HW7b37qfD6F6Ha+sauPG1gXbKigYdRL3frC7p
5sbl3NB11sp0gHiOBy5j3Pg+5dMad2m2fXr6iyoeHuQoGtQY56ODSfCvxis7
eLDuQoLpxZ/D4JEN9ip7eTAxSkvnVvswJDTHDLUd4UFvXl/9bfXDMCOnt6Dl
w4PxMr92UD4Mw7PS6wr0TB6cc7KZ+86et/NzG/xsxHkxyfDSi4Oyw6Ao47Sy
osiLYyE9zkJCw2BtmnfvNZkXS0/vN4niHoaMB3bP1uzjRflRwpaskSGw0Xpe
UxbMix/rDK8Y5wzBaxcdSXUGLxpLrLr7efMQOHUfpnB/WYVpMVu1msQGgf/p
zwvenauw9Iu36RqeQXhv7yHdR1+FAclCyweZA8DdFXqlmHM1hqsd9xNpHID0
jmJdb/3VuL7s2JOC0AGgfyNk9qauxn9rtsbRJtnvbdNkdNGVNTgcb2R1ML0f
hKOvgEroGpR8IcQ/HdUPxftXTT16tAbTl3zfHLvSDwKNcpZeb9dg35WxzFv7
+iHnqw2vyvAavBv6Pbh6qA+m6gqvPDrAh/skHq7puNgL3tUhTp4q/Pi9F6fI
vt0gO7R71W9dfozVeWpB3N0N9Vx82YHIj8/iU9cSJbpBGSMZ947xI+5p2hNb
0gWdxbE308P58fzqCIEzK51glPviWec0Pyp0fW0xDu0Aoaefu0wKBdBG9lug
Xeg3eOe19pDE3nXoud19De+vBviSIHLl9ZF1aCS3eicENwCdKplsfGYdVr+V
KhmVaADJTZsnzt9YhxnKOytdTb5CSIVZcEX+OtzYtybZ7Fk9HBG+8cFNYT3q
j7/TF/nvMyx+YIh8WlqP8fMTFspdFSDaO7/Nhm8D7lku8bP1rQDNNRyOI+Ib
cIGlv95gQwWcdlifI6SzAVNvRAk1mZfDFx5103MuG3BUy//pzeBP8Mz2jO+G
bxtQw2Q1JcrmIzy/6j6ufVQQC3LINi83vgTtcr750BOC+EFn9sc1agaU82Ty
9p0WxJP7603cvNKhP3KIEOkliP+9I11qrH4Osiknjo7dE0SRDb3K6xbiIYG6
n/q8VBA7VAwXOrX84MG6Lc+EFYTQ8rrk4jOvFIqCTcsrV1UhvK74fHl11HPK
uzivonJNIfy6uO9IystUSpPc6zaPHUI4o3k2W7ApnbJehyhQf5h9Hp2R3sed
RQk7InE5OFQIywZtvpfk5FKCkv8eZE0K4WKQz72BHYWUA9qF3uqzQnhna6vo
o7xCimzFxRinBSHMjxW8vKBeRCkeGG9q4hXG5sxnpAyxYgpTuXP/a1lhXGsf
7hvWWEJxysnfd+6AMFqIlN/JGymjaO/0vpB0RBiNKvM6GLsplH9fSZFtDsIo
eLf+z98MCiVhOu2LsaswUq6WceSQyyktOg8s5YKEsduS9ENkvJxiVOSxt+OD
MHZ5VJUqGFdS1luouW4oFsZ7nkEDLW6VlJ6u4bu7y4XRvoY+1/agknL5r8Pn
vC/CyLXwOD60v5KyO1JidKJFGFetuLJbtIoiKtu2WrFTGGVVnlV/VKui5IKl
ecywMCab6zJrvKoo15tWOX+eEEadQxbtlJgqitWpyjsrDGH8VuryUP9dFWU0
aBvtwj/2uYZows+JKgqBpmJmsVEECzmlty/aUilTRwbP3JIRQcPBnsFrXlRK
6cizkEJFEXT55rf1UDiVYscnTiVqiyCnOrXqUwWVQkxoHjyhJ4LdnIyC3z1U
CkstkjvWUARH/CsFD/6hUqKteEy494pgSPCiVZRqNeXkD4rT9v0iuIFnattu
qKaQPK4GeduK4JUz18VzD1dTPt9nVvSdEsH2Y1Nz/VerKXGENz/FXUSQyrUo
IhdVTTnzzpXT2kMEDQQOmDxPrqZwtPZjaYAIms9/I5WVV1NCxsqeB9wSQaPA
Ae2G5moKH0cS17a7IvhJty39xEA1RVjjGDU/VgQXI0Z3fOKiUR6b6Cv7Jorg
b+NXg8nCNIq0vdgdnTQRfGoTLGWuQKMohzabv80VQcuaoIn7SKNkJ73NvPBR
BFvvGYi+s6ZRNPMi+UhlIuiwU+BH53Ea5UOdu9s4VQRljQ0H55xpFIOfe+sz
60XwVXJqzW8fGqX0jwrJuUUE1Ub3sloDaRSj9asilTtFsOvE3pG7t2kUmtLQ
r8E+ETzjK7iNN5JGsdhRaZ1KF0FXwc6D1g9plIaDKW8df4mg9thk4pV4GuWQ
y3VBORbbXlBuYUYijdJx3cH7x6IIVoimGi4m0ygOsdtbnnKK4mVbqTs5qTRK
/ysJXfs1ovjnZ2eOVwaNcrby90OJDaIoln3KIDWTRhnvaGO1i4liVPUR1oEc
GsVj+r1trLQoFviZ0fxzaRQmb0zBIUVRbJhXTljOo1H8pT03CquJ4qpKB78P
RTTKX519l5u0RbFi9dDQ+Cca5eZe9c4ofVG8cSiyRL2CRuF15Nu+b5coRhDT
zXZX0Shhl0YSBMxEUVaQO1WUSqOsj6xeqrUUxUOan4MD2OcP09Ic7tqIYmay
z/sz7PsSxbc+7T4minPOOSItbP2JTf/J8jqKolTHdFJ1IY0iP7LzRtU5UZzv
1q40ek+jvFiW6r91QRRXjMwKrLNpFDXRRURfUSTlWHouptAob9U6nv8LYMeX
e97KLo5G2WJUwPXplijuu3LM+WEYjVJ49NHpq3dF8bc9F8f3azSKoYcPddt9
UXyjoK9m6EWjVIQcUJ6PFcX2LWIHu0/RKHXv1o74pomy+6GtR9mERukRuO3m
USaKJcRbvcBJozgqnK4nVYsizzWOzzoz1ZRhAyPSRL0o+lwNpw/3VlOmzi7/
cu4URc69/9z2lVRTLgZ2WxP7RfHRnTC19sxqyvyDordDdFHUPvdToy62msJZ
7ud9iiWKGX2LJ7wvVFPutB9qkVsSRWk5zmPvj1ZT+H+RdXs5xbDA9E/1Maym
iEpOsew3iKF4lZ7Ko7XVlHjtL7abxMVww+FV7eozVIqMeXbBd2kx9v9v7net
FnZ/+567fFhNDI/fyUx4+YBK0djedyhZWwx14qI8GReplC0cdlrjemIoyGPP
VXyYSjGO2Eu/YSKGxLCu4u1iVMrJdNLhVw5iWHNe5vBobBXlrFuG1m8nMWww
pmpGXKqinNeWFTByFUPrybxd+45WUQJKN1S2+7Hxy6FjURJVlLg2phbXfTG8
6H3yVBR7PiYluAvsixVDBd+L8lEelZR0xyH646diuPulUaX73krK+8lvSRqZ
Ymji9U/l9VIFpYGnSOBYhRhmPjzNp2BTQflWRx5Jq2HHez4tckKpgtITnV05
9VUMleJnxnJ+l1PGpROvhHSJ4aMTkTz7H5dTeLfeGHk7K4bfPx8fUXxGoaxd
+lO5uCCGbysjDC30KRThCq9nZhziyMGXurGosYxC2Odk271WHOVPWmYM/vtE
MTxrVrWKKI7POFpPeBwrpfjGCiSfsBNHw/P3D5jOFlKuHg8JyDwpjo4OPla7
bhRSguSXbWfPiCOVyhVzmq+QEv16au09b3F0MeIU85f8SMmpbg7ICxNnzyfq
OXe9fMrQ3OMjAp/EcWu8yvt2zneUVCPdiz+qxDF5/Wwo+XQu5b/Ihvtv68Tx
QPiW2x2hbyldSry1hzrE8eaAGtjwvaY0H/LZkTgrjmukWY22qzMpZe+sCBpq
G7FPM0t/te9TyuMLnOPWjzeigsDzg7PkGDhclLhK/tlGTPh470Se/iMQ5jVQ
nE3fiJyOFsrX9j6GqEQPh8fvN6J0fsPO7RFJEFLf3dD3dSMK8A7p3JbLAK/N
BR+8eCRwMpS2aLKYCxbDbtceeEvgbF+7DOt8Gey+pphjelkCtTNpLDkzChiL
9XT9vi6BQxAveXNDOWw322dwPEIC7TU8ktSnykEtQ2tW8aUEhudrXMkrqwSB
syyX/B4JDGwSXExyo8GXoWuHO8w3IQUzPvIsfgXroWh1WVlJtHjH031j3XcY
r3K6+fm1FDp2/pYM2TEIcjEdblF5Uhh1OYN6y2EQDp+0tj1cIoU1UQ1vP10b
hLL5bWr9n6Xwzb5Twf/KB+GBhlDbn0EptP9gFFazZwh2PKaoqEhKI2+Gn/U1
y2GIcJNuvH1HGqk8Ka3rrUagQv9BkWWkNEqdD7924PwI/OZZky70SBo1jnp6
h0aw99Hk2ctJz6VR7zqvUuWXEdjSVqeQXyqNPrEqjvetRuHHziuXhpjSqG7f
IptvNAaaQu0yJv/JoExOjGzR+gmgR9KDYs/K4FBzXq3U5glI4v8zMuIugw3r
qiwPmUzAWh6J9xGXZXBx9lrwTv8JGP99bHd7jAz+2OD6ReTHBGT0/PBwpcpg
fLnxWv/0SZDOHKbc3yyLtUdW60TLTkGb0m+lAS1Z/NSi8Wt86xSEP18VtkVP
Fp0127j19k3BYoLK4U5jWRSZLktyvjoFHZGuowoOslgowV261DoFDy/+EiyI
ksVge6GrU5engR/mTvXMymIXB0vB9OgMXDZSXVOwKIsmd+14Tp2aAbrJ8Tf3
OeXwmJ5y0k33GajcU7FovEEO949y+L29MQMBNpEPs9TkUCh7Rt37xQxMnFWu
vnRKDs1Olda0T86AvYud+wEXOfxR2iooOTcDn93ChdQ85XD3TsrZXcszkO7J
OPEjUA7rGEUDWusY4HDl02+TeDnUE3hb/k+dAV8ibFWFGuVQLedz0JQzA7bf
v9sw/k0O3wof+OTiyYDMmBJfao8cnj1D5fpxiQEhcfIV/uNymCOwnJhymwHM
+MPOBxlyGCvben04ggGOT0PXqc/L4brQA8vrHzFAtuk3aZqLgKlDo8Tx5wyw
PSjI4bCKgOJzRV2+mQyIaNnc+pmPgAazXrUf3jBgsc3hSqogATvtWdxHixnQ
3llZbStLwAX1HX3vGhmw7nhPfKU8AXXTt86v+8YA0545dy1lAkqfXvK81MWA
972qwnwkAr4L8xpyGGZA1GDUydJtBKzx2nnFZpEB1WcyyZt3EvDv/W/n9qww
4O9wBU8csv3r0T4lzcMEt1FWtqc5AQVaQ68fXccE81/2fxRsCZjO+2KMW5YJ
z0SDW2/YEdBUoFa+XJ4JrB2v3vYcJ6AEQ1bGXpkJKWFLznFOBExJmopVIzHh
9ztF09mzbPuv1IactJiwr9OScMCVgC4lRWev6zBhUSWxg8+LgHsejlS6GjDh
wH5q3rmLBDTcduPSth1MeHFpMrrqEgFrAw6XTu1kwt8k0QuEAAL2u4ysuYtM
OFRtuPfaNQJynFe9tmLMhOzJM8pdNwn4WTnzl4UZEzhEIzn1QwjYIV3X7mrO
hBynH0UzYQSMPdyToGrJBK4w3rh9UQQ8YLTDpNGKCXbvNHyyYwgYdNj+tr01
E3g5rqudiSfgtv9s548cZMLJJNmn3zMI+OqonJ/pUSbkUXf7b8kiICfrhFOV
HRP4Jz0OxeQQsHAmKtbIngmOIo+1pt4SUO/YxSslx5nwcTtFwPIDAXN+FNmS
TjBhvdPIyMsCAjKk2s5EnWTCmXsbqDzFBPR0a+Tq+I8Jxbn6Kac+EfCCbGYp
05EJgh3/BZaVE9AxOvNn+ykmnFsJtZOiElDj59TlW05MKCXmbrlcQ8CDgnUL
DDYWtu4Q/FZHQNHQjf6bTzPB1Y/jF7mBbb83eYMGG5cnqtZGNRMwOWaxZgMb
i1MPZEy0sf3P/0zrYN8/P3H51p4OAr64Ovg4jI0rhZ+fyOgm4BnFvBdENpbY
XruNq4/Nv8Y5nddsfzxOMcT+GyDgtLtnjDQbU+9uYpYME5Bn7tAbF7b/UrlG
DRJj7PoIB0RFsuPz+e6a7TdJwLarFzgi2PF//hdzp2WagH7ezmLn2PmRJRY7
ac0S8OEtGRU5Byb47hvYFfGbgF9kYh1L2fmt8+WXGlsgYJF/7fWDx5hASNT5
Y7ZMwOel66NG2fX5Oh70doVbHkN/1Bwn2DJBSfhVuMNqebywwzj/0yEmBGxr
dS7il8f3lWUbj9gwoclxyUR8vTyeU3d933aACcS7ioSLQvJ4WNT0svp+JgS+
tfzbKCqPsnK9AUf2MaGl/WIHSUIeX67ue3iIzacbytRouixb/px/ZtVuJrRb
TZ43UZBHf3KRvJEpE0i+ontTlOVxaC6OmWrEhI7KM5z2JHmkhpzllTZkwoxR
l+Q1LXlcc6jji8s2Jqyu2L8lRUce3w3v6kzVY4IeZbsz3UAeuc82R3VpM+FR
ieBXHzN5bD9a+chWic3v7XfosXvkERWEO1ex+7OqaGml0FIej2bJN2TLMIH5
ka6zclAejxtX7mwWZ8L+vNL48JPyuLkL61LXsPmkq/P+zSl5HMy427bIngfX
37+sbz4jjwtP76SZcbL15z74t9FdHvkGzFdyFxjA/9rlTLq/PH5oyOWmjTGA
liGq/Smard/0v9kTNAb0KoXt7X8oj0tLtn4pFQyYS1tx4n4sj7kPzzY3lTJA
KXU8dm+SPLr2Kf5mvWdA0LPypW9Z8tiQ19cq8YwBCTJ6Ygs58uhX8NE8I54B
7xJfaUrnyiPPVZ0A6YcM6E+IO+VUII8bzYQmu0MZsOvx+ZqpSnlMM89599KL
AUfEB/qFaPJ4ynLd6Vw3BlyIPbq4pVYeE8WU1qSfYUDiQ2ONq43yePbZdW8z
O/b8vS/xcHWPPEpuERzR3cWA/LvUk4Q5eXzl5lR9gJv9HljUS4TOy+Pr12bk
7sUZSFjb0vJrSR4LRg842TJn4GZ03+4SLgW076N3yv+cAav4Rc0jggrY1bb5
kXHZDAy81F4JV1fAnV4MxRW/GVhfk5j855QCth0+6PQzfxo476UdO3lWAaV0
Zi8OPp8GlkW2SLWLAh4f1Ukri5yGzoaPoQ88FTAlkWFHOzMN6e0tnhrXFDBr
uTo3csM0bKevwdPxCkio3S756+gUnOP1629oUMC9TPm5F4OTIClX+32pWQHh
qmzC2JdJaDCQaVT9poDussTedQWToHe++lNQtwLKyF7UXQ6dhFWtYk/1RhVw
2/cRioPaJGSkFNg+41REP39HSQXXCRjaMV93YYsitoyHfH30fQxO+1zNX5ug
iBtTLAa70+ig5azeYHVKCVtm5H5eM+yHXlc5z9dnlPByI774Kd8PEedFBNe7
KGH4i9szu1b3w5j30sFGDyU0eCdH1Uzrg7TA+m8HA5XwwFBr7vG6Xtj4wP3H
kcdKuNW8x1Jf6weslL6adPyqhJJ3VO/oc3TBG0pyZEWTEnpV9YRkNnWCQ+VD
TYU2JfTuaO8dSemEopqrXoNdStio+urOPeyEiy2WrLOjbPud3dNVgR0wMjKx
5MatjG/kbP6KcnyHRmGSgN82ZXTUzjQLMGmDXRcujD01VEYK12gMt0wbvKl5
U1MJyugW2Zyg8KcVogLJIYK7lfFqb8LwZE4rWNH1ll/ZKOMtMUcP6qZWqCsy
mh5wV0Z/yY3rN7GaYbto8Fc+T2VM7nK60NrcDNke1FfaPsq45+hLlnxuM9xT
NHe5flkZf2j4imddaIY9kVY/N91WRs8nrIln401Q7Xi09cAz9v0n2/N31zbC
lpL4d/7P2f5su8Ibcq8R0sW67j9LV8bbozdlGi0aIaTOwWoyWxkX/j1trmxq
AOMtTtWhH5VRyE9K/tLYVyhffeFjWZMy2qfdDDXa8gW0nd7EDrcqo80TJd/F
v/WQUjp9ce13ZZwj1Yzdq66HG94+2vY/lHHzxYdnrh+th13d/llzY8oo+Vfa
kx5cB2+2FoVK/1LGmcidG1wP1oFM9OJZkxm2P2KvnygQ6uCv6TWFmN/KqDbE
F36xohZK3gQ9JXETUUTc4Fu8SC2ssrKVfLyKiG1t7oK1I5/h4JjKE05+IkKt
fIHGp88wovg1rl2QiD9cxy4w3T6DyJOND27KEnE2jXptc10NnNQbF5yQJ+KW
atnz0yk1kNVaet9WmYhV3r0x6F8D7Ac4Uo3EljfP1D+hWAPuwTl327YR0Wgq
aa91CA0KCDdWw04ixvsv6F36jwacZQfvZCER9YTJ9ZsNafB4/nfwdXMi+sTr
FPUsVsNAbC3XmAURXThcrap7qkFDN/HWIWu2/ls6rvrl1VB1weiGqi0Rt5+I
+Ho6rBrWC4j+e2BHxFUnpwqSPavhWCY9cPk4ERPioiJiD1fD9EB4QIsTET1a
jYaqZKph+82TC4bniFhRc1jFnKsabsuQL790JaJMWd5I8ggVpOza/QK9iOx9
sDgz7yMVzs1lsugXiRjsa3gqM5UK7x5cvXjQn4iyxDen796nwl8ta2ZJABFj
Jz336F6ngvlXgjfxOhEPUYNubPCgwgO32enoW0Tknlqz3eskFX6spnkshRDx
zOb6G5v3U+Gisfv5pnAiWjfdO7yVTIWyvp0T2++z/VlfU3JBgQp81wTdMh4Q
Ua33oeagCBWSP+Y7BzwhIvN9oMbq+SoYP3yXPpRIxHodS+ev41WwlWl/dn8K
Eefo+9Rle6ugnsRxWuklEd0fVb3KolWBeF3Lz6hsIl6NE9gkVVoFp5wzHBde
E3Hzj/X97u+rIIfnct/pd0Tk3y1wJDOrCv48tzjZkEfEEMNbv7qeV4ExyPww
KCTi3YIftmufVkFkz/TxtBI2PuwQaxNbBR1XKrvWUYh4bfmrTUV0FShujD12
uZKIgVfJT2wiq8Ajz7ljoJqIL5f/3FoIq4Kig9uP7qsl4jFTtfDUe1XAM722
/eMXIha1h/rpsPH+iL7DCk1EfNW4Q92ajRM2v2+NaGXnw6J6fQIbD9NCbP60
E7E3ku8PP1uf9pmjzae6iFjnUbE6nY2vcqod+PKDiLblR3kuhVcB3VSgg/iT
iNO92sfjI6rgwN3J/24Nsfkj8TH0alQVFNd/HekeIeLtv4dtYmOqQGnDW0+9
CSK6doVkLLPji7KJ/hM9RcTVCp1S5ez452O9b0wwiFjJnPPsSa0Cp06b1bvn
iKguJbHe/FUVfJHecj9lnojzOvn8dXlVoOcotnFpiYhpPmqrxChVkJL2+5nt
ChFPp1bvFqyrAj+1ojf8q1RwWUFfsv5nFcga7GrwFVHBZv6IbHNxKty9Knek
UVwFk/V4Y4hKVGCWcfRullTBF8J3T3noUMGBa+BsiIwKmv/KXd5lRIUas6pf
vQQV3BVod5N+gAo699L9timp4LW6nxmCTlRI/HJ7+aGKCs538qf88KWC16E9
6/ZqqiDrY5GkYTIVuuI2x6aRVbDhavSrBwVUMO3il/m3RQWPexXzjzdQYdOp
r6QPO1Rw/7vYFYMVKlR62FjJ7FXB7ishQqIO1UB6r9vmb6WCpYMexnMXqyFu
TtShZb8KrvG7c1I4shrcA7+7hx5RQdX9S0u3q6qhnVI4+/OYCsaeTJv5218N
yJ1w1fCECl6pitrya6UaRMMcwhmnVVBp+q2+uhENrn/dKWLlrILX54r5LU7T
YFRQ7ukLNxW8WbCQbX+HBp8e/8w+7q2Co31HrXQbaXAu41xd9XUVrInO42C4
10DTqLkNIUgFDWjEMPPYGthO2twVcFsFk2ZXbz5JqYENHybGtCJUUOaIT7Ch
2GcoLPfiS3iighqBv2KEaJ+Bvydgj0eeCuZd6T7CtbMO9Pyz1t3/qIKz9e9l
As7XwSnhjpa3xSrokB1yXTipDgr3bD3BKFfB4rL9B05y1sO5/Glv368qqD7m
zgxqrIeKqDNPA+gqyJQSIJSd/wqTmx86Ph1TwZ8vd92bf/4VJKorlEsn2fJy
8V+bv38FjyXZ3GWmCiZGuPnXmjWAtEsn9eYKO57piMATpEa4bGQ9dUdCFdGo
1eZYbBOk9wR+eCmliqJJO+6nFjRBo/+ry59lVXGLsn3F6PcmIL5Zw82vrIrU
QJA4L9kMrZJVGyPJqvjdKa7s0vNm0GTpGz20UMW7EmkbuagtMPxC/lFyoCoO
r3t+oVD3G0yG/FzgvqmKQZXOQl9PfgOm0/P/XIJV8VC7MPaGfQMOOXl1cpgq
EufmX0vQv4HkY0Jl5WNVJGkHKN9Ob4cDoXIzw+9VUSgmtm63YgeUOstYkcZU
MSv2NVnVqRseqW7iKbLdjHUJX8avKP2E6IRzNacIahhqNCh2T2kU/C8FXQxU
VMP3pXaFqTgKJ22eyT0mquFSMnOw3GEUSPzt/l9IajjGGyEoGjsKtVfMVPW3
qaHQTtP1e1aNAdcxpXtrbdSwpGj+Rc/gGPhtHLD4GKyGe8YO/2E9nQD7Ryca
1o6oofHk1YtN9CmQ/sAv5T6uhk0Cf9fNck1DX/NH59pfath4fcMvRblpOLNB
mPMOSw2/8lgxwo9Og0cYTXeFUx2tMjgNtWnTEHRT6wlDWh2/8HSWV+ybgazz
nGfabdSRZBOsxruJAefD3+RuOaKOF/W5nQuVGKCZfXz5wTF1PPEpQ2aPNgPe
j+TH7XdUR5NqHxMNcwaUOrnVfr6gjjvNPR5e82NAk12rZslddew4cJVJa2DA
vGnGQnKZOvrFNmaRL7P3sZLkYGqFOu6yr73qfYu97+skrBujqqOUXnpCahh7
f5K7L69Tr47XwkGTkcjebxcu76V+V8fo3OgvxhVM0H1t9WR0Rh21kyb7N6+a
hQJFc8V1LHU8wKRV7l0/C9sTjF6T/6jjvhd98fvEZ8E4VK8iYFkd/2QmnuUm
zsKBU4Sxtfwk9F9R22ZqOgseYiwDsiIJ84901KhdnwVm+FSlLZGEutY77Bxv
z4If15hVwGYS7nRLn4qKmIXA6R+OVVokPKZHvvUgYRbCa2vu2hqSUO2PWGt1
3ixkXnvaccWWhNda3ujl0GeBxIp1emZHwsM5+szqyVnIdYuerDxOwntOXSmV
zFn4ePQ2x1onElLSh5gO/2aBRvZUfeZBwubKrE8aoiywyHR9X+lNwmWv/REu
m1jwVfaM4YgvCesGKyrCZVnQJnDsgPZVEk753f4bpMqCwWHjy5WhJAwR4bl6
fjsLjJMbUtXCSWjb2jFN3cWCFDv7rw+iSKiv09g1ZcyCk/XeCqdjSRgX5M6/
2pIFXbkpX7jTSLh7sCjp8nEWbHMj/XF/QcJil9Uz8f+xIF6xUL4ti4RFs/z1
iadZcCSu8VJ6LgkJ4glLO91Z0HL1H8GsjIQ8u1svjl5mAXlrmOXrChLe4ccg
6UAWRE+JXRKrJuHsRtdZuMEC61Ma9cP1JOz5nl24/zYLXksWze1rJGEK64PX
lrssWNtmSihoIaHWVs/2uTAW1O128LvTScL7B6SiuaNZsJljNHmqh4Sh3hvc
rR6w4G7Rxboj/SR8dO1SotsjFoz4rLDKBkl4zvZE3Yk4FuwmhcupjJDwVM5G
pnI8CzKGxS3uj5Nw5PPx5aonLOBJTvX984uED0uYvtuesuC0nWbyfwwSqtcH
e99NZEGlUHFtDYuETxcmkz8ksUC+3oylNU9Cpb3zL8qeseBmSLNs/BIJe+//
4XqTzIK+nSf2cqyQ8OrVZObtFBbs+jN60YVLA6XmnHwtnrMgKdf3WROvBq58
5GausPFfV45aAz4NPNKXzfcqlQXFPRtl+QQ18KfwZXGBdBZsikvb4y2igaXd
a5Kb2fjyfq2LneIaWC0TFPUygwXf15QkGUlqoJJVsEHYCxboVe7+nCWjgf1a
9c2+L1kQe7WFKSSvgXsIrZTjmSxgbTkpE6CkgdyberU2Z7Hg0NSY+YCKBjbH
B/d8Y+P3L/18LNQ1MFBp1SeHbBYIneJMeq+pgVfPeZsUs7GXZGSNpI4GBhzz
Kptg48ZWCWbQVg2kF2ZHzrCxZmS69ISBBm6uTfpVy8aRu7XNDxlqII8ur9Nl
Np5cKfEuAQ2UZzYQltn2LIvMExVNNFAxjbbWno2zfVpp4bs1cOHP1XcxbH/5
SP8xZvdq4H5rplwWOx6X4XEph30aKEDPuJ7Fjpdox+VNOqyBOQ5PxrzY+bkt
FPX00VENjDYVyt6RxoKhuk20v/YaqBy+XusPO9+pO8lSX0+x87nz9kZk16vS
mj946YwGbuBoEh9m13fgv8HxzS4auM9z9c8Adv0Vg2KL73hooEeo0QFfNl9M
H3oo5HtrYN3seo5vj1lwJt08bNBXA0kxP0kENt/SaQvH8Crbfkzw3gtsflK/
t1R4XNdAmVXY4cbm79Doq81JtzQQbumP7I1i828xJKY+RAOtNAMnVkewQEng
5MJCqAYyWNQTyffY9qT1T6mGa6BPyM56vlC2PQ3B2iNRGmicEvnTLITN5/2V
8R8eaeD9cw2rdK6zgOb4lGPgsQZ+GVCtHgxgAd3b10XwqQb6nb3+yc2fna9H
RIMLzzVwcOOTL6u8WPCiI+w78Y0GborRMxll9ztt7DTYvtPAZz8mfpax5wF9
0fBlcJ4Gpl3w3fr8KAtUZKYv9Rdr4LDV/PPw/SzIPHVIPKFGAy1LWS3HgQWf
fUjXP9dp4HNjOTcGex6NBvPSf3/VQAPt8bX79Fig+uJj/qE2Nr9O8zKPkliQ
NS5lu+6nBo4KTBrVi7Prf3Ho4c1FDSx8FZgtMDELdSGflt4sa2DD9v+cLg7P
wnhs3OkfHJq4tJTN/7VvFtQL9+huX62Jcv1n9hi3zULO35yWWRFN9L/vHc9X
Oguvb/sJOWtoYnTvxofvQ2dh0vBE0G1tTfxisLNu7ub/57XpbJquJu778HmH
csAsZDuJfuvfpolTQhv0zM+z5zt8iLffrYkTnyyP3N4/C+kLM3LW/2libZyU
pJPQLAzldkSfd9LE2466Psp8s6DoUs4ZflYT1ddYTddzzEJq+/3BGndNjLzt
HvxhmgnJHzRfGl3WxNDJzUPf65mQcOG85tYYTeS+H9V+IIgJXUqHkw890kR7
/pMqG64wYVPPDkGfx5oo35ZUmO3JhHgLAeabJE2Uqh945eXAhFiV7HzVbE0k
/OdtfHoLE6J/jhhKV2niOtMvBLkBBoTanrbkntPEx6ZZw8F6DEjd3+Nwdl4T
P4zqxXOpsd/zvbYeNUuauGPVeytvGQYwd5rHhHNp4b903yAVHgY4ENW/iwhq
YZyV3CGB5hnQ+cN0UlLXwhThDf58rjPQGx8UYHZKCx8sUbeVKU7D1p7nWaFf
tdD8e8oF7jsTEL/56euvltr4JGcuzFl9CFizuzOC92njtqVCvX8CQ7C/jJm4
bb82/pQvnH8/OQirDllEZNho44fclo373wyCX+CC27Vj2rh2lvrtldYg2DQe
VdVw1sYtxEgRN80BWOsnmhYRpI0SFMcjJTv6wQXKE4xDtPFXb4XtU5l+qOI7
/2D+tjaeErGbMFjpg4BnVbfO3NPG2N3+nRKhfTBW4+NoGK2N6WkplOFHvUCT
bJaZTNLGqgvfbe3f9sCN8sh4yyJtDOhdhFbhThj/Uf5ooVgbr88zuG26O+DI
0mz0y1JtTKwL8ziY3gEkPft73OXaeCM5tGFGvwM6XhEDSmja+MNdXuXp2e+g
85hyXL1NG5+fs5Lvr/8G9AsMWYFpbSTXajnvS22Bg+FKUkUz2jj+u7vs8MUW
KM08utGZqY1vW0YKyWYt8HDw04aqOW0MOjVywWSiGfBYGMfVv9r473q0foRh
MySYKg6M85Fxx41y3gRKI+yTss2oUyLjfV6Sg83jOogf0iw/TiRjjt2mVs9D
dTD0ek33pAoZkyn9KfmCdRCIpYIb1Mmovq4tenNkLeScVQw8RCZjl2+qT1zQ
Z5jXXI4b0iFj2Nplt5Zdn8F0vv2d3xYyihZV/fq2WAPdYWEjj/XJeOjSFy/X
izXAn8uw6dlJRulBn92JbjQ4cqX+wgUgoybTV6BcjQapxhl3/yEZe9sCFA9M
VsO2b3ZlBFMy3oHrAyPsfc5lkbL5rAUZH+33Pb7/IXvfNI3imDpCRpln7TeC
WJUgvN5F6oYdGVev/ffSjloJJ78b6Qnak5Fy+24rf2wl/Hadc9c5wb4fPO8Y
aVAJxPsO3y+dJmOV+p+BwlsV4GOnx1x9loyHyXukFg9VQJm84Lon58hY9vH8
uA6xAmzzqoxLXNn67xW0FNWVQ0in2psVTzLaaCt8PCdeDk2pPLXR3mSsr/8v
7eg3Ckif7x2Uv0jGoUezFg9uUuDDv5hNppfY9msN/kz2lcGA4kLI3UAy5udc
73/x6RMYedQcF7pHRkb2p6yImyWw2DG2mxpGxuiOX2GRW0sgz2Stjn8EGcU2
LewJnCwG4qaDa37cJ6PlcPzlKMdi6A++OHs/howhRVsmr8gUw5Op2F7jh2RM
DJYYU+opgrXUrrzMODI+luPpbT1ZBDTN5eTj8WQ0nbO+Na5QBDeeyIWvTyDj
TbH7u0ZGC4HpceaUbxIZZQ1NI4cCCiGn846VSjIZrbI0IlebF8JZ0yz9rhQy
npgP+mYrVggdm6bWYToZVw4Z178t/AgPQgQXmBlk3Ds31DIY+REsp3WGMl6y
+ZR4Sjbi7EfgsbdttMsio3XVa/F38BHKqP7FAq/I2Gcml2wn/REuayVklOWQ
MT4j1Pj2UgGQE0qjvd+w83m+T3vbjwIY5+m7qpRLRoOEl3mPKgog3ZPT+fs7
Muod53yYmFkAJ7sUbcI+kHH818bf+g8KYKPZ7p0788nYfLfrssn1Amh666I6
U0DGNRuea0afL4AwyXCRtEIy7kvobRx0KADT26//2RaT0Su89kmjdQEsTzeO
rSkl44WlA3PzRgXgVS1a7kEh47/itUEragWgpq3/Sr6CjBWRlMIThAIYTDgW
11ZJRuXbDkt/xAogkTfwViiVjKWis0cH+AvgiNez89tpZCRpcYym/csHwe7y
o79qyHj0Ok3jKCMfas0GjVNqyTg4QvM2HcyHoFxezUP1ZDz3xudiX1s+GEqp
blr1lYzu21+PfKHlw+/bFjxFDWQUl1S54FWSD29nzk+7N5GxIW1G+3RePrgc
v98l20JGJtGHMvsuHxRo76qbW8lY+HTuozr7vEe7LTfkG9tendXlluJ8iH36
+6n+dzLaWliuda/OB+tVm0LHO8ioM+10Mq85H9Z47/BJ6mLzzdnt4cqPfKjs
PnHiQA8ZL3t0Xegby4eru2/u4e4lo/aXqsCNc/mw5V2qbkEfGQmHXF48XcmH
KalqWdefZJRaCifd5SuAzDsjfNKD7HhmYmfnRArgFINvrmGIjL8lfZ7WyhWA
pAOp/xadjFsv6OkbaBRAG826fssoGfM4je6eNSyAKLJ3wcgYGZV4VD3O7CsA
88SHzxMmyOgTpJCh71gAxd4d/hzTZOTTDFjbdK8ALvYsOn2YIaP5zvAc05QC
IJnLWJ9jsvnqvNVu+GMBJEs7KX2ZI+MIqVdPcaIAtuuqazr9Yc+vzS8fR/J+
hLa9LP35eTL6n/UY3arwEdb437FU+svW1339iIPTR0iN3G9bvMzm36t/r0pv
fwTDdIn/DqyQcVrR7zjh1Ufwas72CeTSwddmj67/WPgI/KMXA4V5dJDW7qu1
Il8I6f8M72Ty6mBN3PcCXwt2f6k3Pmlbo4Nrrw1G2yUWAt6ZLSdt0ME7Frt2
Te4tgq7E0rpKQR3ksE3cJXulCHw/3G6zE9bBN3xPtHSziyCzf+NoiJgORhWT
wiqEi8H4Tz9DcqMOjio+C2ZYFEPPuuylXAkdfPSl/O2f28UgtMNwww8pHTzk
3Vhqz1MCOQd5N12U0UHZqcf3/cxLYLdLgwKfnA6uC9lf1RtRAgGxjnpbFXRw
cc2Sa6FUKQxMh5yIVNXBecmwr1NGnyBwlbWzopoOPh8u6Hwc8QnEZTZ6F6nr
oOd+X82Y75/AwiIrZFhTB6mxVWY0jzJ4n/711c6tbHmPjZImmRSwKonLb9XT
QUZYQ2bXEgXozf9RXA10sNMtvlB5czlIrjBaYnfo4Dj/vpqh4HIIPia++MtI
B0kEl6Vz5hUg69XHHWKig1mEr082BFRA4Z3MdZJmOvhB5kWB8usKmPywXX73
Hh1MPuDZwSdaCYfX/7fnmTVbv46UnHJvJShVvYyzPq6DXmeHFFYFUKGBNJ/e
46CDW0TvKcm/o8LluD0f3E7qoLAGI85sjAr1rmONd07poMoJVdHTDtXgI6jO
R3HWQZm3+9WMLGlAOfHmqpavDuYe1jwzRvoM9vN5joKROviSo95r58kvwOPE
6/ksSgdjLYY5eFO/wJt622ukaB08J5GmqEr/ApzJv5/seaiDqx7R5R29v0Km
mUHrzSfs+3UC2kOxDTD3oMSMkaGD6y//S/K52QTRGpVqLWU6WJX/s7FpvgUy
DY7zBZXrYL7BfWaGUitQTFgj5Eod3H99d+DrA60wdYyYEVOtg2HGslcKs1rB
8k6Y3MEvOuhiXODW7tgGq/psRJs6dXA5O1F67bdvcDV6cPkri61vUqvkE/t/
6NwsT3Otmi7yiZfG/AvsA6d3TMK9+7qY6DgSyPdvGM4HHfprEaOLpi/SPzhK
0MHvUN73tQ/Z8pqDlnM6dLg75xcVHaeLjd86Modc6PBm28LS4yRdPKle62TX
ToeFipX2F690scmnaFH21QhEt6yNpNbo4r2HTr2eFmOQkHbB5U6tLkq+DmSF
OY1Bmm+DyZ56XVzIKMzYETAGBeLRi/UNujgsqPznXeYY9NiLuLR+00XnAyTS
Jt5xUBncZDIwqIuiL7lkw4vGQTsvQDZ9WBeV0oWUEhrHYfvt7oWzI7oY5nHg
3MvhcbBSScodG9fFvAt7QylCE+DjTpBlMNj+Pjy87YjrBAQa3lp4P6uL0Sxt
B84bE3B73UCb75wuBocqPXv4iP1//DYtfH5eF5+GtJ/xokxA6k0e5+JFXdwS
Jf3nU9sEvDp41jjwry5aSHMXzo9NQJ4CTWbXP128n+dcpLgyAWWzxIWVFV10
Gy5PMRadhP8BX18jHg==
        "]]},
      Annotation[#, "Charting`Private`Tag$190392#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20}, {-0.16936716036804686`, 1.2918413315060102`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.910325673957696*^9, 3.9103257158103647`*^9}, 
   3.910325839350417*^9},
 CellLabel->
  "Out[743]=",ExpressionUUID->"78212540-4ce6-436e-996e-55198ec57cc3"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.9103253214465675`*^9},
 CellLabel->
  "In[744]:=",ExpressionUUID->"8c6ab175-6ae8-4447-beed-0ef7582902af"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "t", "]"}], "/.", "sol1"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"vystup", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"y", "[", "t", "]"}], "/.", "solVystRov"}], ")"}], "/.", 
       "sol2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{"pom", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910325748741715*^9, 3.9103258091636896`*^9}, {
  3.9103258563048897`*^9, 3.9103258590126314`*^9}},
 CellLabel->
  "In[748]:=",ExpressionUUID->"53a4bee3-a297-4d3c-bcaa-a7aa0fc8f344"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUV3c4lu8Xt/eW9RppUlQKReicSsNIEpIiaaAQFcmqJCUl+iLJqEiSEkmR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       "]]},
     Annotation[#, "Charting`Private`Tag$191003#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20}, {-0.5965178300376391, 0.6283639352534806}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.910325749356944*^9, 3.910325753376111*^9}, {
  3.910325791589562*^9, 3.910325859388071*^9}},
 CellLabel->
  "Out[748]=",ExpressionUUID->"6a469551-c933-4641-9bc1-ec8ef3c2c6c5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwUWnc81e8Xt/eWdY3QoEIUsuo8EhKVCqWQr4aRFJVCpKhUdrTMJCEqo4zU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       "]]},
     Annotation[#, "Charting`Private`Tag$191056#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20}, {-0.6053415645107693, 0.6365715431459629}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.910325749356944*^9, 3.910325753376111*^9}, {
  3.910325791589562*^9, 3.91032585943494*^9}},
 CellLabel->
  "Out[750]=",ExpressionUUID->"919bf317-5c9b-4554-808f-d465e4b3b18b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"lhs", "==", 
  "rhs"}], "\[IndentingNewLine]", "rceStavObecne"}], "Input",
 CellChangeTimes->{{3.9103259186652822`*^9, 3.910325991142177*^9}},
 CellLabel->
  "In[761]:=",ExpressionUUID->"4bbb5f09-ae2a-4713-bea3-6d0e9d36c2ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"y", "[", "t", "]"}]}], "+", 
   RowBox[{"13", " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{"8", " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"3", " ", 
    RowBox[{"u", "[", "t", "]"}]}], "+", 
   RowBox[{"7", " ", 
    RowBox[{
     SuperscriptBox["u", "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["u", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "t", "]"}]}]}]}]], "Output",
 CellChangeTimes->{{3.9103259888575964`*^9, 3.9103259916438913`*^9}},
 CellLabel->
  "Out[761]=",ExpressionUUID->"35033c19-c7eb-4da2-8cfb-7a687534e27b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"13", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"8", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9103259888575964`*^9, 3.9103259916438913`*^9}},
 CellLabel->
  "Out[762]=",ExpressionUUID->"aaaab201-6fb3-4c54-a764-32cc1e4419e1"]
}, Open  ]]
},
WindowSize->{1436.25, 738.},
WindowMargins->{{Automatic, 72}, {35.25, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.3 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"68be2a25-4c79-4556-a0b4-5d11ef7e4d3c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 481, 12, 153, "Input",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],
Cell[1042, 34, 698, 16, 148, "Input",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],
Cell[CellGroupData[{
Cell[1765, 54, 2240, 63, 472, "Input",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],
Cell[4008, 119, 1272, 33, 112, "Output",ExpressionUUID->"0c0c18a9-6562-43ef-afe4-bbacfecc0f57"]
}, Open  ]],
Cell[5295, 155, 1204, 34, 292, "Input",ExpressionUUID->"610bb0be-b3fd-408f-8a42-be39a453f29d"],
Cell[CellGroupData[{
Cell[6524, 193, 2718, 79, 372, "Input",ExpressionUUID->"67e9168b-db60-44ba-a9fa-427b0361b9a2"],
Cell[9245, 274, 671, 15, 74, "Output",ExpressionUUID->"1ccb2269-4244-481a-b2e4-19d38c0b0364"],
Cell[9919, 291, 1765, 50, 118, "Output",ExpressionUUID->"6e06fbc8-f41d-4f5e-84e6-2c87e042a93c"]
}, Open  ]],
Cell[11699, 344, 1519, 48, 327, "Input",ExpressionUUID->"34d5834a-ceef-490d-a6db-e030bb1d74d1"],
Cell[13221, 394, 4305, 133, 617, "Input",ExpressionUUID->"58dbc308-1146-4515-b1f9-896efc88e70d"],
Cell[CellGroupData[{
Cell[17551, 531, 1980, 57, 372, "Input",ExpressionUUID->"2a7cb200-a0e5-4628-b6ca-6dbd311847cf"],
Cell[19534, 590, 42156, 713, 538, "Output",ExpressionUUID->"78212540-4ce6-436e-996e-55198ec57cc3"]
}, Open  ]],
Cell[61705, 1306, 153, 3, 64, "Input",ExpressionUUID->"8c6ab175-6ae8-4447-beed-0ef7582902af"],
Cell[CellGroupData[{
Cell[61883, 1313, 950, 29, 197, "Input",ExpressionUUID->"53a4bee3-a297-4d3c-bcaa-a7aa0fc8f344"],
Cell[62836, 1344, 56305, 942, 529, "Output",ExpressionUUID->"6a469551-c933-4641-9bc1-ec8ef3c2c6c5"],
Cell[119144, 2288, 57752, 966, 529, "Output",ExpressionUUID->"919bf317-5c9b-4554-808f-d465e4b3b18b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176933, 3259, 250, 5, 109, "Input",ExpressionUUID->"4bbb5f09-ae2a-4713-bea3-6d0e9d36c2ab"],
Cell[177186, 3266, 1031, 32, 74, "Output",ExpressionUUID->"35033c19-c7eb-4da2-8cfb-7a687534e27b"],
Cell[178220, 3300, 1445, 45, 152, "Output",ExpressionUUID->"aaaab201-6fb3-4c54-a764-32cc1e4419e1"]
}, Open  ]]
}
]
*)

