(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    174392,       3240]
NotebookOptionsPosition[    172306,       3199]
NotebookOutlinePosition[    172820,       3217]
CellTagsIndexPosition[    172777,       3214]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103185676102505`*^9, 3.910318568760665*^9}},
 CellLabel->
  "In[700]:=",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"par", ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Total", "[", 
      FractionBox["1", "#"], "]"}], 
     RowBox[{"-", "1"}]], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ser", "=", "Total"}], ";"}]}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}},
 CellLabel->
  "In[703]:=",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"p", "*", "L1"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"za", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"p", "*", "c"}]], ",", "R2"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zb", "=", 
   RowBox[{"ser", "[", 
    RowBox[{"{", 
     RowBox[{"R3", ",", 
      RowBox[{"p", "*", "L2"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{"par", "[", 
    RowBox[{"{", 
     RowBox[{"za", ",", "zb"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prenos", "=", 
   RowBox[{
    FractionBox["z2", 
     RowBox[{"z1", "+", "z2"}]], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L1", "\[Rule]", "1"}], ",", 
      RowBox[{"L2", "\[Rule]", "1"}], ",", 
      RowBox[{"R1", "\[Rule]", "1"}], ",", 
      RowBox[{"R2", "\[Rule]", "2"}], ",", 
      RowBox[{"R3", "\[Rule]", "3"}], ",", 
      RowBox[{"c", "\[Rule]", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"prenos", "//", "Simplify"}], ",", 
   RowBox[{"prenos", "=", 
    FractionBox[
     RowBox[{"Expand", "[", 
      RowBox[{"Numerator", "[", 
       RowBox[{"prenos", "//", "Simplify"}], "]"}], "]"}], 
     RowBox[{"Denominator", "[", 
      RowBox[{"prenos", "//", "Simplify"}], "]"}]]}]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910318588994113*^9, 3.9103186242946224`*^9}, {
   3.9103186984093633`*^9, 3.9103188230996065`*^9}, {3.91031885620673*^9, 
   3.910318940246311*^9}, {3.9103189821402245`*^9, 3.910318984632202*^9}, 
   3.910319114248515*^9, {3.910319200124604*^9, 3.910319212450725*^9}, {
   3.910321212223425*^9, 3.9103212161376815`*^9}, {3.91032129999327*^9, 
   3.9103213268570223`*^9}, {3.9103216143103514`*^9, 
   3.9103216824171247`*^9}, {3.910322177432126*^9, 3.9103221884641523`*^9}, {
   3.9103222231440277`*^9, 3.9103222308871*^9}, {3.910323229022059*^9, 
   3.910323231024375*^9}},
 CellLabel->
  "In[705]:=",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "p"}]}], ")"}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]], ",", 
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"7", " ", "p"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["p", "2"]}]}], 
    RowBox[{"4", "+", 
     RowBox[{"13", " ", "p"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox["p", "3"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.9103187216013775`*^9, 3.91031881473453*^9}, {
   3.910318863437398*^9, 3.910318941095933*^9}, 3.9103189852341127`*^9, 
   3.91031911496647*^9, {3.910319201428973*^9, 3.9103192132912235`*^9}, {
   3.910321292362014*^9, 3.9103213274636955`*^9}, {3.910321657468945*^9, 
   3.910321682935179*^9}, {3.910322180081609*^9, 3.9103221895424256`*^9}, 
   3.9103222326427927`*^9, {3.9103231596946964`*^9, 3.9103231657775264`*^9}, 
   3.9103232324484653`*^9, 3.910325838613558*^9},
 CellLabel->
  "Out[710]=",ExpressionUUID->"0c0c18a9-6562-43ef-afe4-bbacfecc0f57"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn0", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"vCem", ",", 
      SuperscriptBox["p", "i"]}], "]"}], "/;", 
    RowBox[{"i", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"coeff", "[", 
    RowBox[{"vCem_", ",", "i_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"vCem", "/.", 
      RowBox[{"p", "\[Rule]", "0"}]}], ")"}], "/;", 
    RowBox[{"i", "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numP", "=", 
   RowBox[{"Numerator", "[", "prenos", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"denomP", "=", 
   RowBox[{"Denominator", "[", "prenos", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103190743512273`*^9, 3.910319177581434*^9}, 
   3.9103192389050026`*^9, {3.9103231808821287`*^9, 3.910323239575629*^9}},
 CellLabel->
  "In[711]:=",ExpressionUUID->"610bb0be-b3fd-408f-8a42-be39a453f29d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"denomP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "i_Integer", "]"}], ":=", 
   RowBox[{"coeff", "[", 
    RowBox[{"numP", ",", "i"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "0", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "0", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "0", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"stavRcei", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "i", "]"}], "'"}], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "i", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "i", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"i", "-", "1"}], "]"}], "[", "t", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceStavYU", "=", 
   RowBox[{"stavRcei", "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"vystupniRce", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "*", 
      RowBox[{"y", "[", "t", "]"}]}], "-", 
     RowBox[{
      RowBox[{"b", "[", "n", "]"}], "*", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "[", "t", "]"}]}], "\[Equal]", "0"}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solVystRov", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"vystupniRce", ",", 
      RowBox[{"y", "[", "t", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rceStavObecne", "=", 
  RowBox[{"rceStavYU", "/.", "solVystRov"}]}]}], "Input",
 CellChangeTimes->{{3.9103190743512273`*^9, 3.910319177581434*^9}, 
   3.9103192389050026`*^9, {3.9103231808821287`*^9, 3.9103232027633247`*^9}, {
   3.9103232621832104`*^9, 3.910323262641935*^9}, 3.910323298003126*^9, 
   3.910323655561279*^9, {3.9103237032383833`*^9, 3.91032375592161*^9}, {
   3.910323900694393*^9, 3.910323901712363*^9}, {3.9103251399580545`*^9, 
   3.9103251481619053`*^9}},
 CellLabel->
  "In[717]:=",ExpressionUUID->"67e9168b-db60-44ba-a9fa-427b0361b9a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "+", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}], "\[Equal]", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 3.910319239453104*^9}, {
   3.910323149040643*^9, 3.9103231851460104`*^9}, {3.910323242079173*^9, 
   3.91032329850871*^9}, 3.9103236560938244`*^9, {3.9103237037876053`*^9, 
   3.910323773767955*^9}, {3.910323886917143*^9, 3.910323929871626*^9}, {
   3.910325140772576*^9, 3.910325148806188*^9}, 3.9103258386453285`*^9},
 CellLabel->
  "Out[722]=",ExpressionUUID->"1ccb2269-4244-481a-b2e4-19d38c0b0364"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "0", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "1", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"13", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "[", "2", "]"}], "\[Prime]",
      MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"u", "[", "t", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "[", "t", "]"}], "-", 
     RowBox[{"8", " ", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "[", "t", "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.910319178252495*^9, {3.9103192169579425`*^9, 3.910319239453104*^9}, {
   3.910323149040643*^9, 3.9103231851460104`*^9}, {3.910323242079173*^9, 
   3.91032329850871*^9}, 3.9103236560938244`*^9, {3.9103237037876053`*^9, 
   3.910323773767955*^9}, {3.910323886917143*^9, 3.910323929871626*^9}, {
   3.910325140772576*^9, 3.910325148806188*^9}, 3.9103258386453285`*^9},
 CellLabel->
  "Out[724]=",ExpressionUUID->"6e06fbc8-f41d-4f5e-84e6-2c87e042a93c"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{"0.01", "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"Sin", "[", "t", "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"0.123", "t"}], "]"}], "+", "rn"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.", ",", "tmax", ",", 
       FractionBox["tmax", "500"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intu", "=", 
   RowBox[{"Interpolation", "[", "data", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"intu", "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"intu", "'"}], "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"intu", "''"}], "[", "t", "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.910324022667981*^9, 3.910324246979061*^9}, 
   3.9103243631230135`*^9},
 CellLabel->
  "In[725]:=",ExpressionUUID->"34d5834a-ceef-490d-a6db-e030bb1d74d1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rhs", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Numerator", "[", "prenos", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Numerator", "[", "prenos", "]"}], "/.", 
          RowBox[{"p", "->", "0"}]}], ")"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], ":>", 
         TagBox[
          StyleBox[
           RowBox[{
            RowBox[{
             RowBox[{"Derivative", "[", "i", "]"}], "[", "u", "]"}], "[", "t",
             "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm]}], ",", 
        RowBox[{"p", ":>", 
         StyleBox[
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "1", "]"}], "[", "u", "]"}], "[", "t", 
           "]"}],
          ShowSpecialCharacters->False,
          ShowStringCharacters->True,
          NumberMarks->True]}]}], "}"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Numerator", "[", "prenos", "]"}], "/.", 
       RowBox[{"p", "->", "0"}]}], ")"}], "*", 
     RowBox[{"u", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lhs", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Denominator", "[", "prenos", "]"}], "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Denominator", "[", "prenos", "]"}], "/.", 
          RowBox[{"p", "->", "0"}]}], ")"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["p", "i_"], ":>", 
         TagBox[
          StyleBox[
           RowBox[{
            RowBox[{
             RowBox[{"Derivative", "[", "i", "]"}], "[", "y", "]"}], "[", "t",
             "]"}],
           ShowSpecialCharacters->False,
           ShowStringCharacters->True,
           NumberMarks->True],
          FullForm]}], ",", 
        RowBox[{"p", ":>", 
         StyleBox[
          RowBox[{
           RowBox[{
            RowBox[{"Derivative", "[", "1", "]"}], "[", "y", "]"}], "[", "t", 
           "]"}],
          ShowSpecialCharacters->False,
          ShowStringCharacters->True,
          NumberMarks->True]}]}], "}"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Denominator", "[", "prenos", "]"}], "/.", 
       RowBox[{"p", "->", "0"}]}], ")"}], "*", 
     RowBox[{"y", "[", "t", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rce", "=", 
  RowBox[{"{", 
   RowBox[{"lhs", "==", "rhs"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pocs", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{"rce", ",", 
     TagBox[
      StyleBox[
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "i_", "]"}], "[", "y", "]"}], "[", "t", 
         "]"}], ":>", 
        RowBox[{"0", "==", 
         RowBox[{
          RowBox[{
           RowBox[{"Derivative", "[", 
            RowBox[{"i", "-", "1"}], "]"}], "[", "y", "]"}], "[", "0", 
          "]"}]}]}],
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], ",", "All"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceAll", "=", 
   RowBox[{
    RowBox[{"Union", "[", 
     RowBox[{"rce", ",", "pocs"}], "]"}], "/.", 
    RowBox[{"u", "->", "intu"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"rceAll", ",", "y", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plPrimo", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "sol1"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9103243812289367`*^9, 3.9103243826652117`*^9}, {
   3.910324414835314*^9, 3.9103245150364323`*^9}, {3.9103245997099104`*^9, 
   3.910325094858467*^9}, {3.9103256972283707`*^9, 3.9103256995308657`*^9}, 
   3.910326367035333*^9},
 CellLabel->
  "In[832]:=",ExpressionUUID->"58dbc308-1146-4515-b1f9-896efc88e70d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"y", "[", "t", "]"}]}], "+", 
    RowBox[{"13", " ", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "+", 
    RowBox[{"8", " ", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["y", 
      TagBox[
       RowBox[{"(", "3", ")"}],
       Derivative],
      MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"u", "[", "t", "]"}]}], "+", 
    RowBox[{"7", " ", 
     RowBox[{
      SuperscriptBox["u", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{
      SuperscriptBox["u", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.910326367554078*^9},
 CellLabel->
  "Out[834]=",ExpressionUUID->"2b65cc3f-7376-4408-a639-bbc696ea917a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pocsStav", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rceStavObecne", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "'"}], "[", "t", "]"}], ":>", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "==", "0"}]}], ",", "All"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nezname", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"rceStavObecne", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i_", "]"}], "[", "t", "]"}], ":>", 
       RowBox[{"x", "[", "i", "]"}]}], ",", "All"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"rceStavObecne", ",", "pocsStav"}], "]"}], "/.", 
       RowBox[{"u", "->", "intu"}]}], ",", "nezname", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystup", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "/.", "solVystRov"}], ")"}], "/.", 
    "sol2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plStav", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{"vystup", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "->", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plPrimo", ",", "plStav"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910325160630723*^9, 3.9103253332064395`*^9}, 
   3.9103254136267843`*^9, {3.9103255845152264`*^9, 3.910325600041668*^9}, {
   3.9103256472702885`*^9, 3.9103257346019554`*^9}},
 CellLabel->
  "In[738]:=",ExpressionUUID->"2a7cb200-a0e5-4628-b6ca-6dbd311847cf"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVV3c81e8XNwul7JZxrWtd49JXkjqnQZI0lUqKslJCRKiEjIykjBTKCpVE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        "]]},
      Annotation[#, "Charting`Private`Tag$190318#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
       Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVV3c81e8XNys07GRe6xLXuBQqdY6VQiqlJPWVhlVWpKSFUlZUJBEZhVQq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        "]]},
      Annotation[#, "Charting`Private`Tag$190392#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 20}, {-0.16936716036804686`, 1.2918413315060102`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.910325673957696*^9, 3.9103257158103647`*^9}, 
   3.910325839350417*^9},
 CellLabel->
  "Out[743]=",ExpressionUUID->"78212540-4ce6-436e-996e-55198ec57cc3"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.9103253214465675`*^9},
 CellLabel->
  "In[744]:=",ExpressionUUID->"8c6ab175-6ae8-4447-beed-0ef7582902af"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pom", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"vystup", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"y", "[", "t", "]"}], "/.", "solVystRov"}], ")"}], "/.", 
       "sol2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "/.", "sol1"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"pom", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  "}"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.910325748741715*^9, 3.9103258091636896`*^9}, {
  3.9103258563048897`*^9, 3.9103258590126314`*^9}, {3.9103262373898478`*^9, 
  3.9103262626606407`*^9}},
 CellLabel->
  "In[830]:=",ExpressionUUID->"53a4bee3-a297-4d3c-bcaa-a7aa0fc8f344"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81t8Xt/cm2zM0kNKSSLlHSokkiZRkZSepZEVRRJkRIaMkZCcrdYXs
7bGVvkIysnmekN/z++vzOq97z3qf9/mcc8lWNwyvMTEwMBznZGD4//elrxXb
PpsEDQZhFtLlcgONmi6SngnJE/3IDi42FRpCm7WfA0ikYJRzeH3pycMZ9LIy
lMhKeoFscvTFJh+so12zNmGbdsnI+JXPvFcMI3zjS/q33vsKSY+Zqr5OZQHn
o3eurxIzERcn213mk1zwnvIjbUkrG6UO7pEgD/DAXye9oXm7PERSv5F5+QY/
HG+J3L7SW4iS47drnVwWhIm4k1+WHIrQzaBjVXM8wvDUZsNsce0D+gfPOK3Z
RKBrzT56jliGmE8YKTwZ3ALudYS9swXlaFV7gOV+tihIPqM0zWhVIN7CA3US
rmJgtROYp+wwqj7O2nh7SByY1rzalnwq0b3yuQ6dexJA+XFBZunEF1QbUp8a
KCkJ6bV7nRb5qlAYw34/9TxJ8MjmLlvorUK+J+zOCJ2SgtNR42wLKdXo9tix
l3Z5UiDt8cVo3qEGab98aFG/Sxr+XEl8Nbf/K0o8clO+OEkaKrXuzs2ufUW7
nU1p0owyEKVgqDFbU4uqJywoG/oyYMO/++mf0Dr0bSy36VmaDKgssw/MGNej
3sf3SO2rMsA+OCI3Q2xAmcvTm6KKBOir/HRneqIBUeJHjQatCJCVHlc9VdCI
9spku04kEsDn6S3BKa8m9L6FwJzQRwB9N/2rk1rNKF8k70vcMgFIFxVyfvO0
oHLF3oFBKSIsHGVZm+huQZEyxeZnjxChZuvwqYmkVsSytF2G3YUIzznLn/+y
a0NLEzkmW5yJUHT3tNst8XYkJNJ6+NIjIiROHpJY9GlHzV0TTtZBRHh0ZXul
23/t6DWP+o2VJ0RwaReyWzjRgRyus92qeU0EEy0GPresDlSb9+n06xAiQPFM
0TxfJyKsVXDw0/UVFAYv37zViZBcbIWLPxGEEuuZ5ns7kR9R8BJjKBHW+Ioz
XY90IeNMrfZmRyKMPnhtMJfShaKiXnTO3yBCy1LE6g1WCjokei37uQkRiu18
k2YdKOieWAjnDQUiJA84nbjRSkGT/FudJncQ4fEZ0+k/+7vRuaMPVzaYiHCz
UvuZSyxdHtjZWzJEgEsHlA//WetG7qsChvEVBNBKJ/933aIH+QiN7/sdRoBd
EvyPZ2p6UGek8uS6MwG2PF1Xuq7Qi2Ag9/L4GQL8+/e7ezq0F63ZNv0O3EmA
Xzd7fZwXelHBg2sfBjdkoH20Zuu0cR/KDX/o9bFNBkpNChudPvah1YeaqS9e
y0BqY/LNKWI/Movsfst5VwaW4j7sHH7aj77ez3dKV5ABbbumn520fkSmqh9i
ZpaBaebVC+VdA+jjRyPzwCfSoHpU/3Bw0BDSYxm92BgvBe1560xys8NIkN0i
YfypBPg17jq97+pPdKhBUvjP0S2QUVCy413MT3T3omDg/jUR6Iw7xry9+Sdq
zSkRrswRgW12FyvE1UZRCuuhPhtZEWhkfqjEIDyGWIxSVSIUhUH06KBQW+04
MmGz4EvgFYTcvOBBZ6VJdKAj9VdxNBdMCk0+PW05ifZUa4kkIy6Qcz+tIR89
ieKW5JwNRjnBpj9rlrVuEgl3265FOHJCyhHu1J+0SXTiuf9dgb8cENXw1PbS
1ykUlRd2eZ8TO7j/DJ8/aTaD2FrKkzfsWKBQe+7V9vAZlGtaHNdIYIHZTAMj
5qoZ9EnvrBhTJzPs4i1g/W9pBgXEef+3acUM9q6CJZ/l/iDH8b1vbAjMcGkj
yufg4h/UvdtSdn8mIyRzNwUInphDuQXO1b+O/kMaR73N7pvPIWnp+MOu/Rto
yEXx4OzdOXRiU+K2t9QG8koZ5DWPnEOplrt5F3zWkXjnk/HmrDnEXeYqXPVh
DUXG6ek8FphHRw98MFh0oKGA7a18m4PzaOymjd0jWEZ2qOPFtNsiyr6fYhb1
axIxvFopH3yyiKyaaz/++vYbxbFIDzWmLaI54UMmW7om0F47zY2yT4tI1Jfn
BuXOBKpvsCVk9iyioxLmVVxxv5C80fqra4eXUP5oEss6eRRN2Mtlf2dcRqRX
saoda4PofpNeS4vkMvLcVH4xtW0QiSu5/ak4sIyuCcXFP7/aj/IjYvmz9ZZR
ZkXKgo5ILzq1WLE34doyGtX5VxcU0o1+XBg5F+K7jEoCdpgW2VGQRyn7Lc/Y
ZfTo6Z6QNr0uJCC1O9o+fxkto/h47ScdKPOe4QeThmX0pE6navRlOzr2426P
9sgygoqCanHvVjRw7OXqwbVlVKWy9OABZzPi4phQE9m9gq5nHJ76LFqLHKPu
fW6PWEHEb3qtkxPFiGn51TDOXEE1zNv/CygoRPEm9Qx5VStIZ+DhF27ZbNQo
LawVurSCUvacSHZmikaKbzPqdC6uIotnprrcpzNwDWfrhOrNVTRlbvxe7FkB
NnNe5JQPWUWhT7S4ajzL8VKruKLY61W0bKLlxKFUiZ/u09Bjq1hFe5PNU/sF
MN4WbX19mbKKnBgXX3tLV+OKlcdhozOrSPtL8PU7zTXYyDQ3r4uNikxf1u14
VFeHpz92tVcRqSg7efMKG08jfkigzReoUpGUbdOqg0Izln5AEE49R0VOVb7p
Z/lbcNFPLeUIRyqS/i9Y+595K9bTdrjgF0BF2zV95hwS2vFoRpi7SyIVBZ49
nBsR3oF9uItir3ygoq+sTj1Jmp1YxKW/VK+VilwJ2+aSm7pwTvu/fvVfVBR+
5694jnE31j6wbW0nAw1dYuduHD/Sjb/H6EhLStBQK5bgWV7uxu5Ul6Oc+2no
Ai3YNoXci/kuR5tTT9PQZtSVHb9P9+H0T2V+v6xpKOSE69E3lD6sQRpO6fGh
IZbOdIY79wZwjz9L1dcYGiK+226t6zCAXcYUfhbl0tDV5JVzs+tD+Id5P8eX
BhqakfULtOX9hs/3PVZqGaWhlWypCY7Fb7j2nKpR/yYNHWc4FcGuOYxVm355
jkn+RWsSthWSvD8wc8EbAdGgv+goo/fAmYz/sPvOCyqyr/4ijdLanLfyI3ji
NYuZ0qe/6C7JyHvi4gi+LFP04HDfX3T+1buzSmd/4tbn1m+1F/8iqdT5lot6
PzEICLcY8q2htM2bZgGGo/h9cNWCucIaulNkLpw4MIp3MLuJOx1fQ+Oxn2RK
5cdwnA9Z4+7VNZR3++MEddsY5lpptw7wWkMvrUs8a6XH8L0b94PDY9ZQxadM
YbHCMTw3sScvIX8N2TtlXE9UGMdWVsOUt01r6EFfu5/blXFMGQz7+358DY3l
/Updah7HJy9okCoZ15FayC/7FM9fuLx15kSz9DoyWSXenB78hXedeunUd2gd
xYbZvfz3aAInfdGLHDVcRyWJh1KjDSewoPp68dz1dXRidu5VVsIEflj0bmj9
Md1e9w23sI7feGX3ZSbOtHWUPvA1rLTkN3Z4yyW/Ba+jHKeJMOLMbzxEKj9D
HlhHfluzCiNHf2P9eIdbu5fX0WmsKbFFeAp/EZZ4oSawgVii28xef5nEyqH1
n08obiDPpqt6TiFTOJ3NY/ScNl1uJjjcbJ7CEvfluMwtN9BKj473G71p/JTW
s8fRZwONU5X66pmm8T+3wAvusRuIL9DvvF3hNL45fdDbv3ADzavyjm1lmMGj
18ZSwlo2UHf+cdwmPYONh6Nr4yc20GfdAn1WhRlcf/H4dDrzP9SSg/m7pf9g
9c5FwfeEf6jMqflnxus/OFf39SGs9g+ZBKAL8V1/MOmr4ZUmo3+IN8uwXzPh
D47SYArovfEP2Si2WN5Z/INZSwsyfob8Q44q1T1LKrPYY59l6+ybf+hGcrR6
1btZPJklsLRW+Q/pV/lUnOacw2bbKiU4hv6hbDWvvXJ75nDbyxtIZPUfIolS
7bu55vAxMeI1ktAmYtFfKVy1nMNFEa0hu3ZvogsfF53Wz85hOS7ffNVTm+if
MCHqWsAcjg/Y3XPcehMRnZsZV4fmMM/G0JqB7yay/l7V+4Q4j/3cn5KvvNhE
Pz9MH0Cjc5iL/FBuWJUBHLJn1ax+zeP6I5F7fE8wwItTweOSGgs48GLSIRlD
BvhhLjnHdXABH7/9DlWYM0C4b7io4OMFzBRRevKyEwPwLF3fci5tAVe++3r2
710GmE1Uzw64v4B96zpNXjxkAJffWrkH6PKRn8NXVSMZwI+t1YgasoD//pu2
633JAAc47oyv/FzApZJ/b7hnMYDgg8BmTcVF7K7C7rGlhAG2r9292Xd6ESsb
itwvqmYA7q4zC4cuLeKF6+TH59sZoM7IaKffg0WcH6wUsTDEAHI1TzUjHRax
yxv1uMjfDNA1W/TSxngR7/pyKmXvCgM8d9lTMOG5iKeGLmS0MTFCeMw9v+XY
RZxFtcp34WeErxH6gg6vF7G9iGsprzQjDB3tD3qds4h37L1XmS3PCIY7Rbnz
hJfwqG5Ive5BRvA/8JWHzLeEX9nFtk9qMoJIqKObGv8StghI6wvWZ4TrRnXX
HXcvYUJywQ/5y4wQZorjfzAt4aHyzxN1dowwMSjuedViCcf3NM3Z3maEJodo
CQazJXxxoY/K+oAR9FreSkb7LWFRvnGGN6GMMKM0m/4tYAlTFBY5jsczAqMl
rwfXxyUcdYJB8Gc6IzTU3GF/TpcNLHkl/N8zQlaffRJf7RLmuydJJlcywo7H
bZLaS0u4OU5OobKZEYxskkgHGJdxSJHyvqv9jKDc/y1MfvcyPtWuqfZvjBE8
BZjPqCkuY7Zpfc2XC/T488vNzugv4xp2M50jm4xQfN/Eb4Yu+291ODfIzQTh
VWGaRM9lDMjd1EucCdjcdqJ1rWX871KApcR2Jvjb0q01YbSMK9wjHEr3McEd
3pHPY9eXsVfUy5smGkzwp4PlyPlry1g1N8tz5TQTfMjUuP8tYRmvNJQ8iDFh
gkmidcaH38u4aKwmWNmGCba5nvFL/rWM3Rg7I7tcmeBVGsc9peZlvFdm+IXb
PXo8w+wFYg3L+I/qdKpgCBM8Pm3ZFktcwTlGtMz850ygucZsfmxzGTu7shWe
fc0E7HljJT66K3jnU+HyP3lMQLVxfWuwewVPvCVVhVYwwbmN8GchZ1ZwevXu
xl0N9Pg6f7pMua9gm+HDnU3dTFDvpPc+1mcFy66dHHAcYYIfeWuFrAUr+Ifo
hRHOWSZot73i8e7xCk7abzWZscYEWmpP9vD5rmAz/RsLJzmYgUpTE/z8YAVL
Ovr8HReh76HuMTHRH1Zw36NgpkAyM+gz7zx84MkKfp76nGu7En0vvdFZ/H5x
BRt9ei1Uc5gZNFXU+SRoK1ioP1/S+iQzRJOUzhO6VnD70idZJiNmeMSlrHZx
dQWHCTTtTLVgBhXjyQMXGVdx2SGZD/ouzLAcuBxULbCKR81voHVvZrApVYsv
G1vBAoFfGjKDmWHvxuch/5OrWD1H2Mgklhl2pB85V82yim0p176zvGGG8dCD
nxSPreKotRL7wkJm4F1b7XNBq/iTLNfi1Upm0FUJuHj87Cqe0DG7x9vKDAsH
RXl/Oq1ikZu57B8HmcGMZ4Vd5NIqRnEMUfa/mYEys9RbcXsVO2JDadFVZrjJ
frbhh90qfj6ell7NwgI5Rf+9CApexV94V/feFGIBn+kdG6JPVvG0ss5HAokF
fnp7HMiOXMXiZgknmnezgNwDk/sOPatYK2CmzVOdBdbEk1/Efl/FLlnokpwO
C7DulUh5WbiK4zsiRynGLCCzT75SfWYVf6X+dPG3YYGCux7bTBmpeI6oQtvj
xgKD4pzMIcJULH3yccA3PxY4w+n64d+vVXzSZYD3SSgLtO8U3aj9u4rdYnbF
qSawwCU/uQVnDipOqvCVHc9ggRtePGc12ai44Wd79rNiFjCumIvnOUnFS1xb
D2nWsMBoon3VGoGKSfvvfKH3BqSHetQxWVOxrmmdbuIwC5wSLH2YT/fvfl+i
R2eGBQz4JttZzlDxq7dOFqt/WYBy7aPa/dtU3NL6aTKNgxVYebjufzGkYuoy
/x1DUVYIXdhIVb5GxVtlrDY3t7LCb9uLjVdvULH+8aLgnH2sMGW0vjMjiIq9
nNhELiNWSE1WaTal238TdTGJ4wwr6EWcW76dT8XtZVnyxZdYgZp5z2zyBRWv
/1gvtLZnhT1eNc9IYVQsx3H2qKA7K6Sv8SuNtFKx4Z7Uus8BrHD4kcRJkVQq
9jVePOccyQphuYaMDYVUnHnvxJBEMiuEv+LtnBmkYkparG1dNivksKtQtWOo
mKH599ztclaYFHRjdf5DxYqL6t6y9axgL0zcf4IuG0uGsbZ3s0LfZUn2011U
7K/5I/zeT1YwvnUr3KOYinPs90sqzrNCrGkBsVqAhvvCH6b1/WOFt+eyNF7V
UDFLSY9SIA8b2MVeUxugUPGe7/JlByTZwN5Ok/CjjoovsXpr/SfHBulDQx8p
f6k4cFdLS9hBNqjuM3ScqqDigvPEi0e02GB9cyRbap2Kh7xujvw2YIOr71T/
KtP9cbyqdo41Z4Ok5GMfpSVp+EDDltXjzmxQcPCarMcSFZvP2T1Y8GSD1YqE
mTouGg4RK+dOCWKDz5cTHjUcoeEPGjzPz8SwQeZJZovHB2j4xzVz0torNrh0
NfCg/mka5gnNz8rIZwPqN8O8UjEaPlTEdND4Mxt8MM2RvE2/bzVohJmb2aBr
5kuG+1Ya5kr47/rNfjaoueNdrKJOw4WXXKSHx9ngu8m6ebwKDV+SXGvUW2KD
M8P7rCSVaJh5IMiznJEdNCvOiinspuHsFyLy8vzsEPX46eFsXhr9PZPaEyPN
DvcNL4fMnaThdXGlR8w72eHA0sfjrQY0nNZXfuDmIXbw/XRMS4qOh17cyZHv
x9khEg05DzvQ8JIJJULPkB3OSVl9zaPHlyhmicqv0u17FbMk7aLhE70zM3LX
2YHtz7hdhwgN/3nulRjjxQ4vKW88Fj1o+Lkxuy7zY3Zg7LWc4XtGwxqi0TTX
GHZ4VZSRXEzHb7yblPH9FTuUZTOH77xPw2ExOcZ6+fR4n7koluylYZULh1nL
P7HDJ+ZPlGpjGv4uUvderokdFL2ijH8+pOEgynmrmD52KOCdYXezoeG90T8E
mMfZIR39bXMzo/Pp/HXsusgODonf9w7eouH7wn+vf2fggEP+DVG6njQs3xUo
rcfHAYfJpqrC9PvtUcJNZVIccEPlgaf9RRr2MEzxlFPggOS7TubnbGmYJLRb
PkaFA0ZO/9la4ETDDR1lPUzHOSB9uGZ9+ToNu0VqP3I9xwH95zjtV4/TsOS5
rgPfzTngoiofZ+xhGq4SsBjRdeaAlLg4u2J6vI7t0xFlnhygkpfqpU6vh1CE
J5IL4gDxWAfSnDsNl59l+xMdzQG06hMXrtyh84X/WSLTKw7YxsgYF2VEw9xt
RF3XPA54lTA54x1Bw0Vh2bRvFRzg66g8a3WFRp9nahm6jRzwsl1+MFeBhln4
ao3Leun59SvvuqRD50uLIavcGAfofN/T0qBJ50vo8PvoBXr8YZXXL9PxWtdz
tmJi4ASHnhe+MxfofOGhCbjycsKzW3evt9L9n2l+hL9JcsLd6e8V7fT7K0+E
XHTlOeGb3/MzY/R8knSTpcsOckL+Mx6JKTre2ty7mnZocYLA63u7fej8/tNY
6hltwAn1HkptmvT8noeckGcy5wT+qihtv+d0vpzu7LnhxAnQFudylM6ncc6r
j755cIJFycH482dpOLxh6oBuICeMULc9j6bzXTXYY6T0GScMnmd6r0LP78cp
1sgdqZzgKfVxU4LOt8ccUSg6lxMmFx90PaLnu7ee8IexghPieL+GH6LXuy/o
XeKNBk5ga/r9bPIanS8nVXW/9XDCb5MY28N0Psqzf6WdHuWE17L72d/R42+v
PZdROs8JuweSp5fo+HoEfjfesckJh45qGDncpPNF24k1mocL9n3s+TRkTcP1
rNT3jJJc8DCA/JTZhIZvfn1odUOOCzJ+FPUc26Riwqg228oBLhAvCRD5RqLh
JibOLB/gguKuvawl9P+JB7npDPMZLkhMkxBLoP+vtkPofLApF7iefkd9K0/D
neZnYwRsucA6ycfhkRwN+90TVIt144K3o0rDr+j9vSuxa0jGjwvy95gp9jLT
cH95zP20J1ygzPijJXmD/v/sN9mmGMcFYSS5/bvo8+EAVaK+II0LNkP6NCY5
6HiKDjmpFnDBET7x6+qjVBx6MIkff+IC0T5Fvv2KNHzYyOL9iUYucBLvdDVl
p+FfbrImzT1cQIkcucE+QsXRkaN/DX9ywd8/F3s/0/PVzE9P6p/lguzq9QhH
CTofWu2PWazT/R96FPWQ7i9hZuf4OAc32NL+EaczqPgUz0zw9S3ckCLEwbub
Po+Wd+btXiJzA5va49buH/R5q3Ozw0uJG/Sf+b015aHhs/YH7jCqc8N7Nq/h
Pw30eRi4LP74JDf4pqcd2FdAn29vSir4jLjB7Mk+0/wp+ryq8bSIseAGflGO
feHVVMz8U51F+jo3RHhJELRfU3E+47+3rzy5wdpVx7mUPs+ukCp1FQK5YYCg
GzNDn5dcyH82L4ob9j16cVmbPk9Lrhx/ppLMDXUdInX+blRs48N26NM7bsgP
CEsSfEDFggn1A1ql3PDDZpjjhwUVfy4L8W2s4Qbxx0sv64Kp2KlPT/ZcBzdc
WLwZ9N2cisVX+Wp7v3HDdxmzsq/0ef51S4eD+STdf1RdhCJ9H3BTfsY7tsIN
FR8sL4a5UDHx/IUCJ2YesLw9FRF/nIqbb4pdWODngf+yFOfTQ6nYM6Kf6iHN
AzV8AeRGHSrekZeQuCnPA3l11bfUzlNxV8sVCDzIA4ectRpK6fHdnyaO8hzj
gf2Zkww5KlS8m3sk6Jk+D6x4eXlf1aPiAYU0RcnLPBC89N5JQY6Kg07ZtqXY
0c8X21LVFahY2U7+ltxtHjDuFI1eV6Xi/x5Niubep/uz6BlxG1/FYWnZ5cqh
PLCmxhahtEnfb6tdzD++4IFrUVIx2kv0ffW/vUzH0nngy4+DmsPLqziGYfFN
fSEPIL67lhfJVHyM+EHnLKbnZ9p0Wr9zFc8evTvT3USPtyv/d+uHVZxophZp
1scDTHo980xVq1jHe0355ygPHPQ1lns7u4pXXnzqc5jngYBYdFuavn++LvXz
mdvgAcHQ2qSzE6vYoFeTdJeLF3I1mhR9JlfxxjJzzYYoL7wZu5pa572Ks0Rq
7R5u5YWAvje72V+uYpMDj7m59/ICy0RJJZSsYhbD03mRR3ihrIMj5K//Ki5w
5TkvrsMLMfuGJh7VruLmeGHPHGNeGOqTlA2h64/XSCYfs+EFV6/bbo/p+zTD
LPlr701e8DzBQE1IW8WSEgpTzn68IMz9qfiKyypW1toryBTKC27aF5ZtAlbx
2euHDsXG84LTj7dJvTfp+3usxpVdGbzQEq9qJK+0ih9+ORHw5QMvnDMpm2Te
vYqTpvQyjat5AXHGVssZr+LSLUZtU+28ILcxPaC0sYI70eXl+9/p+fdhh+cq
q3jGwUpKdJoXpp4qdGVQVzBHtIPmOxovhPaO/KrlWsWyn13tgJ0P9l43vWgz
vIKPTNwN7RbhA6lWi+TQ6hVsLOT33lGWDxr1dvu4V6xg1yOB/Zt7+OC/JOaT
B0dXcIht6Gb0UT5gfV/SdImunxYRvX2nLh/QHl65EJ20gnF5gi6+yAcWt8lX
Wp6u4IHRVzeNbOn2TxfUvHmzgpf4smJ/3+ID410Mu2/0rGA+tYJPvg/44P0N
rxKZqBUsb136UzicD9rynJcsrqzgY6GYMzORD/Zbhn7U+f97sKR2j0YWH2hJ
X4x5T3+Puv/XcqGrhA/KIhSSNnes4Ejubm/7r3ywKsZqOR+7grMPDqVudPKB
d5X0EW+VFVx79Wdd1A8+qLTFK4mH6e/P4MkZuT98YJgp6ea1ZQX/fT8v/GmN
D/r/7Ruaur6CRb5T1Qw5+aEp8KTmfeYVrMTBYPFLlB+oplKKj+n+Tu1nD/TZ
xg8WSrm/H3OsYGszvmzB/fzQJ7DbaeePZewbuKUzHfFD98xSUNrcMo7Ll6aq
n+GHmVvHYpi+LuPCga2Ejkv8QBSeOZjVtoybWRSP29rzQ0mgZG9OxjIeV9rv
uHaHH1QLO4xbPy1jBlO1iIgAfrjywm34XdQylgyA4u2R/PCYkDzm8nkZH8w5
OVSexA/cW5e2sNxZpveHPpNBNj8QvMKVX4UuY0dGY/mxMn4QuCUdN3JuGT9U
vKLvVccPonfLecqvLOOkCza3+bv5QZGZdrZpxzIu9XOKTxvhh1i2rbYJd5dx
V6ZbpdocPyyNGtzp1FzGf7o8x1s3+CHD/aJH/doSZvEDtkJWAXi3KZv2gWcZ
C4ocf+HDIwDu7uP7TdaXMCHz5K6TwgIQp7BzeznHMlbU0MWCkgJw6tBtPke+
ZazapW84RBKAgC98ThJbl/EJe8OxdDkBuHVZ2GSubwkbblzwuKkkAKV3ur/K
NS3hq1Gm3EcOCsDg1YuUildL2FnuShLbEQEw0xHtJmYsYc8Ki30dxwSgQzw5
zj9tCQees6lJ0BEA1m0xj4wNl3D0uJ2JrYEAqLWpvG02XsKp3k6Te00EIPXG
sPx/tkt4byUnNeiKAJTckrHxU1nClSwZrMPWAmD6sDNyjbCEDXS0hVUcBUB3
n4cOQXQJ/wgdJYW6CkAZ5504PaMl7NrprzTqLgBW1nlBoxuLeFOUfET9ngBE
/GHNj+5ZxGGXsU5UgACceLSg8pKTjk/KFZPfwQKQZUO4Ta1YxLmjazYQIQBr
Aby5ctmL+KhCvFvscwFg5w+aHFtcxM3XVe//SaTbE3jgc2VsEZsV9oSeeC0A
MpVXyzxiFvH0yu2ExEwBGH/++WfXs0XsrS6cuZgnANfuGunvj13EXPcLik8X
C8B+nq0G35IXcXzN2ZrUCgEQe6zg5RG/iKN4lZOEZAXhY/DjG+8yFrCsYec7
B3lBMD32hIMraAEXPHctq1QShI7QKj4f7wUMg3x1YgcF4ZJgfEWK7gJuJ+ZQ
XNQFYSKXx/S3xQK2sNEd+aopCOVn0LKu1gKezfg9K31KEEJeVtVNLcxj35mg
jVv6gpAZGOHpQ1zAfPt3cDcZCUJC8ksvqfl5nOReIy57WRDmH2xNeb00j3d/
tNrhaSkIApsPU1H5PK7YZFButxMEJq3zLomZ81jveLKmnAvdv1m3ltjYPB56
fPSs721B6LYbb8gunsdOLYNm3V6CYEe4Oq3kPY//Cno57nogCPXMHy7o3ZjH
IcbiHgFBgsDK8MS/+M48lkwofjQQKgj32Qnvkizmceaw0bN90YLw656aK4k4
j1W3LaY8jheEHp0/rwUV5nG9fWTucIogaChYGX/kmscXc/ZUqLwVBFLRgVt3
hObxr/mWhtAcQXjE4VN3oHcOu6s4946+FwTrHfbq85Q5zObNNaZeLghiWuf5
XtTN4ec4YyGqUhAsQn94nlibw9tZTjJM1gqCs5dm+P7uOVx0aoxXs0UQjnx7
IFlSMYePhwZIxXXR7x8zKkptnMOUDrLCbL8g+KwEK2rqzGFr0UoV7R+CYNSu
9p+14xxeuGR+/OW4IPzkeLOT0WIO+yevn1uaFgR5/zzZgutz2GBv6U3FRUFQ
uvXON053DhO+3Iq0otHx95B/ZC03h6fP7Sl4sSkIeXztURGLs7h8ZLK9nVUI
rpePlzzbQbe/vf9sDkEIXvoS9k2/mcVW2R/O2BoIQWLL4ZuZFn+wZpmLTt97
IWCzeV74RWIaM3T9gAovYdixs+lO9+o43nHb1sNo5xb4Jnd78Mvnfjy6HGvM
/UkUJtxSTGVVK/ErzQO3vlWLQtTIlZJr1zC+GtoantcoCtPj3tIJPGVYut8h
+0GHKOQNf9vm2lyCB7axNpzvEwU/1ZCbN8OLcZxrytj2YVFgj/U/09hSjo0r
1JmoY6LwLy8lE3KKsQhHL6FxWhSObAZ7gVoR7jjvpp64KArlh922cWt8wGHJ
vBdd/opC6RCTkjdHKdabyrgNjGIwKxW97Y7ze8x16HikEIcYeHysG+92KsD1
/sM5o3xisGk2OOoalI0DW70ai7eIga39tV+l1ZlYS1L012NpMdjDRJ45KJ+J
GWwLmC9vFQNPsokGsf8t/lygR9q9UwyYt4QqeoZmYp+NX0c294rB5Nx8PE3s
NVbTCTDtOCQGuZ0KLGzEdLwSTXB/rSEGwXtPubAypuOiH2VRd06Igc5tF3LD
txTstutC3kk9+v3u52LN21LxHo+5JonzdHve1qed2sPwdPWTiSlTMcjS+zzz
iPUFzuKXY/1sIQYqy7op+sTz2P5yFTnCTgxkT41ETrv54+1vr2hYuYiB8ooa
sVIqFI8sUC8p3xGDvdmRMjLxDjhFI/oum48YZIbFaRDPPELmIXui+/zFgCEo
9bNIozWS7mnMzwoWgzXdwRkFhedogGzb4hMhBgX2Zsp/18JR7HXGSf1YMdhy
X1vMzP0RMipLZCMniYE98193qsprJMSqunUxTQwqcx3SmtxfoHaDLvT1Hf08
KscwYi4VhSW6mMUWioHb1N4zRygpSG+C09OhTAx6R+s7Gva+QZzKb2LUK+n1
+sb0TEQpEdX6QSFvnRjkvWD/ZSH0Dj1sGmwdbhEDL/dAAx69THRM7O5UAUUM
yl2rFGwgF21aCXE8HBQDjXN9Zl+1c1FFbs424xEx0N5yhcR2OwN5/T2lKf9b
DPgpInq8Qe+Rqvbolb+zYlB4UOq3RFceWo7082peEQNVSr+ryFQRKvwmGZu0
IQZXoxU9AjQ+IFeF4veuLOJQMazR5DtViJTunGs/xi0OyQoLLdeOFaGpyulp
ESFxcJvlN5I0KUUZPI85f4mLg0K5HidbfRGyvbh1RxlRHP4wDz860lSMtqV9
PvZkhzgY1t4riZIpRSOzplev7BYHeyNZ+YYPH1GK+rL3HmVxOMXDEPefUgm6
EhQRx6guDjddzdbdqj8hyS7FD12a4tAZ6Bhad7EC9RHqOt6cEodEplBy/65P
6Lmj1Z+7Z8WB/+fv0vDLFcioeIPrtLE4KItPxnZ2YSTE9EJO+grdvoJOh6VK
OWo7o3z8j7U4qEotk248/IKevmizqHQUBxvr9NDg3Ep0eszxXtRNcQiys1si
J3xB2ve2Zh/3oPt747tf82oVOrZlaGDFVxy0V3IMNiW+II2caM7MR/T4KK9G
xL9UocMnzqhefioOSVGMduBUhVS+sdrxPhOHO9fdn5Jlv6D9dz7H4BfisCPe
8qvuShVS4r1bczOF7q/hYOAPjq9o55s9i1vfisOLUKvCZ8nVaMfRCXJPjjic
D/LIXFCvQbLdKQaPi8Sh9eqF6MKyakS4bup3+KM4TOkfbahyrEGSrEK501/E
gattpW4lsRqJvmwcSqoXh+Bf4k8e0c+FDgZwn2sTB3NaWZBrai3ia1E/zNwj
DqmnxHPGzGsR97Ul+w9D4jD9aUHCt/gr4tjIjrX7KQ5WFJXz0ol1iCXmWq3E
JL1+Uzr+Tfx1iGE3YblpThwcaydS2MPr0HpNz1bfVXHYiHZ+3fe3DlHNwg33
/qPjX3ub3wk1oqWlkw9GWCRg+/34i3mL9WjuKUN+NLcEvDgt72uuU4+mt5V9
1xaSAOUp5fS7Jo1oouImL01cAvLPq/hN/KlDo0Y7j7wjSoBtKf87C8tG9GN6
xPHKDglYHm1ncElrQEMPE17w75aAVL7TO3kYm1CftFH9lwMSQLOKcvP5rwlR
inhWbx2WgMAWYVcn/ibUrvd1+w5NCfhypusml1wTah69Z9R3UgJeHS4OSEhv
QfU+KgEh+hIQ/Lb+0V7mJlQjMltw5IIE4NmPgaJuLagy++2PP5clQCA7lLF/
oBVVHLfgT7WSgCy1Pf29eU2odEhc47yDBAx6JxT+jG5GRbc7nFldJUDl1mGF
Wy2tKJ8nJKHEXQJK8o9thpm2ouy0Y40O9yRg23FKVbNnK8o4skaVeigB+3LH
vDImWlAa5b1ca4gE6PMMDuzWb0Mpzs7G9yMlIOWY0mmDsRaUyLL90f44ej4/
3g4GHWtBcYnf3o8mScDQv3xf14Q2FK38fOT5GwmwAL8s7YE2FNGsL6iTLQGE
ax0KckbtKNSGHdYKJWC+8fB72ZhWFLKOXXLKJCCMFinojdpRYLTHy6uVEtAf
KBWRxtyB/HftaxaskwD/K2Vqh206kG/N77/VLRIgfEV3S1hYB/Iye6XgTpGA
NA02u9LUDuS+dOmi/KAEmPu/4bk13YHcngoHDfwnAeelY8wu1XYgl23NH55O
SAC/pc77QvZO5FjxcFRjVgJiZkeiLh/uRLZGR4XnlyVA3Vnr/X3JDmQ1vaz5
el0CSnff6B+624HMH+a6XmCWBGac9UHFpQNdkrZLZueShB0b/RW8gx3IuIjY
WiYgCXq3L58/5NCJDPX61p3EJEFXaUSJo7sT6Y9GKBIIkqDO0tVj69iJmhVH
KWbbJGEgrdzOMbIT6d465JuwUxJ0TP1emRR0osbyELmBvZJAKd2yr1moE51i
+t4ufkgSUnTdR8WVO1Gtzj4vk6OSQAu2qyNXdKITkQ+3PteShG6mBWT8rBPV
9PU2U3Qk4cS5npgzlA50jKToLmwgCVfe3j/+uq0LVdr5Eg2NJaHl2IMiSbVO
hPI66iPMJCEqSqAv91Qn+ryyza3NShL2t4v7fHvRhY5oeEjxOUjCaqmnX9Tu
LlT+qKlG7wbdX/zBMoehLqTaQnB5ckcStPy6/+ryUVCxiJtYo7ckRIxEsEtt
oaCDZl8rOfwlYeFYra2pMAUVvRZ3PPlYEtJD9hsYdHWh/VNOwoFhknBn+Zqx
gDwF5e/HFTXRkpB1KJN9BFGQkpeQLXOCJJzMm6g//60LZX+5xn8sVRIyjv4X
V+bXhRQ5y0rvv5WE5ctM3T+bu1CWAY8VzpGEOk0jxe8sFCQfd5X733tJODAx
l3X2OQWlDxcWHSmXBNmp7fxSfhS0XY7N3LtSEojfUlUjbSkozcWUvbxWEtiS
JpyXL1CQbHF2PrVZEkbryaqVDBSUsrFpeqhLEuwte6xnn3Qh4onzzO79knBm
Ofvn1y3dKOlpenbRsCQc5zjaldVDQdIU2oXFMUkI8NpyalG2G8VLndncN03H
3/uA/QtPCpKwTslwXZAE/sz8blOXbhSXtXguj0qvP9n74PqfLiS6oL02808S
LvdcbMt6QkHRavFpu1il4GP8CxkZYwoSfjBzxolbClhiQ04hqW4UVQ+rmYJS
cK23+quYNQUJCESnTIhJweBw8/lUkW4UZvJLR44gBUyuY7xP4ymIN/nw4rVt
UpCe5rjX3LwbPR0PTUzbKQVDfZS62IhuxKX034mfe6XgtEY1N9ONbvT4jvIs
+ZAUiDCuygwJdiO2T0FxFkelIPqbJN+3ZQp6yDKomawlBTstEmsboiiIWU9p
6puOFGjfbAjPZu9G/s8eREsbSMGLlThL9Y/diGGQcvSysRRoyrxv/d5OQb6y
8r9emEmBi6zxNp85Clp38I7os5ICsXPl1uXOFORV0Kom5iAFx04dWdWY60Y0
KvnnhRtS8P1Q673jO7qRB9x5Gn1HCm4/Nbcs0+pBK0H1B7u86fk9W/CNHe9G
t9ukhgX9pcBauZ7l5odutCh647HBYylQK33BLMLVg9zMq/aFh0lB/2UZI9ad
PWjuzZbBluj/6/M9uzZMQS4z9g95EqTg/umRSJMCCppRrtitmyoFmb+2Cpe+
6UbOPvy9wW+l6O8nCA3N60aT1Vb363OkoGlK5TXXyW5EjOxzDCuSgvPtZWc+
XuxBRub6F4w+SsElv1PPThK6UbAifeZWSQHD8OeuLY4U9JmqtvNHvRQA0XYt
6Dg93q95IultUuAq57RmrtyN5J9t33TqkYJ9v/tdjkd2oysWCb/3fZMCL/83
Z08q0PmwW5Cy+lMKrnju6Kn9R0F1fwM/f5qUgjmpYyFv6fVdr1vPCJiXgtia
/6xbfbrRvhi3ZzpUKVjjYEpeXKAgW6uJe/ybUpCUNM348WE3Sthjbt/NKg2M
9cfRRdFu1L7eZZjAIw1Lya6a6Yt0PjTqHLUUlgaPvMx98++7kXoslpOTlIZ9
hyIZtMO7kavNQaEZkjQ41h099TKV3o/73q0XyknDe/a3J7mvd6PBf6RfHkrS
kPFfRsOUZTcSaH7eoXFQGlxKJmGMLp94wVPBckQa8ivaDli40vlg65/eeEwa
HluJs4vQ9fMOUCMidKRB/tu2FEzv71EGF29jA2l49N3oi6UPvd9af16TNpGG
gBmBhne5FKSfYGowcoUen5KnYeh/FBRg33Y4w0YanmddlT5n241KD57Y7uIk
DSutmQe2ttLrzfSRX9lNGmKkF6xN6P0m2773L81DGkw0C9KSb1OQycv0UexH
13/ecOUNhYKeOkq3PQqUhp0SrKmEg93oy6GoMt1QaSjU/VtbupuCVlg40gSj
6XiKD7UgdgpS7LwX1hsvDUOWTE1YiIIskhc9XqZKA1/+Q02GYAqKcXawts6g
n6tXUHqYKKhRbfiMQp40vNB4eKOHHs8m2wXV2Q/SYHYm+GoGHV9lSqPshwr6
+Y+3cbmPu5BDKvB6V0uDbc1/OzdPdqEkl+JVaJSGUnLixmU6v7vUd42wddDz
Wch6ukW9C3Fwvmpu7pUGrvz9WlzSFHS0R6wk6rs0TKVoslsGdyG316GpF8ek
wZfj8JYmFwrKcGV+SpiWhlyRcxEN+V3o21FP99EFafh1TeyPEP1/LcQ9a5FF
kwbtg4rbg9a60Kk+G11XBhlwfhTwyv5XF7r3ZuCgCrsM8OXIVu462oUK3QxI
67wysMOURcDXpxP9QrVcVSIyMH0xyCyCbk+a98hykJQMXKD5DJfLdaFzAwXD
Z2RloPX+mYCE3k4U+FauUVhBBpq36j79e6oLfbz9sqh/jwyUdblNLu7tRHOa
wsnJKjLwWMxwRvRHJ9rOHxx87agMnHA6sVq4qwtdGvp3S/G4DJhP7rpjeaET
hWfeNp8/LQPHBxq2v/enz1v3yVMl52SAIbx1vFejE9G0LA7cuygD7z5f9LQu
7ERKgj0yWldlgCncjVL9pwONh477x1yTAfdwUoSQUyd6ybX665eTDFgf6Vsi
DXcgoyD2M4fdZEDohTNTKX1f4WERL3zqQc//yp4nukMdqOa+vNiwrwxUxu43
rA7qQN4bqj77HslAZnTE68L7nWi/l85/AU9kINzMYijjageaXDHV7omUgZfp
Jv+FbLSjV7cc38nHycDwfHjghZoOZDrnJeCdJAOBTHs2fE53IIHrT+60pMlA
5GXBjt2NHaj+d8IA8Z0MXGYcaHlJ38/8bLORW4EM5AacdMmY7UAqPyvSakpk
YBfhg2LqUjv6c7WFU+yzDPSu3gz0sW9Hb4a+uTjUyICmxfjb7X3tyMz0T9fH
Rnq+ubMfeD+1I5Gef6p8HTJg8mpn/6/wdtRkyJ9k0UvHayGX3MPYjvzbiMzv
v8mAyv6ORMLndnRYb68966gMcFT4+Z0Sakfz9dBiMikDaTZG5Wrv2lHGiXP7
s+ZkwNeSaPfjQyuyqLKMXV+RgafCDxw4BdqQOHJb19+QAUPsX1Ma2oraPvpb
pjIT4CePXs3CHvo+qvqsdpGTAEVLnjc78lqRxofXitoCBGDYlKHFpbWglX1F
EXGiBLh0OEBJitaCcnJrlielCbDYuyA+c7AN2Sh2Xzq6lQDnZOp6mkxakXTG
GA5XIAAr7jTICGhBlG0r20b2EIDd5cipEadm9CSVLURZhQAKL70fUfWb0TGC
2GzgEQJsflcS+sTQgv7Gyxn1HyNAioGM+AuxFlQoplqmqEOAO8faqYlbmpBD
9CmC71kC9G4/JNj0pAWRBE0D2i8QIFD+5LGmI82oL9RhQtaMAJopf3nz9jaj
CC6vM3esCHB8xPXDcEsjOhkUUlhnT4AfrD17AlSa0D/mBDHJGwTwFT9i/fd0
Eyq+/87H+Q4B9B3JkTvJTej6xsf/PnsTQDZe+ndWdD3a5tWsLehPAP8PGXMx
o/VoaGXonfVjAiw5Zm5zHmlEz27NCBSHEWCac4Jr2bMBnZ7buMMRQwCuhylT
BcoNiOk63+ClBALIbHI+177XiMp+EyAnlQBBWsd3EvTrkKvtnjebbwlgn2Yb
nqjZgOR/Ii7DXAIc0bxV9UqkHg1fNbiRVkSAB74V9oe/NaDnQxaUlXICPGLO
y2CJqkf6pjfVdL4QICIyzTF+sRax9TxISqgjQLZdQDaVpx59Moxi/tNCgLHV
fRcHj9bS94NX9kAhQPjwK1F/nzq0S+99S9QAAa71dY5/kvmKRuur94/9IMDv
yj/cjdFfUcIJSuyhXwS4O9509NL8V2RYNboePEMAy9bAuJ+r1YgLLVsOLRLg
bSt/1WBWDfLQlOco/kuA1PRyssp0FRrXupwbzkiEpBcNlHnZGmSkHWbkwEGE
xbgBrcOuX1DVqS9/j/ET4YZZ0/ZDqBrt1V1KkRYlQpOY0S23czUo6YzcyRVp
ImwqqDP2KFQhHoNLM21biTB15D/7C51fkJdh6LPMnURoPOrKLfiqEk0YVaoF
7COC2lDAY5HSL8jYZHHYTJUIW51O941aYlRjuiNQBRHhyeBRfJG9Gu03M90l
oE2E1ePhsYUJn1GK+dPO33pEiOvX/V1a+xnxWWKP6vNEgIeVUzn9GPlYLxBe
XiLC2enjO+vYKtHUte1f3S2JwP5URkb732d0yf6ik4E9EThcXD/2ylagescn
gjtvEMH9fjAWYyhHKtc/lzC7E6FomTFbObcUpd2Yv/LNhwjcVpMXinzKkZDb
NpaSACK4fn3BH6RUiu7fNsmKCCGC3vWU3xEGH9Ef9xADx0gilARfz/2WXILM
PD+taMUR4U7XtYjwolLU6D2XKJNMx4c05KW5VIRUfbdqrb4hQqDr661sEmUo
/b7x7/ZsIoRfevf2slIxEgkIDs96TwQBjrvp/9w+IP9HFQcflhPBcqhg20h5
EZoLmh288oUIStXdO+zq85F5iKz/oXoiDIHO297RfNT89IK8YBsROivc2+85
5aKTM5dWZS+QQDM5bH/4fDpOEgno8rtIAt/2eO9pibd4Sf1d3tBlEjzM9iCd
f/wWn7bueqJ2lQTaRs1fxDjTcErImt1zKxLUWlCCVQ9m45WCrccXr5GAOJAm
nCX0Cp/p1yUZOJBgVlRD5p7DW5zGcHs925kET14bc1Z6vsN/5RL7OF1JYJe5
4+lwSg42OFtTZHuLBOtH1l3vieThdPfpiGp3EmjIUjzVigrx+kuR6yQvEuRa
vr4q45KHz389onPvHgkaDB7vOT+cj7OmbbYP3CdBaNP+JJxbgBlEQhkPPSTB
3mr96WuDRdhY/cO3Z0EkyL7zb7+OQjHOtvpWNhdCAvkx2a2vt73HTCGsz8+E
keDTkHImWeo9vliw2y0rkgRaGUMtXW7FOLfvgj57DAm8X/BLlez4gFkZfHfa
xJEgUGHXuspkOTaTS2f7kkACLpeWu4HsJbhQv3VEJpkEL9PEWha0P2IO95XP
Xq9IsDHsc2s+7CM2f0lI6H1DAsdPr7nE9nzERTXad5UzSdB1NObRM9+PmGva
5XxkNgk+Fg69Muf8jC2EY/f8ySMB08/1U3/PfMYlhzG37nsSXHiGukWXKzGf
1a9fb4tJoLKUmaKvVoltgvlrWMpJwFYvcylV4gsuzz+UYvmJBCNOZ5tS+iqx
QN9Vn8+VJLhE+o5lJyux7WbQRakaEthcCrj9erAKV+zIV/aoI8FaVK6jt1w1
FtLvE+huJIHMktatr/LV2OEOw8y+VhKki7cFlCpW48pE+YawDhIcTRuLI92q
wqI1Bm+mKCS4L5/XFZdXhZ2nPB6c6iNBnfDzGOUntbhKKPXKm0ESXF1MsR86
UYPFDzeoMQ2T4LujHuaKrcEulvNbro6QQHWif3fAUi2ueSyx8HGMzo8Fv+/C
HLVYKl+zVfw3CY5hdZOTSnXYrdch6840CQKqHzcIx9Xi+n+RgZ2zJFCvcnW8
aViHCTvKrfYskqBTpX+m3roB3z4zovF0hQT7+3TSVZ/X4cbbXFK/aSQ4V5i0
Y79zPSYl7l89sUGCaZQZsofQgN2rL3W9YiCDpmXzsdNv6nHLpH/eJjMZ+hQF
2w4I1ONtQu+emLGTYd30NHnwViP2UuuyK+MiQ9xHq90SIw243WJNS5SPDM9+
vWzhvNCIdzzeSrolSAaON4wv9483YZ883fU2ETKM+V2WMqtuxJ09t/p2iZNB
TF3/1g2xZiz/L6EoWIoMluM27hFGzdhve03EOIEMHwrsdA9lNeEevWlnLVky
GF1TkTBzb8a7bovopGwnwxeh3zm+uA37JxzZviFPBtUaa79JtjbcV2XDeGkX
Xb/+wIlF9XY8pzkgeW8PGTZ5H+6sKWrD7F/OKqfsJ0Mk/3WbppttmABfz1Qf
JMOe+lhO9KsNq+DDduOqZJC3u33/+Z52rK+Rf5/zCBk+f/30JGalDV/7tD1+
FyJD1e/qzXXnduxzJOH92WNkyNB/6PWfXzuO/ijQ4naCDO+P3VILftKBsw8H
jsecIsMjhV1i/KQOXF22tlmqS4aVFfOST2sdeED1psSQPhnuyL2RMDjegRdK
xvdvniPDRNDvHO8rHZjzkJme7AUybPnnvbnO1IlJxR3XTlwkQ9KO5BTv8A6s
evCkn/1lMuQ2a5xT8O3AZ4sq4p6Yk0H0ZW/4IaFObHtgf2GuJR3fGaaQBNSJ
fQvfNnXYkIFBW0JZw78Tx+yTGVuyI4PX8+sdb5s6cXZ+1D8xJzIwftoRrRnZ
iWv2cIiru9Drd2Wvn29LJx7MvbfP/CYZqFx/yMYKXXhh9+LpB7fJcN/3TGR9
WRfmyrG3SbtLhpJku1jd5S4su+v7vTovMoiMu7kdjKVgtXfnYyfvkaGJoG89
xkbBBjsb8nkfkKEg6iuH8gkKts/UaNz7kAyjuwMP8yZS8H35op/ng8iw8xzZ
u3aqG8e+VdhwDyGDzFOGC0Im3Th3R7JofCgZBCadBwxOUXDtG5G9nyLI4J3r
Kv5hiIK/bwvR+fGMDEfOdwkx7+rGy683rZhj6ef7FshcEj2YZ+sdnx3xZJhV
Fpo1ce3B215Nxui8JIPapqvZI5MefIRskeecQoazh3QPjx/pwedTuuvDX5Ph
+7WuXyVverAjUXekMJ2ef8b2YtXgHuyfVLnWnUmG44GM5jq/unG8jMoWWjbd
Puky6dyjXlyQ+E5JOp/eX4Ul10JzenC9FPkUek+GtyoH/gmu9uAf8c8trYrJ
UDcYlqM714upEjzej8rI4E7M/+6LezH/iwfRGRVkCPgUKTwQ2Yt3iK/mNGEy
LJg8cKP96sMasc51f6rIcGqjLJKhrRcbi478EKwlg1Xk0MlHw734eozJX+UG
MrxUXHm4p6cPPxRpEb7YTIZXO2UpEQt9OPHZsd3ebWSw7smj+vv34yKhUu2k
TjJ8Iqc1bNHox02Ruy2+dJOh61Ys1xnTfjwi8NpztI8Mi0TGaIakPvw3XPwZ
+xC9fi8Ex6WOD2Ah/rD/UVzd8Vi+X1hfFVmplELGu7yDd6TQfE6iJEUqFJkN
iYiUMlNUQioiFBmlSJKS1W1FiOzxGu+SUISoFPk9vz/vz7mfM67rOufcTzad
pwFZ9sVXNs11IVqUePVeoQaou0u9dGF0I5C9yPP8rAFlwmvH77t2I+uIsd93
hzSAFlKo+WslF3lIH1te8FUDdBs/zo+94KKw8G4Gd0wD1mfzCeXhXPRwiZnR
3IQGRFoO2kU1c9Hr61V26tMacLNw5Q1vGS7KNKlffe23BnxoMsj4vK0HJci0
tIz+1YD8RvW/Kl+4KLKxK+LgvAZMfI5pSqrgouBo3s7i/wiwacZudf2NHuRt
MShGWEwAU+Xcdv20HnRCYbTo+hIClJ2Jbvw0yEWHO36c+y5DgJIHrvvfr+1F
pvF/mJbyBNAd1X1PbOtF2JEFwyUrCMBQ60sVf9SL1qlIphEVCRCkcv/Tytpe
ROqXOxquRAB3n0JrVbdepJiyUnFiLQEUYxqczbE+JOWk0mylQYCrpfSlR4x7
0SyRePMdiQCD4x3LNpzvRd8/04zIVAIwDx78vdaxFwmfsOdvMgiws3x+8b/N
faj9lF7hJJMATy1Sl0RT+tAHxjbvw+sI0KFhNL2kuQ8VjRpql20gQNylhrlM
zz70/MWeL5SNBDAYv7jj9nAfSjlr8ShyC34eKh5XU+5Hd3QO20xhBNgy/lx8
9Uw/Cp22X2mzgwBZzgarFIf6kW/BiU/lOwlAXFAncO7pQ6cvut+gmhDgtGgn
d6q+D9ltPrfj1l4CkKTjineJ9SPzuUtz0+YEiHCe9pW5w0M70OUC24MEMP7V
e6x/sB/pXr5+ttKKACyxLzagyEfUHbcYdBsCHAi6ctPzIA8pL7r3OdqOAPZm
fIOKVh6Sq0lK/uVIgGfCp9+0d/DQghtph+2OE2BBvsqpUR0+mjJ5tuK9CwGu
dF4lLZbho0GZlw0MNwI80F8nWH6Lh7obC67d8cDrC9c1v+PMQx+j322f8SLA
qvSwSAkaH72zeP/X/jwBCLfelH7Dzy8VPr6uvkiAZd/vmE9Y8FF6R4uHdgAB
osbqxF+k8VFcfDctJpgAEn8c9u/G8ws/whf9uYLbTdr/m33KR/4qXx44XiMA
W6qR/2UnH3n0j1p9CCeAVYze0zMP+MgpZWoZK4oAwvt7jyRN8dFBp7/1sbcJ
4Opo6WnUz0e7SP+FzcbgejzvGLamk482DUqCczwB5Ln1IWoMAdLOXPqnNpEA
mDEvOY8qQOquq/LZyQT4fErjW+g3PlqutfZMXCoBzNrim8+vEaBFY0TqvwwC
IPg3KT3ER79f0IXHnhJgpcaxE6Uf+GjkLCepPpsAyWr+8TseCVCfjr7lulyc
H5s/sj62AtQ0vU3+/isCfC3QCsfWC1BlgVHd/BsCBJeuu7RFXoDeXDS9eqKI
AEsYm8kuX/koc/OBbQ2lBJC2XWygfFaAEucO/9YpJ0DzHU6MZYoARSGHvIQq
XM/Snh7VeP7Bl0+6LfhAgIYtWdez2wTIe8cZiks9AU5Oyyxd7yRAJxb58Bsb
cfwOT9UEnRAgJbXazr/NBLAeFojdxc+N+ms/Udtxvsq8pq/cEaAQi7PVh7oI
YCg/YqeOx9d1e18a0kOAaJv1pUq/BGgkdM3rF/0E4CE7Y3sNIXqY7J7dKyBA
gW/I5EcZIbIoLE9b8pkAdja9IRcYQrS4dWWi7hCeT0je3H+Lhajo26k7zl8J
EKMeeTP3iBCdWfzuRvQYAfpbfRIf7RUigvryy6UTeD0b/WNpIEQdG0/4jkwR
IG0n+fGJYgEKP1DkofibAC805Np6DgvRNne5k4Z/CfBFkxo7UChEk2FOdmf/
EaAmMuhrWqAQZaS8OfRwARFGHhZZPg8QIusiqb31C4mwYvfrI+VPhUimzc7w
twQRylyxmN0zAlQ2mreZLE2EWl2PZSePCtE5CQkdCzki+MVPJMm4CxFVw4Ye
tIwIZvJXPXTPCVHvphca2QpEiN760zJHXYSiD4qv6VYkQouaq8PzFSJkeMZK
frEyEXKcorrNhoXo97UsCR1VIjjGjkblxwpR9qP5f/YaRFi70V/i7Hchcig+
8DOCRISrG0wi6r4KkUL7k9FCTSI8I3/zWBQlRB/G/g4M0onwwdouWVckRP6S
5r0rmERQD3s48SFLiNiE9FbgEKHL/m2bDU2EBjb/rnNfT4S4zZN6aetEKP6Q
aUWCHhFuPHN9ac0XIlOPlMKaTUQI3+wpWFkuRGI3pnKnthLBcDLXeUgoRPmp
xpka24lwIkFCQg7P36UkKXmfIRHG8sIG96wSIZWO8Xt+u4jg9MS6paVAiJq+
G0ZlmhDBynCkf7+tCF1dcj+0fS+e73W7pXlHRUifOOr/334i/Gto7PynJkLf
tmw/xzpIBCyAFLBBVoRSLGNP21oRIStfKfnxMhE66DnsdOMIESRPBbkH1gqR
ZPjWI2+OEuHRKXKqjo0IlaTd3i9yIMK818+erP9EyLP0s7H8MSKomCYEvvES
IVLnRth6kgipLzuftx4Toa7xSD1XV5yvjqeqfzaIUISUkBnnToQad1qC51MR
ApIupcqTCNmBwuNLr4vQ1NbwtRPeRJD4cYkRs1GEMq36FVQv4PF2rz5lhedv
e3adzJ5LRCDTsyOOJoqQ/M0wcd8AIngQFrJvbhWhqnTun/RgnJ8HlYYvlEXI
9x1zsvkKEYRahi47nomQVlfI8L8wIkxww84ckBch/kQHnxFOhHill10eRSIU
I83oso4kwuK3AWcHg0XImBz0KTSaCBcdnsTcxP3NbmutzrtLhIfN5y7ozAlR
rrXmO949IhRq3frjcFqEnL38XsskEOGne0k3b5sI6a7rf017gPtfsuz3psci
JDUJb3amEOHKDu2PUtUi1Pcy7Y1zGhEooir3r/dEKPfs4oLgx0R4U72wunKt
CF3hnCp48JQIem+Dg5dZi5DlRH1BUTbur/wopdxAhGgvmW87XxChvLwsN3Ef
np/n7bdTeUR4bcdX/43j84k99XbZGyJoentplTqJUOq4ZSGzkAieD6uvrT4g
QudzCwv3lBBhGHT/mPqJ0G5PlSIXRIRI5vP25nRcb+ygotAKIrikFTSWxInQ
+HdBUep7XH8gyVrYI0KVLwyL0Qccr7oR1zZcH/c8nhT31hNh8GrChTUaInSK
JVUy00iExIFJNkNGhLZ8dytZ1YLz+bexq+sizt+LTyU67UT4Tq+mJ4iLkOjM
ulLzLiKYW+7QeI7n84YZW+reQ4QY7zFv479CFD72qzS8nwgfP8hvM68QoqM5
R949ERDBUmrezdpEhNhnSt9VDeD1FiZMzh0RIXGmOhJ8weeBbzUmhfdHx2gI
+jeC8zfonml7WISePv+MlMeIsOeI6dnEEyLk725cpj9BBOsDslE/d4uQmXZW
2aEpIhQ127/Z/xKfl6Oy5V6/iHCLv6mQbilCP7M9y2/9IYJzcFRQDYhQrVtr
efYcEQ52qPffrRSiJC3diloxElQwr61UwPXs+S2+YlCcBDW6VlGWuUK0I/tv
hbgECfofyw0e/C1Eq9zsKtWlSPBJ2uBZEt5fw4zyyq2yJNj77p3XCF5/yVdi
1RF5EtjvT7z1eFyIbmWFVV1YQQKThRLBW4uFyOn0cFXMKhKUtWtuc20Xog0M
0/cv15BAvbb8YJyOCEl+zXnfqEKCxcFPb371FKHeZ8uqv6qR4PCTIlsTXRF6
4XquWpJIgjWffaa34PoLoXdWkykk2JnTp1nTI0SWIxtrDGgkcPP85lVWJ0S0
Z0k19lokKP15Zf81JESzp+Zr/FkkuBmUK//vrhB9ojl9uL8Oj+/fJHNwSohS
h6s+vNlAgnxf7YdL8frPP9WsbdUngVXhkk2SHUK0+1R47fhmEhzPr+efvChE
KrTRWlmMBI37fmUdfCxE40NmdXQDElgrPPVcYCRElZl5dbuMSHDbzeKM8nsh
uueysv6YMQmq0up3luHz8xTVt/7yHhL4j6Y3rIgXoi1D3PqH+0hwaIFyxqmb
QrQ0c+vH4v0kmKIfbLW5L0TCkykfuw6SoPVd3WnSWSF6rSneMG1FgmfKfj4L
8P15/cvxhuU2JHAJWaF9S1qIbJ98aGDZkWD74Mybq/lCxDrJaDR1JEFef8TV
9+ZC1H9KzeP5MRK0bBstk90gRBFuK+TlXEjwu9j55GiRAG3ykHh55jQJLl4P
GnrVKkDDZ//u/3SGBKeVv45+qxWg+HPfJ1leJNDdvKLEyFiIdl4Q3Y32IQFH
7tzSPGUhmrrYuX7ClwTFyhuiR8oEKM2/vn2/P87P4/dics0CZBGEzucFkeBc
1thEy5QAiYW8UlxxhQSUZgVJ/XQByrn65K13GAkUTjR/M+sWoKPXEg+33SBB
os71Yyu24/s6/Naf9ZE4HhMbS23xfV0UcSUxNpoENoeGPxrcEyCXWxe2/LxL
AsWZ08ZuFQKkeOd0n2UcCU71dV2l4vGrY+wDCxJIEHzbf8QnV4DOxR1QW/0Q
//5vveZcsgAREnaV+T4iAaMlVinMQ4CakzY7dqeTADJnjoMZ/t5KZv23KZME
Bjc2y/98LEDMVGJaQhYJeiRb8vP9BKg3XdHwbw4JtNwM1BrkBOjmE+nPNnm4
PWi7bGAEju+z+dCS1yRIF/J1EvD35lD2D8raQhLs/nl/WW0lH9178aUmoIQE
jj/deElnBMgor8elH5Fgk/FzXgFRgKbyPy3BKkmwKN15zUACH6UWVD5LribB
Mtrr+g8dfGReVLBHrA7vt7dYybNqPpovyfrm0IDjx5acdUnnoxyUHFneRIIo
pyOxzQF8ZFtxl0low/mQT89flMxHUu+vfQrpxPWufrBjTTgfFdb4eYq4OH4v
qxyCV/ORS53HMsN+nP/84buDuP9VDc556QISCHtK1oaE8FHVJ6sDiz6TgF3t
V65P4CPvlj1Tx4dIsLpo0vaYMh8R2rHY6q8k0Pnt9aBQnY+aOnV0Nb+TgMeS
exXoz0eBXM3Oa5MkmAiR2Nb3kIe0+5R9h6Zxfa3cPs4Z4qFe3tI1u2dIIFkr
6TbN5qNwoXjR01kSqF3MU4FtfKT/+dcRKTEyZMaJ1obg/y9fvnz96ypOhrHw
z2H5dv3o3ggvqX4xGVI9M+OOMHnIcLR1q5YUGaxCPdKYx3ho8ntNf4QsGf7a
Ly5+ReahR5PFQaPyZMh6+poTqslD5tMv1PcpkOHS9MknhNl+9O9XWnmOIhm+
rr4R4GLej7L/xDktVSZD3WOKhm5LP7KZuynuqUoG0zXD34/Q+5GUWHB6kwYZ
nh3cnBw11ofe/nfOiEMmg791x+4DlX34e91l8DaVDF2OcnYa9n1opaTttUkG
GVb4PY3ckNuHqqTMqQdYZChL2XLxdWov8pI1rH21jgwGKZFK6536kLq8vquC
Lhl2GXYayTH70KflWtI+G8mQ+O/+ihbzXvy97D6cuIUMCm1ZCl4mvSinJqem
AsPjZ924nLKiD6kSxjOGDcgQvcY7LVSvF0X5c67K7ySDoWrrFWJID/rX4eWk
t5sM3VvvxURE9CJ3Tj7YmZLhfZjbxpbvXNR7c1o11IwMF5131g6m9CDTQd25
LAsyFDLea10s7UEl4NvTcogMX15FfXq1pwdpJRYWzliTYXJQhVpM56Kk6T9x
6rZkiA8cks1v4SJp8y3nd9mTYR4zdojK6EGXngUcPONEhpHGp0N9I1w0shCt
iz1OBg9XtG23LxcdsRdbVuJCBtIJZ5uQgG5UV7j9u/A0Gcwi3Vj5O7hok8KV
hiUeZGi+WCt2tb0bPTtTlcX2IgPzR2fBZptupFS7KNzKhwxRgz5b/1vSjW4Q
d7kE+pKBaqT+S0O6G/0OuL4zw48MofRRd4OFXOTSVUv6GEgGgXn3AXZuN+pa
Jy3+4zIZfFataveo7kLGkaaCNaFk2LPGdSCrogu9/RKJ4DoZjsktX+va1YU0
DT49OHmTDEXecj6RgV3oXpK8f1QUGf5TbLx7fFE3Wvxr/5HXt8kgr3mYeKyl
E53ff1e/N4YMGiZO0eUvu9BgVtsq8XgyGKlbNTuyupDl4lXTtEQy1J4CRsBk
J3rvYNVq/hDP/+syiTVPO9H64viXFx6RYbnYFeVr8Z0ofSX31sN0MlBslIdl
HDqRgqfymfdPcD7+Low7s70TXa2zNf32DPd/+MnXvN8daIr0kL4ihwwNu/+o
lAx1IOcgnuSml3h/nUgTXDjVgVq61b845JPhHn+h84O+dmSw3un9tQIyXJ9+
NF843IbyotLScorI8FZ7Wtl6bzsiDA9cbi8lg+031+v2a9rRnR0Uh9ky/P4u
/Yb+V+1owcOT24hVZAjY0fFw36E25Pk7U8WkhgzusXvHWbLtiG8x8sezjgwV
t3+EvS5oR+bPGd1xDWQofeO85I9qGyqTcC9410SGM9omPxI3tSG2U07s51Yy
SLBV/x6KbEMpJd+9ZTrJMCQu+Vxysg3JK3IsdLhk0PFTNO2ra0VBZ73YR/rI
cO4S76w5akVj9a/kLvPx+r/PPThPaEN2lOlvT0S4ftoaDAcutaDGYN36xkEy
hNv2KQ5fbEHbei48nR7G48ss3jJo0opyNhReUxklw/3fKw9peLeitdF/ju8Y
J4Od58CKcMsWFDGy2dD1Bxm8DOIjN3Ba0KxhAOH2T1wv+eV/aHktyC35ndjb
GTIEf70/zXNuQb0z8/39s2TI9nj07RS7BZke3F66SIwCdT+v1hbPN6HinJBE
LXEKFKX7/cbCmtFi00NKcYspkOMYOSY0akb7hzXvL5CiwPffJ5c2XmxGSWF/
FN1kKaCUHakznt6EvhAb7nXIU2DPLz8Cf1cTWleevHK7AgWkY+8/M/NsQgF2
XjFZihTgpyUWaxV8Qh/+Gq5YpUwB372KQXVmjWjFfcU7waoUWPjSy8j5vyZk
pzsi/1WDApplOT/T9RrQ09aSW4fIFHhl5KA49qIBTXnekiujUuD8p9D6JsmP
CJNziqRrUSCMQD0f6tWAwrPWy8SyKOB5kqF0yqoBtRtL3JxfR4H8M08rrC/W
I/XB7iWuuhSQG4y1ULz9EZ2+kn29bSMFEksGimYGP6I36kES2FYKXLaq0/a0
rEcL3u0PewoU2Oq3sX4wrg6Z2pAWKRhS4Mm7053rSupQ3O+fVwJ3USC1hrnv
T9wHJIyt/W/YhAL/KrSKtK3qkLZO0uUD+ygQouZh0BdUh3ybzoi920+BYot/
79GBWlTpvj2IeogC+8qnU6hmH5CctMK/O9YUiIv96TnvWYMOZw76z9lQgBbx
2WVgbQ1KNyr8e9KeAhpNyy81U9+j78Kbl1qcKBC4A7V3vq1Gm4LtZracoEA2
b+u7n9mVKHQtx/fJKQpsWt5KFl9djZqKxH8tc6fAI53+8ONu1UjZusPH35MC
60/n9H6IL0cnpjOnBr1xPIuv2C3fXIFe3vHz3n+BAp1WyXPqZhVolrVvsvgS
zmcgMtvyoxLtalA/SwmkAEmk0cuSKkd3XH98j75MAf12sZel2uWoT6L6zN+r
FIgKc9keiyoQNSN+9Ph1Cph996/b+/Ed8jY47dZ0E8dn7u3eTT/L0Dve1q+b
blFAlVac/d9thJYEyLtm3KFAa87HWd6iUnRQSTS09B4Fdq5znOi2LUbJBa9P
XrpPgdiGNq0NwaVo5OD1wYEkCrR0Lfffr1uMNkweOW6WQoEvVbGP1ZsKUPAt
7YHCNAosWd3A3n2xENVriTmTnlCAmkYIyrlRgFbVtQiinlHgje54S69ZMXI8
meEw85wCNmTznSn81yh7oS/P+SUFzmTYX5dMfot+PTKxa8ynQK3hwzNntPOR
Aba2T/8tBcSjKn4PqL1Gkb3fbdKKcTtzO6Mv4w3quljBlUUUqNz76fnei3mI
qBh72LcC11cl6UO1bB46k3+yS/ge70e1pJIexSxUuH+T1d5a/H4/dnPzqjy0
8LtMR8FHClhtfDa8WOIxMovgHSQ0UYCXfDjyb/ZTlEDLa41opcBnT4ry4YZ0
9Ln6qsWvDgo8rjCi/NNMR+xj+B7gUsD5RsAxHcfHyG8B3fxjHwW0IxQOK0Y8
QFK9l4zP5GvCuLju29C4Gkz3wlPZWwWa4GvOmFFMqsUcl3e1vCjShM6u76Md
ObVYxPPF8U2lmrDr9L6vYrvrsLfGG45OlGmC/on1dpqTtdiAyJmwvEoThk6I
aWeF1mNLg+58WVejCZRX3sMMv3psk1J59oE6TfhXFLokb6oOO/H6+9lzDZoQ
sNBH8cLbeuyOuapebJMmVJ0r9F5s3oCVfjWdfd2qCUsdqNY10h+xoTC/8o4O
TZDfp7XeqbsBUyA8C/vVjZ9THe2eWTdiWGnXntV9mtAjbeJpz/2IuVpLLNvI
1wStKN68r20jdu/Hho7DIk34NPy01FejCSuPOpZ4aVATAv00JQ8fasK+0e46
JA5rgsC1ZsNJxSZs9ftycsk3vJ53/6q+3GnEdjiMj/R+14S7aLE/80ATduav
au7cpCbkumHUwO5PWMK9vT6qPzUh2Hid4OuTJuw9x38TNqMJP71l7Z84N2Hj
H5/N289qgssaH0WOSjOm4tJdFTyvCUswsXCvl02Ysbhk+KP/qLBO4uQno7/N
mPdDXbOKRVS4oJr8ixDXjD3ceFxBJEmFEG/Tb+pKzVhd291ucRkq1JTzGhZ5
tmA/PSoekpZSIclx+kzFiRZMQ3rC2Wg5FQo2z/wof9yMmT5Wo51YSYUEtR7+
lWUtmO/2fWNhq6mgearHNHiiBUvv9X/1RJkKZr9qVTIFzdinC1m+H1SpMH4m
1zjDthX7s5y7dViDCvvPrzHxNm/FKDmS4lJkKiwc2Fp3v7gF279b7wOdSoXh
K6HWt/+1Yv4DxyP3MKhAjmV+ePG8FcsMirFwY1LhQ1riTL9JG9aqVKkYyaGC
TuVS5Zd2bdi/1xO9z9dTQWW//fXZ3W0Yfb96aqMeXt+bY5MZr1qxQ9/2nfy+
iQp2Ca+apOTbsOBrAVry26jwKOlEngSxHcsmZE+wt1Nh7we9d9ML27HOUu6b
/Yb4ec2DyV6rduy/w0v8vXZRIWr4lNbG7DaMOaW3/a4JFUSxe/3uFXZgR26d
WJy/lwoL7osIQxkdWCg9tr7NHM/364/FCls6sNz3ldHTB6ggTz1/0imrHet1
mDy0yooKzkv9gjI72zHJWXVlvSNUEJ+WOlop3YnpxJnxrY7i+NNs5Ubw7+3W
BWb4OlDB55K1mv1YBxbekO163xmvp2Kjo9KFTuyNSw+r6AQVSItCTUJKOjCB
uNQ09xSOp3Epyg3oxGSS9Yv+ulEhV7xD/uOTDkx/08kgFU/c36kDck8edWLO
7bGGW72pcDqyv+W4fycW5Vm1xO48FXZq3SxnZXZiRdI/GgMvUuFop1Zc3bNO
7PNjjZhkfypcqs9Qs1jUhX27KpgRD6ZCpZzmltytXdik0yN7lytUuD2/ZIAe
3onNgOP7j2FU2KcfYCb8rxsTU9NgcMKpcL72sfXa/k5s8Rw/OjaSCmEJGwyu
anRjsj0pP2eiqXDYKSnB6EY3plDoYGsXQwXHxP1PBNLdmFKcekVFHBUunrH4
HIzbNXz4mpqJVHiz5iajL5yLUQ+kRN58SIWBxqiOu0lcjMlx+PH9ERUWEbnr
6c+7sQ1L1Q8fzKCCQ1zldFEEF9syynv3NpMKiShaQ127GzOoTyatzabCyNkr
1yVJXGz3U/vwyy+oED0rs/LpFy5mfk1t/HMeFZ7f0Hn290APZnWcd8jkDRWk
ju68vn+ai9ntSC7OKaTCZ7G2Swfie7BjGvYaK0qpEOhccY1/tQc7Pa967UIZ
FdR+nj/47iUX8+rr/9ZTSQWBeOmFxm1czLf4oQXUUEHp6TWJt1o9WNB9u7fp
dVT4+HyB6rcrvVjYBVXVJY1UuGsnu7dK2INFHuq/4t5MBY0BxTULEnqwGJ2H
w81tVOBvC9M7/rsXS1hmZ6bbRQVa7s4fSc292KPva18n9OD97sR6pBLTg2U2
9CnN91PhfV3g+kNHerGcrAfBzkIqWMgXp8kZ9mKvbxwdrPlMBZPaTqZTWw9W
cnKtqdYwnu/PZ3V3wnqxSqO+l9HfqLDHITYyqagXqyM+UJz+ToW2F70v+mJ6
saYFRwMO/6DCjJLifHp4H9bJUxGV/qRCsM3bs2ZNfVh/aa8x4Q8VJi943ehd
0I8NJCblhM1RIcKz5ZyeQh/29aKtwlcxGnywY918kN6HTVqpXDJbSIPJ+Cit
Z/n92MyGXt4rCRrsGkznVln3YWIKSUarpWng2RU6a53ahy2etMnyl6OB8cqE
ljW3+jDZJuVlgmU0SJx+4S9T0Y8p5PScN1pJAzdPrS2x5X2YUkRi79PVNJgn
f01/mN2PabjaGMip0KC4SzTXtacfoxorZ3qp0SBw9Y15vUs8jEXpke0k0KD1
nM3AZ1keprsw0XszhQbPt9wfl2vhYVuER7qTaTQYl7OYlVDiYzvKlLCF2jQY
VVK1wor6MZOH3HQXNg2kli2gMJbxMXP/BKkGHRo8fJNxpMCJh1kdOeLJ0aPB
AgWr3EUb+JidvlJH7CYaSPeO1bp19mPHV3E3/9lKA80XJc+/efAwt6n7j+y2
00DDxfid0Qse5tVyWKLSkAZQYt3e2MTDLuaucdc0psF+i5SXDVv5WHBUd8vN
PTSoUU1JNRPysDC3+/rj+2iwU9Xcd90UD4s0OfzwoAUN9L74BOco87EY6pqF
hYdoMFwrGaG6kY/Z2lGeiKxpwF3n9zNFh4+RYnRM5GxpwLCYvflgGx/7Vguj
+va4XVK7xA+vP39+b7SzE46n1dadJbh//w02OlHHaeAgmZl72pePGZ526Xjr
QoOzF7ysEvF6ZR75XBSdpsHvmsZnXbi9rSNERc6DBhEDz25ZP+FjSTLRSN+L
Bua99xIs/PjYMYMHTs4+NGgaaLv9MJiPafk+WxTlS4Nl7aYkt/t8bOp5QeZb
PxoQLKQYGxz5WImoao8okAbf/+mG7J3mY1fXtIzJhtBg33ebwi8jfMzUjHdb
P5QGRl1Ly5Ua+diK0G/rna/T4L0yJZFyg49xi2Y6I2/S4O/lOtuTV/hY6vhi
v7dRNPhPt3DLVjw/V4qCqug2DdJQSeaS1QJsna1GuWwsDVYPPnphLyPA/txm
HtOPx/kf7f+xo5KPVdRslnBOpMFVo+takmICLHzO+FnkQxqcSaIfmnzHxyx0
LPe+fUQD14gfytZyAkzplPO4MJ0GFGVuluMYHxM+9Lwrm0mDfz0ac46nBdiz
tgBd/SwaKHY5d+V/5GNeUje7nXJoUNLpf/TeDz62CeL9I1/i+jngPe61UID9
dz5D7W0+DW5Sv3stYgmwuqy8CmEBDQblF4Ss3CHA7gjQcdliGsgEOfE0B/jY
EcUGSf13NGi5cjFm4jsfI+zlZjmV0yA5cXfLnLUAGwn5si+yCu/fgGiJdDsB
lvd2aqKghgZ7sf98mWwBdmlsQaywjgYW8aYXTkkLMAPSUn3ZRhqEfpN2pOgL
MKkjKj16zTRQWrCgvnu9AGu5RQt0aqOBcxKD0TLHxxLe62pEduL6vnV3ecRt
Aeb0d0dVAZcGL32kfbq1BRids/+ksI8Gd3YtP34C53PyhJ2UrIAG976tajOp
FmBFSaef6w3QwPD5aKQnl4+FtPiaO32hAf/Pj0gBrgcTybAfESM0mEtII1lo
CLBl2+7eKxilATvv0cWQowKsyztlo3CcBo979B1TIgVYytPnvTJTNGj7KGFx
F//ehVcUpPeLBpsXsANCTwgw9soPBKc/NNhua0/8ck+A/TZpfx8xR4PlL5tu
vTAQYGXBQpcCMTo84hbu63YTYNfffJcWitOBQE7ufTOFz4dvszkyEnRoiOd4
Fe4SYKsJUhZ6UnRY9+nKvOQGAca3Upx2lMXtD44ydWwFWGYkKT5Cng7Lptcs
LS0RYJ6VnM0FK+jw1m7y6s9jAkx/Zlu/YBUdsoWnTi2vEmBiLNPLMkp0SCm2
WKj7WIB9OHaYpLeWDr2Xju7ykBVg0QknahzV6RCzwL1rxEmAXTgf4u1PpEOz
2J6FxcYCzM7ioVochQ5iNbwh0kEBZsQsqn9Jo4PplEnqI0MBpiXVceGjFh24
fU+KBRQBtmJwgviFRYfiNtebvfl4P5TLNi3Qwe0esCxAU4AJH9D8VXTpUM5Z
pBctKcBqLxpR9TbSwULNoODaTgGWe8ixbf8WOpTF7HLSthFg8ZyAYDeMDrt2
PHQKVRFgQbL3ta4Z0OFrnuXGwg4+dmI4v+uRER02jX9NysXr3/u+6WqJMR3i
73KSWU18bP2jb+zOPXQY9fm6sr+FjykHSPZN7KODr7SZPPv//XGYdEPGgg5j
vdYv93fzseH1sEHzEB2Ol59/3rROgDXJ2wq2W9NhRDgWGTXDx95+uxBpa0OH
9xcPPnL6wseSP9zdeMEOxztyvvryYQEWlv7i821HOmz4G6OQYyLAzgTX384+
huP/fOXz/Hk+dsj2y9aak3T4prOHvAq/v0VffETgSgcTBdHsWnweERXU7s26
04F5+21j1j8+JjW+yUDxLB3enN2+lJDFxybqLcc45+iAqW3Z8BHvl64nXgmm
F+hQXdP7PWOUj6ErUTtPXqLDUf6mlLe4nh/bP5u8HECHwIHNBnUMARa1ufph
UjAdWJezgiX2CTAfRaFJwRU68CaiWhfj89T2x9zP5jAcj/we5lE8H8NPa9K+
3cDx/LU/2GWNAGNkbTCTiKSDzcjyVb7bBNjya/v/akTjet6qelktiI/NOLk/
2XKXDtuM7y766s3H+NtuHLC6R4eKpFC98lk+VqOUMX/2Ph3+dG7N6s3jYzk/
y7Iikuhw1u5V4aUiPhbb0mv1JJkOw56fppev52P+Ob/FK1LpoMCLfvAZv38s
XCG3N4MO6gcM7Qm6fGzPCbbtr0xc/z43d49Y8LF1BqaSy7Pp0CabWFeE+1NS
dcnXekEH3fVr63768LEFf6447MqjgztvRNVvBx8bak+WcXqNn39fLl8ey8c+
vSx+6/+WDsbrTL6n7+RjbyI7j8UV02HhlSSNsVt87MGpH/J57+hQ9UXiWu8X
HnbVaGnpx3I6hOpOHzZU4GOnNRinvlTRIeInb9nkSXy+z+1c+d8HOqg8KW2s
dcLnc7dTuUo9HZoC33VQ8LPG60B3vUY63OlXZC18ycMkbyessWimQ+r+Vy3E
1Xxs3O3Ne7c2XD8WO+6+EudjncYtZ6910iHHb2239GY+9o40tjaVS4dnSO/n
4nAeliEmVVfSR4cfy/4mS33iYRG95POdfDps9+SWSGjyMe+32wmTIjrstJYz
2ieHz/uYo40yX+hgPf++KeB5P6bySkr59AgdLl9x9c6Q4GO85oKTtaN0WPKw
PfY2/j5KHT+WrzlBh+eQ/DLUk4cdW7p8QdgUjl+h1ntLEg+jMNHegV94v1xr
cL8+0I8Nm7olGPylA8d426vrqf1Y9uk1X1L+0aHuuHdN1Kt+7Ex4tc78Agbc
eG95byihH2M/9Q4+uogBesIzi1a/6sN+1Kg3FEsyQCwnwCxiuA97M9iwRkmG
ATnUDSCxsB/zXeR3wncpA46az9QeutePbSJRX3UsZ4BU+X320s4+bM6gfX79
KgbknyW85Dn0YWWOIaZ31zBA/YpNj5WwDwsJZt2fUGHA8OeetiDzPswwufez
mToD5LRzLB/b9WES726syyHi+V2wuES2x9/DvbpBMpoMaPl1qLJufy8W8VdU
70pnwGfZ81vc7fuxfUq3V9dqM8DVQ821V7UXW7Zx23FNDgPefj764On+PqzN
6uvL0PUMWG9/1f6QUh9273z8P5EeA9rEl4j93dGLWcca7THYjOfff/+PN6EP
U86fjEvZxoAqG5+tYRa9WH9L8sC/7QyoXbdcsAePnzJhyjlqxICIT6nRRVa9
mJP8n4BiYwY8sfui/jyiFyOxntStMWXAr4VjlwKe9GCDew8q+poxwOHqucDU
wV7sqduCYx0WDNiZmrNNUNyDud3MyV1vyYCDeWS96oM9GPOZzdydwwyQ+UNt
093OxcY/SJpM2DJAoiWz1OYIF8v78vqemQMDhOupEi/PcbFzi51Fz50ZcPm7
eq24NxfTI8uzZU4y4E+ktJf0PBf7s6PU39WVAdH9Q/c6vnGxEifX2g/uDCBd
S4yVl+rBAi8rrtI8y4ClPacmHv/lYttTqpxCzzFgY/5/6scdurGF6OwL0QUG
VNAaXjnc4mLVfaqz2/0YYHfSOc36Bxe7PltvnBLIgKmW7ZLJgi5sj/LF2H+X
GVByTHBYfagLk9tEEdqG4v43Rv1ks7hYk3Urs/g67m95krn+vy7szoVgvzUR
DPg9s3LVVt9u7NA97Q8XbjEgeN3rCapJF7b6NVeh4w4DKG27ly+K68K4rdcc
19/D+XD67fR+WTeWNLk+5859nP8jDH6Bdxdmv0z4ZzyJAX83KXgsdurGCOxb
u8xSGPDfwkzbNTu6sIF9W2Kep+H42HZ0KCt2YY/dh/nSTxgAC3c3Xt7ShZ2K
uKft+gzna1c0dVVlJzZWO15NeckA3ZSDZQV+nVju0IMVofkM4M6iigTTTsxb
Yo+DqIABxZNSb9gpHZgu5Xf29mIcH7uqJXEZHdhvw4yZ5HcM+KhkGBzF68D8
i5OvVJUz4OKKmFVOSp2Y2LoE2eEqvJ/OlqR1mXVgVzNj4mQ/MGDS7P2QkqAd
k1C7pbGungE+tTGG+cR2LDz2RpZlIwP+BW6+RbHswORkrm7wa8bxXPyuMHSk
HbsTEoiS23C9vP84FxjYjq2a8d1d1ckA5RjmEw+1DizBw7t1iMuAPpFlUrhs
O7Z20P2obD8DaL8ZGSWb27EUW5cvHAED7rw2NZRrb8NIrU5nLQfweVAREnng
aRuWufvo30tfcD6GtYPsHrRiWmVWockjeD0NgUcfvmjFcnUtllaNMuAc0U/K
8kobpvPc9P7QOANObS3hCAWt2JmVU/ocohY4RD412aXXjIk+G/hWXNOCySfh
f+Ub32OpWznKDY7asD3c1yZr00v0PNRn2UltJkhrTu5vlG5B37YcDQllM+H8
qV+PHti1IK0pwx9pOkzQ8tdtLZloQaeztI5V6DLBryPuX/LHFvTMSaGdv5EJ
9fJp8urBrWhkzazR/BYmeCbv8GwitiFas+jNWmCCT3/je+bPFuRyvV5zyw4m
jJscllxGakOZ2Kv4IzuZoJTHlz52txWlz4yr7bPH/YcZu63Z0Y4Gcrui3Zzw
+4WuLHnjdkR0KVtw8zgTNvreihkjdSAntUyvpy5MiJ17l/4SP6d23BLVnGbC
WYf1qUKlTiSIvHBw8AwTZt0kJdUcO5C6kf37hV5M8BbTOHBO2I4cZnfqEn2Y
cDNYI+VffztKfsV8st2XCclxI6cdf3SiftdVqx38mODf9vnZgaEOpEr4dz0w
kAkqpTo3bFQ70dHuzzNJl5lgX8PdtoffiZKiG1yLrzLhRLR5napRF+rd9bqn
+xoTfH9KuJjc60TK80mmv8OZ8ESX02HV2ImOvLlauiqKCVWH3uSqynahBHc3
5obbTDjAdXKkl3chLulg8oEYJuylFxM3NHehNb2b5b3imHBw7G6l9mAXsr5L
vBydwIRXT4+Qf+Px402kJ3MeMGGDm1XCre4u1Lngh1NDChNKw1V1j7p3o1WF
3NavaUzIy72hUq3fjSw9KwylnjBhKSE6bnCsC8VqPntNfcYEl0O7lywP60Zt
/bcpu54zISXEDvbJcZHCvYtxx3NxfgfPhyYUc9GBvY6SV18xgcGYiOev6UF3
Fu6+mPqGCZxtmbd4M92opZg9UlbIBFnzT+fMprlomfdqG14JEy4OmG1QOMBF
5nSxj3OICXMDW4qPfOaiaMGXLSqVeHyTHS3UXi5qiv/0fFM1E1ZNu48SZ7lo
qXmB6uFaJkT885ceb+tB+ySSb134yITLRjf8S1f3oKh3YWL3PjGh0qh5tYlN
D2r0OXM2v4UJDluXHzmzpwfJalsKW9qZQOmfu61woheZDmw9MNHFBAjLSZzm
9aKIRHLV0l4m9Iya67Zd7UUfLWQ3MHl4fuocRXptD5KWms4wFeJ6emLSfTO4
F5mU9646/ZkJTz+Zn7dJ6EXhvlXXbgwx4d1ccsvF2T5Uy8r+/eQrrhepPSyV
iF4k+eXuqeoxJjzyHvtRrtKHjB/6cQcmmFAyp502WtqLrh1y3iM+zYQ9TmM9
p736UKpZr+3x30zgt0W82KnZh0p2HzpT85cJFS0fqX6ZfahzR2MQbZ4JkiPy
J8OU+tHk1l23b/7HgqWj29tkN/YjGf2y1NFFLPAO4Rs8+9iHNNdtzDdbwoKt
CXUvV5/tQwZaee9fyrBAMXnAe2tEP7KlMDpXyLOgwvdzUxGHhy6opw/5rGDB
zsYVmk1W/eiO0to/natYMBRQ4Fk9xkPZCvekNymxQCXnQvFRRR6qkVu6Nmkt
C0xrVr67e7YfCSWvM/+ps6BcO3b7kiAemv1vATiQWBBK9PYekeKhdb8mnUgM
Fui7za09Gc1DeydOnwtjskCTDRu9e3nI5etA6BCHBas9vKrSV/JRyOejcSYb
WHA0/cGXhDA+esDryMzWZ0GEyonbs5Z89LbbrEhuCwtuixd8ky7jo5bWD/We
GAs6/8bVzAbx0WjD9r4WAxakd/E7tXT4SPJD0dj6nSy4snZ9vuoaPiJW6IjF
7WZBVfC14HUYH20ryV42Y8qCpopM8dHffGT9hky0MWeBdYNjkEkAH3nnPlxf
eoAFj6TqU3Nx/1HPFHeqWbHgVPy25C8kAcpMj7a6fIQFJIvHPSNv+ajy4ZJT
oqMsUPDRMYjA7f3xIZeMHFmQm1JyI/kVH83c+XvzyTEWEGS3hNdKCpBC5LkH
S1xYcH3SdI+TogAxr43mnD7NgkTa44ZjAj7afflEWcMZFhQuV60jUQTomB+v
meXFArETXnaKywQo0MdadNuHBW/Ebn20PCxA9z2ap374smDztcpwtRgByj9l
stjSnwWMIrVyWzMB+uRcqfg2iAUG47SauA0CNHJ0C03pCgv62/oIcxcEaKH1
603+YXi9MsfEFVcKkJoF07T/BguyGmpq4wQCtMn0yVGIZEFK1NhEwEEBOrhT
3SM1mgVS4it+aBwXIA+4H7wwBtfj6r3R84sFKHzT8jsn4ljw3S4xI/aSAGWs
v5n2IYEFAXkh1XuGBaiMufA1/SEL9HxmO3e+ECAuNaA64hHOLy/JlnJMgKYJ
PzvH0lkQvf/KwzZbIZJf6zFsnskC8+bweskZAaIrDv3Jy2KB2/z3vqJVQmS0
zFFm5QsWnLeSXfqhR4AcpLlrL+Sx4FnRbdtdXAG6tOgAq/s1C9Sbr9q1bhCi
2Pl62FzIgszFSoNfrwhR7oyhxYMSFrxYXeC0A8ev7kep8zxiwbC7+PXdkwL0
eVTXx7GSBetW7DszhucvNvQirLIa15ei/czCdgFSElLjyXUsuKSSnhaJCdGG
3kdPrzWw4BijQDxLDs+f6fL7RRPOp3LCyg+vhOhbEHNXVysLJFI09Z13CNGH
5qlYsU5c/8LZmUvJQpROLB6gclmQHbZtlVymEAX7XNbZ38eCcRn9bEqoENnW
7Aq5yGdB/O4B+8SzQqS/Rq75kYgFZ+XO0xPfCpHC6Ta1ukEWyHatDZffI0Tj
JQlnJodZcHN01e0+OyH6KOdYqjTKAvKLX71pe4Uo00FTZsc4C5SbFOzWvRei
q3mjR07/YIHDnc33PI4IkcPC/Kd3f+L6eOx45LyLEG2xvPS7eIYF81LZUqW4
fXUm7BqYZYHkxGClFP79H3/xPYvF2BDqNDiRiscfyjjhlbCADRTSTImtlRB1
NNbeZ4qzIWR6+6dFq0So6pdWecVCNojZjq2ITxGiPPXoIcvFbJjMYz17MCRE
Kbt/LP0qwYarfy+mHMoVoigvS72gJWwgr/D/GrxLiPwTC+1WSLNBaH1SXuWE
ELlWqYQ9kWHDwqkTgYcqhMh6NOj5Zjk25EyUqU4OCNHOVaK2T0vZsK6fa5N+
VITWYztnnZexYbao3xT2iRDB5Snx93I2PBSe6rdJw/m7LbMnQoEN5y8Qltkq
itC/Qg8v9VVsWKJy7d3+TpxPYcv9fEU2fLd+JHxULkTd0rrlxmvYIEfTPqUk
J0LV6+8P9SqxoXHnkjnynBDlH51delaFDX3ZgVuz8XxSw+z1FqmyQQOr7DjQ
JkTRLyrs7qux4Tbfb6eEtwgFdpHDtDXYcPcmw+XMbhFyW3DjeTmBDXfm9Ozz
r4jQEfq3tkMkNvCUZHRC9UXI+IDZ7DCZDfkKdo8j3ERI1z+PGIgPX9kDBt8G
JoSIlLFyz3IaG5ou6QaZ9AvR8kZfr8d0Nmy5ve6bF86H2K+e+5u02DDXbdKR
XCpEY2pYeaM2G179EHs8oixCvcapQ04sNrSXGH/IxfGtO7tI/hebDYaO2gRl
VRF6m+Cid3MdG2Y+arK1ZoXocWW9ndp6NuzzWN/4Escn5hsz7NUGNqS0B+q8
Oy9CISvvPN+lx4ZiV9bdG/h9z23TbT36ON8jn+3e4PXanbSe9diEL48yvUaH
EiEyjS4mLtzChpua42CI47+pUHVP/FYcT5v95oueChFVeNlLC2ODr8fV51cI
IrRK+vP9MmBDwvOYs/tPC9HC9cblBw3Y4Jw8mqqYIESTtllDQzvYsDjr+5/8
IiHih8rJBxjh+i3dnRSbKESNOWf1lu1iQxmBJ62LxyvpbLPLMGZDa62m+3NZ
EXomph+20QQ/r41v6dcQoXha4vOGPWy4EK4Q0K4pQlM/dmZc2csGL1R6z/qw
CJm9m0zaaIbrL2rRTYoM/v31hzHfzdkwovvyFLVGiBYfMInIsMD50eDlH6wX
Iqe1P6/YHGSDT2qYpy7O37svj/yWWbLhWWv2xa+PhUgpb693jRUbNmsPjxe+
ECIf/xnXgMNs4I52jc1NCVHTzgwnHRs2KAXTjU79FSKtZfuPDNuyQeoh6VDo
biG63jO7P9mODRMlPvUGhUI0kJG5+5AD7q9R+cQIXi94Htwu7cQGgwer/vPO
FqLETWIby53ZMD6/PKPtgBD9XJjNvnAc77dTl/wu4fq1+GRF1T7Jhvhf2xtd
A4RIxkchLSIE5zNkIflCjQC5YGUJBlfZIFjxWc/olwBVLnG78zuUDUvThLdC
HIRItU0xPOcaG1xO/C05qyRElx5WXj52gw0ZFL8jauMC1OHicVHpJhtiov/7
ehDfR+t0lM82RbBhXpeiAu4CFDVX7RIWhfdH0t6mEV0hGq7xctgSzQYP011b
7F8LkOEdVevJ22ygP17U8wCPn2JbZ5Z5lw0DcjFuGhkCNEs5v8sulg3vA9K+
DZcKkPWEBqYQxwZOobK9wwN8vxY36NbF4/ztH9+9GN+fS8MuMoMTcHv5x6DE
swLkak6m6Cax4duf2+JRBwSoWql57bcHbLBN4d2OiBIgwmf/lanJ+DziVwT+
wfMPeEGVtX7Eho9S6xeyzAWo62LbQrk0NryWeZSAhvhovWHwbGU6G2zCxEB/
tQBFy2lNXXzMBpbCdVVDjgB97er8yspkw6euE7JP8H28M+2K6PNTNsgPMdV2
/uSjVHdWT2IWG0bdb0z9XCBAQWWR8XsK2eB9+uur7y58NNJXFjNTxAb+I61c
CpWPLP/+iH5SwoahtHS7imEeKl+tGXnoHRtuXD0u9nMrH2npHrkhXsYG7XMm
m9W/8FDcgcjQl+VsOOS8OpTgwUf/nS27bF/Jhq+uvz4EOvORe9SPANn3bCj4
ct30/WI+6sqiXCquZoPeKuq6/Hge2lF7+PypD/i8aLwUZSrgoZzBCC/FOjYY
xWDaP534SGlh2Zn39WzQtWw/Uf2Ih0I1frh6N+D+JRs1OnB/49soJzU+4fMo
3u542B8esrU97PypCde/Q8ZjFq8f1VyMsA9oYUPcnDZMHsLfp3HIhtHGBpkP
HUlzN/vRg/xJq+52nJ/Cuh1VA/1IsoV88FonG/zvf/g+9aYfnftubb6hG5+P
J3ZtqLvRj3gyEaYiLhsSGVZpBvF9yISOjG/3siF1NH9+g30/erNr0hDrZ0Ps
6ixEutKHNI6Tt4/y2BApZfCyJbUfRYRYb00UsKFu9M6O/s396FfyzY27Rfj+
ybpdWb6oHzmVvtvwa4ANOz+yu+oP9aFG7gQnYxDfPzH+Z7TxeBt/k5gHhthg
d9hI/JFNL0pfaU1fMIL3Vyhx1cG+XiSvc5Py4isbAl74DZ0O7EV+5u8IR0fZ
sHKJwrNx1x406D6hKv2dDW4MLIW3tg/tv0lSLhxnw5UQ0rinoAeVZFopnpxk
g6uYxtAC/H+GWh2+YuUUG85ENac7DvWgu6LSpZXTOL6X6Kf/pPagf2IT0md/
4fg95RV4X+MiV1WSpNoM7j92xw1nfg9q32y1sOEPGxx1IS1xew+Cw+FifrNs
uL9C9pTeFBdlnS+dpf7D98uion0FLj1oVcz47455NlxKv+hyy5WLQl4Sp68u
4IBPUZuMn14PGm20nFgnzoF1a77+R2ZxkfW3G6P8hRwY6passOBxUdWS0uGo
xRxIeO+fna7PRSzN8c9bJDmg1UhwXDzQjRIMicKRJRwQXh1bkJzRjRY5WfbH
S3MgN+gRa8+BbuQZdIO7U5YDh8tq73src1FvUknHlBwHtJ0kaQT8f3lX0feW
VHkOPJJIXf/7aDfK6yR8Ml/OAauPXsmXNnUj1elD9f9WcOCz2Mn6DZwudGP5
jZrslRy8eNHmpYe70RSrpPKIIgfG7i+7Itvahez3fkeSazhwQCqQe0mlG9W5
EkreKHHgXpfsUdfyTrTh+qG3x1Q4gEnUZOx170QpGdfzl6viZ4Mtv7oTOpF0
ZXFumRoHisxuD26r6kDn+WPZZzQ44C95r5Wj0YWEcxpPVYgcyDfWsZT06UR7
lQ9l1JE4sEfnxilx1w4UP8Ass6Fw4D7SPGFG6UADzyV7vmlyYMuVjcuXe3Qg
9gXhdACNA3d8pgrU9nUgfyiRX8rgQAGvNaJ8vB19WHKPkaLFgZRgyaDltHak
0Oqxk8PkQOO+SzNfXNuRQ9JuxwoWB1bMJ2+Q57eh7ONE/wMcDpBndOQLR9vR
b+bcvYF1HCir4r97cL0NGf7ueOmzngMVgR6MTx7tKLo89+NiXQ5QK7cNyqq2
oZ7w8C9xehyo+dWn7RzSjigHj/1H28iBcRP34mOL25DX2m1rizZxgLgjaouy
RBt6N6iov2cLB5K4H0wVVdqQVO6ERe9WDjzsX6+tKtaGLC/Wu7tjHDiy67+Y
X6JWlGqQcf0fcACdQ/Sug61oTDoo7ZYBB3afXA4Vc61oY7v1O3VDDnRqHB60
qG5BVx+u635pxAGP4sV199NaUdNJmSmDXRwQnLx3fHh3C1LhDMq1GXNgX7pS
rE9CC3L5g2jHTTigZFhScnu+BeVX3jf8uYcDEVJxqg93NiOxSG/7a3txfkP7
m6Q2NyNTy72XVptxQG8iSH9CpgXFq2nGPjXnAM8ldWn/0mY0MCSWu8mCA6s+
W3Wp32pC7DxuXf0BDsT3bBa1nmpG/n75n20PcWDj17Aio94mVGMYJTZmyYEm
aMp1PND0v4bLO57LL4rjmiRN2oWUlDTci1I4h0gDiYY0jCRCSSpJGqQoQkOD
lCSREcreo6GU/d3PN/yiEokQ4vf8eV/Pc+8953Pen3Oep1D/6Ju90wLZes0N
qZe7XVYYPd9+8Yc/6jjyI8pFITsF1tHlK+371LGuhHupIj0J6jb3rOnvV8f2
jA9pEYav4ahtvn7IgDr+EchLcCrTQep0wNbFQ+ooOTfSWC30FcQEb9uZ84+t
b0/bNcXxWaATO9vGfEQdQ5oP3blclwENOV+cvkoQzAgrH9INzgD36gQPn9EE
+WZqb7n3s0G67YTP9LEEPZT2Ou06kwOxwzoB8eMIaoQYflrpmg16M8aH6kkS
XDH6se1v13zgLP90r06KYK+OrFZ9Xj54GNx9ckSaoL9FFl15qwBk9tglScgQ
XLI0+4x5aRHEHVPNvDOJvd/eysLybCFgQHeR2hSCvKrcCRmr8oEXmfe+ZCrB
CN2/xS4RheCZfrnOajrBYIvTlhaaRTD5vZmoQ5bgu0XL9lZOLIV48aw2/xkE
D04s05p6vQgM+sRdc2ex5z+VbX68tRgEkxIGU2cTzHU5Jvy5pBhOLT4xzngu
m0+S1vT3YaUwbb3OFOE8dr3OJVPVtxRebB8358QCgnbZiVMm80pho1OV0gQF
gupt/jO3bC8HsW+EWrQiwaZNoYmdhWXgfdtWS1OJYNTyiqUZMmUg92IZVi5i
9w86V0gLyyG55PdmO2U2njnlJlSlAjZxcy37lhD88Gv3KY+mMmjq9N8fvJRg
xdaajJLv5bC49Nkds70E04NvemdJVkOVWn+sYB/BAc/vUZs+VIPXnU3pRw4Q
FBS9dNlXXg1KEveK+20IDt/82rxpuBoqnb99CrAjKOPt99S9uRo8a7VFcgfZ
eOMcR1riqkFeN6g9xoEgHcOJrqmrhrdxvIHVjmx+rc/WaRVUg8fU5RMKDxMc
H/e63/97Dcz3PjvL1Jng0dYd/4R2NVDeXKnMP0KwZ8HaM3Lja+Go6XwNZ1dW
/1EPVJhZtTA709Wgz42gStWWIu/IWihRzDe/fIzgTzWXD7vqa8A1aJKN7HGC
95ckK5XH1MDMnv1ujz0InjnPf/CkuwYK9yefXeVJUF5t810nxTpwejMcmH+S
4NKoQinD5FqYrr7t7tbTrF4K4gfCUfWQdz86juvF8rG+mHC968Bx7K+Mw94E
P3+c0juoXAdTj2Lpn7MEQ+nFNamFdZDdGFrtd47g8vs20rcv14G9/hdm2nmC
gRmH/Xa51oNMonpH9AWCXPWsT1/W1sNruUtDKy6x9Su6PmCeWQe2vjXSeX4E
6yptYre51LN+UZqz5TJB1/r18xKlGyB9+wkVTgBBq/6WFWUnGmBfbqmm41WC
7jP5Gipb62G8spxhTyCr14RFqWtDGyA1xMHi0jWCCU0K0ivNGsC6P8N2ajDB
W+6vn5hw6mGs/bhjD0MISiVXmYcbNkJy5c5zaqEEayVDqlvFDWClGXctJ4wg
NNW6S8s2wqjo3nubbhL0/DVs/u1DAyRIGcc33CLYfi7HlBffADs8Il473CFo
vzdNby1thGF+a9nvCNafYoue5dMbId5obe2FewSdxh6LvCjHAYuUq18mPyC4
bPWyrV9UG2FwNrczMpJgQ7NJoPNNDsReWjas+pDgofWnM32QA2btZ2Syowkm
cbixO4040L/z/VzjxwTPpt6IfarBgZjCucvqYwjWBElJHJbkgMkylzUHY1m9
uzReZgo58Cc816jrKcHkqofx+6048HBo4o7zz1i9FCG6NowLmxz32U96TjAg
PuXj1EIO/P70wv1BAlvPyFvBiXwORGr/8132gq1XztCb0Ze5sPGJaXBmEsHH
n9yEbmUc6JR5+MAohWDexuneh8dy4e6pjue1qQTvWrbsDCU8MBDrZdmlsfwv
/RkxGMmF9s03KjrTCa5k8oTbTHlwJ52pO/eK4C5dRldxkAu4YHXzxEyC0606
Yt6y628BF7ruZRHc3P5xAc3hQfivzyMqOQSNj8deuLqaBzrWCye/ziXoQu5r
6hZx4Wvp8fmG+aw/VPUFLez7oStKVGsKCOKceyk3rPkQv3bvhEtFBIU3JMg6
hgeFG3pa1UvYfK6GbLtqyYcGs+CKL6UEvSKsw8preNCxZ8nTsHKCZUaxWvOk
+TDuUKGf/huCpYn3It+O4sN8dyv7rrcE5zlqPJbx5oHG2S58/J7g2IRAZvgE
H7YGBCls/0Dwh7/SDMtQPtiHLRqWqCKoWbIi+7ufALwj8wSpn9jnqfl9LUYC
CHu2M9e2mu3HPx279JGNN63j3tRagu+TTVzVTwmgKP+KV1EdwX9qWeo+OQJo
fKu4272BYOXnigkpdQLoqM3WVOQQ9v9JeVL8fQGMZyzkPnMJFn7kTypsFMCC
7z9+n+ez+zPjav/j8kHjj3/1KiHLT8xHCcEaIZhIyKcyIpaXd64eHt0CODgx
M+SGmKBBnr4bv4CNd6a5GzQR1H1e+m37YwGEL/y2tbOZYLnvnvCGDAE8V7uk
Gv0fwTGaT8crrxdC0Zp5E7a1EhRfOTVp8JcAOAYZrcNtBI8fDb0YFCSETlPT
iuTvBG8sszfdKymE8Xu+xh5oZ/2+zq/BVV4I8g7n/SZ3ENzCkfUd+CcEzWOz
7Qs6CXadrneUfMfG6/0Sj3YRLDm/qiOcvc/h8hYF+W6Cs/VfbVC6IISzoc3/
PvawfnYx0Q8hIgh/4CM418vyVbNvrqBaCAlxM3JX9BP8G7Dom62hEIpfJt8T
/mX9ZtPfvrZJCJw8Y6/gQYKyv7LrC3VE8OuNeJfuP4LaoY/SU6+IQLL2jObP
YYIhm/U6kuREIC+aLhclQbEfOrwOvBKB1rfE3yajKW5X639tUSIC0x7D6qEx
FGs0JjzsXiQChxFhyotxFFN0Srw+PWLAR/p0yD5Jiu+tus4E7Gbg5oypbjIT
KE6Lzk89ekQECYrPt+ZJUwTiqeSRKYKS5QaqrjIUPRqr2mYpi4CrxZeaP5ni
1Na/yvvMGPil79laOYXiXefqaJ86EUiZTqo4O41iW8kZw5veIlCwiotdLkvR
X3nhgnBpBsyOcuyuzaQoZddWsFiPgUNnjuP62RQTDa//+RckAh9/aYUfcyjq
TFzlUhIggls3nvy7P49iMwzuUBaIIPG+jmDLAorJpqmaO2MYKHlanzMgT/G4
jf4f5SIGeKlH7yUoUlzeOzFV9SQDXbmSXtZKFKu2zRZZWjEg9ebRLunFbLyG
F+2sGxlQrNHWzFGm+EpzgXLXTQbWCGtkj6hQlFbxDdL4ycbb5vJ7zjKK2Q5S
KW1rGHDsHlv9TpWi6uurvRMmi+FAgmHVPjWKE3V9XD5rMrDLzr+ycwXFPod3
3kV6YjCbXfb20iqKbosWPrptx8DGT2MqZqhTnHftVreyDQN6ARtK4wnFm+WZ
2YahDGjp+hWt16A4t9y+OjGQgZU9JflVmhTv6Kh5LOkVwZLE0bl2ayiqP8qe
OcWbAXl7g6yetRRzFGMG/Z0ZmDnn0qsr61i9/zOevo/Nf/Ln4rS5OhTzgqoe
+1YwMP7KqNQkXZaP3IxHJqZiGNbVT0Jg9WiRcchWFENvz4WEWqT4psDLo0WO
gY7EomeOBhSv2/2MCrYQw3/2Ek//bqAocdRSe7eDGARzMOa6EcWZcUERxr0M
1H0+H61gTPHASU2nM79F8OFKYWTaJpaf93YLBZpiKNMbuWe0heLzPc4+r4oZ
yPujF8HZSvH7zFxxyyoGMl743nIxpXjjW1vw8W0MvDhYEDZsRlFGRcn3CYoh
du5wSJg5xc8Lszo3P2Qgslr3+mILirXCgy/6lojh1tVzgZmWFL1XV4bHTBPD
dcgP2LKT4g+Db7sPsfn59w75CXdRLLk1u3BvAuuHJJ2L7lYULxT1BFiy+Xo6
+PiOsabYZRxw8pQiA67z8s7e2cvWb8n5qCn2YnCoGfRatp9ik1DLyURFDPsC
15/KO0BxSsGY5Cl3GNiBZ09ss6Vow5uVe34JAyZ9Oe5NdhQ7Dz3P+2ctBsPk
AbeTB9l4hn+82zBBDDqH1rlIHaI4IozSj94sBo353k4PHNl6/y5gRp4zoFab
fWilE0VHf8Pw2NcMLA76a1/szOr9kVM1NpeB+fratjtcKD5SL5JZt4sBuX6v
/a2uLH9ZkulT1zMgk5Jl7X2UzffIyj0tIwyMdezfPcmdovkcEtN4mYGh+Wt3
PjrO8r459/nLiWLoqT1tQU+w58sLB0rPMdAelLmtwpOipJVi3qsSBpr1+0z2
nGLrlbiZeNkyYP/yt2LgDYpFb+prwk+IwPWS5dCWMIpeL1WW8pNEcNIyo1Hm
JqvHvMY5dUIh+C6ekV51i+Xv481c124RXP1zMiT0DsW4jLDzUWy/Da9ocLa4
SzGo18jPmj3vQcQaI7n7FMNWtVZmnBRCrNNdxYYHFH85t43bvUwEydp/ByOi
KGbFmeOl50LIkrZu3BNNMdD6/beuL2y/5eekzXtM8dQF+4X2p4Xw/sW8EGEM
xailNtKBT4RQd87HOTqW4mQb6Vf9K0UgNBMa2sWx/FXP6L4yJISvCnqKi+JZ
nrSHRjZIsv3518PBlucUI8dIaARpieBv8UhDXCLFp0GWWg9MhTD6pm2aUxK7
DrsavfOEEGQcioNVUyiGtyzRnaomghmaSs7tqRT/ntDWtg5j5894P8PkNJav
e8/c8tn5tLSxWcE9g+LiTnnNti8CUI83HFR/zfLW02CtYyWEdWeeNnRnsjwB
z032mAAMt4xPe5VNcZZhrk/BZiGYzTscfDqX4nzzq5UlTQLY3f7GSTuf7VdS
RYttvwvANn+p4WABxbU/jGUnOAjgSEigQn4RRd5nyY0CIyF42nwf8C2hWNx8
Xed6Fh/Ord7agGVsf9WJsJ12ng8Bo168HF1BMe12XF3JcQGE1sgEl72hqO1s
lmH6kg/3n7g5BbyjODjX6t3+Y3x44lm1YVMlxZbt61XGB/HghdEqBemPFPVq
tExnNPHh9czQgcoqigeTlnI6InlQ1PqrPvgzxX/patrBynx4l7X95bYatn57
BT05EwVQE5h2fVod65/ihN7aeh4IrGWdauspGkmArdZnHnxd7rnhdiPFDRWL
pJ5u40HnUJ38bi5Fg8TeExf8+dD/UXNgNp/iJ6vP3/OX8mF09J16noCdR2/W
W3ia8GCie19qpIhiu+53y5ISHsjpW10/IGb5n5FuuimKC/LTsw8rNlG81pu/
bn4iF1Sa52xoambn16yf5pNecmF1hrd87H9sPmMPtuls5MK6y/y/h1pZP4bb
yXjP58GGXTr1Kt8obu5r85WJ5oKJSlTqt+8UXUJS/TIzubCr/9+1xHaKRz5I
NziJOWDz7sBhtw5Wf7+WN6uncsHpfqHBql/svJAL33jRjQseLoryXV3s+8Z7
clRHc8FH5+LftG62P/oe2vVCnwuXJzXVef6hiNymVfy9XAgRGaRq9bHzzthk
kvUeDtxNeXKtv5/l5aZk0pZ29nv/wtjDOQMUB87mL/eQ5ULi9kMGPkMsjz2c
fqUfjZChVLFAb5i9v2/36zhfDhR0L/k7MkKxTNCgZstpgP8BV/0kjw==
         "]]},
       Annotation[#, "Charting`Private`Tag$213544#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81e8Xt/dWxjWTQkpUSqXOY6REJaGUJKRkJOIrChGpECIqCWkJEQ2i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         "]]},
       Annotation[#, "Charting`Private`Tag$213597#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0, 20}, {-0.6055194132301888, 0.640716417940714}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.910325749356944*^9, 3.910325753376111*^9}, {
  3.910325791589562*^9, 3.910325859388071*^9}, {3.9103262547986593`*^9, 
  3.9103262650569215`*^9}},
 CellLabel->
  "Out[831]=",ExpressionUUID->"455f773d-96f2-4740-bf82-854629fb3544"]
}, Open  ]]
},
WindowSize->{1428., 336.75},
WindowMargins->{{0, Automatic}, {Automatic, 46.5}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2.2 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8cea4437-8e2f-468b-bf58-8d9948a64486"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 481, 12, 146, "Input",ExpressionUUID->"b508d4ad-b58f-4a88-984c-700ec39c9db8"],
Cell[1042, 34, 698, 16, 141, "Input",ExpressionUUID->"0f3b2d71-07c3-4454-a4f0-7f9ec507a197"],
Cell[CellGroupData[{
Cell[1765, 54, 2240, 63, 451, "Input",ExpressionUUID->"e5cd13d5-24af-419d-ba33-49028ab4e257"],
Cell[4008, 119, 1272, 33, 107, "Output",ExpressionUUID->"0c0c18a9-6562-43ef-afe4-bbacfecc0f57"]
}, Open  ]],
Cell[5295, 155, 1204, 34, 280, "Input",ExpressionUUID->"610bb0be-b3fd-408f-8a42-be39a453f29d"],
Cell[CellGroupData[{
Cell[6524, 193, 2718, 79, 356, "Input",ExpressionUUID->"67e9168b-db60-44ba-a9fa-427b0361b9a2"],
Cell[9245, 274, 671, 15, 70, "Output",ExpressionUUID->"1ccb2269-4244-481a-b2e4-19d38c0b0364"],
Cell[9919, 291, 1765, 50, 113, "Output",ExpressionUUID->"6e06fbc8-f41d-4f5e-84e6-2c87e042a93c"]
}, Open  ]],
Cell[11699, 344, 1519, 48, 313, "Input",ExpressionUUID->"34d5834a-ceef-490d-a6db-e030bb1d74d1"],
Cell[CellGroupData[{
Cell[13243, 396, 4313, 133, 592, "Input",ExpressionUUID->"58dbc308-1146-4515-b1f9-896efc88e70d"],
Cell[17559, 531, 1054, 33, 76, "Output",ExpressionUUID->"2b65cc3f-7376-4408-a639-bbc696ea917a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18650, 569, 1980, 57, 356, "Input",ExpressionUUID->"2a7cb200-a0e5-4628-b6ca-6dbd311847cf"],
Cell[20633, 628, 42156, 713, 514, "Output",ExpressionUUID->"78212540-4ce6-436e-996e-55198ec57cc3"]
}, Open  ]],
Cell[62804, 1344, 153, 3, 62, "Input",ExpressionUUID->"8c6ab175-6ae8-4447-beed-0ef7582902af"],
Cell[CellGroupData[{
Cell[62982, 1351, 1086, 32, 146, "Input",ExpressionUUID->"53a4bee3-a297-4d3c-bcaa-a7aa0fc8f344"],
Cell[64071, 1385, 108219, 1811, 277, "Output",ExpressionUUID->"455f773d-96f2-4740-bf82-854629fb3544"]
}, Open  ]]
}
]
*)

