(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     14227,        410]
NotebookOptionsPosition[     12842,        379]
NotebookOutlinePosition[     13325,        397]
CellTagsIndexPosition[     13282,        394]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",Expression\
UUID->"b1210549-23a0-40c2-9f59-e2e35c547482"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"d", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cp", "=", "840"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Rho]", "=", "1600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   FractionBox["\[Lambda]", 
    RowBox[{"\[Rho]", "*", "cp"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<a = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"a", ",", "2"}], "]"}], ",", 
    "\"\<  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"3", "*", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]x", "=", 
   FractionBox["d", "n"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<\[CapitalDelta]x = \>\"", ",", "\[CapitalDelta]x", ",", 
    "\"\<  m\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ClearAll", "[", "\[CapitalDelta]t", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fo", "=", 
   FractionBox[
    RowBox[{"a", "*", "\[CapitalDelta]t"}], 
    SuperscriptBox["\[CapitalDelta]x", "2"]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]tmax", "=", 
   RowBox[{"\[CapitalDelta]t", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"Fo", "\[Equal]", "0.5"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<\[CapitalDelta]tmax = \>\"", ",", 
    RowBox[{"N", "[", 
     RowBox[{"\[CapitalDelta]tmax", ",", "2"}], "]"}], ",", "\"\<  s\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6894760726875*^9, 
  3.689476074453125*^9}},ExpressionUUID->"7ac7320b-1ae2-4605-b09d-\
52b7e97d2eee"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a = \"\>", "\[InvisibleSpace]", "5.208333333333334`*^-7", 
   "\[InvisibleSpace]", "\<\"  \\!\\(\\*SuperscriptBox[\\(m\\), \
\\(2\\)]\\).\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)\"\>"}],
  SequenceForm[
  "a = ", 5.208333333333334*^-7, 
   "  \!\(\*SuperscriptBox[\(m\), \(2\)]\).\!\(\*SuperscriptBox[\(s\), \
\(-1\)]\)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9120462828658557`*^9},ExpressionUUID->"7c8e31c9-405f-4cb9-b3d1-\
59dfcea0d146"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]x = \"\>", "\[InvisibleSpace]", 
   "0.02666666666666667`", "\[InvisibleSpace]", "\<\"  m\"\>"}],
  SequenceForm["\[CapitalDelta]x = ", 0.02666666666666667, "  m"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9120462829127197`*^9},ExpressionUUID->"71617cd4-f0e4-4681-bdd6-\
c50dc927d29e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[CapitalDelta]tmax = \"\>", "\[InvisibleSpace]", 
   "682.6666666666667`", "\[InvisibleSpace]", "\<\"  s\"\>"}],
  SequenceForm["\[CapitalDelta]tmax = ", 682.6666666666667, "  s"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.912046282928342*^9},ExpressionUUID->"80b89904-6e69-4f6c-9d5b-\
27a3e6e0f0a7"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", "600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpoc", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tpolepoc", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{"Tpoc", "&"}], ",", "n"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"To1", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ton", "=", 
   RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]1", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Alpha]n", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fT1", "[", "T2_", "]"}], "=", 
   RowBox[{"T1", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"T2", "-", "T1"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]1", "*", 
         RowBox[{"(", 
          RowBox[{"To1", "-", "T1"}], ")"}]}]}], ",", "T1"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fTn", "[", "Tnminus_", "]"}], "=", 
   RowBox[{"Tn", "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"-", "\[Lambda]"}], "\[CapitalDelta]x"], "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Tnminus"}], ")"}]}], "\[Equal]", 
        RowBox[{"\[Alpha]n", "*", 
         RowBox[{"(", 
          RowBox[{"Tn", "-", "Ton"}], ")"}]}]}], ",", "Tn"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"krok", "[", "list_List", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "Tpom", "}"}], ",", 
     RowBox[{
      RowBox[{"Tpom", "=", 
       RowBox[{"ListConvolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Fo", ",", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "list"}], 
        "]"}]}], ";", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fTn", "[", 
         RowBox[{"Last", "[", "Tpom", "]"}], "]"}]}], "]"}], ";", 
      RowBox[{"PrependTo", "[", 
       RowBox[{"Tpom", ",", 
        RowBox[{"fT1", "[", 
         RowBox[{"First", "[", "Tpom", "]"}], "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodina", "=", "3600"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", 
   RowBox[{"6", "*", "hodina"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nsteps", "=", 
   RowBox[{"Round", "[", 
    FractionBox["tmax", "\[CapitalDelta]t"], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"teppole", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{"krok", ",", "Tpolepoc", ",", "nsteps"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotik", "[", 
    RowBox[{"list_List", ",", "ntime_Integer"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"nel", "=", 
        RowBox[{"Length", "[", "list", "]"}]}], ",", "listpom", ",", "i"}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"lispom", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"i", "-", "1"}], ")"}], "*", "\[CapitalDelta]x"}], ",", 
           RowBox[{"list", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "nel"}], "}"}]}], "]"}]}], ";", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"lispom", ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<x[m]\>\"", ",", "\"\<T[\[Degree]C]\>\""}], "}"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Ton", "-", "2"}], ",", 
             RowBox[{"To1", "+", "2"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"tpopis", "=", 
          RowBox[{"ntime", "*", "\[CapitalDelta]t"}]}], ";", 
         RowBox[{"PlotLabel", "->", 
          RowBox[{"\"\<t=\>\"", "<>", 
           RowBox[{"ToString", "[", "tpopis", "]"}], "<>", "\"\< s\>\""}]}]}],
         ",", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.68947586009375*^9, {3.689476140125*^9, 3.68947616084375*^9}, 
   3.6894762054375*^9, {3.68947627378125*^9, 
   3.68947628559375*^9}},ExpressionUUID->"28cf945b-6be6-4c9a-b120-\
e25670178b24"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"plots", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"plotik", "[", 
       RowBox[{
        RowBox[{"teppole", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"i", "-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"Length", "[", "teppole", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.689475895484375*^9, {3.689476253328125*^9, 
   3.689476362265625*^9}},ExpressionUUID->"16a9c237-b60e-42ac-9c3b-\
e270c98b0cb6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"plots", "[", 
    RowBox[{"[", "i", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", 
     RowBox[{"Length", "[", "plots", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"32bc8592-dd66-4f19-9b8b-44458ae60901"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`i$$], 1, 37, 1}}, Typeset`size$$ = {
    522., {164., 172.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`i$4001$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`i$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`i$$, $CellContext`i$4001$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Part[$CellContext`plots, $CellContext`i$$], 
      "Specifications" :> {{$CellContext`i$$, 1, 37, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{591., {225., 234.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.9120462841155624`*^9},ExpressionUUID->"f4a9abb4-0b49-4500-9a42-\
2279bad9d00c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Ttry", "=", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       SubscriptBox["T", "i"], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
     RowBox[{"ClearAll", "[", "Fo", "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ListConvolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", 
     RowBox[{"ListCorrelate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Fo", ",", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "Fo"}]}], ")"}], ",", "Fo"}], "}"}], ",", "Ttry"}], 
      "]"}], "\[IndentingNewLine]", "%"}], "===", "%%"}]}], "*)"}]], "Input",
 CellChangeTimes->{
  3.689476233734375*^9},ExpressionUUID->"f107f004-3f88-4549-9d74-\
f707acb763f1"]
},
WindowSize->{1003, 740},
WindowMargins->{{24, Automatic}, {Automatic, 40}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.4500000476837158`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 387, 10, 98, "Input",ExpressionUUID->"b1210549-23a0-40c2-9f59-e2e35c547482"],
Cell[CellGroupData[{
Cell[970, 34, 1960, 54, 532, "Input",ExpressionUUID->"7ac7320b-1ae2-4605-b09d-52b7e97d2eee"],
Cell[CellGroupData[{
Cell[2955, 92, 509, 12, 32, "Print",ExpressionUUID->"7c8e31c9-405f-4cb9-b3d1-59dfcea0d146"],
Cell[3467, 106, 362, 8, 32, "Print",ExpressionUUID->"71617cd4-f0e4-4681-bdd6-c50dc927d29e"],
Cell[3832, 116, 362, 8, 32, "Print",ExpressionUUID->"80b89904-6e69-4f6c-9d5b-27a3e6e0f0a7"]
}, Open  ]]
}, Open  ]],
Cell[4221, 128, 4992, 146, 771, "Input",ExpressionUUID->"28cf945b-6be6-4c9a-b120-e25670178b24"],
Cell[9216, 276, 597, 18, 70, "Input",ExpressionUUID->"16a9c237-b60e-42ac-9c3b-e270c98b0cb6"],
Cell[CellGroupData[{
Cell[9838, 298, 311, 8, 41, "Input",ExpressionUUID->"32bc8592-dd66-4f19-9b8b-44458ae60901"],
Cell[10152, 308, 1644, 35, 485, "Output",ExpressionUUID->"f4a9abb4-0b49-4500-9a42-2279bad9d00c"]
}, Open  ]],
Cell[11811, 346, 1027, 31, 154, "Input",ExpressionUUID->"f107f004-3f88-4549-9d74-f707acb763f1"]
}
]
*)

