(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4343,        151]
NotebookOptionsPosition[      3260,        124]
NotebookOutlinePosition[      3719,        141]
CellTagsIndexPosition[      3676,        138]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x0", "*", 
     SuperscriptBox["q", "i"]}], "+", 
    RowBox[{"b", "*", 
     FractionBox[
      RowBox[{
       SuperscriptBox["q", "i"], "-", "1"}], 
      RowBox[{"q", "-", "1"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xinf", "=", 
   RowBox[{"b", "*", 
    FractionBox[
     RowBox[{"-", "1"}], 
     RowBox[{"q", "-", "1"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"xinf", "/.", 
    RowBox[{"q", "\[Rule]", 
     RowBox[{"1", "-", "a"}]}]}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.685242367765625*^9, 
  3.685242446390625*^9}},ExpressionUUID->"5a505e93-e013-4fcd-b033-\
65805c2df7f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "i", "]"}], "-", 
    RowBox[{"x", "[", 
     RowBox[{"i", "-", "1"}], "]"}]}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.685242450296875*^9, 3.685242459984375*^9}, {
  3.685242509890625*^9, 
  3.68524251071875*^9}},ExpressionUUID->"3f48e278-a2a6-4a9e-bbbd-\
fbfa457a8682"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["q", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "i"}]], " ", 
  RowBox[{"(", 
   RowBox[{"b", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", "x0"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.685242455953125*^9, 3.685242460859375*^9}, 
   3.68524251690625*^9},ExpressionUUID->"10f6b9f6-2549-4371-9d86-\
f35206a5188b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"denom", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", "i", "]"}], "-", "xinf"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.685242481984375*^9, 
  3.68524251403125*^9}},ExpressionUUID->"e22df0cb-3843-440a-9afa-\
ccec16a559c2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["q", "i"], " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", "x0"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "q"}]]], "Output",
 CellChangeTimes->{{3.685242483640625*^9, 
  3.685242514671875*^9}},ExpressionUUID->"3fd3b062-47fb-4e61-9ee2-\
f4770173d14f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["num", "denom"]], "Input",
 CellChangeTimes->{{3.685242524125*^9, 
  3.68524252659375*^9}},ExpressionUUID->"3b3bead7-f850-426a-8e19-\
8712a47be687"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", "q"}], "q"]], "Output",
 CellChangeTimes->{
  3.685242527140625*^9},ExpressionUUID->"78805401-46b3-41bb-a56b-\
e3c1ee076485"]
}, Open  ]]
},
WindowSize->{904, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 750, 25, 198, "Input",ExpressionUUID->"5a505e93-e013-4fcd-b033-65805c2df7f3"],
Cell[CellGroupData[{
Cell[1320, 49, 366, 10, 45, "Input",ExpressionUUID->"3f48e278-a2a6-4a9e-bbbd-fbfa457a8682"],
Cell[1689, 61, 419, 14, 51, "Output",ExpressionUUID->"10f6b9f6-2549-4371-9d86-f35206a5188b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2145, 80, 270, 8, 45, "Input",ExpressionUUID->"e22df0cb-3843-440a-9afa-ccec16a559c2"],
Cell[2418, 90, 419, 14, 87, "Output",ExpressionUUID->"3fd3b062-47fb-4e61-9ee2-f4770173d14f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2874, 109, 175, 4, 76, "Input",ExpressionUUID->"3b3bead7-f850-426a-8e19-8712a47be687"],
Cell[3052, 115, 192, 6, 82, "Output",ExpressionUUID->"78805401-46b3-41bb-a56b-e3c1ee076485"]
}, Open  ]]
}
]
*)

