(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     42115,       1224]
NotebookOptionsPosition[     39958,       1181]
NotebookOutlinePosition[     40418,       1198]
CellTagsIndexPosition[     40375,       1195]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"randomMatrix", "[", "rnm_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "&"}], "[", "i", 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.685842236140625*^9, 
  3.685842236484375*^9}},ExpressionUUID->"5f99be5e-536f-498d-ba57-\
4445edc459ec"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"kfe", ".", "fjfi", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "limpouch"}]}], "/", "numet"}], "/", "nr"}], "/", 
     RowBox[{"node14", ".", "html"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"http", ":"}], "//", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"kfe", ".", "fjfi", ".", "cvut", ".", "cz"}], "/", 
        RowBox[{"~", "limpouch"}]}], "/", "numet"}], "/", "nr"}], "/", 
     RowBox[{"node15", ".", "html"}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.6857809848125*^9, 3.685780987765625*^9}, {
  3.685781059265625*^9, 
  3.685781061765625*^9}},ExpressionUUID->"fe222c62-ebb0-4afd-9ee2-\
83eb715e0222"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"randomMatrix", "[", "n", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], 
      RowBox[{"Random", "[", "]"}]}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"a", ".", "xvect"}], ")"}]}], "+", "p1"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"b", ".", "xvect"}], ")"}]}], "+", "p2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f3", "[", "xvect_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{"c", ".", "xvect"}], ")"}]}], "+", "p3"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectfces", "=", 
   RowBox[{"Through", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}], "[", "vars", "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"origEqns", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{"vectfces", "\[Equal]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", "&"}], "/@", 
       RowBox[{"Range", "[", "n", "]"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jacobian", "=", 
   RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xStart", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Random", "[", "]"}], "&"}], "/@", 
    RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
   RowBox[{"xPrevious", "-", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"jacobian", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"vectfces", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"xNext", "[", "xStart", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", "origEqns", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "for", " ", "linear", " ", "equations", " ", "one", " ", "step", " ", "is",
     " ", "enough"}], "*)"}]}]}], "Input",
 CellChangeTimes->{
  3.68584352715625*^9, {3.685843762765625*^9, 
   3.6858437718125*^9}},ExpressionUUID->"1b6c7b71-2e9d-4942-9c98-\
57ff9ebcd0a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.9878721982907739`"}], ",", 
   RowBox[{"-", "1.652451570761416`"}], ",", "1.8648796902983014`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.842492335705079*^9},ExpressionUUID->"b9965460-367a-4ebf-9bd8-\
45a9f6439d53"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "\[Rule]", 
     RowBox[{"-", "0.9878721982907739`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "2"], "\[Rule]", 
     RowBox[{"-", "1.6524515707614162`"}]}], ",", 
    RowBox[{
     SubscriptBox["x", "3"], "\[Rule]", "1.8648796902983016`"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8424923357584686`*^9},ExpressionUUID->"abfabc98-5cfd-42a9-a012-\
a0a03a270cac"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"nonlinear", " ", "example"}], ",", " ", 
    RowBox[{"quadratic", " ", "forms", " ", "zeros"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "1", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"randomMatrix", "[", "n", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], 
        RowBox[{"Random", "[", "]"}]}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f2", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p2"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f3", "[", "xvect_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", ".", "xvect"}], ")"}], ".", "xvect"}], "+", "p3"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vars", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "#"], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vectfces", "=", 
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f1", ",", "f2", ",", "f3"}], "}"}], "[", "vars", "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origEqns", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{"vectfces", "\[Equal]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"0", "&"}], "/@", 
         RowBox[{"Range", "[", "n", "]"}]}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"grad", "[", "expr_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"jacobian", "=", 
     RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Random", "[", "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"xPrevious", "-", 
      RowBox[{
       RowBox[{"Inverse", "[", 
        RowBox[{"jacobian", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
       RowBox[{"(", 
        RowBox[{"vectfces", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xNext", "[", "xStart", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"xNext", ",", "xStart", ",", "50"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{"origEqns", ",", 
       RowBox[{"Thread", "[", 
        RowBox[{"List", "[", 
         RowBox[{"vars", ",", "xStart"}], "]"}], "]"}]}], "]"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", "origEqns", "]"}]}], "\[IndentingNewLine]", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.68584374725*^9, 3.685843840265625*^9}, {
   3.68584390375*^9, 3.685843921375*^9}, 3.686319570890625*^9, {
   3.686369638140625*^9, 
   3.6863696604375*^9}},ExpressionUUID->"a7b9e635-b099-4170-929a-\
ea3ae4544ce8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7037477678697783`", ",", 
   RowBox[{"-", "1.5309905145107294`"}], ",", 
   RowBox[{"-", "0.6662538460075305`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.842492335805332*^9},ExpressionUUID->"b90db5c6-31a9-4d94-a261-\
72223f86cfc6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"load", " ", "flow", " ", "problem"}], ",", " ", 
    RowBox[{
    "cartesian", " ", "form", " ", "of", " ", "complex", " ", "numbers"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"simplify", "=", 
     RowBox[{"#", "&"}]}], ";"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "\"\<lower\>\"", " ", "programing", " ", "languages", " ", "have", " ", 
      "no", " ", "Mathematica", " ", 
      RowBox[{"Simplify", "[", "#", "]"}]}], "&"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"simplify", "=", "Simplify"}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"conjugate", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"re", ",", 
       RowBox[{"-", "im"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"times", "[", 
      RowBox[{
       RowBox[{"ua", ":", 
        RowBox[{"{", 
         RowBox[{"uare_", ",", "uaim_"}], "}"}]}], ",", 
       RowBox[{"ub", ":", 
        RowBox[{"{", 
         RowBox[{"ubre_", ",", "ubim_"}], "}"}]}]}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"uare", "*", "ubre"}], "-", 
        RowBox[{"uaim", "*", "ubim"}]}], ",", 
       RowBox[{
        RowBox[{"uare", "*", "ubim"}], "+", 
        RowBox[{"ubre", "*", "uaim"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"re", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"re", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"im", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{"im", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sqabs", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["re", "2"], "+", 
        SuperscriptBox["im", "2"]}], ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"powerMinus1", "[", 
      RowBox[{"z", ":", 
       RowBox[{"{", 
        RowBox[{"re_", ",", "im_"}], "}"}]}], "]"}], ":=", 
     FractionBox[
      RowBox[{"{", 
       RowBox[{"re", ",", 
        RowBox[{"-", "im"}]}], "}"}], 
      RowBox[{
       SuperscriptBox["re", "2"], "+", 
       SuperscriptBox["im", "2"]}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ratio", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
    RowBox[{"times", "[", 
     RowBox[{
      RowBox[{"powerMinus1", "[", "b", "]"}], ",", "a"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"times", "[", 
      RowBox[{"u", ",", 
       RowBox[{"conjugate", "[", "i", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"activePower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"re", "[", 
      RowBox[{"apparentPower", "[", 
       RowBox[{"u", ",", "i"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"reactivePower", "[", 
      RowBox[{"u_", ",", "i_"}], "]"}], ":=", 
     RowBox[{"im", "[", 
      RowBox[{"apparentPower", "[", 
       RowBox[{"u", ",", "i"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"current", "[", 
      RowBox[{"u1_", ",", "u2_", ",", "z_"}], "]"}], ":=", 
     RowBox[{"ratio", "[", 
      RowBox[{
       RowBox[{"u1", "-", "u2"}], ",", "z"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"toMyForm", "[", "z_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "z", "]"}], ",", 
       RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fromMyForm", "[", 
      RowBox[{"{", 
       RowBox[{"re_", ",", "im_"}], "}"}], "]"}], ":=", 
     RowBox[{"re", "+", 
      RowBox[{"I", "*", "im"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rearrangeRealEqn", "[", "eqn_Equal", "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"simplify", "[", "eqn", "]"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"Equal", "[", 
        RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{"Equal", "[", 
        RowBox[{
         RowBox[{"a", "-", "b"}], ",", "0"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rearrangeComplexEqn", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rea_", ",", "ima_"}], "}"}], "\[Equal]", 
       RowBox[{"{", 
        RowBox[{"reb_", ",", "imb_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"DeleteCases", "[", 
        RowBox[{"#", ",", 
         RowBox[{"rearrangeRealEqn", "[", "True", "]"}]}], "]"}], "&"}], "@", 
      RowBox[{"Flatten", "[", 
       RowBox[{"rearrangeRealEqn", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"simplify", "[", 
           RowBox[{"rea", "\[Equal]", "reb"}], "]"}], ",", 
          RowBox[{"simplify", "[", 
           RowBox[{"ima", "\[Equal]", "imb"}], "]"}]}], "}"}]}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rearrangeComplexEqn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "\[Equal]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rearrangeRealEqn", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}]}], "\[Equal]", 
      RowBox[{"y", "-", "x"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.686319588328125*^9, 3.6863196456875*^9}, {
   3.68631968075*^9, 3.686319865125*^9}, {3.6863199070625*^9, 
   3.6863201508125*^9}, {3.686320465609375*^9, 3.6863205451875*^9}, {
   3.686320598609375*^9, 3.68632071009375*^9}, {3.6863207813125*^9, 
   3.6863208234375*^9}, {3.686320899*^9, 3.686320913984375*^9}, {
   3.686320966625*^9, 3.68632110234375*^9}, {3.686321198015625*^9, 
   3.686321317671875*^9}, 3.68632140603125*^9, {3.686321932796875*^9, 
   3.686321933671875*^9}, {3.6863220218125*^9, 3.68632206846875*^9}, {
   3.68632216965625*^9, 3.686322249765625*^9}, {3.686322281375*^9, 
   3.68632252790625*^9}, {3.686322631125*^9, 3.686322729171875*^9}, {
   3.68632295625*^9, 3.6863229804375*^9}, {3.686323030578125*^9, 
   3.686323037125*^9}, {3.68632313046875*^9, 3.686323177765625*^9}, {
   3.686323819609375*^9, 
   3.686323852984375*^9}},ExpressionUUID->"4bb28f80-9b3a-4bc1-b609-\
309048cc817a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kz", "=", "2.5"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"respects", " ", "length", " ", "of", " ", "lines"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kReg", "=", "2.5"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"ratio", " ", "of", " ", "powers", " ", "of", " ", "sources"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["z", "1"], ",", 
     SubscriptBox["z", "2"], ",", 
     SubscriptBox["z", "3"]}], "}"}], "=", 
   RowBox[{"kz", "*", 
    RowBox[{"(", 
     RowBox[{"toMyForm", "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{".01", "+", 
         RowBox[{"0.05", "I"}]}], ",", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{"01", "+", 
           RowBox[{"0.05", "I"}]}], ")"}]}], ",", 
        RowBox[{"0.01", "+", 
         RowBox[{"0.02", "I"}]}]}], "}"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"powerFactor4", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"powerFactor5", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S4", "=", 
   RowBox[{
    SuperscriptBox["10", "3"], "*", 
    RowBox[{"{", 
     RowBox[{"powerFactor4", ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", "powerFactor4", "]"}], "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"S5", "=", 
   RowBox[{"500", "*", 
    RowBox[{"{", 
     RowBox[{"powerFactor5", ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", "powerFactor5", "]"}], "]"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["u", "#"], "=", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ure", "#"], ",", 
         SubscriptBox["uim", "#"]}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["i", "#"], "=", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ire", "#"], ",", 
         SubscriptBox["iim", "#"]}], "}"}]}]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", "5", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Unom", "=", "230."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnVoltage3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"sqabs", "[", 
      SubscriptBox["u", "3"], "]"}], "==", 
     RowBox[{"toMyForm", "[", 
      SuperscriptBox["Unom", "2"], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ1", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "1"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["z", "1"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ2", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "2"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "2"], ",", 
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["z", "2"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnZ3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     SubscriptBox["i", "3"], "==", 
     RowBox[{"current", "[", 
      RowBox[{
       SubscriptBox["u", "3"], ",", 
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["z", "3"]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnNod3", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], "+", 
      SubscriptBox["i", "2"]}], "==", 
     SubscriptBox["i", "3"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnNod4", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "4"], "+", 
      SubscriptBox["i", "5"]}], "==", 
     SubscriptBox["i", "3"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSourceActivePowerRatio", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"activePower", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["i", "1"]}], "]"}], "\[Equal]", 
     RowBox[{
      StyleBox["kReg",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"activePower", "[", 
       RowBox[{
        SubscriptBox["u", "2"], ",", 
        SubscriptBox["i", "2"]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSourcReactivePowerRatio", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"reactivePower", "[", 
      RowBox[{
       SubscriptBox["u", "1"], ",", 
       SubscriptBox["i", "1"]}], "]"}], "\[Equal]", 
     RowBox[{
      StyleBox["kReg",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"reactivePower", "[", 
       RowBox[{
        SubscriptBox["u", "2"], ",", 
        SubscriptBox["i", "2"]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnApparentPower4", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["i", "4"]}], "]"}], "\[Equal]", "S4"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnApparentPower5", "=", 
   RowBox[{"rearrangeComplexEqn", "[", 
    RowBox[{
     RowBox[{"apparentPower", "[", 
      RowBox[{
       SubscriptBox["u", "4"], ",", 
       SubscriptBox["i", "5"]}], "]"}], "\[Equal]", "S5"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnSettingAbsoluteTime", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["ure", "3"], "\[Equal]", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqnsTogether", "=", 
   RowBox[{"Union", "[", 
    RowBox[{
    "eqnVoltage3", ",", "eqnZ1", ",", "eqnZ2", ",", "eqnZ3", ",", "eqnNod3", 
     ",", "eqnNod4", ",", "eqnSourceActivePowerRatio", ",", 
     "eqnSourcReactivePowerRatio", ",", "eqnApparentPower4", ",", 
     "eqnApparentPower5", ",", "eqnSettingAbsoluteTime"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"unknownVariables", "=", 
   RowBox[{"Union", "@", 
    RowBox[{"Cases", "[", 
     RowBox[{"eqnsTogether", ",", 
      RowBox[{"Subscript", "[", 
       RowBox[{"_", ",", "_"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{"eqnsTogether", ",", "unknownVariables"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.686323252125*^9, 3.686323311484375*^9}, {
   3.686323384921875*^9, 3.68632340784375*^9}, {3.686323539125*^9, 
   3.686323660265625*^9}, {3.6863237423125*^9, 3.686323768453125*^9}, {
   3.686323838484375*^9, 3.686323858984375*^9}, 3.686324372234375*^9, {
   3.6863244051875*^9, 3.686324473171875*^9}, {3.686324504296875*^9, 
   3.68632457775*^9}, {3.686324611359375*^9, 3.686324635125*^9}, {
   3.686324671375*^9, 3.686324693328125*^9}, {3.686324741578125*^9, 
   3.686324789015625*^9}, {3.68632497278125*^9, 3.68632501803125*^9}, {
   3.686325060625*^9, 3.68632506421875*^9}, {3.686325146*^9, 
   3.686325231015625*^9}, {3.686325261109375*^9, 3.686325518875*^9}, {
   3.68632555503125*^9, 3.6863257609375*^9}, {3.686325887453125*^9, 
   3.686325922265625*^9}, {3.68632598828125*^9, 3.686325994640625*^9}, 
   3.686326092484375*^9, {3.686326561*^9, 3.68632662028125*^9}, {
   3.68632667290625*^9, 3.686326698015625*^9}, {3.686326728625*^9, 
   3.686326743703125*^9}, 3.68632820165625*^9, {3.68632934275*^9, 
   3.686329403734375*^9}, {3.686369759734375*^9, 
   3.686369759921875*^9}},ExpressionUUID->"853efc99-9044-410e-bcbc-\
0d6a40814674"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"18", ",", "18"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8424923358743267`*^9},ExpressionUUID->"2b330cd5-02d4-449e-b346-\
c5c6abbdb4bc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"secondParamteterOfFindRoot", "=", 
   RowBox[{"unknownVariables", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["iim", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["iim", "index"], ",", "1"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["ire", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ire", "index"], ",", "1"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["ure", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["ure", "index"], ",", "Unom"}], "}"}]}], ",", 
      RowBox[{
       SubscriptBox["uim", "index_"], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["uim", "index"], ",", "Unom"}], "}"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"solFindRoot", "=", 
  RowBox[{
   RowBox[{"FindRoot", "[", 
    RowBox[{"eqnsTogether", ",", "secondParamteterOfFindRoot"}], "]"}], "//", 
   "Chop"}]}]}], "Input",
 CellChangeTimes->{{3.686327757328125*^9, 3.686327926953125*^9}, {
  3.686327958671875*^9, 3.6863280118125*^9}, {3.68632822096875*^9, 
  3.68632822284375*^9}, {3.686328878609375*^9, 
  3.68632888253125*^9}},ExpressionUUID->"4fbadc51-1a73-4273-b3a6-\
f8b8f2b6057d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["iim", "1"], "\[Rule]", "3.6256443302614985`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "2"], "\[Rule]", "1.3789685430951788`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "3"], "\[Rule]", "5.0046128733566775`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "4"], "\[Rule]", "3.4816518881494782`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "5"], "\[Rule]", "1.5229609852071992`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "1"], "\[Rule]", "2.9780232293360345`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "2"], "\[Rule]", "1.1923826105388085`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "3"], "\[Rule]", "4.170405839874842`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "4"], "\[Rule]", "2.6146981516592738`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "5"], "\[Rule]", "1.5557076882155687`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "1"], "\[Rule]", "230.46289401192354`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "2"], "\[Rule]", "237.1929383681106`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "3"], "\[Rule]", "230.`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "4"], "\[Rule]", "229.66636438617235`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "1"], "\[Rule]", 
    RowBox[{"-", "0.3787549605492865`"}]}], ",", 
   RowBox[{
    SubscriptBox["ure", "2"], "\[Rule]", "5.617170916920248`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "3"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["ure", "4"], "\[Rule]", "0.14597049767096282`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.842492335905569*^9},ExpressionUUID->"30bafd53-2021-4d86-a769-\
5a1a3de0354f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectfces", "=", 
   RowBox[{"First", "/@", "eqnsTogether"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vars", "=", "unknownVariables"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"expr", ",", "#"}], "]"}], "&"}], "/@", "vars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"jacobian", "=", 
   RowBox[{"grad", "/@", "vectfces"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "%"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xStart", "=", 
   RowBox[{"unknownVariables", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["iim", "index_"], "\[RuleDelayed]", "1"}], ",", 
      RowBox[{
       SubscriptBox["ire", "index_"], "\[RuleDelayed]", "1"}], ",", 
      RowBox[{
       SubscriptBox["ure", "index_"], "\[RuleDelayed]", "Unom"}], ",", 
      RowBox[{
       SubscriptBox["uim", "index_"], "\[RuleDelayed]", "Unom"}]}], "}"}]}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
   RowBox[{"xPrevious", "-", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{"jacobian", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"vectfces", "/.", 
       RowBox[{"Thread", "[", 
        RowBox[{"vars", "\[Rule]", "xPrevious"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aux", "=", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{"xNext", ",", "xStart", ",", "50"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Thread", "[", 
  RowBox[{"vars", "\[Rule]", "aux"}], 
  "]"}], "\[IndentingNewLine]", "solFindRoot"}], "Input",
 CellChangeTimes->{{3.686328502015625*^9, 3.68632853075*^9}, {
  3.6863285624375*^9, 3.686328610890625*^9}, {3.68632872553125*^9, 
  3.686328893890625*^9}},ExpressionUUID->"57d90fed-dc25-4858-b876-\
091e4a840538"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["iim", "1"], "\[Rule]", "3.6256443302614985`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "2"], "\[Rule]", "1.378968543095179`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "3"], "\[Rule]", "5.0046128733566775`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "4"], "\[Rule]", "3.481651888149478`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "5"], "\[Rule]", "1.5229609852071992`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "1"], "\[Rule]", "2.9780232293360345`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "2"], "\[Rule]", "1.1923826105388085`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "3"], "\[Rule]", "4.170405839874843`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "4"], "\[Rule]", "2.6146981516592738`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "5"], "\[Rule]", "1.555707688215569`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "1"], "\[Rule]", "230.46289401192354`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "2"], "\[Rule]", "237.1929383681106`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "3"], "\[Rule]", "230.`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "4"], "\[Rule]", "229.66636438617235`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "1"], "\[Rule]", 
    RowBox[{"-", "0.3787549605492865`"}]}], ",", 
   RowBox[{
    SubscriptBox["ure", "2"], "\[Rule]", "5.617170916920246`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "3"], "\[Rule]", "0.`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "4"], "\[Rule]", "0.14597049767096282`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8424923359745693`*^9},ExpressionUUID->"1512b976-1879-43e7-a60e-\
927bb88f8485"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["iim", "1"], "\[Rule]", "3.6256443302614985`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "2"], "\[Rule]", "1.3789685430951788`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "3"], "\[Rule]", "5.0046128733566775`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "4"], "\[Rule]", "3.4816518881494782`"}], ",", 
   RowBox[{
    SubscriptBox["iim", "5"], "\[Rule]", "1.5229609852071992`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "1"], "\[Rule]", "2.9780232293360345`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "2"], "\[Rule]", "1.1923826105388085`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "3"], "\[Rule]", "4.170405839874842`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "4"], "\[Rule]", "2.6146981516592738`"}], ",", 
   RowBox[{
    SubscriptBox["ire", "5"], "\[Rule]", "1.5557076882155687`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "1"], "\[Rule]", "230.46289401192354`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "2"], "\[Rule]", "237.1929383681106`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "3"], "\[Rule]", "230.`"}], ",", 
   RowBox[{
    SubscriptBox["uim", "4"], "\[Rule]", "229.66636438617235`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "1"], "\[Rule]", 
    RowBox[{"-", "0.3787549605492865`"}]}], ",", 
   RowBox[{
    SubscriptBox["ure", "2"], "\[Rule]", "5.617170916920248`"}], ",", 
   RowBox[{
    SubscriptBox["ure", "3"], "\[Rule]", "0"}], ",", 
   RowBox[{
    SubscriptBox["ure", "4"], "\[Rule]", "0.14597049767096282`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8424923359901905`*^9},ExpressionUUID->"4c393327-07b0-4381-9fad-\
b418b38453b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mf", "@", 
  RowBox[{"(", 
   RowBox[{"Chop", "@", "jacobian"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.6863292439375*^9, 3.686329247578125*^9}, 
   3.68632932628125*^9, {3.68632945040625*^9, 3.686329468078125*^9}, {
   3.686369802109375*^9, 
   3.686369832921875*^9}},ExpressionUUID->"2691356d-6324-4d94-be54-\
b1c11c14e2cd"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", 
      RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0"},
     {"0", "0", 
      RowBox[{"-", "1"}], "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "1", "1", 
      RowBox[{"-", "1"}], "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"-", "1"}], "1", "1", "0", "0", "0", "0", "0", "0", "0", "0"},
     {
      RowBox[{"-", 
       SubscriptBox["ure", "1"]}], 
      RowBox[{"2.5`", " ", 
       SubscriptBox["ure", "2"]}], "0", "0", "0", 
      SubscriptBox["uim", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["uim", "2"]}], "0", "0", "0", 
      SubscriptBox["ire", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["ire", "2"]}], "0", "0", 
      RowBox[{"-", 
       SubscriptBox["iim", "1"]}], 
      RowBox[{"2.5`", " ", 
       SubscriptBox["iim", "2"]}], "0", "0"},
     {
      SubscriptBox["uim", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["uim", "2"]}], "0", "0", "0", 
      SubscriptBox["ure", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["ure", "2"]}], "0", "0", "0", 
      SubscriptBox["iim", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["iim", "2"]}], "0", "0", 
      SubscriptBox["ire", "1"], 
      RowBox[{
       RowBox[{"-", "2.5`"}], " ", 
       SubscriptBox["ire", "2"]}], "0", "0"},
     {"0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      RowBox[{"-", "7.692307692307692`"}], "0", "7.692307692307692`", "0", 
      RowBox[{"-", "1.5384615384615383`"}], "0", "1.5384615384615383`", "0"},
     {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"-", "1.5384615384615383`"}], "0", "1.5384615384615383`", "0", 
      "7.692307692307692`", "0", 
      RowBox[{"-", "7.692307692307692`"}], "0"},
     {"0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      RowBox[{"-", "0.00997506234413965`"}], "0.00997506234413965`", "0", "0", 
      RowBox[{"-", "0.19950124688279303`"}], "0.19950124688279303`", "0"},
     {"0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"-", "0.19950124688279303`"}], "0.19950124688279303`", "0", "0",
       "0.00997506234413965`", 
      RowBox[{"-", "0.00997506234413965`"}], "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "1", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"2", " ", 
       SubscriptBox["uim", "3"]}], "0", "0", "0", 
      RowBox[{"2", " ", 
       SubscriptBox["ure", "3"]}], "0"},
     {"0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "0", "0", 
      RowBox[{"-", "15.999999999999998`"}], "15.999999999999998`", "0", "0", 
      RowBox[{"-", "7.999999999999999`"}], "7.999999999999999`"},
     {"0", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      RowBox[{"-", "7.999999999999999`"}], "7.999999999999999`", "0", "0", 
      "15.999999999999998`", 
      RowBox[{"-", "15.999999999999998`"}]},
     {"0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["ure", "4"]}], "0", "0", "0", "0", 
      SubscriptBox["uim", "4"], "0", "0", "0", "0", 
      SubscriptBox["ire", "4"], "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["iim", "4"]}]},
     {"0", "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["ure", "4"]}], "0", "0", "0", "0", 
      SubscriptBox["uim", "4"], "0", "0", "0", 
      SubscriptBox["ire", "5"], "0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["iim", "5"]}]},
     {"0", "0", "0", 
      SubscriptBox["uim", "4"], "0", "0", "0", "0", 
      SubscriptBox["ure", "4"], "0", "0", "0", "0", 
      SubscriptBox["iim", "4"], "0", "0", "0", 
      SubscriptBox["ire", "4"]},
     {"0", "0", "0", "0", 
      SubscriptBox["uim", "4"], "0", "0", "0", "0", 
      SubscriptBox["ure", "4"], "0", "0", "0", 
      SubscriptBox["iim", "5"], "0", "0", "0", 
      SubscriptBox["ire", "5"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.842492336043564*^9},ExpressionUUID->"a1a90d17-60fb-456c-8efb-\
16d484bd5a64"]
}, Open  ]]
},
WindowSize->{1072, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.4000000953674316`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1014, 31, 153, "Input",ExpressionUUID->"5f99be5e-536f-498d-ba57-4445edc459ec"],
Cell[1574, 53, 854, 25, 69, "Input",ExpressionUUID->"fe222c62-ebb0-4afd-9ee2-83eb715e0222"],
Cell[CellGroupData[{
Cell[2453, 82, 3408, 109, 545, "Input",ExpressionUUID->"1b6c7b71-2e9d-4942-9c98-57ff9ebcd0a9"],
Cell[5864, 193, 279, 8, 46, "Output",ExpressionUUID->"b9965460-367a-4ebf-9bd8-45a9f6439d53"],
Cell[6146, 203, 478, 15, 46, "Output",ExpressionUUID->"abfabc98-5cfd-42a9-a012-a0a03a270cac"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6661, 223, 4213, 127, 629, "Input",ExpressionUUID->"a7b9e635-b099-4170-929a-ea3ae4544ce8"],
Cell[10877, 352, 277, 7, 46, "Output",ExpressionUUID->"b90db5c6-31a9-4d94-a261-72223f86cfc6"]
}, Open  ]],
Cell[11169, 362, 7037, 205, 719, "Input",ExpressionUUID->"4bb28f80-9b3a-4bc1-b609-309048cc817a"],
Cell[CellGroupData[{
Cell[18231, 571, 7781, 228, 772, "Input",ExpressionUUID->"853efc99-9044-410e-bcbc-0d6a40814674"],
Cell[26015, 801, 179, 5, 46, "Output",ExpressionUUID->"2b330cd5-02d4-449e-b346-c5c6abbdb4bc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26231, 811, 1331, 36, 127, "Input",ExpressionUUID->"4fbadc51-1a73-4273-b3a6-f8b8f2b6057d"],
Cell[27565, 849, 1656, 43, 103, "Output",ExpressionUUID->"30bafd53-2021-4d86-a769-5a1a3de0354f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29258, 897, 2214, 62, 378, "Input",ExpressionUUID->"57d90fed-dc25-4858-b876-091e4a840538"],
Cell[31475, 961, 1657, 43, 103, "Output",ExpressionUUID->"1512b976-1879-43e7-a60e-927bb88f8485"],
Cell[33135, 1006, 1658, 43, 103, "Output",ExpressionUUID->"4c393327-07b0-4381-9fad-b418b38453b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34830, 1054, 352, 8, 40, "Input",ExpressionUUID->"2691356d-6324-4d94-be54-b1c11c14e2cd"],
Cell[35185, 1064, 4757, 114, 470, "Output",ExpressionUUID->"a1a90d17-60fb-456c-8efb-16d484bd5a64"]
}, Open  ]]
}
]
*)

