(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106518,       2190]
NotebookOptionsPosition[    103084,       2127]
NotebookOutlinePosition[    103565,       2145]
CellTagsIndexPosition[    103522,       2142]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
      {"7", "10", "8", "7"},
      {"6", "8", "10", "9"},
      {"5", "7", "9", "10"}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"detMat2", "=", 
   RowBox[{"Det", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<determinant= \>\"", ",", "detMat2"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"invEps", "[", "\[Epsilon]_", "]"}], ":=", 
   RowBox[{"Inverse", "[", 
    RowBox[{"mat2", "[", "\[Epsilon]", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mf", "[", 
  RowBox[{"invEps", "[", "\[Epsilon]", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 3.676092822828125*^9}, {3.6851971430625*^9, 
  3.685197182328125*^9}},ExpressionUUID->"5e05fc09-c28a-4694-b565-\
fb02957fc2b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"determinant= \"\>", "\[InvisibleSpace]", 
   RowBox[{"1", "+", 
    RowBox[{"68", " ", "\[Epsilon]"}]}]}],
  SequenceForm["determinant= ", 1 + 68 $CellContext`\[Epsilon]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.841885677309904*^9},ExpressionUUID->"41be8a6c-55e5-4b65-86d6-\
c5b064ecd55a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["68", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["41", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"25", "+", 
        RowBox[{"19", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      RowBox[{"-", 
       FractionBox["17", 
        RowBox[{"1", "+", 
         RowBox[{"68", " ", "\[Epsilon]"}]}]]}], 
      FractionBox[
       RowBox[{"10", "-", 
        RowBox[{"17", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"5", "+", 
        RowBox[{"51", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]},
     {
      FractionBox["10", 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "6"}], "+", 
        RowBox[{"2", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"34", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]], 
      FractionBox[
       RowBox[{"2", "+", 
        RowBox[{"36", " ", "\[Epsilon]"}]}], 
       RowBox[{"1", "+", 
        RowBox[{"68", " ", "\[Epsilon]"}]}]]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.8418856774192533`*^9},ExpressionUUID->"707c625c-4f9a-465f-a2a9-\
4b7257a4147b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "We", " ", "see", " ", "the", " ", "dependance", " ", "of", " ", "the", 
    " ", "inverse", " ", "matrix", " ", "as", " ", "an", " ", "expression", 
    " ", "containing", " ", 
    RowBox[{"\[Epsilon]", ".", " ", "Generally"}]}], ",", " ", 
   RowBox[{
   "all", " ", "the", " ", "terms", " ", "of", " ", "the", " ", "matrix", " ",
     "is", " ", "known", " ", "only", " ", "approximately"}], ",", " ", "so", 
   ",", " ", 
   RowBox[{
   "the", " ", "determinant", " ", "and", " ", "the", " ", "inverse", " ", 
    "matrix", " ", "can", " ", "be", " ", "assumed", " ", "as", " ", "a", " ",
     "function", " ", "of", " ", 
    SuperscriptBox["n", "2"], " ", "terms", " ", 
    SubscriptBox["\[Epsilon]", 
     RowBox[{"i", ",", "j"}]]}], ",", " ", "i", ",", "j", ",", " ", "1", ",", 
   "2", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3", "..."}], "n"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MatrixRank", "[", "mat2", "]"}], ".", "\[IndentingNewLine]", 
       SuperscriptBox["n", "2"]}], " ", "variables"}], " ", "=", 
     RowBox[{">", " ", "possible"}]}]}], ",", " ", 
   RowBox[{
   "but", " ", "not", " ", "easy", " ", "way", " ", "how", " ", "to", " ", 
    "study", " ", "the", " ", "changes", " ", "of", " ", "the", " ", 
    "inverse", " ", "matris", " ", "and", " ", "solution", " ", "of", " ", 
    "the", " ", "seto", " ", "of", " ", "equations"}]}], " ", 
  "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.685197212703125*^9, 3.68519741396875*^9}, {
  3.685197474984375*^9, 3.685197519828125*^9}, {3.6851975590625*^9, 
  3.6851976230625*^9}},ExpressionUUID->"c9a8d6ce-c61d-4aaf-b9d8-c7209ad2a2ef"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"norm1", "[", "vect_", "]"}], ":=", 
   SqrtBox[
    RowBox[{"Plus", "@@", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         SuperscriptBox["#", "2"], "]"}], "&"}], "/@", "vect"}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm2", "[", "vect_", "]"}], ":=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "vect", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"norm3", "[", "vect_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"(", 
     RowBox[{"Abs", "/@", "vect"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm2D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "None"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}], "]"}], 
         "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm2D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.685197385390625*^9, 3.685197390046875*^9}, {
   3.6851976698125*^9, 3.685197746046875*^9}, {3.6851977818125*^9, 
   3.68519782909375*^9}, {3.685197876890625*^9, 3.685197915140625*^9}, {
   3.6851979521875*^9, 3.68519802796875*^9}, {3.6851980934375*^9, 
   3.685198098390625*^9}, {3.685198132078125*^9, 3.685198283140625*^9}, {
   3.685198362140625*^9, 3.68519836546875*^9}, {3.685198423984375*^9, 
   3.68519843240625*^9}, 
   3.685199038140625*^9},ExpressionUUID->"22ef948d-9390-4fb5-9583-\
0e16a716f665"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlwtMlmUUx9GlzOkyTY1MBFnqDB0aRJmXI5WznJJpkbkcm5vlPZ2TLDdT
N1uxuZSVWaZRM2vLlFBqmnLAqa2ipQ0oU4pLJjf5QFMIb+F3zu91fN8+9m68
3/u8z7n8zv//DJn3ysz5XaOiouo7/m5d85e+vXnkwgp9MudqwYrFjVr+zdIz
HV/N7dI6uEtto57p/t6sZ/JPq2ZLe1L6BU34offa+TPKteCrQdmZ1y5on8yW
/pktZXptypTy6b2bNCfj7sfvSivTI9WJhdWJTTrqi/PvrP/klI5KPlcRd7RJ
p0WvmhG96qROuz5cExqbVFNvXgldKtH923YvWDQipN1f23lo7us/6rgRz7+c
kB7SXuH1j2vbUyeXrX8zpC2zV0Y/El+s926aWnGsIKQLf60bOyxFNTlq8eGC
4pB2Df++QCdWpT5bUhXSxv3vDl08b4/eGLVxeY+LIV2fOHHO6NodmhYbM/jn
9pBGhT8Hxtu1WYeMDN8X7icfCD8v1/35B2x9Ge/rb7f3yxje/0J4fxLj+4u3
/Qv772fxyViP76zFL3kef4blR8hPiuVPRnr+Nlt+hfzGleadXvp9mciOnvH1
A5r0PquHtHs9kq1e8rXXq9rqKYVez0qrt+z0eh+0fpAp3g/L1p2YM3VJpeiE
QadWZjXorPD+KqVrSf/WrSsa9OF1N9KyXq2UwqTWkqHLG7Tv7tKJiWsq5Y/w
ug16ucveA0cSquWDjbUvps2t12GrPnu/25Zqqc29s77jq6nJtz418ljG7AHl
2+r0ZnSvqPxva6Qo863jPVLqtOXKpYyG5/6W1ux9bdn7avXMsAr9K/WcHJq5
/dOel89rTDjec7J24EI5O/m8/jLujZd25v4jP9lVN9j/pZ/9TgvtOfnN1tGr
tq402nv0mL1X2m0fOtn2JWNsn9po+5Y4i0M/srik2eLURaeqDg/OqZdJsaVp
saVV+qflQQb/ntqasaZSiy1PMsbypt0sj5JuedUiy7MssbzrVKuD7HFOP7Y6
CZwWWR2lzDn1Osto59S5FDhNsz6RvtY3Wmx9JKud2yTrMxnu3E63PhS4zbc+
lVLndrz1sbStNm69zwVunVOpcW4fNE5kk3PrnArcOqeS59w6h3KHcem8Ngvc
cn+Xc8vzV+x5OBW4dU5FnVv296/tD04Fbh/1+HwuyT6Pv8W5dU4Fbn3OSZJz
S36znNtJnv8Y5/Y/rw/c7vX6pTm3PnflrHO7w+sPtz63Zb9z+533T5Zz65wK
3BZ5/z3k3NKfvZzb7d7Pl5zbe1pKn96ztU7g9Kjzcd05jeBHDjtfp51T51Lg
tMT55BrBb/Ac67Au7+G97CNifki8zxc4JQ7iesK4lAXOaZxxGeSBvJAn8hab
u+b+LStu55U8k3fqQF2oE3WjjtSVOlN3+oC+oE/oG/qIvqLPIvQi6Ev6lL6l
j+nrL6dXJB/q6PP0ATl9ZMNxyW+7leDbHMCFdtY3idC/gDO429VZPyVCXwOO
uZ/XWZ8lQr+DOcHcqOms/zLB9q/sn7lDfMwl5hRziznGXGPOMfeYg8xF8s/c
ZI5G+J9g7jKHmcvMaeY2c5y5zpxn7qMD6EK89x+6gY70NG4DnUGH0CV0a6Bz
jK6hc+gefKGL6CS6iY6iq+gsugvH6DI6jW6j4+g6Ou/zJfAB+AR8Az4CX4HP
wHc4l4EvwafgW/Ax+Bp8Dpzig/BF+CR8Ez4KTvFZ+C58GL4Mn4Zvw8fBKT4P
34cPxBd63wa+ca/1tR50TvGV+Ex8Jz4UXwqn+FZ8LL4Wn4vvjdDTwCfjm/HR
+Go4xXfjw/Hl+HT2/7lzSnxwis/H93MO4FxA/uCUcwTnCvLPucPnpvocDc4l
cMq5hXMM5xrOOZx74JRzEeekE95f85xT51ID/+b9meKcRvSvfuj9fdE5xQcP
dT/pflPh1nVOrzm38NTs3LpOqusmnCrcus4G1wieg+dYh3V5D+9lHxHzJIiD
uIiTuMkDeSFP7nuDPJLXyPPo/+DTvcQ=
       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], 
           LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
             18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
            34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
            50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
            66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
            82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
            98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 
            111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
            124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
            137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
            150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
            163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
            176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
            189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
            202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
            215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 
            228, 229, 230, 231, 232, 233, 234}]},
          RowBox[{
            SqrtBox[
             RowBox[{
               SuperscriptBox[
                RowBox[{"Abs", "[", 
                  TagBox["x", HoldForm], "]"}], "2"], "+", 
               SuperscriptBox[
                RowBox[{"Abs", "[", 
                  TagBox["y", HoldForm], "]"}], "2"]}]], "\[Equal]", "1"}]],
         Annotation[#, (Abs[
               HoldForm[$CellContext`x]]^2 + Abs[
               HoldForm[$CellContext`y]]^2)^Rational[1, 2] == 1, 
          "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[SqrtBox[RowBox[{SuperscriptBox[TemplateBox[List[\
\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"]}]], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztl29olmUUxt8MHLVwRA0SWaVYo0ZISPmHwgwJBxIjqUUiQ2GFkCS5fZAZ
QvuktsI3SkRk2gddgg4iBYN5kTaoTFjuNdFszZWlyz9NIoUg6j7nfa+bc8H7
2S97GDz8tj3Pcz/nPuf8zjNz9VsvtU8pFAqf3lEopPPeOSNv1713HQU7/lx0
8NaW/ltbMt/Z2VLT2ZJ51UR920R95sNrf/z/5xq5dnz3tPHdmde8no7MA2NN
R8eaMq9Llx++Sv6qdeNg68bM00uLG0qLM39nxxXypsF0QebGo+kBf5DP2QIz
9/SnFxwnP9XXvbCvO/OltPxpmXfuSMdl8pLi7Obi7Mw3U7j6L5H3p9stzLw8
vc7g7+SpFs/MRyx+v+X4Wrwy39+WAn4xxytdXpPZwtPwK/nJuen4hfx+Wm7z
GPlG2r62C+QX0+06R8kv2/7+TG6wB/xE/sE3nPyBxecs+VV73zPke239p8nf
2npL5A9tfafIy2w9Q+S77PknZT++Id9j9x8kv2P3O0Z+0K4fIE+x/z9EPjGc
/n6APMv+fxfZz58/U+Fj/vdFFZ5hfID8uN+f/II/n7zN10d+2NdP7vf3I3v8
T5Jf8fiQd3n8yJ4Ppbw+jz95te8PeYfvH3nU95fc6PtPbvP8IC/3/CH/7flF
Lnr+kZ/2/CSf9fwld3p+kx/w/Ce3e32QB7x+yHd7fZFbvf7IB70+yf94/ZKX
en2Te73+yVe8P5AXeP/I++v9hTzi/Yfc5P2J3O39izzk/U32/yq5w/sl+Uvv
p+S13m/Jdd6PyV94v87x9H5OrvF+T/7MfUCe774gV86THpn0yKRHJj1SYfVI
l9XXefJj4pXjVs8j5JXimal2zp5R73i5Zb4pHlpir3NB4pe9dNkbc1VPWTn2
ZT4n3mpMtytm7hCPnbB+dPu8ts/ik7lZPPeXxau69zwdqntwu8WzuhcvWnyr
e9LCPTd7Ub252eJf3aNnbIHZm+rVR+yFq3u2y/Yre1W9+7X7hLxePGzhm7j9
Xp4XPQzxMGqih7EyehjiYdRFD6M9ehjiYbwZPYyG6F2Id9EVvYum6F2Id7E5
ehcLonch3sX26F0sjd6FeBd7o3fRGr0L8S4ORe+W45NZvIvj3gfI66OHMcv7
CPn76GW8632ILJ7GqAeQvC16G895HyRfjx5Hr/dRsni9nC/0Ouqj1yFeL8ef
XkdL9DrE6zgVvY6t0esQr2N69Dq2Rq9DvI6e6HX8Oxy8DvE6akvB6/hkOHi9
fKbX8Xz0OlZEr0O8jkej17Eneh3idfRGr+OJ6HWI1/FR9DrOR69DvI7Xotex
J3od4nU8FD2ON6K3IZ7GjehlfBw9DPEuTkfPYkP0KsSjWBM9iiPRoxCPYkX0
KPZHj0I8imXRm9gZPQnxIp6NHkRP9B7Ec5gTvYZN0WMQb2Fm9BTWRS9BPFSO
T+b7oocgHsKq6CHURg9BPIS++H3IOtknv9fr9L76XF2XrlvfS99b46Jx07hq
3HVfdN90X3XfNS80bzSvNO80LzVvNa8177UutG60rrTutC61brWute61L2jf
0L6ifUf7kvYt7Wva97Qvat/Uvqp9V/uy9m3t69r31Qt+zt5Qr6h31EvqLfWa
ek+9qN5Ur6p31cvqbfW6el/nAp0bdK7QueOazClFmWt0DhqSualD5iydy3Ru
07lO5z6dC3Vu1LlS506dS3Vu1blW516di3Vu1rla526dy3Vu17le5379LtDv
Bv2u0O8O/S6pfLf8B/6hWEQ=
       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], 
           LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
             18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
            34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
            50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
            66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
            82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
            98, 99, 100}], 
           LineBox[{101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
            112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
            125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
            138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
            164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 
            177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
            190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
            203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 
            216, 217, 218, 219, 220, 221}], LineBox[CompressedData["
1:eJwNzkVCAgEAAMDFbgG7UBAxsLsF6wE+wZsX/LHd3a04h7lPfHt3KxcKgmCH
PfY54JAjjjnhlDPOueCSK6654ZY77nngkSeeeeGVN9754JMvvvnhlz/yBEIh
CiikiGJKKKWMciqopIpqaqglTIQoddTTQCNNNNNCK22000GMTrqIk6CbJD2k
6KWPfgZIM8gQw4wwyhjjTDDJFNPMMMsc8yywyBLLrJAhyyprrLPBJv/z+CvG

            "]], LineBox[CompressedData["
1:eJwVztc6ggEAgOHfpbga2ZW9UyirZG8hWSF7Z5bcpdfB+zzf4Vcfz0TTdUEQ
JGgQIRppopkWWmmjnTARonTQSRfd9NBLH/0MMMgQw4wQY5Q4CcYYZ4IkKSaZ
YpoZZvmfzDBHlnkWWGSJZVZYZY11Nthki212yLHLHvvkOaDAIUccc8IpRc44
54ISl1xxzQ233HHPA4888cwLr5R5450PPvnimwpVfqjxyx/wPDDi
            "]]},
          RowBox[{
            RowBox[{"Max", "[", 
              RowBox[{
                RowBox[{"Abs", "[", 
                  TagBox["x", HoldForm], "]"}], ",", 
                RowBox[{"Abs", "[", 
                  TagBox["y", HoldForm], "]"}]}], "]"}], "\[Equal]", "1"}]],
         Annotation[#, Max[
            Abs[
             HoldForm[$CellContext`x]], 
            Abs[
             HoldForm[$CellContext`y]]] == 1, "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{\\\"max\\\", \\\"(\\\", \
RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"]}], \\\")\\\"}], \
TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmHlsVGUUxUdUMAZJ2IxISMDUaGgCUSPBBr1iCAZBRVCKJVIgbBrqRkpQ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       "], {{}, {}, 
        TagBox[
         TooltipBox[
          {RGBColor[1, 0, 0], Thickness[Large], LineBox[CompressedData["
1:eJwl1FV0EAQYBeCNUaMZo3PUgu5mdIOklEhJiXRJd4eSSiPdUgoqIB0qDQJS
SoNSEkrz7fDw3f/9nnP/sDbd6ncNDAgIqClibiyCiE0c4hKP+ASTgIQkIjFJ
SEoykhNCCkJJSSpSk4a0pCM9GchIJjKThTCyko3s5CAn4UQQSRS5yE0e8pKP
/BSgIIUoTBGKUozilKAkpShNGcoSTTnKU4GKVKIyVahKNapTI6YralGbOnxA
XepRnwY0pBEf0pgmNKUZzfmIFnxMS1rRmja05RPa0Z4OdKQTn9KZz+hCV7rR
nR70pBe96UNf+vE5/RnAQAYxmCEMZRjDGcFIRjGaMYxlHOOZwEQmMZkpfMGX
TGUa05nBTGbxFV8zmznMZR7zWcBCFvENi1nCUpaxnBWsZBWrWcNa1rGeb9nA
RjaxmS18x/dsZRs/8CM/sZ0d7ORndrGbPexlH/s5wEEOcZhf+JXfOMJRjnGc
E5zkFKc5w++c5Rzn+YMLXOQSl7nCn/zFVa5xnRvc5Ba3ucNd/uYf7nGfBzzk
Ef/ymCc85Rn/8T/PecFLXvGaN7wlZvyBxCKI2MQhLvGITzAJSEgiEpOEpCQj
OSGkIJSUpCI1aUhLOtKTgYxkIjNZCCMr2chODnISTgSRRJGL3OQhL/nITwEK
UojCFKEoxShOCUpSitKUoSzRlKM8FahIJSpThapUozo1At//ync1g4zu
            "]]},
          RowBox[{
            RowBox[{
              RowBox[{"Abs", "[", 
                TagBox["x", HoldForm], "]"}], "+", 
              RowBox[{"Abs", "[", 
                TagBox["y", HoldForm], "]"}]}], "\[Equal]", "1"}]],
         Annotation[#, Abs[
             HoldForm[$CellContext`x]] + Abs[
             HoldForm[$CellContext`y]] == 1, "Tooltip"]& ]}],
      AspectRatio->1,
      AxesLabel->{None, None},
      AxesOrigin->{0., 0.},
      DisplayFunction->Identity,
      Frame->None,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "GridLinesInFront" -> True},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\
\"], \\\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\
\"Abs\\\"]}], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{{-1.2, 1.2}, {-1.2, 1.2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, Automatic}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.8418856794500265`*^9},ExpressionUUID->"c0bbc32e-c1ef-4bef-822e-\
823563f390f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotNorm3D", "[", "norm_", "]"}], ":=", 
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"norm", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], "\[Equal]", "1"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<1=\>\"", "<>", 
       RowBox[{"ToString", "@", 
        RowBox[{"TraditionalForm", "[", 
         RowBox[{"norm", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], 
          "]"}], "]"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"plotNorm3D", "/@", 
   RowBox[{"{", 
    RowBox[{"norm1", ",", "norm2", ",", "norm3"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.68519851934375*^9, 3.685198525078125*^9}, {
  3.685198564015625*^9, 3.685198610578125*^9}, {3.6851986656875*^9, 
  3.685198666375*^9}, {3.685198705796875*^9, 3.685198710421875*^9}, {
  3.685198750140625*^9, 3.68519875815625*^9}, {3.68519880321875*^9, 
  3.6851988208125*^9}, {3.685198851578125*^9, 
  3.685198877265625*^9}},ExpressionUUID->"280d806d-36c6-4b1c-a6d3-\
dfbe0c1b5445"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVmG9o1WUUx29/vb0oHUrJ3aqN3UnN6EVDEMJ+LZJmkca2mwQmMc3+it00
xPnC1OiFKEqBbGVCIqug7I+KOsXbCibaH4jtYpu70thGuljWXoR/Snsu/D4/
Hr5y+N376sdz7nnOOc/3PM8533Nr2lY1v3hjIpFI3pBI3OS+e9v3LywUJnKL
Nn413PNyPnffOy/131HRk7t8983p17dfiNZ80WfNPuSL79p37Vu3vvhR99PT
K3qCs1O++O81zw5ytdNysnnc2Yn00VO/yPGz9+/MaV9f7bN+a+kzyaJ95PhT
++ixr2qyvrc1M5ab3tL25Jvtv0fxsuZ35KlwzXf28Dfff+fiRO/2WSdnFvdh
nzW/I1c71fWZH52doDJcHzjVd/rTutFcuu/x9R2dA7nnv3zgnx1rxqM1X/RZ
s29FS2F8W3IikhP/uo6OnqK8LpQrDgfyG9LF/dNe+PPQB50DwcZXhlb6fpFX
id++ncuG3L5AcUkZ+LJf8UWP+JHj53zN1FW+nHjA4dyurueOO787Dm8YzWTG
gto3ljdnPb/IK8Vv/8j7S5zfQPOncWpewRM5uDatODXflxNnw2M/VGc9+xoP
8sFDl+uL8ej9YE1esAs+xImcfIIbcs5NnMjx/1P11rHtnn3Fed5wU5vDOYpf
/S74eOr9xfuAfn94P4iTvLCfeNBHTj7nhLgh1/w8EfrTONF/NIw3iifMt/od
CnHHvvX+eGf6/vRd6jvWe8190XuEvuaZfCremv8+wfugxHtQ4rLOoec+v3ny
80/cPnBlze/I1c6e3u4rzk6g9Qg8akWeXb3tLycPtE6BU1rkmw43nSjqa/3S
OqV1bcvm3Ze6PH2NH3nv26+u9uPPh/iCm+JC3HWCC3r4Ra55rFm06Wund108
rPndwpcvOGodBS+9b5xT64TyBeUFFo9Q3qH9P+rz0s/VjvZz7c/ab1JS360+
b/VJq15q3aI+ab3RuqL1xqoHtUbeFG/F1crDJcnb1hO79x91+2Y2JleeLUwE
rPkdudr57J5b6pydQPmf+lVeOHLnrl+6PX21jzyf3HfV6Ufy1jDfap98KA+4
97bGY+4c19mvCPUnGnNringqP1AeoLwhvaTzwhFPX/PLetatO5dnvfySb7VP
Xsnze5IPxR05eqMhnsj1vXBOvbfogxNy4tZzkW+NhzxZfLzk+SCG11s8vVR+
bfFci+80GPyC/A0KL4jr21pfy61/IzF5tvKwx8D1t8lnf/X118q8pDxV+euW
xY8MdnvvS/UXvNv+lH9ecLT47vyBfx/KenieCfFVHgyO2u+JY1TqC3FoftHn
HMiJQ/Ou9cjCscWoUzqPoq88PiU8rtw5zJqHrPnD4vX4hbfPE75s8ZRS+Wkc
34F3tBpzu9Yzzl0hcuqf1jnyv1bqitqPqxPcL71H2FdcfzbwnjE39YeTBzpH
VQpuzDWKJ/rgWvjw4YtHPDuKc8PCB692eXxS7fC7xXet/jpN+ivycuuF4sK6
X3i28uBy5/45MfM3c6KFe17mKn0f9AVrTtJ5IG7+gOcr37f4SKn8NI7XKC+I
65PUUZ3Dq8RvXF0BD72PGmep973cOUrtgVO57ycuXuWLVl+0eOSQ0S/j5kCd
c6z+qu8/eo/G/yY6r8Bvlb9ac4byYO3rWl+IR+1Qpyx8zwiPI35rHtb6ZfFv
6p1V1zSvxKPzNn7L5fHl8h6ts3ytecDiSXFzgjXnKZ9VXsX3f8FZEYc=
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           TagBox[{Polygon3DBox[CompressedData["
1:eJw11Hloz3Ecx/HPxgwbm6uMKUMxytyMYnP9M9d+rLZhRijX5kiGWMMOamrO
FhLGKLei3FcyN5s55hw7UBYLEfF8933549Hn8/v8Pn0+7+/7/f5+I2ak+9L8
nXOpaAA/+GveBwPRF9fwFpfwAbdxC+9xE1dxBx9xF4PQDwPwCQ/xANEYjCGI
Qld0wyh0RDvEIRI9EIvhGIFhGIoYdEdv7emPnuiF9trfBnUox2O8whWcR0Me
spaxGgHMvzB+xV8E8vsnYz0aMf/GWIk/eGm5Ya2K8Q0e4TNKUWM54793ykmV
zn+CMu25r3gsDy9QoTMtttc6s1J5tnMuas85tFLeQpSHtmipvI3EaExQTqxe
UzEFKZim+k5HInyYhCQkY7Jy6FO90rEECzERYzFOdRmPMZile2NUo1TV1NZn
YjbmYC7mYQHmI01xJiAe65CJLCzT+fG6d7niDEQQGiMYTdBUOWmtWrdAqHLS
DM2VqwCrt9XSef1mz/K/T8LRAZ2d129dFMNKZGApFmExfqtGz7EKa7EaYaqF
9W2E83q4E9Yo/hXO64HveGrPQI/44RfzzTiNLcjHUWxECQ7hoPN65jiOIRcH
kIfDuIcjOIVNKMAJnWPrl7EXO53Xq7bf3s0bKMIe7EcOslGsu+zefbiO3Vrf
gPU63/r5pOK099q+A9txBlud17cXnPetsD7/gWfYpfUdOItCbFOc9m7aN+Qf
M0SPJQ==
              "]], Polygon3DBox[CompressedData["
1:eJwt1LdPVlEYx/FzfRvYoossloB1gMWY4KAzyuigEVtAgw1fFJUYK4JiFwQs
iB1k0NHubBl0NVH+AZVoxIqiUb+/nN/w4XLPPeU5z3nOW1xTvyQ/KoRQhTRG
oxAZZNGAbdiCPCaiCJMw3u36XolFKMBMTEUK0zDL82q+TajHVmzGYr+rvcLr
av0cFFcfnuEJenEHD/AQd9Hi9qvYj0u4gWbsxiHP0eu+zf5+DU0edwV7Pb7J
367jIMaiDKUY4xxlHFviZ877Tvn/Qo9T/wnOmXI1Dmcdv/ZxBsWY7RwpV3P8
rvYS51H5nI7JWIdTOI1abEQH2rAe7ehEHTbgpPtr3Fqv2eFxyv9R99G31ViJ
I27Xew1O4DBW4Ljf1b4Gx9ym/6vR6vGaZ7ljanO/asfd7thqPW+r+2r+R3iM
+7iH+ViGpSh3DpSLGZgSYh0W+Vx0Hgl/CpDDP489gH2e4wVe4jZueR2tdw5d
IdaZ6u05nnofq0K8H4pRNV7pcyrxvJpfddbiuFTTFY7vB/5gAK9xMcQaVW02
um3A+9Z+Vddv8CrE+lZdqj4vYw+243yIdaQ79AEfMYj3jvsd3jr+Lu9N9zjv
PoPOgXJxE/0+s1bnpd/tys9Xz691PnvuNLlNJXENPdNJTP5fHr+9X+37W4ht
+pb4PEbcR9++e6/D+OQ9VznfC7EAQ/iJX/jip842k8R3PbNJjFPxZX3+I54/
5/esxwx7viGvqXvS6TzlnVPlVvdE90O/A30+X/0ezMW8EOuy3DEqVt1z3e8y
f1e/Up+Zzq4Hu3DB56dz3IGd6HZdNPqsut3e4DE9Hqf+/wH9VaiD
              "]], Polygon3DBox[CompressedData["
1:eJwt1GVsFUEUhuGhLYTg7lZci7sXp2jRQLDiBGgI7pKQYKUEfgDFSQoUp7g7
FHd3d3fnPZnvx3NnZ3d275wzZyY4IjJ8YIBzriES4wiO4jAWYwnKoQRCUB4V
UAPd0QM9UQt/8B3fcBt30AB1EIrsyKnvFEQhlEQpbMEVXMU5bEATDMFgRKIR
BmEohqEZGutbIZpjCiTDZ7zFG3zCF/Xt/ldcwyXEYyu2YQ5m4QkCEvGDIDzl
Mhzt0Q6VlINAnv1V3A/xCBXRFm3QAmWRB/VQX3nOi9IoiuIoo3FFEKa4Ldb8
yl8/9EVv5dLabuiK2rpXV+vQC330XwuwF/uwG/P0rD8GaC42bg8O4gAWIgad
0FlrbGtdHfOxCzv1TozW2+K3PPzDD6TReHuvJtJZKpVPy+svLn86X19WZ/s1
z0WIQEd0QDVUVpxd9Mz6VRXPDmzHXMX2Aa/xCu/x0fn6sDpp6nytFXa+vp9p
vR5oDhmQCzmcr9OMeOl8/VjdXMQZjbGxmXw4LhBByIysyI0kWvNg9e1+NszG
Zudr3eo7Gvfw2/mcWG7u067HJudr0+pxJpZrfQ4hAUtRRfmwPKVEaj177HzN
PsdxZNEcbI5ptR6pFIPFkl7vRmteG7ESU3ECJ3EKqxHn/B59pxxbrs/jgq4t
/y/0zk3Fd9f5erG6sX0xBqMxHC2d3y9jMU7PbMxp5fss1mINVqi1/gxMQXN9
Z4TzZ4XtHauNW86fQTecrxOLZ5XmPx3T1MYprlhMVl4TlLdjWIbLzp8X150/
K+I1h3VaqyjNJ7nz+9n2dQEkdX5P51Pf7hfDSEzCBOfPlNZqrT8R450/Z+yM
G6XxrZyv4//b+7Rl
              "]], 
             Polygon3DBox[{{193, 222, 224, 229, 228, 194}, {77, 83, 84, 82, 
              53, 48}, {206, 210, 211, 212, 177, 173}, {66, 65, 59, 58, 19, 
              21}, {24, 63, 64, 68, 69, 26}, {49, 80, 81, 79, 75, 43}, {176, 
              207, 208, 209, 201, 168}, {225, 226, 221, 219, 190, 191}}]},
            Annotation[#, "Charting`Private`Tag$2953#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJyNmHtU1VUWx/HVVRBRw/KR8vSRCpqlpQUHsBLxgQ6p+ahcCg2MghjRMiMK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        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[SqrtBox[RowBox[{SuperscriptBox[TemplateBox[List[\
\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"], \\\"+\\\", \
SuperscriptBox[TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\"], \
\\\"2\\\"]}]], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVmT9rFFEUxUdtrCTBRnAaQUHyJR6CrRbi9v5BrMReCy38AJZGsDLfwEKx
WdL4BbRJsTaaMhKsLBXJGchv98d9k2Z5Z+/OzHlz373n3Fx58PTOo7PDMLw8
Mwzn/n2+f/bh9mp1tBz+/x0vbW2f9rvLv3e+3F0crn0fnPFXv958/mb3YC0+
OOOvv3r87cL2/lp8cMb/eff51sXt/cb44Izfuvfr49vdg7X44Ix//enFz8Xi
cC0++N7J+trDnR/3t46Xl26cf/J9ddSyzvfBs947fZ/p+txH7m/iGM/vs+b+
B+c+B+d+Bue+Bc8+hO94gpPvePr5puswD5gf5BucfIPzd1mTb3DyDU6+wck3
OPniOabrMI+Z3+QbnHyDk29wXi9r8g1OvsHJNzj54n7TdXgOeT7JNzj5Biff
4OQbnPfJmnyDk29w8sV1p+uwjrC+kG9w8g1OvsHJNzj5Buf9sybf4OSL30/X
ye/Jl3WT8eQbnHyDk29w8g1OvsHJN2vyxfM31nfWcdZ9xqf+EQ9f4uFLPHyJ
hy9x8g1OHlmHL/uT9a3wIh5exMOLeHgRDy/i7L/Bw8P0SKVfGGd9xuqx1S07
33YOLF9sv+15E8/+a/pg3Iw30w3jZryZnhg34810xrgZb9QfjOf5pS4xvcJ4
5j9x29/sH/HsE/HsB/HwJs48Yf6bvq70OPPf9JTpDuvP1ses3ltdtLpS6UJ7
P538pnjTkcz/Sl8y/yvdyfynHmU885861fQr45n/xK1e2D5KnjTJkyZ50kQv
NPbPuf6S+d/5vlV3mz41HUe9Y7rA+qr1JatDnee4GT/Bp3jzG8z/yocw/+lP
GM/8p28xP8N45j9x639WF2y/JE+a5EkTXdyoE+fOS5j/nfVL/aX5MPMr1PWm
f00/mv6yftvZr+z92PluxlvwaW2+lPlPv8p45j99rPlbxjP/iZuesz5n59/2
RfKkif9r9ENz53/M/85+rHMUe6/my+lfzeeZTzKfYbqyU5dZHbI+Zu/Nzn2z
/RB8WjP/BZ/imf/EGc/8J27+xHSb9TM758Zf5hyNvn/uPJv536kvre9aPbL3
pHMa8rJ5QOWnGV/5D8ZXeo3xVX8r3qfNsxr3yfaP8cx/4oxn/puvNr9hOsz6
k51b40Pc5lu9/5+xuYD5JdOR1l+t7tj7qOZ25F3NjRhf+WzGV76E8ZWOY3zV
9xhf1QnLC9tXxjP/bU5k/tl8hekt60N2Pnuf2+a5Nucy/2++yPSi9VGrL7a/
Nne2eZzNKcy/ma61fl/NF5kHNq/qnEupn5w5T9K6XOWrzRs65wrqe2fOA7R/
VOfK/GKnL1R/PtPPaZ+rzr/p/U5dr3OEmXpc+3FVp0yvdeoynXfM1FOqG6p6
WvVb4lX/JF71Q+JVf/sLD/dRaw==
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           
           TagBox[{Polygon3DBox[{{1, 2, 3}, {297, 328, 298}, {321, 290, 
              289}, {79, 89, 80}, {17, 16, 18}, {96, 87, 88}, {313, 377, 
              311}, {384, 320, 312}}], Polygon3DBox[CompressedData["
1:eJxNmHd8l9UVxu/LRpaGvSTIEBmJYRg0EAIkjBAhEFYYBgJhGQgJQySEoFSk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              "]]},
            Annotation[#, "Charting`Private`Tag$2968#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJztlcENhDAMBM1RCZVcD1cCEm9aoDNauhL45eEoBgRCazT5ZXeI4mgkhnH+
TR8zWzqz3vz6r/G+tfa+2zsHPuYL9z3JrzGvllcc88Y88166D/Pem1cc88b8
S+Zt7bPlpT/4f86Sl771Hq3z4E/xaj7jv+vF/cnOq/mM/64X9yc7r+Yz/rte
3J/svJrP+O96cX+y82o+47/rxf3Jzqv5jP+uF/cnO6/m89Fc5R7k5OTk5E/l
GzfvKM4=
        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{\\\"max\\\", \\\"(\\\", \
RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\"Abs\\\"], \\\",\\\", \
TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\"]}], \\\")\\\"}], \
TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVlk9IVFEUxgd1XTO1KiMrCobAXYsWyXMRQVAQ4oCtikAkN+5mhBYqBG1a
uLHmyRi1aNUmaWEE8tCFf4agRW5EZhwhmY20SA0XLno297vFTw7vOTBcznfv
Pf/u+c55l5+M9A22ZTKZyfjfHv87f11f6i9sR/V8/tHHC9Uo/3xo7VRuIbrb
uZHvKTe9rFXnJTfcPeG/L84ffojlg5kv98/mFoJvA73ZW//pEU49w592zrwJ
V/15naNd4bvOTvvslYfF0r/z1C95Ojz6rXp8+Wa2GPt9TL/O6d7V77eflcP1
aPza+96nXXXvr2TtC5esVfmR/PLtyOmh+J70S9Y+7WqtOn8tvRPwj/eFT8Dv
1614o+zjn3PT4XqwUfv78+eFU8/y8IvzjVotYDy0yzj3H9x4F9vwOPUL32r5
4fEVxC8/dZ9xC1ed7Dm7wulvxb07/ZEcun3hxe5z9+I8HrO76fxm/ZJPdfDG
4lkDvCQ/xDfWO/WIX1YdsJ6sumad8R1UT8wf9ah+rD7CuK08Ma+yP/l57Eeh
sO390b5w6tnp+To1WmoGB+hftCt8tHT0a0ZLY3cuTcX6hVM/zgfsd9L/Cjxk
/snPRWdXOPNcdvVKf6AnIJ/ZF6x8Mb/Kg3DWoezRT52Xv3wP2lUerX6/m3L+
JM0Naw6k7d/7Cf1my+gTqivvl8HvpHxbebLi7mjhXlY/pF3Fs4c+7vwJ6A/O
e3wT/Z38WQGvdJ/51Pmqs2/xzYpT3wHkOb8XdJ5ziH1Osuowaa4yj9SjuaP3
oD32dflLnrFPq99QX1JfEY/JV71DBbyhP3hPC/f1xHdWPtLOacah+Nwa5BzO
Ne2+4k3bZ6sn5Im+MzgPLP5wrmqf/qWdk0nzTXXAOBUPv4foj+eV0c+UL+aF
+bXmSgV1etI+kjSHrDnPfsy+o/UPsm0fMQ==
       "], {
        {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
          GrayLevel[1], 3], 
         StyleBox[GraphicsGroup3DBox[
           
           TagBox[{Polygon3DBox[{{1, 2, 3}, {60, 29, 31}, {25, 29, 26}, {127, 
              107, 106}, {33, 27, 28}, {36, 32, 34}, {43, 44, 45}, {30, 35, 
              31}, {41, 40, 42}, {108, 132, 109}, {125, 101, 100}, {138, 143, 
              134}, {130, 142, 131}, {102, 126, 103}, {141, 129, 128}, {118, 
              93, 90}, {123, 96, 94}, {95, 121, 92}, {37, 38, 39}, {23, 22, 
              24}, {5, 4, 6}, {47, 22, 18}, {19, 44, 15}, {53, 52, 54}, {63, 
              57, 58}, {33, 62, 34}, {55, 59, 56}, {47, 46, 48}, {60, 65, 
              61}, {69, 62, 64}, {66, 71, 67}, {7, 11, 8}, {12, 9, 10}, {13, 
              14, 15}, {17, 16, 18}, {19, 20, 21}, {139, 124, 120}, {72, 68, 
              70}, {49, 50, 51}, {116, 133, 112}, {144, 140, 135}, {118, 119, 
              120}, {83, 110, 84}, {79, 104, 80}, {99, 78, 77}, {114, 89, 
              86}, {87, 111, 85}, {91, 115, 88}, {75, 98, 76}, {105, 82, 
              81}, {97, 74, 73}, {108, 104, 103}, {122, 137, 117}, {116, 115, 
              117}, {99, 107, 100}, {136, 119, 113}}], 
             Polygon3DBox[{{140, 144, 143, 138}, {66, 68, 72, 71}, {73, 74, 
              37, 39}, {16, 17, 14, 13}, {7, 9, 12, 11}, {38, 41, 16, 13}, {
              92, 91, 65, 67}, {10, 9, 5, 6}, {137, 139, 140, 138}, {2, 7, 8, 
              3}, {4, 5, 2, 1}, {110, 114, 86, 84}, {14, 17, 4, 1}, {105, 111,
               112, 106}, {5, 9, 7, 2}, {43, 78, 73, 39}, {74, 75, 40, 37}, {
              85, 111, 105, 81}, {50, 55, 56, 51}, {26, 55, 50, 21}, {53, 57, 
              28, 24}, {58, 57, 53, 54}, {36, 68, 66, 35}, {113, 114, 110, 
              109}, {77, 78, 43, 45}, {46, 79, 80, 48}, {40, 75, 76, 42}, {20,
               25, 26, 21}, {80, 83, 52, 48}, {49, 82, 77, 45}, {81, 82, 49, 
              51}, {76, 79, 46, 42}, {8, 25, 20, 3}, {56, 85, 81, 51}, {65, 
              91, 88, 61}, {130, 126, 125, 129}, {84, 86, 58, 54}, {72, 96, 
              95, 71}, {52, 83, 84, 54}, {134, 143, 141, 128}, {30, 32, 36, 
              35}, {59, 87, 85, 56}, {112, 133, 127, 106}, {97, 98, 75, 74}, {
              96, 123, 121, 95}, {71, 95, 92, 67}, {127, 133, 134, 128}, {132,
               136, 113, 109}, {94, 96, 72, 70}, {125, 126, 102, 101}, {121, 
              123, 124, 122}, {142, 144, 135, 131}, {143, 144, 142, 141}, {
              141, 142, 130, 129}, {124, 139, 137, 122}, {88, 87, 59, 61}, {
              63, 89, 90, 64}, {86, 89, 63, 58}, {40, 41, 38, 37}, {12, 32, 
              30, 11}, {23, 27, 10, 6}, {69, 93, 94, 70}, {135, 136, 132, 
              131}, {102, 98, 97, 101}, {90, 93, 69, 64}, {28, 27, 23, 24}}], 
             Polygon3DBox[{{82, 105, 106, 107, 99, 77}, {22, 47, 48, 52, 53, 
              24}, {104, 108, 109, 110, 83, 80}, {29, 60, 61, 59, 55, 26}, {
              121, 122, 117, 115, 91, 92}, {50, 49, 45, 44, 19, 21}, {57, 63, 
              64, 62, 33, 28}, {119, 136, 135, 140, 139, 120}, {62, 69, 70, 
              68, 36, 34}, {93, 118, 120, 124, 123, 94}, {89, 114, 113, 119, 
              118, 90}, {4, 17, 18, 22, 23, 6}, {98, 102, 103, 104, 79, 76}, {
              44, 43, 39, 38, 13, 15}, {78, 99, 100, 101, 97, 73}, {35, 66, 
              67, 65, 60, 31}, {20, 19, 15, 14, 1, 3}, {27, 33, 34, 32, 12, 
              10}, {126, 130, 131, 132, 108, 103}, {11, 30, 31, 29, 25, 8}, {
              107, 127, 128, 129, 125, 100}, {16, 41, 42, 46, 47, 18}, {115, 
              116, 112, 111, 87, 88}, {137, 138, 134, 133, 116, 117}}]},
            Annotation[#, "Charting`Private`Tag$2987#1"]& ]],
          Lighting->{{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
       VertexNormals->CompressedData["
1:eJxTTMoPSmViYGCYAMTMQCxrPMF1eeWj/TSi7SkUJ6juOj+bC4je7xLqBhKH
0TjUk2o+LvnBEj6DzT3k6qdWfJFs72j6GXXPcErPI8w9hPIZhjgsf6PnexLd
RW46orv56OUazN8EwpHS+COVHijzSQ1/asUX2fFIZLqluXtIDN/Bln6oZS+p
+YtSewdt+hxs6YFK5R6l4U9QHgAZ2zGk
        "]],
      AxesLabel->{None, None, None},
      BoxRatios->{1, 1, 1},
      Boxed->False,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]]},
      PlotLabel->FormBox[
       "\"1=\\!\\(\\*FormBox[RowBox[{TemplateBox[List[\\\"\\\\\\\"x\\\\\\\"\\\
\"], \\\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"y\\\\\\\"\\\"], \\\
\"Abs\\\"], \\\"+\\\", TemplateBox[List[\\\"\\\\\\\"z\\\\\\\"\\\"], \\\"Abs\\\
\"]}], TraditionalForm]\\)\"", TraditionalForm],
      PlotRange->{All, All, All},
      PlotRangePadding->{Automatic, Automatic, Automatic},
      Ticks->{Automatic, Automatic, Automatic}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.841885679856183*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"0c1f5bc7-a732-4804-8548-c4357ad8aab1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm1", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"N", "@", 
      SqrtBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"mat", "/.", 
          RowBox[{
           RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
           SuperscriptBox[
            RowBox[{"Abs", "[", "term", "]"}], "2"]}]}], ")"}], "/.", 
        RowBox[{"List", "\[Rule]", "Plus"}]}]]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Plus", "@@", "#"}], "&"}], ")"}], "/@", 
       RowBox[{"(", 
        RowBox[{"mat", "/.", 
         RowBox[{
          RowBox[{"term_", "?", "NumericQ"}], "\[RuleDelayed]", 
          RowBox[{"Abs", "[", "term", "]"}]}]}], ")"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matNorm2a", "[", "mat_", "]"}], ":=", 
   RowBox[{"matNorm2", "[", 
    RowBox[{"Transpose", "@", "mat"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = \>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"matNorm2", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}], ",", 
     RowBox[{"matNorm2a", "[", 
      RowBox[{"mat2", "[", "0", "]"}], "]"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6851991203125*^9, 3.6851993145625*^9}, {
   3.68519934696875*^9, 3.685199381390625*^9}, {3.685199412125*^9, 
   3.685199441796875*^9}, {3.685199512*^9, 3.685199656984375*^9}, {
   3.68519972671875*^9, 3.68519975721875*^9}, {3.68520000603125*^9, 
   3.685200017375*^9}, 
   3.6852002675625*^9},ExpressionUUID->"dd9dff5b-ef05-435d-93a2-88d46ebec0e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"33", ",", "33"}], "}"}]}],
  SequenceForm["{matNorm2[mat2[0]],matNorm2a[mat2[0]]} = ", {33, 33}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.84188567993429*^9},ExpressionUUID->"7744ea2f-b8a0-4fd3-893a-2f016a2aa93d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"matNorm3", "[", "mat_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"N", "[", "#", "]"}], "]"}], "&"}], "@", 
       RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm2a", ",", "matNorm3"}], 
    "}"}], "[", 
   RowBox[{"mat2", "[", "0", "]"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{
  3.685199839890625*^9, {3.68519987946875*^9, 3.685199990328125*^9}, {
   3.685200040390625*^9, 
   3.685200087734375*^9}},ExpressionUUID->"376cc848-f8cb-41e3-8914-\
d2cb776d3202"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "30.54504869860253`", ",", "33", ",", "33", ",", "30.288685345802126`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.841885680043638*^9},ExpressionUUID->"67e95aab-4e93-4aa4-9e03-\
b3dbd25f46c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{"mat_", ",", "matNorm_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"matNorm", "[", 
     RowBox[{"Inverse", "@", 
      RowBox[{"N", "@", "mat"}]}], "]"}], "*", 
    RowBox[{"matNorm", "[", 
     RowBox[{"N", "@", "mat"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cond", "[", 
    RowBox[{
     RowBox[{"mat2", "[", "0", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"matNorm1", ",", "matNorm2", ",", "matNorm3"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.68520046784375*^9, 3.685200492265625*^9}, {
   3.68520052959375*^9, 3.685200676875*^9}, 
   3.685202460703125*^9},ExpressionUUID->"bae311dc-f7e9-41e6-bb9c-\
3e983943f366"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3009.5787080587934`", ",", "4488.000000000207`", ",", 
   "2984.0927016756295`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.841885680106124*^9},ExpressionUUID->"a3e7578a-285d-4d62-a0b9-\
7fcd9462fd34"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"exactMatrix", "=", 
   RowBox[{"mat2", "[", "0", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixRank", "=", 
   RowBox[{"MatrixRank", "[", "exactMatrix", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "=", 
   RowBox[{
    StyleBox["0.2",
     FontColor->RGBColor[1, 0, 0]], "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"matrixRank", ",", "matrixRank"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matrixOfErrors", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"knownMatrix", "=", 
   RowBox[{"exactMatrix", "+", "matrixOfErrors"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"knownMatrix", "//", "mf"}], ",", 
    RowBox[{"exactMatrix", "//", "mf"}]}], "}"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"variablesToSolve", "=", 
  RowBox[{
   RowBox[{
    SubscriptBox["x", "#"], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"rhsVector", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "matrixRank", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.68520071415625*^9, 3.68520077615625*^9}, {
  3.68520082040625*^9, 3.685200990734375*^9}, {3.68520118575*^9, 
  3.685201205921875*^9}, {3.68520130540625*^9, 3.685201306640625*^9}, {
  3.68520136265625*^9, 3.685201404375*^9}, {3.685204244234375*^9, 
  3.685204283921875*^9}},ExpressionUUID->"abdcd2b1-1004-477d-82ab-\
eb19dc9b5678"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"5.126955796068429`", "6.844567844452494`", "6.115810397853541`", 
          "4.875121258682411`"},
         {"6.89654438698306`", "9.826295503803513`", "8.01689864820385`", 
          "6.892461802694411`"},
         {"5.958402432619435`", "8.080189512776897`", "9.884730391621652`", 
          "9.09946275259318`"},
         {"4.96914025973598`", "6.898997912345603`", "9.19086870469631`", 
          "10.130065175795405`"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]},
    {
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"5", "7", "6", "5"},
         {"7", "10", "8", "7"},
         {"6", "8", "10", "9"},
         {"5", "7", "9", "10"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 CellChangeTimes->{
  3.84188568018423*^9},ExpressionUUID->"128b42cf-fb01-40da-a649-6d29cb52af62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8418856802310953`*^9},ExpressionUUID->"24cb707e-912b-47a8-bd7c-\
659d3ff7368b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "4", ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.841885680277959*^9},ExpressionUUID->"362625da-914b-46e3-8ebd-\
cc049c3e2c6a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "how", " ", "to", " ", "get", " ", "list", " ", "of", " ", "equations", 
    " ", "from", " ", "vectors", " ", "and", " ", "matrices"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"equations", "[", "mat_", "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"mat", ".", "variablesToSolve"}], "==", "rhsVector"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"mf", "/@", 
      RowBox[{"(", 
       RowBox[{"equations", "/@", 
        RowBox[{"{", 
         RowBox[{"exactMatrix", ",", "knownMatrix"}], "}"}]}], ")"}]}], "]"}],
     ";"}]}]}]], "Input",
 CellChangeTimes->{{3.685201310125*^9, 3.685201356921875*^9}, {
  3.685201429109375*^9, 3.685201523296875*^9}, {3.68520186425*^9, 
  3.685201890625*^9}, {3.685202028171875*^9, 
  3.685202073734375*^9}},ExpressionUUID->"fbea3dee-54e9-4016-b4c6-\
6ef3054cf7ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"how", " ", "to", " ", "get", " ", "rhsVector", " ", 
    RowBox[{"(", "b", ")"}], " ", "and", " ", "the", " ", "matrix", " ", 
    RowBox[{"(", "mat", ")"}], " ", "from", " ", "a", " ", "list", " ", "of", 
    " ", "equations", " ", "and", " ", "known", " ", "variablesToSolve"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "m"}], "}"}], "=", 
     RowBox[{
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"equations", "[", "exactMatrix", "]"}], ",", 
        "variablesToSolve"}], "]"}], "//", "Normal"}]}], ";"}], 
   "\[IndentingNewLine]", "b", "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "m"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68520172828125*^9, 3.6852017331875*^9}, {
  3.685201774875*^9, 3.6852018498125*^9}, {3.685201894171875*^9, 
  3.685201895046875*^9}, {3.68520195796875*^9, 
  3.685202045859375*^9}},ExpressionUUID->"510c23b9-5530-4160-8674-\
144f21d337cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}], ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{
  3.841885680340444*^9},ExpressionUUID->"568cd179-d5e4-48de-98a3-\
9e739e01b803"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5", "7", "6", "5"},
     {"7", "10", "8", "7"},
     {"6", "8", "10", "9"},
     {"5", "7", "9", "10"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.841885680387308*^9},ExpressionUUID->"3d4c9309-7155-49bc-87d6-\
f32f87c97f17"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrors", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["exactMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrors", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685202113484375*^9, 3.68520217209375*^9}, {
  3.685202205671875*^9, 3.685202264234375*^9}, {3.68520229925*^9, 
  3.68520231340625*^9}, {3.685202375609375*^9, 3.6852024411875*^9}, {
  3.6852025109375*^9, 3.685202512359375*^9}, {3.685202563421875*^9, 
  3.685202816453125*^9}, {3.6852028650625*^9, 3.6852028746875*^9}, {
  3.68520302125*^9, 3.685203044*^9}, {3.685203136203125*^9, 
  3.685203221390625*^9}},ExpressionUUID->"59be4c75-2c4f-4385-a43c-\
42f9f3111b76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.389776339387272`", ",", "45.43477298256853`", ",", "True"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.841885680449794*^9},ExpressionUUID->"988c4549-f03a-4925-b342-\
6fd7b4d244c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"compareRelativeErrorsKnown", "[", 
    RowBox[{"matNorm_", ",", "vectNorm_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "condNumber", ",", "xExact", ",", "xKnown", ",", 
       "relativeErrorOfsolution", ",", "maxRelativeErrorOfsolution"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"condNumber", "=", 
       RowBox[{"cond", "[", 
        RowBox[{
         StyleBox["knownMatrix",
          FontColor->RGBColor[1, 0, 0]], ",", "matNorm2"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xExact", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"exactMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xKnown", "=", 
       RowBox[{"LinearSolve", "[", 
        RowBox[{"knownMatrix", ",", "rhsVector"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"relativeErrorOfsolution", "=", 
         FractionBox[
          RowBox[{"vectNorm", "[", 
           RowBox[{"xExact", "-", "xKnown"}], "]"}], 
          RowBox[{"vectNorm", "[", "xKnown", "]"}]]}], ",", 
        RowBox[{"maxRelativeErrorOfsolution", "=", 
         RowBox[{"condNumber", "*", 
          FractionBox[
           RowBox[{"matNorm", "[", 
            RowBox[{"exactMatrix", "-", "knownMatrix"}], "]"}], 
           RowBox[{"matNorm", "[", "knownMatrix", "]"}]]}]}], ",", 
        RowBox[{
        "relativeErrorOfsolution", "<", "maxRelativeErrorOfsolution"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"compareRelativeErrorsKnown", "[", 
  RowBox[{"matNorm3", ",", "norm2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.685203252265625*^9, 
  3.68520326675*^9}},ExpressionUUID->"cf5e7553-b249-4c00-9d24-e937b4c8acd7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.389776339387272`", ",", "3.484286557254947`", ",", "False"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8418856805122786`*^9},ExpressionUUID->"a645a510-d160-41cb-b93d-\
0e62b8de9170"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"So", ",", " ", 
   RowBox[{"it", " ", "looks", " ", "like", " ", "a", " ", 
    RowBox[{
     StyleBox["joke",
      FontColor->RGBColor[1, 0, 0]], ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
          "for", " ", "the", " ", "comparison", " ", "of", " ", "errors", " ",
            "we", " ", "have", " ", "to", " ", "know", " ", "the", " ", "the",
            " ", "condition", " ", "number", " ", "of", " ", "the", " ", 
           StyleBox["exactMatrix",
            FontColor->RGBColor[1, 0, 0]]}], " ", "..."}], " ", "but", " ", 
         "knowing", " ", "it", " ", "we", " ", 
         RowBox[{"don", "'"}], "t", " ", "need", " ", "anything", " ", 
         "related", " ", "to", " ", "condition", " ", "numbers", " ", "etc"}],
         "..."}], "\[IndentingNewLine]", "..."}], " ", "but", " ", "we", " ", 
      "can", " ", "believe", " ", "that", " ", "for", " ", "small", " ", 
      "matrixNorm", " ", "of", " ", "matrixOfErrors", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "try", " ", "to", " ", "decrease", " ", "the", " ", "value", " ", 
         StyleBox["0.2",
          FontColor->RGBColor[1, 0, 0]], " ", "in", " ", "the", " ", 
         "definition", " ", "of", " ", "matrixOfErrors", " ", "the", " ", 
         "difference", " ", "of", " ", 
         RowBox[{"cond", "[", "exactMatrix", "]"}], " ", "and", " ", 
         RowBox[{"cond", "[", "knownMatrix", "]"}], " ", "is", " ", "small", 
         " ", "and", " ", "reasonable"}], "..."}], " ", ")"}]}]}]}]}], " ", 
  "\[IndentingNewLine]", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.68520388903125*^9, 3.68520408*^9}, {3.6852043109375*^9, 
  3.68520442140625*^9}, {3.68520445565625*^9, 
  3.68520450884375*^9}},ExpressionUUID->"588485f6-da2e-412c-ac55-\
7b2842b67f1a"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.68520451846875*^9},ExpressionUUID->"6aa2ddd3-1570-4e42-a998-0ab6a9cb37c7"]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1441, 41, 377, "Input",ExpressionUUID->"5e05fc09-c28a-4694-b565-fb02957fc2b1"],
Cell[2011, 65, 352, 9, 34, "Print",ExpressionUUID->"41be8a6c-55e5-4b65-86d6-c5b064ecd55a"],
Cell[2366, 76, 3042, 96, 209, "Output",ExpressionUUID->"707c625c-4f9a-465f-a2a9-4b7257a4147b"]
}, Open  ]],
Cell[5423, 175, 1715, 37, 290, "Input",ExpressionUUID->"c9a8d6ce-c61d-4aaf-b9d8-c7209ad2a2ef"],
Cell[CellGroupData[{
Cell[7163, 216, 2310, 62, 247, "Input",ExpressionUUID->"22ef948d-9390-4fb5-9583-0e16a716f665"],
Cell[9476, 280, 15475, 299, 225, "Output",ExpressionUUID->"c0bbc32e-c1ef-4bef-822e-823563f390f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24988, 584, 1717, 42, 166, "Input",ExpressionUUID->"280d806d-36c6-4b1c-a6d3-dfbe0c1b5445"],
Cell[26708, 628, 57484, 961, 225, 22712, 390, "CachedBoxData", "BoxData", "Output",ExpressionUUID->"0c1f5bc7-a732-4804-8548-c4357ad8aab1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84229, 1594, 2026, 53, 341, "Input",ExpressionUUID->"dd9dff5b-ef05-435d-93a2-88d46ebec0e8"],
Cell[86258, 1649, 379, 9, 34, "Print",ExpressionUUID->"7744ea2f-b8a0-4fd3-893a-2f016a2aa93d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86674, 1663, 864, 24, 136, "Input",ExpressionUUID->"376cc848-f8cb-41e3-8914-d2cb776d3202"],
Cell[87541, 1689, 238, 7, 51, "Output",ExpressionUUID->"67e95aab-4e93-4aa4-9e03-b3dbd25f46c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87816, 1701, 754, 21, 76, "Input",ExpressionUUID->"bae311dc-f7e9-41e6-bb9c-3e983943f366"],
Cell[88573, 1724, 245, 7, 51, "Output",ExpressionUUID->"a3e7578a-285d-4d62-a0b9-7fcd9462fd34"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88855, 1736, 1881, 53, 286, "Input",ExpressionUUID->"abdcd2b1-1004-477d-82ab-eb19dc9b5678"],
Cell[90739, 1791, 2063, 52, 229, "Output",ExpressionUUID->"128b42cf-fb01-40da-a649-6d29cb52af62"],
Cell[92805, 1845, 289, 9, 51, "Output",ExpressionUUID->"24cb707e-912b-47a8-bd7c-659d3ff7368b"],
Cell[93097, 1856, 214, 6, 51, "Output",ExpressionUUID->"362625da-914b-46e3-8ebd-cc049c3e2c6a"]
}, Open  ]],
Cell[93326, 1865, 980, 27, 106, "Input",ExpressionUUID->"fbea3dee-54e9-4016-b4c6-6ef3054cf7ed"],
Cell[CellGroupData[{
Cell[94331, 1896, 1048, 24, 226, "Input",ExpressionUUID->"510c23b9-5530-4160-8674-144f21d337cc"],
Cell[95382, 1922, 233, 7, 51, "Output",ExpressionUUID->"568cd179-d5e4-48de-98a3-9e739e01b803"],
Cell[95618, 1931, 764, 22, 145, "Output",ExpressionUUID->"3d4c9309-7155-49bc-87d6-f32f87c97f17"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96419, 1958, 2253, 53, 555, "Input",ExpressionUUID->"59be4c75-2c4f-4385-a43c-42f9f3111b76"],
Cell[98675, 2013, 226, 6, 51, "Output",ExpressionUUID->"988c4549-f03a-4925-b342-6fd7b4d244c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98938, 2024, 1875, 47, 525, "Input",ExpressionUUID->"cf5e7553-b249-4c00-9d24-e937b4c8acd7"],
Cell[100816, 2073, 229, 6, 51, "Output",ExpressionUUID->"a645a510-d160-41cb-b93d-0e62b8de9170"]
}, Open  ]],
Cell[101060, 2082, 1873, 39, 836, "Input",ExpressionUUID->"588485f6-da2e-412c-ac55-7b2842b67f1a"],
Cell[102936, 2123, 144, 2, 192, "Input",ExpressionUUID->"6aa2ddd3-1570-4e42-a998-0ab6a9cb37c7"]
}
]
*)

