(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     27650,        801]
NotebookOptionsPosition[     25308,        756]
NotebookOutlinePosition[     25769,        773]
CellTagsIndexPosition[     25726,        770]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sortByImag", ":=", 
   RowBox[{
    RowBox[{"Sort", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Im", "[", "#1", "]"}], "<", 
        RowBox[{"Im", "[", "#2", "]"}]}], "&"}]}], "]"}], "&"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"randomMatrix", "[", "rnm_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], "&"}], "[", "i", 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "rnm"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6856875226556287`*^9, 3.6856875658743787`*^9}, {
  3.6856878199368787`*^9, 3.6856878215931287`*^9}, {3.68571858965625*^9, 
  3.685718645375*^9}},ExpressionUUID->"4e7e3309-424c-48e5-bb38-48d29559f64a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "ukazka", " ", "obecne", " ", "diagonalizace", " ", "matice", " ", "a", 
    " ", "ze", " ", "zachovava", " ", "vlastni", " ", "cisla"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"randomMatrix", "[", "rnm", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{
      RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{"Transpose", "[", "vectors", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diag", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Inverse", "[", "P", "]"}], ".", "A", ".", "P"}], "//", 
      "Chop"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "mf"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"sortByImag", "[", 
       RowBox[{"Eigenvalues", "[", "diag", "]"}], "]"}], "-", 
      RowBox[{"sortByImag", "[", "lambdas", "]"}]}], "}"}], "//", "Chop"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.685683424625*^9, 3.685683427375*^9}, {
  3.6856869625775037`*^9, 3.6856869639837537`*^9}, {3.6856871341556287`*^9, 
  3.6856872405931287`*^9}, {3.6856872751712537`*^9, 3.6856873130618787`*^9}, {
  3.6856873595462537`*^9, 3.6856874004525037`*^9}, {3.6856875840150037`*^9, 
  3.6856875882806287`*^9}, {3.6856876514993787`*^9, 3.6856876959212537`*^9}, {
  3.6856878448900037`*^9, 3.6856878511243787`*^9}, {3.6857172029375*^9, 
  3.68571723615625*^9}, {3.6857186751875*^9, 3.68571867653125*^9}, {
  3.874049135167265*^9, 
  3.8740491604116163`*^9}},ExpressionUUID->"249bdc30-93be-4161-bbb9-\
57fb32722351"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.4499527993439698`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.26246018311032815`", " ", "\[ImaginaryI]"}]}], "0", "0"},
     {"0", 
      RowBox[{"0.44995279934396976`", "\[VeryThinSpace]", "-", 
       RowBox[{"0.26246018311032826`", " ", "\[ImaginaryI]"}]}], "0"},
     {"0", "0", "0.05014184080337665`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.8473338079135237`*^9, 3.87404897028063*^9, 
  3.8740490993381853`*^9},ExpressionUUID->"b707f66d-e41a-480f-ab26-\
6846673d3aeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8473338079135237`*^9, 3.87404897028063*^9, 
  3.8740490993538017`*^9},ExpressionUUID->"4d6ad5be-480d-4629-96f5-\
f4691a0a379d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"matice", " ", "a", " ", "slozky"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dosa", "=", 
     RowBox[{"{", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "2", "*", 
         FractionBox["Pi", "3."]}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"1", "1", "1"},
         {"1", 
          SuperscriptBox["a", "2"], "a"},
         {"1", "a", 
          SuperscriptBox["a", "2"]}
        }], ")"}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"invT", "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], 
       RowBox[{"(", GridBox[{
          {"1", "1", "1"},
          {"1", "a", 
           SuperscriptBox["a", "2"]},
          {"1", 
           SuperscriptBox["a", "2"], "a"}
         }], ")"}]}], "/.", "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"overeni", ",", " ", 
     RowBox[{
     "ze", " ", "invT", " ", "je", " ", "skutecne", " ", "inverzni", " ", "k",
       " ", "T"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Inverse", "[", "T", "]"}], "-", "invT"}], "//", "Simplify"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6856932708743787`*^9, 3.6856932786087537`*^9}, {
   3.6856933219056287`*^9, 3.6856934819368787`*^9}, {3.6856940138743787`*^9, 
   3.6856940630931287`*^9}, {3.68577487578125*^9, 3.685774904515625*^9}, {
   3.6857749355*^9, 3.685774974375*^9}, 3.685775304109375*^9, {
   3.8740491697637405`*^9, 
   3.874049191316988*^9}},ExpressionUUID->"67646603-8dfc-4285-805e-\
ca65d2f07d57"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473338094131713`*^9, 
  3.874049099538731*^9},ExpressionUUID->"164a5d9b-8b02-4793-9f0a-\
f8197dc3d9ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ukazka", " ", "cyklicke", " ", "matice"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"impedances", "=", 
     RowBox[{"{", 
      RowBox[{"Zv", ",", "Z1", ",", "Z2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"matZ", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"RotateRight", "[", 
        RowBox[{"impedances", ",", "#"}], "]"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "2", ",", "1"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"mf", "@", "matZ"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"transformedMatZ", "=", 
     RowBox[{"Chop", "@", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"invT", ".", "matZ", ".", "T"}], "//", "Chop"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "@", "%"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6857750335*^9, 3.68577511096875*^9}, {
   3.6857751805625*^9, 3.685775180921875*^9}, {3.685775226671875*^9, 
   3.685775258375*^9}, {3.685775290046875*^9, 3.685775337765625*^9}, {
   3.685775392125*^9, 3.685775394625*^9}, {3.6857754278125*^9, 
   3.685775434953125*^9}, {3.685775478828125*^9, 3.6857755254375*^9}, 
   3.685775741171875*^9, {3.685778404296875*^9, 3.685778429828125*^9}, {
   3.874049208102228*^9, 
   3.874049217116209*^9}},ExpressionUUID->"340102e3-9f64-4c29-9ca8-\
230527ed0217"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"Zv", "Z1", "Z2"},
     {"Z2", "Zv", "Z1"},
     {"Z1", "Z2", "Zv"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.847333809444413*^9, 
  3.8740491001562815`*^9},ExpressionUUID->"f9c47a4d-d991-4ae4-bb9c-\
78d989cfc17d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "3", "f", " ", "vedeni", " ", "a", " ", "transformace", " ", "problemu", 
    " ", "do", " ", "slozek"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"eqnJthPhase", "[", "j_", "]"}], ":=", 
     RowBox[{
      SubscriptBox["\[CapitalDelta]u", "j"], "==", 
      RowBox[{
       RowBox[{
        SubscriptBox["R", "j"], "*", 
        SubscriptBox["i", "j"]}], "+", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"k", "=", "1"}], "3"], 
        RowBox[{
         SubscriptBox["Z", 
          RowBox[{"k", ",", "j"}]], "*", 
         SubscriptBox["i", "k"]}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"eqns3phases", "=", 
    RowBox[{
     RowBox[{"eqnJthPhase", "/@", 
      RowBox[{"Range", "[", "3", "]"}]}], "//", "Simplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"varsToSolve", "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["i", "#"], "&"}], "/@", 
      RowBox[{"Range", "[", "3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"rhsabc", ",", "Zaux"}], "}"}], "=", 
     RowBox[{
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{"eqns3phases", ",", "varsToSolve"}], "]"}], "//", "Normal"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Zabc", "=", 
     RowBox[{
      RowBox[{"-", "1"}], "*", "Zaux"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "@", "Zabc"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Thread", "[", 
    RowBox[{"rhsabc", "\[Equal]", 
     RowBox[{"Zabc", ".", "varsToSolve"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.685776050640625*^9, 3.68577618884375*^9}, {
  3.685776221265625*^9, 3.685776247984375*^9}, {3.685776299640625*^9, 
  3.68577631771875*^9}, {3.68577654528125*^9, 3.68577664084375*^9}, {
  3.6857766748125*^9, 3.68577669803125*^9}, {3.68577672909375*^9, 
  3.68577676646875*^9}, {3.68577682040625*^9, 3.68577687321875*^9}, {
  3.8740492638805637`*^9, 
  3.874049282826491*^9}},ExpressionUUID->"036803d2-1de9-4210-b371-\
73f6a02df4aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "1"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "1"], "+", 
        SubscriptBox["Z", 
         RowBox[{"1", ",", "1"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "1"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "2"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "2"], "+", 
        SubscriptBox["Z", 
         RowBox[{"2", ",", "2"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "3"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "3"], "+", 
        SubscriptBox["Z", 
         RowBox[{"3", ",", "3"}]]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473338094912806`*^9, 
  3.874049100225272*^9},ExpressionUUID->"3040d9cd-6998-4860-b2ad-\
05fb75c8f874"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "1"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "1"], "+", 
        SubscriptBox["Z", 
         RowBox[{"1", ",", "1"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "1"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "1"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "2"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "2"], "+", 
        SubscriptBox["Z", 
         RowBox[{"2", ",", "2"}]]}], ")"}]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]]}]}]}], ",", 
   RowBox[{
    SubscriptBox["\[CapitalDelta]u", "3"], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["i", "1"], " ", 
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "2"], " ", 
      SubscriptBox["Z", 
       RowBox[{"2", ",", "3"}]]}], "+", 
     RowBox[{
      SubscriptBox["i", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["R", "3"], "+", 
        SubscriptBox["Z", 
         RowBox[{"3", ",", "3"}]]}], ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473338094912806`*^9, 
  3.874049100240897*^9},ExpressionUUID->"13db3fc0-69e6-4927-8084-\
ad8514a7cc09"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"symmetric", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["R", "_"], "\[RuleDelayed]", "R"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "k_"}]], "\[RuleDelayed]", "Zv"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"3", ",", "2"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"1", ",", "3"}]], "\[RuleDelayed]", "Zm"}], ",", 
     RowBox[{
      SubscriptBox["Z", 
       RowBox[{"k_", ",", "r_"}]], "\[RuleDelayed]", 
      SubscriptBox["Z", 
       RowBox[{"r", ",", "k"}]]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ZabcSymmetric", "=", 
   RowBox[{"Zabc", "//.", "symmetric"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "@", "ZabcSymmetric"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]voltages", "=", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
       RowBox[{"Range", "[", "3", "]"}]}], ")"}], "->", 
     RowBox[{"\[CapitalDelta]Uf", "*", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        SuperscriptBox["a", "2"], ",", "a"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalDelta]Uf", "\[Rule]", "100"}], ",", 
     RowBox[{"Zm", "\[Rule]", 
      RowBox[{"20", "I"}]}], ",", 
     RowBox[{"Zv", "\[Rule]", 
      RowBox[{"30", "I"}]}], ",", 
     RowBox[{"R", "\[Rule]", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"originalEqns", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"eqns3phases", "//.", "symmetric"}], ")"}], "/.", 
      "\[CapitalDelta]voltages"}], ")"}], "/.", "values"}], "/.", 
   "dosa"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", "originalEqns", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.685776939578125*^9, 3.685776955171875*^9}, 
   3.68577701765625*^9, {3.685777057484375*^9, 3.685777240078125*^9}, {
   3.685777318546875*^9, 3.68577738565625*^9}, {3.685777418296875*^9, 
   3.685777423609375*^9}, {3.685778585484375*^9, 3.685778737234375*^9}, {
   3.685778768984375*^9, 3.685778801171875*^9}, {3.68577885315625*^9, 
   3.685778933078125*^9}, {3.68577916865625*^9, 3.68577920478125*^9}, {
   3.6857801846875*^9, 
   3.68578018596875*^9}},ExpressionUUID->"b91175f6-79d1-4f71-bdf6-\
89c22a6676ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"100", "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "3"]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "50.000000000000036`"}], "-", 
     RowBox[{"86.60254037844383`", " ", "\[ImaginaryI]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "3"]}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "49.99999999999998`"}], "+", 
     RowBox[{"86.60254037844388`", " ", "\[ImaginaryI]"}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "1"]}], "+", 
     RowBox[{"20", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["i", "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
      SubscriptBox["i", "3"]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8473338095537624`*^9, 
  3.874049100272151*^9},ExpressionUUID->"97200c55-c505-4283-a7b3-\
cceb4b8c39d3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["i", "1"], "\[Rule]", 
    RowBox[{"0.9900990099009895`", "\[VeryThinSpace]", "-", 
     RowBox[{"9.900990099009904`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["i", "2"], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "9.069558453311275`"}], "+", 
     RowBox[{"4.093044154668877`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["i", "3"], "\[Rule]", 
    RowBox[{"8.079459443410286`", "\[VeryThinSpace]", "+", 
     RowBox[{"5.807945944341029`", " ", "\[ImaginaryI]"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8473338095537624`*^9, 
  3.874049100303383*^9},ExpressionUUID->"0bbaace9-1a6b-4183-9593-\
fb068d628817"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"ukazka", " ", "diagonalizace", " ", "problemu"}], ",", " ", 
    RowBox[{
    "rovnice", " ", "je", " ", "mozno", " ", "resit", " ", "oddelene"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Zcomponents", "=", 
     RowBox[{
      RowBox[{"invT", ".", 
       RowBox[{"(", 
        RowBox[{"ZabcSymmetric", "/.", "values"}], ")"}], ".", "T"}], "//", 
      "Chop"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "@", "Zcomponents"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"voltagesOriginal", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalDelta]u", "#"], "&"}], "/@", 
          RowBox[{"Range", "[", "3", "]"}]}], "/.", 
         "\[CapitalDelta]voltages"}], ")"}], "/.", "values"}], "/.", 
      "dosa"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"voltagesComponents", "=", 
     RowBox[{
      RowBox[{"invT", ".", "voltagesOriginal"}], "//", "Chop"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"currentsComponents", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["iomn", "#"], "&"}], "/@", 
     RowBox[{"Range", "[", "3", "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"eqnsComponents", "=", 
    RowBox[{"Thread", "[", 
     RowBox[{"voltagesComponents", "==", 
      RowBox[{"Zcomponents", ".", "currentsComponents"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"solComponents", "=", 
    RowBox[{
     RowBox[{"Solve", "[", "eqnsComponents", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"originalCurrents", "=", 
    RowBox[{"T", ".", 
     RowBox[{"(", 
      RowBox[{"currentsComponents", "/.", "solComponents"}], 
      ")"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.68577954978125*^9, 3.685779657765625*^9}, {
  3.6857797485625*^9, 3.685779836015625*^9}, {3.685779947578125*^9, 
  3.685780075875*^9}, {3.685780120078125*^9, 3.685780121875*^9}, {
  3.68578017075*^9, 3.68578017721875*^9}, {3.685780214890625*^9, 
  3.6857802251875*^9}, {3.685780367890625*^9, 3.68578038203125*^9}, {
  3.874049297706085*^9, 
  3.874049320702524*^9}},ExpressionUUID->"80b20539-da30-4803-b065-\
813d183a3cae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["iomn", "1"], ",", 
   SubscriptBox["iomn", "2"], ",", 
   SubscriptBox["iomn", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.847333809600627*^9, 
  3.8740491003723783`*^9},ExpressionUUID->"b43a5968-548d-4f49-9b24-\
6dd56d86671e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.`", "\[VeryThinSpace]", "+", 
       RowBox[{"69.99999999999999`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "1"]}]}], ",", 
   RowBox[{"99.99999999999999`", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0000000000000033`", "\[VeryThinSpace]", "+", 
       RowBox[{"9.999999999999998`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "2"]}]}], ",", 
   RowBox[{"0", "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1.0000000000000033`", "\[VeryThinSpace]", "+", 
       RowBox[{"9.999999999999998`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
     SubscriptBox["iomn", "3"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.847333809600627*^9, 
  3.8740491003880005`*^9},ExpressionUUID->"77ca1ad5-d194-487d-8f86-\
b6b9b5ad6062"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["iomn", "1"], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["iomn", "2"], "\[Rule]", 
    RowBox[{"0.9900990099009934`", "\[VeryThinSpace]", "-", 
     RowBox[{"9.9009900990099`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{
    SubscriptBox["iomn", "3"], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.847333809600627*^9, 
  3.8740491004036217`*^9},ExpressionUUID->"73cadc9d-5304-4456-9812-\
8a00ed60ac45"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.9900990099009934`", "\[VeryThinSpace]", "-", 
    RowBox[{"9.9009900990099`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "9.069558453311272`"}], "+", 
    RowBox[{"4.093044154668872`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"8.07945944341028`", "\[VeryThinSpace]", "+", 
    RowBox[{"5.807945944341029`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.847333809600627*^9, 
  3.87404910042575*^9},ExpressionUUID->"05cb1d67-4c69-4e39-b275-f56416e4efab"]
}, Open  ]]
},
WindowSize->{1032, 694},
WindowMargins->{{27, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5000001192092896`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1392, 41, 189, "Input",ExpressionUUID->"4e7e3309-424c-48e5-bb38-48d29559f64a"],
Cell[CellGroupData[{
Cell[1974, 65, 2149, 54, 392, "Input",ExpressionUUID->"249bdc30-93be-4161-bbb9-57fb32722351"],
Cell[4126, 121, 1034, 25, 118, "Output",ExpressionUUID->"b707f66d-e41a-480f-ab26-6846673d3aeb"],
Cell[5163, 148, 256, 6, 49, "Output",ExpressionUUID->"4d6ad5be-480d-4629-96f5-f4691a0a379d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5456, 159, 1785, 52, 391, "Input",ExpressionUUID->"67646603-8dfc-4285-805e-ca65d2f07d57"],
Cell[7244, 213, 386, 11, 49, "Output",ExpressionUUID->"164a5d9b-8b02-4793-9f0a-f8197dc3d9ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7667, 229, 1450, 38, 189, "Input",ExpressionUUID->"340102e3-9f64-4c29-9ca8-230527ed0217"],
Cell[9120, 269, 752, 21, 118, "Output",ExpressionUUID->"f9c47a4d-d991-4ae4-bb9c-78d989cfc17d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9909, 295, 2129, 58, 296, "Input",ExpressionUUID->"036803d2-1de9-4210-b371-73f6a02df4aa"],
Cell[12041, 355, 1739, 59, 81, "Output",ExpressionUUID->"3040d9cd-6998-4860-b2ad-05fb75c8f874"],
Cell[13783, 416, 1739, 59, 81, "Output",ExpressionUUID->"13db3fc0-69e6-4927-8084-ad8514a7cc09"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15559, 480, 2694, 73, 258, "Input",ExpressionUUID->"b91175f6-79d1-4f71-bdf6-89c22a6676ea"],
Cell[18256, 555, 1543, 44, 79, "Output",ExpressionUUID->"97200c55-c505-4283-a7b3-cceb4b8c39d3"],
Cell[19802, 601, 727, 19, 49, "Output",ExpressionUUID->"0bbaace9-1a6b-4183-9593-fb068d628817"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20566, 625, 2304, 61, 276, "Input",ExpressionUUID->"80b20539-da30-4803-b065-813d183a3cae"],
Cell[22873, 688, 287, 8, 49, "Output",ExpressionUUID->"b43a5968-548d-4f49-9b24-6dd56d86671e"],
Cell[23163, 698, 906, 23, 49, "Output",ExpressionUUID->"77ca1ad5-d194-487d-8f86-b6b9b5ad6062"],
Cell[24072, 723, 670, 17, 49, "Output",ExpressionUUID->"73cadc9d-5304-4456-9812-8a00ed60ac45"],
Cell[24745, 742, 547, 11, 49, "Output",ExpressionUUID->"05cb1d67-4c69-4e39-b275-f56416e4efab"]
}, Open  ]]
}
]
*)

