(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46994,       1169]
NotebookOptionsPosition[     43050,       1095]
NotebookOutlinePosition[     43531,       1113]
CellTagsIndexPosition[     43488,       1110]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}]}], "Input",ExpressionUUID->\
"47c12178-c0c6-416c-9ca8-fa07f4bc14e0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "1.691"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"originalEqn", "=", 
    RowBox[{
     RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"note", ":", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"rhs", " ", 
        RowBox[{"(", 
         RowBox[{"i", ".", "e", ".", " ", "b"}], ")"}], " ", 
        RowBox[{"doesn", "'"}], "t", " ", "influe", " ", "the", " ", 
        "convergence"}], "..."}], " ", "in", " ", "engineering", " ", "we", 
      " ", "can", " ", "understand", " ", "rhs", " ", "to", " ", "be", " ", 
      "an", " ", "INPUT", " ", "and", " ", "in", " ", "case", " ", "of", " ", 
      "LINEAR", " ", "systems", " ", "facts", " ", "like", " ", 
      "\"\<it conveges or not\>\"", " ", 
      RowBox[{"don", "'"}], "t", " ", "depend", " ", "on", " ", "inputs", " ", 
      RowBox[{"(", 
       RowBox[{
       "in", " ", "case", " ", "of", " ", "ODEs", " ", "initial", " ", 
        "values", " ", "are", " ", "inputs", " ", "as", " ", "well"}], 
       ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"depend", " ", "only", " ", "on", " ", "the", " ", "SYSTEM"}], 
      "..."}], " ", "and", " ", "in", " ", "this", " ", "maybe", " ", "the", 
     " ", "simpliest", " ", "example", " ", "the", " ", "system", " ", "has", 
     " ", "only", " ", "one", " ", "parameter", " ", "a"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xExact", "=", 
   FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<condition of convergence, i.e. Abs[q=1-a]<1: \>\"", ",", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"q", "=", 
      RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.778317754078125*^9, 3.778317814984375*^9}, {
  3.778317881203125*^9, 3.778318212640625*^9}, {3.77831830896875*^9, 
  3.778318328921875*^9}, {3.778321595625*^9, 3.77832160065625*^9}, {
  3.778323447328125*^9, 3.7783234646875*^9}, {3.77832514778125*^9, 
  3.778325150046875*^9}},ExpressionUUID->"b0a204e5-715a-4e6d-8cc3-\
3e565739e2db"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xExact= \"\>", "\[InvisibleSpace]", "2.2075694855115313`"}],
  SequenceForm["xExact= ", 2.2075694855115313`],
  Editable->False]], "Print",
 CellChangeTimes->{3.7790102165903635`*^9, 3.7790102603016405`*^9, 
  3.7790103590810137`*^9, 
  3.77901230798092*^9},ExpressionUUID->"7ec11927-f9ee-4804-8d0a-5f001e7cf660"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"condition of convergence, i.e. Abs[q=1-a]<1: \"\>", 
   "\[InvisibleSpace]", "True"}],
  SequenceForm["condition of convergence, i.e. Abs[q=1-a]<1: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.7790102165903635`*^9, 3.7790102603016405`*^9, 
  3.7790103590810137`*^9, 
  3.77901230798092*^9},ExpressionUUID->"70d2c801-28c3-43f8-bf2f-e36ba2efd06f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "can", " ", "see", " ", "that", " ", "the", " ", "iterative", 
     " ", "process", " ", "converges", " ", "to", " ", "the", " ", "exact", 
     " ", "root"}], ",", "\[IndentingNewLine]", 
    RowBox[{
    "Mathematica", " ", "syntaxis", " ", "using", " ", "integer", " ", 
     "parameter"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "1.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "0", "]"}], "=", "x0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "i_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", 
       RowBox[{"x", "[", 
        RowBox[{"i", "-", "1"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "40"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.77831823990625*^9, 3.77831830653125*^9}, {
   3.778318407890625*^9, 3.778318503359375*^9}, {3.778318542078125*^9, 
   3.778318716296875*^9}, 3.778318973625*^9, 3.778323482265625*^9, 
   3.779010484801635*^9, {3.7790112730741024`*^9, 
   3.7790112966613436`*^9}},ExpressionUUID->"0300f5e2-416a-42dc-9ea6-\
9970b0d30df5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6`", ",", "2.6273999999999997`", ",", "1.9174666`", ",", "2.4080305794`",
    ",", "2.0690508696345997`", ",", "2.3032858490824917`", ",", 
   "2.141429478283998`", ",", "2.2532722305057575`", ",", 
   "2.1759888887205214`", ",", "2.2293916778941196`", ",", 
   "2.1924903505751634`", ",", "2.2179891677525623`", ",", 
   "2.2003694850829794`", ",", "2.212544685807661`", ",", 
   "2.204131622106906`", ",", "2.209945049124128`", ",", 
   "2.2059279710552273`", ",", "2.2087037720008382`", ",", 
   "2.206785693547421`", ",", "2.2081110857587323`", ",", 
   "2.2071952397407157`", ",", "2.2078280893391655`", ",", 
   "2.2073907902666363`", ",", "2.207692963925754`", ",", 
   "2.2074841619273036`", ",", "2.2076284441082334`", ",", 
   "2.207528745121211`", ",", "2.2075976371212436`", ",", 
   "2.2075500327492206`", ",", "2.2075829273702885`", ",", 
   "2.2075601971871306`", ",", "2.2075759037436926`", ",", 
   "2.207565050513108`", ",", "2.207572550095442`", ",", 
   "2.2075673678840495`", ",", "2.207570948792122`", ",", 
   "2.2075684743846438`", ",", "2.207570184200211`", ",", 
   "2.207569002717654`", ",", "2.207569819122101`", ",", 
   "2.207569254986628`"}], "}"}]], "Output",
 CellChangeTimes->{3.7790112972073445`*^9, 
  3.77901230798092*^9},ExpressionUUID->"c982e68f-4dcb-46b3-96b5-5336d06eedc8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"10", "+", "x"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "5", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7790107042940207`*^9, 3.7790107427324877`*^9}, {
  3.7790108387693396`*^9, 
  3.7790108399237413`*^9}},ExpressionUUID->"8c7a7c11-a116-4f1f-bece-\
f7f3b0f38a90"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "we", " ", "can", " ", "see", " ", "that", " ", "the", " ", "iterative", 
     " ", "process", " ", "converges", " ", "to", " ", "the", " ", "exact", 
     " ", "root"}], ",", "\[IndentingNewLine]", 
    RowBox[{
    "Mathemetica", " ", "syntaxis", " ", "using", " ", "nesting", " ", "of", 
     " ", "functions"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "10."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778318748734375*^9, 
  3.77831883015625*^9}},ExpressionUUID->"4c4b58f2-0481-4812-b027-\
6208bf62c4e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.`", ",", 
   RowBox[{"-", "3.177`"}], ",", "5.928307`", ",", 
   RowBox[{"-", "0.3634601370000001`"}], ",", "3.984150954667`", ",", 
   "0.9799516903251027`", ",", "3.055853381985354`", ",", 
   "1.6214053130481205`", ",", "2.6126089286837484`", ",", 
   "1.9276872302795298`", ",", "2.4009681238768446`", ",", 
   "2.0739310264011004`", ",", "2.2999136607568396`", ",", 
   "2.143759660417024`", ",", "2.2516620746518363`", ",", 
   "2.177101506415581`", ",", "2.2286228590668333`", ",", 
   "2.193021604384818`", ",", "2.2176220713700907`", ",", 
   "2.2006231486832672`", ",", "2.2123694042598623`", ",", 
   "2.2042527416564353`", ",", "2.209861355515403`", ",", 
   "2.2059858033388564`", ",", "2.20866380989285`", ",", 
   "2.2068133073640404`", ",", "2.208092004611448`", ",", 
   "2.2072084248134898`", ",", "2.2078189784538784`", ",", 
   "2.20739708588837`", ",", "2.2076886136511362`", ",", 
   "2.2074871679670647`", ",", "2.2076263669347584`", ",", 
   "2.2075301804480816`", ",", "2.2075966453103755`", ",", 
   "2.2075507180905305`", ",", "2.2075824537994433`", ",", 
   "2.2075605244245846`", ",", "2.207575677622612`", ",", 
   "2.207565206762775`", ",", "2.2075724421269225`"}], "}"}]], "Output",
 CellChangeTimes->{3.7790102166371636`*^9, 3.7790102603328404`*^9, 
  3.779010666448354*^9, 3.779010848394556*^9, 
  3.77901230799652*^9},ExpressionUUID->"501f5854-c258-4ee1-99c6-1c32aa558854"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"In", " ", "case", " ", "of", " ", 
     RowBox[{"Abs", "[", 
      RowBox[{"q", "=", 
       RowBox[{"1", "-", "a"}]}], "]"}]}], ">", 
    RowBox[{"1", " ", "the", " ", "iterative", " ", "process", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "converge"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "2.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<condition of convergence, i.e. Abs[q=1-a]<1: \>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"q", "=", 
         RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", 
     RowBox[{"xExact", "+", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778319213796875*^9, 3.77831937140625*^9}, 
   3.778321235421875*^9},ExpressionUUID->"89c44910-08ae-4424-b5ef-\
00981aa64cdb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"condition of convergence, i.e. Abs[q=1-a]<1: \"\>", 
   "\[InvisibleSpace]", "False"}],
  SequenceForm["condition of convergence, i.e. Abs[q=1-a]<1: ", False],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216652764*^9, 3.77901026034844*^9, 
  3.77901230802772*^9},ExpressionUUID->"d049e1ab-dfbc-47b9-bd7a-d9a640002a2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xExact= \"\>", "\[InvisibleSpace]", "1.3872166480862134`"}],
  SequenceForm["xExact= ", 1.3872166480862134`],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216652764*^9, 3.77901026034844*^9, 
  3.77901230802772*^9},ExpressionUUID->"bcede4ac-8281-4f6d-9b0e-3b149330a63a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.3872176480862133`", ",", "1.3872149570862136`", ",", 
   "1.3872195075672131`", ",", "1.387211812703843`", ",", 
   "1.3872248247178018`", ",", "1.3872028214021972`", ",", 
   "1.3872400290088849`", ",", "1.3871771109459758`", ",", 
   "1.3872835053903554`", ",", "1.3871035923849093`", ",", 
   "1.3874078252771187`", ",", "1.3868933674563926`", ",", 
   "1.3877633156312403`", ",", "1.386292233267573`", ",", 
   "1.3887798335445347`", ",", "1.384573301476192`", ",", 
   "1.3916865472037596`", ",", "1.3796580486784427`", ",", 
   "1.399998239684754`", ",", "1.3656029766930815`", ",", 
   "1.4237653664119994`", ",", "1.3254127653973096`", ",", 
   "1.4917270137131498`", ",", "1.2104896198110642`", ",", 
   "1.6860620528994907`", ",", "0.8818690685469615`", ",", 
   "2.2417594050870884`", ",", 
   RowBox[{"-", "0.05781515400226578`"}], ",", "3.8307654254178316`", ",", 
   RowBox[{"-", "2.7448243343815526`"}], ",", "8.374497949439204`", ",", 
   RowBox[{"-", "10.428276032501692`"}], ",", "21.36721477096036`", ",", 
   RowBox[{"-", "32.398960177693965`"}], ",", "58.51964166048049`", ",", 
   RowBox[{"-", "95.22371404787249`"}], ",", "164.75630045495237`", ",", 
   RowBox[{"-", "274.86990406932443`"}], ",", "468.5380077812276`", ",", 
   RowBox[{"-", "788.5647711580558`"}], ",", "1337.1960280282722`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.779010216652764*^9, 3.77901026034844*^9, 
  3.77901230802772*^9},ExpressionUUID->"e645dd8f-2d2e-4e98-982a-e4460101eb4e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Of", " ", "course"}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{
              "we", " ", "can", " ", "transform", " ", "the", " ", "original",
                " ", "equation", " ", "into", " ", "a", " ", "form", " ", 
               "for", " ", "which", " ", "our", " ", "iterative", " ", 
               "process", " ", "converges"}], "..."}], " ", "but", " ", "is", 
             " ", "a", " ", "nice", " ", 
             RowBox[{"joke", ":", " ", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                  "to", " ", "find", " ", "a", " ", "proper", " ", 
                   "tansformation", " ", "factor", " ", "for", " ", "lhs", 
                   " ", "and", " ", "rhs", " ", "we", " ", "need", " ", 
                   "DIVISION"}], "..."}], " ", "moreover", " ", "we", " ", 
                 "used", " ", "DIVISION", " ", 
                 StyleBox["twice",
                  FontSlant->"Italic"], " ", "and", " ", "our", " ", 
                 "motivation", " ", "had", " ", "been", " ", "to", " ", 
                 "avoid", " ", "DIVISION", " ", "in", " ", "the", " ", 
                 "process", " ", "of", " ", "the", " ", "solution", " ", "of",
                  " ", "the", " ", "original", " ", "equation"}], "..."}], 
               "\[IndentingNewLine]", "/", 
               RowBox[{"But", ":", " ", 
                RowBox[{
                "we", " ", "have", " ", "used", " ", "division", " ", 
                 "twice"}]}]}]}]}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{
              "but", " ", "we", " ", "need", " ", "one", " ", "division", " ", 
               RowBox[{"(", 
                RowBox[{"evaluation", " ", "of", " ", 
                 FractionBox["1", "factor"], " ", "and", " ", "two", " ", 
                 "multiplications"}], ")"}], " ", "and", " ", "we", " ", 
               "have", " ", "used", " ", "division", " ", "by", " ", "an", 
               " ", "INTEGER", " ", "number"}], "..."}], " ", "it", " ", 
             "can", " ", "be", " ", "profitable", " ", "in", " ", "the", " ", 
             RowBox[{"end", ":", "-"}]}]}], ")"}], "/", "\[IndentingNewLine]", 
          RowBox[{"Look", ":", " ", 
           RowBox[{
           "IAP", " ", "really", " ", "is", " ", "not", " ", "a", " ", 
            "course", " ", "on", " ", "Mathematics", " ", "and", " ", "it", 
            " ", "is", " ", "not", " ", "a", " ", "course", " ", "for", " ", 
            "Scientists"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"really", ".", "\[IndentingNewLine]", "So"}], " ", "we", 
            " ", "can", " ", "play", " ", "with", " ", "computers", " ", 
            "and", " ", "solutions", " ", "and", " ", "we", " ", "can", " ", 
            "be", " ", "free", " ", "in", " ", "our", " ", "games"}], "..."}],
           " ", "and", " ", "one", " ", "of", " ", "our", " ", "game", " ", 
          "is", " ", "to", " ", "find", " ", 
          RowBox[{
           StyleBox["patterns",
            FontSlant->"Italic"], ".", " ", "There"}], " ", "are", " ", 
          "more", " ", "than", " ", "one", " ", "reason", " ", "why", " ", 
          "we", " ", "should", " ", "play", " ", "with", " ", 
          RowBox[{"patterns", ":", " ", 
           RowBox[{
            RowBox[{"1", "/", " ", "pattern"}], " ", "recognition", " ", "is",
             " ", "an", " ", "essential", " ", "part", " ", "of", " ", "not", 
            " ", "only", " ", 
            StyleBox["artifical",
             FontSlant->"Italic"], " ", "intelligence"}]}]}], ",", " ", 
         RowBox[{"but", " ", "of", " ", 
          StyleBox["intelligence",
           FontSlant->"Italic"], " ", "in", " ", 
          RowBox[{
           RowBox[{"general", ".", "\[IndentingNewLine]", "2"}], "/", " ", 
           "seaarching"}], " ", "for", " ", "patterns", " ", "is", " ", "an", 
          " ", "effective", " ", 
          StyleBox["gymm",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["lessons",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["for",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["our",
           FontSlant->"Italic"], 
          StyleBox[" ",
           FontSlant->"Italic"], 
          StyleBox["brains",
           FontSlant->"Italic"], 
          StyleBox["\[IndentingNewLine]",
           FontSlant->"Italic"], 
          StyleBox[
           RowBox[{"3", "/", " ", "patterns"}],
           FontSlant->"Italic"], 
          StyleBox[
           RowBox[{
            StyleBox[" ",
             FontSlant->"Italic"], " "}]], "are", " ", "usefull", " ", 
          "objects", " ", "in", " ", "Wolfram", " ", "Mathematica"}], ",", 
         " ", 
         RowBox[{"SW", " ", "of", " ", "my", " ", 
          RowBox[{"heart", ":", "-"}]}]}], ")"}], "\[IndentingNewLine]", 
       RowBox[{"4", "/", " ", "There"}], " ", "are", " ", "many", " ", 
       "\"\<pseudo-rules\>\"", " ", "for", " ", 
       RowBox[{"Engineers", ".", " ", "\"\<Pseudo\>\""}], " ", "because", " ", 
       RowBox[{"haven", "'"}], "t", " ", "been", " ", "proved"}], ",", " ", 
      RowBox[{
      "but", " ", "\"\<rules\>\"", " ", "because", " ", "are", " ", "usefull",
        " ", "in", " ", "the", " ", 
       RowBox[{"praxis", ".", " ", "Of"}], " ", "course", " ", "we", " ", 
       "have", " ", "to", " ", "remember"}], ",", " ", 
      RowBox[{"that", " ", "they", " ", "are", " ", 
       RowBox[{"\"\<pseudo\>\"", ".", " ", "The"}], " ", "prove", " ", "that",
        " ", "\"\<There must exist at least one function without Lebesque's \
integral value\>\"", " ", "is", " ", "a", " ", "nice", " ", "topic", " ", 
       "for", " ", "conversation"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
        "but", " ", "for", " ", "Engineers", " ", "it", " ", "can", " ", "be",
          " ", "maybe"}], "..."}], " ", "a", " ", 
       RowBox[{
        RowBox[{"hobby", ".", "\[IndentingNewLine]", "5"}], "/", "Next"}], 
       " ", "more", " ", "than", " ", "10", " ", "good", " ", "reasons", " ", 
       "why", " ", "understanding", " ", "understanding", " ", "patterns", 
       " ", "is", " ", 
       RowBox[{"profitable", ":", "-"}]}]}], ")"}], ")"}], "   ", 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aOrig", "=", "2.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bOrig", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"aOrig", "*", "x"}], "\[Equal]", "bOrig"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qOrig", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["bOrig", "aOrig"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<condition of convergence of the original eqquation, i.e. \
Abs[q=1-a]<1: \>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"qOig", "=", 
         RowBox[{"1", "-", "aOrig"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"factor", "=", 
     RowBox[{"Round", "[", "aOrig", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<original eqn: \>\"", ",", "originalEqn", ",", 
      "\"\< has been transformed into: \>\"", ",", 
      RowBox[{
       RowBox[{
        FractionBox["aOrig", "factor"], "*", "x"}], "\[Equal]", 
       FractionBox["bOrig", "factor"]}], ",", 
      "\"\< using facor = Round[a]= \>\"", ",", "factor"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"we", " ", "need", " ", "DIVISION", " ", 
     RowBox[{"twice", ":", " ", 
      RowBox[{"for", " ", "a", " ", "and", " ", "for", " ", "b"}]}]}], "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     FractionBox["aOrig", "factor"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     FractionBox["bOrig", "factor"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"1", "-", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<condition of convergence of transformed eqn, i.e. Abs[q=1-a]<1: \
\>\"", ",", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"q", "=", 
         RowBox[{"1", "-", "a"}]}], "]"}], "<", "1"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", "x", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x0", "=", "10."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xNext", "[", "xPrevious_", "]"}], ":=", 
     RowBox[{"b", "+", 
      RowBox[{"q", "*", "xPrevious"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"NestList", "[", 
    RowBox[{"xNext", ",", "x0", ",", "40"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.778320787125*^9, 3.77832087621875*^9}, {
   3.778321124328125*^9, 3.77832112671875*^9}, {3.77832115921875*^9, 
   3.7783212535*^9}, {3.77832130690625*^9, 3.7783215855625*^9}, {
   3.778321617421875*^9, 3.778321680625*^9}, {3.778321715296875*^9, 
   3.77832223996875*^9}, {3.778322275625*^9, 3.7783224076875*^9}, {
   3.77832247346875*^9, 3.778322550453125*^9}, {3.778322964859375*^9, 
   3.778323049234375*^9}, 3.778323292640625*^9, {3.778323516078125*^9, 
   3.778323615875*^9}, {3.778323678984375*^9, 3.778323737578125*^9}, {
   3.77832377559375*^9, 3.778323801296875*^9}, {3.77832383721875*^9, 
   3.7783238681875*^9}, 3.77837297609375*^9, {3.778373111078125*^9, 
   3.77837311175*^9}, {3.77837316775*^9, 
   3.77837321175*^9}},ExpressionUUID->"eeb7e5cc-d45a-40c8-86f4-878e278c9ff0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xExact= \"\>", "\[InvisibleSpace]", "1.3872166480862134`"}],
  SequenceForm["xExact= ", 1.3872166480862134`],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216683964*^9, 3.7790102603796406`*^9, 
  3.779010983631194*^9, 
  3.77901230805892*^9},ExpressionUUID->"50784e20-8966-4e9c-b8c4-843276151c59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"condition of convergence of the original eqquation, i.e. \
Abs[q=1-a]<1: \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm[
  "condition of convergence of the original eqquation, i.e. Abs[q=1-a]<1: ", 
   False],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216683964*^9, 3.7790102603796406`*^9, 
  3.779010983631194*^9, 
  3.77901230805892*^9},ExpressionUUID->"1edae062-63b6-41f7-91f3-3338074b96ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"original eqn: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2.691`", " ", "x"}], "\[Equal]", "3.733`"}], 
   "\[InvisibleSpace]", "\<\" has been transformed into: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"0.8969999999999999`", " ", "x"}], "\[Equal]", 
    "1.2443333333333333`"}], 
   "\[InvisibleSpace]", "\<\" using facor = Round[a]= \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm[
  "original eqn: ", 2.691 $CellContext`x == 3.733, 
   " has been transformed into: ", 0.8969999999999999 $CellContext`x == 
   1.2443333333333333`, " using facor = Round[a]= ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216683964*^9, 3.7790102603796406`*^9, 
  3.779010983631194*^9, 
  3.77901230805892*^9},ExpressionUUID->"216b916e-4fcf-41e1-b7fa-a56e9750e857"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"condition of convergence of transformed eqn, i.e. \
Abs[q=1-a]<1: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm[
  "condition of convergence of transformed eqn, i.e. Abs[q=1-a]<1: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216683964*^9, 3.7790102603796406`*^9, 
  3.779010983631194*^9, 
  3.77901230805892*^9},ExpressionUUID->"beaf1965-9b0a-4b44-bdc1-64653a48f624"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.`", ",", "2.274333333333334`", ",", "1.478589666666667`", ",", 
   "1.3966280690000001`", ",", "1.3881860244403335`", ",", 
   "1.3873164938506877`", ",", "1.3872269321999542`", ",", 
   "1.3872177073499288`", ",", "1.3872167571903762`", ",", 
   "1.3872166593239421`", ",", "1.3872166492436995`", ",", 
   "1.3872166482054344`", ",", "1.387216648098493`", ",", 
   "1.3872166480874781`", ",", "1.3872166480863437`", ",", 
   "1.387216648086227`", ",", "1.3872166480862147`", ",", 
   "1.3872166480862136`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`", ",", 
   "1.3872166480862134`", ",", "1.3872166480862134`"}], "}"}]], "Output",
 CellChangeTimes->{3.779010216683964*^9, 3.779010260395241*^9, 
  3.7790109836467943`*^9, 
  3.77901230805892*^9},ExpressionUUID->"b197bc3c-6358-4cc0-b2d6-88ead208b255"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Ok", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"let", "'"}], "s", " ", "move", " ", "to", " ", "next", " ", 
      "task"}], "..."}], "\[IndentingNewLine]", 
    RowBox[{"Let", "'"}], "s", " ", "accept", " ", "as", " ", "a", " ", 
    "fact", " ", "that", " ", "we", " ", "can", " ", "solve", " ", 
    "ewuations", " ", "of", " ", "form", " ", 
    RowBox[{"\"\<a*x\[Equal]b\>\"", ".", "\[IndentingNewLine]", "We"}], " ", 
    "are", " ", "searching", " ", "for", " ", "x", " ", "value"}], ",", " ", 
   RowBox[{
   "it", " ", "means", " ", "x", " ", "valie", " ", "is", " ", "an", " ", 
    RowBox[{"output", ".", " ", "So"}]}], ",", " ", 
   RowBox[{"a", " ", "and", " ", "b", " ", "values", " ", "are", " ", 
    RowBox[{"inputs", ".", " ", "\[IndentingNewLine]", "Our"}], " ", "inputs",
     " ", "are", " ", "outputs", " ", "of", " ", "other", " ", "systems"}], 
   ",", " ", 
   RowBox[{
   "in", " ", "engineering", " ", "area", " ", "mainly", " ", "digital", " ", 
    "data", " ", "as", " ", "outputs", " ", "of", " ", "digital", " ", 
    "mearuring", " ", 
    RowBox[{
    "devices", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "Keeping"}],
     " ", "Newtonian", " ", 
    StyleBox["smooth",
     FontSlant->"Italic"], " ", "description", " ", "of", " ", "our", " ", 
    "technical", " ", "engineeing", " ", "problems"}], ",", " ", 
   RowBox[{"we", " ", "can", " ", "understand", " ", "that", " ", 
    StyleBox["ALL",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["inputs",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    StyleBox["are",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontSlant->"Italic"], 
    RowBox[{
     StyleBox["eroneous",
      FontSlant->"Italic"], ".", " ", "The"}], " ", "probability", " ", 
    "that", " ", "fo", " ", "example", " ", "current", " ", "is", " ", "a", 
    " ", "discrete", " ", 
    RowBox[{"(", 
     RowBox[{"digital", " ", "representation"}], ")"}], " ", "value", " ", 
    "is", " ", "0.", " ", "\[IndentingNewLine]", "So"}], ",", " ", 
   RowBox[{"we", " ", "shoud", " ", "search", " ", 
    RowBox[{"(", 
     RowBox[{
     "wanting", " ", "pay", " ", "no", " ", "money", " ", "and", " ", "not", 
      " ", "to", " ", "be", " ", "in", " ", "prison"}], ")"}], " ", "for", 
    " ", "the", " ", "inecurracy", " ", "of", " ", "x", " ", "as", " ", "a", 
    " ", "function", " ", "of", " ", "inecuracies", " ", "of", " ", "a", " ", 
    "and", " ", "b"}]}], "\[IndentingNewLine]", "*)"}]], "Input",
 CellChangeTimes->{{3.77832286265625*^9, 3.778322947703125*^9}, {
  3.7783230746875*^9, 3.778323099890625*^9}, {3.778323153203125*^9, 
  3.778323233484375*^9}, {3.77832331446875*^9, 3.778323406875*^9}, {
  3.7783239813125*^9, 3.77832403125*^9}, {3.7783248524375*^9, 
  3.77832501165625*^9}, {3.778372955421875*^9, 
  3.77837295590625*^9}},ExpressionUUID->"e564f138-b089-4cab-9d4c-\
dfe3273c59fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Brutal", " ", "force", " ", "solution"}], ",", " ", 
    RowBox[{
     RowBox[{"we", "'"}], "ll", " ", "use", " ", "Solve", " ", "command", " ",
      "or", " ", "division"}], ",", " ", 
    RowBox[{
    "now", " ", "we", " ", "want", " ", "to", " ", "show", " ", "other", " ", 
     "poblems", " ", "than", " ", "solution", " ", "of", " ", "an", " ", 
     "equation"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "1.691"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "3.733"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalEqn", "=", 
     RowBox[{
      RowBox[{"a", "*", "x"}], "\[Equal]", "b"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xExact", "=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<xExact= \>\"", ",", "xExact"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.778325018203125*^9, 3.7783251676875*^9}, {
  3.77837262459375*^9, 
  3.7783726258125*^9}},ExpressionUUID->"29d595a6-eed8-4900-9d22-14033df2fd20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xExact= \"\>", "\[InvisibleSpace]", "2.2075694855115313`"}],
  SequenceForm["xExact= ", 2.2075694855115313`],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216715164*^9, 3.7790102604264407`*^9, 
  3.7790123081057205`*^9},ExpressionUUID->"543dcfa6-a09d-4791-a43b-\
fac36a5540b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "now", " ", "we", " ", "involve", " ", "inaccuracies", " ", "of", " ", 
    StyleBox["a",
     FontSlant->"Italic"], " ", "and", " ", 
    StyleBox["b",
     FontSlant->"Italic"], " ", "into", " ", "the", " ", "game"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]aMax", "=", 
     RowBox[{"0.02", "*", "a"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]bMax", "=", 
     RowBox[{"0.02", "*", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xab", "[", 
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_"}], "}"}], "]"}], ":=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataab", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"#", ",", "1"}], "]"}], "&"}], "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"a", "-", "\[CapitalDelta]aMax"}], ",", 
          RowBox[{"a", "+", "\[CapitalDelta]aMax"}], ",", 
          "\[CapitalDelta]aMax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"b", "-", "\[CapitalDelta]bMax"}], ",", 
          RowBox[{"b", "+", "\[CapitalDelta]bMax"}], ",", 
          "\[CapitalDelta]bMax"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"solutions", "=", 
    RowBox[{"xab", "/@", "dataab"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"minx", ",", "maxx"}], "}"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Min", "[", "#", "]"}], ",", 
         RowBox[{"Max", "[", "#", "]"}]}], "}"}], "&"}], "@", "solutions"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<we can be sure that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{"minx", ",", "maxx"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778325213578125*^9, 3.778325590171875*^9}, {
   3.77837206265625*^9, 3.7783721235625*^9}, 
   3.778372656375*^9},ExpressionUUID->"77bb26a0-bcd6-4ebf-801f-83f056f4138d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2075694855115313`", ",", "2.2526219239913585`", ",", 
   "2.2976743624711857`", ",", "2.1634180958013007`", ",", 
   "2.2075694855115313`", ",", "2.251720875221762`", ",", 
   "2.1209981331385306`", ",", "2.164283809325031`", ",", 
   "2.2075694855115318`"}], "}"}]], "Output",
 CellChangeTimes->{3.779010216730764*^9, 3.7790102604420404`*^9, 
  3.7790119580411053`*^9, 
  3.7790123081057205`*^9},ExpressionUUID->"de928fe0-7a69-4d96-b636-\
54779f76b48d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"we can be sure that x \[Epsilon] \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.1209981331385306`", ",", "2.2976743624711857`"}], "}"}]}],
  SequenceForm[
  "we can be sure that x \[Epsilon] ", {2.1209981331385306`, 
   2.2976743624711857`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216730764*^9, 3.7790102604420404`*^9, 
  3.7790119580411053`*^9, 
  3.7790123081057205`*^9},ExpressionUUID->"94d24046-ce82-4cc1-af7f-\
1ba5a3dc1bc6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"error", " ", "using", " ", "Taylor", " ", "series"}], ",", " ", 
    RowBox[{
    "for", " ", "small", " ", "\[CapitalDelta]aMax", " ", "and", " ", 
     "\[CapitalDelta]bMax", " ", "values", " ", "nearly", " ", "the", " ", 
     "same", " ", "result"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
     FractionBox["b", "a"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalDelta]x", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"ain", ",", "bin"}], "]"}], ",", "ain"}], "]"}], "*", 
         "\[CapitalDelta]aMax"}], "]"}], "+", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"x", "[", 
            RowBox[{"ain", ",", "bin"}], "]"}], ",", "bin"}], "]"}], "*", 
         "\[CapitalDelta]bMax"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ain", "\[Rule]", "a"}], ",", 
        RowBox[{"bin", "\[Rule]", "b"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<we hope that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xExact", "-", "\[CapitalDelta]x"}], ",", 
       RowBox[{"xExact", "+", "\[CapitalDelta]x"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.77837215015625*^9, 3.77837218584375*^9}, {
  3.77837222378125*^9, 
  3.778372588609375*^9}},ExpressionUUID->"e074d2b7-85d5-4d68-9412-\
11325f1e23a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"we hope that x \[Epsilon] \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.11926670609107`", ",", "2.2958722649319925`"}], "}"}]}],
  SequenceForm[
  "we hope that x \[Epsilon] ", {2.11926670609107, 2.2958722649319925`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216746364*^9, 3.7790102604576406`*^9, 
  3.7790123081213207`*^9},ExpressionUUID->"f887a4d6-8fd6-4520-a3cf-\
3726170e7a8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"statistical", " ", "access"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]xStatistical", "=", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"x", "[", 
               RowBox[{"ain", ",", "bin"}], "]"}], ",", "ain"}], "]"}], "*", 
            "\[CapitalDelta]aMax"}], ")"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"x", "[", 
               RowBox[{"ain", ",", "bin"}], "]"}], ",", "bin"}], "]"}], "*", 
            "\[CapitalDelta]bMax"}], ")"}], "2"]}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ain", "\[Rule]", "a"}], ",", 
          RowBox[{"bin", "\[Rule]", "b"}]}], "}"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<according the statistical distibution of errors of a and be there is \
some probability that x \[Epsilon] \>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xExact", "-", "\[CapitalDelta]xStatistical"}], ",", 
       RowBox[{"xExact", "+", "\[CapitalDelta]xStatistical"}]}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.778372669671875*^9, 3.778372811390625*^9}, {
   3.77837284753125*^9, 3.7783728998125*^9}, 
   3.778373233609375*^9},ExpressionUUID->"9098bb3e-f030-477e-94c8-\
970c5ea2df1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"according the statistical distibution of errors of a and be \
there is some probability that x \[Epsilon] \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.145129991385703`", ",", "2.2700089796373595`"}], "}"}]}],
  SequenceForm[
  "according the statistical distibution of errors of a and be there is some \
probability that x \[Epsilon] ", {2.145129991385703, 2.2700089796373595`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.779010216746364*^9, 3.7790102604576406`*^9, 
  3.7790123081369205`*^9},ExpressionUUID->"2f4bb245-9389-4c46-b27f-\
89864e0fe715"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x0", ",", "5"}], "]"}]], "Input",
 CellChangeTimes->{{3.7790093802094946`*^9, 
  3.7790093938751183`*^9}},ExpressionUUID->"74224c91-6087-4223-8d5b-\
7f047fde53c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x0", ",", 
   RowBox[{"f", "[", "x0", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x0", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x0", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x0", "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", 
       RowBox[{"f", "[", "x0", "]"}], "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7790093944523196`*^9, 3.779010216761964*^9, 
  3.779010260473241*^9, 
  3.7790123081369205`*^9},ExpressionUUID->"13e055d6-46fe-4dbd-b0b8-\
7fb0c399a6a9"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{"Cos", ",", "0.", ",", "50"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xLast", "=", 
   RowBox[{"Last", "[", "%", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "xLast", "]"}], "-", "xLast"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7790094897996874`*^9, 3.7790094962424984`*^9}, {
  3.7790095766918397`*^9, 3.779009592432267*^9}, {3.779010220677571*^9, 
  3.7790102221595736`*^9}},ExpressionUUID->"58726386-e1c1-486a-a705-\
66c37687c70c"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"q", "=", 
    RowBox[{"-", "1.5"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     SuperscriptBox["q", "i"], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "20"}], "}"}]}], "]"}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", "%", "]"}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.779010039374052*^9, 3.7790101049253674`*^9}, {
   3.7790102130179577`*^9, 3.779010215233161*^9}, 
   3.7790102579928365`*^9},ExpressionUUID->"e2f82680-c680-4344-990a-\
102d01ab04e1"]
},
WindowSize->{1148, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->2.1000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 468, 13, 181, "Input",ExpressionUUID->"47c12178-c0c6-416c-9ca8-fa07f4bc14e0"],
Cell[CellGroupData[{
Cell[1038, 37, 2469, 59, 664, "Input",ExpressionUUID->"b0a204e5-715a-4e6d-8cc3-3e565739e2db"],
Cell[CellGroupData[{
Cell[3532, 100, 362, 7, 45, "Print",ExpressionUUID->"7ec11927-f9ee-4804-8d0a-5f001e7cf660"],
Cell[3897, 109, 410, 8, 45, "Print",ExpressionUUID->"70d2c801-28c3-43f8-bf2f-e36ba2efd06f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4356, 123, 1395, 35, 341, "Input",ExpressionUUID->"0300f5e2-416a-42dc-9ea6-9970b0d30df5"],
Cell[5754, 160, 1359, 24, 269, "Output",ExpressionUUID->"c982e68f-4dcb-46b3-96b5-5336d06eedc8"]
}, Open  ]],
Cell[7128, 187, 454, 12, 141, "Input",ExpressionUUID->"8c7a7c11-a116-4f1f-bece-f7f3b0f38a90"],
Cell[CellGroupData[{
Cell[7607, 203, 967, 24, 301, "Input",ExpressionUUID->"4c4b58f2-0481-4812-b027-6208bf62c4e0"],
Cell[8577, 229, 1451, 25, 269, "Output",ExpressionUUID->"501f5854-c258-4ee1-99c6-1c32aa558854"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10065, 259, 1999, 55, 664, "Input",ExpressionUUID->"89c44910-08ae-4424-b5ef-00981aa64cdb"],
Cell[CellGroupData[{
Cell[12089, 318, 380, 7, 45, "Print",ExpressionUUID->"d049e1ab-dfbc-47b9-bd7a-d9a640002a2b"],
Cell[12472, 327, 330, 6, 45, "Print",ExpressionUUID->"bcede4ac-8281-4f6d-9b0e-3b149330a63a"]
}, Open  ]],
Cell[12817, 336, 1525, 26, 309, "Output",ExpressionUUID->"e645dd8f-2d2e-4e98-982a-e4460101eb4e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14379, 367, 10462, 239, 2912, "Input",ExpressionUUID->"eeb7e5cc-d45a-40c8-86f4-878e278c9ff0"],
Cell[CellGroupData[{
Cell[24866, 610, 358, 7, 45, "Print",ExpressionUUID->"50784e20-8966-4e9c-b8c4-843276151c59"],
Cell[25227, 619, 465, 10, 83, "Print",ExpressionUUID->"1edae062-63b6-41f7-91f3-3338074b96ce"],
Cell[25695, 631, 845, 19, 83, "Print",ExpressionUUID->"216b916e-4fcf-41e1-b7fa-a56e9750e857"],
Cell[26543, 652, 445, 9, 83, "Print",ExpressionUUID->"beaf1965-9b0a-4b44-bdc1-64653a48f624"]
}, Open  ]],
Cell[27003, 664, 1431, 25, 269, "Output",ExpressionUUID->"b197bc3c-6358-4cc0-b2d6-88ead208b255"]
}, Open  ]],
Cell[28449, 692, 3005, 65, 781, "Input",ExpressionUUID->"e564f138-b089-4cab-9d4c-dfe3273c59fc"],
Cell[CellGroupData[{
Cell[31479, 761, 1267, 33, 424, "Input",ExpressionUUID->"29d595a6-eed8-4900-9d22-14033df2fd20"],
Cell[32749, 796, 338, 7, 45, "Print",ExpressionUUID->"543dcfa6-a09d-4791-a43b-fac36a5540b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33124, 808, 2270, 63, 464, "Input",ExpressionUUID->"77bb26a0-bcd6-4ebf-801f-83f056f4138d"],
Cell[35397, 873, 499, 11, 109, "Output",ExpressionUUID->"de928fe0-7a69-4d96-b636-54779f76b48d"],
Cell[35899, 886, 512, 12, 45, "Print",ExpressionUUID->"94d24046-ce82-4cc1-af7f-1ba5a3dc1bc6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36448, 903, 1699, 48, 344, "Input",ExpressionUUID->"e074d2b7-85d5-4d68-9412-11325f1e23a7"],
Cell[38150, 953, 462, 10, 45, "Print",ExpressionUUID->"f887a4d6-8fd6-4520-a3cf-3726170e7a8e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38649, 968, 1601, 44, 352, "Input",ExpressionUUID->"9098bb3e-f030-477e-94c8-970c5ea2df1f"],
Cell[40253, 1014, 624, 12, 83, "Print",ExpressionUUID->"2f4bb245-9389-4c46-b27f-89864e0fe715"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40914, 1031, 225, 5, 60, "Input",ExpressionUUID->"74224c91-6087-4223-8d5b-7f047fde53c3"],
Cell[41142, 1038, 752, 22, 109, "Output",ExpressionUUID->"13e055d6-46fe-4dbd-b0b8-7fb0c399a6a9"]
}, Open  ]],
Cell[41909, 1063, 559, 13, 141, "Input",ExpressionUUID->"58726386-e1c1-486a-a705-66c37687c70c"],
Cell[42471, 1078, 575, 15, 147, "Input",ExpressionUUID->"e2f82680-c680-4344-990a-102d01ab04e1"]
}
]
*)

