(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    252316,       4804]
NotebookOptionsPosition[    250126,       4762]
NotebookOutlinePosition[    250607,       4780]
CellTagsIndexPosition[    250564,       4777]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "DC", " ", "machine", " ", "with", " ", "constant", " ", "feeding", " ", 
     "current"}], ",", " ", 
    RowBox[{
    "La", " ", "and", " ", "Ra", "  ", "inductance", " ", "and", " ", 
     "resistance", " ", "of", " ", "the", " ", "rotor", " ", "windings"}], 
    ",", " ", 
    RowBox[{"J", " ", "moment", " ", "of", " ", "inertia"}], ",", " ", 
    RowBox[{
    "B", " ", "respects", " ", "the", " ", "torque", " ", "of", " ", 
     "newtonian", " ", "friction", " ", "and", " ", "kz", "*", 
     SuperscriptBox[
      RowBox[{"\[Omega]", "[", "t", "]"}], "2"], " ", "respects", " ", 
     "typical", " ", "load"}], ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "hydrodynamic"}], " ", "machine", " ", 
     RowBox[{"(", 
      RowBox[{"pump", ",", " ", 
       RowBox[{"fan", "..."}]}], ")"}]}], ",", " ", 
    RowBox[{
    "ia", " ", "is", " ", "the", " ", "current", " ", "through", " ", "the", 
     " ", "rotor", " ", "windings"}], ",", " ", 
    RowBox[{"u", " ", "or", " ", 
     RowBox[{"u", "[", "t", "]"}], " ", "voltage", " ", "on", " ", 
     RowBox[{"it", ".", " ", "k"}], "*", 
     RowBox[{"ia", "[", "t", "]"}], " ", "is", " ", "the", " ", "internal", 
     " ", "torque"}], ",", " ", 
    RowBox[{
     RowBox[{"ui", "[", "t", "]"}], " ", "induced", " ", "voltage", " ", 
     "beacause", " ", "the", " ", "motion", " ", "of", " ", "wires", " ", 
     "in", " ", "magnetic", " ", "field"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.67912361028125*^9, 3.67912362240625*^9}, {
  3.679123680828125*^9, 3.679123735015625*^9}, {3.67912377540625*^9, 
  3.679123794015625*^9}, {3.679123825453125*^9, 
  3.679124049703125*^9}},ExpressionUUID->"db8f5023-f83b-4c38-a740-\
0f47e5be5c45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"to", " ", "see", " ", "outputs"}], ",", " ", 
    RowBox[{"delete", " ", "respective", " ", "semicolons"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"An", " ", "intristing", " ", "pehonomenon"}], ",", " ", 
     RowBox[{
      RowBox[{
      "possible", " ", "because", " ", "of", " ", "nonlinearity", " ", "of", 
       " ", "the", " ", "load", " ", 
       RowBox[{"(", 
        RowBox[{"do", " ", "you", " ", "know", " ", 
         RowBox[{"why", "?"}]}], ")"}], " ", "try", " ", "solution", " ", 
       "with", " ", "u"}], "\[Rule]", 
      RowBox[{
       RowBox[{"1", " ", "and", " ", "u"}], "\[Rule]", "10"}]}], ",", " ", 
     RowBox[{"first", " ", "response", " ", "is", " ", "oscillating"}], ",", 
     " ", 
     RowBox[{"the", " ", "second", " ", 
      RowBox[{"isn", "'"}], 
      RowBox[{"t", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sign", ":=", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"50.", "#"}], "]"}], "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rcedif", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "\[Equal]", 
        RowBox[{
         RowBox[{"La", "*", 
          RowBox[{
           RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"Ra", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "+", 
         RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"ui", "[", "t", "]"}], "\[Equal]", 
        RowBox[{"k", "*", 
         RowBox[{"\[Omega]", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"J", "*", 
         RowBox[{
          RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"k", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "-", 
         RowBox[{"B", "*", 
          RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
         RowBox[{"kz", "*", 
          SuperscriptBox[
           RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pocs", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"ia", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dos1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"La", "\[Rule]", "1"}], ",", 
       RowBox[{"Ra", "\[Rule]", "0.5"}], ",", 
       RowBox[{"k", "\[Rule]", "2"}], ",", 
       RowBox[{"B", "\[Rule]", ".3"}], ",", 
       RowBox[{"kz", "\[Rule]", "0.4"}], ",", 
       RowBox[{"J", "\[Rule]", 
        RowBox[{"1.5", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "1"}]]}]}], ",", 
       RowBox[{"u", "\[Rule]", "100"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rce", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", "dos1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nezname", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"rce", ",", 
        RowBox[{
         RowBox[{"a_Symbol", "[", "t", "]"}], "\[RuleDelayed]", "a"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{"rce", ",", "nezname", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "res"}], ",", 
        RowBox[{
         RowBox[{"ia", "[", "t", "]"}], "/.", "res"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Blue", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t [s]\>\"", ",", 
         "\"\<\!\(\*StyleBox[\"\[Omega]\",FontColor->RGBColor[1, 0, 0]]\)\!\(\
\*StyleBox[\" \",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"[\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[SuperscriptBox[\"s\", RowBox[{\"-\", \
\"1\"}]],FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"]\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[1, 0, 0]]\) \
\!\(\*StyleBox[\"ia\",FontColor->RGBColor[0, 0, 1]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[0, 0, 1]]\)\!\(\*StyleBox[\"[\",FontColor->RGBColor[0, \
0, 1]]\)\!\(\*StyleBox[\"A\",FontColor->RGBColor[0, 0, \
1]]\)\!\(\*StyleBox[\"]\",FontColor->RGBColor[0, 0, 1]]\)\>\""}], "}"}]}], 
      ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gr1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "res"}], ",", 
         RowBox[{
          RowBox[{"ia", "[", "t", "]"}], "/.", "res"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<t [s]\>\"", ",", 
          "\"\<\!\(\*StyleBox[\"\[Omega]\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\" \",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"[\",FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[SuperscriptBox[\"s\", RowBox[{\"-\", \
\"1\"}]],FontColor->RGBColor[1, 0, \
0]]\)\!\(\*StyleBox[\"]\",FontColor->RGBColor[1, 0, 0]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[1, 0, 0]]\) \
\!\(\*StyleBox[\"ia\",FontColor->RGBColor[0, 0, 1]]\)\!\(\*StyleBox[\" \
\",FontColor->RGBColor[0, 0, 1]]\)\!\(\*StyleBox[\"[\",FontColor->RGBColor[0, \
0, 1]]\)\!\(\*StyleBox[\"A\",FontColor->RGBColor[0, 0, \
1]]\)\!\(\*StyleBox[\"]\",FontColor->RGBColor[0, 0, 1]]\)\>\""}], "}"}]}], 
       ",", 
       RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.67739446709375*^9, {3.677394591203125*^9, 3.6773951425*^9}, {
   3.67835134171875*^9, 3.678351390125*^9}, {3.678351442515625*^9, 
   3.678351477765625*^9}, {3.678351514734375*^9, 3.67835169046875*^9}, {
   3.6783517318125*^9, 3.678351774859375*^9}, {3.678351810515625*^9, 
   3.678351929921875*^9}, 3.678351964359375*^9, {3.67836093278125*^9, 
   3.67836098834375*^9}, {3.679119970640625*^9, 3.67912006653125*^9}, {
   3.679120289171875*^9, 3.679120359171875*^9}, 3.679123246296875*^9, 
   3.679123406109375*^9, {3.6791242488125*^9, 
   3.679124275640625*^9}},ExpressionUUID->"31a88f22-1612-4f9d-8c5d-\
f1eaa66135cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "rSteady1", ",", "\[Omega]", ",", "uSteady1", ",", "uSteady2", ",", "u"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"rSteady1", "[", "\[Omega]_", "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"rcedif", "/.", 
       RowBox[{
        RowBox[{
         RowBox[{"_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", "0"}]}], 
      ")"}], "/.", 
     RowBox[{
      RowBox[{"a_", "[", "t", "]"}], "\[RuleDelayed]", "a"}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"if", " ", "easily", " ", "possible"}], ",", " ", 
    RowBox[{
     RowBox[{
     "it", " ", "would", " ", "be", " ", "interesting", " ", "and", " ", 
      "sometimes", " ", "profitable", " ", "for", " ", "programming"}], 
     "..."}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solGeneral", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"rSteady1", "[", "\[Omega]", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ia", ",", "u", ",", "ui"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"numerical", " ", "solution"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"uSteady1", "[", "\[Omega]_", "]"}], ":=", 
    RowBox[{"u", "/.", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"rSteady1", "[", "\[Omega]", "]"}], "/.", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"dos1", ",", 
          RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"using", " ", "analytical", " ", "solGeneral"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"uSteady2", "[", "\[Omega]_", "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "/.", "solGeneral"}], ")"}], "/.", "dos1"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.678351991421875*^9, 3.67835204675*^9}, {
  3.678352080640625*^9, 3.67835240303125*^9}, {3.678352441046875*^9, 
  3.67835251171875*^9}, {3.6783527504375*^9, 3.678352971421875*^9}, {
  3.678353456125*^9, 3.6783534565*^9}, {3.679120315296875*^9, 
  3.67912032859375*^9}},ExpressionUUID->"15f49443-eb58-4f27-8c0b-\
4f3f196ca860"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "solution", " ", "based", " ", "on", " ", "symbolic", " ", 
    "access", " ", "is", " ", "reasonably", " ", 
    RowBox[{"faster", "!"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"time", "[", 
      RowBox[{"f_", ",", "nEvaluations_Integer"}], "]"}], ":=", 
     RowBox[{"First", "@", 
      RowBox[{"Timing", "[", 
       RowBox[{"f", "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"0.", ",", "nEvaluations"}], "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"time", "[", 
      RowBox[{"#", ",", "1000"}], "]"}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"uSteady1", ",", "uSteady2"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6783531011875*^9, 3.678353278671875*^9}, {
  3.678353315640625*^9, 3.678353379359375*^9}, {3.67835347109375*^9, 
  3.67835347453125*^9}},ExpressionUUID->"16dfaa29-bace-49b6-abd7-\
f42b01c990b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.109375`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8473335606941595`*^9},ExpressionUUID->"56a5eabc-ac10-471c-8fc7-\
559aec398d83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "response", " ", "of", " ", "the", " ", "system", " ", "when", " ", "we", 
     " ", "first", " ", "switch", " ", "the", " ", "voltage", " ", "from", 
     " ", "0", " ", "to", " ", "the", " ", "value", " ", "corresponding", " ",
      "to", " ", "the", " ", "first", " ", "steady", " ", "\[Omega]1"}], ",", 
    " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "u1"}], "=", 
     RowBox[{"uSteady2", "[", "\[Omega]1", "]"}]}], ",", " ", 
    RowBox[{
    "wait", " ", "till", " ", "the", " ", "steady", " ", "state", " ", "is", 
     " ", "nearly", " ", "reached"}], ",", " ", 
    RowBox[{
    "then", " ", "we", " ", "switch", "  ", "the", " ", "voltage", " ", 
     "from", " ", "u1", " ", "to", " ", "the", " ", "value", " ", 
     "corresponding", " ", "to", " ", "the", " ", "first", " ", "steady", " ",
      "\[Omega]2"}], ",", " ", 
    RowBox[{
     RowBox[{"i", ".", "e", ".", " ", "u2"}], "=", 
     RowBox[{"uSteady2", "[", "\[Omega]2", "]"}]}], ",", " ", 
    RowBox[{
    "wait", " ", "till", " ", "the", " ", "steady", " ", "state", " ", "is", 
     " ", "nearly", " ", "reached"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"sol1", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol1", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"omegas", ":", 
         RowBox[{"{", 
          RowBox[{"\[Omega]1_", ",", "\[Omega]2_"}], "}"}]}], ",", "tsol_"}], 
       "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "u1", ",", "u2", ",", "step", ",", "uu", ",", "rce", ",", "res"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], "=", 
         RowBox[{"uSteady2", "/@", "omegas"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"step", "=", "UnitStep"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uu", "[", "t_", "]"}], ":=", 
         RowBox[{
          RowBox[{"u1", "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "0"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u2", "-", "u1"}], ")"}], "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rce", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Union", "[", 
             RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", 
            RowBox[{"u", "\[Rule]", 
             RowBox[{"uu", "[", "t", "]"}]}]}], ")"}], "/.", "dos1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{"rce", ",", "nezname", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", 
              RowBox[{"2", "*", "tsol"}]}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"res", ",", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"uu", "[", "t", "]"}], "/.", 
             RowBox[{"t", "\[Rule]", "#"}]}], "]"}], "&"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"\[Omega]", "/.", 
      RowBox[{
       RowBox[{"sol1", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "40"}], "}"}], ",", "10"}], "}"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"time", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Omega]", "/.", 
          RowBox[{
           RowBox[{"sol1", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"20", ",", 
                RowBox[{"20", "+", "#"}]}], "}"}], ",", "10"}], "}"}], "]"}], 
           "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "[", "0.5", "]"}], "&"}], 
      ",", "40"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"pom", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<time= \>\"", "<>", 
       RowBox[{"ToString", "[", "%", "]"}], "<>", "\"\< s\>\""}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\<\[Omega] [\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], 
       "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.678353505140625*^9, 3.67835357303125*^9}, {
   3.678353620125*^9, 3.6783539295*^9}, {3.6783539660625*^9, 
   3.6783540546875*^9}, {3.67835410746875*^9, 3.678354122296875*^9}, {
   3.678354281*^9, 3.678354525046875*^9}, {3.6783545614375*^9, 
   3.678354851234375*^9}, {3.678354992359375*^9, 3.67835509740625*^9}, {
   3.678355674046875*^9, 3.67835570271875*^9}, {3.678355889984375*^9, 
   3.678356097140625*^9}, {3.678438857828125*^9, 3.678438861765625*^9}, 
   3.67912037575*^9},ExpressionUUID->"a04d402d-2960-4e06-86f3-df56678cc9a1"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV2Hk8VN8bB3BRkiVrIvu+MzNXkeh+mBQSpYgSpbJEvqVN0WZJCSHZKhJK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       "]]},
     Annotation[#, "Charting`Private`Tag$4166#1"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\"\[Omega] [\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)]\"", 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"time= 0.5 s\"", TraditionalForm],
  PlotRange->{{0, 20}, {0., 39.97196848937585}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473335613814974`*^9},ExpressionUUID->"332664e9-59b6-47ca-99d8-\
60023597d650"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"continuous", " ", "access"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"we", " ", "can", " ", "see", " ", "no", " ", "profit"}], 
       "..."}], "now"}], "..."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"20", "t"}], "]"}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"sol1", ",", "t"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol1", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"omegas", ":", 
         RowBox[{"{", 
          RowBox[{"\[Omega]1_", ",", "\[Omega]2_"}], "}"}]}], ",", "tsol_"}], 
       "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "u1", ",", "u2", ",", "step", ",", "uu", ",", "rce", ",", "res"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u1", ",", "u2"}], "}"}], "=", 
         RowBox[{"uSteady2", "/@", "omegas"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"step", "=", 
         RowBox[{
          RowBox[{"0.5", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"Tanh", "[", 
              RowBox[{"20", "#"}], "]"}]}], ")"}]}], "&"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"uu", "[", "t_", "]"}], ":=", 
         RowBox[{
          RowBox[{"u1", "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "0"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"u2", "-", "u1"}], ")"}], "*", 
           RowBox[{"step", "[", 
            RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"rce", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Union", "[", 
             RowBox[{"pocs", ",", "rcedif"}], "]"}], "/.", 
            RowBox[{"u", "\[Rule]", 
             RowBox[{"uu", "[", "t", "]"}]}]}], ")"}], "/.", "dos1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"res", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{"rce", ",", "nezname", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", 
              RowBox[{"2", "*", "tsol"}]}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"res", ",", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"uu", "[", "t", "]"}], "/.", 
             RowBox[{"t", "\[Rule]", "#"}]}], "]"}], "&"}]}], "}"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"\[Omega]", "/.", 
      RowBox[{
       RowBox[{"sol1", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"20", ",", "40"}], "}"}], ",", "10"}], "}"}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"time", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Omega]", "/.", 
          RowBox[{
           RowBox[{"sol1", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"20", ",", 
                RowBox[{"20", "+", "#"}]}], "}"}], ",", "10"}], "}"}], "]"}], 
           "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "[", "0.5", "]"}], "&"}], 
      ",", "40"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"pom", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", 
       RowBox[{"\"\<time= \>\"", "<>", 
        RowBox[{"ToString", "[", "%", "]"}], "<>", "\"\< s\>\""}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<t [s]\>\"", ",", 
         "\"\<\[Omega] [\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], 
        "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6783561149375*^9, 3.678356285765625*^9}, {
  3.678358226625*^9, 3.678358243515625*^9}, {3.678438867125*^9, 
  3.678438871109375*^9}, {3.67912040821875*^9, 
  3.67912041265625*^9}},ExpressionUUID->"53a5bdb6-b215-45df-b6e6-\
9fce14567afd"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "definition", " ", "of", " ", "desired", " ", "angular", " ", 
    "frequency"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"\[Omega]desired", ",", "step"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"steepness", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"-", "5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tsol", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"step", "=", 
     RowBox[{
      RowBox[{"0.5", "*", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Tanh", "[", 
          RowBox[{"steepness", "#"}], "]"}]}], ")"}]}], "&"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Omega]1", "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "0"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Omega]2", "-", "\[Omega]1"}], ")"}], "*", 
       RowBox[{"step", "[", 
        RowBox[{"t", "-", "tsol"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t_", "]"}], ":=", 
      RowBox[{"2.5", "*", 
       RowBox[{"(", 
        RowBox[{"t", "-", "tStart"}], ")"}]}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]desired", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "tStart", ",", 
        RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6783582938125*^9, 3.678358466171875*^9}, {
   3.678358496953125*^9, 3.678358539609375*^9}, {3.6783585745*^9, 
   3.678358655765625*^9}, {3.67835869565625*^9, 3.678358797984375*^9}, {
   3.67835933484375*^9, 3.678359336421875*^9}, {3.6783603835625*^9, 
   3.678360389765625*^9}, 3.678360573546875*^9, 3.67836075315625*^9, {
   3.678425156453125*^9, 3.678425197015625*^9}, 3.67843888196875*^9, 
   3.67843902784375*^9, 3.67843907378125*^9, 3.678439143609375*^9, {
   3.679120464015625*^9, 3.679120473765625*^9}, {3.679122753484375*^9, 
   3.679122776625*^9}, {3.679123062578125*^9, 3.679123076*^9}, {
   3.67912316378125*^9, 3.679123231328125*^9}, 
   3.679123425859375*^9},ExpressionUUID->"8fb4b217-876b-485c-87b9-\
00cbb5be3135"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"adding", " ", "P", " ", "controller"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      StyleBox["100",
       FontColor->RGBColor[1, 0, 0]], "*", "\[CapitalDelta]\[Omega]"}]}], 
    ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "proportional", " ", "controller", " ", "without", " ", "output", " ", 
     "limitations"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"initConds", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "[", "_", "]"}], "\[Equal]", "_"}], "\[RuleDelayed]", 
       "a"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "sol"}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\< \!\(\*StyleBox[\"\[Omega]Real\",FontColor->RGBColor[0, 0, 1]]\) \
 \!\(\*StyleBox[\"\[Omega]Desired\",FontColor->RGBColor[1, 0, 0]]\) \
[\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.67843896134375*^9, 3.678438969015625*^9}, {
  3.67912206271875*^9, 3.679122181375*^9}, {3.679122256875*^9, 
  3.6791222956875*^9}, {3.679122378984375*^9, 3.679122384015625*^9}, {
  3.6791224148125*^9, 3.679122769546875*^9}, {3.679122802828125*^9, 
  3.67912285340625*^9}, {3.679122918375*^9, 3.679123000765625*^9}, {
  3.67912303571875*^9, 3.67912305678125*^9}, {3.679123088625*^9, 
  3.67912309925*^9}, {3.679123166234375*^9, 
  3.679123173125*^9}},ExpressionUUID->"0fc83931-6f54-4ef6-a617-60b87f6d5495"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwc2Xc81d8fB/Br72tn75GGiiIpn/NWZiRZhQiV9S1llSQJaVBkF0lIKYkU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       "]]},
     Annotation[#, "Charting`Private`Tag$5784#1"]& ], 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwk2nc8V98fB/CPvX1kbx9bhcy+Wve8SVIkSbISkigJKWVEC0lSViJJaElK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       "]]},
     Annotation[#, "Charting`Private`Tag$5784#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\" \\!\\(\\*StyleBox[\\\"\[Omega]Real\\\",FontColor->RGBColor[0, 0, \
1]]\\)  \\!\\(\\*StyleBox[\\\"\[Omega]Desired\\\",FontColor->RGBColor[1, 0, \
0]]\\) [\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 20}, {0., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.847333562162564*^9},ExpressionUUID->"d7793828-b981-4bc7-a97d-\
422a7a05352f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"adding", " ", "P", " ", "controller"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      StyleBox["8",
       FontColor->RGBColor[1, 0, 0]], "*", 
      RowBox[{"Tanh", "[", 
       RowBox[{
        StyleBox["100",
         FontColor->RGBColor[1, 0, 0]], "\[CapitalDelta]\[Omega]"}], 
       "]"}]}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "proportional", " ", "controller", " ", "with", " ", "output", " ", 
      "limitations"}], ",", " ", 
     RowBox[{"try", " ", "to", " ", "change", " ", "red", " ", "numbers"}]}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"t", ",", "1"}], "}"}],
        FontColor->RGBColor[1, 0, 1]]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Try", " ", "eqnReg", " ", "without", " ", "time", " ", "derivative", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"simply", " ", "change", " ", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"t", ",", "1"}], "}"}],
         FontColor->RGBColor[1, 0, 1]], 
        StyleBox[
         RowBox[{
          StyleBox[" ",
           FontColor->RGBColor[1, 0, 1]], " "}]], "into", " ", 
        StyleBox[
         RowBox[{"{", 
          RowBox[{"t", ",", "0"}], "}"}],
         FontColor->RGBColor[1, 0, 1]]}], ":", " ", 
       RowBox[{"elapsed", " ", "time", " ", "will", " ", "increase", " ", 
        RowBox[{"strongly", "!"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{"a_Symbol", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"Timing", "[", 
      RowBox[{
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"Union", "[", 
          RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
         ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "tStart", ",", 
           RowBox[{"2", "tsol"}]}], "}"}], ",", 
         RowBox[{"MaxSteps", "\[Rule]", 
          SuperscriptBox["10", "6"]}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", 
        RowBox[{"sol", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\< \!\(\*StyleBox[\"\[Omega]Real\",FontColor->RGBColor[0, 0, 1]]\) \
 \!\(\*StyleBox[\"\[Omega]Desired\",FontColor->RGBColor[1, 0, 0]]\) \
[\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"\"\<elapsed time= \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{"sol", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< s\>\""}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.679123357359375*^9, 3.679123390453125*^9}, {
   3.679124408453125*^9, 3.679124466703125*^9}, {3.6791245063125*^9, 
   3.67912451915625*^9}, {3.679721954171875*^9, 3.679721961046875*^9}, {
   3.679722019921875*^9, 3.679722068640625*^9}, {3.6797221000625*^9, 
   3.679722141671875*^9}, {3.67972218490625*^9, 3.67972221271875*^9}, {
   3.679722255625*^9, 3.679722342546875*^9}, {3.679722398078125*^9, 
   3.679722450390625*^9}, {3.679722495609375*^9, 3.679722649828125*^9}, 
   3.679722724125*^9},ExpressionUUID->"7c35d40a-45af-4c99-8f53-a5f383a13b7c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwc13c8Vf8fB/Brc+2992qoNJSG83kXkUh2oiQkIoWMZJQQkWRWtCi+hVKi
Iu4hZK8kK1kR2Sv7/s75/cXzcc499/V+fz73fc6Rt79keo6RQqFEsFAo5N+P
ZWU/6XRBnPi3QLSY80CJxsdB5UVBXGktuMgwrFCr/L+cvwZTgviMqPglt6Ee
rRrJ9BmPP4J4yl37B+98Z7UaY+4vJfcK4tq4g0lsFQPWyhBDKWkXxM0X2oWj
BKhY55WbbINNgrjMvvvG6zZ8WO+wHw+1WhCnl8gFJJ8XwIas3YXVSwXxaSeX
PZ5xgthYvYOU5SdBXPmf3+WCeiFsBk4qBrwVxB1FIk29l0SwxTyjTWkvBXH3
rLFLBmcksHUVne1VzwRxcaP+StHrMhjzw72aEw8E8dzOx20/guQxKvc2JBQn
iOfvG89aS1XE+K4r6e67LYirnvpvTdRFGROeFT9mFyKIG3enKA/1qWASTrzm
4f6CeF56QWfq5g2YXAezTbanIB5ywB7bdmcjpmK4fLblgiAeGTnuH7RtM6ZG
m3RetBfE4/jRZnaBLdiOHb8vydgI4hMFGu5imtswzRedPjpmgjimpVVcOKCO
6URVhMZqC+IbeV+oiN/YiR1dL4wq2C+IG36wPHwwZxdm7JEb171TEF/62rZi
WqCBWQ6+eMCoJojb9p9mtc3ejdmcSHm6QUkQH7bowBLS92B2NbGZRlKCuOsJ
mdLcSk3MSSv89RUhQfxd3oCDncw+zC33Wv5DLkF887noXWUF+zFPRY/POLMg
LvRykH4rQAvzS3L6MrQqgJdq3GD5aYuwII5TNVzzAnj+0IFtkVcBCw0wad4x
LoA/ediq36J2EIuc1G23+i2AW3cs+qa1HsRi7A/8CvopgP+tU514E3oIS/i+
fej5dwFcZYhXzlBfG3t4RHW8pl4At7v86QfapIM9LZKam6oQwOPff2LOVz6M
ZWwVWBEpEcD9JvVKqzR0sexnbIxaBQJ4zHRlYtxRPezDrRneyAwBPHWA75HY
OX3s8/KwyJvHAnihaPp6xYWjWNnFn9LfkwRwml/79b4rBlhVb4vSSowAfjmT
e7PgJUOswaxqs/wtAXzKVORreNgxrLWyeIdesAAuQH21PaLMCOvcm7f3oq8A
HnHcW7qQaoz9ln2s9+m8AB4Xp69neNkEG42LN/p1RgB/37BVQU3OFJtiibRg
sRLAQ925ep7XmWKrf70cTI4I4NFyVytPbTXHGM+4XPAFAdz+5Xdf9b/mGHuL
rccjTQH8cYpnYMJbC0zoo37wyAYB/IOCRdKI3Qlsc6hsyg0OAdz7RMvLl/w2
GFfTy9h1igBeTv1knidzCpuQ3BV+bZEfrwqKsdDYcRp7l3fEw3uYH+dQN+Gk
XjuDJdBbnGZ6+HGW8DOUjBN2mLfB6VOX2vhxsWTBA28X7TDNAQ89lwp+nOrR
b2tnaI9JbFs9MPSZH18UGDFrXrfHVvzDdzi858dN6/6znSp0wEoEUqRPp/Pj
Zt56yMz2HKZzqHzW+AY//nDxcYzXqDOmEmM0Uu/Hj1+/xyqp+NMFY+ts7zl6
mR/X3eI+FPD9AlbjMV6tc4YfHy8XXLsiehHLLvallVry40abzW4Em7ljdzgY
8zEjfjyQ+V+00v1LmPEzkaeaWvz4azG7S368HtiO8aeJ+buIet/t/uX/ygMT
3Ls5aocaP+5gqt1lbOqJtTUhHzVJfryP1plxqtkLO0VxMZRb4sMrnDLQILcv
hhnOHnw0xYdzsewXc273xWTvB+6R+MOHK8hN+0wU+mGUQbYtyb/4cNVFY9W4
d1ex/m1xCkI/+PDsMR6/6U/+mPOZokW2fD683bJWSZ4jGDuadXgiNJsPl7OZ
3GjKfh3b/K9xgOE5H157M0pvW/J1bCJmsGEljg//56bEltBxA7tSwv1i8jIf
7hI4oqQUFIpZUu8/dHPmwx/q39M30wjD9lgqxI6cIY7vPrLVdikMWx7ffW3A
iA/36wpTrLhzC+veW3rZTpcPVzd6ebfDJAIrDjNw+qnFh5c3rr9OE4vErkvb
mfxQI+qZW9yjRbuN2buM6por8eERgn9Vtj+OwrTzrxxoluTDi74M53+8FY2x
HotUraXy4Uxu/4oSL8Zg4kuOK4HNvDj7lZHOTZb3MJHOhbz7pby4vO9Xzs39
9zChogi3vLe8uNnx7ZX2V+MwnsDsn3/u8eI929iOGOXFY5y2WBJTCC+O+5df
334sAWNHTUYynrx4/E9NAbfZBIyRYY5mZsqLm5YKie63ScLofWF+7od48QlZ
FwkqXzK2Wia6PXIHLz4kJLimVp6MLYTuTysR4MWNntgmZVg9wEbZb4Zu/MaD
Fz44vH/6Yyo2PCKkpfOFB9+v8/T2w6xH2GBNxrxtHg9uEzkypff0MdYTXeOU
EM+D55aeVK87/BT7xiegTzfjwVvTGrwf2KdhTdPpDBI6PLjcvjwVu+k0rKFF
o3DXLh78+K2f79pC07GqhJObLwjx4BlXr5gt5j3HPos94/7eyo1n8pekHTuW
iX1a2lE5Wc6NX5Ys026i/IcVdJYHUfO5cYeU8lGTwv+w3NQ/kyiRG38clxaa
j73CcgL9/7MO48adB2sFHahZ2CtbrrPe3tx4wv1Ya/nuLOyFnHrLKwtuvCHu
aPPRhBwsjaHsdsVhblytlud1l/9r7Gm/mXavBje+OB5yV+jCG+zhc9/3wiLc
ePyGrIdRublYzAZa0vU2Ltwn5UakRts7LIrD5HhKJRduNya0lOGah0WM9rMV
FHDh2Tdiz82zvMdCslmv/k3iwh/VfeZu1cvHgu/c3856iwtves9VLjOZjwW4
bxqV8+XCe3Qr79WnFmA+6kY2lie48Aa3mtVJ6kfMi79X0EOPC5dYvsweVvMR
uzzjURe1hwsf2nhxbMfdT9iF94lapaJceHps8fuWjUXYGc2fsmrtnLjrbEkQ
14cSDO9Uzkqq4sSdlD8G7nxBw+QC3XczfOLEr+YL0MqP4Vh/Kd2w7QEnfsIp
S+WlSSmm7XikHW5z4jYxpV4VHaXYc9Z7Dln+nPjb1evCiefKMCcDBf/rNpw4
/uJJ4e6IL9jX8Qssfw048TQmEUVx+XJsQ2xerMUBTvzf8h0dNlo5Ntqqk7lJ
mhPv3OPmac5eibnbnm9t7aHixotb+S06q7BGSu4Z1EjFy69VqDxOqcbU0xdH
X9KoeN6NTy099jXYzHAkQ/BTKq4sMemqxlyHmd1uiR6JpeJ8hzsV6nvqsPdq
kmLmN6j4iAPvkVFaPebjkb11oz0VHwupaK9IbsR+CM5/ijel4pUqgWq6ek2Y
ZoHW4fVDVHz8q0jpo8ombHm5weabIhUXfjYjCc3NWGDodETgbw58W+PAg0iJ
VqxHZZ/Qn+8ceHDU+Er2x1YMqw55YlrJgT86fPepnc13jMIjVKCayYFfrdny
+/ubNuxs7qmDcckc+FoW37Cf/Q+szPRF3eotDvzujPtxdYl2LDR590CzMwf+
SeJOzfeHHdjvvcHuB05y4LpIOy3ZsRPT7f66lKHPgR+dL+5m3NWFscuf5AvY
xIEnbxy9kDTUjUW/uqalMsaO7/jWfKLueC82blheFdvNjrcYS23yaurFjCa5
zFfq2PGhLr/TT8z7ML5djy805bDj5mbCfyed+zGPtqH5fY/Z8emwgoO3l/qx
Fr9tN17EsOMT+MO0oJgBLKEYT/a/xI6XugxaqFcOYvNnOBR/n2HHRzqZR4xc
fmOWjKavjxuz43bXG1U4BIYwMb2BcqXt7DhvHT61y2cYS2limWmYYcO38/9l
OBM0ir1X8rMe7mPDj5/TNjtv9xer8xstozex4TTNLEm+o2PYqlxjvPobNpzv
QHOHl8YEJuR9cPXIYzY8zjCDGds3iW2pznM8e4cNzygPpqQrTmG2Hvc14lzZ
8Pzx3mNwYBrzqaA+fmXNhhfzlA25Nk5jd8UDWb/os+Hq3IPCt8/PYHjp2R+z
qmz4iSNapeczZzF5gc1XLQZZcaY/AyKqFxawfU6P+i5+Y8XTy1VUqzb+w0wL
eY+Gl7HisV/YrIKm/mEh9nMSH56y4uxh8QJy95awhwVONxvvsuLPZT5UUdyW
sTxqx9/hIFbcgKVRZ5vRCjb4rviz2GlWvHvPLXnHjWvYKqu68nZDVryjtyl8
XWEdE7ZJu6O/nxX/0mNgyqZMx3SZbtn6i7PiW+v+49VOo6BMM2NK93cW/PKg
nJnyCiPCM8uc58pZcGHdT2zZj5hQ+8quZq73LHiQ35Lk28PMiP25eJpWHAtO
CT1dSc9gQXKLUVTLGyx4pP8z/VQ7VrTXcN3T/TIL/tql4bSjHBu6MNev/cSI
Bc9p3bTdMI8dhRyxyP6gxYLHR2+6ORfOgVJSvwo1qRHmvcZRe5aK6nSyf1M4
WfAG6xKOqS1caEui9y37r8z4bO3jq4yCfEh3ZHjSv4AZvzC9ndqZyodstayt
4l8w4wFFjSxnNvOjmN/YxvKbzPjtRDvpNUsBlLH37b1uT2YcQ6LHLOYEEO2O
4vLcWWac42Ph0lCSIJrSYK9VBma85nTGvztjQoj9tv9ObBsznh01QBd7Kozk
e8ZSLGWY8cNfpjcUnhRBpuHNbrdWmfA6Xbf7fb9EUV7bQ56Rj0z4pd4IcTct
ScR65baOwksm3CjG1N5dVApZ8fv72zxgwjdm1/EaLkqhVYOTQ/VXmfDV3Yd0
DjfKIKORI1JsF5hwC5YNU5UVsuhZuKYpWDPhX1nvFqyclUO6paIl7/Yx4Vv3
fknUdZNH923Z5v5uYsJFlDusaf/k0d+VhY3Kkkz45Xm/pPu3FFDs7rbE5BVG
PDPzfkHfe0XUmZVwMeAzI+5e3MI1r6+C1PRD0/OzGfHWwvfPnVdVUPCQV8dE
KiO+cvtar9d7VaQkb3b4bCAjXvZx5Mu4xkbkU3Lo2sOLjPimRp/6AvpGVGWz
4+2304y4aZpNVEPjJnQxiV9aF2PET/m/iaq/qYbwnQxmwVsZ8c9eimflnLcg
geapiI8yjLjcsUWD+2ZbUQFn09wmOgP+yjsXc5RTR5QbMXW8OAPuKfo+I1pr
BzKVCWLUz2XAMyoUe1Ibd6AXRRc1Q54y4E+MXmzHnHaiowuGz+euM+Bq1zew
ljzbhVLjD3Ru8WDAu0/x243qaqBJdTW+82cZcHBzzDo0rYESXDkDOg4y4Bcj
BA+pWO5BQ+wrbwV2MOC7D5cHsPJror0Zo8MGCgx4h5PX3eJmTdTTW21WwsiA
60W/jT53bh9StYzYnP6Fglt7Ro0Zdmkh/1nfs915FDwslofXoQZDdbHnk4Wf
U/ARoUMbp3GELtfqMkWEUvB3QUa1uf2Aypx37y29QsHdWk/Z9rscRMKsKpeW
HSm4w+pa6/H5g6gQWLrcDlPwkoS5AmdxbcTVM8eXoUHB57+aLlm900Znrg3q
/lKm4BlcQUp8xjqIueDLOxNWCl761FfG7eFhlGrJLHwxhk77KJP42vvSEZQ7
t3v/fjc6Df9eGVWhrY/K41zOchyl06Yix4L1ZI+ivw0NOS9Y6LTnTqYyPWMG
aN2NodVrYJ124uelJ1d/GSIBzl3LB0vXad6ZB9NNO4+hfXoPdHsC1mmZs6m3
O0eOI6PftW7Z1uu0rpNbZu8EGyP7m+tx/prrtOq70Yf6eExQJM3hl8jcGi1C
LqlZ94Apat+z1e+46xotur3n0GibORr7bvdYWn+NJptx+cZklAWiXIkv/6uy
RmvpVD8vqmeJVHMX+SL6V2n3bsRHvmw6gfYZbd5jia/SIjSufgl9YoWMxk6f
Vnq8SktX9J538D6JfDZ8eYmfXKX1uPbmy+6xQbcr5xtj9qzSpCS+hVxTPIUe
OW5YOCW8Sht846PbKXoalT+9c2ipaYUWnb40XCR+BgmKW3VtP7JCG2kUd5So
OItUPtxmoKis0HZFdKU6nrFH+yyKVRuYVmji5WrWI+v2yP6ewpULtGVaxaxp
4EkjR+SzzeKh5qNlWsGZNav0dUcUWX8LZ722TLveXrn99/tzKJdjnCt99zJN
edRkg/yu86g8U3anh9AyjXn4zJ2ItfOo/bDpSTSzRPOV1Octq3dG9BsfXnTl
LNFqXd953b95ARkt38CElJdoqiqabsUG7sj+/nvHfsYlmthh5X9JppeQz+7h
27m9i7QO3mc3Nm2/jB55Gv4wTF2k2Xn57O0w8kC5fMFrEv6LtHDRim1Lgx6o
/PVbxZETi7QPtj6aatc90dioyOUwwUWagmBiWEClF6JE6ieZTf+jvd6h2jrv
cQUJqQZ8lm/8R3PwntTap+iN9jv0sZfc/kdjt9hWOJbsg253ZT1bYPhHs9sj
atDeeBU5rRpcdOxdoE18evHQKssfHZQe02wpWaDhJm+UpWOuoUVbtaacaws0
hbMbTFwuBKJvwXUpktYLtA+SKg4ejkHo9VO385GaC7R9ZZeelDgFo3P92euO
8/M0tcNXnJ6WXUfAdKym5ds8LT9P9QWTyQ0kpTSeCO/maWmQuVFy8AZqObdl
i9Sledqn9/ncrOI3EYzk2Hz7M0erVw5Udy8LQ1JUI9WDX+doj3/u/M59LRz9
2zQx8/rFHM3eT22ibO8t9Npt6+3b9nO0b7xp4vtqItDtOw0WizBH06y3iXNK
jUTnXrvLO8nO0XiOP7MM9L6NpKZefzzYPUtrvzGjbaIVjRb5joe+KZylBWRa
V4Wr3UHftk8el34wS8u78tU7WTEG3fbaNrxoMUvL4b5rskE4Fv1beCOc2zhD
05uT8e0zjkMtosZ90q9naAMqvU/f/Y1DrzWnsqOiZ2hb2ydp8VHxyNFfXee8
/gytZ9rcaWtXAoKUJt7vqjO0l5KDFVpRiUjy8+WuQ6wztC5XCxbOg0moZS3X
U+bLNO0RraoypSQZvZYxwaKfTdOG34odLw2/jyLRNMdy8DTtieiNJmeLBwhu
bH/2/cA0LeqN+m4BthSUw/yuMbpgiobbdcUvlj5GEcqmKcsJUzQhRdGHx8qf
IEfdGSdnrylaWNGekIDzT5FExI51bfUpmurG+37bgp+hhf9aqt/yTNGqajtk
W/jTUFr8702oc5J2dbO08uaXaYhP1OnkgtkkTR2eFSQMpaOvVhlTzXyTtCSU
c3A2+jkKejh0K6d+gnYqRls5XfMFGpM+X+CoN0HzE3pp8fhpBvqq5Cz4bd84
Le+LjvSPDy+RU9Sj3u2rY7SLygz9y0GvEPNMS05s8RhNTrnMcNkgCx2iaR0x
gjFaQ4+F9M7FbFRyUjCw+vBfms9GXrXNx3PRafzI0Q1sf2l32ctF79TlolWV
INFbVaM0x4vOSveOvUX75v681TEYpXHM+tEGrN+hgpiSIZrxCI3eQguNefEe
WczP5skIjNAkPjvv6TiUj+ZsNt4I/PaHJs3RmZg6mI92bEyQ3G/5h6afck+G
afcH9PqLi3GBzTAtuXZ6X6ZgITq26Ym0sPQwreLvRXHO9kI0Fts66tUzRJOv
tQvve1aENtmisO1nh2hqglbNF3WLUcaiUGG202/anohbdeddcXT4zNFbnBt+
0zp9Z07r/8bRYEWw+YWRQVp1fc5HD/tSpBA/OqHqNkiDi0b5fU5l6PEWXDHd
Y4BWnl8VY/GwHGklzE8x7BygMWZLBYaoV6Du5U0ldnP9tFePZPVjayqQRFWi
lYxvPy23ov/TI+pXlGTveudBQB/Nt3l1MvtzNdKofmq9qNVHm9JwG+W6UoNa
t7WpnqD30u6auFwb21aLBNagTCikl8b+JeqmX34dktq2ZUKW9xdt8dOeu91L
jch6NTni570e2j7mSOGXrk3ofjWjYopQDy26dbB2orsJCTm2nxCR+Emz7E4w
1PrajLge3CzlUu6iFfkas1YXfUOsc/sP733USTu1+cI/ikErohvNVZ0T7qSt
2lznD/7ZimaYzzWVsHTQprVPy7pxtaH2y7q/Lg+10RIr6v4rjGtHLbXr9o9s
22j0qlL/9gMdqFblw1B123eapP4/j/OjHaikW3VC4WsrbV6uTP/X8S70/AjH
WmtmCy391MyjrTo96HF66XUGuRba8TRNv28cv1Dy+lXmrfebaSzu12K6W36h
2+9HOW9FNNFe9L7Ycv1DL/oF9zU8W+poskHLX3XP9yOfKWmPfRbltHbdxSED
3iHkkhHjF3/4C81X6BPt7O0hdOoUPXhMo4zW9+jh5izWYXSoqjfmsQhOW0y0
sUln/IMkQO8kS+4H2vG/iQEJrKNIKfDowRNtD2kfxHo49dUnkHVa0kF9VIQu
ll083HR4Fu3g5boZuK8Y2QjbyLOHzCLOgBvlbzVo6Jr+xT/fi2dRz6YCRe6k
UlTiPtkgsWsOxTI/y/COrkBVXW03XknMo5kPPtm6V+vRfbkPJ5/VLiBb9+31
vT4NKITPcbxhfQHVKo2N+19pROqDd3KPbv+HWqpyk398aEJbqhY2Kyb8Q680
VDo481rQge/eA/Imi8iGl//UlZdt6GfWs/wzmUso7oK728ENP9CFip9rlQ1L
qKqiNoAn8wdqHxbYf2l+Ce0KCH/03/N2ZHGgujkMlhHXyEpP95NO5ACF4qP1
y+iQzsnJlzJd6JdQf6TP5DLye1JA93nUhXq4FgeO8a2g3xYecvwp3UigRzJk
8PgKKikbOns4qQe1hBS4/qlcQXPSOp4Cwr/QkzkGX8aBFbT56rOQX/G/0N/v
RS2+6yuoTvR18+cjvehAj2tf4M5VpNngPGOp24dmYwTO709aRd+uJfsXh/Wh
wgzmR145q8h9YyWjUkUfOoh5tEqUr6LnoYqC09r9CL89chufXEV8+3t2Rh0c
QL9uZe57C2tIamC7x7vgASTq2rTNwGwNbYgKe91RPIAKnP8LuXhuDaEutY0b
9g0ilamoZvOINeR+7ZpMxY7fiAqn5aeq1pC/YqPN2OXf6MjrYQXe9jUUVqvw
QPDNb8TV/WFj9dAaSpWsEbTfPIQkXreqiTKto9oiMQ664jDKiFeoPLFnHbU5
uOmq2A+jD0vsXVHa66ifE7957OkwknOSZHQ7vo6Wbc6vp0j9QX/Nqn00ndbR
htX8WU3hEXRflFKwJ3Yd7XrOsd3ObASNhRUbMz5cR2B42v3WvRE0vCrNGJG+
jk6kMo985x5FlmypEbX56yj8gFmPJ+tfNDuwx+bsj3UUN5gh+VDnL1KxqpHb
+WsdPY5etioN+YsYwhh+1g2to/zuZ9946X/R2rgX1XZ+HQ0GTFVl/xtDkt9/
q8rw0dGUkg5rq8Y4gicKdZYidLRSl6y94jWOatiVNe2l6EhAGpXoT42jaJUH
WguqdHSw+E7e0J8J5OVkpbNTi44Mz/VNcatOov8qhZ8pHKIjK26NrRrnJtHe
5bCP47p0dPl09383+ybRc6EHvJLGdNQYJHyc7+IUcqScqB6zo6NWU9q4YvQU
Uq+rTGh1pKNOFZfoPVlTaEZm3fWJMx0NNXyuth2ZQg4i2r59l+hoXcZRJ+fc
NPoeouOqFkhHiXcLN5y7NY0ez+TsDr1OR2oUfm7pl9PotqPJP/wmHVn3FX+P
HptG/b3mmWORdDRtIlSowzOD9P8mb/0ZTUcRZRcer26bQcetjnTl36WjgnTR
825eM6gvej5BIZGOjgm5GyglziDpTa5cH5PpaDC0fFt3wQxqD7cL0nxI9MfJ
Y9FgeQahLwMjq4/pyH1DbeTmG7PIj3aI40UmHbE8kHcfSJtFrf8gNf0lHaVy
+JmmlM+iA2V9/fey6KhmVEmSk30O6Z7KjEdv6OiszTV62cY5FJbtuETPpaPF
2uYBf4M51Dl8mP3dOzpSyQnKHo2ZQ1bLz8fG8umoWPp7bFruHPphduiJzwc6
Mo/Z7G3dMofS8m7kz36ko5BL7Vo1wvMI23ssvbqIjn5u39H4MnUebdS0mJ7A
6ehKWkTe2ZJ55K+9pitTRkdUwV/J4r3z6OGJuB7tL3SkORdlF6m4gMRGJHi9
Koj1c+zXOXh4AXn7CkNgJR05fdfcuOREHA9K7w/6SkcJBb+nnV8toN2r9fdc
qulos+qBNrm6BXSwylnRrIaOypLjCtvHF9DZzI/qGrXE/vNDN48Qc49dx+bd
QB2xn/Y/ENrw8R/6OVV4f6qRjgayJhd/dfxDJfWPbZ430ZG/lO7P5JV/yCmi
wMy0mY7+W5t5wYYWUeHXLU8etdARcte/TbNbRA94Wg33f6Ojtp4n7r4hiyhW
PXjwG2Fm3HDPcMUiShoN91topaMU9XTJJ8OLaMKnu/z6dzra8WyJbsmxhHJq
NVJY2+jILiSjqtJwCUlihr4sP+josw7FOuPbElpNWkj/1k5HvxROpUvNLqGD
DpyUPR10xMjwcSxOYBkl76KeTiZ8pPhScLDJMmI3cfQ+3klHrim1VfOXl5GH
UvOpTMIxV1UF3GKXUTmz9KNVwt80fj23alxGOTxNfk+66GhBcP9Ew8QyktHR
3z9OWGwmac9hnhX0aPLLc81uOrJ9bVSz/dgK4n5+IL+K8KhKySS1dgWpp7hk
NP6kI24Wib03RlfQvj8Pgrl66Eh9wDvkH8cqMgriCNEj7PNki/DgkVWU4nl4
/0fCDwIjba2dV5F/uz/3BOHPNr8zm26tovG1DKTwi44YxB7tK65cRdxMLfNh
hJUWFm/uHFpFmxc+38snrNtqXv+SZQ1V6doXDxCOjuWyS9JZQ/OL1pP7e4n8
HAFhl8rWkLLKel834f3DPxp+962hUPNiOcY+op6KnWKnGNaRmo8ZUiH8/Mbf
V0dgHd0QFgdXwl/P6M2VnFlH34vPbY8mPKqVrqURvI42qQYqZhPetmzdJF+y
joYCpTeOEDZtLxC//5OYw3vjDVj7if1eIODAs7aOZrQbohUIF3rWzC/vpyPW
uOfhVoR1/+6VbP1ER9jNStYiws7ViY5HiXXksuxuaiYclTmdgy8ScyoycHSY
8J+35k/bJCkwpSKnIDBAR8tPGSvubaZAc2bsURXCnLG5I4b7KVD5W/3HXsJb
3bl2frGmQFEj47YzhOF04YmgCxRg8u5j9CBsYugcsNefAopZVwxDCF/ZVF7x
5gEFBC9km6QTLhy6ZpXaTgG9H6yJvwgLKVGevhyhAGfaYs4EYfezocMFyxTw
Djp4ZI2wQne0T7MUA1RuK+MTH6SjAHH+kp4tDPC7eEpXhXCbZSLLGMYADuw2
PDsJ325+lMB6lgH2/mW0MyA8yKPQLejJAF+3oGlLwphhhqL8TQZAQlny9oRn
Kl+/2/+CASgjza6+hK0/05oujzAAo8HQwiPC75e0xYKWGWDI+NS3DMI8e6rO
RHEywtJK97k3hMveNk282MII982FC2iEpSbNd+dhjCDydcX3K2EftY5A/Dgj
/F4PW2wgvCmzj6vLgxEexhpjPwmHDp4z/xPCCPJfWdgHCffIj6bMxzPCRTmW
B6OE41JnNvEVMILXs2ti/wgv32PSP7zMCALfbn3i/k3My8ZbsaacTHBW8eWY
AOHXXFztZ6SYYNdRkzlRwva3hM77Y0zQOGx9S57w5/L7r28dZwKr5OPCKoRF
GKUXEuyYQC+KEriJcE2ActibECaI+b30cwdhpcKXdZ/jmWBoR03HbsJB/7YI
1Txngh9zOu/3Ed7huTt9sJIJePbQOQ4Rfnher1SckxluLGSbHic897yWXVWK
GSxtGe1MCRv1HzfetYUZHle9MbMgzHja6pfRcWZYLu6btiZ86mG3yik7ZsC2
Kzw+Tbjgh527iwczsH+U2WVH+IKpy9rNeGa4qP1R9hzh8rvjOveeM0P1cpDP
ecIy9R7Rj/OZofiX5ycXwi16/pKffjDDPmhkdSe8Tytq74QkCxi9GW/1Jqz+
yep1lhoL/M57ec+XsIqGiqKLFgvYr62hq4QFtpRyDdqygPncpysBhNlfxtx4
domwVsZyIOF1pVMLttdZoD81zy+Y8F+pf786nrHAx7lB4xDC/ffLzZPfsYD/
0eism4TbheKqzb+wQP30npVQMj/XlrzGQRYIZ5nzv0U4ddU+vEKVFULjvzFG
E47zU18J0WSFVloI9x3CEXNrl0CfFUqE0nhjCHuP3T9ZdIEVWKzfr9wl7Obs
1OB3jRXiFXcMxZLrP7hTe3c0K6SZH6i+R/a/u0HtbQ4rlF6+dDWesI5V6jP3
ElbwshjUTSD70+oiotbICkNb47kTyX7UMVMyp1hhwaH1VhJhetG+b6k72eDz
qc97HhBe2MN+xFqHDf7o6baRHsv7/lnUgg14d0ZeekjWm3U5I86HDcKbP8al
EG5QxSSNb7HBdI+8dCpZfzpnLPd9Njj0b2c66dyUjKsRn4jjCwHpjwhniF6Z
OFzDBg/Gy6Qfk/2JP+jA1MUGHs4MCaQjo7oNg1bZQN809MoTst5rAnJXEDvc
jPOmPiNs9e9XwnZjduDrc3EmbeSVwzFpxw6qFNcvpPe5Hpl1CWEHwY1Zl9PI
/TAs7Kwazw4hnQxfSKs4DHQPprPDuaFHAumEBW2CKs9UENcf2/SKNPWHwX7p
NnbYyHRshjTFTDy3c4gdNCw3aT4n+3H0/QMLdg44LeJRTLp836ibgQEHvGO2
evOC8PWL+4T+WHNA/cEDA6QPPL1dFHqBA35OhAtnEH7PsplaEskB0ZJ3vElf
1rz21voBB5SMX0gnreZaa/XvPw44MzjVSPpFk2umehUH5F6VUc4k+8H02aj+
Bwe43f5xjLTMbq4Fl2EOYG096U06KSVbJ52VCjEv6nDS4U7jfcKHqVCov/vo
f4QPPdCKfGdOhb9a311Ir9feUT/uSAUDfusI0j7btwZH3KQC8/rhL6R3OAap
KMdTYVI28hfpiaSG+tI0KowxTC2TPr/qLrVSSoUwrwPbXpLzZRvtS3IzFeQS
th4h3XuW13VXHxXYtW3sSFt9ffPpIoUT5n5ExZA+Ejdl2YtxQtEVrgHSzBWw
HmDECTs2pS+Qxv/FvhC35YQf755xvCKseXr7nGkgJ7xWGN1Ceu7ujZTJaE5o
tdZApHPLmg9Fp3LCwIHF46Q3bvC8V1HECc2lTJdJD1mXadrXcsLeYybBpNPu
CPSud3KCV+3mGNISs++2ai5zwl2vxFekqSWzta80uSAsNqCHdOWUtpfeES7Q
ehA8SjpEMUFi8AQXnH6mskB6OWKXi7QvF0ixn+PKIjxq5s0am88F6a+XdpHO
CK/IUavgAvE79hhp+0/CFtWtXOAkfVuPdKdMQTrjHBdMfeA6Sbp2ZAG8d3DD
HSPBq6SbLkhzOmpzwxZ28RukW/9qfzc154bt/zojSPeMx7qo+3BDgdTbZNL9
7h92yt7iBte7nx6THp78ucZ9nxsiB4JekJ6a3hT39xM3bCt3eEd63tPkVGcN
N/w4EP6R9PKsr0p1FzdUSXmXkGZaKC/MWOMGr5HP1aRFlm0Hzh7kAb9o/h7S
EtfCcoxNeWDNjdZPWnY1yxc58ACr6tFh0hvWFzmlw3iATf/vJOktwbJtnEk8
UHeVcY70Doru0+UMHhDc8u8f6f2M8bvaq3hA3SGUThpuflqv7OCBxNNyTNnk
vGPurcof5QHe6hRW0kasW07Hc/HC7eI93KTtqF/DjIx5ISAPEyd9Lmr8uNZZ
Xug/xiVF+gKXkISaJy/ItVXIkPbiOfuaI4EXSnhWFEn73b3lt/icF5wnvFVI
B/C9PjSczws3JLo2kA4XWGkr/8ELCQX2W0jfjpd/lveHF55Vhm4jfVfoiGva
Ei/MVD7YTtowqoZO4+YDbYnnGqQt74gmPNrGB+L5Qlqk2+s3LQlp8oH5cCVG
2poHs40GPniccQ5In7nruOGaCR/Efr+kTbq/0ffOzEk+UO4e0SHtyBc142LP
B0rvT+mSdr739rOVFx+cylTVJ31RoD1cL5QPNI5VGpD2jF833p3IBy+1txqR
vpZo8FvwAx8Uf4owJa1bP9fXV8kHy9xh5qT5WB73vGnjg92nfCxJdx3Q6woc
4gO9PCsr0hlXpn4YLPABRWGDNenL2Q9axVn5QeNDrw3p/YOHmoeF+eHzjaDT
pFmlxurzlfnhfOyaLekms8Samxr8wDVz0o6005fhL7IW/ECvTbUnvbJjX3HR
FX5IPpbtSDo2LbrgRAI/ZN0odiKtIvDrzWwePxQ75juTNp6+mbZ5lh/6N467
/r++pg2JDjsE4COjmPv/876pv5XiIQDz/RqX///9MZ7+33IFAKe0efx/f9Dc
fVr3CsLpexe9SDNPXfD8XiYIBr5mV0g/ljvv3mYgBKbHmr1J7zFxuPCjVQhS
bcp9Sc85hD8SExMGmbUKP9LvfF42nbQRBnHTJP//9yeyjinlsTCUhI8HkN6S
Orm7u08YrrzXCSYdrXyjKYBJBCbXLlwnPfpa4IK0sghotomHkNbXfM5UoisC
b1i3hZL+r1Tjka2zCKzNeYaTZjP4upseKQLVrK8j/t/PVqumJ1kikNP17TZp
4Qfy0pc/i8Cv8N3RpMtPj7pAvQi0rjTcIX1FIa+Ar0cEjrdF3yWtOHyNqW9C
BETenblH+r7915DYdRHQ+SgaT5qnR4AReETBxqsygfTNk7Y3JqVFwS7BNon0
YutLypMtokCZE75P2t14PthISxRchnc9JD1QC/Q1Q1HYH/oilbSVXnRQzilR
kDpp8oR0Q9mPtVNuovB2Tj6NdMT1wOJdV0QhnuNeOmltTDGQK0AUnvymvCD9
8ZP7alGUKEQX/sgkvVWj8JpriihIM8a+Ip2ey7IikSUKprRNOaRt3bMKZ96J
QnZ19GvSYmom/jWFoqCTSX9DOiYzdelqjSiIeQjn/X8+PN652D4iCnkmU59I
7zjV8SF3WhTOslcVkR4XD/aNWBIF2c9ZxaTtE2sW9nCIwac3CaWkpc0uF/Dy
iwFH4f0v///984n4DIuJgZllRgXpY9Fn55M2iIH/cFc1afajbPnu6mKAZfDV
kS5jy7miqykGmyYcG0hr3lycndcTAzeO899IK/jfnTE/Lwaaazk9pH/u0Xin
dkkMuhKK+v6/fvOdHsy+YhCZ2DNImttDZTovXAxWS8/8JV21tS43KobIe65o
gnTImMdlhyQxuGKvOvP/9TxfPCmQIQZtlpuX/r+/lR3ejOaIgXclvvr/eTPA
fqksXwx8Q7woOeS8sjWf8KgQA5fn59hJ11v8HWsaFIO9O3dJkM7et1psMi4G
nDHnZUnfluW+2zJPOKBYifSRka3bW1nFwbH7yzbS5QGe3j82iEOg2skjpNPP
3tS12i4OVXZtRqRDdBNEO/aKA+tolAVp4Cv41HlUHPgoDx1If05fWvvpJg4p
xS9DSKdEUBttvcXBo0cwirT/RcmnvwLFofZuSTxpzT1ah/pixIEpiT2DtKiU
kaB9sjh8Mkt9Q3qBcmaw/4k49DHFfCL9vuZ6+GCuOLyS+9RAOv7NvRPnPonD
sQ/DHaQ9E9I2DJWKg4SE92/S6rblNcMt4rD/ftIa6axpNt6/c+Jw/WX9jtdk
P9rEel3XxEGG9cpB0s5FG9+OsUiALEOyMWmVMAOzCREJ0Fzaepk0y4VTSpdk
JaCGI+466UGji/OTqhIQcjHgHuk0sbvJ05oSwMv1JJ/0jbUnzp4HJeD5PVoV
abv+3L2z+hLw5HRoN2mZ7JauOWsJcNhWzfKG8EMkIrcYIAEVZnJ2pK8qqU77
hRHXu9jrR9qKQ7Ns6Y4EZLs6xpEW+XbSceWxBIg2e38lPf/hgkZApgSY3XIa
IN2aeo117Y0ErK0GUXIJxzk9+m8dl4CPBs1apD0MXl8NrpYA0z29p0kbq9OO
UlokwJOtNIg0z3LvGMOABKwvipWTjryjtJ2FRRKiw11s3xKuqfdJmeeSBE++
kTDSXDzVLENCkqDozvqOdGzMxc5KJUlIS59heUe4pYGm80FNEmaO620nLcQr
8CZzlyTImo6cJn3/bsHNCB1JCGL5XES6s5F9ws9QEjbXMo6TluKzsXIxl4TO
O4xyeYSfxtLVjjpKgo50123S/9070sYZKgmF52lX3pPzvfkhrEZJgobc2zzS
agLjr8biJeEz9cUc6dy4e8H16ZLw/AxfYD7hmZaBkeIs4vrzBeWkdwnuNn+d
JwkiN9/yFBD+EN+54e4XSbDacPsl6cVvavHBtZKQLWC/THqfUPDapW+SQN+a
eOwD4ZIExRbjAUmQ8GxdIV2Z6HZNgEkKOIxaAz6R86et5DcjpxRcmqwaJH1U
hN94VkAK+l4VHy8k53NSvlKrghScw7ZvKyLM94PtbvkmKeg/uuU5aVNR66X3
O6Sg0Yhd+jPhtuT1+sRDUqCbLyNZTM7bdmPN8KNS4Ox79Slpa7H0NB9TKaja
urSxhHDPfT3fE/ZSkCXqqE8j/PtBrJx4iBRYxq2VlJL7v7P/NsdtKZitsXQp
I38fEhrzS/ek4IWPtvgXwmMPO6o7n0nBD/8Nt8vJ+0HX5l21L6WAmXmfQQV5
P5YMelz0VgrKm1UFKsn7d4qCV2qpFHBrmrz7Snh395Wf0dVSMKe5IbqKnP9S
X/UCm6Xg5dN/btWEV1NdpWz7pEC8c1mnljDz4/cVsgzSEHzmmGkj4YTALN0/
7NLAErXLsYmw0um0r7l80rDsdymombCOVGz1QTlpsOUOrf9G/h5Wwo9SN0hD
+IAc03fCjl2BtS3bpMH+3a1DbYRDH7rWOyBpGMHifrWT+9Pf3khNTxokdGK0
Ogk/P3mycc5IGhzuS2Z0kfNSTK85zFYa/us0vN9D5ktW+J4ZKA095q3cv8l8
PuKWl8Ok4WIye90Qmc+S74fmHWl4cF3o/h8yn/B6e3WqNGQ09VmPkfnm5k7G
PZcG+tNTphNkvta/ndbZxPUatpycIvPFd3T/LSLqabBIniPzeTWdfv9FGpid
BJsXyHymX3sCaqWhquyN9BKZjz+/l7tLGvZPG46skfliYwe3LUuDD2ORK/sQ
ke/SrXOLDDIQubEAOAkrHQ8awjlkoPm+hhoPYR0etz8m4jLwXKtcX4hw67i9
i4S8DOy20AgUJexYf3K0f4MM3No+XC1BODRab8xLUwZeLuW+lScs5IZdPAAy
oHXU1kiZ8HMDjQnmIzJwBb/OtpFwOVVxKvGEDLC5nfumTpg5cn32g48MxHz2
GztI5nOev3I9SAZuW4tH6JL5jozNHwmXAQ33bj0DMh9b57+ORBlwdx3UtCDz
DTX5pT2SAZemPjdrMl/l16ULL2SgLtSg5gyZLyx/ZeW9DPR1bWR1JfOdyw4o
/ywDFTGzQ5fJfDrpa9HlMtDgvzDvQ+ZjukeXbpWBjEzz5zfJfCFuTDArA1uu
6l9+QvhjREPi2xUZcFZpS8gk7HZXfYMisyyI7DaivyH8PXXOkFVYFio7Ul+X
Er6dbvnLV1oWPG8YLdYQxl599BhRloWIpIV7rYQzPgQk1e2Whc/OPPgfwtYl
PRswJAuc6lzWs4R5KqDojZ4sOIxpHF8n7NvC3BtnJQsD3xlOCA8T9/Px6I0n
/WUhKvTXziOEV2cnimpCZEHuoifdgnDusrHRgShZMN/z7KAjYXF2YS/ZVFmw
yx3fG0K4gceX5d5z4vs3H1i8RzhEuCOZMUcWGveEaqURHlV49Pl3sSyUPJS7
VE748Ua60YlKWRhPW3NsI2yqfravqkEWhq41zP0hXKSlzJr9i7h+Tf8/3j/E
+092m+onihwEWhSpOhF++oZteppZDiq4xyMCCS+/0yzcxCEHp1w83yUSfv3p
oWEqvxyo7LrgX0WYvbhW+LuwHGz+z0x1gLA9vtrDLSEHxttPf1onLPrV1iNY
QQ7eJLFnaY4QzwM1d/d9VJEDzakTEicI19XjTNObiPOHzGJ8CF9vVUiy3ykH
2worMz8S/tM3VHhYRw56gl/kHB2lo0O/RUODjshB2mZmA0/CqX+OHPtgKAe6
2i37UwgbT776tcFCDmIPbj08TfjVTNd/Z0/KgeNB3FvmL7FfFrg8H56Wg9lj
XzceI/xp1Z2Zy0kODieqmbwhLER5Wq9zQQ4eitB+9RN2Z2pOCnSXAy913Q1i
Y8TzJnXnxkkfObh2ll0hgvBt0X/HWm4R+Vdw7+BxOkqqqhooi5KDfUcVKSWE
n119eDXvrhzkH9gRtE74Y5fWi4RkObjgdzc+bILYz9G8+8NS5GD+u7xBHeEm
rb4m7ydyIPmWaY/wJB0NPwldtcyUg1cm+TM5hGeMLeP0suSAvef48BrhdYYN
GzTfyEGA3AZr4yni+cOx1kz8gxyk5C9S1wjrbBDI6qqUA8bQkFHfGaI/HQNQ
VyMHfA1fZHsI29zOb/vcQKzvx8WberPE+oxZMT5uI+pTLkdKc3QU9GjT/ZhO
OdBmvV+XTPi20eqW4B45WHFYmeGZJ+rLfXLSbkgO9pw4GcS+QDzfnvWYNB6V
A0UfDtkowh8FtMMOTsiBwEWzJv5/RH1XhnIVFuTg8xzL8OZFIr/mFvbfLPLw
5WRydtIyHVFH1x9955CHsJUtCVorxPtbStPOSm55cFsWyR4hrLbmdSZTWB7O
XWnjN10jnldfH55PFpcH7s+R+TzrRL1nRKMipOXBx89Uo5mwTWlhgYuyPDiW
5xzcRaGAk2e0ofVGeaA9uNzxmLCnoi1x65YHzzFrnIuBArfDGHjUNOShnn3H
4Azhj/pHzk3oyMMvBWrcXyYKlC+Lr/QckYdvxrqvvJgp0Jj1N7bRUB5k1euX
6ISHuO9+zjWXhzcZcuXKrBSYKbEzfWZFnP9vTyiN8PqlHX/unZIH5mkZVls2
Cgi3fBf0cpQHw66w3y/ZKSB3M/Olg7M8YGrrsSc4KKC26yoyd5MH9wfJD6lU
CugkSblqXCH6oc51+QYnkd/aoezfTXmYfvaY+oGHAnxPRnsPRMjDpu0mZzN5
KfB6wIN+I1oe+K5Z40/4KDDidv0AV6I8vNUb+u+lAAXC37LZmDyQh/icZVqR
IAWUFmKuJj0i+jGnv9ImRAG74EcFchnywBrgLbhJlMj/Ren7uVfyIHmvNdZe
jAKp7Nmzr17Lw7s71V4vxCnw416husYHedgrkPPVQIoCRs9/vNKvkgc6S0CL
kgIFxv7YVsfUycPUxLvEQkWi31uGhr81ycOniozy08oUqCiYU7LtkIdJGFRo
2EAB+5Vr2uk/5UGNJ3Rv6iYKUIDJ/k+fPOht87x9VY0CB6r5n3iOysM2Y7Fm
B3UKdHI/KP4wIQ/JOhq1Hjso4Gcq1706Iw97Lp5lv7eLAnldW8VvrcjDgEFN
MMteCvFeaRCfwqUAMQtH89sOUaBqx7e3vXwKoJsqQAk+TOwXX+smZWEFWC0b
ddQ6QoFnFBfuXGkFOKq1pkU/RgHs8NTmeXkFiDO7KMtsQoHuSN+j+1QUgBqp
NC9vTgExwfBb5VsVQPDobEyWNQUKTnBncOxUACl12RExWwqYpyaUG+1RAIdj
aw5pZylwVzmdoQMpQMTVL4rcLhRg1cSvjRsrQKNvb5f1VQo8D9B7uMNCAfCI
aZWyQAocKm346HtSAax6Hy8YhlAg8OjPeQZ7BVjndD3cHEUBibuOQnpOCnDM
1HmwLpbYz9/+7oi+oABVviV6U4kUmDu1fEnESwE8DqT+fPeUAnHPbsTY+CpA
eOBLO/MMCqgPsec8vaYAG/t6jihkU8DtkujoplAFuG81uvnIRwoM3NjliBIV
IMknvORXCwU2iPDEXH6gAI/mrFt+dxDnvxr+8OyRAoi9ycuQ66PAQstDTuYM
BWAqD+/YO0UBqhJDXlWBAjDueXFSjp8Bjn/s7F4qVIDk85ZoRpwBEgzfs26m
KcCS5dteJkUGkPY+b33nqwJ83J4vMKbBAOqV9Qym7UQ/7c6XLNoygLd15uab
3QqwcqJ5bsqFAQonrlu871WAJ/EqQbu8GUBbdNdLkRHCS7PG6dEMYOn80Lhr
SQEGqEI5ejQGSFn18udaV4CMaz77yuoYoDf22HMtRkXIf6G0P76TAVw+URaf
UBVBWYkhU+sfAwRQzz9xlFQE6Y4nUt93MULpY6hOlFWEn0WuF5QOMwLrTonZ
SkVFQIdc/rVYMMJdm3rdjWqKkMMZM2Lsxwhp2Tsnxg8owunsi4a9pYxQbUTR
8rVVhFm3hgjr80zAM9Dh9J+9IgRdH+/KD2QCU9+82A4nRdhyP2uzawITdD9x
Gtx/SRHu7XY80VHGBFNTdVGU64ogw/vX4IwiM4jEP+iMfKYIJlOWdtXjzMD1
XbDZ84UieI6kmiexsACjaMxXm5eKMKQUHnhcmgUmH4a83/JWES45Dok5GLJA
VZprTDOuCMGyq5I7/mOBksHfoYXliuB4QcchpIQF3qvYXUuvUoRhSpfwrVYW
ePbK3Nm7SRH0F3N2PaGzgP87rUPivYoga2VB/WrCCpfnPmgyDiqCi4Rkp8c5
VnDavWPb32FFYKgoPVrmxwpmhSpSxZOKsGO9/Kz5Y1ZQK+NdsKMrwp5KiUuG
v1nhV3Pfy/9klCBRJUU1wIEN2gRPPb2noATnOTN/9XuwQZ1FW5K/ihL8d4yb
6AMbfOyouWm4VQne5DC3OqWwQVxf3ukpLSXQq2BQ5GhkgwjFreYdB5WA/QDu
bdLFBkHn/jtadlgJkoqaQk8Ns4HrSOqehGNKwFfx3hxfZwOd6TB+zdNKUG3u
dXVgEzvs20lhlz+rBEdOf3rhpMEO6t7+6xznlMCLZWdFAWIH6SX3v11uStBn
znu+zIwdFihWFcEBSmA++zrsxVV2+I9v09WvKUrQG7RzwaeY+PzQyUXmp0rw
0tr82mgFO3wqivQ99FwJvixr9u5sYIcapxHv4mwlmPAR4DPsYYexz/955hUr
gYDfy51Zq+xwJa59eqqUyMdizjDMxAFr59k9tlYqgbXUtyd0KgfwCDpfetmg
BHc3bjtZI8YB21xU3Z78UoI9+N3+jh0c8BE78bd7QAkWPq+E8+3lABC6dUHi
jxLMVu6N3Yg4wJg25Jw4pQRcrt8NWAw4wFM441wUgzJIsQmVeJ3lgIJSpTO+
isowzCG++XkkB2DJ5j3vVZWhbGJrjHYMB3x1Cz09s1kZNGxCUuvjOKBddNDm
4i5liOzvdEpP4YCli+lWDoeVwdbOctgumwNCtL/9eKpPfJ5xzx+7XA6gijOd
6DmmDH+CMt4YvecAiXJ7i5OWymCxmTY7V8QBByQUTI+fV4ZfZ9JyvGs4oHzS
pDnaVRnqRS8dHK/ngGMVN4xrLinD6vSZXRbNHGB7uc/osJ8yjF9QOPvvBwdc
r3xqsD9SGZzvJL6OHuSAL56yh1WziHo+D6pqrHDA6vxkrNQbZZDJzgrPWOOA
3Vfxbv48ZTig0PeVm0KFV8Fnr6wWKgNXGvujEmYqxEWnpzfXKEOmv/v+19xU
qOO9MlnZoAzKtbpG33ipwBqvs/9zizIUjDtGT/JTwf/B75aMTmU4SCtX5BGh
gn2GKmPAqDKEafV8HZamQurGxWMeE8pw632wVo0sFdqyqx44zSgTfYPV5/JU
OJrnst1kWRl2p1zt0lamwnY8y06FqgIermM3NqlRgdK5jda0UQXsdH/vy9ek
wr7TFM7KLSrgq21zedM+KlzpbbIs2q4C5Q/fFD3YT4U/Qx4TL/aqQNcWr3kn
jApNs3nS1/RV4LXfl6QSbSpQfUNdLh9TAfHH90TZDlNBZ9k8/5yJCoRIczgf
1aXCR8qCofFJFcg32dxYeoQKT7g1A5RdVCCin3fZ+xgV2mPZqyQuqsCH6qKD
yUZUEBDqEOTzUAGe7TkrecepEC7hn7XspwLbrXj5e02o4K76ubMxQgV0nP2L
mC2pgB2Evf7/qcDvnIKxmNNUkBVyiLXJVoEB6zoJV1ui3uGw4QO5KvCDk++P
9hkqlEXXJtI/qMDFlcTEv3ZU0G23nAn9qgKtciZpQo5UUM26qu9UqwIvfopr
/CDMHpT6VK9RBZaM5euTzlGhRrHfiPpDBZhEgvdxn6fCsUsXs+4OqUBCU75+
u8v/Oq7veCy7NwDgNKgnikSlaBjPfp77oWSEy2slI6JCGoiXkkpkJiMJITMV
USmjbApRSJKEMqPhFbJJth9+5/jz+znXfc65xv25PzcJWP/cXnFpQBoqPvlp
XD9LgvXCeWaHR9B9p8sTmOdQ/YpneIWnpGF1s2uMmwMJTHiun7m3mgx3X28s
HHMkgUXCPbEnkmT4bpYk4HSZBMoXS51vUMjwwOuo/wyyuHrnx38ZZChNKu73
ciZBZ5+UB20PGVa83Z9zzYUEZ/bktGSpk8HVZGThvCsJNHmbmBHaZOjgv9nd
jSzdPnXdSZcMWW1h82ZuqL/X9svuNSbDxp4jbSruJHD4+D682IoMjg9q1kx4
oPweDPTetyVDTJTKnhOeKL9L/CpXz5LhU7BaVSXymIjxkKoTGXRzbOXDvdD8
WP048M6XDPumH3Jt9CaB5+wEd0MSGYyMS/mafEgwcurTf6ufkMHAxOgo0xfN
d9WTcqU0MjyeEScHIB+IOuqbkkMGFx/NK4QfCTYxC7muVZDhYIfhpSv+JAiM
ut2ZX0WGvv0G9yuR52btygZqyODcquwleB3Vo2qrz9FGMrQ0z7mnID8/7bnE
7Caj777ZeGUAmo/3xj+t+8gwC1S7tTfQ+8lkvLk7RIb5QOHXeshuc9+8V0+i
+6XXbG9A1oxWWfy2mgJprp1SNYEk+PGeeyGETIEyPjl6eBAJjFjt38rpFNhO
/TfnLXJldG7JNJsCY5KfzaeR0y2tvazlKXBcf0zKIpgErvOV84o6FGjx11ja
FkKCAcuEjov6FKgqWbniIPLJapdXT40oMNgQpO6KrBEj7bnRnAJtPUfC65EF
2Dfn+s9SwLVS9KHrLRL4x5xu33GBArv5J0YTkafm5YuPXKbAy48OMe+Rv1X3
u5d7UoDXKmx0UygJUq10Z+NuUUDt7TFWKrJa7PoZ7UwKxKqIcOeFkcA2PTB5
by4FOEqcX/XIwa+5jCReUOD0SiGTIeSm3vG0xVIKVB7e0C8RjuL3tR4v+ESB
OkkBgTDkYF3DNY8/U2B9HisuBTnr1If8280UeNqkV1KGPBP4it/hOwXGrwT8
+IPj2xLf7B6mQGhuW/6h2yTIHNriIPCHAvxutVq2yI1ckVsWJyiwWeeijxfy
dur1S1//R4GA+unRFOQsdzuJ23xUECo26Z5DbhLlBC7QqbBqeF4xMgKdx0qX
HWRToSlb6cdjZDF1ic42WSrIORrtL0C2PSeskK9EhXgPc2Yrjn81O3BWlwpJ
3B1cWyLReQ1Od0wPUSGi2iqOjKzWPaiuZUxF/8s143LIwXw/4ncdp4IDfP1r
gix2osKg7SwVfspqQBjyP5eU5t85UmGD/8418ci2AfkpeU5UGD269V4acnbG
U65wDyrk9vfvqMTxi8G5msHofuuY1VM4PtFYJC+NCqYu65SMo9D+2n66kxlU
4LFX7juJ3DSS7bMvlwrJAfXWZ5HVVNYPviqmwpsyhw8+yNu/V7+p/EiFECea
7TPkxuvTEzwNVJg9/DmhADmYIU3TaaLCLie59DfI057+0Z++UUH5Uol6I/IX
URX7lmEqcNzfhcwgB1U4PNgyToXu3xWe3NEkgLP3G82nqHCtvUeThJxRNKP8
c5EKUTwbzm1Dvmmat7FvAw2qBdvX7kdWjqWUzHJooG46tNkVeUL52B8lObRu
PT96FTm9J0DaW5EGrdsX068jb9n76/YKdRqkuTV9jEAeb0ywWWdCg4kBt6p0
5DTP2nv6pjToPlX6Nhv5tMR8fbgFDRTl01NeIH9yMlXcZEOD9eK8UhXIqYJC
G8Su0ECuNp2rDflUkZrGKQ8aBB0Ble/IIpYX3R9608Awq8CmC9k/+9MvqUAa
cPNEXh5CPnnoZiErjgbW8YbRS8ibQhcsoZgG/MfP7dkdQwKvrlprxdc0mBpY
MyGF3L0v3mZPBQ0ibBqTqcgFXYr2lBq0TvrdTiAflXe7KNBOg4Qs4UQV5Neh
2k6kHzTI19QcUUOW/iXivKqLBvMvjhCayNOhBa4z/TQQmBsP1UWO+zXu3TlL
g53PhAqOIXMpVPi0L9BAeG7PQ3Nku7AIvyZuOuygv/M9gaygQNyoXkuH+v4f
O62R28POh2ZvpUNnQ1nHeeRtin33fRToUCu/YO+LfD38ZYKHMh1mtgnl+CMP
dd9IdFajwzGH3aMByCXoh9VOhw4clSLDYGSLHqt0QzM63LOIz4hErlSUeX7w
BB3+eX04OxqZcZs7U8OSDiu6hZ/FIi8oJuXI29Oh6odi0D3kB7e/F+50p4OO
1sHBh8g8vc+LRa/S4e7VnJzHyI5KXiWbfOkwryJy6Qmyaq9o2ZogOhwtVO9I
Re5UMn0/FkeHmG9Vp7KQd//+0lxWSAf5Xz2qr5A5tya6npbQIXdR6n4JMnBE
xm6V0aGRw/lTinzK04xkVk2Hi9orw8qQ4zd0qvxppYM55IW8Q36Wz63X2kGH
5vbVb6qQi80kzEp/0kFLOnX4PfLXx7aXg37T4cQ2qnINsoj8cMquaTo8DFVI
qUOW+r6+gHeeDgJvpF/WI+/xIyqGF+kgKr9Y0YBsXHv5WxEPA4z1iuq+IN8+
PSdwWIQB8S3FL1uQSUG8Hn57GRDU7d7+HXkrixpop8CAVH73rB/IlMaD0QbK
DKgsUvH9iawtFpYpqsmAJxlHt/2H+5mz6VeuCQPq6iXp3chRR+XG4kwZsDOh
5Df2o/ljC94WDDDRd33Yg1yueX+z7hkGFAn78P1GXvy6S+/XZQbM+5Iq+pH5
r6mbfXBlQOPDbrsB5O2SNrZZngxQl9jHP4is5Jjq4+mPTLpoMITstoJdIBTF
gPuBR/JHkMdp+8U1chlQoLpe+C9ytLVQvvcLBuSpFz7C3hs/oFNUzIBL1A2s
Cfw8/10X1lsGvCKPKk/i+RmdrN3SxAD5nGT1aTw/lE9Wxm0MOCTe9AYbLJNn
Qr8xgMtlSmEG2e/LYcmVPQxwGN1LmUVeU5DlOTzJAIngsOE55PThG4KUOQYU
F6ibzyPrSp9MsVpkgO0g+x122B2+xlYeJqAPUMz/kIU87GkVm5lw/PMmiUVk
cVWJr7EKTKDNvh3niiVBmeuc42dlJviepmpxI1tmf17F9w8TmtmsOOzkXT6E
70EmUNax5VcgU1d9Dzx3nAn6zSV2K5Fr9ueLPT3FBLuE2hxsB5eQvE5rJvx9
83wWO7NX4ecRByYYtXcHrELe8yFWDq4yYUdEwe3VyC3cjrUevkyInspswHZV
1LQqCGBC38l7G3iQi5/9DaWFMcFPwzwYG8IMezYlMuFr0UpnXmRdY1J0fxnK
z/vttrXIDxT8pjoqmUAvSNDBHtsxZ1pXzYQ6SvkV7NihfrG8BiaUZ4/WYXcF
fEjx6mTCw3QVVxLyXgc10oVuJliwXyRi3zxc5GDZxwTdd2HvsVk70jhaY0wY
W39BeB2ye+HNVxu4WFBjppKOXfuAS3zFKhao966rwxYPcPOZ4GXBSLTeH+xK
IzvNrxtYUP+XLceHLDCoXf9oBwsCJoqLsFPEeH/tVWXB5O+3afzIcyuvaVLU
WXCr7N07bL2BqRRRbRbIkk/8hz3+otdhyYAFj2iHN69HVjGsmqo+yQLapJ43
doScitkrKxY8N+K7g929/cWrDFsWbM21y8IO7n/iE+nIApePiz+wm/0CSBbe
LLByr1XYgEyxX3Aw8GPB5fVJh7A9DrnUww0WDICYDfbO7TbRUmEsqKsRDcd2
KNAQH01gwed7Bj+xV/atlPErZcFo3rtLAsh9lhyxD+UsOFuudR27ruPkGoEq
Fozf8ojFjqsv+pFQx4Kd/UtF2IyXF0KKfrKg1i91AVuQk3CFq5sF3vq9/ILI
U+k1ltp9LEhO/E8Mu+yBlHzzGAtagUcZ2+RGR/cYNxtalMXcsBW41jbs42HD
mSrVG9jiHnKvvEls4POXiMbuOx8RwSfEhqVI2SxsryPaKhRJNkz1xHVhJ0vm
3TmlhfbbFq66ETnoQaff04NsCNpvfhDbcct6x2EDNrz2mDPBluez1/A8xoZW
8VJ77Nq/4n9i7dgQfksqAjvnvN637w5sGBaKvIcd+9v9veQlNqTGNj3GPt3R
lJDrzoZY1s8C7ImK4IN1wWxYuU6yDfvr/sK9wuFsmKg368R+/aJnp0UUG3g+
O/Rh30yH6f77bBgks2awt0dOPV6dwQabkH0iQsgallYL++tRfgk8+tgNtK6/
FxrZIKqmZoxtMWE58KgVxf89ZYbtHGjZuqaTDX5/dW2wkzNO5zSNsUH2zKgn
NuHamcI7yYZpv+O+2CVw+oHiLBu4QrNvYA/0Z2k2cBHQ37A5AnvF1SwZubUE
BIgOJWNXW45mHFpHwIeY7DTsMC021Z6fAMc2q0xsUYGsHfGCBPzaFfUSW+Zx
Jt8KUQJCuIgP2NYfMno/0QhwK93ej03LHLb8zSDAxaFuCHsskvmdi03AqPrF
MWwvi4xGWVkCqlICprGjR5+X3VUiYKBradUmZPOmIaU8ZQJeuyitwd5ZxHhZ
q0pAb4r9Ouznfs8zltQJiJdKFMSuFH5+z0aPgEhpVzHs4LlB4WsGBMQdMNyJ
bfiTHhFnSMCZ92IS2N9SnwV+NCHAbySGgj2h9MyZc4KAvdFLMtiSVukGC+cJ
iKr+ron9NkExe/wCAf4BfdrYVl9rBPsuEfD0wKAOdqLhYNMXFwJaHL7qY4uq
Mo6nXiVg8/+OH8Eu8igpSbhGQGsR7Ri26Qs98ShfAs5Fj5tixzDP/3c1AO2/
0dECW2B75r/GoQR0dghaY2cdU/lwIJwAteG0M9gGUXU0lQgCar2VbLFDSKPD
lBgCPB/r2mPzzLKdF+MJmPGQuIC90Jzjk/acAErSJ3fseMF/uh5kEqDezOeJ
raj/RT06m4DxMG0vbLfKcZ5r+QRICmZ7L9cnVzbUpISAtdaG/thRI29HdF4T
0N3vcB1bhmZiqFpGwK5p/wDsCw+dhWiVBCjtfhSIPRBecHfpIwE7qI9CsIM+
as5PfCLggFHsLWwKb4vFQD3q91xAKLaN99SO5kYC1h0yDcfudNj3NL2DANNz
tZHYLTpFuUcGCTjfzX8X+6lJ+GL0KAFNIkn3sK+csjnY9JcAcRI5HlvYRbDr
8P8I+CazJRG7+9pvZiQXBwT6ridh5weXun9exYHUE4MPsU2S7AUN+Tlgn5Oa
vDwPz1RPhAtywKR44slyPQqE0+qEObCXRKQs1+NjOeiLc4BR7pa2PB8td27d
2s2Bczo305fr89/5to/SHPhjHvIM+8vU1osH2RygWlzMwHbiq+L9sI8DrjpE
FrbgbqdEbeDAtZTG7OX51a+p0zDigG51bx72qNUV27dmHDgW/W8Bdpjb7kU1
Kw5QtH6+wP702IOpepkDjxsdi7AbNtmdZHpyoMvKs3j5/IAj4dv8OZAR5Pxq
uZ7/En+mI1H+Tgql2B0664ybHnFgs3zr6+X603vzs3M5YKFiVYbdw18uElrB
gck978qX+zt6383+Cwd2pCxWYI98vtKu2cUBMcdNldh/84z27x7nAGHN9w57
z+RdcyVBGfC+nF613C+5LjcTQgaOSYy8xy50pd05f0gG9DyHqrHnCp0KbjjK
gIR+8gfsJGeLq9y5MjCZkFSDrUVoaXpNysDxrfHLXvVesfXyHlkorBxbdsUJ
tv25y7LgeWfNR2x5XsPsgiJZWDGRtOzM7IvTS0uykJ3IqMX+PyMkBPw=
       "]]},
     Annotation[#, "Charting`Private`Tag$5848#1"]& ], 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwk2nc8V98fB/CPvX1kbx9bhcy+Wve8SVIkSbISkigJKWVEC0lSViJJaElK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       "]]},
     Annotation[#, "Charting`Private`Tag$5848#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\" \\!\\(\\*StyleBox[\\\"\[Omega]Real\\\",FontColor->RGBColor[0, 0, \
1]]\\)  \\!\\(\\*StyleBox[\\\"\[Omega]Desired\\\",FontColor->RGBColor[1, 0, \
0]]\\) [\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"elapsed time= 0.015625 s\"", TraditionalForm],
  PlotRange->{{-5, 20}, {0., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473335622875357`*^9},ExpressionUUID->"2c225535-a82d-49d6-9efd-\
5b7c108d7525"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"adding", " ", "P"}], "-", 
     RowBox[{"I", " ", "controller"}]}], ",", " ", 
    RowBox[{
    "play", " ", "with", " ", "red", " ", "values", " ", "and", " ", 
     "investigate", " ", "their", " ", 
     RowBox[{"influence", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"cosntP", "=", 
     StyleBox["4",
      FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"constI", "=", 
     StyleBox["100",
      FontColor->RGBColor[1, 0, 0]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
     RowBox[{
      RowBox[{"cosntP", "*", "\[CapitalDelta]\[Omega]"}], "+", 
      RowBox[{"constI", "*", 
       RowBox[{"Integrate", "[", 
        RowBox[{"\[CapitalDelta]\[Omega]", ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}]}]}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"P", "-", 
     RowBox[{
     "I", " ", "controller", " ", "without", " ", "output", " ", 
      "limitations"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnMachine", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"La", "*", 
           RowBox[{
            RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
          RowBox[{"Ra", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "+", 
          RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"J", "*", 
          RowBox[{
           RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"k", "*", 
           RowBox[{"ia", "[", "t", "]"}]}], "-", 
          RowBox[{"B", "*", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
          RowBox[{"kz", "*", 
           SuperscriptBox[
            RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
           RowBox[{"sign", "[", 
            RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
      RowBox[{
       RowBox[{"ui", "[", "t", "]"}], "->", 
       RowBox[{"k", "*", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnReg", "=", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{"charReg", "[", 
           RowBox[{
            RowBox[{"\[Omega]des", "[", "t", "]"}], "-", 
            RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}],
        "]"}], "/.", 
      RowBox[{"\[Omega]des", "\[Rule]", "\[Omega]desired"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Try", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{"charReg", "[", 
           RowBox[{
            RowBox[{"\[Omega]desired", "[", "t", "]"}], "-", 
            RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", "t"}],
        "]"}], " ", "instead", " ", "of", " ", "the", " ", "previous", " ", 
      RowBox[{"command", ":", " ", 
       RowBox[{"the", " ", "result", " ", "is", " ", "the", " ", "same"}]}]}],
      ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "but", " ", "elapsed", " ", "time", " ", "will", " ", "increase"}], 
       "..."}], " ", 
      RowBox[{"why", "?"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eqnNum1", "=", 
     RowBox[{
      RowBox[{"Union", "[", 
       RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{"dos1", ",", 
        RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"initConds", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"unknownVars", "=", 
     RowBox[{"initConds", "/.", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "[", "_", "]"}], "\[Equal]", "_"}], "\[RuleDelayed]", 
       "a"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"Union", "[", 
         RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "tStart", ",", 
          RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Omega]", "[", "t", "]"}], "/.", "sol"}], ",", 
       RowBox[{"\[Omega]desired", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tStart", ",", 
       RowBox[{"2", "tsol"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<t [s]\>\"", ",", 
        "\"\< \!\(\*StyleBox[\"\[Omega]Real\",FontColor->RGBColor[0, 0, 1]]\) \
 \!\(\*StyleBox[\"\[Omega]Desired\",FontColor->RGBColor[1, 0, 0]]\) \
[\!\(\*SuperscriptBox[\(s\), \(-1\)]\)]\>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6797228544375*^9, 3.6797230019375*^9}, {
  3.67972305809375*^9, 3.67972306121875*^9}, {3.6797230991875*^9, 
  3.679723287671875*^9}, {3.679723517328125*^9, 
  3.679723624515625*^9}},ExpressionUUID->"7ba92f8c-23d7-4872-8443-\
293b81da27d6"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwUl3c81d8fx++1N/deO0QJoUJm5XNOwrciMrN3MiJkhcqKCMkuI1ktq5SG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       "]]},
     Annotation[#, "Charting`Private`Tag$5981#1"]& ], 
    TagBox[
     {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
      LineBox[CompressedData["
1:eJwk2nc8V98fB/CPvX1kbx9bhcy+Wve8SVIkSbISkigJKWVEC0lSViJJaElK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       "]]},
     Annotation[#, "Charting`Private`Tag$5981#2"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"t [s]\"", TraditionalForm], 
    FormBox[
    "\" \\!\\(\\*StyleBox[\\\"\[Omega]Real\\\",FontColor->RGBColor[0, 0, \
1]]\\)  \\!\\(\\*StyleBox[\\\"\[Omega]Desired\\\",FontColor->RGBColor[1, 0, \
0]]\\) [\\!\\(\\*SuperscriptBox[\\(s\\), \\(-1\\)]\\)]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
     Charting`ScaledFrameTicks[{Identity, Identity}]}},
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-5, 20}, {0., 4.2008404408397455`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8473335624750214`*^9},ExpressionUUID->"915a526c-50cf-4087-890a-\
59ccbb870229"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.679723274734375*^9},ExpressionUUID->"a7be1507-328a-4990-b8fd-\
e6ec63a8a0ac"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"adding", " ", "P"}], "-", "I", "-", 
     RowBox[{"D", " ", "controller"}]}], ",", " ", 
    RowBox[{
    "play", " ", "with", " ", "red", " ", "values", " ", "and", " ", 
     "investigate", " ", "their", " ", 
     RowBox[{"influence", "!"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"cosntP", "=", 
    StyleBox["4",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{"constI", "=", 
    StyleBox["100",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{"constD", "=", 
    StyleBox["1",
     FontColor->RGBColor[1, 0, 0]]}], ";", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"charReg", "[", "\[CapitalDelta]\[Omega]_", "]"}], ":=", 
    RowBox[{
     RowBox[{"cosntP", "*", "\[CapitalDelta]\[Omega]"}], "+", 
     RowBox[{"constI", "*", 
      RowBox[{"Integrate", "[", 
       RowBox[{"\[CapitalDelta]\[Omega]", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "t"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"D", "[", 
      RowBox[{"\[CapitalDelta]\[Omega]", ",", "t"}], "]"}]}]}], ";", " ", 
   RowBox[{"(*", 
    RowBox[{"P", "-", 
     RowBox[{
     "I", " ", "controller", " ", "without", " ", "output", " ", 
      "limitations"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"eqnMachine", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"La", "*", 
          RowBox[{
           RowBox[{"ia", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"Ra", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "+", 
         RowBox[{"ui", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"J", "*", 
         RowBox[{
          RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{"k", "*", 
          RowBox[{"ia", "[", "t", "]"}]}], "-", 
         RowBox[{"B", "*", 
          RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
         RowBox[{"kz", "*", 
          SuperscriptBox[
           RowBox[{"\[Omega]", "[", "t", "]"}], "2"], "*", 
          RowBox[{"sign", "[", 
           RowBox[{"\[Omega]", "[", "t", "]"}], "]"}]}]}]}]}], "}"}], "/.", 
     RowBox[{
      RowBox[{"ui", "[", "t", "]"}], "->", 
      RowBox[{"k", "*", 
       RowBox[{"\[Omega]", "[", "t", "]"}]}]}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"eqnReg", "=", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{"charReg", "[", 
          RowBox[{
           RowBox[{"\[Omega]des", "[", "t", "]"}], "-", 
           RowBox[{"\[Omega]", "[", "t", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1"}], "}"}]}], "]"}], "/.", 
     RowBox[{"\[Omega]des", "\[Rule]", "\[Omega]desired"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"eqnNum1", "=", 
    RowBox[{
     RowBox[{"Union", "[", 
      RowBox[{"eqnMachine", ",", "eqnReg"}], "]"}], "/.", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{"dos1", ",", 
       RowBox[{"u", "\[Rule]", "_"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"initConds", "=", 
    RowBox[{"Union", "[", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "'"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{"a", "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}], ",", 
      RowBox[{"Cases", "[", 
       RowBox[{"eqnNum1", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"a_", "''"}], "[", "t", "]"}], "\[RuleDelayed]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "'"}], "[", "tStart", "]"}], "\[Equal]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"unknownVars", "=", 
    RowBox[{"Union", "@", 
     RowBox[{"Cases", "[", 
      RowBox[{"eqnNum1", ",", 
       RowBox[{"a_Symbol", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"eqnNum1", ",", "initConds"}], "]"}], ",", "unknownVars", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tStart", ",", 
         RowBox[{"2", "tsol"}]}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.679723787671875*^9, 3.67972385015625*^9}, {
   3.679723899734375*^9, 3.679724036140625*^9}, 3.67972410653125*^9, 
   3.679731138203125*^9},ExpressionUUID->"fc1078c9-68b6-420f-92ef-\
45c96793a8a6"]
},
WindowSize->{1120, 743},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1809, 39, 256, "Input",ExpressionUUID->"db8f5023-f83b-4c38-a740-0f47e5be5c45"],
Cell[2357, 61, 7865, 205, 754, "Input",ExpressionUUID->"31a88f22-1612-4f9d-8c5d-f1eaa66135cd"],
Cell[10225, 268, 2497, 71, 346, "Input",ExpressionUUID->"15f49443-eb58-4f27-8c0b-4f3f196ca860"],
Cell[CellGroupData[{
Cell[12747, 343, 994, 27, 106, "Input",ExpressionUUID->"16dfaa29-bace-49b6-abd7-f42b01c990b8"],
Cell[13744, 372, 187, 5, 51, "Output",ExpressionUUID->"56a5eabc-ac10-471c-8fc7-559aec398d83"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13968, 382, 5509, 139, 599, "Input",ExpressionUUID->"a04d402d-2960-4e06-86f3-df56678cc9a1"],
Cell[19480, 523, 14551, 259, 413, "Output",ExpressionUUID->"332664e9-59b6-47ca-99d8-60023597d650"]
}, Open  ]],
Cell[34046, 785, 4897, 139, 510, "Input",ExpressionUUID->"53a5bdb6-b215-45df-b6e6-9fce14567afd"],
Cell[38946, 926, 2760, 72, 436, "Input",ExpressionUUID->"8fb4b217-876b-485c-87b9-00cbb5be3135"],
Cell[CellGroupData[{
Cell[41731, 1002, 4937, 135, 463, "Input",ExpressionUUID->"0fc83931-6f54-4ef6-a617-60b87f6d5495"],
Cell[46671, 1139, 53785, 905, 400, "Output",ExpressionUUID->"d7793828-b981-4bc7-a97d-422a7a05352f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100493, 2049, 6541, 179, 634, "Input",ExpressionUUID->"7c35d40a-45af-4c99-8f53-a5f383a13b7c"],
Cell[107037, 2230, 55358, 930, 422, "Output",ExpressionUUID->"2c225535-a82d-49d6-9efd-5b7c108d7525"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162432, 3165, 6234, 175, 613, "Input",ExpressionUUID->"7ba92f8c-23d7-4872-8443-293b81da27d6"],
Cell[168669, 3342, 76349, 1274, 400, "Output",ExpressionUUID->"915a526c-50cf-4087-890a-59ccbb870229"]
}, Open  ]],
Cell[245033, 4619, 128, 3, 73, "Input",ExpressionUUID->"a7be1507-328a-4990-b8fd-e6ec63a8a0ac"],
Cell[245164, 4624, 4958, 136, 707, "Input",ExpressionUUID->"fc1078c9-68b6-420f-92ef-45c96793a8a6"]
}
]
*)

