(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106216,       1922]
NotebookOptionsPosition[    105341,       1891]
NotebookOutlinePosition[    105868,       1910]
CellTagsIndexPosition[    105825,       1907]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fce", "[", "x_", "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "2"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hledej", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "min_", ",", "i_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"normgrad", ",", "newx"}], "}"}], ",", 
    RowBox[{
     RowBox[{"normgrad", "=", 
      RowBox[{"Tanh", "[", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"fce", "'"}], "[", "x", "]"}]}], "]"}]}], ";", 
     RowBox[{"newx", "=", 
      RowBox[{"x", "+", 
       RowBox[{"dx", "*", "normgrad"}]}]}], ";", 
     RowBox[{"{", 
      RowBox[{"newx", ",", 
       RowBox[{"fce", "[", "newx", "]"}], ",", 
       RowBox[{"i", "+", "1"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Nest", "[", 
  RowBox[{"hledej", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", "150"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"body", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"fce", "[", "5", "]"}], ",", "1"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{"#2", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", 
       SuperscriptBox["10", 
        RowBox[{"-", "4"}]]}], "&"}], ",", "2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"body", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"c", ",", "b"}], "}"}]}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<i\>\"", ",", "\"\<f [xi]\>\""}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.451631313859375*^9, 3.451631604796875*^9}, {
   3.45163168234375*^9, 3.451631712953125*^9}, {3.512915605703125*^9, 
   3.512915633140625*^9}, {3.512915734671875*^9, 3.51291580815625*^9}, {
   3.512915893703125*^9, 3.512915939390625*^9}, 3.5129160510625*^9, 
   3.512916767609375*^9, {3.512958601390625*^9, 3.512958604921875*^9}},
 ExpressionUUID -> "8f04cb27-a021-4694-b5c3-e9688b91d77a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0000000000050788`", ",", "2.579447606194715`*^-23", ",", "151"}],
   "}"}]], "Output",
 CellChangeTimes->{3.8436997010057507`*^9},
 ExpressionUUID -> "9db900bc-63f6-4752-8e8e-b5c82eefbcd8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"x", "+", "3"}], "2"], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"y", "-", "1"}], "4"], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmin", "=", 
   RowBox[{"-", "7"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymin", "=", 
   RowBox[{"-", "6"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ymax", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"pl1", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "xmin", ",", "xmax"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "ymin", ",", "ymax"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<x \>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{"FindMinimum", "[", 
   RowBox[{
    RowBox[{"vyr", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.5129161295625*^9, {3.5129164641875*^9, 3.512916488578125*^9}, {
   3.512916597015625*^9, 3.51291660678125*^9}, {3.512916981734375*^9, 
   3.512917000453125*^9}, {3.5129177440625*^9, 3.5129177548125*^9}, {
   3.512917793421875*^9, 3.512917801390625*^9}, {3.51291783534375*^9, 
   3.512917979265625*^9}, {3.51291801275*^9, 3.512918017828125*^9}, {
   3.512918058421875*^9, 3.51291807334375*^9}, {3.5129183208125*^9, 
   3.512918321796875*^9}},
 ExpressionUUID -> "32815cde-7c38-4a4f-b650-94876d581471"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHlcTdsb/xtOcxpUyBQ6hgzJLUOG9jEXSuRSZhluhmPIkCmRS+41dgwZ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   "], {{
     {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[
        TagBox[{Polygon3DBox[CompressedData["
1:eJwtmgnYTVUbhs/53r2ojCGVKYRCKIUMKUIhkoaflFApFSUlU8qQEJEMURIV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           "]], Polygon3DBox[CompressedData["
1:eJwtmnfgV1Mfx+8Zl5QSxYOMUrQUySyjKCOhJZWiskVWg0JUGsoKDbMUQpTs
PZ7Hno/HyCw7FGVvz/v1e98/br/zvufc+7333HM+n/f7/anJ0NN6DY9FUdyt
f7L+jtQ/W+vv3kFHWRQLU1HcKnyJ+scI/1t/PxHO6v9N7dfU/7rwPWpfov6Z
wuOFxwo3Fp4lPEH4XOEmwrOFJwqfJ7yN8J06vlX7RZ17QX1P6HhS7QU6N1F9
/9HzPCj8jn5vivCr6n9NeKn6p/M86n9A+G31TxZ+Wvh+4beEJwl/Jbyf2s10
bgtd+4yOZ9W+Lbr/XPXvKHyYxnQVXiHcXu1NdW5Djf1YeBfhzYQ3Ev5EeDfh
zYUbCP+g+/ytdqFzP6n9lPrvE3xT+KLS8/OU8L3q20N4pfr3VV9TnWukvvnC
p6l9qc6dqv5Vwgeq3ULnGqv/OV33udrr6Nwfas9T/6nC04WHafw5ws2FDxDe
V/gxXfO48E0aO5754Z2FF0Y/zyiNbyy8j8bvIzxGuK3wIcL7Cb+u8U8L36fx
HYS/yb43v7G1+uYKn6L2NJ07Wf2v6Nyr1fqZJvw431B4vvAEvq3Gd9PYVjq3
jfrWCHcX3l64mfDLOl5Re4nGX6zxv+hvVH/S8avaj+jv9er/UcfHwl8mfwu+
Ed9qtY6D1G6pc014V435TO1S535X+3adW8j8qj1W968v/C/6hecIf6frD9bY
1jrXVH136LhN7cvUf676z1b/dsL7a0xn4bHCOwgfKtxFeJH+Xiq8Rsd7umZ/
9a9U+2W1r1P/R7rfCuGnhWezftX/gvBKXTdD+H31fyj8hPqvFn5Q+CHh64Uv
FL5X42cLPxD8/A8k74fr1H+B8E18E+HJwrfwPTT+eeEvNf4K4ZeFnxP+Qvhy
4Zey1//nwpexPoVfFl4lfJXwW7rfO8IPRY+/T/1zhB8Mno+31b9M+OHo+78j
/K7wI9Hv84bwm8L3Cy8WfjF7/X3GPAk/lP28TwqfJ3x/8v69VuPHsf6y18Pq
4Pm4VP1Thc9U/2jikfpHCl+t/hHCdwifIzw7uP9W4RHCVwmfJXyL8FnCVwqf
KXyz8JnCM4TPEL5LeIrwrcJnC98jPIvnD453twuPFp4lPIr5Fh5OPBQ+hev1
fIv5Pdaa8MPqv0X4GfWfL3yb8CjhmcIjha/W+MuFz9H4m4RvSJ7fC4XPEV6c
/b4Lg/F1yd//gujn+5/wW6yH6Pl8S+NPZ71q/HDhQ4TPEL5C+HTiQfZ6fj54
PT2avR+eC14/9ybHy2uin3ex8BLmN/r7PJmNXw+Ox09kv+9rwfv7UY1/THie
xi9i/6v/LuFXg+PPU+q/h/lV/258f/aY8I3COwufkb1fn6n2I/H/buGbhXfh
94WXCt8ivKvws9m/92FwvPhAfx8V/q16BvbP7WrfoHZ71nvy+l4sfJfwM9n7
a5mum0p809+XhP+oxjyfHb+WB+eXN7LzzXfCs/g93e8j1q/GzhT+THhj4dbq
/1BjH8nOl88Gr+f31P+B8OPR++tN4bfZT9H777/Z8fPb4Ps9lx2/PwqOp59r
/CbCbYQ/Ym8LPyx8p67fXf0vZOfLFcH593/Z+XhNcLzZQOPXFf6Pxl8j/KHw
cuGnot/nE+EGws01/n1d+6lwQ+GWwh8Ifyy8kfC2wu8J36FrviYuEwPIXzpm
qD1V51qq7xrhScLjhJuVzpF1hNeLzp0bC9cVrkOcFq6tMZN17xN07mj1HZ/9
PfguV6qvFjlO7f4611P9Wfh04Z7CBwmvIzxa+Ajhw3hXYrZwP+Eewkn4NOEe
wgcK90u+9hD9/nrqq6NjivpP1LnBcBe1h6r9FferxozTucGFr+UZuXef6Gfn
Gp7t8Oh7tYKDaPxNOrdAfa3JwcLzWdPCf2pcreo3Do1+5gPV7hr9LrxjN+ED
ot99Y2JOMKeaoL42pfcye5pctT0cSXgBeyT5nQ8iX0XPxV+8Q3BMGKh2fZ27
llgufLbGbkiMIRYLj0nmQHChdsK7J+8h9gp7hr11kr7PBWqfrHvdWDoHkgvh
ULupv57wHGInMTuZU8AtyJm7CJ+s6y/jt3X93NIcaz3hdaPz+X654jvCy9Xu
nM03/9E93oWL6JrD1d5V5/ZKXnNPCc8rvBbXLx2ridmnCX+h+/xMPGAP6nxD
9c8jFhJzWdvC1xOrhc9N5ni11a4Vzf0aqH9u8DsfKly3dK4h54zQ2A1Y8+Rm
4VFwi+x7cw3Xfqn7/EK80/EEnEX4h8I5YInwcuHvC8/JYt5R+LvCv8c9eAfW
5jHR79aidO6cWzj3tyUGBMe8RcL76Nidudb4f/QsnYT3EN4Vkq+xnYU78K2E
Q+k9eh+5tvDehZPfw94rzNW3JMcSC4VnCDcipxF7eYdkTk382zCaa8MR4c4b
R3PHhnwT4drCnwpvQU4ltpGjmC/hBcGaYLLwvjo6svbggaU1w9LgGIOWYE2y
Ntuo/w9+r/Q8Mp/kVjTH3XCfwlqkfTLXbKnxv2t8U3IeXEfn5qhvp2Tu10L9
v6EFkrnkdnw34a1Kc7xLdO5K5pJr1G6r/j/V3y6Z2zYX/hVumMzdt2XdCdcj
Rgnn6PjdqIqv9aO1wGZVfK0n/EV23mavfqNjkM5tR87UuWtYQ8kxrDNrPzq2
NYdzqP9a1ov6ti3N1eAUcIsdSuducji5vR05LTin3k1uEZ4frNEuSo6p+6q9
d3Ss3YmcEpzDl6pvR3JWcI5eIrx5lT82gJtnc/othTeP5vpw/kbCm0Zrgc3g
ZME5Yhrfnxikdl10jvo3haOp/yJySrIGgu9vEq2N4OhbCG8Wzd03L82V4Exw
xZasYbW3Yl+pv4VwE+EthdcKt07Wgo2FfxRulazFtmZfZmsItN2/orUFa4Rn
OT967dRNNduoSNH5vg45RjhE58/uAn2EOxPbiY3CfYX3E+5ZOt6Tq7oI9yI2
Ch8uvK9wD2Kb8CBym3Af4b7CRwl3Ez68dP4hV/YWPlL4KHKmcC/hAcJHkKOE
DxbuK9xbeCC5T7h3ac71bjCHgIvBIdAiaBK4xVAdw9Tuq/ED1XdqMt8eLHyc
8AnJenWA8GDh45P5cH/ho0vHK2LvUOEThAcKHyvcQ7if8MHCvYU7CR9amrPC
XS8n1ql9bLK+PEL9g0pzxk+CNSlcEg74cbCmhhvCEeE+TxbmjoN0HKd2T13f
v3TOHizcXfgI4b10tAuOUcQq1gy56qzotURMI5aPiI517Hlyw+joWMAcMVeL
ovkjMZHcOSo6Vj6XrL/uiPYriEnkgzHRsYo9TOybUO1t9iixdHz03n02Wa/d
Hu1nsKeJvROj9/pxyfq/n/BRpWMouXxkdGxlj8IF5kTvXTgHsW5aNBeBIxDr
p0dzBzgEseXyaG4BZyH2XxzNZYgZ5NaZ0bGEGL5H8J4mtnfUuabBe5i9TEyZ
T+6IjjXECLjQrOjYQY4iVl0RnbvIYcTqKdG57cRkPXOk8BDhU5L13NHCxwoP
S9ZzRwkfU3pND9PvH1J4rZOjV6s9LDr/rkt8qjj+XdWeOkX40MJ7bR3ib6Uh
5qp/T+EuardTe//Se+5U9R9WeC+yhk6r+CdrC06zt9qtorkOHGgf4dbR3Ih8
1Ul4+2huxZ4cXvFR9mot8ifcWvhRjTm90k9Xqn2bxib1bxDsgXwa7dng3RDT
iG3rJ/t2MZqvn5rNNSYJ36yxBxETgjkB3OCUbC50kfoXlPY08Dbwd9qSX3hG
4d3IAex1jb9T7Rkav7Am8Ok3gz2PD6I9J/whch65bz0dUA3+QS8Q404I5rjE
PmLg8cIHFI6NxLzjhPcvHAtZQ43VXj96bbFHebaG0XsXDw1tg8bBW9sq2Z9p
wLdTXxu+ifA2wp1KzxHcdItq7oYn6/EhwseXzqd8iz2FDxHeLpmrNor2P/HA
1ur3/lvYG+Mc3ijPyFiuOTo4J3Mv5hBu2jR6brskr809hLuV5qxdhXeK5rLM
GXPdrJrL/ZPXZgfhg4W7E+OD19AByQdrsWN0H/ccGLwG+S2uGRS8BrkX35y5
3jl6LfBNmev20d+aHHVs8DORu9BkHYNzLFrtwdJrFI/zuGyPh3yBX4v3s4HO
nVRYQ6F/6goPKayZ0E71svkrGg+91F/X9BJ+MdofY4/1Cf5m7L0OOtqzltT/
V7ZmfTZaA6Nl8QjwCmoV9vLQiD/CdQtrx6Hwk2j+1F14Ex3jCnN8uP76wgMK
a0r0VZ1s/YZmRC/VztZ3aEr02JLSHu+71fs+UMWU34lB2RrmH/XXCdY284SX
Re+Pq5I9sDXRHhje2M7ZXiZ7enh2DjwmOOaQG4/M9jKISY8kexb4EvgTg9V3
dHabmPZi8u+9Dbdif2V7QnhteHx4RdcLvxLNSY5M9oeIj7U1Zlz1fHh1f+rc
0OxvgnfJN+RbDcnu+0vHMdma7+/o69GCNwi/Hh2zid3bZ3uhxIhhas8v7Yty
rme2R4RPwzsOxCsp7esyJ4cLXyv8QjSH3CT5m/JtiZHLyC+lPeIVhb3VjbPz
MxoWLdswOx+jcdG6XyevZXIWueub5Huzxlnrq5NjKTEV/slv1hN+PvpZvk+O
bcQ49MwffEPhXsH8ccvktbmRxn8t/G0y/+wUzOfXCm9buAaBPlqTzD+pAcD/
18nW+ycF67EyW7+fKAzRzNmxkxiKntu+ul8T/d5P6KlsLg1nhjv/kKxfqCHA
l79L5redg/k5MbFrcMwkVv6arKfQ/PDj35L1TY9g/vx7tR97BvPjjbL5ERof
rd9N/fsxf3qeUrhBNh9BE6ONN8vWFngYeBl4hq9VeoRaQX31n11Ys6NvN832
OtDoaPVG2fwbjYhWxBPGG8YzwztnzbFWX41ei/eU9jy+Zj/p2l/U36ZwzQE9
8mOyXqNmAL//KVn/UaNAn/ycrBepCaAvamXnenI+emtpaQ8Hj/8A9W2YzR/x
BPAG1suOb3hU6Kd1hQ8WPjlYz+Lx4fXhKeIl4gniveN54xXiKeMtw7HHJtd4
qPXAsc9J9qCZK+ZsenK8w7M6RvjNbA5+XrAGgJvD0c8P5sBwdzzCFRV/Jn/i
oeKl4jlSi8GjxquGw1+c7KnzbrwjXBmPGG8bjxPvGI8drx2NMCnZk8ebJ8dO
SfZA8ULxnPH64czLKv0Bl4bjkSuGVPEDzkstjxoHXBgOTe0P/wluTY2MWhnx
5rxkj3Z5xf+pDaIZxgZrKLQEHjdeN34ZtRM0zEXBmgltgyeOn4Z/gr8FJ5gU
rLHgCnjYeNl43tTW8MDR0+hf9AYah9xGjqvxaoSnBmuoM5JrZNTK4OyjhU8S
vjhY44xM1lhjgjUa2gtNR+4hB6H18IDxgvGkqbVRs6S2Sc2EWiYceEKwxoIb
ownODdaMaAU488RgTQSXpgZIbRLPn9ogNQI8B2oi72TXRKiNwLHHJ9dMqJ3A
wSfCD7O9UTzMAck5llyLx3iScG0dnxb27PDuyD/4qFxzUJXP8aI/IwZm53By
+eeFvT9iLrH3C+Eu2R72mop/Ee9HZNfv0HDwQWo01GqokVCr/hsOEByTOlb8
AC+ZGsCybE04MliToxWpcVEbQ7NR+6KmRe0MjUeta1Xys3ypo2uuanDB/gq1
RWpi+C1oKLQU8eGlaI3L/NTUUII1FFqK+PRatP/LfMHX6wV7gn2yOQRcAg+w
h9r38v2j+T/5FP5eN9gz7J3Nz76P1jfkR2pG+CFoSrQlNQZqfWhKag/LyVfB
NdYTs2sA1Dbg09QG7mO87reoMD+h5kRtDH+FWhQ5rktwDiL3wQHgAnAKtBc5
4IzgGEhuIEf1Ds6Z5C70zYbBnmi/bH1RP9ijPSKbX62O1mPwm/uFv4rWIPAh
OP6OwWsA7r95tneIh4WXFbP9q8HB/twu2XuVPYt+xdPrF6yH8Prw6NBHcHC4
OPONxlmrP72y5wMN9pNwX7SQ2tcV5ixwFzy//sEeK17gymT/iP8zgH8Mf/su
umZFLapjxR92jF6raKqcPAfMxazs2F0Ts9V3Qfaz8Yzw9ynZ/B0NhZaams3v
4QdorfOzuTQeOfoCvvVNtKakVjcuW5+g8eD/7bPrcXjI6PGdsmMhMRE/AM/0
yGBPFi8VjUltCM8P7flg9rfE56b+uTtrtrBniP/wQPa3LZP1bDvhmwvXLPAf
9sjOBeQEag3Ns/0JPFr8th2y/QRqKvgR07L1FBoeLY8HR+0NTxVvjpoUa3dl
dK0KT3dAsOeN1wsffT/6G85L9mSpreFh49Xumu2N4nHiV+yY7adQw8E/QTOH
5D3IXuyQXQvDU8Nb2y3bK8Vjxf9omu1v4FHj/1zJfBZVzC9dA8bzv7CwVwTH
41vyTdFuaPiYHCOIFdT4qSFwT7yTS7P1K/wEb2J2dq6vyamlOQfcA46Jtz4x
W0uiWdGufDO+3dzCtWw0AlyCmE3sviY7t5BDyCXXZedOciS58trs3EJOJbey
Jz6JXlPslTnZ9yNHkatuzM6N5EBy4czsXFXDWUprviHBexgteAMxsXBOJbde
kR27RwX7nZdn+6fEdGI7HBouDYem1jE5W9viMeA1wNnh7nBavODp2Xobjwev
55JsfY1Hg1cD54X7wonxiidlazU0M9r5quzcXcM54D7Z3KMmB5PrhbsX9qjw
qqhZMPd8g92rPcHeICYSGy/L1mojgv3SGdl+MZwAbjAhW9vjCaD/x2drfzQ/
2v9C4b0KewJ4A9TQ2lXxkvxKTCQ2di5cy0BjoDXQGNSKmmXXWqihUEtBA6AF
0Ah46/2Ffy1cA2Z/kSPQsqnKHcdmewVoZrQz9S1qM6xf1vGe2V4uHi5e7l7C
/y7s8eL18n/A2E+rov9v2AnZuQrNh/YjB6ItiypW753tReBJ4GVTI8SPrF+Y
f+BBUbvGn8Sb+iza/yLeEne3zfY7qTFRayLHoL3XqXLPb2qHYA36WHROQnvj
AZCryLloUzySmlxMLArWzOhqPAOeb201H9QIqLVT86F28CvvEjxn+H9tg//v
EvwInrQnvxXMQeBFmH17Fo7JxGb2AHuBNUItIGR/W9YYa401xFpijwys+N5b
0fkaL+DP5FxIfiEX/pMc64mZxM6/k2MnOY5c91dyriOHkkvhf3CZmro5uTKb
e7GH2ctb6phcuOZD7QfOA1dEo8GF3omudcJ58FHgTHBLNBZc6qtkr5n/c8f/
H/gwulZK/CUOUzOgdkDN7G32RjZXhDPiFW6VzYXgRPj7nYTfKOzp4e11y9aK
r1f6kXox/in7kX3ZMVsroZmoNeAR4BU0LuxVtsnmdnA8/GtyCrVCPA9yTevs
XEONDv8eTwBvoEnh2t+gbC/p22q9L83mgsR4Yv392dyDtQpXYE2yNtmDA9TX
NttfpwZOLbyF8MzCNV1qu3hQ+F94RHhFZ2bvDfYI/iqaH+2PR4pX2irbn6fm
SH1im2wvixoo9Y/G2fUIarjUG7bOrmdQE6Zesl12vYEaMrXkJtnzQQ2Z+sjd
2dw1VrmtZTZ3hkNT/7g+W3vV/J8Q4TuzuTA5kly5JJub8e3JxSuS9zbvw97H
48DrwIOhNrko2xtjbeHVoSFYHz9X8eSL5FoQMZJYuUDHqsIeF17X/wETb0pM

           "]], Polygon3DBox[CompressedData["
1:eJwt13fcl+MaAPD3fb0/TlRokUraWqS9pUXztKlIpaWp9ZKG0RBN7SntQaWl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           "]], 
          Polygon3DBox[{{1098, 718, 384, 385, 719, 1099}, {1196, 632, 430, 
           429, 728, 1103}, {1117, 748, 474, 475, 749, 1118}, {1094, 714, 369,
            370, 715, 1095}, {1200, 645, 445, 444, 734, 1106}, {1047, 619, 
           725, 1239, 896, 897}, {1137, 517, 304, 303, 710, 1090}, {1206, 658,
            460, 459, 741, 1110}, {1113, 744, 459, 460, 745, 1114}, {1124, 
           753, 489, 490, 754, 1125}}]},
         Annotation[#, "Charting`Private`Tag$2517#1"]& ]],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k0vXFEABuAzzCjjq4tGmmhHR1BpykJEGhkrsarVxEpXWLFAwoJf0DZp
0127aCzbxhp/AH/Ad30TC3uqvsVzWLz3ec/N3HPuOXey/SP54UQI4bPUKLFX
uxwxXRjCUz5nDV+zmW3sYBe72cMPHOAQxzguk/o3fuIUf3CavznHOS5yMT6b
DOGWWWuv8CWfyYmsGp9yjf+4zjNu8D//8pyb8X5BeNjEhWzFykvZ1q+4w2vu
8oZ7vOU+73jAC3MU6rVyaJxhVfyNd102XuIC5znLGf7iH37nT37kV36RCX2U
g+xjL/N8z07m2Mom1jMTz9Z5HPOVdSv5gk8kJxXG7SznO5bFb8LSOA/TbGFJ
3Ku9FOnFcf96Sm+Ocxm/ZRHfMMVGWjY00GuEOsbjvHRJJh7/H/dZf0Du
       "]]}, 
     {GrayLevel[0.2], 
      Line3DBox[{778, 1089, 1241, 992, 777, 1242, 993, 779, 1243, 994, 780, 
       1244, 995, 781, 1245, 996, 782, 1246, 997, 783, 1434, 1090, 1137, 1433,
        784, 1091, 1247, 998, 785, 1248, 999, 786, 1249, 1000, 787, 1250, 
       1001, 788, 1251, 1002, 789, 1252, 1003, 790, 1435, 1092, 1004, 1093}], 
      Line3DBox[{792, 1138, 1339, 791, 1253, 1005, 793, 1254, 1006, 794, 1255,
        1007, 795, 1256, 1008, 796, 1257, 1009, 797, 1258, 1139, 1340, 798, 
       1140, 1341, 799, 1259, 1010, 800, 1260, 1011, 801, 1261, 1012, 802, 
       1262, 1013, 803, 1263, 1014, 804, 1264, 1015, 805}], 
      Line3DBox[{807, 1141, 1342, 806, 1142, 1343, 808, 1265, 1016, 809, 1266,
        1017, 810, 1267, 1018, 811, 1268, 1019, 812, 1269, 1143, 1344, 813, 
       1144, 1345, 814, 1145, 1346, 815, 1270, 1020, 816, 1271, 1021, 817, 
       1272, 1022, 818, 1273, 1023, 819, 1274, 1024, 820}], 
      Line3DBox[{822, 1146, 1347, 821, 1147, 1348, 823, 1148, 1349, 824, 1275,
        1025, 825, 1276, 1026, 826, 1277, 1027, 827, 1278, 1149, 1350, 828, 
       1150, 1351, 829, 1151, 1352, 830, 1152, 1353, 831, 1279, 1028, 832, 
       1280, 1029, 833, 1281, 1030, 834, 1282, 1031, 835}], 
      Line3DBox[{837, 1153, 1354, 836, 1154, 1355, 838, 1155, 1356, 839, 1156,
        1357, 840, 1283, 1032, 841, 1284, 1033, 842, 1285, 1157, 1358, 843, 
       1158, 1359, 844, 1159, 1360, 845, 1160, 1361, 846, 1161, 1362, 847, 
       1286, 1034, 848, 1287, 1035, 849, 1288, 1036, 850}], 
      Line3DBox[{852, 1162, 1363, 851, 1163, 1364, 853, 1164, 1365, 854, 1165,
        1366, 855, 1166, 1367, 856, 1289, 1037, 857, 1436, 1094, 1095, 1458, 
       858, 1096, 1097, 1437, 859, 1167, 1368, 860, 1168, 1369, 861, 1169, 
       1370, 862, 1170, 1371, 863, 1290, 1038, 864, 1291, 1039, 865}], 
      Line3DBox[{867, 1171, 1372, 866, 1172, 1373, 868, 1173, 1374, 869, 1174,
        1375, 870, 1175, 1376, 871, 1176, 1377, 872, 1438, 1098, 1099, 1459, 
       873, 1100, 1378, 1236, 874, 1177, 1379, 875, 1178, 1380, 876, 1179, 
       1381, 877, 1180, 1382, 878, 1181, 1383, 879, 1292, 1040, 880}], 
      Line3DBox[{884, 1293, 1041, 882, 1294, 1042, 886, 1295, 1043, 888, 1296,
        1044, 890, 1297, 1045, 892, 1298, 1046, 894, 724, 1188, 1439, 1129, 
       1102, 1299, 1047, 897, 1300, 1048, 899, 1301, 1049, 901, 1302, 1050, 
       903, 1303, 1051, 905, 1304, 1052, 907, 1305, 1053, 909}], 
      Line3DBox[{908, 1398, 1194, 906, 1397, 1193, 904, 1396, 1192, 902, 1395,
        1191, 900, 1394, 1190, 898, 1393, 1189, 896, 1239, 1392, 1101, 895, 
       1238, 1391, 1390, 1237, 893, 1389, 1187, 891, 1388, 1186, 889, 1387, 
       1185, 887, 1386, 1184, 885, 1385, 1183, 881, 1384, 1182, 883}], 
      Line3DBox[{911, 1195, 1399, 910, 1306, 1054, 912, 1307, 1055, 913, 1308,
        1056, 914, 1309, 1057, 915, 1310, 1058, 916, 1441, 1103, 1196, 1440, 
       1130, 1104, 1197, 1442, 917, 1311, 1059, 918, 1312, 1060, 919, 1313, 
       1061, 920, 1314, 1062, 921, 1315, 1063, 922, 1316, 1064, 923}], 
      Line3DBox[{925, 1198, 1400, 924, 1199, 1401, 926, 1317, 1065, 927, 1318,
        1066, 928, 1319, 1067, 929, 1443, 1105, 1068, 1131, 1460, 1106, 1200, 
       1444, 1132, 1107, 1201, 1445, 1133, 1108, 1202, 1446, 930, 1320, 1069, 
       931, 1321, 1070, 932, 1322, 1071, 933, 1323, 1072, 934, 1324, 1073, 
       935}], Line3DBox[{937, 1203, 1402, 936, 1204, 1403, 938, 1205, 1404, 
       939, 1325, 1074, 940, 1326, 1075, 941, 1447, 1109, 1076, 1134, 1461, 
       1110, 1206, 1448, 1135, 1111, 1207, 1449, 1136, 1112, 1208, 1450, 942, 
       1209, 1405, 943, 1327, 1077, 944, 1328, 1078, 945, 1329, 1079, 946, 
       1330, 1080, 947}], 
      Line3DBox[{949, 1210, 1406, 948, 1211, 1407, 950, 1212, 1408, 951, 1213,
        1409, 952, 1331, 1081, 953, 1332, 1082, 954, 1451, 1113, 1114, 1462, 
       955, 1115, 1116, 1452, 956, 1214, 1410, 957, 1215, 1411, 958, 1216, 
       1412, 959, 1333, 1083, 960, 1334, 1084, 961, 1335, 1085, 962}], 
      Line3DBox[{964, 1217, 1413, 963, 1218, 1414, 965, 1219, 1415, 966, 1220,
        1416, 967, 1221, 1417, 968, 1336, 1086, 969, 1453, 1117, 1118, 1463, 
       970, 1119, 1120, 1454, 971, 1222, 1418, 972, 1223, 1419, 973, 1224, 
       1420, 974, 1225, 1421, 975, 1337, 1087, 976, 1338, 1088, 977}], 
      Line3DBox[{991, 1128, 1127, 1457, 990, 1432, 1235, 989, 1431, 1234, 988,
        1430, 1233, 987, 1429, 1232, 986, 1428, 1231, 985, 1240, 1427, 1126, 
       984, 1464, 1125, 1124, 1456, 983, 1426, 1230, 982, 1425, 1229, 981, 
       1424, 1228, 980, 1423, 1227, 979, 1422, 1226, 978, 1455, 1122, 1121, 
       1123}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{292, 512, 1242, 293, 525, 1253, 319, 1343, 540, 334, 1348, 
       555, 349, 1355, 570, 364, 1364, 585, 379, 1373, 599, 394, 1385, 613, 
       1294, 409, 627, 1306, 424, 1401, 641, 439, 1403, 654, 454, 1407, 667, 
       469, 1414, 681, 484, 1422, 695, 499}], 
      Line3DBox[{294, 513, 1243, 295, 526, 1254, 320, 541, 1265, 335, 1349, 
       556, 350, 1356, 571, 365, 1365, 586, 380, 1374, 600, 395, 1386, 614, 
       1295, 410, 628, 1307, 425, 642, 1317, 440, 1404, 655, 455, 1408, 668, 
       470, 1415, 682, 485, 1423, 696, 500}], 
      Line3DBox[{296, 514, 1244, 297, 527, 1255, 321, 542, 1266, 336, 557, 
       1275, 351, 1357, 572, 366, 1366, 587, 381, 1375, 601, 396, 1387, 615, 
       1296, 411, 629, 1308, 426, 643, 1318, 441, 656, 1325, 456, 1409, 669, 
       471, 1416, 683, 486, 1424, 697, 501}], 
      Line3DBox[{298, 515, 1245, 299, 528, 1256, 322, 543, 1267, 337, 558, 
       1276, 352, 573, 1283, 367, 1367, 588, 382, 1376, 602, 397, 1388, 616, 
       1297, 412, 630, 1309, 427, 644, 1319, 442, 657, 1326, 457, 670, 1331, 
       472, 1417, 684, 487, 1425, 698, 502}], 
      Line3DBox[{300, 516, 1246, 301, 529, 1257, 323, 544, 1268, 338, 559, 
       1277, 353, 574, 1284, 368, 589, 1289, 383, 1377, 603, 398, 1389, 617, 
       1298, 413, 631, 1310, 428, 730, 1443, 731, 443, 737, 1447, 738, 458, 
       671, 1332, 473, 685, 1336, 488, 1426, 699, 503}], 
      Line3DBox[{302, 708, 1434, 710, 303, 530, 1258, 324, 545, 1269, 339, 
       560, 1278, 354, 575, 1285, 369, 714, 1436, 716, 384, 718, 1438, 720, 
       399, 1390, 722, 724, 414, 726, 1441, 728, 429, 732, 768, 1460, 734, 
       444, 739, 771, 1461, 741, 459, 744, 1451, 746, 474, 748, 1453, 750, 
       489, 753, 1456, 755, 757}], 
      Line3DBox[{306, 519, 1248, 307, 533, 1259, 327, 1346, 548, 342, 1352, 
       563, 357, 1360, 578, 372, 1368, 592, 387, 1379, 606, 402, 1393, 620, 
       1300, 417, 634, 1311, 432, 736, 1446, 647, 447, 743, 1450, 660, 462, 
       1410, 674, 477, 1418, 688, 492, 1428, 702, 506}], 
      Line3DBox[{308, 520, 1249, 309, 534, 1260, 328, 549, 1270, 343, 1353, 
       564, 358, 1361, 579, 373, 1369, 593, 388, 1380, 607, 403, 1394, 621, 
       1301, 418, 635, 1312, 433, 648, 1320, 448, 1405, 661, 463, 1411, 675, 
       478, 1419, 689, 493, 1429, 703, 507}], 
      Line3DBox[{310, 521, 1250, 311, 535, 1261, 329, 550, 1271, 344, 565, 
       1279, 359, 1362, 580, 374, 1370, 594, 389, 1381, 608, 404, 1395, 622, 
       1302, 419, 636, 1313, 434, 649, 1321, 449, 662, 1327, 464, 1412, 676, 
       479, 1420, 690, 494, 1430, 704, 508}], 
      Line3DBox[{312, 522, 1251, 313, 536, 1262, 330, 551, 1272, 345, 566, 
       1280, 360, 581, 1286, 375, 1371, 595, 390, 1382, 609, 405, 1396, 623, 
       1303, 420, 637, 1314, 435, 650, 1322, 450, 663, 1328, 465, 677, 1333, 
       480, 1421, 691, 495, 1431, 705, 509}], 
      Line3DBox[{314, 523, 1252, 315, 537, 1263, 331, 552, 1273, 346, 567, 
       1281, 361, 582, 1287, 376, 596, 1290, 391, 1383, 610, 406, 1397, 624, 
       1304, 421, 638, 1315, 436, 651, 1323, 451, 664, 1329, 466, 678, 1334, 
       481, 692, 1337, 496, 1432, 706, 510}], 
      Line3DBox[{316, 712, 1435, 713, 317, 538, 1264, 332, 553, 1274, 347, 
       568, 1282, 362, 583, 1288, 377, 597, 1291, 392, 611, 1292, 407, 1398, 
       625, 1305, 422, 639, 1316, 437, 652, 1324, 452, 665, 1330, 467, 679, 
       1335, 482, 693, 1338, 497, 758, 1457, 759, 760}], 
      Line3DBox[{498, 694, 1455, 752, 483, 680, 1413, 468, 666, 1406, 453, 
       653, 1402, 438, 640, 1400, 423, 626, 1399, 408, 1293, 612, 1384, 393, 
       598, 1372, 378, 584, 1363, 363, 569, 1354, 348, 554, 1347, 333, 539, 
       1342, 318, 524, 1339, 291, 1241, 511, 707, 761}], 
      Line3DBox[{504, 700, 776, 1464, 754, 490, 686, 775, 1463, 749, 475, 672,
        774, 1462, 745, 460, 658, 1448, 772, 740, 445, 645, 1444, 769, 733, 
       430, 632, 1440, 767, 727, 415, 618, 1439, 766, 723, 1391, 400, 604, 
       765, 1459, 719, 385, 590, 764, 1458, 715, 370, 576, 1358, 355, 561, 
       1350, 340, 546, 1344, 325, 531, 1340, 304, 517, 1433, 709, 762}], 
      Line3DBox[{505, 701, 756, 1427, 491, 687, 1454, 751, 476, 673, 1452, 
       747, 461, 659, 1449, 773, 742, 446, 646, 1445, 770, 735, 431, 633, 
       1442, 729, 416, 1299, 619, 725, 1392, 401, 605, 721, 1378, 386, 591, 
       1437, 717, 371, 577, 1359, 356, 562, 1351, 341, 547, 1345, 326, 532, 
       1341, 305, 1247, 518, 711, 763}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxsvHk0ld///i+RkkqpkEQqKRVJaaCnIZmSJg0kQxJlSEIRGVJIIioZI1NJ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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["\"x \"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->{{-7, 1}, {-6, 4}, {0., 7.062498232142971}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8436997013598523`*^9},
 ExpressionUUID -> "f9da54cf-f545-4c0a-8729-a8de89717ab3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3.`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8436997014132214`*^9},
 ExpressionUUID -> "f7b85641-1729-485a-9d9b-2277f0aa6a00"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"grad", "[", 
    RowBox[{"xx_", ",", "yy_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"vyr", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[RuleDelayed]", "xx"}], ",", 
      RowBox[{"y", "\[RuleDelayed]", "yy"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", "0.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"k0", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hledej", "[", 
    RowBox[{"{", 
     RowBox[{"i_", ",", 
      RowBox[{"b", ":", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}]}], ",", "hodn_", ",", "k_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gr", ",", "newbod"}], "}"}], ",", 
     RowBox[{
      RowBox[{"gr", "=", 
       RowBox[{"grad", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ";", 
      RowBox[{"newbod", "=", 
       RowBox[{"b", "-", 
        RowBox[{"dx", "*", "k", "*", 
         FractionBox["gr", 
          RowBox[{"Norm", "[", "gr", "]"}]]}]}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "newbod", ",", 
        RowBox[{"vyr", "[", 
         RowBox[{"Sequence", "@@", "newbod"}], "]"}], ",", 
        RowBox[{"k", "*", "q"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poc", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"vyr", "[", 
      RowBox[{"4", ",", "5"}], "]"}], ",", "k0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"NestWhileList", "[", 
    RowBox[{"hledej", ",", "poc", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}], ">", "0.01"}], "&"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"dat", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", "b", "}"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Bold"}], "]"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "3"}], ",", "1"}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"dat", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"min", "[", 
  RowBox[{"[", "2", "]"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.51291652671875*^9, 3.512916536375*^9}, {
   3.512916577625*^9, 3.512916578171875*^9}, {3.5129166568125*^9, 
   3.512916739546875*^9}, {3.51291678884375*^9, 3.5129168789375*^9}, {
   3.512916913953125*^9, 3.512916964390625*^9}, {3.512917078265625*^9, 
   3.512917130875*^9}, {3.512917164609375*^9, 3.512917242546875*^9}, {
   3.5129172891875*^9, 3.51291739909375*^9}, {3.51291744190625*^9, 
   3.51291748215625*^9}, {3.51291751515625*^9, 3.5129175488125*^9}, {
   3.512917723765625*^9, 3.51291773278125*^9}, {3.51291810890625*^9, 
   3.512918160453125*^9}, {3.5129182040625*^9, 3.5129182528125*^9}, {
   3.512918288109375*^9, 3.512918419578125*^9}, {3.51291846996875*^9, 
   3.51291855353125*^9}, 3.512918588453125*^9, {3.512958628359375*^9, 
   3.512958675359375*^9}},
 ExpressionUUID -> "7da12926-cff1-41fb-a6b7-1fd4fcd7ea91"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[{{1., 5.}, {1., 5.}}]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{0.6119429999418673, 4.902985749985467}, {0.6119429999418673, 
      4.902985749985467}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{0.24509328952911474`, 4.803883328369849}, {
      0.24509328952911474`, 4.803883328369849}}]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.10133772040230743`, 
      4.7023621219256055`}, {-0.10133772040230743`, 4.7023621219256055`}}]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.42803634235565, 4.598041879816095}, {-0.42803634235565, 
      4.598041879816095}}]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-0.7355729797367725, 4.490484984757889}, {-0.7355729797367725,
       4.490484984757889}}]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-1.0243828100632106`, 
      4.379189018142047}, {-1.0243828100632106`, 4.379189018142047}}]}, 
    {RGBColor[1, 0.75, 0], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.294739078511094, 4.263581483193161}, {-1.294739078511094, 
      4.263581483193161}}]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.546717351054574, 4.143020515942196}, {-1.546717351054574, 
      4.143020515942196}}]}, 
    {RGBColor[0.571589, 0.586483, 0.], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.7801502268649738`, 
      4.016808949613396}, {-1.7801502268649738`, 4.016808949613396}}]}, 
    {RGBColor[0.915, 0.3325, 0.2125], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-1.994576009945535, 3.8842349155659894`}, {-1.994576009945535,
       3.8842349155659894`}}]}, 
    {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.18919518288633, 3.744660114440544}, {-2.18919518288633, 
      3.744660114440544}}]}, 
    {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
     PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.3628703578252854`, 
      3.5976829025819814`}, {-2.3628703578252854`, 3.5976829025819814`}}]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.5142402327851276`, 
      3.4433929001552355`}, {-2.5142402327851276`, 3.4433929001552355`}}]}, 
    {RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.6420443301759198`, 
      3.2826778485743597`}, {-2.6420443301759198`, 3.2826778485743597`}}]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.745699132781138, 3.117426574637587}, {-2.745699132781138, 
      3.117426574637587}}]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.8259451073366177`, 
      2.950385304891122}, {-2.8259451073366177`, 2.950385304891122}}]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.8851312214580256`, 
      2.784581681865062}, {-2.8851312214580256`, 2.784581681865062}}]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.926832472115632, 2.62261580876397}, {-2.926832472115632, 
      2.62261580876397}}]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.9550354889755233`, 
      2.4662532038799476`}, {-2.9550354889755233`, 2.4662532038799476`}}]}, 
    {RGBColor[0.772079, 0.431554, 0.102387], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.973412986305614, 2.316434692983255}, {-2.973412986305614, 
      2.316434692983255}}]}, 
    {RGBColor[0.363898, 0.618501, 0.782349], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{-2.984959471055754, 2.173505956403338}, {-2.984959471055754, 
      2.173505956403338}}]}, 
    {RGBColor[1, 0.75, 0], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.9919341388190253`, 
      2.037459973671054}, {-2.9919341388190253`, 2.037459973671054}}]}, 
    {RGBColor[0.647624, 0.37816, 0.614037], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.995956756766151, 1.9081090892497552`}, {-2.995956756766151,
       1.9081090892497552`}}]}, 
    {RGBColor[0.571589, 0.586483, 0.], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.9981459590205652`, 
      1.785185834917927}, {-2.9981459590205652`, 1.785185834917927}}]}, 
    {RGBColor[0.915, 0.3325, 0.2125], PointSize[0.012833333333333334`], 
     AbsoluteThickness[1.6], 
     PointBox[{{-2.99924905680324, 1.668395434504318}, {-2.99924905680324, 
      1.668395434504318}}]}, 
    {RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.9997476878796503`, 
      1.557440725675338}, {-2.9997476878796503`, 1.557440725675338}}]}, 
    {RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
     PointSize[0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.9999385292064606`, 
      1.4520328606483612`}, {-2.9999385292064606`, 1.4520328606483612`}}]}, 
    {RGBColor[0.736782672705901, 0.358, 0.5030266573755369], PointSize[
     0.012833333333333334`], AbsoluteThickness[1.6], 
     PointBox[{{-2.999992999043209, 1.351895239565806}, {-2.999992999043209, 
      1.351895239565806}}]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm]},
  AxesOrigin->{-3., 1.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[
    RGBColor[0, 0, 1], Bold],
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3., 1.}, {1., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.84369970156033*^9},
 ExpressionUUID -> "35c5796e-85ad-4074-a1db-69c9dd75cea6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"29", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.999992999043209`"}], ",", "1.351895239565806`"}], "}"}], 
   ",", "0.007739391239070596`", ",", "0.9513075410213284`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.843699701644944*^9},
 ExpressionUUID -> "425217e2-057a-4f3d-837a-3d50033a7bf8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "3.`"}]}], ",", 
   RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8436997017295732`*^9},
 ExpressionUUID -> "dfbe2212-68df-4c0d-b4d0-3c98dfbe5000"]
}, Open  ]]
},
WindowSize->{1006, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions -> {
 "VersionedStylesheet" -> {"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 2504, 72, 238, "Input"],
Cell[3074, 96, 231, 5, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3342, 106, 1948, 55, 263, "Input"],
Cell[5293, 163, 87597, 1429, 439, "Output"],
Cell[92893, 1594, 317, 9, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93247, 1608, 3846, 108, 696, "Input"],
Cell[97096, 1718, 7619, 150, 585, "Output"],
Cell[104718, 1870, 344, 9, 73, "Output"],
Cell[105065, 1881, 260, 7, 73, "Output"]
}, Open  ]]
}
]
*)

