(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9751,        313]
NotebookOptionsPosition[      9024,        283]
NotebookOutlinePosition[      9406,        299]
CellTagsIndexPosition[      9363,        296]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.87697457796875*^9, 3.876974580046875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", "x"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vyr", "[", "x0", "]"}], "\[Equal]", "f0"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "+", "\[CapitalDelta]x"}], "]"}], "\[Equal]", "f1"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"vyr", "[", "x", "]"}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"rce", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x0", ",", 
     RowBox[{"x0", "+", "\[CapitalDelta]x"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.876974585671875*^9, 3.876974700875*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"f0", " ", "\[CapitalDelta]x"}], "2"], "+", 
  FractionBox[
   RowBox[{"f1", " ", "\[CapitalDelta]x"}], "2"]}]], "Output",
 CellChangeTimes->{{3.876974656921875*^9, 3.87697470246875*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"trape", ",", "f"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"trape", "[", 
    RowBox[{"f_", ",", "a_", ",", "b_", ",", "nBodu_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xka", ",", "yka", ",", "\[CapitalDelta]x"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]x", "=", 
       FractionBox[
        RowBox[{"b", "-", "a"}], 
        RowBox[{"nBodu", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xka", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"a", ",", "b", ",", "\[CapitalDelta]x"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"yka", "=", 
       RowBox[{"f", "/@", "xka"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalDelta]x", "*", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{"yka", ",", "2", ",", "1"}], "]"}], "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"f0_", ",", "f1_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"0.5", "*", 
           RowBox[{"(", 
            RowBox[{"f0", "+", "f1"}], ")"}]}]}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"0.5", "Pi"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SuperscriptBox["#", "2"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"trape", "[", 
     RowBox[{"f", ",", "0.", ",", 
      RowBox[{"0.5", "Pi"}], ",", "n"}], "]"}], "-", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]}], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "*", 
  "100"}]}], "Input",
 CellChangeTimes->{{3.876974821140625*^9, 3.876974927140625*^9}, {
  3.876974988390625*^9, 3.876975313828125*^9}, {3.876975708921875*^9, 
  3.87697572678125*^9}}],

Cell[BoxData["0.25510204081631765`"], "Output",
 CellChangeTimes->{{3.876975024703125*^9, 3.876975077703125*^9}, 
   3.8769751116875*^9, {3.876975156546875*^9, 3.876975199625*^9}, {
   3.87697526225*^9, 3.876975314296875*^9}, {3.876975710734375*^9, 
   3.87697572725*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", "*", "x"}], "+", "c"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"vyr", "[", "x0", "]"}], "\[Equal]", "f0"}], ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "+", "\[CapitalDelta]x"}], "]"}], "\[Equal]", "fPlus"}], 
     ",", 
     RowBox[{
      RowBox[{"vyr", "[", 
       RowBox[{"x0", "-", "\[CapitalDelta]x"}], "]"}], "\[Equal]", 
      "fMinus"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"vyr", "[", "x", "]"}], "/.", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{"rce", ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x0", "-", "\[CapitalDelta]x"}], ",", 
     RowBox[{"x0", "+", "\[CapitalDelta]x"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.87697536115625*^9, 3.876975393375*^9}, {
  3.8769754469375*^9, 3.876975471734375*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", "f0", " ", "\[CapitalDelta]x"}], "3"], "+", 
  FractionBox[
   RowBox[{"fMinus", " ", "\[CapitalDelta]x"}], "3"], "+", 
  FractionBox[
   RowBox[{"fPlus", " ", "\[CapitalDelta]x"}], "3"]}]], "Output",
 CellChangeTimes->{3.876975476921875*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"homer", ",", "f"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"homer", "[", 
    RowBox[{"f_", ",", "a_", ",", "b_", ",", 
     RowBox[{"nBodu_", "?", "OddQ"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xka", ",", "yka", ",", "\[CapitalDelta]x"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[CapitalDelta]x", "=", 
       FractionBox[
        RowBox[{"b", "-", "a"}], 
        RowBox[{"nBodu", "-", "1"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xka", "=", 
       RowBox[{"Range", "[", 
        RowBox[{"a", ",", "b", ",", "\[CapitalDelta]x"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"yka", "=", 
       RowBox[{"f", "/@", "xka"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       FractionBox["\[CapitalDelta]x", "3"], "*", 
       RowBox[{"Total", "[", 
        RowBox[{
         RowBox[{"Partition", "[", 
          RowBox[{"yka", ",", "3", ",", "2"}], "]"}], "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"fM_", ",", "f0_", ",", "fP_"}], "}"}], "\[RuleDelayed]", 
          RowBox[{"fM", "+", 
           RowBox[{"4", "f0"}], "+", "fP"}]}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"0.5", "Pi"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SuperscriptBox["#", "3"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"homer", "[", 
     RowBox[{"f", ",", "0.", ",", 
      RowBox[{"0.5", "Pi"}], ",", "n"}], "]"}], "-", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]}], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]], "*", 
  "100"}]}], "Input",
 CellChangeTimes->{{3.876975587703125*^9, 3.87697567146875*^9}, {
  3.8769757780625*^9, 3.87697582640625*^9}}],

Cell[BoxData[
 RowBox[{"-", "1.4588838233016103`*^-14"}]], "Output",
 CellChangeTimes->{
  3.876975676015625*^9, {3.876975779203125*^9, 3.876975826671875*^9}}]
}, Open  ]]
},
WindowSize->{1040, 743},
WindowMargins->{{15, Automatic}, {57, Automatic}},
Magnification->1.8000001907348633`,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 395, 10, 117, "Input"],
Cell[CellGroupData[{
Cell[977, 34, 941, 29, 139, "Input"],
Cell[1921, 65, 237, 6, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2195, 76, 2325, 66, 520, "Input"],
Cell[4523, 144, 272, 4, 73, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4832, 153, 1361, 41, 172, "Input"],
Cell[6196, 196, 302, 8, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6535, 209, 2311, 66, 550, "Input"],
Cell[8849, 277, 159, 3, 75, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
