(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    256758,       4746]
NotebookOptionsPosition[    253958,       4693]
NotebookOutlinePosition[    254407,       4710]
CellTagsIndexPosition[    254364,       4707]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.907815635153624*^9, 3.9078156418721886`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "]"}]], "Input",
 CellChangeTimes->{{3.9078158287346816`*^9, 3.9078158329833727`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"5a97b88e-b039-42ca-8117-2c98e495c578"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"2023SestyPrednes.zip\"\>", ",", "\<\"baloonExps.nb\"\>", 
   ",", "\<\"panely1-3.nb\"\>", ",", "\<\"seriove mono.xlsx\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.907815834982924*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"93e82912-321c-4b10-a11b-0c52bbd41e72"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Import", "[", "\"\<seriove mono.xlsx\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"popis", "=", 
   RowBox[{"Take", "[", 
    RowBox[{"data2", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data3", "=", 
   RowBox[{"Drop", "[", 
    RowBox[{"data2", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data4", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"data3", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "<", "80000"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"test", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "c_", ",", "_", ",", "re_", " ", ",", "im_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{"f", "<", "80000"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data4", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"data3", ",", "test"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9078158855234623`*^9, 3.9078158959350214`*^9}, {
  3.9078159701906977`*^9, 3.907816036986946*^9}, {3.9078160739768467`*^9, 
  3.9078162264013424`*^9}, {3.9078162846112595`*^9, 3.9078162922191157`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"ddc318c0-180a-4586-b17e-44948ee56b1d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"z", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{"R", "*", 
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]]}], 
    RowBox[{"R", "+", 
     FractionBox["1", 
      RowBox[{"I", "*", "2.", "*", "Pi", "*", "f", "*", "c"}]]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "c_", ",", "_", ",", "re_", " ", ",", "im_"}], "}"}], 
    "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"re", "-", 
       RowBox[{"Re", "[", 
        RowBox[{"z", "[", "f", "]"}], "]"}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"im", "-", 
       RowBox[{"Im", "[", 
        RowBox[{"z", "[", "f", "]"}], "]"}]}], ")"}], "2"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errCelk", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"err", "/@", "data4"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"min", "=", 
   RowBox[{"NMinimize", "[", 
    RowBox[{"errCelk", ",", 
     RowBox[{"{", 
      RowBox[{"R", ",", "c"}], "}"}], ",", 
     RowBox[{"MaxIterations", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9078163573910985`*^9, 3.9078164143421307`*^9}, {
  3.9078164484434958`*^9, 3.907816506913829*^9}, {3.9078166189688015`*^9, 
  3.9078167397458534`*^9}, {3.907816909420459*^9, 3.9078169165283413`*^9}, {
  3.907816981508132*^9, 3.9078169856328735`*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"da5bb43b-63ea-4ba9-a152-64c717ca1811"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"data4", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "c_", ",", "_", ",", "re_", " ", ",", "im_"}], 
        "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"re", ",", "im"}], "}"}]}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Re[Z]\>\"", ",", "\"\<Im[Z]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"z", "[", "f", "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{"z", "[", "f", "]"}], "]"}]}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "20", ",", "60000"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9078167471869946`*^9, 3.9078168723395348`*^9}, 
   3.9078169319729214`*^9},
 CellLabel->
  "In[121]:=",ExpressionUUID->"2d0e33bb-89e6-48ee-bb86-adf151e43aa0"],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAAtOOG301CXkAuHAjJAoYTwC5ZFeEm
OV5ASl6dY0BWGMC/RpIgXC9eQNLGEWvxKR3AxEMYP40XXkCTNeohGl0jwKuz
WmCP+l1AgZVDi2wnKMCDwMqhRdZdQP32deCc0SzAM4y7QbSAXUBMx5xn7P8y
wFA0D2CRFV1A16IFaFthN8CW6gJeZpZcQE5hpYKKjjvAAAAAAAC4W0BLWBtj
J7BAwMReKGA7B1pARpVh3A3eRMDeOZShKiRYQIfe4uE9KUjA9+rjoe8vVkDg
LZCg+JlKwKqezD/6aVJAnPwWnSxbTcCCPLt860FOQMP1KFyPEk7A9+Rhodbc
SEAIBhA+lJZNwPLSTWIQIEFAX9BCAkYVS8B1kxgEVn44QNYe9kIBJUjAPSzU
muYtMkBaZDvfT3VFwBfUt8zpMh1AT0ATYcODPMB72uGvyRoLQLpJDAIrpzPA
svShC+pb9D99PzVeuuknwMx6MZQT7eA/qaROQBPBHcAgKLfte9TWPyntDb4w
mRfAipRm8zgMyD+7Jw8LtWYOwMmP+BVruMA/D9HoDmKnBcCID+z4LxC4P//P
Yb68gPi/ETY8vVKWtT+zsRLzrKTrv58B9WbUfLU/D4C4q1eR2b+rItxkVBm2
PxL1gk9z8qK/ieHgpA==
       "]]}, {
      {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6]}, {}}, {
      {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[
       1.6]}, {}}}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwVkmk41Hsfhwc5tNlVnhMZkyUkxr7+fvZlGJFd9pBSKMuhRRMysiftesQp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        "]]},
      Annotation[#, "Charting`Private`Tag$313262#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Re[Z]\"", TraditionalForm], 
    FormBox["\"Im[Z]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->
   FrontEndValueCache[{
    Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& , 
     Charting`ScaledTickValues[{Identity, Identity}][#, #2, {6, 6}]& }, {{{0., 
       Directive[
        AbsoluteThickness[0.1]]}, {25., 
       Directive[
        AbsoluteThickness[0.1]]}, {50., 
       Directive[
        AbsoluteThickness[0.1]]}, {75., 
       Directive[
        AbsoluteThickness[0.1]]}, {100., 
       Directive[
        AbsoluteThickness[0.1]]}, {-25., 
       Directive[
        AbsoluteThickness[0.1]]}, {-20., 
       Directive[
        AbsoluteThickness[0.1]]}, {-15., 
       Directive[
        AbsoluteThickness[0.1]]}, {-10., 
       Directive[
        AbsoluteThickness[0.1]]}, {-5., 
       Directive[
        AbsoluteThickness[0.1]]}, {5., 
       Directive[
        AbsoluteThickness[0.1]]}, {10., 
       Directive[
        AbsoluteThickness[0.1]]}, {15., 
       Directive[
        AbsoluteThickness[0.1]]}, {20., 
       Directive[
        AbsoluteThickness[0.1]]}, {30., 
       Directive[
        AbsoluteThickness[0.1]]}, {35., 
       Directive[
        AbsoluteThickness[0.1]]}, {40., 
       Directive[
        AbsoluteThickness[0.1]]}, {45., 
       Directive[
        AbsoluteThickness[0.1]]}, {55., 
       Directive[
        AbsoluteThickness[0.1]]}, {60., 
       Directive[
        AbsoluteThickness[0.1]]}, {65., 
       Directive[
        AbsoluteThickness[0.1]]}, {70., 
       Directive[
        AbsoluteThickness[0.1]]}, {80., 
       Directive[
        AbsoluteThickness[0.1]]}, {85., 
       Directive[
        AbsoluteThickness[0.1]]}, {90., 
       Directive[
        AbsoluteThickness[0.1]]}, {95., 
       Directive[
        AbsoluteThickness[0.1]]}, {105., 
       Directive[
        AbsoluteThickness[0.1]]}, {110., 
       Directive[
        AbsoluteThickness[0.1]]}, {115., 
       Directive[
        AbsoluteThickness[0.1]]}, {120., 
       Directive[
        AbsoluteThickness[0.1]]}, {125., 
       Directive[
        AbsoluteThickness[0.1]]}}, {{-60., 
       Directive[
        AbsoluteThickness[0.1]]}, {-40., 
       Directive[
        AbsoluteThickness[0.1]]}, {-20., 
       Directive[
        AbsoluteThickness[0.1]]}, {0., 
       Directive[
        AbsoluteThickness[0.1]]}, {-80., 
       Directive[
        AbsoluteThickness[0.1]]}, {-75., 
       Directive[
        AbsoluteThickness[0.1]]}, {-70., 
       Directive[
        AbsoluteThickness[0.1]]}, {-65., 
       Directive[
        AbsoluteThickness[0.1]]}, {-55., 
       Directive[
        AbsoluteThickness[0.1]]}, {-50., 
       Directive[
        AbsoluteThickness[0.1]]}, {-45., 
       Directive[
        AbsoluteThickness[0.1]]}, {-35., 
       Directive[
        AbsoluteThickness[0.1]]}, {-30., 
       Directive[
        AbsoluteThickness[0.1]]}, {-25., 
       Directive[
        AbsoluteThickness[0.1]]}, {-15., 
       Directive[
        AbsoluteThickness[0.1]]}, {-10., 
       Directive[
        AbsoluteThickness[0.1]]}, {-5., 
       Directive[
        AbsoluteThickness[0.1]]}, {5., 
       Directive[
        AbsoluteThickness[0.1]]}, {10., 
       Directive[
        AbsoluteThickness[0.1]]}, {15., 
       Directive[
        AbsoluteThickness[0.1]]}, {20., 
       Directive[
        AbsoluteThickness[0.1]]}}}],
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 121.036003}, {-60.145, 0}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.907816744953125*^9, 3.907816788095253*^9, {3.907816864466379*^9, 
   3.9078168728393764`*^9}, 3.907816932566521*^9, 3.907816989013583*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"4f4c78c4-8439-4829-871e-b3aa220c5ec5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "[", "40000", "]"}], "/.", 
  RowBox[{"min", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9078169933722076`*^9, 3.907817019967065*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"333d1cd7-8319-4257-9d1f-a44c10f0a893"],

Cell[BoxData[
 RowBox[{"0.018891432905469213`", "\[VeryThinSpace]", "-", 
  RowBox[{"1.5116943657585082`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.907816994361167*^9, 3.907817020654133*^9}},
 CellLabel->
  "Out[126]=",ExpressionUUID->"e3c8acc5-4e5a-484b-9117-743c7c0dde94"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"linearni", " ", "regrese"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"vyr", "[", "x_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"2", "x"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", "0.5"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"vyr", "[", "x", "]"}], "+", "rn"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "4", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Re[Z]\>\"", ",", "\"\<Im[Z]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"y", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"b", "*", "x"}], "+", "c"}], ")"}]}], ")"}], "2"]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errCelk", "=", 
   RowBox[{"Simplify", "@", 
    RowBox[{"Total", "[", 
     RowBox[{"err", "/@", "data"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rceMinimum", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"0", "\[Equal]", 
      RowBox[{"D", "[", 
       RowBox[{"errCelk", ",", "#"}], "]"}]}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "*", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"b", "*", "x"}], "+", "c"}], "/.", 
  RowBox[{
   RowBox[{"Solve", "[", "rceMinimum", "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "x", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", "x"}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.9078175313735275`*^9, {3.907817847330029*^9, 3.9078178937098885`*^9}, {
   3.907817928751322*^9, 3.907818002856*^9}, {3.9078183040506334`*^9, 
   3.9078183119748716`*^9}, {3.9078183530262365`*^9, 3.907818377153924*^9}, {
   3.907818483486945*^9, 3.907818588254405*^9}, {3.907818628541792*^9, 
   3.9078186688129787`*^9}, {3.9078187435922775`*^9, 3.907818815635786*^9}, {
   3.907818851908433*^9, 3.9078188955031276`*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"2ffb0e04-fcff-40f6-9ffc-a6eb593e951f"],

Cell[BoxData[
 RowBox[{"0.8451740992703548`", "\[VeryThinSpace]", "-", 
  RowBox[{"2.0725987914979473`", " ", "x"}], "+", 
  RowBox[{"1.0498786419429866`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 CellChangeTimes->{{3.9078186291819897`*^9, 3.9078186691877174`*^9}, 
   3.9078187658452625`*^9, 3.9078188161825285`*^9, {3.907818852417424*^9, 
   3.9078188962529125`*^9}},
 CellLabel->
  "Out[286]=",ExpressionUUID->"6b4fc728-27cb-4198-9f1c-c79a48eb1369"],

Cell[BoxData[
 RowBox[{"0.8451740992703541`", "\[VeryThinSpace]", "-", 
  RowBox[{"2.072598791497947`", " ", "x"}], "+", 
  RowBox[{"1.0498786419429866`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 CellChangeTimes->{{3.9078186291819897`*^9, 3.9078186691877174`*^9}, 
   3.9078187658452625`*^9, 3.9078188161825285`*^9, {3.907818852417424*^9, 
   3.907818896268567*^9}},
 CellLabel->
  "Out[287]=",ExpressionUUID->"dcb28d59-a611-4b66-86f9-92a64fd4cd00"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", "12"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"L", "=", "0.033"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", "t_", "]"}], ":=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "30"], 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["i", 
        FractionBox["3", "2"]], "+", "1"}]], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"i", "*", "2", "*", "Pi", "*", "f", "*", "t"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "0.04"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"u", "[", "t", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rce", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"R", "*", 
        RowBox[{"i", "[", "t", "]"}]}], "+", 
       RowBox[{"L", "*", 
        RowBox[{
         RowBox[{"i", "'"}], "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"i", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{"rce", ",", "i", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rn", ":=", 
   RowBox[{
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]], "*", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "0.5"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"u", "[", "t", "]"}], "+", "rn"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"0.1", "rn"}], "+", 
         RowBox[{"i", "[", "t", "]"}]}], "/.", "sol"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", 
       FractionBox["tmax", "2000"]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", ">>", "\"\<data\>\""}], ";"}]}], "Input",
 CellChangeTimes->{
  3.9078190836953244`*^9, {3.907819116484688*^9, 3.9078193852128325`*^9}, {
   3.9078194225632544`*^9, 3.907819429891361*^9}, {3.9078194861918135`*^9, 
   3.9078194931748385`*^9}, 3.907819947825817*^9, {3.907820005090854*^9, 
   3.9078200721075034`*^9}, {3.9078202031126175`*^9, 3.9078202172135487`*^9}},
 CellLabel->
  "In[563]:=",ExpressionUUID->"30f1e764-ee14-418f-85d2-3bb608491201"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"<<", "\"\<data\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nAV", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intProud", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"MovingAverage", "[", 
     RowBox[{
      RowBox[{"data", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "i"}], "}"}]}]}], ",", "nAV"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intNapeti", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"MovingAverage", "[", 
     RowBox[{
      RowBox[{"data", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t_", ",", "u_", ",", "i_"}], "}"}], "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"t", ",", "u"}], "}"}]}]}], ",", "nAV"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"intNapeti", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "tmin", ",", "tmax"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"intNapeti", "[", "t", "]"}], ",", 
    RowBox[{"intProud", "[", "t", "]"}], ",", 
    RowBox[{
     RowBox[{"intProud", "'"}], "[", "t", "]"}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.907819473085805*^9, 3.907819508692231*^9}, {
  3.9078196028731737`*^9, 3.907819874327511*^9}, {3.907820099139882*^9, 
  3.907820170198553*^9}, {3.907820767518684*^9, 3.907820808989231*^9}},
 CellLabel->
  "In[626]:=",ExpressionUUID->"3e2701b2-eabd-4092-b5b1-ef8880a0579c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVV3k4VV8XVkoSpUKGCKUkyhySJaQiQzKTIYpkLI0qQzRIuLNKye/eJKEB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         "]]},
       Annotation[#, "Charting`Private`Tag$348944#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.00009000000000000002, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0.00009000000000000002, 
     0.03991000000000001}, {-0.7013721329847561, 0.7013631861981426}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwVmXc41e8bx5UIadASklkZSagQvQstSTSUlZW9t0pkJJnlHOMczsFZUTJL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         "]]},
       Annotation[#, "Charting`Private`Tag$348991#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.00009000000000000002, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0.00009000000000000002, 
     0.03991000000000001}, {-0.04452636549739736, 0.03754948582073487}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwUV3c81e8XV7I3dyHZMjMqiXI+xbdkFBFC9iay97xcM7uyMqIoEkVl1H1I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         "]]},
       Annotation[#, "Charting`Private`Tag$349038#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0.00009000000000000002, 0},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
       Charting`ScaledFrameTicks[{Identity, Identity}]}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{{0.00009000000000000002, 
     0.03991000000000001}, {-8.277402298432014, 31.13536726363024}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9078201533768597`*^9, 3.9078201719009037`*^9}, {
  3.9078202064035606`*^9, 3.9078202326161327`*^9}, {3.9078208001456704`*^9, 
  3.907820809380724*^9}},
 CellLabel->
  "Out[631]=",ExpressionUUID->"fc99d001-b74e-44bc-aac7-1e3819f69354"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataProFit", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"intProud", "[", "t", "]"}], ",", 
         RowBox[{
          RowBox[{"intProud", "'"}], "[", "t", "]"}], ",", 
         RowBox[{"intNapeti", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "tmin", ",", "tmax", ",", 
         FractionBox[
          RowBox[{"tmax", "-", "tmin"}], "200"]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{"dataProFit", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "deri"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "deri"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<R= \>\"", ",", 
     RowBox[{"D", "[", 
      RowBox[{"fit", ",", "i"}], "]"}], ",", "\"\< \[CapitalOmega]   L= \>\"",
      ",", 
     RowBox[{"D", "[", 
      RowBox[{"fit", ",", "deri"}], "]"}], ",", "\"\< H\>\""}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.907819473085805*^9, 3.907819508692231*^9}, {
  3.9078196028731737`*^9, 3.907819874327511*^9}, {3.907820099139882*^9, 
  3.9078201237745028`*^9}},
 CellLabel->
  "In[632]:=",ExpressionUUID->"00d1aba1-6393-4a13-8ee6-56fc2523beb1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"R= \"\>", "\[InvisibleSpace]", "11.99952738990489`", 
   "\[InvisibleSpace]", "\<\" \[CapitalOmega]   L= \"\>", "\[InvisibleSpace]",
    "0.03291988184749521`", "\[InvisibleSpace]", "\<\" H\"\>"}],
  SequenceForm[
  "R= ", 11.99952738990489, " \[CapitalOmega]   L= ", 0.03291988184749521, 
   " H"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9078198748742514`*^9, 3.907819954511771*^9, 3.9078200087887015`*^9, {
   3.9078200667022085`*^9, 3.9078200756608295`*^9}, 3.907820814473274*^9},
 CellLabel->
  "During evaluation of \
In[632]:=",ExpressionUUID->"119f5219-7f6e-43c6-a0e5-f11edc3dc67f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pom", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["t", "#"], ",", 
      SubscriptBox["i", "#"]}], "}"}], "&"}], "/@", 
   RowBox[{"Range", "[", "10", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"MovingAverage", "[", 
  RowBox[{"pom", ",", "3"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{
  3.9078197630424466`*^9, {3.907820388692336*^9, 3.907820459457223*^9}, {
   3.907820497898486*^9, 3.9078205153780975`*^9}},
 CellLabel->
  "In[591]:=",ExpressionUUID->"7a53ee1f-6923-41b0-a4b9-e3e9e2983d6d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "1"], ",", 
     SubscriptBox["i", "1"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "2"], ",", 
     SubscriptBox["i", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "3"], ",", 
     SubscriptBox["i", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "4"], ",", 
     SubscriptBox["i", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "5"], ",", 
     SubscriptBox["i", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "6"], ",", 
     SubscriptBox["i", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "7"], ",", 
     SubscriptBox["i", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "8"], ",", 
     SubscriptBox["i", "8"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "9"], ",", 
     SubscriptBox["i", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["t", "10"], ",", 
     SubscriptBox["i", "10"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.907820423871253*^9, 3.907820460082019*^9}, {
  3.9078205062304397`*^9, 3.9078205160498*^9}},
 CellLabel->
  "Out[591]=",ExpressionUUID->"3b3e1f16-ed6f-482b-a8bf-0981c4bd2eb2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "1"], "+", 
        SubscriptBox["t", "2"], "+", 
        SubscriptBox["t", "3"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "1"], "+", 
        SubscriptBox["i", "2"], "+", 
        SubscriptBox["i", "3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "2"], "+", 
        SubscriptBox["t", "3"], "+", 
        SubscriptBox["t", "4"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "2"], "+", 
        SubscriptBox["i", "3"], "+", 
        SubscriptBox["i", "4"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "3"], "+", 
        SubscriptBox["t", "4"], "+", 
        SubscriptBox["t", "5"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "3"], "+", 
        SubscriptBox["i", "4"], "+", 
        SubscriptBox["i", "5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "4"], "+", 
        SubscriptBox["t", "5"], "+", 
        SubscriptBox["t", "6"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "4"], "+", 
        SubscriptBox["i", "5"], "+", 
        SubscriptBox["i", "6"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "5"], "+", 
        SubscriptBox["t", "6"], "+", 
        SubscriptBox["t", "7"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "5"], "+", 
        SubscriptBox["i", "6"], "+", 
        SubscriptBox["i", "7"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "6"], "+", 
        SubscriptBox["t", "7"], "+", 
        SubscriptBox["t", "8"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "6"], "+", 
        SubscriptBox["i", "7"], "+", 
        SubscriptBox["i", "8"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "7"], "+", 
        SubscriptBox["t", "8"], "+", 
        SubscriptBox["t", "9"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "7"], "+", 
        SubscriptBox["i", "8"], "+", 
        SubscriptBox["i", "9"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["t", "8"], "+", 
        SubscriptBox["t", "9"], "+", 
        SubscriptBox["t", "10"]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["i", "8"], "+", 
        SubscriptBox["i", "9"], "+", 
        SubscriptBox["i", "10"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.907820423871253*^9, 3.907820460082019*^9}, {
  3.9078205062304397`*^9, 3.9078205160498*^9}},
 CellLabel->
  "Out[592]=",ExpressionUUID->"9cca5a93-a7c2-4f01-85ab-39775ebf37ca"],

Cell[BoxData["8"], "Output",
 CellChangeTimes->{{3.907820423871253*^9, 3.907820460082019*^9}, {
  3.9078205062304397`*^9, 3.907820516065385*^9}},
 CellLabel->
  "Out[593]=",ExpressionUUID->"24602ca3-da47-4ea1-8244-168a691ea241"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "+", 
        RowBox[{"0.1", "*", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       FractionBox["Pi", "3000."]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"MovingAverage", "[", 
    RowBox[{"data2", ",", "200"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"-", "1.2"}], ",", "1.2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9078202601808157`*^9, 3.9078203412501163`*^9}, {
  3.9078205808314133`*^9, 3.907820652373947*^9}},
 CellLabel->
  "In[612]:=",ExpressionUUID->"28545485-f982-4628-9564-8860ceab7557"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJwUV3c81e8XJ2koiTIbUiQlGSWlvDXRpkFSSBJRpFKUlIqUjEKhpEh8i6yy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      "]]}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[
      1.6]}, {}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
       NCache[
        Rational[1, 360], 0.002777777777777778]], AbsoluteThickness[
      1.6]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 6.178989150835526}, {-0.9962946460564286, 
    1.0011111303662648`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.907820341687498*^9, {3.9078205964333277`*^9, 3.9078206526238885`*^9}},
 CellLabel->
  "Out[613]=",ExpressionUUID->"19f211e1-f5fd-4b34-a30b-cab8c74d82d7"]
}, Open  ]]
},
WindowSize->{1068, 636},
WindowMargins->{{1, Automatic}, {Automatic, 9}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>1.7 Inherited,
FrontEndVersion->"12.0 for Microsoft Windows (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 476, 11, 115, "Input",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],
Cell[CellGroupData[{
Cell[1059, 35, 205, 3, 48, "Input",ExpressionUUID->"5a97b88e-b039-42ca-8117-2c98e495c578"],
Cell[1267, 40, 310, 6, 55, "Output",ExpressionUUID->"93e82912-321c-4b10-a11b-0c52bbd41e72"]
}, Open  ]],
Cell[1592, 49, 1449, 40, 248, "Input",ExpressionUUID->"ddc318c0-180a-4586-b17e-44948ee56b1d"],
Cell[3044, 91, 1629, 47, 251, "Input",ExpressionUUID->"da5bb43b-63ea-4ba9-a152-64c717ca1811"],
Cell[CellGroupData[{
Cell[4698, 142, 1455, 42, 182, "Input",ExpressionUUID->"2d0e33bb-89e6-48ee-bb86-adf151e43aa0"],
Cell[6156, 186, 9542, 230, 412, "Output",ExpressionUUID->"4f4c78c4-8439-4829-871e-b3aa220c5ec5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15735, 421, 287, 7, 49, "Input",ExpressionUUID->"333d1cd7-8319-4257-9d1f-a44c10f0a893"],
Cell[16025, 430, 292, 5, 76, "Output",ExpressionUUID->"e3c8acc5-4e5a-484b-9117-743c7c0dde94"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16354, 440, 3314, 97, 487, "Input",ExpressionUUID->"2ffb0e04-fcff-40f6-9ffc-a6eb593e951f"],
Cell[19671, 539, 462, 9, 76, "Output",ExpressionUUID->"6b4fc728-27cb-4198-9f1c-c79a48eb1369"],
Cell[20136, 550, 459, 9, 76, "Output",ExpressionUUID->"dcb28d59-a611-4b66-86f9-92a64fd4cd00"]
}, Open  ]],
Cell[20610, 562, 2952, 90, 498, "Input",ExpressionUUID->"30f1e764-ee14-418f-85d2-3bb608491201"],
Cell[CellGroupData[{
Cell[23587, 656, 1850, 53, 248, "Input",ExpressionUUID->"3e2701b2-eabd-4092-b5b1-ef8880a0579c"],
Cell[25440, 711, 99132, 1680, 430, "Output",ExpressionUUID->"fc99d001-b74e-44bc-aac7-1e3819f69354"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124609, 2396, 1390, 39, 228, "Input",ExpressionUUID->"00d1aba1-6393-4a13-8ee6-56fc2523beb1"],
Cell[126002, 2437, 653, 14, 37, "Print",ExpressionUUID->"119f5219-7f6e-43c6-a0e5-f11edc3dc67f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126692, 2456, 613, 16, 116, "Input",ExpressionUUID->"7a53ee1f-6923-41b0-a4b9-e3e9e2983d6d"],
Cell[127308, 2474, 1343, 46, 110, "Output",ExpressionUUID->"3b3e1f16-ed6f-482b-a8bf-0981c4bd2eb2"],
Cell[128654, 2522, 3925, 134, 259, "Output",ExpressionUUID->"9cca5a93-a7c2-4f01-85ab-39775ebf37ca"],
Cell[132582, 2658, 228, 4, 76, "Output",ExpressionUUID->"24602ca3-da47-4ea1-8244-168a691ea241"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132847, 2667, 1111, 33, 114, "Input",ExpressionUUID->"28545485-f982-4628-9564-8860ceab7557"],
Cell[133961, 2702, 119981, 1988, 413, "Output",ExpressionUUID->"19f211e1-f5fd-4b34-a30b-cab8c74d82d7"]
}, Open  ]]
}
]
*)

