(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     18301,        428]
NotebookOptionsPosition[     17039,        399]
NotebookOutlinePosition[     17487,        416]
CellTagsIndexPosition[     17444,        413]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.907380717575177*^9, 3.9073807294189267`*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"file", "=", 
   RowBox[{
    RowBox[{"FileNames", "[", "\"\<*.xlsx\>\"", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Import", "[", "file", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data1", ">>", "\"\<data1\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.907380842517291*^9, 3.9073808824704156`*^9}, {
  3.907381181728408*^9, 3.9073812357910013`*^9}, {3.9073837654366665`*^9, 
  3.9073837815928683`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"d4d8943b-3cf7-4582-8230-99862e2ddb58"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"<<", "\"\<data1\>\""}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"data1", "[", 
    RowBox[{"[", 
     StyleBox["8",
      FontColor->RGBColor[1, 0, 0]], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"info", "=", 
   RowBox[{"data2", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Drop", "[", 
       RowBox[{"data2", ",", "2"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", "60000"}], "&"}]}], 
     "]"}], "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f_", ",", "_", ",", "_", ",", "R_", ",", "X_"}], "}"}], 
     "\[RuleDelayed]", 
     RowBox[{"{", 
      RowBox[{"f", ",", "R", ",", "X"}], "}"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Z", "[", "f_", "]"}], ":=", 
   FractionBox[
    RowBox[{"R", "*", 
     FractionBox["1", 
      RowBox[{"I", "*", "2", "*", "Pi", "*", "f", "*", "c"}]]}], 
    RowBox[{"R", "+", 
     FractionBox["1", 
      RowBox[{"I", "*", "2", "*", "Pi", "*", "f", "*", "c"}]]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"norm", ":=", 
   RowBox[{
    SuperscriptBox["#", "2"], "&"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"err", "[", 
    RowBox[{"{", 
     RowBox[{"f_", ",", "R_", ",", "X_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"norm", "[", 
     RowBox[{"R", "-", 
      RowBox[{"Re", "[", 
       RowBox[{"Z", "[", "f", "]"}], "]"}]}], "]"}], "+", 
    RowBox[{"norm", "[", 
     RowBox[{"X", "-", 
      RowBox[{"Im", "[", 
       RowBox[{"Z", "[", "f", "]"}], "]"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errCelk", "=", 
   RowBox[{"Total", "[", 
    RowBox[{"err", "/@", "data"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"min", "=", 
  RowBox[{"NMinimize", "[", 
   RowBox[{"errCelk", ",", 
    RowBox[{"{", 
     RowBox[{"R", ",", "c"}], "}"}], ",", 
    RowBox[{"MaxIterations", "\[Rule]", "200"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.9073812435253415`*^9, 3.907381288337862*^9}, {
   3.9073813354940925`*^9, 3.9073813639748993`*^9}, {3.9073813971623955`*^9, 
   3.9073814570998993`*^9}, {3.9073814973811717`*^9, 
   3.9073815505758915`*^9}, {3.9073817716329613`*^9, 3.907381947575411*^9}, {
   3.9073821181419373`*^9, 3.9073821697825623`*^9}, {3.907382341151736*^9, 
   3.907382481047555*^9}, 3.907383823467909*^9, 3.9073839754124427`*^9, {
   3.9073840150061736`*^9, 3.9073840224905677`*^9}, 3.9073848902665277`*^9, 
   3.907384970454007*^9, 3.9073851076776276`*^9},
 CellLabel->
  "In[191]:=",ExpressionUUID->"a68d359c-ad4e-4584-98db-abe11c5a37a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"484642.76953739504`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"R", "\[Rule]", "19427.66520880013`"}], ",", 
     RowBox[{"c", "\[Rule]", "2.55214833995972`*^-7"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9073824467349925`*^9, 3.9073824897662854`*^9, {3.9073837731709614`*^9, 
   3.9073837859834614`*^9}, 3.9073838292647495`*^9, {3.907383977256136*^9, 
   3.907383993099883*^9}, {3.907384023928007*^9, 3.9073840291779876`*^9}, 
   3.907384905094632*^9, {3.9073849716571703`*^9, 3.9073849778290844`*^9}, 
   3.907385112880744*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"f806d961-1737-4f20-922a-3d5b600905b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pl1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"Z", "[", "f", "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{"Z", "[", "f", "]"}], "]"}]}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", "20", ",", 
       SuperscriptBox["10", "5"]}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Re[Z]\>\"", ",", "\"\<Im[Z]\>\""}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "200"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pl2", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"data", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_", ",", "R_", ",", "X_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"R", ",", "X"}], "}"}]}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.015", "]"}], ",", "Red"}], "}"}]}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"pl1", ",", "pl2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.907382671995014*^9, 3.907382804104479*^9}, {
  3.9073828345566745`*^9, 3.9073829644160724`*^9}, {3.9073840443967967`*^9, 
  3.907384056974896*^9}},
 CellLabel->
  "In[200]:=",ExpressionUUID->"e15e0a96-4327-4c91-bd72-4d3cf79d2757"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], Thickness[0.006], Opacity[1.], FaceForm[Opacity[0.3]], 
      LineBox[CompressedData["
1:eJwV1Wc81n8fBfALISUjZWZd9t7rL74/EkrIiCJc9uZCyJZk75nskhWyV+hD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       "]]},
     Annotation[#, "Charting`Private`Tag$90763#1"]& ]}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], 
      PointBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQDQYcpx0mfv5n37X04IGXCX/nzzQ57lAV8ue+4IJD
Bzbd+rPf59FhB/H5TAk72A8f0Nb/Od8gep/DPkMWBnPVQwf2KP24/0t9O1he
7ceBA/clmBpWr9joAKKzM/YfaFvNrLBOcJkDyFx2h10HzkwXT+g3nueQz8N4
YKvNtgOfZr6Z735sKtj+U7qbD6QeYV3w8XCPg8tddgXW3vUHVJmu2nPcaXAA
maPnuOKAYXxcg+2uUrD94XMWHwh2uPW/ITQP7N7AwgUH3uScsDc2TnQwK/+y
/8zFGQfCHRbOs1MOcwhylm6wfTX5wGXRHOV53/wcwO6YP+HAp4qougc1jg6B
hufuq/zsOPDecoOM4nozB7A7/jYfWBF+yujIRH2Hue5H//9d2XBgXcpxN4V7
4g72axfZb2EqObBDrvV14A82B0+BdQ2H1mYd6NmZzflT4Yv99GCmJKHf8Qci
jkrPdK97Zq8bP/2h/ZvgAz2tikW/qh7bN6jrxoQd9T/wo/vmpFDBO/YFbPX7
Z3x2OSArr3tO4tlN+5VL/ByEP9odOPk482fj6pv2k2IzJVduNj5w/1+MSYrN
bfs8k4btDou0D5zLCX/RnHrXvnGqc3eOusoB3z3MNpkP79sHzbbYeX+h7AEA
t2XutQ==
       "]]}, {}}, {}, {}, {}, {}}},
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Re[Z]\"", TraditionalForm], 
    FormBox["\"Im[Z]\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->Automatic,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"ScalingFunctions" -> None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.90738273604191*^9, 3.9073827743231926`*^9}, 
   3.907382807962884*^9, {3.9073828612128553`*^9, 3.9073828847753983`*^9}, 
   3.907382965462862*^9, {3.907383774170967*^9, 3.9073837861709623`*^9}, 
   3.9073838293897495`*^9, 3.9073839932405224`*^9, {3.907384029256144*^9, 
   3.9073840573186417`*^9}, 3.9073849051883993`*^9, 3.9073849779227724`*^9, 
   3.9073851130369596`*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"c4e98a48-bc52-4ef4-a9fa-1cd63054df77"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Z", "[", "40000", "]"}], "/.", 
  RowBox[{"min", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Abs", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.9073832974665284`*^9, 3.907383363705408*^9}, {
  3.9073834954397864`*^9, 3.907383499580386*^9}},
 CellLabel->
  "In[203]:=",ExpressionUUID->"0bfe031a-46c9-4a89-ab20-09681c3e69a3"],

Cell[BoxData[
 RowBox[{"0.012510871490129999`", "\[VeryThinSpace]", "-", 
  RowBox[{"15.590281147518239`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.9073833116071854`*^9, 3.907383364236623*^9}, 
   3.9073835003459973`*^9, {3.907383774342834*^9, 3.9073837862179174`*^9}, 
   3.9073838294366055`*^9, 3.9073839932560964`*^9, 3.907384029334221*^9, 
   3.907384905235306*^9, 3.9073849779696693`*^9, 3.907385113068248*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"25cb0446-fea5-4c9c-bec3-e7523c7bbd67"],

Cell[BoxData["15.590286167372556`"], "Output",
 CellChangeTimes->{{3.9073833116071854`*^9, 3.907383364236623*^9}, 
   3.9073835003459973`*^9, {3.907383774342834*^9, 3.9073837862179174`*^9}, 
   3.9073838294366055`*^9, 3.9073839932560964`*^9, 3.907384029334221*^9, 
   3.907384905235306*^9, 3.9073849779696693`*^9, 3.9073851130838475`*^9},
 CellLabel->
  "Out[204]=",ExpressionUUID->"3020914e-6dc7-4760-bebe-8a2102ad9af9"]
}, Open  ]]
},
WindowSize->{1068, 641},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>2. Inherited,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 481, 12, 161, "Input",ExpressionUUID->"c1754577-7b23-450e-91b5-9be5e68cd5db"],
Cell[1042, 34, 626, 15, 161, "Input",ExpressionUUID->"d4d8943b-3cf7-4582-8230-99862e2ddb58"],
Cell[CellGroupData[{
Cell[1693, 53, 2871, 83, 515, "Input",ExpressionUUID->"a68d359c-ad4e-4584-98db-abe11c5a37a1"],
Cell[4567, 138, 676, 15, 95, "Output",ExpressionUUID->"f806d961-1737-4f20-922a-3d5b600905b7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5280, 158, 1840, 50, 372, "Input",ExpressionUUID->"e15e0a96-4327-4c91-bd72-4d3cf79d2757"],
Cell[7123, 210, 8523, 154, 519, "Output",ExpressionUUID->"c4e98a48-bc52-4ef4-a9fa-1cd63054df77"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15683, 369, 397, 9, 122, "Input",ExpressionUUID->"0bfe031a-46c9-4a89-ab20-09681c3e69a3"],
Cell[16083, 380, 516, 8, 90, "Output",ExpressionUUID->"25cb0446-fea5-4c9c-bec3-e7523c7bbd67"],
Cell[16602, 390, 421, 6, 90, "Output",ExpressionUUID->"3020914e-6dc7-4760-bebe-8a2102ad9af9"]
}, Open  ]]
}
]
*)

