(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    122945,       2997]
NotebookOptionsPosition[    119322,       2937]
NotebookOutlinePosition[    119841,       2955]
CellTagsIndexPosition[    119798,       2952]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellLabel->
  "In[989]:=",ExpressionUUID->"e8d2086a-1ae0-42c9-83a8-db53ff58e176"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"v", " ", "souboru", " ", 
     RowBox[{"dataPID", ".", "csv"}], " ", "jsou", " ", "data", " ", "ve", 
     " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"cas", ",", 
       RowBox[{"vstupPIDregulatoru", "=", "in"}], ",", 
       RowBox[{"vystupPIDregulatoru", "=", "out"}]}], "}"}]}], ",", " ", 
    RowBox[{
     RowBox[{"predpokladame", " ", "out"}], "=", 
     RowBox[{
      RowBox[{"p", "*", 
       RowBox[{"in", "[", "t", "]"}]}], "+", 
      RowBox[{"d", "*", 
       RowBox[{
        RowBox[{"in", "'"}], "[", "t", "]"}]}], "+", 
      RowBox[{"i", "*", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", "t"], 
        RowBox[{
         RowBox[{"in", "[", "\[Tau]", "]"}], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "\[Tau]"}], ".", " ", "Najdete"}], " ", 
         "konstanty", " ", "p"}]}]}]}]}], ",", "i", ",", 
    RowBox[{"d", " ", "a", " ", "napiste", " ", 
     RowBox[{"(", "slovne", ")"}], " ", "jak", " ", "byste", " ", "overovali",
      " ", "svoji", " ", 
     RowBox[{"metodu", ".", " ", "Pokud"}], " ", "to", " ", "overeni", " ", 
     "naprogramujete"}], ",", " ", 
    RowBox[{"mate", " ", "bonusove", " ", "body"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"10.", "*", 
       RowBox[{"Sin", "[", "t", "]"}]}], "+", 
      RowBox[{"5", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", "t"}], "]"}]}], "+", 
      RowBox[{"3", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"5", "t"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i", "=", "7"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"int", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"f", "[", "t", "]"}]}], ",", 
          RowBox[{
           RowBox[{"int", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
        "int", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"iSlozka", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"i", "*", 
       RowBox[{"int", "[", "t", "]"}]}], "/.", "sol"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dSlozka", "[", "t_", "]"}], "=", 
     RowBox[{"d", "*", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pSlozka", "[", "t_", "]"}], "=", 
     RowBox[{"p", "*", 
      RowBox[{"f", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"dSlozka", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vystup", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"pSlozka", "[", "t", "]"}], "+", 
      RowBox[{"iSlozka", "[", "t", "]"}], "+", 
      RowBox[{"dSlozka", "[", "t", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"f", "[", "#", "]"}], ",", 
         RowBox[{"vystup", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataPID.csv\>\"", ",", "data"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.724320734265625*^9, 3.72432103215625*^9}, {
   3.724321083875*^9, 3.7243213455625*^9}, {3.724321385390625*^9, 
   3.724321564390625*^9}, {3.724321663765625*^9, 3.724321840953125*^9}, {
   3.72432187428125*^9, 3.72432190003125*^9}, {3.724321931390625*^9, 
   3.72432199065625*^9}, {3.7243220345625*^9, 3.72432210821875*^9}, {
   3.724322387859375*^9, 3.724322530484375*^9}, {3.7243225699375*^9, 
   3.7243226161875*^9}, {3.72432265234375*^9, 3.724322662265625*^9}, 
   3.724325867546875*^9, {3.7244821895733504`*^9, 3.724482191838975*^9}, {
   3.75542058921875*^9, 3.755420593828125*^9}},
 CellLabel->
  "In[992]:=",ExpressionUUID->"bc46d219-9522-4cdc-b90b-200478d78e96"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", "\"\<dataPID.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vystup", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "out"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vstup", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"data", "/.", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "in"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
   RowBox[{"vystup", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"casy", "=", 
   RowBox[{"data", "/.", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
     "t"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]t", "=", 
   RowBox[{
    RowBox[{"casy", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "-", 
    RowBox[{"casy", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodnotyIntegralu", "=", 
   RowBox[{
    RowBox[{"\[CapitalDelta]t", "*", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Accumulate", "[", 
        RowBox[{"data", "/.", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"t_", ",", "in_", ",", "out_"}], "}"}], "\[RuleDelayed]", 
          "in"}]}], "]"}], ",", "0"}], "]"}]}], "//", 
    RowBox[{
     RowBox[{"Drop", "[", 
      RowBox[{"#", ",", 
       RowBox[{"-", "1"}]}], "]"}], "&"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"intIntegral", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"casy", ",", "hodnotyIntegralu"}], "}"}], "\[Transpose]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"datproFit", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"vstup", "[", "#", "]"}], ",", 
       RowBox[{"intIntegral", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"vstup", "'"}], "[", "#", "]"}], ",", 
       RowBox[{"vystup", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Range", "[", 
     RowBox[{"tmin", ",", "tmax", ",", 
      FractionBox[
       RowBox[{"tmax", "-", "tmin"}], "100"]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Fit", "[", 
  RowBox[{"datproFit", ",", 
   RowBox[{"{", 
    RowBox[{"pp", ",", "ii", ",", "dd"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"pp", ",", "ii", ",", "dd"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.724320734265625*^9, 3.72432103215625*^9}, {
   3.724321083875*^9, 3.7243213455625*^9}, {3.724321385390625*^9, 
   3.724321564390625*^9}, {3.724321663765625*^9, 3.724321840953125*^9}, {
   3.72432187428125*^9, 3.72432190003125*^9}, {3.724321931390625*^9, 
   3.72432199065625*^9}, {3.7243220345625*^9, 3.72432210821875*^9}, {
   3.724322387859375*^9, 3.724322530484375*^9}, {3.7243225699375*^9, 
   3.7243226161875*^9}, {3.72432265234375*^9, 3.724322662265625*^9}, 
   3.724325867546875*^9, {3.7244821895733504`*^9, 3.724482191838975*^9}, {
   3.75542058921875*^9, 3.755420593828125*^9}},
 CellLabel->
  "In[1007]:=",ExpressionUUID->"9576479d-fba7-4f84-8e4c-a7357580bf84"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "V", " ", "souboru", " ", "\"\<dataDobeh.csv\>\"", " ", "jsou", " ", 
      "data", " ", "ve", " ", "tvaru", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"\[Omega]", "[", "t", "]"}]}], "}"}], " ", "soustroji", " ", 
      "motor"}], "-", 
     RowBox[{
      RowBox[{"ventilator", ".", " ", "Moment"}], " ", "ventilatoru", " ", 
      "je"}], " ", "-", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], "*", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[Omega]", "[", "t", "]"}], "2"], ".", " ", "Urcete"}], " ", 
      "moment", " ", "setrvacnosti", " ", "soustroji"}]}], ",", " ", 
    RowBox[{"konstantu", " ", "treni"}], ",", " ", 
    RowBox[{
    "na", " ", "jakou", " ", "uhlovou", " ", "rychlost", " ", "se", " ", 
     "soustroji", " ", "rozebehne", " ", "pri", " ", "hnacim", " ", "momentu",
      " ", "1", " ", "N", "*", "m", " ", "a", " ", "za", " ", "jakou", " ", 
     "dobu", " ", "dosahne", " ", "uhlova", " ", "rychlost", " ", "poloviny", 
     " ", "ustalene", " ", "hodnoty", " ", "pri", " ", "tomto", " ", 
     RowBox[{"momentu", ".", " ", "Popiste"}]}], ",", " ", 
    RowBox[{
    "jak", " ", "byste", " ", "overovali", " ", "presnost", " ", "sveho", " ",
      "algoritmu", " ", "pro", " ", "zasumela", " ", 
     RowBox[{"data", ".", " ", "Pokud"}], " ", "to", " ", "naprogramujete"}], 
    ",", " ", 
    RowBox[{"extra", " ", 
     RowBox[{"body", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"fyzikalni", " ", "model", " ", "je", " ", "tedy", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"J", "*", 
        RowBox[{
         RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "B"}], "*", 
         RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
        RowBox[{"kv", "*", 
         SuperscriptBox[
          RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}], ",", 
      RowBox[{
       RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "\[Omega]0"}]}], 
     "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "15", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"J", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", "0.012"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kv", "=", 
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]0", "=", 
     RowBox[{"0.45", "*", "314"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"2", "*", "60"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"J", "*", 
            RowBox[{
             RowBox[{"\[Omega]", "'"}], "[", "t", "]"}]}], "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "B"}], "*", 
             RowBox[{"\[Omega]", "[", "t", "]"}]}], "-", 
            RowBox[{"kv", "*", 
             SuperscriptBox[
              RowBox[{"\[Omega]", "[", "t", "]"}], "2"]}]}]}], ",", 
          RowBox[{
           RowBox[{"\[Omega]", "[", "0", "]"}], "\[Equal]", "\[Omega]0"}]}], 
         "}"}], ",", "\[Omega]", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"\[Omega]", "/.", "sol"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"\[Omega]", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"\[Omega]", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "100"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataDobeh.csv\>\"", ",", "data"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Import", "[", "\"\<dataDobeh.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"int\[Omega]", "=", 
     RowBox[{"Interpolation", "[", "data", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmin", ",", "tmax"}], "}"}], "=", 
     RowBox[{"int\[Omega]", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datproFit", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"int\[Omega]", "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"int\[Omega]", "'"}], "[", "#", "]"}], ",", 
         RowBox[{
          RowBox[{"-", "kv"}], "*", 
          SuperscriptBox[
           RowBox[{"int\[Omega]", "[", "#", "]"}], "2"]}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"fit", "=", 
    RowBox[{"Fit", "[", 
     RowBox[{"datproFit", ",", 
      RowBox[{"{", 
       RowBox[{"omega", ",", "deromega"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"omega", ",", "deromega"}], "}"}]}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"Bmer", "=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"fit", ",", "omega"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Jmer", "=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"fit", ",", "deromega"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Mrozbeh", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmaxRozbeh", "=", "200"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"\[Omega]r", "'"}], "[", "t", "]"}], "*", "Jmer"}], 
           "\[Equal]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "Bmer"}], "*", 
             RowBox[{"\[Omega]r", "[", "t", "]"}]}], "-", 
            RowBox[{"kv", "*", 
             SuperscriptBox[
              RowBox[{"\[Omega]r", "[", "t", "]"}], "2"]}], "+", 
            "Mrozbeh"}]}], ",", 
          RowBox[{
           RowBox[{"\[Omega]r", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
        ",", "\[Omega]r", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmaxRozbeh"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Omega]rr", "[", "t_", "]"}], ":=", " ", 
     RowBox[{
      RowBox[{"\[Omega]r", "[", "t", "]"}], "/.", "sol"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"\[Omega]rr", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmaxRozbeh"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], "\n", 
   RowBox[{
    RowBox[{"\[Omega]inf", "=", 
     RowBox[{"\[Omega]rr", "[", "tmaxRozbeh", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]Pul", "=", 
     RowBox[{"0.5", "\[Omega]inf"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tPul", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Omega]rr", "[", "t", "]"}], "\[Equal]", "\[Omega]Pul"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"0.01", "tmax"}]}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<J= \>\"", ",", "Jmer", ",", "\"\<  B= \>\"", ",", "Bmer", ",", 
     "\"\<  \[Omega]inf= \>\"", ",", "\[Omega]inf", ",", "\"\<  tPul= \>\"", 
     ",", "tPul"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.724322683546875*^9, {3.724322714953125*^9, 3.724323322953125*^9}, {
   3.724324213453125*^9, 3.724324228296875*^9}, {3.72432429309375*^9, 
   3.72432430578125*^9}, {3.724324360203125*^9, 3.724324361046875*^9}, {
   3.7243243940625*^9, 3.7243244180625*^9}, {3.724324932359375*^9, 
   3.72432563309375*^9}, 3.724325827984375*^9, {3.75542119128125*^9, 
   3.7554212354375*^9}, {3.8800793454751425`*^9, 3.8800793516924357`*^9}, {
   3.9090566043875027`*^9, 3.909056619196436*^9}, {3.90905758013688*^9, 
   3.909057587131912*^9}, {3.909057664275864*^9, 3.909057666194765*^9}, {
   3.909057726276097*^9, 3.909057732427556*^9}},
 CellLabel->
  "In[1028]:=",ExpressionUUID->"4a31d770-4912-4d25-906e-4369c4d52f17"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Mate", " ", "zadane", " ", "INV"}], ",", " ", "diskont", ",", 
    " ", 
    RowBox[{
     RowBox[{"zivotnost", " ", "a", " ", "rocni", " ", 
      RowBox[{"usporu", ".", " ", "Urcete"}], " ", "NPV"}], "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ",", " ", 
    RowBox[{"IRR", " ", "takove"}], ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       RowBox[{
        FractionBox["rocniUspora", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]], " ", "a", " ", 
        "nejak", " ", "se", " ", "popasujte", " ", "s", " ", "realnou", " ", 
        "dobou", " ", "navratnosti", " ", "definovanou", " ", "tak"}]}]}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "0"}], "==", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "Treal"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "3", "body"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"INV", "=", 
     RowBox[{"50.5", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diskont", "=", "3.4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rocniUspora", "=", 
     RowBox[{"4.1", "*", 
      SuperscriptBox["10", "6"]}]}], ";", 
    RowBox[{"zivotnost", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NPV", "=", 
     RowBox[{
      RowBox[{"-", "INV"}], "+", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", "1"}], "zivotnost"], 
       FractionBox["rocniUspora", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"IRR", "=", 
     RowBox[{"irr", "/.", 
      RowBox[{"Quiet", "@", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"0", "==", 
          RowBox[{
           RowBox[{"-", "INV"}], "+", 
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"i", "=", "1"}], "zivotnost"], 
            FractionBox["rocniUspora", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"0.01", "*", "irr"}]}], ")"}], "i"]]}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"irr", ",", "diskont"}], "}"}]}], "]"}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"datinv", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Reverse", "@", 
        RowBox[{"{", 
         RowBox[{"T", ",", 
          RowBox[{
           RowBox[{"-", "INV"}], "+", 
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"i", "=", "1"}], "T"], 
            FractionBox["rocniUspora", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"0.01", "*", "diskont"}]}], ")"}], "i"]]}]}]}], 
         "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "0", ",", "zivotnost"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Treal", "=", 
     RowBox[{
      RowBox[{"Interpolation", "[", 
       RowBox[{"datinv", ",", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "0", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<NPV= \>\"", ",", "NPV", ",", "\"\<  IRR= \>\"", ",", "IRR", ",", 
     "\"\<  Treal= \>\"", ",", "Treal"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7243269765625*^9, 3.724327253921875*^9}, {
   3.72432778575*^9, 3.72432797796875*^9}, {3.724328076125*^9, 
   3.724328231671875*^9}, {3.75542215925*^9, 3.75542216521875*^9}, 
   3.755422200484375*^9, {3.908854468591878*^9, 3.9088544706453066`*^9}, {
   3.909057756043004*^9, 3.909057809531373*^9}},
 CellLabel->
  "In[1064]:=",ExpressionUUID->"c646897c-67f3-451d-a2ba-c616490e7c90"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Dvema", " ", "vedenimi", " ", "o", " ", "R1"}], "=", 
    RowBox[{
     RowBox[{"10", "\[CapitalOmega]", " ", "a", " ", "R2"}], "=", 
     RowBox[{
      RowBox[{
      "15", "\[CapitalOmega]", " ", "se", " ", "z", " ", "DC", " ", "zdroje", 
       " ", "o", " ", "U"}], "=", 
      RowBox[{
      "750", "kV", " ", "ma", " ", "prenest", " ", "celkem", " ", "1000", " ", 
       RowBox[{"MW", ".", " ", "Urcete"}], " ", "minimalni", " ", "ztraty", 
       " ", "na", " ", "vedeni", " ", "a", " ", "vykony", " ", "a", " ", 
       "napeti", " ", "na", " ", "vystupu", " ", "vedeni"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"U", "=", 
     RowBox[{"750", "*", 
      SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R1", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R2", "=", "15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pcelk", "=", 
     RowBox[{"1000", "*", 
      SuperscriptBox["10", "6"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1", "=", 
     RowBox[{"U", "-", 
      RowBox[{"R1", "*", "i1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u2", "=", 
     RowBox[{"U", "-", 
      RowBox[{"R2", "*", "i2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P1", "=", 
     RowBox[{"u1", "*", "i1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P2", "=", 
     RowBox[{"u2", "*", "i2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"min", "=", 
    RowBox[{"FindMinimum", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"R1", "*", 
          SuperscriptBox["i1", "2"]}], "+", 
         RowBox[{"R2", "*", 
          SuperscriptBox["i2", "2"]}]}], ",", 
        RowBox[{"Pcelk", "\[Equal]", 
         RowBox[{"P1", "+", "P2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i1", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i2", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"min", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "Pcelk"], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "P2"}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"R1", "*", 
         SuperscriptBox["i1", "2"]}], ",", 
        RowBox[{"R2", "*", 
         SuperscriptBox["i2", "2"]}]}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u1", ",", "u2"}], "}"}], "/.", 
      RowBox[{"min", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "\n", 
   RowBox[{
    RowBox[{"lagrange", "=", 
     RowBox[{
      RowBox[{"R1", "*", 
       SuperscriptBox["i1", "2"]}], "+", 
      RowBox[{"R2", "*", 
       SuperscriptBox["i2", "2"]}], "+", 
      RowBox[{"\[Lambda]", "*", 
       RowBox[{"(", 
        RowBox[{"Pcelk", "-", 
         RowBox[{"(", 
          RowBox[{"P1", "+", "P2"}], ")"}]}], ")"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.", "\[Equal]", 
       RowBox[{"D", "[", 
        RowBox[{"lagrange", ",", "#"}], "]"}]}], "&"}], "/@", 
     RowBox[{"{", 
      RowBox[{"i1", ",", "i2", ",", "\[Lambda]"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol", "=", 
    RowBox[{"Quiet", "@", 
     RowBox[{
      RowBox[{"Solve", "[", "%", "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u1", ",", "u2"}], "}"}], "/.", "sol"}]}]}]], "Input",
 CellChangeTimes->{{3.7244875491983504`*^9, 3.7244879638546004`*^9}, {
  3.724488021870225*^9, 3.724488034838975*^9}, {3.909057842122707*^9, 
  3.9090578701468678`*^9}},
 CellLabel->
  "In[1088]:=",ExpressionUUID->"483eadca-57af-4265-b317-f33cbbe3ed91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"je", " ", "dana", " ", "DR", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
           MultilineFunction->None], 
          RowBox[{"(", "t", ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["y", "\[Prime]",
           MultilineFunction->None], 
          RowBox[{"(", "t", ")"}]}], "+", 
         RowBox[{"y", 
          RowBox[{"(", "t", ")"}]}]}], "\[LongEqual]", 
        FractionBox[
         RowBox[{"sin", "(", "t", ")"}], 
         RowBox[{
          SqrtBox[
           RowBox[{
            SuperscriptBox["t", 
             RowBox[{"3", "/", "2"}]], "+", "1"}]], "+", "1"}]]}], ",", 
       RowBox[{
        RowBox[{"y", 
         RowBox[{"(", "0", ")"}]}], "\[LongEqual]", "0"}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], 
         RowBox[{"(", "0", ")"}]}], "\[LongEqual]", "a"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{
     RowBox[{"sestrojte", " ", "graf", " ", "zavislosti", " ", "hodnoty", " ", 
      RowBox[{"y", "[", 
       RowBox[{"t", "=", "1"}], "]"}], " ", "na", " ", "hodnote", " ", "a", 
      " ", "pro", " ", "a"}], " ", "\[Element]", 
     RowBox[{"<", "0"}]}], ",", 
    RowBox[{"20", ">"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "najdete", " ", "hodnotu", " ", "a", " ", "pro", " ", "kterou", " ", 
     "plati", " ", 
     RowBox[{"y", "[", 
      RowBox[{"t", "=", "1"}], "]"}]}], "=", "2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rce", "[", "a_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"2", 
          RowBox[{
           RowBox[{"y", "'"}], "[", "t", "]"}]}], "+", 
         RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
        FractionBox[
         RowBox[{"Sin", "[", "t", "]"}], 
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{
            SuperscriptBox["t", 
             FractionBox["3", "2"]], "+", "1"}]]}]]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "a"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"amax", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sol", "[", "a_", "]"}], ":=", 
     RowBox[{
      RowBox[{"y", "[", "tmax", "]"}], "/.", 
      RowBox[{"NDSolve", "[", 
       RowBox[{
        RowBox[{"rce", "[", "a", "]"}], ",", "y", ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"sol", "[", "a", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "amax", ",", 
         RowBox[{"0.05", "amax"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"int", "=", 
     RowBox[{"Interpolation", "[", "data", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"int", "[", "a", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "amax"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{"Reverse", "/@", "data"}], "]"}], "[", "2", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9088546563802543`*^9, 3.908854657706787*^9}, {
  3.9088571150066404`*^9, 3.9088574382612906`*^9}, {3.908857867057598*^9, 
  3.9088580410945115`*^9}, {3.909057923002595*^9, 3.9090579293624516`*^9}},
 CellLabel->
  "In[1103]:=",ExpressionUUID->"81c11f87-c44e-49c4-8d1d-7cb370dd61b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"soubor", " ", 
     RowBox[{"matSoustavy", ".", "csv"}], " ", "obsahuje", " ", "rozsirenou", 
     " ", "matici", " ", "soustavy"}], ",", " ", 
    RowBox[{
    "posledni", " ", "sloupec", " ", "je", " ", "vektor", " ", "pravych", " ",
      "stran"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "soucet", " ", "prvku", " ", "vektoru", " ", "reseni", " ", 
    "a", " ", "cislo", " ", "podminenosti", " ", "soustavy", " ", "s", " ", 
    "vyuzitim", " ", "spektralni", " ", "normy", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"te", " ", "co", " ", "vyuziva", " ", "vlastni", " ", "cisla"}],
       ",", " ", 
      RowBox[{
      "v", " ", "prednaskach", " ", "se", " ", "jmenuje", " ", "matNorm3"}]}],
      ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "5", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "150"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"matSoustavy", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", 
        RowBox[{"i", "+", "j", "-", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<matSoustavy.csv\>\"", ",", "matSoustavy"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"matSoustavy", "=", 
     RowBox[{"Import", "[", "\"\<matSoustavy.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "matSoustavy", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"#", ",", "n"}], "]"}], "&"}], "/@", "matSoustavy"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Last", "/@", "matSoustavy"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{"LinearSolve", "[", 
       RowBox[{"A", ",", "b"}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"matNorm3", "[", "mat_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Max", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"N", "[", "#", "]"}], "]"}], "&"}], "@", 
         RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"cond", "[", 
      RowBox[{"mat_", ",", "matNorm_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"matNorm", "[", 
       RowBox[{"Inverse", "@", 
        RowBox[{"N", "@", "mat"}]}], "]"}], "*", 
      RowBox[{"matNorm", "[", 
       RowBox[{"N", "@", "mat"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"cond", "[", 
      RowBox[{"A", ",", "matNorm3"}], "]"}], ",", 
     RowBox[{"Total", "[", "sol", "]"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.9089464450392885`*^9, 3.9089465881776447`*^9}, {
  3.908946619420231*^9, 3.908946852261881*^9}, {3.908946944676132*^9, 
  3.9089469766023593`*^9}, {3.9089470068489785`*^9, 3.908947015893444*^9}, {
  3.9089470675129375`*^9, 3.9089473746255035`*^9}, {3.909058010242605*^9, 
  3.9090580185072002`*^9}},ExpressionUUID->"de45368c-3660-4671-a13b-\
c96c93ed6298"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "V", " ", "souboru", " ", "\"\<infoVykony.csv\>\"", " ", "jsou", " ", 
       "data", " ", "ve", " ", "tvaru", " ", 
       RowBox[{"{", 
        RowBox[{"T1", ",", "T2", ",", "P"}], "}"}], " ", "tak"}], ",", " ", 
      RowBox[{
       RowBox[{
       "ze", " ", "plati", " ", "ze", " ", "pro", " ", "T\[Epsilon]"}], "<", 
       "T1"}], ",", "T2"}], ")"}], " ", "odebirame", " ", "vykon", " ", "P", 
    " ", "v", " ", "kW"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<teplotyPulhodinove.csv\>\"", " ", "jsou", 
    " ", "prumerne", " ", "pulhodinove", " ", "teploty"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "odebranou", " ", "energii", " ", "za", " ", "dane", " ", 
    "obdobi"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"teploty", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Import", "[", "\"\<teplotyPulhodinove.csv\>\"", "]"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fPom", "[", "T_", "]"}], ":=", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", 
       FractionBox["1", 
        RowBox[{"T", "+", "30"}]]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"solab", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"fPom", "[", "13", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"fPom", "[", 
           RowBox[{"-", "20"}], "]"}], "\[Equal]", "8."}]}], "}"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"P", "[", "T_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"fPom", "[", "T", "]"}], "/.", "solab"}], ")"}], "/;", 
      RowBox[{"T", "\[LessEqual]", "13"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"P", "[", "T_", "]"}], ":=", 
     RowBox[{"0.", "/;", 
      RowBox[{"T", ">", "13"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"P", "[", "T", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", 
        RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"myR", ":=", 
     RowBox[{
      RowBox[{"0.1", "*", 
       RowBox[{"Round", "[", 
        RowBox[{"10", "#"}], "]"}]}], "&"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"infoVykony", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"i", "+", "1"}], ",", 
         RowBox[{"myR", "[", 
          RowBox[{"P", "[", 
           RowBox[{"i", "+", "0.5"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "30"}], ",", "50"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<infoVykony.csv\>\"", ",", "infoVykony"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"infoVykony", "=", 
     RowBox[{"Import", "[", "\"\<infoVykony.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pom", "=", 
     RowBox[{"infoVykony", "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"T1_", ",", "T2_", ",", "P_"}], "}"}], "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{"P", ",", 
         RowBox[{"T1", "\[LessEqual]", "T", "<", "T2"}]}], "}"}]}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vykon", "[", "T_", "]"}], "=", 
     RowBox[{"Piecewise", "[", "pom", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"vykon", "/@", "teploty"}], "]"}], "*", "1000", "*", 
    "1800"}]}]}]], "Input",
 CellChangeTimes->{{3.908947564480008*^9, 3.9089475966398764`*^9}, {
   3.9089479755509815`*^9, 3.908948032666154*^9}, 3.9089480814738755`*^9, {
   3.9089481660404124`*^9, 3.9089481724082704`*^9}, {3.9089482662031035`*^9, 
   3.908948374670975*^9}, {3.908948497971346*^9, 3.908948498171571*^9}, {
   3.9089488000731297`*^9, 3.9089488277314663`*^9}, {3.9089488783261323`*^9, 
   3.908948992028455*^9}, {3.908949520462782*^9, 3.9089495253467894`*^9}, {
   3.9089497272795324`*^9, 3.9089497352897186`*^9}, {3.9090581127144294`*^9, 
   3.9090581211466093`*^9}, {3.909122978344302*^9, 
   3.9091230257895875`*^9}},ExpressionUUID->"87c90be0-8f25-4bcf-93d0-\
4d5a97ab5d29"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<teplotyPulhodinove.csv\>\"", " ", "jsou", 
    " ", "prumerne", " ", "pulhodinove", " ", "teploty"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Urcete", " ", "poradi", " ", "dni", " ", "v", " ", "tydnu", 
    RowBox[{"(*", 
     RowBox[{
     "prvni", " ", "den", " ", "znamena", " ", "prvnich", " ", "48", " ", 
      "hodnot", " ", "pulhodinovych", " ", "teplot"}], "*)"}], " ", "podle", 
    " ", "vzajemne", " ", "korelovanosti", " ", "prumernych", " ", "dennich", 
    " ", "teplot"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"tedy", " ", "ve", " ", "Wolframu", " ", 
    RowBox[{"Correlation", "[", 
     RowBox[{
     "listPondelnichTeplot", ",", "listPondelnichTeplotOTydenPozdeji"}], 
     "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "16", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"teploty", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Import", "[", "\"\<teplotyPulhodinove.csv\>\"", "]"}], "]"}]}],
     ";"}], "\n", 
   RowBox[{
    RowBox[{"denniPrumery", "=", 
     RowBox[{"Mean", "/@", 
      RowBox[{"Partition", "[", 
       RowBox[{"teploty", ",", 
        RowBox[{"2", "*", "24"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"korelace", "[", "den_Integer", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"list1", ",", "list2", ",", "nMax"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"nMax", "=", 
         RowBox[{"Length", "[", "denniPrumery", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"list1", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"denniPrumery", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "den", "-", "1"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"nMax", "-", "13"}], ",", "7"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"list2", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"denniPrumery", "[", 
            RowBox[{"[", 
             RowBox[{"i", "+", "den", "-", "1", "+", "7"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"nMax", "-", "13"}], ",", "7"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Correlation", "[", 
         RowBox[{"list1", ",", "list2"}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"korelace", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
     RowBox[{"Range", "[", "7", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"SortBy", "[", 
    RowBox[{"%", ",", "Last"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.9090325763565145`*^9, 3.909033040715658*^9, 3.9090330851515837`*^9, {
   3.909033154608675*^9, 3.9090332197608433`*^9}, {3.9090332576753626`*^9, 
   3.909033281147024*^9}, {3.9090333755646515`*^9, 3.9090334309071836`*^9}, {
   3.909035086612809*^9, 3.909035232313428*^9}, {3.909035285135892*^9, 
   3.909035286919369*^9}, {3.909035404438876*^9, 3.9090354073475547`*^9}, {
   3.909035441806687*^9, 3.90903552455954*^9}, {3.90905827167447*^9, 
   3.9090582937386904`*^9}},ExpressionUUID->"703320fb-5fce-4c07-a28d-\
702c9e44c7ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "seriova", " ", "kombinace", " ", "civky", " ", "a", " ", "rezistoru", " ",
     "se", " ", "v", " ", "case", " ", "t0", " ", "pripoji", " ", "ke", " ", 
    "zdroji", " ", "napeti"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "pro", " ", "jaky", " ", "cas", " ", "pripnuti", " ", "vznikne", " ", 
     "nemensi", " ", "prechodny", " ", "dej"}], ",", " ", 
    RowBox[{
    "tedy", " ", "nejmensi", " ", "integral", " ", "z", " ", "kvadratu", " ", 
     "rozdilu", " ", "prubehu", " ", "a", " ", "ustaleneho", " ", 
     RowBox[{"probehu", "?", "\"\<\>"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", "T"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"uz", "[", "t_", "]"}], ":=", 
     RowBox[{"230.", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"iHUS", "=", 
     RowBox[{"Im", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "\[Omega]", "*", "t"}], "]"}], "*", 
       FractionBox[
        RowBox[{"230.", "*", 
         SqrtBox["2"]}], 
        RowBox[{
         RowBox[{"I", "*", "\[Omega]", "*", "L"}], "+", "R"}]]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"iHUS", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
       RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"iHUS", "\[Equal]", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0.005"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rce", "[", "t0_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "[", "t0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"R", "*", 
          RowBox[{"i", "[", "t", "]"}]}], "+", 
         RowBox[{"L", "*", 
          RowBox[{
           RowBox[{"i", "'"}], "[", "t", "]"}]}]}], "\[Equal]", 
        RowBox[{"uz", "[", "t", "]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ukaz", "[", "t0_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sol", ",", "pl"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{
            RowBox[{"rce", "[", "t0", "]"}], ",", "i", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pl", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"i", "[", "t", "]"}], "/.", "sol"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<t[s]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"Thickness", "[", "0.006", "]"}], ",", "Dashed"}], 
             "}"}]}], ",", 
           RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"pl1", ",", "pl"}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ukaz", "[", "tStart", "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.9090345307087774`*^9, {3.9090366500438833`*^9, 3.9090366615109835`*^9}, {
   3.909036717199144*^9, 3.909037414212799*^9}, 3.909037826815764*^9, {
   3.90905838615576*^9, 
   3.9090583922675285`*^9}},ExpressionUUID->"7b7b6dbc-f917-4bf9-89e2-\
3c8a1d910996"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "seriova", " ", "kombinace", " ", "kondenzatoru", " ", "a", " ", 
    "rezistoru", " ", "se", " ", "v", " ", "case", " ", "t0", " ", "pripoji", 
    " ", "ke", " ", "zdroji", " ", "napeti"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "pro", " ", "jaky", " ", "cas", " ", "pripnuti", " ", "vznikne", " ", 
     "nemensi", " ", "prechodny", " ", "dej"}], ",", " ", 
    RowBox[{
    "tedy", " ", "nejmensi", " ", "integral", " ", "z", " ", "kvadratu", " ", 
     "rozdilu", " ", "prubehu", " ", "a", " ", "ustaleneho", " ", 
     RowBox[{"probehu", "?", "\"\<\>"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"max", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"40", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"2", "T"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"uz", "[", "t_", "]"}], ":=", 
     RowBox[{"230.", "*", 
      SqrtBox["2"], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", "t"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"iHUS", "=", 
     RowBox[{"Im", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "\[Omega]", "*", "t"}], "]"}], "*", 
       FractionBox[
        RowBox[{"230.", "*", 
         SqrtBox["2"]}], 
        RowBox[{
         FractionBox["1", 
          RowBox[{"I", "*", "\[Omega]", "*", "c"}]], "+", "R"}]]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"iHUS", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<t[s]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Thickness", "[", "0.006", "]"}]}], "}"}]}], ",", 
       RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tStart", "=", 
     RowBox[{"t", "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"iHUS", "\[Equal]", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0.005"}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rce", "[", "t0_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "[", "t0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"R", "*", 
          RowBox[{"i", "[", "t", "]"}]}], "+", 
         RowBox[{"uc", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"uz", "[", "t", "]"}]}], ",", 
       RowBox[{
        RowBox[{"i", "[", "t", "]"}], "\[Equal]", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"uc", "'"}], "[", "t", "]"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ukaz", "[", "t0_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sol", ",", "pl"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{
          RowBox[{"NDSolve", "[", 
           RowBox[{
            RowBox[{"rce", "[", "t0", "]"}], ",", "i", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
            RowBox[{"StartingStepSize", "\[Rule]", 
             SuperscriptBox["10", 
              RowBox[{"-", "9"}]]}]}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"pl", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"i", "[", "t", "]"}], "/.", "sol"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "t0", ",", "tmax"}], "}"}], ",", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<t[s]\>\"", ",", "\"\<i[A]\>\""}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"Thickness", "[", "0.006", "]"}], ",", "Dashed"}], 
             "}"}]}], ",", 
           RowBox[{"GridLines", "\[Rule]", "Full"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"pl1", ",", "pl"}], "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ukaz", "[", "tStart", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.909037659561037*^9, 3.9090376777405305`*^9}, {
  3.909037736807881*^9, 3.909037786316409*^9}, {3.909037858114396*^9, 
  3.9090380128195114`*^9}, {3.9090380430047474`*^9, 3.9090380506597753`*^9}, {
  3.909058433692068*^9, 3.909058570196192*^9}},
 CellLabel->
  "In[1330]:=",ExpressionUUID->"53308f8b-4a74-4708-a710-ed44e752dd8e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"V", " ", "souboru", " ", "\"\<dataHarm.csv\>\""}], ",", " ", 
    RowBox[{"jsou", " ", "dvojice", " ", "ve", " ", "tvaru", " ", 
     RowBox[{"{", 
      RowBox[{"ti", ",", "ui"}], "}"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vite", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "f"}], "=", 
     RowBox[{
     "50", "Hz", " ", "a", " ", "ze", " ", "signal", " ", "ma", " ", 
      "nulovou", " ", "stredni", " ", "hodnotu", " ", "a", " ", "amlitudy", 
      " ", "harmonickych", " ", "vyssich"}]}], ",", " ", 
    RowBox[{"nez", " ", "40"}], ",", " ", 
    RowBox[{"jsou", " ", "nulove"}], ",", " ", 
    RowBox[{"signal", " ", "je", " ", "cisty"}], ",", " ", 
    RowBox[{"bez", " ", "sumu"}], ",", " ", 
    RowBox[{"netreba", " ", "filtrovat"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"najdete", " ", 
      RowBox[{"u", "[", "t", "]"}]}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "1"}], "40"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["b", "n"], "*", 
         RowBox[{"sin", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "+", 
        RowBox[{
         SubscriptBox["a", "n"], "*", 
         RowBox[{"cos", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}]}], ")"}]}]}], ",",
     " ", 
    RowBox[{"jde", " ", "to", " ", "vice", " ", "zpusoby"}], ",", " ", 
    RowBox[{
    "doporucuji", " ", "fitovani", " ", "obsahuhjici", " ", "vyrazy", " ", 
     RowBox[{"sin", "[", 
      RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}], " ", "a", " ", 
     RowBox[{"cos", "[", 
      RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "urcete", " ", "stredni", " ", "elektrolytickou", " ", "hodnotu", " ", "a",
     " ", "efektivni", " ", "hodnotu", " ", 
    RowBox[{"u", "[", "t", "]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"spoctete", " ", "hodnotu", " ", "ueff1"}], "=", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "*", 
     SqrtBox[
      RowBox[{
       RowBox[{
        FractionBox["1", "T"], "*", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"n", "=", "1"}], "40"], 
         SuperscriptBox[
          SubscriptBox["a", "n"], "2"]}]}], "+", 
       SuperscriptBox[
        SubscriptBox["b", "n"], "2"]}]]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"celkem", " ", "max", " ", "10", " ", "bodu"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nFci", "=", "40"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exp", "=", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"2.5", "T"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", "t_", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["10", 
          SuperscriptBox["n", "exp"]], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "+", 
        RowBox[{
         FractionBox["10", 
          RowBox[{
           SuperscriptBox["n", "exp"], "+", "1"}]], "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "40"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"abKvadrat", "[", "n_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["10", 
          SuperscriptBox["n", "exp"]], ")"}], "2"], ",", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["10", 
          RowBox[{
           SuperscriptBox["n", "exp"], "+", "1"}]], ")"}], "2"]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"u", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataHarm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"u", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0.", ",", "tmax", ",", 
         FractionBox["tmax", "500"]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataHarm.csv\>\"", ",", "dataHarm"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, 3.9097203923545876`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"91970e13-1993-44a1-90f7-f3931eee4302"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataHarm", "=", 
   RowBox[{"Import", "[", "\"\<dataHarm.csv\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}], ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "40"}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9097203923545876`*^9, 
   3.909720414213067*^9}, 3.90972048103197*^9, {3.9097205195131264`*^9, 
   3.909720531106614*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"9667beda-abc4-4c6f-85b8-911e3d0df9b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fit", "[", "t_", "]"}], "=", 
   RowBox[{"Fit", "[", 
    RowBox[{"dataHarm", ",", "fce", ",", "t"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9097203923545876`*^9, 
   3.909720414213067*^9}, {3.90972053569258*^9, 3.9097205534731493`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"f1faefe0-e3f3-46d8-8bc0-35fb6f73b6e1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"kk", "=", 
   SuperscriptBox["10", 
    RowBox[{"-", "5"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"abs", "[", "x_", "]"}], ":=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["kk", "2"]}]], "-", "kk"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", ".01"}], ",", ".01"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.909720668456092*^9, 3.909720749421417*^9}, 
   3.9097207950014467`*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"2f206b33-f2e9-48d1-babd-9777cb339a2f"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw11Wk41HsbB/DJyJIaIVuWLGEs5yCVJed/G6NspaGynKTGLruxj8GYX5RW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       "]]},
     Annotation[#, "Charting`Private`Tag$17262#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.01, 0.01}, {0., 0.00999000459183569}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.909720699968296*^9, 3.9097207503005533`*^9}, 
   3.909720795268938*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"b3a5bef7-aa02-4e80-a406-a5c4bdb15436"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"uStredni", "=", 
   RowBox[{
    FractionBox["1", "T"], 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"fit", "[", "t", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<ustredni= \>\"", ",", "uStredni", ",", "\"\< V\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9097203923545876`*^9, 
   3.909720405292992*^9}, {3.9097205599754143`*^9, 3.9097205638899145`*^9}, {
   3.9097207812056828`*^9, 3.9097208010810995`*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"59423cd6-9202-4b78-a4a0-9814f53da9b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ustredni= \"\>", "\[InvisibleSpace]", "7.719805960845277`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["ustredni= ", 7.719805960845277, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9097205723579407`*^9, 3.909720622996175*^9, {3.9097207824057136`*^9, 
   3.90972080672153*^9}},
 CellLabel->
  "During evaluation of \
In[54]:=",ExpressionUUID->"8902c704-019c-46de-b1a8-4b551a4c6d6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"uEfektivni", "=", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "T"], 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"fit", "[", "t", "]"}], "2"], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "T"}], "}"}]}], "]"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<uEfektivni= \>\"", ",", "uEfektivni", ",", "\"\< V\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9097203923545876`*^9, 
   3.909720405292992*^9}, {3.9097205599754143`*^9, 3.9097205638899145`*^9}, {
   3.909720597636948*^9, 3.909720611062224*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"c154faf4-d62f-4e07-9d6a-a79b3dd2d534"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uEfektivni= \"\>", "\[InvisibleSpace]", "8.887846780198155`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["uEfektivni= ", 8.887846780198155, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.90972061224823*^9, 3.9097206265450373`*^9}, 
   3.909720814023153*^9},
 CellLabel->
  "During evaluation of \
In[56]:=",ExpressionUUID->"62143534-1fd6-47b9-800a-80dc3d5c172a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"vydejCos", "[", "n_Integer", "]"}], ":=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"fit", "[", "t", "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"vydejSin", "[", "n_Integer", "]"}], ":=", 
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"fit", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"n", "*", "\[Omega]", "*", "t"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eff1", "=", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["2"]], 
      SqrtBox[
       RowBox[{"Total", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"vydejCos", "[", "#", "]"}], "2"], ",", 
             SuperscriptBox[
              RowBox[{"vydejSin", "[", "#", "]"}], "2"]}], "}"}], "&"}], "/@", 
          RowBox[{"Range", "[", "nFci", "]"}]}], "]"}], "]"}]]}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"eff2", "=", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["2"]], 
      SqrtBox[
       RowBox[{"Total", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"abKvadrat", "/@", 
          RowBox[{"Range", "[", "nFci", "]"}]}], "]"}], "]"}]]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<eff1= \>\"", ",", "eff1", ",", "\"\< V\>\""}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<eff1= \>\"", ",", "eff1", ",", "\"\< V\>\""}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9090533303515778`*^9, 3.9090534613006945`*^9}, {
   3.909053606221692*^9, 3.9090537879333687`*^9}, {3.909053829260681*^9, 
   3.909054079372291*^9}, 3.909058608377413*^9, {3.9097203923545876`*^9, 
   3.909720405292992*^9}, {3.9097205599754143`*^9, 3.9097205638899145`*^9}, {
   3.909720597636948*^9, 
   3.9097206088006506`*^9}},ExpressionUUID->"8b8fc0fa-93ca-4239-ad43-\
cc2b680eab86"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ustredni= \"\>", "\[InvisibleSpace]", "7.719805960845277`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["ustredni= ", 7.719805960845277, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9090586481146364`*^9},
 CellLabel->
  "During evaluation of \
In[1345]:=",ExpressionUUID->"3b589ba7-6ebd-4668-8300-cd6904cd3eeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uEfektivni= \"\>", "\[InvisibleSpace]", "8.887846780198155`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["uEfektivni= ", 8.887846780198155, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9090586482515574`*^9},
 CellLabel->
  "During evaluation of \
In[1345]:=",ExpressionUUID->"9fd6edba-9d57-4cb3-8c51-cc8d1f436080"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"eff1= \"\>", "\[InvisibleSpace]", "8.887846780197266`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["eff1= ", 8.887846780197266, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{3.909058648275544*^9},
 CellLabel->
  "During evaluation of \
In[1345]:=",ExpressionUUID->"c908c235-a3ab-4432-b8ae-bbfc29cfb211"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"eff1= \"\>", "\[InvisibleSpace]", "8.887846780197266`", 
   "\[InvisibleSpace]", "\<\" V\"\>"}],
  SequenceForm["eff1= ", 8.887846780197266, " V"],
  Editable->False]], "Print",
 CellChangeTimes->{3.909058648281542*^9},
 CellLabel->
  "During evaluation of \
In[1345]:=",ExpressionUUID->"f31f2077-13d5-46e0-a661-f97274158779"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "v", " ", "souboru", " ", "\"\<dataPrechodak.csv\>\"", " ", "jsou", " ", 
    "data", " ", "ve", " ", "tvaru", " ", 
    RowBox[{"{", 
     RowBox[{"ti", ",", "proudi"}], "}"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "najdete", " ", "proklad", " ", "proudu", " ", "ve", " ", "tvaru", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", 
       RowBox[{"Exp", "[", 
        FractionBox[
         RowBox[{"-", "t"}], "tau"], "]"}]}]}], ")"}], "*", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Omega]", "*", 
      RowBox[{"(", 
       RowBox[{"t", "+", "faze"}], ")"}]}], "]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"vite", ",", " ", 
    RowBox[{
     RowBox[{"ze", " ", "f"}], "=", 
     RowBox[{"50", "Hz"}]}], ",", " ", 
    RowBox[{
     RowBox[{"proud", " ", "prochazi", " ", "rezistorem", " ", "R"}], "=", 
     RowBox[{"1", "\[CapitalOmega]"}]}], ",", " ", 
    RowBox[{
    "urcete", " ", "celkove", " ", "teplo", " ", "na", " ", "rezistoru", " ", 
     "vznikle"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"najdete", " ", "teplo"}], ",", " ", 
    RowBox[{
    "ktere", " ", "by", " ", "vzniklo", " ", "bez", " ", "exponencialni", " ",
      "slozky"}], ",", " ", 
    RowBox[{
    "tedy", " ", "kdyby", " ", "byl", " ", "proud", " ", "a", " ", "a", " ", 
     "vy", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"\[Omega]", "*", 
       RowBox[{"(", 
        RowBox[{"t", "+", "faze"}], ")"}]}], "]"}], " ", "a", " ", 
     "vypoctete", " ", "o", " ", "kolik", " ", "je", " ", "teplo", " ", "s", 
     " ", "prechodakem", " ", "vetsi"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"doporucuji", " ", "err", " ", "a", " ", "NMinimize"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"celkem", " ", "10", " ", "bodu"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", "50."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "=", 
     FractionBox["1", "f"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Omega]", "=", 
     RowBox[{"2", "*", "Pi", "*", "f"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]", "=", 
     FractionBox["T", "0.8"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", "*", 
         RowBox[{"Exp", "[", 
          FractionBox[
           RowBox[{"-", "t"}], "\[Tau]"], "]"}]}]}], ")"}], "*", 
      FractionBox["10", 
       SqrtBox["2."]], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", 
        RowBox[{"(", 
         RowBox[{"t", "+", 
          FractionBox["T", "4.6"]}], ")"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tmax", "=", 
     RowBox[{"5.", "T"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"i", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataPrechodak", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"i", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Range", "[", 
       RowBox[{"0.", ",", "tmax", ",", 
        FractionBox["tmax", "500"]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"dataPrechodak", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"PointSize", "[", "0.015", "]"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<dataPrechodak.csv\>\"", ",", "dataPrechodak"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataHarm", "=", 
     RowBox[{"Import", "[", "\"\<dataPrechodak.csv\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"model", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Exp", "[", 
          FractionBox[
           RowBox[{"-", "t"}], "tau"], "]"}]}]}], ")"}], "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]", "*", 
        RowBox[{"(", 
         RowBox[{"t", "+", "faze"}], ")"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", 
     RowBox[{"Union", "@", 
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"model", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"E", "->", "0.32"}], ",", 
           RowBox[{"t", "->", "0.123"}]}], "}"}]}], ",", "_Symbol", ",", 
        "All"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"err", "[", 
      RowBox[{"{", 
       RowBox[{"t_", ",", "u_"}], "}"}], "]"}], ":=", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"u", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Exp", "[", 
              FractionBox[
               RowBox[{"-", "t"}], "tau"], "]"}]}]}], ")"}], "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Omega]", "*", 
            RowBox[{"(", 
             RowBox[{"t", "+", "faze"}], ")"}]}], "]"}]}], ")"}]}], ")"}], 
      "2"]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"totalError", "=", 
     RowBox[{"Total", "[", 
      RowBox[{"err", "/@", "dataHarm"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"min", "=", 
     RowBox[{
      RowBox[{"NMinimize", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"totalError", ",", 
          RowBox[{"a", ">", "0"}], ",", 
          RowBox[{"b", ">", "0"}], ",", 
          RowBox[{"0", "<", "faze", "<", 
           RowBox[{"0.3", "T"}]}], ",", 
          RowBox[{"0", "<", "tau", "<", 
           RowBox[{"3", "T"}]}]}], "}"}], ",", "params"}], "]"}], "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fit", "[", "t_", "]"}], "=", 
     RowBox[{"model", "/.", "min"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"pl1", ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"fit", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], "]"}], "\n", 
   RowBox[{
    RowBox[{"R", "=", "1."}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"teploPrechodak", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"R", "*", 
        SuperscriptBox[
         RowBox[{"fit", "[", "t", "]"}], "2"]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"bezPrechodaku", "[", "t_", "]"}], ":=", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Omega]", "*", 
         RowBox[{"(", 
          RowBox[{"t", "+", "faze"}], ")"}]}], "]"}]}], "/.", "min"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"teploBez", "=", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"R", "*", 
        SuperscriptBox[
         RowBox[{"bezPrechodaku", "[", "t", "]"}], "2"]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"teploPrechodak", ",", "teploBez"}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.9090541226357822`*^9, 3.909054131516713*^9}, {
   3.9090542290128546`*^9, 3.9090543641334524`*^9}, {3.9090543975492954`*^9, 
   3.9090547460767217`*^9}, {3.909054854956362*^9, 3.9090548649090605`*^9}, {
   3.9090549638938675`*^9, 3.90905512042113*^9}, {3.9090551652609153`*^9, 
   3.909055273245077*^9}, {3.9090553278699694`*^9, 3.9090553694281683`*^9}, {
   3.9090553995009623`*^9, 3.9090554474025865`*^9}, {3.9090555060040226`*^9, 
   3.9090555750605497`*^9}, {3.9090556135804873`*^9, 
   3.9090560981487417`*^9}, {3.9090562657181053`*^9, 3.909056319060609*^9}, 
   3.9091221951475186`*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"a8f393cd-656c-4a90-b0a2-9999bf6559a1"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0, 0], PointSize[0.015], AbsoluteThickness[1.6], 
     PointBox[CompressedData["
1:eJw1mXk4lF0YxilkKfu+jn0t+5LSc/pooVIoSSFZShuRFEooWhSyhuz7bhhL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      "]]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwUV3c41u8bNVKZ2Xu8Xntmb+7H+IZElJBKEiEUJUrIrkS2bLKy50vIeJAm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        "]]},
      Annotation[#, "Charting`Private`Tag$7563#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.1}, {-30.29895628630588, 41.73391333915361}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9090587300752435`*^9, {3.909122189068108*^9, 3.909122196814133*^9}},
 CellLabel->"Out[45]=",ExpressionUUID->"de6c9bd0-67d4-4b98-af3b-bc4b0cddeb92"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"17.1272280222866`", ",", "2.5000000190664964`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9090587300752435`*^9, {3.909122189068108*^9, 3.9091221968297696`*^9}},
 CellLabel->"Out[50]=",ExpressionUUID->"df18aecc-8a14-4338-8ed6-9182d8a64ae8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["T", "4.6"], "*", "\[Omega]"}]], "Input",
 CellChangeTimes->{{3.909122277357886*^9, 3.9091222817929797`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"174b95ae-a546-472c-a01e-f26685c19c81"],

Cell[BoxData["1.3659098493868669`"], "Output",
 CellChangeTimes->{3.9091222823429003`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"2d854f03-b46b-42da-93c7-aa84f90ac086"]
}, Open  ]]
},
WindowSize->{1330.5, 706.5},
WindowMargins->{{-31.5, Automatic}, {Automatic, 14.25}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>1.9 Inherited,
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"aaa2c3d0-35b8-4c96-8a9a-da839b6b4ee0"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 413, 11, 127, "Input",ExpressionUUID->"e8d2086a-1ae0-42c9-83a8-db53ff58e176"],
Cell[974, 33, 5101, 139, 748, "Input",ExpressionUUID->"bc46d219-9522-4cdc-b90b-200478d78e96"],
Cell[6078, 174, 3576, 101, 418, "Input",ExpressionUUID->"9576479d-fba7-4f84-8e4c-a7357580bf84"],
Cell[9657, 277, 9307, 249, 1409, "Input",ExpressionUUID->"4a31d770-4912-4d25-906e-4369c4d52f17"],
Cell[18967, 528, 4777, 136, 758, "Input",ExpressionUUID->"c646897c-67f3-451d-a2ba-c616490e7c90"],
Cell[23747, 666, 4219, 123, 749, "Input",ExpressionUUID->"483eadca-57af-4265-b317-f33cbbe3ed91"],
Cell[27969, 791, 4264, 125, 580, "Input",ExpressionUUID->"81c11f87-c44e-49c4-8d1d-7cb370dd61b2"],
Cell[32236, 918, 3928, 108, 669, "Input",ExpressionUUID->"de45368c-3660-4671-a13b-c96c93ed6298"],
Cell[36167, 1028, 4839, 133, 778, "Input",ExpressionUUID->"87c90be0-8f25-4bcf-93d0-4d5a97ab5d29"],
Cell[41009, 1163, 3828, 95, 633, "Input",ExpressionUUID->"703320fb-5fce-4c07-a28d-702c9e44c7ad"],
Cell[44840, 1260, 5137, 139, 1010, "Input",ExpressionUUID->"7b7b6dbc-f917-4bf9-89e2-3c8a1d910996"],
Cell[49980, 1401, 5535, 150, 1011, "Input",ExpressionUUID->"53308f8b-4a74-4708-a710-ed44e752dd8e"],
Cell[55518, 1553, 5596, 157, 968, "Input",ExpressionUUID->"91970e13-1993-44a1-90f7-f3931eee4302"],
Cell[61117, 1712, 980, 24, 90, "Input",ExpressionUUID->"9667beda-abc4-4c6f-85b8-911e3d0df9b4"],
Cell[62100, 1738, 546, 10, 53, "Input",ExpressionUUID->"f1faefe0-e3f3-46d8-8bc0-35fb6f73b6e1"],
Cell[CellGroupData[{
Cell[62671, 1752, 711, 22, 137, "Input",ExpressionUUID->"2f206b33-f2e9-48d1-babd-9777cb339a2f"],
Cell[63385, 1776, 4424, 92, 445, "Output",ExpressionUUID->"b3a5bef7-aa02-4e80-a406-a5c4bdb15436"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67846, 1873, 877, 20, 122, "Input",ExpressionUUID->"59423cd6-9202-4b78-a4a0-9814f53da9b1"],
Cell[68726, 1895, 459, 11, 41, "Print",ExpressionUUID->"8902c704-019c-46de-b1a8-4b551a4c6d6a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69222, 1911, 914, 22, 137, "Input",ExpressionUUID->"c154faf4-d62f-4e07-9d6a-a79b3dd2d534"],
Cell[70139, 1935, 436, 10, 41, "Print",ExpressionUUID->"62143534-1fd6-47b9-800a-80dc3d5c172a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70612, 1950, 2233, 64, 407, "Input",ExpressionUUID->"8b8fc0fa-93ca-4239-ad43-cc2b680eab86"],
Cell[CellGroupData[{
Cell[72870, 2018, 385, 9, 41, "Print",ExpressionUUID->"3b589ba7-6ebd-4668-8300-cd6904cd3eeb"],
Cell[73258, 2029, 389, 9, 41, "Print",ExpressionUUID->"9fd6edba-9d57-4cb3-8c51-cc8d1f436080"],
Cell[73650, 2040, 375, 9, 41, "Print",ExpressionUUID->"c908c235-a3ab-4432-b8ae-bbfc29cfb211"],
Cell[74028, 2051, 375, 9, 41, "Print",ExpressionUUID->"f31f2077-13d5-46e0-a661-f97274158779"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74452, 2066, 8695, 247, 1498, "Input",ExpressionUUID->"a8f393cd-656c-4a90-b0a2-9999bf6559a1"],
Cell[83150, 2315, 35437, 599, 437, "Output",ExpressionUUID->"de6c9bd0-67d4-4b98-af3b-bc4b0cddeb92"],
Cell[118590, 2916, 281, 5, 60, "Output",ExpressionUUID->"df18aecc-8a14-4338-8ed6-9182d8a64ae8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[118908, 2926, 226, 4, 83, "Input",ExpressionUUID->"174b95ae-a546-472c-a01e-f26685c19c81"],
Cell[119137, 2932, 169, 2, 60, "Output",ExpressionUUID->"2d854f03-b46b-42da-93c7-aa84f90ac086"]
}, Open  ]]
}
]
*)

