(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     36632,       1010]
NotebookOptionsPosition[     33723,        960]
NotebookOutlinePosition[     34204,        978]
CellTagsIndexPosition[     34161,        975]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$HistoryLength", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mf", "=", "MatrixForm"}], ";"}]}], "Input",
 CellChangeTimes->{{3.67350642246875*^9, 3.673506422875*^9}, {
  3.676092820640625*^9, 
  3.676092822828125*^9}},ExpressionUUID->"a0728aa4-f8eb-4a24-a91f-\
a96dae15df4c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"mat2", "[", "\[Epsilon]_", "]"}], ":=", 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"5", "+", "\[Epsilon]"}], "7", "6", "5"},
       {"7", "10", "8", "7"},
       {"6", "8", "10", "9"},
       {"5", "7", "9", "10"}
      }], ")"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.67609263334375*^9, 3.6760926529375*^9}, {
   3.676092730828125*^9, 3.67609274709375*^9}, 
   3.9054039411467237`*^9},ExpressionUUID->"449f7501-fbf7-486c-a6cc-\
208ecfe1a139"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"LinearSolve", "::", "\"\<luc\>\""}], ",", 
   RowBox[{"RowReduce", "::", "\"\<luc\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"mat2", "[", 
     FractionBox[
      RowBox[{"-", "1"}], 
      RowBox[{"68", "-", 
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]]}]], "]"}], "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xPresne", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solSol", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"A", ".", 
        RowBox[{"(", 
         RowBox[{"xvect", "=", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", "#"], "&"}], "/@", 
           RowBox[{"Range", "[", "n", "]"}]}]}], ")"}]}], "\[Equal]", "b"}], 
      "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"errVect1", "=", 
  RowBox[{
   RowBox[{"A", ".", "xPresne"}], "-", "b"}]}], "\[IndentingNewLine]", 
 RowBox[{"errVect2", "=", 
  RowBox[{
   RowBox[{"A", ".", 
    RowBox[{"(", 
     RowBox[{"xvect", "/.", "solSol"}], ")"}]}], "-", 
   "b"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6760977475*^9, 3.676098134625*^9}, {
  3.9054040710160246`*^9, 
  3.9054040897281685`*^9}},ExpressionUUID->"9a09cb9f-78c5-47ff-aeac-\
8f4f87b69842"],

Cell[BoxData[
 TemplateBox[{
  "LinearSolve","lslc",
   "\"Coefficient matrix and target vector(s) or matrix do not have the same \
dimensions.\"",2,10,1,29199509179131630851,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9054039637163134`*^9, 
  3.905404095044422*^9},ExpressionUUID->"628b20bb-b5a7-4d77-9e37-\
367ea47e67e3"],

Cell[BoxData[
 TemplateBox[{
  "Dot","dotsh",
   "\"Tensors \\!\\(\\*RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\
\\\"4.985294117647038`\\\", \\\",\\\", \\\"7.`\\\", \\\",\\\", \\\"6.`\\\", \
\\\",\\\", \\\"5.`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\
\\\"7.`\\\", \\\",\\\", \\\"10.`\\\", \\\",\\\", \\\"8.`\\\", \\\",\\\", \
\\\"7.`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
RowBox[{\\\"6.`\\\", \\\",\\\", \\\"8.`\\\", \\\",\\\", \\\"10.`\\\", \\\",\\\
\", \\\"9.`\\\"}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"5.`\
\\\", \\\",\\\", \\\"7.`\\\", \\\",\\\", \\\"9.`\\\", \\\",\\\", \
\\\"10.`\\\"}], \\\"}\\\"}]}], \\\"}\\\"}]\\) and \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{SubscriptBox[\\\"x\\\", \\\"1\\\"], \\\",\\\", \
SubscriptBox[\\\"x\\\", \\\"2\\\"], \\\",\\\", SubscriptBox[\\\"x\\\", \
\\\"3\\\"]}], \\\"}\\\"}]\\) have incompatible shapes.\"",2,11,2,
   29199509179131630851,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9054039637163134`*^9, 
  3.905404095129031*^9},ExpressionUUID->"316c7afc-39e1-4747-bacc-\
b2b1eca1fb4f"],

Cell[BoxData[
 TemplateBox[{
  "Part","partw",
   "\"Part \\!\\(\\*RowBox[{\\\"1\\\"}]\\) of \\!\\(\\*RowBox[{\\\"{\\\", \
\\\"}\\\"}]\\) does not exist.\"",2,11,3,29199509179131630851,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9054039637163134`*^9, 
  3.9054040952605257`*^9},ExpressionUUID->"9b76c1da-d6b6-4e67-a929-\
5d4b51a050c0"],

Cell[BoxData[
 TemplateBox[{
  "LinearSolve","lslc",
   "\"Coefficient matrix and target vector(s) or matrix do not have the same \
dimensions.\"",2,12,4,29199509179131630851,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9054039637163134`*^9, 
  3.905404095313896*^9},ExpressionUUID->"c82eddfc-7d4d-41aa-ac14-\
fd2b7fb6acce"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.809752104243929*^9, 3.9054039639637575`*^9, 
  3.9054040953607635`*^9},ExpressionUUID->"ac82e6a5-3e54-4e41-956e-\
4cb804c5cff2"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll","reps",
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \\\"}\\\"}], \
\\\"\[LeftDoubleBracket]\\\", \\\"1\\\", \\\"\[RightDoubleBracket]\\\"}], \
\\\"}\\\"}]\\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"",2,13,5,29199509179131630851,
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9054039637163134`*^9, 
  3.905404095392006*^9},ExpressionUUID->"8e2b4f59-4d71-4d54-96ad-\
cb427b211aeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["x", "3"]}], "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["x", "3"]}], "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.985294117647038`", ",", "7.`", ",", "6.`", ",", "5.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "10.`", ",", "8.`", ",", "7.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "8.`", ",", "10.`", ",", "9.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "7.`", ",", "9.`", ",", "10.`"}], "}"}]}], "}"}], 
     ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["x", "3"]}], "}"}], "/.", "\[VeryThinSpace]", 
       RowBox[{
        RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.809752104243929*^9, 3.9054039639637575`*^9, 
  3.9054040954453793`*^9},ExpressionUUID->"4e1c8423-c172-4414-b038-\
d95da0106493"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"prosta", " ", "iterace"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"k", "=", ".025"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{
      RowBox[{"k", "*", 
       RowBox[{"(", GridBox[{
          {"20", "3", "4"},
          {"3", "44", "5"},
          {"1", "2", "50"}
         }], ")"}]}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"k", "*", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"Norm", "/@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], 
         ")"}]}], ")"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.67609936765625*^9, 3.67609937503125*^9}, {
   3.6761003179375*^9, 3.676100349453125*^9}, {3.676101115875*^9, 
   3.676101202046875*^9}, {3.676269990734375*^9, 3.676270011984375*^9}, {
   3.67627087578125*^9, 3.676270967140625*^9}, {3.676271000078125*^9, 
   3.676271025171875*^9}, 3.676271086921875*^9, {3.676273503703125*^9, 
   3.67627350975*^9}},ExpressionUUID->"a57915d9-9159-4ddf-a0f5-1a3f82920772"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Jacobi", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", 
          RowBox[{"3", "+", "I"}], "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LinearSolve", "[", 
     RowBox[{"Aorig", ",", "borig"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "xi_", "]"}], ":=", 
     RowBox[{
      RowBox[{"Cmat", ".", "xi"}], "+", "b"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Norm", "/@", "%"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.676105032961247*^9, 3.676105075961247*^9}, {
   3.676105114054997*^9, 3.676105206804997*^9}, {3.676105245633122*^9, 
   3.676105245883122*^9}, {3.676105350539372*^9, 3.676105397804997*^9}, {
   3.676105497039372*^9, 3.676105542664372*^9}, 3.676269892203125*^9, {
   3.676270187109375*^9, 3.676270188421875*^9}, {3.676270266546875*^9, 
   3.676270275953125*^9}, {3.67627043290625*^9, 3.6762704591875*^9}, {
   3.67627069090625*^9, 3.67627069184375*^9}, {3.67627073290625*^9, 
   3.676270769328125*^9}, {3.676270799515625*^9, 3.67627080465625*^9}, {
   3.676270842046875*^9, 3.6762708435*^9}, {3.676271017640625*^9, 
   3.676271084125*^9}, 3.67627133303125*^9, {3.6762713951875*^9, 
   3.676271416734375*^9}},ExpressionUUID->"5b03e942-b6b3-43ba-a710-\
02b2f09233ea"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.676270323859375*^9, 3.676270328109375*^9}, 
   3.6762704955*^9},ExpressionUUID->"1d339204-719f-4a1f-99a1-47054b02bf9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Seidel", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aorig", "=", 
     RowBox[{
      RowBox[{"(", GridBox[{
         {"20", "3", "4"},
         {"3", "44", "5"},
         {"1", "2", "50"}
        }], ")"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"MatrixRank", "[", "Aorig", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"borig", "=", 
     RowBox[{"Range", "[", "n", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"borig", "[", 
         RowBox[{"[", "j", "]"}], "]"}], 
        RowBox[{"Aorig", "[", 
         RowBox[{"[", 
          RowBox[{"j", ",", "j"}], "]"}], "]"}]], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xPresne", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xStart", "=", 
     RowBox[{
      RowBox[{"0", "&"}], "/@", 
      RowBox[{"Range", "[", "n", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cmat", "=", 
     RowBox[{
      RowBox[{"IdentityMatrix", "[", "n", "]"}], "-", "A"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xiPlus1", "[", "x_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xn", ",", "xp"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"xn", "=", "x"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"xp", "=", 
            RowBox[{
             RowBox[{"Cmat", ".", "xn"}], "+", "b"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xn", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "=", 
            RowBox[{"xp", "[", 
             RowBox[{"[", "i", "]"}], "]"}]}]}], "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "xn"}]}], "\[IndentingNewLine]", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"res", "=", 
     RowBox[{"NestWhileList", "[", 
      RowBox[{"xiPlus1", ",", "xStart", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"#1", "-", "#2"}], "]"}], ">", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]]}], "&"}], ",", "2", ",", "100"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "-", "xPresne"}], ")"}], "&"}], "/@", "res"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Norm", "/@", "%"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.676271376046875*^9, 3.6762713814375*^9}, 
   3.676271424046875*^9, {3.676273062046875*^9, 3.6762730915*^9}, {
   3.676273151359375*^9, 3.67627315178125*^9}, {3.676273268609375*^9, 
   3.676273317328125*^9}, {3.67627336390625*^9, 3.676273495640625*^9}, 
   3.67739442165625*^9},ExpressionUUID->"cceaa29c-949f-481c-8650-\
d62ed28079e5"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 0.07599974697132941}, {2., 0.017916460000937523`}, {3., 
      0.0007091897729583686}, {4., 0.000018589452804575432`}, {5., 
      1.0586571109905757`*^-7}, {6., 
      4.566372830582151*^-9}}]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.921875, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{1., 6.}, {0, 0.07599974697132941}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8097521045290337`*^9, 
  3.9054039643179383`*^9},ExpressionUUID->"3867d323-7b4b-4efc-bee3-\
5972a3b51178"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "podivejme", " ", "se", " ", "pomoci", " ", "experimentalni", " ", 
    "matematiky", " ", "na", " ", "vlastni", " ", "cisla", " ", "matic"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mf", "=", "MatrixForm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SeedRandom", "[", "4", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aijMax", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rnm", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "aijMax"}], ",", "aijMax"}], "}"}], "]"}], "&"}], 
        "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "rnm"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "rnm"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"%", "//", "mf"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lambdas", ",", "vectors"}], "}"}], "=", 
     RowBox[{
      RowBox[{"Eigensystem", "[", "A", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Abs", "/@", "lambdas"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"vectors", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", "dejSouradniceVBaziEigenvectors", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eqns", ",", "lambdas", ",", "\[Lambda]"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"lambdas", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Lambda]", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", "rnm", "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"lambdas", "/.", 
         RowBox[{
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"Thread", "[", 
             RowBox[{
              RowBox[{"lambdas", ".", "vectors"}], "\[Equal]", "vect"}], 
             "]"}], ",", "lambdas"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"dejSouradniceVBaziEigenvectors", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.684507384390625*^9, 3.68450773*^9}, {
   3.68450779615625*^9, 3.684507854296875*^9}, {3.68450790325*^9, 
   3.6845079044375*^9}, {3.684508081984375*^9, 3.684508368984375*^9}, 
   3.684508414421875*^9, {3.6845084795625*^9, 3.68450851825*^9}, {
   3.68450857453125*^9, 3.684508605921875*^9}, {3.684508672890625*^9, 
   3.6845087789375*^9}, {3.68450897421875*^9, 3.684509153671875*^9}, {
   3.684509196234375*^9, 3.684509237*^9}, {3.684509268375*^9, 
   3.68450931365625*^9}, {3.68450934990625*^9, 3.68450942665625*^9}, {
   3.68450971296875*^9, 
   3.684509714515625*^9}},ExpressionUUID->"9b0960a1-890d-4137-950b-\
db5f1305a829"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.036979223999276`"}], "+", 
    RowBox[{"0.8082438377411559`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.036979223999276`"}], "-", 
    RowBox[{"0.8082438377411556`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"2.3071796616215448`", "\[VeryThinSpace]", "+", 
    RowBox[{"1.9915431685917802`*^-17", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8097521052309694`*^9, 
  3.9054039643960476`*^9},ExpressionUUID->"d8c40c7b-f498-4aec-a90e-\
1cbf10dec084"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vect", "=", 
   RowBox[{"{", 
    RowBox[{"0.256", ",", 
     RowBox[{"2", "-", "I"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"dejSouradniceVBaziEigenvectors", "[", "vect", "]"}], "[", 
     RowBox[{"[", "#", "]"}], "]"}], "*", 
    RowBox[{"vectors", "[", 
     RowBox[{"[", "#", "]"}], "]"}]}], "&"}], "/@", 
  RowBox[{"Range", "[", "rnm", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Chop", "/@", 
  RowBox[{"Plus", "@@", "%"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "-", "vect"}]}], "Input",
 CellChangeTimes->{{3.68450947375*^9, 3.684509501859375*^9}, {
  3.684509542625*^9, 
  3.684509641359375*^9}},ExpressionUUID->"b35751b4-21c4-41cc-8e7b-\
5ce54e5c3e0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.24676601695390593`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7428570279407504`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.9668617116740595`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7540840749362827`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.4658824366845648`"}], "+", 
      RowBox[{"2.2795458511932924`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.3283872172922857`"}], "-", 
      RowBox[{"1.450598569152314`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.8317576417504466`", "\[VeryThinSpace]", "-", 
      RowBox[{"2.176230104376008`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2.996984210226755`"}], "-", 
      RowBox[{"3.249834309773856`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.3376212003383801`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.7077415412115641`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.201380646575494`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.4221460294397259`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.4628666469113203`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.970288458580564`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8097521052465916`*^9, 
  3.9054039644338036`*^9},ExpressionUUID->"92ed6520-164d-4278-a1bf-\
07b2a6fbc8a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.25600000000000034`", ",", 
   RowBox[{"2.`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.9999999999999996`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "2.999999999999999`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8097521052465916`*^9, 
  3.905403964465046*^9},ExpressionUUID->"4d887cc7-f502-4e63-902a-\
1a2bf055d052"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.3306690738754696`*^-16", ",", 
   RowBox[{"0.`", "\[VeryThinSpace]", "+", 
    RowBox[{"4.440892098500626`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
   "8.881784197001252`*^-16"}], "}"}]], "Output",
 CellChangeTimes->{3.8097521052465916`*^9, 
  3.905403964480666*^9},ExpressionUUID->"5d0a22ea-6ac1-4db7-88be-\
bd04f55c2db9"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.6845118365*^9},ExpressionUUID->"72f5096d-b337-4ac5-8749-d164d23bf50e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Lambda]AbsMax", "=", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "/@", "lambdas"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ratio", "[", 
     RowBox[{"exp_Integer", ",", "vect_List"}], "]"}], ":=", 
    FractionBox[
     RowBox[{"Norm", "@", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"MatrixPower", "[", 
          RowBox[{"A", ",", "exp"}], "]"}], ".", "vect"}], "//", "N"}], 
       ")"}]}], 
     RowBox[{
      SuperscriptBox["\[Lambda]AbsMax", "exp"], "*", 
      RowBox[{"Norm", "[", "vect", "]"}]}]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"upravit", ",", " ", "opravit"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ratio", "[", 
  RowBox[{"17", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.684511345484375*^9, 3.684511406640625*^9}, {
  3.68451144090625*^9, 3.68451158309375*^9}, {3.684511613421875*^9, 
  3.684511637609375*^9}, {3.68451176071875*^9, 3.684511765421875*^9}, {
  3.684511799625*^9, 3.684511828953125*^9}, {3.68451190390625*^9, 
  3.68451192446875*^9}, {3.684570222828125*^9, 
  3.684570300265625*^9}},ExpressionUUID->"69c264ba-13fb-435d-a130-\
95c4a7c93a92"],

Cell[BoxData["0.4148325433112122`"], "Output",
 CellChangeTimes->{3.809752105315587*^9, 
  3.9054039645340424`*^9},ExpressionUUID->"679e78e9-a2dd-4ebe-8e3c-\
3e6a72bf72df"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"https", ":"}], "//", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"en", ".", "wikipedia", ".", "org"}], "/", "wiki"}], "/", 
     "Square_root"}], "_of", "_a", "_matrix"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.68457101390625*^9, 
  3.684571016109375*^9}},ExpressionUUID->"9e1225d0-b165-4331-ba8e-\
9ec9a4e1da09"]
},
WindowSize->{1033, 653},
WindowMargins->{{8, Automatic}, {Automatic, 4}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.6000001430511475`,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 582, 16, 136, "Input",ExpressionUUID->"a0728aa4-f8eb-4a24-a91f-a96dae15df4c"],
Cell[1143, 38, 541, 15, 192, "Input",ExpressionUUID->"449f7501-fbf7-486c-a6cc-208ecfe1a139"],
Cell[CellGroupData[{
Cell[1709, 57, 1706, 52, 329, "Input",ExpressionUUID->"9a09cb9f-78c5-47ff-aeac-8f4f87b69842"],
Cell[3418, 111, 351, 8, 37, "Message",ExpressionUUID->"628b20bb-b5a7-4d77-9e37-367ea47e67e3"],
Cell[3772, 121, 1118, 19, 70, "Message",ExpressionUUID->"316c7afc-39e1-4747-bacc-b2b1eca1fb4f"],
Cell[4893, 142, 363, 8, 37, "Message",ExpressionUUID->"9b76c1da-d6b6-4e67-a929-5d4b51a050c0"],
Cell[5259, 152, 351, 8, 37, "Message",ExpressionUUID->"c82eddfc-7d4d-41aa-ac14-fd2b7fb6acce"],
Cell[5613, 162, 3599, 99, 322, "Output",ExpressionUUID->"ac82e6a5-3e54-4e41-956e-4cb804c5cff2"],
Cell[9215, 263, 536, 11, 70, "Message",ExpressionUUID->"8e2b4f59-4d71-4d54-96ad-cb427b211aeb"],
Cell[9754, 276, 2777, 80, 202, "Output",ExpressionUUID->"4e1c8423-c172-4414-b038-d95da0106493"]
}, Open  ]],
Cell[12546, 359, 2542, 70, 472, "Input",ExpressionUUID->"a57915d9-9159-4ddf-a0f5-1a3f82920772"],
Cell[15091, 431, 3829, 108, 112, "Input",ExpressionUUID->"5b03e942-b6b3-43ba-a710-02b2f09233ea"],
Cell[18923, 541, 168, 2, 112, "Input",ExpressionUUID->"1d339204-719f-4a1f-99a1-47054b02bf9e"],
Cell[CellGroupData[{
Cell[19116, 547, 4012, 118, 112, "Input",ExpressionUUID->"cceaa29c-949f-481c-8650-d62ed28079e5"],
Cell[23131, 667, 1456, 39, 112, "Output",ExpressionUUID->"3867d323-7b4b-4efc-bee3-5972a3b51178"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24624, 711, 3443, 88, 112, "Input",ExpressionUUID->"9b0960a1-890d-4137-950b-db5f1305a829"],
Cell[28070, 801, 568, 14, 112, "Output",ExpressionUUID->"d8c40c7b-f498-4aec-a90e-1cbf10dec084"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28675, 820, 792, 22, 112, "Input",ExpressionUUID->"b35751b4-21c4-41cc-8e7b-5ce54e5c3e0b"],
Cell[29470, 844, 1481, 33, 112, "Output",ExpressionUUID->"92ed6520-164d-4278-a1bf-07b2a6fbc8a3"],
Cell[30954, 879, 365, 8, 112, "Output",ExpressionUUID->"4d887cc7-f502-4e63-902a-1a2bf055d052"],
Cell[31322, 889, 363, 8, 112, "Output",ExpressionUUID->"5d0a22ea-6ac1-4db7-88be-bd04f55c2db9"]
}, Open  ]],
Cell[31700, 900, 140, 2, 112, "Input",ExpressionUUID->"72f5096d-b337-4ac5-8749-d164d23bf50e"],
Cell[CellGroupData[{
Cell[31865, 906, 1285, 33, 112, "Input",ExpressionUUID->"69c264ba-13fb-435d-a130-95c4a7c93a92"],
Cell[33153, 941, 172, 3, 112, "Output",ExpressionUUID->"679e78e9-a2dd-4ebe-8e3c-3e6a72bf72df"]
}, Open  ]],
Cell[33340, 947, 379, 11, 112, "Input",ExpressionUUID->"9e1225d0-b165-4331-ba8e-9ec9a4e1da09"]
}
]
*)

