(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6315,        202]
NotebookOptionsPosition[      4433,        157]
NotebookOutlinePosition[      5481,        187]
CellTagsIndexPosition[      5402,        182]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"ConstrainedMin", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", " ", "y"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y"}], "<", "10"}], ",", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ">", "2"}], ",", 
      RowBox[{"x", ">", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9059951084002514`*^9, 3.9059951144534206`*^9}},
 CellTags->
  "LinearProgramming",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6"}], ",", 
     RowBox[{"y", "\[Rule]", "4"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.843699663883998*^9, 3.9059951159999275`*^9},
 CellTags->
  "LinearProgramming",ExpressionUUID->"1b9de45e-1fbe-4301-9e52-1451f130b0eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "1"}]},
      {"1", "0"}
     }], ")"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->
  "LinearProgramming",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.843699663906126*^9},
 CellTags->
  "LinearProgramming",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fce", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"x", "*", 
     SuperscriptBox["y", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"podminka", "=", 
   RowBox[{
    RowBox[{".02", "*", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"0.05", "*", 
     SuperscriptBox["x", "2"], "*", "y"}], "+", 
    SuperscriptBox["y", "2"], "-", "6"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.9059951244823422`*^9},ExpressionUUID->"629b8dd3-b7c2-4c18-b692-\
7d859c19d59f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lagrange", "=", 
   RowBox[{"fce", "+", 
    RowBox[{"\[Lambda]", "*", "podminka"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{
    RowBox[{"Quiet", "@", 
     RowBox[{"Solve", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"lagrange", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"lagrange", ",", "y"}], "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{"podminka", "\[Equal]", "0"}]}], "}"}], "]"}]}], "//", 
    "N"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9059951362139254`*^9, 
  3.9059951376047635`*^9}},ExpressionUUID->"75fbd09c-4932-4bb5-946d-\
97c94884b774"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "res"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Element]", "Reals"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7.288691475657752`", ",", 
     RowBox[{"-", "1.4684090963635708`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32.02312036492725`", ",", 
     RowBox[{"-", "23.092495748456827`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8436996641222625`*^9},ExpressionUUID->"81efd811-368e-429d-b6d2-\
c34855317e43"]
}, Open  ]]
},
WindowSize->{859, 646},
WindowMargins->{{-1489, Automatic}, {Automatic, 142}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
Magnification->1.25,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "LinearProgramming"->{
  Cell[580, 22, 615, 18, 35, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
   CellTags->"LinearProgramming"],
  Cell[1198, 42, 342, 9, 40, "Output",ExpressionUUID->"1b9de45e-1fbe-4301-9e52-1451f130b0eb",
   CellTags->"LinearProgramming"],
  Cell[1577, 56, 504, 18, 71, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
   CellTags->"LinearProgramming"],
  Cell[2084, 76, 205, 5, 40, "Output",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807",
   CellTags->"LinearProgramming"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"LinearProgramming", 4863, 170}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 615, 18, 35, "Input",ExpressionUUID->"c8af7cb0-830c-48ac-8f79-5224ef97b05f",
 CellTags->"LinearProgramming"],
Cell[1198, 42, 342, 9, 40, "Output",ExpressionUUID->"1b9de45e-1fbe-4301-9e52-1451f130b0eb",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1577, 56, 504, 18, 71, "Input",ExpressionUUID->"335d2ed4-ffb2-4736-bb12-f7652814675a",
 CellTags->"LinearProgramming"],
Cell[2084, 76, 205, 5, 40, "Output",ExpressionUUID->"ae528e67-c78b-4609-b9ff-4673f7a3d807",
 CellTags->"LinearProgramming"]
}, Open  ]],
Cell[2304, 84, 565, 18, 84, "Input",ExpressionUUID->"629b8dd3-b7c2-4c18-b692-7d859c19d59f"],
Cell[2872, 104, 762, 22, 117, "Input",ExpressionUUID->"75fbd09c-4932-4bb5-946d-97c94884b774"],
Cell[CellGroupData[{
Cell[3659, 130, 368, 11, 35, "Input",ExpressionUUID->"f98c4e70-1610-4df1-a563-702072e14242"],
Cell[4030, 143, 387, 11, 40, "Output",ExpressionUUID->"81efd811-368e-429d-b6d2-c34855317e43"]
}, Open  ]]
}
]
*)

